# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class Webhook(UniversalBaseModel):
    id: str
    url: str
    secret: str = pydantic.Field()
    """
    The secret used to verify the webhook signature.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The date and time the webhook was created in ISO 8601 format.
    """

    include_transcript: bool
    include_crm_matches: bool
    include_summary: bool
    include_action_items: bool

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
