import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [lambda](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslambda.html).
 *
 * @experimental
 */
export declare class Lambda extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to add permissions to the resource-based policy of a version of an AWS Lambda layer.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_AddLayerVersionPermission.html
     *
     * @experimental
     */
    toAddLayerVersionPermission(): this;
    /**
     * (experimental) Grants permission to give an AWS service or another account permission to use an AWS Lambda function.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPrincipal()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html
     *
     * @experimental
     */
    toAddPermission(): this;
    /**
     * (experimental) Grants permission to create an alias for a Lambda function version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_CreateAlias.html
     *
     * @experimental
     */
    toCreateAlias(): this;
    /**
     * (experimental) Grants permission to create an AWS Lambda code signing config.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_CreateCodeSigningConfig.html
     *
     * @experimental
     */
    toCreateCodeSigningConfig(): this;
    /**
     * (experimental) Grants permission to create a mapping between an event source and an AWS Lambda function.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFunctionArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_CreateEventSourceMapping.html
     *
     * @experimental
     */
    toCreateEventSourceMapping(): this;
    /**
     * (experimental) Grants permission to create an AWS Lambda function.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLayer()
     * - .ifVpcIds()
     * - .ifSubnetIds()
     * - .ifSecurityGroupIds()
     * - .ifCodeSigningConfigArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html
     *
     * @experimental
     */
    toCreateFunction(): this;
    /**
     * (experimental) Grants permission to delete an AWS Lambda function alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteAlias.html
     *
     * @experimental
     */
    toDeleteAlias(): this;
    /**
     * (experimental) Grants permission to delete an AWS Lambda code signing config.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteCodeSigningConfig.html
     *
     * @experimental
     */
    toDeleteCodeSigningConfig(): this;
    /**
     * (experimental) Grants permission to delete an AWS Lambda event source mapping.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFunctionArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteEventSourceMapping.html
     *
     * @experimental
     */
    toDeleteEventSourceMapping(): this;
    /**
     * (experimental) Grants permission to delete an AWS Lambda function.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteFunction.html
     *
     * @experimental
     */
    toDeleteFunction(): this;
    /**
     * (experimental) Grants permission to detach a code signing config from an AWS Lambda function.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteFunctionCodeSigningConfig.html
     *
     * @experimental
     */
    toDeleteFunctionCodeSigningConfig(): this;
    /**
     * (experimental) Grants permission to remove a concurrent execution limit from an AWS Lambda function.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteFunctionConcurrency.html
     *
     * @experimental
     */
    toDeleteFunctionConcurrency(): this;
    /**
     * (experimental) Grants permission to delete the configuration for asynchronous invocation for an AWS Lambda function, version, or alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteFunctionEventInvokeConfig.html
     *
     * @experimental
     */
    toDeleteFunctionEventInvokeConfig(): this;
    /**
     * (experimental) Grants permission to delete a version of an AWS Lambda layer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteLayerVersion.html
     *
     * @experimental
     */
    toDeleteLayerVersion(): this;
    /**
     * (experimental) Grants permission to delete the provisioned concurrency configuration for an AWS Lambda function.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_DeleteProvisionedConcurrencyConfig.html
     *
     * @experimental
     */
    toDeleteProvisionedConcurrencyConfig(): this;
    /**
     * (experimental) Grants permission to disable replication for a Lambda@Edge function.
     *
     * Access Level: Permissions management
     *
     * @experimental
     */
    toDisableReplication(): this;
    /**
     * (experimental) Grants permission to enable replication for a Lambda@Edge function.
     *
     * Access Level: Permissions management
     *
     * @experimental
     */
    toEnableReplication(): this;
    /**
     * (experimental) Grants permission to view details about an account's limits and usage in an AWS Region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetAccountSettings.html
     *
     * @experimental
     */
    toGetAccountSettings(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Lambda function alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetAlias.html
     *
     * @experimental
     */
    toGetAlias(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Lambda code signing config.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetCodeSigningConfig.html
     *
     * @experimental
     */
    toGetCodeSigningConfig(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Lambda event source mapping.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifFunctionArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetEventSourceMapping.html
     *
     * @experimental
     */
    toGetEventSourceMapping(): this;
    /**
     * (experimental) Grants permission to view details about an AWS Lambda function.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunction.html
     *
     * @experimental
     */
    toGetFunction(): this;
    /**
     * (experimental) Grants permission to view the code signing config arn attached to an AWS Lambda function.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionCodeSigningConfig.html
     *
     * @experimental
     */
    toGetFunctionCodeSigningConfig(): this;
    /**
     * (experimental) Grants permission to view details about the reserved concurrency configuration for a function.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConcurrency.html
     *
     * @experimental
     */
    toGetFunctionConcurrency(): this;
    /**
     * (experimental) Grants permission to view details about the version-specific settings of an AWS Lambda function or version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html
     *
     * @experimental
     */
    toGetFunctionConfiguration(): this;
    /**
     * (experimental) Grants permission to view the configuration for asynchronous invocation for a function, version, or alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionEventInvokeConfig.html
     *
     * @experimental
     */
    toGetFunctionEventInvokeConfig(): this;
    /**
     * (experimental) Grants permission to view details about a version of an AWS Lambda layer.
     *
     * Note this action also supports GetLayerVersionByArn API
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetLayerVersion.html
     *
     * @experimental
     */
    toGetLayerVersion(): this;
    /**
     * (experimental) Grants permission to view the resource-based policy for a version of an AWS Lambda layer.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetLayerVersionPolicy.html
     *
     * @experimental
     */
    toGetLayerVersionPolicy(): this;
    /**
     * (experimental) Grants permission to view the resource-based policy for an AWS Lambda function, version, or alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetPolicy.html
     *
     * @experimental
     */
    toGetPolicy(): this;
    /**
     * (experimental) Grants permission to view the provisioned concurrency configuration for an AWS Lambda function's alias or version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_GetProvisionedConcurrencyConfig.html
     *
     * @experimental
     */
    toGetProvisionedConcurrencyConfig(): this;
    /**
     * (experimental) (Deprecated) Grants permission to invoke a function asynchronously.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_InvokeAsync.html
     *
     * @experimental
     */
    toInvokeAsync(): this;
    /**
     * (experimental) Grants permission to invoke an AWS Lambda function.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html
     *
     * @experimental
     */
    toInvokeFunction(): this;
    /**
     * (experimental) Grants permission to retrieve a list of aliases for an AWS Lambda function.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListAliases.html
     *
     * @experimental
     */
    toListAliases(): this;
    /**
     * (experimental) Grants permission to retrieve a list of AWS Lambda code signing configs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListCodeSigningConfigs.html
     *
     * @experimental
     */
    toListCodeSigningConfigs(): this;
    /**
     * (experimental) Grants permission to retrieve a list of AWS Lambda event source mappings.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListEventSourceMappings.html
     *
     * @experimental
     */
    toListEventSourceMappings(): this;
    /**
     * (experimental) Grants permission to retrieve a list of configurations for asynchronous invocation for a function.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListFunctionEventInvokeConfigs.html
     *
     * @experimental
     */
    toListFunctionEventInvokeConfigs(): this;
    /**
     * (experimental) Grants permission to retrieve a list of AWS Lambda functions, with the version-specific configuration of each function.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListFunctions.html
     *
     * @experimental
     */
    toListFunctions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of AWS Lambda functions by the code signing config assigned.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListFunctionsByCodeSigningConfig.html
     *
     * @experimental
     */
    toListFunctionsByCodeSigningConfig(): this;
    /**
     * (experimental) Grants permission to retrieve a list of versions of an AWS Lambda layer.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListLayerVersions.html
     *
     * @experimental
     */
    toListLayerVersions(): this;
    /**
     * (experimental) Grants permission to retrieve a list of AWS Lambda layers, with details about the latest version of each layer.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListLayers.html
     *
     * @experimental
     */
    toListLayers(): this;
    /**
     * (experimental) Grants permission to retrieve a list of provisioned concurrency configurations for an AWS Lambda function.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListProvisionedConcurrencyConfigs.html
     *
     * @experimental
     */
    toListProvisionedConcurrencyConfigs(): this;
    /**
     * (experimental) Grants permission to retrieve a list of tags for an AWS Lambda function.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListTags.html
     *
     * @experimental
     */
    toListTags(): this;
    /**
     * (experimental) Grants permission to retrieve a list of versions for an AWS Lambda function.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_ListVersionsByFunction.html
     *
     * @experimental
     */
    toListVersionsByFunction(): this;
    /**
     * (experimental) Grants permission to create an AWS Lambda layer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PublishLayerVersion.html
     *
     * @experimental
     */
    toPublishLayerVersion(): this;
    /**
     * (experimental) Grants permission to create an AWS Lambda function version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PublishVersion.html
     *
     * @experimental
     */
    toPublishVersion(): this;
    /**
     * (experimental) Grants permission to attach a code signing config to an AWS Lambda function.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifCodeSigningConfigArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PutFunctionCodeSigningConfig.html
     *
     * @experimental
     */
    toPutFunctionCodeSigningConfig(): this;
    /**
     * (experimental) Grants permission to configure reserved concurrency for an AWS Lambda function.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PutFunctionConcurrency.html
     *
     * @experimental
     */
    toPutFunctionConcurrency(): this;
    /**
     * (experimental) Grants permission to configures options for asynchronous invocation on an AWS Lambda function, version, or alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PutFunctionEventInvokeConfig.html
     *
     * @experimental
     */
    toPutFunctionEventInvokeConfig(): this;
    /**
     * (experimental) Grants permission to configure provisioned concurrency for an AWS Lambda function's alias or version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_PutProvisionedConcurrencyConfig.html
     *
     * @experimental
     */
    toPutProvisionedConcurrencyConfig(): this;
    /**
     * (experimental) Grants permission to remove a statement from the permissions policy for a version of an AWS Lambda layer.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_RemoveLayerVersionPermission.html
     *
     * @experimental
     */
    toRemoveLayerVersionPermission(): this;
    /**
     * (experimental) Grants permission to revoke function-use permission from an AWS service or another account.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPrincipal()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_RemovePermission.html
     *
     * @experimental
     */
    toRemovePermission(): this;
    /**
     * (experimental) Grants permission to add tags to an AWS Lambda function.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_TagResources.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from an AWS Lambda function.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the configuration of an AWS Lambda function's alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateAlias.html
     *
     * @experimental
     */
    toUpdateAlias(): this;
    /**
     * (experimental) Grants permission to update an AWS Lambda code signing config.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateCodeSigningConfig.html
     *
     * @experimental
     */
    toUpdateCodeSigningConfig(): this;
    /**
     * (experimental) Grants permission to update the configuration of an AWS Lambda event source mapping.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFunctionArn()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateEventSourceMapping.html
     *
     * @experimental
     */
    toUpdateEventSourceMapping(): this;
    /**
     * (experimental) Grants permission to update the code of an AWS Lambda function.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunctionCode.html
     *
     * @experimental
     */
    toUpdateFunctionCode(): this;
    /**
     * (experimental) Grants permission to update the code signing config of an AWS Lambda function.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunctionCodeSigningConfig.html
     *
     * @experimental
     */
    toUpdateFunctionCodeSigningConfig(): this;
    /**
     * (experimental) Grants permission to modify the version-specific settings of an AWS Lambda function.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifLayer()
     * - .ifVpcIds()
     * - .ifSubnetIds()
     * - .ifSecurityGroupIds()
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunctionConfiguration.html
     *
     * @experimental
     */
    toUpdateFunctionConfiguration(): this;
    /**
     * (experimental) Grants permission to modify the configuration for asynchronous invocation for an AWS Lambda function, version, or alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunctionEventInvokeConfig.html
     *
     * @experimental
     */
    toUpdateFunctionEventInvokeConfig(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type code signing config to the statement.
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param codeSigningConfigId - Identifier for the codeSigningConfigId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onCodeSigningConfig(codeSigningConfigId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type eventSourceMapping to the statement.
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param uUID - Identifier for the uUID.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEventSourceMapping(uUID: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type function to the statement.
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param functionName - Identifier for the functionName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFunction(functionName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type function alias to the statement.
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param functionName - Identifier for the functionName.
     * @param alias - Identifier for the alias.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFunctionAlias(functionName: string, alias: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type function version to the statement.
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param functionName - Identifier for the functionName.
     * @param version - Identifier for the version.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFunctionVersion(functionName: string, version: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type layer to the statement.
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param layerName - Identifier for the layerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onLayer(layerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type layerVersion to the statement.
     *
     * https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html
     *
     * @param layerName - Identifier for the layerName.
     * @param layerVersion - Identifier for the layerVersion.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onLayerVersion(layerName: string, layerVersion: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the ARN of an AWS Lambda code signing config.
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toPutFunctionCodeSigningConfig()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifCodeSigningConfigArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of an AWS Lambda function.
     *
     * Applies to actions:
     * - .toCreateEventSourceMapping()
     * - .toDeleteEventSourceMapping()
     * - .toGetEventSourceMapping()
     * - .toUpdateEventSourceMapping()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifFunctionArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of an AWS Lambda layer.
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toUpdateFunctionConfiguration()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifLayer(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by restricting the AWS service or account that can invoke a function.
     *
     * Applies to actions:
     * - .toAddPermission()
     * - .toRemovePermission()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPrincipal(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of security groups configured for the AWS Lambda function.
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toUpdateFunctionConfiguration()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifSecurityGroupIds(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of subnets configured for the AWS Lambda function.
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toUpdateFunctionConfiguration()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifSubnetIds(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of the VPC configured for the AWS Lambda function.
     *
     * Applies to actions:
     * - .toCreateFunction()
     * - .toUpdateFunctionConfiguration()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVpcIds(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [lambda](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslambda.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
