# Deterministic to probabilistic forecasting: 
# Produces probabilistic forecasts from a collection of deterministic forecasts
# previously generated by the get_d2p_submodel_names of a given base model.
#
# Example usage:
#   python -m subseasonal_toolkit.models.d2p.batch_predict us_tmp2m_p1_1.5x1.5 34w -t std_paper_forecast -mn raw_ecmwf
#
# Positional args:
#   gt_id: e.g., us_tmp2m_p1_1.5x1.5 or us_precip_p3_1.5x1.5
#   horizon: 12w, 34w, or 56w
#
# Named args:
#   --target_dates (-t): target dates for batch prediction
#   --model_name (-mn): name of model with deterministic forecasts; (default: "raw_ecmwf")
#   --first_year (-fy): first year of climatological period; (default: 1981)
#   --last_year (-ly): last year of climatological period; (default: 2010)

import os
from subseasonal_toolkit.utils.notebook_util import call_notebook
from pkg_resources import resource_filename

model_name = "d2p"
call_notebook(
    resource_filename("subseasonal_toolkit",os.path.join("models",model_name,model_name+".ipynb")))
