# Copyright 2016 to 2021, Cisco Systems, Inc., all rights reserved.
"""Unit test cases for yscoverage.dataset module."""

import os
import unittest2 as unittest
from yangsuite.paths import set_base_path
from yscoverage.dataset import dataset_for_yangset


class TestYSYangDataset(unittest.TestCase):

    testdir = os.path.join(os.path.dirname(__file__), 'data')

    def setUp(self):
        set_base_path(self.testdir)
        self.maxDiff = None

    def test_yangset_dataset_basic(self):
        dataset = dataset_for_yangset('test', 'ocif-alpha', 'ietf-interfaces')

        self.assertEqual(['xpath', 'module'], dataset['header'])
        self.assertEqual([
            ['/interfaces', 'ietf-interfaces'],
            ['/interfaces/interface', 'ietf-interfaces'],
            ['/interfaces/interface/name', 'ietf-interfaces'],
            ['/interfaces/interface/description', 'ietf-interfaces'],
            ['/interfaces/interface/type', 'ietf-interfaces'],
            ['/interfaces/interface/enabled', 'ietf-interfaces'],
            ['/interfaces/interface/link-up-down-trap-enable',
             'ietf-interfaces'],
            ['/interfaces-state', 'ietf-interfaces'],
            ['/interfaces-state/interface', 'ietf-interfaces'],
            ['/interfaces-state/interface/name', 'ietf-interfaces'],
            ['/interfaces-state/interface/type', 'ietf-interfaces'],
            ['/interfaces-state/interface/admin-status', 'ietf-interfaces'],
            ['/interfaces-state/interface/oper-status', 'ietf-interfaces'],
            ['/interfaces-state/interface/last-change', 'ietf-interfaces'],
            ['/interfaces-state/interface/if-index', 'ietf-interfaces'],
            ['/interfaces-state/interface/phys-address', 'ietf-interfaces'],
            ['/interfaces-state/interface/higher-layer-if', 'ietf-interfaces'],
            ['/interfaces-state/interface/lower-layer-if', 'ietf-interfaces'],
            ['/interfaces-state/interface/speed', 'ietf-interfaces'],
            ['/interfaces-state/interface/statistics', 'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/discontinuity-time',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/in-octets',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/in-unicast-pkts',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/in-broadcast-pkts',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/in-multicast-pkts',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/in-discards',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/in-errors',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/in-unknown-protos',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/out-octets',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/out-unicast-pkts',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/out-broadcast-pkts',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/out-multicast-pkts',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/out-discards',
             'ietf-interfaces'],
            ['/interfaces-state/interface/statistics/out-errors',
             'ietf-interfaces'],
        ], dataset['data'])

    def test_yangset_dataset_addons(self):
        dataset = dataset_for_yangset('test', 'ocif-alpha', 'ietf-interfaces',
                                      ['nodetype', 'datatype'])

        self.assertEqual(['xpath', 'module', 'nodetype', 'datatype'],
                         dataset['header'])
        self.assertEqual([
            ['/interfaces', 'ietf-interfaces', 'container', ''],
            ['/interfaces/interface', 'ietf-interfaces', 'list', ''],
            ['/interfaces/interface/name',
             'ietf-interfaces', 'leaf', 'string'],
            ['/interfaces/interface/description',
             'ietf-interfaces', 'leaf', 'string'],
            ['/interfaces/interface/type',
             'ietf-interfaces', 'leaf', 'identityref'],
            ['/interfaces/interface/enabled',
             'ietf-interfaces', 'leaf', 'boolean'],
            ['/interfaces/interface/link-up-down-trap-enable',
             'ietf-interfaces', 'leaf', 'enumeration'],
            ['/interfaces-state', 'ietf-interfaces', 'container', ''],
            ['/interfaces-state/interface', 'ietf-interfaces', 'list', ''],
            ['/interfaces-state/interface/name',
             'ietf-interfaces', 'leaf', 'string'],
            ['/interfaces-state/interface/type',
             'ietf-interfaces', 'leaf', 'identityref'],
            ['/interfaces-state/interface/admin-status',
             'ietf-interfaces', 'leaf', 'enumeration'],
            ['/interfaces-state/interface/oper-status',
             'ietf-interfaces', 'leaf', 'enumeration'],
            ['/interfaces-state/interface/last-change',
             'ietf-interfaces', 'leaf', 'yang:date-and-time'],
            ['/interfaces-state/interface/if-index',
             'ietf-interfaces',  'leaf', 'int32'],
            ['/interfaces-state/interface/phys-address',
             'ietf-interfaces', 'leaf', 'yang:phys-address'],
            ['/interfaces-state/interface/higher-layer-if',
             'ietf-interfaces',
             'leaf-list',
             'interface-state-ref'],
            ['/interfaces-state/interface/lower-layer-if',
             'ietf-interfaces',
             'leaf-list',
             'interface-state-ref'],
            ['/interfaces-state/interface/speed',
             'ietf-interfaces', 'leaf', 'yang:gauge64'],
            ['/interfaces-state/interface/statistics',
             'ietf-interfaces', 'container', ''],
            ['/interfaces-state/interface/statistics/discontinuity-time',
             'ietf-interfaces',
             'leaf',
             'yang:date-and-time'],
            ['/interfaces-state/interface/statistics/in-octets',
             'ietf-interfaces',
             'leaf',
             'yang:counter64'],
            ['/interfaces-state/interface/statistics/in-unicast-pkts',
             'ietf-interfaces',
             'leaf',
             'yang:counter64'],
            ['/interfaces-state/interface/statistics/in-broadcast-pkts',
             'ietf-interfaces',
             'leaf',
             'yang:counter64'],
            ['/interfaces-state/interface/statistics/in-multicast-pkts',
             'ietf-interfaces',
             'leaf',
             'yang:counter64'],
            ['/interfaces-state/interface/statistics/in-discards',
             'ietf-interfaces',
             'leaf',
             'yang:counter32'],
            ['/interfaces-state/interface/statistics/in-errors',
             'ietf-interfaces',
             'leaf',
             'yang:counter32'],
            ['/interfaces-state/interface/statistics/in-unknown-protos',
             'ietf-interfaces',
             'leaf',
             'yang:counter32'],
            ['/interfaces-state/interface/statistics/out-octets',
             'ietf-interfaces',
             'leaf',
             'yang:counter64'],
            ['/interfaces-state/interface/statistics/out-unicast-pkts',
             'ietf-interfaces',
             'leaf',
             'yang:counter64'],
            ['/interfaces-state/interface/statistics/out-broadcast-pkts',
             'ietf-interfaces',
             'leaf',
             'yang:counter64'],
            ['/interfaces-state/interface/statistics/out-multicast-pkts',
             'ietf-interfaces',
             'leaf',
             'yang:counter64'],
            ['/interfaces-state/interface/statistics/out-discards',
             'ietf-interfaces',
             'leaf',
             'yang:counter32'],
            ['/interfaces-state/interface/statistics/out-errors',
             'ietf-interfaces',
             'leaf',
             'yang:counter32']
        ], dataset['data'])
