# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.watchlist_aml_breakdown_legal_and_regulatory_warnings import WatchlistAmlBreakdownLegalAndRegulatoryWarnings
from onfido.models.watchlist_aml_breakdown_politically_exposed_person import WatchlistAmlBreakdownPoliticallyExposedPerson
from onfido.models.watchlist_aml_breakdown_sanction import WatchlistAmlBreakdownSanction
from typing import Optional, Set
from typing_extensions import Self

class WatchlistStandardBreakdown(BaseModel):
    """
    WatchlistStandardBreakdown
    """ # noqa: E501
    sanction: Optional[WatchlistAmlBreakdownSanction] = None
    politically_exposed_person: Optional[WatchlistAmlBreakdownPoliticallyExposedPerson] = None
    legal_and_regulatory_warnings: Optional[WatchlistAmlBreakdownLegalAndRegulatoryWarnings] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["sanction", "politically_exposed_person", "legal_and_regulatory_warnings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WatchlistStandardBreakdown from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of sanction
        if self.sanction:
            _dict['sanction'] = self.sanction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of politically_exposed_person
        if self.politically_exposed_person:
            _dict['politically_exposed_person'] = self.politically_exposed_person.to_dict()
        # override the default output from pydantic by calling `to_dict()` of legal_and_regulatory_warnings
        if self.legal_and_regulatory_warnings:
            _dict['legal_and_regulatory_warnings'] = self.legal_and_regulatory_warnings.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WatchlistStandardBreakdown from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sanction": WatchlistAmlBreakdownSanction.from_dict(obj["sanction"]) if obj.get("sanction") is not None else None,
            "politically_exposed_person": WatchlistAmlBreakdownPoliticallyExposedPerson.from_dict(obj["politically_exposed_person"]) if obj.get("politically_exposed_person") is not None else None,
            "legal_and_regulatory_warnings": WatchlistAmlBreakdownLegalAndRegulatoryWarnings.from_dict(obj["legal_and_regulatory_warnings"]) if obj.get("legal_and_regulatory_warnings") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


