/*! For license information please see index.js.LICENSE.txt */
define(["module","@jupyter-widgets/base"],((t,e)=>(()=>{var n={747:(t,e,n)=>{var i=n(325),r=new URL(i.uri,document.location);r.pathname=r.pathname.slice(0,r.pathname.lastIndexOf("/")+1),n.p=`${r.origin}${r.pathname}`},580:(t,e,n)=>{var i=n(146),r=n(486),s=n(232);!function(){const t={type:"change"},e={type:"start"},n={type:"end"};class i extends s.EventDispatcher{constructor(i,r){super(),void 0===r&&console.warn('THREE.OrbitControls: The second parameter "domElement" is now mandatory.'),r===document&&console.error('THREE.OrbitControls: "document" should not be used as the target "domElement". Please use "renderer.domElement" instead.'),this.object=i,this.domElement=r,this.domElement.style.touchAction="none",this.enabled=!0,this.target=new s.Vector3,this.minDistance=0,this.maxDistance=1/0,this.minZoom=0,this.maxZoom=1/0,this.minPolarAngle=0,this.maxPolarAngle=Math.PI,this.minAzimuthAngle=-1/0,this.maxAzimuthAngle=1/0,this.enableDamping=!1,this.dampingFactor=.05,this.enableZoom=!0,this.zoomSpeed=1,this.enableRotate=!0,this.rotateSpeed=1,this.enablePan=!0,this.panSpeed=1,this.screenSpacePanning=!0,this.keyPanSpeed=7,this.autoRotate=!1,this.autoRotateSpeed=2,this.keys={LEFT:"ArrowLeft",UP:"ArrowUp",RIGHT:"ArrowRight",BOTTOM:"ArrowDown"},this.mouseButtons={LEFT:s.MOUSE.ROTATE,MIDDLE:s.MOUSE.DOLLY,RIGHT:s.MOUSE.PAN},this.touches={ONE:s.TOUCH.ROTATE,TWO:s.TOUCH.DOLLY_PAN},this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.zoom0=this.object.zoom,this._domElementKeyEvents=null,this.getPolarAngle=function(){return u.phi},this.getAzimuthalAngle=function(){return u.theta},this.getDistance=function(){return this.object.position.distanceTo(this.target)},this.listenToKeyEvents=function(t){t.addEventListener("keydown",Y),this._domElementKeyEvents=t},this.saveState=function(){a.target0.copy(a.target),a.position0.copy(a.object.position),a.zoom0=a.object.zoom},this.reset=function(){a.target.copy(a.target0),a.object.position.copy(a.position0),a.object.zoom=a.zoom0,a.object.updateProjectionMatrix(),a.dispatchEvent(t),a.update(),l=o.NONE},this.update=function(){const e=new s.Vector3,n=(new s.Quaternion).setFromUnitVectors(i.up,new s.Vector3(0,1,0)),r=n.clone().invert(),m=new s.Vector3,g=new s.Quaternion,v=2*Math.PI;return function(){const i=a.object.position;e.copy(i).sub(a.target),e.applyQuaternion(n),u.setFromVector3(e),a.autoRotate&&l===o.NONE&&A(2*Math.PI/60/60*a.autoRotateSpeed),a.enableDamping?(u.theta+=h.theta*a.dampingFactor,u.phi+=h.phi*a.dampingFactor):(u.theta+=h.theta,u.phi+=h.phi);let s=a.minAzimuthAngle,_=a.maxAzimuthAngle;return isFinite(s)&&isFinite(_)&&(s<-Math.PI?s+=v:s>Math.PI&&(s-=v),_<-Math.PI?_+=v:_>Math.PI&&(_-=v),u.theta=s<=_?Math.max(s,Math.min(_,u.theta)):u.theta>(s+_)/2?Math.max(s,u.theta):Math.min(_,u.theta)),u.phi=Math.max(a.minPolarAngle,Math.min(a.maxPolarAngle,u.phi)),u.makeSafe(),u.radius*=d,u.radius=Math.max(a.minDistance,Math.min(a.maxDistance,u.radius)),!0===a.enableDamping?a.target.addScaledVector(p,a.dampingFactor):a.target.add(p),e.setFromSpherical(u),e.applyQuaternion(r),i.copy(a.target).add(e),a.object.lookAt(a.target),!0===a.enableDamping?(h.theta*=1-a.dampingFactor,h.phi*=1-a.dampingFactor,p.multiplyScalar(1-a.dampingFactor)):(h.set(0,0,0),p.set(0,0,0)),d=1,!!(f||m.distanceToSquared(a.object.position)>c||8*(1-g.dot(a.object.quaternion))>c)&&(a.dispatchEvent(t),m.copy(a.object.position),g.copy(a.object.quaternion),f=!1,!0)}}(),this.dispose=function(){a.domElement.removeEventListener("contextmenu",q),a.domElement.removeEventListener("pointerdown",V),a.domElement.removeEventListener("pointercancel",j),a.domElement.removeEventListener("wheel",X),a.domElement.removeEventListener("pointermove",H),a.domElement.removeEventListener("pointerup",W),null!==a._domElementKeyEvents&&a._domElementKeyEvents.removeEventListener("keydown",Y)};const a=this,o={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_PAN:4,TOUCH_DOLLY_PAN:5,TOUCH_DOLLY_ROTATE:6};let l=o.NONE;const c=1e-6,u=new s.Spherical,h=new s.Spherical;let d=1;const p=new s.Vector3;let f=!1;const m=new s.Vector2,g=new s.Vector2,v=new s.Vector2,_=new s.Vector2,y=new s.Vector2,x=new s.Vector2,b=new s.Vector2,M=new s.Vector2,w=new s.Vector2,S=[],E={};function T(){return Math.pow(.95,a.zoomSpeed)}function A(t){h.theta-=t}function R(t){h.phi-=t}const C=function(){const t=new s.Vector3;return function(e,n){t.setFromMatrixColumn(n,0),t.multiplyScalar(-e),p.add(t)}}(),L=function(){const t=new s.Vector3;return function(e,n){!0===a.screenSpacePanning?t.setFromMatrixColumn(n,1):(t.setFromMatrixColumn(n,0),t.crossVectors(a.object.up,t)),t.multiplyScalar(e),p.add(t)}}(),P=function(){const t=new s.Vector3;return function(e,n){const i=a.domElement;if(a.object.isPerspectiveCamera){const r=a.object.position;t.copy(r).sub(a.target);let s=t.length();s*=Math.tan(a.object.fov/2*Math.PI/180),C(2*e*s/i.clientHeight,a.object.matrix),L(2*n*s/i.clientHeight,a.object.matrix)}else a.object.isOrthographicCamera?(C(e*(a.object.right-a.object.left)/a.object.zoom/i.clientWidth,a.object.matrix),L(n*(a.object.top-a.object.bottom)/a.object.zoom/i.clientHeight,a.object.matrix)):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled."),a.enablePan=!1)}}();function I(t){a.object.isPerspectiveCamera?d/=t:a.object.isOrthographicCamera?(a.object.zoom=Math.max(a.minZoom,Math.min(a.maxZoom,a.object.zoom*t)),a.object.updateProjectionMatrix(),f=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),a.enableZoom=!1)}function D(t){a.object.isPerspectiveCamera?d*=t:a.object.isOrthographicCamera?(a.object.zoom=Math.max(a.minZoom,Math.min(a.maxZoom,a.object.zoom/t)),a.object.updateProjectionMatrix(),f=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),a.enableZoom=!1)}function O(t){m.set(t.clientX,t.clientY)}function N(t){_.set(t.clientX,t.clientY)}function U(){if(1===S.length)m.set(S[0].pageX,S[0].pageY);else{const t=.5*(S[0].pageX+S[1].pageX),e=.5*(S[0].pageY+S[1].pageY);m.set(t,e)}}function F(){if(1===S.length)_.set(S[0].pageX,S[0].pageY);else{const t=.5*(S[0].pageX+S[1].pageX),e=.5*(S[0].pageY+S[1].pageY);_.set(t,e)}}function B(){const t=S[0].pageX-S[1].pageX,e=S[0].pageY-S[1].pageY,n=Math.sqrt(t*t+e*e);b.set(0,n)}function z(t){if(1==S.length)g.set(t.pageX,t.pageY);else{const e=K(t),n=.5*(t.pageX+e.x),i=.5*(t.pageY+e.y);g.set(n,i)}v.subVectors(g,m).multiplyScalar(a.rotateSpeed);const e=a.domElement;A(2*Math.PI*v.x/e.clientHeight),R(2*Math.PI*v.y/e.clientHeight),m.copy(g)}function k(t){if(1===S.length)y.set(t.pageX,t.pageY);else{const e=K(t),n=.5*(t.pageX+e.x),i=.5*(t.pageY+e.y);y.set(n,i)}x.subVectors(y,_).multiplyScalar(a.panSpeed),P(x.x,x.y),_.copy(y)}function G(t){const e=K(t),n=t.pageX-e.x,i=t.pageY-e.y,r=Math.sqrt(n*n+i*i);M.set(0,r),w.set(0,Math.pow(M.y/b.y,a.zoomSpeed)),I(w.y),b.copy(M)}function V(t){!1!==a.enabled&&(0===S.length&&(a.domElement.setPointerCapture(t.pointerId),a.domElement.addEventListener("pointermove",H),a.domElement.addEventListener("pointerup",W)),function(t){S.push(t)}(t),"touch"===t.pointerType?function(t){switch(J(t),S.length){case 1:switch(a.touches.ONE){case s.TOUCH.ROTATE:if(!1===a.enableRotate)return;U(),l=o.TOUCH_ROTATE;break;case s.TOUCH.PAN:if(!1===a.enablePan)return;F(),l=o.TOUCH_PAN;break;default:l=o.NONE}break;case 2:switch(a.touches.TWO){case s.TOUCH.DOLLY_PAN:if(!1===a.enableZoom&&!1===a.enablePan)return;a.enableZoom&&B(),a.enablePan&&F(),l=o.TOUCH_DOLLY_PAN;break;case s.TOUCH.DOLLY_ROTATE:if(!1===a.enableZoom&&!1===a.enableRotate)return;a.enableZoom&&B(),a.enableRotate&&U(),l=o.TOUCH_DOLLY_ROTATE;break;default:l=o.NONE}break;default:l=o.NONE}l!==o.NONE&&a.dispatchEvent(e)}(t):function(t){let n;switch(t.button){case 0:n=a.mouseButtons.LEFT;break;case 1:n=a.mouseButtons.MIDDLE;break;case 2:n=a.mouseButtons.RIGHT;break;default:n=-1}switch(n){case s.MOUSE.DOLLY:if(!1===a.enableZoom)return;!function(t){b.set(t.clientX,t.clientY)}(t),l=o.DOLLY;break;case s.MOUSE.ROTATE:if(t.ctrlKey||t.metaKey||t.shiftKey){if(!1===a.enablePan)return;N(t),l=o.PAN}else{if(!1===a.enableRotate)return;O(t),l=o.ROTATE}break;case s.MOUSE.PAN:if(t.ctrlKey||t.metaKey||t.shiftKey){if(!1===a.enableRotate)return;O(t),l=o.ROTATE}else{if(!1===a.enablePan)return;N(t),l=o.PAN}break;default:l=o.NONE}l!==o.NONE&&a.dispatchEvent(e)}(t))}function H(t){!1!==a.enabled&&("touch"===t.pointerType?function(t){switch(J(t),l){case o.TOUCH_ROTATE:if(!1===a.enableRotate)return;z(t),a.update();break;case o.TOUCH_PAN:if(!1===a.enablePan)return;k(t),a.update();break;case o.TOUCH_DOLLY_PAN:if(!1===a.enableZoom&&!1===a.enablePan)return;!function(t){a.enableZoom&&G(t),a.enablePan&&k(t)}(t),a.update();break;case o.TOUCH_DOLLY_ROTATE:if(!1===a.enableZoom&&!1===a.enableRotate)return;!function(t){a.enableZoom&&G(t),a.enableRotate&&z(t)}(t),a.update();break;default:l=o.NONE}}(t):function(t){switch(l){case o.ROTATE:if(!1===a.enableRotate)return;!function(t){g.set(t.clientX,t.clientY),v.subVectors(g,m).multiplyScalar(a.rotateSpeed);const e=a.domElement;A(2*Math.PI*v.x/e.clientHeight),R(2*Math.PI*v.y/e.clientHeight),m.copy(g),a.update()}(t);break;case o.DOLLY:if(!1===a.enableZoom)return;!function(t){M.set(t.clientX,t.clientY),w.subVectors(M,b),w.y>0?I(T()):w.y<0&&D(T()),b.copy(M),a.update()}(t);break;case o.PAN:if(!1===a.enablePan)return;!function(t){y.set(t.clientX,t.clientY),x.subVectors(y,_).multiplyScalar(a.panSpeed),P(x.x,x.y),_.copy(y),a.update()}(t)}}(t))}function W(t){Z(t),0===S.length&&(a.domElement.releasePointerCapture(t.pointerId),a.domElement.removeEventListener("pointermove",H),a.domElement.removeEventListener("pointerup",W)),a.dispatchEvent(n),l=o.NONE}function j(t){Z(t)}function X(t){!1!==a.enabled&&!1!==a.enableZoom&&l===o.NONE&&(t.preventDefault(),a.dispatchEvent(e),function(t){t.deltaY<0?D(T()):t.deltaY>0&&I(T()),a.update()}(t),a.dispatchEvent(n))}function Y(t){!1!==a.enabled&&!1!==a.enablePan&&function(t){let e=!1;switch(t.code){case a.keys.UP:P(0,a.keyPanSpeed),e=!0;break;case a.keys.BOTTOM:P(0,-a.keyPanSpeed),e=!0;break;case a.keys.LEFT:P(a.keyPanSpeed,0),e=!0;break;case a.keys.RIGHT:P(-a.keyPanSpeed,0),e=!0}e&&(t.preventDefault(),a.update())}(t)}function q(t){!1!==a.enabled&&t.preventDefault()}function Z(t){delete E[t.pointerId];for(let e=0;e<S.length;e++)if(S[e].pointerId==t.pointerId)return void S.splice(e,1)}function J(t){let e=E[t.pointerId];void 0===e&&(e=new s.Vector2,E[t.pointerId]=e),e.set(t.pageX,t.pageY)}function K(t){const e=t.pointerId===S[0].pointerId?S[1]:S[0];return E[e.pointerId]}a.domElement.addEventListener("contextmenu",q),a.domElement.addEventListener("pointerdown",V),a.domElement.addEventListener("pointercancel",j),a.domElement.addEventListener("wheel",X,{passive:!1}),this.update()}}s.MapControls=class extends i{constructor(t,e){super(t,e),this.screenSpacePanning=!1,this.mouseButtons.LEFT=s.MOUSE.PAN,this.mouseButtons.RIGHT=s.MOUSE.ROTATE,this.touches.ONE=s.TOUCH.PAN,this.touches.TWO=s.TOUCH.DOLLY_ROTATE}},s.OrbitControls=i}();class a{static createButton(t,e){e&&console.error('THREE.VRButton: The "options" parameter has been removed. Please set the reference space type via renderer.xr.setReferenceSpaceType() instead.');const n=document.createElement("button");function i(){n.style.display="",n.style.cursor="auto",n.style.left="calc(50% - 75px)",n.style.width="150px",n.onmouseenter=null,n.onmouseleave=null,n.onclick=null}function r(t){t.style.position="absolute",t.style.bottom="10px",t.style.padding="6px 3px",t.style.border="1px solid #fff",t.style.borderRadius="1px",t.style.background="rgba(0,0,0,0.1)",t.style.color="#fff",t.style.font="normal 7px sans-serif",t.style.textAlign="center",t.style.opacity="0.5",t.style.outline="none",t.style.zIndex="999"}if("xr"in navigator)return n.id="VRButton",n.style.display="none",r(n),navigator.xr.isSessionSupported("immersive-vr").then((function(e){e?function(){let e=null;async function i(i){i.addEventListener("end",r),await t.xr.setSession(i),n.textContent="EXIT VR",e=i}function r(){e.removeEventListener("end",r),n.textContent="ENTER VR",e=null}n.style.display="",n.style.cursor="pointer",n.style.left="calc(50% - 50px)",n.style.width="100px",n.textContent="ENTER VR",n.onmouseenter=function(){n.style.opacity="1.0"},n.onmouseleave=function(){n.style.opacity="0.5"},n.onclick=function(){if(null===e){const t={optionalFeatures:["local-floor","bounded-floor","hand-tracking","layers"]};navigator.xr.requestSession("immersive-vr",t).then(i)}else e.end()}}():(i(),n.textContent="VR NOT SUPPORTED"),e&&a.xrSessionIsGranted&&n.click()})).catch((function(t){i(),console.warn("Exception when trying to call xr.isSessionSupported",t),n.textContent="VR NOT ALLOWED"})),n;{const t=document.createElement("a");return!1===window.isSecureContext?(t.href=document.location.href.replace(/^http:/,"https:"),t.innerHTML="WEBXR NEEDS HTTPS"):(t.href="https://immersiveweb.dev/",t.innerHTML="WEBXR NOT AVAILABLE"),t.style.left="calc(50% - 90px)",t.style.width="180px",t.style.textDecoration="none",r(t),t}}static xrSessionIsGranted=!1;static registerSessionGrantedListener(){if("xr"in navigator){if(/WebXRViewer\//i.test(navigator.userAgent))return;navigator.xr.addEventListener("sessiongranted",(()=>{a.xrSessionIsGranted=!0}))}}}a.registerSessionGrantedListener();var o=i.DOMWidgetModel.extend({defaults:r.extend(i.DOMWidgetModel.prototype.defaults(),{_model_name:"BraketModel",_view_name:"BraketView",_model_module:"evince",_view_module:"evince",_model_module_version:"0.30.0",_view_module_version:"0.30.0"})}),l=i.DOMWidgetView.extend({render:function(){console.log("Hello from BraketView 3.1");const t=new s.Scene;this.scene=t;let e=new s.PerspectiveCamera(75,window.innerWidth/window.innerHeight,.1,1e3);this.camera=e,e.position.z=5;const n=new s.WebGLRenderer;this.renderer=n,this.renderer.setSize(.9*document.activeElement.clientWidth,.9*document.activeElement.clientWidth*.6);const i=new s.Color(this.model.get("bg_color")[0],this.model.get("bg_color")[1],this.model.get("bg_color")[2]);this.renderer.setClearColor(i,1),this.renderer.antialias=!0,this.el.appendChild(a.createButton(this.renderer)),this.renderer.xr.enabled=!0,new s.OrbitControls(this.camera,this.renderer.domElement),this.init_changed(),this.el.append(this.renderer.domElement),this.ao_changed(),this.model.on("change:init",this.init_changed,this),this.model.on("change:ao",this.ao_changed,this),n.setAnimationLoop((function(){for(let e=0;e<t.children.length;e++)performance.now(),t.children[e].material.uniforms.time.value+=.01;n.render(t,e)}))},init_changed:function(){this.pos=this.model.get("pos"),this.masses=this.model.get("masses"),this.colors=this.model.get("colors")},pos_changed:function(){this.pos=this.model.get("pos");for(let t=0;t<this.pos.length;t++){let e=this.pos[t],n=this.scene.children[t];n.position.x=e[0],n.position.y=e[1],n.position.z=e[2]}},surf_changed:function(){this.surf=this.model.get("surf");for(let t=0;t<this.surf.length;t++){let t=new s.ShaderMaterial({uniforms:{time:{value:0},resolution:{value:new s.Vector2}},vertexShader:"uniform float time;\n            uniform vec2 resolution;\n            varying vec2 vUv;\n            varying vec3 pos;\n            varying vec3 tex;\n\n            void main() {\n                vUv = uv;\n                pos = vec3(position.x, position.y, position.z);\n                tex = vec3(position.x+time, position.y, position.z);\n                //pos = vec3(position.x + time * resolution.x, position.y + time * resolution.y, position.z);\n                gl_Position = projectionMatrix * modelViewMatrix * vec4( pos, 1.0 );\n            }",fragmentShader:"uniform vec3 user_color;\nuniform float time;\n\nvarying vec2 vUv;\nvarying vec3 pos;\nvarying vec3 tex;\nvarying float q;\n\nvoid main() {\n\nvec2 p = vUv;\nfloat q = tex[0]*tex[0] + tex[1]*tex[1] + tex[2]*tex[2];\n\n    gl_FragColor = gl_FragColor + .01*vec4(.5 + 1.7369481664870148*sqrt(15)*pow(3.141592653589793, -0.75)*tex[2]*(pow(tex[0], 2) - pow(tex[1], 2))*exp(-pow(tex[0], 2) - pow(tex[1], 2) - pow(tex[2], 2)), 0.2, 0.5, 0.5);\n}",side:s.DoubleSide,blending:s.SubtractiveBlending});t.depthWrite=!1;let e=new s.BufferGeometry;e.setIndex(this.surf[1]),e.setAttribute("position",new s.Float32BufferAttribute(this.surf[0],3)),new s.Mesh(e,t)}},ao_changed:function(){this.ao=this.model.get("ao"),this.surface_view=this.model.get("surface_view");var t=this.model.get("fragment_shader");if(this.surface_view){var e="uniform float time;\nuniform vec2 resolution;\nvarying vec2 vUv;\nvarying vec3 pos;\nvarying vec3 tex;\n\nvoid main() {\n\tvUv = uv;\n\tpos = vec3(position.x, position.y, position.z);\n\ttex = vec3(position.x, position.y, position.z);\n\t//pos = vec3(position.x + time * resolution.x, position.y + time * resolution.y, position.z);\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( pos, 1.0 );\n}";let n=new s.ShaderMaterial({uniforms:{time:{value:0},resolution:{value:new s.Vector2}},vertexShader:e,fragmentShader:t,side:s.DoubleSide,blending:s.SubtractiveBlending});n.depthWrite=!1,this.model.get("additive")&&(n.blending=s.AdditiveBlending);let i=new s.PlaneGeometry(1e4,1e4),r=new s.Mesh(i,n);r.position.x=0,r.position.y=0,r.position.z=0,this.scene.add(r)}else{e="uniform float time;\nuniform vec2 resolution;\nvarying vec2 vUv;\nvarying vec3 pos;\nvarying vec3 tex;\n\nvoid main() {\n\tvUv = uv;\n\tpos = vec3(position.x, position.y, position.z);\n\ttex = vec3(position.x, position.y, position.z);\n\t//pos = vec3(position.x + time * resolution.x, position.y + time * resolution.y, position.z);\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( pos, 1.0 );\n}";let n=new s.SphereBufferGeometry(.3),i=(new s.InstancedBufferGeometry).copy(n),r=120;i.maxInstancedCount=r;let a=[],o=[];for(let t=0;t<r;t++)o.push(0,0,0),a.push(.03*(t**1.1+.1),0,0);let l=new Float32Array(o);i.setAttribute("aCurve",new s.InstancedBufferAttribute(l,3,!1));let c=new Float32Array(a);i.setAttribute("aRadius",new s.InstancedBufferAttribute(c,3,!1)),this.instancedGeometry=i;let u=new s.ShaderMaterial({fragmentShader:t,vertexShader:"// Define the attributes\nvarying vec3 vColor;\nvarying vec3 tex;\nvarying vec2 vUv;\n\nattribute vec3 aRadius;\nattribute vec3 aCurve;\n\nvoid main(){\nvec3 transformed = position*aRadius.x*length(cameraPosition);\ntex = vec3(transformed.x, transformed.y, transformed.z) + cameraPosition;\n\n\n// 3. Get position and add it to the final position\n//vec3 curvePosition = vec3(aCurve.x, aCurve.y, aCurve.z);\n\n//transformed += curvePosition;\n\ngl_Position = projectionMatrix * modelViewMatrix * vec4(tex, 1.0);\n//vColor = aColor;\n//vPis = gl_position;\n}",uniforms:{time:{value:0},resolution:{value:new s.Vector2}},side:s.BackSide,blending:s.SubtractiveBlending});this.model.get("additive")&&(u.blending=s.AdditiveBlending),u.depthWrite=!1;let h=new s.InstancedMesh(i,u,r);h.instanceMatrix.needsUpdate=!0,this.scene.add(h)}}});t.exports={BraketModel:o,BraketView:l}},568:(t,e,n)=>{const i=n(580),r=n(258),s=n(597);t.exports={BraketModel:i.BraketModel,BraketView:i.BraketView,MDModel:r.MDModel,MDView:r.MDView,LatticeModel:s.LatticeModel,LatticeView:s.LatticeView},t.exports.version=n(147).version},597:(t,e,n)=>{var i=n(146),r=n(486),s=n(232);!function(){const t={type:"change"},e={type:"start"},n={type:"end"};class i extends s.EventDispatcher{constructor(i,r){super(),void 0===r&&console.warn('THREE.OrbitControls: The second parameter "domElement" is now mandatory.'),r===document&&console.error('THREE.OrbitControls: "document" should not be used as the target "domElement". Please use "renderer.domElement" instead.'),this.object=i,this.domElement=r,this.domElement.style.touchAction="none",this.enabled=!0,this.target=new s.Vector3,this.minDistance=0,this.maxDistance=1/0,this.minZoom=0,this.maxZoom=1/0,this.minPolarAngle=0,this.maxPolarAngle=Math.PI,this.minAzimuthAngle=-1/0,this.maxAzimuthAngle=1/0,this.enableDamping=!1,this.dampingFactor=.05,this.enableZoom=!0,this.zoomSpeed=1,this.enableRotate=!0,this.rotateSpeed=1,this.enablePan=!0,this.panSpeed=1,this.screenSpacePanning=!0,this.keyPanSpeed=7,this.autoRotate=!1,this.autoRotateSpeed=2,this.keys={LEFT:"ArrowLeft",UP:"ArrowUp",RIGHT:"ArrowRight",BOTTOM:"ArrowDown"},this.mouseButtons={LEFT:s.MOUSE.ROTATE,MIDDLE:s.MOUSE.DOLLY,RIGHT:s.MOUSE.PAN},this.touches={ONE:s.TOUCH.ROTATE,TWO:s.TOUCH.DOLLY_PAN},this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.zoom0=this.object.zoom,this._domElementKeyEvents=null,this.getPolarAngle=function(){return u.phi},this.getAzimuthalAngle=function(){return u.theta},this.getDistance=function(){return this.object.position.distanceTo(this.target)},this.listenToKeyEvents=function(t){t.addEventListener("keydown",Y),this._domElementKeyEvents=t},this.saveState=function(){a.target0.copy(a.target),a.position0.copy(a.object.position),a.zoom0=a.object.zoom},this.reset=function(){a.target.copy(a.target0),a.object.position.copy(a.position0),a.object.zoom=a.zoom0,a.object.updateProjectionMatrix(),a.dispatchEvent(t),a.update(),l=o.NONE},this.update=function(){const e=new s.Vector3,n=(new s.Quaternion).setFromUnitVectors(i.up,new s.Vector3(0,1,0)),r=n.clone().invert(),m=new s.Vector3,g=new s.Quaternion,v=2*Math.PI;return function(){const i=a.object.position;e.copy(i).sub(a.target),e.applyQuaternion(n),u.setFromVector3(e),a.autoRotate&&l===o.NONE&&A(2*Math.PI/60/60*a.autoRotateSpeed),a.enableDamping?(u.theta+=h.theta*a.dampingFactor,u.phi+=h.phi*a.dampingFactor):(u.theta+=h.theta,u.phi+=h.phi);let s=a.minAzimuthAngle,_=a.maxAzimuthAngle;return isFinite(s)&&isFinite(_)&&(s<-Math.PI?s+=v:s>Math.PI&&(s-=v),_<-Math.PI?_+=v:_>Math.PI&&(_-=v),u.theta=s<=_?Math.max(s,Math.min(_,u.theta)):u.theta>(s+_)/2?Math.max(s,u.theta):Math.min(_,u.theta)),u.phi=Math.max(a.minPolarAngle,Math.min(a.maxPolarAngle,u.phi)),u.makeSafe(),u.radius*=d,u.radius=Math.max(a.minDistance,Math.min(a.maxDistance,u.radius)),!0===a.enableDamping?a.target.addScaledVector(p,a.dampingFactor):a.target.add(p),e.setFromSpherical(u),e.applyQuaternion(r),i.copy(a.target).add(e),a.object.lookAt(a.target),!0===a.enableDamping?(h.theta*=1-a.dampingFactor,h.phi*=1-a.dampingFactor,p.multiplyScalar(1-a.dampingFactor)):(h.set(0,0,0),p.set(0,0,0)),d=1,!!(f||m.distanceToSquared(a.object.position)>c||8*(1-g.dot(a.object.quaternion))>c)&&(a.dispatchEvent(t),m.copy(a.object.position),g.copy(a.object.quaternion),f=!1,!0)}}(),this.dispose=function(){a.domElement.removeEventListener("contextmenu",q),a.domElement.removeEventListener("pointerdown",V),a.domElement.removeEventListener("pointercancel",j),a.domElement.removeEventListener("wheel",X),a.domElement.removeEventListener("pointermove",H),a.domElement.removeEventListener("pointerup",W),null!==a._domElementKeyEvents&&a._domElementKeyEvents.removeEventListener("keydown",Y)};const a=this,o={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_PAN:4,TOUCH_DOLLY_PAN:5,TOUCH_DOLLY_ROTATE:6};let l=o.NONE;const c=1e-6,u=new s.Spherical,h=new s.Spherical;let d=1;const p=new s.Vector3;let f=!1;const m=new s.Vector2,g=new s.Vector2,v=new s.Vector2,_=new s.Vector2,y=new s.Vector2,x=new s.Vector2,b=new s.Vector2,M=new s.Vector2,w=new s.Vector2,S=[],E={};function T(){return Math.pow(.95,a.zoomSpeed)}function A(t){h.theta-=t}function R(t){h.phi-=t}const C=function(){const t=new s.Vector3;return function(e,n){t.setFromMatrixColumn(n,0),t.multiplyScalar(-e),p.add(t)}}(),L=function(){const t=new s.Vector3;return function(e,n){!0===a.screenSpacePanning?t.setFromMatrixColumn(n,1):(t.setFromMatrixColumn(n,0),t.crossVectors(a.object.up,t)),t.multiplyScalar(e),p.add(t)}}(),P=function(){const t=new s.Vector3;return function(e,n){const i=a.domElement;if(a.object.isPerspectiveCamera){const r=a.object.position;t.copy(r).sub(a.target);let s=t.length();s*=Math.tan(a.object.fov/2*Math.PI/180),C(2*e*s/i.clientHeight,a.object.matrix),L(2*n*s/i.clientHeight,a.object.matrix)}else a.object.isOrthographicCamera?(C(e*(a.object.right-a.object.left)/a.object.zoom/i.clientWidth,a.object.matrix),L(n*(a.object.top-a.object.bottom)/a.object.zoom/i.clientHeight,a.object.matrix)):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled."),a.enablePan=!1)}}();function I(t){a.object.isPerspectiveCamera?d/=t:a.object.isOrthographicCamera?(a.object.zoom=Math.max(a.minZoom,Math.min(a.maxZoom,a.object.zoom*t)),a.object.updateProjectionMatrix(),f=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),a.enableZoom=!1)}function D(t){a.object.isPerspectiveCamera?d*=t:a.object.isOrthographicCamera?(a.object.zoom=Math.max(a.minZoom,Math.min(a.maxZoom,a.object.zoom/t)),a.object.updateProjectionMatrix(),f=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),a.enableZoom=!1)}function O(t){m.set(t.clientX,t.clientY)}function N(t){_.set(t.clientX,t.clientY)}function U(){if(1===S.length)m.set(S[0].pageX,S[0].pageY);else{const t=.5*(S[0].pageX+S[1].pageX),e=.5*(S[0].pageY+S[1].pageY);m.set(t,e)}}function F(){if(1===S.length)_.set(S[0].pageX,S[0].pageY);else{const t=.5*(S[0].pageX+S[1].pageX),e=.5*(S[0].pageY+S[1].pageY);_.set(t,e)}}function B(){const t=S[0].pageX-S[1].pageX,e=S[0].pageY-S[1].pageY,n=Math.sqrt(t*t+e*e);b.set(0,n)}function z(t){if(1==S.length)g.set(t.pageX,t.pageY);else{const e=K(t),n=.5*(t.pageX+e.x),i=.5*(t.pageY+e.y);g.set(n,i)}v.subVectors(g,m).multiplyScalar(a.rotateSpeed);const e=a.domElement;A(2*Math.PI*v.x/e.clientHeight),R(2*Math.PI*v.y/e.clientHeight),m.copy(g)}function k(t){if(1===S.length)y.set(t.pageX,t.pageY);else{const e=K(t),n=.5*(t.pageX+e.x),i=.5*(t.pageY+e.y);y.set(n,i)}x.subVectors(y,_).multiplyScalar(a.panSpeed),P(x.x,x.y),_.copy(y)}function G(t){const e=K(t),n=t.pageX-e.x,i=t.pageY-e.y,r=Math.sqrt(n*n+i*i);M.set(0,r),w.set(0,Math.pow(M.y/b.y,a.zoomSpeed)),I(w.y),b.copy(M)}function V(t){!1!==a.enabled&&(0===S.length&&(a.domElement.setPointerCapture(t.pointerId),a.domElement.addEventListener("pointermove",H),a.domElement.addEventListener("pointerup",W)),function(t){S.push(t)}(t),"touch"===t.pointerType?function(t){switch(J(t),S.length){case 1:switch(a.touches.ONE){case s.TOUCH.ROTATE:if(!1===a.enableRotate)return;U(),l=o.TOUCH_ROTATE;break;case s.TOUCH.PAN:if(!1===a.enablePan)return;F(),l=o.TOUCH_PAN;break;default:l=o.NONE}break;case 2:switch(a.touches.TWO){case s.TOUCH.DOLLY_PAN:if(!1===a.enableZoom&&!1===a.enablePan)return;a.enableZoom&&B(),a.enablePan&&F(),l=o.TOUCH_DOLLY_PAN;break;case s.TOUCH.DOLLY_ROTATE:if(!1===a.enableZoom&&!1===a.enableRotate)return;a.enableZoom&&B(),a.enableRotate&&U(),l=o.TOUCH_DOLLY_ROTATE;break;default:l=o.NONE}break;default:l=o.NONE}l!==o.NONE&&a.dispatchEvent(e)}(t):function(t){let n;switch(t.button){case 0:n=a.mouseButtons.LEFT;break;case 1:n=a.mouseButtons.MIDDLE;break;case 2:n=a.mouseButtons.RIGHT;break;default:n=-1}switch(n){case s.MOUSE.DOLLY:if(!1===a.enableZoom)return;!function(t){b.set(t.clientX,t.clientY)}(t),l=o.DOLLY;break;case s.MOUSE.ROTATE:if(t.ctrlKey||t.metaKey||t.shiftKey){if(!1===a.enablePan)return;N(t),l=o.PAN}else{if(!1===a.enableRotate)return;O(t),l=o.ROTATE}break;case s.MOUSE.PAN:if(t.ctrlKey||t.metaKey||t.shiftKey){if(!1===a.enableRotate)return;O(t),l=o.ROTATE}else{if(!1===a.enablePan)return;N(t),l=o.PAN}break;default:l=o.NONE}l!==o.NONE&&a.dispatchEvent(e)}(t))}function H(t){!1!==a.enabled&&("touch"===t.pointerType?function(t){switch(J(t),l){case o.TOUCH_ROTATE:if(!1===a.enableRotate)return;z(t),a.update();break;case o.TOUCH_PAN:if(!1===a.enablePan)return;k(t),a.update();break;case o.TOUCH_DOLLY_PAN:if(!1===a.enableZoom&&!1===a.enablePan)return;!function(t){a.enableZoom&&G(t),a.enablePan&&k(t)}(t),a.update();break;case o.TOUCH_DOLLY_ROTATE:if(!1===a.enableZoom&&!1===a.enableRotate)return;!function(t){a.enableZoom&&G(t),a.enableRotate&&z(t)}(t),a.update();break;default:l=o.NONE}}(t):function(t){switch(l){case o.ROTATE:if(!1===a.enableRotate)return;!function(t){g.set(t.clientX,t.clientY),v.subVectors(g,m).multiplyScalar(a.rotateSpeed);const e=a.domElement;A(2*Math.PI*v.x/e.clientHeight),R(2*Math.PI*v.y/e.clientHeight),m.copy(g),a.update()}(t);break;case o.DOLLY:if(!1===a.enableZoom)return;!function(t){M.set(t.clientX,t.clientY),w.subVectors(M,b),w.y>0?I(T()):w.y<0&&D(T()),b.copy(M),a.update()}(t);break;case o.PAN:if(!1===a.enablePan)return;!function(t){y.set(t.clientX,t.clientY),x.subVectors(y,_).multiplyScalar(a.panSpeed),P(x.x,x.y),_.copy(y),a.update()}(t)}}(t))}function W(t){Z(t),0===S.length&&(a.domElement.releasePointerCapture(t.pointerId),a.domElement.removeEventListener("pointermove",H),a.domElement.removeEventListener("pointerup",W)),a.dispatchEvent(n),l=o.NONE}function j(t){Z(t)}function X(t){!1!==a.enabled&&!1!==a.enableZoom&&l===o.NONE&&(t.preventDefault(),a.dispatchEvent(e),function(t){t.deltaY<0?D(T()):t.deltaY>0&&I(T()),a.update()}(t),a.dispatchEvent(n))}function Y(t){!1!==a.enabled&&!1!==a.enablePan&&function(t){let e=!1;switch(t.code){case a.keys.UP:P(0,a.keyPanSpeed),e=!0;break;case a.keys.BOTTOM:P(0,-a.keyPanSpeed),e=!0;break;case a.keys.LEFT:P(a.keyPanSpeed,0),e=!0;break;case a.keys.RIGHT:P(-a.keyPanSpeed,0),e=!0}e&&(t.preventDefault(),a.update())}(t)}function q(t){!1!==a.enabled&&t.preventDefault()}function Z(t){delete E[t.pointerId];for(let e=0;e<S.length;e++)if(S[e].pointerId==t.pointerId)return void S.splice(e,1)}function J(t){let e=E[t.pointerId];void 0===e&&(e=new s.Vector2,E[t.pointerId]=e),e.set(t.pageX,t.pageY)}function K(t){const e=t.pointerId===S[0].pointerId?S[1]:S[0];return E[e.pointerId]}a.domElement.addEventListener("contextmenu",q),a.domElement.addEventListener("pointerdown",V),a.domElement.addEventListener("pointercancel",j),a.domElement.addEventListener("wheel",X,{passive:!1}),this.update()}}s.MapControls=class extends i{constructor(t,e){super(t,e),this.screenSpacePanning=!1,this.mouseButtons.LEFT=s.MOUSE.PAN,this.mouseButtons.RIGHT=s.MOUSE.ROTATE,this.touches.ONE=s.TOUCH.PAN,this.touches.TWO=s.TOUCH.DOLLY_ROTATE}},s.OrbitControls=i}();class a{static createButton(t,e){e&&console.error('THREE.VRButton: The "options" parameter has been removed. Please set the reference space type via renderer.xr.setReferenceSpaceType() instead.');const n=document.createElement("button");function i(){n.style.display="",n.style.cursor="auto",n.style.left="calc(50% - 75px)",n.style.width="150px",n.onmouseenter=null,n.onmouseleave=null,n.onclick=null}function r(t){t.style.position="absolute",t.style.bottom="10px",t.style.padding="6px 3px",t.style.border="1px solid #fff",t.style.borderRadius="1px",t.style.background="rgba(0,0,0,0.1)",t.style.color="#fff",t.style.font="normal 7px sans-serif",t.style.textAlign="center",t.style.opacity="0.5",t.style.outline="none",t.style.zIndex="999"}if("xr"in navigator)return n.id="VRButton",n.style.display="none",r(n),navigator.xr.isSessionSupported("immersive-vr").then((function(e){e?function(){let e=null;async function i(i){i.addEventListener("end",r),await t.xr.setSession(i),n.textContent="EXIT VR",e=i}function r(){e.removeEventListener("end",r),n.textContent="ENTER VR",e=null}n.style.display="",n.style.cursor="pointer",n.style.left="calc(50% - 50px)",n.style.width="100px",n.textContent="ENTER VR",n.onmouseenter=function(){n.style.opacity="1.0"},n.onmouseleave=function(){n.style.opacity="0.5"},n.onclick=function(){if(null===e){const t={optionalFeatures:["local-floor","bounded-floor","hand-tracking","layers"]};navigator.xr.requestSession("immersive-vr",t).then(i)}else e.end()}}():(i(),n.textContent="VR NOT SUPPORTED"),e&&a.xrSessionIsGranted&&n.click()})).catch((function(t){i(),console.warn("Exception when trying to call xr.isSessionSupported",t),n.textContent="VR NOT ALLOWED"})),n;{const t=document.createElement("a");return!1===window.isSecureContext?(t.href=document.location.href.replace(/^http:/,"https:"),t.innerHTML="WEBXR NEEDS HTTPS"):(t.href="https://immersiveweb.dev/",t.innerHTML="WEBXR NOT AVAILABLE"),t.style.left="calc(50% - 90px)",t.style.width="180px",t.style.textDecoration="none",r(t),t}}static xrSessionIsGranted=!1;static registerSessionGrantedListener(){if("xr"in navigator){if(/WebXRViewer\//i.test(navigator.userAgent))return;navigator.xr.addEventListener("sessiongranted",(()=>{a.xrSessionIsGranted=!0}))}}}a.registerSessionGrantedListener();var o=i.DOMWidgetModel.extend({defaults:r.extend(i.DOMWidgetModel.prototype.defaults(),{_model_name:"LatticeModel",_view_name:"LatticeView",_model_module:"evince",_view_module:"evince",_model_module_version:"0.30.0",_view_module_version:"0.30.0"})}),l=i.DOMWidgetView.extend({render:function(){const t=new s.Scene;this.scene=t;let e=new s.PerspectiveCamera(75,window.innerWidth/window.innerHeight,.1,1e3);this.camera=e,this.camera.position.z=5;const n=new s.WebGLRenderer;this.renderer=n,this.el.appendChild(a.createButton(this.renderer)),this.renderer.setAnimationLoop((function(){n.render(t,e)})),this.renderer.setSize(.5*window.innerWidth,.5*window.innerHeight),this.renderer.setClearColor(986927,1),this.renderer.antialias=!0,this.renderer.xr.enabled=!0;let i=new s.OrbitControls(this.camera,this.renderer.domElement);this.controls=i,this.init_changed(),this.el.append(this.renderer.domElement),this.pos_changed(),this.state_changed(),this.model.on("change:pos",this.pos_changed,this),this.model.on("change:init",this.init_changed,this),this.model.on("change:state",this.state_changed,this),n.setAnimationLoop((function(){n.render(t,e)}))},init_changed:function(){this.pos=this.model.get("pos"),this.masses=this.model.get("masses"),this.colors=this.model.get("colors"),this.box=this.model.get("box"),this.state=this.model.get("state"),this.box.length>2&&(this.camera.position.z=2*Math.abs(this.box[2]));let t=new s.SphereBufferGeometry(.3),e=(new s.InstancedBufferGeometry).copy(t),n=this.state.length;e.maxInstancedCount=n;let i=[];if(2==this.box.length){let t=[];for(let e=0;e<n;e++)t.push(this.state[e],this.state[e]);let a=new Float32Array(t);e.setAttribute("aState",new s.InstancedBufferAttribute(a,2,!1));for(let t=0;t<n;t++)i.push(this.pos[t][0],this.pos[t][1],0);let o=new Float32Array(i);e.setAttribute("aCurve",new s.InstancedBufferAttribute(o,3,!1));var r="attribute vec3 aColor;\nvarying vec4 vColor;\n//varying vec3 vPos;\n\n// 1. Define the attributes\nattribute vec4 aCurve;\nattribute vec2 aState;\n\nvec3 getColor(float stateValue){\n  \n  vec3 pos = vec3(0.);\n  pos.x += cos(.01*stateValue );\n  pos.y += 0.0; // sin(progress *PI*8.) * radius + sin(progress * PI *2.) * 30.;\n  pos.z += 0.0; // progress *200. - 200./2. + offset;\n  \n  return pos;\n}\n\nvoid main(){\n  vec3 transformed = position;\n  \n  // 2. Extract values from attribute\n  //float aRadius = aCurve.x;\n\n  \n  // 3. Get position and add it to the final position\n  vec3 curvePosition = vec3(aCurve.x, aCurve.y, 0.0);\n   \n  \n\n  transformed += curvePosition;\n  \n  gl_Position = projectionMatrix * modelViewMatrix * vec4(transformed, 1.0);\n  //vColor = aColor;\n  //vColor = getColor(aState);\n  vColor = vec4(aState.x/2.0, 2.0-aState.y, .1*aState.y, aState.y); //aState.y);\n  //vPis = gl_position;\n}"}if(3==this.box.length){let t=[];for(let e=0;e<n;e++)t.push(this.state[e],this.state[e]);let a=new Float32Array(t);e.setAttribute("aState",new s.InstancedBufferAttribute(a,2,!1));for(let t=0;t<n;t++)i.push(this.pos[t][0],this.pos[t][1],this.pos[t][2]);let o=new Float32Array(i);e.setAttribute("aCurve",new s.InstancedBufferAttribute(o,3,!1)),r="attribute vec3 aColor;\nvarying vec4 vColor;\n//varying vec3 vPos;\n\n// 1. Define the attributes\nattribute vec4 aCurve;\nattribute vec2 aState;\n\nvec4 getColor(vec2 stateValue){\n  \n  vec4 pos = vec4(0.3);\n  pos.x = .5*(1.0 + cos(6.0*stateValue.x));\n  pos.y = .5*(1.0 + sin(stateValue.x)); // (1.0+sin(stateValue *3.14*8.0);\n  pos.z = .5*(1.0 + cos(24.0*stateValue.x + 0.5));\n  //pos.z += .5*(1.0+cos(3.14*stateValue +.5);\n  pos.w = stateValue.y;\n  \n  return pos;\n}\n\nvoid main(){\n  vec3 transformed = position;\n  \n  // 2. Extract values from attribute\n  //float aRadius = aCurve.x;\n\n  \n  // 3. Get position and add it to the final position\n  vec3 curvePosition = vec3(aCurve.x, aCurve.y, aCurve.z);\n   \n  \n\n  transformed += curvePosition;\n  \n  gl_Position = projectionMatrix * modelViewMatrix * vec4(transformed, 1.0);\n  vColor = getColor(aState);\n  //vColor = vec4(aState.x/2.0, 2.0-aState.y, .1*aState.y, aState.y); //aState.y);\n\n}"}let a=new Float32Array([]);e.setAttribute("aColor",new s.InstancedBufferAttribute(a,3,!1)),this.instancedGeometry=e;let o=new s.ShaderMaterial({fragmentShader:"varying vec4 vColor;\nvoid main(){\n  gl_FragColor = gl_FragColor + .5*vColor; //vec4(vColor, 1.0);\n}",vertexShader:r,blending:s.AdditiveBlending});o.depthWrite=!1,o.side=s.FrontSide;let l=new s.InstancedMesh(e,o,n);l.instanceMatrix.needsUpdate=!0,this.scene.add(l);let c=new s.AmbientLight(2105376,5);this.scene.add(c);const u=new s.DirectionalLight(16777215,.5);u.position.set(1,1,1),this.scene.add(u)},pos_changed:function(){this.pos=this.model.get("pos");let t=this.scene.children[0],e=(new s.Matrix4,[]);if(this.box.length>2){for(let n=0;n<t.count;n++)e.push(this.pos[n][0],this.pos[n][1],this.pos[n][2]);let n=new Float32Array(e);this.scene.children[0].geometry.setAttribute("aCurve",new s.InstancedBufferAttribute(n,3,!1))}if(2==this.box.length){for(let n=0;n<t.count;n++)e.push(this.pos[n][0],this.pos[n][1]);let n=new Float32Array(e);this.scene.children[0].geometry.setAttribute("aCurve",new s.InstancedBufferAttribute(n,2,!1))}},state_changed:function(){this.state=this.model.get("state");let t=this.scene.children[0],e=(new s.Matrix4,[]);for(let n=0;n<t.count;n++)e.push(this.state[n],this.state[n]);let n=new Float32Array(e);this.scene.children[0].geometry.setAttribute("aState",new s.InstancedBufferAttribute(n,2,!1))}});t.exports={LatticeModel:o,LatticeView:l}},258:(t,e,n)=>{var i=n(146),r=n(486),s=n(232);!function(){const t={type:"change"},e={type:"start"},n={type:"end"};class i extends s.EventDispatcher{constructor(i,r){super(),void 0===r&&console.warn('THREE.OrbitControls: The second parameter "domElement" is now mandatory.'),r===document&&console.error('THREE.OrbitControls: "document" should not be used as the target "domElement". Please use "renderer.domElement" instead.'),this.object=i,this.domElement=r,this.domElement.style.touchAction="none",this.enabled=!0,this.target=new s.Vector3,this.minDistance=0,this.maxDistance=1/0,this.minZoom=0,this.maxZoom=1/0,this.minPolarAngle=0,this.maxPolarAngle=Math.PI,this.minAzimuthAngle=-1/0,this.maxAzimuthAngle=1/0,this.enableDamping=!1,this.dampingFactor=.05,this.enableZoom=!0,this.zoomSpeed=1,this.enableRotate=!0,this.rotateSpeed=1,this.enablePan=!0,this.panSpeed=1,this.screenSpacePanning=!0,this.keyPanSpeed=7,this.autoRotate=!1,this.autoRotateSpeed=2,this.keys={LEFT:"ArrowLeft",UP:"ArrowUp",RIGHT:"ArrowRight",BOTTOM:"ArrowDown"},this.mouseButtons={LEFT:s.MOUSE.ROTATE,MIDDLE:s.MOUSE.DOLLY,RIGHT:s.MOUSE.PAN},this.touches={ONE:s.TOUCH.ROTATE,TWO:s.TOUCH.DOLLY_PAN},this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.zoom0=this.object.zoom,this._domElementKeyEvents=null,this.getPolarAngle=function(){return u.phi},this.getAzimuthalAngle=function(){return u.theta},this.getDistance=function(){return this.object.position.distanceTo(this.target)},this.listenToKeyEvents=function(t){t.addEventListener("keydown",Y),this._domElementKeyEvents=t},this.saveState=function(){a.target0.copy(a.target),a.position0.copy(a.object.position),a.zoom0=a.object.zoom},this.reset=function(){a.target.copy(a.target0),a.object.position.copy(a.position0),a.object.zoom=a.zoom0,a.object.updateProjectionMatrix(),a.dispatchEvent(t),a.update(),l=o.NONE},this.update=function(){const e=new s.Vector3,n=(new s.Quaternion).setFromUnitVectors(i.up,new s.Vector3(0,1,0)),r=n.clone().invert(),m=new s.Vector3,g=new s.Quaternion,v=2*Math.PI;return function(){const i=a.object.position;e.copy(i).sub(a.target),e.applyQuaternion(n),u.setFromVector3(e),a.autoRotate&&l===o.NONE&&A(2*Math.PI/60/60*a.autoRotateSpeed),a.enableDamping?(u.theta+=h.theta*a.dampingFactor,u.phi+=h.phi*a.dampingFactor):(u.theta+=h.theta,u.phi+=h.phi);let s=a.minAzimuthAngle,_=a.maxAzimuthAngle;return isFinite(s)&&isFinite(_)&&(s<-Math.PI?s+=v:s>Math.PI&&(s-=v),_<-Math.PI?_+=v:_>Math.PI&&(_-=v),u.theta=s<=_?Math.max(s,Math.min(_,u.theta)):u.theta>(s+_)/2?Math.max(s,u.theta):Math.min(_,u.theta)),u.phi=Math.max(a.minPolarAngle,Math.min(a.maxPolarAngle,u.phi)),u.makeSafe(),u.radius*=d,u.radius=Math.max(a.minDistance,Math.min(a.maxDistance,u.radius)),!0===a.enableDamping?a.target.addScaledVector(p,a.dampingFactor):a.target.add(p),e.setFromSpherical(u),e.applyQuaternion(r),i.copy(a.target).add(e),a.object.lookAt(a.target),!0===a.enableDamping?(h.theta*=1-a.dampingFactor,h.phi*=1-a.dampingFactor,p.multiplyScalar(1-a.dampingFactor)):(h.set(0,0,0),p.set(0,0,0)),d=1,!!(f||m.distanceToSquared(a.object.position)>c||8*(1-g.dot(a.object.quaternion))>c)&&(a.dispatchEvent(t),m.copy(a.object.position),g.copy(a.object.quaternion),f=!1,!0)}}(),this.dispose=function(){a.domElement.removeEventListener("contextmenu",q),a.domElement.removeEventListener("pointerdown",V),a.domElement.removeEventListener("pointercancel",j),a.domElement.removeEventListener("wheel",X),a.domElement.removeEventListener("pointermove",H),a.domElement.removeEventListener("pointerup",W),null!==a._domElementKeyEvents&&a._domElementKeyEvents.removeEventListener("keydown",Y)};const a=this,o={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_PAN:4,TOUCH_DOLLY_PAN:5,TOUCH_DOLLY_ROTATE:6};let l=o.NONE;const c=1e-6,u=new s.Spherical,h=new s.Spherical;let d=1;const p=new s.Vector3;let f=!1;const m=new s.Vector2,g=new s.Vector2,v=new s.Vector2,_=new s.Vector2,y=new s.Vector2,x=new s.Vector2,b=new s.Vector2,M=new s.Vector2,w=new s.Vector2,S=[],E={};function T(){return Math.pow(.95,a.zoomSpeed)}function A(t){h.theta-=t}function R(t){h.phi-=t}const C=function(){const t=new s.Vector3;return function(e,n){t.setFromMatrixColumn(n,0),t.multiplyScalar(-e),p.add(t)}}(),L=function(){const t=new s.Vector3;return function(e,n){!0===a.screenSpacePanning?t.setFromMatrixColumn(n,1):(t.setFromMatrixColumn(n,0),t.crossVectors(a.object.up,t)),t.multiplyScalar(e),p.add(t)}}(),P=function(){const t=new s.Vector3;return function(e,n){const i=a.domElement;if(a.object.isPerspectiveCamera){const r=a.object.position;t.copy(r).sub(a.target);let s=t.length();s*=Math.tan(a.object.fov/2*Math.PI/180),C(2*e*s/i.clientHeight,a.object.matrix),L(2*n*s/i.clientHeight,a.object.matrix)}else a.object.isOrthographicCamera?(C(e*(a.object.right-a.object.left)/a.object.zoom/i.clientWidth,a.object.matrix),L(n*(a.object.top-a.object.bottom)/a.object.zoom/i.clientHeight,a.object.matrix)):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled."),a.enablePan=!1)}}();function I(t){a.object.isPerspectiveCamera?d/=t:a.object.isOrthographicCamera?(a.object.zoom=Math.max(a.minZoom,Math.min(a.maxZoom,a.object.zoom*t)),a.object.updateProjectionMatrix(),f=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),a.enableZoom=!1)}function D(t){a.object.isPerspectiveCamera?d*=t:a.object.isOrthographicCamera?(a.object.zoom=Math.max(a.minZoom,Math.min(a.maxZoom,a.object.zoom/t)),a.object.updateProjectionMatrix(),f=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),a.enableZoom=!1)}function O(t){m.set(t.clientX,t.clientY)}function N(t){_.set(t.clientX,t.clientY)}function U(){if(1===S.length)m.set(S[0].pageX,S[0].pageY);else{const t=.5*(S[0].pageX+S[1].pageX),e=.5*(S[0].pageY+S[1].pageY);m.set(t,e)}}function F(){if(1===S.length)_.set(S[0].pageX,S[0].pageY);else{const t=.5*(S[0].pageX+S[1].pageX),e=.5*(S[0].pageY+S[1].pageY);_.set(t,e)}}function B(){const t=S[0].pageX-S[1].pageX,e=S[0].pageY-S[1].pageY,n=Math.sqrt(t*t+e*e);b.set(0,n)}function z(t){if(1==S.length)g.set(t.pageX,t.pageY);else{const e=K(t),n=.5*(t.pageX+e.x),i=.5*(t.pageY+e.y);g.set(n,i)}v.subVectors(g,m).multiplyScalar(a.rotateSpeed);const e=a.domElement;A(2*Math.PI*v.x/e.clientHeight),R(2*Math.PI*v.y/e.clientHeight),m.copy(g)}function k(t){if(1===S.length)y.set(t.pageX,t.pageY);else{const e=K(t),n=.5*(t.pageX+e.x),i=.5*(t.pageY+e.y);y.set(n,i)}x.subVectors(y,_).multiplyScalar(a.panSpeed),P(x.x,x.y),_.copy(y)}function G(t){const e=K(t),n=t.pageX-e.x,i=t.pageY-e.y,r=Math.sqrt(n*n+i*i);M.set(0,r),w.set(0,Math.pow(M.y/b.y,a.zoomSpeed)),I(w.y),b.copy(M)}function V(t){!1!==a.enabled&&(0===S.length&&(a.domElement.setPointerCapture(t.pointerId),a.domElement.addEventListener("pointermove",H),a.domElement.addEventListener("pointerup",W)),function(t){S.push(t)}(t),"touch"===t.pointerType?function(t){switch(J(t),S.length){case 1:switch(a.touches.ONE){case s.TOUCH.ROTATE:if(!1===a.enableRotate)return;U(),l=o.TOUCH_ROTATE;break;case s.TOUCH.PAN:if(!1===a.enablePan)return;F(),l=o.TOUCH_PAN;break;default:l=o.NONE}break;case 2:switch(a.touches.TWO){case s.TOUCH.DOLLY_PAN:if(!1===a.enableZoom&&!1===a.enablePan)return;a.enableZoom&&B(),a.enablePan&&F(),l=o.TOUCH_DOLLY_PAN;break;case s.TOUCH.DOLLY_ROTATE:if(!1===a.enableZoom&&!1===a.enableRotate)return;a.enableZoom&&B(),a.enableRotate&&U(),l=o.TOUCH_DOLLY_ROTATE;break;default:l=o.NONE}break;default:l=o.NONE}l!==o.NONE&&a.dispatchEvent(e)}(t):function(t){let n;switch(t.button){case 0:n=a.mouseButtons.LEFT;break;case 1:n=a.mouseButtons.MIDDLE;break;case 2:n=a.mouseButtons.RIGHT;break;default:n=-1}switch(n){case s.MOUSE.DOLLY:if(!1===a.enableZoom)return;!function(t){b.set(t.clientX,t.clientY)}(t),l=o.DOLLY;break;case s.MOUSE.ROTATE:if(t.ctrlKey||t.metaKey||t.shiftKey){if(!1===a.enablePan)return;N(t),l=o.PAN}else{if(!1===a.enableRotate)return;O(t),l=o.ROTATE}break;case s.MOUSE.PAN:if(t.ctrlKey||t.metaKey||t.shiftKey){if(!1===a.enableRotate)return;O(t),l=o.ROTATE}else{if(!1===a.enablePan)return;N(t),l=o.PAN}break;default:l=o.NONE}l!==o.NONE&&a.dispatchEvent(e)}(t))}function H(t){!1!==a.enabled&&("touch"===t.pointerType?function(t){switch(J(t),l){case o.TOUCH_ROTATE:if(!1===a.enableRotate)return;z(t),a.update();break;case o.TOUCH_PAN:if(!1===a.enablePan)return;k(t),a.update();break;case o.TOUCH_DOLLY_PAN:if(!1===a.enableZoom&&!1===a.enablePan)return;!function(t){a.enableZoom&&G(t),a.enablePan&&k(t)}(t),a.update();break;case o.TOUCH_DOLLY_ROTATE:if(!1===a.enableZoom&&!1===a.enableRotate)return;!function(t){a.enableZoom&&G(t),a.enableRotate&&z(t)}(t),a.update();break;default:l=o.NONE}}(t):function(t){switch(l){case o.ROTATE:if(!1===a.enableRotate)return;!function(t){g.set(t.clientX,t.clientY),v.subVectors(g,m).multiplyScalar(a.rotateSpeed);const e=a.domElement;A(2*Math.PI*v.x/e.clientHeight),R(2*Math.PI*v.y/e.clientHeight),m.copy(g),a.update()}(t);break;case o.DOLLY:if(!1===a.enableZoom)return;!function(t){M.set(t.clientX,t.clientY),w.subVectors(M,b),w.y>0?I(T()):w.y<0&&D(T()),b.copy(M),a.update()}(t);break;case o.PAN:if(!1===a.enablePan)return;!function(t){y.set(t.clientX,t.clientY),x.subVectors(y,_).multiplyScalar(a.panSpeed),P(x.x,x.y),_.copy(y),a.update()}(t)}}(t))}function W(t){Z(t),0===S.length&&(a.domElement.releasePointerCapture(t.pointerId),a.domElement.removeEventListener("pointermove",H),a.domElement.removeEventListener("pointerup",W)),a.dispatchEvent(n),l=o.NONE}function j(t){Z(t)}function X(t){!1!==a.enabled&&!1!==a.enableZoom&&l===o.NONE&&(t.preventDefault(),a.dispatchEvent(e),function(t){t.deltaY<0?D(T()):t.deltaY>0&&I(T()),a.update()}(t),a.dispatchEvent(n))}function Y(t){!1!==a.enabled&&!1!==a.enablePan&&function(t){let e=!1;switch(t.code){case a.keys.UP:P(0,a.keyPanSpeed),e=!0;break;case a.keys.BOTTOM:P(0,-a.keyPanSpeed),e=!0;break;case a.keys.LEFT:P(a.keyPanSpeed,0),e=!0;break;case a.keys.RIGHT:P(-a.keyPanSpeed,0),e=!0}e&&(t.preventDefault(),a.update())}(t)}function q(t){!1!==a.enabled&&t.preventDefault()}function Z(t){delete E[t.pointerId];for(let e=0;e<S.length;e++)if(S[e].pointerId==t.pointerId)return void S.splice(e,1)}function J(t){let e=E[t.pointerId];void 0===e&&(e=new s.Vector2,E[t.pointerId]=e),e.set(t.pageX,t.pageY)}function K(t){const e=t.pointerId===S[0].pointerId?S[1]:S[0];return E[e.pointerId]}a.domElement.addEventListener("contextmenu",q),a.domElement.addEventListener("pointerdown",V),a.domElement.addEventListener("pointercancel",j),a.domElement.addEventListener("wheel",X,{passive:!1}),this.update()}}s.MapControls=class extends i{constructor(t,e){super(t,e),this.screenSpacePanning=!1,this.mouseButtons.LEFT=s.MOUSE.PAN,this.mouseButtons.RIGHT=s.MOUSE.ROTATE,this.touches.ONE=s.TOUCH.PAN,this.touches.TWO=s.TOUCH.DOLLY_ROTATE}},s.OrbitControls=i}();class a{static createButton(t,e){e&&console.error('THREE.VRButton: The "options" parameter has been removed. Please set the reference space type via renderer.xr.setReferenceSpaceType() instead.');const n=document.createElement("button");function i(){n.style.display="",n.style.cursor="auto",n.style.left="calc(50% - 75px)",n.style.width="150px",n.onmouseenter=null,n.onmouseleave=null,n.onclick=null}function r(t){t.style.position="absolute",t.style.bottom="10px",t.style.padding="6px 3px",t.style.border="1px solid #fff",t.style.borderRadius="1px",t.style.background="rgba(0,0,0,0.1)",t.style.color="#fff",t.style.font="normal 7px sans-serif",t.style.textAlign="center",t.style.opacity="0.5",t.style.outline="none",t.style.zIndex="999"}if("xr"in navigator)return n.id="VRButton",n.style.display="none",r(n),navigator.xr.isSessionSupported("immersive-vr").then((function(e){e?function(){let e=null;async function i(i){i.addEventListener("end",r),await t.xr.setSession(i),n.textContent="EXIT VR",e=i}function r(){e.removeEventListener("end",r),n.textContent="ENTER VR",e=null}n.style.display="",n.style.cursor="pointer",n.style.left="calc(50% - 50px)",n.style.width="100px",n.textContent="ENTER VR",n.onmouseenter=function(){n.style.opacity="1.0"},n.onmouseleave=function(){n.style.opacity="0.5"},n.onclick=function(){if(null===e){const t={optionalFeatures:["local-floor","bounded-floor","hand-tracking","layers"]};navigator.xr.requestSession("immersive-vr",t).then(i)}else e.end()}}():(i(),n.textContent="VR NOT SUPPORTED"),e&&a.xrSessionIsGranted&&n.click()})).catch((function(t){i(),console.warn("Exception when trying to call xr.isSessionSupported",t),n.textContent="VR NOT ALLOWED"})),n;{const t=document.createElement("a");return!1===window.isSecureContext?(t.href=document.location.href.replace(/^http:/,"https:"),t.innerHTML="WEBXR NEEDS HTTPS"):(t.href="https://immersiveweb.dev/",t.innerHTML="WEBXR NOT AVAILABLE"),t.style.left="calc(50% - 90px)",t.style.width="180px",t.style.textDecoration="none",r(t),t}}static xrSessionIsGranted=!1;static registerSessionGrantedListener(){if("xr"in navigator){if(/WebXRViewer\//i.test(navigator.userAgent))return;navigator.xr.addEventListener("sessiongranted",(()=>{a.xrSessionIsGranted=!0}))}}}a.registerSessionGrantedListener();var o=i.DOMWidgetModel.extend({defaults:r.extend(i.DOMWidgetModel.prototype.defaults(),{_model_name:"MDModel",_view_name:"MDView",_model_module:"evince",_view_module:"evince",_model_module_version:"0.30.0",_view_module_version:"0.30.0"})}),l=i.DOMWidgetView.extend({render:function(){const t=new s.Scene;this.scene=t;let e=new s.PerspectiveCamera(75,window.innerWidth/window.innerHeight,.1,1e3);this.camera=e,this.camera.position.z=5;const n=new s.WebGLRenderer;this.renderer=n,this.el.appendChild(a.createButton(this.renderer)),this.renderer.setAnimationLoop((function(){n.render(t,e)})),this.renderer.setSize(.5*window.innerWidth,.5*window.innerHeight);const i=new s.Color(this.model.get("bg_color")[0],this.model.get("bg_color")[1],this.model.get("bg_color")[2]);this.renderer.setClearColor(i,1),this.renderer.antialias=!0,this.renderer.xr.enabled=!0;let r=new s.OrbitControls(this.camera,this.renderer.domElement);this.controls=r,this.init_changed(),this.el.append(this.renderer.domElement),this.pos_changed(),this.model.on("change:pos",this.pos_changed,this),this.model.on("change:init",this.init_changed,this),n.setAnimationLoop((function(){n.render(t,e)}))},init_changed:function(){console.log("init change"),this.pos=this.model.get("pos"),this.masses=this.model.get("masses"),this.colors=this.model.get("colors"),this.box=this.model.get("box"),this.box.length>2&&(this.camera.position.z=2*Math.abs(this.box[2]));let t=new s.SphereBufferGeometry(.3),e=(new s.InstancedBufferGeometry).copy(t),n=this.pos.length;e.maxInstancedCount=n;let i=[],r=[];if(2==this.box.length){for(let t=0;t<n;t++)r.push(this.pos[t][0],this.pos[t][1]),i.push(this.colors[t][0],this.colors[t][1],this.colors[t][2]);let t=new Float32Array(r);e.setAttribute("aCurve",new s.InstancedBufferAttribute(t,3,!1));var a="attribute vec3 aColor;\nvarying vec3 vColor;\n//varying vec3 vPos;\n\n// 1. Define the attributes\nattribute vec4 aCurve;\n\nvoid main(){\nvec3 transformed = position;\n\n// 2. Extract values from attribute\n//float aRadius = aCurve.x;\n\n\n// 3. Get position and add it to the final position\nvec3 curvePosition = vec3(aCurve.x, aCurve.y, 0.0);\n\ntransformed += curvePosition;\n\ngl_Position = projectionMatrix * modelViewMatrix * vec4(transformed, 1.0);\nvColor = aColor;\n//vPis = gl_position;\n}"}if(3==this.box.length){for(let t=0;t<n;t++)r.push(this.pos[t][0],this.pos[t][1],this.pos[t][2]),i.push(this.colors[t][0],this.colors[t][1],this.colors[t][2]);let t=new Float32Array(r);e.setAttribute("aCurve",new s.InstancedBufferAttribute(t,3,!1)),a="attribute vec3 aColor;\nvarying vec3 vColor;\n//varying vec3 vPos;\n\n// 1. Define the attributes\nattribute vec4 aCurve;\n\nvoid main(){\nvec3 transformed = position;\n\n// 2. Extract values from attribute\n//float aRadius = aCurve.x;\n\n\n// 3. Get position and add it to the final position\nvec3 curvePosition = vec3(aCurve.x, aCurve.y, aCurve.z);\n\ntransformed += curvePosition;\n\ngl_Position = projectionMatrix * modelViewMatrix * vec4(transformed, 1.0);\nvColor = aColor;\n//vPis = gl_position;\n}"}let o=new Float32Array(i);e.setAttribute("aColor",new s.InstancedBufferAttribute(o,3,!1)),this.instancedGeometry=e;let l=new s.ShaderMaterial({fragmentShader:"varying vec3 vColor;\nvoid main(){\ngl_FragColor = gl_FragColor + vec4(vColor, 1.0);\n}",vertexShader:a}),c=new s.InstancedMesh(e,l,n);if(c.instanceMatrix.needsUpdate=!0,this.scene.add(c),this.box.length>2){if(this.box[0]>0){let t=new s.PlaneGeometry(2*Math.abs(this.box[1]),2*Math.abs(this.box[2])),e=new s.MeshBasicMaterial({color:"rgba(10,10,5)",side:s.BackSide});e.opacity=.2,e.transparent=!0,e.blending=s.SubtractiveBlending,this.model.get("additive")&&(e.blending=s.AdditiveBlending);let n=new s.Mesh(t,e);n.rotation.x=0,n.position.x=this.box[0],n.rotation.y=1.57075,n.rotation.x=1.57075,this.scene.add(n),n=new s.Mesh(t,e),n.rotation.x=0,n.position.x=-this.box[0],n.rotation.y=-1.57075,n.rotation.x=1.57075,this.scene.add(n)}if(this.box[1]>0){let t=new s.PlaneGeometry(2*Math.abs(this.box[0]),2*Math.abs(this.box[2])),e=new s.MeshBasicMaterial({color:"rgba(20,20,10)",side:s.BackSide});e.opacity=.2,e.transparent=!0,e.blending=s.SubtractiveBlending,this.model.get("additive")&&(e.blending=s.AdditiveBlending);let n=new s.Mesh(t,e);n.rotation.y=0,n.position.y=-this.box[1],n.rotation.x=1.57075,n.rotation.z=0,this.scene.add(n),n=new s.Mesh(t,e),n.rotation.y=0,n.position.y=this.box[1],n.rotation.x=-1.57075,n.rotation.z=0,this.scene.add(n)}if(this.box[2]>0){let t=new s.PlaneGeometry(2*Math.abs(this.box[0]),2*Math.abs(this.box[1])),e=new s.MeshBasicMaterial({color:"rgba(35,35,25)",side:s.BackSide});e.opacity=.2,e.transparent=!0,e.blending=s.SubtractiveBlending,this.model.get("additive")&&(e.blending=s.AdditiveBlending);let n=new s.Mesh(t,e);n.position.z=this.box[2],this.scene.add(n),n=new s.Mesh(t,e),n.rotation.x=3.1415,n.position.z=-this.box[2],this.scene.add(n)}let t=[];t.push(new s.Vector3(this.box[0],this.box[1],this.box[2])),t.push(new s.Vector3(this.box[0],-this.box[1],this.box[2])),t.push(new s.Vector3(-this.box[0],-this.box[1],this.box[2])),t.push(new s.Vector3(-this.box[0],this.box[1],this.box[2])),t.push(new s.Vector3(this.box[0],this.box[1],this.box[2]));let e=(new s.BufferGeometry).setFromPoints(t),n=new s.Line(e,new s.LineBasicMaterial({color:7829367}));this.scene.add(n),t=[],t.push(new s.Vector3(this.box[0],this.box[1],-this.box[2])),t.push(new s.Vector3(this.box[0],-this.box[1],-this.box[2])),t.push(new s.Vector3(-this.box[0],-this.box[1],-this.box[2])),t.push(new s.Vector3(-this.box[0],this.box[1],-this.box[2])),t.push(new s.Vector3(this.box[0],this.box[1],-this.box[2])),e=(new s.BufferGeometry).setFromPoints(t),n=new s.Line(e,new s.LineBasicMaterial({color:7829367})),this.scene.add(n),t=[],t.push(new s.Vector3(this.box[0],this.box[1],-this.box[2])),t.push(new s.Vector3(this.box[0],this.box[1],this.box[2])),e=(new s.BufferGeometry).setFromPoints(t),n=new s.Line(e,new s.LineBasicMaterial({color:7829367})),this.scene.add(n),t=[],t.push(new s.Vector3(this.box[0],-this.box[1],-this.box[2])),t.push(new s.Vector3(this.box[0],-this.box[1],this.box[2])),e=(new s.BufferGeometry).setFromPoints(t),n=new s.Line(e,new s.LineBasicMaterial({color:7829367})),this.scene.add(n),t=[],t.push(new s.Vector3(-this.box[0],this.box[1],-this.box[2])),t.push(new s.Vector3(-this.box[0],this.box[1],this.box[2])),e=(new s.BufferGeometry).setFromPoints(t),n=new s.Line(e,new s.LineBasicMaterial({color:7829367})),this.scene.add(n),t=[],t.push(new s.Vector3(-this.box[0],-this.box[1],-this.box[2])),t.push(new s.Vector3(-this.box[0],-this.box[1],this.box[2])),e=(new s.BufferGeometry).setFromPoints(t),n=new s.Line(e,new s.LineBasicMaterial({color:7829367})),this.scene.add(n)}let u=new s.AmbientLight(2105376,5);this.scene.add(u);const h=new s.DirectionalLight(16777215,.5);h.position.set(1,1,1),this.scene.add(h)},pos_changed:function(){this.pos=this.model.get("pos");let t=this.scene.children[0],e=(new s.Matrix4,[]);if(this.box.length>2){for(let n=0;n<t.count;n++)e.push(this.pos[n][0],this.pos[n][1],this.pos[n][2]);let n=new Float32Array(e);this.scene.children[0].geometry.setAttribute("aCurve",new s.InstancedBufferAttribute(n,3,!1))}if(2==this.box.length){for(let n=0;n<t.count;n++)e.push(this.pos[n][0],this.pos[n][1]);let n=new Float32Array(e);this.scene.children[0].geometry.setAttribute("aCurve",new s.InstancedBufferAttribute(n,2,!1))}}});t.exports={MDModel:o,MDView:l}},486:function(t,e,n){var i;t=n.nmd(t),function(){var r,s="Expected a function",a="__lodash_hash_undefined__",o="__lodash_placeholder__",l=32,c=128,u=1/0,h=9007199254740991,d=NaN,p=4294967295,f=[["ary",c],["bind",1],["bindKey",2],["curry",8],["curryRight",16],["flip",512],["partial",l],["partialRight",64],["rearg",256]],m="[object Arguments]",g="[object Array]",v="[object Boolean]",_="[object Date]",y="[object Error]",x="[object Function]",b="[object GeneratorFunction]",M="[object Map]",w="[object Number]",S="[object Object]",E="[object Promise]",T="[object RegExp]",A="[object Set]",R="[object String]",C="[object Symbol]",L="[object WeakMap]",P="[object ArrayBuffer]",I="[object DataView]",D="[object Float32Array]",O="[object Float64Array]",N="[object Int8Array]",U="[object Int16Array]",F="[object Int32Array]",B="[object Uint8Array]",z="[object Uint8ClampedArray]",k="[object Uint16Array]",G="[object Uint32Array]",V=/\b__p \+= '';/g,H=/\b(__p \+=) '' \+/g,W=/(__e\(.*?\)|\b__t\)) \+\n'';/g,j=/&(?:amp|lt|gt|quot|#39);/g,X=/[&<>"']/g,Y=RegExp(j.source),q=RegExp(X.source),Z=/<%-([\s\S]+?)%>/g,J=/<%([\s\S]+?)%>/g,K=/<%=([\s\S]+?)%>/g,$=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,Q=/^\w*$/,tt=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g,et=/[\\^$.*+?()[\]{}|]/g,nt=RegExp(et.source),it=/^\s+/,rt=/\s/,st=/\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,at=/\{\n\/\* \[wrapped with (.+)\] \*/,ot=/,? & /,lt=/[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g,ct=/[()=,{}\[\]\/\s]/,ut=/\\(\\)?/g,ht=/\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g,dt=/\w*$/,pt=/^[-+]0x[0-9a-f]+$/i,ft=/^0b[01]+$/i,mt=/^\[object .+?Constructor\]$/,gt=/^0o[0-7]+$/i,vt=/^(?:0|[1-9]\d*)$/,_t=/[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g,yt=/($^)/,xt=/['\n\r\u2028\u2029\\]/g,bt="\\u0300-\\u036f\\ufe20-\\ufe2f\\u20d0-\\u20ff",Mt="a-z\\xdf-\\xf6\\xf8-\\xff",wt="A-Z\\xc0-\\xd6\\xd8-\\xde",St="\\xac\\xb1\\xd7\\xf7\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf\\u2000-\\u206f \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",Et="["+St+"]",Tt="["+bt+"]",At="\\d+",Rt="["+Mt+"]",Ct="[^\\ud800-\\udfff"+St+At+"\\u2700-\\u27bf"+Mt+wt+"]",Lt="\\ud83c[\\udffb-\\udfff]",Pt="[^\\ud800-\\udfff]",It="(?:\\ud83c[\\udde6-\\uddff]){2}",Dt="[\\ud800-\\udbff][\\udc00-\\udfff]",Ot="["+wt+"]",Nt="(?:"+Rt+"|"+Ct+")",Ut="(?:"+Ot+"|"+Ct+")",Ft="(?:['’](?:d|ll|m|re|s|t|ve))?",Bt="(?:['’](?:D|LL|M|RE|S|T|VE))?",zt="(?:"+Tt+"|"+Lt+")?",kt="[\\ufe0e\\ufe0f]?",Gt=kt+zt+"(?:\\u200d(?:"+[Pt,It,Dt].join("|")+")"+kt+zt+")*",Vt="(?:"+["[\\u2700-\\u27bf]",It,Dt].join("|")+")"+Gt,Ht="(?:"+[Pt+Tt+"?",Tt,It,Dt,"[\\ud800-\\udfff]"].join("|")+")",Wt=RegExp("['’]","g"),jt=RegExp(Tt,"g"),Xt=RegExp(Lt+"(?="+Lt+")|"+Ht+Gt,"g"),Yt=RegExp([Ot+"?"+Rt+"+"+Ft+"(?="+[Et,Ot,"$"].join("|")+")",Ut+"+"+Bt+"(?="+[Et,Ot+Nt,"$"].join("|")+")",Ot+"?"+Nt+"+"+Ft,Ot+"+"+Bt,"\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])","\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",At,Vt].join("|"),"g"),qt=RegExp("[\\u200d\\ud800-\\udfff"+bt+"\\ufe0e\\ufe0f]"),Zt=/[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/,Jt=["Array","Buffer","DataView","Date","Error","Float32Array","Float64Array","Function","Int8Array","Int16Array","Int32Array","Map","Math","Object","Promise","RegExp","Set","String","Symbol","TypeError","Uint8Array","Uint8ClampedArray","Uint16Array","Uint32Array","WeakMap","_","clearTimeout","isFinite","parseInt","setTimeout"],Kt=-1,$t={};$t[D]=$t[O]=$t[N]=$t[U]=$t[F]=$t[B]=$t[z]=$t[k]=$t[G]=!0,$t[m]=$t[g]=$t[P]=$t[v]=$t[I]=$t[_]=$t[y]=$t[x]=$t[M]=$t[w]=$t[S]=$t[T]=$t[A]=$t[R]=$t[L]=!1;var Qt={};Qt[m]=Qt[g]=Qt[P]=Qt[I]=Qt[v]=Qt[_]=Qt[D]=Qt[O]=Qt[N]=Qt[U]=Qt[F]=Qt[M]=Qt[w]=Qt[S]=Qt[T]=Qt[A]=Qt[R]=Qt[C]=Qt[B]=Qt[z]=Qt[k]=Qt[G]=!0,Qt[y]=Qt[x]=Qt[L]=!1;var te={"\\":"\\","'":"'","\n":"n","\r":"r","\u2028":"u2028","\u2029":"u2029"},ee=parseFloat,ne=parseInt,ie="object"==typeof n.g&&n.g&&n.g.Object===Object&&n.g,re="object"==typeof self&&self&&self.Object===Object&&self,se=ie||re||Function("return this")(),ae=e&&!e.nodeType&&e,oe=ae&&t&&!t.nodeType&&t,le=oe&&oe.exports===ae,ce=le&&ie.process,ue=function(){try{return oe&&oe.require&&oe.require("util").types||ce&&ce.binding&&ce.binding("util")}catch(t){}}(),he=ue&&ue.isArrayBuffer,de=ue&&ue.isDate,pe=ue&&ue.isMap,fe=ue&&ue.isRegExp,me=ue&&ue.isSet,ge=ue&&ue.isTypedArray;function ve(t,e,n){switch(n.length){case 0:return t.call(e);case 1:return t.call(e,n[0]);case 2:return t.call(e,n[0],n[1]);case 3:return t.call(e,n[0],n[1],n[2])}return t.apply(e,n)}function _e(t,e,n,i){for(var r=-1,s=null==t?0:t.length;++r<s;){var a=t[r];e(i,a,n(a),t)}return i}function ye(t,e){for(var n=-1,i=null==t?0:t.length;++n<i&&!1!==e(t[n],n,t););return t}function xe(t,e){for(var n=null==t?0:t.length;n--&&!1!==e(t[n],n,t););return t}function be(t,e){for(var n=-1,i=null==t?0:t.length;++n<i;)if(!e(t[n],n,t))return!1;return!0}function Me(t,e){for(var n=-1,i=null==t?0:t.length,r=0,s=[];++n<i;){var a=t[n];e(a,n,t)&&(s[r++]=a)}return s}function we(t,e){return!(null==t||!t.length)&&De(t,e,0)>-1}function Se(t,e,n){for(var i=-1,r=null==t?0:t.length;++i<r;)if(n(e,t[i]))return!0;return!1}function Ee(t,e){for(var n=-1,i=null==t?0:t.length,r=Array(i);++n<i;)r[n]=e(t[n],n,t);return r}function Te(t,e){for(var n=-1,i=e.length,r=t.length;++n<i;)t[r+n]=e[n];return t}function Ae(t,e,n,i){var r=-1,s=null==t?0:t.length;for(i&&s&&(n=t[++r]);++r<s;)n=e(n,t[r],r,t);return n}function Re(t,e,n,i){var r=null==t?0:t.length;for(i&&r&&(n=t[--r]);r--;)n=e(n,t[r],r,t);return n}function Ce(t,e){for(var n=-1,i=null==t?0:t.length;++n<i;)if(e(t[n],n,t))return!0;return!1}var Le=Fe("length");function Pe(t,e,n){var i;return n(t,(function(t,n,r){if(e(t,n,r))return i=n,!1})),i}function Ie(t,e,n,i){for(var r=t.length,s=n+(i?1:-1);i?s--:++s<r;)if(e(t[s],s,t))return s;return-1}function De(t,e,n){return e==e?function(t,e,n){for(var i=n-1,r=t.length;++i<r;)if(t[i]===e)return i;return-1}(t,e,n):Ie(t,Ne,n)}function Oe(t,e,n,i){for(var r=n-1,s=t.length;++r<s;)if(i(t[r],e))return r;return-1}function Ne(t){return t!=t}function Ue(t,e){var n=null==t?0:t.length;return n?ke(t,e)/n:d}function Fe(t){return function(e){return null==e?r:e[t]}}function Be(t){return function(e){return null==t?r:t[e]}}function ze(t,e,n,i,r){return r(t,(function(t,r,s){n=i?(i=!1,t):e(n,t,r,s)})),n}function ke(t,e){for(var n,i=-1,s=t.length;++i<s;){var a=e(t[i]);a!==r&&(n=n===r?a:n+a)}return n}function Ge(t,e){for(var n=-1,i=Array(t);++n<t;)i[n]=e(n);return i}function Ve(t){return t?t.slice(0,on(t)+1).replace(it,""):t}function He(t){return function(e){return t(e)}}function We(t,e){return Ee(e,(function(e){return t[e]}))}function je(t,e){return t.has(e)}function Xe(t,e){for(var n=-1,i=t.length;++n<i&&De(e,t[n],0)>-1;);return n}function Ye(t,e){for(var n=t.length;n--&&De(e,t[n],0)>-1;);return n}function qe(t,e){for(var n=t.length,i=0;n--;)t[n]===e&&++i;return i}var Ze=Be({À:"A",Á:"A",Â:"A",Ã:"A",Ä:"A",Å:"A",à:"a",á:"a",â:"a",ã:"a",ä:"a",å:"a",Ç:"C",ç:"c",Ð:"D",ð:"d",È:"E",É:"E",Ê:"E",Ë:"E",è:"e",é:"e",ê:"e",ë:"e",Ì:"I",Í:"I",Î:"I",Ï:"I",ì:"i",í:"i",î:"i",ï:"i",Ñ:"N",ñ:"n",Ò:"O",Ó:"O",Ô:"O",Õ:"O",Ö:"O",Ø:"O",ò:"o",ó:"o",ô:"o",õ:"o",ö:"o",ø:"o",Ù:"U",Ú:"U",Û:"U",Ü:"U",ù:"u",ú:"u",û:"u",ü:"u",Ý:"Y",ý:"y",ÿ:"y",Æ:"Ae",æ:"ae",Þ:"Th",þ:"th",ß:"ss",Ā:"A",Ă:"A",Ą:"A",ā:"a",ă:"a",ą:"a",Ć:"C",Ĉ:"C",Ċ:"C",Č:"C",ć:"c",ĉ:"c",ċ:"c",č:"c",Ď:"D",Đ:"D",ď:"d",đ:"d",Ē:"E",Ĕ:"E",Ė:"E",Ę:"E",Ě:"E",ē:"e",ĕ:"e",ė:"e",ę:"e",ě:"e",Ĝ:"G",Ğ:"G",Ġ:"G",Ģ:"G",ĝ:"g",ğ:"g",ġ:"g",ģ:"g",Ĥ:"H",Ħ:"H",ĥ:"h",ħ:"h",Ĩ:"I",Ī:"I",Ĭ:"I",Į:"I",İ:"I",ĩ:"i",ī:"i",ĭ:"i",į:"i",ı:"i",Ĵ:"J",ĵ:"j",Ķ:"K",ķ:"k",ĸ:"k",Ĺ:"L",Ļ:"L",Ľ:"L",Ŀ:"L",Ł:"L",ĺ:"l",ļ:"l",ľ:"l",ŀ:"l",ł:"l",Ń:"N",Ņ:"N",Ň:"N",Ŋ:"N",ń:"n",ņ:"n",ň:"n",ŋ:"n",Ō:"O",Ŏ:"O",Ő:"O",ō:"o",ŏ:"o",ő:"o",Ŕ:"R",Ŗ:"R",Ř:"R",ŕ:"r",ŗ:"r",ř:"r",Ś:"S",Ŝ:"S",Ş:"S",Š:"S",ś:"s",ŝ:"s",ş:"s",š:"s",Ţ:"T",Ť:"T",Ŧ:"T",ţ:"t",ť:"t",ŧ:"t",Ũ:"U",Ū:"U",Ŭ:"U",Ů:"U",Ű:"U",Ų:"U",ũ:"u",ū:"u",ŭ:"u",ů:"u",ű:"u",ų:"u",Ŵ:"W",ŵ:"w",Ŷ:"Y",ŷ:"y",Ÿ:"Y",Ź:"Z",Ż:"Z",Ž:"Z",ź:"z",ż:"z",ž:"z",Ĳ:"IJ",ĳ:"ij",Œ:"Oe",œ:"oe",ŉ:"'n",ſ:"s"}),Je=Be({"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;"});function Ke(t){return"\\"+te[t]}function $e(t){return qt.test(t)}function Qe(t){var e=-1,n=Array(t.size);return t.forEach((function(t,i){n[++e]=[i,t]})),n}function tn(t,e){return function(n){return t(e(n))}}function en(t,e){for(var n=-1,i=t.length,r=0,s=[];++n<i;){var a=t[n];a!==e&&a!==o||(t[n]=o,s[r++]=n)}return s}function nn(t){var e=-1,n=Array(t.size);return t.forEach((function(t){n[++e]=t})),n}function rn(t){var e=-1,n=Array(t.size);return t.forEach((function(t){n[++e]=[t,t]})),n}function sn(t){return $e(t)?function(t){for(var e=Xt.lastIndex=0;Xt.test(t);)++e;return e}(t):Le(t)}function an(t){return $e(t)?function(t){return t.match(Xt)||[]}(t):function(t){return t.split("")}(t)}function on(t){for(var e=t.length;e--&&rt.test(t.charAt(e)););return e}var ln=Be({"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"',"&#39;":"'"}),cn=function t(e){var n,i=(e=null==e?se:cn.defaults(se.Object(),e,cn.pick(se,Jt))).Array,rt=e.Date,bt=e.Error,Mt=e.Function,wt=e.Math,St=e.Object,Et=e.RegExp,Tt=e.String,At=e.TypeError,Rt=i.prototype,Ct=Mt.prototype,Lt=St.prototype,Pt=e["__core-js_shared__"],It=Ct.toString,Dt=Lt.hasOwnProperty,Ot=0,Nt=(n=/[^.]+$/.exec(Pt&&Pt.keys&&Pt.keys.IE_PROTO||""))?"Symbol(src)_1."+n:"",Ut=Lt.toString,Ft=It.call(St),Bt=se._,zt=Et("^"+It.call(Dt).replace(et,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),kt=le?e.Buffer:r,Gt=e.Symbol,Vt=e.Uint8Array,Ht=kt?kt.allocUnsafe:r,Xt=tn(St.getPrototypeOf,St),qt=St.create,te=Lt.propertyIsEnumerable,ie=Rt.splice,re=Gt?Gt.isConcatSpreadable:r,ae=Gt?Gt.iterator:r,oe=Gt?Gt.toStringTag:r,ce=function(){try{var t=cs(St,"defineProperty");return t({},"",{}),t}catch(t){}}(),ue=e.clearTimeout!==se.clearTimeout&&e.clearTimeout,Le=rt&&rt.now!==se.Date.now&&rt.now,Be=e.setTimeout!==se.setTimeout&&e.setTimeout,un=wt.ceil,hn=wt.floor,dn=St.getOwnPropertySymbols,pn=kt?kt.isBuffer:r,fn=e.isFinite,mn=Rt.join,gn=tn(St.keys,St),vn=wt.max,_n=wt.min,yn=rt.now,xn=e.parseInt,bn=wt.random,Mn=Rt.reverse,wn=cs(e,"DataView"),Sn=cs(e,"Map"),En=cs(e,"Promise"),Tn=cs(e,"Set"),An=cs(e,"WeakMap"),Rn=cs(St,"create"),Cn=An&&new An,Ln={},Pn=Bs(wn),In=Bs(Sn),Dn=Bs(En),On=Bs(Tn),Nn=Bs(An),Un=Gt?Gt.prototype:r,Fn=Un?Un.valueOf:r,Bn=Un?Un.toString:r;function zn(t){if(eo(t)&&!Wa(t)&&!(t instanceof Hn)){if(t instanceof Vn)return t;if(Dt.call(t,"__wrapped__"))return zs(t)}return new Vn(t)}var kn=function(){function t(){}return function(e){if(!to(e))return{};if(qt)return qt(e);t.prototype=e;var n=new t;return t.prototype=r,n}}();function Gn(){}function Vn(t,e){this.__wrapped__=t,this.__actions__=[],this.__chain__=!!e,this.__index__=0,this.__values__=r}function Hn(t){this.__wrapped__=t,this.__actions__=[],this.__dir__=1,this.__filtered__=!1,this.__iteratees__=[],this.__takeCount__=p,this.__views__=[]}function Wn(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var i=t[e];this.set(i[0],i[1])}}function jn(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var i=t[e];this.set(i[0],i[1])}}function Xn(t){var e=-1,n=null==t?0:t.length;for(this.clear();++e<n;){var i=t[e];this.set(i[0],i[1])}}function Yn(t){var e=-1,n=null==t?0:t.length;for(this.__data__=new Xn;++e<n;)this.add(t[e])}function qn(t){var e=this.__data__=new jn(t);this.size=e.size}function Zn(t,e){var n=Wa(t),i=!n&&Ha(t),r=!n&&!i&&qa(t),s=!n&&!i&&!r&&co(t),a=n||i||r||s,o=a?Ge(t.length,Tt):[],l=o.length;for(var c in t)!e&&!Dt.call(t,c)||a&&("length"==c||r&&("offset"==c||"parent"==c)||s&&("buffer"==c||"byteLength"==c||"byteOffset"==c)||gs(c,l))||o.push(c);return o}function Jn(t){var e=t.length;return e?t[Xi(0,e-1)]:r}function Kn(t,e){return Ds(Ar(t),ai(e,0,t.length))}function $n(t){return Ds(Ar(t))}function Qn(t,e,n){(n!==r&&!ka(t[e],n)||n===r&&!(e in t))&&ri(t,e,n)}function ti(t,e,n){var i=t[e];Dt.call(t,e)&&ka(i,n)&&(n!==r||e in t)||ri(t,e,n)}function ei(t,e){for(var n=t.length;n--;)if(ka(t[n][0],e))return n;return-1}function ni(t,e,n,i){return hi(t,(function(t,r,s){e(i,t,n(t),s)})),i}function ii(t,e){return t&&Rr(e,Io(e),t)}function ri(t,e,n){"__proto__"==e&&ce?ce(t,e,{configurable:!0,enumerable:!0,value:n,writable:!0}):t[e]=n}function si(t,e){for(var n=-1,s=e.length,a=i(s),o=null==t;++n<s;)a[n]=o?r:Ao(t,e[n]);return a}function ai(t,e,n){return t==t&&(n!==r&&(t=t<=n?t:n),e!==r&&(t=t>=e?t:e)),t}function oi(t,e,n,i,s,a){var o,l=1&e,c=2&e,u=4&e;if(n&&(o=s?n(t,i,s,a):n(t)),o!==r)return o;if(!to(t))return t;var h=Wa(t);if(h){if(o=function(t){var e=t.length,n=new t.constructor(e);return e&&"string"==typeof t[0]&&Dt.call(t,"index")&&(n.index=t.index,n.input=t.input),n}(t),!l)return Ar(t,o)}else{var d=ds(t),p=d==x||d==b;if(qa(t))return br(t,l);if(d==S||d==m||p&&!s){if(o=c||p?{}:fs(t),!l)return c?function(t,e){return Rr(t,hs(t),e)}(t,function(t,e){return t&&Rr(e,Do(e),t)}(o,t)):function(t,e){return Rr(t,us(t),e)}(t,ii(o,t))}else{if(!Qt[d])return s?t:{};o=function(t,e,n){var i,r=t.constructor;switch(e){case P:return Mr(t);case v:case _:return new r(+t);case I:return function(t,e){var n=e?Mr(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.byteLength)}(t,n);case D:case O:case N:case U:case F:case B:case z:case k:case G:return wr(t,n);case M:return new r;case w:case R:return new r(t);case T:return function(t){var e=new t.constructor(t.source,dt.exec(t));return e.lastIndex=t.lastIndex,e}(t);case A:return new r;case C:return i=t,Fn?St(Fn.call(i)):{}}}(t,d,l)}}a||(a=new qn);var f=a.get(t);if(f)return f;a.set(t,o),ao(t)?t.forEach((function(i){o.add(oi(i,e,n,i,t,a))})):no(t)&&t.forEach((function(i,r){o.set(r,oi(i,e,n,r,t,a))}));var g=h?r:(u?c?ns:es:c?Do:Io)(t);return ye(g||t,(function(i,r){g&&(i=t[r=i]),ti(o,r,oi(i,e,n,r,t,a))})),o}function li(t,e,n){var i=n.length;if(null==t)return!i;for(t=St(t);i--;){var s=n[i],a=e[s],o=t[s];if(o===r&&!(s in t)||!a(o))return!1}return!0}function ci(t,e,n){if("function"!=typeof t)throw new At(s);return Cs((function(){t.apply(r,n)}),e)}function ui(t,e,n,i){var r=-1,s=we,a=!0,o=t.length,l=[],c=e.length;if(!o)return l;n&&(e=Ee(e,He(n))),i?(s=Se,a=!1):e.length>=200&&(s=je,a=!1,e=new Yn(e));t:for(;++r<o;){var u=t[r],h=null==n?u:n(u);if(u=i||0!==u?u:0,a&&h==h){for(var d=c;d--;)if(e[d]===h)continue t;l.push(u)}else s(e,h,i)||l.push(u)}return l}zn.templateSettings={escape:Z,evaluate:J,interpolate:K,variable:"",imports:{_:zn}},zn.prototype=Gn.prototype,zn.prototype.constructor=zn,Vn.prototype=kn(Gn.prototype),Vn.prototype.constructor=Vn,Hn.prototype=kn(Gn.prototype),Hn.prototype.constructor=Hn,Wn.prototype.clear=function(){this.__data__=Rn?Rn(null):{},this.size=0},Wn.prototype.delete=function(t){var e=this.has(t)&&delete this.__data__[t];return this.size-=e?1:0,e},Wn.prototype.get=function(t){var e=this.__data__;if(Rn){var n=e[t];return n===a?r:n}return Dt.call(e,t)?e[t]:r},Wn.prototype.has=function(t){var e=this.__data__;return Rn?e[t]!==r:Dt.call(e,t)},Wn.prototype.set=function(t,e){var n=this.__data__;return this.size+=this.has(t)?0:1,n[t]=Rn&&e===r?a:e,this},jn.prototype.clear=function(){this.__data__=[],this.size=0},jn.prototype.delete=function(t){var e=this.__data__,n=ei(e,t);return!(n<0||(n==e.length-1?e.pop():ie.call(e,n,1),--this.size,0))},jn.prototype.get=function(t){var e=this.__data__,n=ei(e,t);return n<0?r:e[n][1]},jn.prototype.has=function(t){return ei(this.__data__,t)>-1},jn.prototype.set=function(t,e){var n=this.__data__,i=ei(n,t);return i<0?(++this.size,n.push([t,e])):n[i][1]=e,this},Xn.prototype.clear=function(){this.size=0,this.__data__={hash:new Wn,map:new(Sn||jn),string:new Wn}},Xn.prototype.delete=function(t){var e=os(this,t).delete(t);return this.size-=e?1:0,e},Xn.prototype.get=function(t){return os(this,t).get(t)},Xn.prototype.has=function(t){return os(this,t).has(t)},Xn.prototype.set=function(t,e){var n=os(this,t),i=n.size;return n.set(t,e),this.size+=n.size==i?0:1,this},Yn.prototype.add=Yn.prototype.push=function(t){return this.__data__.set(t,a),this},Yn.prototype.has=function(t){return this.__data__.has(t)},qn.prototype.clear=function(){this.__data__=new jn,this.size=0},qn.prototype.delete=function(t){var e=this.__data__,n=e.delete(t);return this.size=e.size,n},qn.prototype.get=function(t){return this.__data__.get(t)},qn.prototype.has=function(t){return this.__data__.has(t)},qn.prototype.set=function(t,e){var n=this.__data__;if(n instanceof jn){var i=n.__data__;if(!Sn||i.length<199)return i.push([t,e]),this.size=++n.size,this;n=this.__data__=new Xn(i)}return n.set(t,e),this.size=n.size,this};var hi=Pr(yi),di=Pr(xi,!0);function pi(t,e){var n=!0;return hi(t,(function(t,i,r){return n=!!e(t,i,r)})),n}function fi(t,e,n){for(var i=-1,s=t.length;++i<s;){var a=t[i],o=e(a);if(null!=o&&(l===r?o==o&&!lo(o):n(o,l)))var l=o,c=a}return c}function mi(t,e){var n=[];return hi(t,(function(t,i,r){e(t,i,r)&&n.push(t)})),n}function gi(t,e,n,i,r){var s=-1,a=t.length;for(n||(n=ms),r||(r=[]);++s<a;){var o=t[s];e>0&&n(o)?e>1?gi(o,e-1,n,i,r):Te(r,o):i||(r[r.length]=o)}return r}var vi=Ir(),_i=Ir(!0);function yi(t,e){return t&&vi(t,e,Io)}function xi(t,e){return t&&_i(t,e,Io)}function bi(t,e){return Me(e,(function(e){return Ka(t[e])}))}function Mi(t,e){for(var n=0,i=(e=vr(e,t)).length;null!=t&&n<i;)t=t[Fs(e[n++])];return n&&n==i?t:r}function wi(t,e,n){var i=e(t);return Wa(t)?i:Te(i,n(t))}function Si(t){return null==t?t===r?"[object Undefined]":"[object Null]":oe&&oe in St(t)?function(t){var e=Dt.call(t,oe),n=t[oe];try{t[oe]=r;var i=!0}catch(t){}var s=Ut.call(t);return i&&(e?t[oe]=n:delete t[oe]),s}(t):function(t){return Ut.call(t)}(t)}function Ei(t,e){return t>e}function Ti(t,e){return null!=t&&Dt.call(t,e)}function Ai(t,e){return null!=t&&e in St(t)}function Ri(t,e,n){for(var s=n?Se:we,a=t[0].length,o=t.length,l=o,c=i(o),u=1/0,h=[];l--;){var d=t[l];l&&e&&(d=Ee(d,He(e))),u=_n(d.length,u),c[l]=!n&&(e||a>=120&&d.length>=120)?new Yn(l&&d):r}d=t[0];var p=-1,f=c[0];t:for(;++p<a&&h.length<u;){var m=d[p],g=e?e(m):m;if(m=n||0!==m?m:0,!(f?je(f,g):s(h,g,n))){for(l=o;--l;){var v=c[l];if(!(v?je(v,g):s(t[l],g,n)))continue t}f&&f.push(g),h.push(m)}}return h}function Ci(t,e,n){var i=null==(t=Es(t,e=vr(e,t)))?t:t[Fs(Js(e))];return null==i?r:ve(i,t,n)}function Li(t){return eo(t)&&Si(t)==m}function Pi(t,e,n,i,s){return t===e||(null==t||null==e||!eo(t)&&!eo(e)?t!=t&&e!=e:function(t,e,n,i,s,a){var o=Wa(t),l=Wa(e),c=o?g:ds(t),u=l?g:ds(e),h=(c=c==m?S:c)==S,d=(u=u==m?S:u)==S,p=c==u;if(p&&qa(t)){if(!qa(e))return!1;o=!0,h=!1}if(p&&!h)return a||(a=new qn),o||co(t)?Qr(t,e,n,i,s,a):function(t,e,n,i,r,s,a){switch(n){case I:if(t.byteLength!=e.byteLength||t.byteOffset!=e.byteOffset)return!1;t=t.buffer,e=e.buffer;case P:return!(t.byteLength!=e.byteLength||!s(new Vt(t),new Vt(e)));case v:case _:case w:return ka(+t,+e);case y:return t.name==e.name&&t.message==e.message;case T:case R:return t==e+"";case M:var o=Qe;case A:var l=1&i;if(o||(o=nn),t.size!=e.size&&!l)return!1;var c=a.get(t);if(c)return c==e;i|=2,a.set(t,e);var u=Qr(o(t),o(e),i,r,s,a);return a.delete(t),u;case C:if(Fn)return Fn.call(t)==Fn.call(e)}return!1}(t,e,c,n,i,s,a);if(!(1&n)){var f=h&&Dt.call(t,"__wrapped__"),x=d&&Dt.call(e,"__wrapped__");if(f||x){var b=f?t.value():t,E=x?e.value():e;return a||(a=new qn),s(b,E,n,i,a)}}return!!p&&(a||(a=new qn),function(t,e,n,i,s,a){var o=1&n,l=es(t),c=l.length;if(c!=es(e).length&&!o)return!1;for(var u=c;u--;){var h=l[u];if(!(o?h in e:Dt.call(e,h)))return!1}var d=a.get(t),p=a.get(e);if(d&&p)return d==e&&p==t;var f=!0;a.set(t,e),a.set(e,t);for(var m=o;++u<c;){var g=t[h=l[u]],v=e[h];if(i)var _=o?i(v,g,h,e,t,a):i(g,v,h,t,e,a);if(!(_===r?g===v||s(g,v,n,i,a):_)){f=!1;break}m||(m="constructor"==h)}if(f&&!m){var y=t.constructor,x=e.constructor;y==x||!("constructor"in t)||!("constructor"in e)||"function"==typeof y&&y instanceof y&&"function"==typeof x&&x instanceof x||(f=!1)}return a.delete(t),a.delete(e),f}(t,e,n,i,s,a))}(t,e,n,i,Pi,s))}function Ii(t,e,n,i){var s=n.length,a=s,o=!i;if(null==t)return!a;for(t=St(t);s--;){var l=n[s];if(o&&l[2]?l[1]!==t[l[0]]:!(l[0]in t))return!1}for(;++s<a;){var c=(l=n[s])[0],u=t[c],h=l[1];if(o&&l[2]){if(u===r&&!(c in t))return!1}else{var d=new qn;if(i)var p=i(u,h,c,t,e,d);if(!(p===r?Pi(h,u,3,i,d):p))return!1}}return!0}function Di(t){return!(!to(t)||(e=t,Nt&&Nt in e))&&(Ka(t)?zt:mt).test(Bs(t));var e}function Oi(t){return"function"==typeof t?t:null==t?rl:"object"==typeof t?Wa(t)?zi(t[0],t[1]):Bi(t):pl(t)}function Ni(t){if(!bs(t))return gn(t);var e=[];for(var n in St(t))Dt.call(t,n)&&"constructor"!=n&&e.push(n);return e}function Ui(t,e){return t<e}function Fi(t,e){var n=-1,r=Xa(t)?i(t.length):[];return hi(t,(function(t,i,s){r[++n]=e(t,i,s)})),r}function Bi(t){var e=ls(t);return 1==e.length&&e[0][2]?ws(e[0][0],e[0][1]):function(n){return n===t||Ii(n,t,e)}}function zi(t,e){return _s(t)&&Ms(e)?ws(Fs(t),e):function(n){var i=Ao(n,t);return i===r&&i===e?Ro(n,t):Pi(e,i,3)}}function ki(t,e,n,i,s){t!==e&&vi(e,(function(a,o){if(s||(s=new qn),to(a))!function(t,e,n,i,s,a,o){var l=As(t,n),c=As(e,n),u=o.get(c);if(u)Qn(t,n,u);else{var h=a?a(l,c,n+"",t,e,o):r,d=h===r;if(d){var p=Wa(c),f=!p&&qa(c),m=!p&&!f&&co(c);h=c,p||f||m?Wa(l)?h=l:Ya(l)?h=Ar(l):f?(d=!1,h=br(c,!0)):m?(d=!1,h=wr(c,!0)):h=[]:ro(c)||Ha(c)?(h=l,Ha(l)?h=_o(l):to(l)&&!Ka(l)||(h=fs(c))):d=!1}d&&(o.set(c,h),s(h,c,i,a,o),o.delete(c)),Qn(t,n,h)}}(t,e,o,n,ki,i,s);else{var l=i?i(As(t,o),a,o+"",t,e,s):r;l===r&&(l=a),Qn(t,o,l)}}),Do)}function Gi(t,e){var n=t.length;if(n)return gs(e+=e<0?n:0,n)?t[e]:r}function Vi(t,e,n){e=e.length?Ee(e,(function(t){return Wa(t)?function(e){return Mi(e,1===t.length?t[0]:t)}:t})):[rl];var i=-1;e=Ee(e,He(as()));var r=Fi(t,(function(t,n,r){var s=Ee(e,(function(e){return e(t)}));return{criteria:s,index:++i,value:t}}));return function(t,e){var i=t.length;for(t.sort((function(t,e){return function(t,e,n){for(var i=-1,r=t.criteria,s=e.criteria,a=r.length,o=n.length;++i<a;){var l=Sr(r[i],s[i]);if(l)return i>=o?l:l*("desc"==n[i]?-1:1)}return t.index-e.index}(t,e,n)}));i--;)t[i]=t[i].value;return t}(r)}function Hi(t,e,n){for(var i=-1,r=e.length,s={};++i<r;){var a=e[i],o=Mi(t,a);n(o,a)&&Ki(s,vr(a,t),o)}return s}function Wi(t,e,n,i){var r=i?Oe:De,s=-1,a=e.length,o=t;for(t===e&&(e=Ar(e)),n&&(o=Ee(t,He(n)));++s<a;)for(var l=0,c=e[s],u=n?n(c):c;(l=r(o,u,l,i))>-1;)o!==t&&ie.call(o,l,1),ie.call(t,l,1);return t}function ji(t,e){for(var n=t?e.length:0,i=n-1;n--;){var r=e[n];if(n==i||r!==s){var s=r;gs(r)?ie.call(t,r,1):cr(t,r)}}return t}function Xi(t,e){return t+hn(bn()*(e-t+1))}function Yi(t,e){var n="";if(!t||e<1||e>h)return n;do{e%2&&(n+=t),(e=hn(e/2))&&(t+=t)}while(e);return n}function qi(t,e){return Ls(Ss(t,e,rl),t+"")}function Zi(t){return Jn(Go(t))}function Ji(t,e){var n=Go(t);return Ds(n,ai(e,0,n.length))}function Ki(t,e,n,i){if(!to(t))return t;for(var s=-1,a=(e=vr(e,t)).length,o=a-1,l=t;null!=l&&++s<a;){var c=Fs(e[s]),u=n;if("__proto__"===c||"constructor"===c||"prototype"===c)return t;if(s!=o){var h=l[c];(u=i?i(h,c,l):r)===r&&(u=to(h)?h:gs(e[s+1])?[]:{})}ti(l,c,u),l=l[c]}return t}var $i=Cn?function(t,e){return Cn.set(t,e),t}:rl,Qi=ce?function(t,e){return ce(t,"toString",{configurable:!0,enumerable:!1,value:el(e),writable:!0})}:rl;function tr(t){return Ds(Go(t))}function er(t,e,n){var r=-1,s=t.length;e<0&&(e=-e>s?0:s+e),(n=n>s?s:n)<0&&(n+=s),s=e>n?0:n-e>>>0,e>>>=0;for(var a=i(s);++r<s;)a[r]=t[r+e];return a}function nr(t,e){var n;return hi(t,(function(t,i,r){return!(n=e(t,i,r))})),!!n}function ir(t,e,n){var i=0,r=null==t?i:t.length;if("number"==typeof e&&e==e&&r<=2147483647){for(;i<r;){var s=i+r>>>1,a=t[s];null!==a&&!lo(a)&&(n?a<=e:a<e)?i=s+1:r=s}return r}return rr(t,e,rl,n)}function rr(t,e,n,i){var s=0,a=null==t?0:t.length;if(0===a)return 0;for(var o=(e=n(e))!=e,l=null===e,c=lo(e),u=e===r;s<a;){var h=hn((s+a)/2),d=n(t[h]),p=d!==r,f=null===d,m=d==d,g=lo(d);if(o)var v=i||m;else v=u?m&&(i||p):l?m&&p&&(i||!f):c?m&&p&&!f&&(i||!g):!f&&!g&&(i?d<=e:d<e);v?s=h+1:a=h}return _n(a,4294967294)}function sr(t,e){for(var n=-1,i=t.length,r=0,s=[];++n<i;){var a=t[n],o=e?e(a):a;if(!n||!ka(o,l)){var l=o;s[r++]=0===a?0:a}}return s}function ar(t){return"number"==typeof t?t:lo(t)?d:+t}function or(t){if("string"==typeof t)return t;if(Wa(t))return Ee(t,or)+"";if(lo(t))return Bn?Bn.call(t):"";var e=t+"";return"0"==e&&1/t==-1/0?"-0":e}function lr(t,e,n){var i=-1,r=we,s=t.length,a=!0,o=[],l=o;if(n)a=!1,r=Se;else if(s>=200){var c=e?null:Yr(t);if(c)return nn(c);a=!1,r=je,l=new Yn}else l=e?[]:o;t:for(;++i<s;){var u=t[i],h=e?e(u):u;if(u=n||0!==u?u:0,a&&h==h){for(var d=l.length;d--;)if(l[d]===h)continue t;e&&l.push(h),o.push(u)}else r(l,h,n)||(l!==o&&l.push(h),o.push(u))}return o}function cr(t,e){return null==(t=Es(t,e=vr(e,t)))||delete t[Fs(Js(e))]}function ur(t,e,n,i){return Ki(t,e,n(Mi(t,e)),i)}function hr(t,e,n,i){for(var r=t.length,s=i?r:-1;(i?s--:++s<r)&&e(t[s],s,t););return n?er(t,i?0:s,i?s+1:r):er(t,i?s+1:0,i?r:s)}function dr(t,e){var n=t;return n instanceof Hn&&(n=n.value()),Ae(e,(function(t,e){return e.func.apply(e.thisArg,Te([t],e.args))}),n)}function pr(t,e,n){var r=t.length;if(r<2)return r?lr(t[0]):[];for(var s=-1,a=i(r);++s<r;)for(var o=t[s],l=-1;++l<r;)l!=s&&(a[s]=ui(a[s]||o,t[l],e,n));return lr(gi(a,1),e,n)}function fr(t,e,n){for(var i=-1,s=t.length,a=e.length,o={};++i<s;){var l=i<a?e[i]:r;n(o,t[i],l)}return o}function mr(t){return Ya(t)?t:[]}function gr(t){return"function"==typeof t?t:rl}function vr(t,e){return Wa(t)?t:_s(t,e)?[t]:Us(yo(t))}var _r=qi;function yr(t,e,n){var i=t.length;return n=n===r?i:n,!e&&n>=i?t:er(t,e,n)}var xr=ue||function(t){return se.clearTimeout(t)};function br(t,e){if(e)return t.slice();var n=t.length,i=Ht?Ht(n):new t.constructor(n);return t.copy(i),i}function Mr(t){var e=new t.constructor(t.byteLength);return new Vt(e).set(new Vt(t)),e}function wr(t,e){var n=e?Mr(t.buffer):t.buffer;return new t.constructor(n,t.byteOffset,t.length)}function Sr(t,e){if(t!==e){var n=t!==r,i=null===t,s=t==t,a=lo(t),o=e!==r,l=null===e,c=e==e,u=lo(e);if(!l&&!u&&!a&&t>e||a&&o&&c&&!l&&!u||i&&o&&c||!n&&c||!s)return 1;if(!i&&!a&&!u&&t<e||u&&n&&s&&!i&&!a||l&&n&&s||!o&&s||!c)return-1}return 0}function Er(t,e,n,r){for(var s=-1,a=t.length,o=n.length,l=-1,c=e.length,u=vn(a-o,0),h=i(c+u),d=!r;++l<c;)h[l]=e[l];for(;++s<o;)(d||s<a)&&(h[n[s]]=t[s]);for(;u--;)h[l++]=t[s++];return h}function Tr(t,e,n,r){for(var s=-1,a=t.length,o=-1,l=n.length,c=-1,u=e.length,h=vn(a-l,0),d=i(h+u),p=!r;++s<h;)d[s]=t[s];for(var f=s;++c<u;)d[f+c]=e[c];for(;++o<l;)(p||s<a)&&(d[f+n[o]]=t[s++]);return d}function Ar(t,e){var n=-1,r=t.length;for(e||(e=i(r));++n<r;)e[n]=t[n];return e}function Rr(t,e,n,i){var s=!n;n||(n={});for(var a=-1,o=e.length;++a<o;){var l=e[a],c=i?i(n[l],t[l],l,n,t):r;c===r&&(c=t[l]),s?ri(n,l,c):ti(n,l,c)}return n}function Cr(t,e){return function(n,i){var r=Wa(n)?_e:ni,s=e?e():{};return r(n,t,as(i,2),s)}}function Lr(t){return qi((function(e,n){var i=-1,s=n.length,a=s>1?n[s-1]:r,o=s>2?n[2]:r;for(a=t.length>3&&"function"==typeof a?(s--,a):r,o&&vs(n[0],n[1],o)&&(a=s<3?r:a,s=1),e=St(e);++i<s;){var l=n[i];l&&t(e,l,i,a)}return e}))}function Pr(t,e){return function(n,i){if(null==n)return n;if(!Xa(n))return t(n,i);for(var r=n.length,s=e?r:-1,a=St(n);(e?s--:++s<r)&&!1!==i(a[s],s,a););return n}}function Ir(t){return function(e,n,i){for(var r=-1,s=St(e),a=i(e),o=a.length;o--;){var l=a[t?o:++r];if(!1===n(s[l],l,s))break}return e}}function Dr(t){return function(e){var n=$e(e=yo(e))?an(e):r,i=n?n[0]:e.charAt(0),s=n?yr(n,1).join(""):e.slice(1);return i[t]()+s}}function Or(t){return function(e){return Ae($o(Wo(e).replace(Wt,"")),t,"")}}function Nr(t){return function(){var e=arguments;switch(e.length){case 0:return new t;case 1:return new t(e[0]);case 2:return new t(e[0],e[1]);case 3:return new t(e[0],e[1],e[2]);case 4:return new t(e[0],e[1],e[2],e[3]);case 5:return new t(e[0],e[1],e[2],e[3],e[4]);case 6:return new t(e[0],e[1],e[2],e[3],e[4],e[5]);case 7:return new t(e[0],e[1],e[2],e[3],e[4],e[5],e[6])}var n=kn(t.prototype),i=t.apply(n,e);return to(i)?i:n}}function Ur(t){return function(e,n,i){var s=St(e);if(!Xa(e)){var a=as(n,3);e=Io(e),n=function(t){return a(s[t],t,s)}}var o=t(e,n,i);return o>-1?s[a?e[o]:o]:r}}function Fr(t){return ts((function(e){var n=e.length,i=n,a=Vn.prototype.thru;for(t&&e.reverse();i--;){var o=e[i];if("function"!=typeof o)throw new At(s);if(a&&!l&&"wrapper"==rs(o))var l=new Vn([],!0)}for(i=l?i:n;++i<n;){var c=rs(o=e[i]),u="wrapper"==c?is(o):r;l=u&&ys(u[0])&&424==u[1]&&!u[4].length&&1==u[9]?l[rs(u[0])].apply(l,u[3]):1==o.length&&ys(o)?l[c]():l.thru(o)}return function(){var t=arguments,i=t[0];if(l&&1==t.length&&Wa(i))return l.plant(i).value();for(var r=0,s=n?e[r].apply(this,t):i;++r<n;)s=e[r].call(this,s);return s}}))}function Br(t,e,n,s,a,o,l,u,h,d){var p=e&c,f=1&e,m=2&e,g=24&e,v=512&e,_=m?r:Nr(t);return function r(){for(var c=arguments.length,y=i(c),x=c;x--;)y[x]=arguments[x];if(g)var b=ss(r),M=qe(y,b);if(s&&(y=Er(y,s,a,g)),o&&(y=Tr(y,o,l,g)),c-=M,g&&c<d){var w=en(y,b);return jr(t,e,Br,r.placeholder,n,y,w,u,h,d-c)}var S=f?n:this,E=m?S[t]:t;return c=y.length,u?y=Ts(y,u):v&&c>1&&y.reverse(),p&&h<c&&(y.length=h),this&&this!==se&&this instanceof r&&(E=_||Nr(E)),E.apply(S,y)}}function zr(t,e){return function(n,i){return function(t,e,n,i){return yi(t,(function(t,r,s){e(i,n(t),r,s)})),i}(n,t,e(i),{})}}function kr(t,e){return function(n,i){var s;if(n===r&&i===r)return e;if(n!==r&&(s=n),i!==r){if(s===r)return i;"string"==typeof n||"string"==typeof i?(n=or(n),i=or(i)):(n=ar(n),i=ar(i)),s=t(n,i)}return s}}function Gr(t){return ts((function(e){return e=Ee(e,He(as())),qi((function(n){var i=this;return t(e,(function(t){return ve(t,i,n)}))}))}))}function Vr(t,e){var n=(e=e===r?" ":or(e)).length;if(n<2)return n?Yi(e,t):e;var i=Yi(e,un(t/sn(e)));return $e(e)?yr(an(i),0,t).join(""):i.slice(0,t)}function Hr(t){return function(e,n,s){return s&&"number"!=typeof s&&vs(e,n,s)&&(n=s=r),e=fo(e),n===r?(n=e,e=0):n=fo(n),function(t,e,n,r){for(var s=-1,a=vn(un((e-t)/(n||1)),0),o=i(a);a--;)o[r?a:++s]=t,t+=n;return o}(e,n,s=s===r?e<n?1:-1:fo(s),t)}}function Wr(t){return function(e,n){return"string"==typeof e&&"string"==typeof n||(e=vo(e),n=vo(n)),t(e,n)}}function jr(t,e,n,i,s,a,o,c,u,h){var d=8&e;e|=d?l:64,4&(e&=~(d?64:l))||(e&=-4);var p=[t,e,s,d?a:r,d?o:r,d?r:a,d?r:o,c,u,h],f=n.apply(r,p);return ys(t)&&Rs(f,p),f.placeholder=i,Ps(f,t,e)}function Xr(t){var e=wt[t];return function(t,n){if(t=vo(t),(n=null==n?0:_n(mo(n),292))&&fn(t)){var i=(yo(t)+"e").split("e");return+((i=(yo(e(i[0]+"e"+(+i[1]+n)))+"e").split("e"))[0]+"e"+(+i[1]-n))}return e(t)}}var Yr=Tn&&1/nn(new Tn([,-0]))[1]==u?function(t){return new Tn(t)}:cl;function qr(t){return function(e){var n=ds(e);return n==M?Qe(e):n==A?rn(e):function(t,e){return Ee(e,(function(e){return[e,t[e]]}))}(e,t(e))}}function Zr(t,e,n,a,u,h,d,p){var f=2&e;if(!f&&"function"!=typeof t)throw new At(s);var m=a?a.length:0;if(m||(e&=-97,a=u=r),d=d===r?d:vn(mo(d),0),p=p===r?p:mo(p),m-=u?u.length:0,64&e){var g=a,v=u;a=u=r}var _=f?r:is(t),y=[t,e,n,a,u,g,v,h,d,p];if(_&&function(t,e){var n=t[1],i=e[1],r=n|i,s=r<131,a=i==c&&8==n||i==c&&256==n&&t[7].length<=e[8]||384==i&&e[7].length<=e[8]&&8==n;if(!s&&!a)return t;1&i&&(t[2]=e[2],r|=1&n?0:4);var l=e[3];if(l){var u=t[3];t[3]=u?Er(u,l,e[4]):l,t[4]=u?en(t[3],o):e[4]}(l=e[5])&&(u=t[5],t[5]=u?Tr(u,l,e[6]):l,t[6]=u?en(t[5],o):e[6]),(l=e[7])&&(t[7]=l),i&c&&(t[8]=null==t[8]?e[8]:_n(t[8],e[8])),null==t[9]&&(t[9]=e[9]),t[0]=e[0],t[1]=r}(y,_),t=y[0],e=y[1],n=y[2],a=y[3],u=y[4],!(p=y[9]=y[9]===r?f?0:t.length:vn(y[9]-m,0))&&24&e&&(e&=-25),e&&1!=e)x=8==e||16==e?function(t,e,n){var s=Nr(t);return function a(){for(var o=arguments.length,l=i(o),c=o,u=ss(a);c--;)l[c]=arguments[c];var h=o<3&&l[0]!==u&&l[o-1]!==u?[]:en(l,u);return(o-=h.length)<n?jr(t,e,Br,a.placeholder,r,l,h,r,r,n-o):ve(this&&this!==se&&this instanceof a?s:t,this,l)}}(t,e,p):e!=l&&33!=e||u.length?Br.apply(r,y):function(t,e,n,r){var s=1&e,a=Nr(t);return function e(){for(var o=-1,l=arguments.length,c=-1,u=r.length,h=i(u+l),d=this&&this!==se&&this instanceof e?a:t;++c<u;)h[c]=r[c];for(;l--;)h[c++]=arguments[++o];return ve(d,s?n:this,h)}}(t,e,n,a);else var x=function(t,e,n){var i=1&e,r=Nr(t);return function e(){return(this&&this!==se&&this instanceof e?r:t).apply(i?n:this,arguments)}}(t,e,n);return Ps((_?$i:Rs)(x,y),t,e)}function Jr(t,e,n,i){return t===r||ka(t,Lt[n])&&!Dt.call(i,n)?e:t}function Kr(t,e,n,i,s,a){return to(t)&&to(e)&&(a.set(e,t),ki(t,e,r,Kr,a),a.delete(e)),t}function $r(t){return ro(t)?r:t}function Qr(t,e,n,i,s,a){var o=1&n,l=t.length,c=e.length;if(l!=c&&!(o&&c>l))return!1;var u=a.get(t),h=a.get(e);if(u&&h)return u==e&&h==t;var d=-1,p=!0,f=2&n?new Yn:r;for(a.set(t,e),a.set(e,t);++d<l;){var m=t[d],g=e[d];if(i)var v=o?i(g,m,d,e,t,a):i(m,g,d,t,e,a);if(v!==r){if(v)continue;p=!1;break}if(f){if(!Ce(e,(function(t,e){if(!je(f,e)&&(m===t||s(m,t,n,i,a)))return f.push(e)}))){p=!1;break}}else if(m!==g&&!s(m,g,n,i,a)){p=!1;break}}return a.delete(t),a.delete(e),p}function ts(t){return Ls(Ss(t,r,js),t+"")}function es(t){return wi(t,Io,us)}function ns(t){return wi(t,Do,hs)}var is=Cn?function(t){return Cn.get(t)}:cl;function rs(t){for(var e=t.name+"",n=Ln[e],i=Dt.call(Ln,e)?n.length:0;i--;){var r=n[i],s=r.func;if(null==s||s==t)return r.name}return e}function ss(t){return(Dt.call(zn,"placeholder")?zn:t).placeholder}function as(){var t=zn.iteratee||sl;return t=t===sl?Oi:t,arguments.length?t(arguments[0],arguments[1]):t}function os(t,e){var n,i,r=t.__data__;return("string"==(i=typeof(n=e))||"number"==i||"symbol"==i||"boolean"==i?"__proto__"!==n:null===n)?r["string"==typeof e?"string":"hash"]:r.map}function ls(t){for(var e=Io(t),n=e.length;n--;){var i=e[n],r=t[i];e[n]=[i,r,Ms(r)]}return e}function cs(t,e){var n=function(t,e){return null==t?r:t[e]}(t,e);return Di(n)?n:r}var us=dn?function(t){return null==t?[]:(t=St(t),Me(dn(t),(function(e){return te.call(t,e)})))}:gl,hs=dn?function(t){for(var e=[];t;)Te(e,us(t)),t=Xt(t);return e}:gl,ds=Si;function ps(t,e,n){for(var i=-1,r=(e=vr(e,t)).length,s=!1;++i<r;){var a=Fs(e[i]);if(!(s=null!=t&&n(t,a)))break;t=t[a]}return s||++i!=r?s:!!(r=null==t?0:t.length)&&Qa(r)&&gs(a,r)&&(Wa(t)||Ha(t))}function fs(t){return"function"!=typeof t.constructor||bs(t)?{}:kn(Xt(t))}function ms(t){return Wa(t)||Ha(t)||!!(re&&t&&t[re])}function gs(t,e){var n=typeof t;return!!(e=null==e?h:e)&&("number"==n||"symbol"!=n&&vt.test(t))&&t>-1&&t%1==0&&t<e}function vs(t,e,n){if(!to(n))return!1;var i=typeof e;return!!("number"==i?Xa(n)&&gs(e,n.length):"string"==i&&e in n)&&ka(n[e],t)}function _s(t,e){if(Wa(t))return!1;var n=typeof t;return!("number"!=n&&"symbol"!=n&&"boolean"!=n&&null!=t&&!lo(t))||Q.test(t)||!$.test(t)||null!=e&&t in St(e)}function ys(t){var e=rs(t),n=zn[e];if("function"!=typeof n||!(e in Hn.prototype))return!1;if(t===n)return!0;var i=is(n);return!!i&&t===i[0]}(wn&&ds(new wn(new ArrayBuffer(1)))!=I||Sn&&ds(new Sn)!=M||En&&ds(En.resolve())!=E||Tn&&ds(new Tn)!=A||An&&ds(new An)!=L)&&(ds=function(t){var e=Si(t),n=e==S?t.constructor:r,i=n?Bs(n):"";if(i)switch(i){case Pn:return I;case In:return M;case Dn:return E;case On:return A;case Nn:return L}return e});var xs=Pt?Ka:vl;function bs(t){var e=t&&t.constructor;return t===("function"==typeof e&&e.prototype||Lt)}function Ms(t){return t==t&&!to(t)}function ws(t,e){return function(n){return null!=n&&n[t]===e&&(e!==r||t in St(n))}}function Ss(t,e,n){return e=vn(e===r?t.length-1:e,0),function(){for(var r=arguments,s=-1,a=vn(r.length-e,0),o=i(a);++s<a;)o[s]=r[e+s];s=-1;for(var l=i(e+1);++s<e;)l[s]=r[s];return l[e]=n(o),ve(t,this,l)}}function Es(t,e){return e.length<2?t:Mi(t,er(e,0,-1))}function Ts(t,e){for(var n=t.length,i=_n(e.length,n),s=Ar(t);i--;){var a=e[i];t[i]=gs(a,n)?s[a]:r}return t}function As(t,e){if(("constructor"!==e||"function"!=typeof t[e])&&"__proto__"!=e)return t[e]}var Rs=Is($i),Cs=Be||function(t,e){return se.setTimeout(t,e)},Ls=Is(Qi);function Ps(t,e,n){var i=e+"";return Ls(t,function(t,e){var n=e.length;if(!n)return t;var i=n-1;return e[i]=(n>1?"& ":"")+e[i],e=e.join(n>2?", ":" "),t.replace(st,"{\n/* [wrapped with "+e+"] */\n")}(i,function(t,e){return ye(f,(function(n){var i="_."+n[0];e&n[1]&&!we(t,i)&&t.push(i)})),t.sort()}(function(t){var e=t.match(at);return e?e[1].split(ot):[]}(i),n)))}function Is(t){var e=0,n=0;return function(){var i=yn(),s=16-(i-n);if(n=i,s>0){if(++e>=800)return arguments[0]}else e=0;return t.apply(r,arguments)}}function Ds(t,e){var n=-1,i=t.length,s=i-1;for(e=e===r?i:e;++n<e;){var a=Xi(n,s),o=t[a];t[a]=t[n],t[n]=o}return t.length=e,t}var Os,Ns,Us=(Os=Oa((function(t){var e=[];return 46===t.charCodeAt(0)&&e.push(""),t.replace(tt,(function(t,n,i,r){e.push(i?r.replace(ut,"$1"):n||t)})),e}),(function(t){return 500===Ns.size&&Ns.clear(),t})),Ns=Os.cache,Os);function Fs(t){if("string"==typeof t||lo(t))return t;var e=t+"";return"0"==e&&1/t==-1/0?"-0":e}function Bs(t){if(null!=t){try{return It.call(t)}catch(t){}try{return t+""}catch(t){}}return""}function zs(t){if(t instanceof Hn)return t.clone();var e=new Vn(t.__wrapped__,t.__chain__);return e.__actions__=Ar(t.__actions__),e.__index__=t.__index__,e.__values__=t.__values__,e}var ks=qi((function(t,e){return Ya(t)?ui(t,gi(e,1,Ya,!0)):[]})),Gs=qi((function(t,e){var n=Js(e);return Ya(n)&&(n=r),Ya(t)?ui(t,gi(e,1,Ya,!0),as(n,2)):[]})),Vs=qi((function(t,e){var n=Js(e);return Ya(n)&&(n=r),Ya(t)?ui(t,gi(e,1,Ya,!0),r,n):[]}));function Hs(t,e,n){var i=null==t?0:t.length;if(!i)return-1;var r=null==n?0:mo(n);return r<0&&(r=vn(i+r,0)),Ie(t,as(e,3),r)}function Ws(t,e,n){var i=null==t?0:t.length;if(!i)return-1;var s=i-1;return n!==r&&(s=mo(n),s=n<0?vn(i+s,0):_n(s,i-1)),Ie(t,as(e,3),s,!0)}function js(t){return null!=t&&t.length?gi(t,1):[]}function Xs(t){return t&&t.length?t[0]:r}var Ys=qi((function(t){var e=Ee(t,mr);return e.length&&e[0]===t[0]?Ri(e):[]})),qs=qi((function(t){var e=Js(t),n=Ee(t,mr);return e===Js(n)?e=r:n.pop(),n.length&&n[0]===t[0]?Ri(n,as(e,2)):[]})),Zs=qi((function(t){var e=Js(t),n=Ee(t,mr);return(e="function"==typeof e?e:r)&&n.pop(),n.length&&n[0]===t[0]?Ri(n,r,e):[]}));function Js(t){var e=null==t?0:t.length;return e?t[e-1]:r}var Ks=qi($s);function $s(t,e){return t&&t.length&&e&&e.length?Wi(t,e):t}var Qs=ts((function(t,e){var n=null==t?0:t.length,i=si(t,e);return ji(t,Ee(e,(function(t){return gs(t,n)?+t:t})).sort(Sr)),i}));function ta(t){return null==t?t:Mn.call(t)}var ea=qi((function(t){return lr(gi(t,1,Ya,!0))})),na=qi((function(t){var e=Js(t);return Ya(e)&&(e=r),lr(gi(t,1,Ya,!0),as(e,2))})),ia=qi((function(t){var e=Js(t);return e="function"==typeof e?e:r,lr(gi(t,1,Ya,!0),r,e)}));function ra(t){if(!t||!t.length)return[];var e=0;return t=Me(t,(function(t){if(Ya(t))return e=vn(t.length,e),!0})),Ge(e,(function(e){return Ee(t,Fe(e))}))}function sa(t,e){if(!t||!t.length)return[];var n=ra(t);return null==e?n:Ee(n,(function(t){return ve(e,r,t)}))}var aa=qi((function(t,e){return Ya(t)?ui(t,e):[]})),oa=qi((function(t){return pr(Me(t,Ya))})),la=qi((function(t){var e=Js(t);return Ya(e)&&(e=r),pr(Me(t,Ya),as(e,2))})),ca=qi((function(t){var e=Js(t);return e="function"==typeof e?e:r,pr(Me(t,Ya),r,e)})),ua=qi(ra),ha=qi((function(t){var e=t.length,n=e>1?t[e-1]:r;return n="function"==typeof n?(t.pop(),n):r,sa(t,n)}));function da(t){var e=zn(t);return e.__chain__=!0,e}function pa(t,e){return e(t)}var fa=ts((function(t){var e=t.length,n=e?t[0]:0,i=this.__wrapped__,s=function(e){return si(e,t)};return!(e>1||this.__actions__.length)&&i instanceof Hn&&gs(n)?((i=i.slice(n,+n+(e?1:0))).__actions__.push({func:pa,args:[s],thisArg:r}),new Vn(i,this.__chain__).thru((function(t){return e&&!t.length&&t.push(r),t}))):this.thru(s)})),ma=Cr((function(t,e,n){Dt.call(t,n)?++t[n]:ri(t,n,1)})),ga=Ur(Hs),va=Ur(Ws);function _a(t,e){return(Wa(t)?ye:hi)(t,as(e,3))}function ya(t,e){return(Wa(t)?xe:di)(t,as(e,3))}var xa=Cr((function(t,e,n){Dt.call(t,n)?t[n].push(e):ri(t,n,[e])})),ba=qi((function(t,e,n){var r=-1,s="function"==typeof e,a=Xa(t)?i(t.length):[];return hi(t,(function(t){a[++r]=s?ve(e,t,n):Ci(t,e,n)})),a})),Ma=Cr((function(t,e,n){ri(t,n,e)}));function wa(t,e){return(Wa(t)?Ee:Fi)(t,as(e,3))}var Sa=Cr((function(t,e,n){t[n?0:1].push(e)}),(function(){return[[],[]]})),Ea=qi((function(t,e){if(null==t)return[];var n=e.length;return n>1&&vs(t,e[0],e[1])?e=[]:n>2&&vs(e[0],e[1],e[2])&&(e=[e[0]]),Vi(t,gi(e,1),[])})),Ta=Le||function(){return se.Date.now()};function Aa(t,e,n){return e=n?r:e,e=t&&null==e?t.length:e,Zr(t,c,r,r,r,r,e)}function Ra(t,e){var n;if("function"!=typeof e)throw new At(s);return t=mo(t),function(){return--t>0&&(n=e.apply(this,arguments)),t<=1&&(e=r),n}}var Ca=qi((function(t,e,n){var i=1;if(n.length){var r=en(n,ss(Ca));i|=l}return Zr(t,i,e,n,r)})),La=qi((function(t,e,n){var i=3;if(n.length){var r=en(n,ss(La));i|=l}return Zr(e,i,t,n,r)}));function Pa(t,e,n){var i,a,o,l,c,u,h=0,d=!1,p=!1,f=!0;if("function"!=typeof t)throw new At(s);function m(e){var n=i,s=a;return i=a=r,h=e,l=t.apply(s,n)}function g(t){return h=t,c=Cs(_,e),d?m(t):l}function v(t){var n=t-u;return u===r||n>=e||n<0||p&&t-h>=o}function _(){var t=Ta();if(v(t))return y(t);c=Cs(_,function(t){var n=e-(t-u);return p?_n(n,o-(t-h)):n}(t))}function y(t){return c=r,f&&i?m(t):(i=a=r,l)}function x(){var t=Ta(),n=v(t);if(i=arguments,a=this,u=t,n){if(c===r)return g(u);if(p)return xr(c),c=Cs(_,e),m(u)}return c===r&&(c=Cs(_,e)),l}return e=vo(e)||0,to(n)&&(d=!!n.leading,o=(p="maxWait"in n)?vn(vo(n.maxWait)||0,e):o,f="trailing"in n?!!n.trailing:f),x.cancel=function(){c!==r&&xr(c),h=0,i=u=a=c=r},x.flush=function(){return c===r?l:y(Ta())},x}var Ia=qi((function(t,e){return ci(t,1,e)})),Da=qi((function(t,e,n){return ci(t,vo(e)||0,n)}));function Oa(t,e){if("function"!=typeof t||null!=e&&"function"!=typeof e)throw new At(s);var n=function(){var i=arguments,r=e?e.apply(this,i):i[0],s=n.cache;if(s.has(r))return s.get(r);var a=t.apply(this,i);return n.cache=s.set(r,a)||s,a};return n.cache=new(Oa.Cache||Xn),n}function Na(t){if("function"!=typeof t)throw new At(s);return function(){var e=arguments;switch(e.length){case 0:return!t.call(this);case 1:return!t.call(this,e[0]);case 2:return!t.call(this,e[0],e[1]);case 3:return!t.call(this,e[0],e[1],e[2])}return!t.apply(this,e)}}Oa.Cache=Xn;var Ua=_r((function(t,e){var n=(e=1==e.length&&Wa(e[0])?Ee(e[0],He(as())):Ee(gi(e,1),He(as()))).length;return qi((function(i){for(var r=-1,s=_n(i.length,n);++r<s;)i[r]=e[r].call(this,i[r]);return ve(t,this,i)}))})),Fa=qi((function(t,e){var n=en(e,ss(Fa));return Zr(t,l,r,e,n)})),Ba=qi((function(t,e){var n=en(e,ss(Ba));return Zr(t,64,r,e,n)})),za=ts((function(t,e){return Zr(t,256,r,r,r,e)}));function ka(t,e){return t===e||t!=t&&e!=e}var Ga=Wr(Ei),Va=Wr((function(t,e){return t>=e})),Ha=Li(function(){return arguments}())?Li:function(t){return eo(t)&&Dt.call(t,"callee")&&!te.call(t,"callee")},Wa=i.isArray,ja=he?He(he):function(t){return eo(t)&&Si(t)==P};function Xa(t){return null!=t&&Qa(t.length)&&!Ka(t)}function Ya(t){return eo(t)&&Xa(t)}var qa=pn||vl,Za=de?He(de):function(t){return eo(t)&&Si(t)==_};function Ja(t){if(!eo(t))return!1;var e=Si(t);return e==y||"[object DOMException]"==e||"string"==typeof t.message&&"string"==typeof t.name&&!ro(t)}function Ka(t){if(!to(t))return!1;var e=Si(t);return e==x||e==b||"[object AsyncFunction]"==e||"[object Proxy]"==e}function $a(t){return"number"==typeof t&&t==mo(t)}function Qa(t){return"number"==typeof t&&t>-1&&t%1==0&&t<=h}function to(t){var e=typeof t;return null!=t&&("object"==e||"function"==e)}function eo(t){return null!=t&&"object"==typeof t}var no=pe?He(pe):function(t){return eo(t)&&ds(t)==M};function io(t){return"number"==typeof t||eo(t)&&Si(t)==w}function ro(t){if(!eo(t)||Si(t)!=S)return!1;var e=Xt(t);if(null===e)return!0;var n=Dt.call(e,"constructor")&&e.constructor;return"function"==typeof n&&n instanceof n&&It.call(n)==Ft}var so=fe?He(fe):function(t){return eo(t)&&Si(t)==T},ao=me?He(me):function(t){return eo(t)&&ds(t)==A};function oo(t){return"string"==typeof t||!Wa(t)&&eo(t)&&Si(t)==R}function lo(t){return"symbol"==typeof t||eo(t)&&Si(t)==C}var co=ge?He(ge):function(t){return eo(t)&&Qa(t.length)&&!!$t[Si(t)]},uo=Wr(Ui),ho=Wr((function(t,e){return t<=e}));function po(t){if(!t)return[];if(Xa(t))return oo(t)?an(t):Ar(t);if(ae&&t[ae])return function(t){for(var e,n=[];!(e=t.next()).done;)n.push(e.value);return n}(t[ae]());var e=ds(t);return(e==M?Qe:e==A?nn:Go)(t)}function fo(t){return t?(t=vo(t))===u||t===-1/0?17976931348623157e292*(t<0?-1:1):t==t?t:0:0===t?t:0}function mo(t){var e=fo(t),n=e%1;return e==e?n?e-n:e:0}function go(t){return t?ai(mo(t),0,p):0}function vo(t){if("number"==typeof t)return t;if(lo(t))return d;if(to(t)){var e="function"==typeof t.valueOf?t.valueOf():t;t=to(e)?e+"":e}if("string"!=typeof t)return 0===t?t:+t;t=Ve(t);var n=ft.test(t);return n||gt.test(t)?ne(t.slice(2),n?2:8):pt.test(t)?d:+t}function _o(t){return Rr(t,Do(t))}function yo(t){return null==t?"":or(t)}var xo=Lr((function(t,e){if(bs(e)||Xa(e))Rr(e,Io(e),t);else for(var n in e)Dt.call(e,n)&&ti(t,n,e[n])})),bo=Lr((function(t,e){Rr(e,Do(e),t)})),Mo=Lr((function(t,e,n,i){Rr(e,Do(e),t,i)})),wo=Lr((function(t,e,n,i){Rr(e,Io(e),t,i)})),So=ts(si),Eo=qi((function(t,e){t=St(t);var n=-1,i=e.length,s=i>2?e[2]:r;for(s&&vs(e[0],e[1],s)&&(i=1);++n<i;)for(var a=e[n],o=Do(a),l=-1,c=o.length;++l<c;){var u=o[l],h=t[u];(h===r||ka(h,Lt[u])&&!Dt.call(t,u))&&(t[u]=a[u])}return t})),To=qi((function(t){return t.push(r,Kr),ve(No,r,t)}));function Ao(t,e,n){var i=null==t?r:Mi(t,e);return i===r?n:i}function Ro(t,e){return null!=t&&ps(t,e,Ai)}var Co=zr((function(t,e,n){null!=e&&"function"!=typeof e.toString&&(e=Ut.call(e)),t[e]=n}),el(rl)),Lo=zr((function(t,e,n){null!=e&&"function"!=typeof e.toString&&(e=Ut.call(e)),Dt.call(t,e)?t[e].push(n):t[e]=[n]}),as),Po=qi(Ci);function Io(t){return Xa(t)?Zn(t):Ni(t)}function Do(t){return Xa(t)?Zn(t,!0):function(t){if(!to(t))return function(t){var e=[];if(null!=t)for(var n in St(t))e.push(n);return e}(t);var e=bs(t),n=[];for(var i in t)("constructor"!=i||!e&&Dt.call(t,i))&&n.push(i);return n}(t)}var Oo=Lr((function(t,e,n){ki(t,e,n)})),No=Lr((function(t,e,n,i){ki(t,e,n,i)})),Uo=ts((function(t,e){var n={};if(null==t)return n;var i=!1;e=Ee(e,(function(e){return e=vr(e,t),i||(i=e.length>1),e})),Rr(t,ns(t),n),i&&(n=oi(n,7,$r));for(var r=e.length;r--;)cr(n,e[r]);return n})),Fo=ts((function(t,e){return null==t?{}:function(t,e){return Hi(t,e,(function(e,n){return Ro(t,n)}))}(t,e)}));function Bo(t,e){if(null==t)return{};var n=Ee(ns(t),(function(t){return[t]}));return e=as(e),Hi(t,n,(function(t,n){return e(t,n[0])}))}var zo=qr(Io),ko=qr(Do);function Go(t){return null==t?[]:We(t,Io(t))}var Vo=Or((function(t,e,n){return e=e.toLowerCase(),t+(n?Ho(e):e)}));function Ho(t){return Ko(yo(t).toLowerCase())}function Wo(t){return(t=yo(t))&&t.replace(_t,Ze).replace(jt,"")}var jo=Or((function(t,e,n){return t+(n?"-":"")+e.toLowerCase()})),Xo=Or((function(t,e,n){return t+(n?" ":"")+e.toLowerCase()})),Yo=Dr("toLowerCase"),qo=Or((function(t,e,n){return t+(n?"_":"")+e.toLowerCase()})),Zo=Or((function(t,e,n){return t+(n?" ":"")+Ko(e)})),Jo=Or((function(t,e,n){return t+(n?" ":"")+e.toUpperCase()})),Ko=Dr("toUpperCase");function $o(t,e,n){return t=yo(t),(e=n?r:e)===r?function(t){return Zt.test(t)}(t)?function(t){return t.match(Yt)||[]}(t):function(t){return t.match(lt)||[]}(t):t.match(e)||[]}var Qo=qi((function(t,e){try{return ve(t,r,e)}catch(t){return Ja(t)?t:new bt(t)}})),tl=ts((function(t,e){return ye(e,(function(e){e=Fs(e),ri(t,e,Ca(t[e],t))})),t}));function el(t){return function(){return t}}var nl=Fr(),il=Fr(!0);function rl(t){return t}function sl(t){return Oi("function"==typeof t?t:oi(t,1))}var al=qi((function(t,e){return function(n){return Ci(n,t,e)}})),ol=qi((function(t,e){return function(n){return Ci(t,n,e)}}));function ll(t,e,n){var i=Io(e),r=bi(e,i);null!=n||to(e)&&(r.length||!i.length)||(n=e,e=t,t=this,r=bi(e,Io(e)));var s=!(to(n)&&"chain"in n&&!n.chain),a=Ka(t);return ye(r,(function(n){var i=e[n];t[n]=i,a&&(t.prototype[n]=function(){var e=this.__chain__;if(s||e){var n=t(this.__wrapped__),r=n.__actions__=Ar(this.__actions__);return r.push({func:i,args:arguments,thisArg:t}),n.__chain__=e,n}return i.apply(t,Te([this.value()],arguments))})})),t}function cl(){}var ul=Gr(Ee),hl=Gr(be),dl=Gr(Ce);function pl(t){return _s(t)?Fe(Fs(t)):function(t){return function(e){return Mi(e,t)}}(t)}var fl=Hr(),ml=Hr(!0);function gl(){return[]}function vl(){return!1}var _l,yl=kr((function(t,e){return t+e}),0),xl=Xr("ceil"),bl=kr((function(t,e){return t/e}),1),Ml=Xr("floor"),wl=kr((function(t,e){return t*e}),1),Sl=Xr("round"),El=kr((function(t,e){return t-e}),0);return zn.after=function(t,e){if("function"!=typeof e)throw new At(s);return t=mo(t),function(){if(--t<1)return e.apply(this,arguments)}},zn.ary=Aa,zn.assign=xo,zn.assignIn=bo,zn.assignInWith=Mo,zn.assignWith=wo,zn.at=So,zn.before=Ra,zn.bind=Ca,zn.bindAll=tl,zn.bindKey=La,zn.castArray=function(){if(!arguments.length)return[];var t=arguments[0];return Wa(t)?t:[t]},zn.chain=da,zn.chunk=function(t,e,n){e=(n?vs(t,e,n):e===r)?1:vn(mo(e),0);var s=null==t?0:t.length;if(!s||e<1)return[];for(var a=0,o=0,l=i(un(s/e));a<s;)l[o++]=er(t,a,a+=e);return l},zn.compact=function(t){for(var e=-1,n=null==t?0:t.length,i=0,r=[];++e<n;){var s=t[e];s&&(r[i++]=s)}return r},zn.concat=function(){var t=arguments.length;if(!t)return[];for(var e=i(t-1),n=arguments[0],r=t;r--;)e[r-1]=arguments[r];return Te(Wa(n)?Ar(n):[n],gi(e,1))},zn.cond=function(t){var e=null==t?0:t.length,n=as();return t=e?Ee(t,(function(t){if("function"!=typeof t[1])throw new At(s);return[n(t[0]),t[1]]})):[],qi((function(n){for(var i=-1;++i<e;){var r=t[i];if(ve(r[0],this,n))return ve(r[1],this,n)}}))},zn.conforms=function(t){return function(t){var e=Io(t);return function(n){return li(n,t,e)}}(oi(t,1))},zn.constant=el,zn.countBy=ma,zn.create=function(t,e){var n=kn(t);return null==e?n:ii(n,e)},zn.curry=function t(e,n,i){var s=Zr(e,8,r,r,r,r,r,n=i?r:n);return s.placeholder=t.placeholder,s},zn.curryRight=function t(e,n,i){var s=Zr(e,16,r,r,r,r,r,n=i?r:n);return s.placeholder=t.placeholder,s},zn.debounce=Pa,zn.defaults=Eo,zn.defaultsDeep=To,zn.defer=Ia,zn.delay=Da,zn.difference=ks,zn.differenceBy=Gs,zn.differenceWith=Vs,zn.drop=function(t,e,n){var i=null==t?0:t.length;return i?er(t,(e=n||e===r?1:mo(e))<0?0:e,i):[]},zn.dropRight=function(t,e,n){var i=null==t?0:t.length;return i?er(t,0,(e=i-(e=n||e===r?1:mo(e)))<0?0:e):[]},zn.dropRightWhile=function(t,e){return t&&t.length?hr(t,as(e,3),!0,!0):[]},zn.dropWhile=function(t,e){return t&&t.length?hr(t,as(e,3),!0):[]},zn.fill=function(t,e,n,i){var s=null==t?0:t.length;return s?(n&&"number"!=typeof n&&vs(t,e,n)&&(n=0,i=s),function(t,e,n,i){var s=t.length;for((n=mo(n))<0&&(n=-n>s?0:s+n),(i=i===r||i>s?s:mo(i))<0&&(i+=s),i=n>i?0:go(i);n<i;)t[n++]=e;return t}(t,e,n,i)):[]},zn.filter=function(t,e){return(Wa(t)?Me:mi)(t,as(e,3))},zn.flatMap=function(t,e){return gi(wa(t,e),1)},zn.flatMapDeep=function(t,e){return gi(wa(t,e),u)},zn.flatMapDepth=function(t,e,n){return n=n===r?1:mo(n),gi(wa(t,e),n)},zn.flatten=js,zn.flattenDeep=function(t){return null!=t&&t.length?gi(t,u):[]},zn.flattenDepth=function(t,e){return null!=t&&t.length?gi(t,e=e===r?1:mo(e)):[]},zn.flip=function(t){return Zr(t,512)},zn.flow=nl,zn.flowRight=il,zn.fromPairs=function(t){for(var e=-1,n=null==t?0:t.length,i={};++e<n;){var r=t[e];i[r[0]]=r[1]}return i},zn.functions=function(t){return null==t?[]:bi(t,Io(t))},zn.functionsIn=function(t){return null==t?[]:bi(t,Do(t))},zn.groupBy=xa,zn.initial=function(t){return null!=t&&t.length?er(t,0,-1):[]},zn.intersection=Ys,zn.intersectionBy=qs,zn.intersectionWith=Zs,zn.invert=Co,zn.invertBy=Lo,zn.invokeMap=ba,zn.iteratee=sl,zn.keyBy=Ma,zn.keys=Io,zn.keysIn=Do,zn.map=wa,zn.mapKeys=function(t,e){var n={};return e=as(e,3),yi(t,(function(t,i,r){ri(n,e(t,i,r),t)})),n},zn.mapValues=function(t,e){var n={};return e=as(e,3),yi(t,(function(t,i,r){ri(n,i,e(t,i,r))})),n},zn.matches=function(t){return Bi(oi(t,1))},zn.matchesProperty=function(t,e){return zi(t,oi(e,1))},zn.memoize=Oa,zn.merge=Oo,zn.mergeWith=No,zn.method=al,zn.methodOf=ol,zn.mixin=ll,zn.negate=Na,zn.nthArg=function(t){return t=mo(t),qi((function(e){return Gi(e,t)}))},zn.omit=Uo,zn.omitBy=function(t,e){return Bo(t,Na(as(e)))},zn.once=function(t){return Ra(2,t)},zn.orderBy=function(t,e,n,i){return null==t?[]:(Wa(e)||(e=null==e?[]:[e]),Wa(n=i?r:n)||(n=null==n?[]:[n]),Vi(t,e,n))},zn.over=ul,zn.overArgs=Ua,zn.overEvery=hl,zn.overSome=dl,zn.partial=Fa,zn.partialRight=Ba,zn.partition=Sa,zn.pick=Fo,zn.pickBy=Bo,zn.property=pl,zn.propertyOf=function(t){return function(e){return null==t?r:Mi(t,e)}},zn.pull=Ks,zn.pullAll=$s,zn.pullAllBy=function(t,e,n){return t&&t.length&&e&&e.length?Wi(t,e,as(n,2)):t},zn.pullAllWith=function(t,e,n){return t&&t.length&&e&&e.length?Wi(t,e,r,n):t},zn.pullAt=Qs,zn.range=fl,zn.rangeRight=ml,zn.rearg=za,zn.reject=function(t,e){return(Wa(t)?Me:mi)(t,Na(as(e,3)))},zn.remove=function(t,e){var n=[];if(!t||!t.length)return n;var i=-1,r=[],s=t.length;for(e=as(e,3);++i<s;){var a=t[i];e(a,i,t)&&(n.push(a),r.push(i))}return ji(t,r),n},zn.rest=function(t,e){if("function"!=typeof t)throw new At(s);return qi(t,e=e===r?e:mo(e))},zn.reverse=ta,zn.sampleSize=function(t,e,n){return e=(n?vs(t,e,n):e===r)?1:mo(e),(Wa(t)?Kn:Ji)(t,e)},zn.set=function(t,e,n){return null==t?t:Ki(t,e,n)},zn.setWith=function(t,e,n,i){return i="function"==typeof i?i:r,null==t?t:Ki(t,e,n,i)},zn.shuffle=function(t){return(Wa(t)?$n:tr)(t)},zn.slice=function(t,e,n){var i=null==t?0:t.length;return i?(n&&"number"!=typeof n&&vs(t,e,n)?(e=0,n=i):(e=null==e?0:mo(e),n=n===r?i:mo(n)),er(t,e,n)):[]},zn.sortBy=Ea,zn.sortedUniq=function(t){return t&&t.length?sr(t):[]},zn.sortedUniqBy=function(t,e){return t&&t.length?sr(t,as(e,2)):[]},zn.split=function(t,e,n){return n&&"number"!=typeof n&&vs(t,e,n)&&(e=n=r),(n=n===r?p:n>>>0)?(t=yo(t))&&("string"==typeof e||null!=e&&!so(e))&&!(e=or(e))&&$e(t)?yr(an(t),0,n):t.split(e,n):[]},zn.spread=function(t,e){if("function"!=typeof t)throw new At(s);return e=null==e?0:vn(mo(e),0),qi((function(n){var i=n[e],r=yr(n,0,e);return i&&Te(r,i),ve(t,this,r)}))},zn.tail=function(t){var e=null==t?0:t.length;return e?er(t,1,e):[]},zn.take=function(t,e,n){return t&&t.length?er(t,0,(e=n||e===r?1:mo(e))<0?0:e):[]},zn.takeRight=function(t,e,n){var i=null==t?0:t.length;return i?er(t,(e=i-(e=n||e===r?1:mo(e)))<0?0:e,i):[]},zn.takeRightWhile=function(t,e){return t&&t.length?hr(t,as(e,3),!1,!0):[]},zn.takeWhile=function(t,e){return t&&t.length?hr(t,as(e,3)):[]},zn.tap=function(t,e){return e(t),t},zn.throttle=function(t,e,n){var i=!0,r=!0;if("function"!=typeof t)throw new At(s);return to(n)&&(i="leading"in n?!!n.leading:i,r="trailing"in n?!!n.trailing:r),Pa(t,e,{leading:i,maxWait:e,trailing:r})},zn.thru=pa,zn.toArray=po,zn.toPairs=zo,zn.toPairsIn=ko,zn.toPath=function(t){return Wa(t)?Ee(t,Fs):lo(t)?[t]:Ar(Us(yo(t)))},zn.toPlainObject=_o,zn.transform=function(t,e,n){var i=Wa(t),r=i||qa(t)||co(t);if(e=as(e,4),null==n){var s=t&&t.constructor;n=r?i?new s:[]:to(t)&&Ka(s)?kn(Xt(t)):{}}return(r?ye:yi)(t,(function(t,i,r){return e(n,t,i,r)})),n},zn.unary=function(t){return Aa(t,1)},zn.union=ea,zn.unionBy=na,zn.unionWith=ia,zn.uniq=function(t){return t&&t.length?lr(t):[]},zn.uniqBy=function(t,e){return t&&t.length?lr(t,as(e,2)):[]},zn.uniqWith=function(t,e){return e="function"==typeof e?e:r,t&&t.length?lr(t,r,e):[]},zn.unset=function(t,e){return null==t||cr(t,e)},zn.unzip=ra,zn.unzipWith=sa,zn.update=function(t,e,n){return null==t?t:ur(t,e,gr(n))},zn.updateWith=function(t,e,n,i){return i="function"==typeof i?i:r,null==t?t:ur(t,e,gr(n),i)},zn.values=Go,zn.valuesIn=function(t){return null==t?[]:We(t,Do(t))},zn.without=aa,zn.words=$o,zn.wrap=function(t,e){return Fa(gr(e),t)},zn.xor=oa,zn.xorBy=la,zn.xorWith=ca,zn.zip=ua,zn.zipObject=function(t,e){return fr(t||[],e||[],ti)},zn.zipObjectDeep=function(t,e){return fr(t||[],e||[],Ki)},zn.zipWith=ha,zn.entries=zo,zn.entriesIn=ko,zn.extend=bo,zn.extendWith=Mo,ll(zn,zn),zn.add=yl,zn.attempt=Qo,zn.camelCase=Vo,zn.capitalize=Ho,zn.ceil=xl,zn.clamp=function(t,e,n){return n===r&&(n=e,e=r),n!==r&&(n=(n=vo(n))==n?n:0),e!==r&&(e=(e=vo(e))==e?e:0),ai(vo(t),e,n)},zn.clone=function(t){return oi(t,4)},zn.cloneDeep=function(t){return oi(t,5)},zn.cloneDeepWith=function(t,e){return oi(t,5,e="function"==typeof e?e:r)},zn.cloneWith=function(t,e){return oi(t,4,e="function"==typeof e?e:r)},zn.conformsTo=function(t,e){return null==e||li(t,e,Io(e))},zn.deburr=Wo,zn.defaultTo=function(t,e){return null==t||t!=t?e:t},zn.divide=bl,zn.endsWith=function(t,e,n){t=yo(t),e=or(e);var i=t.length,s=n=n===r?i:ai(mo(n),0,i);return(n-=e.length)>=0&&t.slice(n,s)==e},zn.eq=ka,zn.escape=function(t){return(t=yo(t))&&q.test(t)?t.replace(X,Je):t},zn.escapeRegExp=function(t){return(t=yo(t))&&nt.test(t)?t.replace(et,"\\$&"):t},zn.every=function(t,e,n){var i=Wa(t)?be:pi;return n&&vs(t,e,n)&&(e=r),i(t,as(e,3))},zn.find=ga,zn.findIndex=Hs,zn.findKey=function(t,e){return Pe(t,as(e,3),yi)},zn.findLast=va,zn.findLastIndex=Ws,zn.findLastKey=function(t,e){return Pe(t,as(e,3),xi)},zn.floor=Ml,zn.forEach=_a,zn.forEachRight=ya,zn.forIn=function(t,e){return null==t?t:vi(t,as(e,3),Do)},zn.forInRight=function(t,e){return null==t?t:_i(t,as(e,3),Do)},zn.forOwn=function(t,e){return t&&yi(t,as(e,3))},zn.forOwnRight=function(t,e){return t&&xi(t,as(e,3))},zn.get=Ao,zn.gt=Ga,zn.gte=Va,zn.has=function(t,e){return null!=t&&ps(t,e,Ti)},zn.hasIn=Ro,zn.head=Xs,zn.identity=rl,zn.includes=function(t,e,n,i){t=Xa(t)?t:Go(t),n=n&&!i?mo(n):0;var r=t.length;return n<0&&(n=vn(r+n,0)),oo(t)?n<=r&&t.indexOf(e,n)>-1:!!r&&De(t,e,n)>-1},zn.indexOf=function(t,e,n){var i=null==t?0:t.length;if(!i)return-1;var r=null==n?0:mo(n);return r<0&&(r=vn(i+r,0)),De(t,e,r)},zn.inRange=function(t,e,n){return e=fo(e),n===r?(n=e,e=0):n=fo(n),function(t,e,n){return t>=_n(e,n)&&t<vn(e,n)}(t=vo(t),e,n)},zn.invoke=Po,zn.isArguments=Ha,zn.isArray=Wa,zn.isArrayBuffer=ja,zn.isArrayLike=Xa,zn.isArrayLikeObject=Ya,zn.isBoolean=function(t){return!0===t||!1===t||eo(t)&&Si(t)==v},zn.isBuffer=qa,zn.isDate=Za,zn.isElement=function(t){return eo(t)&&1===t.nodeType&&!ro(t)},zn.isEmpty=function(t){if(null==t)return!0;if(Xa(t)&&(Wa(t)||"string"==typeof t||"function"==typeof t.splice||qa(t)||co(t)||Ha(t)))return!t.length;var e=ds(t);if(e==M||e==A)return!t.size;if(bs(t))return!Ni(t).length;for(var n in t)if(Dt.call(t,n))return!1;return!0},zn.isEqual=function(t,e){return Pi(t,e)},zn.isEqualWith=function(t,e,n){var i=(n="function"==typeof n?n:r)?n(t,e):r;return i===r?Pi(t,e,r,n):!!i},zn.isError=Ja,zn.isFinite=function(t){return"number"==typeof t&&fn(t)},zn.isFunction=Ka,zn.isInteger=$a,zn.isLength=Qa,zn.isMap=no,zn.isMatch=function(t,e){return t===e||Ii(t,e,ls(e))},zn.isMatchWith=function(t,e,n){return n="function"==typeof n?n:r,Ii(t,e,ls(e),n)},zn.isNaN=function(t){return io(t)&&t!=+t},zn.isNative=function(t){if(xs(t))throw new bt("Unsupported core-js use. Try https://npms.io/search?q=ponyfill.");return Di(t)},zn.isNil=function(t){return null==t},zn.isNull=function(t){return null===t},zn.isNumber=io,zn.isObject=to,zn.isObjectLike=eo,zn.isPlainObject=ro,zn.isRegExp=so,zn.isSafeInteger=function(t){return $a(t)&&t>=-9007199254740991&&t<=h},zn.isSet=ao,zn.isString=oo,zn.isSymbol=lo,zn.isTypedArray=co,zn.isUndefined=function(t){return t===r},zn.isWeakMap=function(t){return eo(t)&&ds(t)==L},zn.isWeakSet=function(t){return eo(t)&&"[object WeakSet]"==Si(t)},zn.join=function(t,e){return null==t?"":mn.call(t,e)},zn.kebabCase=jo,zn.last=Js,zn.lastIndexOf=function(t,e,n){var i=null==t?0:t.length;if(!i)return-1;var s=i;return n!==r&&(s=(s=mo(n))<0?vn(i+s,0):_n(s,i-1)),e==e?function(t,e,n){for(var i=n+1;i--;)if(t[i]===e)return i;return i}(t,e,s):Ie(t,Ne,s,!0)},zn.lowerCase=Xo,zn.lowerFirst=Yo,zn.lt=uo,zn.lte=ho,zn.max=function(t){return t&&t.length?fi(t,rl,Ei):r},zn.maxBy=function(t,e){return t&&t.length?fi(t,as(e,2),Ei):r},zn.mean=function(t){return Ue(t,rl)},zn.meanBy=function(t,e){return Ue(t,as(e,2))},zn.min=function(t){return t&&t.length?fi(t,rl,Ui):r},zn.minBy=function(t,e){return t&&t.length?fi(t,as(e,2),Ui):r},zn.stubArray=gl,zn.stubFalse=vl,zn.stubObject=function(){return{}},zn.stubString=function(){return""},zn.stubTrue=function(){return!0},zn.multiply=wl,zn.nth=function(t,e){return t&&t.length?Gi(t,mo(e)):r},zn.noConflict=function(){return se._===this&&(se._=Bt),this},zn.noop=cl,zn.now=Ta,zn.pad=function(t,e,n){t=yo(t);var i=(e=mo(e))?sn(t):0;if(!e||i>=e)return t;var r=(e-i)/2;return Vr(hn(r),n)+t+Vr(un(r),n)},zn.padEnd=function(t,e,n){t=yo(t);var i=(e=mo(e))?sn(t):0;return e&&i<e?t+Vr(e-i,n):t},zn.padStart=function(t,e,n){t=yo(t);var i=(e=mo(e))?sn(t):0;return e&&i<e?Vr(e-i,n)+t:t},zn.parseInt=function(t,e,n){return n||null==e?e=0:e&&(e=+e),xn(yo(t).replace(it,""),e||0)},zn.random=function(t,e,n){if(n&&"boolean"!=typeof n&&vs(t,e,n)&&(e=n=r),n===r&&("boolean"==typeof e?(n=e,e=r):"boolean"==typeof t&&(n=t,t=r)),t===r&&e===r?(t=0,e=1):(t=fo(t),e===r?(e=t,t=0):e=fo(e)),t>e){var i=t;t=e,e=i}if(n||t%1||e%1){var s=bn();return _n(t+s*(e-t+ee("1e-"+((s+"").length-1))),e)}return Xi(t,e)},zn.reduce=function(t,e,n){var i=Wa(t)?Ae:ze,r=arguments.length<3;return i(t,as(e,4),n,r,hi)},zn.reduceRight=function(t,e,n){var i=Wa(t)?Re:ze,r=arguments.length<3;return i(t,as(e,4),n,r,di)},zn.repeat=function(t,e,n){return e=(n?vs(t,e,n):e===r)?1:mo(e),Yi(yo(t),e)},zn.replace=function(){var t=arguments,e=yo(t[0]);return t.length<3?e:e.replace(t[1],t[2])},zn.result=function(t,e,n){var i=-1,s=(e=vr(e,t)).length;for(s||(s=1,t=r);++i<s;){var a=null==t?r:t[Fs(e[i])];a===r&&(i=s,a=n),t=Ka(a)?a.call(t):a}return t},zn.round=Sl,zn.runInContext=t,zn.sample=function(t){return(Wa(t)?Jn:Zi)(t)},zn.size=function(t){if(null==t)return 0;if(Xa(t))return oo(t)?sn(t):t.length;var e=ds(t);return e==M||e==A?t.size:Ni(t).length},zn.snakeCase=qo,zn.some=function(t,e,n){var i=Wa(t)?Ce:nr;return n&&vs(t,e,n)&&(e=r),i(t,as(e,3))},zn.sortedIndex=function(t,e){return ir(t,e)},zn.sortedIndexBy=function(t,e,n){return rr(t,e,as(n,2))},zn.sortedIndexOf=function(t,e){var n=null==t?0:t.length;if(n){var i=ir(t,e);if(i<n&&ka(t[i],e))return i}return-1},zn.sortedLastIndex=function(t,e){return ir(t,e,!0)},zn.sortedLastIndexBy=function(t,e,n){return rr(t,e,as(n,2),!0)},zn.sortedLastIndexOf=function(t,e){if(null!=t&&t.length){var n=ir(t,e,!0)-1;if(ka(t[n],e))return n}return-1},zn.startCase=Zo,zn.startsWith=function(t,e,n){return t=yo(t),n=null==n?0:ai(mo(n),0,t.length),e=or(e),t.slice(n,n+e.length)==e},zn.subtract=El,zn.sum=function(t){return t&&t.length?ke(t,rl):0},zn.sumBy=function(t,e){return t&&t.length?ke(t,as(e,2)):0},zn.template=function(t,e,n){var i=zn.templateSettings;n&&vs(t,e,n)&&(e=r),t=yo(t),e=Mo({},e,i,Jr);var s,a,o=Mo({},e.imports,i.imports,Jr),l=Io(o),c=We(o,l),u=0,h=e.interpolate||yt,d="__p += '",p=Et((e.escape||yt).source+"|"+h.source+"|"+(h===K?ht:yt).source+"|"+(e.evaluate||yt).source+"|$","g"),f="//# sourceURL="+(Dt.call(e,"sourceURL")?(e.sourceURL+"").replace(/\s/g," "):"lodash.templateSources["+ ++Kt+"]")+"\n";t.replace(p,(function(e,n,i,r,o,l){return i||(i=r),d+=t.slice(u,l).replace(xt,Ke),n&&(s=!0,d+="' +\n__e("+n+") +\n'"),o&&(a=!0,d+="';\n"+o+";\n__p += '"),i&&(d+="' +\n((__t = ("+i+")) == null ? '' : __t) +\n'"),u=l+e.length,e})),d+="';\n";var m=Dt.call(e,"variable")&&e.variable;if(m){if(ct.test(m))throw new bt("Invalid `variable` option passed into `_.template`")}else d="with (obj) {\n"+d+"\n}\n";d=(a?d.replace(V,""):d).replace(H,"$1").replace(W,"$1;"),d="function("+(m||"obj")+") {\n"+(m?"":"obj || (obj = {});\n")+"var __t, __p = ''"+(s?", __e = _.escape":"")+(a?", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n":";\n")+d+"return __p\n}";var g=Qo((function(){return Mt(l,f+"return "+d).apply(r,c)}));if(g.source=d,Ja(g))throw g;return g},zn.times=function(t,e){if((t=mo(t))<1||t>h)return[];var n=p,i=_n(t,p);e=as(e),t-=p;for(var r=Ge(i,e);++n<t;)e(n);return r},zn.toFinite=fo,zn.toInteger=mo,zn.toLength=go,zn.toLower=function(t){return yo(t).toLowerCase()},zn.toNumber=vo,zn.toSafeInteger=function(t){return t?ai(mo(t),-9007199254740991,h):0===t?t:0},zn.toString=yo,zn.toUpper=function(t){return yo(t).toUpperCase()},zn.trim=function(t,e,n){if((t=yo(t))&&(n||e===r))return Ve(t);if(!t||!(e=or(e)))return t;var i=an(t),s=an(e);return yr(i,Xe(i,s),Ye(i,s)+1).join("")},zn.trimEnd=function(t,e,n){if((t=yo(t))&&(n||e===r))return t.slice(0,on(t)+1);if(!t||!(e=or(e)))return t;var i=an(t);return yr(i,0,Ye(i,an(e))+1).join("")},zn.trimStart=function(t,e,n){if((t=yo(t))&&(n||e===r))return t.replace(it,"");if(!t||!(e=or(e)))return t;var i=an(t);return yr(i,Xe(i,an(e))).join("")},zn.truncate=function(t,e){var n=30,i="...";if(to(e)){var s="separator"in e?e.separator:s;n="length"in e?mo(e.length):n,i="omission"in e?or(e.omission):i}var a=(t=yo(t)).length;if($e(t)){var o=an(t);a=o.length}if(n>=a)return t;var l=n-sn(i);if(l<1)return i;var c=o?yr(o,0,l).join(""):t.slice(0,l);if(s===r)return c+i;if(o&&(l+=c.length-l),so(s)){if(t.slice(l).search(s)){var u,h=c;for(s.global||(s=Et(s.source,yo(dt.exec(s))+"g")),s.lastIndex=0;u=s.exec(h);)var d=u.index;c=c.slice(0,d===r?l:d)}}else if(t.indexOf(or(s),l)!=l){var p=c.lastIndexOf(s);p>-1&&(c=c.slice(0,p))}return c+i},zn.unescape=function(t){return(t=yo(t))&&Y.test(t)?t.replace(j,ln):t},zn.uniqueId=function(t){var e=++Ot;return yo(t)+e},zn.upperCase=Jo,zn.upperFirst=Ko,zn.each=_a,zn.eachRight=ya,zn.first=Xs,ll(zn,(_l={},yi(zn,(function(t,e){Dt.call(zn.prototype,e)||(_l[e]=t)})),_l),{chain:!1}),zn.VERSION="4.17.21",ye(["bind","bindKey","curry","curryRight","partial","partialRight"],(function(t){zn[t].placeholder=zn})),ye(["drop","take"],(function(t,e){Hn.prototype[t]=function(n){n=n===r?1:vn(mo(n),0);var i=this.__filtered__&&!e?new Hn(this):this.clone();return i.__filtered__?i.__takeCount__=_n(n,i.__takeCount__):i.__views__.push({size:_n(n,p),type:t+(i.__dir__<0?"Right":"")}),i},Hn.prototype[t+"Right"]=function(e){return this.reverse()[t](e).reverse()}})),ye(["filter","map","takeWhile"],(function(t,e){var n=e+1,i=1==n||3==n;Hn.prototype[t]=function(t){var e=this.clone();return e.__iteratees__.push({iteratee:as(t,3),type:n}),e.__filtered__=e.__filtered__||i,e}})),ye(["head","last"],(function(t,e){var n="take"+(e?"Right":"");Hn.prototype[t]=function(){return this[n](1).value()[0]}})),ye(["initial","tail"],(function(t,e){var n="drop"+(e?"":"Right");Hn.prototype[t]=function(){return this.__filtered__?new Hn(this):this[n](1)}})),Hn.prototype.compact=function(){return this.filter(rl)},Hn.prototype.find=function(t){return this.filter(t).head()},Hn.prototype.findLast=function(t){return this.reverse().find(t)},Hn.prototype.invokeMap=qi((function(t,e){return"function"==typeof t?new Hn(this):this.map((function(n){return Ci(n,t,e)}))})),Hn.prototype.reject=function(t){return this.filter(Na(as(t)))},Hn.prototype.slice=function(t,e){t=mo(t);var n=this;return n.__filtered__&&(t>0||e<0)?new Hn(n):(t<0?n=n.takeRight(-t):t&&(n=n.drop(t)),e!==r&&(n=(e=mo(e))<0?n.dropRight(-e):n.take(e-t)),n)},Hn.prototype.takeRightWhile=function(t){return this.reverse().takeWhile(t).reverse()},Hn.prototype.toArray=function(){return this.take(p)},yi(Hn.prototype,(function(t,e){var n=/^(?:filter|find|map|reject)|While$/.test(e),i=/^(?:head|last)$/.test(e),s=zn[i?"take"+("last"==e?"Right":""):e],a=i||/^find/.test(e);s&&(zn.prototype[e]=function(){var e=this.__wrapped__,o=i?[1]:arguments,l=e instanceof Hn,c=o[0],u=l||Wa(e),h=function(t){var e=s.apply(zn,Te([t],o));return i&&d?e[0]:e};u&&n&&"function"==typeof c&&1!=c.length&&(l=u=!1);var d=this.__chain__,p=!!this.__actions__.length,f=a&&!d,m=l&&!p;if(!a&&u){e=m?e:new Hn(this);var g=t.apply(e,o);return g.__actions__.push({func:pa,args:[h],thisArg:r}),new Vn(g,d)}return f&&m?t.apply(this,o):(g=this.thru(h),f?i?g.value()[0]:g.value():g)})})),ye(["pop","push","shift","sort","splice","unshift"],(function(t){var e=Rt[t],n=/^(?:push|sort|unshift)$/.test(t)?"tap":"thru",i=/^(?:pop|shift)$/.test(t);zn.prototype[t]=function(){var t=arguments;if(i&&!this.__chain__){var r=this.value();return e.apply(Wa(r)?r:[],t)}return this[n]((function(n){return e.apply(Wa(n)?n:[],t)}))}})),yi(Hn.prototype,(function(t,e){var n=zn[e];if(n){var i=n.name+"";Dt.call(Ln,i)||(Ln[i]=[]),Ln[i].push({name:e,func:n})}})),Ln[Br(r,2).name]=[{name:"wrapper",func:r}],Hn.prototype.clone=function(){var t=new Hn(this.__wrapped__);return t.__actions__=Ar(this.__actions__),t.__dir__=this.__dir__,t.__filtered__=this.__filtered__,t.__iteratees__=Ar(this.__iteratees__),t.__takeCount__=this.__takeCount__,t.__views__=Ar(this.__views__),t},Hn.prototype.reverse=function(){if(this.__filtered__){var t=new Hn(this);t.__dir__=-1,t.__filtered__=!0}else(t=this.clone()).__dir__*=-1;return t},Hn.prototype.value=function(){var t=this.__wrapped__.value(),e=this.__dir__,n=Wa(t),i=e<0,r=n?t.length:0,s=function(t,e,n){for(var i=-1,r=n.length;++i<r;){var s=n[i],a=s.size;switch(s.type){case"drop":t+=a;break;case"dropRight":e-=a;break;case"take":e=_n(e,t+a);break;case"takeRight":t=vn(t,e-a)}}return{start:t,end:e}}(0,r,this.__views__),a=s.start,o=s.end,l=o-a,c=i?o:a-1,u=this.__iteratees__,h=u.length,d=0,p=_n(l,this.__takeCount__);if(!n||!i&&r==l&&p==l)return dr(t,this.__actions__);var f=[];t:for(;l--&&d<p;){for(var m=-1,g=t[c+=e];++m<h;){var v=u[m],_=v.iteratee,y=v.type,x=_(g);if(2==y)g=x;else if(!x){if(1==y)continue t;break t}}f[d++]=g}return f},zn.prototype.at=fa,zn.prototype.chain=function(){return da(this)},zn.prototype.commit=function(){return new Vn(this.value(),this.__chain__)},zn.prototype.next=function(){this.__values__===r&&(this.__values__=po(this.value()));var t=this.__index__>=this.__values__.length;return{done:t,value:t?r:this.__values__[this.__index__++]}},zn.prototype.plant=function(t){for(var e,n=this;n instanceof Gn;){var i=zs(n);i.__index__=0,i.__values__=r,e?s.__wrapped__=i:e=i;var s=i;n=n.__wrapped__}return s.__wrapped__=t,e},zn.prototype.reverse=function(){var t=this.__wrapped__;if(t instanceof Hn){var e=t;return this.__actions__.length&&(e=new Hn(this)),(e=e.reverse()).__actions__.push({func:pa,args:[ta],thisArg:r}),new Vn(e,this.__chain__)}return this.thru(ta)},zn.prototype.toJSON=zn.prototype.valueOf=zn.prototype.value=function(){return dr(this.__wrapped__,this.__actions__)},zn.prototype.first=zn.prototype.head,ae&&(zn.prototype[ae]=function(){return this}),zn}();se._=cn,(i=function(){return cn}.call(e,n,e,t))===r||(t.exports=i)}.call(this)},146:t=>{"use strict";t.exports=e},325:e=>{"use strict";e.exports=t},232:(t,e)=>{"use strict";Object.defineProperty(e,"__esModule",{value:!0});const n="142",i=100,r=300,s=301,a=302,o=303,l=304,c=306,u=1e3,h=1001,d=1002,p=1003,f=1004,m=1005,g=1006,v=1007,_=1008,y=1009,x=1012,b=1014,M=1015,w=1016,S=1020,E=1023,T=1026,A=1027,R=33776,C=33777,L=33778,P=33779,I=35840,D=35841,O=35842,N=35843,U=37492,F=37496,B=37808,z=37809,k=37810,G=37811,V=37812,H=37813,W=37814,j=37815,X=37816,Y=37817,q=37818,Z=37819,J=37820,K=37821,$=36492,Q=2300,tt=2301,et=2302,nt=2400,it=2401,rt=2402,st=2501,at=3e3,ot=3001,lt="srgb",ct="srgb-linear",ut=7680,ht=35044,dt="300 es",pt=1035;class ft{addEventListener(t,e){void 0===this._listeners&&(this._listeners={});const n=this._listeners;void 0===n[t]&&(n[t]=[]),-1===n[t].indexOf(e)&&n[t].push(e)}hasEventListener(t,e){if(void 0===this._listeners)return!1;const n=this._listeners;return void 0!==n[t]&&-1!==n[t].indexOf(e)}removeEventListener(t,e){if(void 0===this._listeners)return;const n=this._listeners[t];if(void 0!==n){const t=n.indexOf(e);-1!==t&&n.splice(t,1)}}dispatchEvent(t){if(void 0===this._listeners)return;const e=this._listeners[t.type];if(void 0!==e){t.target=this;const n=e.slice(0);for(let e=0,i=n.length;e<i;e++)n[e].call(this,t);t.target=null}}}const mt=["00","01","02","03","04","05","06","07","08","09","0a","0b","0c","0d","0e","0f","10","11","12","13","14","15","16","17","18","19","1a","1b","1c","1d","1e","1f","20","21","22","23","24","25","26","27","28","29","2a","2b","2c","2d","2e","2f","30","31","32","33","34","35","36","37","38","39","3a","3b","3c","3d","3e","3f","40","41","42","43","44","45","46","47","48","49","4a","4b","4c","4d","4e","4f","50","51","52","53","54","55","56","57","58","59","5a","5b","5c","5d","5e","5f","60","61","62","63","64","65","66","67","68","69","6a","6b","6c","6d","6e","6f","70","71","72","73","74","75","76","77","78","79","7a","7b","7c","7d","7e","7f","80","81","82","83","84","85","86","87","88","89","8a","8b","8c","8d","8e","8f","90","91","92","93","94","95","96","97","98","99","9a","9b","9c","9d","9e","9f","a0","a1","a2","a3","a4","a5","a6","a7","a8","a9","aa","ab","ac","ad","ae","af","b0","b1","b2","b3","b4","b5","b6","b7","b8","b9","ba","bb","bc","bd","be","bf","c0","c1","c2","c3","c4","c5","c6","c7","c8","c9","ca","cb","cc","cd","ce","cf","d0","d1","d2","d3","d4","d5","d6","d7","d8","d9","da","db","dc","dd","de","df","e0","e1","e2","e3","e4","e5","e6","e7","e8","e9","ea","eb","ec","ed","ee","ef","f0","f1","f2","f3","f4","f5","f6","f7","f8","f9","fa","fb","fc","fd","fe","ff"];let gt=1234567;const vt=Math.PI/180,_t=180/Math.PI;function yt(){const t=4294967295*Math.random()|0,e=4294967295*Math.random()|0,n=4294967295*Math.random()|0,i=4294967295*Math.random()|0;return(mt[255&t]+mt[t>>8&255]+mt[t>>16&255]+mt[t>>24&255]+"-"+mt[255&e]+mt[e>>8&255]+"-"+mt[e>>16&15|64]+mt[e>>24&255]+"-"+mt[63&n|128]+mt[n>>8&255]+"-"+mt[n>>16&255]+mt[n>>24&255]+mt[255&i]+mt[i>>8&255]+mt[i>>16&255]+mt[i>>24&255]).toLowerCase()}function xt(t,e,n){return Math.max(e,Math.min(n,t))}function bt(t,e){return(t%e+e)%e}function Mt(t,e,n){return(1-n)*t+n*e}function wt(t){return 0==(t&t-1)&&0!==t}function St(t){return Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))}function Et(t){return Math.pow(2,Math.floor(Math.log(t)/Math.LN2))}var Tt=Object.freeze({__proto__:null,DEG2RAD:vt,RAD2DEG:_t,generateUUID:yt,clamp:xt,euclideanModulo:bt,mapLinear:function(t,e,n,i,r){return i+(t-e)*(r-i)/(n-e)},inverseLerp:function(t,e,n){return t!==e?(n-t)/(e-t):0},lerp:Mt,damp:function(t,e,n,i){return Mt(t,e,1-Math.exp(-n*i))},pingpong:function(t,e=1){return e-Math.abs(bt(t,2*e)-e)},smoothstep:function(t,e,n){return t<=e?0:t>=n?1:(t=(t-e)/(n-e))*t*(3-2*t)},smootherstep:function(t,e,n){return t<=e?0:t>=n?1:(t=(t-e)/(n-e))*t*t*(t*(6*t-15)+10)},randInt:function(t,e){return t+Math.floor(Math.random()*(e-t+1))},randFloat:function(t,e){return t+Math.random()*(e-t)},randFloatSpread:function(t){return t*(.5-Math.random())},seededRandom:function(t){void 0!==t&&(gt=t);let e=gt+=1831565813;return e=Math.imul(e^e>>>15,1|e),e^=e+Math.imul(e^e>>>7,61|e),((e^e>>>14)>>>0)/4294967296},degToRad:function(t){return t*vt},radToDeg:function(t){return t*_t},isPowerOfTwo:wt,ceilPowerOfTwo:St,floorPowerOfTwo:Et,setQuaternionFromProperEuler:function(t,e,n,i,r){const s=Math.cos,a=Math.sin,o=s(n/2),l=a(n/2),c=s((e+i)/2),u=a((e+i)/2),h=s((e-i)/2),d=a((e-i)/2),p=s((i-e)/2),f=a((i-e)/2);switch(r){case"XYX":t.set(o*u,l*h,l*d,o*c);break;case"YZY":t.set(l*d,o*u,l*h,o*c);break;case"ZXZ":t.set(l*h,l*d,o*u,o*c);break;case"XZX":t.set(o*u,l*f,l*p,o*c);break;case"YXY":t.set(l*p,o*u,l*f,o*c);break;case"ZYZ":t.set(l*f,l*p,o*u,o*c);break;default:console.warn("THREE.MathUtils: .setQuaternionFromProperEuler() encountered an unknown order: "+r)}},normalize:function(t,e){switch(e.constructor){case Float32Array:return t;case Uint16Array:return Math.round(65535*t);case Uint8Array:return Math.round(255*t);case Int16Array:return Math.round(32767*t);case Int8Array:return Math.round(127*t);default:throw new Error("Invalid component type.")}},denormalize:function(t,e){switch(e.constructor){case Float32Array:return t;case Uint16Array:return t/65535;case Uint8Array:return t/255;case Int16Array:return Math.max(t/32767,-1);case Int8Array:return Math.max(t/127,-1);default:throw new Error("Invalid component type.")}}});class At{constructor(t=0,e=0){At.prototype.isVector2=!0,this.x=t,this.y=e}get width(){return this.x}set width(t){this.x=t}get height(){return this.y}set height(t){this.y=t}set(t,e){return this.x=t,this.y=e,this}setScalar(t){return this.x=t,this.y=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setComponent(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y)}copy(t){return this.x=t.x,this.y=t.y,this}add(t,e){return void 0!==e?(console.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this)}addScalar(t){return this.x+=t,this.y+=t,this}addVectors(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this}addScaledVector(t,e){return this.x+=t.x*e,this.y+=t.y*e,this}sub(t,e){return void 0!==e?(console.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this)}subScalar(t){return this.x-=t,this.y-=t,this}subVectors(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this}multiply(t){return this.x*=t.x,this.y*=t.y,this}multiplyScalar(t){return this.x*=t,this.y*=t,this}divide(t){return this.x/=t.x,this.y/=t.y,this}divideScalar(t){return this.multiplyScalar(1/t)}applyMatrix3(t){const e=this.x,n=this.y,i=t.elements;return this.x=i[0]*e+i[3]*n+i[6],this.y=i[1]*e+i[4]*n+i[7],this}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this}clamp(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this}clampScalar(t,e){return this.x=Math.max(t,Math.min(e,this.x)),this.y=Math.max(t,Math.min(e,this.y)),this}clampLength(t,e){const n=this.length();return this.divideScalar(n||1).multiplyScalar(Math.max(t,Math.min(e,n)))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}roundToZero(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this}negate(){return this.x=-this.x,this.y=-this.y,this}dot(t){return this.x*t.x+this.y*t.y}cross(t){return this.x*t.y-this.y*t.x}lengthSq(){return this.x*this.x+this.y*this.y}length(){return Math.sqrt(this.x*this.x+this.y*this.y)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)}normalize(){return this.divideScalar(this.length()||1)}angle(){return Math.atan2(-this.y,-this.x)+Math.PI}distanceTo(t){return Math.sqrt(this.distanceToSquared(t))}distanceToSquared(t){const e=this.x-t.x,n=this.y-t.y;return e*e+n*n}manhattanDistanceTo(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this}lerpVectors(t,e,n){return this.x=t.x+(e.x-t.x)*n,this.y=t.y+(e.y-t.y)*n,this}equals(t){return t.x===this.x&&t.y===this.y}fromArray(t,e=0){return this.x=t[e],this.y=t[e+1],this}toArray(t=[],e=0){return t[e]=this.x,t[e+1]=this.y,t}fromBufferAttribute(t,e,n){return void 0!==n&&console.warn("THREE.Vector2: offset has been removed from .fromBufferAttribute()."),this.x=t.getX(e),this.y=t.getY(e),this}rotateAround(t,e){const n=Math.cos(e),i=Math.sin(e),r=this.x-t.x,s=this.y-t.y;return this.x=r*n-s*i+t.x,this.y=r*i+s*n+t.y,this}random(){return this.x=Math.random(),this.y=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y}}class Rt{constructor(){Rt.prototype.isMatrix3=!0,this.elements=[1,0,0,0,1,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")}set(t,e,n,i,r,s,a,o,l){const c=this.elements;return c[0]=t,c[1]=i,c[2]=a,c[3]=e,c[4]=r,c[5]=o,c[6]=n,c[7]=s,c[8]=l,this}identity(){return this.set(1,0,0,0,1,0,0,0,1),this}copy(t){const e=this.elements,n=t.elements;return e[0]=n[0],e[1]=n[1],e[2]=n[2],e[3]=n[3],e[4]=n[4],e[5]=n[5],e[6]=n[6],e[7]=n[7],e[8]=n[8],this}extractBasis(t,e,n){return t.setFromMatrix3Column(this,0),e.setFromMatrix3Column(this,1),n.setFromMatrix3Column(this,2),this}setFromMatrix4(t){const e=t.elements;return this.set(e[0],e[4],e[8],e[1],e[5],e[9],e[2],e[6],e[10]),this}multiply(t){return this.multiplyMatrices(this,t)}premultiply(t){return this.multiplyMatrices(t,this)}multiplyMatrices(t,e){const n=t.elements,i=e.elements,r=this.elements,s=n[0],a=n[3],o=n[6],l=n[1],c=n[4],u=n[7],h=n[2],d=n[5],p=n[8],f=i[0],m=i[3],g=i[6],v=i[1],_=i[4],y=i[7],x=i[2],b=i[5],M=i[8];return r[0]=s*f+a*v+o*x,r[3]=s*m+a*_+o*b,r[6]=s*g+a*y+o*M,r[1]=l*f+c*v+u*x,r[4]=l*m+c*_+u*b,r[7]=l*g+c*y+u*M,r[2]=h*f+d*v+p*x,r[5]=h*m+d*_+p*b,r[8]=h*g+d*y+p*M,this}multiplyScalar(t){const e=this.elements;return e[0]*=t,e[3]*=t,e[6]*=t,e[1]*=t,e[4]*=t,e[7]*=t,e[2]*=t,e[5]*=t,e[8]*=t,this}determinant(){const t=this.elements,e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],l=t[7],c=t[8];return e*s*c-e*a*l-n*r*c+n*a*o+i*r*l-i*s*o}invert(){const t=this.elements,e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],l=t[7],c=t[8],u=c*s-a*l,h=a*o-c*r,d=l*r-s*o,p=e*u+n*h+i*d;if(0===p)return this.set(0,0,0,0,0,0,0,0,0);const f=1/p;return t[0]=u*f,t[1]=(i*l-c*n)*f,t[2]=(a*n-i*s)*f,t[3]=h*f,t[4]=(c*e-i*o)*f,t[5]=(i*r-a*e)*f,t[6]=d*f,t[7]=(n*o-l*e)*f,t[8]=(s*e-n*r)*f,this}transpose(){let t;const e=this.elements;return t=e[1],e[1]=e[3],e[3]=t,t=e[2],e[2]=e[6],e[6]=t,t=e[5],e[5]=e[7],e[7]=t,this}getNormalMatrix(t){return this.setFromMatrix4(t).invert().transpose()}transposeIntoArray(t){const e=this.elements;return t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],this}setUvTransform(t,e,n,i,r,s,a){const o=Math.cos(r),l=Math.sin(r);return this.set(n*o,n*l,-n*(o*s+l*a)+s+t,-i*l,i*o,-i*(-l*s+o*a)+a+e,0,0,1),this}scale(t,e){const n=this.elements;return n[0]*=t,n[3]*=t,n[6]*=t,n[1]*=e,n[4]*=e,n[7]*=e,this}rotate(t){const e=Math.cos(t),n=Math.sin(t),i=this.elements,r=i[0],s=i[3],a=i[6],o=i[1],l=i[4],c=i[7];return i[0]=e*r+n*o,i[3]=e*s+n*l,i[6]=e*a+n*c,i[1]=-n*r+e*o,i[4]=-n*s+e*l,i[7]=-n*a+e*c,this}translate(t,e){const n=this.elements;return n[0]+=t*n[2],n[3]+=t*n[5],n[6]+=t*n[8],n[1]+=e*n[2],n[4]+=e*n[5],n[7]+=e*n[8],this}equals(t){const e=this.elements,n=t.elements;for(let t=0;t<9;t++)if(e[t]!==n[t])return!1;return!0}fromArray(t,e=0){for(let n=0;n<9;n++)this.elements[n]=t[n+e];return this}toArray(t=[],e=0){const n=this.elements;return t[e]=n[0],t[e+1]=n[1],t[e+2]=n[2],t[e+3]=n[3],t[e+4]=n[4],t[e+5]=n[5],t[e+6]=n[6],t[e+7]=n[7],t[e+8]=n[8],t}clone(){return(new this.constructor).fromArray(this.elements)}}function Ct(t){for(let e=t.length-1;e>=0;--e)if(t[e]>65535)return!0;return!1}const Lt={Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array};function Pt(t,e){return new Lt[t](e)}function It(t){return document.createElementNS("http://www.w3.org/1999/xhtml",t)}function Dt(t){return t<.04045?.0773993808*t:Math.pow(.9478672986*t+.0521327014,2.4)}function Ot(t){return t<.0031308?12.92*t:1.055*Math.pow(t,.41666)-.055}const Nt={[lt]:{[ct]:Dt},[ct]:{[lt]:Ot}},Ut={legacyMode:!0,get workingColorSpace(){return ct},set workingColorSpace(t){console.warn("THREE.ColorManagement: .workingColorSpace is readonly.")},convert:function(t,e,n){if(this.legacyMode||e===n||!e||!n)return t;if(Nt[e]&&void 0!==Nt[e][n]){const i=Nt[e][n];return t.r=i(t.r),t.g=i(t.g),t.b=i(t.b),t}throw new Error("Unsupported color space conversion.")},fromWorkingColorSpace:function(t,e){return this.convert(t,this.workingColorSpace,e)},toWorkingColorSpace:function(t,e){return this.convert(t,e,this.workingColorSpace)}},Ft={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},Bt={r:0,g:0,b:0},zt={h:0,s:0,l:0},kt={h:0,s:0,l:0};function Gt(t,e,n){return n<0&&(n+=1),n>1&&(n-=1),n<1/6?t+6*(e-t)*n:n<.5?e:n<2/3?t+6*(e-t)*(2/3-n):t}function Vt(t,e){return e.r=t.r,e.g=t.g,e.b=t.b,e}class Ht{constructor(t,e,n){return this.isColor=!0,this.r=1,this.g=1,this.b=1,void 0===e&&void 0===n?this.set(t):this.setRGB(t,e,n)}set(t){return t&&t.isColor?this.copy(t):"number"==typeof t?this.setHex(t):"string"==typeof t&&this.setStyle(t),this}setScalar(t){return this.r=t,this.g=t,this.b=t,this}setHex(t,e="srgb"){return t=Math.floor(t),this.r=(t>>16&255)/255,this.g=(t>>8&255)/255,this.b=(255&t)/255,Ut.toWorkingColorSpace(this,e),this}setRGB(t,e,n,i="srgb-linear"){return this.r=t,this.g=e,this.b=n,Ut.toWorkingColorSpace(this,i),this}setHSL(t,e,n,i="srgb-linear"){if(t=bt(t,1),e=xt(e,0,1),n=xt(n,0,1),0===e)this.r=this.g=this.b=n;else{const i=n<=.5?n*(1+e):n+e-n*e,r=2*n-i;this.r=Gt(r,i,t+1/3),this.g=Gt(r,i,t),this.b=Gt(r,i,t-1/3)}return Ut.toWorkingColorSpace(this,i),this}setStyle(t,e="srgb"){function n(e){void 0!==e&&parseFloat(e)<1&&console.warn("THREE.Color: Alpha component of "+t+" will be ignored.")}let i;if(i=/^((?:rgb|hsl)a?)\(([^\)]*)\)/.exec(t)){let t;const r=i[1],s=i[2];switch(r){case"rgb":case"rgba":if(t=/^\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(s))return this.r=Math.min(255,parseInt(t[1],10))/255,this.g=Math.min(255,parseInt(t[2],10))/255,this.b=Math.min(255,parseInt(t[3],10))/255,Ut.toWorkingColorSpace(this,e),n(t[4]),this;if(t=/^\s*(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(s))return this.r=Math.min(100,parseInt(t[1],10))/100,this.g=Math.min(100,parseInt(t[2],10))/100,this.b=Math.min(100,parseInt(t[3],10))/100,Ut.toWorkingColorSpace(this,e),n(t[4]),this;break;case"hsl":case"hsla":if(t=/^\s*(\d*\.?\d+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(?:,\s*(\d*\.?\d+)\s*)?$/.exec(s)){const i=parseFloat(t[1])/360,r=parseInt(t[2],10)/100,s=parseInt(t[3],10)/100;return n(t[4]),this.setHSL(i,r,s,e)}}}else if(i=/^\#([A-Fa-f\d]+)$/.exec(t)){const t=i[1],n=t.length;if(3===n)return this.r=parseInt(t.charAt(0)+t.charAt(0),16)/255,this.g=parseInt(t.charAt(1)+t.charAt(1),16)/255,this.b=parseInt(t.charAt(2)+t.charAt(2),16)/255,Ut.toWorkingColorSpace(this,e),this;if(6===n)return this.r=parseInt(t.charAt(0)+t.charAt(1),16)/255,this.g=parseInt(t.charAt(2)+t.charAt(3),16)/255,this.b=parseInt(t.charAt(4)+t.charAt(5),16)/255,Ut.toWorkingColorSpace(this,e),this}return t&&t.length>0?this.setColorName(t,e):this}setColorName(t,e="srgb"){const n=Ft[t.toLowerCase()];return void 0!==n?this.setHex(n,e):console.warn("THREE.Color: Unknown color "+t),this}clone(){return new this.constructor(this.r,this.g,this.b)}copy(t){return this.r=t.r,this.g=t.g,this.b=t.b,this}copySRGBToLinear(t){return this.r=Dt(t.r),this.g=Dt(t.g),this.b=Dt(t.b),this}copyLinearToSRGB(t){return this.r=Ot(t.r),this.g=Ot(t.g),this.b=Ot(t.b),this}convertSRGBToLinear(){return this.copySRGBToLinear(this),this}convertLinearToSRGB(){return this.copyLinearToSRGB(this),this}getHex(t="srgb"){return Ut.fromWorkingColorSpace(Vt(this,Bt),t),xt(255*Bt.r,0,255)<<16^xt(255*Bt.g,0,255)<<8^xt(255*Bt.b,0,255)<<0}getHexString(t="srgb"){return("000000"+this.getHex(t).toString(16)).slice(-6)}getHSL(t,e="srgb-linear"){Ut.fromWorkingColorSpace(Vt(this,Bt),e);const n=Bt.r,i=Bt.g,r=Bt.b,s=Math.max(n,i,r),a=Math.min(n,i,r);let o,l;const c=(a+s)/2;if(a===s)o=0,l=0;else{const t=s-a;switch(l=c<=.5?t/(s+a):t/(2-s-a),s){case n:o=(i-r)/t+(i<r?6:0);break;case i:o=(r-n)/t+2;break;case r:o=(n-i)/t+4}o/=6}return t.h=o,t.s=l,t.l=c,t}getRGB(t,e="srgb-linear"){return Ut.fromWorkingColorSpace(Vt(this,Bt),e),t.r=Bt.r,t.g=Bt.g,t.b=Bt.b,t}getStyle(t="srgb"){return Ut.fromWorkingColorSpace(Vt(this,Bt),t),t!==lt?`color(${t} ${Bt.r} ${Bt.g} ${Bt.b})`:`rgb(${255*Bt.r|0},${255*Bt.g|0},${255*Bt.b|0})`}offsetHSL(t,e,n){return this.getHSL(zt),zt.h+=t,zt.s+=e,zt.l+=n,this.setHSL(zt.h,zt.s,zt.l),this}add(t){return this.r+=t.r,this.g+=t.g,this.b+=t.b,this}addColors(t,e){return this.r=t.r+e.r,this.g=t.g+e.g,this.b=t.b+e.b,this}addScalar(t){return this.r+=t,this.g+=t,this.b+=t,this}sub(t){return this.r=Math.max(0,this.r-t.r),this.g=Math.max(0,this.g-t.g),this.b=Math.max(0,this.b-t.b),this}multiply(t){return this.r*=t.r,this.g*=t.g,this.b*=t.b,this}multiplyScalar(t){return this.r*=t,this.g*=t,this.b*=t,this}lerp(t,e){return this.r+=(t.r-this.r)*e,this.g+=(t.g-this.g)*e,this.b+=(t.b-this.b)*e,this}lerpColors(t,e,n){return this.r=t.r+(e.r-t.r)*n,this.g=t.g+(e.g-t.g)*n,this.b=t.b+(e.b-t.b)*n,this}lerpHSL(t,e){this.getHSL(zt),t.getHSL(kt);const n=Mt(zt.h,kt.h,e),i=Mt(zt.s,kt.s,e),r=Mt(zt.l,kt.l,e);return this.setHSL(n,i,r),this}equals(t){return t.r===this.r&&t.g===this.g&&t.b===this.b}fromArray(t,e=0){return this.r=t[e],this.g=t[e+1],this.b=t[e+2],this}toArray(t=[],e=0){return t[e]=this.r,t[e+1]=this.g,t[e+2]=this.b,t}fromBufferAttribute(t,e){return this.r=t.getX(e),this.g=t.getY(e),this.b=t.getZ(e),!0===t.normalized&&(this.r/=255,this.g/=255,this.b/=255),this}toJSON(){return this.getHex()}*[Symbol.iterator](){yield this.r,yield this.g,yield this.b}}let Wt;Ht.NAMES=Ft;class jt{static getDataURL(t){if(/^data:/i.test(t.src))return t.src;if("undefined"==typeof HTMLCanvasElement)return t.src;let e;if(t instanceof HTMLCanvasElement)e=t;else{void 0===Wt&&(Wt=It("canvas")),Wt.width=t.width,Wt.height=t.height;const n=Wt.getContext("2d");t instanceof ImageData?n.putImageData(t,0,0):n.drawImage(t,0,0,t.width,t.height),e=Wt}return e.width>2048||e.height>2048?(console.warn("THREE.ImageUtils.getDataURL: Image converted to jpg for performance reasons",t),e.toDataURL("image/jpeg",.6)):e.toDataURL("image/png")}static sRGBToLinear(t){if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap){const e=It("canvas");e.width=t.width,e.height=t.height;const n=e.getContext("2d");n.drawImage(t,0,0,t.width,t.height);const i=n.getImageData(0,0,t.width,t.height),r=i.data;for(let t=0;t<r.length;t++)r[t]=255*Dt(r[t]/255);return n.putImageData(i,0,0),e}if(t.data){const e=t.data.slice(0);for(let t=0;t<e.length;t++)e instanceof Uint8Array||e instanceof Uint8ClampedArray?e[t]=Math.floor(255*Dt(e[t]/255)):e[t]=Dt(e[t]);return{data:e,width:t.width,height:t.height}}return console.warn("THREE.ImageUtils.sRGBToLinear(): Unsupported image type. No color space conversion applied."),t}}class Xt{constructor(t=null){this.isSource=!0,this.uuid=yt(),this.data=t,this.version=0}set needsUpdate(t){!0===t&&this.version++}toJSON(t){const e=void 0===t||"string"==typeof t;if(!e&&void 0!==t.images[this.uuid])return t.images[this.uuid];const n={uuid:this.uuid,url:""},i=this.data;if(null!==i){let t;if(Array.isArray(i)){t=[];for(let e=0,n=i.length;e<n;e++)i[e].isDataTexture?t.push(Yt(i[e].image)):t.push(Yt(i[e]))}else t=Yt(i);n.url=t}return e||(t.images[this.uuid]=n),n}}function Yt(t){return"undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap?jt.getDataURL(t):t.data?{data:Array.from(t.data),width:t.width,height:t.height,type:t.data.constructor.name}:(console.warn("THREE.Texture: Unable to serialize Texture."),{})}let qt=0;class Zt extends ft{constructor(t=Zt.DEFAULT_IMAGE,e=Zt.DEFAULT_MAPPING,n=1001,i=1001,r=1006,s=1008,a=1023,o=1009,l=1,c=3e3){super(),this.isTexture=!0,Object.defineProperty(this,"id",{value:qt++}),this.uuid=yt(),this.name="",this.source=new Xt(t),this.mipmaps=[],this.mapping=e,this.wrapS=n,this.wrapT=i,this.magFilter=r,this.minFilter=s,this.anisotropy=l,this.format=a,this.internalFormat=null,this.type=o,this.offset=new At(0,0),this.repeat=new At(1,1),this.center=new At(0,0),this.rotation=0,this.matrixAutoUpdate=!0,this.matrix=new Rt,this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.encoding=c,this.userData={},this.version=0,this.onUpdate=null,this.isRenderTargetTexture=!1,this.needsPMREMUpdate=!1}get image(){return this.source.data}set image(t){this.source.data=t}updateMatrix(){this.matrix.setUvTransform(this.offset.x,this.offset.y,this.repeat.x,this.repeat.y,this.rotation,this.center.x,this.center.y)}clone(){return(new this.constructor).copy(this)}copy(t){return this.name=t.name,this.source=t.source,this.mipmaps=t.mipmaps.slice(0),this.mapping=t.mapping,this.wrapS=t.wrapS,this.wrapT=t.wrapT,this.magFilter=t.magFilter,this.minFilter=t.minFilter,this.anisotropy=t.anisotropy,this.format=t.format,this.internalFormat=t.internalFormat,this.type=t.type,this.offset.copy(t.offset),this.repeat.copy(t.repeat),this.center.copy(t.center),this.rotation=t.rotation,this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrix.copy(t.matrix),this.generateMipmaps=t.generateMipmaps,this.premultiplyAlpha=t.premultiplyAlpha,this.flipY=t.flipY,this.unpackAlignment=t.unpackAlignment,this.encoding=t.encoding,this.userData=JSON.parse(JSON.stringify(t.userData)),this.needsUpdate=!0,this}toJSON(t){const e=void 0===t||"string"==typeof t;if(!e&&void 0!==t.textures[this.uuid])return t.textures[this.uuid];const n={metadata:{version:4.5,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,image:this.source.toJSON(t).uuid,mapping:this.mapping,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],center:[this.center.x,this.center.y],rotation:this.rotation,wrap:[this.wrapS,this.wrapT],format:this.format,type:this.type,encoding:this.encoding,minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy,flipY:this.flipY,premultiplyAlpha:this.premultiplyAlpha,unpackAlignment:this.unpackAlignment};return"{}"!==JSON.stringify(this.userData)&&(n.userData=this.userData),e||(t.textures[this.uuid]=n),n}dispose(){this.dispatchEvent({type:"dispose"})}transformUv(t){if(this.mapping!==r)return t;if(t.applyMatrix3(this.matrix),t.x<0||t.x>1)switch(this.wrapS){case u:t.x=t.x-Math.floor(t.x);break;case h:t.x=t.x<0?0:1;break;case d:1===Math.abs(Math.floor(t.x)%2)?t.x=Math.ceil(t.x)-t.x:t.x=t.x-Math.floor(t.x)}if(t.y<0||t.y>1)switch(this.wrapT){case u:t.y=t.y-Math.floor(t.y);break;case h:t.y=t.y<0?0:1;break;case d:1===Math.abs(Math.floor(t.y)%2)?t.y=Math.ceil(t.y)-t.y:t.y=t.y-Math.floor(t.y)}return this.flipY&&(t.y=1-t.y),t}set needsUpdate(t){!0===t&&(this.version++,this.source.needsUpdate=!0)}}Zt.DEFAULT_IMAGE=null,Zt.DEFAULT_MAPPING=r;class Jt{constructor(t=0,e=0,n=0,i=1){Jt.prototype.isVector4=!0,this.x=t,this.y=e,this.z=n,this.w=i}get width(){return this.z}set width(t){this.z=t}get height(){return this.w}set height(t){this.w=t}set(t,e,n,i){return this.x=t,this.y=e,this.z=n,this.w=i,this}setScalar(t){return this.x=t,this.y=t,this.z=t,this.w=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setZ(t){return this.z=t,this}setW(t){return this.w=t,this}setComponent(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;case 3:this.w=e;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y,this.z,this.w)}copy(t){return this.x=t.x,this.y=t.y,this.z=t.z,this.w=void 0!==t.w?t.w:1,this}add(t,e){return void 0!==e?(console.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this.z+=t.z,this.w+=t.w,this)}addScalar(t){return this.x+=t,this.y+=t,this.z+=t,this.w+=t,this}addVectors(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this.w=t.w+e.w,this}addScaledVector(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this.w+=t.w*e,this}sub(t,e){return void 0!==e?(console.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this.z-=t.z,this.w-=t.w,this)}subScalar(t){return this.x-=t,this.y-=t,this.z-=t,this.w-=t,this}subVectors(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this.w=t.w-e.w,this}multiply(t){return this.x*=t.x,this.y*=t.y,this.z*=t.z,this.w*=t.w,this}multiplyScalar(t){return this.x*=t,this.y*=t,this.z*=t,this.w*=t,this}applyMatrix4(t){const e=this.x,n=this.y,i=this.z,r=this.w,s=t.elements;return this.x=s[0]*e+s[4]*n+s[8]*i+s[12]*r,this.y=s[1]*e+s[5]*n+s[9]*i+s[13]*r,this.z=s[2]*e+s[6]*n+s[10]*i+s[14]*r,this.w=s[3]*e+s[7]*n+s[11]*i+s[15]*r,this}divideScalar(t){return this.multiplyScalar(1/t)}setAxisAngleFromQuaternion(t){this.w=2*Math.acos(t.w);const e=Math.sqrt(1-t.w*t.w);return e<1e-4?(this.x=1,this.y=0,this.z=0):(this.x=t.x/e,this.y=t.y/e,this.z=t.z/e),this}setAxisAngleFromRotationMatrix(t){let e,n,i,r;const s=.01,a=.1,o=t.elements,l=o[0],c=o[4],u=o[8],h=o[1],d=o[5],p=o[9],f=o[2],m=o[6],g=o[10];if(Math.abs(c-h)<s&&Math.abs(u-f)<s&&Math.abs(p-m)<s){if(Math.abs(c+h)<a&&Math.abs(u+f)<a&&Math.abs(p+m)<a&&Math.abs(l+d+g-3)<a)return this.set(1,0,0,0),this;e=Math.PI;const t=(l+1)/2,o=(d+1)/2,v=(g+1)/2,_=(c+h)/4,y=(u+f)/4,x=(p+m)/4;return t>o&&t>v?t<s?(n=0,i=.707106781,r=.707106781):(n=Math.sqrt(t),i=_/n,r=y/n):o>v?o<s?(n=.707106781,i=0,r=.707106781):(i=Math.sqrt(o),n=_/i,r=x/i):v<s?(n=.707106781,i=.707106781,r=0):(r=Math.sqrt(v),n=y/r,i=x/r),this.set(n,i,r,e),this}let v=Math.sqrt((m-p)*(m-p)+(u-f)*(u-f)+(h-c)*(h-c));return Math.abs(v)<.001&&(v=1),this.x=(m-p)/v,this.y=(u-f)/v,this.z=(h-c)/v,this.w=Math.acos((l+d+g-1)/2),this}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this.w=Math.min(this.w,t.w),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this.w=Math.max(this.w,t.w),this}clamp(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this.z=Math.max(t.z,Math.min(e.z,this.z)),this.w=Math.max(t.w,Math.min(e.w,this.w)),this}clampScalar(t,e){return this.x=Math.max(t,Math.min(e,this.x)),this.y=Math.max(t,Math.min(e,this.y)),this.z=Math.max(t,Math.min(e,this.z)),this.w=Math.max(t,Math.min(e,this.w)),this}clampLength(t,e){const n=this.length();return this.divideScalar(n||1).multiplyScalar(Math.max(t,Math.min(e,n)))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this}roundToZero(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this.w=this.w<0?Math.ceil(this.w):Math.floor(this.w),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this}dot(t){return this.x*t.x+this.y*t.y+this.z*t.z+this.w*t.w}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)}normalize(){return this.divideScalar(this.length()||1)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this.w+=(t.w-this.w)*e,this}lerpVectors(t,e,n){return this.x=t.x+(e.x-t.x)*n,this.y=t.y+(e.y-t.y)*n,this.z=t.z+(e.z-t.z)*n,this.w=t.w+(e.w-t.w)*n,this}equals(t){return t.x===this.x&&t.y===this.y&&t.z===this.z&&t.w===this.w}fromArray(t,e=0){return this.x=t[e],this.y=t[e+1],this.z=t[e+2],this.w=t[e+3],this}toArray(t=[],e=0){return t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t[e+3]=this.w,t}fromBufferAttribute(t,e,n){return void 0!==n&&console.warn("THREE.Vector4: offset has been removed from .fromBufferAttribute()."),this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this.w=t.getW(e),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this.w=Math.random(),this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z,yield this.w}}class Kt extends ft{constructor(t,e,n={}){super(),this.isWebGLRenderTarget=!0,this.width=t,this.height=e,this.depth=1,this.scissor=new Jt(0,0,t,e),this.scissorTest=!1,this.viewport=new Jt(0,0,t,e);const i={width:t,height:e,depth:1};this.texture=new Zt(i,n.mapping,n.wrapS,n.wrapT,n.magFilter,n.minFilter,n.format,n.type,n.anisotropy,n.encoding),this.texture.isRenderTargetTexture=!0,this.texture.flipY=!1,this.texture.generateMipmaps=void 0!==n.generateMipmaps&&n.generateMipmaps,this.texture.internalFormat=void 0!==n.internalFormat?n.internalFormat:null,this.texture.minFilter=void 0!==n.minFilter?n.minFilter:g,this.depthBuffer=void 0===n.depthBuffer||n.depthBuffer,this.stencilBuffer=void 0!==n.stencilBuffer&&n.stencilBuffer,this.depthTexture=void 0!==n.depthTexture?n.depthTexture:null,this.samples=void 0!==n.samples?n.samples:0}setSize(t,e,n=1){this.width===t&&this.height===e&&this.depth===n||(this.width=t,this.height=e,this.depth=n,this.texture.image.width=t,this.texture.image.height=e,this.texture.image.depth=n,this.dispose()),this.viewport.set(0,0,t,e),this.scissor.set(0,0,t,e)}clone(){return(new this.constructor).copy(this)}copy(t){this.width=t.width,this.height=t.height,this.depth=t.depth,this.viewport.copy(t.viewport),this.texture=t.texture.clone(),this.texture.isRenderTargetTexture=!0;const e=Object.assign({},t.texture.image);return this.texture.source=new Xt(e),this.depthBuffer=t.depthBuffer,this.stencilBuffer=t.stencilBuffer,null!==t.depthTexture&&(this.depthTexture=t.depthTexture.clone()),this.samples=t.samples,this}dispose(){this.dispatchEvent({type:"dispose"})}}class $t extends Zt{constructor(t=null,e=1,n=1,i=1){super(null),this.isDataArrayTexture=!0,this.image={data:t,width:e,height:n,depth:i},this.magFilter=p,this.minFilter=p,this.wrapR=h,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}class Qt extends Zt{constructor(t=null,e=1,n=1,i=1){super(null),this.isData3DTexture=!0,this.image={data:t,width:e,height:n,depth:i},this.magFilter=p,this.minFilter=p,this.wrapR=h,this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}class te{constructor(t=0,e=0,n=0,i=1){this.isQuaternion=!0,this._x=t,this._y=e,this._z=n,this._w=i}static slerp(t,e,n,i){return console.warn("THREE.Quaternion: Static .slerp() has been deprecated. Use qm.slerpQuaternions( qa, qb, t ) instead."),n.slerpQuaternions(t,e,i)}static slerpFlat(t,e,n,i,r,s,a){let o=n[i+0],l=n[i+1],c=n[i+2],u=n[i+3];const h=r[s+0],d=r[s+1],p=r[s+2],f=r[s+3];if(0===a)return t[e+0]=o,t[e+1]=l,t[e+2]=c,void(t[e+3]=u);if(1===a)return t[e+0]=h,t[e+1]=d,t[e+2]=p,void(t[e+3]=f);if(u!==f||o!==h||l!==d||c!==p){let t=1-a;const e=o*h+l*d+c*p+u*f,n=e>=0?1:-1,i=1-e*e;if(i>Number.EPSILON){const r=Math.sqrt(i),s=Math.atan2(r,e*n);t=Math.sin(t*s)/r,a=Math.sin(a*s)/r}const r=a*n;if(o=o*t+h*r,l=l*t+d*r,c=c*t+p*r,u=u*t+f*r,t===1-a){const t=1/Math.sqrt(o*o+l*l+c*c+u*u);o*=t,l*=t,c*=t,u*=t}}t[e]=o,t[e+1]=l,t[e+2]=c,t[e+3]=u}static multiplyQuaternionsFlat(t,e,n,i,r,s){const a=n[i],o=n[i+1],l=n[i+2],c=n[i+3],u=r[s],h=r[s+1],d=r[s+2],p=r[s+3];return t[e]=a*p+c*u+o*d-l*h,t[e+1]=o*p+c*h+l*u-a*d,t[e+2]=l*p+c*d+a*h-o*u,t[e+3]=c*p-a*u-o*h-l*d,t}get x(){return this._x}set x(t){this._x=t,this._onChangeCallback()}get y(){return this._y}set y(t){this._y=t,this._onChangeCallback()}get z(){return this._z}set z(t){this._z=t,this._onChangeCallback()}get w(){return this._w}set w(t){this._w=t,this._onChangeCallback()}set(t,e,n,i){return this._x=t,this._y=e,this._z=n,this._w=i,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._w)}copy(t){return this._x=t.x,this._y=t.y,this._z=t.z,this._w=t.w,this._onChangeCallback(),this}setFromEuler(t,e){if(!t||!t.isEuler)throw new Error("THREE.Quaternion: .setFromEuler() now expects an Euler rotation rather than a Vector3 and order.");const n=t._x,i=t._y,r=t._z,s=t._order,a=Math.cos,o=Math.sin,l=a(n/2),c=a(i/2),u=a(r/2),h=o(n/2),d=o(i/2),p=o(r/2);switch(s){case"XYZ":this._x=h*c*u+l*d*p,this._y=l*d*u-h*c*p,this._z=l*c*p+h*d*u,this._w=l*c*u-h*d*p;break;case"YXZ":this._x=h*c*u+l*d*p,this._y=l*d*u-h*c*p,this._z=l*c*p-h*d*u,this._w=l*c*u+h*d*p;break;case"ZXY":this._x=h*c*u-l*d*p,this._y=l*d*u+h*c*p,this._z=l*c*p+h*d*u,this._w=l*c*u-h*d*p;break;case"ZYX":this._x=h*c*u-l*d*p,this._y=l*d*u+h*c*p,this._z=l*c*p-h*d*u,this._w=l*c*u+h*d*p;break;case"YZX":this._x=h*c*u+l*d*p,this._y=l*d*u+h*c*p,this._z=l*c*p-h*d*u,this._w=l*c*u-h*d*p;break;case"XZY":this._x=h*c*u-l*d*p,this._y=l*d*u-h*c*p,this._z=l*c*p+h*d*u,this._w=l*c*u+h*d*p;break;default:console.warn("THREE.Quaternion: .setFromEuler() encountered an unknown order: "+s)}return!1!==e&&this._onChangeCallback(),this}setFromAxisAngle(t,e){const n=e/2,i=Math.sin(n);return this._x=t.x*i,this._y=t.y*i,this._z=t.z*i,this._w=Math.cos(n),this._onChangeCallback(),this}setFromRotationMatrix(t){const e=t.elements,n=e[0],i=e[4],r=e[8],s=e[1],a=e[5],o=e[9],l=e[2],c=e[6],u=e[10],h=n+a+u;if(h>0){const t=.5/Math.sqrt(h+1);this._w=.25/t,this._x=(c-o)*t,this._y=(r-l)*t,this._z=(s-i)*t}else if(n>a&&n>u){const t=2*Math.sqrt(1+n-a-u);this._w=(c-o)/t,this._x=.25*t,this._y=(i+s)/t,this._z=(r+l)/t}else if(a>u){const t=2*Math.sqrt(1+a-n-u);this._w=(r-l)/t,this._x=(i+s)/t,this._y=.25*t,this._z=(o+c)/t}else{const t=2*Math.sqrt(1+u-n-a);this._w=(s-i)/t,this._x=(r+l)/t,this._y=(o+c)/t,this._z=.25*t}return this._onChangeCallback(),this}setFromUnitVectors(t,e){let n=t.dot(e)+1;return n<Number.EPSILON?(n=0,Math.abs(t.x)>Math.abs(t.z)?(this._x=-t.y,this._y=t.x,this._z=0,this._w=n):(this._x=0,this._y=-t.z,this._z=t.y,this._w=n)):(this._x=t.y*e.z-t.z*e.y,this._y=t.z*e.x-t.x*e.z,this._z=t.x*e.y-t.y*e.x,this._w=n),this.normalize()}angleTo(t){return 2*Math.acos(Math.abs(xt(this.dot(t),-1,1)))}rotateTowards(t,e){const n=this.angleTo(t);if(0===n)return this;const i=Math.min(1,e/n);return this.slerp(t,i),this}identity(){return this.set(0,0,0,1)}invert(){return this.conjugate()}conjugate(){return this._x*=-1,this._y*=-1,this._z*=-1,this._onChangeCallback(),this}dot(t){return this._x*t._x+this._y*t._y+this._z*t._z+this._w*t._w}lengthSq(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w}length(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)}normalize(){let t=this.length();return 0===t?(this._x=0,this._y=0,this._z=0,this._w=1):(t=1/t,this._x=this._x*t,this._y=this._y*t,this._z=this._z*t,this._w=this._w*t),this._onChangeCallback(),this}multiply(t,e){return void 0!==e?(console.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead."),this.multiplyQuaternions(t,e)):this.multiplyQuaternions(this,t)}premultiply(t){return this.multiplyQuaternions(t,this)}multiplyQuaternions(t,e){const n=t._x,i=t._y,r=t._z,s=t._w,a=e._x,o=e._y,l=e._z,c=e._w;return this._x=n*c+s*a+i*l-r*o,this._y=i*c+s*o+r*a-n*l,this._z=r*c+s*l+n*o-i*a,this._w=s*c-n*a-i*o-r*l,this._onChangeCallback(),this}slerp(t,e){if(0===e)return this;if(1===e)return this.copy(t);const n=this._x,i=this._y,r=this._z,s=this._w;let a=s*t._w+n*t._x+i*t._y+r*t._z;if(a<0?(this._w=-t._w,this._x=-t._x,this._y=-t._y,this._z=-t._z,a=-a):this.copy(t),a>=1)return this._w=s,this._x=n,this._y=i,this._z=r,this;const o=1-a*a;if(o<=Number.EPSILON){const t=1-e;return this._w=t*s+e*this._w,this._x=t*n+e*this._x,this._y=t*i+e*this._y,this._z=t*r+e*this._z,this.normalize(),this._onChangeCallback(),this}const l=Math.sqrt(o),c=Math.atan2(l,a),u=Math.sin((1-e)*c)/l,h=Math.sin(e*c)/l;return this._w=s*u+this._w*h,this._x=n*u+this._x*h,this._y=i*u+this._y*h,this._z=r*u+this._z*h,this._onChangeCallback(),this}slerpQuaternions(t,e,n){return this.copy(t).slerp(e,n)}random(){const t=Math.random(),e=Math.sqrt(1-t),n=Math.sqrt(t),i=2*Math.PI*Math.random(),r=2*Math.PI*Math.random();return this.set(e*Math.cos(i),n*Math.sin(r),n*Math.cos(r),e*Math.sin(i))}equals(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._w===this._w}fromArray(t,e=0){return this._x=t[e],this._y=t[e+1],this._z=t[e+2],this._w=t[e+3],this._onChangeCallback(),this}toArray(t=[],e=0){return t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._w,t}fromBufferAttribute(t,e){return this._x=t.getX(e),this._y=t.getY(e),this._z=t.getZ(e),this._w=t.getW(e),this}_onChange(t){return this._onChangeCallback=t,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._w}}class ee{constructor(t=0,e=0,n=0){ee.prototype.isVector3=!0,this.x=t,this.y=e,this.z=n}set(t,e,n){return void 0===n&&(n=this.z),this.x=t,this.y=e,this.z=n,this}setScalar(t){return this.x=t,this.y=t,this.z=t,this}setX(t){return this.x=t,this}setY(t){return this.y=t,this}setZ(t){return this.z=t,this}setComponent(t,e){switch(t){case 0:this.x=e;break;case 1:this.y=e;break;case 2:this.z=e;break;default:throw new Error("index is out of range: "+t)}return this}getComponent(t){switch(t){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+t)}}clone(){return new this.constructor(this.x,this.y,this.z)}copy(t){return this.x=t.x,this.y=t.y,this.z=t.z,this}add(t,e){return void 0!==e?(console.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(t,e)):(this.x+=t.x,this.y+=t.y,this.z+=t.z,this)}addScalar(t){return this.x+=t,this.y+=t,this.z+=t,this}addVectors(t,e){return this.x=t.x+e.x,this.y=t.y+e.y,this.z=t.z+e.z,this}addScaledVector(t,e){return this.x+=t.x*e,this.y+=t.y*e,this.z+=t.z*e,this}sub(t,e){return void 0!==e?(console.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(t,e)):(this.x-=t.x,this.y-=t.y,this.z-=t.z,this)}subScalar(t){return this.x-=t,this.y-=t,this.z-=t,this}subVectors(t,e){return this.x=t.x-e.x,this.y=t.y-e.y,this.z=t.z-e.z,this}multiply(t,e){return void 0!==e?(console.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead."),this.multiplyVectors(t,e)):(this.x*=t.x,this.y*=t.y,this.z*=t.z,this)}multiplyScalar(t){return this.x*=t,this.y*=t,this.z*=t,this}multiplyVectors(t,e){return this.x=t.x*e.x,this.y=t.y*e.y,this.z=t.z*e.z,this}applyEuler(t){return t&&t.isEuler||console.error("THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order."),this.applyQuaternion(ie.setFromEuler(t))}applyAxisAngle(t,e){return this.applyQuaternion(ie.setFromAxisAngle(t,e))}applyMatrix3(t){const e=this.x,n=this.y,i=this.z,r=t.elements;return this.x=r[0]*e+r[3]*n+r[6]*i,this.y=r[1]*e+r[4]*n+r[7]*i,this.z=r[2]*e+r[5]*n+r[8]*i,this}applyNormalMatrix(t){return this.applyMatrix3(t).normalize()}applyMatrix4(t){const e=this.x,n=this.y,i=this.z,r=t.elements,s=1/(r[3]*e+r[7]*n+r[11]*i+r[15]);return this.x=(r[0]*e+r[4]*n+r[8]*i+r[12])*s,this.y=(r[1]*e+r[5]*n+r[9]*i+r[13])*s,this.z=(r[2]*e+r[6]*n+r[10]*i+r[14])*s,this}applyQuaternion(t){const e=this.x,n=this.y,i=this.z,r=t.x,s=t.y,a=t.z,o=t.w,l=o*e+s*i-a*n,c=o*n+a*e-r*i,u=o*i+r*n-s*e,h=-r*e-s*n-a*i;return this.x=l*o+h*-r+c*-a-u*-s,this.y=c*o+h*-s+u*-r-l*-a,this.z=u*o+h*-a+l*-s-c*-r,this}project(t){return this.applyMatrix4(t.matrixWorldInverse).applyMatrix4(t.projectionMatrix)}unproject(t){return this.applyMatrix4(t.projectionMatrixInverse).applyMatrix4(t.matrixWorld)}transformDirection(t){const e=this.x,n=this.y,i=this.z,r=t.elements;return this.x=r[0]*e+r[4]*n+r[8]*i,this.y=r[1]*e+r[5]*n+r[9]*i,this.z=r[2]*e+r[6]*n+r[10]*i,this.normalize()}divide(t){return this.x/=t.x,this.y/=t.y,this.z/=t.z,this}divideScalar(t){return this.multiplyScalar(1/t)}min(t){return this.x=Math.min(this.x,t.x),this.y=Math.min(this.y,t.y),this.z=Math.min(this.z,t.z),this}max(t){return this.x=Math.max(this.x,t.x),this.y=Math.max(this.y,t.y),this.z=Math.max(this.z,t.z),this}clamp(t,e){return this.x=Math.max(t.x,Math.min(e.x,this.x)),this.y=Math.max(t.y,Math.min(e.y,this.y)),this.z=Math.max(t.z,Math.min(e.z,this.z)),this}clampScalar(t,e){return this.x=Math.max(t,Math.min(e,this.x)),this.y=Math.max(t,Math.min(e,this.y)),this.z=Math.max(t,Math.min(e,this.z)),this}clampLength(t,e){const n=this.length();return this.divideScalar(n||1).multiplyScalar(Math.max(t,Math.min(e,n)))}floor(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this}ceil(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this}round(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this}roundToZero(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this}negate(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this}dot(t){return this.x*t.x+this.y*t.y+this.z*t.z}lengthSq(){return this.x*this.x+this.y*this.y+this.z*this.z}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)}manhattanLength(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)}normalize(){return this.divideScalar(this.length()||1)}setLength(t){return this.normalize().multiplyScalar(t)}lerp(t,e){return this.x+=(t.x-this.x)*e,this.y+=(t.y-this.y)*e,this.z+=(t.z-this.z)*e,this}lerpVectors(t,e,n){return this.x=t.x+(e.x-t.x)*n,this.y=t.y+(e.y-t.y)*n,this.z=t.z+(e.z-t.z)*n,this}cross(t,e){return void 0!==e?(console.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead."),this.crossVectors(t,e)):this.crossVectors(this,t)}crossVectors(t,e){const n=t.x,i=t.y,r=t.z,s=e.x,a=e.y,o=e.z;return this.x=i*o-r*a,this.y=r*s-n*o,this.z=n*a-i*s,this}projectOnVector(t){const e=t.lengthSq();if(0===e)return this.set(0,0,0);const n=t.dot(this)/e;return this.copy(t).multiplyScalar(n)}projectOnPlane(t){return ne.copy(this).projectOnVector(t),this.sub(ne)}reflect(t){return this.sub(ne.copy(t).multiplyScalar(2*this.dot(t)))}angleTo(t){const e=Math.sqrt(this.lengthSq()*t.lengthSq());if(0===e)return Math.PI/2;const n=this.dot(t)/e;return Math.acos(xt(n,-1,1))}distanceTo(t){return Math.sqrt(this.distanceToSquared(t))}distanceToSquared(t){const e=this.x-t.x,n=this.y-t.y,i=this.z-t.z;return e*e+n*n+i*i}manhattanDistanceTo(t){return Math.abs(this.x-t.x)+Math.abs(this.y-t.y)+Math.abs(this.z-t.z)}setFromSpherical(t){return this.setFromSphericalCoords(t.radius,t.phi,t.theta)}setFromSphericalCoords(t,e,n){const i=Math.sin(e)*t;return this.x=i*Math.sin(n),this.y=Math.cos(e)*t,this.z=i*Math.cos(n),this}setFromCylindrical(t){return this.setFromCylindricalCoords(t.radius,t.theta,t.y)}setFromCylindricalCoords(t,e,n){return this.x=t*Math.sin(e),this.y=n,this.z=t*Math.cos(e),this}setFromMatrixPosition(t){const e=t.elements;return this.x=e[12],this.y=e[13],this.z=e[14],this}setFromMatrixScale(t){const e=this.setFromMatrixColumn(t,0).length(),n=this.setFromMatrixColumn(t,1).length(),i=this.setFromMatrixColumn(t,2).length();return this.x=e,this.y=n,this.z=i,this}setFromMatrixColumn(t,e){return this.fromArray(t.elements,4*e)}setFromMatrix3Column(t,e){return this.fromArray(t.elements,3*e)}setFromEuler(t){return this.x=t._x,this.y=t._y,this.z=t._z,this}equals(t){return t.x===this.x&&t.y===this.y&&t.z===this.z}fromArray(t,e=0){return this.x=t[e],this.y=t[e+1],this.z=t[e+2],this}toArray(t=[],e=0){return t[e]=this.x,t[e+1]=this.y,t[e+2]=this.z,t}fromBufferAttribute(t,e,n){return void 0!==n&&console.warn("THREE.Vector3: offset has been removed from .fromBufferAttribute()."),this.x=t.getX(e),this.y=t.getY(e),this.z=t.getZ(e),this}random(){return this.x=Math.random(),this.y=Math.random(),this.z=Math.random(),this}randomDirection(){const t=2*(Math.random()-.5),e=Math.random()*Math.PI*2,n=Math.sqrt(1-t**2);return this.x=n*Math.cos(e),this.y=n*Math.sin(e),this.z=t,this}*[Symbol.iterator](){yield this.x,yield this.y,yield this.z}}const ne=new ee,ie=new te;class re{constructor(t=new ee(1/0,1/0,1/0),e=new ee(-1/0,-1/0,-1/0)){this.isBox3=!0,this.min=t,this.max=e}set(t,e){return this.min.copy(t),this.max.copy(e),this}setFromArray(t){let e=1/0,n=1/0,i=1/0,r=-1/0,s=-1/0,a=-1/0;for(let o=0,l=t.length;o<l;o+=3){const l=t[o],c=t[o+1],u=t[o+2];l<e&&(e=l),c<n&&(n=c),u<i&&(i=u),l>r&&(r=l),c>s&&(s=c),u>a&&(a=u)}return this.min.set(e,n,i),this.max.set(r,s,a),this}setFromBufferAttribute(t){let e=1/0,n=1/0,i=1/0,r=-1/0,s=-1/0,a=-1/0;for(let o=0,l=t.count;o<l;o++){const l=t.getX(o),c=t.getY(o),u=t.getZ(o);l<e&&(e=l),c<n&&(n=c),u<i&&(i=u),l>r&&(r=l),c>s&&(s=c),u>a&&(a=u)}return this.min.set(e,n,i),this.max.set(r,s,a),this}setFromPoints(t){this.makeEmpty();for(let e=0,n=t.length;e<n;e++)this.expandByPoint(t[e]);return this}setFromCenterAndSize(t,e){const n=ae.copy(e).multiplyScalar(.5);return this.min.copy(t).sub(n),this.max.copy(t).add(n),this}setFromObject(t,e=!1){return this.makeEmpty(),this.expandByObject(t,e)}clone(){return(new this.constructor).copy(this)}copy(t){return this.min.copy(t.min),this.max.copy(t.max),this}makeEmpty(){return this.min.x=this.min.y=this.min.z=1/0,this.max.x=this.max.y=this.max.z=-1/0,this}isEmpty(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z}getCenter(t){return this.isEmpty()?t.set(0,0,0):t.addVectors(this.min,this.max).multiplyScalar(.5)}getSize(t){return this.isEmpty()?t.set(0,0,0):t.subVectors(this.max,this.min)}expandByPoint(t){return this.min.min(t),this.max.max(t),this}expandByVector(t){return this.min.sub(t),this.max.add(t),this}expandByScalar(t){return this.min.addScalar(-t),this.max.addScalar(t),this}expandByObject(t,e=!1){t.updateWorldMatrix(!1,!1);const n=t.geometry;if(void 0!==n)if(e&&null!=n.attributes&&void 0!==n.attributes.position){const e=n.attributes.position;for(let n=0,i=e.count;n<i;n++)ae.fromBufferAttribute(e,n).applyMatrix4(t.matrixWorld),this.expandByPoint(ae)}else null===n.boundingBox&&n.computeBoundingBox(),oe.copy(n.boundingBox),oe.applyMatrix4(t.matrixWorld),this.union(oe);const i=t.children;for(let t=0,n=i.length;t<n;t++)this.expandByObject(i[t],e);return this}containsPoint(t){return!(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y||t.z<this.min.z||t.z>this.max.z)}containsBox(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y&&this.min.z<=t.min.z&&t.max.z<=this.max.z}getParameter(t,e){return e.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y),(t.z-this.min.z)/(this.max.z-this.min.z))}intersectsBox(t){return!(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y||t.max.z<this.min.z||t.min.z>this.max.z)}intersectsSphere(t){return this.clampPoint(t.center,ae),ae.distanceToSquared(t.center)<=t.radius*t.radius}intersectsPlane(t){let e,n;return t.normal.x>0?(e=t.normal.x*this.min.x,n=t.normal.x*this.max.x):(e=t.normal.x*this.max.x,n=t.normal.x*this.min.x),t.normal.y>0?(e+=t.normal.y*this.min.y,n+=t.normal.y*this.max.y):(e+=t.normal.y*this.max.y,n+=t.normal.y*this.min.y),t.normal.z>0?(e+=t.normal.z*this.min.z,n+=t.normal.z*this.max.z):(e+=t.normal.z*this.max.z,n+=t.normal.z*this.min.z),e<=-t.constant&&n>=-t.constant}intersectsTriangle(t){if(this.isEmpty())return!1;this.getCenter(fe),me.subVectors(this.max,fe),le.subVectors(t.a,fe),ce.subVectors(t.b,fe),ue.subVectors(t.c,fe),he.subVectors(ce,le),de.subVectors(ue,ce),pe.subVectors(le,ue);let e=[0,-he.z,he.y,0,-de.z,de.y,0,-pe.z,pe.y,he.z,0,-he.x,de.z,0,-de.x,pe.z,0,-pe.x,-he.y,he.x,0,-de.y,de.x,0,-pe.y,pe.x,0];return!!_e(e,le,ce,ue,me)&&(e=[1,0,0,0,1,0,0,0,1],!!_e(e,le,ce,ue,me)&&(ge.crossVectors(he,de),e=[ge.x,ge.y,ge.z],_e(e,le,ce,ue,me)))}clampPoint(t,e){return e.copy(t).clamp(this.min,this.max)}distanceToPoint(t){return ae.copy(t).clamp(this.min,this.max).sub(t).length()}getBoundingSphere(t){return this.getCenter(t.center),t.radius=.5*this.getSize(ae).length(),t}intersect(t){return this.min.max(t.min),this.max.min(t.max),this.isEmpty()&&this.makeEmpty(),this}union(t){return this.min.min(t.min),this.max.max(t.max),this}applyMatrix4(t){return this.isEmpty()||(se[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(t),se[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(t),se[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(t),se[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(t),se[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(t),se[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(t),se[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(t),se[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(t),this.setFromPoints(se)),this}translate(t){return this.min.add(t),this.max.add(t),this}equals(t){return t.min.equals(this.min)&&t.max.equals(this.max)}}const se=[new ee,new ee,new ee,new ee,new ee,new ee,new ee,new ee],ae=new ee,oe=new re,le=new ee,ce=new ee,ue=new ee,he=new ee,de=new ee,pe=new ee,fe=new ee,me=new ee,ge=new ee,ve=new ee;function _e(t,e,n,i,r){for(let s=0,a=t.length-3;s<=a;s+=3){ve.fromArray(t,s);const a=r.x*Math.abs(ve.x)+r.y*Math.abs(ve.y)+r.z*Math.abs(ve.z),o=e.dot(ve),l=n.dot(ve),c=i.dot(ve);if(Math.max(-Math.max(o,l,c),Math.min(o,l,c))>a)return!1}return!0}const ye=new re,xe=new ee,be=new ee,Me=new ee;class we{constructor(t=new ee,e=-1){this.center=t,this.radius=e}set(t,e){return this.center.copy(t),this.radius=e,this}setFromPoints(t,e){const n=this.center;void 0!==e?n.copy(e):ye.setFromPoints(t).getCenter(n);let i=0;for(let e=0,r=t.length;e<r;e++)i=Math.max(i,n.distanceToSquared(t[e]));return this.radius=Math.sqrt(i),this}copy(t){return this.center.copy(t.center),this.radius=t.radius,this}isEmpty(){return this.radius<0}makeEmpty(){return this.center.set(0,0,0),this.radius=-1,this}containsPoint(t){return t.distanceToSquared(this.center)<=this.radius*this.radius}distanceToPoint(t){return t.distanceTo(this.center)-this.radius}intersectsSphere(t){const e=this.radius+t.radius;return t.center.distanceToSquared(this.center)<=e*e}intersectsBox(t){return t.intersectsSphere(this)}intersectsPlane(t){return Math.abs(t.distanceToPoint(this.center))<=this.radius}clampPoint(t,e){const n=this.center.distanceToSquared(t);return e.copy(t),n>this.radius*this.radius&&(e.sub(this.center).normalize(),e.multiplyScalar(this.radius).add(this.center)),e}getBoundingBox(t){return this.isEmpty()?(t.makeEmpty(),t):(t.set(this.center,this.center),t.expandByScalar(this.radius),t)}applyMatrix4(t){return this.center.applyMatrix4(t),this.radius=this.radius*t.getMaxScaleOnAxis(),this}translate(t){return this.center.add(t),this}expandByPoint(t){Me.subVectors(t,this.center);const e=Me.lengthSq();if(e>this.radius*this.radius){const t=Math.sqrt(e),n=.5*(t-this.radius);this.center.add(Me.multiplyScalar(n/t)),this.radius+=n}return this}union(t){return!0===this.center.equals(t.center)?be.set(0,0,1).multiplyScalar(t.radius):be.subVectors(t.center,this.center).normalize().multiplyScalar(t.radius),this.expandByPoint(xe.copy(t.center).add(be)),this.expandByPoint(xe.copy(t.center).sub(be)),this}equals(t){return t.center.equals(this.center)&&t.radius===this.radius}clone(){return(new this.constructor).copy(this)}}const Se=new ee,Ee=new ee,Te=new ee,Ae=new ee,Re=new ee,Ce=new ee,Le=new ee;class Pe{constructor(t=new ee,e=new ee(0,0,-1)){this.origin=t,this.direction=e}set(t,e){return this.origin.copy(t),this.direction.copy(e),this}copy(t){return this.origin.copy(t.origin),this.direction.copy(t.direction),this}at(t,e){return e.copy(this.direction).multiplyScalar(t).add(this.origin)}lookAt(t){return this.direction.copy(t).sub(this.origin).normalize(),this}recast(t){return this.origin.copy(this.at(t,Se)),this}closestPointToPoint(t,e){e.subVectors(t,this.origin);const n=e.dot(this.direction);return n<0?e.copy(this.origin):e.copy(this.direction).multiplyScalar(n).add(this.origin)}distanceToPoint(t){return Math.sqrt(this.distanceSqToPoint(t))}distanceSqToPoint(t){const e=Se.subVectors(t,this.origin).dot(this.direction);return e<0?this.origin.distanceToSquared(t):(Se.copy(this.direction).multiplyScalar(e).add(this.origin),Se.distanceToSquared(t))}distanceSqToSegment(t,e,n,i){Ee.copy(t).add(e).multiplyScalar(.5),Te.copy(e).sub(t).normalize(),Ae.copy(this.origin).sub(Ee);const r=.5*t.distanceTo(e),s=-this.direction.dot(Te),a=Ae.dot(this.direction),o=-Ae.dot(Te),l=Ae.lengthSq(),c=Math.abs(1-s*s);let u,h,d,p;if(c>0)if(u=s*o-a,h=s*a-o,p=r*c,u>=0)if(h>=-p)if(h<=p){const t=1/c;u*=t,h*=t,d=u*(u+s*h+2*a)+h*(s*u+h+2*o)+l}else h=r,u=Math.max(0,-(s*h+a)),d=-u*u+h*(h+2*o)+l;else h=-r,u=Math.max(0,-(s*h+a)),d=-u*u+h*(h+2*o)+l;else h<=-p?(u=Math.max(0,-(-s*r+a)),h=u>0?-r:Math.min(Math.max(-r,-o),r),d=-u*u+h*(h+2*o)+l):h<=p?(u=0,h=Math.min(Math.max(-r,-o),r),d=h*(h+2*o)+l):(u=Math.max(0,-(s*r+a)),h=u>0?r:Math.min(Math.max(-r,-o),r),d=-u*u+h*(h+2*o)+l);else h=s>0?-r:r,u=Math.max(0,-(s*h+a)),d=-u*u+h*(h+2*o)+l;return n&&n.copy(this.direction).multiplyScalar(u).add(this.origin),i&&i.copy(Te).multiplyScalar(h).add(Ee),d}intersectSphere(t,e){Se.subVectors(t.center,this.origin);const n=Se.dot(this.direction),i=Se.dot(Se)-n*n,r=t.radius*t.radius;if(i>r)return null;const s=Math.sqrt(r-i),a=n-s,o=n+s;return a<0&&o<0?null:a<0?this.at(o,e):this.at(a,e)}intersectsSphere(t){return this.distanceSqToPoint(t.center)<=t.radius*t.radius}distanceToPlane(t){const e=t.normal.dot(this.direction);if(0===e)return 0===t.distanceToPoint(this.origin)?0:null;const n=-(this.origin.dot(t.normal)+t.constant)/e;return n>=0?n:null}intersectPlane(t,e){const n=this.distanceToPlane(t);return null===n?null:this.at(n,e)}intersectsPlane(t){const e=t.distanceToPoint(this.origin);return 0===e||t.normal.dot(this.direction)*e<0}intersectBox(t,e){let n,i,r,s,a,o;const l=1/this.direction.x,c=1/this.direction.y,u=1/this.direction.z,h=this.origin;return l>=0?(n=(t.min.x-h.x)*l,i=(t.max.x-h.x)*l):(n=(t.max.x-h.x)*l,i=(t.min.x-h.x)*l),c>=0?(r=(t.min.y-h.y)*c,s=(t.max.y-h.y)*c):(r=(t.max.y-h.y)*c,s=(t.min.y-h.y)*c),n>s||r>i?null:((r>n||n!=n)&&(n=r),(s<i||i!=i)&&(i=s),u>=0?(a=(t.min.z-h.z)*u,o=(t.max.z-h.z)*u):(a=(t.max.z-h.z)*u,o=(t.min.z-h.z)*u),n>o||a>i?null:((a>n||n!=n)&&(n=a),(o<i||i!=i)&&(i=o),i<0?null:this.at(n>=0?n:i,e)))}intersectsBox(t){return null!==this.intersectBox(t,Se)}intersectTriangle(t,e,n,i,r){Re.subVectors(e,t),Ce.subVectors(n,t),Le.crossVectors(Re,Ce);let s,a=this.direction.dot(Le);if(a>0){if(i)return null;s=1}else{if(!(a<0))return null;s=-1,a=-a}Ae.subVectors(this.origin,t);const o=s*this.direction.dot(Ce.crossVectors(Ae,Ce));if(o<0)return null;const l=s*this.direction.dot(Re.cross(Ae));if(l<0)return null;if(o+l>a)return null;const c=-s*Ae.dot(Le);return c<0?null:this.at(c/a,r)}applyMatrix4(t){return this.origin.applyMatrix4(t),this.direction.transformDirection(t),this}equals(t){return t.origin.equals(this.origin)&&t.direction.equals(this.direction)}clone(){return(new this.constructor).copy(this)}}class Ie{constructor(){Ie.prototype.isMatrix4=!0,this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1],arguments.length>0&&console.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")}set(t,e,n,i,r,s,a,o,l,c,u,h,d,p,f,m){const g=this.elements;return g[0]=t,g[4]=e,g[8]=n,g[12]=i,g[1]=r,g[5]=s,g[9]=a,g[13]=o,g[2]=l,g[6]=c,g[10]=u,g[14]=h,g[3]=d,g[7]=p,g[11]=f,g[15]=m,this}identity(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this}clone(){return(new Ie).fromArray(this.elements)}copy(t){const e=this.elements,n=t.elements;return e[0]=n[0],e[1]=n[1],e[2]=n[2],e[3]=n[3],e[4]=n[4],e[5]=n[5],e[6]=n[6],e[7]=n[7],e[8]=n[8],e[9]=n[9],e[10]=n[10],e[11]=n[11],e[12]=n[12],e[13]=n[13],e[14]=n[14],e[15]=n[15],this}copyPosition(t){const e=this.elements,n=t.elements;return e[12]=n[12],e[13]=n[13],e[14]=n[14],this}setFromMatrix3(t){const e=t.elements;return this.set(e[0],e[3],e[6],0,e[1],e[4],e[7],0,e[2],e[5],e[8],0,0,0,0,1),this}extractBasis(t,e,n){return t.setFromMatrixColumn(this,0),e.setFromMatrixColumn(this,1),n.setFromMatrixColumn(this,2),this}makeBasis(t,e,n){return this.set(t.x,e.x,n.x,0,t.y,e.y,n.y,0,t.z,e.z,n.z,0,0,0,0,1),this}extractRotation(t){const e=this.elements,n=t.elements,i=1/De.setFromMatrixColumn(t,0).length(),r=1/De.setFromMatrixColumn(t,1).length(),s=1/De.setFromMatrixColumn(t,2).length();return e[0]=n[0]*i,e[1]=n[1]*i,e[2]=n[2]*i,e[3]=0,e[4]=n[4]*r,e[5]=n[5]*r,e[6]=n[6]*r,e[7]=0,e[8]=n[8]*s,e[9]=n[9]*s,e[10]=n[10]*s,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this}makeRotationFromEuler(t){t&&t.isEuler||console.error("THREE.Matrix4: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.");const e=this.elements,n=t.x,i=t.y,r=t.z,s=Math.cos(n),a=Math.sin(n),o=Math.cos(i),l=Math.sin(i),c=Math.cos(r),u=Math.sin(r);if("XYZ"===t.order){const t=s*c,n=s*u,i=a*c,r=a*u;e[0]=o*c,e[4]=-o*u,e[8]=l,e[1]=n+i*l,e[5]=t-r*l,e[9]=-a*o,e[2]=r-t*l,e[6]=i+n*l,e[10]=s*o}else if("YXZ"===t.order){const t=o*c,n=o*u,i=l*c,r=l*u;e[0]=t+r*a,e[4]=i*a-n,e[8]=s*l,e[1]=s*u,e[5]=s*c,e[9]=-a,e[2]=n*a-i,e[6]=r+t*a,e[10]=s*o}else if("ZXY"===t.order){const t=o*c,n=o*u,i=l*c,r=l*u;e[0]=t-r*a,e[4]=-s*u,e[8]=i+n*a,e[1]=n+i*a,e[5]=s*c,e[9]=r-t*a,e[2]=-s*l,e[6]=a,e[10]=s*o}else if("ZYX"===t.order){const t=s*c,n=s*u,i=a*c,r=a*u;e[0]=o*c,e[4]=i*l-n,e[8]=t*l+r,e[1]=o*u,e[5]=r*l+t,e[9]=n*l-i,e[2]=-l,e[6]=a*o,e[10]=s*o}else if("YZX"===t.order){const t=s*o,n=s*l,i=a*o,r=a*l;e[0]=o*c,e[4]=r-t*u,e[8]=i*u+n,e[1]=u,e[5]=s*c,e[9]=-a*c,e[2]=-l*c,e[6]=n*u+i,e[10]=t-r*u}else if("XZY"===t.order){const t=s*o,n=s*l,i=a*o,r=a*l;e[0]=o*c,e[4]=-u,e[8]=l*c,e[1]=t*u+r,e[5]=s*c,e[9]=n*u-i,e[2]=i*u-n,e[6]=a*c,e[10]=r*u+t}return e[3]=0,e[7]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,this}makeRotationFromQuaternion(t){return this.compose(Ne,t,Ue)}lookAt(t,e,n){const i=this.elements;return ze.subVectors(t,e),0===ze.lengthSq()&&(ze.z=1),ze.normalize(),Fe.crossVectors(n,ze),0===Fe.lengthSq()&&(1===Math.abs(n.z)?ze.x+=1e-4:ze.z+=1e-4,ze.normalize(),Fe.crossVectors(n,ze)),Fe.normalize(),Be.crossVectors(ze,Fe),i[0]=Fe.x,i[4]=Be.x,i[8]=ze.x,i[1]=Fe.y,i[5]=Be.y,i[9]=ze.y,i[2]=Fe.z,i[6]=Be.z,i[10]=ze.z,this}multiply(t,e){return void 0!==e?(console.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead."),this.multiplyMatrices(t,e)):this.multiplyMatrices(this,t)}premultiply(t){return this.multiplyMatrices(t,this)}multiplyMatrices(t,e){const n=t.elements,i=e.elements,r=this.elements,s=n[0],a=n[4],o=n[8],l=n[12],c=n[1],u=n[5],h=n[9],d=n[13],p=n[2],f=n[6],m=n[10],g=n[14],v=n[3],_=n[7],y=n[11],x=n[15],b=i[0],M=i[4],w=i[8],S=i[12],E=i[1],T=i[5],A=i[9],R=i[13],C=i[2],L=i[6],P=i[10],I=i[14],D=i[3],O=i[7],N=i[11],U=i[15];return r[0]=s*b+a*E+o*C+l*D,r[4]=s*M+a*T+o*L+l*O,r[8]=s*w+a*A+o*P+l*N,r[12]=s*S+a*R+o*I+l*U,r[1]=c*b+u*E+h*C+d*D,r[5]=c*M+u*T+h*L+d*O,r[9]=c*w+u*A+h*P+d*N,r[13]=c*S+u*R+h*I+d*U,r[2]=p*b+f*E+m*C+g*D,r[6]=p*M+f*T+m*L+g*O,r[10]=p*w+f*A+m*P+g*N,r[14]=p*S+f*R+m*I+g*U,r[3]=v*b+_*E+y*C+x*D,r[7]=v*M+_*T+y*L+x*O,r[11]=v*w+_*A+y*P+x*N,r[15]=v*S+_*R+y*I+x*U,this}multiplyScalar(t){const e=this.elements;return e[0]*=t,e[4]*=t,e[8]*=t,e[12]*=t,e[1]*=t,e[5]*=t,e[9]*=t,e[13]*=t,e[2]*=t,e[6]*=t,e[10]*=t,e[14]*=t,e[3]*=t,e[7]*=t,e[11]*=t,e[15]*=t,this}determinant(){const t=this.elements,e=t[0],n=t[4],i=t[8],r=t[12],s=t[1],a=t[5],o=t[9],l=t[13],c=t[2],u=t[6],h=t[10],d=t[14];return t[3]*(+r*o*u-i*l*u-r*a*h+n*l*h+i*a*d-n*o*d)+t[7]*(+e*o*d-e*l*h+r*s*h-i*s*d+i*l*c-r*o*c)+t[11]*(+e*l*u-e*a*d-r*s*u+n*s*d+r*a*c-n*l*c)+t[15]*(-i*a*c-e*o*u+e*a*h+i*s*u-n*s*h+n*o*c)}transpose(){const t=this.elements;let e;return e=t[1],t[1]=t[4],t[4]=e,e=t[2],t[2]=t[8],t[8]=e,e=t[6],t[6]=t[9],t[9]=e,e=t[3],t[3]=t[12],t[12]=e,e=t[7],t[7]=t[13],t[13]=e,e=t[11],t[11]=t[14],t[14]=e,this}setPosition(t,e,n){const i=this.elements;return t.isVector3?(i[12]=t.x,i[13]=t.y,i[14]=t.z):(i[12]=t,i[13]=e,i[14]=n),this}invert(){const t=this.elements,e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],l=t[7],c=t[8],u=t[9],h=t[10],d=t[11],p=t[12],f=t[13],m=t[14],g=t[15],v=u*m*l-f*h*l+f*o*d-a*m*d-u*o*g+a*h*g,_=p*h*l-c*m*l-p*o*d+s*m*d+c*o*g-s*h*g,y=c*f*l-p*u*l+p*a*d-s*f*d-c*a*g+s*u*g,x=p*u*o-c*f*o-p*a*h+s*f*h+c*a*m-s*u*m,b=e*v+n*_+i*y+r*x;if(0===b)return this.set(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);const M=1/b;return t[0]=v*M,t[1]=(f*h*r-u*m*r-f*i*d+n*m*d+u*i*g-n*h*g)*M,t[2]=(a*m*r-f*o*r+f*i*l-n*m*l-a*i*g+n*o*g)*M,t[3]=(u*o*r-a*h*r-u*i*l+n*h*l+a*i*d-n*o*d)*M,t[4]=_*M,t[5]=(c*m*r-p*h*r+p*i*d-e*m*d-c*i*g+e*h*g)*M,t[6]=(p*o*r-s*m*r-p*i*l+e*m*l+s*i*g-e*o*g)*M,t[7]=(s*h*r-c*o*r+c*i*l-e*h*l-s*i*d+e*o*d)*M,t[8]=y*M,t[9]=(p*u*r-c*f*r-p*n*d+e*f*d+c*n*g-e*u*g)*M,t[10]=(s*f*r-p*a*r+p*n*l-e*f*l-s*n*g+e*a*g)*M,t[11]=(c*a*r-s*u*r-c*n*l+e*u*l+s*n*d-e*a*d)*M,t[12]=x*M,t[13]=(c*f*i-p*u*i+p*n*h-e*f*h-c*n*m+e*u*m)*M,t[14]=(p*a*i-s*f*i-p*n*o+e*f*o+s*n*m-e*a*m)*M,t[15]=(s*u*i-c*a*i+c*n*o-e*u*o-s*n*h+e*a*h)*M,this}scale(t){const e=this.elements,n=t.x,i=t.y,r=t.z;return e[0]*=n,e[4]*=i,e[8]*=r,e[1]*=n,e[5]*=i,e[9]*=r,e[2]*=n,e[6]*=i,e[10]*=r,e[3]*=n,e[7]*=i,e[11]*=r,this}getMaxScaleOnAxis(){const t=this.elements,e=t[0]*t[0]+t[1]*t[1]+t[2]*t[2],n=t[4]*t[4]+t[5]*t[5]+t[6]*t[6],i=t[8]*t[8]+t[9]*t[9]+t[10]*t[10];return Math.sqrt(Math.max(e,n,i))}makeTranslation(t,e,n){return this.set(1,0,0,t,0,1,0,e,0,0,1,n,0,0,0,1),this}makeRotationX(t){const e=Math.cos(t),n=Math.sin(t);return this.set(1,0,0,0,0,e,-n,0,0,n,e,0,0,0,0,1),this}makeRotationY(t){const e=Math.cos(t),n=Math.sin(t);return this.set(e,0,n,0,0,1,0,0,-n,0,e,0,0,0,0,1),this}makeRotationZ(t){const e=Math.cos(t),n=Math.sin(t);return this.set(e,-n,0,0,n,e,0,0,0,0,1,0,0,0,0,1),this}makeRotationAxis(t,e){const n=Math.cos(e),i=Math.sin(e),r=1-n,s=t.x,a=t.y,o=t.z,l=r*s,c=r*a;return this.set(l*s+n,l*a-i*o,l*o+i*a,0,l*a+i*o,c*a+n,c*o-i*s,0,l*o-i*a,c*o+i*s,r*o*o+n,0,0,0,0,1),this}makeScale(t,e,n){return this.set(t,0,0,0,0,e,0,0,0,0,n,0,0,0,0,1),this}makeShear(t,e,n,i,r,s){return this.set(1,n,r,0,t,1,s,0,e,i,1,0,0,0,0,1),this}compose(t,e,n){const i=this.elements,r=e._x,s=e._y,a=e._z,o=e._w,l=r+r,c=s+s,u=a+a,h=r*l,d=r*c,p=r*u,f=s*c,m=s*u,g=a*u,v=o*l,_=o*c,y=o*u,x=n.x,b=n.y,M=n.z;return i[0]=(1-(f+g))*x,i[1]=(d+y)*x,i[2]=(p-_)*x,i[3]=0,i[4]=(d-y)*b,i[5]=(1-(h+g))*b,i[6]=(m+v)*b,i[7]=0,i[8]=(p+_)*M,i[9]=(m-v)*M,i[10]=(1-(h+f))*M,i[11]=0,i[12]=t.x,i[13]=t.y,i[14]=t.z,i[15]=1,this}decompose(t,e,n){const i=this.elements;let r=De.set(i[0],i[1],i[2]).length();const s=De.set(i[4],i[5],i[6]).length(),a=De.set(i[8],i[9],i[10]).length();this.determinant()<0&&(r=-r),t.x=i[12],t.y=i[13],t.z=i[14],Oe.copy(this);const o=1/r,l=1/s,c=1/a;return Oe.elements[0]*=o,Oe.elements[1]*=o,Oe.elements[2]*=o,Oe.elements[4]*=l,Oe.elements[5]*=l,Oe.elements[6]*=l,Oe.elements[8]*=c,Oe.elements[9]*=c,Oe.elements[10]*=c,e.setFromRotationMatrix(Oe),n.x=r,n.y=s,n.z=a,this}makePerspective(t,e,n,i,r,s){void 0===s&&console.warn("THREE.Matrix4: .makePerspective() has been redefined and has a new signature. Please check the docs.");const a=this.elements,o=2*r/(e-t),l=2*r/(n-i),c=(e+t)/(e-t),u=(n+i)/(n-i),h=-(s+r)/(s-r),d=-2*s*r/(s-r);return a[0]=o,a[4]=0,a[8]=c,a[12]=0,a[1]=0,a[5]=l,a[9]=u,a[13]=0,a[2]=0,a[6]=0,a[10]=h,a[14]=d,a[3]=0,a[7]=0,a[11]=-1,a[15]=0,this}makeOrthographic(t,e,n,i,r,s){const a=this.elements,o=1/(e-t),l=1/(n-i),c=1/(s-r),u=(e+t)*o,h=(n+i)*l,d=(s+r)*c;return a[0]=2*o,a[4]=0,a[8]=0,a[12]=-u,a[1]=0,a[5]=2*l,a[9]=0,a[13]=-h,a[2]=0,a[6]=0,a[10]=-2*c,a[14]=-d,a[3]=0,a[7]=0,a[11]=0,a[15]=1,this}equals(t){const e=this.elements,n=t.elements;for(let t=0;t<16;t++)if(e[t]!==n[t])return!1;return!0}fromArray(t,e=0){for(let n=0;n<16;n++)this.elements[n]=t[n+e];return this}toArray(t=[],e=0){const n=this.elements;return t[e]=n[0],t[e+1]=n[1],t[e+2]=n[2],t[e+3]=n[3],t[e+4]=n[4],t[e+5]=n[5],t[e+6]=n[6],t[e+7]=n[7],t[e+8]=n[8],t[e+9]=n[9],t[e+10]=n[10],t[e+11]=n[11],t[e+12]=n[12],t[e+13]=n[13],t[e+14]=n[14],t[e+15]=n[15],t}}const De=new ee,Oe=new Ie,Ne=new ee(0,0,0),Ue=new ee(1,1,1),Fe=new ee,Be=new ee,ze=new ee,ke=new Ie,Ge=new te;class Ve{constructor(t=0,e=0,n=0,i=Ve.DefaultOrder){this.isEuler=!0,this._x=t,this._y=e,this._z=n,this._order=i}get x(){return this._x}set x(t){this._x=t,this._onChangeCallback()}get y(){return this._y}set y(t){this._y=t,this._onChangeCallback()}get z(){return this._z}set z(t){this._z=t,this._onChangeCallback()}get order(){return this._order}set order(t){this._order=t,this._onChangeCallback()}set(t,e,n,i=this._order){return this._x=t,this._y=e,this._z=n,this._order=i,this._onChangeCallback(),this}clone(){return new this.constructor(this._x,this._y,this._z,this._order)}copy(t){return this._x=t._x,this._y=t._y,this._z=t._z,this._order=t._order,this._onChangeCallback(),this}setFromRotationMatrix(t,e=this._order,n=!0){const i=t.elements,r=i[0],s=i[4],a=i[8],o=i[1],l=i[5],c=i[9],u=i[2],h=i[6],d=i[10];switch(e){case"XYZ":this._y=Math.asin(xt(a,-1,1)),Math.abs(a)<.9999999?(this._x=Math.atan2(-c,d),this._z=Math.atan2(-s,r)):(this._x=Math.atan2(h,l),this._z=0);break;case"YXZ":this._x=Math.asin(-xt(c,-1,1)),Math.abs(c)<.9999999?(this._y=Math.atan2(a,d),this._z=Math.atan2(o,l)):(this._y=Math.atan2(-u,r),this._z=0);break;case"ZXY":this._x=Math.asin(xt(h,-1,1)),Math.abs(h)<.9999999?(this._y=Math.atan2(-u,d),this._z=Math.atan2(-s,l)):(this._y=0,this._z=Math.atan2(o,r));break;case"ZYX":this._y=Math.asin(-xt(u,-1,1)),Math.abs(u)<.9999999?(this._x=Math.atan2(h,d),this._z=Math.atan2(o,r)):(this._x=0,this._z=Math.atan2(-s,l));break;case"YZX":this._z=Math.asin(xt(o,-1,1)),Math.abs(o)<.9999999?(this._x=Math.atan2(-c,l),this._y=Math.atan2(-u,r)):(this._x=0,this._y=Math.atan2(a,d));break;case"XZY":this._z=Math.asin(-xt(s,-1,1)),Math.abs(s)<.9999999?(this._x=Math.atan2(h,l),this._y=Math.atan2(a,r)):(this._x=Math.atan2(-c,d),this._y=0);break;default:console.warn("THREE.Euler: .setFromRotationMatrix() encountered an unknown order: "+e)}return this._order=e,!0===n&&this._onChangeCallback(),this}setFromQuaternion(t,e,n){return ke.makeRotationFromQuaternion(t),this.setFromRotationMatrix(ke,e,n)}setFromVector3(t,e=this._order){return this.set(t.x,t.y,t.z,e)}reorder(t){return Ge.setFromEuler(this),this.setFromQuaternion(Ge,t)}equals(t){return t._x===this._x&&t._y===this._y&&t._z===this._z&&t._order===this._order}fromArray(t){return this._x=t[0],this._y=t[1],this._z=t[2],void 0!==t[3]&&(this._order=t[3]),this._onChangeCallback(),this}toArray(t=[],e=0){return t[e]=this._x,t[e+1]=this._y,t[e+2]=this._z,t[e+3]=this._order,t}_onChange(t){return this._onChangeCallback=t,this}_onChangeCallback(){}*[Symbol.iterator](){yield this._x,yield this._y,yield this._z,yield this._order}toVector3(){console.error("THREE.Euler: .toVector3() has been removed. Use Vector3.setFromEuler() instead")}}Ve.DefaultOrder="XYZ",Ve.RotationOrders=["XYZ","YZX","ZXY","XZY","YXZ","ZYX"];class He{constructor(){this.mask=1}set(t){this.mask=(1<<t|0)>>>0}enable(t){this.mask|=1<<t|0}enableAll(){this.mask=-1}toggle(t){this.mask^=1<<t|0}disable(t){this.mask&=~(1<<t|0)}disableAll(){this.mask=0}test(t){return 0!=(this.mask&t.mask)}isEnabled(t){return 0!=(this.mask&(1<<t|0))}}let We=0;const je=new ee,Xe=new te,Ye=new Ie,qe=new ee,Ze=new ee,Je=new ee,Ke=new te,$e=new ee(1,0,0),Qe=new ee(0,1,0),tn=new ee(0,0,1),en={type:"added"},nn={type:"removed"};class rn extends ft{constructor(){super(),this.isObject3D=!0,Object.defineProperty(this,"id",{value:We++}),this.uuid=yt(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=rn.DefaultUp.clone();const t=new ee,e=new Ve,n=new te,i=new ee(1,1,1);e._onChange((function(){n.setFromEuler(e,!1)})),n._onChange((function(){e.setFromQuaternion(n,void 0,!1)})),Object.defineProperties(this,{position:{configurable:!0,enumerable:!0,value:t},rotation:{configurable:!0,enumerable:!0,value:e},quaternion:{configurable:!0,enumerable:!0,value:n},scale:{configurable:!0,enumerable:!0,value:i},modelViewMatrix:{value:new Ie},normalMatrix:{value:new Rt}}),this.matrix=new Ie,this.matrixWorld=new Ie,this.matrixAutoUpdate=rn.DefaultMatrixAutoUpdate,this.matrixWorldNeedsUpdate=!1,this.layers=new He,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.animations=[],this.userData={}}onBeforeRender(){}onAfterRender(){}applyMatrix4(t){this.matrixAutoUpdate&&this.updateMatrix(),this.matrix.premultiply(t),this.matrix.decompose(this.position,this.quaternion,this.scale)}applyQuaternion(t){return this.quaternion.premultiply(t),this}setRotationFromAxisAngle(t,e){this.quaternion.setFromAxisAngle(t,e)}setRotationFromEuler(t){this.quaternion.setFromEuler(t,!0)}setRotationFromMatrix(t){this.quaternion.setFromRotationMatrix(t)}setRotationFromQuaternion(t){this.quaternion.copy(t)}rotateOnAxis(t,e){return Xe.setFromAxisAngle(t,e),this.quaternion.multiply(Xe),this}rotateOnWorldAxis(t,e){return Xe.setFromAxisAngle(t,e),this.quaternion.premultiply(Xe),this}rotateX(t){return this.rotateOnAxis($e,t)}rotateY(t){return this.rotateOnAxis(Qe,t)}rotateZ(t){return this.rotateOnAxis(tn,t)}translateOnAxis(t,e){return je.copy(t).applyQuaternion(this.quaternion),this.position.add(je.multiplyScalar(e)),this}translateX(t){return this.translateOnAxis($e,t)}translateY(t){return this.translateOnAxis(Qe,t)}translateZ(t){return this.translateOnAxis(tn,t)}localToWorld(t){return t.applyMatrix4(this.matrixWorld)}worldToLocal(t){return t.applyMatrix4(Ye.copy(this.matrixWorld).invert())}lookAt(t,e,n){t.isVector3?qe.copy(t):qe.set(t,e,n);const i=this.parent;this.updateWorldMatrix(!0,!1),Ze.setFromMatrixPosition(this.matrixWorld),this.isCamera||this.isLight?Ye.lookAt(Ze,qe,this.up):Ye.lookAt(qe,Ze,this.up),this.quaternion.setFromRotationMatrix(Ye),i&&(Ye.extractRotation(i.matrixWorld),Xe.setFromRotationMatrix(Ye),this.quaternion.premultiply(Xe.invert()))}add(t){if(arguments.length>1){for(let t=0;t<arguments.length;t++)this.add(arguments[t]);return this}return t===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",t),this):(t&&t.isObject3D?(null!==t.parent&&t.parent.remove(t),t.parent=this,this.children.push(t),t.dispatchEvent(en)):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",t),this)}remove(t){if(arguments.length>1){for(let t=0;t<arguments.length;t++)this.remove(arguments[t]);return this}const e=this.children.indexOf(t);return-1!==e&&(t.parent=null,this.children.splice(e,1),t.dispatchEvent(nn)),this}removeFromParent(){const t=this.parent;return null!==t&&t.remove(this),this}clear(){for(let t=0;t<this.children.length;t++){const e=this.children[t];e.parent=null,e.dispatchEvent(nn)}return this.children.length=0,this}attach(t){return this.updateWorldMatrix(!0,!1),Ye.copy(this.matrixWorld).invert(),null!==t.parent&&(t.parent.updateWorldMatrix(!0,!1),Ye.multiply(t.parent.matrixWorld)),t.applyMatrix4(Ye),this.add(t),t.updateWorldMatrix(!1,!0),this}getObjectById(t){return this.getObjectByProperty("id",t)}getObjectByName(t){return this.getObjectByProperty("name",t)}getObjectByProperty(t,e){if(this[t]===e)return this;for(let n=0,i=this.children.length;n<i;n++){const i=this.children[n].getObjectByProperty(t,e);if(void 0!==i)return i}}getWorldPosition(t){return this.updateWorldMatrix(!0,!1),t.setFromMatrixPosition(this.matrixWorld)}getWorldQuaternion(t){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(Ze,t,Je),t}getWorldScale(t){return this.updateWorldMatrix(!0,!1),this.matrixWorld.decompose(Ze,Ke,t),t}getWorldDirection(t){this.updateWorldMatrix(!0,!1);const e=this.matrixWorld.elements;return t.set(e[8],e[9],e[10]).normalize()}raycast(){}traverse(t){t(this);const e=this.children;for(let n=0,i=e.length;n<i;n++)e[n].traverse(t)}traverseVisible(t){if(!1===this.visible)return;t(this);const e=this.children;for(let n=0,i=e.length;n<i;n++)e[n].traverseVisible(t)}traverseAncestors(t){const e=this.parent;null!==e&&(t(e),e.traverseAncestors(t))}updateMatrix(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0}updateMatrixWorld(t){this.matrixAutoUpdate&&this.updateMatrix(),(this.matrixWorldNeedsUpdate||t)&&(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.matrixWorldNeedsUpdate=!1,t=!0);const e=this.children;for(let n=0,i=e.length;n<i;n++)e[n].updateMatrixWorld(t)}updateWorldMatrix(t,e){const n=this.parent;if(!0===t&&null!==n&&n.updateWorldMatrix(!0,!1),this.matrixAutoUpdate&&this.updateMatrix(),null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),!0===e){const t=this.children;for(let e=0,n=t.length;e<n;e++)t[e].updateWorldMatrix(!1,!0)}}toJSON(t){const e=void 0===t||"string"==typeof t,n={};e&&(t={geometries:{},materials:{},textures:{},images:{},shapes:{},skeletons:{},animations:{},nodes:{}},n.metadata={version:4.5,type:"Object",generator:"Object3D.toJSON"});const i={};function r(e,n){return void 0===e[n.uuid]&&(e[n.uuid]=n.toJSON(t)),n.uuid}if(i.uuid=this.uuid,i.type=this.type,""!==this.name&&(i.name=this.name),!0===this.castShadow&&(i.castShadow=!0),!0===this.receiveShadow&&(i.receiveShadow=!0),!1===this.visible&&(i.visible=!1),!1===this.frustumCulled&&(i.frustumCulled=!1),0!==this.renderOrder&&(i.renderOrder=this.renderOrder),"{}"!==JSON.stringify(this.userData)&&(i.userData=this.userData),i.layers=this.layers.mask,i.matrix=this.matrix.toArray(),!1===this.matrixAutoUpdate&&(i.matrixAutoUpdate=!1),this.isInstancedMesh&&(i.type="InstancedMesh",i.count=this.count,i.instanceMatrix=this.instanceMatrix.toJSON(),null!==this.instanceColor&&(i.instanceColor=this.instanceColor.toJSON())),this.isScene)this.background&&(this.background.isColor?i.background=this.background.toJSON():this.background.isTexture&&(i.background=this.background.toJSON(t).uuid)),this.environment&&this.environment.isTexture&&(i.environment=this.environment.toJSON(t).uuid);else if(this.isMesh||this.isLine||this.isPoints){i.geometry=r(t.geometries,this.geometry);const e=this.geometry.parameters;if(void 0!==e&&void 0!==e.shapes){const n=e.shapes;if(Array.isArray(n))for(let e=0,i=n.length;e<i;e++){const i=n[e];r(t.shapes,i)}else r(t.shapes,n)}}if(this.isSkinnedMesh&&(i.bindMode=this.bindMode,i.bindMatrix=this.bindMatrix.toArray(),void 0!==this.skeleton&&(r(t.skeletons,this.skeleton),i.skeleton=this.skeleton.uuid)),void 0!==this.material)if(Array.isArray(this.material)){const e=[];for(let n=0,i=this.material.length;n<i;n++)e.push(r(t.materials,this.material[n]));i.material=e}else i.material=r(t.materials,this.material);if(this.children.length>0){i.children=[];for(let e=0;e<this.children.length;e++)i.children.push(this.children[e].toJSON(t).object)}if(this.animations.length>0){i.animations=[];for(let e=0;e<this.animations.length;e++){const n=this.animations[e];i.animations.push(r(t.animations,n))}}if(e){const e=s(t.geometries),i=s(t.materials),r=s(t.textures),a=s(t.images),o=s(t.shapes),l=s(t.skeletons),c=s(t.animations),u=s(t.nodes);e.length>0&&(n.geometries=e),i.length>0&&(n.materials=i),r.length>0&&(n.textures=r),a.length>0&&(n.images=a),o.length>0&&(n.shapes=o),l.length>0&&(n.skeletons=l),c.length>0&&(n.animations=c),u.length>0&&(n.nodes=u)}return n.object=i,n;function s(t){const e=[];for(const n in t){const i=t[n];delete i.metadata,e.push(i)}return e}}clone(t){return(new this.constructor).copy(this,t)}copy(t,e=!0){if(this.name=t.name,this.up.copy(t.up),this.position.copy(t.position),this.rotation.order=t.rotation.order,this.quaternion.copy(t.quaternion),this.scale.copy(t.scale),this.matrix.copy(t.matrix),this.matrixWorld.copy(t.matrixWorld),this.matrixAutoUpdate=t.matrixAutoUpdate,this.matrixWorldNeedsUpdate=t.matrixWorldNeedsUpdate,this.layers.mask=t.layers.mask,this.visible=t.visible,this.castShadow=t.castShadow,this.receiveShadow=t.receiveShadow,this.frustumCulled=t.frustumCulled,this.renderOrder=t.renderOrder,this.userData=JSON.parse(JSON.stringify(t.userData)),!0===e)for(let e=0;e<t.children.length;e++){const n=t.children[e];this.add(n.clone())}return this}}rn.DefaultUp=new ee(0,1,0),rn.DefaultMatrixAutoUpdate=!0;const sn=new ee,an=new ee,on=new ee,ln=new ee,cn=new ee,un=new ee,hn=new ee,dn=new ee,pn=new ee,fn=new ee;class mn{constructor(t=new ee,e=new ee,n=new ee){this.a=t,this.b=e,this.c=n}static getNormal(t,e,n,i){i.subVectors(n,e),sn.subVectors(t,e),i.cross(sn);const r=i.lengthSq();return r>0?i.multiplyScalar(1/Math.sqrt(r)):i.set(0,0,0)}static getBarycoord(t,e,n,i,r){sn.subVectors(i,e),an.subVectors(n,e),on.subVectors(t,e);const s=sn.dot(sn),a=sn.dot(an),o=sn.dot(on),l=an.dot(an),c=an.dot(on),u=s*l-a*a;if(0===u)return r.set(-2,-1,-1);const h=1/u,d=(l*o-a*c)*h,p=(s*c-a*o)*h;return r.set(1-d-p,p,d)}static containsPoint(t,e,n,i){return this.getBarycoord(t,e,n,i,ln),ln.x>=0&&ln.y>=0&&ln.x+ln.y<=1}static getUV(t,e,n,i,r,s,a,o){return this.getBarycoord(t,e,n,i,ln),o.set(0,0),o.addScaledVector(r,ln.x),o.addScaledVector(s,ln.y),o.addScaledVector(a,ln.z),o}static isFrontFacing(t,e,n,i){return sn.subVectors(n,e),an.subVectors(t,e),sn.cross(an).dot(i)<0}set(t,e,n){return this.a.copy(t),this.b.copy(e),this.c.copy(n),this}setFromPointsAndIndices(t,e,n,i){return this.a.copy(t[e]),this.b.copy(t[n]),this.c.copy(t[i]),this}setFromAttributeAndIndices(t,e,n,i){return this.a.fromBufferAttribute(t,e),this.b.fromBufferAttribute(t,n),this.c.fromBufferAttribute(t,i),this}clone(){return(new this.constructor).copy(this)}copy(t){return this.a.copy(t.a),this.b.copy(t.b),this.c.copy(t.c),this}getArea(){return sn.subVectors(this.c,this.b),an.subVectors(this.a,this.b),.5*sn.cross(an).length()}getMidpoint(t){return t.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)}getNormal(t){return mn.getNormal(this.a,this.b,this.c,t)}getPlane(t){return t.setFromCoplanarPoints(this.a,this.b,this.c)}getBarycoord(t,e){return mn.getBarycoord(t,this.a,this.b,this.c,e)}getUV(t,e,n,i,r){return mn.getUV(t,this.a,this.b,this.c,e,n,i,r)}containsPoint(t){return mn.containsPoint(t,this.a,this.b,this.c)}isFrontFacing(t){return mn.isFrontFacing(this.a,this.b,this.c,t)}intersectsBox(t){return t.intersectsTriangle(this)}closestPointToPoint(t,e){const n=this.a,i=this.b,r=this.c;let s,a;cn.subVectors(i,n),un.subVectors(r,n),dn.subVectors(t,n);const o=cn.dot(dn),l=un.dot(dn);if(o<=0&&l<=0)return e.copy(n);pn.subVectors(t,i);const c=cn.dot(pn),u=un.dot(pn);if(c>=0&&u<=c)return e.copy(i);const h=o*u-c*l;if(h<=0&&o>=0&&c<=0)return s=o/(o-c),e.copy(n).addScaledVector(cn,s);fn.subVectors(t,r);const d=cn.dot(fn),p=un.dot(fn);if(p>=0&&d<=p)return e.copy(r);const f=d*l-o*p;if(f<=0&&l>=0&&p<=0)return a=l/(l-p),e.copy(n).addScaledVector(un,a);const m=c*p-d*u;if(m<=0&&u-c>=0&&d-p>=0)return hn.subVectors(r,i),a=(u-c)/(u-c+(d-p)),e.copy(i).addScaledVector(hn,a);const g=1/(m+f+h);return s=f*g,a=h*g,e.copy(n).addScaledVector(cn,s).addScaledVector(un,a)}equals(t){return t.a.equals(this.a)&&t.b.equals(this.b)&&t.c.equals(this.c)}}let gn=0;class vn extends ft{constructor(){super(),this.isMaterial=!0,Object.defineProperty(this,"id",{value:gn++}),this.uuid=yt(),this.name="",this.type="Material",this.blending=1,this.side=0,this.vertexColors=!1,this.opacity=1,this.transparent=!1,this.blendSrc=204,this.blendDst=205,this.blendEquation=i,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.depthFunc=3,this.depthTest=!0,this.depthWrite=!0,this.stencilWriteMask=255,this.stencilFunc=519,this.stencilRef=0,this.stencilFuncMask=255,this.stencilFail=ut,this.stencilZFail=ut,this.stencilZPass=ut,this.stencilWrite=!1,this.clippingPlanes=null,this.clipIntersection=!1,this.clipShadows=!1,this.shadowSide=null,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.dithering=!1,this.alphaToCoverage=!1,this.premultipliedAlpha=!1,this.visible=!0,this.toneMapped=!0,this.userData={},this.version=0,this._alphaTest=0}get alphaTest(){return this._alphaTest}set alphaTest(t){this._alphaTest>0!=t>0&&this.version++,this._alphaTest=t}onBuild(){}onBeforeRender(){}onBeforeCompile(){}customProgramCacheKey(){return this.onBeforeCompile.toString()}setValues(t){if(void 0!==t)for(const e in t){const n=t[e];if(void 0===n){console.warn("THREE.Material: '"+e+"' parameter is undefined.");continue}if("shading"===e){console.warn("THREE."+this.type+": .shading has been removed. Use the boolean .flatShading instead."),this.flatShading=1===n;continue}const i=this[e];void 0!==i?i&&i.isColor?i.set(n):i&&i.isVector3&&n&&n.isVector3?i.copy(n):this[e]=n:console.warn("THREE."+this.type+": '"+e+"' is not a property of this material.")}}toJSON(t){const e=void 0===t||"string"==typeof t;e&&(t={textures:{},images:{}});const n={metadata:{version:4.5,type:"Material",generator:"Material.toJSON"}};function i(t){const e=[];for(const n in t){const i=t[n];delete i.metadata,e.push(i)}return e}if(n.uuid=this.uuid,n.type=this.type,""!==this.name&&(n.name=this.name),this.color&&this.color.isColor&&(n.color=this.color.getHex()),void 0!==this.roughness&&(n.roughness=this.roughness),void 0!==this.metalness&&(n.metalness=this.metalness),void 0!==this.sheen&&(n.sheen=this.sheen),this.sheenColor&&this.sheenColor.isColor&&(n.sheenColor=this.sheenColor.getHex()),void 0!==this.sheenRoughness&&(n.sheenRoughness=this.sheenRoughness),this.emissive&&this.emissive.isColor&&(n.emissive=this.emissive.getHex()),this.emissiveIntensity&&1!==this.emissiveIntensity&&(n.emissiveIntensity=this.emissiveIntensity),this.specular&&this.specular.isColor&&(n.specular=this.specular.getHex()),void 0!==this.specularIntensity&&(n.specularIntensity=this.specularIntensity),this.specularColor&&this.specularColor.isColor&&(n.specularColor=this.specularColor.getHex()),void 0!==this.shininess&&(n.shininess=this.shininess),void 0!==this.clearcoat&&(n.clearcoat=this.clearcoat),void 0!==this.clearcoatRoughness&&(n.clearcoatRoughness=this.clearcoatRoughness),this.clearcoatMap&&this.clearcoatMap.isTexture&&(n.clearcoatMap=this.clearcoatMap.toJSON(t).uuid),this.clearcoatRoughnessMap&&this.clearcoatRoughnessMap.isTexture&&(n.clearcoatRoughnessMap=this.clearcoatRoughnessMap.toJSON(t).uuid),this.clearcoatNormalMap&&this.clearcoatNormalMap.isTexture&&(n.clearcoatNormalMap=this.clearcoatNormalMap.toJSON(t).uuid,n.clearcoatNormalScale=this.clearcoatNormalScale.toArray()),void 0!==this.iridescence&&(n.iridescence=this.iridescence),void 0!==this.iridescenceIOR&&(n.iridescenceIOR=this.iridescenceIOR),void 0!==this.iridescenceThicknessRange&&(n.iridescenceThicknessRange=this.iridescenceThicknessRange),this.iridescenceMap&&this.iridescenceMap.isTexture&&(n.iridescenceMap=this.iridescenceMap.toJSON(t).uuid),this.iridescenceThicknessMap&&this.iridescenceThicknessMap.isTexture&&(n.iridescenceThicknessMap=this.iridescenceThicknessMap.toJSON(t).uuid),this.map&&this.map.isTexture&&(n.map=this.map.toJSON(t).uuid),this.matcap&&this.matcap.isTexture&&(n.matcap=this.matcap.toJSON(t).uuid),this.alphaMap&&this.alphaMap.isTexture&&(n.alphaMap=this.alphaMap.toJSON(t).uuid),this.lightMap&&this.lightMap.isTexture&&(n.lightMap=this.lightMap.toJSON(t).uuid,n.lightMapIntensity=this.lightMapIntensity),this.aoMap&&this.aoMap.isTexture&&(n.aoMap=this.aoMap.toJSON(t).uuid,n.aoMapIntensity=this.aoMapIntensity),this.bumpMap&&this.bumpMap.isTexture&&(n.bumpMap=this.bumpMap.toJSON(t).uuid,n.bumpScale=this.bumpScale),this.normalMap&&this.normalMap.isTexture&&(n.normalMap=this.normalMap.toJSON(t).uuid,n.normalMapType=this.normalMapType,n.normalScale=this.normalScale.toArray()),this.displacementMap&&this.displacementMap.isTexture&&(n.displacementMap=this.displacementMap.toJSON(t).uuid,n.displacementScale=this.displacementScale,n.displacementBias=this.displacementBias),this.roughnessMap&&this.roughnessMap.isTexture&&(n.roughnessMap=this.roughnessMap.toJSON(t).uuid),this.metalnessMap&&this.metalnessMap.isTexture&&(n.metalnessMap=this.metalnessMap.toJSON(t).uuid),this.emissiveMap&&this.emissiveMap.isTexture&&(n.emissiveMap=this.emissiveMap.toJSON(t).uuid),this.specularMap&&this.specularMap.isTexture&&(n.specularMap=this.specularMap.toJSON(t).uuid),this.specularIntensityMap&&this.specularIntensityMap.isTexture&&(n.specularIntensityMap=this.specularIntensityMap.toJSON(t).uuid),this.specularColorMap&&this.specularColorMap.isTexture&&(n.specularColorMap=this.specularColorMap.toJSON(t).uuid),this.envMap&&this.envMap.isTexture&&(n.envMap=this.envMap.toJSON(t).uuid,void 0!==this.combine&&(n.combine=this.combine)),void 0!==this.envMapIntensity&&(n.envMapIntensity=this.envMapIntensity),void 0!==this.reflectivity&&(n.reflectivity=this.reflectivity),void 0!==this.refractionRatio&&(n.refractionRatio=this.refractionRatio),this.gradientMap&&this.gradientMap.isTexture&&(n.gradientMap=this.gradientMap.toJSON(t).uuid),void 0!==this.transmission&&(n.transmission=this.transmission),this.transmissionMap&&this.transmissionMap.isTexture&&(n.transmissionMap=this.transmissionMap.toJSON(t).uuid),void 0!==this.thickness&&(n.thickness=this.thickness),this.thicknessMap&&this.thicknessMap.isTexture&&(n.thicknessMap=this.thicknessMap.toJSON(t).uuid),void 0!==this.attenuationDistance&&(n.attenuationDistance=this.attenuationDistance),void 0!==this.attenuationColor&&(n.attenuationColor=this.attenuationColor.getHex()),void 0!==this.size&&(n.size=this.size),null!==this.shadowSide&&(n.shadowSide=this.shadowSide),void 0!==this.sizeAttenuation&&(n.sizeAttenuation=this.sizeAttenuation),1!==this.blending&&(n.blending=this.blending),0!==this.side&&(n.side=this.side),this.vertexColors&&(n.vertexColors=!0),this.opacity<1&&(n.opacity=this.opacity),!0===this.transparent&&(n.transparent=this.transparent),n.depthFunc=this.depthFunc,n.depthTest=this.depthTest,n.depthWrite=this.depthWrite,n.colorWrite=this.colorWrite,n.stencilWrite=this.stencilWrite,n.stencilWriteMask=this.stencilWriteMask,n.stencilFunc=this.stencilFunc,n.stencilRef=this.stencilRef,n.stencilFuncMask=this.stencilFuncMask,n.stencilFail=this.stencilFail,n.stencilZFail=this.stencilZFail,n.stencilZPass=this.stencilZPass,void 0!==this.rotation&&0!==this.rotation&&(n.rotation=this.rotation),!0===this.polygonOffset&&(n.polygonOffset=!0),0!==this.polygonOffsetFactor&&(n.polygonOffsetFactor=this.polygonOffsetFactor),0!==this.polygonOffsetUnits&&(n.polygonOffsetUnits=this.polygonOffsetUnits),void 0!==this.linewidth&&1!==this.linewidth&&(n.linewidth=this.linewidth),void 0!==this.dashSize&&(n.dashSize=this.dashSize),void 0!==this.gapSize&&(n.gapSize=this.gapSize),void 0!==this.scale&&(n.scale=this.scale),!0===this.dithering&&(n.dithering=!0),this.alphaTest>0&&(n.alphaTest=this.alphaTest),!0===this.alphaToCoverage&&(n.alphaToCoverage=this.alphaToCoverage),!0===this.premultipliedAlpha&&(n.premultipliedAlpha=this.premultipliedAlpha),!0===this.wireframe&&(n.wireframe=this.wireframe),this.wireframeLinewidth>1&&(n.wireframeLinewidth=this.wireframeLinewidth),"round"!==this.wireframeLinecap&&(n.wireframeLinecap=this.wireframeLinecap),"round"!==this.wireframeLinejoin&&(n.wireframeLinejoin=this.wireframeLinejoin),!0===this.flatShading&&(n.flatShading=this.flatShading),!1===this.visible&&(n.visible=!1),!1===this.toneMapped&&(n.toneMapped=!1),!1===this.fog&&(n.fog=!1),"{}"!==JSON.stringify(this.userData)&&(n.userData=this.userData),e){const e=i(t.textures),r=i(t.images);e.length>0&&(n.textures=e),r.length>0&&(n.images=r)}return n}clone(){return(new this.constructor).copy(this)}copy(t){this.name=t.name,this.blending=t.blending,this.side=t.side,this.vertexColors=t.vertexColors,this.opacity=t.opacity,this.transparent=t.transparent,this.blendSrc=t.blendSrc,this.blendDst=t.blendDst,this.blendEquation=t.blendEquation,this.blendSrcAlpha=t.blendSrcAlpha,this.blendDstAlpha=t.blendDstAlpha,this.blendEquationAlpha=t.blendEquationAlpha,this.depthFunc=t.depthFunc,this.depthTest=t.depthTest,this.depthWrite=t.depthWrite,this.stencilWriteMask=t.stencilWriteMask,this.stencilFunc=t.stencilFunc,this.stencilRef=t.stencilRef,this.stencilFuncMask=t.stencilFuncMask,this.stencilFail=t.stencilFail,this.stencilZFail=t.stencilZFail,this.stencilZPass=t.stencilZPass,this.stencilWrite=t.stencilWrite;const e=t.clippingPlanes;let n=null;if(null!==e){const t=e.length;n=new Array(t);for(let i=0;i!==t;++i)n[i]=e[i].clone()}return this.clippingPlanes=n,this.clipIntersection=t.clipIntersection,this.clipShadows=t.clipShadows,this.shadowSide=t.shadowSide,this.colorWrite=t.colorWrite,this.precision=t.precision,this.polygonOffset=t.polygonOffset,this.polygonOffsetFactor=t.polygonOffsetFactor,this.polygonOffsetUnits=t.polygonOffsetUnits,this.dithering=t.dithering,this.alphaTest=t.alphaTest,this.alphaToCoverage=t.alphaToCoverage,this.premultipliedAlpha=t.premultipliedAlpha,this.visible=t.visible,this.toneMapped=t.toneMapped,this.userData=JSON.parse(JSON.stringify(t.userData)),this}dispose(){this.dispatchEvent({type:"dispose"})}set needsUpdate(t){!0===t&&this.version++}}class _n extends vn{constructor(t){super(),this.isMeshBasicMaterial=!0,this.type="MeshBasicMaterial",this.color=new Ht(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.fog=t.fog,this}}const yn=new ee,xn=new At;class bn{constructor(t,e,n){if(Array.isArray(t))throw new TypeError("THREE.BufferAttribute: array should be a Typed Array.");this.isBufferAttribute=!0,this.name="",this.array=t,this.itemSize=e,this.count=void 0!==t?t.length/e:0,this.normalized=!0===n,this.usage=ht,this.updateRange={offset:0,count:-1},this.version=0}onUploadCallback(){}set needsUpdate(t){!0===t&&this.version++}setUsage(t){return this.usage=t,this}copy(t){return this.name=t.name,this.array=new t.array.constructor(t.array),this.itemSize=t.itemSize,this.count=t.count,this.normalized=t.normalized,this.usage=t.usage,this}copyAt(t,e,n){t*=this.itemSize,n*=e.itemSize;for(let i=0,r=this.itemSize;i<r;i++)this.array[t+i]=e.array[n+i];return this}copyArray(t){return this.array.set(t),this}copyColorsArray(t){const e=this.array;let n=0;for(let i=0,r=t.length;i<r;i++){let r=t[i];void 0===r&&(console.warn("THREE.BufferAttribute.copyColorsArray(): color is undefined",i),r=new Ht),e[n++]=r.r,e[n++]=r.g,e[n++]=r.b}return this}copyVector2sArray(t){const e=this.array;let n=0;for(let i=0,r=t.length;i<r;i++){let r=t[i];void 0===r&&(console.warn("THREE.BufferAttribute.copyVector2sArray(): vector is undefined",i),r=new At),e[n++]=r.x,e[n++]=r.y}return this}copyVector3sArray(t){const e=this.array;let n=0;for(let i=0,r=t.length;i<r;i++){let r=t[i];void 0===r&&(console.warn("THREE.BufferAttribute.copyVector3sArray(): vector is undefined",i),r=new ee),e[n++]=r.x,e[n++]=r.y,e[n++]=r.z}return this}copyVector4sArray(t){const e=this.array;let n=0;for(let i=0,r=t.length;i<r;i++){let r=t[i];void 0===r&&(console.warn("THREE.BufferAttribute.copyVector4sArray(): vector is undefined",i),r=new Jt),e[n++]=r.x,e[n++]=r.y,e[n++]=r.z,e[n++]=r.w}return this}applyMatrix3(t){if(2===this.itemSize)for(let e=0,n=this.count;e<n;e++)xn.fromBufferAttribute(this,e),xn.applyMatrix3(t),this.setXY(e,xn.x,xn.y);else if(3===this.itemSize)for(let e=0,n=this.count;e<n;e++)yn.fromBufferAttribute(this,e),yn.applyMatrix3(t),this.setXYZ(e,yn.x,yn.y,yn.z);return this}applyMatrix4(t){for(let e=0,n=this.count;e<n;e++)yn.fromBufferAttribute(this,e),yn.applyMatrix4(t),this.setXYZ(e,yn.x,yn.y,yn.z);return this}applyNormalMatrix(t){for(let e=0,n=this.count;e<n;e++)yn.fromBufferAttribute(this,e),yn.applyNormalMatrix(t),this.setXYZ(e,yn.x,yn.y,yn.z);return this}transformDirection(t){for(let e=0,n=this.count;e<n;e++)yn.fromBufferAttribute(this,e),yn.transformDirection(t),this.setXYZ(e,yn.x,yn.y,yn.z);return this}set(t,e=0){return this.array.set(t,e),this}getX(t){return this.array[t*this.itemSize]}setX(t,e){return this.array[t*this.itemSize]=e,this}getY(t){return this.array[t*this.itemSize+1]}setY(t,e){return this.array[t*this.itemSize+1]=e,this}getZ(t){return this.array[t*this.itemSize+2]}setZ(t,e){return this.array[t*this.itemSize+2]=e,this}getW(t){return this.array[t*this.itemSize+3]}setW(t,e){return this.array[t*this.itemSize+3]=e,this}setXY(t,e,n){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=n,this}setXYZ(t,e,n,i){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=n,this.array[t+2]=i,this}setXYZW(t,e,n,i,r){return t*=this.itemSize,this.array[t+0]=e,this.array[t+1]=n,this.array[t+2]=i,this.array[t+3]=r,this}onUpload(t){return this.onUploadCallback=t,this}clone(){return new this.constructor(this.array,this.itemSize).copy(this)}toJSON(){const t={itemSize:this.itemSize,type:this.array.constructor.name,array:Array.from(this.array),normalized:this.normalized};return""!==this.name&&(t.name=this.name),this.usage!==ht&&(t.usage=this.usage),0===this.updateRange.offset&&-1===this.updateRange.count||(t.updateRange=this.updateRange),t}}class Mn extends bn{constructor(t,e,n){super(new Uint16Array(t),e,n)}}class wn extends bn{constructor(t,e,n){super(new Uint32Array(t),e,n)}}class Sn extends bn{constructor(t,e,n){super(new Float32Array(t),e,n)}}let En=0;const Tn=new Ie,An=new rn,Rn=new ee,Cn=new re,Ln=new re,Pn=new ee;class In extends ft{constructor(){super(),this.isBufferGeometry=!0,Object.defineProperty(this,"id",{value:En++}),this.uuid=yt(),this.name="",this.type="BufferGeometry",this.index=null,this.attributes={},this.morphAttributes={},this.morphTargetsRelative=!1,this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0},this.userData={}}getIndex(){return this.index}setIndex(t){return Array.isArray(t)?this.index=new(Ct(t)?wn:Mn)(t,1):this.index=t,this}getAttribute(t){return this.attributes[t]}setAttribute(t,e){return this.attributes[t]=e,this}deleteAttribute(t){return delete this.attributes[t],this}hasAttribute(t){return void 0!==this.attributes[t]}addGroup(t,e,n=0){this.groups.push({start:t,count:e,materialIndex:n})}clearGroups(){this.groups=[]}setDrawRange(t,e){this.drawRange.start=t,this.drawRange.count=e}applyMatrix4(t){const e=this.attributes.position;void 0!==e&&(e.applyMatrix4(t),e.needsUpdate=!0);const n=this.attributes.normal;if(void 0!==n){const e=(new Rt).getNormalMatrix(t);n.applyNormalMatrix(e),n.needsUpdate=!0}const i=this.attributes.tangent;return void 0!==i&&(i.transformDirection(t),i.needsUpdate=!0),null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this}applyQuaternion(t){return Tn.makeRotationFromQuaternion(t),this.applyMatrix4(Tn),this}rotateX(t){return Tn.makeRotationX(t),this.applyMatrix4(Tn),this}rotateY(t){return Tn.makeRotationY(t),this.applyMatrix4(Tn),this}rotateZ(t){return Tn.makeRotationZ(t),this.applyMatrix4(Tn),this}translate(t,e,n){return Tn.makeTranslation(t,e,n),this.applyMatrix4(Tn),this}scale(t,e,n){return Tn.makeScale(t,e,n),this.applyMatrix4(Tn),this}lookAt(t){return An.lookAt(t),An.updateMatrix(),this.applyMatrix4(An.matrix),this}center(){return this.computeBoundingBox(),this.boundingBox.getCenter(Rn).negate(),this.translate(Rn.x,Rn.y,Rn.z),this}setFromPoints(t){const e=[];for(let n=0,i=t.length;n<i;n++){const i=t[n];e.push(i.x,i.y,i.z||0)}return this.setAttribute("position",new Sn(e,3)),this}computeBoundingBox(){null===this.boundingBox&&(this.boundingBox=new re);const t=this.attributes.position,e=this.morphAttributes.position;if(t&&t.isGLBufferAttribute)return console.error('THREE.BufferGeometry.computeBoundingBox(): GLBufferAttribute requires a manual bounding box. Alternatively set "mesh.frustumCulled" to "false".',this),void this.boundingBox.set(new ee(-1/0,-1/0,-1/0),new ee(1/0,1/0,1/0));if(void 0!==t){if(this.boundingBox.setFromBufferAttribute(t),e)for(let t=0,n=e.length;t<n;t++){const n=e[t];Cn.setFromBufferAttribute(n),this.morphTargetsRelative?(Pn.addVectors(this.boundingBox.min,Cn.min),this.boundingBox.expandByPoint(Pn),Pn.addVectors(this.boundingBox.max,Cn.max),this.boundingBox.expandByPoint(Pn)):(this.boundingBox.expandByPoint(Cn.min),this.boundingBox.expandByPoint(Cn.max))}}else this.boundingBox.makeEmpty();(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox(): Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)}computeBoundingSphere(){null===this.boundingSphere&&(this.boundingSphere=new we);const t=this.attributes.position,e=this.morphAttributes.position;if(t&&t.isGLBufferAttribute)return console.error('THREE.BufferGeometry.computeBoundingSphere(): GLBufferAttribute requires a manual bounding sphere. Alternatively set "mesh.frustumCulled" to "false".',this),void this.boundingSphere.set(new ee,1/0);if(t){const n=this.boundingSphere.center;if(Cn.setFromBufferAttribute(t),e)for(let t=0,n=e.length;t<n;t++){const n=e[t];Ln.setFromBufferAttribute(n),this.morphTargetsRelative?(Pn.addVectors(Cn.min,Ln.min),Cn.expandByPoint(Pn),Pn.addVectors(Cn.max,Ln.max),Cn.expandByPoint(Pn)):(Cn.expandByPoint(Ln.min),Cn.expandByPoint(Ln.max))}Cn.getCenter(n);let i=0;for(let e=0,r=t.count;e<r;e++)Pn.fromBufferAttribute(t,e),i=Math.max(i,n.distanceToSquared(Pn));if(e)for(let r=0,s=e.length;r<s;r++){const s=e[r],a=this.morphTargetsRelative;for(let e=0,r=s.count;e<r;e++)Pn.fromBufferAttribute(s,e),a&&(Rn.fromBufferAttribute(t,e),Pn.add(Rn)),i=Math.max(i,n.distanceToSquared(Pn))}this.boundingSphere.radius=Math.sqrt(i),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}computeTangents(){const t=this.index,e=this.attributes;if(null===t||void 0===e.position||void 0===e.normal||void 0===e.uv)return void console.error("THREE.BufferGeometry: .computeTangents() failed. Missing required attributes (index, position, normal or uv)");const n=t.array,i=e.position.array,r=e.normal.array,s=e.uv.array,a=i.length/3;!1===this.hasAttribute("tangent")&&this.setAttribute("tangent",new bn(new Float32Array(4*a),4));const o=this.getAttribute("tangent").array,l=[],c=[];for(let t=0;t<a;t++)l[t]=new ee,c[t]=new ee;const u=new ee,h=new ee,d=new ee,p=new At,f=new At,m=new At,g=new ee,v=new ee;function _(t,e,n){u.fromArray(i,3*t),h.fromArray(i,3*e),d.fromArray(i,3*n),p.fromArray(s,2*t),f.fromArray(s,2*e),m.fromArray(s,2*n),h.sub(u),d.sub(u),f.sub(p),m.sub(p);const r=1/(f.x*m.y-m.x*f.y);isFinite(r)&&(g.copy(h).multiplyScalar(m.y).addScaledVector(d,-f.y).multiplyScalar(r),v.copy(d).multiplyScalar(f.x).addScaledVector(h,-m.x).multiplyScalar(r),l[t].add(g),l[e].add(g),l[n].add(g),c[t].add(v),c[e].add(v),c[n].add(v))}let y=this.groups;0===y.length&&(y=[{start:0,count:n.length}]);for(let t=0,e=y.length;t<e;++t){const e=y[t],i=e.start;for(let t=i,r=i+e.count;t<r;t+=3)_(n[t+0],n[t+1],n[t+2])}const x=new ee,b=new ee,M=new ee,w=new ee;function S(t){M.fromArray(r,3*t),w.copy(M);const e=l[t];x.copy(e),x.sub(M.multiplyScalar(M.dot(e))).normalize(),b.crossVectors(w,e);const n=b.dot(c[t])<0?-1:1;o[4*t]=x.x,o[4*t+1]=x.y,o[4*t+2]=x.z,o[4*t+3]=n}for(let t=0,e=y.length;t<e;++t){const e=y[t],i=e.start;for(let t=i,r=i+e.count;t<r;t+=3)S(n[t+0]),S(n[t+1]),S(n[t+2])}}computeVertexNormals(){const t=this.index,e=this.getAttribute("position");if(void 0!==e){let n=this.getAttribute("normal");if(void 0===n)n=new bn(new Float32Array(3*e.count),3),this.setAttribute("normal",n);else for(let t=0,e=n.count;t<e;t++)n.setXYZ(t,0,0,0);const i=new ee,r=new ee,s=new ee,a=new ee,o=new ee,l=new ee,c=new ee,u=new ee;if(t)for(let h=0,d=t.count;h<d;h+=3){const d=t.getX(h+0),p=t.getX(h+1),f=t.getX(h+2);i.fromBufferAttribute(e,d),r.fromBufferAttribute(e,p),s.fromBufferAttribute(e,f),c.subVectors(s,r),u.subVectors(i,r),c.cross(u),a.fromBufferAttribute(n,d),o.fromBufferAttribute(n,p),l.fromBufferAttribute(n,f),a.add(c),o.add(c),l.add(c),n.setXYZ(d,a.x,a.y,a.z),n.setXYZ(p,o.x,o.y,o.z),n.setXYZ(f,l.x,l.y,l.z)}else for(let t=0,a=e.count;t<a;t+=3)i.fromBufferAttribute(e,t+0),r.fromBufferAttribute(e,t+1),s.fromBufferAttribute(e,t+2),c.subVectors(s,r),u.subVectors(i,r),c.cross(u),n.setXYZ(t+0,c.x,c.y,c.z),n.setXYZ(t+1,c.x,c.y,c.z),n.setXYZ(t+2,c.x,c.y,c.z);this.normalizeNormals(),n.needsUpdate=!0}}merge(t,e){if(!t||!t.isBufferGeometry)return void console.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",t);void 0===e&&(e=0,console.warn("THREE.BufferGeometry.merge(): Overwriting original geometry, starting at offset=0. Use BufferGeometryUtils.mergeBufferGeometries() for lossless merge."));const n=this.attributes;for(const i in n){if(void 0===t.attributes[i])continue;const r=n[i].array,s=t.attributes[i],a=s.array,o=s.itemSize*e,l=Math.min(a.length,r.length-o);for(let t=0,e=o;t<l;t++,e++)r[e]=a[t]}return this}normalizeNormals(){const t=this.attributes.normal;for(let e=0,n=t.count;e<n;e++)Pn.fromBufferAttribute(t,e),Pn.normalize(),t.setXYZ(e,Pn.x,Pn.y,Pn.z)}toNonIndexed(){function t(t,e){const n=t.array,i=t.itemSize,r=t.normalized,s=new n.constructor(e.length*i);let a=0,o=0;for(let r=0,l=e.length;r<l;r++){a=t.isInterleavedBufferAttribute?e[r]*t.data.stride+t.offset:e[r]*i;for(let t=0;t<i;t++)s[o++]=n[a++]}return new bn(s,i,r)}if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): BufferGeometry is already non-indexed."),this;const e=new In,n=this.index.array,i=this.attributes;for(const r in i){const s=t(i[r],n);e.setAttribute(r,s)}const r=this.morphAttributes;for(const i in r){const s=[],a=r[i];for(let e=0,i=a.length;e<i;e++){const i=t(a[e],n);s.push(i)}e.morphAttributes[i]=s}e.morphTargetsRelative=this.morphTargetsRelative;const s=this.groups;for(let t=0,n=s.length;t<n;t++){const n=s[t];e.addGroup(n.start,n.count,n.materialIndex)}return e}toJSON(){const t={metadata:{version:4.5,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(t.uuid=this.uuid,t.type=this.type,""!==this.name&&(t.name=this.name),Object.keys(this.userData).length>0&&(t.userData=this.userData),void 0!==this.parameters){const e=this.parameters;for(const n in e)void 0!==e[n]&&(t[n]=e[n]);return t}t.data={attributes:{}};const e=this.index;null!==e&&(t.data.index={type:e.array.constructor.name,array:Array.prototype.slice.call(e.array)});const n=this.attributes;for(const e in n){const i=n[e];t.data.attributes[e]=i.toJSON(t.data)}const i={};let r=!1;for(const e in this.morphAttributes){const n=this.morphAttributes[e],s=[];for(let e=0,i=n.length;e<i;e++){const i=n[e];s.push(i.toJSON(t.data))}s.length>0&&(i[e]=s,r=!0)}r&&(t.data.morphAttributes=i,t.data.morphTargetsRelative=this.morphTargetsRelative);const s=this.groups;s.length>0&&(t.data.groups=JSON.parse(JSON.stringify(s)));const a=this.boundingSphere;return null!==a&&(t.data.boundingSphere={center:a.center.toArray(),radius:a.radius}),t}clone(){return(new this.constructor).copy(this)}copy(t){this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null;const e={};this.name=t.name;const n=t.index;null!==n&&this.setIndex(n.clone(e));const i=t.attributes;for(const t in i){const n=i[t];this.setAttribute(t,n.clone(e))}const r=t.morphAttributes;for(const t in r){const n=[],i=r[t];for(let t=0,r=i.length;t<r;t++)n.push(i[t].clone(e));this.morphAttributes[t]=n}this.morphTargetsRelative=t.morphTargetsRelative;const s=t.groups;for(let t=0,e=s.length;t<e;t++){const e=s[t];this.addGroup(e.start,e.count,e.materialIndex)}const a=t.boundingBox;null!==a&&(this.boundingBox=a.clone());const o=t.boundingSphere;return null!==o&&(this.boundingSphere=o.clone()),this.drawRange.start=t.drawRange.start,this.drawRange.count=t.drawRange.count,this.userData=t.userData,void 0!==t.parameters&&(this.parameters=Object.assign({},t.parameters)),this}dispose(){this.dispatchEvent({type:"dispose"})}}const Dn=new Ie,On=new Pe,Nn=new we,Un=new ee,Fn=new ee,Bn=new ee,zn=new ee,kn=new ee,Gn=new ee,Vn=new ee,Hn=new ee,Wn=new ee,jn=new At,Xn=new At,Yn=new At,qn=new ee,Zn=new ee;class Jn extends rn{constructor(t=new In,e=new _n){super(),this.isMesh=!0,this.type="Mesh",this.geometry=t,this.material=e,this.updateMorphTargets()}copy(t,e){return super.copy(t,e),void 0!==t.morphTargetInfluences&&(this.morphTargetInfluences=t.morphTargetInfluences.slice()),void 0!==t.morphTargetDictionary&&(this.morphTargetDictionary=Object.assign({},t.morphTargetDictionary)),this.material=t.material,this.geometry=t.geometry,this}updateMorphTargets(){const t=this.geometry.morphAttributes,e=Object.keys(t);if(e.length>0){const n=t[e[0]];if(void 0!==n){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,e=n.length;t<e;t++){const e=n[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[e]=t}}}}raycast(t,e){const n=this.geometry,i=this.material,r=this.matrixWorld;if(void 0===i)return;if(null===n.boundingSphere&&n.computeBoundingSphere(),Nn.copy(n.boundingSphere),Nn.applyMatrix4(r),!1===t.ray.intersectsSphere(Nn))return;if(Dn.copy(r).invert(),On.copy(t.ray).applyMatrix4(Dn),null!==n.boundingBox&&!1===On.intersectsBox(n.boundingBox))return;let s;const a=n.index,o=n.attributes.position,l=n.morphAttributes.position,c=n.morphTargetsRelative,u=n.attributes.uv,h=n.attributes.uv2,d=n.groups,p=n.drawRange;if(null!==a)if(Array.isArray(i))for(let n=0,r=d.length;n<r;n++){const r=d[n],f=i[r.materialIndex];for(let n=Math.max(r.start,p.start),i=Math.min(a.count,Math.min(r.start+r.count,p.start+p.count));n<i;n+=3){const i=a.getX(n),d=a.getX(n+1),p=a.getX(n+2);s=Kn(this,f,t,On,o,l,c,u,h,i,d,p),s&&(s.faceIndex=Math.floor(n/3),s.face.materialIndex=r.materialIndex,e.push(s))}}else for(let n=Math.max(0,p.start),r=Math.min(a.count,p.start+p.count);n<r;n+=3){const r=a.getX(n),d=a.getX(n+1),p=a.getX(n+2);s=Kn(this,i,t,On,o,l,c,u,h,r,d,p),s&&(s.faceIndex=Math.floor(n/3),e.push(s))}else if(void 0!==o)if(Array.isArray(i))for(let n=0,r=d.length;n<r;n++){const r=d[n],a=i[r.materialIndex];for(let n=Math.max(r.start,p.start),i=Math.min(o.count,Math.min(r.start+r.count,p.start+p.count));n<i;n+=3)s=Kn(this,a,t,On,o,l,c,u,h,n,n+1,n+2),s&&(s.faceIndex=Math.floor(n/3),s.face.materialIndex=r.materialIndex,e.push(s))}else for(let n=Math.max(0,p.start),r=Math.min(o.count,p.start+p.count);n<r;n+=3)s=Kn(this,i,t,On,o,l,c,u,h,n,n+1,n+2),s&&(s.faceIndex=Math.floor(n/3),e.push(s))}}function Kn(t,e,n,i,r,s,a,o,l,c,u,h){Un.fromBufferAttribute(r,c),Fn.fromBufferAttribute(r,u),Bn.fromBufferAttribute(r,h);const d=t.morphTargetInfluences;if(s&&d){Vn.set(0,0,0),Hn.set(0,0,0),Wn.set(0,0,0);for(let t=0,e=s.length;t<e;t++){const e=d[t],n=s[t];0!==e&&(zn.fromBufferAttribute(n,c),kn.fromBufferAttribute(n,u),Gn.fromBufferAttribute(n,h),a?(Vn.addScaledVector(zn,e),Hn.addScaledVector(kn,e),Wn.addScaledVector(Gn,e)):(Vn.addScaledVector(zn.sub(Un),e),Hn.addScaledVector(kn.sub(Fn),e),Wn.addScaledVector(Gn.sub(Bn),e)))}Un.add(Vn),Fn.add(Hn),Bn.add(Wn)}t.isSkinnedMesh&&(t.boneTransform(c,Un),t.boneTransform(u,Fn),t.boneTransform(h,Bn));const p=function(t,e,n,i,r,s,a,o){let l;if(l=1===e.side?i.intersectTriangle(a,s,r,!0,o):i.intersectTriangle(r,s,a,2!==e.side,o),null===l)return null;Zn.copy(o),Zn.applyMatrix4(t.matrixWorld);const c=n.ray.origin.distanceTo(Zn);return c<n.near||c>n.far?null:{distance:c,point:Zn.clone(),object:t}}(t,e,n,i,Un,Fn,Bn,qn);if(p){o&&(jn.fromBufferAttribute(o,c),Xn.fromBufferAttribute(o,u),Yn.fromBufferAttribute(o,h),p.uv=mn.getUV(qn,Un,Fn,Bn,jn,Xn,Yn,new At)),l&&(jn.fromBufferAttribute(l,c),Xn.fromBufferAttribute(l,u),Yn.fromBufferAttribute(l,h),p.uv2=mn.getUV(qn,Un,Fn,Bn,jn,Xn,Yn,new At));const t={a:c,b:u,c:h,normal:new ee,materialIndex:0};mn.getNormal(Un,Fn,Bn,t.normal),p.face=t}return p}class $n extends In{constructor(t=1,e=1,n=1,i=1,r=1,s=1){super(),this.type="BoxGeometry",this.parameters={width:t,height:e,depth:n,widthSegments:i,heightSegments:r,depthSegments:s};const a=this;i=Math.floor(i),r=Math.floor(r),s=Math.floor(s);const o=[],l=[],c=[],u=[];let h=0,d=0;function p(t,e,n,i,r,s,p,f,m,g,v){const _=s/m,y=p/g,x=s/2,b=p/2,M=f/2,w=m+1,S=g+1;let E=0,T=0;const A=new ee;for(let s=0;s<S;s++){const a=s*y-b;for(let o=0;o<w;o++){const h=o*_-x;A[t]=h*i,A[e]=a*r,A[n]=M,l.push(A.x,A.y,A.z),A[t]=0,A[e]=0,A[n]=f>0?1:-1,c.push(A.x,A.y,A.z),u.push(o/m),u.push(1-s/g),E+=1}}for(let t=0;t<g;t++)for(let e=0;e<m;e++){const n=h+e+w*t,i=h+e+w*(t+1),r=h+(e+1)+w*(t+1),s=h+(e+1)+w*t;o.push(n,i,s),o.push(i,r,s),T+=6}a.addGroup(d,T,v),d+=T,h+=E}p("z","y","x",-1,-1,n,e,t,s,r,0),p("z","y","x",1,-1,n,e,-t,s,r,1),p("x","z","y",1,1,t,n,e,i,s,2),p("x","z","y",1,-1,t,n,-e,i,s,3),p("x","y","z",1,-1,t,e,n,i,r,4),p("x","y","z",-1,-1,t,e,-n,i,r,5),this.setIndex(o),this.setAttribute("position",new Sn(l,3)),this.setAttribute("normal",new Sn(c,3)),this.setAttribute("uv",new Sn(u,2))}static fromJSON(t){return new $n(t.width,t.height,t.depth,t.widthSegments,t.heightSegments,t.depthSegments)}}function Qn(t){const e={};for(const n in t){e[n]={};for(const i in t[n]){const r=t[n][i];r&&(r.isColor||r.isMatrix3||r.isMatrix4||r.isVector2||r.isVector3||r.isVector4||r.isTexture||r.isQuaternion)?e[n][i]=r.clone():Array.isArray(r)?e[n][i]=r.slice():e[n][i]=r}}return e}function ti(t){const e={};for(let n=0;n<t.length;n++){const i=Qn(t[n]);for(const t in i)e[t]=i[t]}return e}const ei={clone:Qn,merge:ti};class ni extends vn{constructor(t){super(),this.isShaderMaterial=!0,this.type="ShaderMaterial",this.defines={},this.uniforms={},this.vertexShader="void main() {\n\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",this.fragmentShader="void main() {\n\tgl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}",this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.extensions={derivatives:!1,fragDepth:!1,drawBuffers:!1,shaderTextureLOD:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]},this.index0AttributeName=void 0,this.uniformsNeedUpdate=!1,this.glslVersion=null,void 0!==t&&(void 0!==t.attributes&&console.error("THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead."),this.setValues(t))}copy(t){return super.copy(t),this.fragmentShader=t.fragmentShader,this.vertexShader=t.vertexShader,this.uniforms=Qn(t.uniforms),this.defines=Object.assign({},t.defines),this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.fog=t.fog,this.lights=t.lights,this.clipping=t.clipping,this.extensions=Object.assign({},t.extensions),this.glslVersion=t.glslVersion,this}toJSON(t){const e=super.toJSON(t);e.glslVersion=this.glslVersion,e.uniforms={};for(const n in this.uniforms){const i=this.uniforms[n].value;i&&i.isTexture?e.uniforms[n]={type:"t",value:i.toJSON(t).uuid}:i&&i.isColor?e.uniforms[n]={type:"c",value:i.getHex()}:i&&i.isVector2?e.uniforms[n]={type:"v2",value:i.toArray()}:i&&i.isVector3?e.uniforms[n]={type:"v3",value:i.toArray()}:i&&i.isVector4?e.uniforms[n]={type:"v4",value:i.toArray()}:i&&i.isMatrix3?e.uniforms[n]={type:"m3",value:i.toArray()}:i&&i.isMatrix4?e.uniforms[n]={type:"m4",value:i.toArray()}:e.uniforms[n]={value:i}}Object.keys(this.defines).length>0&&(e.defines=this.defines),e.vertexShader=this.vertexShader,e.fragmentShader=this.fragmentShader;const n={};for(const t in this.extensions)!0===this.extensions[t]&&(n[t]=!0);return Object.keys(n).length>0&&(e.extensions=n),e}}class ii extends rn{constructor(){super(),this.isCamera=!0,this.type="Camera",this.matrixWorldInverse=new Ie,this.projectionMatrix=new Ie,this.projectionMatrixInverse=new Ie}copy(t,e){return super.copy(t,e),this.matrixWorldInverse.copy(t.matrixWorldInverse),this.projectionMatrix.copy(t.projectionMatrix),this.projectionMatrixInverse.copy(t.projectionMatrixInverse),this}getWorldDirection(t){this.updateWorldMatrix(!0,!1);const e=this.matrixWorld.elements;return t.set(-e[8],-e[9],-e[10]).normalize()}updateMatrixWorld(t){super.updateMatrixWorld(t),this.matrixWorldInverse.copy(this.matrixWorld).invert()}updateWorldMatrix(t,e){super.updateWorldMatrix(t,e),this.matrixWorldInverse.copy(this.matrixWorld).invert()}clone(){return(new this.constructor).copy(this)}}class ri extends ii{constructor(t=50,e=1,n=.1,i=2e3){super(),this.isPerspectiveCamera=!0,this.type="PerspectiveCamera",this.fov=t,this.zoom=1,this.near=n,this.far=i,this.focus=10,this.aspect=e,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()}copy(t,e){return super.copy(t,e),this.fov=t.fov,this.zoom=t.zoom,this.near=t.near,this.far=t.far,this.focus=t.focus,this.aspect=t.aspect,this.view=null===t.view?null:Object.assign({},t.view),this.filmGauge=t.filmGauge,this.filmOffset=t.filmOffset,this}setFocalLength(t){const e=.5*this.getFilmHeight()/t;this.fov=2*_t*Math.atan(e),this.updateProjectionMatrix()}getFocalLength(){const t=Math.tan(.5*vt*this.fov);return.5*this.getFilmHeight()/t}getEffectiveFOV(){return 2*_t*Math.atan(Math.tan(.5*vt*this.fov)/this.zoom)}getFilmWidth(){return this.filmGauge*Math.min(this.aspect,1)}getFilmHeight(){return this.filmGauge/Math.max(this.aspect,1)}setViewOffset(t,e,n,i,r,s){this.aspect=t/e,null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=t,this.view.fullHeight=e,this.view.offsetX=n,this.view.offsetY=i,this.view.width=r,this.view.height=s,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const t=this.near;let e=t*Math.tan(.5*vt*this.fov)/this.zoom,n=2*e,i=this.aspect*n,r=-.5*i;const s=this.view;if(null!==this.view&&this.view.enabled){const t=s.fullWidth,a=s.fullHeight;r+=s.offsetX*i/t,e-=s.offsetY*n/a,i*=s.width/t,n*=s.height/a}const a=this.filmOffset;0!==a&&(r+=t*a/this.getFilmWidth()),this.projectionMatrix.makePerspective(r,r+i,e,e-n,t,this.far),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(t){const e=super.toJSON(t);return e.object.fov=this.fov,e.object.zoom=this.zoom,e.object.near=this.near,e.object.far=this.far,e.object.focus=this.focus,e.object.aspect=this.aspect,null!==this.view&&(e.object.view=Object.assign({},this.view)),e.object.filmGauge=this.filmGauge,e.object.filmOffset=this.filmOffset,e}}const si=90;class ai extends rn{constructor(t,e,n){if(super(),this.type="CubeCamera",!0!==n.isWebGLCubeRenderTarget)return void console.error("THREE.CubeCamera: The constructor now expects an instance of WebGLCubeRenderTarget as third parameter.");this.renderTarget=n;const i=new ri(si,1,t,e);i.layers=this.layers,i.up.set(0,-1,0),i.lookAt(new ee(1,0,0)),this.add(i);const r=new ri(si,1,t,e);r.layers=this.layers,r.up.set(0,-1,0),r.lookAt(new ee(-1,0,0)),this.add(r);const s=new ri(si,1,t,e);s.layers=this.layers,s.up.set(0,0,1),s.lookAt(new ee(0,1,0)),this.add(s);const a=new ri(si,1,t,e);a.layers=this.layers,a.up.set(0,0,-1),a.lookAt(new ee(0,-1,0)),this.add(a);const o=new ri(si,1,t,e);o.layers=this.layers,o.up.set(0,-1,0),o.lookAt(new ee(0,0,1)),this.add(o);const l=new ri(si,1,t,e);l.layers=this.layers,l.up.set(0,-1,0),l.lookAt(new ee(0,0,-1)),this.add(l)}update(t,e){null===this.parent&&this.updateMatrixWorld();const n=this.renderTarget,[i,r,s,a,o,l]=this.children,c=t.getRenderTarget(),u=t.toneMapping,h=t.xr.enabled;t.toneMapping=0,t.xr.enabled=!1;const d=n.texture.generateMipmaps;n.texture.generateMipmaps=!1,t.setRenderTarget(n,0),t.render(e,i),t.setRenderTarget(n,1),t.render(e,r),t.setRenderTarget(n,2),t.render(e,s),t.setRenderTarget(n,3),t.render(e,a),t.setRenderTarget(n,4),t.render(e,o),n.texture.generateMipmaps=d,t.setRenderTarget(n,5),t.render(e,l),t.setRenderTarget(c),t.toneMapping=u,t.xr.enabled=h,n.texture.needsPMREMUpdate=!0}}class oi extends Zt{constructor(t,e,n,i,r,a,o,l,c,u){super(t=void 0!==t?t:[],e=void 0!==e?e:s,n,i,r,a,o,l,c,u),this.isCubeTexture=!0,this.flipY=!1}get images(){return this.image}set images(t){this.image=t}}class li extends Kt{constructor(t,e={}){super(t,t,e),this.isWebGLCubeRenderTarget=!0;const n={width:t,height:t,depth:1},i=[n,n,n,n,n,n];this.texture=new oi(i,e.mapping,e.wrapS,e.wrapT,e.magFilter,e.minFilter,e.format,e.type,e.anisotropy,e.encoding),this.texture.isRenderTargetTexture=!0,this.texture.generateMipmaps=void 0!==e.generateMipmaps&&e.generateMipmaps,this.texture.minFilter=void 0!==e.minFilter?e.minFilter:g}fromEquirectangularTexture(t,e){this.texture.type=e.type,this.texture.encoding=e.encoding,this.texture.generateMipmaps=e.generateMipmaps,this.texture.minFilter=e.minFilter,this.texture.magFilter=e.magFilter;const n={tEquirect:{value:null}},i="\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\tvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\n\t\t\t\t\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n\n\t\t\t\t}\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvWorldDirection = transformDirection( position, modelMatrix );\n\n\t\t\t\t\t#include <begin_vertex>\n\t\t\t\t\t#include <project_vertex>\n\n\t\t\t\t}\n\t\t\t",r="\n\n\t\t\t\tuniform sampler2D tEquirect;\n\n\t\t\t\tvarying vec3 vWorldDirection;\n\n\t\t\t\t#include <common>\n\n\t\t\t\tvoid main() {\n\n\t\t\t\t\tvec3 direction = normalize( vWorldDirection );\n\n\t\t\t\t\tvec2 sampleUV = equirectUv( direction );\n\n\t\t\t\t\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\n\t\t\t\t}\n\t\t\t",s=new $n(5,5,5),a=new ni({name:"CubemapFromEquirect",uniforms:Qn(n),vertexShader:i,fragmentShader:r,side:1,blending:0});a.uniforms.tEquirect.value=e;const o=new Jn(s,a),l=e.minFilter;return e.minFilter===_&&(e.minFilter=g),new ai(1,10,this).update(t,o),e.minFilter=l,o.geometry.dispose(),o.material.dispose(),this}clear(t,e,n,i){const r=t.getRenderTarget();for(let r=0;r<6;r++)t.setRenderTarget(this,r),t.clear(e,n,i);t.setRenderTarget(r)}}const ci=new ee,ui=new ee,hi=new Rt;class di{constructor(t=new ee(1,0,0),e=0){this.isPlane=!0,this.normal=t,this.constant=e}set(t,e){return this.normal.copy(t),this.constant=e,this}setComponents(t,e,n,i){return this.normal.set(t,e,n),this.constant=i,this}setFromNormalAndCoplanarPoint(t,e){return this.normal.copy(t),this.constant=-e.dot(this.normal),this}setFromCoplanarPoints(t,e,n){const i=ci.subVectors(n,e).cross(ui.subVectors(t,e)).normalize();return this.setFromNormalAndCoplanarPoint(i,t),this}copy(t){return this.normal.copy(t.normal),this.constant=t.constant,this}normalize(){const t=1/this.normal.length();return this.normal.multiplyScalar(t),this.constant*=t,this}negate(){return this.constant*=-1,this.normal.negate(),this}distanceToPoint(t){return this.normal.dot(t)+this.constant}distanceToSphere(t){return this.distanceToPoint(t.center)-t.radius}projectPoint(t,e){return e.copy(this.normal).multiplyScalar(-this.distanceToPoint(t)).add(t)}intersectLine(t,e){const n=t.delta(ci),i=this.normal.dot(n);if(0===i)return 0===this.distanceToPoint(t.start)?e.copy(t.start):null;const r=-(t.start.dot(this.normal)+this.constant)/i;return r<0||r>1?null:e.copy(n).multiplyScalar(r).add(t.start)}intersectsLine(t){const e=this.distanceToPoint(t.start),n=this.distanceToPoint(t.end);return e<0&&n>0||n<0&&e>0}intersectsBox(t){return t.intersectsPlane(this)}intersectsSphere(t){return t.intersectsPlane(this)}coplanarPoint(t){return t.copy(this.normal).multiplyScalar(-this.constant)}applyMatrix4(t,e){const n=e||hi.getNormalMatrix(t),i=this.coplanarPoint(ci).applyMatrix4(t),r=this.normal.applyMatrix3(n).normalize();return this.constant=-i.dot(r),this}translate(t){return this.constant-=t.dot(this.normal),this}equals(t){return t.normal.equals(this.normal)&&t.constant===this.constant}clone(){return(new this.constructor).copy(this)}}const pi=new we,fi=new ee;class mi{constructor(t=new di,e=new di,n=new di,i=new di,r=new di,s=new di){this.planes=[t,e,n,i,r,s]}set(t,e,n,i,r,s){const a=this.planes;return a[0].copy(t),a[1].copy(e),a[2].copy(n),a[3].copy(i),a[4].copy(r),a[5].copy(s),this}copy(t){const e=this.planes;for(let n=0;n<6;n++)e[n].copy(t.planes[n]);return this}setFromProjectionMatrix(t){const e=this.planes,n=t.elements,i=n[0],r=n[1],s=n[2],a=n[3],o=n[4],l=n[5],c=n[6],u=n[7],h=n[8],d=n[9],p=n[10],f=n[11],m=n[12],g=n[13],v=n[14],_=n[15];return e[0].setComponents(a-i,u-o,f-h,_-m).normalize(),e[1].setComponents(a+i,u+o,f+h,_+m).normalize(),e[2].setComponents(a+r,u+l,f+d,_+g).normalize(),e[3].setComponents(a-r,u-l,f-d,_-g).normalize(),e[4].setComponents(a-s,u-c,f-p,_-v).normalize(),e[5].setComponents(a+s,u+c,f+p,_+v).normalize(),this}intersectsObject(t){const e=t.geometry;return null===e.boundingSphere&&e.computeBoundingSphere(),pi.copy(e.boundingSphere).applyMatrix4(t.matrixWorld),this.intersectsSphere(pi)}intersectsSprite(t){return pi.center.set(0,0,0),pi.radius=.7071067811865476,pi.applyMatrix4(t.matrixWorld),this.intersectsSphere(pi)}intersectsSphere(t){const e=this.planes,n=t.center,i=-t.radius;for(let t=0;t<6;t++)if(e[t].distanceToPoint(n)<i)return!1;return!0}intersectsBox(t){const e=this.planes;for(let n=0;n<6;n++){const i=e[n];if(fi.x=i.normal.x>0?t.max.x:t.min.x,fi.y=i.normal.y>0?t.max.y:t.min.y,fi.z=i.normal.z>0?t.max.z:t.min.z,i.distanceToPoint(fi)<0)return!1}return!0}containsPoint(t){const e=this.planes;for(let n=0;n<6;n++)if(e[n].distanceToPoint(t)<0)return!1;return!0}clone(){return(new this.constructor).copy(this)}}function gi(){let t=null,e=!1,n=null,i=null;function r(e,s){n(e,s),i=t.requestAnimationFrame(r)}return{start:function(){!0!==e&&null!==n&&(i=t.requestAnimationFrame(r),e=!0)},stop:function(){t.cancelAnimationFrame(i),e=!1},setAnimationLoop:function(t){n=t},setContext:function(e){t=e}}}function vi(t,e){const n=e.isWebGL2,i=new WeakMap;return{get:function(t){return t.isInterleavedBufferAttribute&&(t=t.data),i.get(t)},remove:function(e){e.isInterleavedBufferAttribute&&(e=e.data);const n=i.get(e);n&&(t.deleteBuffer(n.buffer),i.delete(e))},update:function(e,r){if(e.isGLBufferAttribute){const t=i.get(e);return void((!t||t.version<e.version)&&i.set(e,{buffer:e.buffer,type:e.type,bytesPerElement:e.elementSize,version:e.version}))}e.isInterleavedBufferAttribute&&(e=e.data);const s=i.get(e);void 0===s?i.set(e,function(e,i){const r=e.array,s=e.usage,a=t.createBuffer();let o;if(t.bindBuffer(i,a),t.bufferData(i,r,s),e.onUploadCallback(),r instanceof Float32Array)o=t.FLOAT;else if(r instanceof Uint16Array)if(e.isFloat16BufferAttribute){if(!n)throw new Error("THREE.WebGLAttributes: Usage of Float16BufferAttribute requires WebGL2.");o=t.HALF_FLOAT}else o=t.UNSIGNED_SHORT;else if(r instanceof Int16Array)o=t.SHORT;else if(r instanceof Uint32Array)o=t.UNSIGNED_INT;else if(r instanceof Int32Array)o=t.INT;else if(r instanceof Int8Array)o=t.BYTE;else if(r instanceof Uint8Array)o=t.UNSIGNED_BYTE;else{if(!(r instanceof Uint8ClampedArray))throw new Error("THREE.WebGLAttributes: Unsupported buffer data format: "+r);o=t.UNSIGNED_BYTE}return{buffer:a,type:o,bytesPerElement:r.BYTES_PER_ELEMENT,version:e.version}}(e,r)):s.version<e.version&&(function(e,i,r){const s=i.array,a=i.updateRange;t.bindBuffer(r,e),-1===a.count?t.bufferSubData(r,0,s):(n?t.bufferSubData(r,a.offset*s.BYTES_PER_ELEMENT,s,a.offset,a.count):t.bufferSubData(r,a.offset*s.BYTES_PER_ELEMENT,s.subarray(a.offset,a.offset+a.count)),a.count=-1)}(s.buffer,e,r),s.version=e.version)}}}class _i extends In{constructor(t=1,e=1,n=1,i=1){super(),this.type="PlaneGeometry",this.parameters={width:t,height:e,widthSegments:n,heightSegments:i};const r=t/2,s=e/2,a=Math.floor(n),o=Math.floor(i),l=a+1,c=o+1,u=t/a,h=e/o,d=[],p=[],f=[],m=[];for(let t=0;t<c;t++){const e=t*h-s;for(let n=0;n<l;n++){const i=n*u-r;p.push(i,-e,0),f.push(0,0,1),m.push(n/a),m.push(1-t/o)}}for(let t=0;t<o;t++)for(let e=0;e<a;e++){const n=e+l*t,i=e+l*(t+1),r=e+1+l*(t+1),s=e+1+l*t;d.push(n,i,s),d.push(i,r,s)}this.setIndex(d),this.setAttribute("position",new Sn(p,3)),this.setAttribute("normal",new Sn(f,3)),this.setAttribute("uv",new Sn(m,2))}static fromJSON(t){return new _i(t.width,t.height,t.widthSegments,t.heightSegments)}}const yi={alphamap_fragment:"#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif",alphamap_pars_fragment:"#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",alphatest_fragment:"#ifdef USE_ALPHATEST\n\tif ( diffuseColor.a < alphaTest ) discard;\n#endif",alphatest_pars_fragment:"#ifdef USE_ALPHATEST\n\tuniform float alphaTest;\n#endif",aomap_fragment:"#ifdef USE_AOMAP\n\tfloat ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n\treflectedLight.indirectDiffuse *= ambientOcclusion;\n\t#if defined( USE_ENVMAP ) && defined( STANDARD )\n\t\tfloat dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n\t\treflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.roughness );\n\t#endif\n#endif",aomap_pars_fragment:"#ifdef USE_AOMAP\n\tuniform sampler2D aoMap;\n\tuniform float aoMapIntensity;\n#endif",begin_vertex:"vec3 transformed = vec3( position );",beginnormal_vertex:"vec3 objectNormal = vec3( normal );\n#ifdef USE_TANGENT\n\tvec3 objectTangent = vec3( tangent.xyz );\n#endif",bsdfs:"vec3 BRDF_Lambert( const in vec3 diffuseColor ) {\n\treturn RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n}\nfloat F_Schlick( const in float f0, const in float f90, const in float dotVH ) {\n\tfloat fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );\n\treturn f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );\n}\nvec3 Schlick_to_F0( const in vec3 f, const in float f90, const in float dotVH ) {\n\t\tfloat x = clamp( 1.0 - dotVH, 0.0, 1.0 );\n\t\tfloat x2 = x * x;\n\t\tfloat x5 = clamp( x * x2 * x2, 0.0, 0.9999 );\n\t\treturn ( f - vec3( f90 ) * x5 ) / ( 1.0 - x5 );\n}\nfloat V_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n\tfloat a2 = pow2( alpha );\n\tfloat gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n\tfloat gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n\treturn 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n\tfloat a2 = pow2( alpha );\n\tfloat denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n\treturn RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_GGX( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in vec3 f0, const in float f90, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( f0, f90, dotVH );\n\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( V * D );\n}\n#ifdef USE_IRIDESCENCE\nvec3 BRDF_GGX_Iridescence( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in vec3 f0, const in float f90, const in float iridescence, const in vec3 iridescenceFresnel, const in float roughness ) {\n\tfloat alpha = pow2( roughness );\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = mix(F_Schlick( f0, f90, dotVH ), iridescenceFresnel, iridescence);\n\tfloat V = V_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n\tfloat D = D_GGX( alpha, dotNH );\n\treturn F * ( V * D );\n}\n#endif\nvec2 LTC_Uv( const in vec3 N, const in vec3 V, const in float roughness ) {\n\tconst float LUT_SIZE = 64.0;\n\tconst float LUT_SCALE = ( LUT_SIZE - 1.0 ) / LUT_SIZE;\n\tconst float LUT_BIAS = 0.5 / LUT_SIZE;\n\tfloat dotNV = saturate( dot( N, V ) );\n\tvec2 uv = vec2( roughness, sqrt( 1.0 - dotNV ) );\n\tuv = uv * LUT_SCALE + LUT_BIAS;\n\treturn uv;\n}\nfloat LTC_ClippedSphereFormFactor( const in vec3 f ) {\n\tfloat l = length( f );\n\treturn max( ( l * l + f.z ) / ( l + 1.0 ), 0.0 );\n}\nvec3 LTC_EdgeVectorFormFactor( const in vec3 v1, const in vec3 v2 ) {\n\tfloat x = dot( v1, v2 );\n\tfloat y = abs( x );\n\tfloat a = 0.8543985 + ( 0.4965155 + 0.0145206 * y ) * y;\n\tfloat b = 3.4175940 + ( 4.1616724 + y ) * y;\n\tfloat v = a / b;\n\tfloat theta_sintheta = ( x > 0.0 ) ? v : 0.5 * inversesqrt( max( 1.0 - x * x, 1e-7 ) ) - v;\n\treturn cross( v1, v2 ) * theta_sintheta;\n}\nvec3 LTC_Evaluate( const in vec3 N, const in vec3 V, const in vec3 P, const in mat3 mInv, const in vec3 rectCoords[ 4 ] ) {\n\tvec3 v1 = rectCoords[ 1 ] - rectCoords[ 0 ];\n\tvec3 v2 = rectCoords[ 3 ] - rectCoords[ 0 ];\n\tvec3 lightNormal = cross( v1, v2 );\n\tif( dot( lightNormal, P - rectCoords[ 0 ] ) < 0.0 ) return vec3( 0.0 );\n\tvec3 T1, T2;\n\tT1 = normalize( V - N * dot( V, N ) );\n\tT2 = - cross( N, T1 );\n\tmat3 mat = mInv * transposeMat3( mat3( T1, T2, N ) );\n\tvec3 coords[ 4 ];\n\tcoords[ 0 ] = mat * ( rectCoords[ 0 ] - P );\n\tcoords[ 1 ] = mat * ( rectCoords[ 1 ] - P );\n\tcoords[ 2 ] = mat * ( rectCoords[ 2 ] - P );\n\tcoords[ 3 ] = mat * ( rectCoords[ 3 ] - P );\n\tcoords[ 0 ] = normalize( coords[ 0 ] );\n\tcoords[ 1 ] = normalize( coords[ 1 ] );\n\tcoords[ 2 ] = normalize( coords[ 2 ] );\n\tcoords[ 3 ] = normalize( coords[ 3 ] );\n\tvec3 vectorFormFactor = vec3( 0.0 );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 0 ], coords[ 1 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 1 ], coords[ 2 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 2 ], coords[ 3 ] );\n\tvectorFormFactor += LTC_EdgeVectorFormFactor( coords[ 3 ], coords[ 0 ] );\n\tfloat result = LTC_ClippedSphereFormFactor( vectorFormFactor );\n\treturn vec3( result );\n}\nfloat G_BlinnPhong_Implicit( ) {\n\treturn 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n\treturn RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_BlinnPhong( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in vec3 specularColor, const in float shininess ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat dotVH = saturate( dot( viewDir, halfDir ) );\n\tvec3 F = F_Schlick( specularColor, 1.0, dotVH );\n\tfloat G = G_BlinnPhong_Implicit( );\n\tfloat D = D_BlinnPhong( shininess, dotNH );\n\treturn F * ( G * D );\n}\n#if defined( USE_SHEEN )\nfloat D_Charlie( float roughness, float dotNH ) {\n\tfloat alpha = pow2( roughness );\n\tfloat invAlpha = 1.0 / alpha;\n\tfloat cos2h = dotNH * dotNH;\n\tfloat sin2h = max( 1.0 - cos2h, 0.0078125 );\n\treturn ( 2.0 + invAlpha ) * pow( sin2h, invAlpha * 0.5 ) / ( 2.0 * PI );\n}\nfloat V_Neubelt( float dotNV, float dotNL ) {\n\treturn saturate( 1.0 / ( 4.0 * ( dotNL + dotNV - dotNL * dotNV ) ) );\n}\nvec3 BRDF_Sheen( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, vec3 sheenColor, const in float sheenRoughness ) {\n\tvec3 halfDir = normalize( lightDir + viewDir );\n\tfloat dotNL = saturate( dot( normal, lightDir ) );\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat dotNH = saturate( dot( normal, halfDir ) );\n\tfloat D = D_Charlie( sheenRoughness, dotNH );\n\tfloat V = V_Neubelt( dotNV, dotNL );\n\treturn sheenColor * ( D * V );\n}\n#endif",iridescence_fragment:"#ifdef USE_IRIDESCENCE\nconst mat3 XYZ_TO_REC709 = mat3(\n\t\t3.2404542, -0.9692660,\t0.0556434,\n\t -1.5371385,\t1.8760108, -0.2040259,\n\t -0.4985314,\t0.0415560,\t1.0572252\n);\nvec3 Fresnel0ToIor( vec3 fresnel0 ) {\n\t vec3 sqrtF0 = sqrt( fresnel0 );\n\t return ( vec3( 1.0 ) + sqrtF0 ) / ( vec3( 1.0 ) - sqrtF0 );\n}\nvec3 IorToFresnel0( vec3 transmittedIor, float incidentIor ) {\n\t return pow2( ( transmittedIor - vec3( incidentIor ) ) / ( transmittedIor + vec3( incidentIor ) ) );\n}\nfloat IorToFresnel0( float transmittedIor, float incidentIor ) {\n\t return pow2( ( transmittedIor - incidentIor ) / ( transmittedIor + incidentIor ));\n}\nvec3 evalSensitivity( float OPD, vec3 shift ) {\n\t float phase = 2.0 * PI * OPD * 1.0e-9;\n\t vec3 val = vec3( 5.4856e-13, 4.4201e-13, 5.2481e-13 );\n\t vec3 pos = vec3( 1.6810e+06, 1.7953e+06, 2.2084e+06 );\n\t vec3 var = vec3( 4.3278e+09, 9.3046e+09, 6.6121e+09 );\n\t vec3 xyz = val * sqrt( 2.0 * PI * var ) * cos( pos * phase + shift ) * exp( -pow2( phase ) * var );\n\t xyz.x += 9.7470e-14 * sqrt( 2.0 * PI * 4.5282e+09 ) * cos( 2.2399e+06 * phase + shift[0] ) * exp( -4.5282e+09 * pow2( phase ) );\n\t xyz /= 1.0685e-7;\n\t vec3 srgb = XYZ_TO_REC709 * xyz;\n\t return srgb;\n}\nvec3 evalIridescence( float outsideIOR, float eta2, float cosTheta1, float thinFilmThickness, vec3 baseF0 ) {\n\t vec3 I;\n\t float iridescenceIOR = mix( outsideIOR, eta2, smoothstep( 0.0, 0.03, thinFilmThickness ) );\n\t float sinTheta2Sq = pow2( outsideIOR / iridescenceIOR ) * ( 1.0 - pow2( cosTheta1 ) );\n\t float cosTheta2Sq = 1.0 - sinTheta2Sq;\n\t if ( cosTheta2Sq < 0.0 ) {\n\t\t\t return vec3( 1.0 );\n\t }\n\t float cosTheta2 = sqrt( cosTheta2Sq );\n\t float R0 = IorToFresnel0( iridescenceIOR, outsideIOR );\n\t float R12 = F_Schlick( R0, 1.0, cosTheta1 );\n\t float R21 = R12;\n\t float T121 = 1.0 - R12;\n\t float phi12 = 0.0;\n\t if ( iridescenceIOR < outsideIOR ) phi12 = PI;\n\t float phi21 = PI - phi12;\n\t vec3 baseIOR = Fresnel0ToIor( clamp( baseF0, 0.0, 0.9999 ) );\t vec3 R1 = IorToFresnel0( baseIOR, iridescenceIOR );\n\t vec3 R23 = F_Schlick( R1, 1.0, cosTheta2 );\n\t vec3 phi23 = vec3( 0.0 );\n\t if ( baseIOR[0] < iridescenceIOR ) phi23[0] = PI;\n\t if ( baseIOR[1] < iridescenceIOR ) phi23[1] = PI;\n\t if ( baseIOR[2] < iridescenceIOR ) phi23[2] = PI;\n\t float OPD = 2.0 * iridescenceIOR * thinFilmThickness * cosTheta2;\n\t vec3 phi = vec3( phi21 ) + phi23;\n\t vec3 R123 = clamp( R12 * R23, 1e-5, 0.9999 );\n\t vec3 r123 = sqrt( R123 );\n\t vec3 Rs = pow2( T121 ) * R23 / ( vec3( 1.0 ) - R123 );\n\t vec3 C0 = R12 + Rs;\n\t I = C0;\n\t vec3 Cm = Rs - T121;\n\t for ( int m = 1; m <= 2; ++m ) {\n\t\t\t Cm *= r123;\n\t\t\t vec3 Sm = 2.0 * evalSensitivity( float( m ) * OPD, float( m ) * phi );\n\t\t\t I += Cm * Sm;\n\t }\n\t return max( I, vec3( 0.0 ) );\n}\n#endif",bumpmap_pars_fragment:"#ifdef USE_BUMPMAP\n\tuniform sampler2D bumpMap;\n\tuniform float bumpScale;\n\tvec2 dHdxy_fwd() {\n\t\tvec2 dSTdx = dFdx( vUv );\n\t\tvec2 dSTdy = dFdy( vUv );\n\t\tfloat Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n\t\tfloat dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n\t\tfloat dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n\t\treturn vec2( dBx, dBy );\n\t}\n\tvec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy, float faceDirection ) {\n\t\tvec3 vSigmaX = vec3( dFdx( surf_pos.x ), dFdx( surf_pos.y ), dFdx( surf_pos.z ) );\n\t\tvec3 vSigmaY = vec3( dFdy( surf_pos.x ), dFdy( surf_pos.y ), dFdy( surf_pos.z ) );\n\t\tvec3 vN = surf_norm;\n\t\tvec3 R1 = cross( vSigmaY, vN );\n\t\tvec3 R2 = cross( vN, vSigmaX );\n\t\tfloat fDet = dot( vSigmaX, R1 ) * faceDirection;\n\t\tvec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n\t\treturn normalize( abs( fDet ) * surf_norm - vGrad );\n\t}\n#endif",clipping_planes_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tvec4 plane;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < UNION_CLIPPING_PLANES; i ++ ) {\n\t\tplane = clippingPlanes[ i ];\n\t\tif ( dot( vClipPosition, plane.xyz ) > plane.w ) discard;\n\t}\n\t#pragma unroll_loop_end\n\t#if UNION_CLIPPING_PLANES < NUM_CLIPPING_PLANES\n\t\tbool clipped = true;\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = UNION_CLIPPING_PLANES; i < NUM_CLIPPING_PLANES; i ++ ) {\n\t\t\tplane = clippingPlanes[ i ];\n\t\t\tclipped = ( dot( vClipPosition, plane.xyz ) > plane.w ) && clipped;\n\t\t}\n\t\t#pragma unroll_loop_end\n\t\tif ( clipped ) discard;\n\t#endif\n#endif",clipping_planes_pars_fragment:"#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n\tuniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif",clipping_planes_pars_vertex:"#if NUM_CLIPPING_PLANES > 0\n\tvarying vec3 vClipPosition;\n#endif",clipping_planes_vertex:"#if NUM_CLIPPING_PLANES > 0\n\tvClipPosition = - mvPosition.xyz;\n#endif",color_fragment:"#if defined( USE_COLOR_ALPHA )\n\tdiffuseColor *= vColor;\n#elif defined( USE_COLOR )\n\tdiffuseColor.rgb *= vColor;\n#endif",color_pars_fragment:"#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR )\n\tvarying vec3 vColor;\n#endif",color_pars_vertex:"#if defined( USE_COLOR_ALPHA )\n\tvarying vec4 vColor;\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR )\n\tvarying vec3 vColor;\n#endif",color_vertex:"#if defined( USE_COLOR_ALPHA )\n\tvColor = vec4( 1.0 );\n#elif defined( USE_COLOR ) || defined( USE_INSTANCING_COLOR )\n\tvColor = vec3( 1.0 );\n#endif\n#ifdef USE_COLOR\n\tvColor *= color;\n#endif\n#ifdef USE_INSTANCING_COLOR\n\tvColor.xyz *= instanceColor.xyz;\n#endif",common:"#define PI 3.141592653589793\n#define PI2 6.283185307179586\n#define PI_HALF 1.5707963267948966\n#define RECIPROCAL_PI 0.3183098861837907\n#define RECIPROCAL_PI2 0.15915494309189535\n#define EPSILON 1e-6\n#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\n#define whiteComplement( a ) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nvec3 pow2( const in vec3 x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat max3( const in vec3 v ) { return max( max( v.x, v.y ), v.z ); }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n\tconst highp float a = 12.9898, b = 78.233, c = 43758.5453;\n\thighp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n\treturn fract( sin( sn ) * c );\n}\n#ifdef HIGH_PRECISION\n\tfloat precisionSafeLength( vec3 v ) { return length( v ); }\n#else\n\tfloat precisionSafeLength( vec3 v ) {\n\t\tfloat maxComponent = max3( abs( v ) );\n\t\treturn length( v / maxComponent ) * maxComponent;\n\t}\n#endif\nstruct IncidentLight {\n\tvec3 color;\n\tvec3 direction;\n\tbool visible;\n};\nstruct ReflectedLight {\n\tvec3 directDiffuse;\n\tvec3 directSpecular;\n\tvec3 indirectDiffuse;\n\tvec3 indirectSpecular;\n};\nstruct GeometricContext {\n\tvec3 position;\n\tvec3 normal;\n\tvec3 viewDir;\n#ifdef USE_CLEARCOAT\n\tvec3 clearcoatNormal;\n#endif\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n\treturn normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nmat3 transposeMat3( const in mat3 m ) {\n\tmat3 tmp;\n\ttmp[ 0 ] = vec3( m[ 0 ].x, m[ 1 ].x, m[ 2 ].x );\n\ttmp[ 1 ] = vec3( m[ 0 ].y, m[ 1 ].y, m[ 2 ].y );\n\ttmp[ 2 ] = vec3( m[ 0 ].z, m[ 1 ].z, m[ 2 ].z );\n\treturn tmp;\n}\nfloat linearToRelativeLuminance( const in vec3 color ) {\n\tvec3 weights = vec3( 0.2126, 0.7152, 0.0722 );\n\treturn dot( weights, color.rgb );\n}\nbool isPerspectiveMatrix( mat4 m ) {\n\treturn m[ 2 ][ 3 ] == - 1.0;\n}\nvec2 equirectUv( in vec3 dir ) {\n\tfloat u = atan( dir.z, dir.x ) * RECIPROCAL_PI2 + 0.5;\n\tfloat v = asin( clamp( dir.y, - 1.0, 1.0 ) ) * RECIPROCAL_PI + 0.5;\n\treturn vec2( u, v );\n}",cube_uv_reflection_fragment:"#ifdef ENVMAP_TYPE_CUBE_UV\n\t#define cubeUV_minMipLevel 4.0\n\t#define cubeUV_minTileSize 16.0\n\tfloat getFace( vec3 direction ) {\n\t\tvec3 absDirection = abs( direction );\n\t\tfloat face = - 1.0;\n\t\tif ( absDirection.x > absDirection.z ) {\n\t\t\tif ( absDirection.x > absDirection.y )\n\t\t\t\tface = direction.x > 0.0 ? 0.0 : 3.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t} else {\n\t\t\tif ( absDirection.z > absDirection.y )\n\t\t\t\tface = direction.z > 0.0 ? 2.0 : 5.0;\n\t\t\telse\n\t\t\t\tface = direction.y > 0.0 ? 1.0 : 4.0;\n\t\t}\n\t\treturn face;\n\t}\n\tvec2 getUV( vec3 direction, float face ) {\n\t\tvec2 uv;\n\t\tif ( face == 0.0 ) {\n\t\t\tuv = vec2( direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 1.0 ) {\n\t\t\tuv = vec2( - direction.x, - direction.z ) / abs( direction.y );\n\t\t} else if ( face == 2.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.y ) / abs( direction.z );\n\t\t} else if ( face == 3.0 ) {\n\t\t\tuv = vec2( - direction.z, direction.y ) / abs( direction.x );\n\t\t} else if ( face == 4.0 ) {\n\t\t\tuv = vec2( - direction.x, direction.z ) / abs( direction.y );\n\t\t} else {\n\t\t\tuv = vec2( direction.x, direction.y ) / abs( direction.z );\n\t\t}\n\t\treturn 0.5 * ( uv + 1.0 );\n\t}\n\tvec3 bilinearCubeUV( sampler2D envMap, vec3 direction, float mipInt ) {\n\t\tfloat face = getFace( direction );\n\t\tfloat filterInt = max( cubeUV_minMipLevel - mipInt, 0.0 );\n\t\tmipInt = max( mipInt, cubeUV_minMipLevel );\n\t\tfloat faceSize = exp2( mipInt );\n\t\tvec2 uv = getUV( direction, face ) * ( faceSize - 2.0 ) + 1.0;\n\t\tif ( face > 2.0 ) {\n\t\t\tuv.y += faceSize;\n\t\t\tface -= 3.0;\n\t\t}\n\t\tuv.x += face * faceSize;\n\t\tuv.x += filterInt * 3.0 * cubeUV_minTileSize;\n\t\tuv.y += 4.0 * ( exp2( CUBEUV_MAX_MIP ) - faceSize );\n\t\tuv.x *= CUBEUV_TEXEL_WIDTH;\n\t\tuv.y *= CUBEUV_TEXEL_HEIGHT;\n\t\t#ifdef texture2DGradEXT\n\t\t\treturn texture2DGradEXT( envMap, uv, vec2( 0.0 ), vec2( 0.0 ) ).rgb;\n\t\t#else\n\t\t\treturn texture2D( envMap, uv ).rgb;\n\t\t#endif\n\t}\n\t#define r0 1.0\n\t#define v0 0.339\n\t#define m0 - 2.0\n\t#define r1 0.8\n\t#define v1 0.276\n\t#define m1 - 1.0\n\t#define r4 0.4\n\t#define v4 0.046\n\t#define m4 2.0\n\t#define r5 0.305\n\t#define v5 0.016\n\t#define m5 3.0\n\t#define r6 0.21\n\t#define v6 0.0038\n\t#define m6 4.0\n\tfloat roughnessToMip( float roughness ) {\n\t\tfloat mip = 0.0;\n\t\tif ( roughness >= r1 ) {\n\t\t\tmip = ( r0 - roughness ) * ( m1 - m0 ) / ( r0 - r1 ) + m0;\n\t\t} else if ( roughness >= r4 ) {\n\t\t\tmip = ( r1 - roughness ) * ( m4 - m1 ) / ( r1 - r4 ) + m1;\n\t\t} else if ( roughness >= r5 ) {\n\t\t\tmip = ( r4 - roughness ) * ( m5 - m4 ) / ( r4 - r5 ) + m4;\n\t\t} else if ( roughness >= r6 ) {\n\t\t\tmip = ( r5 - roughness ) * ( m6 - m5 ) / ( r5 - r6 ) + m5;\n\t\t} else {\n\t\t\tmip = - 2.0 * log2( 1.16 * roughness );\t\t}\n\t\treturn mip;\n\t}\n\tvec4 textureCubeUV( sampler2D envMap, vec3 sampleDir, float roughness ) {\n\t\tfloat mip = clamp( roughnessToMip( roughness ), m0, CUBEUV_MAX_MIP );\n\t\tfloat mipF = fract( mip );\n\t\tfloat mipInt = floor( mip );\n\t\tvec3 color0 = bilinearCubeUV( envMap, sampleDir, mipInt );\n\t\tif ( mipF == 0.0 ) {\n\t\t\treturn vec4( color0, 1.0 );\n\t\t} else {\n\t\t\tvec3 color1 = bilinearCubeUV( envMap, sampleDir, mipInt + 1.0 );\n\t\t\treturn vec4( mix( color0, color1, mipF ), 1.0 );\n\t\t}\n\t}\n#endif",defaultnormal_vertex:"vec3 transformedNormal = objectNormal;\n#ifdef USE_INSTANCING\n\tmat3 m = mat3( instanceMatrix );\n\ttransformedNormal /= vec3( dot( m[ 0 ], m[ 0 ] ), dot( m[ 1 ], m[ 1 ] ), dot( m[ 2 ], m[ 2 ] ) );\n\ttransformedNormal = m * transformedNormal;\n#endif\ntransformedNormal = normalMatrix * transformedNormal;\n#ifdef FLIP_SIDED\n\ttransformedNormal = - transformedNormal;\n#endif\n#ifdef USE_TANGENT\n\tvec3 transformedTangent = ( modelViewMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#ifdef FLIP_SIDED\n\t\ttransformedTangent = - transformedTangent;\n\t#endif\n#endif",displacementmap_pars_vertex:"#ifdef USE_DISPLACEMENTMAP\n\tuniform sampler2D displacementMap;\n\tuniform float displacementScale;\n\tuniform float displacementBias;\n#endif",displacementmap_vertex:"#ifdef USE_DISPLACEMENTMAP\n\ttransformed += normalize( objectNormal ) * ( texture2D( displacementMap, vUv ).x * displacementScale + displacementBias );\n#endif",emissivemap_fragment:"#ifdef USE_EMISSIVEMAP\n\tvec4 emissiveColor = texture2D( emissiveMap, vUv );\n\ttotalEmissiveRadiance *= emissiveColor.rgb;\n#endif",emissivemap_pars_fragment:"#ifdef USE_EMISSIVEMAP\n\tuniform sampler2D emissiveMap;\n#endif",encodings_fragment:"gl_FragColor = linearToOutputTexel( gl_FragColor );",encodings_pars_fragment:"vec4 LinearToLinear( in vec4 value ) {\n\treturn value;\n}\nvec4 LinearTosRGB( in vec4 value ) {\n\treturn vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.a );\n}",envmap_fragment:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvec3 cameraToFrag;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToFrag = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToFrag = normalize( vWorldPosition - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvec3 reflectVec = reflect( cameraToFrag, worldNormal );\n\t\t#else\n\t\t\tvec3 reflectVec = refract( cameraToFrag, worldNormal, refractionRatio );\n\t\t#endif\n\t#else\n\t\tvec3 reflectVec = vReflect;\n\t#endif\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tvec4 envColor = textureCube( envMap, vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n\t#elif defined( ENVMAP_TYPE_CUBE_UV )\n\t\tvec4 envColor = textureCubeUV( envMap, reflectVec, 0.0 );\n\t#else\n\t\tvec4 envColor = vec4( 0.0 );\n\t#endif\n\t#ifdef ENVMAP_BLENDING_MULTIPLY\n\t\toutgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_MIX )\n\t\toutgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n\t#elif defined( ENVMAP_BLENDING_ADD )\n\t\toutgoingLight += envColor.xyz * specularStrength * reflectivity;\n\t#endif\n#endif",envmap_common_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float envMapIntensity;\n\tuniform float flipEnvMap;\n\t#ifdef ENVMAP_TYPE_CUBE\n\t\tuniform samplerCube envMap;\n\t#else\n\t\tuniform sampler2D envMap;\n\t#endif\n\t\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\n\tuniform float reflectivity;\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\tvarying vec3 vWorldPosition;\n\t\tuniform float refractionRatio;\n\t#else\n\t\tvarying vec3 vReflect;\n\t#endif\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\n\t#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) ||defined( PHONG )\n\t\t#define ENV_WORLDPOS\n\t#endif\n\t#ifdef ENV_WORLDPOS\n\t\t\n\t\tvarying vec3 vWorldPosition;\n\t#else\n\t\tvarying vec3 vReflect;\n\t\tuniform float refractionRatio;\n\t#endif\n#endif",envmap_physical_pars_fragment:"#if defined( USE_ENVMAP )\n\tvec3 getIBLIrradiance( const in vec3 normal ) {\n\t\t#if defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, worldNormal, 1.0 );\n\t\t\treturn PI * envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n\tvec3 getIBLRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness ) {\n\t\t#if defined( ENVMAP_TYPE_CUBE_UV )\n\t\t\tvec3 reflectVec = reflect( - viewDir, normal );\n\t\t\treflectVec = normalize( mix( reflectVec, normal, roughness * roughness) );\n\t\t\treflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n\t\t\tvec4 envMapColor = textureCubeUV( envMap, reflectVec, roughness );\n\t\t\treturn envMapColor.rgb * envMapIntensity;\n\t\t#else\n\t\t\treturn vec3( 0.0 );\n\t\t#endif\n\t}\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\n\t#ifdef ENV_WORLDPOS\n\t\tvWorldPosition = worldPosition.xyz;\n\t#else\n\t\tvec3 cameraToVertex;\n\t\tif ( isOrthographic ) {\n\t\t\tcameraToVertex = normalize( vec3( - viewMatrix[ 0 ][ 2 ], - viewMatrix[ 1 ][ 2 ], - viewMatrix[ 2 ][ 2 ] ) );\n\t\t} else {\n\t\t\tcameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n\t\t}\n\t\tvec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\t#ifdef ENVMAP_MODE_REFLECTION\n\t\t\tvReflect = reflect( cameraToVertex, worldNormal );\n\t\t#else\n\t\t\tvReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n\t\t#endif\n\t#endif\n#endif",fog_vertex:"#ifdef USE_FOG\n\tvFogDepth = - mvPosition.z;\n#endif",fog_pars_vertex:"#ifdef USE_FOG\n\tvarying float vFogDepth;\n#endif",fog_fragment:"#ifdef USE_FOG\n\t#ifdef FOG_EXP2\n\t\tfloat fogFactor = 1.0 - exp( - fogDensity * fogDensity * vFogDepth * vFogDepth );\n\t#else\n\t\tfloat fogFactor = smoothstep( fogNear, fogFar, vFogDepth );\n\t#endif\n\tgl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif",fog_pars_fragment:"#ifdef USE_FOG\n\tuniform vec3 fogColor;\n\tvarying float vFogDepth;\n\t#ifdef FOG_EXP2\n\t\tuniform float fogDensity;\n\t#else\n\t\tuniform float fogNear;\n\t\tuniform float fogFar;\n\t#endif\n#endif",gradientmap_pars_fragment:"#ifdef USE_GRADIENTMAP\n\tuniform sampler2D gradientMap;\n#endif\nvec3 getGradientIrradiance( vec3 normal, vec3 lightDirection ) {\n\tfloat dotNL = dot( normal, lightDirection );\n\tvec2 coord = vec2( dotNL * 0.5 + 0.5, 0.0 );\n\t#ifdef USE_GRADIENTMAP\n\t\treturn vec3( texture2D( gradientMap, coord ).r );\n\t#else\n\t\treturn ( coord.x < 0.7 ) ? vec3( 0.7 ) : vec3( 1.0 );\n\t#endif\n}",lightmap_fragment:"#ifdef USE_LIGHTMAP\n\tvec4 lightMapTexel = texture2D( lightMap, vUv2 );\n\tvec3 lightMapIrradiance = lightMapTexel.rgb * lightMapIntensity;\n\treflectedLight.indirectDiffuse += lightMapIrradiance;\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\n\tuniform sampler2D lightMap;\n\tuniform float lightMapIntensity;\n#endif",lights_lambert_vertex:"vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\nvIndirectFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n\tvLightBack = vec3( 0.0 );\n\tvIndirectBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\nvIndirectFront += getAmbientLightIrradiance( ambientLightColor );\nvIndirectFront += getLightProbeIrradiance( lightProbe, geometry.normal );\n#ifdef DOUBLE_SIDED\n\tvIndirectBack += getAmbientLightIrradiance( ambientLightColor );\n\tvIndirectBack += getLightProbeIrradiance( lightProbe, backGeometry.normal );\n#endif\n#if NUM_POINT_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tgetPointLightInfo( pointLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( - dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tgetSpotLightInfo( spotLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( - dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if NUM_DIR_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tgetDirectionalLightInfo( directionalLights[ i ], geometry, directLight );\n\t\tdotNL = dot( geometry.normal, directLight.direction );\n\t\tdirectLightColor_Diffuse = directLight.color;\n\t\tvLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvLightBack += saturate( - dotNL ) * directLightColor_Diffuse;\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\tvIndirectFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry.normal );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\tvIndirectBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry.normal );\n\t\t#endif\n\t}\n\t#pragma unroll_loop_end\n#endif",lights_pars_begin:"uniform bool receiveShadow;\nuniform vec3 ambientLightColor;\nuniform vec3 lightProbe[ 9 ];\nvec3 shGetIrradianceAt( in vec3 normal, in vec3 shCoefficients[ 9 ] ) {\n\tfloat x = normal.x, y = normal.y, z = normal.z;\n\tvec3 result = shCoefficients[ 0 ] * 0.886227;\n\tresult += shCoefficients[ 1 ] * 2.0 * 0.511664 * y;\n\tresult += shCoefficients[ 2 ] * 2.0 * 0.511664 * z;\n\tresult += shCoefficients[ 3 ] * 2.0 * 0.511664 * x;\n\tresult += shCoefficients[ 4 ] * 2.0 * 0.429043 * x * y;\n\tresult += shCoefficients[ 5 ] * 2.0 * 0.429043 * y * z;\n\tresult += shCoefficients[ 6 ] * ( 0.743125 * z * z - 0.247708 );\n\tresult += shCoefficients[ 7 ] * 2.0 * 0.429043 * x * z;\n\tresult += shCoefficients[ 8 ] * 0.429043 * ( x * x - y * y );\n\treturn result;\n}\nvec3 getLightProbeIrradiance( const in vec3 lightProbe[ 9 ], const in vec3 normal ) {\n\tvec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n\tvec3 irradiance = shGetIrradianceAt( worldNormal, lightProbe );\n\treturn irradiance;\n}\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n\tvec3 irradiance = ambientLightColor;\n\treturn irradiance;\n}\nfloat getDistanceAttenuation( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n\t#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n\t\tfloat distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n\t\tif ( cutoffDistance > 0.0 ) {\n\t\t\tdistanceFalloff *= pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n\t\t}\n\t\treturn distanceFalloff;\n\t#else\n\t\tif ( cutoffDistance > 0.0 && decayExponent > 0.0 ) {\n\t\t\treturn pow( saturate( - lightDistance / cutoffDistance + 1.0 ), decayExponent );\n\t\t}\n\t\treturn 1.0;\n\t#endif\n}\nfloat getSpotAttenuation( const in float coneCosine, const in float penumbraCosine, const in float angleCosine ) {\n\treturn smoothstep( coneCosine, penumbraCosine, angleCosine );\n}\n#if NUM_DIR_LIGHTS > 0\n\tstruct DirectionalLight {\n\t\tvec3 direction;\n\t\tvec3 color;\n\t};\n\tuniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n\tvoid getDirectionalLightInfo( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight light ) {\n\t\tlight.color = directionalLight.color;\n\t\tlight.direction = directionalLight.direction;\n\t\tlight.visible = true;\n\t}\n#endif\n#if NUM_POINT_LIGHTS > 0\n\tstruct PointLight {\n\t\tvec3 position;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t};\n\tuniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n\tvoid getPointLightInfo( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight light ) {\n\t\tvec3 lVector = pointLight.position - geometry.position;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat lightDistance = length( lVector );\n\t\tlight.color = pointLight.color;\n\t\tlight.color *= getDistanceAttenuation( lightDistance, pointLight.distance, pointLight.decay );\n\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n\tstruct SpotLight {\n\t\tvec3 position;\n\t\tvec3 direction;\n\t\tvec3 color;\n\t\tfloat distance;\n\t\tfloat decay;\n\t\tfloat coneCos;\n\t\tfloat penumbraCos;\n\t};\n\tuniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n\tvoid getSpotLightInfo( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight light ) {\n\t\tvec3 lVector = spotLight.position - geometry.position;\n\t\tlight.direction = normalize( lVector );\n\t\tfloat angleCos = dot( light.direction, spotLight.direction );\n\t\tfloat spotAttenuation = getSpotAttenuation( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n\t\tif ( spotAttenuation > 0.0 ) {\n\t\t\tfloat lightDistance = length( lVector );\n\t\t\tlight.color = spotLight.color * spotAttenuation;\n\t\t\tlight.color *= getDistanceAttenuation( lightDistance, spotLight.distance, spotLight.decay );\n\t\t\tlight.visible = ( light.color != vec3( 0.0 ) );\n\t\t} else {\n\t\t\tlight.color = vec3( 0.0 );\n\t\t\tlight.visible = false;\n\t\t}\n\t}\n#endif\n#if NUM_RECT_AREA_LIGHTS > 0\n\tstruct RectAreaLight {\n\t\tvec3 color;\n\t\tvec3 position;\n\t\tvec3 halfWidth;\n\t\tvec3 halfHeight;\n\t};\n\tuniform sampler2D ltc_1;\tuniform sampler2D ltc_2;\n\tuniform RectAreaLight rectAreaLights[ NUM_RECT_AREA_LIGHTS ];\n#endif\n#if NUM_HEMI_LIGHTS > 0\n\tstruct HemisphereLight {\n\t\tvec3 direction;\n\t\tvec3 skyColor;\n\t\tvec3 groundColor;\n\t};\n\tuniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n\tvec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in vec3 normal ) {\n\t\tfloat dotNL = dot( normal, hemiLight.direction );\n\t\tfloat hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n\t\tvec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n\t\treturn irradiance;\n\t}\n#endif",lights_toon_fragment:"ToonMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;",lights_toon_pars_fragment:"varying vec3 vViewPosition;\nstruct ToonMaterial {\n\tvec3 diffuseColor;\n};\nvoid RE_Direct_Toon( const in IncidentLight directLight, const in GeometricContext geometry, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\tvec3 irradiance = getGradientIrradiance( geometry.normal, directLight.direction ) * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Toon( const in vec3 irradiance, const in GeometricContext geometry, const in ToonMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_Toon\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Toon\n#define Material_LightProbeLOD( material )\t(0)",lights_phong_fragment:"BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;",lights_phong_pars_fragment:"varying vec3 vViewPosition;\nstruct BlinnPhongMaterial {\n\tvec3 diffuseColor;\n\tvec3 specularColor;\n\tfloat specularShininess;\n\tfloat specularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n\treflectedLight.directSpecular += irradiance * BRDF_BlinnPhong( directLight.direction, geometry.viewDir, geometry.normal, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\n#define RE_Direct\t\t\t\tRE_Direct_BlinnPhong\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )\t(0)",lights_physical_fragment:"PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nvec3 dxy = max( abs( dFdx( geometryNormal ) ), abs( dFdy( geometryNormal ) ) );\nfloat geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );\nmaterial.roughness = max( roughnessFactor, 0.0525 );material.roughness += geometryRoughness;\nmaterial.roughness = min( material.roughness, 1.0 );\n#ifdef IOR\n\t#ifdef SPECULAR\n\t\tfloat specularIntensityFactor = specularIntensity;\n\t\tvec3 specularColorFactor = specularColor;\n\t\t#ifdef USE_SPECULARINTENSITYMAP\n\t\t\tspecularIntensityFactor *= texture2D( specularIntensityMap, vUv ).a;\n\t\t#endif\n\t\t#ifdef USE_SPECULARCOLORMAP\n\t\t\tspecularColorFactor *= texture2D( specularColorMap, vUv ).rgb;\n\t\t#endif\n\t\tmaterial.specularF90 = mix( specularIntensityFactor, 1.0, metalnessFactor );\n\t#else\n\t\tfloat specularIntensityFactor = 1.0;\n\t\tvec3 specularColorFactor = vec3( 1.0 );\n\t\tmaterial.specularF90 = 1.0;\n\t#endif\n\tmaterial.specularColor = mix( min( pow2( ( ior - 1.0 ) / ( ior + 1.0 ) ) * specularColorFactor, vec3( 1.0 ) ) * specularIntensityFactor, diffuseColor.rgb, metalnessFactor );\n#else\n\tmaterial.specularColor = mix( vec3( 0.04 ), diffuseColor.rgb, metalnessFactor );\n\tmaterial.specularF90 = 1.0;\n#endif\n#ifdef USE_CLEARCOAT\n\tmaterial.clearcoat = clearcoat;\n\tmaterial.clearcoatRoughness = clearcoatRoughness;\n\tmaterial.clearcoatF0 = vec3( 0.04 );\n\tmaterial.clearcoatF90 = 1.0;\n\t#ifdef USE_CLEARCOATMAP\n\t\tmaterial.clearcoat *= texture2D( clearcoatMap, vUv ).x;\n\t#endif\n\t#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\t\tmaterial.clearcoatRoughness *= texture2D( clearcoatRoughnessMap, vUv ).y;\n\t#endif\n\tmaterial.clearcoat = saturate( material.clearcoat );\tmaterial.clearcoatRoughness = max( material.clearcoatRoughness, 0.0525 );\n\tmaterial.clearcoatRoughness += geometryRoughness;\n\tmaterial.clearcoatRoughness = min( material.clearcoatRoughness, 1.0 );\n#endif\n#ifdef USE_IRIDESCENCE\n\tmaterial.iridescence = iridescence;\n\tmaterial.iridescenceIOR = iridescenceIOR;\n\t#ifdef USE_IRIDESCENCEMAP\n\t\tmaterial.iridescence *= texture2D( iridescenceMap, vUv ).r;\n\t#endif\n\t#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\t\tmaterial.iridescenceThickness = (iridescenceThicknessMaximum - iridescenceThicknessMinimum) * texture2D( iridescenceThicknessMap, vUv ).g + iridescenceThicknessMinimum;\n\t#else\n\t\tmaterial.iridescenceThickness = iridescenceThicknessMaximum;\n\t#endif\n#endif\n#ifdef USE_SHEEN\n\tmaterial.sheenColor = sheenColor;\n\t#ifdef USE_SHEENCOLORMAP\n\t\tmaterial.sheenColor *= texture2D( sheenColorMap, vUv ).rgb;\n\t#endif\n\tmaterial.sheenRoughness = clamp( sheenRoughness, 0.07, 1.0 );\n\t#ifdef USE_SHEENROUGHNESSMAP\n\t\tmaterial.sheenRoughness *= texture2D( sheenRoughnessMap, vUv ).a;\n\t#endif\n#endif",lights_physical_pars_fragment:"struct PhysicalMaterial {\n\tvec3 diffuseColor;\n\tfloat roughness;\n\tvec3 specularColor;\n\tfloat specularF90;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat clearcoat;\n\t\tfloat clearcoatRoughness;\n\t\tvec3 clearcoatF0;\n\t\tfloat clearcoatF90;\n\t#endif\n\t#ifdef USE_IRIDESCENCE\n\t\tfloat iridescence;\n\t\tfloat iridescenceIOR;\n\t\tfloat iridescenceThickness;\n\t\tvec3 iridescenceFresnel;\n\t\tvec3 iridescenceF0;\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tvec3 sheenColor;\n\t\tfloat sheenRoughness;\n\t#endif\n};\nvec3 clearcoatSpecular = vec3( 0.0 );\nvec3 sheenSpecular = vec3( 0.0 );\nfloat IBLSheenBRDF( const in vec3 normal, const in vec3 viewDir, const in float roughness) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tfloat r2 = roughness * roughness;\n\tfloat a = roughness < 0.25 ? -339.2 * r2 + 161.4 * roughness - 25.9 : -8.48 * r2 + 14.3 * roughness - 9.95;\n\tfloat b = roughness < 0.25 ? 44.0 * r2 - 23.7 * roughness + 3.26 : 1.97 * r2 - 3.27 * roughness + 0.72;\n\tfloat DG = exp( a * dotNV + b ) + ( roughness < 0.25 ? 0.0 : 0.1 * ( roughness - 0.25 ) );\n\treturn saturate( DG * RECIPROCAL_PI );\n}\nvec2 DFGApprox( const in vec3 normal, const in vec3 viewDir, const in float roughness ) {\n\tfloat dotNV = saturate( dot( normal, viewDir ) );\n\tconst vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n\tconst vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n\tvec4 r = roughness * c0 + c1;\n\tfloat a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n\tvec2 fab = vec2( - 1.04, 1.04 ) * a004 + r.zw;\n\treturn fab;\n}\nvec3 EnvironmentBRDF( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness ) {\n\tvec2 fab = DFGApprox( normal, viewDir, roughness );\n\treturn specularColor * fab.x + specularF90 * fab.y;\n}\n#ifdef USE_IRIDESCENCE\nvoid computeMultiscatteringIridescence( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float iridescence, const in vec3 iridescenceF0, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#else\nvoid computeMultiscattering( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {\n#endif\n\tvec2 fab = DFGApprox( normal, viewDir, roughness );\n\t#ifdef USE_IRIDESCENCE\n\t\tvec3 Fr = mix( specularColor, iridescenceF0, iridescence );\n\t#else\n\t\tvec3 Fr = specularColor;\n\t#endif\n\tvec3 FssEss = Fr * fab.x + specularF90 * fab.y;\n\tfloat Ess = fab.x + fab.y;\n\tfloat Ems = 1.0 - Ess;\n\tvec3 Favg = Fr + ( 1.0 - Fr ) * 0.047619;\tvec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );\n\tsingleScatter += FssEss;\n\tmultiScatter += Fms * Ems;\n}\n#if NUM_RECT_AREA_LIGHTS > 0\n\tvoid RE_Direct_RectArea_Physical( const in RectAreaLight rectAreaLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\t\tvec3 normal = geometry.normal;\n\t\tvec3 viewDir = geometry.viewDir;\n\t\tvec3 position = geometry.position;\n\t\tvec3 lightPos = rectAreaLight.position;\n\t\tvec3 halfWidth = rectAreaLight.halfWidth;\n\t\tvec3 halfHeight = rectAreaLight.halfHeight;\n\t\tvec3 lightColor = rectAreaLight.color;\n\t\tfloat roughness = material.roughness;\n\t\tvec3 rectCoords[ 4 ];\n\t\trectCoords[ 0 ] = lightPos + halfWidth - halfHeight;\t\trectCoords[ 1 ] = lightPos - halfWidth - halfHeight;\n\t\trectCoords[ 2 ] = lightPos - halfWidth + halfHeight;\n\t\trectCoords[ 3 ] = lightPos + halfWidth + halfHeight;\n\t\tvec2 uv = LTC_Uv( normal, viewDir, roughness );\n\t\tvec4 t1 = texture2D( ltc_1, uv );\n\t\tvec4 t2 = texture2D( ltc_2, uv );\n\t\tmat3 mInv = mat3(\n\t\t\tvec3( t1.x, 0, t1.y ),\n\t\t\tvec3(\t\t0, 1,\t\t0 ),\n\t\t\tvec3( t1.z, 0, t1.w )\n\t\t);\n\t\tvec3 fresnel = ( material.specularColor * t2.x + ( vec3( 1.0 ) - material.specularColor ) * t2.y );\n\t\treflectedLight.directSpecular += lightColor * fresnel * LTC_Evaluate( normal, viewDir, position, mInv, rectCoords );\n\t\treflectedLight.directDiffuse += lightColor * material.diffuseColor * LTC_Evaluate( normal, viewDir, position, mat3( 1.0 ), rectCoords );\n\t}\n#endif\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\tfloat dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n\tvec3 irradiance = dotNL * directLight.color;\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNLcc = saturate( dot( geometry.clearcoatNormal, directLight.direction ) );\n\t\tvec3 ccIrradiance = dotNLcc * directLight.color;\n\t\tclearcoatSpecular += ccIrradiance * BRDF_GGX( directLight.direction, geometry.viewDir, geometry.clearcoatNormal, material.clearcoatF0, material.clearcoatF90, material.clearcoatRoughness );\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tsheenSpecular += irradiance * BRDF_Sheen( directLight.direction, geometry.viewDir, geometry.normal, material.sheenColor, material.sheenRoughness );\n\t#endif\n\t#ifdef USE_IRIDESCENCE\n\t\treflectedLight.directSpecular += irradiance * BRDF_GGX_Iridescence( directLight.direction, geometry.viewDir, geometry.normal, material.specularColor, material.specularF90, material.iridescence, material.iridescenceFresnel, material.roughness );\n\t#else\n\t\treflectedLight.directSpecular += irradiance * BRDF_GGX( directLight.direction, geometry.viewDir, geometry.normal, material.specularColor, material.specularF90, material.roughness );\n\t#endif\n\treflectedLight.directDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n\treflectedLight.indirectDiffuse += irradiance * BRDF_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in vec3 clearcoatRadiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight) {\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatSpecular += clearcoatRadiance * EnvironmentBRDF( geometry.clearcoatNormal, geometry.viewDir, material.clearcoatF0, material.clearcoatF90, material.clearcoatRoughness );\n\t#endif\n\t#ifdef USE_SHEEN\n\t\tsheenSpecular += irradiance * material.sheenColor * IBLSheenBRDF( geometry.normal, geometry.viewDir, material.sheenRoughness );\n\t#endif\n\tvec3 singleScattering = vec3( 0.0 );\n\tvec3 multiScattering = vec3( 0.0 );\n\tvec3 cosineWeightedIrradiance = irradiance * RECIPROCAL_PI;\n\t#ifdef USE_IRIDESCENCE\n\t\tcomputeMultiscatteringIridescence( geometry.normal, geometry.viewDir, material.specularColor, material.specularF90, material.iridescence, material.iridescenceFresnel, material.roughness, singleScattering, multiScattering );\n\t#else\n\t\tcomputeMultiscattering( geometry.normal, geometry.viewDir, material.specularColor, material.specularF90, material.roughness, singleScattering, multiScattering );\n\t#endif\n\tvec3 totalScattering = singleScattering + multiScattering;\n\tvec3 diffuse = material.diffuseColor * ( 1.0 - max( max( totalScattering.r, totalScattering.g ), totalScattering.b ) );\n\treflectedLight.indirectSpecular += radiance * singleScattering;\n\treflectedLight.indirectSpecular += multiScattering * cosineWeightedIrradiance;\n\treflectedLight.indirectDiffuse += diffuse * cosineWeightedIrradiance;\n}\n#define RE_Direct\t\t\t\tRE_Direct_Physical\n#define RE_Direct_RectArea\t\tRE_Direct_RectArea_Physical\n#define RE_IndirectDiffuse\t\tRE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular\t\tRE_IndirectSpecular_Physical\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n\treturn saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}",lights_fragment_begin:"\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = ( isOrthographic ) ? vec3( 0, 0, 1 ) : normalize( vViewPosition );\n#ifdef USE_CLEARCOAT\n\tgeometry.clearcoatNormal = clearcoatNormal;\n#endif\n#ifdef USE_IRIDESCENCE\nfloat dotNVi = saturate( dot( normal, geometry.viewDir ) );\nif ( material.iridescenceThickness == 0.0 ) {\n\tmaterial.iridescence = 0.0;\n} else {\n\tmaterial.iridescence = saturate( material.iridescence );\n}\nif ( material.iridescence > 0.0 ) {\n\tmaterial.iridescenceFresnel = evalIridescence( 1.0, material.iridescenceIOR, dotNVi, material.iridescenceThickness, material.specularColor );\n\tmaterial.iridescenceF0 = Schlick_to_F0( material.iridescenceFresnel, 1.0, dotNVi );\n}\n#endif\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n\tPointLight pointLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n\t\tpointLight = pointLights[ i ];\n\t\tgetPointLightInfo( pointLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_POINT_LIGHT_SHADOWS )\n\t\tpointLightShadow = pointLightShadows[ i ];\n\t\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getPointShadow( pointShadowMap[ i ], pointLightShadow.shadowMapSize, pointLightShadow.shadowBias, pointLightShadow.shadowRadius, vPointShadowCoord[ i ], pointLightShadow.shadowCameraNear, pointLightShadow.shadowCameraFar ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n\tSpotLight spotLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n\t\tspotLight = spotLights[ i ];\n\t\tgetSpotLightInfo( spotLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_SPOT_LIGHT_SHADOWS )\n\t\tspotLightShadow = spotLightShadows[ i ];\n\t\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getShadow( spotShadowMap[ i ], spotLightShadow.shadowMapSize, spotLightShadow.shadowBias, spotLightShadow.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n\tDirectionalLight directionalLight;\n\t#if defined( USE_SHADOWMAP ) && NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLightShadow;\n\t#endif\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n\t\tdirectionalLight = directionalLights[ i ];\n\t\tgetDirectionalLightInfo( directionalLight, geometry, directLight );\n\t\t#if defined( USE_SHADOWMAP ) && ( UNROLLED_LOOP_INDEX < NUM_DIR_LIGHT_SHADOWS )\n\t\tdirectionalLightShadow = directionalLightShadows[ i ];\n\t\tdirectLight.color *= all( bvec2( directLight.visible, receiveShadow ) ) ? getShadow( directionalShadowMap[ i ], directionalLightShadow.shadowMapSize, directionalLightShadow.shadowBias, directionalLightShadow.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t\t#endif\n\t\tRE_Direct( directLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if ( NUM_RECT_AREA_LIGHTS > 0 ) && defined( RE_Direct_RectArea )\n\tRectAreaLight rectAreaLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_RECT_AREA_LIGHTS; i ++ ) {\n\t\trectAreaLight = rectAreaLights[ i ];\n\t\tRE_Direct_RectArea( rectAreaLight, geometry, material, reflectedLight );\n\t}\n\t#pragma unroll_loop_end\n#endif\n#if defined( RE_IndirectDiffuse )\n\tvec3 iblIrradiance = vec3( 0.0 );\n\tvec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n\tirradiance += getLightProbeIrradiance( lightProbe, geometry.normal );\n\t#if ( NUM_HEMI_LIGHTS > 0 )\n\t\t#pragma unroll_loop_start\n\t\tfor ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n\t\t\tirradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry.normal );\n\t\t}\n\t\t#pragma unroll_loop_end\n\t#endif\n#endif\n#if defined( RE_IndirectSpecular )\n\tvec3 radiance = vec3( 0.0 );\n\tvec3 clearcoatRadiance = vec3( 0.0 );\n#endif",lights_fragment_maps:"#if defined( RE_IndirectDiffuse )\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vUv2 );\n\t\tvec3 lightMapIrradiance = lightMapTexel.rgb * lightMapIntensity;\n\t\tirradiance += lightMapIrradiance;\n\t#endif\n\t#if defined( USE_ENVMAP ) && defined( STANDARD ) && defined( ENVMAP_TYPE_CUBE_UV )\n\t\tiblIrradiance += getIBLIrradiance( geometry.normal );\n\t#endif\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n\tradiance += getIBLRadiance( geometry.viewDir, geometry.normal, material.roughness );\n\t#ifdef USE_CLEARCOAT\n\t\tclearcoatRadiance += getIBLRadiance( geometry.viewDir, geometry.clearcoatNormal, material.clearcoatRoughness );\n\t#endif\n#endif",lights_fragment_end:"#if defined( RE_IndirectDiffuse )\n\tRE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( RE_IndirectSpecular )\n\tRE_IndirectSpecular( radiance, iblIrradiance, clearcoatRadiance, geometry, material, reflectedLight );\n#endif",logdepthbuf_fragment:"#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\n\tgl_FragDepthEXT = vIsPerspective == 0.0 ? gl_FragCoord.z : log2( vFragDepth ) * logDepthBufFC * 0.5;\n#endif",logdepthbuf_pars_fragment:"#if defined( USE_LOGDEPTHBUF ) && defined( USE_LOGDEPTHBUF_EXT )\n\tuniform float logDepthBufFC;\n\tvarying float vFragDepth;\n\tvarying float vIsPerspective;\n#endif",logdepthbuf_pars_vertex:"#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvarying float vFragDepth;\n\t\tvarying float vIsPerspective;\n\t#else\n\t\tuniform float logDepthBufFC;\n\t#endif\n#endif",logdepthbuf_vertex:"#ifdef USE_LOGDEPTHBUF\n\t#ifdef USE_LOGDEPTHBUF_EXT\n\t\tvFragDepth = 1.0 + gl_Position.w;\n\t\tvIsPerspective = float( isPerspectiveMatrix( projectionMatrix ) );\n\t#else\n\t\tif ( isPerspectiveMatrix( projectionMatrix ) ) {\n\t\t\tgl_Position.z = log2( max( EPSILON, gl_Position.w + 1.0 ) ) * logDepthBufFC - 1.0;\n\t\t\tgl_Position.z *= gl_Position.w;\n\t\t}\n\t#endif\n#endif",map_fragment:"#ifdef USE_MAP\n\tvec4 sampledDiffuseColor = texture2D( map, vUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\tsampledDiffuseColor = vec4( mix( pow( sampledDiffuseColor.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), sampledDiffuseColor.rgb * 0.0773993808, vec3( lessThanEqual( sampledDiffuseColor.rgb, vec3( 0.04045 ) ) ) ), sampledDiffuseColor.w );\n\t#endif\n\tdiffuseColor *= sampledDiffuseColor;\n#endif",map_pars_fragment:"#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif",map_particle_fragment:"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\tvec2 uv = ( uvTransform * vec3( gl_PointCoord.x, 1.0 - gl_PointCoord.y, 1 ) ).xy;\n#endif\n#ifdef USE_MAP\n\tdiffuseColor *= texture2D( map, uv );\n#endif\n#ifdef USE_ALPHAMAP\n\tdiffuseColor.a *= texture2D( alphaMap, uv ).g;\n#endif",map_particle_pars_fragment:"#if defined( USE_MAP ) || defined( USE_ALPHAMAP )\n\tuniform mat3 uvTransform;\n#endif\n#ifdef USE_MAP\n\tuniform sampler2D map;\n#endif\n#ifdef USE_ALPHAMAP\n\tuniform sampler2D alphaMap;\n#endif",metalnessmap_fragment:"float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n\tvec4 texelMetalness = texture2D( metalnessMap, vUv );\n\tmetalnessFactor *= texelMetalness.b;\n#endif",metalnessmap_pars_fragment:"#ifdef USE_METALNESSMAP\n\tuniform sampler2D metalnessMap;\n#endif",morphcolor_vertex:"#if defined( USE_MORPHCOLORS ) && defined( MORPHTARGETS_TEXTURE )\n\tvColor *= morphTargetBaseInfluence;\n\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\t#if defined( USE_COLOR_ALPHA )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ) * morphTargetInfluences[ i ];\n\t\t#elif defined( USE_COLOR )\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) vColor += getMorph( gl_VertexID, i, 2 ).rgb * morphTargetInfluences[ i ];\n\t\t#endif\n\t}\n#endif",morphnormal_vertex:"#ifdef USE_MORPHNORMALS\n\tobjectNormal *= morphTargetBaseInfluence;\n\t#ifdef MORPHTARGETS_TEXTURE\n\t\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) objectNormal += getMorph( gl_VertexID, i, 1 ).xyz * morphTargetInfluences[ i ];\n\t\t}\n\t#else\n\t\tobjectNormal += morphNormal0 * morphTargetInfluences[ 0 ];\n\t\tobjectNormal += morphNormal1 * morphTargetInfluences[ 1 ];\n\t\tobjectNormal += morphNormal2 * morphTargetInfluences[ 2 ];\n\t\tobjectNormal += morphNormal3 * morphTargetInfluences[ 3 ];\n\t#endif\n#endif",morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\n\tuniform float morphTargetBaseInfluence;\n\t#ifdef MORPHTARGETS_TEXTURE\n\t\tuniform float morphTargetInfluences[ MORPHTARGETS_COUNT ];\n\t\tuniform sampler2DArray morphTargetsTexture;\n\t\tuniform ivec2 morphTargetsTextureSize;\n\t\tvec4 getMorph( const in int vertexIndex, const in int morphTargetIndex, const in int offset ) {\n\t\t\tint texelIndex = vertexIndex * MORPHTARGETS_TEXTURE_STRIDE + offset;\n\t\t\tint y = texelIndex / morphTargetsTextureSize.x;\n\t\t\tint x = texelIndex - y * morphTargetsTextureSize.x;\n\t\t\tivec3 morphUV = ivec3( x, y, morphTargetIndex );\n\t\t\treturn texelFetch( morphTargetsTexture, morphUV, 0 );\n\t\t}\n\t#else\n\t\t#ifndef USE_MORPHNORMALS\n\t\t\tuniform float morphTargetInfluences[ 8 ];\n\t\t#else\n\t\t\tuniform float morphTargetInfluences[ 4 ];\n\t\t#endif\n\t#endif\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\n\ttransformed *= morphTargetBaseInfluence;\n\t#ifdef MORPHTARGETS_TEXTURE\n\t\tfor ( int i = 0; i < MORPHTARGETS_COUNT; i ++ ) {\n\t\t\tif ( morphTargetInfluences[ i ] != 0.0 ) transformed += getMorph( gl_VertexID, i, 0 ).xyz * morphTargetInfluences[ i ];\n\t\t}\n\t#else\n\t\ttransformed += morphTarget0 * morphTargetInfluences[ 0 ];\n\t\ttransformed += morphTarget1 * morphTargetInfluences[ 1 ];\n\t\ttransformed += morphTarget2 * morphTargetInfluences[ 2 ];\n\t\ttransformed += morphTarget3 * morphTargetInfluences[ 3 ];\n\t\t#ifndef USE_MORPHNORMALS\n\t\t\ttransformed += morphTarget4 * morphTargetInfluences[ 4 ];\n\t\t\ttransformed += morphTarget5 * morphTargetInfluences[ 5 ];\n\t\t\ttransformed += morphTarget6 * morphTargetInfluences[ 6 ];\n\t\t\ttransformed += morphTarget7 * morphTargetInfluences[ 7 ];\n\t\t#endif\n\t#endif\n#endif",normal_fragment_begin:"float faceDirection = gl_FrontFacing ? 1.0 : - 1.0;\n#ifdef FLAT_SHADED\n\tvec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n\tvec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n\tvec3 normal = normalize( cross( fdx, fdy ) );\n#else\n\tvec3 normal = normalize( vNormal );\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * faceDirection;\n\t#endif\n\t#ifdef USE_TANGENT\n\t\tvec3 tangent = normalize( vTangent );\n\t\tvec3 bitangent = normalize( vBitangent );\n\t\t#ifdef DOUBLE_SIDED\n\t\t\ttangent = tangent * faceDirection;\n\t\t\tbitangent = bitangent * faceDirection;\n\t\t#endif\n\t\t#if defined( TANGENTSPACE_NORMALMAP ) || defined( USE_CLEARCOAT_NORMALMAP )\n\t\t\tmat3 vTBN = mat3( tangent, bitangent, normal );\n\t\t#endif\n\t#endif\n#endif\nvec3 geometryNormal = normal;",normal_fragment_maps:"#ifdef OBJECTSPACE_NORMALMAP\n\tnormal = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\t#ifdef FLIP_SIDED\n\t\tnormal = - normal;\n\t#endif\n\t#ifdef DOUBLE_SIDED\n\t\tnormal = normal * faceDirection;\n\t#endif\n\tnormal = normalize( normalMatrix * normal );\n#elif defined( TANGENTSPACE_NORMALMAP )\n\tvec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n\tmapN.xy *= normalScale;\n\t#ifdef USE_TANGENT\n\t\tnormal = normalize( vTBN * mapN );\n\t#else\n\t\tnormal = perturbNormal2Arb( - vViewPosition, normal, mapN, faceDirection );\n\t#endif\n#elif defined( USE_BUMPMAP )\n\tnormal = perturbNormalArb( - vViewPosition, normal, dHdxy_fwd(), faceDirection );\n#endif",normal_pars_fragment:"#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif",normal_pars_vertex:"#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n\t#ifdef USE_TANGENT\n\t\tvarying vec3 vTangent;\n\t\tvarying vec3 vBitangent;\n\t#endif\n#endif",normal_vertex:"#ifndef FLAT_SHADED\n\tvNormal = normalize( transformedNormal );\n\t#ifdef USE_TANGENT\n\t\tvTangent = normalize( transformedTangent );\n\t\tvBitangent = normalize( cross( vNormal, vTangent ) * tangent.w );\n\t#endif\n#endif",normalmap_pars_fragment:"#ifdef USE_NORMALMAP\n\tuniform sampler2D normalMap;\n\tuniform vec2 normalScale;\n#endif\n#ifdef OBJECTSPACE_NORMALMAP\n\tuniform mat3 normalMatrix;\n#endif\n#if ! defined ( USE_TANGENT ) && ( defined ( TANGENTSPACE_NORMALMAP ) || defined ( USE_CLEARCOAT_NORMALMAP ) )\n\tvec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm, vec3 mapN, float faceDirection ) {\n\t\tvec3 q0 = vec3( dFdx( eye_pos.x ), dFdx( eye_pos.y ), dFdx( eye_pos.z ) );\n\t\tvec3 q1 = vec3( dFdy( eye_pos.x ), dFdy( eye_pos.y ), dFdy( eye_pos.z ) );\n\t\tvec2 st0 = dFdx( vUv.st );\n\t\tvec2 st1 = dFdy( vUv.st );\n\t\tvec3 N = surf_norm;\n\t\tvec3 q1perp = cross( q1, N );\n\t\tvec3 q0perp = cross( N, q0 );\n\t\tvec3 T = q1perp * st0.x + q0perp * st1.x;\n\t\tvec3 B = q1perp * st0.y + q0perp * st1.y;\n\t\tfloat det = max( dot( T, T ), dot( B, B ) );\n\t\tfloat scale = ( det == 0.0 ) ? 0.0 : faceDirection * inversesqrt( det );\n\t\treturn normalize( T * ( mapN.x * scale ) + B * ( mapN.y * scale ) + N * mapN.z );\n\t}\n#endif",clearcoat_normal_fragment_begin:"#ifdef USE_CLEARCOAT\n\tvec3 clearcoatNormal = geometryNormal;\n#endif",clearcoat_normal_fragment_maps:"#ifdef USE_CLEARCOAT_NORMALMAP\n\tvec3 clearcoatMapN = texture2D( clearcoatNormalMap, vUv ).xyz * 2.0 - 1.0;\n\tclearcoatMapN.xy *= clearcoatNormalScale;\n\t#ifdef USE_TANGENT\n\t\tclearcoatNormal = normalize( vTBN * clearcoatMapN );\n\t#else\n\t\tclearcoatNormal = perturbNormal2Arb( - vViewPosition, clearcoatNormal, clearcoatMapN, faceDirection );\n\t#endif\n#endif",clearcoat_pars_fragment:"#ifdef USE_CLEARCOATMAP\n\tuniform sampler2D clearcoatMap;\n#endif\n#ifdef USE_CLEARCOAT_ROUGHNESSMAP\n\tuniform sampler2D clearcoatRoughnessMap;\n#endif\n#ifdef USE_CLEARCOAT_NORMALMAP\n\tuniform sampler2D clearcoatNormalMap;\n\tuniform vec2 clearcoatNormalScale;\n#endif",iridescence_pars_fragment:"#ifdef USE_IRIDESCENCEMAP\n\tuniform sampler2D iridescenceMap;\n#endif\n#ifdef USE_IRIDESCENCE_THICKNESSMAP\n\tuniform sampler2D iridescenceThicknessMap;\n#endif",output_fragment:"#ifdef OPAQUE\ndiffuseColor.a = 1.0;\n#endif\n#ifdef USE_TRANSMISSION\ndiffuseColor.a *= transmissionAlpha + 0.1;\n#endif\ngl_FragColor = vec4( outgoingLight, diffuseColor.a );",packing:"vec3 packNormalToRGB( const in vec3 normal ) {\n\treturn normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n\treturn 2.0 * rgb.xyz - 1.0;\n}\nconst float PackUpscale = 256. / 255.;const float UnpackDownscale = 255. / 256.;\nconst vec3 PackFactors = vec3( 256. * 256. * 256., 256. * 256., 256. );\nconst vec4 UnpackFactors = UnpackDownscale / vec4( PackFactors, 1. );\nconst float ShiftRight8 = 1. / 256.;\nvec4 packDepthToRGBA( const in float v ) {\n\tvec4 r = vec4( fract( v * PackFactors ), v );\n\tr.yzw -= r.xyz * ShiftRight8;\treturn r * PackUpscale;\n}\nfloat unpackRGBAToDepth( const in vec4 v ) {\n\treturn dot( v, UnpackFactors );\n}\nvec4 pack2HalfToRGBA( vec2 v ) {\n\tvec4 r = vec4( v.x, fract( v.x * 255.0 ), v.y, fract( v.y * 255.0 ) );\n\treturn vec4( r.x - r.y / 255.0, r.y, r.z - r.w / 255.0, r.w );\n}\nvec2 unpackRGBATo2Half( vec4 v ) {\n\treturn vec2( v.x + ( v.y / 255.0 ), v.z + ( v.w / 255.0 ) );\n}\nfloat viewZToOrthographicDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( viewZ + near ) / ( near - far );\n}\nfloat orthographicDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n\treturn linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n\treturn ( ( near + viewZ ) * far ) / ( ( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n\treturn ( near * far ) / ( ( far - near ) * invClipZ - far );\n}",premultiplied_alpha_fragment:"#ifdef PREMULTIPLIED_ALPHA\n\tgl_FragColor.rgb *= gl_FragColor.a;\n#endif",project_vertex:"vec4 mvPosition = vec4( transformed, 1.0 );\n#ifdef USE_INSTANCING\n\tmvPosition = instanceMatrix * mvPosition;\n#endif\nmvPosition = modelViewMatrix * mvPosition;\ngl_Position = projectionMatrix * mvPosition;",dithering_fragment:"#ifdef DITHERING\n\tgl_FragColor.rgb = dithering( gl_FragColor.rgb );\n#endif",dithering_pars_fragment:"#ifdef DITHERING\n\tvec3 dithering( vec3 color ) {\n\t\tfloat grid_position = rand( gl_FragCoord.xy );\n\t\tvec3 dither_shift_RGB = vec3( 0.25 / 255.0, -0.25 / 255.0, 0.25 / 255.0 );\n\t\tdither_shift_RGB = mix( 2.0 * dither_shift_RGB, -2.0 * dither_shift_RGB, grid_position );\n\t\treturn color + dither_shift_RGB;\n\t}\n#endif",roughnessmap_fragment:"float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n\tvec4 texelRoughness = texture2D( roughnessMap, vUv );\n\troughnessFactor *= texelRoughness.g;\n#endif",roughnessmap_pars_fragment:"#ifdef USE_ROUGHNESSMAP\n\tuniform sampler2D roughnessMap;\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D directionalShadowMap[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D spotShadowMap[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform sampler2D pointShadowMap[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n\tfloat texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n\t\treturn step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n\t}\n\tvec2 texture2DDistribution( sampler2D shadow, vec2 uv ) {\n\t\treturn unpackRGBATo2Half( texture2D( shadow, uv ) );\n\t}\n\tfloat VSMShadow (sampler2D shadow, vec2 uv, float compare ){\n\t\tfloat occlusion = 1.0;\n\t\tvec2 distribution = texture2DDistribution( shadow, uv );\n\t\tfloat hard_shadow = step( compare , distribution.x );\n\t\tif (hard_shadow != 1.0 ) {\n\t\t\tfloat distance = compare - distribution.x ;\n\t\t\tfloat variance = max( 0.00000, distribution.y * distribution.y );\n\t\t\tfloat softness_probability = variance / (variance + distance * distance );\t\t\tsoftness_probability = clamp( ( softness_probability - 0.3 ) / ( 0.95 - 0.3 ), 0.0, 1.0 );\t\t\tocclusion = clamp( max( hard_shadow, softness_probability ), 0.0, 1.0 );\n\t\t}\n\t\treturn occlusion;\n\t}\n\tfloat getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n\t\tfloat shadow = 1.0;\n\t\tshadowCoord.xyz /= shadowCoord.w;\n\t\tshadowCoord.z += shadowBias;\n\t\tbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n\t\tbool inFrustum = all( inFrustumVec );\n\t\tbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n\t\tbool frustumTest = all( frustumTestVec );\n\t\tif ( frustumTest ) {\n\t\t#if defined( SHADOWMAP_TYPE_PCF )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx0 = - texelSize.x * shadowRadius;\n\t\t\tfloat dy0 = - texelSize.y * shadowRadius;\n\t\t\tfloat dx1 = + texelSize.x * shadowRadius;\n\t\t\tfloat dy1 = + texelSize.y * shadowRadius;\n\t\t\tfloat dx2 = dx0 / 2.0;\n\t\t\tfloat dy2 = dy0 / 2.0;\n\t\t\tfloat dx3 = dx1 / 2.0;\n\t\t\tfloat dy3 = dy1 / 2.0;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy2 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx2, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx3, dy3 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n\t\t\t) * ( 1.0 / 17.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n\t\t\tvec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n\t\t\tfloat dx = texelSize.x;\n\t\t\tfloat dy = texelSize.y;\n\t\t\tvec2 uv = shadowCoord.xy;\n\t\t\tvec2 f = fract( uv * shadowMapSize + 0.5 );\n\t\t\tuv -= f * texelSize;\n\t\t\tshadow = (\n\t\t\t\ttexture2DCompare( shadowMap, uv, shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( dx, 0.0 ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( 0.0, dy ), shadowCoord.z ) +\n\t\t\t\ttexture2DCompare( shadowMap, uv + texelSize, shadowCoord.z ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, 0.0 ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 0.0 ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( -dx, dy ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 2.0 * dx, dy ), shadowCoord.z ),\n\t\t\t\t\t f.x ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( 0.0, -dy ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( 0.0, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( texture2DCompare( shadowMap, uv + vec2( dx, -dy ), shadowCoord.z ), \n\t\t\t\t\t texture2DCompare( shadowMap, uv + vec2( dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t f.y ) +\n\t\t\t\tmix( mix( texture2DCompare( shadowMap, uv + vec2( -dx, -dy ), shadowCoord.z ), \n\t\t\t\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( 2.0 * dx, -dy ), shadowCoord.z ),\n\t\t\t\t\t\t\tf.x ),\n\t\t\t\t\t mix( texture2DCompare( shadowMap, uv + vec2( -dx, 2.0 * dy ), shadowCoord.z ), \n\t\t\t\t\t\t\ttexture2DCompare( shadowMap, uv + vec2( 2.0 * dx, 2.0 * dy ), shadowCoord.z ),\n\t\t\t\t\t\t\tf.x ),\n\t\t\t\t\t f.y )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#elif defined( SHADOWMAP_TYPE_VSM )\n\t\t\tshadow = VSMShadow( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#else\n\t\t\tshadow = texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n\t\t#endif\n\t\t}\n\t\treturn shadow;\n\t}\n\tvec2 cubeToUV( vec3 v, float texelSizeY ) {\n\t\tvec3 absV = abs( v );\n\t\tfloat scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n\t\tabsV *= scaleToCube;\n\t\tv *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n\t\tvec2 planar = v.xy;\n\t\tfloat almostATexel = 1.5 * texelSizeY;\n\t\tfloat almostOne = 1.0 - almostATexel;\n\t\tif ( absV.z >= almostOne ) {\n\t\t\tif ( v.z > 0.0 )\n\t\t\t\tplanar.x = 4.0 - v.x;\n\t\t} else if ( absV.x >= almostOne ) {\n\t\t\tfloat signX = sign( v.x );\n\t\t\tplanar.x = v.z * signX + 2.0 * signX;\n\t\t} else if ( absV.y >= almostOne ) {\n\t\t\tfloat signY = sign( v.y );\n\t\t\tplanar.x = v.x + 2.0 * signY + 2.0;\n\t\t\tplanar.y = v.z * signY - 2.0;\n\t\t}\n\t\treturn vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n\t}\n\tfloat getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord, float shadowCameraNear, float shadowCameraFar ) {\n\t\tvec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n\t\tvec3 lightToPosition = shadowCoord.xyz;\n\t\tfloat dp = ( length( lightToPosition ) - shadowCameraNear ) / ( shadowCameraFar - shadowCameraNear );\t\tdp += shadowBias;\n\t\tvec3 bd3D = normalize( lightToPosition );\n\t\t#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT ) || defined( SHADOWMAP_TYPE_VSM )\n\t\t\tvec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n\t\t\treturn (\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n\t\t\t\ttexture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n\t\t\t) * ( 1.0 / 9.0 );\n\t\t#else\n\t\t\treturn texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n\t\t#endif\n\t}\n#endif",shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t\tuniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tvarying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHT_SHADOWS ];\n\t\tstruct DirectionalLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform DirectionalLightShadow directionalLightShadows[ NUM_DIR_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHT_SHADOWS ];\n\t\tstruct SpotLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t};\n\t\tuniform SpotLightShadow spotLightShadows[ NUM_SPOT_LIGHT_SHADOWS ];\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t\tuniform mat4 pointShadowMatrix[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tvarying vec4 vPointShadowCoord[ NUM_POINT_LIGHT_SHADOWS ];\n\t\tstruct PointLightShadow {\n\t\t\tfloat shadowBias;\n\t\t\tfloat shadowNormalBias;\n\t\t\tfloat shadowRadius;\n\t\t\tvec2 shadowMapSize;\n\t\t\tfloat shadowCameraNear;\n\t\t\tfloat shadowCameraFar;\n\t\t};\n\t\tuniform PointLightShadow pointLightShadows[ NUM_POINT_LIGHT_SHADOWS ];\n\t#endif\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0 || NUM_SPOT_LIGHT_SHADOWS > 0 || NUM_POINT_LIGHT_SHADOWS > 0\n\t\tvec3 shadowWorldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n\t\tvec4 shadowWorldPosition;\n\t#endif\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * directionalLightShadows[ i ].shadowNormalBias, 0 );\n\t\tvDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * spotLightShadows[ i ].shadowNormalBias, 0 );\n\t\tvSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tshadowWorldPosition = worldPosition + vec4( shadowWorldNormal * pointLightShadows[ i ].shadowNormalBias, 0 );\n\t\tvPointShadowCoord[ i ] = pointShadowMatrix[ i ] * shadowWorldPosition;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n#endif",shadowmask_pars_fragment:"float getShadowMask() {\n\tfloat shadow = 1.0;\n\t#ifdef USE_SHADOWMAP\n\t#if NUM_DIR_LIGHT_SHADOWS > 0\n\tDirectionalLightShadow directionalLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_DIR_LIGHT_SHADOWS; i ++ ) {\n\t\tdirectionalLight = directionalLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_SPOT_LIGHT_SHADOWS > 0\n\tSpotLightShadow spotLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_SPOT_LIGHT_SHADOWS; i ++ ) {\n\t\tspotLight = spotLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#if NUM_POINT_LIGHT_SHADOWS > 0\n\tPointLightShadow pointLight;\n\t#pragma unroll_loop_start\n\tfor ( int i = 0; i < NUM_POINT_LIGHT_SHADOWS; i ++ ) {\n\t\tpointLight = pointLightShadows[ i ];\n\t\tshadow *= receiveShadow ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ], pointLight.shadowCameraNear, pointLight.shadowCameraFar ) : 1.0;\n\t}\n\t#pragma unroll_loop_end\n\t#endif\n\t#endif\n\treturn shadow;\n}",skinbase_vertex:"#ifdef USE_SKINNING\n\tmat4 boneMatX = getBoneMatrix( skinIndex.x );\n\tmat4 boneMatY = getBoneMatrix( skinIndex.y );\n\tmat4 boneMatZ = getBoneMatrix( skinIndex.z );\n\tmat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\n\tuniform mat4 bindMatrix;\n\tuniform mat4 bindMatrixInverse;\n\tuniform highp sampler2D boneTexture;\n\tuniform int boneTextureSize;\n\tmat4 getBoneMatrix( const in float i ) {\n\t\tfloat j = i * 4.0;\n\t\tfloat x = mod( j, float( boneTextureSize ) );\n\t\tfloat y = floor( j / float( boneTextureSize ) );\n\t\tfloat dx = 1.0 / float( boneTextureSize );\n\t\tfloat dy = 1.0 / float( boneTextureSize );\n\t\ty = dy * ( y + 0.5 );\n\t\tvec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n\t\tvec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n\t\tvec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n\t\tvec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n\t\tmat4 bone = mat4( v1, v2, v3, v4 );\n\t\treturn bone;\n\t}\n#endif",skinning_vertex:"#ifdef USE_SKINNING\n\tvec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n\tvec4 skinned = vec4( 0.0 );\n\tskinned += boneMatX * skinVertex * skinWeight.x;\n\tskinned += boneMatY * skinVertex * skinWeight.y;\n\tskinned += boneMatZ * skinVertex * skinWeight.z;\n\tskinned += boneMatW * skinVertex * skinWeight.w;\n\ttransformed = ( bindMatrixInverse * skinned ).xyz;\n#endif",skinnormal_vertex:"#ifdef USE_SKINNING\n\tmat4 skinMatrix = mat4( 0.0 );\n\tskinMatrix += skinWeight.x * boneMatX;\n\tskinMatrix += skinWeight.y * boneMatY;\n\tskinMatrix += skinWeight.z * boneMatZ;\n\tskinMatrix += skinWeight.w * boneMatW;\n\tskinMatrix = bindMatrixInverse * skinMatrix * bindMatrix;\n\tobjectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n\t#ifdef USE_TANGENT\n\t\tobjectTangent = vec4( skinMatrix * vec4( objectTangent, 0.0 ) ).xyz;\n\t#endif\n#endif",specularmap_fragment:"float specularStrength;\n#ifdef USE_SPECULARMAP\n\tvec4 texelSpecular = texture2D( specularMap, vUv );\n\tspecularStrength = texelSpecular.r;\n#else\n\tspecularStrength = 1.0;\n#endif",specularmap_pars_fragment:"#ifdef USE_SPECULARMAP\n\tuniform sampler2D specularMap;\n#endif",tonemapping_fragment:"#if defined( TONE_MAPPING )\n\tgl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif",tonemapping_pars_fragment:"#ifndef saturate\n#define saturate( a ) clamp( a, 0.0, 1.0 )\n#endif\nuniform float toneMappingExposure;\nvec3 LinearToneMapping( vec3 color ) {\n\treturn toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\treturn saturate( color / ( vec3( 1.0 ) + color ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n\tcolor *= toneMappingExposure;\n\tcolor = max( vec3( 0.0 ), color - 0.004 );\n\treturn pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\nvec3 RRTAndODTFit( vec3 v ) {\n\tvec3 a = v * ( v + 0.0245786 ) - 0.000090537;\n\tvec3 b = v * ( 0.983729 * v + 0.4329510 ) + 0.238081;\n\treturn a / b;\n}\nvec3 ACESFilmicToneMapping( vec3 color ) {\n\tconst mat3 ACESInputMat = mat3(\n\t\tvec3( 0.59719, 0.07600, 0.02840 ),\t\tvec3( 0.35458, 0.90834, 0.13383 ),\n\t\tvec3( 0.04823, 0.01566, 0.83777 )\n\t);\n\tconst mat3 ACESOutputMat = mat3(\n\t\tvec3(\t1.60475, -0.10208, -0.00327 ),\t\tvec3( -0.53108,\t1.10813, -0.07276 ),\n\t\tvec3( -0.07367, -0.00605,\t1.07602 )\n\t);\n\tcolor *= toneMappingExposure / 0.6;\n\tcolor = ACESInputMat * color;\n\tcolor = RRTAndODTFit( color );\n\tcolor = ACESOutputMat * color;\n\treturn saturate( color );\n}\nvec3 CustomToneMapping( vec3 color ) { return color; }",transmission_fragment:"#ifdef USE_TRANSMISSION\n\tfloat transmissionAlpha = 1.0;\n\tfloat transmissionFactor = transmission;\n\tfloat thicknessFactor = thickness;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\ttransmissionFactor *= texture2D( transmissionMap, vUv ).r;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tthicknessFactor *= texture2D( thicknessMap, vUv ).g;\n\t#endif\n\tvec3 pos = vWorldPosition;\n\tvec3 v = normalize( cameraPosition - pos );\n\tvec3 n = inverseTransformDirection( normal, viewMatrix );\n\tvec4 transmission = getIBLVolumeRefraction(\n\t\tn, v, roughnessFactor, material.diffuseColor, material.specularColor, material.specularF90,\n\t\tpos, modelMatrix, viewMatrix, projectionMatrix, ior, thicknessFactor,\n\t\tattenuationColor, attenuationDistance );\n\ttotalDiffuse = mix( totalDiffuse, transmission.rgb, transmissionFactor );\n\ttransmissionAlpha = mix( transmissionAlpha, transmission.a, transmissionFactor );\n#endif",transmission_pars_fragment:"#ifdef USE_TRANSMISSION\n\tuniform float transmission;\n\tuniform float thickness;\n\tuniform float attenuationDistance;\n\tuniform vec3 attenuationColor;\n\t#ifdef USE_TRANSMISSIONMAP\n\t\tuniform sampler2D transmissionMap;\n\t#endif\n\t#ifdef USE_THICKNESSMAP\n\t\tuniform sampler2D thicknessMap;\n\t#endif\n\tuniform vec2 transmissionSamplerSize;\n\tuniform sampler2D transmissionSamplerMap;\n\tuniform mat4 modelMatrix;\n\tuniform mat4 projectionMatrix;\n\tvarying vec3 vWorldPosition;\n\tvec3 getVolumeTransmissionRay( const in vec3 n, const in vec3 v, const in float thickness, const in float ior, const in mat4 modelMatrix ) {\n\t\tvec3 refractionVector = refract( - v, normalize( n ), 1.0 / ior );\n\t\tvec3 modelScale;\n\t\tmodelScale.x = length( vec3( modelMatrix[ 0 ].xyz ) );\n\t\tmodelScale.y = length( vec3( modelMatrix[ 1 ].xyz ) );\n\t\tmodelScale.z = length( vec3( modelMatrix[ 2 ].xyz ) );\n\t\treturn normalize( refractionVector ) * thickness * modelScale;\n\t}\n\tfloat applyIorToRoughness( const in float roughness, const in float ior ) {\n\t\treturn roughness * clamp( ior * 2.0 - 2.0, 0.0, 1.0 );\n\t}\n\tvec4 getTransmissionSample( const in vec2 fragCoord, const in float roughness, const in float ior ) {\n\t\tfloat framebufferLod = log2( transmissionSamplerSize.x ) * applyIorToRoughness( roughness, ior );\n\t\t#ifdef texture2DLodEXT\n\t\t\treturn texture2DLodEXT( transmissionSamplerMap, fragCoord.xy, framebufferLod );\n\t\t#else\n\t\t\treturn texture2D( transmissionSamplerMap, fragCoord.xy, framebufferLod );\n\t\t#endif\n\t}\n\tvec3 applyVolumeAttenuation( const in vec3 radiance, const in float transmissionDistance, const in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tif ( attenuationDistance == 0.0 ) {\n\t\t\treturn radiance;\n\t\t} else {\n\t\t\tvec3 attenuationCoefficient = -log( attenuationColor ) / attenuationDistance;\n\t\t\tvec3 transmittance = exp( - attenuationCoefficient * transmissionDistance );\t\t\treturn transmittance * radiance;\n\t\t}\n\t}\n\tvec4 getIBLVolumeRefraction( const in vec3 n, const in vec3 v, const in float roughness, const in vec3 diffuseColor,\n\t\tconst in vec3 specularColor, const in float specularF90, const in vec3 position, const in mat4 modelMatrix,\n\t\tconst in mat4 viewMatrix, const in mat4 projMatrix, const in float ior, const in float thickness,\n\t\tconst in vec3 attenuationColor, const in float attenuationDistance ) {\n\t\tvec3 transmissionRay = getVolumeTransmissionRay( n, v, thickness, ior, modelMatrix );\n\t\tvec3 refractedRayExit = position + transmissionRay;\n\t\tvec4 ndcPos = projMatrix * viewMatrix * vec4( refractedRayExit, 1.0 );\n\t\tvec2 refractionCoords = ndcPos.xy / ndcPos.w;\n\t\trefractionCoords += 1.0;\n\t\trefractionCoords /= 2.0;\n\t\tvec4 transmittedLight = getTransmissionSample( refractionCoords, roughness, ior );\n\t\tvec3 attenuatedColor = applyVolumeAttenuation( transmittedLight.rgb, length( transmissionRay ), attenuationColor, attenuationDistance );\n\t\tvec3 F = EnvironmentBRDF( n, v, specularColor, specularF90, roughness );\n\t\treturn vec4( ( 1.0 - F ) * attenuatedColor * diffuseColor, transmittedLight.a );\n\t}\n#endif",uv_pars_fragment:"#if ( defined( USE_UV ) && ! defined( UVS_VERTEX_ONLY ) )\n\tvarying vec2 vUv;\n#endif",uv_pars_vertex:"#ifdef USE_UV\n\t#ifdef UVS_VERTEX_ONLY\n\t\tvec2 vUv;\n\t#else\n\t\tvarying vec2 vUv;\n\t#endif\n\tuniform mat3 uvTransform;\n#endif",uv_vertex:"#ifdef USE_UV\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n#endif",uv2_pars_fragment:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvarying vec2 vUv2;\n#endif",uv2_pars_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tattribute vec2 uv2;\n\tvarying vec2 vUv2;\n\tuniform mat3 uv2Transform;\n#endif",uv2_vertex:"#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n\tvUv2 = ( uv2Transform * vec3( uv2, 1 ) ).xy;\n#endif",worldpos_vertex:"#if defined( USE_ENVMAP ) || defined( DISTANCE ) || defined ( USE_SHADOWMAP ) || defined ( USE_TRANSMISSION )\n\tvec4 worldPosition = vec4( transformed, 1.0 );\n\t#ifdef USE_INSTANCING\n\t\tworldPosition = instanceMatrix * worldPosition;\n\t#endif\n\tworldPosition = modelMatrix * worldPosition;\n#endif",background_vert:"varying vec2 vUv;\nuniform mat3 uvTransform;\nvoid main() {\n\tvUv = ( uvTransform * vec3( uv, 1 ) ).xy;\n\tgl_Position = vec4( position.xy, 1.0, 1.0 );\n}",background_frag:"uniform sampler2D t2D;\nvarying vec2 vUv;\nvoid main() {\n\tgl_FragColor = texture2D( t2D, vUv );\n\t#ifdef DECODE_VIDEO_TEXTURE\n\t\tgl_FragColor = vec4( mix( pow( gl_FragColor.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), gl_FragColor.rgb * 0.0773993808, vec3( lessThanEqual( gl_FragColor.rgb, vec3( 0.04045 ) ) ) ), gl_FragColor.w );\n\t#endif\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}",cube_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n\tgl_Position.z = gl_Position.w;\n}",cube_frag:"#include <envmap_common_pars_fragment>\nuniform float opacity;\nvarying vec3 vWorldDirection;\n#include <cube_uv_reflection_fragment>\nvoid main() {\n\tvec3 vReflect = vWorldDirection;\n\t#include <envmap_fragment>\n\tgl_FragColor = envColor;\n\tgl_FragColor.a *= opacity;\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}",depth_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvHighPrecisionZW = gl_Position.zw;\n}",depth_frag:"#if DEPTH_PACKING == 3200\n\tuniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvarying vec2 vHighPrecisionZW;\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#if DEPTH_PACKING == 3200\n\t\tdiffuseColor.a = opacity;\n\t#endif\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <logdepthbuf_fragment>\n\tfloat fragCoordZ = 0.5 * vHighPrecisionZW[0] / vHighPrecisionZW[1] + 0.5;\n\t#if DEPTH_PACKING == 3200\n\t\tgl_FragColor = vec4( vec3( 1.0 - fragCoordZ ), opacity );\n\t#elif DEPTH_PACKING == 3201\n\t\tgl_FragColor = packDepthToRGBA( fragCoordZ );\n\t#endif\n}",distanceRGBA_vert:"#define DISTANCE\nvarying vec3 vWorldPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <skinbase_vertex>\n\t#ifdef USE_DISPLACEMENTMAP\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <clipping_planes_vertex>\n\tvWorldPosition = worldPosition.xyz;\n}",distanceRGBA_frag:"#define DISTANCE\nuniform vec3 referencePosition;\nuniform float nearDistance;\nuniform float farDistance;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( 1.0 );\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\tfloat dist = length( vWorldPosition - referencePosition );\n\tdist = ( dist - nearDistance ) / ( farDistance - nearDistance );\n\tdist = saturate( dist );\n\tgl_FragColor = packDepthToRGBA( dist );\n}",equirect_vert:"varying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvWorldDirection = transformDirection( position, modelMatrix );\n\t#include <begin_vertex>\n\t#include <project_vertex>\n}",equirect_frag:"uniform sampler2D tEquirect;\nvarying vec3 vWorldDirection;\n#include <common>\nvoid main() {\n\tvec3 direction = normalize( vWorldDirection );\n\tvec2 sampleUV = equirectUv( direction );\n\tgl_FragColor = texture2D( tEquirect, sampleUV );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n}",linedashed_vert:"uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\tvLineDistance = scale * lineDistance;\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",linedashed_frag:"uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tif ( mod( vLineDistance, totalSize ) > dashSize ) {\n\t\tdiscard;\n\t}\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <color_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <output_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",meshbasic_vert:"#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#if defined ( USE_ENVMAP ) || defined ( USE_SKINNING )\n\t\t#include <beginnormal_vertex>\n\t\t#include <morphnormal_vertex>\n\t\t#include <skinbase_vertex>\n\t\t#include <skinnormal_vertex>\n\t\t#include <defaultnormal_vertex>\n\t#endif\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <fog_vertex>\n}",meshbasic_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n\tvarying vec3 vNormal;\n#endif\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <cube_uv_reflection_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\t#ifdef USE_LIGHTMAP\n\t\tvec4 lightMapTexel = texture2D( lightMap, vUv2 );\n\t\treflectedLight.indirectDiffuse += lightMapTexel.rgb * lightMapIntensity * RECIPROCAL_PI;\n\t#else\n\t\treflectedLight.indirectDiffuse += vec3( 1.0 );\n\t#endif\n\t#include <aomap_fragment>\n\treflectedLight.indirectDiffuse *= diffuseColor.rgb;\n\tvec3 outgoingLight = reflectedLight.indirectDiffuse;\n\t#include <envmap_fragment>\n\t#include <output_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshlambert_vert:"#define LAMBERT\nvarying vec3 vLightFront;\nvarying vec3 vIndirectFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n\tvarying vec3 vIndirectBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <lights_lambert_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshlambert_frag:"uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\nvarying vec3 vIndirectFront;\n#ifdef DOUBLE_SIDED\n\tvarying vec3 vLightBack;\n\tvarying vec3 vIndirectBack;\n#endif\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <cube_uv_reflection_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <emissivemap_fragment>\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.indirectDiffuse += ( gl_FrontFacing ) ? vIndirectFront : vIndirectBack;\n\t#else\n\t\treflectedLight.indirectDiffuse += vIndirectFront;\n\t#endif\n\t#include <lightmap_fragment>\n\treflectedLight.indirectDiffuse *= BRDF_Lambert( diffuseColor.rgb );\n\t#ifdef DOUBLE_SIDED\n\t\treflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n\t#else\n\t\treflectedLight.directDiffuse = vLightFront;\n\t#endif\n\treflectedLight.directDiffuse *= BRDF_Lambert( diffuseColor.rgb ) * getShadowMask();\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <output_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshmatcap_vert:"#define MATCAP\nvarying vec3 vViewPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <color_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n\tvViewPosition = - mvPosition.xyz;\n}",meshmatcap_frag:"#define MATCAP\nuniform vec3 diffuse;\nuniform float opacity;\nuniform sampler2D matcap;\nvarying vec3 vViewPosition;\n#include <common>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <fog_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tvec3 viewDir = normalize( vViewPosition );\n\tvec3 x = normalize( vec3( viewDir.z, 0.0, - viewDir.x ) );\n\tvec3 y = cross( viewDir, x );\n\tvec2 uv = vec2( dot( x, normal ), dot( y, normal ) ) * 0.495 + 0.5;\n\t#ifdef USE_MATCAP\n\t\tvec4 matcapColor = texture2D( matcap, uv );\n\t#else\n\t\tvec4 matcapColor = vec4( vec3( mix( 0.2, 0.8, uv.y ) ), 1.0 );\n\t#endif\n\tvec3 outgoingLight = diffuseColor.rgb * matcapColor.rgb;\n\t#include <output_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshnormal_vert:"#define NORMAL\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvViewPosition = - mvPosition.xyz;\n#endif\n}",meshnormal_frag:"#define NORMAL\nuniform float opacity;\n#if defined( FLAT_SHADED ) || defined( USE_BUMPMAP ) || defined( TANGENTSPACE_NORMALMAP )\n\tvarying vec3 vViewPosition;\n#endif\n#include <packing>\n#include <uv_pars_fragment>\n#include <normal_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\t#include <logdepthbuf_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\tgl_FragColor = vec4( packNormalToRGB( normal ), opacity );\n\t#ifdef OPAQUE\n\t\tgl_FragColor.a = 1.0;\n\t#endif\n}",meshphong_vert:"#define PHONG\nvarying vec3 vViewPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <envmap_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshphong_frag:"#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_pars_fragment>\n#include <cube_uv_reflection_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <specularmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_phong_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n\t#include <envmap_fragment>\n\t#include <output_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshphysical_vert:"#define STANDARD\nvarying vec3 vViewPosition;\n#ifdef USE_TRANSMISSION\n\tvarying vec3 vWorldPosition;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n#ifdef USE_TRANSMISSION\n\tvWorldPosition = worldPosition.xyz;\n#endif\n}",meshphysical_frag:"#define STANDARD\n#ifdef PHYSICAL\n\t#define IOR\n\t#define SPECULAR\n#endif\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\n#ifdef IOR\n\tuniform float ior;\n#endif\n#ifdef SPECULAR\n\tuniform float specularIntensity;\n\tuniform vec3 specularColor;\n\t#ifdef USE_SPECULARINTENSITYMAP\n\t\tuniform sampler2D specularIntensityMap;\n\t#endif\n\t#ifdef USE_SPECULARCOLORMAP\n\t\tuniform sampler2D specularColorMap;\n\t#endif\n#endif\n#ifdef USE_CLEARCOAT\n\tuniform float clearcoat;\n\tuniform float clearcoatRoughness;\n#endif\n#ifdef USE_IRIDESCENCE\n\tuniform float iridescence;\n\tuniform float iridescenceIOR;\n\tuniform float iridescenceThicknessMinimum;\n\tuniform float iridescenceThicknessMaximum;\n#endif\n#ifdef USE_SHEEN\n\tuniform vec3 sheenColor;\n\tuniform float sheenRoughness;\n\t#ifdef USE_SHEENCOLORMAP\n\t\tuniform sampler2D sheenColorMap;\n\t#endif\n\t#ifdef USE_SHEENROUGHNESSMAP\n\t\tuniform sampler2D sheenRoughnessMap;\n\t#endif\n#endif\nvarying vec3 vViewPosition;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <bsdfs>\n#include <iridescence_fragment>\n#include <cube_uv_reflection_fragment>\n#include <envmap_common_pars_fragment>\n#include <envmap_physical_pars_fragment>\n#include <fog_pars_fragment>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_physical_pars_fragment>\n#include <transmission_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <clearcoat_pars_fragment>\n#include <iridescence_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <roughnessmap_fragment>\n\t#include <metalnessmap_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <clearcoat_normal_fragment_begin>\n\t#include <clearcoat_normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_physical_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 totalDiffuse = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse;\n\tvec3 totalSpecular = reflectedLight.directSpecular + reflectedLight.indirectSpecular;\n\t#include <transmission_fragment>\n\tvec3 outgoingLight = totalDiffuse + totalSpecular + totalEmissiveRadiance;\n\t#ifdef USE_SHEEN\n\t\tfloat sheenEnergyComp = 1.0 - 0.157 * max3( material.sheenColor );\n\t\toutgoingLight = outgoingLight * sheenEnergyComp + sheenSpecular;\n\t#endif\n\t#ifdef USE_CLEARCOAT\n\t\tfloat dotNVcc = saturate( dot( geometry.clearcoatNormal, geometry.viewDir ) );\n\t\tvec3 Fcc = F_Schlick( material.clearcoatF0, material.clearcoatF90, dotNVcc );\n\t\toutgoingLight = outgoingLight * ( 1.0 - material.clearcoat * Fcc ) + clearcoatSpecular * material.clearcoat;\n\t#endif\n\t#include <output_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",meshtoon_vert:"#define TOON\nvarying vec3 vViewPosition;\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <normal_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\t#include <uv2_vertex>\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <normal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <displacementmap_vertex>\n\t#include <project_vertex>\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\tvViewPosition = - mvPosition.xyz;\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",meshtoon_frag:"#define TOON\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <dithering_pars_fragment>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <gradientmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <normal_pars_fragment>\n#include <lights_toon_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\tReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n\tvec3 totalEmissiveRadiance = emissive;\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <color_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\t#include <normal_fragment_begin>\n\t#include <normal_fragment_maps>\n\t#include <emissivemap_fragment>\n\t#include <lights_toon_fragment>\n\t#include <lights_fragment_begin>\n\t#include <lights_fragment_maps>\n\t#include <lights_fragment_end>\n\t#include <aomap_fragment>\n\tvec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n\t#include <output_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n\t#include <dithering_fragment>\n}",points_vert:"uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <color_vertex>\n\t#include <morphcolor_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <project_vertex>\n\tgl_PointSize = size;\n\t#ifdef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) gl_PointSize *= ( scale / - mvPosition.z );\n\t#endif\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <worldpos_vertex>\n\t#include <fog_vertex>\n}",points_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_particle_fragment>\n\t#include <color_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <output_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n\t#include <premultiplied_alpha_fragment>\n}",shadow_vert:"#include <common>\n#include <fog_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\nvoid main() {\n\t#include <beginnormal_vertex>\n\t#include <morphnormal_vertex>\n\t#include <skinbase_vertex>\n\t#include <skinnormal_vertex>\n\t#include <defaultnormal_vertex>\n\t#include <begin_vertex>\n\t#include <morphtarget_vertex>\n\t#include <skinning_vertex>\n\t#include <project_vertex>\n\t#include <worldpos_vertex>\n\t#include <shadowmap_vertex>\n\t#include <fog_vertex>\n}",shadow_frag:"uniform vec3 color;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars_begin>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\nvoid main() {\n\tgl_FragColor = vec4( color, opacity * ( 1.0 - getShadowMask() ) );\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}",sprite_vert:"uniform float rotation;\nuniform vec2 center;\n#include <common>\n#include <uv_pars_vertex>\n#include <fog_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n\t#include <uv_vertex>\n\tvec4 mvPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\n\tvec2 scale;\n\tscale.x = length( vec3( modelMatrix[ 0 ].x, modelMatrix[ 0 ].y, modelMatrix[ 0 ].z ) );\n\tscale.y = length( vec3( modelMatrix[ 1 ].x, modelMatrix[ 1 ].y, modelMatrix[ 1 ].z ) );\n\t#ifndef USE_SIZEATTENUATION\n\t\tbool isPerspective = isPerspectiveMatrix( projectionMatrix );\n\t\tif ( isPerspective ) scale *= - mvPosition.z;\n\t#endif\n\tvec2 alignedPosition = ( position.xy - ( center - vec2( 0.5 ) ) ) * scale;\n\tvec2 rotatedPosition;\n\trotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;\n\trotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;\n\tmvPosition.xy += rotatedPosition;\n\tgl_Position = projectionMatrix * mvPosition;\n\t#include <logdepthbuf_vertex>\n\t#include <clipping_planes_vertex>\n\t#include <fog_vertex>\n}",sprite_frag:"uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <alphatest_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n\t#include <clipping_planes_fragment>\n\tvec3 outgoingLight = vec3( 0.0 );\n\tvec4 diffuseColor = vec4( diffuse, opacity );\n\t#include <logdepthbuf_fragment>\n\t#include <map_fragment>\n\t#include <alphamap_fragment>\n\t#include <alphatest_fragment>\n\toutgoingLight = diffuseColor.rgb;\n\t#include <output_fragment>\n\t#include <tonemapping_fragment>\n\t#include <encodings_fragment>\n\t#include <fog_fragment>\n}"},xi={common:{diffuse:{value:new Ht(16777215)},opacity:{value:1},map:{value:null},uvTransform:{value:new Rt},uv2Transform:{value:new Rt},alphaMap:{value:null},alphaTest:{value:0}},specularmap:{specularMap:{value:null}},envmap:{envMap:{value:null},flipEnvMap:{value:-1},reflectivity:{value:1},ior:{value:1.5},refractionRatio:{value:.98}},aomap:{aoMap:{value:null},aoMapIntensity:{value:1}},lightmap:{lightMap:{value:null},lightMapIntensity:{value:1}},emissivemap:{emissiveMap:{value:null}},bumpmap:{bumpMap:{value:null},bumpScale:{value:1}},normalmap:{normalMap:{value:null},normalScale:{value:new At(1,1)}},displacementmap:{displacementMap:{value:null},displacementScale:{value:1},displacementBias:{value:0}},roughnessmap:{roughnessMap:{value:null}},metalnessmap:{metalnessMap:{value:null}},gradientmap:{gradientMap:{value:null}},fog:{fogDensity:{value:25e-5},fogNear:{value:1},fogFar:{value:2e3},fogColor:{value:new Ht(16777215)}},lights:{ambientLightColor:{value:[]},lightProbe:{value:[]},directionalLights:{value:[],properties:{direction:{},color:{}}},directionalLightShadows:{value:[],properties:{shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},directionalShadowMap:{value:[]},directionalShadowMatrix:{value:[]},spotLights:{value:[],properties:{color:{},position:{},direction:{},distance:{},coneCos:{},penumbraCos:{},decay:{}}},spotLightShadows:{value:[],properties:{shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{}}},spotShadowMap:{value:[]},spotShadowMatrix:{value:[]},pointLights:{value:[],properties:{color:{},position:{},decay:{},distance:{}}},pointLightShadows:{value:[],properties:{shadowBias:{},shadowNormalBias:{},shadowRadius:{},shadowMapSize:{},shadowCameraNear:{},shadowCameraFar:{}}},pointShadowMap:{value:[]},pointShadowMatrix:{value:[]},hemisphereLights:{value:[],properties:{direction:{},skyColor:{},groundColor:{}}},rectAreaLights:{value:[],properties:{color:{},position:{},width:{},height:{}}},ltc_1:{value:null},ltc_2:{value:null}},points:{diffuse:{value:new Ht(16777215)},opacity:{value:1},size:{value:1},scale:{value:1},map:{value:null},alphaMap:{value:null},alphaTest:{value:0},uvTransform:{value:new Rt}},sprite:{diffuse:{value:new Ht(16777215)},opacity:{value:1},center:{value:new At(.5,.5)},rotation:{value:0},map:{value:null},alphaMap:{value:null},alphaTest:{value:0},uvTransform:{value:new Rt}}},bi={basic:{uniforms:ti([xi.common,xi.specularmap,xi.envmap,xi.aomap,xi.lightmap,xi.fog]),vertexShader:yi.meshbasic_vert,fragmentShader:yi.meshbasic_frag},lambert:{uniforms:ti([xi.common,xi.specularmap,xi.envmap,xi.aomap,xi.lightmap,xi.emissivemap,xi.fog,xi.lights,{emissive:{value:new Ht(0)}}]),vertexShader:yi.meshlambert_vert,fragmentShader:yi.meshlambert_frag},phong:{uniforms:ti([xi.common,xi.specularmap,xi.envmap,xi.aomap,xi.lightmap,xi.emissivemap,xi.bumpmap,xi.normalmap,xi.displacementmap,xi.fog,xi.lights,{emissive:{value:new Ht(0)},specular:{value:new Ht(1118481)},shininess:{value:30}}]),vertexShader:yi.meshphong_vert,fragmentShader:yi.meshphong_frag},standard:{uniforms:ti([xi.common,xi.envmap,xi.aomap,xi.lightmap,xi.emissivemap,xi.bumpmap,xi.normalmap,xi.displacementmap,xi.roughnessmap,xi.metalnessmap,xi.fog,xi.lights,{emissive:{value:new Ht(0)},roughness:{value:1},metalness:{value:0},envMapIntensity:{value:1}}]),vertexShader:yi.meshphysical_vert,fragmentShader:yi.meshphysical_frag},toon:{uniforms:ti([xi.common,xi.aomap,xi.lightmap,xi.emissivemap,xi.bumpmap,xi.normalmap,xi.displacementmap,xi.gradientmap,xi.fog,xi.lights,{emissive:{value:new Ht(0)}}]),vertexShader:yi.meshtoon_vert,fragmentShader:yi.meshtoon_frag},matcap:{uniforms:ti([xi.common,xi.bumpmap,xi.normalmap,xi.displacementmap,xi.fog,{matcap:{value:null}}]),vertexShader:yi.meshmatcap_vert,fragmentShader:yi.meshmatcap_frag},points:{uniforms:ti([xi.points,xi.fog]),vertexShader:yi.points_vert,fragmentShader:yi.points_frag},dashed:{uniforms:ti([xi.common,xi.fog,{scale:{value:1},dashSize:{value:1},totalSize:{value:2}}]),vertexShader:yi.linedashed_vert,fragmentShader:yi.linedashed_frag},depth:{uniforms:ti([xi.common,xi.displacementmap]),vertexShader:yi.depth_vert,fragmentShader:yi.depth_frag},normal:{uniforms:ti([xi.common,xi.bumpmap,xi.normalmap,xi.displacementmap,{opacity:{value:1}}]),vertexShader:yi.meshnormal_vert,fragmentShader:yi.meshnormal_frag},sprite:{uniforms:ti([xi.sprite,xi.fog]),vertexShader:yi.sprite_vert,fragmentShader:yi.sprite_frag},background:{uniforms:{uvTransform:{value:new Rt},t2D:{value:null}},vertexShader:yi.background_vert,fragmentShader:yi.background_frag},cube:{uniforms:ti([xi.envmap,{opacity:{value:1}}]),vertexShader:yi.cube_vert,fragmentShader:yi.cube_frag},equirect:{uniforms:{tEquirect:{value:null}},vertexShader:yi.equirect_vert,fragmentShader:yi.equirect_frag},distanceRGBA:{uniforms:ti([xi.common,xi.displacementmap,{referencePosition:{value:new ee},nearDistance:{value:1},farDistance:{value:1e3}}]),vertexShader:yi.distanceRGBA_vert,fragmentShader:yi.distanceRGBA_frag},shadow:{uniforms:ti([xi.lights,xi.fog,{color:{value:new Ht(0)},opacity:{value:1}}]),vertexShader:yi.shadow_vert,fragmentShader:yi.shadow_frag}};function Mi(t,e,n,i,r,s){const a=new Ht(0);let o,l,u=!0===r?0:1,h=null,d=0,p=null;function f(t,e){n.buffers.color.setClear(t.r,t.g,t.b,e,s)}return{getClearColor:function(){return a},setClearColor:function(t,e=1){a.set(t),u=e,f(a,u)},getClearAlpha:function(){return u},setClearAlpha:function(t){u=t,f(a,u)},render:function(n,r){let s=!1,m=!0===r.isScene?r.background:null;m&&m.isTexture&&(m=e.get(m));const g=t.xr,v=g.getSession&&g.getSession();v&&"additive"===v.environmentBlendMode&&(m=null),null===m?f(a,u):m&&m.isColor&&(f(m,1),s=!0),(t.autoClear||s)&&t.clear(t.autoClearColor,t.autoClearDepth,t.autoClearStencil),m&&(m.isCubeTexture||m.mapping===c)?(void 0===l&&(l=new Jn(new $n(1,1,1),new ni({name:"BackgroundCubeMaterial",uniforms:Qn(bi.cube.uniforms),vertexShader:bi.cube.vertexShader,fragmentShader:bi.cube.fragmentShader,side:1,depthTest:!1,depthWrite:!1,fog:!1})),l.geometry.deleteAttribute("normal"),l.geometry.deleteAttribute("uv"),l.onBeforeRender=function(t,e,n){this.matrixWorld.copyPosition(n.matrixWorld)},Object.defineProperty(l.material,"envMap",{get:function(){return this.uniforms.envMap.value}}),i.update(l)),l.material.uniforms.envMap.value=m,l.material.uniforms.flipEnvMap.value=m.isCubeTexture&&!1===m.isRenderTargetTexture?-1:1,h===m&&d===m.version&&p===t.toneMapping||(l.material.needsUpdate=!0,h=m,d=m.version,p=t.toneMapping),l.layers.enableAll(),n.unshift(l,l.geometry,l.material,0,0,null)):m&&m.isTexture&&(void 0===o&&(o=new Jn(new _i(2,2),new ni({name:"BackgroundMaterial",uniforms:Qn(bi.background.uniforms),vertexShader:bi.background.vertexShader,fragmentShader:bi.background.fragmentShader,side:0,depthTest:!1,depthWrite:!1,fog:!1})),o.geometry.deleteAttribute("normal"),Object.defineProperty(o.material,"map",{get:function(){return this.uniforms.t2D.value}}),i.update(o)),o.material.uniforms.t2D.value=m,!0===m.matrixAutoUpdate&&m.updateMatrix(),o.material.uniforms.uvTransform.value.copy(m.matrix),h===m&&d===m.version&&p===t.toneMapping||(o.material.needsUpdate=!0,h=m,d=m.version,p=t.toneMapping),o.layers.enableAll(),n.unshift(o,o.geometry,o.material,0,0,null))}}}function wi(t,e,n,i){const r=t.getParameter(t.MAX_VERTEX_ATTRIBS),s=i.isWebGL2?null:e.get("OES_vertex_array_object"),a=i.isWebGL2||null!==s,o={},l=p(null);let c=l,u=!1;function h(e){return i.isWebGL2?t.bindVertexArray(e):s.bindVertexArrayOES(e)}function d(e){return i.isWebGL2?t.deleteVertexArray(e):s.deleteVertexArrayOES(e)}function p(t){const e=[],n=[],i=[];for(let t=0;t<r;t++)e[t]=0,n[t]=0,i[t]=0;return{geometry:null,program:null,wireframe:!1,newAttributes:e,enabledAttributes:n,attributeDivisors:i,object:t,attributes:{},index:null}}function f(){const t=c.newAttributes;for(let e=0,n=t.length;e<n;e++)t[e]=0}function m(t){g(t,0)}function g(n,r){const s=c.newAttributes,a=c.enabledAttributes,o=c.attributeDivisors;s[n]=1,0===a[n]&&(t.enableVertexAttribArray(n),a[n]=1),o[n]!==r&&((i.isWebGL2?t:e.get("ANGLE_instanced_arrays"))[i.isWebGL2?"vertexAttribDivisor":"vertexAttribDivisorANGLE"](n,r),o[n]=r)}function v(){const e=c.newAttributes,n=c.enabledAttributes;for(let i=0,r=n.length;i<r;i++)n[i]!==e[i]&&(t.disableVertexAttribArray(i),n[i]=0)}function _(e,n,r,s,a,o){!0!==i.isWebGL2||r!==t.INT&&r!==t.UNSIGNED_INT?t.vertexAttribPointer(e,n,r,s,a,o):t.vertexAttribIPointer(e,n,r,a,o)}function y(){x(),u=!0,c!==l&&(c=l,h(c.object))}function x(){l.geometry=null,l.program=null,l.wireframe=!1}return{setup:function(r,l,d,y,x){let b=!1;if(a){const e=function(e,n,r){const a=!0===r.wireframe;let l=o[e.id];void 0===l&&(l={},o[e.id]=l);let c=l[n.id];void 0===c&&(c={},l[n.id]=c);let u=c[a];return void 0===u&&(u=p(i.isWebGL2?t.createVertexArray():s.createVertexArrayOES()),c[a]=u),u}(y,d,l);c!==e&&(c=e,h(c.object)),b=function(t,e,n,i){const r=c.attributes,s=e.attributes;let a=0;const o=n.getAttributes();for(const e in o)if(o[e].location>=0){const n=r[e];let i=s[e];if(void 0===i&&("instanceMatrix"===e&&t.instanceMatrix&&(i=t.instanceMatrix),"instanceColor"===e&&t.instanceColor&&(i=t.instanceColor)),void 0===n)return!0;if(n.attribute!==i)return!0;if(i&&n.data!==i.data)return!0;a++}return c.attributesNum!==a||c.index!==i}(r,y,d,x),b&&function(t,e,n,i){const r={},s=e.attributes;let a=0;const o=n.getAttributes();for(const e in o)if(o[e].location>=0){let n=s[e];void 0===n&&("instanceMatrix"===e&&t.instanceMatrix&&(n=t.instanceMatrix),"instanceColor"===e&&t.instanceColor&&(n=t.instanceColor));const i={};i.attribute=n,n&&n.data&&(i.data=n.data),r[e]=i,a++}c.attributes=r,c.attributesNum=a,c.index=i}(r,y,d,x)}else{const t=!0===l.wireframe;c.geometry===y.id&&c.program===d.id&&c.wireframe===t||(c.geometry=y.id,c.program=d.id,c.wireframe=t,b=!0)}null!==x&&n.update(x,t.ELEMENT_ARRAY_BUFFER),(b||u)&&(u=!1,function(r,s,a,o){if(!1===i.isWebGL2&&(r.isInstancedMesh||o.isInstancedBufferGeometry)&&null===e.get("ANGLE_instanced_arrays"))return;f();const l=o.attributes,c=a.getAttributes(),u=s.defaultAttributeValues;for(const e in c){const i=c[e];if(i.location>=0){let s=l[e];if(void 0===s&&("instanceMatrix"===e&&r.instanceMatrix&&(s=r.instanceMatrix),"instanceColor"===e&&r.instanceColor&&(s=r.instanceColor)),void 0!==s){const e=s.normalized,a=s.itemSize,l=n.get(s);if(void 0===l)continue;const c=l.buffer,u=l.type,h=l.bytesPerElement;if(s.isInterleavedBufferAttribute){const n=s.data,l=n.stride,d=s.offset;if(n.isInstancedInterleavedBuffer){for(let t=0;t<i.locationSize;t++)g(i.location+t,n.meshPerAttribute);!0!==r.isInstancedMesh&&void 0===o._maxInstanceCount&&(o._maxInstanceCount=n.meshPerAttribute*n.count)}else for(let t=0;t<i.locationSize;t++)m(i.location+t);t.bindBuffer(t.ARRAY_BUFFER,c);for(let t=0;t<i.locationSize;t++)_(i.location+t,a/i.locationSize,u,e,l*h,(d+a/i.locationSize*t)*h)}else{if(s.isInstancedBufferAttribute){for(let t=0;t<i.locationSize;t++)g(i.location+t,s.meshPerAttribute);!0!==r.isInstancedMesh&&void 0===o._maxInstanceCount&&(o._maxInstanceCount=s.meshPerAttribute*s.count)}else for(let t=0;t<i.locationSize;t++)m(i.location+t);t.bindBuffer(t.ARRAY_BUFFER,c);for(let t=0;t<i.locationSize;t++)_(i.location+t,a/i.locationSize,u,e,a*h,a/i.locationSize*t*h)}}else if(void 0!==u){const n=u[e];if(void 0!==n)switch(n.length){case 2:t.vertexAttrib2fv(i.location,n);break;case 3:t.vertexAttrib3fv(i.location,n);break;case 4:t.vertexAttrib4fv(i.location,n);break;default:t.vertexAttrib1fv(i.location,n)}}}}v()}(r,l,d,y),null!==x&&t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,n.get(x).buffer))},reset:y,resetDefaultState:x,dispose:function(){y();for(const t in o){const e=o[t];for(const t in e){const n=e[t];for(const t in n)d(n[t].object),delete n[t];delete e[t]}delete o[t]}},releaseStatesOfGeometry:function(t){if(void 0===o[t.id])return;const e=o[t.id];for(const t in e){const n=e[t];for(const t in n)d(n[t].object),delete n[t];delete e[t]}delete o[t.id]},releaseStatesOfProgram:function(t){for(const e in o){const n=o[e];if(void 0===n[t.id])continue;const i=n[t.id];for(const t in i)d(i[t].object),delete i[t];delete n[t.id]}},initAttributes:f,enableAttribute:m,disableUnusedAttributes:v}}function Si(t,e,n,i){const r=i.isWebGL2;let s;this.setMode=function(t){s=t},this.render=function(e,i){t.drawArrays(s,e,i),n.update(i,s,1)},this.renderInstances=function(i,a,o){if(0===o)return;let l,c;if(r)l=t,c="drawArraysInstanced";else if(l=e.get("ANGLE_instanced_arrays"),c="drawArraysInstancedANGLE",null===l)return void console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");l[c](s,i,a,o),n.update(a,s,o)}}function Ei(t,e,n){let i;function r(e){if("highp"===e){if(t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.HIGH_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.HIGH_FLOAT).precision>0)return"highp";e="mediump"}return"mediump"===e&&t.getShaderPrecisionFormat(t.VERTEX_SHADER,t.MEDIUM_FLOAT).precision>0&&t.getShaderPrecisionFormat(t.FRAGMENT_SHADER,t.MEDIUM_FLOAT).precision>0?"mediump":"lowp"}const s="undefined"!=typeof WebGL2RenderingContext&&t instanceof WebGL2RenderingContext||"undefined"!=typeof WebGL2ComputeRenderingContext&&t instanceof WebGL2ComputeRenderingContext;let a=void 0!==n.precision?n.precision:"highp";const o=r(a);o!==a&&(console.warn("THREE.WebGLRenderer:",a,"not supported, using",o,"instead."),a=o);const l=s||e.has("WEBGL_draw_buffers"),c=!0===n.logarithmicDepthBuffer,u=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS),h=t.getParameter(t.MAX_VERTEX_TEXTURE_IMAGE_UNITS),d=t.getParameter(t.MAX_TEXTURE_SIZE),p=t.getParameter(t.MAX_CUBE_MAP_TEXTURE_SIZE),f=t.getParameter(t.MAX_VERTEX_ATTRIBS),m=t.getParameter(t.MAX_VERTEX_UNIFORM_VECTORS),g=t.getParameter(t.MAX_VARYING_VECTORS),v=t.getParameter(t.MAX_FRAGMENT_UNIFORM_VECTORS),_=h>0,y=s||e.has("OES_texture_float");return{isWebGL2:s,drawBuffers:l,getMaxAnisotropy:function(){if(void 0!==i)return i;if(!0===e.has("EXT_texture_filter_anisotropic")){const n=e.get("EXT_texture_filter_anisotropic");i=t.getParameter(n.MAX_TEXTURE_MAX_ANISOTROPY_EXT)}else i=0;return i},getMaxPrecision:r,precision:a,logarithmicDepthBuffer:c,maxTextures:u,maxVertexTextures:h,maxTextureSize:d,maxCubemapSize:p,maxAttributes:f,maxVertexUniforms:m,maxVaryings:g,maxFragmentUniforms:v,vertexTextures:_,floatFragmentTextures:y,floatVertexTextures:_&&y,maxSamples:s?t.getParameter(t.MAX_SAMPLES):0}}function Ti(t){const e=this;let n=null,i=0,r=!1,s=!1;const a=new di,o=new Rt,l={value:null,needsUpdate:!1};function c(){l.value!==n&&(l.value=n,l.needsUpdate=i>0),e.numPlanes=i,e.numIntersection=0}function u(t,n,i,r){const s=null!==t?t.length:0;let c=null;if(0!==s){if(c=l.value,!0!==r||null===c){const e=i+4*s,r=n.matrixWorldInverse;o.getNormalMatrix(r),(null===c||c.length<e)&&(c=new Float32Array(e));for(let e=0,n=i;e!==s;++e,n+=4)a.copy(t[e]).applyMatrix4(r,o),a.normal.toArray(c,n),c[n+3]=a.constant}l.value=c,l.needsUpdate=!0}return e.numPlanes=s,e.numIntersection=0,c}this.uniform=l,this.numPlanes=0,this.numIntersection=0,this.init=function(t,e,s){const a=0!==t.length||e||0!==i||r;return r=e,n=u(t,s,0),i=t.length,a},this.beginShadows=function(){s=!0,u(null)},this.endShadows=function(){s=!1,c()},this.setState=function(e,a,o){const h=e.clippingPlanes,d=e.clipIntersection,p=e.clipShadows,f=t.get(e);if(!r||null===h||0===h.length||s&&!p)s?u(null):c();else{const t=s?0:i,e=4*t;let r=f.clippingState||null;l.value=r,r=u(h,a,e,o);for(let t=0;t!==e;++t)r[t]=n[t];f.clippingState=r,this.numIntersection=d?this.numPlanes:0,this.numPlanes+=t}}}function Ai(t){let e=new WeakMap;function n(t,e){return e===o?t.mapping=s:e===l&&(t.mapping=a),t}function i(t){const n=t.target;n.removeEventListener("dispose",i);const r=e.get(n);void 0!==r&&(e.delete(n),r.dispose())}return{get:function(r){if(r&&r.isTexture&&!1===r.isRenderTargetTexture){const s=r.mapping;if(s===o||s===l){if(e.has(r))return n(e.get(r).texture,r.mapping);{const s=r.image;if(s&&s.height>0){const a=new li(s.height/2);return a.fromEquirectangularTexture(t,r),e.set(r,a),r.addEventListener("dispose",i),n(a.texture,r.mapping)}return null}}}return r},dispose:function(){e=new WeakMap}}}bi.physical={uniforms:ti([bi.standard.uniforms,{clearcoat:{value:0},clearcoatMap:{value:null},clearcoatRoughness:{value:0},clearcoatRoughnessMap:{value:null},clearcoatNormalScale:{value:new At(1,1)},clearcoatNormalMap:{value:null},iridescence:{value:0},iridescenceMap:{value:null},iridescenceIOR:{value:1.3},iridescenceThicknessMinimum:{value:100},iridescenceThicknessMaximum:{value:400},iridescenceThicknessMap:{value:null},sheen:{value:0},sheenColor:{value:new Ht(0)},sheenColorMap:{value:null},sheenRoughness:{value:1},sheenRoughnessMap:{value:null},transmission:{value:0},transmissionMap:{value:null},transmissionSamplerSize:{value:new At},transmissionSamplerMap:{value:null},thickness:{value:0},thicknessMap:{value:null},attenuationDistance:{value:0},attenuationColor:{value:new Ht(0)},specularIntensity:{value:1},specularIntensityMap:{value:null},specularColor:{value:new Ht(1,1,1)},specularColorMap:{value:null}}]),vertexShader:yi.meshphysical_vert,fragmentShader:yi.meshphysical_frag};class Ri extends ii{constructor(t=-1,e=1,n=1,i=-1,r=.1,s=2e3){super(),this.isOrthographicCamera=!0,this.type="OrthographicCamera",this.zoom=1,this.view=null,this.left=t,this.right=e,this.top=n,this.bottom=i,this.near=r,this.far=s,this.updateProjectionMatrix()}copy(t,e){return super.copy(t,e),this.left=t.left,this.right=t.right,this.top=t.top,this.bottom=t.bottom,this.near=t.near,this.far=t.far,this.zoom=t.zoom,this.view=null===t.view?null:Object.assign({},t.view),this}setViewOffset(t,e,n,i,r,s){null===this.view&&(this.view={enabled:!0,fullWidth:1,fullHeight:1,offsetX:0,offsetY:0,width:1,height:1}),this.view.enabled=!0,this.view.fullWidth=t,this.view.fullHeight=e,this.view.offsetX=n,this.view.offsetY=i,this.view.width=r,this.view.height=s,this.updateProjectionMatrix()}clearViewOffset(){null!==this.view&&(this.view.enabled=!1),this.updateProjectionMatrix()}updateProjectionMatrix(){const t=(this.right-this.left)/(2*this.zoom),e=(this.top-this.bottom)/(2*this.zoom),n=(this.right+this.left)/2,i=(this.top+this.bottom)/2;let r=n-t,s=n+t,a=i+e,o=i-e;if(null!==this.view&&this.view.enabled){const t=(this.right-this.left)/this.view.fullWidth/this.zoom,e=(this.top-this.bottom)/this.view.fullHeight/this.zoom;r+=t*this.view.offsetX,s=r+t*this.view.width,a-=e*this.view.offsetY,o=a-e*this.view.height}this.projectionMatrix.makeOrthographic(r,s,a,o,this.near,this.far),this.projectionMatrixInverse.copy(this.projectionMatrix).invert()}toJSON(t){const e=super.toJSON(t);return e.object.zoom=this.zoom,e.object.left=this.left,e.object.right=this.right,e.object.top=this.top,e.object.bottom=this.bottom,e.object.near=this.near,e.object.far=this.far,null!==this.view&&(e.object.view=Object.assign({},this.view)),e}}const Ci=[.125,.215,.35,.446,.526,.582],Li=new Ri,Pi=new Ht;let Ii=null;const Di=(1+Math.sqrt(5))/2,Oi=1/Di,Ni=[new ee(1,1,1),new ee(-1,1,1),new ee(1,1,-1),new ee(-1,1,-1),new ee(0,Di,Oi),new ee(0,Di,-Oi),new ee(Oi,0,Di),new ee(-Oi,0,Di),new ee(Di,Oi,0),new ee(-Di,Oi,0)];class Ui{constructor(t){this._renderer=t,this._pingPongRenderTarget=null,this._lodMax=0,this._cubeSize=0,this._lodPlanes=[],this._sizeLods=[],this._sigmas=[],this._blurMaterial=null,this._cubemapMaterial=null,this._equirectMaterial=null,this._compileMaterial(this._blurMaterial)}fromScene(t,e=0,n=.1,i=100){Ii=this._renderer.getRenderTarget(),this._setSize(256);const r=this._allocateTargets();return r.depthBuffer=!0,this._sceneToCubeUV(t,n,i,r),e>0&&this._blur(r,0,0,e),this._applyPMREM(r),this._cleanup(r),r}fromEquirectangular(t,e=null){return this._fromTexture(t,e)}fromCubemap(t,e=null){return this._fromTexture(t,e)}compileCubemapShader(){null===this._cubemapMaterial&&(this._cubemapMaterial=ki(),this._compileMaterial(this._cubemapMaterial))}compileEquirectangularShader(){null===this._equirectMaterial&&(this._equirectMaterial=zi(),this._compileMaterial(this._equirectMaterial))}dispose(){this._dispose(),null!==this._cubemapMaterial&&this._cubemapMaterial.dispose(),null!==this._equirectMaterial&&this._equirectMaterial.dispose()}_setSize(t){this._lodMax=Math.floor(Math.log2(t)),this._cubeSize=Math.pow(2,this._lodMax)}_dispose(){null!==this._blurMaterial&&this._blurMaterial.dispose(),null!==this._pingPongRenderTarget&&this._pingPongRenderTarget.dispose();for(let t=0;t<this._lodPlanes.length;t++)this._lodPlanes[t].dispose()}_cleanup(t){this._renderer.setRenderTarget(Ii),t.scissorTest=!1,Bi(t,0,0,t.width,t.height)}_fromTexture(t,e){t.mapping===s||t.mapping===a?this._setSize(0===t.image.length?16:t.image[0].width||t.image[0].image.width):this._setSize(t.image.width/4),Ii=this._renderer.getRenderTarget();const n=e||this._allocateTargets();return this._textureToCubeUV(t,n),this._applyPMREM(n),this._cleanup(n),n}_allocateTargets(){const t=3*Math.max(this._cubeSize,112),e=4*this._cubeSize,n={magFilter:g,minFilter:g,generateMipmaps:!1,type:w,format:E,encoding:at,depthBuffer:!1},i=Fi(t,e,n);if(null===this._pingPongRenderTarget||this._pingPongRenderTarget.width!==t){null!==this._pingPongRenderTarget&&this._dispose(),this._pingPongRenderTarget=Fi(t,e,n);const{_lodMax:i}=this;({sizeLods:this._sizeLods,lodPlanes:this._lodPlanes,sigmas:this._sigmas}=function(t){const e=[],n=[],i=[];let r=t;const s=t-4+1+Ci.length;for(let a=0;a<s;a++){const s=Math.pow(2,r);n.push(s);let o=1/s;a>t-4?o=Ci[a-t+4-1]:0===a&&(o=0),i.push(o);const l=1/(s-2),c=-l,u=1+l,h=[c,c,u,c,u,u,c,c,u,u,c,u],d=6,p=6,f=3,m=2,g=1,v=new Float32Array(f*p*d),_=new Float32Array(m*p*d),y=new Float32Array(g*p*d);for(let t=0;t<d;t++){const e=t%3*2/3-1,n=t>2?0:-1,i=[e,n,0,e+2/3,n,0,e+2/3,n+1,0,e,n,0,e+2/3,n+1,0,e,n+1,0];v.set(i,f*p*t),_.set(h,m*p*t);const r=[t,t,t,t,t,t];y.set(r,g*p*t)}const x=new In;x.setAttribute("position",new bn(v,f)),x.setAttribute("uv",new bn(_,m)),x.setAttribute("faceIndex",new bn(y,g)),e.push(x),r>4&&r--}return{lodPlanes:e,sizeLods:n,sigmas:i}}(i)),this._blurMaterial=function(t,e,n){const i=new Float32Array(20),r=new ee(0,1,0);return new ni({name:"SphericalGaussianBlur",defines:{n:20,CUBEUV_TEXEL_WIDTH:1/e,CUBEUV_TEXEL_HEIGHT:1/n,CUBEUV_MAX_MIP:`${t}.0`},uniforms:{envMap:{value:null},samples:{value:1},weights:{value:i},latitudinal:{value:!1},dTheta:{value:0},mipInt:{value:0},poleAxis:{value:r}},vertexShader:"\n\n\t\tprecision mediump float;\n\t\tprecision mediump int;\n\n\t\tattribute float faceIndex;\n\n\t\tvarying vec3 vOutputDirection;\n\n\t\t// RH coordinate system; PMREM face-indexing convention\n\t\tvec3 getDirection( vec2 uv, float face ) {\n\n\t\t\tuv = 2.0 * uv - 1.0;\n\n\t\t\tvec3 direction = vec3( uv, 1.0 );\n\n\t\t\tif ( face == 0.0 ) {\n\n\t\t\t\tdirection = direction.zyx; // ( 1, v, u ) pos x\n\n\t\t\t} else if ( face == 1.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xz *= -1.0; // ( -u, 1, -v ) pos y\n\n\t\t\t} else if ( face == 2.0 ) {\n\n\t\t\t\tdirection.x *= -1.0; // ( -u, v, 1 ) pos z\n\n\t\t\t} else if ( face == 3.0 ) {\n\n\t\t\t\tdirection = direction.zyx;\n\t\t\t\tdirection.xz *= -1.0; // ( -1, v, -u ) neg x\n\n\t\t\t} else if ( face == 4.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xy *= -1.0; // ( -u, -1, v ) neg y\n\n\t\t\t} else if ( face == 5.0 ) {\n\n\t\t\t\tdirection.z *= -1.0; // ( u, v, -1 ) neg z\n\n\t\t\t}\n\n\t\t\treturn direction;\n\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\tvOutputDirection = getDirection( uv, faceIndex );\n\t\t\tgl_Position = vec4( position, 1.0 );\n\n\t\t}\n\t",fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\t\t\tuniform int samples;\n\t\t\tuniform float weights[ n ];\n\t\t\tuniform bool latitudinal;\n\t\t\tuniform float dTheta;\n\t\t\tuniform float mipInt;\n\t\t\tuniform vec3 poleAxis;\n\n\t\t\t#define ENVMAP_TYPE_CUBE_UV\n\t\t\t#include <cube_uv_reflection_fragment>\n\n\t\t\tvec3 getSample( float theta, vec3 axis ) {\n\n\t\t\t\tfloat cosTheta = cos( theta );\n\t\t\t\t// Rodrigues' axis-angle rotation\n\t\t\t\tvec3 sampleDirection = vOutputDirection * cosTheta\n\t\t\t\t\t+ cross( axis, vOutputDirection ) * sin( theta )\n\t\t\t\t\t+ axis * dot( axis, vOutputDirection ) * ( 1.0 - cosTheta );\n\n\t\t\t\treturn bilinearCubeUV( envMap, sampleDirection, mipInt );\n\n\t\t\t}\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 axis = latitudinal ? poleAxis : cross( poleAxis, vOutputDirection );\n\n\t\t\t\tif ( all( equal( axis, vec3( 0.0 ) ) ) ) {\n\n\t\t\t\t\taxis = vec3( vOutputDirection.z, 0.0, - vOutputDirection.x );\n\n\t\t\t\t}\n\n\t\t\t\taxis = normalize( axis );\n\n\t\t\t\tgl_FragColor = vec4( 0.0, 0.0, 0.0, 1.0 );\n\t\t\t\tgl_FragColor.rgb += weights[ 0 ] * getSample( 0.0, axis );\n\n\t\t\t\tfor ( int i = 1; i < n; i++ ) {\n\n\t\t\t\t\tif ( i >= samples ) {\n\n\t\t\t\t\t\tbreak;\n\n\t\t\t\t\t}\n\n\t\t\t\t\tfloat theta = dTheta * float( i );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( -1.0 * theta, axis );\n\t\t\t\t\tgl_FragColor.rgb += weights[ i ] * getSample( theta, axis );\n\n\t\t\t\t}\n\n\t\t\t}\n\t\t",blending:0,depthTest:!1,depthWrite:!1})}(i,t,e)}return i}_compileMaterial(t){const e=new Jn(this._lodPlanes[0],t);this._renderer.compile(e,Li)}_sceneToCubeUV(t,e,n,i){const r=new ri(90,1,e,n),s=[1,-1,1,1,1,1],a=[1,1,1,-1,-1,-1],o=this._renderer,l=o.autoClear,c=o.toneMapping;o.getClearColor(Pi),o.toneMapping=0,o.autoClear=!1;const u=new _n({name:"PMREM.Background",side:1,depthWrite:!1,depthTest:!1}),h=new Jn(new $n,u);let d=!1;const p=t.background;p?p.isColor&&(u.color.copy(p),t.background=null,d=!0):(u.color.copy(Pi),d=!0);for(let e=0;e<6;e++){const n=e%3;0===n?(r.up.set(0,s[e],0),r.lookAt(a[e],0,0)):1===n?(r.up.set(0,0,s[e]),r.lookAt(0,a[e],0)):(r.up.set(0,s[e],0),r.lookAt(0,0,a[e]));const l=this._cubeSize;Bi(i,n*l,e>2?l:0,l,l),o.setRenderTarget(i),d&&o.render(h,r),o.render(t,r)}h.geometry.dispose(),h.material.dispose(),o.toneMapping=c,o.autoClear=l,t.background=p}_textureToCubeUV(t,e){const n=this._renderer,i=t.mapping===s||t.mapping===a;i?(null===this._cubemapMaterial&&(this._cubemapMaterial=ki()),this._cubemapMaterial.uniforms.flipEnvMap.value=!1===t.isRenderTargetTexture?-1:1):null===this._equirectMaterial&&(this._equirectMaterial=zi());const r=i?this._cubemapMaterial:this._equirectMaterial,o=new Jn(this._lodPlanes[0],r);r.uniforms.envMap.value=t;const l=this._cubeSize;Bi(e,0,0,3*l,2*l),n.setRenderTarget(e),n.render(o,Li)}_applyPMREM(t){const e=this._renderer,n=e.autoClear;e.autoClear=!1;for(let e=1;e<this._lodPlanes.length;e++){const n=Math.sqrt(this._sigmas[e]*this._sigmas[e]-this._sigmas[e-1]*this._sigmas[e-1]),i=Ni[(e-1)%Ni.length];this._blur(t,e-1,e,n,i)}e.autoClear=n}_blur(t,e,n,i,r){const s=this._pingPongRenderTarget;this._halfBlur(t,s,e,n,i,"latitudinal",r),this._halfBlur(s,t,n,n,i,"longitudinal",r)}_halfBlur(t,e,n,i,r,s,a){const o=this._renderer,l=this._blurMaterial;"latitudinal"!==s&&"longitudinal"!==s&&console.error("blur direction must be either latitudinal or longitudinal!");const c=new Jn(this._lodPlanes[i],l),u=l.uniforms,h=this._sizeLods[n]-1,d=isFinite(r)?Math.PI/(2*h):2*Math.PI/39,p=r/d,f=isFinite(r)?1+Math.floor(3*p):20;f>20&&console.warn(`sigmaRadians, ${r}, is too large and will clip, as it requested ${f} samples when the maximum is set to 20`);const m=[];let g=0;for(let t=0;t<20;++t){const e=t/p,n=Math.exp(-e*e/2);m.push(n),0===t?g+=n:t<f&&(g+=2*n)}for(let t=0;t<m.length;t++)m[t]=m[t]/g;u.envMap.value=t.texture,u.samples.value=f,u.weights.value=m,u.latitudinal.value="latitudinal"===s,a&&(u.poleAxis.value=a);const{_lodMax:v}=this;u.dTheta.value=d,u.mipInt.value=v-n;const _=this._sizeLods[i];Bi(e,3*_*(i>v-4?i-v+4:0),4*(this._cubeSize-_),3*_,2*_),o.setRenderTarget(e),o.render(c,Li)}}function Fi(t,e,n){const i=new Kt(t,e,n);return i.texture.mapping=c,i.texture.name="PMREM.cubeUv",i.scissorTest=!0,i}function Bi(t,e,n,i,r){t.viewport.set(e,n,i,r),t.scissor.set(e,n,i,r)}function zi(){return new ni({name:"EquirectangularToCubeUV",uniforms:{envMap:{value:null}},vertexShader:"\n\n\t\tprecision mediump float;\n\t\tprecision mediump int;\n\n\t\tattribute float faceIndex;\n\n\t\tvarying vec3 vOutputDirection;\n\n\t\t// RH coordinate system; PMREM face-indexing convention\n\t\tvec3 getDirection( vec2 uv, float face ) {\n\n\t\t\tuv = 2.0 * uv - 1.0;\n\n\t\t\tvec3 direction = vec3( uv, 1.0 );\n\n\t\t\tif ( face == 0.0 ) {\n\n\t\t\t\tdirection = direction.zyx; // ( 1, v, u ) pos x\n\n\t\t\t} else if ( face == 1.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xz *= -1.0; // ( -u, 1, -v ) pos y\n\n\t\t\t} else if ( face == 2.0 ) {\n\n\t\t\t\tdirection.x *= -1.0; // ( -u, v, 1 ) pos z\n\n\t\t\t} else if ( face == 3.0 ) {\n\n\t\t\t\tdirection = direction.zyx;\n\t\t\t\tdirection.xz *= -1.0; // ( -1, v, -u ) neg x\n\n\t\t\t} else if ( face == 4.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xy *= -1.0; // ( -u, -1, v ) neg y\n\n\t\t\t} else if ( face == 5.0 ) {\n\n\t\t\t\tdirection.z *= -1.0; // ( u, v, -1 ) neg z\n\n\t\t\t}\n\n\t\t\treturn direction;\n\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\tvOutputDirection = getDirection( uv, faceIndex );\n\t\t\tgl_Position = vec4( position, 1.0 );\n\n\t\t}\n\t",fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform sampler2D envMap;\n\n\t\t\t#include <common>\n\n\t\t\tvoid main() {\n\n\t\t\t\tvec3 outputDirection = normalize( vOutputDirection );\n\t\t\t\tvec2 uv = equirectUv( outputDirection );\n\n\t\t\t\tgl_FragColor = vec4( texture2D ( envMap, uv ).rgb, 1.0 );\n\n\t\t\t}\n\t\t",blending:0,depthTest:!1,depthWrite:!1})}function ki(){return new ni({name:"CubemapToCubeUV",uniforms:{envMap:{value:null},flipEnvMap:{value:-1}},vertexShader:"\n\n\t\tprecision mediump float;\n\t\tprecision mediump int;\n\n\t\tattribute float faceIndex;\n\n\t\tvarying vec3 vOutputDirection;\n\n\t\t// RH coordinate system; PMREM face-indexing convention\n\t\tvec3 getDirection( vec2 uv, float face ) {\n\n\t\t\tuv = 2.0 * uv - 1.0;\n\n\t\t\tvec3 direction = vec3( uv, 1.0 );\n\n\t\t\tif ( face == 0.0 ) {\n\n\t\t\t\tdirection = direction.zyx; // ( 1, v, u ) pos x\n\n\t\t\t} else if ( face == 1.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xz *= -1.0; // ( -u, 1, -v ) pos y\n\n\t\t\t} else if ( face == 2.0 ) {\n\n\t\t\t\tdirection.x *= -1.0; // ( -u, v, 1 ) pos z\n\n\t\t\t} else if ( face == 3.0 ) {\n\n\t\t\t\tdirection = direction.zyx;\n\t\t\t\tdirection.xz *= -1.0; // ( -1, v, -u ) neg x\n\n\t\t\t} else if ( face == 4.0 ) {\n\n\t\t\t\tdirection = direction.xzy;\n\t\t\t\tdirection.xy *= -1.0; // ( -u, -1, v ) neg y\n\n\t\t\t} else if ( face == 5.0 ) {\n\n\t\t\t\tdirection.z *= -1.0; // ( u, v, -1 ) neg z\n\n\t\t\t}\n\n\t\t\treturn direction;\n\n\t\t}\n\n\t\tvoid main() {\n\n\t\t\tvOutputDirection = getDirection( uv, faceIndex );\n\t\t\tgl_Position = vec4( position, 1.0 );\n\n\t\t}\n\t",fragmentShader:"\n\n\t\t\tprecision mediump float;\n\t\t\tprecision mediump int;\n\n\t\t\tuniform float flipEnvMap;\n\n\t\t\tvarying vec3 vOutputDirection;\n\n\t\t\tuniform samplerCube envMap;\n\n\t\t\tvoid main() {\n\n\t\t\t\tgl_FragColor = textureCube( envMap, vec3( flipEnvMap * vOutputDirection.x, vOutputDirection.yz ) );\n\n\t\t\t}\n\t\t",blending:0,depthTest:!1,depthWrite:!1})}function Gi(t){let e=new WeakMap,n=null;function i(t){const n=t.target;n.removeEventListener("dispose",i);const r=e.get(n);void 0!==r&&(e.delete(n),r.dispose())}return{get:function(r){if(r&&r.isTexture){const c=r.mapping,u=c===o||c===l,h=c===s||c===a;if(u||h){if(r.isRenderTargetTexture&&!0===r.needsPMREMUpdate){r.needsPMREMUpdate=!1;let i=e.get(r);return null===n&&(n=new Ui(t)),i=u?n.fromEquirectangular(r,i):n.fromCubemap(r,i),e.set(r,i),i.texture}if(e.has(r))return e.get(r).texture;{const s=r.image;if(u&&s&&s.height>0||h&&s&&function(t){let e=0;for(let n=0;n<6;n++)void 0!==t[n]&&e++;return 6===e}(s)){null===n&&(n=new Ui(t));const s=u?n.fromEquirectangular(r):n.fromCubemap(r);return e.set(r,s),r.addEventListener("dispose",i),s.texture}return null}}}return r},dispose:function(){e=new WeakMap,null!==n&&(n.dispose(),n=null)}}}function Vi(t){const e={};function n(n){if(void 0!==e[n])return e[n];let i;switch(n){case"WEBGL_depth_texture":i=t.getExtension("WEBGL_depth_texture")||t.getExtension("MOZ_WEBGL_depth_texture")||t.getExtension("WEBKIT_WEBGL_depth_texture");break;case"EXT_texture_filter_anisotropic":i=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":i=t.getExtension("WEBGL_compressed_texture_s3tc")||t.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":i=t.getExtension("WEBGL_compressed_texture_pvrtc")||t.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;default:i=t.getExtension(n)}return e[n]=i,i}return{has:function(t){return null!==n(t)},init:function(t){t.isWebGL2?n("EXT_color_buffer_float"):(n("WEBGL_depth_texture"),n("OES_texture_float"),n("OES_texture_half_float"),n("OES_texture_half_float_linear"),n("OES_standard_derivatives"),n("OES_element_index_uint"),n("OES_vertex_array_object"),n("ANGLE_instanced_arrays")),n("OES_texture_float_linear"),n("EXT_color_buffer_half_float"),n("WEBGL_multisampled_render_to_texture")},get:function(t){const e=n(t);return null===e&&console.warn("THREE.WebGLRenderer: "+t+" extension not supported."),e}}}function Hi(t,e,n,i){const r={},s=new WeakMap;function a(t){const o=t.target;null!==o.index&&e.remove(o.index);for(const t in o.attributes)e.remove(o.attributes[t]);o.removeEventListener("dispose",a),delete r[o.id];const l=s.get(o);l&&(e.remove(l),s.delete(o)),i.releaseStatesOfGeometry(o),!0===o.isInstancedBufferGeometry&&delete o._maxInstanceCount,n.memory.geometries--}function o(t){const n=[],i=t.index,r=t.attributes.position;let a=0;if(null!==i){const t=i.array;a=i.version;for(let e=0,i=t.length;e<i;e+=3){const i=t[e+0],r=t[e+1],s=t[e+2];n.push(i,r,r,s,s,i)}}else{const t=r.array;a=r.version;for(let e=0,i=t.length/3-1;e<i;e+=3){const t=e+0,i=e+1,r=e+2;n.push(t,i,i,r,r,t)}}const o=new(Ct(n)?wn:Mn)(n,1);o.version=a;const l=s.get(t);l&&e.remove(l),s.set(t,o)}return{get:function(t,e){return!0===r[e.id]||(e.addEventListener("dispose",a),r[e.id]=!0,n.memory.geometries++),e},update:function(n){const i=n.attributes;for(const n in i)e.update(i[n],t.ARRAY_BUFFER);const r=n.morphAttributes;for(const n in r){const i=r[n];for(let n=0,r=i.length;n<r;n++)e.update(i[n],t.ARRAY_BUFFER)}},getWireframeAttribute:function(t){const e=s.get(t);if(e){const n=t.index;null!==n&&e.version<n.version&&o(t)}else o(t);return s.get(t)}}}function Wi(t,e,n,i){const r=i.isWebGL2;let s,a,o;this.setMode=function(t){s=t},this.setIndex=function(t){a=t.type,o=t.bytesPerElement},this.render=function(e,i){t.drawElements(s,i,a,e*o),n.update(i,s,1)},this.renderInstances=function(i,l,c){if(0===c)return;let u,h;if(r)u=t,h="drawElementsInstanced";else if(u=e.get("ANGLE_instanced_arrays"),h="drawElementsInstancedANGLE",null===u)return void console.error("THREE.WebGLIndexedBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");u[h](s,l,a,i*o,c),n.update(l,s,c)}}function ji(t){const e={frame:0,calls:0,triangles:0,points:0,lines:0};return{memory:{geometries:0,textures:0},render:e,programs:null,autoReset:!0,reset:function(){e.frame++,e.calls=0,e.triangles=0,e.points=0,e.lines=0},update:function(n,i,r){switch(e.calls++,i){case t.TRIANGLES:e.triangles+=r*(n/3);break;case t.LINES:e.lines+=r*(n/2);break;case t.LINE_STRIP:e.lines+=r*(n-1);break;case t.LINE_LOOP:e.lines+=r*n;break;case t.POINTS:e.points+=r*n;break;default:console.error("THREE.WebGLInfo: Unknown draw mode:",i)}}}}function Xi(t,e){return t[0]-e[0]}function Yi(t,e){return Math.abs(e[1])-Math.abs(t[1])}function qi(t,e){let n=1;const i=e.isInterleavedBufferAttribute?e.data.array:e.array;i instanceof Int8Array?n=127:i instanceof Uint8Array?n=255:i instanceof Uint16Array?n=65535:i instanceof Int16Array?n=32767:i instanceof Int32Array?n=2147483647:console.error("THREE.WebGLMorphtargets: Unsupported morph attribute data type: ",i),t.divideScalar(n)}function Zi(t,e,n){const i={},r=new Float32Array(8),s=new WeakMap,a=new Jt,o=[];for(let t=0;t<8;t++)o[t]=[t,0];return{update:function(l,c,u,h){const d=l.morphTargetInfluences;if(!0===e.isWebGL2){const p=c.morphAttributes.position||c.morphAttributes.normal||c.morphAttributes.color,f=void 0!==p?p.length:0;let m=s.get(c);if(void 0===m||m.count!==f){void 0!==m&&m.texture.dispose();const _=void 0!==c.morphAttributes.position,y=void 0!==c.morphAttributes.normal,x=void 0!==c.morphAttributes.color,b=c.morphAttributes.position||[],w=c.morphAttributes.normal||[],S=c.morphAttributes.color||[];let E=0;!0===_&&(E=1),!0===y&&(E=2),!0===x&&(E=3);let T=c.attributes.position.count*E,A=1;T>e.maxTextureSize&&(A=Math.ceil(T/e.maxTextureSize),T=e.maxTextureSize);const R=new Float32Array(T*A*4*f),C=new $t(R,T,A,f);C.type=M,C.needsUpdate=!0;const L=4*E;for(let I=0;I<f;I++){const D=b[I],O=w[I],N=S[I],U=T*A*4*I;for(let F=0;F<D.count;F++){const B=F*L;!0===_&&(a.fromBufferAttribute(D,F),!0===D.normalized&&qi(a,D),R[U+B+0]=a.x,R[U+B+1]=a.y,R[U+B+2]=a.z,R[U+B+3]=0),!0===y&&(a.fromBufferAttribute(O,F),!0===O.normalized&&qi(a,O),R[U+B+4]=a.x,R[U+B+5]=a.y,R[U+B+6]=a.z,R[U+B+7]=0),!0===x&&(a.fromBufferAttribute(N,F),!0===N.normalized&&qi(a,N),R[U+B+8]=a.x,R[U+B+9]=a.y,R[U+B+10]=a.z,R[U+B+11]=4===N.itemSize?a.w:1)}}function P(){C.dispose(),s.delete(c),c.removeEventListener("dispose",P)}m={count:f,texture:C,size:new At(T,A)},s.set(c,m),c.addEventListener("dispose",P)}let g=0;for(let z=0;z<d.length;z++)g+=d[z];const v=c.morphTargetsRelative?1:1-g;h.getUniforms().setValue(t,"morphTargetBaseInfluence",v),h.getUniforms().setValue(t,"morphTargetInfluences",d),h.getUniforms().setValue(t,"morphTargetsTexture",m.texture,n),h.getUniforms().setValue(t,"morphTargetsTextureSize",m.size)}else{const k=void 0===d?0:d.length;let G=i[c.id];if(void 0===G||G.length!==k){G=[];for(let X=0;X<k;X++)G[X]=[X,0];i[c.id]=G}for(let Y=0;Y<k;Y++){const q=G[Y];q[0]=Y,q[1]=d[Y]}G.sort(Yi);for(let Z=0;Z<8;Z++)Z<k&&G[Z][1]?(o[Z][0]=G[Z][0],o[Z][1]=G[Z][1]):(o[Z][0]=Number.MAX_SAFE_INTEGER,o[Z][1]=0);o.sort(Xi);const V=c.morphAttributes.position,H=c.morphAttributes.normal;let W=0;for(let J=0;J<8;J++){const K=o[J],$=K[0],Q=K[1];$!==Number.MAX_SAFE_INTEGER&&Q?(V&&c.getAttribute("morphTarget"+J)!==V[$]&&c.setAttribute("morphTarget"+J,V[$]),H&&c.getAttribute("morphNormal"+J)!==H[$]&&c.setAttribute("morphNormal"+J,H[$]),r[J]=Q,W+=Q):(V&&!0===c.hasAttribute("morphTarget"+J)&&c.deleteAttribute("morphTarget"+J),H&&!0===c.hasAttribute("morphNormal"+J)&&c.deleteAttribute("morphNormal"+J),r[J]=0)}const j=c.morphTargetsRelative?1:1-W;h.getUniforms().setValue(t,"morphTargetBaseInfluence",j),h.getUniforms().setValue(t,"morphTargetInfluences",r)}}}}function Ji(t,e,n,i){let r=new WeakMap;function s(t){const e=t.target;e.removeEventListener("dispose",s),n.remove(e.instanceMatrix),null!==e.instanceColor&&n.remove(e.instanceColor)}return{update:function(a){const o=i.render.frame,l=a.geometry,c=e.get(a,l);return r.get(c)!==o&&(e.update(c),r.set(c,o)),a.isInstancedMesh&&(!1===a.hasEventListener("dispose",s)&&a.addEventListener("dispose",s),n.update(a.instanceMatrix,t.ARRAY_BUFFER),null!==a.instanceColor&&n.update(a.instanceColor,t.ARRAY_BUFFER)),c},dispose:function(){r=new WeakMap}}}const Ki=new Zt,$i=new $t,Qi=new Qt,tr=new oi,er=[],nr=[],ir=new Float32Array(16),rr=new Float32Array(9),sr=new Float32Array(4);function ar(t,e,n){const i=t[0];if(i<=0||i>0)return t;const r=e*n;let s=er[r];if(void 0===s&&(s=new Float32Array(r),er[r]=s),0!==e){i.toArray(s,0);for(let i=1,r=0;i!==e;++i)r+=n,t[i].toArray(s,r)}return s}function or(t,e){if(t.length!==e.length)return!1;for(let n=0,i=t.length;n<i;n++)if(t[n]!==e[n])return!1;return!0}function lr(t,e){for(let n=0,i=e.length;n<i;n++)t[n]=e[n]}function cr(t,e){let n=nr[e];void 0===n&&(n=new Int32Array(e),nr[e]=n);for(let i=0;i!==e;++i)n[i]=t.allocateTextureUnit();return n}function ur(t,e){const n=this.cache;n[0]!==e&&(t.uniform1f(this.addr,e),n[0]=e)}function hr(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y||(t.uniform2f(this.addr,e.x,e.y),n[0]=e.x,n[1]=e.y);else{if(or(n,e))return;t.uniform2fv(this.addr,e),lr(n,e)}}function dr(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y&&n[2]===e.z||(t.uniform3f(this.addr,e.x,e.y,e.z),n[0]=e.x,n[1]=e.y,n[2]=e.z);else if(void 0!==e.r)n[0]===e.r&&n[1]===e.g&&n[2]===e.b||(t.uniform3f(this.addr,e.r,e.g,e.b),n[0]=e.r,n[1]=e.g,n[2]=e.b);else{if(or(n,e))return;t.uniform3fv(this.addr,e),lr(n,e)}}function pr(t,e){const n=this.cache;if(void 0!==e.x)n[0]===e.x&&n[1]===e.y&&n[2]===e.z&&n[3]===e.w||(t.uniform4f(this.addr,e.x,e.y,e.z,e.w),n[0]=e.x,n[1]=e.y,n[2]=e.z,n[3]=e.w);else{if(or(n,e))return;t.uniform4fv(this.addr,e),lr(n,e)}}function fr(t,e){const n=this.cache,i=e.elements;if(void 0===i){if(or(n,e))return;t.uniformMatrix2fv(this.addr,!1,e),lr(n,e)}else{if(or(n,i))return;sr.set(i),t.uniformMatrix2fv(this.addr,!1,sr),lr(n,i)}}function mr(t,e){const n=this.cache,i=e.elements;if(void 0===i){if(or(n,e))return;t.uniformMatrix3fv(this.addr,!1,e),lr(n,e)}else{if(or(n,i))return;rr.set(i),t.uniformMatrix3fv(this.addr,!1,rr),lr(n,i)}}function gr(t,e){const n=this.cache,i=e.elements;if(void 0===i){if(or(n,e))return;t.uniformMatrix4fv(this.addr,!1,e),lr(n,e)}else{if(or(n,i))return;ir.set(i),t.uniformMatrix4fv(this.addr,!1,ir),lr(n,i)}}function vr(t,e){const n=this.cache;n[0]!==e&&(t.uniform1i(this.addr,e),n[0]=e)}function _r(t,e){const n=this.cache;or(n,e)||(t.uniform2iv(this.addr,e),lr(n,e))}function yr(t,e){const n=this.cache;or(n,e)||(t.uniform3iv(this.addr,e),lr(n,e))}function xr(t,e){const n=this.cache;or(n,e)||(t.uniform4iv(this.addr,e),lr(n,e))}function br(t,e){const n=this.cache;n[0]!==e&&(t.uniform1ui(this.addr,e),n[0]=e)}function Mr(t,e){const n=this.cache;or(n,e)||(t.uniform2uiv(this.addr,e),lr(n,e))}function wr(t,e){const n=this.cache;or(n,e)||(t.uniform3uiv(this.addr,e),lr(n,e))}function Sr(t,e){const n=this.cache;or(n,e)||(t.uniform4uiv(this.addr,e),lr(n,e))}function Er(t,e,n){const i=this.cache,r=n.allocateTextureUnit();i[0]!==r&&(t.uniform1i(this.addr,r),i[0]=r),n.setTexture2D(e||Ki,r)}function Tr(t,e,n){const i=this.cache,r=n.allocateTextureUnit();i[0]!==r&&(t.uniform1i(this.addr,r),i[0]=r),n.setTexture3D(e||Qi,r)}function Ar(t,e,n){const i=this.cache,r=n.allocateTextureUnit();i[0]!==r&&(t.uniform1i(this.addr,r),i[0]=r),n.setTextureCube(e||tr,r)}function Rr(t,e,n){const i=this.cache,r=n.allocateTextureUnit();i[0]!==r&&(t.uniform1i(this.addr,r),i[0]=r),n.setTexture2DArray(e||$i,r)}function Cr(t,e){t.uniform1fv(this.addr,e)}function Lr(t,e){const n=ar(e,this.size,2);t.uniform2fv(this.addr,n)}function Pr(t,e){const n=ar(e,this.size,3);t.uniform3fv(this.addr,n)}function Ir(t,e){const n=ar(e,this.size,4);t.uniform4fv(this.addr,n)}function Dr(t,e){const n=ar(e,this.size,4);t.uniformMatrix2fv(this.addr,!1,n)}function Or(t,e){const n=ar(e,this.size,9);t.uniformMatrix3fv(this.addr,!1,n)}function Nr(t,e){const n=ar(e,this.size,16);t.uniformMatrix4fv(this.addr,!1,n)}function Ur(t,e){t.uniform1iv(this.addr,e)}function Fr(t,e){t.uniform2iv(this.addr,e)}function Br(t,e){t.uniform3iv(this.addr,e)}function zr(t,e){t.uniform4iv(this.addr,e)}function kr(t,e){t.uniform1uiv(this.addr,e)}function Gr(t,e){t.uniform2uiv(this.addr,e)}function Vr(t,e){t.uniform3uiv(this.addr,e)}function Hr(t,e){t.uniform4uiv(this.addr,e)}function Wr(t,e,n){const i=e.length,r=cr(n,i);t.uniform1iv(this.addr,r);for(let t=0;t!==i;++t)n.setTexture2D(e[t]||Ki,r[t])}function jr(t,e,n){const i=e.length,r=cr(n,i);t.uniform1iv(this.addr,r);for(let t=0;t!==i;++t)n.setTexture3D(e[t]||Qi,r[t])}function Xr(t,e,n){const i=e.length,r=cr(n,i);t.uniform1iv(this.addr,r);for(let t=0;t!==i;++t)n.setTextureCube(e[t]||tr,r[t])}function Yr(t,e,n){const i=e.length,r=cr(n,i);t.uniform1iv(this.addr,r);for(let t=0;t!==i;++t)n.setTexture2DArray(e[t]||$i,r[t])}class qr{constructor(t,e,n){this.id=t,this.addr=n,this.cache=[],this.setValue=function(t){switch(t){case 5126:return ur;case 35664:return hr;case 35665:return dr;case 35666:return pr;case 35674:return fr;case 35675:return mr;case 35676:return gr;case 5124:case 35670:return vr;case 35667:case 35671:return _r;case 35668:case 35672:return yr;case 35669:case 35673:return xr;case 5125:return br;case 36294:return Mr;case 36295:return wr;case 36296:return Sr;case 35678:case 36198:case 36298:case 36306:case 35682:return Er;case 35679:case 36299:case 36307:return Tr;case 35680:case 36300:case 36308:case 36293:return Ar;case 36289:case 36303:case 36311:case 36292:return Rr}}(e.type)}}class Zr{constructor(t,e,n){this.id=t,this.addr=n,this.cache=[],this.size=e.size,this.setValue=function(t){switch(t){case 5126:return Cr;case 35664:return Lr;case 35665:return Pr;case 35666:return Ir;case 35674:return Dr;case 35675:return Or;case 35676:return Nr;case 5124:case 35670:return Ur;case 35667:case 35671:return Fr;case 35668:case 35672:return Br;case 35669:case 35673:return zr;case 5125:return kr;case 36294:return Gr;case 36295:return Vr;case 36296:return Hr;case 35678:case 36198:case 36298:case 36306:case 35682:return Wr;case 35679:case 36299:case 36307:return jr;case 35680:case 36300:case 36308:case 36293:return Xr;case 36289:case 36303:case 36311:case 36292:return Yr}}(e.type)}}class Jr{constructor(t){this.id=t,this.seq=[],this.map={}}setValue(t,e,n){const i=this.seq;for(let r=0,s=i.length;r!==s;++r){const s=i[r];s.setValue(t,e[s.id],n)}}}const Kr=/(\w+)(\])?(\[|\.)?/g;function $r(t,e){t.seq.push(e),t.map[e.id]=e}function Qr(t,e,n){const i=t.name,r=i.length;for(Kr.lastIndex=0;;){const s=Kr.exec(i),a=Kr.lastIndex;let o=s[1];const l="]"===s[2],c=s[3];if(l&&(o|=0),void 0===c||"["===c&&a+2===r){$r(n,void 0===c?new qr(o,t,e):new Zr(o,t,e));break}{let t=n.map[o];void 0===t&&(t=new Jr(o),$r(n,t)),n=t}}}class ts{constructor(t,e){this.seq=[],this.map={};const n=t.getProgramParameter(e,t.ACTIVE_UNIFORMS);for(let i=0;i<n;++i){const n=t.getActiveUniform(e,i);Qr(n,t.getUniformLocation(e,n.name),this)}}setValue(t,e,n,i){const r=this.map[e];void 0!==r&&r.setValue(t,n,i)}setOptional(t,e,n){const i=e[n];void 0!==i&&this.setValue(t,n,i)}static upload(t,e,n,i){for(let r=0,s=e.length;r!==s;++r){const s=e[r],a=n[s.id];!1!==a.needsUpdate&&s.setValue(t,a.value,i)}}static seqWithValue(t,e){const n=[];for(let i=0,r=t.length;i!==r;++i){const r=t[i];r.id in e&&n.push(r)}return n}}function es(t,e,n){const i=t.createShader(e);return t.shaderSource(i,n),t.compileShader(i),i}let ns=0;function is(t,e,n){const i=t.getShaderParameter(e,t.COMPILE_STATUS),r=t.getShaderInfoLog(e).trim();if(i&&""===r)return"";const s=/ERROR: 0:(\d+)/.exec(r);if(s){const i=parseInt(s[1]);return n.toUpperCase()+"\n\n"+r+"\n\n"+function(t,e){const n=t.split("\n"),i=[],r=Math.max(e-6,0),s=Math.min(e+6,n.length);for(let t=r;t<s;t++){const r=t+1;i.push(`${r===e?">":" "} ${r}: ${n[t]}`)}return i.join("\n")}(t.getShaderSource(e),i)}return r}function rs(t,e){const n=function(t){switch(t){case at:return["Linear","( value )"];case ot:return["sRGB","( value )"];default:return console.warn("THREE.WebGLProgram: Unsupported encoding:",t),["Linear","( value )"]}}(e);return"vec4 "+t+"( vec4 value ) { return LinearTo"+n[0]+n[1]+"; }"}function ss(t,e){let n;switch(e){case 1:n="Linear";break;case 2:n="Reinhard";break;case 3:n="OptimizedCineon";break;case 4:n="ACESFilmic";break;case 5:n="Custom";break;default:console.warn("THREE.WebGLProgram: Unsupported toneMapping:",e),n="Linear"}return"vec3 "+t+"( vec3 color ) { return "+n+"ToneMapping( color ); }"}function as(t){return""!==t}function os(t,e){return t.replace(/NUM_DIR_LIGHTS/g,e.numDirLights).replace(/NUM_SPOT_LIGHTS/g,e.numSpotLights).replace(/NUM_RECT_AREA_LIGHTS/g,e.numRectAreaLights).replace(/NUM_POINT_LIGHTS/g,e.numPointLights).replace(/NUM_HEMI_LIGHTS/g,e.numHemiLights).replace(/NUM_DIR_LIGHT_SHADOWS/g,e.numDirLightShadows).replace(/NUM_SPOT_LIGHT_SHADOWS/g,e.numSpotLightShadows).replace(/NUM_POINT_LIGHT_SHADOWS/g,e.numPointLightShadows)}function ls(t,e){return t.replace(/NUM_CLIPPING_PLANES/g,e.numClippingPlanes).replace(/UNION_CLIPPING_PLANES/g,e.numClippingPlanes-e.numClipIntersection)}const cs=/^[ \t]*#include +<([\w\d./]+)>/gm;function us(t){return t.replace(cs,hs)}function hs(t,e){const n=yi[e];if(void 0===n)throw new Error("Can not resolve #include <"+e+">");return us(n)}const ds=/#pragma unroll_loop[\s]+?for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g,ps=/#pragma unroll_loop_start\s+for\s*\(\s*int\s+i\s*=\s*(\d+)\s*;\s*i\s*<\s*(\d+)\s*;\s*i\s*\+\+\s*\)\s*{([\s\S]+?)}\s+#pragma unroll_loop_end/g;function fs(t){return t.replace(ps,gs).replace(ds,ms)}function ms(t,e,n,i){return console.warn("WebGLProgram: #pragma unroll_loop shader syntax is deprecated. Please use #pragma unroll_loop_start syntax instead."),gs(0,e,n,i)}function gs(t,e,n,i){let r="";for(let t=parseInt(e);t<parseInt(n);t++)r+=i.replace(/\[\s*i\s*\]/g,"[ "+t+" ]").replace(/UNROLLED_LOOP_INDEX/g,t);return r}function vs(t){let e="precision "+t.precision+" float;\nprecision "+t.precision+" int;";return"highp"===t.precision?e+="\n#define HIGH_PRECISION":"mediump"===t.precision?e+="\n#define MEDIUM_PRECISION":"lowp"===t.precision&&(e+="\n#define LOW_PRECISION"),e}function _s(t,e,n,i){const r=t.getContext(),o=n.defines;let l=n.vertexShader,u=n.fragmentShader;const h=function(t){let e="SHADOWMAP_TYPE_BASIC";return 1===t.shadowMapType?e="SHADOWMAP_TYPE_PCF":2===t.shadowMapType?e="SHADOWMAP_TYPE_PCF_SOFT":3===t.shadowMapType&&(e="SHADOWMAP_TYPE_VSM"),e}(n),d=function(t){let e="ENVMAP_TYPE_CUBE";if(t.envMap)switch(t.envMapMode){case s:case a:e="ENVMAP_TYPE_CUBE";break;case c:e="ENVMAP_TYPE_CUBE_UV"}return e}(n),p=function(t){let e="ENVMAP_MODE_REFLECTION";return t.envMap&&t.envMapMode===a&&(e="ENVMAP_MODE_REFRACTION"),e}(n),f=function(t){let e="ENVMAP_BLENDING_NONE";if(t.envMap)switch(t.combine){case 0:e="ENVMAP_BLENDING_MULTIPLY";break;case 1:e="ENVMAP_BLENDING_MIX";break;case 2:e="ENVMAP_BLENDING_ADD"}return e}(n),m=function(t){const e=t.envMapCubeUVHeight;if(null===e)return null;const n=Math.log2(e)-2,i=1/e;return{texelWidth:1/(3*Math.max(Math.pow(2,n),112)),texelHeight:i,maxMip:n}}(n),g=n.isWebGL2?"":function(t){return[t.extensionDerivatives||t.envMapCubeUVHeight||t.bumpMap||t.tangentSpaceNormalMap||t.clearcoatNormalMap||t.flatShading||"physical"===t.shaderID?"#extension GL_OES_standard_derivatives : enable":"",(t.extensionFragDepth||t.logarithmicDepthBuffer)&&t.rendererExtensionFragDepth?"#extension GL_EXT_frag_depth : enable":"",t.extensionDrawBuffers&&t.rendererExtensionDrawBuffers?"#extension GL_EXT_draw_buffers : require":"",(t.extensionShaderTextureLOD||t.envMap||t.transmission)&&t.rendererExtensionShaderTextureLod?"#extension GL_EXT_shader_texture_lod : enable":""].filter(as).join("\n")}(n),v=function(t){const e=[];for(const n in t){const i=t[n];!1!==i&&e.push("#define "+n+" "+i)}return e.join("\n")}(o),_=r.createProgram();let y,x,b=n.glslVersion?"#version "+n.glslVersion+"\n":"";n.isRawShaderMaterial?(y=[v].filter(as).join("\n"),y.length>0&&(y+="\n"),x=[g,v].filter(as).join("\n"),x.length>0&&(x+="\n")):(y=[vs(n),"#define SHADER_NAME "+n.shaderName,v,n.instancing?"#define USE_INSTANCING":"",n.instancingColor?"#define USE_INSTANCING_COLOR":"",n.supportsVertexTextures?"#define VERTEX_TEXTURES":"",n.useFog&&n.fog?"#define USE_FOG":"",n.useFog&&n.fogExp2?"#define FOG_EXP2":"",n.map?"#define USE_MAP":"",n.envMap?"#define USE_ENVMAP":"",n.envMap?"#define "+p:"",n.lightMap?"#define USE_LIGHTMAP":"",n.aoMap?"#define USE_AOMAP":"",n.emissiveMap?"#define USE_EMISSIVEMAP":"",n.bumpMap?"#define USE_BUMPMAP":"",n.normalMap?"#define USE_NORMALMAP":"",n.normalMap&&n.objectSpaceNormalMap?"#define OBJECTSPACE_NORMALMAP":"",n.normalMap&&n.tangentSpaceNormalMap?"#define TANGENTSPACE_NORMALMAP":"",n.clearcoatMap?"#define USE_CLEARCOATMAP":"",n.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",n.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",n.iridescenceMap?"#define USE_IRIDESCENCEMAP":"",n.iridescenceThicknessMap?"#define USE_IRIDESCENCE_THICKNESSMAP":"",n.displacementMap&&n.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",n.specularMap?"#define USE_SPECULARMAP":"",n.specularIntensityMap?"#define USE_SPECULARINTENSITYMAP":"",n.specularColorMap?"#define USE_SPECULARCOLORMAP":"",n.roughnessMap?"#define USE_ROUGHNESSMAP":"",n.metalnessMap?"#define USE_METALNESSMAP":"",n.alphaMap?"#define USE_ALPHAMAP":"",n.transmission?"#define USE_TRANSMISSION":"",n.transmissionMap?"#define USE_TRANSMISSIONMAP":"",n.thicknessMap?"#define USE_THICKNESSMAP":"",n.sheenColorMap?"#define USE_SHEENCOLORMAP":"",n.sheenRoughnessMap?"#define USE_SHEENROUGHNESSMAP":"",n.vertexTangents?"#define USE_TANGENT":"",n.vertexColors?"#define USE_COLOR":"",n.vertexAlphas?"#define USE_COLOR_ALPHA":"",n.vertexUvs?"#define USE_UV":"",n.uvsVertexOnly?"#define UVS_VERTEX_ONLY":"",n.flatShading?"#define FLAT_SHADED":"",n.skinning?"#define USE_SKINNING":"",n.morphTargets?"#define USE_MORPHTARGETS":"",n.morphNormals&&!1===n.flatShading?"#define USE_MORPHNORMALS":"",n.morphColors&&n.isWebGL2?"#define USE_MORPHCOLORS":"",n.morphTargetsCount>0&&n.isWebGL2?"#define MORPHTARGETS_TEXTURE":"",n.morphTargetsCount>0&&n.isWebGL2?"#define MORPHTARGETS_TEXTURE_STRIDE "+n.morphTextureStride:"",n.morphTargetsCount>0&&n.isWebGL2?"#define MORPHTARGETS_COUNT "+n.morphTargetsCount:"",n.doubleSided?"#define DOUBLE_SIDED":"",n.flipSided?"#define FLIP_SIDED":"",n.shadowMapEnabled?"#define USE_SHADOWMAP":"",n.shadowMapEnabled?"#define "+h:"",n.sizeAttenuation?"#define USE_SIZEATTENUATION":"",n.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",n.logarithmicDepthBuffer&&n.rendererExtensionFragDepth?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;","#ifdef USE_INSTANCING","\tattribute mat4 instanceMatrix;","#endif","#ifdef USE_INSTANCING_COLOR","\tattribute vec3 instanceColor;","#endif","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_TANGENT","\tattribute vec4 tangent;","#endif","#if defined( USE_COLOR_ALPHA )","\tattribute vec4 color;","#elif defined( USE_COLOR )","\tattribute vec3 color;","#endif","#if ( defined( USE_MORPHTARGETS ) && ! defined( MORPHTARGETS_TEXTURE ) )","\tattribute vec3 morphTarget0;","\tattribute vec3 morphTarget1;","\tattribute vec3 morphTarget2;","\tattribute vec3 morphTarget3;","\t#ifdef USE_MORPHNORMALS","\t\tattribute vec3 morphNormal0;","\t\tattribute vec3 morphNormal1;","\t\tattribute vec3 morphNormal2;","\t\tattribute vec3 morphNormal3;","\t#else","\t\tattribute vec3 morphTarget4;","\t\tattribute vec3 morphTarget5;","\t\tattribute vec3 morphTarget6;","\t\tattribute vec3 morphTarget7;","\t#endif","#endif","#ifdef USE_SKINNING","\tattribute vec4 skinIndex;","\tattribute vec4 skinWeight;","#endif","\n"].filter(as).join("\n"),x=[g,vs(n),"#define SHADER_NAME "+n.shaderName,v,n.useFog&&n.fog?"#define USE_FOG":"",n.useFog&&n.fogExp2?"#define FOG_EXP2":"",n.map?"#define USE_MAP":"",n.matcap?"#define USE_MATCAP":"",n.envMap?"#define USE_ENVMAP":"",n.envMap?"#define "+d:"",n.envMap?"#define "+p:"",n.envMap?"#define "+f:"",m?"#define CUBEUV_TEXEL_WIDTH "+m.texelWidth:"",m?"#define CUBEUV_TEXEL_HEIGHT "+m.texelHeight:"",m?"#define CUBEUV_MAX_MIP "+m.maxMip+".0":"",n.lightMap?"#define USE_LIGHTMAP":"",n.aoMap?"#define USE_AOMAP":"",n.emissiveMap?"#define USE_EMISSIVEMAP":"",n.bumpMap?"#define USE_BUMPMAP":"",n.normalMap?"#define USE_NORMALMAP":"",n.normalMap&&n.objectSpaceNormalMap?"#define OBJECTSPACE_NORMALMAP":"",n.normalMap&&n.tangentSpaceNormalMap?"#define TANGENTSPACE_NORMALMAP":"",n.clearcoat?"#define USE_CLEARCOAT":"",n.clearcoatMap?"#define USE_CLEARCOATMAP":"",n.clearcoatRoughnessMap?"#define USE_CLEARCOAT_ROUGHNESSMAP":"",n.clearcoatNormalMap?"#define USE_CLEARCOAT_NORMALMAP":"",n.iridescence?"#define USE_IRIDESCENCE":"",n.iridescenceMap?"#define USE_IRIDESCENCEMAP":"",n.iridescenceThicknessMap?"#define USE_IRIDESCENCE_THICKNESSMAP":"",n.specularMap?"#define USE_SPECULARMAP":"",n.specularIntensityMap?"#define USE_SPECULARINTENSITYMAP":"",n.specularColorMap?"#define USE_SPECULARCOLORMAP":"",n.roughnessMap?"#define USE_ROUGHNESSMAP":"",n.metalnessMap?"#define USE_METALNESSMAP":"",n.alphaMap?"#define USE_ALPHAMAP":"",n.alphaTest?"#define USE_ALPHATEST":"",n.sheen?"#define USE_SHEEN":"",n.sheenColorMap?"#define USE_SHEENCOLORMAP":"",n.sheenRoughnessMap?"#define USE_SHEENROUGHNESSMAP":"",n.transmission?"#define USE_TRANSMISSION":"",n.transmissionMap?"#define USE_TRANSMISSIONMAP":"",n.thicknessMap?"#define USE_THICKNESSMAP":"",n.decodeVideoTexture?"#define DECODE_VIDEO_TEXTURE":"",n.vertexTangents?"#define USE_TANGENT":"",n.vertexColors||n.instancingColor?"#define USE_COLOR":"",n.vertexAlphas?"#define USE_COLOR_ALPHA":"",n.vertexUvs?"#define USE_UV":"",n.uvsVertexOnly?"#define UVS_VERTEX_ONLY":"",n.gradientMap?"#define USE_GRADIENTMAP":"",n.flatShading?"#define FLAT_SHADED":"",n.doubleSided?"#define DOUBLE_SIDED":"",n.flipSided?"#define FLIP_SIDED":"",n.shadowMapEnabled?"#define USE_SHADOWMAP":"",n.shadowMapEnabled?"#define "+h:"",n.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",n.physicallyCorrectLights?"#define PHYSICALLY_CORRECT_LIGHTS":"",n.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",n.logarithmicDepthBuffer&&n.rendererExtensionFragDepth?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;","uniform bool isOrthographic;",0!==n.toneMapping?"#define TONE_MAPPING":"",0!==n.toneMapping?yi.tonemapping_pars_fragment:"",0!==n.toneMapping?ss("toneMapping",n.toneMapping):"",n.dithering?"#define DITHERING":"",n.opaque?"#define OPAQUE":"",yi.encodings_pars_fragment,rs("linearToOutputTexel",n.outputEncoding),n.useDepthPacking?"#define DEPTH_PACKING "+n.depthPacking:"","\n"].filter(as).join("\n")),l=us(l),l=os(l,n),l=ls(l,n),u=us(u),u=os(u,n),u=ls(u,n),l=fs(l),u=fs(u),n.isWebGL2&&!0!==n.isRawShaderMaterial&&(b="#version 300 es\n",y=["precision mediump sampler2DArray;","#define attribute in","#define varying out","#define texture2D texture"].join("\n")+"\n"+y,x=["#define varying in",n.glslVersion===dt?"":"layout(location = 0) out highp vec4 pc_fragColor;",n.glslVersion===dt?"":"#define gl_FragColor pc_fragColor","#define gl_FragDepthEXT gl_FragDepth","#define texture2D texture","#define textureCube texture","#define texture2DProj textureProj","#define texture2DLodEXT textureLod","#define texture2DProjLodEXT textureProjLod","#define textureCubeLodEXT textureLod","#define texture2DGradEXT textureGrad","#define texture2DProjGradEXT textureProjGrad","#define textureCubeGradEXT textureGrad"].join("\n")+"\n"+x);const M=b+y+l,w=b+x+u,S=es(r,r.VERTEX_SHADER,M),E=es(r,r.FRAGMENT_SHADER,w);if(r.attachShader(_,S),r.attachShader(_,E),void 0!==n.index0AttributeName?r.bindAttribLocation(_,0,n.index0AttributeName):!0===n.morphTargets&&r.bindAttribLocation(_,0,"position"),r.linkProgram(_),t.debug.checkShaderErrors){const t=r.getProgramInfoLog(_).trim(),e=r.getShaderInfoLog(S).trim(),n=r.getShaderInfoLog(E).trim();let i=!0,s=!0;if(!1===r.getProgramParameter(_,r.LINK_STATUS)){i=!1;const e=is(r,S,"vertex"),n=is(r,E,"fragment");console.error("THREE.WebGLProgram: Shader Error "+r.getError()+" - VALIDATE_STATUS "+r.getProgramParameter(_,r.VALIDATE_STATUS)+"\n\nProgram Info Log: "+t+"\n"+e+"\n"+n)}else""!==t?console.warn("THREE.WebGLProgram: Program Info Log:",t):""!==e&&""!==n||(s=!1);s&&(this.diagnostics={runnable:i,programLog:t,vertexShader:{log:e,prefix:y},fragmentShader:{log:n,prefix:x}})}let T,A;return r.deleteShader(S),r.deleteShader(E),this.getUniforms=function(){return void 0===T&&(T=new ts(r,_)),T},this.getAttributes=function(){return void 0===A&&(A=function(t,e){const n={},i=t.getProgramParameter(e,t.ACTIVE_ATTRIBUTES);for(let r=0;r<i;r++){const i=t.getActiveAttrib(e,r),s=i.name;let a=1;i.type===t.FLOAT_MAT2&&(a=2),i.type===t.FLOAT_MAT3&&(a=3),i.type===t.FLOAT_MAT4&&(a=4),n[s]={type:i.type,location:t.getAttribLocation(e,s),locationSize:a}}return n}(r,_)),A},this.destroy=function(){i.releaseStatesOfProgram(this),r.deleteProgram(_),this.program=void 0},this.name=n.shaderName,this.id=ns++,this.cacheKey=e,this.usedTimes=1,this.program=_,this.vertexShader=S,this.fragmentShader=E,this}let ys=0;class xs{constructor(){this.shaderCache=new Map,this.materialCache=new Map}update(t){const e=t.vertexShader,n=t.fragmentShader,i=this._getShaderStage(e),r=this._getShaderStage(n),s=this._getShaderCacheForMaterial(t);return!1===s.has(i)&&(s.add(i),i.usedTimes++),!1===s.has(r)&&(s.add(r),r.usedTimes++),this}remove(t){const e=this.materialCache.get(t);for(const t of e)t.usedTimes--,0===t.usedTimes&&this.shaderCache.delete(t.code);return this.materialCache.delete(t),this}getVertexShaderID(t){return this._getShaderStage(t.vertexShader).id}getFragmentShaderID(t){return this._getShaderStage(t.fragmentShader).id}dispose(){this.shaderCache.clear(),this.materialCache.clear()}_getShaderCacheForMaterial(t){const e=this.materialCache;return!1===e.has(t)&&e.set(t,new Set),e.get(t)}_getShaderStage(t){const e=this.shaderCache;if(!1===e.has(t)){const n=new bs(t);e.set(t,n)}return e.get(t)}}class bs{constructor(t){this.id=ys++,this.code=t,this.usedTimes=0}}function Ms(t,e,n,i,r,s,a){const o=new He,l=new xs,u=[],h=r.isWebGL2,d=r.logarithmicDepthBuffer,p=r.vertexTextures;let f=r.precision;const m={MeshDepthMaterial:"depth",MeshDistanceMaterial:"distanceRGBA",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshToonMaterial:"toon",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",MeshMatcapMaterial:"matcap",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points",ShadowMaterial:"shadow",SpriteMaterial:"sprite"};return{getParameters:function(s,o,u,g,v){const _=g.fog,y=v.geometry,x=s.isMeshStandardMaterial?g.environment:null,b=(s.isMeshStandardMaterial?n:e).get(s.envMap||x),M=b&&b.mapping===c?b.image.height:null,w=m[s.type];null!==s.precision&&(f=r.getMaxPrecision(s.precision),f!==s.precision&&console.warn("THREE.WebGLProgram.getParameters:",s.precision,"not supported, using",f,"instead."));const S=y.morphAttributes.position||y.morphAttributes.normal||y.morphAttributes.color,E=void 0!==S?S.length:0;let T,A,R,C,L=0;if(void 0!==y.morphAttributes.position&&(L=1),void 0!==y.morphAttributes.normal&&(L=2),void 0!==y.morphAttributes.color&&(L=3),w){const t=bi[w];T=t.vertexShader,A=t.fragmentShader}else T=s.vertexShader,A=s.fragmentShader,l.update(s),R=l.getVertexShaderID(s),C=l.getFragmentShaderID(s);const P=t.getRenderTarget(),I=s.alphaTest>0,D=s.clearcoat>0,O=s.iridescence>0;return{isWebGL2:h,shaderID:w,shaderName:s.type,vertexShader:T,fragmentShader:A,defines:s.defines,customVertexShaderID:R,customFragmentShaderID:C,isRawShaderMaterial:!0===s.isRawShaderMaterial,glslVersion:s.glslVersion,precision:f,instancing:!0===v.isInstancedMesh,instancingColor:!0===v.isInstancedMesh&&null!==v.instanceColor,supportsVertexTextures:p,outputEncoding:null===P?t.outputEncoding:!0===P.isXRRenderTarget?P.texture.encoding:at,map:!!s.map,matcap:!!s.matcap,envMap:!!b,envMapMode:b&&b.mapping,envMapCubeUVHeight:M,lightMap:!!s.lightMap,aoMap:!!s.aoMap,emissiveMap:!!s.emissiveMap,bumpMap:!!s.bumpMap,normalMap:!!s.normalMap,objectSpaceNormalMap:1===s.normalMapType,tangentSpaceNormalMap:0===s.normalMapType,decodeVideoTexture:!!s.map&&!0===s.map.isVideoTexture&&s.map.encoding===ot,clearcoat:D,clearcoatMap:D&&!!s.clearcoatMap,clearcoatRoughnessMap:D&&!!s.clearcoatRoughnessMap,clearcoatNormalMap:D&&!!s.clearcoatNormalMap,iridescence:O,iridescenceMap:O&&!!s.iridescenceMap,iridescenceThicknessMap:O&&!!s.iridescenceThicknessMap,displacementMap:!!s.displacementMap,roughnessMap:!!s.roughnessMap,metalnessMap:!!s.metalnessMap,specularMap:!!s.specularMap,specularIntensityMap:!!s.specularIntensityMap,specularColorMap:!!s.specularColorMap,opaque:!1===s.transparent&&1===s.blending,alphaMap:!!s.alphaMap,alphaTest:I,gradientMap:!!s.gradientMap,sheen:s.sheen>0,sheenColorMap:!!s.sheenColorMap,sheenRoughnessMap:!!s.sheenRoughnessMap,transmission:s.transmission>0,transmissionMap:!!s.transmissionMap,thicknessMap:!!s.thicknessMap,combine:s.combine,vertexTangents:!!s.normalMap&&!!y.attributes.tangent,vertexColors:s.vertexColors,vertexAlphas:!0===s.vertexColors&&!!y.attributes.color&&4===y.attributes.color.itemSize,vertexUvs:!!(s.map||s.bumpMap||s.normalMap||s.specularMap||s.alphaMap||s.emissiveMap||s.roughnessMap||s.metalnessMap||s.clearcoatMap||s.clearcoatRoughnessMap||s.clearcoatNormalMap||s.iridescenceMap||s.iridescenceThicknessMap||s.displacementMap||s.transmissionMap||s.thicknessMap||s.specularIntensityMap||s.specularColorMap||s.sheenColorMap||s.sheenRoughnessMap),uvsVertexOnly:!(s.map||s.bumpMap||s.normalMap||s.specularMap||s.alphaMap||s.emissiveMap||s.roughnessMap||s.metalnessMap||s.clearcoatNormalMap||s.iridescenceMap||s.iridescenceThicknessMap||s.transmission>0||s.transmissionMap||s.thicknessMap||s.specularIntensityMap||s.specularColorMap||s.sheen>0||s.sheenColorMap||s.sheenRoughnessMap||!s.displacementMap),fog:!!_,useFog:!0===s.fog,fogExp2:_&&_.isFogExp2,flatShading:!!s.flatShading,sizeAttenuation:s.sizeAttenuation,logarithmicDepthBuffer:d,skinning:!0===v.isSkinnedMesh,morphTargets:void 0!==y.morphAttributes.position,morphNormals:void 0!==y.morphAttributes.normal,morphColors:void 0!==y.morphAttributes.color,morphTargetsCount:E,morphTextureStride:L,numDirLights:o.directional.length,numPointLights:o.point.length,numSpotLights:o.spot.length,numRectAreaLights:o.rectArea.length,numHemiLights:o.hemi.length,numDirLightShadows:o.directionalShadowMap.length,numPointLightShadows:o.pointShadowMap.length,numSpotLightShadows:o.spotShadowMap.length,numClippingPlanes:a.numPlanes,numClipIntersection:a.numIntersection,dithering:s.dithering,shadowMapEnabled:t.shadowMap.enabled&&u.length>0,shadowMapType:t.shadowMap.type,toneMapping:s.toneMapped?t.toneMapping:0,physicallyCorrectLights:t.physicallyCorrectLights,premultipliedAlpha:s.premultipliedAlpha,doubleSided:2===s.side,flipSided:1===s.side,useDepthPacking:!!s.depthPacking,depthPacking:s.depthPacking||0,index0AttributeName:s.index0AttributeName,extensionDerivatives:s.extensions&&s.extensions.derivatives,extensionFragDepth:s.extensions&&s.extensions.fragDepth,extensionDrawBuffers:s.extensions&&s.extensions.drawBuffers,extensionShaderTextureLOD:s.extensions&&s.extensions.shaderTextureLOD,rendererExtensionFragDepth:h||i.has("EXT_frag_depth"),rendererExtensionDrawBuffers:h||i.has("WEBGL_draw_buffers"),rendererExtensionShaderTextureLod:h||i.has("EXT_shader_texture_lod"),customProgramCacheKey:s.customProgramCacheKey()}},getProgramCacheKey:function(e){const n=[];if(e.shaderID?n.push(e.shaderID):(n.push(e.customVertexShaderID),n.push(e.customFragmentShaderID)),void 0!==e.defines)for(const t in e.defines)n.push(t),n.push(e.defines[t]);return!1===e.isRawShaderMaterial&&(function(t,e){t.push(e.precision),t.push(e.outputEncoding),t.push(e.envMapMode),t.push(e.envMapCubeUVHeight),t.push(e.combine),t.push(e.vertexUvs),t.push(e.fogExp2),t.push(e.sizeAttenuation),t.push(e.morphTargetsCount),t.push(e.morphAttributeCount),t.push(e.numDirLights),t.push(e.numPointLights),t.push(e.numSpotLights),t.push(e.numHemiLights),t.push(e.numRectAreaLights),t.push(e.numDirLightShadows),t.push(e.numPointLightShadows),t.push(e.numSpotLightShadows),t.push(e.shadowMapType),t.push(e.toneMapping),t.push(e.numClippingPlanes),t.push(e.numClipIntersection),t.push(e.depthPacking)}(n,e),function(t,e){o.disableAll(),e.isWebGL2&&o.enable(0),e.supportsVertexTextures&&o.enable(1),e.instancing&&o.enable(2),e.instancingColor&&o.enable(3),e.map&&o.enable(4),e.matcap&&o.enable(5),e.envMap&&o.enable(6),e.lightMap&&o.enable(7),e.aoMap&&o.enable(8),e.emissiveMap&&o.enable(9),e.bumpMap&&o.enable(10),e.normalMap&&o.enable(11),e.objectSpaceNormalMap&&o.enable(12),e.tangentSpaceNormalMap&&o.enable(13),e.clearcoat&&o.enable(14),e.clearcoatMap&&o.enable(15),e.clearcoatRoughnessMap&&o.enable(16),e.clearcoatNormalMap&&o.enable(17),e.iridescence&&o.enable(18),e.iridescenceMap&&o.enable(19),e.iridescenceThicknessMap&&o.enable(20),e.displacementMap&&o.enable(21),e.specularMap&&o.enable(22),e.roughnessMap&&o.enable(23),e.metalnessMap&&o.enable(24),e.gradientMap&&o.enable(25),e.alphaMap&&o.enable(26),e.alphaTest&&o.enable(27),e.vertexColors&&o.enable(28),e.vertexAlphas&&o.enable(29),e.vertexUvs&&o.enable(30),e.vertexTangents&&o.enable(31),e.uvsVertexOnly&&o.enable(32),e.fog&&o.enable(33),t.push(o.mask),o.disableAll(),e.useFog&&o.enable(0),e.flatShading&&o.enable(1),e.logarithmicDepthBuffer&&o.enable(2),e.skinning&&o.enable(3),e.morphTargets&&o.enable(4),e.morphNormals&&o.enable(5),e.morphColors&&o.enable(6),e.premultipliedAlpha&&o.enable(7),e.shadowMapEnabled&&o.enable(8),e.physicallyCorrectLights&&o.enable(9),e.doubleSided&&o.enable(10),e.flipSided&&o.enable(11),e.useDepthPacking&&o.enable(12),e.dithering&&o.enable(13),e.specularIntensityMap&&o.enable(14),e.specularColorMap&&o.enable(15),e.transmission&&o.enable(16),e.transmissionMap&&o.enable(17),e.thicknessMap&&o.enable(18),e.sheen&&o.enable(19),e.sheenColorMap&&o.enable(20),e.sheenRoughnessMap&&o.enable(21),e.decodeVideoTexture&&o.enable(22),e.opaque&&o.enable(23),t.push(o.mask)}(n,e),n.push(t.outputEncoding)),n.push(e.customProgramCacheKey),n.join()},getUniforms:function(t){const e=m[t.type];let n;if(e){const t=bi[e];n=ei.clone(t.uniforms)}else n=t.uniforms;return n},acquireProgram:function(e,n){let i;for(let t=0,e=u.length;t<e;t++){const e=u[t];if(e.cacheKey===n){i=e,++i.usedTimes;break}}return void 0===i&&(i=new _s(t,n,e,s),u.push(i)),i},releaseProgram:function(t){if(0==--t.usedTimes){const e=u.indexOf(t);u[e]=u[u.length-1],u.pop(),t.destroy()}},releaseShaderCache:function(t){l.remove(t)},programs:u,dispose:function(){l.dispose()}}}function ws(){let t=new WeakMap;return{get:function(e){let n=t.get(e);return void 0===n&&(n={},t.set(e,n)),n},remove:function(e){t.delete(e)},update:function(e,n,i){t.get(e)[n]=i},dispose:function(){t=new WeakMap}}}function Ss(t,e){return t.groupOrder!==e.groupOrder?t.groupOrder-e.groupOrder:t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.material.id!==e.material.id?t.material.id-e.material.id:t.z!==e.z?t.z-e.z:t.id-e.id}function Es(t,e){return t.groupOrder!==e.groupOrder?t.groupOrder-e.groupOrder:t.renderOrder!==e.renderOrder?t.renderOrder-e.renderOrder:t.z!==e.z?e.z-t.z:t.id-e.id}function Ts(){const t=[];let e=0;const n=[],i=[],r=[];function s(n,i,r,s,a,o){let l=t[e];return void 0===l?(l={id:n.id,object:n,geometry:i,material:r,groupOrder:s,renderOrder:n.renderOrder,z:a,group:o},t[e]=l):(l.id=n.id,l.object=n,l.geometry=i,l.material=r,l.groupOrder=s,l.renderOrder=n.renderOrder,l.z=a,l.group=o),e++,l}return{opaque:n,transmissive:i,transparent:r,init:function(){e=0,n.length=0,i.length=0,r.length=0},push:function(t,e,a,o,l,c){const u=s(t,e,a,o,l,c);a.transmission>0?i.push(u):!0===a.transparent?r.push(u):n.push(u)},unshift:function(t,e,a,o,l,c){const u=s(t,e,a,o,l,c);a.transmission>0?i.unshift(u):!0===a.transparent?r.unshift(u):n.unshift(u)},finish:function(){for(let n=e,i=t.length;n<i;n++){const e=t[n];if(null===e.id)break;e.id=null,e.object=null,e.geometry=null,e.material=null,e.group=null}},sort:function(t,e){n.length>1&&n.sort(t||Ss),i.length>1&&i.sort(e||Es),r.length>1&&r.sort(e||Es)}}}function As(){let t=new WeakMap;return{get:function(e,n){let i;return!1===t.has(e)?(i=new Ts,t.set(e,[i])):n>=t.get(e).length?(i=new Ts,t.get(e).push(i)):i=t.get(e)[n],i},dispose:function(){t=new WeakMap}}}function Rs(){const t={};return{get:function(e){if(void 0!==t[e.id])return t[e.id];let n;switch(e.type){case"DirectionalLight":n={direction:new ee,color:new Ht};break;case"SpotLight":n={position:new ee,direction:new ee,color:new Ht,distance:0,coneCos:0,penumbraCos:0,decay:0};break;case"PointLight":n={position:new ee,color:new Ht,distance:0,decay:0};break;case"HemisphereLight":n={direction:new ee,skyColor:new Ht,groundColor:new Ht};break;case"RectAreaLight":n={color:new Ht,position:new ee,halfWidth:new ee,halfHeight:new ee}}return t[e.id]=n,n}}}let Cs=0;function Ls(t,e){return(e.castShadow?1:0)-(t.castShadow?1:0)}function Ps(t,e){const n=new Rs,i=function(){const t={};return{get:function(e){if(void 0!==t[e.id])return t[e.id];let n;switch(e.type){case"DirectionalLight":case"SpotLight":n={shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new At};break;case"PointLight":n={shadowBias:0,shadowNormalBias:0,shadowRadius:1,shadowMapSize:new At,shadowCameraNear:1,shadowCameraFar:1e3}}return t[e.id]=n,n}}}(),r={version:0,hash:{directionalLength:-1,pointLength:-1,spotLength:-1,rectAreaLength:-1,hemiLength:-1,numDirectionalShadows:-1,numPointShadows:-1,numSpotShadows:-1},ambient:[0,0,0],probe:[],directional:[],directionalShadow:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadow:[],spotShadowMap:[],spotShadowMatrix:[],rectArea:[],rectAreaLTC1:null,rectAreaLTC2:null,point:[],pointShadow:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[]};for(let t=0;t<9;t++)r.probe.push(new ee);const s=new ee,a=new Ie,o=new Ie;return{setup:function(s,a){let o=0,l=0,c=0;for(let t=0;t<9;t++)r.probe[t].set(0,0,0);let u=0,h=0,d=0,p=0,f=0,m=0,g=0,v=0;s.sort(Ls);const _=!0!==a?Math.PI:1;for(let t=0,e=s.length;t<e;t++){const e=s[t],a=e.color,y=e.intensity,x=e.distance,b=e.shadow&&e.shadow.map?e.shadow.map.texture:null;if(e.isAmbientLight)o+=a.r*y*_,l+=a.g*y*_,c+=a.b*y*_;else if(e.isLightProbe)for(let t=0;t<9;t++)r.probe[t].addScaledVector(e.sh.coefficients[t],y);else if(e.isDirectionalLight){const t=n.get(e);if(t.color.copy(e.color).multiplyScalar(e.intensity*_),e.castShadow){const t=e.shadow,n=i.get(e);n.shadowBias=t.bias,n.shadowNormalBias=t.normalBias,n.shadowRadius=t.radius,n.shadowMapSize=t.mapSize,r.directionalShadow[u]=n,r.directionalShadowMap[u]=b,r.directionalShadowMatrix[u]=e.shadow.matrix,m++}r.directional[u]=t,u++}else if(e.isSpotLight){const t=n.get(e);if(t.position.setFromMatrixPosition(e.matrixWorld),t.color.copy(a).multiplyScalar(y*_),t.distance=x,t.coneCos=Math.cos(e.angle),t.penumbraCos=Math.cos(e.angle*(1-e.penumbra)),t.decay=e.decay,e.castShadow){const t=e.shadow,n=i.get(e);n.shadowBias=t.bias,n.shadowNormalBias=t.normalBias,n.shadowRadius=t.radius,n.shadowMapSize=t.mapSize,r.spotShadow[d]=n,r.spotShadowMap[d]=b,r.spotShadowMatrix[d]=e.shadow.matrix,v++}r.spot[d]=t,d++}else if(e.isRectAreaLight){const t=n.get(e);t.color.copy(a).multiplyScalar(y),t.halfWidth.set(.5*e.width,0,0),t.halfHeight.set(0,.5*e.height,0),r.rectArea[p]=t,p++}else if(e.isPointLight){const t=n.get(e);if(t.color.copy(e.color).multiplyScalar(e.intensity*_),t.distance=e.distance,t.decay=e.decay,e.castShadow){const t=e.shadow,n=i.get(e);n.shadowBias=t.bias,n.shadowNormalBias=t.normalBias,n.shadowRadius=t.radius,n.shadowMapSize=t.mapSize,n.shadowCameraNear=t.camera.near,n.shadowCameraFar=t.camera.far,r.pointShadow[h]=n,r.pointShadowMap[h]=b,r.pointShadowMatrix[h]=e.shadow.matrix,g++}r.point[h]=t,h++}else if(e.isHemisphereLight){const t=n.get(e);t.skyColor.copy(e.color).multiplyScalar(y*_),t.groundColor.copy(e.groundColor).multiplyScalar(y*_),r.hemi[f]=t,f++}}p>0&&(e.isWebGL2||!0===t.has("OES_texture_float_linear")?(r.rectAreaLTC1=xi.LTC_FLOAT_1,r.rectAreaLTC2=xi.LTC_FLOAT_2):!0===t.has("OES_texture_half_float_linear")?(r.rectAreaLTC1=xi.LTC_HALF_1,r.rectAreaLTC2=xi.LTC_HALF_2):console.error("THREE.WebGLRenderer: Unable to use RectAreaLight. Missing WebGL extensions.")),r.ambient[0]=o,r.ambient[1]=l,r.ambient[2]=c;const y=r.hash;y.directionalLength===u&&y.pointLength===h&&y.spotLength===d&&y.rectAreaLength===p&&y.hemiLength===f&&y.numDirectionalShadows===m&&y.numPointShadows===g&&y.numSpotShadows===v||(r.directional.length=u,r.spot.length=d,r.rectArea.length=p,r.point.length=h,r.hemi.length=f,r.directionalShadow.length=m,r.directionalShadowMap.length=m,r.pointShadow.length=g,r.pointShadowMap.length=g,r.spotShadow.length=v,r.spotShadowMap.length=v,r.directionalShadowMatrix.length=m,r.pointShadowMatrix.length=g,r.spotShadowMatrix.length=v,y.directionalLength=u,y.pointLength=h,y.spotLength=d,y.rectAreaLength=p,y.hemiLength=f,y.numDirectionalShadows=m,y.numPointShadows=g,y.numSpotShadows=v,r.version=Cs++)},setupView:function(t,e){let n=0,i=0,l=0,c=0,u=0;const h=e.matrixWorldInverse;for(let e=0,d=t.length;e<d;e++){const d=t[e];if(d.isDirectionalLight){const t=r.directional[n];t.direction.setFromMatrixPosition(d.matrixWorld),s.setFromMatrixPosition(d.target.matrixWorld),t.direction.sub(s),t.direction.transformDirection(h),n++}else if(d.isSpotLight){const t=r.spot[l];t.position.setFromMatrixPosition(d.matrixWorld),t.position.applyMatrix4(h),t.direction.setFromMatrixPosition(d.matrixWorld),s.setFromMatrixPosition(d.target.matrixWorld),t.direction.sub(s),t.direction.transformDirection(h),l++}else if(d.isRectAreaLight){const t=r.rectArea[c];t.position.setFromMatrixPosition(d.matrixWorld),t.position.applyMatrix4(h),o.identity(),a.copy(d.matrixWorld),a.premultiply(h),o.extractRotation(a),t.halfWidth.set(.5*d.width,0,0),t.halfHeight.set(0,.5*d.height,0),t.halfWidth.applyMatrix4(o),t.halfHeight.applyMatrix4(o),c++}else if(d.isPointLight){const t=r.point[i];t.position.setFromMatrixPosition(d.matrixWorld),t.position.applyMatrix4(h),i++}else if(d.isHemisphereLight){const t=r.hemi[u];t.direction.setFromMatrixPosition(d.matrixWorld),t.direction.transformDirection(h),u++}}},state:r}}function Is(t,e){const n=new Ps(t,e),i=[],r=[];return{init:function(){i.length=0,r.length=0},state:{lightsArray:i,shadowsArray:r,lights:n},setupLights:function(t){n.setup(i,t)},setupLightsView:function(t){n.setupView(i,t)},pushLight:function(t){i.push(t)},pushShadow:function(t){r.push(t)}}}function Ds(t,e){let n=new WeakMap;return{get:function(i,r=0){let s;return!1===n.has(i)?(s=new Is(t,e),n.set(i,[s])):r>=n.get(i).length?(s=new Is(t,e),n.get(i).push(s)):s=n.get(i)[r],s},dispose:function(){n=new WeakMap}}}class Os extends vn{constructor(t){super(),this.isMeshDepthMaterial=!0,this.type="MeshDepthMaterial",this.depthPacking=3200,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.setValues(t)}copy(t){return super.copy(t),this.depthPacking=t.depthPacking,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this}}class Ns extends vn{constructor(t){super(),this.isMeshDistanceMaterial=!0,this.type="MeshDistanceMaterial",this.referencePosition=new ee,this.nearDistance=1,this.farDistance=1e3,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.setValues(t)}copy(t){return super.copy(t),this.referencePosition.copy(t.referencePosition),this.nearDistance=t.nearDistance,this.farDistance=t.farDistance,this.map=t.map,this.alphaMap=t.alphaMap,this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this}}function Us(t,e,n){let i=new mi;const r=new At,s=new At,a=new Jt,o=new Os({depthPacking:3201}),l=new Ns,c={},u=n.maxTextureSize,h={0:1,1:0,2:2},d=new ni({defines:{VSM_SAMPLES:8},uniforms:{shadow_pass:{value:null},resolution:{value:new At},radius:{value:4}},vertexShader:"void main() {\n\tgl_Position = vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D shadow_pass;\nuniform vec2 resolution;\nuniform float radius;\n#include <packing>\nvoid main() {\n\tconst float samples = float( VSM_SAMPLES );\n\tfloat mean = 0.0;\n\tfloat squared_mean = 0.0;\n\tfloat uvStride = samples <= 1.0 ? 0.0 : 2.0 / ( samples - 1.0 );\n\tfloat uvStart = samples <= 1.0 ? 0.0 : - 1.0;\n\tfor ( float i = 0.0; i < samples; i ++ ) {\n\t\tfloat uvOffset = uvStart + i * uvStride;\n\t\t#ifdef HORIZONTAL_PASS\n\t\t\tvec2 distribution = unpackRGBATo2Half( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( uvOffset, 0.0 ) * radius ) / resolution ) );\n\t\t\tmean += distribution.x;\n\t\t\tsquared_mean += distribution.y * distribution.y + distribution.x * distribution.x;\n\t\t#else\n\t\t\tfloat depth = unpackRGBAToDepth( texture2D( shadow_pass, ( gl_FragCoord.xy + vec2( 0.0, uvOffset ) * radius ) / resolution ) );\n\t\t\tmean += depth;\n\t\t\tsquared_mean += depth * depth;\n\t\t#endif\n\t}\n\tmean = mean / samples;\n\tsquared_mean = squared_mean / samples;\n\tfloat std_dev = sqrt( squared_mean - mean * mean );\n\tgl_FragColor = pack2HalfToRGBA( vec2( mean, std_dev ) );\n}"}),f=d.clone();f.defines.HORIZONTAL_PASS=1;const m=new In;m.setAttribute("position",new bn(new Float32Array([-1,-1,.5,3,-1,.5,-1,3,.5]),3));const g=new Jn(m,d),v=this;function _(n,i){const s=e.update(g);d.defines.VSM_SAMPLES!==n.blurSamples&&(d.defines.VSM_SAMPLES=n.blurSamples,f.defines.VSM_SAMPLES=n.blurSamples,d.needsUpdate=!0,f.needsUpdate=!0),null===n.mapPass&&(n.mapPass=new Kt(r.x,r.y)),d.uniforms.shadow_pass.value=n.map.texture,d.uniforms.resolution.value=n.mapSize,d.uniforms.radius.value=n.radius,t.setRenderTarget(n.mapPass),t.clear(),t.renderBufferDirect(i,null,s,d,g,null),f.uniforms.shadow_pass.value=n.mapPass.texture,f.uniforms.resolution.value=n.mapSize,f.uniforms.radius.value=n.radius,t.setRenderTarget(n.map),t.clear(),t.renderBufferDirect(i,null,s,f,g,null)}function y(e,n,i,r,s,a){let u=null;const d=!0===i.isPointLight?e.customDistanceMaterial:e.customDepthMaterial;if(u=void 0!==d?d:!0===i.isPointLight?l:o,t.localClippingEnabled&&!0===n.clipShadows&&Array.isArray(n.clippingPlanes)&&0!==n.clippingPlanes.length||n.displacementMap&&0!==n.displacementScale||n.alphaMap&&n.alphaTest>0){const t=u.uuid,e=n.uuid;let i=c[t];void 0===i&&(i={},c[t]=i);let r=i[e];void 0===r&&(r=u.clone(),i[e]=r),u=r}return u.visible=n.visible,u.wireframe=n.wireframe,u.side=3===a?null!==n.shadowSide?n.shadowSide:n.side:null!==n.shadowSide?n.shadowSide:h[n.side],u.alphaMap=n.alphaMap,u.alphaTest=n.alphaTest,u.clipShadows=n.clipShadows,u.clippingPlanes=n.clippingPlanes,u.clipIntersection=n.clipIntersection,u.displacementMap=n.displacementMap,u.displacementScale=n.displacementScale,u.displacementBias=n.displacementBias,u.wireframeLinewidth=n.wireframeLinewidth,u.linewidth=n.linewidth,!0===i.isPointLight&&!0===u.isMeshDistanceMaterial&&(u.referencePosition.setFromMatrixPosition(i.matrixWorld),u.nearDistance=r,u.farDistance=s),u}function x(n,r,s,a,o){if(!1===n.visible)return;if(n.layers.test(r.layers)&&(n.isMesh||n.isLine||n.isPoints)&&(n.castShadow||n.receiveShadow&&3===o)&&(!n.frustumCulled||i.intersectsObject(n))){n.modelViewMatrix.multiplyMatrices(s.matrixWorldInverse,n.matrixWorld);const i=e.update(n),r=n.material;if(Array.isArray(r)){const e=i.groups;for(let l=0,c=e.length;l<c;l++){const c=e[l],u=r[c.materialIndex];if(u&&u.visible){const e=y(n,u,a,s.near,s.far,o);t.renderBufferDirect(s,null,i,e,n,c)}}}else if(r.visible){const e=y(n,r,a,s.near,s.far,o);t.renderBufferDirect(s,null,i,e,n,null)}}const l=n.children;for(let t=0,e=l.length;t<e;t++)x(l[t],r,s,a,o)}this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=1,this.render=function(e,n,o){if(!1===v.enabled)return;if(!1===v.autoUpdate&&!1===v.needsUpdate)return;if(0===e.length)return;const l=t.getRenderTarget(),c=t.getActiveCubeFace(),h=t.getActiveMipmapLevel(),d=t.state;d.setBlending(0),d.buffers.color.setClear(1,1,1,1),d.buffers.depth.setTest(!0),d.setScissorTest(!1);for(let l=0,c=e.length;l<c;l++){const c=e[l],h=c.shadow;if(void 0===h){console.warn("THREE.WebGLShadowMap:",c,"has no shadow.");continue}if(!1===h.autoUpdate&&!1===h.needsUpdate)continue;r.copy(h.mapSize);const f=h.getFrameExtents();if(r.multiply(f),s.copy(h.mapSize),(r.x>u||r.y>u)&&(r.x>u&&(s.x=Math.floor(u/f.x),r.x=s.x*f.x,h.mapSize.x=s.x),r.y>u&&(s.y=Math.floor(u/f.y),r.y=s.y*f.y,h.mapSize.y=s.y)),null===h.map){const t=3!==this.type?{minFilter:p,magFilter:p}:{};h.map=new Kt(r.x,r.y,t),h.map.texture.name=c.name+".shadowMap",h.camera.updateProjectionMatrix()}t.setRenderTarget(h.map),t.clear();const m=h.getViewportCount();for(let t=0;t<m;t++){const e=h.getViewport(t);a.set(s.x*e.x,s.y*e.y,s.x*e.z,s.y*e.w),d.viewport(a),h.updateMatrices(c,t),i=h.getFrustum(),x(n,o,h.camera,c,this.type)}!0!==h.isPointLightShadow&&3===this.type&&_(h,o),h.needsUpdate=!1}v.needsUpdate=!1,t.setRenderTarget(l,c,h)}}function Fs(t,e,n){const r=n.isWebGL2,s=new function(){let e=!1;const n=new Jt;let i=null;const r=new Jt(0,0,0,0);return{setMask:function(n){i===n||e||(t.colorMask(n,n,n,n),i=n)},setLocked:function(t){e=t},setClear:function(e,i,s,a,o){!0===o&&(e*=a,i*=a,s*=a),n.set(e,i,s,a),!1===r.equals(n)&&(t.clearColor(e,i,s,a),r.copy(n))},reset:function(){e=!1,i=null,r.set(-1,0,0,0)}}},a=new function(){let e=!1,n=null,i=null,r=null;return{setTest:function(e){e?z(t.DEPTH_TEST):k(t.DEPTH_TEST)},setMask:function(i){n===i||e||(t.depthMask(i),n=i)},setFunc:function(e){if(i!==e){if(e)switch(e){case 0:t.depthFunc(t.NEVER);break;case 1:t.depthFunc(t.ALWAYS);break;case 2:t.depthFunc(t.LESS);break;case 3:default:t.depthFunc(t.LEQUAL);break;case 4:t.depthFunc(t.EQUAL);break;case 5:t.depthFunc(t.GEQUAL);break;case 6:t.depthFunc(t.GREATER);break;case 7:t.depthFunc(t.NOTEQUAL)}else t.depthFunc(t.LEQUAL);i=e}},setLocked:function(t){e=t},setClear:function(e){r!==e&&(t.clearDepth(e),r=e)},reset:function(){e=!1,n=null,i=null,r=null}}},o=new function(){let e=!1,n=null,i=null,r=null,s=null,a=null,o=null,l=null,c=null;return{setTest:function(n){e||(n?z(t.STENCIL_TEST):k(t.STENCIL_TEST))},setMask:function(i){n===i||e||(t.stencilMask(i),n=i)},setFunc:function(e,n,a){i===e&&r===n&&s===a||(t.stencilFunc(e,n,a),i=e,r=n,s=a)},setOp:function(e,n,i){a===e&&o===n&&l===i||(t.stencilOp(e,n,i),a=e,o=n,l=i)},setLocked:function(t){e=t},setClear:function(e){c!==e&&(t.clearStencil(e),c=e)},reset:function(){e=!1,n=null,i=null,r=null,s=null,a=null,o=null,l=null,c=null}}};let l={},c={},u=new WeakMap,h=[],d=null,p=!1,f=null,m=null,g=null,v=null,_=null,y=null,x=null,b=!1,M=null,w=null,S=null,E=null,T=null;const A=t.getParameter(t.MAX_COMBINED_TEXTURE_IMAGE_UNITS);let R=!1,C=0;const L=t.getParameter(t.VERSION);-1!==L.indexOf("WebGL")?(C=parseFloat(/^WebGL (\d)/.exec(L)[1]),R=C>=1):-1!==L.indexOf("OpenGL ES")&&(C=parseFloat(/^OpenGL ES (\d)/.exec(L)[1]),R=C>=2);let P=null,I={};const D=t.getParameter(t.SCISSOR_BOX),O=t.getParameter(t.VIEWPORT),N=(new Jt).fromArray(D),U=(new Jt).fromArray(O);function F(e,n,i){const r=new Uint8Array(4),s=t.createTexture();t.bindTexture(e,s),t.texParameteri(e,t.TEXTURE_MIN_FILTER,t.NEAREST),t.texParameteri(e,t.TEXTURE_MAG_FILTER,t.NEAREST);for(let e=0;e<i;e++)t.texImage2D(n+e,0,t.RGBA,1,1,0,t.RGBA,t.UNSIGNED_BYTE,r);return s}const B={};function z(e){!0!==l[e]&&(t.enable(e),l[e]=!0)}function k(e){!1!==l[e]&&(t.disable(e),l[e]=!1)}B[t.TEXTURE_2D]=F(t.TEXTURE_2D,t.TEXTURE_2D,1),B[t.TEXTURE_CUBE_MAP]=F(t.TEXTURE_CUBE_MAP,t.TEXTURE_CUBE_MAP_POSITIVE_X,6),s.setClear(0,0,0,1),a.setClear(1),o.setClear(0),z(t.DEPTH_TEST),a.setFunc(3),W(!1),j(1),z(t.CULL_FACE),H(0);const G={[i]:t.FUNC_ADD,101:t.FUNC_SUBTRACT,102:t.FUNC_REVERSE_SUBTRACT};if(r)G[103]=t.MIN,G[104]=t.MAX;else{const t=e.get("EXT_blend_minmax");null!==t&&(G[103]=t.MIN_EXT,G[104]=t.MAX_EXT)}const V={200:t.ZERO,201:t.ONE,202:t.SRC_COLOR,204:t.SRC_ALPHA,210:t.SRC_ALPHA_SATURATE,208:t.DST_COLOR,206:t.DST_ALPHA,203:t.ONE_MINUS_SRC_COLOR,205:t.ONE_MINUS_SRC_ALPHA,209:t.ONE_MINUS_DST_COLOR,207:t.ONE_MINUS_DST_ALPHA};function H(e,n,r,s,a,o,l,c){if(0!==e){if(!1===p&&(z(t.BLEND),p=!0),5===e)a=a||n,o=o||r,l=l||s,n===m&&a===_||(t.blendEquationSeparate(G[n],G[a]),m=n,_=a),r===g&&s===v&&o===y&&l===x||(t.blendFuncSeparate(V[r],V[s],V[o],V[l]),g=r,v=s,y=o,x=l),f=e,b=null;else if(e!==f||c!==b){if(m===i&&_===i||(t.blendEquation(t.FUNC_ADD),m=i,_=i),c)switch(e){case 1:t.blendFuncSeparate(t.ONE,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA);break;case 2:t.blendFunc(t.ONE,t.ONE);break;case 3:t.blendFuncSeparate(t.ZERO,t.ONE_MINUS_SRC_COLOR,t.ZERO,t.ONE);break;case 4:t.blendFuncSeparate(t.ZERO,t.SRC_COLOR,t.ZERO,t.SRC_ALPHA);break;default:console.error("THREE.WebGLState: Invalid blending: ",e)}else switch(e){case 1:t.blendFuncSeparate(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA,t.ONE,t.ONE_MINUS_SRC_ALPHA);break;case 2:t.blendFunc(t.SRC_ALPHA,t.ONE);break;case 3:t.blendFuncSeparate(t.ZERO,t.ONE_MINUS_SRC_COLOR,t.ZERO,t.ONE);break;case 4:t.blendFunc(t.ZERO,t.SRC_COLOR);break;default:console.error("THREE.WebGLState: Invalid blending: ",e)}g=null,v=null,y=null,x=null,f=e,b=c}}else!0===p&&(k(t.BLEND),p=!1)}function W(e){M!==e&&(e?t.frontFace(t.CW):t.frontFace(t.CCW),M=e)}function j(e){0!==e?(z(t.CULL_FACE),e!==w&&(1===e?t.cullFace(t.BACK):2===e?t.cullFace(t.FRONT):t.cullFace(t.FRONT_AND_BACK))):k(t.CULL_FACE),w=e}function X(e,n,i){e?(z(t.POLYGON_OFFSET_FILL),E===n&&T===i||(t.polygonOffset(n,i),E=n,T=i)):k(t.POLYGON_OFFSET_FILL)}function Y(e){void 0===e&&(e=t.TEXTURE0+A-1),P!==e&&(t.activeTexture(e),P=e)}return{buffers:{color:s,depth:a,stencil:o},enable:z,disable:k,bindFramebuffer:function(e,n){return c[e]!==n&&(t.bindFramebuffer(e,n),c[e]=n,r&&(e===t.DRAW_FRAMEBUFFER&&(c[t.FRAMEBUFFER]=n),e===t.FRAMEBUFFER&&(c[t.DRAW_FRAMEBUFFER]=n)),!0)},drawBuffers:function(i,r){let s=h,a=!1;if(i)if(s=u.get(r),void 0===s&&(s=[],u.set(r,s)),i.isWebGLMultipleRenderTargets){const e=i.texture;if(s.length!==e.length||s[0]!==t.COLOR_ATTACHMENT0){for(let n=0,i=e.length;n<i;n++)s[n]=t.COLOR_ATTACHMENT0+n;s.length=e.length,a=!0}}else s[0]!==t.COLOR_ATTACHMENT0&&(s[0]=t.COLOR_ATTACHMENT0,a=!0);else s[0]!==t.BACK&&(s[0]=t.BACK,a=!0);a&&(n.isWebGL2?t.drawBuffers(s):e.get("WEBGL_draw_buffers").drawBuffersWEBGL(s))},useProgram:function(e){return d!==e&&(t.useProgram(e),d=e,!0)},setBlending:H,setMaterial:function(e,n){2===e.side?k(t.CULL_FACE):z(t.CULL_FACE);let i=1===e.side;n&&(i=!i),W(i),1===e.blending&&!1===e.transparent?H(0):H(e.blending,e.blendEquation,e.blendSrc,e.blendDst,e.blendEquationAlpha,e.blendSrcAlpha,e.blendDstAlpha,e.premultipliedAlpha),a.setFunc(e.depthFunc),a.setTest(e.depthTest),a.setMask(e.depthWrite),s.setMask(e.colorWrite);const r=e.stencilWrite;o.setTest(r),r&&(o.setMask(e.stencilWriteMask),o.setFunc(e.stencilFunc,e.stencilRef,e.stencilFuncMask),o.setOp(e.stencilFail,e.stencilZFail,e.stencilZPass)),X(e.polygonOffset,e.polygonOffsetFactor,e.polygonOffsetUnits),!0===e.alphaToCoverage?z(t.SAMPLE_ALPHA_TO_COVERAGE):k(t.SAMPLE_ALPHA_TO_COVERAGE)},setFlipSided:W,setCullFace:j,setLineWidth:function(e){e!==S&&(R&&t.lineWidth(e),S=e)},setPolygonOffset:X,setScissorTest:function(e){e?z(t.SCISSOR_TEST):k(t.SCISSOR_TEST)},activeTexture:Y,bindTexture:function(e,n){null===P&&Y();let i=I[P];void 0===i&&(i={type:void 0,texture:void 0},I[P]=i),i.type===e&&i.texture===n||(t.bindTexture(e,n||B[e]),i.type=e,i.texture=n)},unbindTexture:function(){const e=I[P];void 0!==e&&void 0!==e.type&&(t.bindTexture(e.type,null),e.type=void 0,e.texture=void 0)},compressedTexImage2D:function(){try{t.compressedTexImage2D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},texImage2D:function(){try{t.texImage2D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},texImage3D:function(){try{t.texImage3D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},texStorage2D:function(){try{t.texStorage2D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},texStorage3D:function(){try{t.texStorage3D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},texSubImage2D:function(){try{t.texSubImage2D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},texSubImage3D:function(){try{t.texSubImage3D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},compressedTexSubImage2D:function(){try{t.compressedTexSubImage2D.apply(t,arguments)}catch(t){console.error("THREE.WebGLState:",t)}},scissor:function(e){!1===N.equals(e)&&(t.scissor(e.x,e.y,e.z,e.w),N.copy(e))},viewport:function(e){!1===U.equals(e)&&(t.viewport(e.x,e.y,e.z,e.w),U.copy(e))},reset:function(){t.disable(t.BLEND),t.disable(t.CULL_FACE),t.disable(t.DEPTH_TEST),t.disable(t.POLYGON_OFFSET_FILL),t.disable(t.SCISSOR_TEST),t.disable(t.STENCIL_TEST),t.disable(t.SAMPLE_ALPHA_TO_COVERAGE),t.blendEquation(t.FUNC_ADD),t.blendFunc(t.ONE,t.ZERO),t.blendFuncSeparate(t.ONE,t.ZERO,t.ONE,t.ZERO),t.colorMask(!0,!0,!0,!0),t.clearColor(0,0,0,0),t.depthMask(!0),t.depthFunc(t.LESS),t.clearDepth(1),t.stencilMask(4294967295),t.stencilFunc(t.ALWAYS,0,4294967295),t.stencilOp(t.KEEP,t.KEEP,t.KEEP),t.clearStencil(0),t.cullFace(t.BACK),t.frontFace(t.CCW),t.polygonOffset(0,0),t.activeTexture(t.TEXTURE0),t.bindFramebuffer(t.FRAMEBUFFER,null),!0===r&&(t.bindFramebuffer(t.DRAW_FRAMEBUFFER,null),t.bindFramebuffer(t.READ_FRAMEBUFFER,null)),t.useProgram(null),t.lineWidth(1),t.scissor(0,0,t.canvas.width,t.canvas.height),t.viewport(0,0,t.canvas.width,t.canvas.height),l={},P=null,I={},c={},u=new WeakMap,h=[],d=null,p=!1,f=null,m=null,g=null,v=null,_=null,y=null,x=null,b=!1,M=null,w=null,S=null,E=null,T=null,N.set(0,0,t.canvas.width,t.canvas.height),U.set(0,0,t.canvas.width,t.canvas.height),s.reset(),a.reset(),o.reset()}}}function Bs(t,e,n,i,r,s,a){const o=r.isWebGL2,l=r.maxTextures,c=r.maxCubemapSize,R=r.maxTextureSize,C=r.maxSamples,L=e.has("WEBGL_multisampled_render_to_texture")?e.get("WEBGL_multisampled_render_to_texture"):null,P=/OculusBrowser/g.test(navigator.userAgent),I=new WeakMap;let D;const O=new WeakMap;let N=!1;try{N="undefined"!=typeof OffscreenCanvas&&null!==new OffscreenCanvas(1,1).getContext("2d")}catch(t){}function U(t,e){return N?new OffscreenCanvas(t,e):It("canvas")}function F(t,e,n,i){let r=1;if((t.width>i||t.height>i)&&(r=i/Math.max(t.width,t.height)),r<1||!0===e){if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement||"undefined"!=typeof HTMLCanvasElement&&t instanceof HTMLCanvasElement||"undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap){const i=e?Et:Math.floor,s=i(r*t.width),a=i(r*t.height);void 0===D&&(D=U(s,a));const o=n?U(s,a):D;return o.width=s,o.height=a,o.getContext("2d").drawImage(t,0,0,s,a),console.warn("THREE.WebGLRenderer: Texture has been resized from ("+t.width+"x"+t.height+") to ("+s+"x"+a+")."),o}return"data"in t&&console.warn("THREE.WebGLRenderer: Image in DataTexture is too big ("+t.width+"x"+t.height+")."),t}return t}function B(t){return wt(t.width)&&wt(t.height)}function z(t,e){return t.generateMipmaps&&e&&t.minFilter!==p&&t.minFilter!==g}function k(e){t.generateMipmap(e)}function G(n,i,r,s,a=!1){if(!1===o)return i;if(null!==n){if(void 0!==t[n])return t[n];console.warn("THREE.WebGLRenderer: Attempt to use non-existing WebGL internal format '"+n+"'")}let l=i;return i===t.RED&&(r===t.FLOAT&&(l=t.R32F),r===t.HALF_FLOAT&&(l=t.R16F),r===t.UNSIGNED_BYTE&&(l=t.R8)),i===t.RG&&(r===t.FLOAT&&(l=t.RG32F),r===t.HALF_FLOAT&&(l=t.RG16F),r===t.UNSIGNED_BYTE&&(l=t.RG8)),i===t.RGBA&&(r===t.FLOAT&&(l=t.RGBA32F),r===t.HALF_FLOAT&&(l=t.RGBA16F),r===t.UNSIGNED_BYTE&&(l=s===ot&&!1===a?t.SRGB8_ALPHA8:t.RGBA8),r===t.UNSIGNED_SHORT_4_4_4_4&&(l=t.RGBA4),r===t.UNSIGNED_SHORT_5_5_5_1&&(l=t.RGB5_A1)),l!==t.R16F&&l!==t.R32F&&l!==t.RG16F&&l!==t.RG32F&&l!==t.RGBA16F&&l!==t.RGBA32F||e.get("EXT_color_buffer_float"),l}function V(t,e,n){return!0===z(t,n)||t.isFramebufferTexture&&t.minFilter!==p&&t.minFilter!==g?Math.log2(Math.max(e.width,e.height))+1:void 0!==t.mipmaps&&t.mipmaps.length>0?t.mipmaps.length:t.isCompressedTexture&&Array.isArray(t.image)?e.mipmaps.length:1}function H(e){return e===p||e===f||e===m?t.NEAREST:t.LINEAR}function W(t){const e=t.target;e.removeEventListener("dispose",W),function(t){const e=i.get(t);if(void 0===e.__webglInit)return;const n=t.source,r=O.get(n);if(r){const i=r[e.__cacheKey];i.usedTimes--,0===i.usedTimes&&X(t),0===Object.keys(r).length&&O.delete(n)}i.remove(t)}(e),e.isVideoTexture&&I.delete(e)}function j(e){const n=e.target;n.removeEventListener("dispose",j),function(e){const n=e.texture,r=i.get(e),s=i.get(n);if(void 0!==s.__webglTexture&&(t.deleteTexture(s.__webglTexture),a.memory.textures--),e.depthTexture&&e.depthTexture.dispose(),e.isWebGLCubeRenderTarget)for(let e=0;e<6;e++)t.deleteFramebuffer(r.__webglFramebuffer[e]),r.__webglDepthbuffer&&t.deleteRenderbuffer(r.__webglDepthbuffer[e]);else{if(t.deleteFramebuffer(r.__webglFramebuffer),r.__webglDepthbuffer&&t.deleteRenderbuffer(r.__webglDepthbuffer),r.__webglMultisampledFramebuffer&&t.deleteFramebuffer(r.__webglMultisampledFramebuffer),r.__webglColorRenderbuffer)for(let e=0;e<r.__webglColorRenderbuffer.length;e++)r.__webglColorRenderbuffer[e]&&t.deleteRenderbuffer(r.__webglColorRenderbuffer[e]);r.__webglDepthRenderbuffer&&t.deleteRenderbuffer(r.__webglDepthRenderbuffer)}if(e.isWebGLMultipleRenderTargets)for(let e=0,r=n.length;e<r;e++){const r=i.get(n[e]);r.__webglTexture&&(t.deleteTexture(r.__webglTexture),a.memory.textures--),i.remove(n[e])}i.remove(n),i.remove(e)}(n)}function X(e){const n=i.get(e);t.deleteTexture(n.__webglTexture);const r=e.source;delete O.get(r)[n.__cacheKey],a.memory.textures--}let Y=0;function q(e,r){const s=i.get(e);if(e.isVideoTexture&&function(t){const e=a.render.frame;I.get(t)!==e&&(I.set(t,e),t.update())}(e),!1===e.isRenderTargetTexture&&e.version>0&&s.__version!==e.version){const t=e.image;if(null===t)console.warn("THREE.WebGLRenderer: Texture marked for update but no image data found.");else{if(!1!==t.complete)return void Q(s,e,r);console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete")}}n.activeTexture(t.TEXTURE0+r),n.bindTexture(t.TEXTURE_2D,s.__webglTexture)}const Z={[u]:t.REPEAT,[h]:t.CLAMP_TO_EDGE,[d]:t.MIRRORED_REPEAT},J={[p]:t.NEAREST,[f]:t.NEAREST_MIPMAP_NEAREST,[m]:t.NEAREST_MIPMAP_LINEAR,[g]:t.LINEAR,[v]:t.LINEAR_MIPMAP_NEAREST,[_]:t.LINEAR_MIPMAP_LINEAR};function K(n,s,a){if(a?(t.texParameteri(n,t.TEXTURE_WRAP_S,Z[s.wrapS]),t.texParameteri(n,t.TEXTURE_WRAP_T,Z[s.wrapT]),n!==t.TEXTURE_3D&&n!==t.TEXTURE_2D_ARRAY||t.texParameteri(n,t.TEXTURE_WRAP_R,Z[s.wrapR]),t.texParameteri(n,t.TEXTURE_MAG_FILTER,J[s.magFilter]),t.texParameteri(n,t.TEXTURE_MIN_FILTER,J[s.minFilter])):(t.texParameteri(n,t.TEXTURE_WRAP_S,t.CLAMP_TO_EDGE),t.texParameteri(n,t.TEXTURE_WRAP_T,t.CLAMP_TO_EDGE),n!==t.TEXTURE_3D&&n!==t.TEXTURE_2D_ARRAY||t.texParameteri(n,t.TEXTURE_WRAP_R,t.CLAMP_TO_EDGE),s.wrapS===h&&s.wrapT===h||console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping."),t.texParameteri(n,t.TEXTURE_MAG_FILTER,H(s.magFilter)),t.texParameteri(n,t.TEXTURE_MIN_FILTER,H(s.minFilter)),s.minFilter!==p&&s.minFilter!==g&&console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter.")),!0===e.has("EXT_texture_filter_anisotropic")){const a=e.get("EXT_texture_filter_anisotropic");if(s.type===M&&!1===e.has("OES_texture_float_linear"))return;if(!1===o&&s.type===w&&!1===e.has("OES_texture_half_float_linear"))return;(s.anisotropy>1||i.get(s).__currentAnisotropy)&&(t.texParameterf(n,a.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(s.anisotropy,r.getMaxAnisotropy())),i.get(s).__currentAnisotropy=s.anisotropy)}}function $(e,n){let i=!1;void 0===e.__webglInit&&(e.__webglInit=!0,n.addEventListener("dispose",W));const r=n.source;let s=O.get(r);void 0===s&&(s={},O.set(r,s));const o=function(t){const e=[];return e.push(t.wrapS),e.push(t.wrapT),e.push(t.magFilter),e.push(t.minFilter),e.push(t.anisotropy),e.push(t.internalFormat),e.push(t.format),e.push(t.type),e.push(t.generateMipmaps),e.push(t.premultiplyAlpha),e.push(t.flipY),e.push(t.unpackAlignment),e.push(t.encoding),e.join()}(n);if(o!==e.__cacheKey){void 0===s[o]&&(s[o]={texture:t.createTexture(),usedTimes:0},a.memory.textures++,i=!0),s[o].usedTimes++;const r=s[e.__cacheKey];void 0!==r&&(s[e.__cacheKey].usedTimes--,0===r.usedTimes&&X(n)),e.__cacheKey=o,e.__webglTexture=s[o].texture}return i}function Q(e,i,r){let a=t.TEXTURE_2D;i.isDataArrayTexture&&(a=t.TEXTURE_2D_ARRAY),i.isData3DTexture&&(a=t.TEXTURE_3D);const l=$(e,i),c=i.source;if(n.activeTexture(t.TEXTURE0+r),n.bindTexture(a,e.__webglTexture),c.version!==c.__currentVersion||!0===l){t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,i.flipY),t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,i.premultiplyAlpha),t.pixelStorei(t.UNPACK_ALIGNMENT,i.unpackAlignment),t.pixelStorei(t.UNPACK_COLORSPACE_CONVERSION_WEBGL,t.NONE);const e=function(t){return!o&&(t.wrapS!==h||t.wrapT!==h||t.minFilter!==p&&t.minFilter!==g)}(i)&&!1===B(i.image);let r=F(i.image,e,!1,R);r=st(i,r);const u=B(r)||o,d=s.convert(i.format,i.encoding);let f,m=s.convert(i.type),v=G(i.internalFormat,d,m,i.encoding,i.isVideoTexture);K(a,i,u);const _=i.mipmaps,y=o&&!0!==i.isVideoTexture,w=void 0===c.__currentVersion||!0===l,C=V(i,r,u);if(i.isDepthTexture)v=t.DEPTH_COMPONENT,o?v=i.type===M?t.DEPTH_COMPONENT32F:i.type===b?t.DEPTH_COMPONENT24:i.type===S?t.DEPTH24_STENCIL8:t.DEPTH_COMPONENT16:i.type===M&&console.error("WebGLRenderer: Floating point depth texture requires WebGL2."),i.format===T&&v===t.DEPTH_COMPONENT&&i.type!==x&&i.type!==b&&(console.warn("THREE.WebGLRenderer: Use UnsignedShortType or UnsignedIntType for DepthFormat DepthTexture."),i.type=b,m=s.convert(i.type)),i.format===A&&v===t.DEPTH_COMPONENT&&(v=t.DEPTH_STENCIL,i.type!==S&&(console.warn("THREE.WebGLRenderer: Use UnsignedInt248Type for DepthStencilFormat DepthTexture."),i.type=S,m=s.convert(i.type))),w&&(y?n.texStorage2D(t.TEXTURE_2D,1,v,r.width,r.height):n.texImage2D(t.TEXTURE_2D,0,v,r.width,r.height,0,d,m,null));else if(i.isDataTexture)if(_.length>0&&u){y&&w&&n.texStorage2D(t.TEXTURE_2D,C,v,_[0].width,_[0].height);for(let e=0,i=_.length;e<i;e++)f=_[e],y?n.texSubImage2D(t.TEXTURE_2D,e,0,0,f.width,f.height,d,m,f.data):n.texImage2D(t.TEXTURE_2D,e,v,f.width,f.height,0,d,m,f.data);i.generateMipmaps=!1}else y?(w&&n.texStorage2D(t.TEXTURE_2D,C,v,r.width,r.height),n.texSubImage2D(t.TEXTURE_2D,0,0,0,r.width,r.height,d,m,r.data)):n.texImage2D(t.TEXTURE_2D,0,v,r.width,r.height,0,d,m,r.data);else if(i.isCompressedTexture){y&&w&&n.texStorage2D(t.TEXTURE_2D,C,v,_[0].width,_[0].height);for(let e=0,r=_.length;e<r;e++)f=_[e],i.format!==E?null!==d?y?n.compressedTexSubImage2D(t.TEXTURE_2D,e,0,0,f.width,f.height,d,f.data):n.compressedTexImage2D(t.TEXTURE_2D,e,v,f.width,f.height,0,f.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):y?n.texSubImage2D(t.TEXTURE_2D,e,0,0,f.width,f.height,d,m,f.data):n.texImage2D(t.TEXTURE_2D,e,v,f.width,f.height,0,d,m,f.data)}else if(i.isDataArrayTexture)y?(w&&n.texStorage3D(t.TEXTURE_2D_ARRAY,C,v,r.width,r.height,r.depth),n.texSubImage3D(t.TEXTURE_2D_ARRAY,0,0,0,0,r.width,r.height,r.depth,d,m,r.data)):n.texImage3D(t.TEXTURE_2D_ARRAY,0,v,r.width,r.height,r.depth,0,d,m,r.data);else if(i.isData3DTexture)y?(w&&n.texStorage3D(t.TEXTURE_3D,C,v,r.width,r.height,r.depth),n.texSubImage3D(t.TEXTURE_3D,0,0,0,0,r.width,r.height,r.depth,d,m,r.data)):n.texImage3D(t.TEXTURE_3D,0,v,r.width,r.height,r.depth,0,d,m,r.data);else if(i.isFramebufferTexture){if(w)if(y)n.texStorage2D(t.TEXTURE_2D,C,v,r.width,r.height);else{let e=r.width,i=r.height;for(let r=0;r<C;r++)n.texImage2D(t.TEXTURE_2D,r,v,e,i,0,d,m,null),e>>=1,i>>=1}}else if(_.length>0&&u){y&&w&&n.texStorage2D(t.TEXTURE_2D,C,v,_[0].width,_[0].height);for(let e=0,i=_.length;e<i;e++)f=_[e],y?n.texSubImage2D(t.TEXTURE_2D,e,0,0,d,m,f):n.texImage2D(t.TEXTURE_2D,e,v,d,m,f);i.generateMipmaps=!1}else y?(w&&n.texStorage2D(t.TEXTURE_2D,C,v,r.width,r.height),n.texSubImage2D(t.TEXTURE_2D,0,0,0,d,m,r)):n.texImage2D(t.TEXTURE_2D,0,v,d,m,r);z(i,u)&&k(a),c.__currentVersion=c.version,i.onUpdate&&i.onUpdate(i)}e.__version=i.version}function tt(e,r,a,o,l){const c=s.convert(a.format,a.encoding),u=s.convert(a.type),h=G(a.internalFormat,c,u,a.encoding);i.get(r).__hasExternalTextures||(l===t.TEXTURE_3D||l===t.TEXTURE_2D_ARRAY?n.texImage3D(l,0,h,r.width,r.height,r.depth,0,c,u,null):n.texImage2D(l,0,h,r.width,r.height,0,c,u,null)),n.bindFramebuffer(t.FRAMEBUFFER,e),rt(r)?L.framebufferTexture2DMultisampleEXT(t.FRAMEBUFFER,o,l,i.get(a).__webglTexture,0,it(r)):t.framebufferTexture2D(t.FRAMEBUFFER,o,l,i.get(a).__webglTexture,0),n.bindFramebuffer(t.FRAMEBUFFER,null)}function et(e,n,i){if(t.bindRenderbuffer(t.RENDERBUFFER,e),n.depthBuffer&&!n.stencilBuffer){let r=t.DEPTH_COMPONENT16;if(i||rt(n)){const e=n.depthTexture;e&&e.isDepthTexture&&(e.type===M?r=t.DEPTH_COMPONENT32F:e.type===b&&(r=t.DEPTH_COMPONENT24));const i=it(n);rt(n)?L.renderbufferStorageMultisampleEXT(t.RENDERBUFFER,i,r,n.width,n.height):t.renderbufferStorageMultisample(t.RENDERBUFFER,i,r,n.width,n.height)}else t.renderbufferStorage(t.RENDERBUFFER,r,n.width,n.height);t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.RENDERBUFFER,e)}else if(n.depthBuffer&&n.stencilBuffer){const r=it(n);i&&!1===rt(n)?t.renderbufferStorageMultisample(t.RENDERBUFFER,r,t.DEPTH24_STENCIL8,n.width,n.height):rt(n)?L.renderbufferStorageMultisampleEXT(t.RENDERBUFFER,r,t.DEPTH24_STENCIL8,n.width,n.height):t.renderbufferStorage(t.RENDERBUFFER,t.DEPTH_STENCIL,n.width,n.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.RENDERBUFFER,e)}else{const e=!0===n.isWebGLMultipleRenderTargets?n.texture:[n.texture];for(let r=0;r<e.length;r++){const a=e[r],o=s.convert(a.format,a.encoding),l=s.convert(a.type),c=G(a.internalFormat,o,l,a.encoding),u=it(n);i&&!1===rt(n)?t.renderbufferStorageMultisample(t.RENDERBUFFER,u,c,n.width,n.height):rt(n)?L.renderbufferStorageMultisampleEXT(t.RENDERBUFFER,u,c,n.width,n.height):t.renderbufferStorage(t.RENDERBUFFER,c,n.width,n.height)}}t.bindRenderbuffer(t.RENDERBUFFER,null)}function nt(e){const r=i.get(e),s=!0===e.isWebGLCubeRenderTarget;if(e.depthTexture&&!r.__autoAllocateDepthBuffer){if(s)throw new Error("target.depthTexture not supported in Cube render targets");!function(e,r){if(r&&r.isWebGLCubeRenderTarget)throw new Error("Depth Texture with cube render targets is not supported");if(n.bindFramebuffer(t.FRAMEBUFFER,e),!r.depthTexture||!r.depthTexture.isDepthTexture)throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");i.get(r.depthTexture).__webglTexture&&r.depthTexture.image.width===r.width&&r.depthTexture.image.height===r.height||(r.depthTexture.image.width=r.width,r.depthTexture.image.height=r.height,r.depthTexture.needsUpdate=!0),q(r.depthTexture,0);const s=i.get(r.depthTexture).__webglTexture,a=it(r);if(r.depthTexture.format===T)rt(r)?L.framebufferTexture2DMultisampleEXT(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,s,0,a):t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_ATTACHMENT,t.TEXTURE_2D,s,0);else{if(r.depthTexture.format!==A)throw new Error("Unknown depthTexture format");rt(r)?L.framebufferTexture2DMultisampleEXT(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.TEXTURE_2D,s,0,a):t.framebufferTexture2D(t.FRAMEBUFFER,t.DEPTH_STENCIL_ATTACHMENT,t.TEXTURE_2D,s,0)}}(r.__webglFramebuffer,e)}else if(s){r.__webglDepthbuffer=[];for(let i=0;i<6;i++)n.bindFramebuffer(t.FRAMEBUFFER,r.__webglFramebuffer[i]),r.__webglDepthbuffer[i]=t.createRenderbuffer(),et(r.__webglDepthbuffer[i],e,!1)}else n.bindFramebuffer(t.FRAMEBUFFER,r.__webglFramebuffer),r.__webglDepthbuffer=t.createRenderbuffer(),et(r.__webglDepthbuffer,e,!1);n.bindFramebuffer(t.FRAMEBUFFER,null)}function it(t){return Math.min(C,t.samples)}function rt(t){const n=i.get(t);return o&&t.samples>0&&!0===e.has("WEBGL_multisampled_render_to_texture")&&!1!==n.__useRenderToTexture}function st(t,n){const i=t.encoding,r=t.format,s=t.type;return!0===t.isCompressedTexture||!0===t.isVideoTexture||t.format===pt||i!==at&&(i===ot?!1===o?!0===e.has("EXT_sRGB")&&r===E?(t.format=pt,t.minFilter=g,t.generateMipmaps=!1):n=jt.sRGBToLinear(n):r===E&&s===y||console.warn("THREE.WebGLTextures: sRGB encoded textures have to use RGBAFormat and UnsignedByteType."):console.error("THREE.WebGLTextures: Unsupported texture encoding:",i)),n}this.allocateTextureUnit=function(){const t=Y;return t>=l&&console.warn("THREE.WebGLTextures: Trying to use "+t+" texture units while this GPU supports only "+l),Y+=1,t},this.resetTextureUnits=function(){Y=0},this.setTexture2D=q,this.setTexture2DArray=function(e,r){const s=i.get(e);e.version>0&&s.__version!==e.version?Q(s,e,r):(n.activeTexture(t.TEXTURE0+r),n.bindTexture(t.TEXTURE_2D_ARRAY,s.__webglTexture))},this.setTexture3D=function(e,r){const s=i.get(e);e.version>0&&s.__version!==e.version?Q(s,e,r):(n.activeTexture(t.TEXTURE0+r),n.bindTexture(t.TEXTURE_3D,s.__webglTexture))},this.setTextureCube=function(e,r){const a=i.get(e);e.version>0&&a.__version!==e.version?function(e,i,r){if(6!==i.image.length)return;const a=$(e,i),l=i.source;if(n.activeTexture(t.TEXTURE0+r),n.bindTexture(t.TEXTURE_CUBE_MAP,e.__webglTexture),l.version!==l.__currentVersion||!0===a){t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,i.flipY),t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,i.premultiplyAlpha),t.pixelStorei(t.UNPACK_ALIGNMENT,i.unpackAlignment),t.pixelStorei(t.UNPACK_COLORSPACE_CONVERSION_WEBGL,t.NONE);const e=i.isCompressedTexture||i.image[0].isCompressedTexture,r=i.image[0]&&i.image[0].isDataTexture,u=[];for(let t=0;t<6;t++)u[t]=e||r?r?i.image[t].image:i.image[t]:F(i.image[t],!1,!0,c),u[t]=st(i,u[t]);const h=u[0],d=B(h)||o,p=s.convert(i.format,i.encoding),f=s.convert(i.type),m=G(i.internalFormat,p,f,i.encoding),g=o&&!0!==i.isVideoTexture,v=void 0===l.__currentVersion||!0===a;let _,y=V(i,h,d);if(K(t.TEXTURE_CUBE_MAP,i,d),e){g&&v&&n.texStorage2D(t.TEXTURE_CUBE_MAP,y,m,h.width,h.height);for(let e=0;e<6;e++){_=u[e].mipmaps;for(let r=0;r<_.length;r++){const s=_[r];i.format!==E?null!==p?g?n.compressedTexSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r,0,0,s.width,s.height,p,s.data):n.compressedTexImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r,m,s.width,s.height,0,s.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setTextureCube()"):g?n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r,0,0,s.width,s.height,p,f,s.data):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,r,m,s.width,s.height,0,p,f,s.data)}}}else{_=i.mipmaps,g&&v&&(_.length>0&&y++,n.texStorage2D(t.TEXTURE_CUBE_MAP,y,m,u[0].width,u[0].height));for(let e=0;e<6;e++)if(r){g?n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,0,0,u[e].width,u[e].height,p,f,u[e].data):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,m,u[e].width,u[e].height,0,p,f,u[e].data);for(let i=0;i<_.length;i++){const r=_[i].image[e].image;g?n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,i+1,0,0,r.width,r.height,p,f,r.data):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,i+1,m,r.width,r.height,0,p,f,r.data)}}else{g?n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,0,0,p,f,u[e]):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,m,p,f,u[e]);for(let i=0;i<_.length;i++){const r=_[i];g?n.texSubImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,i+1,0,0,p,f,r.image[e]):n.texImage2D(t.TEXTURE_CUBE_MAP_POSITIVE_X+e,i+1,m,p,f,r.image[e])}}}z(i,d)&&k(t.TEXTURE_CUBE_MAP),l.__currentVersion=l.version,i.onUpdate&&i.onUpdate(i)}e.__version=i.version}(a,e,r):(n.activeTexture(t.TEXTURE0+r),n.bindTexture(t.TEXTURE_CUBE_MAP,a.__webglTexture))},this.rebindTextures=function(e,n,r){const s=i.get(e);void 0!==n&&tt(s.__webglFramebuffer,e,e.texture,t.COLOR_ATTACHMENT0,t.TEXTURE_2D),void 0!==r&&nt(e)},this.setupRenderTarget=function(e){const l=e.texture,c=i.get(e),u=i.get(l);e.addEventListener("dispose",j),!0!==e.isWebGLMultipleRenderTargets&&(void 0===u.__webglTexture&&(u.__webglTexture=t.createTexture()),u.__version=l.version,a.memory.textures++);const h=!0===e.isWebGLCubeRenderTarget,d=!0===e.isWebGLMultipleRenderTargets,p=B(e)||o;if(h){c.__webglFramebuffer=[];for(let e=0;e<6;e++)c.__webglFramebuffer[e]=t.createFramebuffer()}else{if(c.__webglFramebuffer=t.createFramebuffer(),d)if(r.drawBuffers){const n=e.texture;for(let e=0,r=n.length;e<r;e++){const r=i.get(n[e]);void 0===r.__webglTexture&&(r.__webglTexture=t.createTexture(),a.memory.textures++)}}else console.warn("THREE.WebGLRenderer: WebGLMultipleRenderTargets can only be used with WebGL2 or WEBGL_draw_buffers extension.");if(o&&e.samples>0&&!1===rt(e)){const i=d?l:[l];c.__webglMultisampledFramebuffer=t.createFramebuffer(),c.__webglColorRenderbuffer=[],n.bindFramebuffer(t.FRAMEBUFFER,c.__webglMultisampledFramebuffer);for(let n=0;n<i.length;n++){const r=i[n];c.__webglColorRenderbuffer[n]=t.createRenderbuffer(),t.bindRenderbuffer(t.RENDERBUFFER,c.__webglColorRenderbuffer[n]);const a=s.convert(r.format,r.encoding),o=s.convert(r.type),l=G(r.internalFormat,a,o,r.encoding),u=it(e);t.renderbufferStorageMultisample(t.RENDERBUFFER,u,l,e.width,e.height),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0+n,t.RENDERBUFFER,c.__webglColorRenderbuffer[n])}t.bindRenderbuffer(t.RENDERBUFFER,null),e.depthBuffer&&(c.__webglDepthRenderbuffer=t.createRenderbuffer(),et(c.__webglDepthRenderbuffer,e,!0)),n.bindFramebuffer(t.FRAMEBUFFER,null)}}if(h){n.bindTexture(t.TEXTURE_CUBE_MAP,u.__webglTexture),K(t.TEXTURE_CUBE_MAP,l,p);for(let n=0;n<6;n++)tt(c.__webglFramebuffer[n],e,l,t.COLOR_ATTACHMENT0,t.TEXTURE_CUBE_MAP_POSITIVE_X+n);z(l,p)&&k(t.TEXTURE_CUBE_MAP),n.unbindTexture()}else if(d){const r=e.texture;for(let s=0,a=r.length;s<a;s++){const a=r[s],o=i.get(a);n.bindTexture(t.TEXTURE_2D,o.__webglTexture),K(t.TEXTURE_2D,a,p),tt(c.__webglFramebuffer,e,a,t.COLOR_ATTACHMENT0+s,t.TEXTURE_2D),z(a,p)&&k(t.TEXTURE_2D)}n.unbindTexture()}else{let i=t.TEXTURE_2D;(e.isWebGL3DRenderTarget||e.isWebGLArrayRenderTarget)&&(o?i=e.isWebGL3DRenderTarget?t.TEXTURE_3D:t.TEXTURE_2D_ARRAY:console.error("THREE.WebGLTextures: THREE.Data3DTexture and THREE.DataArrayTexture only supported with WebGL2.")),n.bindTexture(i,u.__webglTexture),K(i,l,p),tt(c.__webglFramebuffer,e,l,t.COLOR_ATTACHMENT0,i),z(l,p)&&k(i),n.unbindTexture()}e.depthBuffer&&nt(e)},this.updateRenderTargetMipmap=function(e){const r=B(e)||o,s=!0===e.isWebGLMultipleRenderTargets?e.texture:[e.texture];for(let a=0,o=s.length;a<o;a++){const o=s[a];if(z(o,r)){const r=e.isWebGLCubeRenderTarget?t.TEXTURE_CUBE_MAP:t.TEXTURE_2D,s=i.get(o).__webglTexture;n.bindTexture(r,s),k(r),n.unbindTexture()}}},this.updateMultisampleRenderTarget=function(e){if(o&&e.samples>0&&!1===rt(e)){const r=e.isWebGLMultipleRenderTargets?e.texture:[e.texture],s=e.width,a=e.height;let o=t.COLOR_BUFFER_BIT;const l=[],c=e.stencilBuffer?t.DEPTH_STENCIL_ATTACHMENT:t.DEPTH_ATTACHMENT,u=i.get(e),h=!0===e.isWebGLMultipleRenderTargets;if(h)for(let e=0;e<r.length;e++)n.bindFramebuffer(t.FRAMEBUFFER,u.__webglMultisampledFramebuffer),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0+e,t.RENDERBUFFER,null),n.bindFramebuffer(t.FRAMEBUFFER,u.__webglFramebuffer),t.framebufferTexture2D(t.DRAW_FRAMEBUFFER,t.COLOR_ATTACHMENT0+e,t.TEXTURE_2D,null,0);n.bindFramebuffer(t.READ_FRAMEBUFFER,u.__webglMultisampledFramebuffer),n.bindFramebuffer(t.DRAW_FRAMEBUFFER,u.__webglFramebuffer);for(let n=0;n<r.length;n++){l.push(t.COLOR_ATTACHMENT0+n),e.depthBuffer&&l.push(c);const d=void 0!==u.__ignoreDepthValues&&u.__ignoreDepthValues;if(!1===d&&(e.depthBuffer&&(o|=t.DEPTH_BUFFER_BIT),e.stencilBuffer&&(o|=t.STENCIL_BUFFER_BIT)),h&&t.framebufferRenderbuffer(t.READ_FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.RENDERBUFFER,u.__webglColorRenderbuffer[n]),!0===d&&(t.invalidateFramebuffer(t.READ_FRAMEBUFFER,[c]),t.invalidateFramebuffer(t.DRAW_FRAMEBUFFER,[c])),h){const e=i.get(r[n]).__webglTexture;t.framebufferTexture2D(t.DRAW_FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0)}t.blitFramebuffer(0,0,s,a,0,0,s,a,o,t.NEAREST),P&&t.invalidateFramebuffer(t.READ_FRAMEBUFFER,l)}if(n.bindFramebuffer(t.READ_FRAMEBUFFER,null),n.bindFramebuffer(t.DRAW_FRAMEBUFFER,null),h)for(let e=0;e<r.length;e++){n.bindFramebuffer(t.FRAMEBUFFER,u.__webglMultisampledFramebuffer),t.framebufferRenderbuffer(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0+e,t.RENDERBUFFER,u.__webglColorRenderbuffer[e]);const s=i.get(r[e]).__webglTexture;n.bindFramebuffer(t.FRAMEBUFFER,u.__webglFramebuffer),t.framebufferTexture2D(t.DRAW_FRAMEBUFFER,t.COLOR_ATTACHMENT0+e,t.TEXTURE_2D,s,0)}n.bindFramebuffer(t.DRAW_FRAMEBUFFER,u.__webglMultisampledFramebuffer)}},this.setupDepthRenderbuffer=nt,this.setupFrameBufferTexture=tt,this.useMultisampledRTT=rt}function zs(t,e,n){const i=n.isWebGL2;return{convert:function(n,r=null){let s;if(n===y)return t.UNSIGNED_BYTE;if(1017===n)return t.UNSIGNED_SHORT_4_4_4_4;if(1018===n)return t.UNSIGNED_SHORT_5_5_5_1;if(1010===n)return t.BYTE;if(1011===n)return t.SHORT;if(n===x)return t.UNSIGNED_SHORT;if(1013===n)return t.INT;if(n===b)return t.UNSIGNED_INT;if(n===M)return t.FLOAT;if(n===w)return i?t.HALF_FLOAT:(s=e.get("OES_texture_half_float"),null!==s?s.HALF_FLOAT_OES:null);if(1021===n)return t.ALPHA;if(n===E)return t.RGBA;if(1024===n)return t.LUMINANCE;if(1025===n)return t.LUMINANCE_ALPHA;if(n===T)return t.DEPTH_COMPONENT;if(n===A)return t.DEPTH_STENCIL;if(1028===n)return t.RED;if(1022===n)return console.warn("THREE.WebGLRenderer: THREE.RGBFormat has been removed. Use THREE.RGBAFormat instead. https://github.com/mrdoob/three.js/pull/23228"),t.RGBA;if(n===pt)return s=e.get("EXT_sRGB"),null!==s?s.SRGB_ALPHA_EXT:null;if(1029===n)return t.RED_INTEGER;if(1030===n)return t.RG;if(1031===n)return t.RG_INTEGER;if(1033===n)return t.RGBA_INTEGER;if(n===R||n===C||n===L||n===P)if(r===ot){if(s=e.get("WEBGL_compressed_texture_s3tc_srgb"),null===s)return null;if(n===R)return s.COMPRESSED_SRGB_S3TC_DXT1_EXT;if(n===C)return s.COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;if(n===L)return s.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;if(n===P)return s.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT}else{if(s=e.get("WEBGL_compressed_texture_s3tc"),null===s)return null;if(n===R)return s.COMPRESSED_RGB_S3TC_DXT1_EXT;if(n===C)return s.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(n===L)return s.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(n===P)return s.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(n===I||n===D||n===O||n===N){if(s=e.get("WEBGL_compressed_texture_pvrtc"),null===s)return null;if(n===I)return s.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(n===D)return s.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(n===O)return s.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(n===N)return s.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(36196===n)return s=e.get("WEBGL_compressed_texture_etc1"),null!==s?s.COMPRESSED_RGB_ETC1_WEBGL:null;if(n===U||n===F){if(s=e.get("WEBGL_compressed_texture_etc"),null===s)return null;if(n===U)return r===ot?s.COMPRESSED_SRGB8_ETC2:s.COMPRESSED_RGB8_ETC2;if(n===F)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:s.COMPRESSED_RGBA8_ETC2_EAC}if(n===B||n===z||n===k||n===G||n===V||n===H||n===W||n===j||n===X||n===Y||n===q||n===Z||n===J||n===K){if(s=e.get("WEBGL_compressed_texture_astc"),null===s)return null;if(n===B)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR:s.COMPRESSED_RGBA_ASTC_4x4_KHR;if(n===z)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR:s.COMPRESSED_RGBA_ASTC_5x4_KHR;if(n===k)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR:s.COMPRESSED_RGBA_ASTC_5x5_KHR;if(n===G)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR:s.COMPRESSED_RGBA_ASTC_6x5_KHR;if(n===V)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR:s.COMPRESSED_RGBA_ASTC_6x6_KHR;if(n===H)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR:s.COMPRESSED_RGBA_ASTC_8x5_KHR;if(n===W)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR:s.COMPRESSED_RGBA_ASTC_8x6_KHR;if(n===j)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR:s.COMPRESSED_RGBA_ASTC_8x8_KHR;if(n===X)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR:s.COMPRESSED_RGBA_ASTC_10x5_KHR;if(n===Y)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR:s.COMPRESSED_RGBA_ASTC_10x6_KHR;if(n===q)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR:s.COMPRESSED_RGBA_ASTC_10x8_KHR;if(n===Z)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR:s.COMPRESSED_RGBA_ASTC_10x10_KHR;if(n===J)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR:s.COMPRESSED_RGBA_ASTC_12x10_KHR;if(n===K)return r===ot?s.COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR:s.COMPRESSED_RGBA_ASTC_12x12_KHR}if(n===$){if(s=e.get("EXT_texture_compression_bptc"),null===s)return null;if(n===$)return r===ot?s.COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT:s.COMPRESSED_RGBA_BPTC_UNORM_EXT}return n===S?i?t.UNSIGNED_INT_24_8:(s=e.get("WEBGL_depth_texture"),null!==s?s.UNSIGNED_INT_24_8_WEBGL:null):void 0!==t[n]?t[n]:null}}}class ks extends ri{constructor(t=[]){super(),this.isArrayCamera=!0,this.cameras=t}}class Gs extends rn{constructor(){super(),this.isGroup=!0,this.type="Group"}}const Vs={type:"move"};class Hs{constructor(){this._targetRay=null,this._grip=null,this._hand=null}getHandSpace(){return null===this._hand&&(this._hand=new Gs,this._hand.matrixAutoUpdate=!1,this._hand.visible=!1,this._hand.joints={},this._hand.inputState={pinching:!1}),this._hand}getTargetRaySpace(){return null===this._targetRay&&(this._targetRay=new Gs,this._targetRay.matrixAutoUpdate=!1,this._targetRay.visible=!1,this._targetRay.hasLinearVelocity=!1,this._targetRay.linearVelocity=new ee,this._targetRay.hasAngularVelocity=!1,this._targetRay.angularVelocity=new ee),this._targetRay}getGripSpace(){return null===this._grip&&(this._grip=new Gs,this._grip.matrixAutoUpdate=!1,this._grip.visible=!1,this._grip.hasLinearVelocity=!1,this._grip.linearVelocity=new ee,this._grip.hasAngularVelocity=!1,this._grip.angularVelocity=new ee),this._grip}dispatchEvent(t){return null!==this._targetRay&&this._targetRay.dispatchEvent(t),null!==this._grip&&this._grip.dispatchEvent(t),null!==this._hand&&this._hand.dispatchEvent(t),this}disconnect(t){return this.dispatchEvent({type:"disconnected",data:t}),null!==this._targetRay&&(this._targetRay.visible=!1),null!==this._grip&&(this._grip.visible=!1),null!==this._hand&&(this._hand.visible=!1),this}update(t,e,n){let i=null,r=null,s=null;const a=this._targetRay,o=this._grip,l=this._hand;if(t&&"visible-blurred"!==e.session.visibilityState){if(l&&t.hand){s=!0;for(const i of t.hand.values()){const t=e.getJointPose(i,n);if(void 0===l.joints[i.jointName]){const t=new Gs;t.matrixAutoUpdate=!1,t.visible=!1,l.joints[i.jointName]=t,l.add(t)}const r=l.joints[i.jointName];null!==t&&(r.matrix.fromArray(t.transform.matrix),r.matrix.decompose(r.position,r.rotation,r.scale),r.jointRadius=t.radius),r.visible=null!==t}const i=l.joints["index-finger-tip"],r=l.joints["thumb-tip"],a=i.position.distanceTo(r.position),o=.02,c=.005;l.inputState.pinching&&a>o+c?(l.inputState.pinching=!1,this.dispatchEvent({type:"pinchend",handedness:t.handedness,target:this})):!l.inputState.pinching&&a<=o-c&&(l.inputState.pinching=!0,this.dispatchEvent({type:"pinchstart",handedness:t.handedness,target:this}))}else null!==o&&t.gripSpace&&(r=e.getPose(t.gripSpace,n),null!==r&&(o.matrix.fromArray(r.transform.matrix),o.matrix.decompose(o.position,o.rotation,o.scale),r.linearVelocity?(o.hasLinearVelocity=!0,o.linearVelocity.copy(r.linearVelocity)):o.hasLinearVelocity=!1,r.angularVelocity?(o.hasAngularVelocity=!0,o.angularVelocity.copy(r.angularVelocity)):o.hasAngularVelocity=!1));null!==a&&(i=e.getPose(t.targetRaySpace,n),null===i&&null!==r&&(i=r),null!==i&&(a.matrix.fromArray(i.transform.matrix),a.matrix.decompose(a.position,a.rotation,a.scale),i.linearVelocity?(a.hasLinearVelocity=!0,a.linearVelocity.copy(i.linearVelocity)):a.hasLinearVelocity=!1,i.angularVelocity?(a.hasAngularVelocity=!0,a.angularVelocity.copy(i.angularVelocity)):a.hasAngularVelocity=!1,this.dispatchEvent(Vs)))}return null!==a&&(a.visible=null!==i),null!==o&&(o.visible=null!==r),null!==l&&(l.visible=null!==s),this}}class Ws extends Zt{constructor(t,e,n,i,r,s,a,o,l,c){if((c=void 0!==c?c:T)!==T&&c!==A)throw new Error("DepthTexture format must be either THREE.DepthFormat or THREE.DepthStencilFormat");void 0===n&&c===T&&(n=b),void 0===n&&c===A&&(n=S),super(null,i,r,s,a,o,c,n,l),this.isDepthTexture=!0,this.image={width:t,height:e},this.magFilter=void 0!==a?a:p,this.minFilter=void 0!==o?o:p,this.flipY=!1,this.generateMipmaps=!1}}class js extends ft{constructor(t,e){super();const n=this;let i=null,r=1,s=null,a="local-floor",o=null,l=null,c=null,u=null,h=null,d=null;const p=e.getContextAttributes();let f=null,m=null;const g=[],v=[],_=new ri;_.layers.enable(1),_.viewport=new Jt;const x=new ri;x.layers.enable(2),x.viewport=new Jt;const M=[_,x],w=new ks;w.layers.enable(1),w.layers.enable(2);let R=null,C=null;function L(t){const e=v.indexOf(t.inputSource);if(-1===e)return;const n=g[e];void 0!==n&&n.dispatchEvent({type:t.type,data:t.inputSource})}function P(){i.removeEventListener("select",L),i.removeEventListener("selectstart",L),i.removeEventListener("selectend",L),i.removeEventListener("squeeze",L),i.removeEventListener("squeezestart",L),i.removeEventListener("squeezeend",L),i.removeEventListener("end",P),i.removeEventListener("inputsourceschange",I);for(let t=0;t<g.length;t++){const e=v[t];null!==e&&(v[t]=null,g[t].disconnect(e))}R=null,C=null,t.setRenderTarget(f),h=null,u=null,c=null,i=null,m=null,F.stop(),n.isPresenting=!1,n.dispatchEvent({type:"sessionend"})}function I(t){for(let e=0;e<t.removed.length;e++){const n=t.removed[e],i=v.indexOf(n);i>=0&&(v[i]=null,g[i].dispatchEvent({type:"disconnected",data:n}))}for(let e=0;e<t.added.length;e++){const n=t.added[e];let i=v.indexOf(n);if(-1===i){for(let t=0;t<g.length;t++){if(t>=v.length){v.push(n),i=t;break}if(null===v[t]){v[t]=n,i=t;break}}if(-1===i)break}const r=g[i];r&&r.dispatchEvent({type:"connected",data:n})}}this.cameraAutoUpdate=!0,this.enabled=!1,this.isPresenting=!1,this.getController=function(t){let e=g[t];return void 0===e&&(e=new Hs,g[t]=e),e.getTargetRaySpace()},this.getControllerGrip=function(t){let e=g[t];return void 0===e&&(e=new Hs,g[t]=e),e.getGripSpace()},this.getHand=function(t){let e=g[t];return void 0===e&&(e=new Hs,g[t]=e),e.getHandSpace()},this.setFramebufferScaleFactor=function(t){r=t,!0===n.isPresenting&&console.warn("THREE.WebXRManager: Cannot change framebuffer scale while presenting.")},this.setReferenceSpaceType=function(t){a=t,!0===n.isPresenting&&console.warn("THREE.WebXRManager: Cannot change reference space type while presenting.")},this.getReferenceSpace=function(){return o||s},this.setReferenceSpace=function(t){o=t},this.getBaseLayer=function(){return null!==u?u:h},this.getBinding=function(){return c},this.getFrame=function(){return d},this.getSession=function(){return i},this.setSession=async function(l){if(i=l,null!==i){if(f=t.getRenderTarget(),i.addEventListener("select",L),i.addEventListener("selectstart",L),i.addEventListener("selectend",L),i.addEventListener("squeeze",L),i.addEventListener("squeezestart",L),i.addEventListener("squeezeend",L),i.addEventListener("end",P),i.addEventListener("inputsourceschange",I),!0!==p.xrCompatible&&await e.makeXRCompatible(),void 0===i.renderState.layers||!1===t.capabilities.isWebGL2){const n={antialias:void 0!==i.renderState.layers||p.antialias,alpha:p.alpha,depth:p.depth,stencil:p.stencil,framebufferScaleFactor:r};h=new XRWebGLLayer(i,e,n),i.updateRenderState({baseLayer:h}),m=new Kt(h.framebufferWidth,h.framebufferHeight,{format:E,type:y,encoding:t.outputEncoding})}else{let n=null,s=null,a=null;p.depth&&(a=p.stencil?e.DEPTH24_STENCIL8:e.DEPTH_COMPONENT24,n=p.stencil?A:T,s=p.stencil?S:b);const o={colorFormat:e.RGBA8,depthFormat:a,scaleFactor:r};c=new XRWebGLBinding(i,e),u=c.createProjectionLayer(o),i.updateRenderState({layers:[u]}),m=new Kt(u.textureWidth,u.textureHeight,{format:E,type:y,depthTexture:new Ws(u.textureWidth,u.textureHeight,s,void 0,void 0,void 0,void 0,void 0,void 0,n),stencilBuffer:p.stencil,encoding:t.outputEncoding,samples:p.antialias?4:0}),t.properties.get(m).__ignoreDepthValues=u.ignoreDepthValues}m.isXRRenderTarget=!0,this.setFoveation(1),o=null,s=await i.requestReferenceSpace(a),F.setContext(i),F.start(),n.isPresenting=!0,n.dispatchEvent({type:"sessionstart"})}};const D=new ee,O=new ee;function N(t,e){null===e?t.matrixWorld.copy(t.matrix):t.matrixWorld.multiplyMatrices(e.matrixWorld,t.matrix),t.matrixWorldInverse.copy(t.matrixWorld).invert()}this.updateCamera=function(t){if(null===i)return;w.near=x.near=_.near=t.near,w.far=x.far=_.far=t.far,R===w.near&&C===w.far||(i.updateRenderState({depthNear:w.near,depthFar:w.far}),R=w.near,C=w.far);const e=t.parent,n=w.cameras;N(w,e);for(let t=0;t<n.length;t++)N(n[t],e);w.matrixWorld.decompose(w.position,w.quaternion,w.scale),t.position.copy(w.position),t.quaternion.copy(w.quaternion),t.scale.copy(w.scale),t.matrix.copy(w.matrix),t.matrixWorld.copy(w.matrixWorld);const r=t.children;for(let t=0,e=r.length;t<e;t++)r[t].updateMatrixWorld(!0);2===n.length?function(t,e,n){D.setFromMatrixPosition(e.matrixWorld),O.setFromMatrixPosition(n.matrixWorld);const i=D.distanceTo(O),r=e.projectionMatrix.elements,s=n.projectionMatrix.elements,a=r[14]/(r[10]-1),o=r[14]/(r[10]+1),l=(r[9]+1)/r[5],c=(r[9]-1)/r[5],u=(r[8]-1)/r[0],h=(s[8]+1)/s[0],d=a*u,p=a*h,f=i/(-u+h),m=f*-u;e.matrixWorld.decompose(t.position,t.quaternion,t.scale),t.translateX(m),t.translateZ(f),t.matrixWorld.compose(t.position,t.quaternion,t.scale),t.matrixWorldInverse.copy(t.matrixWorld).invert();const g=a+f,v=o+f,_=d-m,y=p+(i-m),x=l*o/v*g,b=c*o/v*g;t.projectionMatrix.makePerspective(_,y,x,b,g,v)}(w,_,x):w.projectionMatrix.copy(_.projectionMatrix)},this.getCamera=function(){return w},this.getFoveation=function(){return null!==u?u.fixedFoveation:null!==h?h.fixedFoveation:void 0},this.setFoveation=function(t){null!==u&&(u.fixedFoveation=t),null!==h&&void 0!==h.fixedFoveation&&(h.fixedFoveation=t)};let U=null;const F=new gi;F.setAnimationLoop((function(e,n){if(l=n.getViewerPose(o||s),d=n,null!==l){const e=l.views;null!==h&&(t.setRenderTargetFramebuffer(m,h.framebuffer),t.setRenderTarget(m));let n=!1;e.length!==w.cameras.length&&(w.cameras.length=0,n=!0);for(let i=0;i<e.length;i++){const r=e[i];let s=null;if(null!==h)s=h.getViewport(r);else{const e=c.getViewSubImage(u,r);s=e.viewport,0===i&&(t.setRenderTargetTextures(m,e.colorTexture,u.ignoreDepthValues?void 0:e.depthStencilTexture),t.setRenderTarget(m))}let a=M[i];void 0===a&&(a=new ri,a.layers.enable(i),a.viewport=new Jt,M[i]=a),a.matrix.fromArray(r.transform.matrix),a.projectionMatrix.fromArray(r.projectionMatrix),a.viewport.set(s.x,s.y,s.width,s.height),0===i&&w.matrix.copy(a.matrix),!0===n&&w.cameras.push(a)}}for(let t=0;t<g.length;t++){const e=v[t],i=g[t];null!==e&&void 0!==i&&i.update(e,n,o||s)}U&&U(e,n),d=null})),this.setAnimationLoop=function(t){U=t},this.dispose=function(){}}}function Xs(t,e){function n(n,i){n.opacity.value=i.opacity,i.color&&n.diffuse.value.copy(i.color),i.emissive&&n.emissive.value.copy(i.emissive).multiplyScalar(i.emissiveIntensity),i.map&&(n.map.value=i.map),i.alphaMap&&(n.alphaMap.value=i.alphaMap),i.bumpMap&&(n.bumpMap.value=i.bumpMap,n.bumpScale.value=i.bumpScale,1===i.side&&(n.bumpScale.value*=-1)),i.displacementMap&&(n.displacementMap.value=i.displacementMap,n.displacementScale.value=i.displacementScale,n.displacementBias.value=i.displacementBias),i.emissiveMap&&(n.emissiveMap.value=i.emissiveMap),i.normalMap&&(n.normalMap.value=i.normalMap,n.normalScale.value.copy(i.normalScale),1===i.side&&n.normalScale.value.negate()),i.specularMap&&(n.specularMap.value=i.specularMap),i.alphaTest>0&&(n.alphaTest.value=i.alphaTest);const r=e.get(i).envMap;if(r&&(n.envMap.value=r,n.flipEnvMap.value=r.isCubeTexture&&!1===r.isRenderTargetTexture?-1:1,n.reflectivity.value=i.reflectivity,n.ior.value=i.ior,n.refractionRatio.value=i.refractionRatio),i.lightMap){n.lightMap.value=i.lightMap;const e=!0!==t.physicallyCorrectLights?Math.PI:1;n.lightMapIntensity.value=i.lightMapIntensity*e}let s,a;i.aoMap&&(n.aoMap.value=i.aoMap,n.aoMapIntensity.value=i.aoMapIntensity),i.map?s=i.map:i.specularMap?s=i.specularMap:i.displacementMap?s=i.displacementMap:i.normalMap?s=i.normalMap:i.bumpMap?s=i.bumpMap:i.roughnessMap?s=i.roughnessMap:i.metalnessMap?s=i.metalnessMap:i.alphaMap?s=i.alphaMap:i.emissiveMap?s=i.emissiveMap:i.clearcoatMap?s=i.clearcoatMap:i.clearcoatNormalMap?s=i.clearcoatNormalMap:i.clearcoatRoughnessMap?s=i.clearcoatRoughnessMap:i.iridescenceMap?s=i.iridescenceMap:i.iridescenceThicknessMap?s=i.iridescenceThicknessMap:i.specularIntensityMap?s=i.specularIntensityMap:i.specularColorMap?s=i.specularColorMap:i.transmissionMap?s=i.transmissionMap:i.thicknessMap?s=i.thicknessMap:i.sheenColorMap?s=i.sheenColorMap:i.sheenRoughnessMap&&(s=i.sheenRoughnessMap),void 0!==s&&(s.isWebGLRenderTarget&&(s=s.texture),!0===s.matrixAutoUpdate&&s.updateMatrix(),n.uvTransform.value.copy(s.matrix)),i.aoMap?a=i.aoMap:i.lightMap&&(a=i.lightMap),void 0!==a&&(a.isWebGLRenderTarget&&(a=a.texture),!0===a.matrixAutoUpdate&&a.updateMatrix(),n.uv2Transform.value.copy(a.matrix))}return{refreshFogUniforms:function(t,e){t.fogColor.value.copy(e.color),e.isFog?(t.fogNear.value=e.near,t.fogFar.value=e.far):e.isFogExp2&&(t.fogDensity.value=e.density)},refreshMaterialUniforms:function(t,i,r,s,a){i.isMeshBasicMaterial||i.isMeshLambertMaterial?n(t,i):i.isMeshToonMaterial?(n(t,i),function(t,e){e.gradientMap&&(t.gradientMap.value=e.gradientMap)}(t,i)):i.isMeshPhongMaterial?(n(t,i),function(t,e){t.specular.value.copy(e.specular),t.shininess.value=Math.max(e.shininess,1e-4)}(t,i)):i.isMeshStandardMaterial?(n(t,i),function(t,n){t.roughness.value=n.roughness,t.metalness.value=n.metalness,n.roughnessMap&&(t.roughnessMap.value=n.roughnessMap),n.metalnessMap&&(t.metalnessMap.value=n.metalnessMap),e.get(n).envMap&&(t.envMapIntensity.value=n.envMapIntensity)}(t,i),i.isMeshPhysicalMaterial&&function(t,e,n){t.ior.value=e.ior,e.sheen>0&&(t.sheenColor.value.copy(e.sheenColor).multiplyScalar(e.sheen),t.sheenRoughness.value=e.sheenRoughness,e.sheenColorMap&&(t.sheenColorMap.value=e.sheenColorMap),e.sheenRoughnessMap&&(t.sheenRoughnessMap.value=e.sheenRoughnessMap)),e.clearcoat>0&&(t.clearcoat.value=e.clearcoat,t.clearcoatRoughness.value=e.clearcoatRoughness,e.clearcoatMap&&(t.clearcoatMap.value=e.clearcoatMap),e.clearcoatRoughnessMap&&(t.clearcoatRoughnessMap.value=e.clearcoatRoughnessMap),e.clearcoatNormalMap&&(t.clearcoatNormalScale.value.copy(e.clearcoatNormalScale),t.clearcoatNormalMap.value=e.clearcoatNormalMap,1===e.side&&t.clearcoatNormalScale.value.negate())),e.iridescence>0&&(t.iridescence.value=e.iridescence,t.iridescenceIOR.value=e.iridescenceIOR,t.iridescenceThicknessMinimum.value=e.iridescenceThicknessRange[0],t.iridescenceThicknessMaximum.value=e.iridescenceThicknessRange[1],e.iridescenceMap&&(t.iridescenceMap.value=e.iridescenceMap),e.iridescenceThicknessMap&&(t.iridescenceThicknessMap.value=e.iridescenceThicknessMap)),e.transmission>0&&(t.transmission.value=e.transmission,t.transmissionSamplerMap.value=n.texture,t.transmissionSamplerSize.value.set(n.width,n.height),e.transmissionMap&&(t.transmissionMap.value=e.transmissionMap),t.thickness.value=e.thickness,e.thicknessMap&&(t.thicknessMap.value=e.thicknessMap),t.attenuationDistance.value=e.attenuationDistance,t.attenuationColor.value.copy(e.attenuationColor)),t.specularIntensity.value=e.specularIntensity,t.specularColor.value.copy(e.specularColor),e.specularIntensityMap&&(t.specularIntensityMap.value=e.specularIntensityMap),e.specularColorMap&&(t.specularColorMap.value=e.specularColorMap)}(t,i,a)):i.isMeshMatcapMaterial?(n(t,i),function(t,e){e.matcap&&(t.matcap.value=e.matcap)}(t,i)):i.isMeshDepthMaterial?n(t,i):i.isMeshDistanceMaterial?(n(t,i),function(t,e){t.referencePosition.value.copy(e.referencePosition),t.nearDistance.value=e.nearDistance,t.farDistance.value=e.farDistance}(t,i)):i.isMeshNormalMaterial?n(t,i):i.isLineBasicMaterial?(function(t,e){t.diffuse.value.copy(e.color),t.opacity.value=e.opacity}(t,i),i.isLineDashedMaterial&&function(t,e){t.dashSize.value=e.dashSize,t.totalSize.value=e.dashSize+e.gapSize,t.scale.value=e.scale}(t,i)):i.isPointsMaterial?function(t,e,n,i){let r;t.diffuse.value.copy(e.color),t.opacity.value=e.opacity,t.size.value=e.size*n,t.scale.value=.5*i,e.map&&(t.map.value=e.map),e.alphaMap&&(t.alphaMap.value=e.alphaMap),e.alphaTest>0&&(t.alphaTest.value=e.alphaTest),e.map?r=e.map:e.alphaMap&&(r=e.alphaMap),void 0!==r&&(!0===r.matrixAutoUpdate&&r.updateMatrix(),t.uvTransform.value.copy(r.matrix))}(t,i,r,s):i.isSpriteMaterial?function(t,e){let n;t.diffuse.value.copy(e.color),t.opacity.value=e.opacity,t.rotation.value=e.rotation,e.map&&(t.map.value=e.map),e.alphaMap&&(t.alphaMap.value=e.alphaMap),e.alphaTest>0&&(t.alphaTest.value=e.alphaTest),e.map?n=e.map:e.alphaMap&&(n=e.alphaMap),void 0!==n&&(!0===n.matrixAutoUpdate&&n.updateMatrix(),t.uvTransform.value.copy(n.matrix))}(t,i):i.isShadowMaterial?(t.color.value.copy(i.color),t.opacity.value=i.opacity):i.isShaderMaterial&&(i.uniformsNeedUpdate=!1)}}}function Ys(t={}){this.isWebGLRenderer=!0;const e=void 0!==t.canvas?t.canvas:function(){const t=It("canvas");return t.style.display="block",t}(),n=void 0!==t.context?t.context:null,i=void 0===t.depth||t.depth,r=void 0===t.stencil||t.stencil,s=void 0!==t.antialias&&t.antialias,a=void 0===t.premultipliedAlpha||t.premultipliedAlpha,o=void 0!==t.preserveDrawingBuffer&&t.preserveDrawingBuffer,l=void 0!==t.powerPreference?t.powerPreference:"default",c=void 0!==t.failIfMajorPerformanceCaveat&&t.failIfMajorPerformanceCaveat;let u;u=null!==n?n.getContextAttributes().alpha:void 0!==t.alpha&&t.alpha;let h=null,d=null;const p=[],f=[];this.domElement=e,this.debug={checkShaderErrors:!0},this.autoClear=!0,this.autoClearColor=!0,this.autoClearDepth=!0,this.autoClearStencil=!0,this.sortObjects=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.outputEncoding=at,this.physicallyCorrectLights=!1,this.toneMapping=0,this.toneMappingExposure=1,Object.defineProperties(this,{gammaFactor:{get:function(){return console.warn("THREE.WebGLRenderer: .gammaFactor has been removed."),2},set:function(){console.warn("THREE.WebGLRenderer: .gammaFactor has been removed.")}}});const m=this;let g=!1,v=0,x=0,b=null,S=-1,T=null;const A=new Jt,R=new Jt;let C=null,L=e.width,P=e.height,I=1,D=null,O=null;const N=new Jt(0,0,L,P),U=new Jt(0,0,L,P);let F=!1;const B=new mi;let z=!1,k=!1,G=null;const V=new Ie,H=new At,W=new ee,j={background:null,fog:null,environment:null,overrideMaterial:null,isScene:!0};function X(){return null===b?I:1}let Y,q,Z,J,K,$,Q,tt,et,nt,it,rt,st,ot,lt,ct,ut,ht,dt,pt,ft,mt,gt,vt=n;function _t(t,n){for(let i=0;i<t.length;i++){const r=t[i],s=e.getContext(r,n);if(null!==s)return s}return null}try{const t={alpha:!0,depth:i,stencil:r,antialias:s,premultipliedAlpha:a,preserveDrawingBuffer:o,powerPreference:l,failIfMajorPerformanceCaveat:c};if("setAttribute"in e&&e.setAttribute("data-engine","three.js r142"),e.addEventListener("webglcontextlost",bt,!1),e.addEventListener("webglcontextrestored",Mt,!1),e.addEventListener("webglcontextcreationerror",wt,!1),null===vt){const e=["webgl2","webgl","experimental-webgl"];if(!0===m.isWebGL1Renderer&&e.shift(),vt=_t(e,t),null===vt)throw _t(e)?new Error("Error creating WebGL context with your selected attributes."):new Error("Error creating WebGL context.")}void 0===vt.getShaderPrecisionFormat&&(vt.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}})}catch(t){throw console.error("THREE.WebGLRenderer: "+t.message),t}function yt(){Y=new Vi(vt),q=new Ei(vt,Y,t),Y.init(q),mt=new zs(vt,Y,q),Z=new Fs(vt,Y,q),J=new ji(vt),K=new ws,$=new Bs(vt,Y,Z,K,q,mt,J),Q=new Ai(m),tt=new Gi(m),et=new vi(vt,q),gt=new wi(vt,Y,et,q),nt=new Hi(vt,et,J,gt),it=new Ji(vt,nt,et,J),dt=new Zi(vt,q,$),ct=new Ti(K),rt=new Ms(m,Q,tt,Y,q,gt,ct),st=new Xs(m,K),ot=new As,lt=new Ds(Y,q),ht=new Mi(m,Q,Z,it,u,a),ut=new Us(m,it,q),pt=new Si(vt,Y,J,q),ft=new Wi(vt,Y,J,q),J.programs=rt.programs,m.capabilities=q,m.extensions=Y,m.properties=K,m.renderLists=ot,m.shadowMap=ut,m.state=Z,m.info=J}yt();const xt=new js(m,vt);function bt(t){t.preventDefault(),console.log("THREE.WebGLRenderer: Context Lost."),g=!0}function Mt(){console.log("THREE.WebGLRenderer: Context Restored."),g=!1;const t=J.autoReset,e=ut.enabled,n=ut.autoUpdate,i=ut.needsUpdate,r=ut.type;yt(),J.autoReset=t,ut.enabled=e,ut.autoUpdate=n,ut.needsUpdate=i,ut.type=r}function wt(t){console.error("THREE.WebGLRenderer: A WebGL context could not be created. Reason: ",t.statusMessage)}function St(t){const e=t.target;e.removeEventListener("dispose",St),function(t){(function(t){const e=K.get(t).programs;void 0!==e&&(e.forEach((function(t){rt.releaseProgram(t)})),t.isShaderMaterial&&rt.releaseShaderCache(t))})(t),K.remove(t)}(e)}this.xr=xt,this.getContext=function(){return vt},this.getContextAttributes=function(){return vt.getContextAttributes()},this.forceContextLoss=function(){const t=Y.get("WEBGL_lose_context");t&&t.loseContext()},this.forceContextRestore=function(){const t=Y.get("WEBGL_lose_context");t&&t.restoreContext()},this.getPixelRatio=function(){return I},this.setPixelRatio=function(t){void 0!==t&&(I=t,this.setSize(L,P,!1))},this.getSize=function(t){return t.set(L,P)},this.setSize=function(t,n,i){xt.isPresenting?console.warn("THREE.WebGLRenderer: Can't change size while VR device is presenting."):(L=t,P=n,e.width=Math.floor(t*I),e.height=Math.floor(n*I),!1!==i&&(e.style.width=t+"px",e.style.height=n+"px"),this.setViewport(0,0,t,n))},this.getDrawingBufferSize=function(t){return t.set(L*I,P*I).floor()},this.setDrawingBufferSize=function(t,n,i){L=t,P=n,I=i,e.width=Math.floor(t*i),e.height=Math.floor(n*i),this.setViewport(0,0,t,n)},this.getCurrentViewport=function(t){return t.copy(A)},this.getViewport=function(t){return t.copy(N)},this.setViewport=function(t,e,n,i){t.isVector4?N.set(t.x,t.y,t.z,t.w):N.set(t,e,n,i),Z.viewport(A.copy(N).multiplyScalar(I).floor())},this.getScissor=function(t){return t.copy(U)},this.setScissor=function(t,e,n,i){t.isVector4?U.set(t.x,t.y,t.z,t.w):U.set(t,e,n,i),Z.scissor(R.copy(U).multiplyScalar(I).floor())},this.getScissorTest=function(){return F},this.setScissorTest=function(t){Z.setScissorTest(F=t)},this.setOpaqueSort=function(t){D=t},this.setTransparentSort=function(t){O=t},this.getClearColor=function(t){return t.copy(ht.getClearColor())},this.setClearColor=function(){ht.setClearColor.apply(ht,arguments)},this.getClearAlpha=function(){return ht.getClearAlpha()},this.setClearAlpha=function(){ht.setClearAlpha.apply(ht,arguments)},this.clear=function(t=!0,e=!0,n=!0){let i=0;t&&(i|=vt.COLOR_BUFFER_BIT),e&&(i|=vt.DEPTH_BUFFER_BIT),n&&(i|=vt.STENCIL_BUFFER_BIT),vt.clear(i)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.dispose=function(){e.removeEventListener("webglcontextlost",bt,!1),e.removeEventListener("webglcontextrestored",Mt,!1),e.removeEventListener("webglcontextcreationerror",wt,!1),ot.dispose(),lt.dispose(),K.dispose(),Q.dispose(),tt.dispose(),it.dispose(),gt.dispose(),rt.dispose(),xt.dispose(),xt.removeEventListener("sessionstart",Rt),xt.removeEventListener("sessionend",Ct),G&&(G.dispose(),G=null),Lt.stop()},this.renderBufferDirect=function(t,e,n,i,r,s){null===e&&(e=j);const a=r.isMesh&&r.matrixWorld.determinant()<0,o=function(t,e,n,i,r){!0!==e.isScene&&(e=j),$.resetTextureUnits();const s=e.fog,a=i.isMeshStandardMaterial?e.environment:null,o=null===b?m.outputEncoding:!0===b.isXRRenderTarget?b.texture.encoding:at,l=(i.isMeshStandardMaterial?tt:Q).get(i.envMap||a),c=!0===i.vertexColors&&!!n.attributes.color&&4===n.attributes.color.itemSize,u=!!i.normalMap&&!!n.attributes.tangent,h=!!n.morphAttributes.position,p=!!n.morphAttributes.normal,f=!!n.morphAttributes.color,g=i.toneMapped?m.toneMapping:0,v=n.morphAttributes.position||n.morphAttributes.normal||n.morphAttributes.color,_=void 0!==v?v.length:0,y=K.get(i),x=d.state.lights;if(!0===z&&(!0===k||t!==T)){const e=t===T&&i.id===S;ct.setState(i,t,e)}let M=!1;i.version===y.__version?y.needsLights&&y.lightsStateVersion!==x.state.version||y.outputEncoding!==o||r.isInstancedMesh&&!1===y.instancing?M=!0:r.isInstancedMesh||!0!==y.instancing?r.isSkinnedMesh&&!1===y.skinning?M=!0:r.isSkinnedMesh||!0!==y.skinning?y.envMap!==l||!0===i.fog&&y.fog!==s?M=!0:void 0===y.numClippingPlanes||y.numClippingPlanes===ct.numPlanes&&y.numIntersection===ct.numIntersection?(y.vertexAlphas!==c||y.vertexTangents!==u||y.morphTargets!==h||y.morphNormals!==p||y.morphColors!==f||y.toneMapping!==g||!0===q.isWebGL2&&y.morphTargetsCount!==_)&&(M=!0):M=!0:M=!0:M=!0:(M=!0,y.__version=i.version);let w=y.currentProgram;!0===M&&(w=Ut(i,e,r));let E=!1,A=!1,R=!1;const C=w.getUniforms(),L=y.uniforms;if(Z.useProgram(w.program)&&(E=!0,A=!0,R=!0),i.id!==S&&(S=i.id,A=!0),E||T!==t){if(C.setValue(vt,"projectionMatrix",t.projectionMatrix),q.logarithmicDepthBuffer&&C.setValue(vt,"logDepthBufFC",2/(Math.log(t.far+1)/Math.LN2)),T!==t&&(T=t,A=!0,R=!0),i.isShaderMaterial||i.isMeshPhongMaterial||i.isMeshToonMaterial||i.isMeshStandardMaterial||i.envMap){const e=C.map.cameraPosition;void 0!==e&&e.setValue(vt,W.setFromMatrixPosition(t.matrixWorld))}(i.isMeshPhongMaterial||i.isMeshToonMaterial||i.isMeshLambertMaterial||i.isMeshBasicMaterial||i.isMeshStandardMaterial||i.isShaderMaterial)&&C.setValue(vt,"isOrthographic",!0===t.isOrthographicCamera),(i.isMeshPhongMaterial||i.isMeshToonMaterial||i.isMeshLambertMaterial||i.isMeshBasicMaterial||i.isMeshStandardMaterial||i.isShaderMaterial||i.isShadowMaterial||r.isSkinnedMesh)&&C.setValue(vt,"viewMatrix",t.matrixWorldInverse)}if(r.isSkinnedMesh){C.setOptional(vt,r,"bindMatrix"),C.setOptional(vt,r,"bindMatrixInverse");const t=r.skeleton;t&&(q.floatVertexTextures?(null===t.boneTexture&&t.computeBoneTexture(),C.setValue(vt,"boneTexture",t.boneTexture,$),C.setValue(vt,"boneTextureSize",t.boneTextureSize)):console.warn("THREE.WebGLRenderer: SkinnedMesh can only be used with WebGL 2. With WebGL 1 OES_texture_float and vertex textures support is required."))}const D=n.morphAttributes;var O,N;return(void 0!==D.position||void 0!==D.normal||void 0!==D.color&&!0===q.isWebGL2)&&dt.update(r,n,i,w),(A||y.receiveShadow!==r.receiveShadow)&&(y.receiveShadow=r.receiveShadow,C.setValue(vt,"receiveShadow",r.receiveShadow)),A&&(C.setValue(vt,"toneMappingExposure",m.toneMappingExposure),y.needsLights&&(N=R,(O=L).ambientLightColor.needsUpdate=N,O.lightProbe.needsUpdate=N,O.directionalLights.needsUpdate=N,O.directionalLightShadows.needsUpdate=N,O.pointLights.needsUpdate=N,O.pointLightShadows.needsUpdate=N,O.spotLights.needsUpdate=N,O.spotLightShadows.needsUpdate=N,O.rectAreaLights.needsUpdate=N,O.hemisphereLights.needsUpdate=N),s&&!0===i.fog&&st.refreshFogUniforms(L,s),st.refreshMaterialUniforms(L,i,I,P,G),ts.upload(vt,y.uniformsList,L,$)),i.isShaderMaterial&&!0===i.uniformsNeedUpdate&&(ts.upload(vt,y.uniformsList,L,$),i.uniformsNeedUpdate=!1),i.isSpriteMaterial&&C.setValue(vt,"center",r.center),C.setValue(vt,"modelViewMatrix",r.modelViewMatrix),C.setValue(vt,"normalMatrix",r.normalMatrix),C.setValue(vt,"modelMatrix",r.matrixWorld),w}(t,e,n,i,r);Z.setMaterial(i,a);let l=n.index;const c=n.attributes.position;if(null===l){if(void 0===c||0===c.count)return}else if(0===l.count)return;let u,h=1;!0===i.wireframe&&(l=nt.getWireframeAttribute(n),h=2),gt.setup(r,i,o,n,l);let p=pt;null!==l&&(u=et.get(l),p=ft,p.setIndex(u));const f=null!==l?l.count:c.count,g=n.drawRange.start*h,v=n.drawRange.count*h,_=null!==s?s.start*h:0,y=null!==s?s.count*h:1/0,x=Math.max(g,_),M=Math.min(f,g+v,_+y)-1,w=Math.max(0,M-x+1);if(0!==w){if(r.isMesh)!0===i.wireframe?(Z.setLineWidth(i.wireframeLinewidth*X()),p.setMode(vt.LINES)):p.setMode(vt.TRIANGLES);else if(r.isLine){let t=i.linewidth;void 0===t&&(t=1),Z.setLineWidth(t*X()),r.isLineSegments?p.setMode(vt.LINES):r.isLineLoop?p.setMode(vt.LINE_LOOP):p.setMode(vt.LINE_STRIP)}else r.isPoints?p.setMode(vt.POINTS):r.isSprite&&p.setMode(vt.TRIANGLES);if(r.isInstancedMesh)p.renderInstances(x,w,r.count);else if(n.isInstancedBufferGeometry){const t=Math.min(n.instanceCount,n._maxInstanceCount);p.renderInstances(x,w,t)}else p.render(x,w)}},this.compile=function(t,e){d=lt.get(t),d.init(),f.push(d),t.traverseVisible((function(t){t.isLight&&t.layers.test(e.layers)&&(d.pushLight(t),t.castShadow&&d.pushShadow(t))})),d.setupLights(m.physicallyCorrectLights),t.traverse((function(e){const n=e.material;if(n)if(Array.isArray(n))for(let i=0;i<n.length;i++)Ut(n[i],t,e);else Ut(n,t,e)})),f.pop(),d=null};let Tt=null;function Rt(){Lt.stop()}function Ct(){Lt.start()}const Lt=new gi;function Pt(t,e,n,i){if(!1===t.visible)return;if(t.layers.test(e.layers))if(t.isGroup)n=t.renderOrder;else if(t.isLOD)!0===t.autoUpdate&&t.update(e);else if(t.isLight)d.pushLight(t),t.castShadow&&d.pushShadow(t);else if(t.isSprite){if(!t.frustumCulled||B.intersectsSprite(t)){i&&W.setFromMatrixPosition(t.matrixWorld).applyMatrix4(V);const e=it.update(t),r=t.material;r.visible&&h.push(t,e,r,n,W.z,null)}}else if((t.isMesh||t.isLine||t.isPoints)&&(t.isSkinnedMesh&&t.skeleton.frame!==J.render.frame&&(t.skeleton.update(),t.skeleton.frame=J.render.frame),!t.frustumCulled||B.intersectsObject(t))){i&&W.setFromMatrixPosition(t.matrixWorld).applyMatrix4(V);const e=it.update(t),r=t.material;if(Array.isArray(r)){const i=e.groups;for(let s=0,a=i.length;s<a;s++){const a=i[s],o=r[a.materialIndex];o&&o.visible&&h.push(t,e,o,n,W.z,a)}}else r.visible&&h.push(t,e,r,n,W.z,null)}const r=t.children;for(let t=0,s=r.length;t<s;t++)Pt(r[t],e,n,i)}function Dt(t,e,n,i){const r=t.opaque,a=t.transmissive,o=t.transparent;d.setupLightsView(n),a.length>0&&function(t,e,n){const i=q.isWebGL2;null===G&&(G=new Kt(1,1,{generateMipmaps:!0,type:Y.has("EXT_color_buffer_half_float")?w:y,minFilter:_,samples:i&&!0===s?4:0})),m.getDrawingBufferSize(H),i?G.setSize(H.x,H.y):G.setSize(Et(H.x),Et(H.y));const r=m.getRenderTarget();m.setRenderTarget(G),m.clear();const a=m.toneMapping;m.toneMapping=0,Ot(t,e,n),m.toneMapping=a,$.updateMultisampleRenderTarget(G),$.updateRenderTargetMipmap(G),m.setRenderTarget(r)}(r,e,n),i&&Z.viewport(A.copy(i)),r.length>0&&Ot(r,e,n),a.length>0&&Ot(a,e,n),o.length>0&&Ot(o,e,n),Z.buffers.depth.setTest(!0),Z.buffers.depth.setMask(!0),Z.buffers.color.setMask(!0),Z.setPolygonOffset(!1)}function Ot(t,e,n){const i=!0===e.isScene?e.overrideMaterial:null;for(let r=0,s=t.length;r<s;r++){const s=t[r],a=s.object,o=s.geometry,l=null===i?s.material:i,c=s.group;a.layers.test(n.layers)&&Nt(a,e,n,o,l,c)}}function Nt(t,e,n,i,r,s){t.onBeforeRender(m,e,n,i,r,s),t.modelViewMatrix.multiplyMatrices(n.matrixWorldInverse,t.matrixWorld),t.normalMatrix.getNormalMatrix(t.modelViewMatrix),r.onBeforeRender(m,e,n,i,t,s),!0===r.transparent&&2===r.side?(r.side=1,r.needsUpdate=!0,m.renderBufferDirect(n,e,i,r,t,s),r.side=0,r.needsUpdate=!0,m.renderBufferDirect(n,e,i,r,t,s),r.side=2):m.renderBufferDirect(n,e,i,r,t,s),t.onAfterRender(m,e,n,i,r,s)}function Ut(t,e,n){!0!==e.isScene&&(e=j);const i=K.get(t),r=d.state.lights,s=d.state.shadowsArray,a=r.state.version,o=rt.getParameters(t,r.state,s,e,n),l=rt.getProgramCacheKey(o);let c=i.programs;i.environment=t.isMeshStandardMaterial?e.environment:null,i.fog=e.fog,i.envMap=(t.isMeshStandardMaterial?tt:Q).get(t.envMap||i.environment),void 0===c&&(t.addEventListener("dispose",St),c=new Map,i.programs=c);let u=c.get(l);if(void 0!==u){if(i.currentProgram===u&&i.lightsStateVersion===a)return Ft(t,o),u}else o.uniforms=rt.getUniforms(t),t.onBuild(n,o,m),t.onBeforeCompile(o,m),u=rt.acquireProgram(o,l),c.set(l,u),i.uniforms=o.uniforms;const h=i.uniforms;(t.isShaderMaterial||t.isRawShaderMaterial)&&!0!==t.clipping||(h.clippingPlanes=ct.uniform),Ft(t,o),i.needsLights=function(t){return t.isMeshLambertMaterial||t.isMeshToonMaterial||t.isMeshPhongMaterial||t.isMeshStandardMaterial||t.isShadowMaterial||t.isShaderMaterial&&!0===t.lights}(t),i.lightsStateVersion=a,i.needsLights&&(h.ambientLightColor.value=r.state.ambient,h.lightProbe.value=r.state.probe,h.directionalLights.value=r.state.directional,h.directionalLightShadows.value=r.state.directionalShadow,h.spotLights.value=r.state.spot,h.spotLightShadows.value=r.state.spotShadow,h.rectAreaLights.value=r.state.rectArea,h.ltc_1.value=r.state.rectAreaLTC1,h.ltc_2.value=r.state.rectAreaLTC2,h.pointLights.value=r.state.point,h.pointLightShadows.value=r.state.pointShadow,h.hemisphereLights.value=r.state.hemi,h.directionalShadowMap.value=r.state.directionalShadowMap,h.directionalShadowMatrix.value=r.state.directionalShadowMatrix,h.spotShadowMap.value=r.state.spotShadowMap,h.spotShadowMatrix.value=r.state.spotShadowMatrix,h.pointShadowMap.value=r.state.pointShadowMap,h.pointShadowMatrix.value=r.state.pointShadowMatrix);const p=u.getUniforms(),f=ts.seqWithValue(p.seq,h);return i.currentProgram=u,i.uniformsList=f,u}function Ft(t,e){const n=K.get(t);n.outputEncoding=e.outputEncoding,n.instancing=e.instancing,n.skinning=e.skinning,n.morphTargets=e.morphTargets,n.morphNormals=e.morphNormals,n.morphColors=e.morphColors,n.morphTargetsCount=e.morphTargetsCount,n.numClippingPlanes=e.numClippingPlanes,n.numIntersection=e.numClipIntersection,n.vertexAlphas=e.vertexAlphas,n.vertexTangents=e.vertexTangents,n.toneMapping=e.toneMapping}Lt.setAnimationLoop((function(t){Tt&&Tt(t)})),"undefined"!=typeof self&&Lt.setContext(self),this.setAnimationLoop=function(t){Tt=t,xt.setAnimationLoop(t),null===t?Lt.stop():Lt.start()},xt.addEventListener("sessionstart",Rt),xt.addEventListener("sessionend",Ct),this.render=function(t,e){if(void 0!==e&&!0!==e.isCamera)return void console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.");if(!0===g)return;!0===t.autoUpdate&&t.updateMatrixWorld(),null===e.parent&&e.updateMatrixWorld(),!0===xt.enabled&&!0===xt.isPresenting&&(!0===xt.cameraAutoUpdate&&xt.updateCamera(e),e=xt.getCamera()),!0===t.isScene&&t.onBeforeRender(m,t,e,b),d=lt.get(t,f.length),d.init(),f.push(d),V.multiplyMatrices(e.projectionMatrix,e.matrixWorldInverse),B.setFromProjectionMatrix(V),k=this.localClippingEnabled,z=ct.init(this.clippingPlanes,k,e),h=ot.get(t,p.length),h.init(),p.push(h),Pt(t,e,0,m.sortObjects),h.finish(),!0===m.sortObjects&&h.sort(D,O),!0===z&&ct.beginShadows();const n=d.state.shadowsArray;if(ut.render(n,t,e),!0===z&&ct.endShadows(),!0===this.info.autoReset&&this.info.reset(),ht.render(h,t),d.setupLights(m.physicallyCorrectLights),e.isArrayCamera){const n=e.cameras;for(let e=0,i=n.length;e<i;e++){const i=n[e];Dt(h,t,i,i.viewport)}}else Dt(h,t,e);null!==b&&($.updateMultisampleRenderTarget(b),$.updateRenderTargetMipmap(b)),!0===t.isScene&&t.onAfterRender(m,t,e),gt.resetDefaultState(),S=-1,T=null,f.pop(),d=f.length>0?f[f.length-1]:null,p.pop(),h=p.length>0?p[p.length-1]:null},this.getActiveCubeFace=function(){return v},this.getActiveMipmapLevel=function(){return x},this.getRenderTarget=function(){return b},this.setRenderTargetTextures=function(t,e,n){K.get(t.texture).__webglTexture=e,K.get(t.depthTexture).__webglTexture=n;const i=K.get(t);i.__hasExternalTextures=!0,i.__hasExternalTextures&&(i.__autoAllocateDepthBuffer=void 0===n,i.__autoAllocateDepthBuffer||!0===Y.has("WEBGL_multisampled_render_to_texture")&&(console.warn("THREE.WebGLRenderer: Render-to-texture extension was disabled because an external texture was provided"),i.__useRenderToTexture=!1))},this.setRenderTargetFramebuffer=function(t,e){const n=K.get(t);n.__webglFramebuffer=e,n.__useDefaultFramebuffer=void 0===e},this.setRenderTarget=function(t,e=0,n=0){b=t,v=e,x=n;let i=!0;if(t){const e=K.get(t);void 0!==e.__useDefaultFramebuffer?(Z.bindFramebuffer(vt.FRAMEBUFFER,null),i=!1):void 0===e.__webglFramebuffer?$.setupRenderTarget(t):e.__hasExternalTextures&&$.rebindTextures(t,K.get(t.texture).__webglTexture,K.get(t.depthTexture).__webglTexture)}let r=null,s=!1,a=!1;if(t){const n=t.texture;(n.isData3DTexture||n.isDataArrayTexture)&&(a=!0);const i=K.get(t).__webglFramebuffer;t.isWebGLCubeRenderTarget?(r=i[e],s=!0):r=q.isWebGL2&&t.samples>0&&!1===$.useMultisampledRTT(t)?K.get(t).__webglMultisampledFramebuffer:i,A.copy(t.viewport),R.copy(t.scissor),C=t.scissorTest}else A.copy(N).multiplyScalar(I).floor(),R.copy(U).multiplyScalar(I).floor(),C=F;if(Z.bindFramebuffer(vt.FRAMEBUFFER,r)&&q.drawBuffers&&i&&Z.drawBuffers(t,r),Z.viewport(A),Z.scissor(R),Z.setScissorTest(C),s){const i=K.get(t.texture);vt.framebufferTexture2D(vt.FRAMEBUFFER,vt.COLOR_ATTACHMENT0,vt.TEXTURE_CUBE_MAP_POSITIVE_X+e,i.__webglTexture,n)}else if(a){const i=K.get(t.texture),r=e||0;vt.framebufferTextureLayer(vt.FRAMEBUFFER,vt.COLOR_ATTACHMENT0,i.__webglTexture,n||0,r)}S=-1},this.readRenderTargetPixels=function(t,e,n,i,r,s,a){if(!t||!t.isWebGLRenderTarget)return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");let o=K.get(t).__webglFramebuffer;if(t.isWebGLCubeRenderTarget&&void 0!==a&&(o=o[a]),o){Z.bindFramebuffer(vt.FRAMEBUFFER,o);try{const a=t.texture,o=a.format,l=a.type;if(o!==E&&mt.convert(o)!==vt.getParameter(vt.IMPLEMENTATION_COLOR_READ_FORMAT))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.");const c=l===w&&(Y.has("EXT_color_buffer_half_float")||q.isWebGL2&&Y.has("EXT_color_buffer_float"));if(!(l===y||mt.convert(l)===vt.getParameter(vt.IMPLEMENTATION_COLOR_READ_TYPE)||l===M&&(q.isWebGL2||Y.has("OES_texture_float")||Y.has("WEBGL_color_buffer_float"))||c))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.");e>=0&&e<=t.width-i&&n>=0&&n<=t.height-r&&vt.readPixels(e,n,i,r,mt.convert(o),mt.convert(l),s)}finally{const t=null!==b?K.get(b).__webglFramebuffer:null;Z.bindFramebuffer(vt.FRAMEBUFFER,t)}}},this.copyFramebufferToTexture=function(t,e,n=0){const i=Math.pow(2,-n),r=Math.floor(e.image.width*i),s=Math.floor(e.image.height*i);$.setTexture2D(e,0),vt.copyTexSubImage2D(vt.TEXTURE_2D,n,0,0,t.x,t.y,r,s),Z.unbindTexture()},this.copyTextureToTexture=function(t,e,n,i=0){const r=e.image.width,s=e.image.height,a=mt.convert(n.format),o=mt.convert(n.type);$.setTexture2D(n,0),vt.pixelStorei(vt.UNPACK_FLIP_Y_WEBGL,n.flipY),vt.pixelStorei(vt.UNPACK_PREMULTIPLY_ALPHA_WEBGL,n.premultiplyAlpha),vt.pixelStorei(vt.UNPACK_ALIGNMENT,n.unpackAlignment),e.isDataTexture?vt.texSubImage2D(vt.TEXTURE_2D,i,t.x,t.y,r,s,a,o,e.image.data):e.isCompressedTexture?vt.compressedTexSubImage2D(vt.TEXTURE_2D,i,t.x,t.y,e.mipmaps[0].width,e.mipmaps[0].height,a,e.mipmaps[0].data):vt.texSubImage2D(vt.TEXTURE_2D,i,t.x,t.y,a,o,e.image),0===i&&n.generateMipmaps&&vt.generateMipmap(vt.TEXTURE_2D),Z.unbindTexture()},this.copyTextureToTexture3D=function(t,e,n,i,r=0){if(m.isWebGL1Renderer)return void console.warn("THREE.WebGLRenderer.copyTextureToTexture3D: can only be used with WebGL2.");const s=t.max.x-t.min.x+1,a=t.max.y-t.min.y+1,o=t.max.z-t.min.z+1,l=mt.convert(i.format),c=mt.convert(i.type);let u;if(i.isData3DTexture)$.setTexture3D(i,0),u=vt.TEXTURE_3D;else{if(!i.isDataArrayTexture)return void console.warn("THREE.WebGLRenderer.copyTextureToTexture3D: only supports THREE.DataTexture3D and THREE.DataTexture2DArray.");$.setTexture2DArray(i,0),u=vt.TEXTURE_2D_ARRAY}vt.pixelStorei(vt.UNPACK_FLIP_Y_WEBGL,i.flipY),vt.pixelStorei(vt.UNPACK_PREMULTIPLY_ALPHA_WEBGL,i.premultiplyAlpha),vt.pixelStorei(vt.UNPACK_ALIGNMENT,i.unpackAlignment);const h=vt.getParameter(vt.UNPACK_ROW_LENGTH),d=vt.getParameter(vt.UNPACK_IMAGE_HEIGHT),p=vt.getParameter(vt.UNPACK_SKIP_PIXELS),f=vt.getParameter(vt.UNPACK_SKIP_ROWS),g=vt.getParameter(vt.UNPACK_SKIP_IMAGES),v=n.isCompressedTexture?n.mipmaps[0]:n.image;vt.pixelStorei(vt.UNPACK_ROW_LENGTH,v.width),vt.pixelStorei(vt.UNPACK_IMAGE_HEIGHT,v.height),vt.pixelStorei(vt.UNPACK_SKIP_PIXELS,t.min.x),vt.pixelStorei(vt.UNPACK_SKIP_ROWS,t.min.y),vt.pixelStorei(vt.UNPACK_SKIP_IMAGES,t.min.z),n.isDataTexture||n.isData3DTexture?vt.texSubImage3D(u,r,e.x,e.y,e.z,s,a,o,l,c,v.data):n.isCompressedTexture?(console.warn("THREE.WebGLRenderer.copyTextureToTexture3D: untested support for compressed srcTexture."),vt.compressedTexSubImage3D(u,r,e.x,e.y,e.z,s,a,o,l,v.data)):vt.texSubImage3D(u,r,e.x,e.y,e.z,s,a,o,l,c,v),vt.pixelStorei(vt.UNPACK_ROW_LENGTH,h),vt.pixelStorei(vt.UNPACK_IMAGE_HEIGHT,d),vt.pixelStorei(vt.UNPACK_SKIP_PIXELS,p),vt.pixelStorei(vt.UNPACK_SKIP_ROWS,f),vt.pixelStorei(vt.UNPACK_SKIP_IMAGES,g),0===r&&i.generateMipmaps&&vt.generateMipmap(u),Z.unbindTexture()},this.initTexture=function(t){t.isCubeTexture?$.setTextureCube(t,0):t.isData3DTexture?$.setTexture3D(t,0):t.isDataArrayTexture?$.setTexture2DArray(t,0):$.setTexture2D(t,0),Z.unbindTexture()},this.resetState=function(){v=0,x=0,b=null,Z.reset(),gt.reset()},"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}class qs extends Ys{}qs.prototype.isWebGL1Renderer=!0;class Zs{constructor(t,e=25e-5){this.isFogExp2=!0,this.name="",this.color=new Ht(t),this.density=e}clone(){return new Zs(this.color,this.density)}toJSON(){return{type:"FogExp2",color:this.color.getHex(),density:this.density}}}class Js{constructor(t,e=1,n=1e3){this.isFog=!0,this.name="",this.color=new Ht(t),this.near=e,this.far=n}clone(){return new Js(this.color,this.near,this.far)}toJSON(){return{type:"Fog",color:this.color.getHex(),near:this.near,far:this.far}}}class Ks extends rn{constructor(){super(),this.isScene=!0,this.type="Scene",this.background=null,this.environment=null,this.fog=null,this.overrideMaterial=null,this.autoUpdate=!0,"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("observe",{detail:this}))}copy(t,e){return super.copy(t,e),null!==t.background&&(this.background=t.background.clone()),null!==t.environment&&(this.environment=t.environment.clone()),null!==t.fog&&(this.fog=t.fog.clone()),null!==t.overrideMaterial&&(this.overrideMaterial=t.overrideMaterial.clone()),this.autoUpdate=t.autoUpdate,this.matrixAutoUpdate=t.matrixAutoUpdate,this}toJSON(t){const e=super.toJSON(t);return null!==this.fog&&(e.object.fog=this.fog.toJSON()),e}}class $s{constructor(t,e){this.isInterleavedBuffer=!0,this.array=t,this.stride=e,this.count=void 0!==t?t.length/e:0,this.usage=ht,this.updateRange={offset:0,count:-1},this.version=0,this.uuid=yt()}onUploadCallback(){}set needsUpdate(t){!0===t&&this.version++}setUsage(t){return this.usage=t,this}copy(t){return this.array=new t.array.constructor(t.array),this.count=t.count,this.stride=t.stride,this.usage=t.usage,this}copyAt(t,e,n){t*=this.stride,n*=e.stride;for(let i=0,r=this.stride;i<r;i++)this.array[t+i]=e.array[n+i];return this}set(t,e=0){return this.array.set(t,e),this}clone(t){void 0===t.arrayBuffers&&(t.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=yt()),void 0===t.arrayBuffers[this.array.buffer._uuid]&&(t.arrayBuffers[this.array.buffer._uuid]=this.array.slice(0).buffer);const e=new this.array.constructor(t.arrayBuffers[this.array.buffer._uuid]),n=new this.constructor(e,this.stride);return n.setUsage(this.usage),n}onUpload(t){return this.onUploadCallback=t,this}toJSON(t){return void 0===t.arrayBuffers&&(t.arrayBuffers={}),void 0===this.array.buffer._uuid&&(this.array.buffer._uuid=yt()),void 0===t.arrayBuffers[this.array.buffer._uuid]&&(t.arrayBuffers[this.array.buffer._uuid]=Array.from(new Uint32Array(this.array.buffer))),{uuid:this.uuid,buffer:this.array.buffer._uuid,type:this.array.constructor.name,stride:this.stride}}}const Qs=new ee;class ta{constructor(t,e,n,i=!1){this.isInterleavedBufferAttribute=!0,this.name="",this.data=t,this.itemSize=e,this.offset=n,this.normalized=!0===i}get count(){return this.data.count}get array(){return this.data.array}set needsUpdate(t){this.data.needsUpdate=t}applyMatrix4(t){for(let e=0,n=this.data.count;e<n;e++)Qs.fromBufferAttribute(this,e),Qs.applyMatrix4(t),this.setXYZ(e,Qs.x,Qs.y,Qs.z);return this}applyNormalMatrix(t){for(let e=0,n=this.count;e<n;e++)Qs.fromBufferAttribute(this,e),Qs.applyNormalMatrix(t),this.setXYZ(e,Qs.x,Qs.y,Qs.z);return this}transformDirection(t){for(let e=0,n=this.count;e<n;e++)Qs.fromBufferAttribute(this,e),Qs.transformDirection(t),this.setXYZ(e,Qs.x,Qs.y,Qs.z);return this}setX(t,e){return this.data.array[t*this.data.stride+this.offset]=e,this}setY(t,e){return this.data.array[t*this.data.stride+this.offset+1]=e,this}setZ(t,e){return this.data.array[t*this.data.stride+this.offset+2]=e,this}setW(t,e){return this.data.array[t*this.data.stride+this.offset+3]=e,this}getX(t){return this.data.array[t*this.data.stride+this.offset]}getY(t){return this.data.array[t*this.data.stride+this.offset+1]}getZ(t){return this.data.array[t*this.data.stride+this.offset+2]}getW(t){return this.data.array[t*this.data.stride+this.offset+3]}setXY(t,e,n){return t=t*this.data.stride+this.offset,this.data.array[t+0]=e,this.data.array[t+1]=n,this}setXYZ(t,e,n,i){return t=t*this.data.stride+this.offset,this.data.array[t+0]=e,this.data.array[t+1]=n,this.data.array[t+2]=i,this}setXYZW(t,e,n,i,r){return t=t*this.data.stride+this.offset,this.data.array[t+0]=e,this.data.array[t+1]=n,this.data.array[t+2]=i,this.data.array[t+3]=r,this}clone(t){if(void 0===t){console.log("THREE.InterleavedBufferAttribute.clone(): Cloning an interleaved buffer attribute will deinterleave buffer data.");const t=[];for(let e=0;e<this.count;e++){const n=e*this.data.stride+this.offset;for(let e=0;e<this.itemSize;e++)t.push(this.data.array[n+e])}return new bn(new this.array.constructor(t),this.itemSize,this.normalized)}return void 0===t.interleavedBuffers&&(t.interleavedBuffers={}),void 0===t.interleavedBuffers[this.data.uuid]&&(t.interleavedBuffers[this.data.uuid]=this.data.clone(t)),new ta(t.interleavedBuffers[this.data.uuid],this.itemSize,this.offset,this.normalized)}toJSON(t){if(void 0===t){console.log("THREE.InterleavedBufferAttribute.toJSON(): Serializing an interleaved buffer attribute will deinterleave buffer data.");const t=[];for(let e=0;e<this.count;e++){const n=e*this.data.stride+this.offset;for(let e=0;e<this.itemSize;e++)t.push(this.data.array[n+e])}return{itemSize:this.itemSize,type:this.array.constructor.name,array:t,normalized:this.normalized}}return void 0===t.interleavedBuffers&&(t.interleavedBuffers={}),void 0===t.interleavedBuffers[this.data.uuid]&&(t.interleavedBuffers[this.data.uuid]=this.data.toJSON(t)),{isInterleavedBufferAttribute:!0,itemSize:this.itemSize,data:this.data.uuid,offset:this.offset,normalized:this.normalized}}}class ea extends vn{constructor(t){super(),this.isSpriteMaterial=!0,this.type="SpriteMaterial",this.color=new Ht(16777215),this.map=null,this.alphaMap=null,this.rotation=0,this.sizeAttenuation=!0,this.transparent=!0,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.alphaMap=t.alphaMap,this.rotation=t.rotation,this.sizeAttenuation=t.sizeAttenuation,this.fog=t.fog,this}}let na;const ia=new ee,ra=new ee,sa=new ee,aa=new At,oa=new At,la=new Ie,ca=new ee,ua=new ee,ha=new ee,da=new At,pa=new At,fa=new At;class ma extends rn{constructor(t){if(super(),this.isSprite=!0,this.type="Sprite",void 0===na){na=new In;const t=new Float32Array([-.5,-.5,0,0,0,.5,-.5,0,1,0,.5,.5,0,1,1,-.5,.5,0,0,1]),e=new $s(t,5);na.setIndex([0,1,2,0,2,3]),na.setAttribute("position",new ta(e,3,0,!1)),na.setAttribute("uv",new ta(e,2,3,!1))}this.geometry=na,this.material=void 0!==t?t:new ea,this.center=new At(.5,.5)}raycast(t,e){null===t.camera&&console.error('THREE.Sprite: "Raycaster.camera" needs to be set in order to raycast against sprites.'),ra.setFromMatrixScale(this.matrixWorld),la.copy(t.camera.matrixWorld),this.modelViewMatrix.multiplyMatrices(t.camera.matrixWorldInverse,this.matrixWorld),sa.setFromMatrixPosition(this.modelViewMatrix),t.camera.isPerspectiveCamera&&!1===this.material.sizeAttenuation&&ra.multiplyScalar(-sa.z);const n=this.material.rotation;let i,r;0!==n&&(r=Math.cos(n),i=Math.sin(n));const s=this.center;ga(ca.set(-.5,-.5,0),sa,s,ra,i,r),ga(ua.set(.5,-.5,0),sa,s,ra,i,r),ga(ha.set(.5,.5,0),sa,s,ra,i,r),da.set(0,0),pa.set(1,0),fa.set(1,1);let a=t.ray.intersectTriangle(ca,ua,ha,!1,ia);if(null===a&&(ga(ua.set(-.5,.5,0),sa,s,ra,i,r),pa.set(0,1),a=t.ray.intersectTriangle(ca,ha,ua,!1,ia),null===a))return;const o=t.ray.origin.distanceTo(ia);o<t.near||o>t.far||e.push({distance:o,point:ia.clone(),uv:mn.getUV(ia,ca,ua,ha,da,pa,fa,new At),face:null,object:this})}copy(t,e){return super.copy(t,e),void 0!==t.center&&this.center.copy(t.center),this.material=t.material,this}}function ga(t,e,n,i,r,s){aa.subVectors(t,n).addScalar(.5).multiply(i),void 0!==r?(oa.x=s*aa.x-r*aa.y,oa.y=r*aa.x+s*aa.y):oa.copy(aa),t.copy(e),t.x+=oa.x,t.y+=oa.y,t.applyMatrix4(la)}const va=new ee,_a=new ee;class ya extends rn{constructor(){super(),this._currentLevel=0,this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]},isLOD:{value:!0}}),this.autoUpdate=!0}copy(t){super.copy(t,!1);const e=t.levels;for(let t=0,n=e.length;t<n;t++){const n=e[t];this.addLevel(n.object.clone(),n.distance)}return this.autoUpdate=t.autoUpdate,this}addLevel(t,e=0){e=Math.abs(e);const n=this.levels;let i;for(i=0;i<n.length&&!(e<n[i].distance);i++);return n.splice(i,0,{distance:e,object:t}),this.add(t),this}getCurrentLevel(){return this._currentLevel}getObjectForDistance(t){const e=this.levels;if(e.length>0){let n,i;for(n=1,i=e.length;n<i&&!(t<e[n].distance);n++);return e[n-1].object}return null}raycast(t,e){if(this.levels.length>0){va.setFromMatrixPosition(this.matrixWorld);const n=t.ray.origin.distanceTo(va);this.getObjectForDistance(n).raycast(t,e)}}update(t){const e=this.levels;if(e.length>1){va.setFromMatrixPosition(t.matrixWorld),_a.setFromMatrixPosition(this.matrixWorld);const n=va.distanceTo(_a)/t.zoom;let i,r;for(e[0].object.visible=!0,i=1,r=e.length;i<r&&n>=e[i].distance;i++)e[i-1].object.visible=!1,e[i].object.visible=!0;for(this._currentLevel=i-1;i<r;i++)e[i].object.visible=!1}}toJSON(t){const e=super.toJSON(t);!1===this.autoUpdate&&(e.object.autoUpdate=!1),e.object.levels=[];const n=this.levels;for(let t=0,i=n.length;t<i;t++){const i=n[t];e.object.levels.push({object:i.object.uuid,distance:i.distance})}return e}}const xa=new ee,ba=new Jt,Ma=new Jt,wa=new ee,Sa=new Ie;class Ea extends Jn{constructor(t,e){super(t,e),this.isSkinnedMesh=!0,this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new Ie,this.bindMatrixInverse=new Ie}copy(t,e){return super.copy(t,e),this.bindMode=t.bindMode,this.bindMatrix.copy(t.bindMatrix),this.bindMatrixInverse.copy(t.bindMatrixInverse),this.skeleton=t.skeleton,this}bind(t,e){this.skeleton=t,void 0===e&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),e=this.matrixWorld),this.bindMatrix.copy(e),this.bindMatrixInverse.copy(e).invert()}pose(){this.skeleton.pose()}normalizeSkinWeights(){const t=new Jt,e=this.geometry.attributes.skinWeight;for(let n=0,i=e.count;n<i;n++){t.fromBufferAttribute(e,n);const i=1/t.manhattanLength();i!==1/0?t.multiplyScalar(i):t.set(1,0,0,0),e.setXYZW(n,t.x,t.y,t.z,t.w)}}updateMatrixWorld(t){super.updateMatrixWorld(t),"attached"===this.bindMode?this.bindMatrixInverse.copy(this.matrixWorld).invert():"detached"===this.bindMode?this.bindMatrixInverse.copy(this.bindMatrix).invert():console.warn("THREE.SkinnedMesh: Unrecognized bindMode: "+this.bindMode)}boneTransform(t,e){const n=this.skeleton,i=this.geometry;ba.fromBufferAttribute(i.attributes.skinIndex,t),Ma.fromBufferAttribute(i.attributes.skinWeight,t),xa.copy(e).applyMatrix4(this.bindMatrix),e.set(0,0,0);for(let t=0;t<4;t++){const i=Ma.getComponent(t);if(0!==i){const r=ba.getComponent(t);Sa.multiplyMatrices(n.bones[r].matrixWorld,n.boneInverses[r]),e.addScaledVector(wa.copy(xa).applyMatrix4(Sa),i)}}return e.applyMatrix4(this.bindMatrixInverse)}}class Ta extends rn{constructor(){super(),this.isBone=!0,this.type="Bone"}}class Aa extends Zt{constructor(t=null,e=1,n=1,i,r,s,a,o,l=1003,c=1003,u,h){super(null,s,a,o,l,c,i,r,u,h),this.isDataTexture=!0,this.image={data:t,width:e,height:n},this.generateMipmaps=!1,this.flipY=!1,this.unpackAlignment=1}}const Ra=new Ie,Ca=new Ie;class La{constructor(t=[],e=[]){this.uuid=yt(),this.bones=t.slice(0),this.boneInverses=e,this.boneMatrices=null,this.boneTexture=null,this.boneTextureSize=0,this.frame=-1,this.init()}init(){const t=this.bones,e=this.boneInverses;if(this.boneMatrices=new Float32Array(16*t.length),0===e.length)this.calculateInverses();else if(t.length!==e.length){console.warn("THREE.Skeleton: Number of inverse bone matrices does not match amount of bones."),this.boneInverses=[];for(let t=0,e=this.bones.length;t<e;t++)this.boneInverses.push(new Ie)}}calculateInverses(){this.boneInverses.length=0;for(let t=0,e=this.bones.length;t<e;t++){const e=new Ie;this.bones[t]&&e.copy(this.bones[t].matrixWorld).invert(),this.boneInverses.push(e)}}pose(){for(let t=0,e=this.bones.length;t<e;t++){const e=this.bones[t];e&&e.matrixWorld.copy(this.boneInverses[t]).invert()}for(let t=0,e=this.bones.length;t<e;t++){const e=this.bones[t];e&&(e.parent&&e.parent.isBone?(e.matrix.copy(e.parent.matrixWorld).invert(),e.matrix.multiply(e.matrixWorld)):e.matrix.copy(e.matrixWorld),e.matrix.decompose(e.position,e.quaternion,e.scale))}}update(){const t=this.bones,e=this.boneInverses,n=this.boneMatrices,i=this.boneTexture;for(let i=0,r=t.length;i<r;i++){const r=t[i]?t[i].matrixWorld:Ca;Ra.multiplyMatrices(r,e[i]),Ra.toArray(n,16*i)}null!==i&&(i.needsUpdate=!0)}clone(){return new La(this.bones,this.boneInverses)}computeBoneTexture(){let t=Math.sqrt(4*this.bones.length);t=St(t),t=Math.max(t,4);const e=new Float32Array(t*t*4);e.set(this.boneMatrices);const n=new Aa(e,t,t,E,M);return n.needsUpdate=!0,this.boneMatrices=e,this.boneTexture=n,this.boneTextureSize=t,this}getBoneByName(t){for(let e=0,n=this.bones.length;e<n;e++){const n=this.bones[e];if(n.name===t)return n}}dispose(){null!==this.boneTexture&&(this.boneTexture.dispose(),this.boneTexture=null)}fromJSON(t,e){this.uuid=t.uuid;for(let n=0,i=t.bones.length;n<i;n++){const i=t.bones[n];let r=e[i];void 0===r&&(console.warn("THREE.Skeleton: No bone found with UUID:",i),r=new Ta),this.bones.push(r),this.boneInverses.push((new Ie).fromArray(t.boneInverses[n]))}return this.init(),this}toJSON(){const t={metadata:{version:4.5,type:"Skeleton",generator:"Skeleton.toJSON"},bones:[],boneInverses:[]};t.uuid=this.uuid;const e=this.bones,n=this.boneInverses;for(let i=0,r=e.length;i<r;i++){const r=e[i];t.bones.push(r.uuid);const s=n[i];t.boneInverses.push(s.toArray())}return t}}class Pa extends bn{constructor(t,e,n,i=1){"number"==typeof n&&(i=n,n=!1,console.error("THREE.InstancedBufferAttribute: The constructor now expects normalized as the third argument.")),super(t,e,n),this.isInstancedBufferAttribute=!0,this.meshPerAttribute=i}copy(t){return super.copy(t),this.meshPerAttribute=t.meshPerAttribute,this}toJSON(){const t=super.toJSON();return t.meshPerAttribute=this.meshPerAttribute,t.isInstancedBufferAttribute=!0,t}}const Ia=new Ie,Da=new Ie,Oa=[],Na=new Jn;class Ua extends Jn{constructor(t,e,n){super(t,e),this.isInstancedMesh=!0,this.instanceMatrix=new Pa(new Float32Array(16*n),16),this.instanceColor=null,this.count=n,this.frustumCulled=!1}copy(t,e){return super.copy(t,e),this.instanceMatrix.copy(t.instanceMatrix),null!==t.instanceColor&&(this.instanceColor=t.instanceColor.clone()),this.count=t.count,this}getColorAt(t,e){e.fromArray(this.instanceColor.array,3*t)}getMatrixAt(t,e){e.fromArray(this.instanceMatrix.array,16*t)}raycast(t,e){const n=this.matrixWorld,i=this.count;if(Na.geometry=this.geometry,Na.material=this.material,void 0!==Na.material)for(let r=0;r<i;r++){this.getMatrixAt(r,Ia),Da.multiplyMatrices(n,Ia),Na.matrixWorld=Da,Na.raycast(t,Oa);for(let t=0,n=Oa.length;t<n;t++){const n=Oa[t];n.instanceId=r,n.object=this,e.push(n)}Oa.length=0}}setColorAt(t,e){null===this.instanceColor&&(this.instanceColor=new Pa(new Float32Array(3*this.instanceMatrix.count),3)),e.toArray(this.instanceColor.array,3*t)}setMatrixAt(t,e){e.toArray(this.instanceMatrix.array,16*t)}updateMorphTargets(){}dispose(){this.dispatchEvent({type:"dispose"})}}class Fa extends vn{constructor(t){super(),this.isLineBasicMaterial=!0,this.type="LineBasicMaterial",this.color=new Ht(16777215),this.linewidth=1,this.linecap="round",this.linejoin="round",this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.linewidth=t.linewidth,this.linecap=t.linecap,this.linejoin=t.linejoin,this.fog=t.fog,this}}const Ba=new ee,za=new ee,ka=new Ie,Ga=new Pe,Va=new we;class Ha extends rn{constructor(t=new In,e=new Fa){super(),this.isLine=!0,this.type="Line",this.geometry=t,this.material=e,this.updateMorphTargets()}copy(t,e){return super.copy(t,e),this.material=t.material,this.geometry=t.geometry,this}computeLineDistances(){const t=this.geometry;if(null===t.index){const e=t.attributes.position,n=[0];for(let t=1,i=e.count;t<i;t++)Ba.fromBufferAttribute(e,t-1),za.fromBufferAttribute(e,t),n[t]=n[t-1],n[t]+=Ba.distanceTo(za);t.setAttribute("lineDistance",new Sn(n,1))}else console.warn("THREE.Line.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}raycast(t,e){const n=this.geometry,i=this.matrixWorld,r=t.params.Line.threshold,s=n.drawRange;if(null===n.boundingSphere&&n.computeBoundingSphere(),Va.copy(n.boundingSphere),Va.applyMatrix4(i),Va.radius+=r,!1===t.ray.intersectsSphere(Va))return;ka.copy(i).invert(),Ga.copy(t.ray).applyMatrix4(ka);const a=r/((this.scale.x+this.scale.y+this.scale.z)/3),o=a*a,l=new ee,c=new ee,u=new ee,h=new ee,d=this.isLineSegments?2:1,p=n.index,f=n.attributes.position;if(null!==p)for(let n=Math.max(0,s.start),i=Math.min(p.count,s.start+s.count)-1;n<i;n+=d){const i=p.getX(n),r=p.getX(n+1);if(l.fromBufferAttribute(f,i),c.fromBufferAttribute(f,r),Ga.distanceSqToSegment(l,c,h,u)>o)continue;h.applyMatrix4(this.matrixWorld);const s=t.ray.origin.distanceTo(h);s<t.near||s>t.far||e.push({distance:s,point:u.clone().applyMatrix4(this.matrixWorld),index:n,face:null,faceIndex:null,object:this})}else for(let n=Math.max(0,s.start),i=Math.min(f.count,s.start+s.count)-1;n<i;n+=d){if(l.fromBufferAttribute(f,n),c.fromBufferAttribute(f,n+1),Ga.distanceSqToSegment(l,c,h,u)>o)continue;h.applyMatrix4(this.matrixWorld);const i=t.ray.origin.distanceTo(h);i<t.near||i>t.far||e.push({distance:i,point:u.clone().applyMatrix4(this.matrixWorld),index:n,face:null,faceIndex:null,object:this})}}updateMorphTargets(){const t=this.geometry.morphAttributes,e=Object.keys(t);if(e.length>0){const n=t[e[0]];if(void 0!==n){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,e=n.length;t<e;t++){const e=n[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[e]=t}}}}}const Wa=new ee,ja=new ee;class Xa extends Ha{constructor(t,e){super(t,e),this.isLineSegments=!0,this.type="LineSegments"}computeLineDistances(){const t=this.geometry;if(null===t.index){const e=t.attributes.position,n=[];for(let t=0,i=e.count;t<i;t+=2)Wa.fromBufferAttribute(e,t),ja.fromBufferAttribute(e,t+1),n[t]=0===t?0:n[t-1],n[t+1]=n[t]+Wa.distanceTo(ja);t.setAttribute("lineDistance",new Sn(n,1))}else console.warn("THREE.LineSegments.computeLineDistances(): Computation only possible with non-indexed BufferGeometry.");return this}}class Ya extends Ha{constructor(t,e){super(t,e),this.isLineLoop=!0,this.type="LineLoop"}}class qa extends vn{constructor(t){super(),this.isPointsMaterial=!0,this.type="PointsMaterial",this.color=new Ht(16777215),this.map=null,this.alphaMap=null,this.size=1,this.sizeAttenuation=!0,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.alphaMap=t.alphaMap,this.size=t.size,this.sizeAttenuation=t.sizeAttenuation,this.fog=t.fog,this}}const Za=new Ie,Ja=new Pe,Ka=new we,$a=new ee;class Qa extends rn{constructor(t=new In,e=new qa){super(),this.isPoints=!0,this.type="Points",this.geometry=t,this.material=e,this.updateMorphTargets()}copy(t,e){return super.copy(t,e),this.material=t.material,this.geometry=t.geometry,this}raycast(t,e){const n=this.geometry,i=this.matrixWorld,r=t.params.Points.threshold,s=n.drawRange;if(null===n.boundingSphere&&n.computeBoundingSphere(),Ka.copy(n.boundingSphere),Ka.applyMatrix4(i),Ka.radius+=r,!1===t.ray.intersectsSphere(Ka))return;Za.copy(i).invert(),Ja.copy(t.ray).applyMatrix4(Za);const a=r/((this.scale.x+this.scale.y+this.scale.z)/3),o=a*a,l=n.index,c=n.attributes.position;if(null!==l)for(let n=Math.max(0,s.start),r=Math.min(l.count,s.start+s.count);n<r;n++){const r=l.getX(n);$a.fromBufferAttribute(c,r),to($a,r,o,i,t,e,this)}else for(let n=Math.max(0,s.start),r=Math.min(c.count,s.start+s.count);n<r;n++)$a.fromBufferAttribute(c,n),to($a,n,o,i,t,e,this)}updateMorphTargets(){const t=this.geometry.morphAttributes,e=Object.keys(t);if(e.length>0){const n=t[e[0]];if(void 0!==n){this.morphTargetInfluences=[],this.morphTargetDictionary={};for(let t=0,e=n.length;t<e;t++){const e=n[t].name||String(t);this.morphTargetInfluences.push(0),this.morphTargetDictionary[e]=t}}}}}function to(t,e,n,i,r,s,a){const o=Ja.distanceSqToPoint(t);if(o<n){const n=new ee;Ja.closestPointToPoint(t,n),n.applyMatrix4(i);const l=r.ray.origin.distanceTo(n);if(l<r.near||l>r.far)return;s.push({distance:l,distanceToRay:Math.sqrt(o),point:n,index:e,face:null,object:a})}}class eo extends Zt{constructor(t,e,n,i,r,s,a,o,l,c,u,h){super(null,s,a,o,l,c,i,r,u,h),this.isCompressedTexture=!0,this.image={width:e,height:n},this.mipmaps=t,this.flipY=!1,this.generateMipmaps=!1}}class no{constructor(){this.type="Curve",this.arcLengthDivisions=200}getPoint(){return console.warn("THREE.Curve: .getPoint() not implemented."),null}getPointAt(t,e){const n=this.getUtoTmapping(t);return this.getPoint(n,e)}getPoints(t=5){const e=[];for(let n=0;n<=t;n++)e.push(this.getPoint(n/t));return e}getSpacedPoints(t=5){const e=[];for(let n=0;n<=t;n++)e.push(this.getPointAt(n/t));return e}getLength(){const t=this.getLengths();return t[t.length-1]}getLengths(t=this.arcLengthDivisions){if(this.cacheArcLengths&&this.cacheArcLengths.length===t+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;const e=[];let n,i=this.getPoint(0),r=0;e.push(0);for(let s=1;s<=t;s++)n=this.getPoint(s/t),r+=n.distanceTo(i),e.push(r),i=n;return this.cacheArcLengths=e,e}updateArcLengths(){this.needsUpdate=!0,this.getLengths()}getUtoTmapping(t,e){const n=this.getLengths();let i=0;const r=n.length;let s;s=e||t*n[r-1];let a,o=0,l=r-1;for(;o<=l;)if(i=Math.floor(o+(l-o)/2),a=n[i]-s,a<0)o=i+1;else{if(!(a>0)){l=i;break}l=i-1}if(i=l,n[i]===s)return i/(r-1);const c=n[i];return(i+(s-c)/(n[i+1]-c))/(r-1)}getTangent(t,e){const n=1e-4;let i=t-n,r=t+n;i<0&&(i=0),r>1&&(r=1);const s=this.getPoint(i),a=this.getPoint(r),o=e||(s.isVector2?new At:new ee);return o.copy(a).sub(s).normalize(),o}getTangentAt(t,e){const n=this.getUtoTmapping(t);return this.getTangent(n,e)}computeFrenetFrames(t,e){const n=new ee,i=[],r=[],s=[],a=new ee,o=new Ie;for(let e=0;e<=t;e++){const n=e/t;i[e]=this.getTangentAt(n,new ee)}r[0]=new ee,s[0]=new ee;let l=Number.MAX_VALUE;const c=Math.abs(i[0].x),u=Math.abs(i[0].y),h=Math.abs(i[0].z);c<=l&&(l=c,n.set(1,0,0)),u<=l&&(l=u,n.set(0,1,0)),h<=l&&n.set(0,0,1),a.crossVectors(i[0],n).normalize(),r[0].crossVectors(i[0],a),s[0].crossVectors(i[0],r[0]);for(let e=1;e<=t;e++){if(r[e]=r[e-1].clone(),s[e]=s[e-1].clone(),a.crossVectors(i[e-1],i[e]),a.length()>Number.EPSILON){a.normalize();const t=Math.acos(xt(i[e-1].dot(i[e]),-1,1));r[e].applyMatrix4(o.makeRotationAxis(a,t))}s[e].crossVectors(i[e],r[e])}if(!0===e){let e=Math.acos(xt(r[0].dot(r[t]),-1,1));e/=t,i[0].dot(a.crossVectors(r[0],r[t]))>0&&(e=-e);for(let n=1;n<=t;n++)r[n].applyMatrix4(o.makeRotationAxis(i[n],e*n)),s[n].crossVectors(i[n],r[n])}return{tangents:i,normals:r,binormals:s}}clone(){return(new this.constructor).copy(this)}copy(t){return this.arcLengthDivisions=t.arcLengthDivisions,this}toJSON(){const t={metadata:{version:4.5,type:"Curve",generator:"Curve.toJSON"}};return t.arcLengthDivisions=this.arcLengthDivisions,t.type=this.type,t}fromJSON(t){return this.arcLengthDivisions=t.arcLengthDivisions,this}}class io extends no{constructor(t=0,e=0,n=1,i=1,r=0,s=2*Math.PI,a=!1,o=0){super(),this.isEllipseCurve=!0,this.type="EllipseCurve",this.aX=t,this.aY=e,this.xRadius=n,this.yRadius=i,this.aStartAngle=r,this.aEndAngle=s,this.aClockwise=a,this.aRotation=o}getPoint(t,e){const n=e||new At,i=2*Math.PI;let r=this.aEndAngle-this.aStartAngle;const s=Math.abs(r)<Number.EPSILON;for(;r<0;)r+=i;for(;r>i;)r-=i;r<Number.EPSILON&&(r=s?0:i),!0!==this.aClockwise||s||(r===i?r=-i:r-=i);const a=this.aStartAngle+t*r;let o=this.aX+this.xRadius*Math.cos(a),l=this.aY+this.yRadius*Math.sin(a);if(0!==this.aRotation){const t=Math.cos(this.aRotation),e=Math.sin(this.aRotation),n=o-this.aX,i=l-this.aY;o=n*t-i*e+this.aX,l=n*e+i*t+this.aY}return n.set(o,l)}copy(t){return super.copy(t),this.aX=t.aX,this.aY=t.aY,this.xRadius=t.xRadius,this.yRadius=t.yRadius,this.aStartAngle=t.aStartAngle,this.aEndAngle=t.aEndAngle,this.aClockwise=t.aClockwise,this.aRotation=t.aRotation,this}toJSON(){const t=super.toJSON();return t.aX=this.aX,t.aY=this.aY,t.xRadius=this.xRadius,t.yRadius=this.yRadius,t.aStartAngle=this.aStartAngle,t.aEndAngle=this.aEndAngle,t.aClockwise=this.aClockwise,t.aRotation=this.aRotation,t}fromJSON(t){return super.fromJSON(t),this.aX=t.aX,this.aY=t.aY,this.xRadius=t.xRadius,this.yRadius=t.yRadius,this.aStartAngle=t.aStartAngle,this.aEndAngle=t.aEndAngle,this.aClockwise=t.aClockwise,this.aRotation=t.aRotation,this}}class ro extends io{constructor(t,e,n,i,r,s){super(t,e,n,n,i,r,s),this.isArcCurve=!0,this.type="ArcCurve"}}function so(){let t=0,e=0,n=0,i=0;function r(r,s,a,o){t=r,e=a,n=-3*r+3*s-2*a-o,i=2*r-2*s+a+o}return{initCatmullRom:function(t,e,n,i,s){r(e,n,s*(n-t),s*(i-e))},initNonuniformCatmullRom:function(t,e,n,i,s,a,o){let l=(e-t)/s-(n-t)/(s+a)+(n-e)/a,c=(n-e)/a-(i-e)/(a+o)+(i-n)/o;l*=a,c*=a,r(e,n,l,c)},calc:function(r){const s=r*r;return t+e*r+n*s+i*(s*r)}}}const ao=new ee,oo=new so,lo=new so,co=new so;class uo extends no{constructor(t=[],e=!1,n="centripetal",i=.5){super(),this.isCatmullRomCurve3=!0,this.type="CatmullRomCurve3",this.points=t,this.closed=e,this.curveType=n,this.tension=i}getPoint(t,e=new ee){const n=e,i=this.points,r=i.length,s=(r-(this.closed?0:1))*t;let a,o,l=Math.floor(s),c=s-l;this.closed?l+=l>0?0:(Math.floor(Math.abs(l)/r)+1)*r:0===c&&l===r-1&&(l=r-2,c=1),this.closed||l>0?a=i[(l-1)%r]:(ao.subVectors(i[0],i[1]).add(i[0]),a=ao);const u=i[l%r],h=i[(l+1)%r];if(this.closed||l+2<r?o=i[(l+2)%r]:(ao.subVectors(i[r-1],i[r-2]).add(i[r-1]),o=ao),"centripetal"===this.curveType||"chordal"===this.curveType){const t="chordal"===this.curveType?.5:.25;let e=Math.pow(a.distanceToSquared(u),t),n=Math.pow(u.distanceToSquared(h),t),i=Math.pow(h.distanceToSquared(o),t);n<1e-4&&(n=1),e<1e-4&&(e=n),i<1e-4&&(i=n),oo.initNonuniformCatmullRom(a.x,u.x,h.x,o.x,e,n,i),lo.initNonuniformCatmullRom(a.y,u.y,h.y,o.y,e,n,i),co.initNonuniformCatmullRom(a.z,u.z,h.z,o.z,e,n,i)}else"catmullrom"===this.curveType&&(oo.initCatmullRom(a.x,u.x,h.x,o.x,this.tension),lo.initCatmullRom(a.y,u.y,h.y,o.y,this.tension),co.initCatmullRom(a.z,u.z,h.z,o.z,this.tension));return n.set(oo.calc(c),lo.calc(c),co.calc(c)),n}copy(t){super.copy(t),this.points=[];for(let e=0,n=t.points.length;e<n;e++){const n=t.points[e];this.points.push(n.clone())}return this.closed=t.closed,this.curveType=t.curveType,this.tension=t.tension,this}toJSON(){const t=super.toJSON();t.points=[];for(let e=0,n=this.points.length;e<n;e++){const n=this.points[e];t.points.push(n.toArray())}return t.closed=this.closed,t.curveType=this.curveType,t.tension=this.tension,t}fromJSON(t){super.fromJSON(t),this.points=[];for(let e=0,n=t.points.length;e<n;e++){const n=t.points[e];this.points.push((new ee).fromArray(n))}return this.closed=t.closed,this.curveType=t.curveType,this.tension=t.tension,this}}function ho(t,e,n,i,r){const s=.5*(i-e),a=.5*(r-n),o=t*t;return(2*n-2*i+s+a)*(t*o)+(-3*n+3*i-2*s-a)*o+s*t+n}function po(t,e,n,i){return function(t,e){const n=1-t;return n*n*e}(t,e)+function(t,e){return 2*(1-t)*t*e}(t,n)+function(t,e){return t*t*e}(t,i)}function fo(t,e,n,i,r){return function(t,e){const n=1-t;return n*n*n*e}(t,e)+function(t,e){const n=1-t;return 3*n*n*t*e}(t,n)+function(t,e){return 3*(1-t)*t*t*e}(t,i)+function(t,e){return t*t*t*e}(t,r)}class mo extends no{constructor(t=new At,e=new At,n=new At,i=new At){super(),this.isCubicBezierCurve=!0,this.type="CubicBezierCurve",this.v0=t,this.v1=e,this.v2=n,this.v3=i}getPoint(t,e=new At){const n=e,i=this.v0,r=this.v1,s=this.v2,a=this.v3;return n.set(fo(t,i.x,r.x,s.x,a.x),fo(t,i.y,r.y,s.y,a.y)),n}copy(t){return super.copy(t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this.v3.copy(t.v3),this}toJSON(){const t=super.toJSON();return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t.v3=this.v3.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this.v3.fromArray(t.v3),this}}class go extends no{constructor(t=new ee,e=new ee,n=new ee,i=new ee){super(),this.isCubicBezierCurve3=!0,this.type="CubicBezierCurve3",this.v0=t,this.v1=e,this.v2=n,this.v3=i}getPoint(t,e=new ee){const n=e,i=this.v0,r=this.v1,s=this.v2,a=this.v3;return n.set(fo(t,i.x,r.x,s.x,a.x),fo(t,i.y,r.y,s.y,a.y),fo(t,i.z,r.z,s.z,a.z)),n}copy(t){return super.copy(t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this.v3.copy(t.v3),this}toJSON(){const t=super.toJSON();return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t.v3=this.v3.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this.v3.fromArray(t.v3),this}}class vo extends no{constructor(t=new At,e=new At){super(),this.isLineCurve=!0,this.type="LineCurve",this.v1=t,this.v2=e}getPoint(t,e=new At){const n=e;return 1===t?n.copy(this.v2):(n.copy(this.v2).sub(this.v1),n.multiplyScalar(t).add(this.v1)),n}getPointAt(t,e){return this.getPoint(t,e)}getTangent(t,e){const n=e||new At;return n.copy(this.v2).sub(this.v1).normalize(),n}copy(t){return super.copy(t),this.v1.copy(t.v1),this.v2.copy(t.v2),this}toJSON(){const t=super.toJSON();return t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this}}class _o extends no{constructor(t=new ee,e=new ee){super(),this.isLineCurve3=!0,this.type="LineCurve3",this.v1=t,this.v2=e}getPoint(t,e=new ee){const n=e;return 1===t?n.copy(this.v2):(n.copy(this.v2).sub(this.v1),n.multiplyScalar(t).add(this.v1)),n}getPointAt(t,e){return this.getPoint(t,e)}copy(t){return super.copy(t),this.v1.copy(t.v1),this.v2.copy(t.v2),this}toJSON(){const t=super.toJSON();return t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this}}class yo extends no{constructor(t=new At,e=new At,n=new At){super(),this.isQuadraticBezierCurve=!0,this.type="QuadraticBezierCurve",this.v0=t,this.v1=e,this.v2=n}getPoint(t,e=new At){const n=e,i=this.v0,r=this.v1,s=this.v2;return n.set(po(t,i.x,r.x,s.x),po(t,i.y,r.y,s.y)),n}copy(t){return super.copy(t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this}toJSON(){const t=super.toJSON();return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this}}class xo extends no{constructor(t=new ee,e=new ee,n=new ee){super(),this.isQuadraticBezierCurve3=!0,this.type="QuadraticBezierCurve3",this.v0=t,this.v1=e,this.v2=n}getPoint(t,e=new ee){const n=e,i=this.v0,r=this.v1,s=this.v2;return n.set(po(t,i.x,r.x,s.x),po(t,i.y,r.y,s.y),po(t,i.z,r.z,s.z)),n}copy(t){return super.copy(t),this.v0.copy(t.v0),this.v1.copy(t.v1),this.v2.copy(t.v2),this}toJSON(){const t=super.toJSON();return t.v0=this.v0.toArray(),t.v1=this.v1.toArray(),t.v2=this.v2.toArray(),t}fromJSON(t){return super.fromJSON(t),this.v0.fromArray(t.v0),this.v1.fromArray(t.v1),this.v2.fromArray(t.v2),this}}class bo extends no{constructor(t=[]){super(),this.isSplineCurve=!0,this.type="SplineCurve",this.points=t}getPoint(t,e=new At){const n=e,i=this.points,r=(i.length-1)*t,s=Math.floor(r),a=r-s,o=i[0===s?s:s-1],l=i[s],c=i[s>i.length-2?i.length-1:s+1],u=i[s>i.length-3?i.length-1:s+2];return n.set(ho(a,o.x,l.x,c.x,u.x),ho(a,o.y,l.y,c.y,u.y)),n}copy(t){super.copy(t),this.points=[];for(let e=0,n=t.points.length;e<n;e++){const n=t.points[e];this.points.push(n.clone())}return this}toJSON(){const t=super.toJSON();t.points=[];for(let e=0,n=this.points.length;e<n;e++){const n=this.points[e];t.points.push(n.toArray())}return t}fromJSON(t){super.fromJSON(t),this.points=[];for(let e=0,n=t.points.length;e<n;e++){const n=t.points[e];this.points.push((new At).fromArray(n))}return this}}var Mo=Object.freeze({__proto__:null,ArcCurve:ro,CatmullRomCurve3:uo,CubicBezierCurve:mo,CubicBezierCurve3:go,EllipseCurve:io,LineCurve:vo,LineCurve3:_o,QuadraticBezierCurve:yo,QuadraticBezierCurve3:xo,SplineCurve:bo});class wo extends no{constructor(){super(),this.type="CurvePath",this.curves=[],this.autoClose=!1}add(t){this.curves.push(t)}closePath(){const t=this.curves[0].getPoint(0),e=this.curves[this.curves.length-1].getPoint(1);t.equals(e)||this.curves.push(new vo(e,t))}getPoint(t,e){const n=t*this.getLength(),i=this.getCurveLengths();let r=0;for(;r<i.length;){if(i[r]>=n){const t=i[r]-n,s=this.curves[r],a=s.getLength(),o=0===a?0:1-t/a;return s.getPointAt(o,e)}r++}return null}getLength(){const t=this.getCurveLengths();return t[t.length-1]}updateArcLengths(){this.needsUpdate=!0,this.cacheLengths=null,this.getCurveLengths()}getCurveLengths(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;const t=[];let e=0;for(let n=0,i=this.curves.length;n<i;n++)e+=this.curves[n].getLength(),t.push(e);return this.cacheLengths=t,t}getSpacedPoints(t=40){const e=[];for(let n=0;n<=t;n++)e.push(this.getPoint(n/t));return this.autoClose&&e.push(e[0]),e}getPoints(t=12){const e=[];let n;for(let i=0,r=this.curves;i<r.length;i++){const s=r[i],a=s.isEllipseCurve?2*t:s.isLineCurve||s.isLineCurve3?1:s.isSplineCurve?t*s.points.length:t,o=s.getPoints(a);for(let t=0;t<o.length;t++){const i=o[t];n&&n.equals(i)||(e.push(i),n=i)}}return this.autoClose&&e.length>1&&!e[e.length-1].equals(e[0])&&e.push(e[0]),e}copy(t){super.copy(t),this.curves=[];for(let e=0,n=t.curves.length;e<n;e++){const n=t.curves[e];this.curves.push(n.clone())}return this.autoClose=t.autoClose,this}toJSON(){const t=super.toJSON();t.autoClose=this.autoClose,t.curves=[];for(let e=0,n=this.curves.length;e<n;e++){const n=this.curves[e];t.curves.push(n.toJSON())}return t}fromJSON(t){super.fromJSON(t),this.autoClose=t.autoClose,this.curves=[];for(let e=0,n=t.curves.length;e<n;e++){const n=t.curves[e];this.curves.push((new Mo[n.type]).fromJSON(n))}return this}}class So extends wo{constructor(t){super(),this.type="Path",this.currentPoint=new At,t&&this.setFromPoints(t)}setFromPoints(t){this.moveTo(t[0].x,t[0].y);for(let e=1,n=t.length;e<n;e++)this.lineTo(t[e].x,t[e].y);return this}moveTo(t,e){return this.currentPoint.set(t,e),this}lineTo(t,e){const n=new vo(this.currentPoint.clone(),new At(t,e));return this.curves.push(n),this.currentPoint.set(t,e),this}quadraticCurveTo(t,e,n,i){const r=new yo(this.currentPoint.clone(),new At(t,e),new At(n,i));return this.curves.push(r),this.currentPoint.set(n,i),this}bezierCurveTo(t,e,n,i,r,s){const a=new mo(this.currentPoint.clone(),new At(t,e),new At(n,i),new At(r,s));return this.curves.push(a),this.currentPoint.set(r,s),this}splineThru(t){const e=[this.currentPoint.clone()].concat(t),n=new bo(e);return this.curves.push(n),this.currentPoint.copy(t[t.length-1]),this}arc(t,e,n,i,r,s){const a=this.currentPoint.x,o=this.currentPoint.y;return this.absarc(t+a,e+o,n,i,r,s),this}absarc(t,e,n,i,r,s){return this.absellipse(t,e,n,n,i,r,s),this}ellipse(t,e,n,i,r,s,a,o){const l=this.currentPoint.x,c=this.currentPoint.y;return this.absellipse(t+l,e+c,n,i,r,s,a,o),this}absellipse(t,e,n,i,r,s,a,o){const l=new io(t,e,n,i,r,s,a,o);if(this.curves.length>0){const t=l.getPoint(0);t.equals(this.currentPoint)||this.lineTo(t.x,t.y)}this.curves.push(l);const c=l.getPoint(1);return this.currentPoint.copy(c),this}copy(t){return super.copy(t),this.currentPoint.copy(t.currentPoint),this}toJSON(){const t=super.toJSON();return t.currentPoint=this.currentPoint.toArray(),t}fromJSON(t){return super.fromJSON(t),this.currentPoint.fromArray(t.currentPoint),this}}class Eo extends In{constructor(t=[new At(0,.5),new At(.5,0),new At(0,-.5)],e=12,n=0,i=2*Math.PI){super(),this.type="LatheGeometry",this.parameters={points:t,segments:e,phiStart:n,phiLength:i},e=Math.floor(e),i=xt(i,0,2*Math.PI);const r=[],s=[],a=[],o=[],l=[],c=1/e,u=new ee,h=new At,d=new ee,p=new ee,f=new ee;let m=0,g=0;for(let e=0;e<=t.length-1;e++)switch(e){case 0:m=t[e+1].x-t[e].x,g=t[e+1].y-t[e].y,d.x=1*g,d.y=-m,d.z=0*g,f.copy(d),d.normalize(),o.push(d.x,d.y,d.z);break;case t.length-1:o.push(f.x,f.y,f.z);break;default:m=t[e+1].x-t[e].x,g=t[e+1].y-t[e].y,d.x=1*g,d.y=-m,d.z=0*g,p.copy(d),d.x+=f.x,d.y+=f.y,d.z+=f.z,d.normalize(),o.push(d.x,d.y,d.z),f.copy(p)}for(let r=0;r<=e;r++){const d=n+r*c*i,p=Math.sin(d),f=Math.cos(d);for(let n=0;n<=t.length-1;n++){u.x=t[n].x*p,u.y=t[n].y,u.z=t[n].x*f,s.push(u.x,u.y,u.z),h.x=r/e,h.y=n/(t.length-1),a.push(h.x,h.y);const i=o[3*n+0]*p,c=o[3*n+1],d=o[3*n+0]*f;l.push(i,c,d)}}for(let n=0;n<e;n++)for(let e=0;e<t.length-1;e++){const i=e+n*t.length,s=i,a=i+t.length,o=i+t.length+1,l=i+1;r.push(s,a,l),r.push(o,l,a)}this.setIndex(r),this.setAttribute("position",new Sn(s,3)),this.setAttribute("uv",new Sn(a,2)),this.setAttribute("normal",new Sn(l,3))}static fromJSON(t){return new Eo(t.points,t.segments,t.phiStart,t.phiLength)}}class To extends Eo{constructor(t=1,e=1,n=4,i=8){const r=new So;r.absarc(0,-e/2,t,1.5*Math.PI,0),r.absarc(0,e/2,t,0,.5*Math.PI),super(r.getPoints(n),i),this.type="CapsuleGeometry",this.parameters={radius:t,height:e,capSegments:n,radialSegments:i}}static fromJSON(t){return new To(t.radius,t.length,t.capSegments,t.radialSegments)}}class Ao extends In{constructor(t=1,e=8,n=0,i=2*Math.PI){super(),this.type="CircleGeometry",this.parameters={radius:t,segments:e,thetaStart:n,thetaLength:i},e=Math.max(3,e);const r=[],s=[],a=[],o=[],l=new ee,c=new At;s.push(0,0,0),a.push(0,0,1),o.push(.5,.5);for(let r=0,u=3;r<=e;r++,u+=3){const h=n+r/e*i;l.x=t*Math.cos(h),l.y=t*Math.sin(h),s.push(l.x,l.y,l.z),a.push(0,0,1),c.x=(s[u]/t+1)/2,c.y=(s[u+1]/t+1)/2,o.push(c.x,c.y)}for(let t=1;t<=e;t++)r.push(t,t+1,0);this.setIndex(r),this.setAttribute("position",new Sn(s,3)),this.setAttribute("normal",new Sn(a,3)),this.setAttribute("uv",new Sn(o,2))}static fromJSON(t){return new Ao(t.radius,t.segments,t.thetaStart,t.thetaLength)}}class Ro extends In{constructor(t=1,e=1,n=1,i=8,r=1,s=!1,a=0,o=2*Math.PI){super(),this.type="CylinderGeometry",this.parameters={radiusTop:t,radiusBottom:e,height:n,radialSegments:i,heightSegments:r,openEnded:s,thetaStart:a,thetaLength:o};const l=this;i=Math.floor(i),r=Math.floor(r);const c=[],u=[],h=[],d=[];let p=0;const f=[],m=n/2;let g=0;function v(n){const r=p,s=new At,f=new ee;let v=0;const _=!0===n?t:e,y=!0===n?1:-1;for(let t=1;t<=i;t++)u.push(0,m*y,0),h.push(0,y,0),d.push(.5,.5),p++;const x=p;for(let t=0;t<=i;t++){const e=t/i*o+a,n=Math.cos(e),r=Math.sin(e);f.x=_*r,f.y=m*y,f.z=_*n,u.push(f.x,f.y,f.z),h.push(0,y,0),s.x=.5*n+.5,s.y=.5*r*y+.5,d.push(s.x,s.y),p++}for(let t=0;t<i;t++){const e=r+t,i=x+t;!0===n?c.push(i,i+1,e):c.push(i+1,i,e),v+=3}l.addGroup(g,v,!0===n?1:2),g+=v}!function(){const s=new ee,v=new ee;let _=0;const y=(e-t)/n;for(let l=0;l<=r;l++){const c=[],g=l/r,_=g*(e-t)+t;for(let t=0;t<=i;t++){const e=t/i,r=e*o+a,l=Math.sin(r),f=Math.cos(r);v.x=_*l,v.y=-g*n+m,v.z=_*f,u.push(v.x,v.y,v.z),s.set(l,y,f).normalize(),h.push(s.x,s.y,s.z),d.push(e,1-g),c.push(p++)}f.push(c)}for(let t=0;t<i;t++)for(let e=0;e<r;e++){const n=f[e][t],i=f[e+1][t],r=f[e+1][t+1],s=f[e][t+1];c.push(n,i,s),c.push(i,r,s),_+=6}l.addGroup(g,_,0),g+=_}(),!1===s&&(t>0&&v(!0),e>0&&v(!1)),this.setIndex(c),this.setAttribute("position",new Sn(u,3)),this.setAttribute("normal",new Sn(h,3)),this.setAttribute("uv",new Sn(d,2))}static fromJSON(t){return new Ro(t.radiusTop,t.radiusBottom,t.height,t.radialSegments,t.heightSegments,t.openEnded,t.thetaStart,t.thetaLength)}}class Co extends Ro{constructor(t=1,e=1,n=8,i=1,r=!1,s=0,a=2*Math.PI){super(0,t,e,n,i,r,s,a),this.type="ConeGeometry",this.parameters={radius:t,height:e,radialSegments:n,heightSegments:i,openEnded:r,thetaStart:s,thetaLength:a}}static fromJSON(t){return new Co(t.radius,t.height,t.radialSegments,t.heightSegments,t.openEnded,t.thetaStart,t.thetaLength)}}class Lo extends In{constructor(t=[],e=[],n=1,i=0){super(),this.type="PolyhedronGeometry",this.parameters={vertices:t,indices:e,radius:n,detail:i};const r=[],s=[];function a(t,e,n,i){const r=i+1,s=[];for(let i=0;i<=r;i++){s[i]=[];const a=t.clone().lerp(n,i/r),o=e.clone().lerp(n,i/r),l=r-i;for(let t=0;t<=l;t++)s[i][t]=0===t&&i===r?a:a.clone().lerp(o,t/l)}for(let t=0;t<r;t++)for(let e=0;e<2*(r-t)-1;e++){const n=Math.floor(e/2);e%2==0?(o(s[t][n+1]),o(s[t+1][n]),o(s[t][n])):(o(s[t][n+1]),o(s[t+1][n+1]),o(s[t+1][n]))}}function o(t){r.push(t.x,t.y,t.z)}function l(e,n){const i=3*e;n.x=t[i+0],n.y=t[i+1],n.z=t[i+2]}function c(t,e,n,i){i<0&&1===t.x&&(s[e]=t.x-1),0===n.x&&0===n.z&&(s[e]=i/2/Math.PI+.5)}function u(t){return Math.atan2(t.z,-t.x)}!function(t){const n=new ee,i=new ee,r=new ee;for(let s=0;s<e.length;s+=3)l(e[s+0],n),l(e[s+1],i),l(e[s+2],r),a(n,i,r,t)}(i),function(t){const e=new ee;for(let n=0;n<r.length;n+=3)e.x=r[n+0],e.y=r[n+1],e.z=r[n+2],e.normalize().multiplyScalar(t),r[n+0]=e.x,r[n+1]=e.y,r[n+2]=e.z}(n),function(){const t=new ee;for(let n=0;n<r.length;n+=3){t.x=r[n+0],t.y=r[n+1],t.z=r[n+2];const i=u(t)/2/Math.PI+.5,a=(e=t,Math.atan2(-e.y,Math.sqrt(e.x*e.x+e.z*e.z))/Math.PI+.5);s.push(i,1-a)}var e;(function(){const t=new ee,e=new ee,n=new ee,i=new ee,a=new At,o=new At,l=new At;for(let h=0,d=0;h<r.length;h+=9,d+=6){t.set(r[h+0],r[h+1],r[h+2]),e.set(r[h+3],r[h+4],r[h+5]),n.set(r[h+6],r[h+7],r[h+8]),a.set(s[d+0],s[d+1]),o.set(s[d+2],s[d+3]),l.set(s[d+4],s[d+5]),i.copy(t).add(e).add(n).divideScalar(3);const p=u(i);c(a,d+0,t,p),c(o,d+2,e,p),c(l,d+4,n,p)}})(),function(){for(let t=0;t<s.length;t+=6){const e=s[t+0],n=s[t+2],i=s[t+4],r=Math.max(e,n,i),a=Math.min(e,n,i);r>.9&&a<.1&&(e<.2&&(s[t+0]+=1),n<.2&&(s[t+2]+=1),i<.2&&(s[t+4]+=1))}}()}(),this.setAttribute("position",new Sn(r,3)),this.setAttribute("normal",new Sn(r.slice(),3)),this.setAttribute("uv",new Sn(s,2)),0===i?this.computeVertexNormals():this.normalizeNormals()}static fromJSON(t){return new Lo(t.vertices,t.indices,t.radius,t.details)}}class Po extends Lo{constructor(t=1,e=0){const n=(1+Math.sqrt(5))/2,i=1/n;super([-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-i,-n,0,-i,n,0,i,-n,0,i,n,-i,-n,0,-i,n,0,i,-n,0,i,n,0,-n,0,-i,n,0,-i,-n,0,i,n,0,i],[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9],t,e),this.type="DodecahedronGeometry",this.parameters={radius:t,detail:e}}static fromJSON(t){return new Po(t.radius,t.detail)}}const Io=new ee,Do=new ee,Oo=new ee,No=new mn;class Uo extends In{constructor(t=null,e=1){if(super(),this.type="EdgesGeometry",this.parameters={geometry:t,thresholdAngle:e},null!==t){const n=4,i=Math.pow(10,n),r=Math.cos(vt*e),s=t.getIndex(),a=t.getAttribute("position"),o=s?s.count:a.count,l=[0,0,0],c=["a","b","c"],u=new Array(3),h={},d=[];for(let t=0;t<o;t+=3){s?(l[0]=s.getX(t),l[1]=s.getX(t+1),l[2]=s.getX(t+2)):(l[0]=t,l[1]=t+1,l[2]=t+2);const{a:e,b:n,c:o}=No;if(e.fromBufferAttribute(a,l[0]),n.fromBufferAttribute(a,l[1]),o.fromBufferAttribute(a,l[2]),No.getNormal(Oo),u[0]=`${Math.round(e.x*i)},${Math.round(e.y*i)},${Math.round(e.z*i)}`,u[1]=`${Math.round(n.x*i)},${Math.round(n.y*i)},${Math.round(n.z*i)}`,u[2]=`${Math.round(o.x*i)},${Math.round(o.y*i)},${Math.round(o.z*i)}`,u[0]!==u[1]&&u[1]!==u[2]&&u[2]!==u[0])for(let t=0;t<3;t++){const e=(t+1)%3,n=u[t],i=u[e],s=No[c[t]],a=No[c[e]],o=`${n}_${i}`,p=`${i}_${n}`;p in h&&h[p]?(Oo.dot(h[p].normal)<=r&&(d.push(s.x,s.y,s.z),d.push(a.x,a.y,a.z)),h[p]=null):o in h||(h[o]={index0:l[t],index1:l[e],normal:Oo.clone()})}}for(const t in h)if(h[t]){const{index0:e,index1:n}=h[t];Io.fromBufferAttribute(a,e),Do.fromBufferAttribute(a,n),d.push(Io.x,Io.y,Io.z),d.push(Do.x,Do.y,Do.z)}this.setAttribute("position",new Sn(d,3))}}}class Fo extends So{constructor(t){super(t),this.uuid=yt(),this.type="Shape",this.holes=[]}getPointsHoles(t){const e=[];for(let n=0,i=this.holes.length;n<i;n++)e[n]=this.holes[n].getPoints(t);return e}extractPoints(t){return{shape:this.getPoints(t),holes:this.getPointsHoles(t)}}copy(t){super.copy(t),this.holes=[];for(let e=0,n=t.holes.length;e<n;e++){const n=t.holes[e];this.holes.push(n.clone())}return this}toJSON(){const t=super.toJSON();t.uuid=this.uuid,t.holes=[];for(let e=0,n=this.holes.length;e<n;e++){const n=this.holes[e];t.holes.push(n.toJSON())}return t}fromJSON(t){super.fromJSON(t),this.uuid=t.uuid,this.holes=[];for(let e=0,n=t.holes.length;e<n;e++){const n=t.holes[e];this.holes.push((new So).fromJSON(n))}return this}}function Bo(t,e,n,i,r){let s,a;if(r===function(t,e,n,i){let r=0;for(let s=e,a=n-i;s<n;s+=i)r+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return r}(t,e,n,i)>0)for(s=e;s<n;s+=i)a=sl(s,t[s],t[s+1],a);else for(s=n-i;s>=e;s-=i)a=sl(s,t[s],t[s+1],a);return a&&Qo(a,a.next)&&(al(a),a=a.next),a}function zo(t,e){if(!t)return t;e||(e=t);let n,i=t;do{if(n=!1,i.steiner||!Qo(i,i.next)&&0!==$o(i.prev,i,i.next))i=i.next;else{if(al(i),i=e=i.prev,i===i.next)break;n=!0}}while(n||i!==e);return e}function ko(t,e,n,i,r,s,a){if(!t)return;!a&&s&&function(t,e,n,i){let r=t;do{null===r.z&&(r.z=qo(r.x,r.y,e,n,i)),r.prevZ=r.prev,r.nextZ=r.next,r=r.next}while(r!==t);r.prevZ.nextZ=null,r.prevZ=null,function(t){let e,n,i,r,s,a,o,l,c=1;do{for(n=t,t=null,s=null,a=0;n;){for(a++,i=n,o=0,e=0;e<c&&(o++,i=i.nextZ,i);e++);for(l=c;o>0||l>0&&i;)0!==o&&(0===l||!i||n.z<=i.z)?(r=n,n=n.nextZ,o--):(r=i,i=i.nextZ,l--),s?s.nextZ=r:t=r,r.prevZ=s,s=r;n=i}s.nextZ=null,c*=2}while(a>1)}(r)}(t,i,r,s);let o,l,c=t;for(;t.prev!==t.next;)if(o=t.prev,l=t.next,s?Vo(t,i,r,s):Go(t))e.push(o.i/n),e.push(t.i/n),e.push(l.i/n),al(t),t=l.next,c=l.next;else if((t=l)===c){a?1===a?ko(t=Ho(zo(t),e,n),e,n,i,r,s,2):2===a&&Wo(t,e,n,i,r,s):ko(zo(t),e,n,i,r,s,1);break}}function Go(t){const e=t.prev,n=t,i=t.next;if($o(e,n,i)>=0)return!1;let r=t.next.next;for(;r!==t.prev;){if(Jo(e.x,e.y,n.x,n.y,i.x,i.y,r.x,r.y)&&$o(r.prev,r,r.next)>=0)return!1;r=r.next}return!0}function Vo(t,e,n,i){const r=t.prev,s=t,a=t.next;if($o(r,s,a)>=0)return!1;const o=r.x<s.x?r.x<a.x?r.x:a.x:s.x<a.x?s.x:a.x,l=r.y<s.y?r.y<a.y?r.y:a.y:s.y<a.y?s.y:a.y,c=r.x>s.x?r.x>a.x?r.x:a.x:s.x>a.x?s.x:a.x,u=r.y>s.y?r.y>a.y?r.y:a.y:s.y>a.y?s.y:a.y,h=qo(o,l,e,n,i),d=qo(c,u,e,n,i);let p=t.prevZ,f=t.nextZ;for(;p&&p.z>=h&&f&&f.z<=d;){if(p!==t.prev&&p!==t.next&&Jo(r.x,r.y,s.x,s.y,a.x,a.y,p.x,p.y)&&$o(p.prev,p,p.next)>=0)return!1;if(p=p.prevZ,f!==t.prev&&f!==t.next&&Jo(r.x,r.y,s.x,s.y,a.x,a.y,f.x,f.y)&&$o(f.prev,f,f.next)>=0)return!1;f=f.nextZ}for(;p&&p.z>=h;){if(p!==t.prev&&p!==t.next&&Jo(r.x,r.y,s.x,s.y,a.x,a.y,p.x,p.y)&&$o(p.prev,p,p.next)>=0)return!1;p=p.prevZ}for(;f&&f.z<=d;){if(f!==t.prev&&f!==t.next&&Jo(r.x,r.y,s.x,s.y,a.x,a.y,f.x,f.y)&&$o(f.prev,f,f.next)>=0)return!1;f=f.nextZ}return!0}function Ho(t,e,n){let i=t;do{const r=i.prev,s=i.next.next;!Qo(r,s)&&tl(r,i,i.next,s)&&il(r,s)&&il(s,r)&&(e.push(r.i/n),e.push(i.i/n),e.push(s.i/n),al(i),al(i.next),i=t=s),i=i.next}while(i!==t);return zo(i)}function Wo(t,e,n,i,r,s){let a=t;do{let t=a.next.next;for(;t!==a.prev;){if(a.i!==t.i&&Ko(a,t)){let o=rl(a,t);return a=zo(a,a.next),o=zo(o,o.next),ko(a,e,n,i,r,s),void ko(o,e,n,i,r,s)}t=t.next}a=a.next}while(a!==t)}function jo(t,e){return t.x-e.x}function Xo(t,e){if(e=function(t,e){let n=e;const i=t.x,r=t.y;let s,a=-1/0;do{if(r<=n.y&&r>=n.next.y&&n.next.y!==n.y){const t=n.x+(r-n.y)*(n.next.x-n.x)/(n.next.y-n.y);if(t<=i&&t>a){if(a=t,t===i){if(r===n.y)return n;if(r===n.next.y)return n.next}s=n.x<n.next.x?n:n.next}}n=n.next}while(n!==e);if(!s)return null;if(i===a)return s;const o=s,l=s.x,c=s.y;let u,h=1/0;n=s;do{i>=n.x&&n.x>=l&&i!==n.x&&Jo(r<c?i:a,r,l,c,r<c?a:i,r,n.x,n.y)&&(u=Math.abs(r-n.y)/(i-n.x),il(n,t)&&(u<h||u===h&&(n.x>s.x||n.x===s.x&&Yo(s,n)))&&(s=n,h=u)),n=n.next}while(n!==o);return s}(t,e),e){const n=rl(e,t);zo(e,e.next),zo(n,n.next)}}function Yo(t,e){return $o(t.prev,t,e.prev)<0&&$o(e.next,t,t.next)<0}function qo(t,e,n,i,r){return(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-n)*r)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-i)*r)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function Zo(t){let e=t,n=t;do{(e.x<n.x||e.x===n.x&&e.y<n.y)&&(n=e),e=e.next}while(e!==t);return n}function Jo(t,e,n,i,r,s,a,o){return(r-a)*(e-o)-(t-a)*(s-o)>=0&&(t-a)*(i-o)-(n-a)*(e-o)>=0&&(n-a)*(s-o)-(r-a)*(i-o)>=0}function Ko(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){let n=t;do{if(n.i!==t.i&&n.next.i!==t.i&&n.i!==e.i&&n.next.i!==e.i&&tl(n,n.next,t,e))return!0;n=n.next}while(n!==t);return!1}(t,e)&&(il(t,e)&&il(e,t)&&function(t,e){let n=t,i=!1;const r=(t.x+e.x)/2,s=(t.y+e.y)/2;do{n.y>s!=n.next.y>s&&n.next.y!==n.y&&r<(n.next.x-n.x)*(s-n.y)/(n.next.y-n.y)+n.x&&(i=!i),n=n.next}while(n!==t);return i}(t,e)&&($o(t.prev,t,e.prev)||$o(t,e.prev,e))||Qo(t,e)&&$o(t.prev,t,t.next)>0&&$o(e.prev,e,e.next)>0)}function $o(t,e,n){return(e.y-t.y)*(n.x-e.x)-(e.x-t.x)*(n.y-e.y)}function Qo(t,e){return t.x===e.x&&t.y===e.y}function tl(t,e,n,i){const r=nl($o(t,e,n)),s=nl($o(t,e,i)),a=nl($o(n,i,t)),o=nl($o(n,i,e));return r!==s&&a!==o||!(0!==r||!el(t,n,e))||!(0!==s||!el(t,i,e))||!(0!==a||!el(n,t,i))||!(0!==o||!el(n,e,i))}function el(t,e,n){return e.x<=Math.max(t.x,n.x)&&e.x>=Math.min(t.x,n.x)&&e.y<=Math.max(t.y,n.y)&&e.y>=Math.min(t.y,n.y)}function nl(t){return t>0?1:t<0?-1:0}function il(t,e){return $o(t.prev,t,t.next)<0?$o(t,e,t.next)>=0&&$o(t,t.prev,e)>=0:$o(t,e,t.prev)<0||$o(t,t.next,e)<0}function rl(t,e){const n=new ol(t.i,t.x,t.y),i=new ol(e.i,e.x,e.y),r=t.next,s=e.prev;return t.next=e,e.prev=t,n.next=r,r.prev=n,i.next=n,n.prev=i,s.next=i,i.prev=s,i}function sl(t,e,n,i){const r=new ol(t,e,n);return i?(r.next=i.next,r.prev=i,i.next.prev=r,i.next=r):(r.prev=r,r.next=r),r}function al(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ)}function ol(t,e,n){this.i=t,this.x=e,this.y=n,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1}class ll{static area(t){const e=t.length;let n=0;for(let i=e-1,r=0;r<e;i=r++)n+=t[i].x*t[r].y-t[r].x*t[i].y;return.5*n}static isClockWise(t){return ll.area(t)<0}static triangulateShape(t,e){const n=[],i=[],r=[];cl(t),ul(n,t);let s=t.length;e.forEach(cl);for(let t=0;t<e.length;t++)i.push(s),s+=e[t].length,ul(n,e[t]);const a=function(t,e,n=2){const i=e&&e.length,r=i?e[0]*n:t.length;let s=Bo(t,0,r,n,!0);const a=[];if(!s||s.next===s.prev)return a;let o,l,c,u,h,d,p;if(i&&(s=function(t,e,n,i){const r=[];let s,a,o,l,c;for(s=0,a=e.length;s<a;s++)o=e[s]*i,l=s<a-1?e[s+1]*i:t.length,c=Bo(t,o,l,i,!1),c===c.next&&(c.steiner=!0),r.push(Zo(c));for(r.sort(jo),s=0;s<r.length;s++)Xo(r[s],n),n=zo(n,n.next);return n}(t,e,s,n)),t.length>80*n){o=c=t[0],l=u=t[1];for(let e=n;e<r;e+=n)h=t[e],d=t[e+1],h<o&&(o=h),d<l&&(l=d),h>c&&(c=h),d>u&&(u=d);p=Math.max(c-o,u-l),p=0!==p?1/p:0}return ko(s,a,n,o,l,p),a}(n,i);for(let t=0;t<a.length;t+=3)r.push(a.slice(t,t+3));return r}}function cl(t){const e=t.length;e>2&&t[e-1].equals(t[0])&&t.pop()}function ul(t,e){for(let n=0;n<e.length;n++)t.push(e[n].x),t.push(e[n].y)}class hl extends In{constructor(t=new Fo([new At(.5,.5),new At(-.5,.5),new At(-.5,-.5),new At(.5,-.5)]),e={}){super(),this.type="ExtrudeGeometry",this.parameters={shapes:t,options:e},t=Array.isArray(t)?t:[t];const n=this,i=[],r=[];for(let e=0,n=t.length;e<n;e++)s(t[e]);function s(t){const s=[],a=void 0!==e.curveSegments?e.curveSegments:12,o=void 0!==e.steps?e.steps:1;let l=void 0!==e.depth?e.depth:1,c=void 0===e.bevelEnabled||e.bevelEnabled,u=void 0!==e.bevelThickness?e.bevelThickness:.2,h=void 0!==e.bevelSize?e.bevelSize:u-.1,d=void 0!==e.bevelOffset?e.bevelOffset:0,p=void 0!==e.bevelSegments?e.bevelSegments:3;const f=e.extrudePath,m=void 0!==e.UVGenerator?e.UVGenerator:dl;void 0!==e.amount&&(console.warn("THREE.ExtrudeBufferGeometry: amount has been renamed to depth."),l=e.amount);let g,v,_,y,x,b=!1;f&&(g=f.getSpacedPoints(o),b=!0,c=!1,v=f.computeFrenetFrames(o,!1),_=new ee,y=new ee,x=new ee),c||(p=0,u=0,h=0,d=0);const M=t.extractPoints(a);let w=M.shape;const S=M.holes;if(!ll.isClockWise(w)){w=w.reverse();for(let t=0,e=S.length;t<e;t++){const e=S[t];ll.isClockWise(e)&&(S[t]=e.reverse())}}const E=ll.triangulateShape(w,S),T=w;for(let t=0,e=S.length;t<e;t++){const e=S[t];w=w.concat(e)}function A(t,e,n){return e||console.error("THREE.ExtrudeGeometry: vec does not exist"),e.clone().multiplyScalar(n).add(t)}const R=w.length,C=E.length;function L(t,e,n){let i,r,s;const a=t.x-e.x,o=t.y-e.y,l=n.x-t.x,c=n.y-t.y,u=a*a+o*o,h=a*c-o*l;if(Math.abs(h)>Number.EPSILON){const h=Math.sqrt(u),d=Math.sqrt(l*l+c*c),p=e.x-o/h,f=e.y+a/h,m=((n.x-c/d-p)*c-(n.y+l/d-f)*l)/(a*c-o*l);i=p+a*m-t.x,r=f+o*m-t.y;const g=i*i+r*r;if(g<=2)return new At(i,r);s=Math.sqrt(g/2)}else{let t=!1;a>Number.EPSILON?l>Number.EPSILON&&(t=!0):a<-Number.EPSILON?l<-Number.EPSILON&&(t=!0):Math.sign(o)===Math.sign(c)&&(t=!0),t?(i=-o,r=a,s=Math.sqrt(u)):(i=a,r=o,s=Math.sqrt(u/2))}return new At(i/s,r/s)}const P=[];for(let t=0,e=T.length,n=e-1,i=t+1;t<e;t++,n++,i++)n===e&&(n=0),i===e&&(i=0),P[t]=L(T[t],T[n],T[i]);const I=[];let D,O=P.concat();for(let t=0,e=S.length;t<e;t++){const e=S[t];D=[];for(let t=0,n=e.length,i=n-1,r=t+1;t<n;t++,i++,r++)i===n&&(i=0),r===n&&(r=0),D[t]=L(e[t],e[i],e[r]);I.push(D),O=O.concat(D)}for(let t=0;t<p;t++){const e=t/p,n=u*Math.cos(e*Math.PI/2),i=h*Math.sin(e*Math.PI/2)+d;for(let t=0,e=T.length;t<e;t++){const e=A(T[t],P[t],i);F(e.x,e.y,-n)}for(let t=0,e=S.length;t<e;t++){const e=S[t];D=I[t];for(let t=0,r=e.length;t<r;t++){const r=A(e[t],D[t],i);F(r.x,r.y,-n)}}}const N=h+d;for(let t=0;t<R;t++){const e=c?A(w[t],O[t],N):w[t];b?(y.copy(v.normals[0]).multiplyScalar(e.x),_.copy(v.binormals[0]).multiplyScalar(e.y),x.copy(g[0]).add(y).add(_),F(x.x,x.y,x.z)):F(e.x,e.y,0)}for(let t=1;t<=o;t++)for(let e=0;e<R;e++){const n=c?A(w[e],O[e],N):w[e];b?(y.copy(v.normals[t]).multiplyScalar(n.x),_.copy(v.binormals[t]).multiplyScalar(n.y),x.copy(g[t]).add(y).add(_),F(x.x,x.y,x.z)):F(n.x,n.y,l/o*t)}for(let t=p-1;t>=0;t--){const e=t/p,n=u*Math.cos(e*Math.PI/2),i=h*Math.sin(e*Math.PI/2)+d;for(let t=0,e=T.length;t<e;t++){const e=A(T[t],P[t],i);F(e.x,e.y,l+n)}for(let t=0,e=S.length;t<e;t++){const e=S[t];D=I[t];for(let t=0,r=e.length;t<r;t++){const r=A(e[t],D[t],i);b?F(r.x,r.y+g[o-1].y,g[o-1].x+n):F(r.x,r.y,l+n)}}}function U(t,e){let n=t.length;for(;--n>=0;){const i=n;let r=n-1;r<0&&(r=t.length-1);for(let t=0,n=o+2*p;t<n;t++){const n=R*t,s=R*(t+1);z(e+i+n,e+r+n,e+r+s,e+i+s)}}}function F(t,e,n){s.push(t),s.push(e),s.push(n)}function B(t,e,r){k(t),k(e),k(r);const s=i.length/3,a=m.generateTopUV(n,i,s-3,s-2,s-1);G(a[0]),G(a[1]),G(a[2])}function z(t,e,r,s){k(t),k(e),k(s),k(e),k(r),k(s);const a=i.length/3,o=m.generateSideWallUV(n,i,a-6,a-3,a-2,a-1);G(o[0]),G(o[1]),G(o[3]),G(o[1]),G(o[2]),G(o[3])}function k(t){i.push(s[3*t+0]),i.push(s[3*t+1]),i.push(s[3*t+2])}function G(t){r.push(t.x),r.push(t.y)}!function(){const t=i.length/3;if(c){let t=0,e=R*t;for(let t=0;t<C;t++){const n=E[t];B(n[2]+e,n[1]+e,n[0]+e)}t=o+2*p,e=R*t;for(let t=0;t<C;t++){const n=E[t];B(n[0]+e,n[1]+e,n[2]+e)}}else{for(let t=0;t<C;t++){const e=E[t];B(e[2],e[1],e[0])}for(let t=0;t<C;t++){const e=E[t];B(e[0]+R*o,e[1]+R*o,e[2]+R*o)}}n.addGroup(t,i.length/3-t,0)}(),function(){const t=i.length/3;let e=0;U(T,e),e+=T.length;for(let t=0,n=S.length;t<n;t++){const n=S[t];U(n,e),e+=n.length}n.addGroup(t,i.length/3-t,1)}()}this.setAttribute("position",new Sn(i,3)),this.setAttribute("uv",new Sn(r,2)),this.computeVertexNormals()}toJSON(){const t=super.toJSON();return function(t,e,n){if(n.shapes=[],Array.isArray(t))for(let e=0,i=t.length;e<i;e++){const i=t[e];n.shapes.push(i.uuid)}else n.shapes.push(t.uuid);return n.options=Object.assign({},e),void 0!==e.extrudePath&&(n.options.extrudePath=e.extrudePath.toJSON()),n}(this.parameters.shapes,this.parameters.options,t)}static fromJSON(t,e){const n=[];for(let i=0,r=t.shapes.length;i<r;i++){const r=e[t.shapes[i]];n.push(r)}const i=t.options.extrudePath;return void 0!==i&&(t.options.extrudePath=(new Mo[i.type]).fromJSON(i)),new hl(n,t.options)}}const dl={generateTopUV:function(t,e,n,i,r){const s=e[3*n],a=e[3*n+1],o=e[3*i],l=e[3*i+1],c=e[3*r],u=e[3*r+1];return[new At(s,a),new At(o,l),new At(c,u)]},generateSideWallUV:function(t,e,n,i,r,s){const a=e[3*n],o=e[3*n+1],l=e[3*n+2],c=e[3*i],u=e[3*i+1],h=e[3*i+2],d=e[3*r],p=e[3*r+1],f=e[3*r+2],m=e[3*s],g=e[3*s+1],v=e[3*s+2];return Math.abs(o-u)<Math.abs(a-c)?[new At(a,1-l),new At(c,1-h),new At(d,1-f),new At(m,1-v)]:[new At(o,1-l),new At(u,1-h),new At(p,1-f),new At(g,1-v)]}};class pl extends Lo{constructor(t=1,e=0){const n=(1+Math.sqrt(5))/2;super([-1,n,0,1,n,0,-1,-n,0,1,-n,0,0,-1,n,0,1,n,0,-1,-n,0,1,-n,n,0,-1,n,0,1,-n,0,-1,-n,0,1],[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1],t,e),this.type="IcosahedronGeometry",this.parameters={radius:t,detail:e}}static fromJSON(t){return new pl(t.radius,t.detail)}}class fl extends Lo{constructor(t=1,e=0){super([1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2],t,e),this.type="OctahedronGeometry",this.parameters={radius:t,detail:e}}static fromJSON(t){return new fl(t.radius,t.detail)}}class ml extends In{constructor(t=.5,e=1,n=8,i=1,r=0,s=2*Math.PI){super(),this.type="RingGeometry",this.parameters={innerRadius:t,outerRadius:e,thetaSegments:n,phiSegments:i,thetaStart:r,thetaLength:s},n=Math.max(3,n);const a=[],o=[],l=[],c=[];let u=t;const h=(e-t)/(i=Math.max(1,i)),d=new ee,p=new At;for(let t=0;t<=i;t++){for(let t=0;t<=n;t++){const i=r+t/n*s;d.x=u*Math.cos(i),d.y=u*Math.sin(i),o.push(d.x,d.y,d.z),l.push(0,0,1),p.x=(d.x/e+1)/2,p.y=(d.y/e+1)/2,c.push(p.x,p.y)}u+=h}for(let t=0;t<i;t++){const e=t*(n+1);for(let t=0;t<n;t++){const i=t+e,r=i,s=i+n+1,o=i+n+2,l=i+1;a.push(r,s,l),a.push(s,o,l)}}this.setIndex(a),this.setAttribute("position",new Sn(o,3)),this.setAttribute("normal",new Sn(l,3)),this.setAttribute("uv",new Sn(c,2))}static fromJSON(t){return new ml(t.innerRadius,t.outerRadius,t.thetaSegments,t.phiSegments,t.thetaStart,t.thetaLength)}}class gl extends In{constructor(t=new Fo([new At(0,.5),new At(-.5,-.5),new At(.5,-.5)]),e=12){super(),this.type="ShapeGeometry",this.parameters={shapes:t,curveSegments:e};const n=[],i=[],r=[],s=[];let a=0,o=0;if(!1===Array.isArray(t))l(t);else for(let e=0;e<t.length;e++)l(t[e]),this.addGroup(a,o,e),a+=o,o=0;function l(t){const a=i.length/3,l=t.extractPoints(e);let c=l.shape;const u=l.holes;!1===ll.isClockWise(c)&&(c=c.reverse());for(let t=0,e=u.length;t<e;t++){const e=u[t];!0===ll.isClockWise(e)&&(u[t]=e.reverse())}const h=ll.triangulateShape(c,u);for(let t=0,e=u.length;t<e;t++){const e=u[t];c=c.concat(e)}for(let t=0,e=c.length;t<e;t++){const e=c[t];i.push(e.x,e.y,0),r.push(0,0,1),s.push(e.x,e.y)}for(let t=0,e=h.length;t<e;t++){const e=h[t],i=e[0]+a,r=e[1]+a,s=e[2]+a;n.push(i,r,s),o+=3}}this.setIndex(n),this.setAttribute("position",new Sn(i,3)),this.setAttribute("normal",new Sn(r,3)),this.setAttribute("uv",new Sn(s,2))}toJSON(){const t=super.toJSON();return function(t,e){if(e.shapes=[],Array.isArray(t))for(let n=0,i=t.length;n<i;n++){const i=t[n];e.shapes.push(i.uuid)}else e.shapes.push(t.uuid);return e}(this.parameters.shapes,t)}static fromJSON(t,e){const n=[];for(let i=0,r=t.shapes.length;i<r;i++){const r=e[t.shapes[i]];n.push(r)}return new gl(n,t.curveSegments)}}class vl extends In{constructor(t=1,e=32,n=16,i=0,r=2*Math.PI,s=0,a=Math.PI){super(),this.type="SphereGeometry",this.parameters={radius:t,widthSegments:e,heightSegments:n,phiStart:i,phiLength:r,thetaStart:s,thetaLength:a},e=Math.max(3,Math.floor(e)),n=Math.max(2,Math.floor(n));const o=Math.min(s+a,Math.PI);let l=0;const c=[],u=new ee,h=new ee,d=[],p=[],f=[],m=[];for(let d=0;d<=n;d++){const g=[],v=d/n;let _=0;0==d&&0==s?_=.5/e:d==n&&o==Math.PI&&(_=-.5/e);for(let n=0;n<=e;n++){const o=n/e;u.x=-t*Math.cos(i+o*r)*Math.sin(s+v*a),u.y=t*Math.cos(s+v*a),u.z=t*Math.sin(i+o*r)*Math.sin(s+v*a),p.push(u.x,u.y,u.z),h.copy(u).normalize(),f.push(h.x,h.y,h.z),m.push(o+_,1-v),g.push(l++)}c.push(g)}for(let t=0;t<n;t++)for(let i=0;i<e;i++){const e=c[t][i+1],r=c[t][i],a=c[t+1][i],l=c[t+1][i+1];(0!==t||s>0)&&d.push(e,r,l),(t!==n-1||o<Math.PI)&&d.push(r,a,l)}this.setIndex(d),this.setAttribute("position",new Sn(p,3)),this.setAttribute("normal",new Sn(f,3)),this.setAttribute("uv",new Sn(m,2))}static fromJSON(t){return new vl(t.radius,t.widthSegments,t.heightSegments,t.phiStart,t.phiLength,t.thetaStart,t.thetaLength)}}class _l extends Lo{constructor(t=1,e=0){super([1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],[2,1,0,0,3,2,1,3,0,2,3,1],t,e),this.type="TetrahedronGeometry",this.parameters={radius:t,detail:e}}static fromJSON(t){return new _l(t.radius,t.detail)}}class yl extends In{constructor(t=1,e=.4,n=8,i=6,r=2*Math.PI){super(),this.type="TorusGeometry",this.parameters={radius:t,tube:e,radialSegments:n,tubularSegments:i,arc:r},n=Math.floor(n),i=Math.floor(i);const s=[],a=[],o=[],l=[],c=new ee,u=new ee,h=new ee;for(let s=0;s<=n;s++)for(let d=0;d<=i;d++){const p=d/i*r,f=s/n*Math.PI*2;u.x=(t+e*Math.cos(f))*Math.cos(p),u.y=(t+e*Math.cos(f))*Math.sin(p),u.z=e*Math.sin(f),a.push(u.x,u.y,u.z),c.x=t*Math.cos(p),c.y=t*Math.sin(p),h.subVectors(u,c).normalize(),o.push(h.x,h.y,h.z),l.push(d/i),l.push(s/n)}for(let t=1;t<=n;t++)for(let e=1;e<=i;e++){const n=(i+1)*t+e-1,r=(i+1)*(t-1)+e-1,a=(i+1)*(t-1)+e,o=(i+1)*t+e;s.push(n,r,o),s.push(r,a,o)}this.setIndex(s),this.setAttribute("position",new Sn(a,3)),this.setAttribute("normal",new Sn(o,3)),this.setAttribute("uv",new Sn(l,2))}static fromJSON(t){return new yl(t.radius,t.tube,t.radialSegments,t.tubularSegments,t.arc)}}class xl extends In{constructor(t=1,e=.4,n=64,i=8,r=2,s=3){super(),this.type="TorusKnotGeometry",this.parameters={radius:t,tube:e,tubularSegments:n,radialSegments:i,p:r,q:s},n=Math.floor(n),i=Math.floor(i);const a=[],o=[],l=[],c=[],u=new ee,h=new ee,d=new ee,p=new ee,f=new ee,m=new ee,g=new ee;for(let a=0;a<=n;++a){const _=a/n*r*Math.PI*2;v(_,r,s,t,d),v(_+.01,r,s,t,p),m.subVectors(p,d),g.addVectors(p,d),f.crossVectors(m,g),g.crossVectors(f,m),f.normalize(),g.normalize();for(let t=0;t<=i;++t){const r=t/i*Math.PI*2,s=-e*Math.cos(r),p=e*Math.sin(r);u.x=d.x+(s*g.x+p*f.x),u.y=d.y+(s*g.y+p*f.y),u.z=d.z+(s*g.z+p*f.z),o.push(u.x,u.y,u.z),h.subVectors(u,d).normalize(),l.push(h.x,h.y,h.z),c.push(a/n),c.push(t/i)}}for(let t=1;t<=n;t++)for(let e=1;e<=i;e++){const n=(i+1)*(t-1)+(e-1),r=(i+1)*t+(e-1),s=(i+1)*t+e,o=(i+1)*(t-1)+e;a.push(n,r,o),a.push(r,s,o)}function v(t,e,n,i,r){const s=Math.cos(t),a=Math.sin(t),o=n/e*t,l=Math.cos(o);r.x=i*(2+l)*.5*s,r.y=i*(2+l)*a*.5,r.z=i*Math.sin(o)*.5}this.setIndex(a),this.setAttribute("position",new Sn(o,3)),this.setAttribute("normal",new Sn(l,3)),this.setAttribute("uv",new Sn(c,2))}static fromJSON(t){return new xl(t.radius,t.tube,t.tubularSegments,t.radialSegments,t.p,t.q)}}class bl extends In{constructor(t=new xo(new ee(-1,-1,0),new ee(-1,1,0),new ee(1,1,0)),e=64,n=1,i=8,r=!1){super(),this.type="TubeGeometry",this.parameters={path:t,tubularSegments:e,radius:n,radialSegments:i,closed:r};const s=t.computeFrenetFrames(e,r);this.tangents=s.tangents,this.normals=s.normals,this.binormals=s.binormals;const a=new ee,o=new ee,l=new At;let c=new ee;const u=[],h=[],d=[],p=[];function f(r){c=t.getPointAt(r/e,c);const l=s.normals[r],d=s.binormals[r];for(let t=0;t<=i;t++){const e=t/i*Math.PI*2,r=Math.sin(e),s=-Math.cos(e);o.x=s*l.x+r*d.x,o.y=s*l.y+r*d.y,o.z=s*l.z+r*d.z,o.normalize(),h.push(o.x,o.y,o.z),a.x=c.x+n*o.x,a.y=c.y+n*o.y,a.z=c.z+n*o.z,u.push(a.x,a.y,a.z)}}!function(){for(let t=0;t<e;t++)f(t);f(!1===r?e:0),function(){for(let t=0;t<=e;t++)for(let n=0;n<=i;n++)l.x=t/e,l.y=n/i,d.push(l.x,l.y)}(),function(){for(let t=1;t<=e;t++)for(let e=1;e<=i;e++){const n=(i+1)*(t-1)+(e-1),r=(i+1)*t+(e-1),s=(i+1)*t+e,a=(i+1)*(t-1)+e;p.push(n,r,a),p.push(r,s,a)}}()}(),this.setIndex(p),this.setAttribute("position",new Sn(u,3)),this.setAttribute("normal",new Sn(h,3)),this.setAttribute("uv",new Sn(d,2))}toJSON(){const t=super.toJSON();return t.path=this.parameters.path.toJSON(),t}static fromJSON(t){return new bl((new Mo[t.path.type]).fromJSON(t.path),t.tubularSegments,t.radius,t.radialSegments,t.closed)}}class Ml extends In{constructor(t=null){if(super(),this.type="WireframeGeometry",this.parameters={geometry:t},null!==t){const e=[],n=new Set,i=new ee,r=new ee;if(null!==t.index){const s=t.attributes.position,a=t.index;let o=t.groups;0===o.length&&(o=[{start:0,count:a.count,materialIndex:0}]);for(let t=0,l=o.length;t<l;++t){const l=o[t],c=l.start;for(let t=c,o=c+l.count;t<o;t+=3)for(let o=0;o<3;o++){const l=a.getX(t+o),c=a.getX(t+(o+1)%3);i.fromBufferAttribute(s,l),r.fromBufferAttribute(s,c),!0===wl(i,r,n)&&(e.push(i.x,i.y,i.z),e.push(r.x,r.y,r.z))}}}else{const s=t.attributes.position;for(let t=0,a=s.count/3;t<a;t++)for(let a=0;a<3;a++){const o=3*t+a,l=3*t+(a+1)%3;i.fromBufferAttribute(s,o),r.fromBufferAttribute(s,l),!0===wl(i,r,n)&&(e.push(i.x,i.y,i.z),e.push(r.x,r.y,r.z))}}this.setAttribute("position",new Sn(e,3))}}}function wl(t,e,n){const i=`${t.x},${t.y},${t.z}-${e.x},${e.y},${e.z}`,r=`${e.x},${e.y},${e.z}-${t.x},${t.y},${t.z}`;return!0!==n.has(i)&&!0!==n.has(r)&&(n.add(i),n.add(r),!0)}var Sl=Object.freeze({__proto__:null,BoxGeometry:$n,BoxBufferGeometry:$n,CapsuleGeometry:To,CapsuleBufferGeometry:To,CircleGeometry:Ao,CircleBufferGeometry:Ao,ConeGeometry:Co,ConeBufferGeometry:Co,CylinderGeometry:Ro,CylinderBufferGeometry:Ro,DodecahedronGeometry:Po,DodecahedronBufferGeometry:Po,EdgesGeometry:Uo,ExtrudeGeometry:hl,ExtrudeBufferGeometry:hl,IcosahedronGeometry:pl,IcosahedronBufferGeometry:pl,LatheGeometry:Eo,LatheBufferGeometry:Eo,OctahedronGeometry:fl,OctahedronBufferGeometry:fl,PlaneGeometry:_i,PlaneBufferGeometry:_i,PolyhedronGeometry:Lo,PolyhedronBufferGeometry:Lo,RingGeometry:ml,RingBufferGeometry:ml,ShapeGeometry:gl,ShapeBufferGeometry:gl,SphereGeometry:vl,SphereBufferGeometry:vl,TetrahedronGeometry:_l,TetrahedronBufferGeometry:_l,TorusGeometry:yl,TorusBufferGeometry:yl,TorusKnotGeometry:xl,TorusKnotBufferGeometry:xl,TubeGeometry:bl,TubeBufferGeometry:bl,WireframeGeometry:Ml});class El extends vn{constructor(t){super(),this.isShadowMaterial=!0,this.type="ShadowMaterial",this.color=new Ht(0),this.transparent=!0,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.fog=t.fog,this}}class Tl extends ni{constructor(t){super(t),this.isRawShaderMaterial=!0,this.type="RawShaderMaterial"}}class Al extends vn{constructor(t){super(),this.isMeshStandardMaterial=!0,this.defines={STANDARD:""},this.type="MeshStandardMaterial",this.color=new Ht(16777215),this.roughness=1,this.metalness=0,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Ht(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new At(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapIntensity=1,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.defines={STANDARD:""},this.color.copy(t.color),this.roughness=t.roughness,this.metalness=t.metalness,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.roughnessMap=t.roughnessMap,this.metalnessMap=t.metalnessMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.envMapIntensity=t.envMapIntensity,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.flatShading=t.flatShading,this.fog=t.fog,this}}class Rl extends Al{constructor(t){super(),this.isMeshPhysicalMaterial=!0,this.defines={STANDARD:"",PHYSICAL:""},this.type="MeshPhysicalMaterial",this.clearcoatMap=null,this.clearcoatRoughness=0,this.clearcoatRoughnessMap=null,this.clearcoatNormalScale=new At(1,1),this.clearcoatNormalMap=null,this.ior=1.5,Object.defineProperty(this,"reflectivity",{get:function(){return xt(2.5*(this.ior-1)/(this.ior+1),0,1)},set:function(t){this.ior=(1+.4*t)/(1-.4*t)}}),this.iridescenceMap=null,this.iridescenceIOR=1.3,this.iridescenceThicknessRange=[100,400],this.iridescenceThicknessMap=null,this.sheenColor=new Ht(0),this.sheenColorMap=null,this.sheenRoughness=1,this.sheenRoughnessMap=null,this.transmissionMap=null,this.thickness=0,this.thicknessMap=null,this.attenuationDistance=0,this.attenuationColor=new Ht(1,1,1),this.specularIntensity=1,this.specularIntensityMap=null,this.specularColor=new Ht(1,1,1),this.specularColorMap=null,this._sheen=0,this._clearcoat=0,this._iridescence=0,this._transmission=0,this.setValues(t)}get sheen(){return this._sheen}set sheen(t){this._sheen>0!=t>0&&this.version++,this._sheen=t}get clearcoat(){return this._clearcoat}set clearcoat(t){this._clearcoat>0!=t>0&&this.version++,this._clearcoat=t}get iridescence(){return this._iridescence}set iridescence(t){this._iridescence>0!=t>0&&this.version++,this._iridescence=t}get transmission(){return this._transmission}set transmission(t){this._transmission>0!=t>0&&this.version++,this._transmission=t}copy(t){return super.copy(t),this.defines={STANDARD:"",PHYSICAL:""},this.clearcoat=t.clearcoat,this.clearcoatMap=t.clearcoatMap,this.clearcoatRoughness=t.clearcoatRoughness,this.clearcoatRoughnessMap=t.clearcoatRoughnessMap,this.clearcoatNormalMap=t.clearcoatNormalMap,this.clearcoatNormalScale.copy(t.clearcoatNormalScale),this.ior=t.ior,this.iridescence=t.iridescence,this.iridescenceMap=t.iridescenceMap,this.iridescenceIOR=t.iridescenceIOR,this.iridescenceThicknessRange=[...t.iridescenceThicknessRange],this.iridescenceThicknessMap=t.iridescenceThicknessMap,this.sheen=t.sheen,this.sheenColor.copy(t.sheenColor),this.sheenColorMap=t.sheenColorMap,this.sheenRoughness=t.sheenRoughness,this.sheenRoughnessMap=t.sheenRoughnessMap,this.transmission=t.transmission,this.transmissionMap=t.transmissionMap,this.thickness=t.thickness,this.thicknessMap=t.thicknessMap,this.attenuationDistance=t.attenuationDistance,this.attenuationColor.copy(t.attenuationColor),this.specularIntensity=t.specularIntensity,this.specularIntensityMap=t.specularIntensityMap,this.specularColor.copy(t.specularColor),this.specularColorMap=t.specularColorMap,this}}class Cl extends vn{constructor(t){super(),this.isMeshPhongMaterial=!0,this.type="MeshPhongMaterial",this.color=new Ht(16777215),this.specular=new Ht(1118481),this.shininess=30,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Ht(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new At(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.specular.copy(t.specular),this.shininess=t.shininess,this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.flatShading=t.flatShading,this.fog=t.fog,this}}class Ll extends vn{constructor(t){super(),this.isMeshToonMaterial=!0,this.defines={TOON:""},this.type="MeshToonMaterial",this.color=new Ht(16777215),this.map=null,this.gradientMap=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Ht(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new At(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.gradientMap=t.gradientMap,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.alphaMap=t.alphaMap,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.fog=t.fog,this}}class Pl extends vn{constructor(t){super(),this.isMeshNormalMaterial=!0,this.type="MeshNormalMaterial",this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new At(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.flatShading=!1,this.setValues(t)}copy(t){return super.copy(t),this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.flatShading=t.flatShading,this}}class Il extends vn{constructor(t){super(),this.isMeshLambertMaterial=!0,this.type="MeshLambertMaterial",this.color=new Ht(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new Ht(0),this.emissiveIntensity=1,this.emissiveMap=null,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=0,this.reflectivity=1,this.refractionRatio=.98,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.color.copy(t.color),this.map=t.map,this.lightMap=t.lightMap,this.lightMapIntensity=t.lightMapIntensity,this.aoMap=t.aoMap,this.aoMapIntensity=t.aoMapIntensity,this.emissive.copy(t.emissive),this.emissiveMap=t.emissiveMap,this.emissiveIntensity=t.emissiveIntensity,this.specularMap=t.specularMap,this.alphaMap=t.alphaMap,this.envMap=t.envMap,this.combine=t.combine,this.reflectivity=t.reflectivity,this.refractionRatio=t.refractionRatio,this.wireframe=t.wireframe,this.wireframeLinewidth=t.wireframeLinewidth,this.wireframeLinecap=t.wireframeLinecap,this.wireframeLinejoin=t.wireframeLinejoin,this.fog=t.fog,this}}class Dl extends vn{constructor(t){super(),this.isMeshMatcapMaterial=!0,this.defines={MATCAP:""},this.type="MeshMatcapMaterial",this.color=new Ht(16777215),this.matcap=null,this.map=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalMapType=0,this.normalScale=new At(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.alphaMap=null,this.flatShading=!1,this.fog=!0,this.setValues(t)}copy(t){return super.copy(t),this.defines={MATCAP:""},this.color.copy(t.color),this.matcap=t.matcap,this.map=t.map,this.bumpMap=t.bumpMap,this.bumpScale=t.bumpScale,this.normalMap=t.normalMap,this.normalMapType=t.normalMapType,this.normalScale.copy(t.normalScale),this.displacementMap=t.displacementMap,this.displacementScale=t.displacementScale,this.displacementBias=t.displacementBias,this.alphaMap=t.alphaMap,this.flatShading=t.flatShading,this.fog=t.fog,this}}class Ol extends Fa{constructor(t){super(),this.isLineDashedMaterial=!0,this.type="LineDashedMaterial",this.scale=1,this.dashSize=3,this.gapSize=1,this.setValues(t)}copy(t){return super.copy(t),this.scale=t.scale,this.dashSize=t.dashSize,this.gapSize=t.gapSize,this}}const Nl={arraySlice:function(t,e,n){return Nl.isTypedArray(t)?new t.constructor(t.subarray(e,void 0!==n?n:t.length)):t.slice(e,n)},convertArray:function(t,e,n){return!t||!n&&t.constructor===e?t:"number"==typeof e.BYTES_PER_ELEMENT?new e(t):Array.prototype.slice.call(t)},isTypedArray:function(t){return ArrayBuffer.isView(t)&&!(t instanceof DataView)},getKeyframeOrder:function(t){const e=t.length,n=new Array(e);for(let t=0;t!==e;++t)n[t]=t;return n.sort((function(e,n){return t[e]-t[n]})),n},sortedArray:function(t,e,n){const i=t.length,r=new t.constructor(i);for(let s=0,a=0;a!==i;++s){const i=n[s]*e;for(let n=0;n!==e;++n)r[a++]=t[i+n]}return r},flattenJSON:function(t,e,n,i){let r=1,s=t[0];for(;void 0!==s&&void 0===s[i];)s=t[r++];if(void 0===s)return;let a=s[i];if(void 0!==a)if(Array.isArray(a))do{a=s[i],void 0!==a&&(e.push(s.time),n.push.apply(n,a)),s=t[r++]}while(void 0!==s);else if(void 0!==a.toArray)do{a=s[i],void 0!==a&&(e.push(s.time),a.toArray(n,n.length)),s=t[r++]}while(void 0!==s);else do{a=s[i],void 0!==a&&(e.push(s.time),n.push(a)),s=t[r++]}while(void 0!==s)},subclip:function(t,e,n,i,r=30){const s=t.clone();s.name=e;const a=[];for(let t=0;t<s.tracks.length;++t){const e=s.tracks[t],o=e.getValueSize(),l=[],c=[];for(let t=0;t<e.times.length;++t){const s=e.times[t]*r;if(!(s<n||s>=i)){l.push(e.times[t]);for(let n=0;n<o;++n)c.push(e.values[t*o+n])}}0!==l.length&&(e.times=Nl.convertArray(l,e.times.constructor),e.values=Nl.convertArray(c,e.values.constructor),a.push(e))}s.tracks=a;let o=1/0;for(let t=0;t<s.tracks.length;++t)o>s.tracks[t].times[0]&&(o=s.tracks[t].times[0]);for(let t=0;t<s.tracks.length;++t)s.tracks[t].shift(-1*o);return s.resetDuration(),s},makeClipAdditive:function(t,e=0,n=t,i=30){i<=0&&(i=30);const r=n.tracks.length,s=e/i;for(let e=0;e<r;++e){const i=n.tracks[e],r=i.ValueTypeName;if("bool"===r||"string"===r)continue;const a=t.tracks.find((function(t){return t.name===i.name&&t.ValueTypeName===r}));if(void 0===a)continue;let o=0;const l=i.getValueSize();i.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline&&(o=l/3);let c=0;const u=a.getValueSize();a.createInterpolant.isInterpolantFactoryMethodGLTFCubicSpline&&(c=u/3);const h=i.times.length-1;let d;if(s<=i.times[0]){const t=o,e=l-o;d=Nl.arraySlice(i.values,t,e)}else if(s>=i.times[h]){const t=h*l+o,e=t+l-o;d=Nl.arraySlice(i.values,t,e)}else{const t=i.createInterpolant(),e=o,n=l-o;t.evaluate(s),d=Nl.arraySlice(t.resultBuffer,e,n)}"quaternion"===r&&(new te).fromArray(d).normalize().conjugate().toArray(d);const p=a.times.length;for(let t=0;t<p;++t){const e=t*u+c;if("quaternion"===r)te.multiplyQuaternionsFlat(a.values,e,d,0,a.values,e);else{const t=u-2*c;for(let n=0;n<t;++n)a.values[e+n]-=d[n]}}}return t.blendMode=st,t}};class Ul{constructor(t,e,n,i){this.parameterPositions=t,this._cachedIndex=0,this.resultBuffer=void 0!==i?i:new e.constructor(n),this.sampleValues=e,this.valueSize=n,this.settings=null,this.DefaultSettings_={}}evaluate(t){const e=this.parameterPositions;let n=this._cachedIndex,i=e[n],r=e[n-1];t:{e:{let s;n:{i:if(!(t<i)){for(let s=n+2;;){if(void 0===i){if(t<r)break i;return n=e.length,this._cachedIndex=n,this.copySampleValue_(n-1)}if(n===s)break;if(r=i,i=e[++n],t<i)break e}s=e.length;break n}if(t>=r)break t;{const a=e[1];t<a&&(n=2,r=a);for(let s=n-2;;){if(void 0===r)return this._cachedIndex=0,this.copySampleValue_(0);if(n===s)break;if(i=r,r=e[--n-1],t>=r)break e}s=n,n=0}}for(;n<s;){const i=n+s>>>1;t<e[i]?s=i:n=i+1}if(i=e[n],r=e[n-1],void 0===r)return this._cachedIndex=0,this.copySampleValue_(0);if(void 0===i)return n=e.length,this._cachedIndex=n,this.copySampleValue_(n-1)}this._cachedIndex=n,this.intervalChanged_(n,r,i)}return this.interpolate_(n,r,t,i)}getSettings_(){return this.settings||this.DefaultSettings_}copySampleValue_(t){const e=this.resultBuffer,n=this.sampleValues,i=this.valueSize,r=t*i;for(let t=0;t!==i;++t)e[t]=n[r+t];return e}interpolate_(){throw new Error("call to abstract method")}intervalChanged_(){}}class Fl extends Ul{constructor(t,e,n,i){super(t,e,n,i),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0,this.DefaultSettings_={endingStart:nt,endingEnd:nt}}intervalChanged_(t,e,n){const i=this.parameterPositions;let r=t-2,s=t+1,a=i[r],o=i[s];if(void 0===a)switch(this.getSettings_().endingStart){case it:r=t,a=2*e-n;break;case rt:r=i.length-2,a=e+i[r]-i[r+1];break;default:r=t,a=n}if(void 0===o)switch(this.getSettings_().endingEnd){case it:s=t,o=2*n-e;break;case rt:s=1,o=n+i[1]-i[0];break;default:s=t-1,o=e}const l=.5*(n-e),c=this.valueSize;this._weightPrev=l/(e-a),this._weightNext=l/(o-n),this._offsetPrev=r*c,this._offsetNext=s*c}interpolate_(t,e,n,i){const r=this.resultBuffer,s=this.sampleValues,a=this.valueSize,o=t*a,l=o-a,c=this._offsetPrev,u=this._offsetNext,h=this._weightPrev,d=this._weightNext,p=(n-e)/(i-e),f=p*p,m=f*p,g=-h*m+2*h*f-h*p,v=(1+h)*m+(-1.5-2*h)*f+(-.5+h)*p+1,_=(-1-d)*m+(1.5+d)*f+.5*p,y=d*m-d*f;for(let t=0;t!==a;++t)r[t]=g*s[c+t]+v*s[l+t]+_*s[o+t]+y*s[u+t];return r}}class Bl extends Ul{constructor(t,e,n,i){super(t,e,n,i)}interpolate_(t,e,n,i){const r=this.resultBuffer,s=this.sampleValues,a=this.valueSize,o=t*a,l=o-a,c=(n-e)/(i-e),u=1-c;for(let t=0;t!==a;++t)r[t]=s[l+t]*u+s[o+t]*c;return r}}class zl extends Ul{constructor(t,e,n,i){super(t,e,n,i)}interpolate_(t){return this.copySampleValue_(t-1)}}class kl{constructor(t,e,n,i){if(void 0===t)throw new Error("THREE.KeyframeTrack: track name is undefined");if(void 0===e||0===e.length)throw new Error("THREE.KeyframeTrack: no keyframes in track named "+t);this.name=t,this.times=Nl.convertArray(e,this.TimeBufferType),this.values=Nl.convertArray(n,this.ValueBufferType),this.setInterpolation(i||this.DefaultInterpolation)}static toJSON(t){const e=t.constructor;let n;if(e.toJSON!==this.toJSON)n=e.toJSON(t);else{n={name:t.name,times:Nl.convertArray(t.times,Array),values:Nl.convertArray(t.values,Array)};const e=t.getInterpolation();e!==t.DefaultInterpolation&&(n.interpolation=e)}return n.type=t.ValueTypeName,n}InterpolantFactoryMethodDiscrete(t){return new zl(this.times,this.values,this.getValueSize(),t)}InterpolantFactoryMethodLinear(t){return new Bl(this.times,this.values,this.getValueSize(),t)}InterpolantFactoryMethodSmooth(t){return new Fl(this.times,this.values,this.getValueSize(),t)}setInterpolation(t){let e;switch(t){case Q:e=this.InterpolantFactoryMethodDiscrete;break;case tt:e=this.InterpolantFactoryMethodLinear;break;case et:e=this.InterpolantFactoryMethodSmooth}if(void 0===e){const e="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(t===this.DefaultInterpolation)throw new Error(e);this.setInterpolation(this.DefaultInterpolation)}return console.warn("THREE.KeyframeTrack:",e),this}return this.createInterpolant=e,this}getInterpolation(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return Q;case this.InterpolantFactoryMethodLinear:return tt;case this.InterpolantFactoryMethodSmooth:return et}}getValueSize(){return this.values.length/this.times.length}shift(t){if(0!==t){const e=this.times;for(let n=0,i=e.length;n!==i;++n)e[n]+=t}return this}scale(t){if(1!==t){const e=this.times;for(let n=0,i=e.length;n!==i;++n)e[n]*=t}return this}trim(t,e){const n=this.times,i=n.length;let r=0,s=i-1;for(;r!==i&&n[r]<t;)++r;for(;-1!==s&&n[s]>e;)--s;if(++s,0!==r||s!==i){r>=s&&(s=Math.max(s,1),r=s-1);const t=this.getValueSize();this.times=Nl.arraySlice(n,r,s),this.values=Nl.arraySlice(this.values,r*t,s*t)}return this}validate(){let t=!0;const e=this.getValueSize();e-Math.floor(e)!=0&&(console.error("THREE.KeyframeTrack: Invalid value size in track.",this),t=!1);const n=this.times,i=this.values,r=n.length;0===r&&(console.error("THREE.KeyframeTrack: Track is empty.",this),t=!1);let s=null;for(let e=0;e!==r;e++){const i=n[e];if("number"==typeof i&&isNaN(i)){console.error("THREE.KeyframeTrack: Time is not a valid number.",this,e,i),t=!1;break}if(null!==s&&s>i){console.error("THREE.KeyframeTrack: Out of order keys.",this,e,i,s),t=!1;break}s=i}if(void 0!==i&&Nl.isTypedArray(i))for(let e=0,n=i.length;e!==n;++e){const n=i[e];if(isNaN(n)){console.error("THREE.KeyframeTrack: Value is not a valid number.",this,e,n),t=!1;break}}return t}optimize(){const t=Nl.arraySlice(this.times),e=Nl.arraySlice(this.values),n=this.getValueSize(),i=this.getInterpolation()===et,r=t.length-1;let s=1;for(let a=1;a<r;++a){let r=!1;const o=t[a];if(o!==t[a+1]&&(1!==a||o!==t[0]))if(i)r=!0;else{const t=a*n,i=t-n,s=t+n;for(let a=0;a!==n;++a){const n=e[t+a];if(n!==e[i+a]||n!==e[s+a]){r=!0;break}}}if(r){if(a!==s){t[s]=t[a];const i=a*n,r=s*n;for(let t=0;t!==n;++t)e[r+t]=e[i+t]}++s}}if(r>0){t[s]=t[r];for(let t=r*n,i=s*n,a=0;a!==n;++a)e[i+a]=e[t+a];++s}return s!==t.length?(this.times=Nl.arraySlice(t,0,s),this.values=Nl.arraySlice(e,0,s*n)):(this.times=t,this.values=e),this}clone(){const t=Nl.arraySlice(this.times,0),e=Nl.arraySlice(this.values,0),n=new(0,this.constructor)(this.name,t,e);return n.createInterpolant=this.createInterpolant,n}}kl.prototype.TimeBufferType=Float32Array,kl.prototype.ValueBufferType=Float32Array,kl.prototype.DefaultInterpolation=tt;class Gl extends kl{}Gl.prototype.ValueTypeName="bool",Gl.prototype.ValueBufferType=Array,Gl.prototype.DefaultInterpolation=Q,Gl.prototype.InterpolantFactoryMethodLinear=void 0,Gl.prototype.InterpolantFactoryMethodSmooth=void 0;class Vl extends kl{}Vl.prototype.ValueTypeName="color";class Hl extends kl{}Hl.prototype.ValueTypeName="number";class Wl extends Ul{constructor(t,e,n,i){super(t,e,n,i)}interpolate_(t,e,n,i){const r=this.resultBuffer,s=this.sampleValues,a=this.valueSize,o=(n-e)/(i-e);let l=t*a;for(let t=l+a;l!==t;l+=4)te.slerpFlat(r,0,s,l-a,s,l,o);return r}}class jl extends kl{InterpolantFactoryMethodLinear(t){return new Wl(this.times,this.values,this.getValueSize(),t)}}jl.prototype.ValueTypeName="quaternion",jl.prototype.DefaultInterpolation=tt,jl.prototype.InterpolantFactoryMethodSmooth=void 0;class Xl extends kl{}Xl.prototype.ValueTypeName="string",Xl.prototype.ValueBufferType=Array,Xl.prototype.DefaultInterpolation=Q,Xl.prototype.InterpolantFactoryMethodLinear=void 0,Xl.prototype.InterpolantFactoryMethodSmooth=void 0;class Yl extends kl{}Yl.prototype.ValueTypeName="vector";class ql{constructor(t,e=-1,n,i=2500){this.name=t,this.tracks=n,this.duration=e,this.blendMode=i,this.uuid=yt(),this.duration<0&&this.resetDuration()}static parse(t){const e=[],n=t.tracks,i=1/(t.fps||1);for(let t=0,r=n.length;t!==r;++t)e.push(Zl(n[t]).scale(i));const r=new this(t.name,t.duration,e,t.blendMode);return r.uuid=t.uuid,r}static toJSON(t){const e=[],n=t.tracks,i={name:t.name,duration:t.duration,tracks:e,uuid:t.uuid,blendMode:t.blendMode};for(let t=0,i=n.length;t!==i;++t)e.push(kl.toJSON(n[t]));return i}static CreateFromMorphTargetSequence(t,e,n,i){const r=e.length,s=[];for(let t=0;t<r;t++){let a=[],o=[];a.push((t+r-1)%r,t,(t+1)%r),o.push(0,1,0);const l=Nl.getKeyframeOrder(a);a=Nl.sortedArray(a,1,l),o=Nl.sortedArray(o,1,l),i||0!==a[0]||(a.push(r),o.push(o[0])),s.push(new Hl(".morphTargetInfluences["+e[t].name+"]",a,o).scale(1/n))}return new this(t,-1,s)}static findByName(t,e){let n=t;if(!Array.isArray(t)){const e=t;n=e.geometry&&e.geometry.animations||e.animations}for(let t=0;t<n.length;t++)if(n[t].name===e)return n[t];return null}static CreateClipsFromMorphTargetSequences(t,e,n){const i={},r=/^([\w-]*?)([\d]+)$/;for(let e=0,n=t.length;e<n;e++){const n=t[e],s=n.name.match(r);if(s&&s.length>1){const t=s[1];let e=i[t];e||(i[t]=e=[]),e.push(n)}}const s=[];for(const t in i)s.push(this.CreateFromMorphTargetSequence(t,i[t],e,n));return s}static parseAnimation(t,e){if(!t)return console.error("THREE.AnimationClip: No animation in JSONLoader data."),null;const n=function(t,e,n,i,r){if(0!==n.length){const s=[],a=[];Nl.flattenJSON(n,s,a,i),0!==s.length&&r.push(new t(e,s,a))}},i=[],r=t.name||"default",s=t.fps||30,a=t.blendMode;let o=t.length||-1;const l=t.hierarchy||[];for(let t=0;t<l.length;t++){const r=l[t].keys;if(r&&0!==r.length)if(r[0].morphTargets){const t={};let e;for(e=0;e<r.length;e++)if(r[e].morphTargets)for(let n=0;n<r[e].morphTargets.length;n++)t[r[e].morphTargets[n]]=-1;for(const n in t){const t=[],s=[];for(let i=0;i!==r[e].morphTargets.length;++i){const i=r[e];t.push(i.time),s.push(i.morphTarget===n?1:0)}i.push(new Hl(".morphTargetInfluence["+n+"]",t,s))}o=t.length*s}else{const s=".bones["+e[t].name+"]";n(Yl,s+".position",r,"pos",i),n(jl,s+".quaternion",r,"rot",i),n(Yl,s+".scale",r,"scl",i)}}return 0===i.length?null:new this(r,o,i,a)}resetDuration(){let t=0;for(let e=0,n=this.tracks.length;e!==n;++e){const n=this.tracks[e];t=Math.max(t,n.times[n.times.length-1])}return this.duration=t,this}trim(){for(let t=0;t<this.tracks.length;t++)this.tracks[t].trim(0,this.duration);return this}validate(){let t=!0;for(let e=0;e<this.tracks.length;e++)t=t&&this.tracks[e].validate();return t}optimize(){for(let t=0;t<this.tracks.length;t++)this.tracks[t].optimize();return this}clone(){const t=[];for(let e=0;e<this.tracks.length;e++)t.push(this.tracks[e].clone());return new this.constructor(this.name,this.duration,t,this.blendMode)}toJSON(){return this.constructor.toJSON(this)}}function Zl(t){if(void 0===t.type)throw new Error("THREE.KeyframeTrack: track type undefined, can not parse");const e=function(t){switch(t.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return Hl;case"vector":case"vector2":case"vector3":case"vector4":return Yl;case"color":return Vl;case"quaternion":return jl;case"bool":case"boolean":return Gl;case"string":return Xl}throw new Error("THREE.KeyframeTrack: Unsupported typeName: "+t)}(t.type);if(void 0===t.times){const e=[],n=[];Nl.flattenJSON(t.keys,e,n,"value"),t.times=e,t.values=n}return void 0!==e.parse?e.parse(t):new e(t.name,t.times,t.values,t.interpolation)}const Jl={enabled:!1,files:{},add:function(t,e){!1!==this.enabled&&(this.files[t]=e)},get:function(t){if(!1!==this.enabled)return this.files[t]},remove:function(t){delete this.files[t]},clear:function(){this.files={}}};class Kl{constructor(t,e,n){const i=this;let r,s=!1,a=0,o=0;const l=[];this.onStart=void 0,this.onLoad=t,this.onProgress=e,this.onError=n,this.itemStart=function(t){o++,!1===s&&void 0!==i.onStart&&i.onStart(t,a,o),s=!0},this.itemEnd=function(t){a++,void 0!==i.onProgress&&i.onProgress(t,a,o),a===o&&(s=!1,void 0!==i.onLoad&&i.onLoad())},this.itemError=function(t){void 0!==i.onError&&i.onError(t)},this.resolveURL=function(t){return r?r(t):t},this.setURLModifier=function(t){return r=t,this},this.addHandler=function(t,e){return l.push(t,e),this},this.removeHandler=function(t){const e=l.indexOf(t);return-1!==e&&l.splice(e,2),this},this.getHandler=function(t){for(let e=0,n=l.length;e<n;e+=2){const n=l[e],i=l[e+1];if(n.global&&(n.lastIndex=0),n.test(t))return i}return null}}}const $l=new Kl;class Ql{constructor(t){this.manager=void 0!==t?t:$l,this.crossOrigin="anonymous",this.withCredentials=!1,this.path="",this.resourcePath="",this.requestHeader={}}load(){}loadAsync(t,e){const n=this;return new Promise((function(i,r){n.load(t,i,e,r)}))}parse(){}setCrossOrigin(t){return this.crossOrigin=t,this}setWithCredentials(t){return this.withCredentials=t,this}setPath(t){return this.path=t,this}setResourcePath(t){return this.resourcePath=t,this}setRequestHeader(t){return this.requestHeader=t,this}}const tc={};class ec extends Ql{constructor(t){super(t)}load(t,e,n,i){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const r=Jl.get(t);if(void 0!==r)return this.manager.itemStart(t),setTimeout((()=>{e&&e(r),this.manager.itemEnd(t)}),0),r;if(void 0!==tc[t])return void tc[t].push({onLoad:e,onProgress:n,onError:i});tc[t]=[],tc[t].push({onLoad:e,onProgress:n,onError:i});const s=new Request(t,{headers:new Headers(this.requestHeader),credentials:this.withCredentials?"include":"same-origin"}),a=this.mimeType,o=this.responseType;fetch(s).then((e=>{if(200===e.status||0===e.status){if(0===e.status&&console.warn("THREE.FileLoader: HTTP Status 0 received."),"undefined"==typeof ReadableStream||void 0===e.body||void 0===e.body.getReader)return e;const n=tc[t],i=e.body.getReader(),r=e.headers.get("Content-Length"),s=r?parseInt(r):0,a=0!==s;let o=0;const l=new ReadableStream({start(t){!function e(){i.read().then((({done:i,value:r})=>{if(i)t.close();else{o+=r.byteLength;const i=new ProgressEvent("progress",{lengthComputable:a,loaded:o,total:s});for(let t=0,e=n.length;t<e;t++){const e=n[t];e.onProgress&&e.onProgress(i)}t.enqueue(r),e()}}))}()}});return new Response(l)}throw Error(`fetch for "${e.url}" responded with ${e.status}: ${e.statusText}`)})).then((t=>{switch(o){case"arraybuffer":return t.arrayBuffer();case"blob":return t.blob();case"document":return t.text().then((t=>(new DOMParser).parseFromString(t,a)));case"json":return t.json();default:if(void 0===a)return t.text();{const e=/charset="?([^;"\s]*)"?/i.exec(a),n=e&&e[1]?e[1].toLowerCase():void 0,i=new TextDecoder(n);return t.arrayBuffer().then((t=>i.decode(t)))}}})).then((e=>{Jl.add(t,e);const n=tc[t];delete tc[t];for(let t=0,i=n.length;t<i;t++){const i=n[t];i.onLoad&&i.onLoad(e)}})).catch((e=>{const n=tc[t];if(void 0===n)throw this.manager.itemError(t),e;delete tc[t];for(let t=0,i=n.length;t<i;t++){const i=n[t];i.onError&&i.onError(e)}this.manager.itemError(t)})).finally((()=>{this.manager.itemEnd(t)})),this.manager.itemStart(t)}setResponseType(t){return this.responseType=t,this}setMimeType(t){return this.mimeType=t,this}}class nc extends Ql{constructor(t){super(t)}load(t,e,n,i){void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const r=this,s=Jl.get(t);if(void 0!==s)return r.manager.itemStart(t),setTimeout((function(){e&&e(s),r.manager.itemEnd(t)}),0),s;const a=It("img");function o(){c(),Jl.add(t,this),e&&e(this),r.manager.itemEnd(t)}function l(e){c(),i&&i(e),r.manager.itemError(t),r.manager.itemEnd(t)}function c(){a.removeEventListener("load",o,!1),a.removeEventListener("error",l,!1)}return a.addEventListener("load",o,!1),a.addEventListener("error",l,!1),"data:"!==t.slice(0,5)&&void 0!==this.crossOrigin&&(a.crossOrigin=this.crossOrigin),r.manager.itemStart(t),a.src=t,a}}class ic extends rn{constructor(t,e=1){super(),this.isLight=!0,this.type="Light",this.color=new Ht(t),this.intensity=e}dispose(){}copy(t,e){return super.copy(t,e),this.color.copy(t.color),this.intensity=t.intensity,this}toJSON(t){const e=super.toJSON(t);return e.object.color=this.color.getHex(),e.object.intensity=this.intensity,void 0!==this.groundColor&&(e.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(e.object.distance=this.distance),void 0!==this.angle&&(e.object.angle=this.angle),void 0!==this.decay&&(e.object.decay=this.decay),void 0!==this.penumbra&&(e.object.penumbra=this.penumbra),void 0!==this.shadow&&(e.object.shadow=this.shadow.toJSON()),e}}class rc extends ic{constructor(t,e,n){super(t,n),this.isHemisphereLight=!0,this.type="HemisphereLight",this.position.copy(rn.DefaultUp),this.updateMatrix(),this.groundColor=new Ht(e)}copy(t,e){return super.copy(t,e),this.groundColor.copy(t.groundColor),this}}const sc=new Ie,ac=new ee,oc=new ee;class lc{constructor(t){this.camera=t,this.bias=0,this.normalBias=0,this.radius=1,this.blurSamples=8,this.mapSize=new At(512,512),this.map=null,this.mapPass=null,this.matrix=new Ie,this.autoUpdate=!0,this.needsUpdate=!1,this._frustum=new mi,this._frameExtents=new At(1,1),this._viewportCount=1,this._viewports=[new Jt(0,0,1,1)]}getViewportCount(){return this._viewportCount}getFrustum(){return this._frustum}updateMatrices(t){const e=this.camera,n=this.matrix;ac.setFromMatrixPosition(t.matrixWorld),e.position.copy(ac),oc.setFromMatrixPosition(t.target.matrixWorld),e.lookAt(oc),e.updateMatrixWorld(),sc.multiplyMatrices(e.projectionMatrix,e.matrixWorldInverse),this._frustum.setFromProjectionMatrix(sc),n.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),n.multiply(e.projectionMatrix),n.multiply(e.matrixWorldInverse)}getViewport(t){return this._viewports[t]}getFrameExtents(){return this._frameExtents}dispose(){this.map&&this.map.dispose(),this.mapPass&&this.mapPass.dispose()}copy(t){return this.camera=t.camera.clone(),this.bias=t.bias,this.radius=t.radius,this.mapSize.copy(t.mapSize),this}clone(){return(new this.constructor).copy(this)}toJSON(){const t={};return 0!==this.bias&&(t.bias=this.bias),0!==this.normalBias&&(t.normalBias=this.normalBias),1!==this.radius&&(t.radius=this.radius),512===this.mapSize.x&&512===this.mapSize.y||(t.mapSize=this.mapSize.toArray()),t.camera=this.camera.toJSON(!1).object,delete t.camera.matrix,t}}class cc extends lc{constructor(){super(new ri(50,1,.5,500)),this.isSpotLightShadow=!0,this.focus=1}updateMatrices(t){const e=this.camera,n=2*_t*t.angle*this.focus,i=this.mapSize.width/this.mapSize.height,r=t.distance||e.far;n===e.fov&&i===e.aspect&&r===e.far||(e.fov=n,e.aspect=i,e.far=r,e.updateProjectionMatrix()),super.updateMatrices(t)}copy(t){return super.copy(t),this.focus=t.focus,this}}class uc extends ic{constructor(t,e,n=0,i=Math.PI/3,r=0,s=1){super(t,e),this.isSpotLight=!0,this.type="SpotLight",this.position.copy(rn.DefaultUp),this.updateMatrix(),this.target=new rn,this.distance=n,this.angle=i,this.penumbra=r,this.decay=s,this.shadow=new cc}get power(){return this.intensity*Math.PI}set power(t){this.intensity=t/Math.PI}dispose(){this.shadow.dispose()}copy(t,e){return super.copy(t,e),this.distance=t.distance,this.angle=t.angle,this.penumbra=t.penumbra,this.decay=t.decay,this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}const hc=new Ie,dc=new ee,pc=new ee;class fc extends lc{constructor(){super(new ri(90,1,.5,500)),this.isPointLightShadow=!0,this._frameExtents=new At(4,2),this._viewportCount=6,this._viewports=[new Jt(2,1,1,1),new Jt(0,1,1,1),new Jt(3,1,1,1),new Jt(1,1,1,1),new Jt(3,0,1,1),new Jt(1,0,1,1)],this._cubeDirections=[new ee(1,0,0),new ee(-1,0,0),new ee(0,0,1),new ee(0,0,-1),new ee(0,1,0),new ee(0,-1,0)],this._cubeUps=[new ee(0,1,0),new ee(0,1,0),new ee(0,1,0),new ee(0,1,0),new ee(0,0,1),new ee(0,0,-1)]}updateMatrices(t,e=0){const n=this.camera,i=this.matrix,r=t.distance||n.far;r!==n.far&&(n.far=r,n.updateProjectionMatrix()),dc.setFromMatrixPosition(t.matrixWorld),n.position.copy(dc),pc.copy(n.position),pc.add(this._cubeDirections[e]),n.up.copy(this._cubeUps[e]),n.lookAt(pc),n.updateMatrixWorld(),i.makeTranslation(-dc.x,-dc.y,-dc.z),hc.multiplyMatrices(n.projectionMatrix,n.matrixWorldInverse),this._frustum.setFromProjectionMatrix(hc)}}class mc extends ic{constructor(t,e,n=0,i=1){super(t,e),this.isPointLight=!0,this.type="PointLight",this.distance=n,this.decay=i,this.shadow=new fc}get power(){return 4*this.intensity*Math.PI}set power(t){this.intensity=t/(4*Math.PI)}dispose(){this.shadow.dispose()}copy(t,e){return super.copy(t,e),this.distance=t.distance,this.decay=t.decay,this.shadow=t.shadow.clone(),this}}class gc extends lc{constructor(){super(new Ri(-5,5,5,-5,.5,500)),this.isDirectionalLightShadow=!0}}class vc extends ic{constructor(t,e){super(t,e),this.isDirectionalLight=!0,this.type="DirectionalLight",this.position.copy(rn.DefaultUp),this.updateMatrix(),this.target=new rn,this.shadow=new gc}dispose(){this.shadow.dispose()}copy(t){return super.copy(t),this.target=t.target.clone(),this.shadow=t.shadow.clone(),this}}class _c extends ic{constructor(t,e){super(t,e),this.isAmbientLight=!0,this.type="AmbientLight"}}class yc extends ic{constructor(t,e,n=10,i=10){super(t,e),this.isRectAreaLight=!0,this.type="RectAreaLight",this.width=n,this.height=i}get power(){return this.intensity*this.width*this.height*Math.PI}set power(t){this.intensity=t/(this.width*this.height*Math.PI)}copy(t){return super.copy(t),this.width=t.width,this.height=t.height,this}toJSON(t){const e=super.toJSON(t);return e.object.width=this.width,e.object.height=this.height,e}}class xc{constructor(){this.isSphericalHarmonics3=!0,this.coefficients=[];for(let t=0;t<9;t++)this.coefficients.push(new ee)}set(t){for(let e=0;e<9;e++)this.coefficients[e].copy(t[e]);return this}zero(){for(let t=0;t<9;t++)this.coefficients[t].set(0,0,0);return this}getAt(t,e){const n=t.x,i=t.y,r=t.z,s=this.coefficients;return e.copy(s[0]).multiplyScalar(.282095),e.addScaledVector(s[1],.488603*i),e.addScaledVector(s[2],.488603*r),e.addScaledVector(s[3],.488603*n),e.addScaledVector(s[4],n*i*1.092548),e.addScaledVector(s[5],i*r*1.092548),e.addScaledVector(s[6],.315392*(3*r*r-1)),e.addScaledVector(s[7],n*r*1.092548),e.addScaledVector(s[8],.546274*(n*n-i*i)),e}getIrradianceAt(t,e){const n=t.x,i=t.y,r=t.z,s=this.coefficients;return e.copy(s[0]).multiplyScalar(.886227),e.addScaledVector(s[1],1.023328*i),e.addScaledVector(s[2],1.023328*r),e.addScaledVector(s[3],1.023328*n),e.addScaledVector(s[4],.858086*n*i),e.addScaledVector(s[5],.858086*i*r),e.addScaledVector(s[6],.743125*r*r-.247708),e.addScaledVector(s[7],.858086*n*r),e.addScaledVector(s[8],.429043*(n*n-i*i)),e}add(t){for(let e=0;e<9;e++)this.coefficients[e].add(t.coefficients[e]);return this}addScaledSH(t,e){for(let n=0;n<9;n++)this.coefficients[n].addScaledVector(t.coefficients[n],e);return this}scale(t){for(let e=0;e<9;e++)this.coefficients[e].multiplyScalar(t);return this}lerp(t,e){for(let n=0;n<9;n++)this.coefficients[n].lerp(t.coefficients[n],e);return this}equals(t){for(let e=0;e<9;e++)if(!this.coefficients[e].equals(t.coefficients[e]))return!1;return!0}copy(t){return this.set(t.coefficients)}clone(){return(new this.constructor).copy(this)}fromArray(t,e=0){const n=this.coefficients;for(let i=0;i<9;i++)n[i].fromArray(t,e+3*i);return this}toArray(t=[],e=0){const n=this.coefficients;for(let i=0;i<9;i++)n[i].toArray(t,e+3*i);return t}static getBasisAt(t,e){const n=t.x,i=t.y,r=t.z;e[0]=.282095,e[1]=.488603*i,e[2]=.488603*r,e[3]=.488603*n,e[4]=1.092548*n*i,e[5]=1.092548*i*r,e[6]=.315392*(3*r*r-1),e[7]=1.092548*n*r,e[8]=.546274*(n*n-i*i)}}class bc extends ic{constructor(t=new xc,e=1){super(void 0,e),this.isLightProbe=!0,this.sh=t}copy(t){return super.copy(t),this.sh.copy(t.sh),this}fromJSON(t){return this.intensity=t.intensity,this.sh.fromArray(t.sh),this}toJSON(t){const e=super.toJSON(t);return e.object.sh=this.sh.toArray(),e}}class Mc extends Ql{constructor(t){super(t),this.textures={}}load(t,e,n,i){const r=this,s=new ec(r.manager);s.setPath(r.path),s.setRequestHeader(r.requestHeader),s.setWithCredentials(r.withCredentials),s.load(t,(function(n){try{e(r.parse(JSON.parse(n)))}catch(e){i?i(e):console.error(e),r.manager.itemError(t)}}),n,i)}parse(t){const e=this.textures;function n(t){return void 0===e[t]&&console.warn("THREE.MaterialLoader: Undefined texture",t),e[t]}const i=Mc.createMaterialFromType(t.type);if(void 0!==t.uuid&&(i.uuid=t.uuid),void 0!==t.name&&(i.name=t.name),void 0!==t.color&&void 0!==i.color&&i.color.setHex(t.color),void 0!==t.roughness&&(i.roughness=t.roughness),void 0!==t.metalness&&(i.metalness=t.metalness),void 0!==t.sheen&&(i.sheen=t.sheen),void 0!==t.sheenColor&&(i.sheenColor=(new Ht).setHex(t.sheenColor)),void 0!==t.sheenRoughness&&(i.sheenRoughness=t.sheenRoughness),void 0!==t.emissive&&void 0!==i.emissive&&i.emissive.setHex(t.emissive),void 0!==t.specular&&void 0!==i.specular&&i.specular.setHex(t.specular),void 0!==t.specularIntensity&&(i.specularIntensity=t.specularIntensity),void 0!==t.specularColor&&void 0!==i.specularColor&&i.specularColor.setHex(t.specularColor),void 0!==t.shininess&&(i.shininess=t.shininess),void 0!==t.clearcoat&&(i.clearcoat=t.clearcoat),void 0!==t.clearcoatRoughness&&(i.clearcoatRoughness=t.clearcoatRoughness),void 0!==t.iridescence&&(i.iridescence=t.iridescence),void 0!==t.iridescenceIOR&&(i.iridescenceIOR=t.iridescenceIOR),void 0!==t.iridescenceThicknessRange&&(i.iridescenceThicknessRange=t.iridescenceThicknessRange),void 0!==t.transmission&&(i.transmission=t.transmission),void 0!==t.thickness&&(i.thickness=t.thickness),void 0!==t.attenuationDistance&&(i.attenuationDistance=t.attenuationDistance),void 0!==t.attenuationColor&&void 0!==i.attenuationColor&&i.attenuationColor.setHex(t.attenuationColor),void 0!==t.fog&&(i.fog=t.fog),void 0!==t.flatShading&&(i.flatShading=t.flatShading),void 0!==t.blending&&(i.blending=t.blending),void 0!==t.combine&&(i.combine=t.combine),void 0!==t.side&&(i.side=t.side),void 0!==t.shadowSide&&(i.shadowSide=t.shadowSide),void 0!==t.opacity&&(i.opacity=t.opacity),void 0!==t.transparent&&(i.transparent=t.transparent),void 0!==t.alphaTest&&(i.alphaTest=t.alphaTest),void 0!==t.depthTest&&(i.depthTest=t.depthTest),void 0!==t.depthWrite&&(i.depthWrite=t.depthWrite),void 0!==t.colorWrite&&(i.colorWrite=t.colorWrite),void 0!==t.stencilWrite&&(i.stencilWrite=t.stencilWrite),void 0!==t.stencilWriteMask&&(i.stencilWriteMask=t.stencilWriteMask),void 0!==t.stencilFunc&&(i.stencilFunc=t.stencilFunc),void 0!==t.stencilRef&&(i.stencilRef=t.stencilRef),void 0!==t.stencilFuncMask&&(i.stencilFuncMask=t.stencilFuncMask),void 0!==t.stencilFail&&(i.stencilFail=t.stencilFail),void 0!==t.stencilZFail&&(i.stencilZFail=t.stencilZFail),void 0!==t.stencilZPass&&(i.stencilZPass=t.stencilZPass),void 0!==t.wireframe&&(i.wireframe=t.wireframe),void 0!==t.wireframeLinewidth&&(i.wireframeLinewidth=t.wireframeLinewidth),void 0!==t.wireframeLinecap&&(i.wireframeLinecap=t.wireframeLinecap),void 0!==t.wireframeLinejoin&&(i.wireframeLinejoin=t.wireframeLinejoin),void 0!==t.rotation&&(i.rotation=t.rotation),1!==t.linewidth&&(i.linewidth=t.linewidth),void 0!==t.dashSize&&(i.dashSize=t.dashSize),void 0!==t.gapSize&&(i.gapSize=t.gapSize),void 0!==t.scale&&(i.scale=t.scale),void 0!==t.polygonOffset&&(i.polygonOffset=t.polygonOffset),void 0!==t.polygonOffsetFactor&&(i.polygonOffsetFactor=t.polygonOffsetFactor),void 0!==t.polygonOffsetUnits&&(i.polygonOffsetUnits=t.polygonOffsetUnits),void 0!==t.dithering&&(i.dithering=t.dithering),void 0!==t.alphaToCoverage&&(i.alphaToCoverage=t.alphaToCoverage),void 0!==t.premultipliedAlpha&&(i.premultipliedAlpha=t.premultipliedAlpha),void 0!==t.visible&&(i.visible=t.visible),void 0!==t.toneMapped&&(i.toneMapped=t.toneMapped),void 0!==t.userData&&(i.userData=t.userData),void 0!==t.vertexColors&&("number"==typeof t.vertexColors?i.vertexColors=t.vertexColors>0:i.vertexColors=t.vertexColors),void 0!==t.uniforms)for(const e in t.uniforms){const r=t.uniforms[e];switch(i.uniforms[e]={},r.type){case"t":i.uniforms[e].value=n(r.value);break;case"c":i.uniforms[e].value=(new Ht).setHex(r.value);break;case"v2":i.uniforms[e].value=(new At).fromArray(r.value);break;case"v3":i.uniforms[e].value=(new ee).fromArray(r.value);break;case"v4":i.uniforms[e].value=(new Jt).fromArray(r.value);break;case"m3":i.uniforms[e].value=(new Rt).fromArray(r.value);break;case"m4":i.uniforms[e].value=(new Ie).fromArray(r.value);break;default:i.uniforms[e].value=r.value}}if(void 0!==t.defines&&(i.defines=t.defines),void 0!==t.vertexShader&&(i.vertexShader=t.vertexShader),void 0!==t.fragmentShader&&(i.fragmentShader=t.fragmentShader),void 0!==t.extensions)for(const e in t.extensions)i.extensions[e]=t.extensions[e];if(void 0!==t.shading&&(i.flatShading=1===t.shading),void 0!==t.size&&(i.size=t.size),void 0!==t.sizeAttenuation&&(i.sizeAttenuation=t.sizeAttenuation),void 0!==t.map&&(i.map=n(t.map)),void 0!==t.matcap&&(i.matcap=n(t.matcap)),void 0!==t.alphaMap&&(i.alphaMap=n(t.alphaMap)),void 0!==t.bumpMap&&(i.bumpMap=n(t.bumpMap)),void 0!==t.bumpScale&&(i.bumpScale=t.bumpScale),void 0!==t.normalMap&&(i.normalMap=n(t.normalMap)),void 0!==t.normalMapType&&(i.normalMapType=t.normalMapType),void 0!==t.normalScale){let e=t.normalScale;!1===Array.isArray(e)&&(e=[e,e]),i.normalScale=(new At).fromArray(e)}return void 0!==t.displacementMap&&(i.displacementMap=n(t.displacementMap)),void 0!==t.displacementScale&&(i.displacementScale=t.displacementScale),void 0!==t.displacementBias&&(i.displacementBias=t.displacementBias),void 0!==t.roughnessMap&&(i.roughnessMap=n(t.roughnessMap)),void 0!==t.metalnessMap&&(i.metalnessMap=n(t.metalnessMap)),void 0!==t.emissiveMap&&(i.emissiveMap=n(t.emissiveMap)),void 0!==t.emissiveIntensity&&(i.emissiveIntensity=t.emissiveIntensity),void 0!==t.specularMap&&(i.specularMap=n(t.specularMap)),void 0!==t.specularIntensityMap&&(i.specularIntensityMap=n(t.specularIntensityMap)),void 0!==t.specularColorMap&&(i.specularColorMap=n(t.specularColorMap)),void 0!==t.envMap&&(i.envMap=n(t.envMap)),void 0!==t.envMapIntensity&&(i.envMapIntensity=t.envMapIntensity),void 0!==t.reflectivity&&(i.reflectivity=t.reflectivity),void 0!==t.refractionRatio&&(i.refractionRatio=t.refractionRatio),void 0!==t.lightMap&&(i.lightMap=n(t.lightMap)),void 0!==t.lightMapIntensity&&(i.lightMapIntensity=t.lightMapIntensity),void 0!==t.aoMap&&(i.aoMap=n(t.aoMap)),void 0!==t.aoMapIntensity&&(i.aoMapIntensity=t.aoMapIntensity),void 0!==t.gradientMap&&(i.gradientMap=n(t.gradientMap)),void 0!==t.clearcoatMap&&(i.clearcoatMap=n(t.clearcoatMap)),void 0!==t.clearcoatRoughnessMap&&(i.clearcoatRoughnessMap=n(t.clearcoatRoughnessMap)),void 0!==t.clearcoatNormalMap&&(i.clearcoatNormalMap=n(t.clearcoatNormalMap)),void 0!==t.clearcoatNormalScale&&(i.clearcoatNormalScale=(new At).fromArray(t.clearcoatNormalScale)),void 0!==t.iridescenceMap&&(i.iridescenceMap=n(t.iridescenceMap)),void 0!==t.iridescenceThicknessMap&&(i.iridescenceThicknessMap=n(t.iridescenceThicknessMap)),void 0!==t.transmissionMap&&(i.transmissionMap=n(t.transmissionMap)),void 0!==t.thicknessMap&&(i.thicknessMap=n(t.thicknessMap)),void 0!==t.sheenColorMap&&(i.sheenColorMap=n(t.sheenColorMap)),void 0!==t.sheenRoughnessMap&&(i.sheenRoughnessMap=n(t.sheenRoughnessMap)),i}setTextures(t){return this.textures=t,this}static createMaterialFromType(t){return new{ShadowMaterial:El,SpriteMaterial:ea,RawShaderMaterial:Tl,ShaderMaterial:ni,PointsMaterial:qa,MeshPhysicalMaterial:Rl,MeshStandardMaterial:Al,MeshPhongMaterial:Cl,MeshToonMaterial:Ll,MeshNormalMaterial:Pl,MeshLambertMaterial:Il,MeshDepthMaterial:Os,MeshDistanceMaterial:Ns,MeshBasicMaterial:_n,MeshMatcapMaterial:Dl,LineDashedMaterial:Ol,LineBasicMaterial:Fa,Material:vn}[t]}}class wc{static decodeText(t){if("undefined"!=typeof TextDecoder)return(new TextDecoder).decode(t);let e="";for(let n=0,i=t.length;n<i;n++)e+=String.fromCharCode(t[n]);try{return decodeURIComponent(escape(e))}catch(t){return e}}static extractUrlBase(t){const e=t.lastIndexOf("/");return-1===e?"./":t.slice(0,e+1)}static resolveURL(t,e){return"string"!=typeof t||""===t?"":(/^https?:\/\//i.test(e)&&/^\//.test(t)&&(e=e.replace(/(^https?:\/\/[^\/]+).*/i,"$1")),/^(https?:)?\/\//i.test(t)||/^data:.*,.*$/i.test(t)||/^blob:.*$/i.test(t)?t:e+t)}}class Sc extends In{constructor(){super(),this.isInstancedBufferGeometry=!0,this.type="InstancedBufferGeometry",this.instanceCount=1/0}copy(t){return super.copy(t),this.instanceCount=t.instanceCount,this}clone(){return(new this.constructor).copy(this)}toJSON(){const t=super.toJSON(this);return t.instanceCount=this.instanceCount,t.isInstancedBufferGeometry=!0,t}}class Ec extends Ql{constructor(t){super(t)}load(t,e,n,i){const r=this,s=new ec(r.manager);s.setPath(r.path),s.setRequestHeader(r.requestHeader),s.setWithCredentials(r.withCredentials),s.load(t,(function(n){try{e(r.parse(JSON.parse(n)))}catch(e){i?i(e):console.error(e),r.manager.itemError(t)}}),n,i)}parse(t){const e={},n={};function i(t,i){if(void 0!==e[i])return e[i];const r=t.interleavedBuffers[i],s=function(t,e){if(void 0!==n[e])return n[e];const i=t.arrayBuffers[e],r=new Uint32Array(i).buffer;return n[e]=r,r}(t,r.buffer),a=Pt(r.type,s),o=new $s(a,r.stride);return o.uuid=r.uuid,e[i]=o,o}const r=t.isInstancedBufferGeometry?new Sc:new In,s=t.data.index;if(void 0!==s){const t=Pt(s.type,s.array);r.setIndex(new bn(t,1))}const a=t.data.attributes;for(const e in a){const n=a[e];let s;if(n.isInterleavedBufferAttribute){const e=i(t.data,n.data);s=new ta(e,n.itemSize,n.offset,n.normalized)}else{const t=Pt(n.type,n.array);s=new(n.isInstancedBufferAttribute?Pa:bn)(t,n.itemSize,n.normalized)}void 0!==n.name&&(s.name=n.name),void 0!==n.usage&&s.setUsage(n.usage),void 0!==n.updateRange&&(s.updateRange.offset=n.updateRange.offset,s.updateRange.count=n.updateRange.count),r.setAttribute(e,s)}const o=t.data.morphAttributes;if(o)for(const e in o){const n=o[e],s=[];for(let e=0,r=n.length;e<r;e++){const r=n[e];let a;if(r.isInterleavedBufferAttribute){const e=i(t.data,r.data);a=new ta(e,r.itemSize,r.offset,r.normalized)}else{const t=Pt(r.type,r.array);a=new bn(t,r.itemSize,r.normalized)}void 0!==r.name&&(a.name=r.name),s.push(a)}r.morphAttributes[e]=s}t.data.morphTargetsRelative&&(r.morphTargetsRelative=!0);const l=t.data.groups||t.data.drawcalls||t.data.offsets;if(void 0!==l)for(let t=0,e=l.length;t!==e;++t){const e=l[t];r.addGroup(e.start,e.count,e.materialIndex)}const c=t.data.boundingSphere;if(void 0!==c){const t=new ee;void 0!==c.center&&t.fromArray(c.center),r.boundingSphere=new we(t,c.radius)}return t.name&&(r.name=t.name),t.userData&&(r.userData=t.userData),r}}const Tc={UVMapping:r,CubeReflectionMapping:s,CubeRefractionMapping:a,EquirectangularReflectionMapping:o,EquirectangularRefractionMapping:l,CubeUVReflectionMapping:c},Ac={RepeatWrapping:u,ClampToEdgeWrapping:h,MirroredRepeatWrapping:d},Rc={NearestFilter:p,NearestMipmapNearestFilter:f,NearestMipmapLinearFilter:m,LinearFilter:g,LinearMipmapNearestFilter:v,LinearMipmapLinearFilter:_};let Cc;const Lc={getContext:function(){return void 0===Cc&&(Cc=new(window.AudioContext||window.webkitAudioContext)),Cc},setContext:function(t){Cc=t}},Pc=new Ie,Ic=new Ie,Dc=new Ie;class Oc{constructor(t=!0){this.autoStart=t,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1}start(){this.startTime=Nc(),this.oldTime=this.startTime,this.elapsedTime=0,this.running=!0}stop(){this.getElapsedTime(),this.running=!1,this.autoStart=!1}getElapsedTime(){return this.getDelta(),this.elapsedTime}getDelta(){let t=0;if(this.autoStart&&!this.running)return this.start(),0;if(this.running){const e=Nc();t=(e-this.oldTime)/1e3,this.oldTime=e,this.elapsedTime+=t}return t}}function Nc(){return("undefined"==typeof performance?Date:performance).now()}const Uc=new ee,Fc=new te,Bc=new ee,zc=new ee;class kc extends rn{constructor(t){super(),this.type="Audio",this.listener=t,this.context=t.context,this.gain=this.context.createGain(),this.gain.connect(t.getInput()),this.autoplay=!1,this.buffer=null,this.detune=0,this.loop=!1,this.loopStart=0,this.loopEnd=0,this.offset=0,this.duration=void 0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.source=null,this.sourceType="empty",this._startedAt=0,this._progress=0,this._connected=!1,this.filters=[]}getOutput(){return this.gain}setNodeSource(t){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=t,this.connect(),this}setMediaElementSource(t){return this.hasPlaybackControl=!1,this.sourceType="mediaNode",this.source=this.context.createMediaElementSource(t),this.connect(),this}setMediaStreamSource(t){return this.hasPlaybackControl=!1,this.sourceType="mediaStreamNode",this.source=this.context.createMediaStreamSource(t),this.connect(),this}setBuffer(t){return this.buffer=t,this.sourceType="buffer",this.autoplay&&this.play(),this}play(t=0){if(!0===this.isPlaying)return void console.warn("THREE.Audio: Audio is already playing.");if(!1===this.hasPlaybackControl)return void console.warn("THREE.Audio: this Audio has no playback control.");this._startedAt=this.context.currentTime+t;const e=this.context.createBufferSource();return e.buffer=this.buffer,e.loop=this.loop,e.loopStart=this.loopStart,e.loopEnd=this.loopEnd,e.onended=this.onEnded.bind(this),e.start(this._startedAt,this._progress+this.offset,this.duration),this.isPlaying=!0,this.source=e,this.setDetune(this.detune),this.setPlaybackRate(this.playbackRate),this.connect()}pause(){if(!1!==this.hasPlaybackControl)return!0===this.isPlaying&&(this._progress+=Math.max(this.context.currentTime-this._startedAt,0)*this.playbackRate,!0===this.loop&&(this._progress=this._progress%(this.duration||this.buffer.duration)),this.source.stop(),this.source.onended=null,this.isPlaying=!1),this;console.warn("THREE.Audio: this Audio has no playback control.")}stop(){if(!1!==this.hasPlaybackControl)return this._progress=0,this.source.stop(),this.source.onended=null,this.isPlaying=!1,this;console.warn("THREE.Audio: this Audio has no playback control.")}connect(){if(this.filters.length>0){this.source.connect(this.filters[0]);for(let t=1,e=this.filters.length;t<e;t++)this.filters[t-1].connect(this.filters[t]);this.filters[this.filters.length-1].connect(this.getOutput())}else this.source.connect(this.getOutput());return this._connected=!0,this}disconnect(){if(this.filters.length>0){this.source.disconnect(this.filters[0]);for(let t=1,e=this.filters.length;t<e;t++)this.filters[t-1].disconnect(this.filters[t]);this.filters[this.filters.length-1].disconnect(this.getOutput())}else this.source.disconnect(this.getOutput());return this._connected=!1,this}getFilters(){return this.filters}setFilters(t){return t||(t=[]),!0===this._connected?(this.disconnect(),this.filters=t.slice(),this.connect()):this.filters=t.slice(),this}setDetune(t){if(this.detune=t,void 0!==this.source.detune)return!0===this.isPlaying&&this.source.detune.setTargetAtTime(this.detune,this.context.currentTime,.01),this}getDetune(){return this.detune}getFilter(){return this.getFilters()[0]}setFilter(t){return this.setFilters(t?[t]:[])}setPlaybackRate(t){if(!1!==this.hasPlaybackControl)return this.playbackRate=t,!0===this.isPlaying&&this.source.playbackRate.setTargetAtTime(this.playbackRate,this.context.currentTime,.01),this;console.warn("THREE.Audio: this Audio has no playback control.")}getPlaybackRate(){return this.playbackRate}onEnded(){this.isPlaying=!1}getLoop(){return!1===this.hasPlaybackControl?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.loop}setLoop(t){if(!1!==this.hasPlaybackControl)return this.loop=t,!0===this.isPlaying&&(this.source.loop=this.loop),this;console.warn("THREE.Audio: this Audio has no playback control.")}setLoopStart(t){return this.loopStart=t,this}setLoopEnd(t){return this.loopEnd=t,this}getVolume(){return this.gain.gain.value}setVolume(t){return this.gain.gain.setTargetAtTime(t,this.context.currentTime,.01),this}}const Gc=new ee,Vc=new te,Hc=new ee,Wc=new ee;class jc{constructor(t,e,n){let i,r,s;switch(this.binding=t,this.valueSize=n,e){case"quaternion":i=this._slerp,r=this._slerpAdditive,s=this._setAdditiveIdentityQuaternion,this.buffer=new Float64Array(6*n),this._workIndex=5;break;case"string":case"bool":i=this._select,r=this._select,s=this._setAdditiveIdentityOther,this.buffer=new Array(5*n);break;default:i=this._lerp,r=this._lerpAdditive,s=this._setAdditiveIdentityNumeric,this.buffer=new Float64Array(5*n)}this._mixBufferRegion=i,this._mixBufferRegionAdditive=r,this._setIdentity=s,this._origIndex=3,this._addIndex=4,this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,this.useCount=0,this.referenceCount=0}accumulate(t,e){const n=this.buffer,i=this.valueSize,r=t*i+i;let s=this.cumulativeWeight;if(0===s){for(let t=0;t!==i;++t)n[r+t]=n[t];s=e}else{s+=e;const t=e/s;this._mixBufferRegion(n,r,0,t,i)}this.cumulativeWeight=s}accumulateAdditive(t){const e=this.buffer,n=this.valueSize,i=n*this._addIndex;0===this.cumulativeWeightAdditive&&this._setIdentity(),this._mixBufferRegionAdditive(e,i,0,t,n),this.cumulativeWeightAdditive+=t}apply(t){const e=this.valueSize,n=this.buffer,i=t*e+e,r=this.cumulativeWeight,s=this.cumulativeWeightAdditive,a=this.binding;if(this.cumulativeWeight=0,this.cumulativeWeightAdditive=0,r<1){const t=e*this._origIndex;this._mixBufferRegion(n,i,t,1-r,e)}s>0&&this._mixBufferRegionAdditive(n,i,this._addIndex*e,1,e);for(let t=e,r=e+e;t!==r;++t)if(n[t]!==n[t+e]){a.setValue(n,i);break}}saveOriginalState(){const t=this.binding,e=this.buffer,n=this.valueSize,i=n*this._origIndex;t.getValue(e,i);for(let t=n,r=i;t!==r;++t)e[t]=e[i+t%n];this._setIdentity(),this.cumulativeWeight=0,this.cumulativeWeightAdditive=0}restoreOriginalState(){const t=3*this.valueSize;this.binding.setValue(this.buffer,t)}_setAdditiveIdentityNumeric(){const t=this._addIndex*this.valueSize,e=t+this.valueSize;for(let n=t;n<e;n++)this.buffer[n]=0}_setAdditiveIdentityQuaternion(){this._setAdditiveIdentityNumeric(),this.buffer[this._addIndex*this.valueSize+3]=1}_setAdditiveIdentityOther(){const t=this._origIndex*this.valueSize,e=this._addIndex*this.valueSize;for(let n=0;n<this.valueSize;n++)this.buffer[e+n]=this.buffer[t+n]}_select(t,e,n,i,r){if(i>=.5)for(let i=0;i!==r;++i)t[e+i]=t[n+i]}_slerp(t,e,n,i){te.slerpFlat(t,e,t,e,t,n,i)}_slerpAdditive(t,e,n,i,r){const s=this._workIndex*r;te.multiplyQuaternionsFlat(t,s,t,e,t,n),te.slerpFlat(t,e,t,e,t,s,i)}_lerp(t,e,n,i,r){const s=1-i;for(let a=0;a!==r;++a){const r=e+a;t[r]=t[r]*s+t[n+a]*i}}_lerpAdditive(t,e,n,i,r){for(let s=0;s!==r;++s){const r=e+s;t[r]=t[r]+t[n+s]*i}}}const Xc=new RegExp("[\\[\\]\\.:\\/]","g"),Yc="[^\\[\\]\\.:\\/]",qc="[^"+"\\[\\]\\.:\\/".replace("\\.","")+"]",Zc=new RegExp("^"+/((?:WC+[\/:])*)/.source.replace("WC",Yc)+/(WCOD+)?/.source.replace("WCOD",qc)+/(?:\.(WC+)(?:\[(.+)\])?)?/.source.replace("WC",Yc)+/\.(WC+)(?:\[(.+)\])?/.source.replace("WC",Yc)+"$"),Jc=["material","materials","bones"];class Kc{constructor(t,e,n){this.path=e,this.parsedPath=n||Kc.parseTrackName(e),this.node=Kc.findNode(t,this.parsedPath.nodeName)||t,this.rootNode=t,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}static create(t,e,n){return t&&t.isAnimationObjectGroup?new Kc.Composite(t,e,n):new Kc(t,e,n)}static sanitizeNodeName(t){return t.replace(/\s/g,"_").replace(Xc,"")}static parseTrackName(t){const e=Zc.exec(t);if(null===e)throw new Error("PropertyBinding: Cannot parse trackName: "+t);const n={nodeName:e[2],objectName:e[3],objectIndex:e[4],propertyName:e[5],propertyIndex:e[6]},i=n.nodeName&&n.nodeName.lastIndexOf(".");if(void 0!==i&&-1!==i){const t=n.nodeName.substring(i+1);-1!==Jc.indexOf(t)&&(n.nodeName=n.nodeName.substring(0,i),n.objectName=t)}if(null===n.propertyName||0===n.propertyName.length)throw new Error("PropertyBinding: can not parse propertyName from trackName: "+t);return n}static findNode(t,e){if(void 0===e||""===e||"."===e||-1===e||e===t.name||e===t.uuid)return t;if(t.skeleton){const n=t.skeleton.getBoneByName(e);if(void 0!==n)return n}if(t.children){const n=function(t){for(let i=0;i<t.length;i++){const r=t[i];if(r.name===e||r.uuid===e)return r;const s=n(r.children);if(s)return s}return null},i=n(t.children);if(i)return i}return null}_getValue_unavailable(){}_setValue_unavailable(){}_getValue_direct(t,e){t[e]=this.targetObject[this.propertyName]}_getValue_array(t,e){const n=this.resolvedProperty;for(let i=0,r=n.length;i!==r;++i)t[e++]=n[i]}_getValue_arrayElement(t,e){t[e]=this.resolvedProperty[this.propertyIndex]}_getValue_toArray(t,e){this.resolvedProperty.toArray(t,e)}_setValue_direct(t,e){this.targetObject[this.propertyName]=t[e]}_setValue_direct_setNeedsUpdate(t,e){this.targetObject[this.propertyName]=t[e],this.targetObject.needsUpdate=!0}_setValue_direct_setMatrixWorldNeedsUpdate(t,e){this.targetObject[this.propertyName]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_array(t,e){const n=this.resolvedProperty;for(let i=0,r=n.length;i!==r;++i)n[i]=t[e++]}_setValue_array_setNeedsUpdate(t,e){const n=this.resolvedProperty;for(let i=0,r=n.length;i!==r;++i)n[i]=t[e++];this.targetObject.needsUpdate=!0}_setValue_array_setMatrixWorldNeedsUpdate(t,e){const n=this.resolvedProperty;for(let i=0,r=n.length;i!==r;++i)n[i]=t[e++];this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_arrayElement(t,e){this.resolvedProperty[this.propertyIndex]=t[e]}_setValue_arrayElement_setNeedsUpdate(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.needsUpdate=!0}_setValue_arrayElement_setMatrixWorldNeedsUpdate(t,e){this.resolvedProperty[this.propertyIndex]=t[e],this.targetObject.matrixWorldNeedsUpdate=!0}_setValue_fromArray(t,e){this.resolvedProperty.fromArray(t,e)}_setValue_fromArray_setNeedsUpdate(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.needsUpdate=!0}_setValue_fromArray_setMatrixWorldNeedsUpdate(t,e){this.resolvedProperty.fromArray(t,e),this.targetObject.matrixWorldNeedsUpdate=!0}_getValue_unbound(t,e){this.bind(),this.getValue(t,e)}_setValue_unbound(t,e){this.bind(),this.setValue(t,e)}bind(){let t=this.node;const e=this.parsedPath,n=e.objectName,i=e.propertyName;let r=e.propertyIndex;if(t||(t=Kc.findNode(this.rootNode,e.nodeName)||this.rootNode,this.node=t),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,!t)return void console.error("THREE.PropertyBinding: Trying to update node for track: "+this.path+" but it wasn't found.");if(n){let i=e.objectIndex;switch(n){case"materials":if(!t.material)return void console.error("THREE.PropertyBinding: Can not bind to material as node does not have a material.",this);if(!t.material.materials)return void console.error("THREE.PropertyBinding: Can not bind to material.materials as node.material does not have a materials array.",this);t=t.material.materials;break;case"bones":if(!t.skeleton)return void console.error("THREE.PropertyBinding: Can not bind to bones as node does not have a skeleton.",this);t=t.skeleton.bones;for(let e=0;e<t.length;e++)if(t[e].name===i){i=e;break}break;default:if(void 0===t[n])return void console.error("THREE.PropertyBinding: Can not bind to objectName of node undefined.",this);t=t[n]}if(void 0!==i){if(void 0===t[i])return void console.error("THREE.PropertyBinding: Trying to bind to objectIndex of objectName, but is undefined.",this,t);t=t[i]}}const s=t[i];if(void 0===s){const n=e.nodeName;return void console.error("THREE.PropertyBinding: Trying to update property for track: "+n+"."+i+" but it wasn't found.",t)}let a=this.Versioning.None;this.targetObject=t,void 0!==t.needsUpdate?a=this.Versioning.NeedsUpdate:void 0!==t.matrixWorldNeedsUpdate&&(a=this.Versioning.MatrixWorldNeedsUpdate);let o=this.BindingType.Direct;if(void 0!==r){if("morphTargetInfluences"===i){if(!t.geometry)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.",this);if(!t.geometry.morphAttributes)return void console.error("THREE.PropertyBinding: Can not bind to morphTargetInfluences because node does not have a geometry.morphAttributes.",this);void 0!==t.morphTargetDictionary[r]&&(r=t.morphTargetDictionary[r])}o=this.BindingType.ArrayElement,this.resolvedProperty=s,this.propertyIndex=r}else void 0!==s.fromArray&&void 0!==s.toArray?(o=this.BindingType.HasFromToArray,this.resolvedProperty=s):Array.isArray(s)?(o=this.BindingType.EntireArray,this.resolvedProperty=s):this.propertyName=i;this.getValue=this.GetterByBindingType[o],this.setValue=this.SetterByBindingTypeAndVersioning[o][a]}unbind(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}}Kc.Composite=class{constructor(t,e,n){const i=n||Kc.parseTrackName(e);this._targetGroup=t,this._bindings=t.subscribe_(e,i)}getValue(t,e){this.bind();const n=this._targetGroup.nCachedObjects_,i=this._bindings[n];void 0!==i&&i.getValue(t,e)}setValue(t,e){const n=this._bindings;for(let i=this._targetGroup.nCachedObjects_,r=n.length;i!==r;++i)n[i].setValue(t,e)}bind(){const t=this._bindings;for(let e=this._targetGroup.nCachedObjects_,n=t.length;e!==n;++e)t[e].bind()}unbind(){const t=this._bindings;for(let e=this._targetGroup.nCachedObjects_,n=t.length;e!==n;++e)t[e].unbind()}},Kc.prototype.BindingType={Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Kc.prototype.Versioning={None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},Kc.prototype.GetterByBindingType=[Kc.prototype._getValue_direct,Kc.prototype._getValue_array,Kc.prototype._getValue_arrayElement,Kc.prototype._getValue_toArray],Kc.prototype.SetterByBindingTypeAndVersioning=[[Kc.prototype._setValue_direct,Kc.prototype._setValue_direct_setNeedsUpdate,Kc.prototype._setValue_direct_setMatrixWorldNeedsUpdate],[Kc.prototype._setValue_array,Kc.prototype._setValue_array_setNeedsUpdate,Kc.prototype._setValue_array_setMatrixWorldNeedsUpdate],[Kc.prototype._setValue_arrayElement,Kc.prototype._setValue_arrayElement_setNeedsUpdate,Kc.prototype._setValue_arrayElement_setMatrixWorldNeedsUpdate],[Kc.prototype._setValue_fromArray,Kc.prototype._setValue_fromArray_setNeedsUpdate,Kc.prototype._setValue_fromArray_setMatrixWorldNeedsUpdate]];class $c{constructor(t,e,n=null,i=e.blendMode){this._mixer=t,this._clip=e,this._localRoot=n,this.blendMode=i;const r=e.tracks,s=r.length,a=new Array(s),o={endingStart:nt,endingEnd:nt};for(let t=0;t!==s;++t){const e=r[t].createInterpolant(null);a[t]=e,e.settings=o}this._interpolantSettings=o,this._interpolants=a,this._propertyBindings=new Array(s),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=2201,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0}play(){return this._mixer._activateAction(this),this}stop(){return this._mixer._deactivateAction(this),this.reset()}reset(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()}isRunning(){return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)}isScheduled(){return this._mixer._isActiveAction(this)}startAt(t){return this._startTime=t,this}setLoop(t,e){return this.loop=t,this.repetitions=e,this}setEffectiveWeight(t){return this.weight=t,this._effectiveWeight=this.enabled?t:0,this.stopFading()}getEffectiveWeight(){return this._effectiveWeight}fadeIn(t){return this._scheduleFading(t,0,1)}fadeOut(t){return this._scheduleFading(t,1,0)}crossFadeFrom(t,e,n){if(t.fadeOut(e),this.fadeIn(e),n){const n=this._clip.duration,i=t._clip.duration,r=i/n,s=n/i;t.warp(1,r,e),this.warp(s,1,e)}return this}crossFadeTo(t,e,n){return t.crossFadeFrom(this,e,n)}stopFading(){const t=this._weightInterpolant;return null!==t&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this}setEffectiveTimeScale(t){return this.timeScale=t,this._effectiveTimeScale=this.paused?0:t,this.stopWarping()}getEffectiveTimeScale(){return this._effectiveTimeScale}setDuration(t){return this.timeScale=this._clip.duration/t,this.stopWarping()}syncWith(t){return this.time=t.time,this.timeScale=t.timeScale,this.stopWarping()}halt(t){return this.warp(this._effectiveTimeScale,0,t)}warp(t,e,n){const i=this._mixer,r=i.time,s=this.timeScale;let a=this._timeScaleInterpolant;null===a&&(a=i._lendControlInterpolant(),this._timeScaleInterpolant=a);const o=a.parameterPositions,l=a.sampleValues;return o[0]=r,o[1]=r+n,l[0]=t/s,l[1]=e/s,this}stopWarping(){const t=this._timeScaleInterpolant;return null!==t&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(t)),this}getMixer(){return this._mixer}getClip(){return this._clip}getRoot(){return this._localRoot||this._mixer._root}_update(t,e,n,i){if(!this.enabled)return void this._updateWeight(t);const r=this._startTime;if(null!==r){const i=(t-r)*n;if(i<0||0===n)return;this._startTime=null,e=n*i}e*=this._updateTimeScale(t);const s=this._updateTime(e),a=this._updateWeight(t);if(a>0){const t=this._interpolants,e=this._propertyBindings;if(this.blendMode===st)for(let n=0,i=t.length;n!==i;++n)t[n].evaluate(s),e[n].accumulateAdditive(a);else for(let n=0,r=t.length;n!==r;++n)t[n].evaluate(s),e[n].accumulate(i,a)}}_updateWeight(t){let e=0;if(this.enabled){e=this.weight;const n=this._weightInterpolant;if(null!==n){const i=n.evaluate(t)[0];e*=i,t>n.parameterPositions[1]&&(this.stopFading(),0===i&&(this.enabled=!1))}}return this._effectiveWeight=e,e}_updateTimeScale(t){let e=0;if(!this.paused){e=this.timeScale;const n=this._timeScaleInterpolant;null!==n&&(e*=n.evaluate(t)[0],t>n.parameterPositions[1]&&(this.stopWarping(),0===e?this.paused=!0:this.timeScale=e))}return this._effectiveTimeScale=e,e}_updateTime(t){const e=this._clip.duration,n=this.loop;let i=this.time+t,r=this._loopCount;const s=2202===n;if(0===t)return-1===r?i:s&&1==(1&r)?e-i:i;if(2200===n){-1===r&&(this._loopCount=0,this._setEndings(!0,!0,!1));t:{if(i>=e)i=e;else{if(!(i<0)){this.time=i;break t}i=0}this.clampWhenFinished?this.paused=!0:this.enabled=!1,this.time=i,this._mixer.dispatchEvent({type:"finished",action:this,direction:t<0?-1:1})}}else{if(-1===r&&(t>=0?(r=0,this._setEndings(!0,0===this.repetitions,s)):this._setEndings(0===this.repetitions,!0,s)),i>=e||i<0){const n=Math.floor(i/e);i-=e*n,r+=Math.abs(n);const a=this.repetitions-r;if(a<=0)this.clampWhenFinished?this.paused=!0:this.enabled=!1,i=t>0?e:0,this.time=i,this._mixer.dispatchEvent({type:"finished",action:this,direction:t>0?1:-1});else{if(1===a){const e=t<0;this._setEndings(e,!e,s)}else this._setEndings(!1,!1,s);this._loopCount=r,this.time=i,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:n})}}else this.time=i;if(s&&1==(1&r))return e-i}return i}_setEndings(t,e,n){const i=this._interpolantSettings;n?(i.endingStart=it,i.endingEnd=it):(i.endingStart=t?this.zeroSlopeAtStart?it:nt:rt,i.endingEnd=e?this.zeroSlopeAtEnd?it:nt:rt)}_scheduleFading(t,e,n){const i=this._mixer,r=i.time;let s=this._weightInterpolant;null===s&&(s=i._lendControlInterpolant(),this._weightInterpolant=s);const a=s.parameterPositions,o=s.sampleValues;return a[0]=r,o[0]=e,a[1]=r+t,o[1]=n,this}}const Qc=new Float32Array(1);class tu{constructor(t){"string"==typeof t&&(console.warn("THREE.Uniform: Type parameter is no longer needed."),t=arguments[1]),this.value=t}clone(){return new tu(void 0===this.value.clone?this.value:this.value.clone())}}function eu(t,e){return t.distance-e.distance}function nu(t,e,n,i){if(t.layers.test(e.layers)&&t.raycast(e,n),!0===i){const i=t.children;for(let t=0,r=i.length;t<r;t++)nu(i[t],e,n,!0)}}const iu=new At,ru=new ee,su=new ee,au=new ee,ou=new ee,lu=new Ie,cu=new Ie;function uu(t){const e=[];!0===t.isBone&&e.push(t);for(let n=0;n<t.children.length;n++)e.push.apply(e,uu(t.children[n]));return e}const hu=new ee,du=new Ht,pu=new Ht,fu=new ee,mu=new ee,gu=new ee,vu=new ee,_u=new ii;function yu(t,e,n,i,r,s,a){vu.set(r,s,a).unproject(i);const o=e[t];if(void 0!==o){const t=n.getAttribute("position");for(let e=0,n=o.length;e<n;e++)t.setXYZ(o[e],vu.x,vu.y,vu.z)}}const xu=new re,bu=new ee;let Mu,wu;const{floatView:Su,uint32View:Eu,baseTable:Tu,shiftTable:Au,mantissaTable:Ru,exponentTable:Cu,offsetTable:Lu}=Pu();function Pu(){const t=new ArrayBuffer(4),e=new Float32Array(t),n=new Uint32Array(t),i=new Uint32Array(512),r=new Uint32Array(512);for(let t=0;t<256;++t){const e=t-127;e<-27?(i[t]=0,i[256|t]=32768,r[t]=24,r[256|t]=24):e<-14?(i[t]=1024>>-e-14,i[256|t]=1024>>-e-14|32768,r[t]=-e-1,r[256|t]=-e-1):e<=15?(i[t]=e+15<<10,i[256|t]=e+15<<10|32768,r[t]=13,r[256|t]=13):e<128?(i[t]=31744,i[256|t]=64512,r[t]=24,r[256|t]=24):(i[t]=31744,i[256|t]=64512,r[t]=13,r[256|t]=13)}const s=new Uint32Array(2048),a=new Uint32Array(64),o=new Uint32Array(64);for(let t=1;t<1024;++t){let e=t<<13,n=0;for(;0==(8388608&e);)e<<=1,n-=8388608;e&=-8388609,n+=947912704,s[t]=e|n}for(let t=1024;t<2048;++t)s[t]=939524096+(t-1024<<13);for(let t=1;t<31;++t)a[t]=t<<23;a[31]=1199570944,a[32]=2147483648;for(let t=33;t<63;++t)a[t]=2147483648+(t-32<<23);a[63]=3347054592;for(let t=1;t<64;++t)32!==t&&(o[t]=1024);return{floatView:e,uint32View:n,baseTable:i,shiftTable:r,mantissaTable:s,exponentTable:a,offsetTable:o}}var Iu=Object.freeze({__proto__:null,toHalfFloat:function(t){Math.abs(t)>65504&&console.warn("THREE.DataUtils.toHalfFloat(): Value out of range."),t=xt(t,-65504,65504),Su[0]=t;const e=Eu[0],n=e>>23&511;return Tu[n]+((8388607&e)>>Au[n])},fromHalfFloat:function(t){const e=t>>10;return Eu[0]=Ru[Lu[e]+(1023&t)]+Cu[e],Su[0]}});"undefined"!=typeof __THREE_DEVTOOLS__&&__THREE_DEVTOOLS__.dispatchEvent(new CustomEvent("register",{detail:{revision:n}})),"undefined"!=typeof window&&(window.__THREE__?console.warn("WARNING: Multiple instances of Three.js being imported."):window.__THREE__=n),e.ACESFilmicToneMapping=4,e.AddEquation=i,e.AddOperation=2,e.AdditiveAnimationBlendMode=st,e.AdditiveBlending=2,e.AlphaFormat=1021,e.AlwaysDepth=1,e.AlwaysStencilFunc=519,e.AmbientLight=_c,e.AmbientLightProbe=class extends bc{constructor(t,e=1){super(void 0,e),this.isAmbientLightProbe=!0;const n=(new Ht).set(t);this.sh.coefficients[0].set(n.r,n.g,n.b).multiplyScalar(2*Math.sqrt(Math.PI))}},e.AnimationClip=ql,e.AnimationLoader=class extends Ql{constructor(t){super(t)}load(t,e,n,i){const r=this,s=new ec(this.manager);s.setPath(this.path),s.setRequestHeader(this.requestHeader),s.setWithCredentials(this.withCredentials),s.load(t,(function(n){try{e(r.parse(JSON.parse(n)))}catch(e){i?i(e):console.error(e),r.manager.itemError(t)}}),n,i)}parse(t){const e=[];for(let n=0;n<t.length;n++){const i=ql.parse(t[n]);e.push(i)}return e}},e.AnimationMixer=class extends ft{constructor(t){super(),this._root=t,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1}_bindAction(t,e){const n=t._localRoot||this._root,i=t._clip.tracks,r=i.length,s=t._propertyBindings,a=t._interpolants,o=n.uuid,l=this._bindingsByRootAndName;let c=l[o];void 0===c&&(c={},l[o]=c);for(let t=0;t!==r;++t){const r=i[t],l=r.name;let u=c[l];if(void 0!==u)++u.referenceCount,s[t]=u;else{if(u=s[t],void 0!==u){null===u._cacheIndex&&(++u.referenceCount,this._addInactiveBinding(u,o,l));continue}const i=e&&e._propertyBindings[t].binding.parsedPath;u=new jc(Kc.create(n,l,i),r.ValueTypeName,r.getValueSize()),++u.referenceCount,this._addInactiveBinding(u,o,l),s[t]=u}a[t].resultBuffer=u.buffer}}_activateAction(t){if(!this._isActiveAction(t)){if(null===t._cacheIndex){const e=(t._localRoot||this._root).uuid,n=t._clip.uuid,i=this._actionsByClip[n];this._bindAction(t,i&&i.knownActions[0]),this._addInactiveAction(t,n,e)}const e=t._propertyBindings;for(let t=0,n=e.length;t!==n;++t){const n=e[t];0==n.useCount++&&(this._lendBinding(n),n.saveOriginalState())}this._lendAction(t)}}_deactivateAction(t){if(this._isActiveAction(t)){const e=t._propertyBindings;for(let t=0,n=e.length;t!==n;++t){const n=e[t];0==--n.useCount&&(n.restoreOriginalState(),this._takeBackBinding(n))}this._takeBackAction(t)}}_initMemoryManager(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;const t=this;this.stats={actions:{get total(){return t._actions.length},get inUse(){return t._nActiveActions}},bindings:{get total(){return t._bindings.length},get inUse(){return t._nActiveBindings}},controlInterpolants:{get total(){return t._controlInterpolants.length},get inUse(){return t._nActiveControlInterpolants}}}}_isActiveAction(t){const e=t._cacheIndex;return null!==e&&e<this._nActiveActions}_addInactiveAction(t,e,n){const i=this._actions,r=this._actionsByClip;let s=r[e];if(void 0===s)s={knownActions:[t],actionByRoot:{}},t._byClipCacheIndex=0,r[e]=s;else{const e=s.knownActions;t._byClipCacheIndex=e.length,e.push(t)}t._cacheIndex=i.length,i.push(t),s.actionByRoot[n]=t}_removeInactiveAction(t){const e=this._actions,n=e[e.length-1],i=t._cacheIndex;n._cacheIndex=i,e[i]=n,e.pop(),t._cacheIndex=null;const r=t._clip.uuid,s=this._actionsByClip,a=s[r],o=a.knownActions,l=o[o.length-1],c=t._byClipCacheIndex;l._byClipCacheIndex=c,o[c]=l,o.pop(),t._byClipCacheIndex=null,delete a.actionByRoot[(t._localRoot||this._root).uuid],0===o.length&&delete s[r],this._removeInactiveBindingsForAction(t)}_removeInactiveBindingsForAction(t){const e=t._propertyBindings;for(let t=0,n=e.length;t!==n;++t){const n=e[t];0==--n.referenceCount&&this._removeInactiveBinding(n)}}_lendAction(t){const e=this._actions,n=t._cacheIndex,i=this._nActiveActions++,r=e[i];t._cacheIndex=i,e[i]=t,r._cacheIndex=n,e[n]=r}_takeBackAction(t){const e=this._actions,n=t._cacheIndex,i=--this._nActiveActions,r=e[i];t._cacheIndex=i,e[i]=t,r._cacheIndex=n,e[n]=r}_addInactiveBinding(t,e,n){const i=this._bindingsByRootAndName,r=this._bindings;let s=i[e];void 0===s&&(s={},i[e]=s),s[n]=t,t._cacheIndex=r.length,r.push(t)}_removeInactiveBinding(t){const e=this._bindings,n=t.binding,i=n.rootNode.uuid,r=n.path,s=this._bindingsByRootAndName,a=s[i],o=e[e.length-1],l=t._cacheIndex;o._cacheIndex=l,e[l]=o,e.pop(),delete a[r],0===Object.keys(a).length&&delete s[i]}_lendBinding(t){const e=this._bindings,n=t._cacheIndex,i=this._nActiveBindings++,r=e[i];t._cacheIndex=i,e[i]=t,r._cacheIndex=n,e[n]=r}_takeBackBinding(t){const e=this._bindings,n=t._cacheIndex,i=--this._nActiveBindings,r=e[i];t._cacheIndex=i,e[i]=t,r._cacheIndex=n,e[n]=r}_lendControlInterpolant(){const t=this._controlInterpolants,e=this._nActiveControlInterpolants++;let n=t[e];return void 0===n&&(n=new Bl(new Float32Array(2),new Float32Array(2),1,Qc),n.__cacheIndex=e,t[e]=n),n}_takeBackControlInterpolant(t){const e=this._controlInterpolants,n=t.__cacheIndex,i=--this._nActiveControlInterpolants,r=e[i];t.__cacheIndex=i,e[i]=t,r.__cacheIndex=n,e[n]=r}clipAction(t,e,n){const i=e||this._root,r=i.uuid;let s="string"==typeof t?ql.findByName(i,t):t;const a=null!==s?s.uuid:t,o=this._actionsByClip[a];let l=null;if(void 0===n&&(n=null!==s?s.blendMode:2500),void 0!==o){const t=o.actionByRoot[r];if(void 0!==t&&t.blendMode===n)return t;l=o.knownActions[0],null===s&&(s=l._clip)}if(null===s)return null;const c=new $c(this,s,e,n);return this._bindAction(c,l),this._addInactiveAction(c,a,r),c}existingAction(t,e){const n=e||this._root,i=n.uuid,r="string"==typeof t?ql.findByName(n,t):t,s=r?r.uuid:t,a=this._actionsByClip[s];return void 0!==a&&a.actionByRoot[i]||null}stopAllAction(){const t=this._actions;for(let e=this._nActiveActions-1;e>=0;--e)t[e].stop();return this}update(t){t*=this.timeScale;const e=this._actions,n=this._nActiveActions,i=this.time+=t,r=Math.sign(t),s=this._accuIndex^=1;for(let a=0;a!==n;++a)e[a]._update(i,t,r,s);const a=this._bindings,o=this._nActiveBindings;for(let t=0;t!==o;++t)a[t].apply(s);return this}setTime(t){this.time=0;for(let t=0;t<this._actions.length;t++)this._actions[t].time=0;return this.update(t)}getRoot(){return this._root}uncacheClip(t){const e=this._actions,n=t.uuid,i=this._actionsByClip,r=i[n];if(void 0!==r){const t=r.knownActions;for(let n=0,i=t.length;n!==i;++n){const i=t[n];this._deactivateAction(i);const r=i._cacheIndex,s=e[e.length-1];i._cacheIndex=null,i._byClipCacheIndex=null,s._cacheIndex=r,e[r]=s,e.pop(),this._removeInactiveBindingsForAction(i)}delete i[n]}}uncacheRoot(t){const e=t.uuid,n=this._actionsByClip;for(const t in n){const i=n[t].actionByRoot[e];void 0!==i&&(this._deactivateAction(i),this._removeInactiveAction(i))}const i=this._bindingsByRootAndName[e];if(void 0!==i)for(const t in i){const e=i[t];e.restoreOriginalState(),this._removeInactiveBinding(e)}}uncacheAction(t,e){const n=this.existingAction(t,e);null!==n&&(this._deactivateAction(n),this._removeInactiveAction(n))}},e.AnimationObjectGroup=class{constructor(){this.isAnimationObjectGroup=!0,this.uuid=yt(),this._objects=Array.prototype.slice.call(arguments),this.nCachedObjects_=0;const t={};this._indicesByUUID=t;for(let e=0,n=arguments.length;e!==n;++e)t[arguments[e].uuid]=e;this._paths=[],this._parsedPaths=[],this._bindings=[],this._bindingsIndicesByPath={};const e=this;this.stats={objects:{get total(){return e._objects.length},get inUse(){return this.total-e.nCachedObjects_}},get bindingsPerObject(){return e._bindings.length}}}add(){const t=this._objects,e=this._indicesByUUID,n=this._paths,i=this._parsedPaths,r=this._bindings,s=r.length;let a,o=t.length,l=this.nCachedObjects_;for(let c=0,u=arguments.length;c!==u;++c){const u=arguments[c],h=u.uuid;let d=e[h];if(void 0===d){d=o++,e[h]=d,t.push(u);for(let t=0,e=s;t!==e;++t)r[t].push(new Kc(u,n[t],i[t]))}else if(d<l){a=t[d];const o=--l,c=t[o];e[c.uuid]=d,t[d]=c,e[h]=o,t[o]=u;for(let t=0,e=s;t!==e;++t){const e=r[t],s=e[o];let a=e[d];e[d]=s,void 0===a&&(a=new Kc(u,n[t],i[t])),e[o]=a}}else t[d]!==a&&console.error("THREE.AnimationObjectGroup: Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes.")}this.nCachedObjects_=l}remove(){const t=this._objects,e=this._indicesByUUID,n=this._bindings,i=n.length;let r=this.nCachedObjects_;for(let s=0,a=arguments.length;s!==a;++s){const a=arguments[s],o=a.uuid,l=e[o];if(void 0!==l&&l>=r){const s=r++,c=t[s];e[c.uuid]=l,t[l]=c,e[o]=s,t[s]=a;for(let t=0,e=i;t!==e;++t){const e=n[t],i=e[s],r=e[l];e[l]=i,e[s]=r}}}this.nCachedObjects_=r}uncache(){const t=this._objects,e=this._indicesByUUID,n=this._bindings,i=n.length;let r=this.nCachedObjects_,s=t.length;for(let a=0,o=arguments.length;a!==o;++a){const o=arguments[a].uuid,l=e[o];if(void 0!==l)if(delete e[o],l<r){const a=--r,o=t[a],c=--s,u=t[c];e[o.uuid]=l,t[l]=o,e[u.uuid]=a,t[a]=u,t.pop();for(let t=0,e=i;t!==e;++t){const e=n[t],i=e[a],r=e[c];e[l]=i,e[a]=r,e.pop()}}else{const r=--s,a=t[r];r>0&&(e[a.uuid]=l),t[l]=a,t.pop();for(let t=0,e=i;t!==e;++t){const e=n[t];e[l]=e[r],e.pop()}}}this.nCachedObjects_=r}subscribe_(t,e){const n=this._bindingsIndicesByPath;let i=n[t];const r=this._bindings;if(void 0!==i)return r[i];const s=this._paths,a=this._parsedPaths,o=this._objects,l=o.length,c=this.nCachedObjects_,u=new Array(l);i=r.length,n[t]=i,s.push(t),a.push(e),r.push(u);for(let n=c,i=o.length;n!==i;++n){const i=o[n];u[n]=new Kc(i,t,e)}return u}unsubscribe_(t){const e=this._bindingsIndicesByPath,n=e[t];if(void 0!==n){const i=this._paths,r=this._parsedPaths,s=this._bindings,a=s.length-1,o=s[a];e[t[a]]=n,s[n]=o,s.pop(),r[n]=r[a],r.pop(),i[n]=i[a],i.pop()}}},e.AnimationUtils=Nl,e.ArcCurve=ro,e.ArrayCamera=ks,e.ArrowHelper=class extends rn{constructor(t=new ee(0,0,1),e=new ee(0,0,0),n=1,i=16776960,r=.2*n,s=.2*r){super(),this.type="ArrowHelper",void 0===Mu&&(Mu=new In,Mu.setAttribute("position",new Sn([0,0,0,0,1,0],3)),wu=new Ro(0,.5,1,5,1),wu.translate(0,-.5,0)),this.position.copy(e),this.line=new Ha(Mu,new Fa({color:i,toneMapped:!1})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new Jn(wu,new _n({color:i,toneMapped:!1})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(t),this.setLength(n,r,s)}setDirection(t){if(t.y>.99999)this.quaternion.set(0,0,0,1);else if(t.y<-.99999)this.quaternion.set(1,0,0,0);else{bu.set(t.z,0,-t.x).normalize();const e=Math.acos(t.y);this.quaternion.setFromAxisAngle(bu,e)}}setLength(t,e=.2*t,n=.2*e){this.line.scale.set(1,Math.max(1e-4,t-e),1),this.line.updateMatrix(),this.cone.scale.set(n,e,n),this.cone.position.y=t,this.cone.updateMatrix()}setColor(t){this.line.material.color.set(t),this.cone.material.color.set(t)}copy(t){return super.copy(t,!1),this.line.copy(t.line),this.cone.copy(t.cone),this}},e.Audio=kc,e.AudioAnalyser=class{constructor(t,e=2048){this.analyser=t.context.createAnalyser(),this.analyser.fftSize=e,this.data=new Uint8Array(this.analyser.frequencyBinCount),t.getOutput().connect(this.analyser)}getFrequencyData(){return this.analyser.getByteFrequencyData(this.data),this.data}getAverageFrequency(){let t=0;const e=this.getFrequencyData();for(let n=0;n<e.length;n++)t+=e[n];return t/e.length}},e.AudioContext=Lc,e.AudioListener=class extends rn{constructor(){super(),this.type="AudioListener",this.context=Lc.getContext(),this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null,this.timeDelta=0,this._clock=new Oc}getInput(){return this.gain}removeFilter(){return null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null),this}getFilter(){return this.filter}setFilter(t){return null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=t,this.gain.connect(this.filter),this.filter.connect(this.context.destination),this}getMasterVolume(){return this.gain.gain.value}setMasterVolume(t){return this.gain.gain.setTargetAtTime(t,this.context.currentTime,.01),this}updateMatrixWorld(t){super.updateMatrixWorld(t);const e=this.context.listener,n=this.up;if(this.timeDelta=this._clock.getDelta(),this.matrixWorld.decompose(Uc,Fc,Bc),zc.set(0,0,-1).applyQuaternion(Fc),e.positionX){const t=this.context.currentTime+this.timeDelta;e.positionX.linearRampToValueAtTime(Uc.x,t),e.positionY.linearRampToValueAtTime(Uc.y,t),e.positionZ.linearRampToValueAtTime(Uc.z,t),e.forwardX.linearRampToValueAtTime(zc.x,t),e.forwardY.linearRampToValueAtTime(zc.y,t),e.forwardZ.linearRampToValueAtTime(zc.z,t),e.upX.linearRampToValueAtTime(n.x,t),e.upY.linearRampToValueAtTime(n.y,t),e.upZ.linearRampToValueAtTime(n.z,t)}else e.setPosition(Uc.x,Uc.y,Uc.z),e.setOrientation(zc.x,zc.y,zc.z,n.x,n.y,n.z)}},e.AudioLoader=class extends Ql{constructor(t){super(t)}load(t,e,n,i){const r=this,s=new ec(this.manager);s.setResponseType("arraybuffer"),s.setPath(this.path),s.setRequestHeader(this.requestHeader),s.setWithCredentials(this.withCredentials),s.load(t,(function(n){try{const t=n.slice(0);Lc.getContext().decodeAudioData(t,(function(t){e(t)}))}catch(e){i?i(e):console.error(e),r.manager.itemError(t)}}),n,i)}},e.AxesHelper=class extends Xa{constructor(t=1){const e=[0,0,0,t,0,0,0,0,0,0,t,0,0,0,0,0,0,t],n=new In;n.setAttribute("position",new Sn(e,3)),n.setAttribute("color",new Sn([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1],3)),super(n,new Fa({vertexColors:!0,toneMapped:!1})),this.type="AxesHelper"}setColors(t,e,n){const i=new Ht,r=this.geometry.attributes.color.array;return i.set(t),i.toArray(r,0),i.toArray(r,3),i.set(e),i.toArray(r,6),i.toArray(r,9),i.set(n),i.toArray(r,12),i.toArray(r,15),this.geometry.attributes.color.needsUpdate=!0,this}dispose(){this.geometry.dispose(),this.material.dispose()}},e.BackSide=1,e.BasicDepthPacking=3200,e.BasicShadowMap=0,e.Bone=Ta,e.BooleanKeyframeTrack=Gl,e.Box2=class{constructor(t=new At(1/0,1/0),e=new At(-1/0,-1/0)){this.isBox2=!0,this.min=t,this.max=e}set(t,e){return this.min.copy(t),this.max.copy(e),this}setFromPoints(t){this.makeEmpty();for(let e=0,n=t.length;e<n;e++)this.expandByPoint(t[e]);return this}setFromCenterAndSize(t,e){const n=iu.copy(e).multiplyScalar(.5);return this.min.copy(t).sub(n),this.max.copy(t).add(n),this}clone(){return(new this.constructor).copy(this)}copy(t){return this.min.copy(t.min),this.max.copy(t.max),this}makeEmpty(){return this.min.x=this.min.y=1/0,this.max.x=this.max.y=-1/0,this}isEmpty(){return this.max.x<this.min.x||this.max.y<this.min.y}getCenter(t){return this.isEmpty()?t.set(0,0):t.addVectors(this.min,this.max).multiplyScalar(.5)}getSize(t){return this.isEmpty()?t.set(0,0):t.subVectors(this.max,this.min)}expandByPoint(t){return this.min.min(t),this.max.max(t),this}expandByVector(t){return this.min.sub(t),this.max.add(t),this}expandByScalar(t){return this.min.addScalar(-t),this.max.addScalar(t),this}containsPoint(t){return!(t.x<this.min.x||t.x>this.max.x||t.y<this.min.y||t.y>this.max.y)}containsBox(t){return this.min.x<=t.min.x&&t.max.x<=this.max.x&&this.min.y<=t.min.y&&t.max.y<=this.max.y}getParameter(t,e){return e.set((t.x-this.min.x)/(this.max.x-this.min.x),(t.y-this.min.y)/(this.max.y-this.min.y))}intersectsBox(t){return!(t.max.x<this.min.x||t.min.x>this.max.x||t.max.y<this.min.y||t.min.y>this.max.y)}clampPoint(t,e){return e.copy(t).clamp(this.min,this.max)}distanceToPoint(t){return iu.copy(t).clamp(this.min,this.max).sub(t).length()}intersect(t){return this.min.max(t.min),this.max.min(t.max),this}union(t){return this.min.min(t.min),this.max.max(t.max),this}translate(t){return this.min.add(t),this.max.add(t),this}equals(t){return t.min.equals(this.min)&&t.max.equals(this.max)}},e.Box3=re,e.Box3Helper=class extends Xa{constructor(t,e=16776960){const n=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),i=new In;i.setIndex(new bn(n,1)),i.setAttribute("position",new Sn([1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,-1,-1,1,-1,-1,-1,-1,1,-1,-1],3)),super(i,new Fa({color:e,toneMapped:!1})),this.box=t,this.type="Box3Helper",this.geometry.computeBoundingSphere()}updateMatrixWorld(t){const e=this.box;e.isEmpty()||(e.getCenter(this.position),e.getSize(this.scale),this.scale.multiplyScalar(.5),super.updateMatrixWorld(t))}},e.BoxBufferGeometry=$n,e.BoxGeometry=$n,e.BoxHelper=class extends Xa{constructor(t,e=16776960){const n=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),i=new Float32Array(24),r=new In;r.setIndex(new bn(n,1)),r.setAttribute("position",new bn(i,3)),super(r,new Fa({color:e,toneMapped:!1})),this.object=t,this.type="BoxHelper",this.matrixAutoUpdate=!1,this.update()}update(t){if(void 0!==t&&console.warn("THREE.BoxHelper: .update() has no longer arguments."),void 0!==this.object&&xu.setFromObject(this.object),xu.isEmpty())return;const e=xu.min,n=xu.max,i=this.geometry.attributes.position,r=i.array;r[0]=n.x,r[1]=n.y,r[2]=n.z,r[3]=e.x,r[4]=n.y,r[5]=n.z,r[6]=e.x,r[7]=e.y,r[8]=n.z,r[9]=n.x,r[10]=e.y,r[11]=n.z,r[12]=n.x,r[13]=n.y,r[14]=e.z,r[15]=e.x,r[16]=n.y,r[17]=e.z,r[18]=e.x,r[19]=e.y,r[20]=e.z,r[21]=n.x,r[22]=e.y,r[23]=e.z,i.needsUpdate=!0,this.geometry.computeBoundingSphere()}setFromObject(t){return this.object=t,this.update(),this}copy(t,e){return super.copy(t,e),this.object=t.object,this}},e.BufferAttribute=bn,e.BufferGeometry=In,e.BufferGeometryLoader=Ec,e.ByteType=1010,e.Cache=Jl,e.Camera=ii,e.CameraHelper=class extends Xa{constructor(t){const e=new In,n=new Fa({color:16777215,vertexColors:!0,toneMapped:!1}),i=[],r=[],s={};function a(t,e){o(t),o(e)}function o(t){i.push(0,0,0),r.push(0,0,0),void 0===s[t]&&(s[t]=[]),s[t].push(i.length/3-1)}a("n1","n2"),a("n2","n4"),a("n4","n3"),a("n3","n1"),a("f1","f2"),a("f2","f4"),a("f4","f3"),a("f3","f1"),a("n1","f1"),a("n2","f2"),a("n3","f3"),a("n4","f4"),a("p","n1"),a("p","n2"),a("p","n3"),a("p","n4"),a("u1","u2"),a("u2","u3"),a("u3","u1"),a("c","t"),a("p","c"),a("cn1","cn2"),a("cn3","cn4"),a("cf1","cf2"),a("cf3","cf4"),e.setAttribute("position",new Sn(i,3)),e.setAttribute("color",new Sn(r,3)),super(e,n),this.type="CameraHelper",this.camera=t,this.camera.updateProjectionMatrix&&this.camera.updateProjectionMatrix(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=s,this.update();const l=new Ht(16755200),c=new Ht(16711680),u=new Ht(43775),h=new Ht(16777215),d=new Ht(3355443);this.setColors(l,c,u,h,d)}setColors(t,e,n,i,r){const s=this.geometry.getAttribute("color");s.setXYZ(0,t.r,t.g,t.b),s.setXYZ(1,t.r,t.g,t.b),s.setXYZ(2,t.r,t.g,t.b),s.setXYZ(3,t.r,t.g,t.b),s.setXYZ(4,t.r,t.g,t.b),s.setXYZ(5,t.r,t.g,t.b),s.setXYZ(6,t.r,t.g,t.b),s.setXYZ(7,t.r,t.g,t.b),s.setXYZ(8,t.r,t.g,t.b),s.setXYZ(9,t.r,t.g,t.b),s.setXYZ(10,t.r,t.g,t.b),s.setXYZ(11,t.r,t.g,t.b),s.setXYZ(12,t.r,t.g,t.b),s.setXYZ(13,t.r,t.g,t.b),s.setXYZ(14,t.r,t.g,t.b),s.setXYZ(15,t.r,t.g,t.b),s.setXYZ(16,t.r,t.g,t.b),s.setXYZ(17,t.r,t.g,t.b),s.setXYZ(18,t.r,t.g,t.b),s.setXYZ(19,t.r,t.g,t.b),s.setXYZ(20,t.r,t.g,t.b),s.setXYZ(21,t.r,t.g,t.b),s.setXYZ(22,t.r,t.g,t.b),s.setXYZ(23,t.r,t.g,t.b),s.setXYZ(24,e.r,e.g,e.b),s.setXYZ(25,e.r,e.g,e.b),s.setXYZ(26,e.r,e.g,e.b),s.setXYZ(27,e.r,e.g,e.b),s.setXYZ(28,e.r,e.g,e.b),s.setXYZ(29,e.r,e.g,e.b),s.setXYZ(30,e.r,e.g,e.b),s.setXYZ(31,e.r,e.g,e.b),s.setXYZ(32,n.r,n.g,n.b),s.setXYZ(33,n.r,n.g,n.b),s.setXYZ(34,n.r,n.g,n.b),s.setXYZ(35,n.r,n.g,n.b),s.setXYZ(36,n.r,n.g,n.b),s.setXYZ(37,n.r,n.g,n.b),s.setXYZ(38,i.r,i.g,i.b),s.setXYZ(39,i.r,i.g,i.b),s.setXYZ(40,r.r,r.g,r.b),s.setXYZ(41,r.r,r.g,r.b),s.setXYZ(42,r.r,r.g,r.b),s.setXYZ(43,r.r,r.g,r.b),s.setXYZ(44,r.r,r.g,r.b),s.setXYZ(45,r.r,r.g,r.b),s.setXYZ(46,r.r,r.g,r.b),s.setXYZ(47,r.r,r.g,r.b),s.setXYZ(48,r.r,r.g,r.b),s.setXYZ(49,r.r,r.g,r.b),s.needsUpdate=!0}update(){const t=this.geometry,e=this.pointMap;_u.projectionMatrixInverse.copy(this.camera.projectionMatrixInverse),yu("c",e,t,_u,0,0,-1),yu("t",e,t,_u,0,0,1),yu("n1",e,t,_u,-1,-1,-1),yu("n2",e,t,_u,1,-1,-1),yu("n3",e,t,_u,-1,1,-1),yu("n4",e,t,_u,1,1,-1),yu("f1",e,t,_u,-1,-1,1),yu("f2",e,t,_u,1,-1,1),yu("f3",e,t,_u,-1,1,1),yu("f4",e,t,_u,1,1,1),yu("u1",e,t,_u,.7,1.1,-1),yu("u2",e,t,_u,-.7,1.1,-1),yu("u3",e,t,_u,0,2,-1),yu("cf1",e,t,_u,-1,0,1),yu("cf2",e,t,_u,1,0,1),yu("cf3",e,t,_u,0,-1,1),yu("cf4",e,t,_u,0,1,1),yu("cn1",e,t,_u,-1,0,-1),yu("cn2",e,t,_u,1,0,-1),yu("cn3",e,t,_u,0,-1,-1),yu("cn4",e,t,_u,0,1,-1),t.getAttribute("position").needsUpdate=!0}dispose(){this.geometry.dispose(),this.material.dispose()}},e.CanvasTexture=class extends Zt{constructor(t,e,n,i,r,s,a,o,l){super(t,e,n,i,r,s,a,o,l),this.isCanvasTexture=!0,this.needsUpdate=!0}},e.CapsuleBufferGeometry=To,e.CapsuleGeometry=To,e.CatmullRomCurve3=uo,e.CineonToneMapping=3,e.CircleBufferGeometry=Ao,e.CircleGeometry=Ao,e.ClampToEdgeWrapping=h,e.Clock=Oc,e.Color=Ht,e.ColorKeyframeTrack=Vl,e.ColorManagement=Ut,e.CompressedTexture=eo,e.CompressedTextureLoader=class extends Ql{constructor(t){super(t)}load(t,e,n,i){const r=this,s=[],a=new eo,o=new ec(this.manager);o.setPath(this.path),o.setResponseType("arraybuffer"),o.setRequestHeader(this.requestHeader),o.setWithCredentials(r.withCredentials);let l=0;function c(c){o.load(t[c],(function(t){const n=r.parse(t,!0);s[c]={width:n.width,height:n.height,format:n.format,mipmaps:n.mipmaps},l+=1,6===l&&(1===n.mipmapCount&&(a.minFilter=g),a.image=s,a.format=n.format,a.needsUpdate=!0,e&&e(a))}),n,i)}if(Array.isArray(t))for(let e=0,n=t.length;e<n;++e)c(e);else o.load(t,(function(t){const n=r.parse(t,!0);if(n.isCubemap){const t=n.mipmaps.length/n.mipmapCount;for(let e=0;e<t;e++){s[e]={mipmaps:[]};for(let t=0;t<n.mipmapCount;t++)s[e].mipmaps.push(n.mipmaps[e*n.mipmapCount+t]),s[e].format=n.format,s[e].width=n.width,s[e].height=n.height}a.image=s}else a.image.width=n.width,a.image.height=n.height,a.mipmaps=n.mipmaps;1===n.mipmapCount&&(a.minFilter=g),a.format=n.format,a.needsUpdate=!0,e&&e(a)}),n,i);return a}},e.ConeBufferGeometry=Co,e.ConeGeometry=Co,e.CubeCamera=ai,e.CubeReflectionMapping=s,e.CubeRefractionMapping=a,e.CubeTexture=oi,e.CubeTextureLoader=class extends Ql{constructor(t){super(t)}load(t,e,n,i){const r=new oi,s=new nc(this.manager);s.setCrossOrigin(this.crossOrigin),s.setPath(this.path);let a=0;function o(n){s.load(t[n],(function(t){r.images[n]=t,a++,6===a&&(r.needsUpdate=!0,e&&e(r))}),void 0,i)}for(let e=0;e<t.length;++e)o(e);return r}},e.CubeUVReflectionMapping=c,e.CubicBezierCurve=mo,e.CubicBezierCurve3=go,e.CubicInterpolant=Fl,e.CullFaceBack=1,e.CullFaceFront=2,e.CullFaceFrontBack=3,e.CullFaceNone=0,e.Curve=no,e.CurvePath=wo,e.CustomBlending=5,e.CustomToneMapping=5,e.CylinderBufferGeometry=Ro,e.CylinderGeometry=Ro,e.Cylindrical=class{constructor(t=1,e=0,n=0){return this.radius=t,this.theta=e,this.y=n,this}set(t,e,n){return this.radius=t,this.theta=e,this.y=n,this}copy(t){return this.radius=t.radius,this.theta=t.theta,this.y=t.y,this}setFromVector3(t){return this.setFromCartesianCoords(t.x,t.y,t.z)}setFromCartesianCoords(t,e,n){return this.radius=Math.sqrt(t*t+n*n),this.theta=Math.atan2(t,n),this.y=e,this}clone(){return(new this.constructor).copy(this)}},e.Data3DTexture=Qt,e.DataArrayTexture=$t,e.DataTexture=Aa,e.DataTexture2DArray=class extends $t{constructor(t,e,n,i){console.warn("THREE.DataTexture2DArray has been renamed to DataArrayTexture."),super(t,e,n,i)}},e.DataTexture3D=class extends Qt{constructor(t,e,n,i){console.warn("THREE.DataTexture3D has been renamed to Data3DTexture."),super(t,e,n,i)}},e.DataTextureLoader=class extends Ql{constructor(t){super(t)}load(t,e,n,i){const r=this,s=new Aa,a=new ec(this.manager);return a.setResponseType("arraybuffer"),a.setRequestHeader(this.requestHeader),a.setPath(this.path),a.setWithCredentials(r.withCredentials),a.load(t,(function(t){const n=r.parse(t);n&&(void 0!==n.image?s.image=n.image:void 0!==n.data&&(s.image.width=n.width,s.image.height=n.height,s.image.data=n.data),s.wrapS=void 0!==n.wrapS?n.wrapS:h,s.wrapT=void 0!==n.wrapT?n.wrapT:h,s.magFilter=void 0!==n.magFilter?n.magFilter:g,s.minFilter=void 0!==n.minFilter?n.minFilter:g,s.anisotropy=void 0!==n.anisotropy?n.anisotropy:1,void 0!==n.encoding&&(s.encoding=n.encoding),void 0!==n.flipY&&(s.flipY=n.flipY),void 0!==n.format&&(s.format=n.format),void 0!==n.type&&(s.type=n.type),void 0!==n.mipmaps&&(s.mipmaps=n.mipmaps,s.minFilter=_),1===n.mipmapCount&&(s.minFilter=g),void 0!==n.generateMipmaps&&(s.generateMipmaps=n.generateMipmaps),s.needsUpdate=!0,e&&e(s,n))}),n,i),s}},e.DataUtils=Iu,e.DecrementStencilOp=7683,e.DecrementWrapStencilOp=34056,e.DefaultLoadingManager=$l,e.DepthFormat=T,e.DepthStencilFormat=A,e.DepthTexture=Ws,e.DirectionalLight=vc,e.DirectionalLightHelper=class extends rn{constructor(t,e,n){super(),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=n,void 0===e&&(e=1);let i=new In;i.setAttribute("position",new Sn([-e,e,0,e,e,0,e,-e,0,-e,-e,0,-e,e,0],3));const r=new Fa({fog:!1,toneMapped:!1});this.lightPlane=new Ha(i,r),this.add(this.lightPlane),i=new In,i.setAttribute("position",new Sn([0,0,0,0,0,1],3)),this.targetLine=new Ha(i,r),this.add(this.targetLine),this.update()}dispose(){this.lightPlane.geometry.dispose(),this.lightPlane.material.dispose(),this.targetLine.geometry.dispose(),this.targetLine.material.dispose()}update(){fu.setFromMatrixPosition(this.light.matrixWorld),mu.setFromMatrixPosition(this.light.target.matrixWorld),gu.subVectors(mu,fu),this.lightPlane.lookAt(mu),void 0!==this.color?(this.lightPlane.material.color.set(this.color),this.targetLine.material.color.set(this.color)):(this.lightPlane.material.color.copy(this.light.color),this.targetLine.material.color.copy(this.light.color)),this.targetLine.lookAt(mu),this.targetLine.scale.z=gu.length()}},e.DiscreteInterpolant=zl,e.DodecahedronBufferGeometry=Po,e.DodecahedronGeometry=Po,e.DoubleSide=2,e.DstAlphaFactor=206,e.DstColorFactor=208,e.DynamicCopyUsage=35050,e.DynamicDrawUsage=35048,e.DynamicReadUsage=35049,e.EdgesGeometry=Uo,e.EllipseCurve=io,e.EqualDepth=4,e.EqualStencilFunc=514,e.EquirectangularReflectionMapping=o,e.EquirectangularRefractionMapping=l,e.Euler=Ve,e.EventDispatcher=ft,e.ExtrudeBufferGeometry=hl,e.ExtrudeGeometry=hl,e.FileLoader=ec,e.FlatShading=1,e.Float16BufferAttribute=class extends bn{constructor(t,e,n){super(new Uint16Array(t),e,n),this.isFloat16BufferAttribute=!0}},e.Float32BufferAttribute=Sn,e.Float64BufferAttribute=class extends bn{constructor(t,e,n){super(new Float64Array(t),e,n)}},e.FloatType=M,e.Fog=Js,e.FogExp2=Zs,e.Font=function(){console.error("THREE.Font has been moved to /examples/jsm/loaders/FontLoader.js")},e.FontLoader=function(){console.error("THREE.FontLoader has been moved to /examples/jsm/loaders/FontLoader.js")},e.FramebufferTexture=class extends Zt{constructor(t,e,n){super({width:t,height:e}),this.isFramebufferTexture=!0,this.format=n,this.magFilter=p,this.minFilter=p,this.generateMipmaps=!1,this.needsUpdate=!0}},e.FrontSide=0,e.Frustum=mi,e.GLBufferAttribute=class{constructor(t,e,n,i,r){this.isGLBufferAttribute=!0,this.buffer=t,this.type=e,this.itemSize=n,this.elementSize=i,this.count=r,this.version=0}set needsUpdate(t){!0===t&&this.version++}setBuffer(t){return this.buffer=t,this}setType(t,e){return this.type=t,this.elementSize=e,this}setItemSize(t){return this.itemSize=t,this}setCount(t){return this.count=t,this}},e.GLSL1="100",e.GLSL3=dt,e.GreaterDepth=6,e.GreaterEqualDepth=5,e.GreaterEqualStencilFunc=518,e.GreaterStencilFunc=516,e.GridHelper=class extends Xa{constructor(t=10,e=10,n=4473924,i=8947848){n=new Ht(n),i=new Ht(i);const r=e/2,s=t/e,a=t/2,o=[],l=[];for(let t=0,c=0,u=-a;t<=e;t++,u+=s){o.push(-a,0,u,a,0,u),o.push(u,0,-a,u,0,a);const e=t===r?n:i;e.toArray(l,c),c+=3,e.toArray(l,c),c+=3,e.toArray(l,c),c+=3,e.toArray(l,c),c+=3}const c=new In;c.setAttribute("position",new Sn(o,3)),c.setAttribute("color",new Sn(l,3)),super(c,new Fa({vertexColors:!0,toneMapped:!1})),this.type="GridHelper"}},e.Group=Gs,e.HalfFloatType=w,e.HemisphereLight=rc,e.HemisphereLightHelper=class extends rn{constructor(t,e,n){super(),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=n;const i=new fl(e);i.rotateY(.5*Math.PI),this.material=new _n({wireframe:!0,fog:!1,toneMapped:!1}),void 0===this.color&&(this.material.vertexColors=!0);const r=i.getAttribute("position"),s=new Float32Array(3*r.count);i.setAttribute("color",new bn(s,3)),this.add(new Jn(i,this.material)),this.update()}dispose(){this.children[0].geometry.dispose(),this.children[0].material.dispose()}update(){const t=this.children[0];if(void 0!==this.color)this.material.color.set(this.color);else{const e=t.geometry.getAttribute("color");du.copy(this.light.color),pu.copy(this.light.groundColor);for(let t=0,n=e.count;t<n;t++){const i=t<n/2?du:pu;e.setXYZ(t,i.r,i.g,i.b)}e.needsUpdate=!0}t.lookAt(hu.setFromMatrixPosition(this.light.matrixWorld).negate())}},e.HemisphereLightProbe=class extends bc{constructor(t,e,n=1){super(void 0,n),this.isHemisphereLightProbe=!0;const i=(new Ht).set(t),r=(new Ht).set(e),s=new ee(i.r,i.g,i.b),a=new ee(r.r,r.g,r.b),o=Math.sqrt(Math.PI),l=o*Math.sqrt(.75);this.sh.coefficients[0].copy(s).add(a).multiplyScalar(o),this.sh.coefficients[1].copy(s).sub(a).multiplyScalar(l)}},e.IcosahedronBufferGeometry=pl,e.IcosahedronGeometry=pl,e.ImageBitmapLoader=class extends Ql{constructor(t){super(t),this.isImageBitmapLoader=!0,"undefined"==typeof createImageBitmap&&console.warn("THREE.ImageBitmapLoader: createImageBitmap() not supported."),"undefined"==typeof fetch&&console.warn("THREE.ImageBitmapLoader: fetch() not supported."),this.options={premultiplyAlpha:"none"}}setOptions(t){return this.options=t,this}load(t,e,n,i){void 0===t&&(t=""),void 0!==this.path&&(t=this.path+t),t=this.manager.resolveURL(t);const r=this,s=Jl.get(t);if(void 0!==s)return r.manager.itemStart(t),setTimeout((function(){e&&e(s),r.manager.itemEnd(t)}),0),s;const a={};a.credentials="anonymous"===this.crossOrigin?"same-origin":"include",a.headers=this.requestHeader,fetch(t,a).then((function(t){return t.blob()})).then((function(t){return createImageBitmap(t,Object.assign(r.options,{colorSpaceConversion:"none"}))})).then((function(n){Jl.add(t,n),e&&e(n),r.manager.itemEnd(t)})).catch((function(e){i&&i(e),r.manager.itemError(t),r.manager.itemEnd(t)})),r.manager.itemStart(t)}},e.ImageLoader=nc,e.ImageUtils=jt,e.ImmediateRenderObject=function(){console.error("THREE.ImmediateRenderObject has been removed.")},e.IncrementStencilOp=7682,e.IncrementWrapStencilOp=34055,e.InstancedBufferAttribute=Pa,e.InstancedBufferGeometry=Sc,e.InstancedInterleavedBuffer=class extends $s{constructor(t,e,n=1){super(t,e),this.isInstancedInterleavedBuffer=!0,this.meshPerAttribute=n}copy(t){return super.copy(t),this.meshPerAttribute=t.meshPerAttribute,this}clone(t){const e=super.clone(t);return e.meshPerAttribute=this.meshPerAttribute,e}toJSON(t){const e=super.toJSON(t);return e.isInstancedInterleavedBuffer=!0,e.meshPerAttribute=this.meshPerAttribute,e}},e.InstancedMesh=Ua,e.Int16BufferAttribute=class extends bn{constructor(t,e,n){super(new Int16Array(t),e,n)}},e.Int32BufferAttribute=class extends bn{constructor(t,e,n){super(new Int32Array(t),e,n)}},e.Int8BufferAttribute=class extends bn{constructor(t,e,n){super(new Int8Array(t),e,n)}},e.IntType=1013,e.InterleavedBuffer=$s,e.InterleavedBufferAttribute=ta,e.Interpolant=Ul,e.InterpolateDiscrete=Q,e.InterpolateLinear=tt,e.InterpolateSmooth=et,e.InvertStencilOp=5386,e.KeepStencilOp=ut,e.KeyframeTrack=kl,e.LOD=ya,e.LatheBufferGeometry=Eo,e.LatheGeometry=Eo,e.Layers=He,e.LessDepth=2,e.LessEqualDepth=3,e.LessEqualStencilFunc=515,e.LessStencilFunc=513,e.Light=ic,e.LightProbe=bc,e.Line=Ha,e.Line3=class{constructor(t=new ee,e=new ee){this.start=t,this.end=e}set(t,e){return this.start.copy(t),this.end.copy(e),this}copy(t){return this.start.copy(t.start),this.end.copy(t.end),this}getCenter(t){return t.addVectors(this.start,this.end).multiplyScalar(.5)}delta(t){return t.subVectors(this.end,this.start)}distanceSq(){return this.start.distanceToSquared(this.end)}distance(){return this.start.distanceTo(this.end)}at(t,e){return this.delta(e).multiplyScalar(t).add(this.start)}closestPointToPointParameter(t,e){ru.subVectors(t,this.start),su.subVectors(this.end,this.start);const n=su.dot(su);let i=su.dot(ru)/n;return e&&(i=xt(i,0,1)),i}closestPointToPoint(t,e,n){const i=this.closestPointToPointParameter(t,e);return this.delta(n).multiplyScalar(i).add(this.start)}applyMatrix4(t){return this.start.applyMatrix4(t),this.end.applyMatrix4(t),this}equals(t){return t.start.equals(this.start)&&t.end.equals(this.end)}clone(){return(new this.constructor).copy(this)}},e.LineBasicMaterial=Fa,e.LineCurve=vo,e.LineCurve3=_o,e.LineDashedMaterial=Ol,e.LineLoop=Ya,e.LineSegments=Xa,e.LinearEncoding=at,e.LinearFilter=g,e.LinearInterpolant=Bl,e.LinearMipMapLinearFilter=1008,e.LinearMipMapNearestFilter=1007,e.LinearMipmapLinearFilter=_,e.LinearMipmapNearestFilter=v,e.LinearSRGBColorSpace=ct,e.LinearToneMapping=1,e.Loader=Ql,e.LoaderUtils=wc,e.LoadingManager=Kl,e.LoopOnce=2200,e.LoopPingPong=2202,e.LoopRepeat=2201,e.LuminanceAlphaFormat=1025,e.LuminanceFormat=1024,e.MOUSE={LEFT:0,MIDDLE:1,RIGHT:2,ROTATE:0,DOLLY:1,PAN:2},e.Material=vn,e.MaterialLoader=Mc,e.MathUtils=Tt,e.Matrix3=Rt,e.Matrix4=Ie,e.MaxEquation=104,e.Mesh=Jn,e.MeshBasicMaterial=_n,e.MeshDepthMaterial=Os,e.MeshDistanceMaterial=Ns,e.MeshLambertMaterial=Il,e.MeshMatcapMaterial=Dl,e.MeshNormalMaterial=Pl,e.MeshPhongMaterial=Cl,e.MeshPhysicalMaterial=Rl,e.MeshStandardMaterial=Al,e.MeshToonMaterial=Ll,e.MinEquation=103,e.MirroredRepeatWrapping=d,e.MixOperation=1,e.MultiplyBlending=4,e.MultiplyOperation=0,e.NearestFilter=p,e.NearestMipMapLinearFilter=1005,e.NearestMipMapNearestFilter=1004,e.NearestMipmapLinearFilter=m,e.NearestMipmapNearestFilter=f,e.NeverDepth=0,e.NeverStencilFunc=512,e.NoBlending=0,e.NoColorSpace="",e.NoToneMapping=0,e.NormalAnimationBlendMode=2500,e.NormalBlending=1,e.NotEqualDepth=7,e.NotEqualStencilFunc=517,e.NumberKeyframeTrack=Hl,e.Object3D=rn,e.ObjectLoader=class extends Ql{constructor(t){super(t)}load(t,e,n,i){const r=this,s=""===this.path?wc.extractUrlBase(t):this.path;this.resourcePath=this.resourcePath||s;const a=new ec(this.manager);a.setPath(this.path),a.setRequestHeader(this.requestHeader),a.setWithCredentials(this.withCredentials),a.load(t,(function(n){let s=null;try{s=JSON.parse(n)}catch(e){return void 0!==i&&i(e),void console.error("THREE:ObjectLoader: Can't parse "+t+".",e.message)}const a=s.metadata;void 0!==a&&void 0!==a.type&&"geometry"!==a.type.toLowerCase()?r.parse(s,e):console.error("THREE.ObjectLoader: Can't load "+t)}),n,i)}async loadAsync(t,e){const n=""===this.path?wc.extractUrlBase(t):this.path;this.resourcePath=this.resourcePath||n;const i=new ec(this.manager);i.setPath(this.path),i.setRequestHeader(this.requestHeader),i.setWithCredentials(this.withCredentials);const r=await i.loadAsync(t,e),s=JSON.parse(r),a=s.metadata;if(void 0===a||void 0===a.type||"geometry"===a.type.toLowerCase())throw new Error("THREE.ObjectLoader: Can't load "+t);return await this.parseAsync(s)}parse(t,e){const n=this.parseAnimations(t.animations),i=this.parseShapes(t.shapes),r=this.parseGeometries(t.geometries,i),s=this.parseImages(t.images,(function(){void 0!==e&&e(l)})),a=this.parseTextures(t.textures,s),o=this.parseMaterials(t.materials,a),l=this.parseObject(t.object,r,o,a,n),c=this.parseSkeletons(t.skeletons,l);if(this.bindSkeletons(l,c),void 0!==e){let t=!1;for(const e in s)if(s[e].data instanceof HTMLImageElement){t=!0;break}!1===t&&e(l)}return l}async parseAsync(t){const e=this.parseAnimations(t.animations),n=this.parseShapes(t.shapes),i=this.parseGeometries(t.geometries,n),r=await this.parseImagesAsync(t.images),s=this.parseTextures(t.textures,r),a=this.parseMaterials(t.materials,s),o=this.parseObject(t.object,i,a,s,e),l=this.parseSkeletons(t.skeletons,o);return this.bindSkeletons(o,l),o}parseShapes(t){const e={};if(void 0!==t)for(let n=0,i=t.length;n<i;n++){const i=(new Fo).fromJSON(t[n]);e[i.uuid]=i}return e}parseSkeletons(t,e){const n={},i={};if(e.traverse((function(t){t.isBone&&(i[t.uuid]=t)})),void 0!==t)for(let e=0,r=t.length;e<r;e++){const r=(new La).fromJSON(t[e],i);n[r.uuid]=r}return n}parseGeometries(t,e){const n={};if(void 0!==t){const i=new Ec;for(let r=0,s=t.length;r<s;r++){let s;const a=t[r];switch(a.type){case"BufferGeometry":case"InstancedBufferGeometry":s=i.parse(a);break;case"Geometry":console.error("THREE.ObjectLoader: The legacy Geometry type is no longer supported.");break;default:a.type in Sl?s=Sl[a.type].fromJSON(a,e):console.warn(`THREE.ObjectLoader: Unsupported geometry type "${a.type}"`)}s.uuid=a.uuid,void 0!==a.name&&(s.name=a.name),!0===s.isBufferGeometry&&void 0!==a.userData&&(s.userData=a.userData),n[a.uuid]=s}}return n}parseMaterials(t,e){const n={},i={};if(void 0!==t){const r=new Mc;r.setTextures(e);for(let e=0,s=t.length;e<s;e++){const s=t[e];if("MultiMaterial"===s.type){const t=[];for(let e=0;e<s.materials.length;e++){const i=s.materials[e];void 0===n[i.uuid]&&(n[i.uuid]=r.parse(i)),t.push(n[i.uuid])}i[s.uuid]=t}else void 0===n[s.uuid]&&(n[s.uuid]=r.parse(s)),i[s.uuid]=n[s.uuid]}}return i}parseAnimations(t){const e={};if(void 0!==t)for(let n=0;n<t.length;n++){const i=t[n],r=ql.parse(i);e[r.uuid]=r}return e}parseImages(t,e){const n=this,i={};let r;function s(t){if("string"==typeof t){const e=t;return function(t){return n.manager.itemStart(t),r.load(t,(function(){n.manager.itemEnd(t)}),void 0,(function(){n.manager.itemError(t),n.manager.itemEnd(t)}))}(/^(\/\/)|([a-z]+:(\/\/)?)/i.test(e)?e:n.resourcePath+e)}return t.data?{data:Pt(t.type,t.data),width:t.width,height:t.height}:null}if(void 0!==t&&t.length>0){const n=new Kl(e);r=new nc(n),r.setCrossOrigin(this.crossOrigin);for(let e=0,n=t.length;e<n;e++){const n=t[e],r=n.url;if(Array.isArray(r)){const t=[];for(let e=0,n=r.length;e<n;e++){const n=s(r[e]);null!==n&&(n instanceof HTMLImageElement?t.push(n):t.push(new Aa(n.data,n.width,n.height)))}i[n.uuid]=new Xt(t)}else{const t=s(n.url);i[n.uuid]=new Xt(t)}}}return i}async parseImagesAsync(t){const e=this,n={};let i;async function r(t){if("string"==typeof t){const n=t,r=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(n)?n:e.resourcePath+n;return await i.loadAsync(r)}return t.data?{data:Pt(t.type,t.data),width:t.width,height:t.height}:null}if(void 0!==t&&t.length>0){i=new nc(this.manager),i.setCrossOrigin(this.crossOrigin);for(let e=0,i=t.length;e<i;e++){const i=t[e],s=i.url;if(Array.isArray(s)){const t=[];for(let e=0,n=s.length;e<n;e++){const n=s[e],i=await r(n);null!==i&&(i instanceof HTMLImageElement?t.push(i):t.push(new Aa(i.data,i.width,i.height)))}n[i.uuid]=new Xt(t)}else{const t=await r(i.url);n[i.uuid]=new Xt(t)}}}return n}parseTextures(t,e){function n(t,e){return"number"==typeof t?t:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",t),e[t])}const i={};if(void 0!==t)for(let r=0,s=t.length;r<s;r++){const s=t[r];void 0===s.image&&console.warn('THREE.ObjectLoader: No "image" specified for',s.uuid),void 0===e[s.image]&&console.warn("THREE.ObjectLoader: Undefined image",s.image);const a=e[s.image],o=a.data;let l;Array.isArray(o)?(l=new oi,6===o.length&&(l.needsUpdate=!0)):(l=o&&o.data?new Aa:new Zt,o&&(l.needsUpdate=!0)),l.source=a,l.uuid=s.uuid,void 0!==s.name&&(l.name=s.name),void 0!==s.mapping&&(l.mapping=n(s.mapping,Tc)),void 0!==s.offset&&l.offset.fromArray(s.offset),void 0!==s.repeat&&l.repeat.fromArray(s.repeat),void 0!==s.center&&l.center.fromArray(s.center),void 0!==s.rotation&&(l.rotation=s.rotation),void 0!==s.wrap&&(l.wrapS=n(s.wrap[0],Ac),l.wrapT=n(s.wrap[1],Ac)),void 0!==s.format&&(l.format=s.format),void 0!==s.type&&(l.type=s.type),void 0!==s.encoding&&(l.encoding=s.encoding),void 0!==s.minFilter&&(l.minFilter=n(s.minFilter,Rc)),void 0!==s.magFilter&&(l.magFilter=n(s.magFilter,Rc)),void 0!==s.anisotropy&&(l.anisotropy=s.anisotropy),void 0!==s.flipY&&(l.flipY=s.flipY),void 0!==s.premultiplyAlpha&&(l.premultiplyAlpha=s.premultiplyAlpha),void 0!==s.unpackAlignment&&(l.unpackAlignment=s.unpackAlignment),void 0!==s.userData&&(l.userData=s.userData),i[s.uuid]=l}return i}parseObject(t,e,n,i,r){let s,a,o;function l(t){return void 0===e[t]&&console.warn("THREE.ObjectLoader: Undefined geometry",t),e[t]}function c(t){if(void 0!==t){if(Array.isArray(t)){const e=[];for(let i=0,r=t.length;i<r;i++){const r=t[i];void 0===n[r]&&console.warn("THREE.ObjectLoader: Undefined material",r),e.push(n[r])}return e}return void 0===n[t]&&console.warn("THREE.ObjectLoader: Undefined material",t),n[t]}}function u(t){return void 0===i[t]&&console.warn("THREE.ObjectLoader: Undefined texture",t),i[t]}switch(t.type){case"Scene":s=new Ks,void 0!==t.background&&(Number.isInteger(t.background)?s.background=new Ht(t.background):s.background=u(t.background)),void 0!==t.environment&&(s.environment=u(t.environment)),void 0!==t.fog&&("Fog"===t.fog.type?s.fog=new Js(t.fog.color,t.fog.near,t.fog.far):"FogExp2"===t.fog.type&&(s.fog=new Zs(t.fog.color,t.fog.density)));break;case"PerspectiveCamera":s=new ri(t.fov,t.aspect,t.near,t.far),void 0!==t.focus&&(s.focus=t.focus),void 0!==t.zoom&&(s.zoom=t.zoom),void 0!==t.filmGauge&&(s.filmGauge=t.filmGauge),void 0!==t.filmOffset&&(s.filmOffset=t.filmOffset),void 0!==t.view&&(s.view=Object.assign({},t.view));break;case"OrthographicCamera":s=new Ri(t.left,t.right,t.top,t.bottom,t.near,t.far),void 0!==t.zoom&&(s.zoom=t.zoom),void 0!==t.view&&(s.view=Object.assign({},t.view));break;case"AmbientLight":s=new _c(t.color,t.intensity);break;case"DirectionalLight":s=new vc(t.color,t.intensity);break;case"PointLight":s=new mc(t.color,t.intensity,t.distance,t.decay);break;case"RectAreaLight":s=new yc(t.color,t.intensity,t.width,t.height);break;case"SpotLight":s=new uc(t.color,t.intensity,t.distance,t.angle,t.penumbra,t.decay);break;case"HemisphereLight":s=new rc(t.color,t.groundColor,t.intensity);break;case"LightProbe":s=(new bc).fromJSON(t);break;case"SkinnedMesh":a=l(t.geometry),o=c(t.material),s=new Ea(a,o),void 0!==t.bindMode&&(s.bindMode=t.bindMode),void 0!==t.bindMatrix&&s.bindMatrix.fromArray(t.bindMatrix),void 0!==t.skeleton&&(s.skeleton=t.skeleton);break;case"Mesh":a=l(t.geometry),o=c(t.material),s=new Jn(a,o);break;case"InstancedMesh":a=l(t.geometry),o=c(t.material);const e=t.count,n=t.instanceMatrix,i=t.instanceColor;s=new Ua(a,o,e),s.instanceMatrix=new Pa(new Float32Array(n.array),16),void 0!==i&&(s.instanceColor=new Pa(new Float32Array(i.array),i.itemSize));break;case"LOD":s=new ya;break;case"Line":s=new Ha(l(t.geometry),c(t.material));break;case"LineLoop":s=new Ya(l(t.geometry),c(t.material));break;case"LineSegments":s=new Xa(l(t.geometry),c(t.material));break;case"PointCloud":case"Points":s=new Qa(l(t.geometry),c(t.material));break;case"Sprite":s=new ma(c(t.material));break;case"Group":s=new Gs;break;case"Bone":s=new Ta;break;default:s=new rn}if(s.uuid=t.uuid,void 0!==t.name&&(s.name=t.name),void 0!==t.matrix?(s.matrix.fromArray(t.matrix),void 0!==t.matrixAutoUpdate&&(s.matrixAutoUpdate=t.matrixAutoUpdate),s.matrixAutoUpdate&&s.matrix.decompose(s.position,s.quaternion,s.scale)):(void 0!==t.position&&s.position.fromArray(t.position),void 0!==t.rotation&&s.rotation.fromArray(t.rotation),void 0!==t.quaternion&&s.quaternion.fromArray(t.quaternion),void 0!==t.scale&&s.scale.fromArray(t.scale)),void 0!==t.castShadow&&(s.castShadow=t.castShadow),void 0!==t.receiveShadow&&(s.receiveShadow=t.receiveShadow),t.shadow&&(void 0!==t.shadow.bias&&(s.shadow.bias=t.shadow.bias),void 0!==t.shadow.normalBias&&(s.shadow.normalBias=t.shadow.normalBias),void 0!==t.shadow.radius&&(s.shadow.radius=t.shadow.radius),void 0!==t.shadow.mapSize&&s.shadow.mapSize.fromArray(t.shadow.mapSize),void 0!==t.shadow.camera&&(s.shadow.camera=this.parseObject(t.shadow.camera))),void 0!==t.visible&&(s.visible=t.visible),void 0!==t.frustumCulled&&(s.frustumCulled=t.frustumCulled),void 0!==t.renderOrder&&(s.renderOrder=t.renderOrder),void 0!==t.userData&&(s.userData=t.userData),void 0!==t.layers&&(s.layers.mask=t.layers),void 0!==t.children){const a=t.children;for(let t=0;t<a.length;t++)s.add(this.parseObject(a[t],e,n,i,r))}if(void 0!==t.animations){const e=t.animations;for(let t=0;t<e.length;t++){const n=e[t];s.animations.push(r[n])}}if("LOD"===t.type){void 0!==t.autoUpdate&&(s.autoUpdate=t.autoUpdate);const e=t.levels;for(let t=0;t<e.length;t++){const n=e[t],i=s.getObjectByProperty("uuid",n.object);void 0!==i&&s.addLevel(i,n.distance)}}return s}bindSkeletons(t,e){0!==Object.keys(e).length&&t.traverse((function(t){if(!0===t.isSkinnedMesh&&void 0!==t.skeleton){const n=e[t.skeleton];void 0===n?console.warn("THREE.ObjectLoader: No skeleton found with UUID:",t.skeleton):t.bind(n,t.bindMatrix)}}))}setTexturePath(t){return console.warn("THREE.ObjectLoader: .setTexturePath() has been renamed to .setResourcePath()."),this.setResourcePath(t)}},e.ObjectSpaceNormalMap=1,e.OctahedronBufferGeometry=fl,e.OctahedronGeometry=fl,e.OneFactor=201,e.OneMinusDstAlphaFactor=207,e.OneMinusDstColorFactor=209,e.OneMinusSrcAlphaFactor=205,e.OneMinusSrcColorFactor=203,e.OrthographicCamera=Ri,e.PCFShadowMap=1,e.PCFSoftShadowMap=2,e.PMREMGenerator=Ui,e.ParametricGeometry=class extends In{constructor(){console.error("THREE.ParametricGeometry has been moved to /examples/jsm/geometries/ParametricGeometry.js"),super()}},e.Path=So,e.PerspectiveCamera=ri,e.Plane=di,e.PlaneBufferGeometry=_i,e.PlaneGeometry=_i,e.PlaneHelper=class extends Ha{constructor(t,e=1,n=16776960){const i=n,r=new In;r.setAttribute("position",new Sn([1,-1,1,-1,1,1,-1,-1,1,1,1,1,-1,1,1,-1,-1,1,1,-1,1,1,1,1,0,0,1,0,0,0],3)),r.computeBoundingSphere(),super(r,new Fa({color:i,toneMapped:!1})),this.type="PlaneHelper",this.plane=t,this.size=e;const s=new In;s.setAttribute("position",new Sn([1,1,1,-1,1,1,-1,-1,1,1,1,1,-1,-1,1,1,-1,1],3)),s.computeBoundingSphere(),this.add(new Jn(s,new _n({color:i,opacity:.2,transparent:!0,depthWrite:!1,toneMapped:!1})))}updateMatrixWorld(t){let e=-this.plane.constant;Math.abs(e)<1e-8&&(e=1e-8),this.scale.set(.5*this.size,.5*this.size,e),this.children[0].material.side=e<0?1:0,this.lookAt(this.plane.normal),super.updateMatrixWorld(t)}},e.PointLight=mc,e.PointLightHelper=class extends Jn{constructor(t,e,n){super(new vl(e,4,2),new _n({wireframe:!0,fog:!1,toneMapped:!1})),this.light=t,this.light.updateMatrixWorld(),this.color=n,this.type="PointLightHelper",this.matrix=this.light.matrixWorld,this.matrixAutoUpdate=!1,this.update()}dispose(){this.geometry.dispose(),this.material.dispose()}update(){void 0!==this.color?this.material.color.set(this.color):this.material.color.copy(this.light.color)}},e.Points=Qa,e.PointsMaterial=qa,e.PolarGridHelper=class extends Xa{constructor(t=10,e=16,n=8,i=64,r=4473924,s=8947848){r=new Ht(r),s=new Ht(s);const a=[],o=[];for(let n=0;n<=e;n++){const i=n/e*(2*Math.PI),l=Math.sin(i)*t,c=Math.cos(i)*t;a.push(0,0,0),a.push(l,0,c);const u=1&n?r:s;o.push(u.r,u.g,u.b),o.push(u.r,u.g,u.b)}for(let e=0;e<=n;e++){const l=1&e?r:s,c=t-t/n*e;for(let t=0;t<i;t++){let e=t/i*(2*Math.PI),n=Math.sin(e)*c,r=Math.cos(e)*c;a.push(n,0,r),o.push(l.r,l.g,l.b),e=(t+1)/i*(2*Math.PI),n=Math.sin(e)*c,r=Math.cos(e)*c,a.push(n,0,r),o.push(l.r,l.g,l.b)}}const l=new In;l.setAttribute("position",new Sn(a,3)),l.setAttribute("color",new Sn(o,3)),super(l,new Fa({vertexColors:!0,toneMapped:!1})),this.type="PolarGridHelper"}},e.PolyhedronBufferGeometry=Lo,e.PolyhedronGeometry=Lo,e.PositionalAudio=class extends kc{constructor(t){super(t),this.panner=this.context.createPanner(),this.panner.panningModel="HRTF",this.panner.connect(this.gain)}disconnect(){super.disconnect(),this.panner.disconnect(this.gain)}getOutput(){return this.panner}getRefDistance(){return this.panner.refDistance}setRefDistance(t){return this.panner.refDistance=t,this}getRolloffFactor(){return this.panner.rolloffFactor}setRolloffFactor(t){return this.panner.rolloffFactor=t,this}getDistanceModel(){return this.panner.distanceModel}setDistanceModel(t){return this.panner.distanceModel=t,this}getMaxDistance(){return this.panner.maxDistance}setMaxDistance(t){return this.panner.maxDistance=t,this}setDirectionalCone(t,e,n){return this.panner.coneInnerAngle=t,this.panner.coneOuterAngle=e,this.panner.coneOuterGain=n,this}updateMatrixWorld(t){if(super.updateMatrixWorld(t),!0===this.hasPlaybackControl&&!1===this.isPlaying)return;this.matrixWorld.decompose(Gc,Vc,Hc),Wc.set(0,0,1).applyQuaternion(Vc);const e=this.panner;if(e.positionX){const t=this.context.currentTime+this.listener.timeDelta;e.positionX.linearRampToValueAtTime(Gc.x,t),e.positionY.linearRampToValueAtTime(Gc.y,t),e.positionZ.linearRampToValueAtTime(Gc.z,t),e.orientationX.linearRampToValueAtTime(Wc.x,t),e.orientationY.linearRampToValueAtTime(Wc.y,t),e.orientationZ.linearRampToValueAtTime(Wc.z,t)}else e.setPosition(Gc.x,Gc.y,Gc.z),e.setOrientation(Wc.x,Wc.y,Wc.z)}},e.PropertyBinding=Kc,e.PropertyMixer=jc,e.QuadraticBezierCurve=yo,e.QuadraticBezierCurve3=xo,e.Quaternion=te,e.QuaternionKeyframeTrack=jl,e.QuaternionLinearInterpolant=Wl,e.REVISION=n,e.RGBADepthPacking=3201,e.RGBAFormat=E,e.RGBAIntegerFormat=1033,e.RGBA_ASTC_10x10_Format=Z,e.RGBA_ASTC_10x5_Format=X,e.RGBA_ASTC_10x6_Format=Y,e.RGBA_ASTC_10x8_Format=q,e.RGBA_ASTC_12x10_Format=J,e.RGBA_ASTC_12x12_Format=K,e.RGBA_ASTC_4x4_Format=B,e.RGBA_ASTC_5x4_Format=z,e.RGBA_ASTC_5x5_Format=k,e.RGBA_ASTC_6x5_Format=G,e.RGBA_ASTC_6x6_Format=V,e.RGBA_ASTC_8x5_Format=H,e.RGBA_ASTC_8x6_Format=W,e.RGBA_ASTC_8x8_Format=j,e.RGBA_BPTC_Format=$,e.RGBA_ETC2_EAC_Format=F,e.RGBA_PVRTC_2BPPV1_Format=N,e.RGBA_PVRTC_4BPPV1_Format=O,e.RGBA_S3TC_DXT1_Format=C,e.RGBA_S3TC_DXT3_Format=L,e.RGBA_S3TC_DXT5_Format=P,e.RGBFormat=1022,e.RGB_ETC1_Format=36196,e.RGB_ETC2_Format=U,e.RGB_PVRTC_2BPPV1_Format=D,e.RGB_PVRTC_4BPPV1_Format=I,e.RGB_S3TC_DXT1_Format=R,e.RGFormat=1030,e.RGIntegerFormat=1031,e.RawShaderMaterial=Tl,e.Ray=Pe,e.Raycaster=class{constructor(t,e,n=0,i=1/0){this.ray=new Pe(t,e),this.near=n,this.far=i,this.camera=null,this.layers=new He,this.params={Mesh:{},Line:{threshold:1},LOD:{},Points:{threshold:1},Sprite:{}}}set(t,e){this.ray.set(t,e)}setFromCamera(t,e){e.isPerspectiveCamera?(this.ray.origin.setFromMatrixPosition(e.matrixWorld),this.ray.direction.set(t.x,t.y,.5).unproject(e).sub(this.ray.origin).normalize(),this.camera=e):e.isOrthographicCamera?(this.ray.origin.set(t.x,t.y,(e.near+e.far)/(e.near-e.far)).unproject(e),this.ray.direction.set(0,0,-1).transformDirection(e.matrixWorld),this.camera=e):console.error("THREE.Raycaster: Unsupported camera type: "+e.type)}intersectObject(t,e=!0,n=[]){return nu(t,this,n,e),n.sort(eu),n}intersectObjects(t,e=!0,n=[]){for(let i=0,r=t.length;i<r;i++)nu(t[i],this,n,e);return n.sort(eu),n}},e.RectAreaLight=yc,e.RedFormat=1028,e.RedIntegerFormat=1029,e.ReinhardToneMapping=2,e.RepeatWrapping=u,e.ReplaceStencilOp=7681,e.ReverseSubtractEquation=102,e.RingBufferGeometry=ml,e.RingGeometry=ml,e.SRGBColorSpace=lt,e.Scene=Ks,e.ShaderChunk=yi,e.ShaderLib=bi,e.ShaderMaterial=ni,e.ShadowMaterial=El,e.Shape=Fo,e.ShapeBufferGeometry=gl,e.ShapeGeometry=gl,e.ShapePath=class{constructor(){this.type="ShapePath",this.color=new Ht,this.subPaths=[],this.currentPath=null}moveTo(t,e){return this.currentPath=new So,this.subPaths.push(this.currentPath),this.currentPath.moveTo(t,e),this}lineTo(t,e){return this.currentPath.lineTo(t,e),this}quadraticCurveTo(t,e,n,i){return this.currentPath.quadraticCurveTo(t,e,n,i),this}bezierCurveTo(t,e,n,i,r,s){return this.currentPath.bezierCurveTo(t,e,n,i,r,s),this}splineThru(t){return this.currentPath.splineThru(t),this}toShapes(t,e){function n(t){const e=[];for(let n=0,i=t.length;n<i;n++){const i=t[n],r=new Fo;r.curves=i.curves,e.push(r)}return e}function i(t,e){const n=e.length;let i=!1;for(let r=n-1,s=0;s<n;r=s++){let n=e[r],a=e[s],o=a.x-n.x,l=a.y-n.y;if(Math.abs(l)>Number.EPSILON){if(l<0&&(n=e[s],o=-o,a=e[r],l=-l),t.y<n.y||t.y>a.y)continue;if(t.y===n.y){if(t.x===n.x)return!0}else{const e=l*(t.x-n.x)-o*(t.y-n.y);if(0===e)return!0;if(e<0)continue;i=!i}}else{if(t.y!==n.y)continue;if(a.x<=t.x&&t.x<=n.x||n.x<=t.x&&t.x<=a.x)return!0}}return i}const r=ll.isClockWise,s=this.subPaths;if(0===s.length)return[];if(!0===e)return n(s);let a,o,l;const c=[];if(1===s.length)return o=s[0],l=new Fo,l.curves=o.curves,c.push(l),c;let u=!r(s[0].getPoints());u=t?!u:u;const h=[],d=[];let p,f,m=[],g=0;d[g]=void 0,m[g]=[];for(let e=0,n=s.length;e<n;e++)o=s[e],p=o.getPoints(),a=r(p),a=t?!a:a,a?(!u&&d[g]&&g++,d[g]={s:new Fo,p},d[g].s.curves=o.curves,u&&g++,m[g]=[]):m[g].push({h:o,p:p[0]});if(!d[0])return n(s);if(d.length>1){let t=!1,e=0;for(let t=0,e=d.length;t<e;t++)h[t]=[];for(let n=0,r=d.length;n<r;n++){const r=m[n];for(let s=0;s<r.length;s++){const a=r[s];let o=!0;for(let r=0;r<d.length;r++)i(a.p,d[r].p)&&(n!==r&&e++,o?(o=!1,h[r].push(a)):t=!0);o&&h[n].push(a)}}e>0&&!1===t&&(m=h)}for(let t=0,e=d.length;t<e;t++){l=d[t].s,c.push(l),f=m[t];for(let t=0,e=f.length;t<e;t++)l.holes.push(f[t].h)}return c}},e.ShapeUtils=ll,e.ShortType=1011,e.Skeleton=La,e.SkeletonHelper=class extends Xa{constructor(t){const e=uu(t),n=new In,i=[],r=[],s=new Ht(0,0,1),a=new Ht(0,1,0);for(let t=0;t<e.length;t++){const n=e[t];n.parent&&n.parent.isBone&&(i.push(0,0,0),i.push(0,0,0),r.push(s.r,s.g,s.b),r.push(a.r,a.g,a.b))}n.setAttribute("position",new Sn(i,3)),n.setAttribute("color",new Sn(r,3)),super(n,new Fa({vertexColors:!0,depthTest:!1,depthWrite:!1,toneMapped:!1,transparent:!0})),this.isSkeletonHelper=!0,this.type="SkeletonHelper",this.root=t,this.bones=e,this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1}updateMatrixWorld(t){const e=this.bones,n=this.geometry,i=n.getAttribute("position");cu.copy(this.root.matrixWorld).invert();for(let t=0,n=0;t<e.length;t++){const r=e[t];r.parent&&r.parent.isBone&&(lu.multiplyMatrices(cu,r.matrixWorld),ou.setFromMatrixPosition(lu),i.setXYZ(n,ou.x,ou.y,ou.z),lu.multiplyMatrices(cu,r.parent.matrixWorld),ou.setFromMatrixPosition(lu),i.setXYZ(n+1,ou.x,ou.y,ou.z),n+=2)}n.getAttribute("position").needsUpdate=!0,super.updateMatrixWorld(t)}},e.SkinnedMesh=Ea,e.SmoothShading=2,e.Source=Xt,e.Sphere=we,e.SphereBufferGeometry=vl,e.SphereGeometry=vl,e.Spherical=class{constructor(t=1,e=0,n=0){return this.radius=t,this.phi=e,this.theta=n,this}set(t,e,n){return this.radius=t,this.phi=e,this.theta=n,this}copy(t){return this.radius=t.radius,this.phi=t.phi,this.theta=t.theta,this}makeSafe(){const t=1e-6;return this.phi=Math.max(t,Math.min(Math.PI-t,this.phi)),this}setFromVector3(t){return this.setFromCartesianCoords(t.x,t.y,t.z)}setFromCartesianCoords(t,e,n){return this.radius=Math.sqrt(t*t+e*e+n*n),0===this.radius?(this.theta=0,this.phi=0):(this.theta=Math.atan2(t,n),this.phi=Math.acos(xt(e/this.radius,-1,1))),this}clone(){return(new this.constructor).copy(this)}},e.SphericalHarmonics3=xc,e.SplineCurve=bo,e.SpotLight=uc,e.SpotLightHelper=class extends rn{constructor(t,e){super(),this.light=t,this.light.updateMatrixWorld(),this.matrix=t.matrixWorld,this.matrixAutoUpdate=!1,this.color=e;const n=new In,i=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1];for(let t=0,e=1,n=32;t<n;t++,e++){const r=t/n*Math.PI*2,s=e/n*Math.PI*2;i.push(Math.cos(r),Math.sin(r),1,Math.cos(s),Math.sin(s),1)}n.setAttribute("position",new Sn(i,3));const r=new Fa({fog:!1,toneMapped:!1});this.cone=new Xa(n,r),this.add(this.cone),this.update()}dispose(){this.cone.geometry.dispose(),this.cone.material.dispose()}update(){this.light.updateMatrixWorld();const t=this.light.distance?this.light.distance:1e3,e=t*Math.tan(this.light.angle);this.cone.scale.set(e,e,t),au.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(au),void 0!==this.color?this.cone.material.color.set(this.color):this.cone.material.color.copy(this.light.color)}},e.Sprite=ma,e.SpriteMaterial=ea,e.SrcAlphaFactor=204,e.SrcAlphaSaturateFactor=210,e.SrcColorFactor=202,e.StaticCopyUsage=35046,e.StaticDrawUsage=ht,e.StaticReadUsage=35045,e.StereoCamera=class{constructor(){this.type="StereoCamera",this.aspect=1,this.eyeSep=.064,this.cameraL=new ri,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new ri,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1,this._cache={focus:null,fov:null,aspect:null,near:null,far:null,zoom:null,eyeSep:null}}update(t){const e=this._cache;if(e.focus!==t.focus||e.fov!==t.fov||e.aspect!==t.aspect*this.aspect||e.near!==t.near||e.far!==t.far||e.zoom!==t.zoom||e.eyeSep!==this.eyeSep){e.focus=t.focus,e.fov=t.fov,e.aspect=t.aspect*this.aspect,e.near=t.near,e.far=t.far,e.zoom=t.zoom,e.eyeSep=this.eyeSep,Dc.copy(t.projectionMatrix);const n=e.eyeSep/2,i=n*e.near/e.focus,r=e.near*Math.tan(vt*e.fov*.5)/e.zoom;let s,a;Ic.elements[12]=-n,Pc.elements[12]=n,s=-r*e.aspect+i,a=r*e.aspect+i,Dc.elements[0]=2*e.near/(a-s),Dc.elements[8]=(a+s)/(a-s),this.cameraL.projectionMatrix.copy(Dc),s=-r*e.aspect-i,a=r*e.aspect-i,Dc.elements[0]=2*e.near/(a-s),Dc.elements[8]=(a+s)/(a-s),this.cameraR.projectionMatrix.copy(Dc)}this.cameraL.matrixWorld.copy(t.matrixWorld).multiply(Ic),this.cameraR.matrixWorld.copy(t.matrixWorld).multiply(Pc)}},e.StreamCopyUsage=35042,e.StreamDrawUsage=35040,e.StreamReadUsage=35041,e.StringKeyframeTrack=Xl,e.SubtractEquation=101,e.SubtractiveBlending=3,e.TOUCH={ROTATE:0,PAN:1,DOLLY_PAN:2,DOLLY_ROTATE:3},e.TangentSpaceNormalMap=0,e.TetrahedronBufferGeometry=_l,e.TetrahedronGeometry=_l,e.TextGeometry=class extends In{constructor(){console.error("THREE.TextGeometry has been moved to /examples/jsm/geometries/TextGeometry.js"),super()}},e.Texture=Zt,e.TextureLoader=class extends Ql{constructor(t){super(t)}load(t,e,n,i){const r=new Zt,s=new nc(this.manager);return s.setCrossOrigin(this.crossOrigin),s.setPath(this.path),s.load(t,(function(t){r.image=t,r.needsUpdate=!0,void 0!==e&&e(r)}),n,i),r}},e.TorusBufferGeometry=yl,e.TorusGeometry=yl,e.TorusKnotBufferGeometry=xl,e.TorusKnotGeometry=xl,e.Triangle=mn,e.TriangleFanDrawMode=2,e.TriangleStripDrawMode=1,e.TrianglesDrawMode=0,e.TubeBufferGeometry=bl,e.TubeGeometry=bl,e.UVMapping=r,e.Uint16BufferAttribute=Mn,e.Uint32BufferAttribute=wn,e.Uint8BufferAttribute=class extends bn{constructor(t,e,n){super(new Uint8Array(t),e,n)}},e.Uint8ClampedBufferAttribute=class extends bn{constructor(t,e,n){super(new Uint8ClampedArray(t),e,n)}},e.Uniform=tu,e.UniformsLib=xi,e.UniformsUtils=ei,e.UnsignedByteType=y,e.UnsignedInt248Type=S,e.UnsignedIntType=b,e.UnsignedShort4444Type=1017,e.UnsignedShort5551Type=1018,e.UnsignedShortType=x,e.VSMShadowMap=3,e.Vector2=At,e.Vector3=ee,e.Vector4=Jt,e.VectorKeyframeTrack=Yl,e.VideoTexture=class extends Zt{constructor(t,e,n,i,r,s,a,o,l){super(t,e,n,i,r,s,a,o,l),this.isVideoTexture=!0,this.minFilter=void 0!==s?s:g,this.magFilter=void 0!==r?r:g,this.generateMipmaps=!1;const c=this;"requestVideoFrameCallback"in t&&t.requestVideoFrameCallback((function e(){c.needsUpdate=!0,t.requestVideoFrameCallback(e)}))}clone(){return new this.constructor(this.image).copy(this)}update(){const t=this.image;!1=="requestVideoFrameCallback"in t&&t.readyState>=t.HAVE_CURRENT_DATA&&(this.needsUpdate=!0)}},e.WebGL1Renderer=qs,e.WebGL3DRenderTarget=class extends Kt{constructor(t,e,n){super(t,e),this.isWebGL3DRenderTarget=!0,this.depth=n,this.texture=new Qt(null,t,e,n),this.texture.isRenderTargetTexture=!0}},e.WebGLArrayRenderTarget=class extends Kt{constructor(t,e,n){super(t,e),this.isWebGLArrayRenderTarget=!0,this.depth=n,this.texture=new $t(null,t,e,n),this.texture.isRenderTargetTexture=!0}},e.WebGLCubeRenderTarget=li,e.WebGLMultipleRenderTargets=class extends Kt{constructor(t,e,n,i={}){super(t,e,i),this.isWebGLMultipleRenderTargets=!0;const r=this.texture;this.texture=[];for(let t=0;t<n;t++)this.texture[t]=r.clone(),this.texture[t].isRenderTargetTexture=!0}setSize(t,e,n=1){if(this.width!==t||this.height!==e||this.depth!==n){this.width=t,this.height=e,this.depth=n;for(let i=0,r=this.texture.length;i<r;i++)this.texture[i].image.width=t,this.texture[i].image.height=e,this.texture[i].image.depth=n;this.dispose()}return this.viewport.set(0,0,t,e),this.scissor.set(0,0,t,e),this}copy(t){this.dispose(),this.width=t.width,this.height=t.height,this.depth=t.depth,this.viewport.set(0,0,this.width,this.height),this.scissor.set(0,0,this.width,this.height),this.depthBuffer=t.depthBuffer,this.stencilBuffer=t.stencilBuffer,null!==t.depthTexture&&(this.depthTexture=t.depthTexture.clone()),this.texture.length=0;for(let e=0,n=t.texture.length;e<n;e++)this.texture[e]=t.texture[e].clone(),this.texture[e].isRenderTargetTexture=!0;return this}},e.WebGLMultisampleRenderTarget=class extends Kt{constructor(t,e,n){console.error('THREE.WebGLMultisampleRenderTarget has been removed. Use a normal render target and set the "samples" property to greater 0 to enable multisampling.'),super(t,e,n),this.samples=4}},e.WebGLRenderTarget=Kt,e.WebGLRenderer=Ys,e.WebGLUtils=zs,e.WireframeGeometry=Ml,e.WrapAroundEnding=rt,e.ZeroCurvatureEnding=nt,e.ZeroFactor=200,e.ZeroSlopeEnding=it,e.ZeroStencilOp=0,e._SRGBAFormat=pt,e.sRGBEncoding=ot},147:t=>{"use strict";t.exports={version:"0.30.0"}}},i={};function r(t){var e=i[t];if(void 0!==e)return e.exports;var s=i[t]={id:t,loaded:!1,exports:{}};return n[t].call(s.exports,s,s.exports,r),s.loaded=!0,s.exports}return r.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(t){if("object"==typeof window)return window}}(),r.nmd=t=>(t.paths=[],t.children||(t.children=[]),t),r.p="",r(747),r(568)})()));