import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeSystemGetAwsSnsIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Amazon Resource Name (ARN) of the SNS topic for your S3 bucket
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy#aws_sns_topic_arn DataSnowflakeSystemGetAwsSnsIamPolicy#aws_sns_topic_arn}
    */
    readonly awsSnsTopicArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy#id DataSnowflakeSystemGetAwsSnsIamPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy snowflake_system_get_aws_sns_iam_policy}
*/
export declare class DataSnowflakeSystemGetAwsSnsIamPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_system_get_aws_sns_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/system_get_aws_sns_iam_policy snowflake_system_get_aws_sns_iam_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeSystemGetAwsSnsIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeSystemGetAwsSnsIamPolicyConfig);
    private _awsSnsTopicArn?;
    get awsSnsTopicArn(): string;
    set awsSnsTopicArn(value: string);
    get awsSnsTopicArnInput(): string | undefined;
    get awsSnsTopicPolicyJson(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
