"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteApi = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [execute-api](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonapigateway.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class ExecuteApi extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [execute-api](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonapigateway.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'execute-api';
        this.accessLevelList = {
            Write: [
                'InvalidateCache',
                'Invoke',
                'ManageConnections'
            ]
        };
    }
    /**
     * Used to invalidate API cache upon a client request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/api-gateway-caching.html
     */
    toInvalidateCache() {
        return this.to('InvalidateCache');
    }
    /**
     * Used to invoke an API upon a client request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/how-to-call-api.html
     */
    toInvoke() {
        return this.to('Invoke');
    }
    /**
     * ManageConnections controls access to the @connections API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/apigateway/api-reference/apigateway-websocket-control-access-iam.html
     */
    toManageConnections() {
        return this.to('ManageConnections');
    }
    /**
     * Adds a resource of type execute-api-general to the statement
     *
     * @param apiId - Identifier for the apiId.
     * @param stage - Identifier for the stage.
     * @param method - Identifier for the method.
     * @param apiSpecificResourcePath - Identifier for the apiSpecificResourcePath.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onExecuteApiGeneral(apiId, stage, method, apiSpecificResourcePath, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:execute-api:${region || '*'}:${account || '*'}:${apiId}/${stage}/${method}/${apiSpecificResourcePath}`);
    }
}
exports.ExecuteApi = ExecuteApi;
_a = JSII_RTTI_SYMBOL_1;
ExecuteApi[_a] = { fqn: "cdk-iam-floyd.ExecuteApi", version: "0.342.0" };
//# sourceMappingURL=data:application/json;base64,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