"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dbqms = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Dbqms extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'dbqms';
        this.accessLevelList = {
            Write: [
                'CreateFavoriteQuery',
                'CreateQueryHistory',
                'CreateTab',
                'DeleteFavoriteQueries',
                'DeleteQueryHistory',
                'DeleteTab',
                'UpdateFavoriteQuery',
                'UpdateQueryHistory',
                'UpdateTab'
            ],
            List: [
                'DescribeFavoriteQueries',
                'DescribeQueryHistory',
                'DescribeTabs'
            ],
            Read: [
                'GetQueryString'
            ]
        };
    }
    /**
     * Grants permission to create a new favorite query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateFavoriteQuery
     */
    toCreateFavoriteQuery() {
        return this.to('CreateFavoriteQuery');
    }
    /**
     * Grants permission to add a query to the history
     *
     * Access Level: Write
     */
    toCreateQueryHistory() {
        return this.to('CreateQueryHistory');
    }
    /**
     * Grants permission to create a new query tab
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateTab
     */
    toCreateTab() {
        return this.to('CreateTab');
    }
    /**
     * Grants permission to delete saved queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteFavoriteQueries
     */
    toDeleteFavoriteQueries() {
        return this.to('DeleteFavoriteQueries');
    }
    /**
     * Grants permission to delete a historical query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteQueryHistory
     */
    toDeleteQueryHistory() {
        return this.to('DeleteQueryHistory');
    }
    /**
     * Grants permission to delete query tab
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteTab
     */
    toDeleteTab() {
        return this.to('DeleteTab');
    }
    /**
     * Grants permission to list saved queries and associated metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeFavoriteQueries
     */
    toDescribeFavoriteQueries() {
        return this.to('DescribeFavoriteQueries');
    }
    /**
     * Grants permission to list history of queries that were run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeQueryHistory
     */
    toDescribeQueryHistory() {
        return this.to('DescribeQueryHistory');
    }
    /**
     * Grants permission to list query tabs and associated metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeTabs
     */
    toDescribeTabs() {
        return this.to('DescribeTabs');
    }
    /**
     * Grants permission to retrieve favorite or history query string by id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#GetQueryString
     */
    toGetQueryString() {
        return this.to('GetQueryString');
    }
    /**
     * Grants permission to update saved query and description
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateFavoriteQuery
     */
    toUpdateFavoriteQuery() {
        return this.to('UpdateFavoriteQuery');
    }
    /**
     * Grants permission to update the query history
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateQueryHistory
     */
    toUpdateQueryHistory() {
        return this.to('UpdateQueryHistory');
    }
    /**
     * Grants permission to update query tab
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateTab
     */
    toUpdateTab() {
        return this.to('UpdateTab');
    }
}
exports.Dbqms = Dbqms;
_a = JSII_RTTI_SYMBOL_1;
Dbqms[_a] = { fqn: "cdk-iam-floyd.Dbqms", version: "0.342.0" };
//# sourceMappingURL=data:application/json;base64,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