"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ssmmessages = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [ssmmessages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsessionmanagermessagegatewayservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Ssmmessages extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ssmmessages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsessionmanagermessagegatewayservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'ssmmessages';
        this.accessLevelList = {
            Write: [
                'CreateControlChannel',
                'CreateDataChannel',
                'OpenControlChannel',
                'OpenDataChannel'
            ]
        };
    }
    /**
     * Grants permission to register a control channel for an instance to send control messages to Systems Manager service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-iam-instance-profile.html
     */
    toCreateControlChannel() {
        return this.to('CreateControlChannel');
    }
    /**
     * Grants permission to register a data channel for an instance to send data messages to Systems Manager service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-iam-instance-profile.html
     */
    toCreateDataChannel() {
        return this.to('CreateDataChannel');
    }
    /**
     * Grants permission to open a websocket connection for a registered control channel stream from an instance to Systems Manager service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-iam-instance-profile.html
     */
    toOpenControlChannel() {
        return this.to('OpenControlChannel');
    }
    /**
     * Grants permission to open a websocket connection for a registered data channel stream from an instance to Systems Manager service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-iam-instance-profile.html
     */
    toOpenDataChannel() {
        return this.to('OpenDataChannel');
    }
}
exports.Ssmmessages = Ssmmessages;
_a = JSII_RTTI_SYMBOL_1;
Ssmmessages[_a] = { fqn: "cdk-iam-floyd.Ssmmessages", version: "0.342.0" };
//# sourceMappingURL=data:application/json;base64,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