import { PolicyStatementWithActions } from './3-actions';
export interface ResourceTypes {
    [key: string]: ResourceType;
}
export interface ResourceType {
    name: string;
    url: string;
    arn: string;
    conditionKeys: string[];
}
/**
 * Adds "resource" functionality to the Policy Statement
 */
export declare class PolicyStatementWithResources extends PolicyStatementWithActions {
    private useNotResources;
    protected resources: string[];
    protected skipAutoResource: boolean;
    private cdkResourcesApplied;
    /**
     * Injects resources into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON(): any;
    toStatementJson(): any;
    private cdkApplyResources;
    /**
     * Switches the statement to use [`NotResource`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html).
     */
    notResources(): this;
    /**
     * Checks weather any resource was applied to the policy.
     */
    hasResources(): boolean;
    /**
     * Limit statement to specified resources.
     *
     * To allow all resources, pass `*`
     */
    on(...arns: string[]): this;
    /**
     * Add all resources (`*`) to the statement
     *
     * This is the default behavior, unless the statement has principals.
     */
    onAllResources(): this;
    private ensureResource;
    /**
     * Dummy method. Will be overridden by 6-principal.ts
     *
     * We just need it here so we can reference it in method `ensureResource`
     */
    hasPrincipals(): boolean;
}
