"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Amplifybackend = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Amplifybackend extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'amplifybackend';
        this.accessLevelList = {
            Write: [
                'CloneBackend',
                'CreateBackend',
                'CreateBackendAPI',
                'CreateBackendAuth',
                'CreateBackendConfig',
                'CreateBackendStorage',
                'CreateToken',
                'DeleteBackend',
                'DeleteBackendAPI',
                'DeleteBackendAuth',
                'DeleteBackendStorage',
                'DeleteToken',
                'GenerateBackendAPIModels',
                'ImportBackendAuth',
                'ImportBackendStorage',
                'RemoveAllBackends',
                'RemoveBackendConfig',
                'UpdateBackendAPI',
                'UpdateBackendAuth',
                'UpdateBackendConfig',
                'UpdateBackendJob',
                'UpdateBackendStorage'
            ],
            Read: [
                'GetBackend',
                'GetBackendAPI',
                'GetBackendAPIModels',
                'GetBackendAuth',
                'GetBackendJob',
                'GetBackendStorage',
                'GetToken'
            ],
            List: [
                'ListBackendJobs',
                'ListS3Buckets'
            ]
        };
    }
    /**
     * Grants permission to clone an existing Amplify Admin backend environment into a new Amplify Admin backend enviroment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-clone.html#CloneBackend
     */
    toCloneBackend() {
        return this.to('CloneBackend');
    }
    /**
     * Grants permission to create a new Amplify Admin backend environment by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html#CreateBackend
     */
    toCreateBackend() {
        return this.to('CreateBackend');
    }
    /**
     * Grants permission to create an API for an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html#CreateBackendAPI
     */
    toCreateBackendAPI() {
        return this.to('CreateBackendAPI');
    }
    /**
     * Grants permission to create an auth resource for an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html#CreateBackendAuth
     */
    toCreateBackendAuth() {
        return this.to('CreateBackendAuth');
    }
    /**
     * Grants permission to create a new Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html#CreateBackendConfig
     */
    toCreateBackendConfig() {
        return this.to('CreateBackendConfig');
    }
    /**
     * Grants permission to create a backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#CreateBackendStorage
     */
    toCreateBackendStorage() {
        return this.to('CreateBackendStorage');
    }
    /**
     * Grants permission to create an Amplify Admin challenge token by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge.html#CreateToken
     */
    toCreateToken() {
        return this.to('CreateToken');
    }
    /**
     * Grants permission to delete an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-remove.html#DeleteBackend
     */
    toDeleteBackend() {
        return this.to('DeleteBackend');
    }
    /**
     * Grants permission to delete an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-remove.html#DeleteBackendAPI
     */
    toDeleteBackendAPI() {
        return this.to('DeleteBackendAPI');
    }
    /**
     * Grants permission to delete an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-remove.html#DeleteBackendAuth
     */
    toDeleteBackendAuth() {
        return this.to('DeleteBackendAuth');
    }
    /**
     * Grants permission to delete a backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#DeleteBackendStorage
     */
    toDeleteBackendStorage() {
        return this.to('DeleteBackendStorage');
    }
    /**
     * Grants permission to delete an Amplify Admin challenge token by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid-remove.html#DeleteToken
     */
    toDeleteToken() {
        return this.to('DeleteToken');
    }
    /**
     * Grants permission to generate models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-generatemodels.html#GenerateBackendAPIModels
     */
    toGenerateBackendAPIModels() {
        return this.to('GenerateBackendAPIModels');
    }
    /**
     * Grants permission to retrieve an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-details.html#GetBackend
     */
    toGetBackend() {
        return this.to('GetBackend');
    }
    /**
     * Grants permission to retrieve an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html#GetBackendAPI
     */
    toGetBackendAPI() {
        return this.to('GetBackendAPI');
    }
    /**
     * Grants permission to retrieve models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-getmodels.html#GetBackendAPIModels
     */
    toGetBackendAPIModels() {
        return this.to('GetBackendAPIModels');
    }
    /**
     * Grants permission to retrieve an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-details.html#GetBackendAuth
     */
    toGetBackendAuth() {
        return this.to('GetBackendAuth');
    }
    /**
     * Grants permission to retrieve a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#GetBackendJob
     */
    toGetBackendJob() {
        return this.to('GetBackendJob');
    }
    /**
     * Grants permission to retrieve an existing backend storage resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#GetBackendStorage
     */
    toGetBackendStorage() {
        return this.to('GetBackendStorage');
    }
    /**
     * Grants permission to retrieve an Amplify Admin challenge token by appId
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid.html#GetToken
     */
    toGetToken() {
        return this.to('GetToken');
    }
    /**
     * Grants permission to import an existing auth resource of an Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#ImportBackendAuth
     */
    toImportBackendAuth() {
        return this.to('ImportBackendAuth');
    }
    /**
     * Grants permission to import an existing backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#ImportBackendStorage
     */
    toImportBackendStorage() {
        return this.to('ImportBackendStorage');
    }
    /**
     * Grants permission to retrieve the jobs of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html#ListBackendJobs
     */
    toListBackendJobs() {
        return this.to('ListBackendJobs');
    }
    /**
     * Grants permission to retrieve s3 buckets
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#ListS3Buckets
     */
    toListS3Buckets() {
        return this.to('ListS3Buckets');
    }
    /**
     * Grants permission to delete all existing Amplify Admin backend environments by appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-remove.html#RemoveAllBackends
     */
    toRemoveAllBackends() {
        return this.to('RemoveAllBackends');
    }
    /**
     * Grants permission to delete an Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-remove.html#RemoveBackendConfig
     */
    toRemoveBackendConfig() {
        return this.to('RemoveBackendConfig');
    }
    /**
     * Grants permission to update an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname.html#UpdateBackendAPI
     */
    toUpdateBackendAPI() {
        return this.to('UpdateBackendAPI');
    }
    /**
     * Grants permission to update an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#UpdateBackendAuth
     */
    toUpdateBackendAuth() {
        return this.to('UpdateBackendAuth');
    }
    /**
     * Grants permission to update an Amplify Admin backend config by Amplify appId
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-update.html#UpdateBackendConfig
     */
    toUpdateBackendConfig() {
        return this.to('UpdateBackendConfig');
    }
    /**
     * Grants permission to update a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#UpdateBackendJob
     */
    toUpdateBackendJob() {
        return this.to('UpdateBackendJob');
    }
    /**
     * Grants permission to update a backend storage resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html#UpdateBackendStorage
     */
    toUpdateBackendStorage() {
        return this.to('UpdateBackendStorage');
    }
    /**
     * Adds a resource of type backend to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onBackend(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}`);
    }
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onEnvironment(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/environments`);
    }
    /**
     * Adds a resource of type api to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onApi(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/api`);
    }
    /**
     * Adds a resource of type auth to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onAuth(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/auth`);
    }
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onJob(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/job`);
    }
    /**
     * Adds a resource of type config to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onConfig(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/config`);
    }
    /**
     * Adds a resource of type token to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-token.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onToken(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/token`);
    }
    /**
     * Adds a resource of type storage to the statement
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-storage.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onStorage(appId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:amplifybackend:${region || '*'}:${account || '*'}:backend/${appId}/storage`);
    }
}
exports.Amplifybackend = Amplifybackend;
_a = JSII_RTTI_SYMBOL_1;
Amplifybackend[_a] = { fqn: "cdk-iam-floyd.Amplifybackend", version: "0.342.0" };
//# sourceMappingURL=data:application/json;base64,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