"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Kendra = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [kendra](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkendra.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Kendra extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [kendra](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkendra.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'kendra';
        this.accessLevelList = {
            Write: [
                'AssociateEntitiesToExperience',
                'AssociatePersonasToEntities',
                'BatchDeleteDocument',
                'BatchPutDocument',
                'ClearQuerySuggestions',
                'CreateDataSource',
                'CreateExperience',
                'CreateFaq',
                'CreateIndex',
                'CreateQuerySuggestionsBlockList',
                'CreateThesaurus',
                'DeleteDataSource',
                'DeleteExperience',
                'DeleteFaq',
                'DeleteIndex',
                'DeletePrincipalMapping',
                'DeleteQuerySuggestionsBlockList',
                'DeleteThesaurus',
                'DisassociateEntitiesFromExperience',
                'DisassociatePersonasFromEntities',
                'PutPrincipalMapping',
                'StartDataSourceSyncJob',
                'StopDataSourceSyncJob',
                'SubmitFeedback',
                'UpdateDataSource',
                'UpdateExperience',
                'UpdateIndex',
                'UpdateQuerySuggestionsBlockList',
                'UpdateQuerySuggestionsConfig',
                'UpdateThesaurus'
            ],
            Read: [
                'BatchGetDocumentStatus',
                'DescribeDataSource',
                'DescribeExperience',
                'DescribeFaq',
                'DescribeIndex',
                'DescribePrincipalMapping',
                'DescribeQuerySuggestionsBlockList',
                'DescribeQuerySuggestionsConfig',
                'DescribeThesaurus',
                'GetQuerySuggestions',
                'GetSnapshots',
                'ListTagsForResource',
                'Query'
            ],
            List: [
                'ListDataSourceSyncJobs',
                'ListDataSources',
                'ListEntityPersonas',
                'ListExperienceEntities',
                'ListExperiences',
                'ListFaqs',
                'ListGroupsOlderThanOrderingId',
                'ListIndices',
                'ListQuerySuggestionsBlockLists',
                'ListThesauri'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to put principal mapping in index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html
     */
    toAssociateEntitiesToExperience() {
        return this.to('AssociateEntitiesToExperience');
    }
    /**
     * Defines the specific permissions of users or groups in your AWS SSO identity source with access to your Amazon Kendra experience
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_AssociatePersonasToEntities.html
     */
    toAssociatePersonasToEntities() {
        return this.to('AssociatePersonasToEntities');
    }
    /**
     * Grants permission to batch delete document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html
     */
    toBatchDeleteDocument() {
        return this.to('BatchDeleteDocument');
    }
    /**
     * Grants permission to do batch get document status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html
     */
    toBatchGetDocumentStatus() {
        return this.to('BatchGetDocumentStatus');
    }
    /**
     * Grants permission to batch put document
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html
     */
    toBatchPutDocument() {
        return this.to('BatchPutDocument');
    }
    /**
     * Grants permission to clear out the suggestions for a given index, generated so far
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ClearQuerySuggestions.html
     */
    toClearQuerySuggestions() {
        return this.to('ClearQuerySuggestions');
    }
    /**
     * Grants permission to create a data source
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html
     */
    toCreateDataSource() {
        return this.to('CreateDataSource');
    }
    /**
     * Creates an Amazon Kendra experience such as a search application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateExperience.html
     */
    toCreateExperience() {
        return this.to('CreateExperience');
    }
    /**
     * Grants permission to create an Faq
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateFaq.html
     */
    toCreateFaq() {
        return this.to('CreateFaq');
    }
    /**
     * Grants permission to create an Index
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html
     */
    toCreateIndex() {
        return this.to('CreateIndex');
    }
    /**
     * Grants permission to create a QuerySuggestions BlockList
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateQuerySuggestionsBlockList.html
     */
    toCreateQuerySuggestionsBlockList() {
        return this.to('CreateQuerySuggestionsBlockList');
    }
    /**
     * Grants permission to create a Thesaurus
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateThesaurus.html
     */
    toCreateThesaurus() {
        return this.to('CreateThesaurus');
    }
    /**
     * Grants permission to delete a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteDataSource.html
     */
    toDeleteDataSource() {
        return this.to('DeleteDataSource');
    }
    /**
     * Deletes your Amazon Kendra experience such as a search application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteExperience.html
     */
    toDeleteExperience() {
        return this.to('DeleteExperience');
    }
    /**
     * Grants permission to delete an Faq
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteFaq.html
     */
    toDeleteFaq() {
        return this.to('DeleteFaq');
    }
    /**
     * Grants permission to delete an Index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteIndex.html
     */
    toDeleteIndex() {
        return this.to('DeleteIndex');
    }
    /**
     * Grants permission to delete principal mapping from index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeletePrincipalMapping.html
     */
    toDeletePrincipalMapping() {
        return this.to('DeletePrincipalMapping');
    }
    /**
     * Grants permission to delete a QuerySuggestions BlockList
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteQuerySuggestionsBlockList.html
     */
    toDeleteQuerySuggestionsBlockList() {
        return this.to('DeleteQuerySuggestionsBlockList');
    }
    /**
     * Grants permission to delete a Thesaurus
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteThesaurus.html
     */
    toDeleteThesaurus() {
        return this.to('DeleteThesaurus');
    }
    /**
     * Grants permission to describe a data source
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeDataSource.html
     */
    toDescribeDataSource() {
        return this.to('DescribeDataSource');
    }
    /**
     * Gets information about your Amazon Kendra experience such as a search application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeExperience.html
     */
    toDescribeExperience() {
        return this.to('DescribeExperience');
    }
    /**
     * Grants permission to describe an Faq
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeFaq.html
     */
    toDescribeFaq() {
        return this.to('DescribeFaq');
    }
    /**
     * Grants permission to describe an Index
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeIndex.html
     */
    toDescribeIndex() {
        return this.to('DescribeIndex');
    }
    /**
     * Grants permission to describe principal mapping from index
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribePrincipalMapping.html
     */
    toDescribePrincipalMapping() {
        return this.to('DescribePrincipalMapping');
    }
    /**
     * Grants permission to describe a QuerySuggestions BlockList
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeQuerySuggestionsBlockList.html
     */
    toDescribeQuerySuggestionsBlockList() {
        return this.to('DescribeQuerySuggestionsBlockList');
    }
    /**
     * Grants permission to describe the query suggestions configuration for an index
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeQuerySuggestionsConfig.html
     */
    toDescribeQuerySuggestionsConfig() {
        return this.to('DescribeQuerySuggestionsConfig');
    }
    /**
     * Grants permission to describe a Thesaurus
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeThesaurus.html
     */
    toDescribeThesaurus() {
        return this.to('DescribeThesaurus');
    }
    /**
     * Prevents users or groups in your AWS SSO identity source from accessing your Amazon Kendra experience
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DisassociateEntitiesFromExperience.html
     */
    toDisassociateEntitiesFromExperience() {
        return this.to('DisassociateEntitiesFromExperience');
    }
    /**
     * Removes the specific permissions of users or groups in your AWS SSO identity source with access to your Amazon Kendra experience
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DisassociatePersonasFromEntities.html
     */
    toDisassociatePersonasFromEntities() {
        return this.to('DisassociatePersonasFromEntities');
    }
    /**
     * Grants permission to get suggestions for a query prefix
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html
     */
    toGetQuerySuggestions() {
        return this.to('GetQuerySuggestions');
    }
    /**
     * Retrieves search metrics data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_GetSnapshots.html
     */
    toGetSnapshots() {
        return this.to('GetSnapshots');
    }
    /**
     * Grants permission to get Data Source sync job history
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListDataSourceSyncJobs.html
     */
    toListDataSourceSyncJobs() {
        return this.to('ListDataSourceSyncJobs');
    }
    /**
     * Grants permission to list the data sources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListDataSources.html
     */
    toListDataSources() {
        return this.to('ListDataSources');
    }
    /**
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListEntityPersonas.html
     */
    toListEntityPersonas() {
        return this.to('ListEntityPersonas');
    }
    /**
     * Lists users or groups in your AWS SSO identity source that are granted access to your Amazon Kendra experience
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListExperienceEntities.html
     */
    toListExperienceEntities() {
        return this.to('ListExperienceEntities');
    }
    /**
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListExperiences.html
     */
    toListExperiences() {
        return this.to('ListExperiences');
    }
    /**
     * Grants permission to list the Faqs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListFaqs.html
     */
    toListFaqs() {
        return this.to('ListFaqs');
    }
    /**
     * Grants permission to list groups that are older than an ordering id
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListGroupsOlderThanOrderingId.html
     */
    toListGroupsOlderThanOrderingId() {
        return this.to('ListGroupsOlderThanOrderingId');
    }
    /**
     * Grants permission to list the indexes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListIndices.html
     */
    toListIndices() {
        return this.to('ListIndices');
    }
    /**
     * Grants permission to list the QuerySuggestions BlockLists
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListQuerySuggestionsBlockLists.html
     */
    toListQuerySuggestionsBlockLists() {
        return this.to('ListQuerySuggestionsBlockLists');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list the Thesauri
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListThesauri.html
     */
    toListThesauri() {
        return this.to('ListThesauri');
    }
    /**
     * Grants permission to put principal mapping in index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html
     */
    toPutPrincipalMapping() {
        return this.to('PutPrincipalMapping');
    }
    /**
     * Grants permission to query documents and faqs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html
     */
    toQuery() {
        return this.to('Query');
    }
    /**
     * Grants permission to start Data Source sync job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_StartDataSourceSyncJob.html
     */
    toStartDataSourceSyncJob() {
        return this.to('StartDataSourceSyncJob');
    }
    /**
     * Grants permission to stop Data Source sync job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_StopDataSourceSyncJob.html
     */
    toStopDataSourceSyncJob() {
        return this.to('StopDataSourceSyncJob');
    }
    /**
     * Grants permission to send feedback about a query results
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_SubmitFeedback.html
     */
    toSubmitFeedback() {
        return this.to('SubmitFeedback');
    }
    /**
     * Grants permission to tag a resource with given key value pairs
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove the tag with the given key from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateDataSource.html
     */
    toUpdateDataSource() {
        return this.to('UpdateDataSource');
    }
    /**
     * Updates your Amazon Kendra experience such as a search application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateExperience.html
     */
    toUpdateExperience() {
        return this.to('UpdateExperience');
    }
    /**
     * Grants permission to update an Index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html
     */
    toUpdateIndex() {
        return this.to('UpdateIndex');
    }
    /**
     * Grants permission to update a QuerySuggestions BlockList
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsBlockList.html
     */
    toUpdateQuerySuggestionsBlockList() {
        return this.to('UpdateQuerySuggestionsBlockList');
    }
    /**
     * Grants permission to update the query suggestions configuration for an index
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html
     */
    toUpdateQuerySuggestionsConfig() {
        return this.to('UpdateQuerySuggestionsConfig');
    }
    /**
     * Grants permission to update a thesaurus
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateThesaurus.html
     */
    toUpdateThesaurus() {
        return this.to('UpdateThesaurus');
    }
    /**
     * Adds a resource of type index to the statement
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/index.html
     *
     * @param indexId - Identifier for the indexId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIndex(indexId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:kendra:${region || '*'}:${account || '*'}:index/${indexId}`);
    }
    /**
     * Adds a resource of type data-source to the statement
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/data-source.html
     *
     * @param indexId - Identifier for the indexId.
     * @param dataSourceId - Identifier for the dataSourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataSource(indexId, dataSourceId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:kendra:${region || '*'}:${account || '*'}:index/${indexId}/data-source/${dataSourceId}`);
    }
    /**
     * Adds a resource of type faq to the statement
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/faq.html
     *
     * @param indexId - Identifier for the indexId.
     * @param faqId - Identifier for the faqId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFaq(indexId, faqId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:kendra:${region || '*'}:${account || '*'}:index/${indexId}/faq/${faqId}`);
    }
    /**
     * Adds a resource of type experience to the statement
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html
     *
     * @param indexId - Identifier for the indexId.
     * @param experienceId - Identifier for the experienceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onExperience(indexId, experienceId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:kendra:${region || '*'}:${account || '*'}:index/${indexId}/experience/${experienceId}`);
    }
    /**
     * Adds a resource of type thesaurus to the statement
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/thesaurus.html
     *
     * @param indexId - Identifier for the indexId.
     * @param thesaurusId - Identifier for the thesaurusId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onThesaurus(indexId, thesaurusId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:kendra:${region || '*'}:${account || '*'}:index/${indexId}/thesaurus/${thesaurusId}`);
    }
    /**
     * Adds a resource of type query-suggestions-block-list to the statement
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions-block-list.html
     *
     * @param indexId - Identifier for the indexId.
     * @param querySuggestionsBlockListId - Identifier for the querySuggestionsBlockListId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQuerySuggestionsBlockList(indexId, querySuggestionsBlockListId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:kendra:${region || '*'}:${account || '*'}:index/${indexId}/query-suggestions-block-list/${querySuggestionsBlockListId}`);
    }
}
exports.Kendra = Kendra;
_a = JSII_RTTI_SYMBOL_1;
Kendra[_a] = { fqn: "cdk-iam-floyd.Kendra", version: "0.342.0" };
//# sourceMappingURL=data:application/json;base64,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