"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Opsworks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [opsworks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworks.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Opsworks extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [opsworks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsopsworks.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'opsworks';
        this.accessLevelList = {
            Write: [
                'AssignInstance',
                'AssignVolume',
                'AssociateElasticIp',
                'AttachElasticLoadBalancer',
                'CloneStack',
                'CreateApp',
                'CreateDeployment',
                'CreateInstance',
                'CreateLayer',
                'CreateStack',
                'CreateUserProfile',
                'DeleteApp',
                'DeleteInstance',
                'DeleteLayer',
                'DeleteStack',
                'DeleteUserProfile',
                'DeregisterEcsCluster',
                'DeregisterElasticIp',
                'DeregisterInstance',
                'DeregisterRdsDbInstance',
                'DeregisterVolume',
                'DetachElasticLoadBalancer',
                'DisassociateElasticIp',
                'GrantAccess',
                'RebootInstance',
                'RegisterEcsCluster',
                'RegisterElasticIp',
                'RegisterInstance',
                'RegisterRdsDbInstance',
                'RegisterVolume',
                'SetLoadBasedAutoScaling',
                'SetTimeBasedAutoScaling',
                'StartInstance',
                'StartStack',
                'StopInstance',
                'StopStack',
                'UnassignInstance',
                'UnassignVolume',
                'UpdateApp',
                'UpdateElasticIp',
                'UpdateInstance',
                'UpdateLayer',
                'UpdateMyUserProfile',
                'UpdateRdsDbInstance',
                'UpdateStack',
                'UpdateVolume'
            ],
            List: [
                'DescribeAgentVersions',
                'DescribeApps',
                'DescribeCommands',
                'DescribeDeployments',
                'DescribeEcsClusters',
                'DescribeElasticIps',
                'DescribeElasticLoadBalancers',
                'DescribeInstances',
                'DescribeLayers',
                'DescribeLoadBasedAutoScaling',
                'DescribeMyUserProfile',
                'DescribeOperatingSystems',
                'DescribePermissions',
                'DescribeRaidArrays',
                'DescribeRdsDbInstances',
                'DescribeServiceErrors',
                'DescribeStackProvisioningParameters',
                'DescribeStackSummary',
                'DescribeStacks',
                'DescribeTimeBasedAutoScaling',
                'DescribeUserProfiles',
                'DescribeVolumes',
                'ListTags'
            ],
            Read: [
                'GetHostnameSuggestion'
            ],
            'Permissions management': [
                'SetPermission',
                'UpdateUserProfile'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Assign a registered instance to a layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AssignInstance.html
     */
    toAssignInstance() {
        return this.to('AssignInstance');
    }
    /**
     * Assigns one of the stack's registered Amazon EBS volumes to a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AssignVolume.html
     */
    toAssignVolume() {
        return this.to('AssignVolume');
    }
    /**
     * Associates one of the stack's registered Elastic IP addresses with a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AssociateElasticIp.html
     */
    toAssociateElasticIp() {
        return this.to('AssociateElasticIp');
    }
    /**
     * Attaches an Elastic Load Balancing load balancer to a specified layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_AttachElasticLoadBalancer.html
     */
    toAttachElasticLoadBalancer() {
        return this.to('AttachElasticLoadBalancer');
    }
    /**
     * Creates a clone of a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CloneStack.html
     */
    toCloneStack() {
        return this.to('CloneStack');
    }
    /**
     * Creates an app for a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateApp.html
     */
    toCreateApp() {
        return this.to('CreateApp');
    }
    /**
     * Runs deployment or stack commands
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateDeployment.html
     */
    toCreateDeployment() {
        return this.to('CreateDeployment');
    }
    /**
     * Creates an instance in a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateInstance.html
     */
    toCreateInstance() {
        return this.to('CreateInstance');
    }
    /**
     * Creates a layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateLayer.html
     */
    toCreateLayer() {
        return this.to('CreateLayer');
    }
    /**
     * Creates a new stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateStack.html
     */
    toCreateStack() {
        return this.to('CreateStack');
    }
    /**
     * Creates a new user profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_CreateUserProfile.html
     */
    toCreateUserProfile() {
        return this.to('CreateUserProfile');
    }
    /**
     * Deletes a specified app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteApp.html
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * Deletes a specified instance, which terminates the associated Amazon EC2 instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteInstance.html
     */
    toDeleteInstance() {
        return this.to('DeleteInstance');
    }
    /**
     * Deletes a specified layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteLayer.html
     */
    toDeleteLayer() {
        return this.to('DeleteLayer');
    }
    /**
     * Deletes a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteStack.html
     */
    toDeleteStack() {
        return this.to('DeleteStack');
    }
    /**
     * Deletes a user profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeleteUserProfile.html
     */
    toDeleteUserProfile() {
        return this.to('DeleteUserProfile');
    }
    /**
     * Deletes a user profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterEcsCluster.html
     */
    toDeregisterEcsCluster() {
        return this.to('DeregisterEcsCluster');
    }
    /**
     * Deregisters a specified Elastic IP address
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterElasticIp.html
     */
    toDeregisterElasticIp() {
        return this.to('DeregisterElasticIp');
    }
    /**
     * Deregister a registered Amazon EC2 or on-premises instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterInstance.html
     */
    toDeregisterInstance() {
        return this.to('DeregisterInstance');
    }
    /**
     * Deregisters an Amazon RDS instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterRdsDbInstance.html
     */
    toDeregisterRdsDbInstance() {
        return this.to('DeregisterRdsDbInstance');
    }
    /**
     * Deregisters an Amazon EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DeregisterVolume.html
     */
    toDeregisterVolume() {
        return this.to('DeregisterVolume');
    }
    /**
     * Describes the available AWS OpsWorks agent versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeAgentVersions.html
     */
    toDescribeAgentVersions() {
        return this.to('DescribeAgentVersions');
    }
    /**
     * Requests a description of a specified set of apps
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeApps.html
     */
    toDescribeApps() {
        return this.to('DescribeApps');
    }
    /**
     * Describes the results of specified commands
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeCommands.html
     */
    toDescribeCommands() {
        return this.to('DescribeCommands');
    }
    /**
     * Requests a description of a specified set of deployments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeDeployments.html
     */
    toDescribeDeployments() {
        return this.to('DescribeDeployments');
    }
    /**
     * Describes Amazon ECS clusters that are registered with a stack
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeEcsClusters.html
     */
    toDescribeEcsClusters() {
        return this.to('DescribeEcsClusters');
    }
    /**
     * Describes Elastic IP addresses
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeElasticIps.html
     */
    toDescribeElasticIps() {
        return this.to('DescribeElasticIps');
    }
    /**
     * Describes a stack's Elastic Load Balancing instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeElasticLoadBalancers.html
     */
    toDescribeElasticLoadBalancers() {
        return this.to('DescribeElasticLoadBalancers');
    }
    /**
     * Requests a description of a set of instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeInstances.html
     */
    toDescribeInstances() {
        return this.to('DescribeInstances');
    }
    /**
     * Requests a description of one or more layers in a specified stack
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeLayers.html
     */
    toDescribeLayers() {
        return this.to('DescribeLayers');
    }
    /**
     * Describes load-based auto scaling configurations for specified layers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeLoadBasedAutoScaling.html
     */
    toDescribeLoadBasedAutoScaling() {
        return this.to('DescribeLoadBasedAutoScaling');
    }
    /**
     * Describes a user's SSH information
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeMyUserProfile.html
     */
    toDescribeMyUserProfile() {
        return this.to('DescribeMyUserProfile');
    }
    /**
     * Describes the operating systems that are supported by AWS OpsWorks Stacks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeOperatingSystems.html
     */
    toDescribeOperatingSystems() {
        return this.to('DescribeOperatingSystems');
    }
    /**
     * Describes the permissions for a specified stack
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribePermissions.html
     */
    toDescribePermissions() {
        return this.to('DescribePermissions');
    }
    /**
     * Describe an instance's RAID arrays
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeRaidArrays.html
     */
    toDescribeRaidArrays() {
        return this.to('DescribeRaidArrays');
    }
    /**
     * Describes Amazon RDS instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeRdsDbInstances.html
     */
    toDescribeRdsDbInstances() {
        return this.to('DescribeRdsDbInstances');
    }
    /**
     * Describes AWS OpsWorks service errors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeServiceErrors.html
     */
    toDescribeServiceErrors() {
        return this.to('DescribeServiceErrors');
    }
    /**
     * Requests a description of a stack's provisioning parameters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeStackProvisioningParameters.html
     */
    toDescribeStackProvisioningParameters() {
        return this.to('DescribeStackProvisioningParameters');
    }
    /**
     * Describes the number of layers and apps in a specified stack, and the number of instances in each state, such as running_setup or online
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeStackSummary.html
     */
    toDescribeStackSummary() {
        return this.to('DescribeStackSummary');
    }
    /**
     * Requests a description of one or more stacks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeStacks.html
     */
    toDescribeStacks() {
        return this.to('DescribeStacks');
    }
    /**
     * Describes time-based auto scaling configurations for specified instances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeTimeBasedAutoScaling.html
     */
    toDescribeTimeBasedAutoScaling() {
        return this.to('DescribeTimeBasedAutoScaling');
    }
    /**
     * Describe specified users
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeUserProfiles.html
     */
    toDescribeUserProfiles() {
        return this.to('DescribeUserProfiles');
    }
    /**
     * Describes an instance's Amazon EBS volumes
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DescribeVolumes.html
     */
    toDescribeVolumes() {
        return this.to('DescribeVolumes');
    }
    /**
     * Detaches a specified Elastic Load Balancing instance from its layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DetachElasticLoadBalancer.html
     */
    toDetachElasticLoadBalancer() {
        return this.to('DetachElasticLoadBalancer');
    }
    /**
     * Disassociates an Elastic IP address from its instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_DisassociateElasticIp.html
     */
    toDisassociateElasticIp() {
        return this.to('DisassociateElasticIp');
    }
    /**
     * Gets a generated host name for the specified layer, based on the current host name theme
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_GetHostnameSuggestion.html
     */
    toGetHostnameSuggestion() {
        return this.to('GetHostnameSuggestion');
    }
    /**
     * Grants RDP access to a Windows instance for a specified time period
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RebootInstance.html
     */
    toGrantAccess() {
        return this.to('GrantAccess');
    }
    /**
     * Returns a list of tags that are applied to the specified stack or layer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_ListTags.html
     */
    toListTags() {
        return this.to('ListTags');
    }
    /**
     * Reboots a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RebootInstance.html
     */
    toRebootInstance() {
        return this.to('RebootInstance');
    }
    /**
     * Registers a specified Amazon ECS cluster with a stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterEcsCluster.html
     */
    toRegisterEcsCluster() {
        return this.to('RegisterEcsCluster');
    }
    /**
     * Registers an Elastic IP address with a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterElasticIp.html
     */
    toRegisterElasticIp() {
        return this.to('RegisterElasticIp');
    }
    /**
     * Registers instances with a specified stack that were created outside of AWS OpsWorks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterInstance.html
     */
    toRegisterInstance() {
        return this.to('RegisterInstance');
    }
    /**
     * Registers an Amazon RDS instance with a stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterRdsDbInstance.html
     */
    toRegisterRdsDbInstance() {
        return this.to('RegisterRdsDbInstance');
    }
    /**
     * Registers an Amazon EBS volume with a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_RegisterVolume.html
     */
    toRegisterVolume() {
        return this.to('RegisterVolume');
    }
    /**
     * Specify the load-based auto scaling configuration for a specified layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_SetLoadBasedAutoScaling.html
     */
    toSetLoadBasedAutoScaling() {
        return this.to('SetLoadBasedAutoScaling');
    }
    /**
     * Specifies a user's permissions
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_SetPermission.html
     */
    toSetPermission() {
        return this.to('SetPermission');
    }
    /**
     * Specify the time-based auto scaling configuration for a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_SetTimeBasedAutoScaling.html
     */
    toSetTimeBasedAutoScaling() {
        return this.to('SetTimeBasedAutoScaling');
    }
    /**
     * Starts a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StartInstance.html
     */
    toStartInstance() {
        return this.to('StartInstance');
    }
    /**
     * Starts a stack's instances
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StartStack.html
     */
    toStartStack() {
        return this.to('StartStack');
    }
    /**
     * Stops a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StopInstance.html
     */
    toStopInstance() {
        return this.to('StopInstance');
    }
    /**
     * Stops a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_StopStack.html
     */
    toStopStack() {
        return this.to('StopStack');
    }
    /**
     * Apply tags to a specified stack or layer
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Unassigns a registered instance from all of it's layers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UnassignInstance.html
     */
    toUnassignInstance() {
        return this.to('UnassignInstance');
    }
    /**
     * Unassigns an assigned Amazon EBS volume
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UnassignVolume.html
     */
    toUnassignVolume() {
        return this.to('UnassignVolume');
    }
    /**
     * Removes tags from a specified stack or layer
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Updates a specified app
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateApp.html
     */
    toUpdateApp() {
        return this.to('UpdateApp');
    }
    /**
     * Updates a registered Elastic IP address's name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateElasticIp.html
     */
    toUpdateElasticIp() {
        return this.to('UpdateElasticIp');
    }
    /**
     * Updates a specified instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateInstance.html
     */
    toUpdateInstance() {
        return this.to('UpdateInstance');
    }
    /**
     * Updates a specified layer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateLayer.html
     */
    toUpdateLayer() {
        return this.to('UpdateLayer');
    }
    /**
     * Updates a user's SSH public key
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateMyUserProfile.html
     */
    toUpdateMyUserProfile() {
        return this.to('UpdateMyUserProfile');
    }
    /**
     * Updates an Amazon RDS instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateRdsDbInstance.html
     */
    toUpdateRdsDbInstance() {
        return this.to('UpdateRdsDbInstance');
    }
    /**
     * Updates a specified stack
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateStack.html
     */
    toUpdateStack() {
        return this.to('UpdateStack');
    }
    /**
     * Updates a specified user profile
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateUserProfile.html
     */
    toUpdateUserProfile() {
        return this.to('UpdateUserProfile');
    }
    /**
     * Updates an Amazon EBS volume's name or mount point
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/opsworks/latest/APIReference/API_UpdateVolume.html
     */
    toUpdateVolume() {
        return this.to('UpdateVolume');
    }
    /**
     * Adds a resource of type stack to the statement
     *
     * https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks.html
     *
     * @param stackId - Identifier for the stackId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onStack(stackId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:opsworks:${region || '*'}:${account || '*'}:stack/${stackId}/`);
    }
}
exports.Opsworks = Opsworks;
_a = JSII_RTTI_SYMBOL_1;
Opsworks[_a] = { fqn: "cdk-iam-floyd.Opsworks", version: "0.342.0" };
//# sourceMappingURL=data:application/json;base64,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