import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [signer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssigner.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Signer extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to add cross-account permissions to a Signing Profile
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifProfileVersion()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_AddProfilePermission.html
     */
    toAddProfilePermission(): this;
    /**
     * Grants permission to change the state of a Signing Profile to CANCELED
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifProfileVersion()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_CancelSigningProfile.html
     */
    toCancelSigningProfile(): this;
    /**
     * Grants permission to return information about a specific Signing Job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_DescribeSigningJob.html
     */
    toDescribeSigningJob(): this;
    /**
     * Grants permission to return information about a specific Signing Platform
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_GetSigningPlatform.html
     */
    toGetSigningPlatform(): this;
    /**
     * Grants permission to return information about a specific Signing Profile
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifProfileVersion()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_GetSigningProfile.html
     */
    toGetSigningProfile(): this;
    /**
     * Grants permission to list the cross-account permissions associated with a Signing Profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_ListProfilePermissions.html
     */
    toListProfilePermissions(): this;
    /**
     * Grants permission to list all Signing Jobs in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_ListSigningJobs.html
     */
    toListSigningJobs(): this;
    /**
     * Grants permission to list all available Signing Platforms
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_ListSigningPlatforms.html
     */
    toListSigningPlatforms(): this;
    /**
     * Grants permission to list all Signing Profiles in your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_ListSigningProfiles.html
     */
    toListSigningProfiles(): this;
    /**
     * Grants permission to list the tags associated with a Signing Profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create a new Signing Profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_PutSigningProfile.html
     */
    toPutSigningProfile(): this;
    /**
     * Grants permission to remove cross-account permissions from a Signing Profile
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifProfileVersion()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_RemoveProfilePermission.html
     */
    toRemoveProfilePermission(): this;
    /**
     * Grants permission to change the state of a Signing Job to REVOKED
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifProfileVersion()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_RevokeSignature.html
     */
    toRevokeSignature(): this;
    /**
     * Grants permission to change the state of a Signing Profile to REVOKED
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifProfileVersion()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_RevokeSigningProfile.html
     */
    toRevokeSigningProfile(): this;
    /**
     * Grants permission to initiate a Signing Job on the provided code
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifProfileVersion()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_StartSigningJob.html
     */
    toStartSigningJob(): this;
    /**
     * Grants permission to add one or more tags to a Signing Profile
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove one or more tags from a Signing Profile
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/signer/latest/api/API_UntagResource.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type signing-profile to the statement
     *
     * https://docs.aws.amazon.com/signer/latest/developerguide/gs-profile.html
     *
     * @param profileName - Identifier for the profileName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSigningProfile(profileName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type signing-job to the statement
     *
     * https://docs.aws.amazon.com/signer/latest/developerguide/gs-job.html
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSigningJob(jobId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access based on the version of the Signing Profile
     *
     * https://docs.aws.amazon.com/signer/latest/developerguide/authen-apipermissions.html
     *
     * Applies to actions:
     * - .toAddProfilePermission()
     * - .toCancelSigningProfile()
     * - .toGetSigningProfile()
     * - .toRemoveProfilePermission()
     * - .toRevokeSignature()
     * - .toRevokeSigningProfile()
     * - .toStartSigningJob()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifProfileVersion(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [signer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssigner.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
