# Generated by Django 4.1.8 on 2023-04-17 11:31
import colorfield.fields
import django.contrib.postgres.constraints
import django.contrib.postgres.fields.ranges
import django.core.validators
import django.db.models.deletion
import django_fsm
import mptt.fields
import timezone_field.fields
import wbcore.contrib.color.fields
import wbcore.contrib.icons.models
import wbhuman_resources.models.kpi
from django.contrib.postgres.operations import BtreeGistExtension
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        ("agenda", "0003_calendaritem_endpoint_basename"),
        ("directory", "0002_auto_20230414_1553"),
    ]

    operations = [
        BtreeGistExtension(),
        migrations.CreateModel(
            name="AbsenceRequest",
            fields=[
                (
                    "calendaritem_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="agenda.calendaritem",
                    ),
                ),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[
                            ("DRAFT", "Draft"),
                            ("PENDING", "Pending"),
                            ("APPROVED", "Approved"),
                            ("DENIED", "Denied"),
                            ("CANCELLED", "Cancelled"),
                        ],
                        default="DRAFT",
                        help_text="The request status (defaults to draft)",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True, help_text="A note to the HR administrator", null=True, verbose_name="Extra Notes"
                    ),
                ),
                (
                    "reason",
                    models.TextField(
                        blank=True,
                        help_text="The HR's response to this absence request",
                        null=True,
                        verbose_name="Reason",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        auto_now_add=True, help_text="The request creation time", verbose_name="Created"
                    ),
                ),
                (
                    "attachment",
                    models.FileField(
                        blank=True,
                        help_text="Upload a file to document this absence request (e.g. medical certificate)",
                        max_length=256,
                        null=True,
                        upload_to="human_resources/absence_request/attachments",
                        verbose_name="Attachment",
                    ),
                ),
            ],
            options={
                "verbose_name": "Absence Request",
                "verbose_name_plural": "Absence Requests",
                "permissions": [("administrate_absencerequest", "Can administer Absence Requests")],
            },
            bases=("agenda.calendaritem",),
        ),
        migrations.CreateModel(
            name="AbsenceRequestType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("color", wbcore.contrib.color.fields.ColorField(default="#000000", verbose_name="Color")),
                ("icon", wbcore.contrib.icons.models.IconField(default="EVENT", max_length=128, verbose_name="Icon")),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                (
                    "is_vacation",
                    models.BooleanField(
                        default=False,
                        help_text="If true, the days will be counted towards the employee's vacation balance",
                        verbose_name="Vacation",
                    ),
                ),
                (
                    "is_timeoff",
                    models.BooleanField(
                        default=False,
                        help_text="If true, the employee is considered as not working",
                        verbose_name="Time-Off",
                    ),
                ),
                (
                    "is_extensible",
                    models.BooleanField(
                        default=False,
                        help_text="If true, allow the associated request to be extended",
                        verbose_name="Extensible",
                    ),
                ),
                ("auto_approve", models.BooleanField(default=False, verbose_name="Auto Approve")),
                ("days_in_advance", models.PositiveIntegerField(default=0, verbose_name="Days In Advance")),
            ],
            options={
                "verbose_name": "Absence Request Type",
                "verbose_name_plural": "Absence Request Types",
            },
        ),
        migrations.CreateModel(
            name="DayOffCalendar",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255)),
                (
                    "resource",
                    models.CharField(
                        blank=True, help_text="Used to fetch the days off from an API.", max_length=255, null=True
                    ),
                ),
                ("timezone", timezone_field.fields.TimeZoneField(default="UTC")),
            ],
            options={
                "verbose_name": "Day Off Calendar",
                "verbose_name_plural": "Days Off Calendar",
                "unique_together": {("resource", "timezone")},
            },
        ),
        migrations.CreateModel(
            name="DefaultDailyPeriod",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("lower_time", models.TimeField()),
                ("upper_time", models.TimeField()),
                ("timespan", django.contrib.postgres.fields.ranges.DateTimeRangeField()),
                ("title", models.CharField(max_length=128)),
                ("total_hours", models.FloatField()),
                (
                    "calendar",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="default_periods",
                        to="wbhuman_resources.dayoffcalendar",
                        verbose_name="Calendar",
                    ),
                ),
            ],
            options={
                "verbose_name": "Default Daily Period",
                "verbose_name_plural": "Default Daily Periods",
            },
        ),
        migrations.CreateModel(
            name="EmployeeHumanResource",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="If false, the employee will be considered as not active but his absence requests will be preserved",
                        verbose_name="Is active",
                    ),
                ),
                (
                    "extra_days_frequency",
                    models.CharField(
                        choices=[("MONTHLY", "Monthly"), ("YEARLY", "Yearly")],
                        default="YEARLY",
                        help_text="The frequency at which an additional number of vacation days is enabled for this employee (defaults to yearly)",
                        max_length=16,
                        verbose_name="Extra Days Frequency",
                    ),
                ),
                (
                    "occupancy_rate",
                    models.FloatField(
                        default=1,
                        help_text="The occupation rate in percent, 100% being employed fulltime",
                        verbose_name="Occupation Rate",
                    ),
                ),
                (
                    "contract_type",
                    models.CharField(
                        choices=[("INTERNAL", "Internal"), ("EXTERNAL", "External")],
                        default="INTERNAL",
                        help_text="If Internal, the employee is considered a full-time employee and thus has employee access to the system.",
                        max_length=16,
                        verbose_name="Employee Type",
                    ),
                ),
                ("enrollment_at", models.DateField(verbose_name="Enrolled at")),
                ("disenrollment_at", models.DateField(blank=True, null=True, verbose_name="Disenroll at")),
                (
                    "calendar",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="employees",
                        to="wbhuman_resources.dayoffcalendar",
                    ),
                ),
                (
                    "direct_manager",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="managed_employees",
                        to="directory.person",
                        verbose_name="Direct Manager",
                    ),
                ),
            ],
            options={
                "verbose_name": "Employee Human Resource",
                "verbose_name_plural": "Employee Human Resources",
            },
        ),
        migrations.CreateModel(
            name="Evaluation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("evaluated_score", models.IntegerField(blank=True, null=True)),
                ("evaluated_period", django.contrib.postgres.fields.ranges.DateRangeField()),
                ("evaluation_date", models.DateField()),
                (
                    "last_update",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date of latest change (automatically computed)",
                        verbose_name="Last update",
                    ),
                ),
            ],
            options={
                "verbose_name": "Evaluation",
                "verbose_name_plural": "Evaluations",
            },
        ),
        migrations.CreateModel(
            name="Review",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                ("from_date", models.DateField(blank=True, null=True, verbose_name="From")),
                ("to_date", models.DateField(blank=True, null=True, verbose_name="To")),
                ("review_deadline", models.DateField(blank=True, null=True, verbose_name="Deadline")),
                ("review", models.DateTimeField(blank=True, null=True, verbose_name="Review Date")),
                ("auto_apply_deadline", models.BooleanField(default=True, verbose_name="Auto Apply Deadline")),
                (
                    "year",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1000),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                        verbose_name="Year",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[("ANNUAL", "Annual"), ("INTERMEDIARY", "Intermediary")],
                        default="ANNUAL",
                        max_length=32,
                        verbose_name="Type",
                    ),
                ),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[
                            ("PREPARATION_OF_REVIEW", "Stage 1: Preparation of review"),
                            ("FILL_IN_REVIEW", "Stage 2: Fill in review"),
                            ("REVIEW", "Stage 3: Review"),
                            ("EVALUATION", "Stage 4: Evalutation"),
                            ("VALIDATION", "Stage 5: Validation"),
                        ],
                        default="PREPARATION_OF_REVIEW",
                        help_text="Indicates one of the four stages defined by the workflow",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                ("is_template", models.BooleanField(default=False)),
                ("feedback_reviewee", models.TextField(blank=True, default="", verbose_name="Feedback Reviewee")),
                ("feedback_reviewer", models.TextField(blank=True, default="", verbose_name="Feedback Reviewer")),
                ("editable_mode", models.BooleanField(default=True, verbose_name="Editable table mode")),
                (
                    "signed_reviewee",
                    models.DateTimeField(blank=True, null=True, verbose_name="Date of reviewee's signature"),
                ),
                (
                    "signed_reviewer",
                    models.DateTimeField(blank=True, null=True, verbose_name="Date of reviewer's signature"),
                ),
                (
                    "completely_filled_reviewee",
                    models.DateTimeField(blank=True, null=True, verbose_name="Completely Filled Out Reviewee"),
                ),
                (
                    "completely_filled_reviewer",
                    models.DateTimeField(blank=True, null=True, verbose_name="Completely Filled Out Reviewer"),
                ),
                ("changed", models.DateTimeField(auto_now=True, null=True)),
                (
                    "moderator",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="moderator_reviews",
                        to="directory.person",
                    ),
                ),
            ],
            options={
                "verbose_name": "Review",
                "verbose_name_plural": "Reviews",
                "permissions": [
                    ("admin_review", "Can administer Reviews"),
                    ("global_review_readers", "Can view and read Review"),
                ],
            },
        ),
        migrations.CreateModel(
            name="ReviewQuestionCategory",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=255, unique=True, verbose_name="Name")),
                ("order", models.PositiveIntegerField(blank=True, null=True, verbose_name="Order")),
                ("weight", models.DecimalField(decimal_places=1, default=1.0, max_digits=16, verbose_name="Weight")),
            ],
            options={
                "verbose_name": "Review Question Category",
                "verbose_name_plural": "Review Question Categories",
            },
        ),
        migrations.CreateModel(
            name="ReviewQuestion",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                ("question", models.TextField(blank=True, default="", verbose_name="Question")),
                ("mandatory", models.BooleanField(default=True, verbose_name="Mandatory")),
                (
                    "answer_type",
                    models.CharField(
                        choices=[("TEXT", "Text"), ("RATING", "Rating")],
                        default="TEXT",
                        max_length=32,
                        verbose_name="Type",
                    ),
                ),
                ("for_reviewee", models.BooleanField(default=True, verbose_name="For Reviewee")),
                ("for_reviewer", models.BooleanField(default=True, verbose_name="For Reviewer")),
                ("for_department_peers", models.BooleanField(default=False, verbose_name="For Department Peers")),
                ("for_company_peers", models.BooleanField(default=False, verbose_name="For Company Peers")),
                ("order", models.PositiveIntegerField(blank=True, null=True, verbose_name="Order")),
                ("weight", models.DecimalField(decimal_places=1, default=1.0, max_digits=16, verbose_name="Weight")),
                (
                    "category",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="questions_related",
                        to="wbhuman_resources.reviewquestioncategory",
                        verbose_name="Category",
                    ),
                ),
                (
                    "evaluation",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="evaluation_questions",
                        to="wbhuman_resources.evaluation",
                        verbose_name="Evaluation",
                    ),
                ),
                (
                    "review",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="questions",
                        to="wbhuman_resources.review",
                        verbose_name="Review",
                    ),
                ),
            ],
            options={
                "verbose_name": "Review Question",
                "verbose_name_plural": "Review Questions",
            },
        ),
        migrations.CreateModel(
            name="ReviewGroup",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=255, verbose_name="Name")),
                ("employees", models.ManyToManyField(blank=True, related_name="reviewgroups", to="directory.person")),
            ],
            options={
                "verbose_name": "Review Group",
                "verbose_name_plural": "Review Groups",
            },
        ),
        migrations.CreateModel(
            name="ReviewAnswer",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "answered_anonymized",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Answered Anonymized"),
                ),
                (
                    "answer_number",
                    models.PositiveIntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(4),
                        ],
                        verbose_name="Rating",
                    ),
                ),
                ("answer_text", models.TextField(blank=True, null=True, verbose_name="Comment")),
                (
                    "answered_by",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="related_answers",
                        to="directory.person",
                        verbose_name="Answered By",
                    ),
                ),
                (
                    "question",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="answers",
                        to="wbhuman_resources.reviewquestion",
                        verbose_name="Question",
                    ),
                ),
            ],
            options={
                "verbose_name": "Review Answer",
                "verbose_name_plural": "Review Answers",
            },
        ),
        migrations.AddField(
            model_name="review",
            name="review_group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="review_related",
                to="wbhuman_resources.reviewgroup",
                verbose_name="Group",
            ),
        ),
        migrations.AddField(
            model_name="review",
            name="reviewee",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="reviewee_reviews",
                to="directory.person",
                verbose_name="Reviewee",
            ),
        ),
        migrations.AddField(
            model_name="review",
            name="reviewer",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="reviewer_reviews",
                to="directory.person",
                verbose_name="Reviewer",
            ),
        ),
        migrations.CreateModel(
            name="Position",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                (
                    "color",
                    colorfield.fields.ColorField(default="#FF0000", image_field=None, max_length=18, samples=None),
                ),
                ("name", models.CharField(max_length=256)),
                ("height", models.IntegerField(default=0)),
                ("is_internal", models.BooleanField(default=True, verbose_name="Internal Position")),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
                (
                    "group",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="human_resources_positions",
                        to="auth.group",
                    ),
                ),
                (
                    "manager",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="managed_positions",
                        to="directory.person",
                        verbose_name="Department Manager",
                    ),
                ),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="children",
                        to="wbhuman_resources.position",
                        verbose_name="Parent Positions",
                    ),
                ),
            ],
            options={
                "verbose_name": "Position",
                "verbose_name_plural": "Positions",
            },
        ),
        migrations.CreateModel(
            name="KPI",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=255)),
                ("goal", models.PositiveIntegerField(verbose_name="Goal")),
                ("period", django.contrib.postgres.fields.ranges.DateRangeField(verbose_name="Period")),
                (
                    "evaluated_intervals",
                    models.CharField(
                        choices=[
                            ("DAILY", "Daily"),
                            ("WEEKLY", "Weekly"),
                            ("MONTHLY", "Monthly"),
                            ("QUARTERLY", "Quarterly"),
                        ],
                        default="MONTHLY",
                        max_length=16,
                        verbose_name="Evaluated Intervals",
                    ),
                ),
                ("handler", models.CharField(max_length=255)),
                ("additional_data", models.JSONField(default=wbhuman_resources.models.kpi.default_additional_data)),
                (
                    "last_update",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date of latest change (automatically computed)",
                        verbose_name="Last update",
                    ),
                ),
                ("individual_evaluation", models.BooleanField(default=True, verbose_name="Individual Evaluation")),
                ("is_active", models.BooleanField(default=True, verbose_name="Is Active")),
                (
                    "evaluated_persons",
                    models.ManyToManyField(
                        related_name="wbhuman_resources_kpis", to="directory.person", verbose_name="Evaluated Persons"
                    ),
                ),
            ],
            options={
                "verbose_name": "Key Performance Indicator",
                "verbose_name_plural": "Key Performance Indicators",
                "permissions": [("admin_kpi", "Can administer KPI")],
            },
        ),
        migrations.AddField(
            model_name="evaluation",
            name="kpi",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="evaluations",
                to="wbhuman_resources.kpi",
                verbose_name="KPI",
            ),
        ),
        migrations.AddField(
            model_name="evaluation",
            name="person",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="wbhuman_resources_evaluations",
                to="directory.person",
            ),
        ),
        migrations.CreateModel(
            name="EmployeeYearBalance",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                ("year", models.IntegerField(verbose_name="Year")),
                (
                    "extra_balance",
                    models.FloatField(
                        default=0,
                        help_text="The yearly extra balance (in hours)",
                        verbose_name="Extra Balance (in hours)",
                    ),
                ),
                (
                    "employee",
                    models.ForeignKey(
                        help_text="The employee having that year balance",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="balances",
                        to="wbhuman_resources.employeehumanresource",
                        verbose_name="Employee",
                    ),
                ),
            ],
            options={
                "verbose_name": "Employee Year Balance",
                "verbose_name_plural": "Employee Year Balances",
            },
        ),
        migrations.CreateModel(
            name="EmployeeWeeklyOffPeriods",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("computed_str", models.CharField(blank=True, max_length=512, null=True, verbose_name="Name")),
                (
                    "weekday",
                    models.PositiveIntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(6),
                        ]
                    ),
                ),
                (
                    "employee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="default_periods_relationships",
                        to="wbhuman_resources.employeehumanresource",
                        verbose_name="Employee",
                    ),
                ),
                (
                    "period",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="employees_relationships",
                        to="wbhuman_resources.defaultdailyperiod",
                        verbose_name="Off Period",
                    ),
                ),
            ],
            options={
                "verbose_name": "Employee Weekly off Period",
                "verbose_name_plural": "Employee Weekly off Periods",
            },
        ),
        migrations.AddField(
            model_name="employeehumanresource",
            name="position",
            field=models.ForeignKey(
                blank=True,
                help_text="The position this employee belongs to",
                limit_choices_to=models.Q(("height", 0)),
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="employees",
                to="wbhuman_resources.position",
                verbose_name="Position",
            ),
        ),
        migrations.AddField(
            model_name="employeehumanresource",
            name="profile",
            field=models.OneToOneField(
                help_text="The CRM profile related to this employee",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="human_resources",
                to="directory.person",
                verbose_name="Employee",
            ),
        ),
        migrations.AddField(
            model_name="employeehumanresource",
            name="weekly_off_periods",
            field=models.ManyToManyField(
                related_name="employees_off",
                through="wbhuman_resources.EmployeeWeeklyOffPeriods",
                to="wbhuman_resources.defaultdailyperiod",
                verbose_name="Weekly off periods",
            ),
        ),
        migrations.CreateModel(
            name="DayOff",
            fields=[
                (
                    "calendaritem_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="agenda.calendaritem",
                    ),
                ),
                ("date", models.DateField(verbose_name="Date")),
                (
                    "count_as_holiday",
                    models.BooleanField(
                        default=True,
                        help_text="If true, there is no work but the day counts towards the employees' vacation balance",
                        verbose_name="Count as Holiday",
                    ),
                ),
                (
                    "calendar",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="days_off",
                        to="wbhuman_resources.dayoffcalendar",
                        verbose_name="Calendar",
                    ),
                ),
            ],
            options={
                "verbose_name": "Day Off",
                "verbose_name_plural": "Days Off",
            },
            bases=("agenda.calendaritem",),
        ),
        migrations.CreateModel(
            name="BalanceHourlyAllowance",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("period_index", models.PositiveIntegerField()),
                ("hourly_allowance", models.FloatField()),
                (
                    "balance",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="monthly_allowances",
                        to="wbhuman_resources.employeeyearbalance",
                        verbose_name="Balance",
                    ),
                ),
            ],
            options={
                "verbose_name": "Monthly Allowance",
                "verbose_name_plural": "Monthly Allowance",
            },
        ),
        migrations.CreateModel(
            name="AbsenceRequestPeriods",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("date", models.DateField()),
                ("timespan", django.contrib.postgres.fields.ranges.DateTimeRangeField(verbose_name="Timespan")),
                (
                    "consecutive_hours_count",
                    models.IntegerField(
                        default=0,
                        help_text="The number of consecutive hours this absence request period spans",
                        verbose_name="Consecutive Absence Hours count",
                    ),
                ),
                (
                    "balance",
                    models.ForeignKey(
                        blank=True,
                        help_text="For which balance this absence will count towards",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="periods",
                        to="wbhuman_resources.employeeyearbalance",
                        verbose_name="Balance",
                    ),
                ),
                (
                    "default_period",
                    models.ForeignKey(
                        help_text="The associated period",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="periods",
                        to="wbhuman_resources.defaultdailyperiod",
                        verbose_name="Period",
                    ),
                ),
                (
                    "employee",
                    models.ForeignKey(
                        help_text="The Requester",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="periods",
                        to="wbhuman_resources.employeehumanresource",
                        verbose_name="Employee",
                    ),
                ),
                (
                    "request",
                    models.ForeignKey(
                        help_text="The associated request",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="periods",
                        to="wbhuman_resources.absencerequest",
                        verbose_name="Request",
                    ),
                ),
            ],
            options={
                "verbose_name": "Absence Request Period",
                "verbose_name_plural": "Absence Request Periods",
            },
        ),
        migrations.AddField(
            model_name="absencerequest",
            name="employee",
            field=models.ForeignKey(
                help_text="The employee requesting the absence",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="requests",
                to="wbhuman_resources.employeehumanresource",
                verbose_name="Employee",
            ),
        ),
        migrations.AddField(
            model_name="absencerequest",
            name="type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="request",
                to="wbhuman_resources.absencerequesttype",
                verbose_name="Type",
            ),
        ),
        migrations.AddIndex(
            model_name="employeeyearbalance",
            index=models.Index(fields=["employee", "year"], name="wbhuman_res_employe_b6cd2e_idx"),
        ),
        migrations.AlterUniqueTogether(
            name="employeeyearbalance",
            unique_together={("employee", "year")},
        ),
        migrations.AddIndex(
            model_name="employeeweeklyoffperiods",
            index=models.Index(fields=["employee", "period", "weekday"], name="wbhuman_res_employe_248df8_idx"),
        ),
        migrations.AlterUniqueTogether(
            name="employeeweeklyoffperiods",
            unique_together={("employee", "period", "weekday")},
        ),
        migrations.AddConstraint(
            model_name="defaultdailyperiod",
            constraint=models.CheckConstraint(
                check=models.Q(("upper_time__gt", models.F("lower_time"))), name="check_lower_time_lt_upper_time"
            ),
        ),
        migrations.AddConstraint(
            model_name="defaultdailyperiod",
            constraint=django.contrib.postgres.constraints.ExclusionConstraint(
                expressions=[("timespan", "&&"), ("calendar", "=")], name="check_no_overlapping_default_periods_time"
            ),
        ),
        migrations.AddConstraint(
            model_name="dayoff",
            constraint=models.UniqueConstraint(fields=("date", "calendar"), name="unique_date_for_calendar"),
        ),
        migrations.AddIndex(
            model_name="balancehourlyallowance",
            index=models.Index(fields=["balance"], name="wbhuman_res_balance_d67ba9_idx"),
        ),
        migrations.AddIndex(
            model_name="balancehourlyallowance",
            index=models.Index(fields=["balance", "period_index"], name="wbhuman_res_balance_35163a_idx"),
        ),
        migrations.AlterUniqueTogether(
            name="balancehourlyallowance",
            unique_together={("balance", "period_index")},
        ),
        migrations.AddIndex(
            model_name="absencerequestperiods",
            index=models.Index(fields=["employee", "default_period", "date"], name="wbhuman_res_employe_5eb827_idx"),
        ),
        migrations.AddConstraint(
            model_name="absencerequestperiods",
            constraint=django.contrib.postgres.constraints.ExclusionConstraint(
                expressions=[("timespan", "&&"), ("employee", "=")], name="exclude_overlapping_periods"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="absencerequestperiods",
            unique_together={("employee", "default_period", "date")},
        ),
    ]
