# -*- coding: utf-8 -*-
# ###
# Copyright (c) 2013, Rice University
# This software is subject to the provisions of the GNU Affero General
# Public License version 3 (AGPLv3).
# See LICENCE.txt for details.
# ###

COLLECTION_METADATA = {
    u'roles': None,
    u'subjects': [u'Mathematics and Statistics', u'Science and Technology', u'OpenStax Featured'],
    u'abstract': u'<div xmlns="http://www.w3.org/1999/xhtml" xmlns:md="http://cnx.rice.edu/mdml" xmlns:c="http://cnx.rice.edu/cnxml" xmlns:qml="http://cnx.rice.edu/qml/1.0" '
                 u'xmlns:data="http://dev.w3.org/html5/spec/#custom" xmlns:bib="http://bibtexml.sf.net/" xmlns:html="http://www.w3.org/1999/xhtml" xmlns:mod="http://cnx.rice.edu/#moduleIds">'
                 u'This introductory, algebra-based, two-semester college physics book is grounded with real-world examples, illustrations, and explanations to help students grasp key, '
                 u'fundamental physics concepts. This online, fully editable and customizable title includes learning objectives, concept questions, links to labs and simulations, and ample '
                 u'practice opportunities to solve traditional physics application problems.</div>',
    u'authors': [{u'id': u'OpenStaxCollege',
                  u'fullname': u'OpenStax College',
                  u'surname': None, u'suffix': None,
                  u'firstname': u'OpenStax College', u'title': None,
                  }],
    u'created': u'2013-07-31T19:07:20Z',
    u'doctype': u'',
    u'id': u'e79ffde3-7fb4-4af3-9ec8-df648b391597',
    u'shortId': u'55_943-0',
    u'language': u'en',
    u'license': {
        u'code': u'by',
        u'version': u'4.0',
        u'name': u'Creative Commons Attribution License',
        u'url': u'http://creativecommons.org/licenses/by/4.0/',
        },
    u'licensors': [{u'surname': u'University',
                    u'firstname': u'Rice',
                    u'suffix': None,
                    u'title': None,
                    u'id': u'OSCRiceUniversity',
                    u'fullname': u'Rice University',
                    },
                   ],
    u'publishers': [{u'surname': None,
                     u'firstname': u'OpenStax College',
                     u'suffix': None,
                     u'title': None,
                     u'id': u'OpenStaxCollege',
                     u'fullname': u'OpenStax College',
                     },
                    {u'surname': u'Physics',
                     u'firstname': u'College',
                     u'suffix': None,
                     u'title': None,
                     u'id': u'cnxcap',
                     u'fullname': u'OSC Physics Maintainer',
                     }
                    ],
    u'title': u'College Physics',
    u'parentAuthors': [],
    u'parentId': None,
    u'parentTitle': None,
    u'parentVersion': '',
    u'parent': {
        u'authors': [],
        u'id': None,
        u'shortId': None,
        u'title': None,
        u'version': '',
        },
    u'revised': u'2013-08-31T19:07:20Z',
    u'stateid': 1,
    u'submitlog': u'New version 1.7',
    u'submitter': {
        u'surname': None,
        u'firstname': u'OpenStax College',
        u'suffix': None,
        u'title': None,
        u'id': u'OpenStaxCollege',
        u'fullname': u'OpenStax College',
        },
    u'mediaType': u'application/vnd.org.cnx.collection',
    u'version': u'7.1',
    u'printStyle': None,
    u'baked': None,
    u'googleAnalytics': [u'UA-XXXXX-Y'],
    u'buyLink': None,
    u'legacy_id': u'col11406',
    u'legacy_version': u'1.7',
    u'history': [
        {
            u'version': u'7.1',
            u'revised': u'2013-08-31T19:07:20Z',
            u'changes': 'New version 1.7',
            u'publisher': {
                u'surname': None,
                u'firstname': u'OpenStax College',
                u'suffix': None,
                u'title': None,
                u'id': u'OpenStaxCollege',
                u'fullname': u'OpenStax College',
                },
            },
        {
            u"version": u"6.2",
            u"revised": u"2013-08-02T01:02:23Z",
            u"changes": u"Add second collated version",
            u"publisher": {
                u"surname": None,
                u"firstname": "OpenStax College",
                u"suffix": None,
                u"title": None,
                u"id": "OpenStaxCollege",
                u"fullname": "OpenStax College",
                },
            },
        {
            u'version': u'6.1',
            u'revised': u'2013-07-31T19:07:20Z',
            u'changes': 'Updated something',
            u'publisher': {
                u'surname': None,
                u'firstname': u'OpenStax College',
                u'suffix': None,
                u'title': None,
                u'id': u'OpenStaxCollege',
                u'fullname': u'OpenStax College',
                },
            },
        ],
    u'keywords': [
        u'college physics', u'physics', u'friction', u'ac circuits',
        u'atomic physics', u'bioelectricity',
        u'biological and medical applications', u'circuits',
        u'collisions', u'dc instruments', u'drag', u'elasticity',
        u'electric charge and electric field', u'electric current',
        u'electric potential', u'electrical technologies',
        u'electromagnetic induction', u'electromagnetic waves', u'energy',
        u'fluid dynamics', u'fluid statics', u'forces', u'frontiers of physics',
        u'gas laws', u'geometric optics', u'heat and transfer methods',
        u'kinematics', u'kinetic theory', u'linear momentum', u'magnetism',
        u'medical applications of nuclear physics',
        u'Newton\u2019s Laws of Motion', u'Ohm\u2019s Law',
        u'oscillatory motion and waves', u'particle physics',
        u'physics of hearing', u'quantum physics',
        u'radioactivity and nuclear physics', u'resistance',
        u'rotational motion and angular momentum', u'special relativity',
        u'statics and torque', u'temperature', u'thermodynamics',
        u'uniform circular motion and gravitation',
        u'vision and optical instruments', u'wave optics', u'work',
        ],
    u'resources': [
        # FIXME This file probably shouldn't exist?
        {u'filename': u'collection.html',
         u'id': u'271b03b039158a5ff77937adf05f398dfc4f9929',
         u'media_type': u'text/xml',
         },
        {u'filename': u'collection.xml',
         u'id': u'271b03b039158a5ff77937adf05f398dfc4f9929',
         u'media_type': u'text/xml',
         },
        {u'filename': u'featured-cover.png',
         u'id': u'6214e8dcdf2824dbf830b4a0d77a3fa2f53608d2',
         u'media_type': u'image/png',
         },
        ],
    u'collated': False,
    u'baked': None,
    u'canonical': None,
    u'canon_url': u'http://cnx.org/contents/e79ffde3-7fb4-4af3-9ec8-df648b391597/College-Physics'
    }
COLLECTION_JSON_TREE = {
    u'id': u'e79ffde3-7fb4-4af3-9ec8-df648b391597@7.1',
    u'shortId': u'55_943-0@7.1',
    u'title': u'College Physics',
    u'contents': [
        {u'id': u'209deb1f-1a46-4369-9e0d-18674cf58a3e@7',
         u'shortId': u'IJ3rHxpG@7',
         u'title': u'Preface'},
        {u'id': u'd7eb0963-6cfa-57fe-8e18-585474e8b563@7.1',
         u'shortId': u'1-sJY2z6@7.1',
         u'title': u'Introduction: The Nature of Science and Physics',
         u'contents': [
                {u'id': u'f3c9ab70-a916-4d8c-9256-42953287b4e9@3',
                 u'shortId': u'88mrcKkW@3',
                 u'title': u'Introduction to Science and the Realm of Physics, Physical Quantities, and Units'},
                {u'id': u'd395b566-5fe3-4428-bcb2-19016e3aa3ce@4',
                 u'shortId': u'05W1Zl_j@4',
                 u'title': u'Physics: An Introduction'},
                {u'id': u'c8bdbabc-62b1-4a5f-b291-982ab25756d7@6',
                 u'shortId': u'yL26vGKx@6',
                 u'title': u'Physical Quantities and Units'},
                {u'id': u'5152cea8-829a-4aaf-bcc5-c58a416ecb66@7',
                 u'shortId': u'UVLOqIKa@7',
                 u'title': u'Accuracy, Precision, and Significant Figures'},
                {u'id': u'5838b105-41cd-4c3d-a957-3ac004a48af3@5',
                 u'shortId': u'WDixBUHN@5',
                 u'title': u'Approximation'},
                ],
         },
        {u'id': u'd17ce3fa-f871-5648-81b0-46128103d61c@7.1',
         u'shortId': u'0Xzj-vhx@7.1',
         u'title': u"Further Applications of Newton's Laws: Friction, Drag, and Elasticity",
         u'contents': [
                {u'id': u'24a2ed13-22a6-47d6-97a3-c8aa8d54ac6d@2',
                 u'shortId': u'JKLtEyKm@2',
                 u'title': u'Introduction: Further Applications of Newton\u2019s Laws'},
                {u'id': u'ea271306-f7f2-46ac-b2ec-1d80ff186a59@5',
                 u'shortId': u'6icTBvfy@5',
                 u'title': u'Friction'},
                {u'id': u'26346a42-84b9-48ad-9f6a-62303c16ad41@6',
                 u'shortId': u'JjRqQoS5@6',
                 u'title': u'Drag Forces'},
                {u'id': u'56f1c5c1-4014-450d-a477-2121e276beca@8',
                 u'shortId': u'VvHFwUAU@8',
                 u'title': u'Elasticity: Stress and Strain'},
                ],
         },
        {u'id': u'f6024d8a-1868-44c7-ab65-45419ef54881@3',
         u'shortId': u'9gJNihho@3',
         u'title': u'Atomic Masses'},
        {u'id': u'7250386b-14a7-41a2-b8bf-9e9ab872f0dc@2',
         u'shortId': u'clA4axSn@2',
         u'title': u'Selected Radioactive Isotopes'},
        {u'id': u'c0a76659-c311-405f-9a99-15c71af39325@5',
         u'shortId': u'wKdmWcMR@5',
         u'title': u'Useful Inførmation'},
        {u'id': u'ae3e18de-638d-4738-b804-dc69cd4db3a3@5',
         u'shortId': u'rj4Y3mON@5',
         u'title': u'Glossary of Key Symbols and Notation'},
        ],
    }
COLLECTION_DERIVED_METADATA = {
    u'parent': {
        u'authors': [
            {u'surname': None, u'suffix': None,
             u'firstname': u'OpenStax College',
             u'title': None, u'id': u'OpenStaxCollege',
             u'fullname': u'OpenStax College',
             }],
        u'id': u'e79ffde3-7fb4-4af3-9ec8-df648b391597',
        u'shortId': u'55_943-0',
        u'title': u'College Physics',
        u'version': u'7.1',
    },
    u'title': u'Derived Copy of College Physics'
}
MODULE_METADATA = {
    u'printStyle': None,
    u'baked': None,
    u'roles': None,
    u'subjects': [u'Science and Technology'],
    u'abstract': None,
    u'authors': [{u'id': u'OpenStaxCollege',
                  u'fullname': u'OpenStax College',
                  u'surname': None, u'suffix': None,
                  u'firstname': u'OpenStax College', u'title': None,
                  }],
    u'created': u'2013-07-31T19:07:24Z',
    u'doctype': u'',
    u'id': u'56f1c5c1-4014-450d-a477-2121e276beca',
    u'shortId': u'VvHFwUAU',
    u'language': u'en',
    u'license': {
        u'code': u'by',
        u'version': u'4.0',
        u'name': u'Creative Commons Attribution License',
        u'url': u'http://creativecommons.org/licenses/by/4.0/',
        },
    u'licensors': [{u'surname': u'University',
                    u'firstname': u'Rice',
                    u'suffix': None,
                    u'title': None,
                    u'id': u'OSCRiceUniversity',
                    u'fullname': u'Rice University',
                    },
                   ],
    u'publishers': [{u'surname': None,
                     u'firstname': u'OpenStax College',
                     u'suffix': None,
                     u'title': None,
                     u'id': u'OpenStaxCollege',
                     u'fullname': u'OpenStax College',
                     },
                    {u'surname': u'Physics',
                     u'firstname': u'College',
                     u'suffix': None,
                     u'title': None,
                     u'id': u'cnxcap',
                     u'fullname': u'OSC Physics Maintainer',
                     }
                    ],
    u'title': u'Elasticity: Stress and Strain',
    u'parentAuthors': [],
    u'parentId': None,
    u'parentTitle': None,
    u'parentVersion': '',
    u'parent': {
        u'authors': [],
        u'id': None,
        u'shortId': None,
        u'title': None,
        u'version': '',
        },
    u'revised': u'2013-07-31T19:07:24Z',
    u'stateid': 1,
    u'submitlog': u'Added more examples',
    u'submitter': {
        u'surname': None,
        u'firstname': u'OpenStax College',
        u'suffix': None,
        u'title': None,
        u'id': u'OpenStaxCollege',
        u'fullname': u'OpenStax College',
        },
    u'mediaType': u'application/vnd.org.cnx.module',
    u'version': u'8',
    u'googleAnalytics': None,
    u'buyLink': u'http://openstaxcollege.worksmartsuite.com/',
    u'legacy_id': u'm42081',
    u'legacy_version': u'1.8',
    u'history': [
        {
            u'version': u'8',
            u'revised': u'2013-07-31T19:07:24Z',
            u'changes': u'Added more examples',
            u'publisher': {
                u'surname': None,
                u'firstname': u'OpenStax College',
                u'suffix': None,
                u'title': None,
                u'id': u'OpenStaxCollege',
                u'fullname': u'OpenStax College',
                },
            },
        ],
    u'keywords': [
        u'bulk modulus', u'compression', u'deformation', u'force',
        u'Hooke\u2019s law', u'length', u'shear modulus', u'strain', u'stress',
        u'tension', u'Young\u2019s modulus', u'shear deformation',
        u'tensile strength',
        ],
    u'resources': [
            {u'filename': u'index_auto_generated.cnxml',
             u'id': u'01b0137ec023558ef05c9a7ddc275cca055f3a65',
             u'media_type': u'text/xml'},
            {u'filename': u'Figure_06_03_09a.jpg',
             u'id': u'03ab3d7bca387b142f226ea8b62e550b7a65a9e1',
             u'media_type': u'image/jpg'},
            {u'filename': u'index.cnxml.html',
             u'id': u'04e14d5e0b59a150dbdf9b0b832a8e716fc0c5ec',
             u'media_type': u'text/xml'},
            {u'filename': u'Figure_06_03_04a.jpg',
             u'id': u'191d7161e775dacea2d0c2f81fa41f0eefd65eeb',
             u'media_type': u'image/png'},
            {u'filename': u'Figure_06_03_08a.jpg',
             u'id': u'3028d78f9f9d80f035bb4899cf8aa798d3befa79',
             u'media_type': u'image/jpg'},
            {u'filename': u'Figure_06_03_06a.jpg',
             u'id': u'4b832692d2a7318172d0c3d3a5986b1dc06aa2f5',
             u'media_type': u'image/jpg'},
            {u'filename': u'Figure_06_03_05_xa.jpg',
             u'id': u'8bebb2a5642cc453cbcca70f79fb2184e2976b60',
             u'media_type': u'image/png'},
            {u'filename': u'Figure_06_03_10a.jpg',
             u'id': u'95430b74a5ee9e09037c589feb0685ee226a06b8',
             u'media_type': u'image/jpg'},
            {u'filename': u'index.cnxml',
             u'id': u'9ae3b93679f6a4db2b78454189841d8ade98e0e6',
             u'media_type': u'text/xml'},
            {u'filename': u'Figure_06_03_02a.jpg',
             u'id': u'b1504837b73dc2756173109e32344f0147c2921a',
             u'media_type': u'image/jpg'},
            {u'filename': u'Figure_06_03_01a.jpg',
             u'id': u'b1cae2957bab746ebaf065bd43f567509a446c3b',
             u'media_type': u'image/jpg'},
            {u'filename': u'Figure_06_03_03a.jpg',
             u'id': u'ff325274bcfa3be254a6cf39f86985df7ddaf294',
             u'media_type': u'image/jpg'}
            ],
    u'baked': None,
    u'canonical': None,
    u'canon_url': u'http://cnx.org/contents/56f1c5c1-4014-450d-a477-2121e276beca/Elasticity:-Stress-and-Strain'
    }
