"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeSource = exports.CodeSourceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "CodeSourceProperty", { enumerable: true, get: function () { return pai_generated_1.RosCodeSource; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::CodeSource`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosCodeSource`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-codesource
 */
class CodeSource extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosCodeSource = new pai_generated_1.RosCodeSource(this, id, {
            mountPath: props.mountPath,
            codeRepo: props.codeRepo,
            description: props.description,
            codeRepoAccessToken: props.codeRepoAccessToken,
            accessibility: props.accessibility,
            codeCommit: props.codeCommit,
            displayName: props.displayName,
            workspaceId: props.workspaceId,
            codeBranch: props.codeBranch,
            codeRepoUserName: props.codeRepoUserName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCodeSource;
        this.attrAccessibility = rosCodeSource.attrAccessibility;
        this.attrCodeBranch = rosCodeSource.attrCodeBranch;
        this.attrCodeCommit = rosCodeSource.attrCodeCommit;
        this.attrCodeRepo = rosCodeSource.attrCodeRepo;
        this.attrCodeRepoAccessToken = rosCodeSource.attrCodeRepoAccessToken;
        this.attrCodeRepoUserName = rosCodeSource.attrCodeRepoUserName;
        this.attrCodeSourcesId = rosCodeSource.attrCodeSourcesId;
        this.attrCreateTime = rosCodeSource.attrCreateTime;
        this.attrDescription = rosCodeSource.attrDescription;
        this.attrDisplayName = rosCodeSource.attrDisplayName;
        this.attrGmtModifyTime = rosCodeSource.attrGmtModifyTime;
        this.attrMountPath = rosCodeSource.attrMountPath;
        this.attrUserId = rosCodeSource.attrUserId;
        this.attrWorkspaceId = rosCodeSource.attrWorkspaceId;
    }
}
exports.CodeSource = CodeSource;
//# sourceMappingURL=data:application/json;base64,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