import * as ros from '@alicloud/ros-cdk-core';
import { RosDataset } from './pai.generated';
export { RosDataset as DatasetProperty };
/**
 * Properties for defining a `Dataset`.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-dataset
 */
export interface DatasetProps {
    /**
     * Property datasetName: The name of the dataset. The naming rules are as follows:
     * - Start with a lowercase letter, uppercase letter, number, or Chinese.
     * - Can contain an underscore (_) or a dash (-).
     * - 1~127 characters in length.
     */
    readonly datasetName: string | ros.IResolvable;
    /**
     * Property dataSourceType: The data source type. The following values are supported:
     * - OSS: Alibaba Cloud Object Storage (OSS).
     * - NAS: Alibaba cloud file storage (NAS).
     */
    readonly dataSourceType: string | ros.IResolvable;
    /**
     * Property property: The properties of the dataset. The following values are supported:
     * - FILE: FILE.
     * - DIRECTORY: folder.
     */
    readonly property: string | ros.IResolvable;
    /**
     * Property uri: The Uri configuration sample is as follows:
     * - The data source type is OSS:'oss:\/\/ bucket.endpoint\/object'
     * - The data source type is NAS:
     * The general NAS format is: 'nas:\/\/<nasfisid>.region\/subpath\/to\/dir\/';
     * CPFS1.0:'nas:\/\/<cpfs-fsid>.region\/subpath\/to\/dir \/';
     * CPFS2.0:'nas:\/\/<cpfs-fsid>.region\/<protocolserviceid>\/'.
     * CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-<8-bit ascii characters>;CPFS2.0 is cpfs-<16 ascii characters>.
     */
    readonly uri: string | ros.IResolvable;
    /**
     * Property workspaceId: The ID of the workspace where the dataset is located.
     * If this parameter is not configured, the default workspace is used. If the default workspace does not exist, an error is reported.
     */
    readonly workspaceId: string | ros.IResolvable;
    /**
     * Property accessibility: Workspace visibility. The following values are supported:
     * - PRIVATE (default): indicates that the workspace is visible to itself and the administrator.
     * - PUBLIC: The workspace is visible to all users.
     */
    readonly accessibility?: string | ros.IResolvable;
    /**
     * Property dataType: The dataset type. The default value is COMMON. The following values are supported:
     * - COMMON: COMMON.
     * - PIC: picture.
     * - TEXT: TEXT.
     * - VIDEO: VIDEO.
     * - AUDIO: AUDIO.
     */
    readonly dataType?: string | ros.IResolvable;
    /**
     * Property description: Custom descriptions of datasets to distinguish between different datasets.
     */
    readonly description?: string | ros.IResolvable;
    /**
     * Property options: The extended field, which is of the JsonString type.
     * When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
     */
    readonly options?: string | ros.IResolvable;
    /**
     * Property sourceId: The data source ID.
     * - When the SourceType is USER, SourceId can be customized.
     * - When SourceType is ITAG, that is, when the iTAG module labels the data set generated by the result, SourceId is the task ID of ITAG.
     * - When SourceType is PAI_PUBLIC_DATASET, that is, a dataset created using PAI public datasets, SourceId is empty by default.
     */
    readonly sourceId?: string | ros.IResolvable;
    /**
     * Property sourceType: The data source type. The default value is USER. The following values are supported:
     * - PAI-PUBLIC-DATASET:PAI public dataset.
     * - ITAG: The dataset generated by the iTAG module annotation result.
     * - USER: The data set registered by the USER.
     */
    readonly sourceType?: string | ros.IResolvable;
}
/**
 * Represents a `Dataset`.
 */
export interface IDataset extends ros.IResource {
    readonly props: DatasetProps;
    /**
     * Attribute Accessibility: Workspace visibility.
     */
    readonly attrAccessibility: ros.IResolvable | string;
    /**
     * Attribute CreateTime: The creation time of the resource.
     */
    readonly attrCreateTime: ros.IResolvable | string;
    /**
     * Attribute DataSourceType: The data source type.
     */
    readonly attrDataSourceType: ros.IResolvable | string;
    /**
     * Attribute DataType: The dataset type. The default value is COMMON.
     */
    readonly attrDataType: ros.IResolvable | string;
    /**
     * Attribute DatasetId: The first ID of the resource.
     */
    readonly attrDatasetId: ros.IResolvable | string;
    /**
     * Attribute DatasetName: The name of the dataset.
     */
    readonly attrDatasetName: ros.IResolvable | string;
    /**
     * Attribute Description: Custom descriptions of datasets to distinguish between different datasets.
     */
    readonly attrDescription: ros.IResolvable | string;
    /**
     * Attribute GmtModifiedTime: Update time.
     */
    readonly attrGmtModifiedTime: ros.IResolvable | string;
    /**
     * Attribute Options: The extended field, which is of the JsonString type.
     */
    readonly attrOptions: ros.IResolvable | string;
    /**
     * Attribute OwnerId: The ID of the primary account.
     */
    readonly attrOwnerId: ros.IResolvable | string;
    /**
     * Attribute Property: The properties of the dataset.
     */
    readonly attrProperty: ros.IResolvable | string;
    /**
     * Attribute SourceId: The data source ID.
     */
    readonly attrSourceId: ros.IResolvable | string;
    /**
     * Attribute SourceType: The data source type. The default value is USER.
     */
    readonly attrSourceType: ros.IResolvable | string;
    /**
     * Attribute Uri: The Uri configuration sample is as follows:.
     */
    readonly attrUri: ros.IResolvable | string;
    /**
     * Attribute UserId: The ID of the user to which the dataset belongs.
     */
    readonly attrUserId: ros.IResolvable | string;
    /**
     * Attribute WorkspaceId: The ID of the workspace where the dataset is located.
     */
    readonly attrWorkspaceId: ros.IResolvable | string;
}
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::Dataset`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDataset`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-dataset
 */
export declare class Dataset extends ros.Resource implements IDataset {
    protected scope: ros.Construct;
    protected id: string;
    readonly props: DatasetProps;
    protected enableResourcePropertyConstraint: boolean;
    /**
     * Attribute Accessibility: Workspace visibility.
     */
    readonly attrAccessibility: ros.IResolvable | string;
    /**
     * Attribute CreateTime: The creation time of the resource.
     */
    readonly attrCreateTime: ros.IResolvable | string;
    /**
     * Attribute DataSourceType: The data source type.
     */
    readonly attrDataSourceType: ros.IResolvable | string;
    /**
     * Attribute DataType: The dataset type. The default value is COMMON.
     */
    readonly attrDataType: ros.IResolvable | string;
    /**
     * Attribute DatasetId: The first ID of the resource.
     */
    readonly attrDatasetId: ros.IResolvable | string;
    /**
     * Attribute DatasetName: The name of the dataset.
     */
    readonly attrDatasetName: ros.IResolvable | string;
    /**
     * Attribute Description: Custom descriptions of datasets to distinguish between different datasets.
     */
    readonly attrDescription: ros.IResolvable | string;
    /**
     * Attribute GmtModifiedTime: Update time.
     */
    readonly attrGmtModifiedTime: ros.IResolvable | string;
    /**
     * Attribute Options: The extended field, which is of the JsonString type.
     */
    readonly attrOptions: ros.IResolvable | string;
    /**
     * Attribute OwnerId: The ID of the primary account.
     */
    readonly attrOwnerId: ros.IResolvable | string;
    /**
     * Attribute Property: The properties of the dataset.
     */
    readonly attrProperty: ros.IResolvable | string;
    /**
     * Attribute SourceId: The data source ID.
     */
    readonly attrSourceId: ros.IResolvable | string;
    /**
     * Attribute SourceType: The data source type. The default value is USER.
     */
    readonly attrSourceType: ros.IResolvable | string;
    /**
     * Attribute Uri: The Uri configuration sample is as follows:.
     */
    readonly attrUri: ros.IResolvable | string;
    /**
     * Attribute UserId: The ID of the user to which the dataset belongs.
     */
    readonly attrUserId: ros.IResolvable | string;
    /**
     * Attribute WorkspaceId: The ID of the workspace where the dataset is located.
     */
    readonly attrWorkspaceId: ros.IResolvable | string;
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope: ros.Construct, id: string, props: DatasetProps, enableResourcePropertyConstraint?: boolean);
}
