"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dataset = exports.DatasetProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "DatasetProperty", { enumerable: true, get: function () { return pai_generated_1.RosDataset; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::Dataset`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDataset`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-dataset
 */
class Dataset extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDataset = new pai_generated_1.RosDataset(this, id, {
            options: props.options,
            description: props.description,
            accessibility: props.accessibility,
            datasetName: props.datasetName,
            sourceType: props.sourceType,
            sourceId: props.sourceId,
            dataSourceType: props.dataSourceType,
            workspaceId: props.workspaceId,
            dataType: props.dataType,
            uri: props.uri,
            property: props.property,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDataset;
        this.attrAccessibility = rosDataset.attrAccessibility;
        this.attrCreateTime = rosDataset.attrCreateTime;
        this.attrDataSourceType = rosDataset.attrDataSourceType;
        this.attrDataType = rosDataset.attrDataType;
        this.attrDatasetId = rosDataset.attrDatasetId;
        this.attrDatasetName = rosDataset.attrDatasetName;
        this.attrDescription = rosDataset.attrDescription;
        this.attrGmtModifiedTime = rosDataset.attrGmtModifiedTime;
        this.attrOptions = rosDataset.attrOptions;
        this.attrOwnerId = rosDataset.attrOwnerId;
        this.attrProperty = rosDataset.attrProperty;
        this.attrSourceId = rosDataset.attrSourceId;
        this.attrSourceType = rosDataset.attrSourceType;
        this.attrUri = rosDataset.attrUri;
        this.attrUserId = rosDataset.attrUserId;
        this.attrWorkspaceId = rosDataset.attrWorkspaceId;
    }
}
exports.Dataset = Dataset;
//# sourceMappingURL=data:application/json;base64,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