import * as ros from '@alicloud/ros-cdk-core';
import { RosDatasetVersion } from './pai.generated';
export { RosDatasetVersion as DatasetVersionProperty };
/**
 * Properties for defining a `DatasetVersion`.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-datasetversion
 */
export interface DatasetVersionProps {
    /**
     * Property datasetId: The ID of the dataset.
     */
    readonly datasetId: string | ros.IResolvable;
    /**
     * Property dataSourceType: The data source type. The following values are supported:
     * - OSS: Alibaba Cloud Object Storage (OSS).
     * - NAS: Alibaba cloud file storage (NAS).
     * - CPFS
     */
    readonly dataSourceType: string | ros.IResolvable;
    /**
     * Property property: The properties of the dataset. The following values are supported:
     * - FILE: FILE.
     * - DIRECTORY: folder.
     */
    readonly property: string | ros.IResolvable;
    /**
     * Property uri: The Uri configuration sample is as follows:
     * - The data source type is OSS:'oss:\/\/bucket.endpoint\/object'
     * - The data source type is NAS:
     * The general NAS format is: 'nas:\/\/<nasfisid>.region\/subpath\/to\/dir\/';
     * CPFS1.0:'nas:\/\/<cpfs-fsid>.region\/subpath\/to\/dir \/';
     * CPFS2.0:'nas:\/\/<cpfs-fsid>.region\/<protocolserviceid>\/'.
     * CPFS1.0 and CPFS2.0 are distinguished by the format of fsid: CPFS1.0 is cpfs-<8-bit ascii characters>;CPFS2.0 is cpfs-<16 ascii characters>.
     */
    readonly uri: string | ros.IResolvable;
    /**
     * Property dataCount: The number of dataset files, in units of pieces.
     */
    readonly dataCount?: number | ros.IResolvable;
    /**
     * Property dataSize: The size of the dataset file in bytes.
     */
    readonly dataSize?: number | ros.IResolvable;
    /**
     * Property description: To create a custom description for dataset versions in order to distinguish between different versions of the dataset.
     */
    readonly description?: string | ros.IResolvable;
    /**
     * Property labels: Dataset version tag list.
     */
    readonly labels?: Array<RosDatasetVersion.LabelsProperty | ros.IResolvable> | ros.IResolvable;
    /**
     * Property options: The extended field, which is of the JsonString type.
     * When DLC uses a dataset, you can specify the default Mount path for the dataset by configuring the mountPath field.
     */
    readonly options?: string | ros.IResolvable;
    /**
     * Property sourceId: The data source ID.
     * - When the SourceType is USER, SourceId can be customized.
     * - When SourceType is ITAG, that is, when the iTAG module labels the data set generated by the result, SourceId is the task ID of ITAG.
     * - When SourceType is PAI_PUBLIC_DATASET, that is, a dataset created using PAI public datasets, SourceId is empty by default.
     */
    readonly sourceId?: string | ros.IResolvable;
    /**
     * Property sourceType: The data source type. The default value is USER. The following values are supported:
     * - PAI-PUBLIC-DATASET:PAI public dataset.
     * - ITAG: The dataset generated by the iTAG module annotation result.
     * - USER: The data set registered by the USER.
     */
    readonly sourceType?: string | ros.IResolvable;
}
/**
 * Represents a `DatasetVersion`.
 */
export interface IDatasetVersion extends ros.IResource {
    readonly props: DatasetVersionProps;
    /**
     * Attribute VersionName: Dataset version name.
     */
    readonly attrVersionName: ros.IResolvable | string;
}
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::DatasetVersion`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDatasetVersion`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-datasetversion
 */
export declare class DatasetVersion extends ros.Resource implements IDatasetVersion {
    protected scope: ros.Construct;
    protected id: string;
    readonly props: DatasetVersionProps;
    protected enableResourcePropertyConstraint: boolean;
    /**
     * Attribute VersionName: Dataset version name.
     */
    readonly attrVersionName: ros.IResolvable | string;
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope: ros.Construct, id: string, props: DatasetVersionProps, enableResourcePropertyConstraint?: boolean);
}
