"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatasetVersion = exports.DatasetVersionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "DatasetVersionProperty", { enumerable: true, get: function () { return pai_generated_1.RosDatasetVersion; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::DatasetVersion`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDatasetVersion`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-datasetversion
 */
class DatasetVersion extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDatasetVersion = new pai_generated_1.RosDatasetVersion(this, id, {
            options: props.options,
            description: props.description,
            sourceType: props.sourceType,
            sourceId: props.sourceId,
            dataSourceType: props.dataSourceType,
            dataSize: props.dataSize,
            dataCount: props.dataCount,
            labels: props.labels,
            property: props.property,
            uri: props.uri,
            datasetId: props.datasetId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDatasetVersion;
        this.attrVersionName = rosDatasetVersion.attrVersionName;
    }
}
exports.DatasetVersion = DatasetVersion;
//# sourceMappingURL=data:application/json;base64,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