"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dataset = exports.DatasetProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "DatasetProperty", { enumerable: true, get: function () { return pai_generated_1.RosDataset; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::PAI::Dataset`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDataset`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-pai-dataset
 */
class Dataset extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDataset = new pai_generated_1.RosDataset(this, id, {
            workspaceId: props.workspaceId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
            datasetId: props.datasetId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDataset;
        this.attrAccessibility = rosDataset.attrAccessibility;
        this.attrCreateTime = rosDataset.attrCreateTime;
        this.attrDataSourceType = rosDataset.attrDataSourceType;
        this.attrDataType = rosDataset.attrDataType;
        this.attrDatasetId = rosDataset.attrDatasetId;
        this.attrDatasetName = rosDataset.attrDatasetName;
        this.attrDescription = rosDataset.attrDescription;
        this.attrGmtModifiedTime = rosDataset.attrGmtModifiedTime;
        this.attrOptions = rosDataset.attrOptions;
        this.attrOwnerId = rosDataset.attrOwnerId;
        this.attrProperty = rosDataset.attrProperty;
        this.attrSourceId = rosDataset.attrSourceId;
        this.attrSourceType = rosDataset.attrSourceType;
        this.attrUri = rosDataset.attrUri;
        this.attrUserId = rosDataset.attrUserId;
        this.attrWorkspaceId = rosDataset.attrWorkspaceId;
    }
}
exports.Dataset = Dataset;
//# sourceMappingURL=data:application/json;base64,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