"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceResourceDlc = exports.WorkspaceResourceDlcProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "WorkspaceResourceDlcProperty", { enumerable: true, get: function () { return pai_generated_1.RosWorkspaceResourceDlc; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::PAI::WorkspaceResourceDlc`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosWorkspaceResourceDlc`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-pai-workspaceresourcedlc
 */
class WorkspaceResourceDlc extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosWorkspaceResourceDlc = new pai_generated_1.RosWorkspaceResourceDlc(this, id, {
            groupName: props.groupName,
            workspaceId: props.workspaceId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWorkspaceResourceDlc;
        this.attrCreateTime = rosWorkspaceResourceDlc.attrCreateTime;
        this.attrGroupName = rosWorkspaceResourceDlc.attrGroupName;
        this.attrIsDefault = rosWorkspaceResourceDlc.attrIsDefault;
        this.attrResources = rosWorkspaceResourceDlc.attrResources;
    }
}
exports.WorkspaceResourceDlc = WorkspaceResourceDlc;
//# sourceMappingURL=data:application/json;base64,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