"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceResourceFlink = exports.WorkspaceResourceFlinkProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "WorkspaceResourceFlinkProperty", { enumerable: true, get: function () { return pai_generated_1.RosWorkspaceResourceFlink; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::PAI::WorkspaceResourceFlink`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosWorkspaceResourceFlink`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-pai-workspaceresourceflink
 */
class WorkspaceResourceFlink extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosWorkspaceResourceFlink = new pai_generated_1.RosWorkspaceResourceFlink(this, id, {
            groupName: props.groupName,
            workspaceId: props.workspaceId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWorkspaceResourceFlink;
        this.attrCreateTime = rosWorkspaceResourceFlink.attrCreateTime;
        this.attrGroupName = rosWorkspaceResourceFlink.attrGroupName;
        this.attrIsDefault = rosWorkspaceResourceFlink.attrIsDefault;
        this.attrResources = rosWorkspaceResourceFlink.attrResources;
    }
}
exports.WorkspaceResourceFlink = WorkspaceResourceFlink;
//# sourceMappingURL=data:application/json;base64,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