"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceResourceMaxComputes = exports.WorkspaceResourceMaxComputesProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "WorkspaceResourceMaxComputesProperty", { enumerable: true, get: function () { return pai_generated_1.RosWorkspaceResourceMaxComputes; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::PAI::WorkspaceResourceMaxComputes`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosWorkspaceResourceMaxComputes`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-pai-workspaceresourcemaxcomputes
 */
class WorkspaceResourceMaxComputes extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosWorkspaceResourceMaxComputes = new pai_generated_1.RosWorkspaceResourceMaxComputes(this, id, {
            groupName: props.groupName,
            workspaceId: props.workspaceId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWorkspaceResourceMaxComputes;
        this.attrGroupNames = rosWorkspaceResourceMaxComputes.attrGroupNames;
        this.attrWorkspaceResourceMaxComputes = rosWorkspaceResourceMaxComputes.attrWorkspaceResourceMaxComputes;
    }
}
exports.WorkspaceResourceMaxComputes = WorkspaceResourceMaxComputes;
//# sourceMappingURL=data:application/json;base64,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