"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Experiment = exports.ExperimentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "ExperimentProperty", { enumerable: true, get: function () { return pai_generated_1.RosExperiment; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::Experiment`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosExperiment`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-experiment
 */
class Experiment extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosExperiment = new pai_generated_1.RosExperiment(this, id, {
            accessibility: props.accessibility,
            artifactUri: props.artifactUri,
            experimentName: props.experimentName,
            workspaceId: props.workspaceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosExperiment;
        this.attrAccessibility = rosExperiment.attrAccessibility;
        this.attrArtifactUri = rosExperiment.attrArtifactUri;
        this.attrCreateTime = rosExperiment.attrCreateTime;
        this.attrExperimentId = rosExperiment.attrExperimentId;
        this.attrExperimentName = rosExperiment.attrExperimentName;
        this.attrGmtModifiedTime = rosExperiment.attrGmtModifiedTime;
        this.attrLabels = rosExperiment.attrLabels;
        this.attrOwnerId = rosExperiment.attrOwnerId;
        this.attrTensorboardLogUri = rosExperiment.attrTensorboardLogUri;
        this.attrUserId = rosExperiment.attrUserId;
        this.attrWorkspaceId = rosExperiment.attrWorkspaceId;
    }
}
exports.Experiment = Experiment;
//# sourceMappingURL=data:application/json;base64,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