"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Run = exports.RunProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "RunProperty", { enumerable: true, get: function () { return pai_generated_1.RosRun; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::Run`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosRun`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-run
 */
class Run extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosRun = new pai_generated_1.RosRun(this, id, {
            experimentId: props.experimentId,
            sourceId: props.sourceId,
            sourceType: props.sourceType,
            runName: props.runName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRun;
        this.attrAccessibility = rosRun.attrAccessibility;
        this.attrCreateTime = rosRun.attrCreateTime;
        this.attrExperimentId = rosRun.attrExperimentId;
        this.attrGmtModifiedTime = rosRun.attrGmtModifiedTime;
        this.attrLabels = rosRun.attrLabels;
        this.attrMetrics = rosRun.attrMetrics;
        this.attrOwnerId = rosRun.attrOwnerId;
        this.attrParams = rosRun.attrParams;
        this.attrRunId = rosRun.attrRunId;
        this.attrRunName = rosRun.attrRunName;
        this.attrSourceId = rosRun.attrSourceId;
        this.attrSourceType = rosRun.attrSourceType;
        this.attrUserId = rosRun.attrUserId;
        this.attrWorkspaceId = rosRun.attrWorkspaceId;
    }
}
exports.Run = Run;
//# sourceMappingURL=data:application/json;base64,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