"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.ServiceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "ServiceProperty", { enumerable: true, get: function () { return pai_generated_1.RosService; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::Service`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosService`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-service
 */
class Service extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosService = new pai_generated_1.RosService(this, id, {
            develop: props.develop,
            serviceConfig: props.serviceConfig,
            labels: props.labels,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosService;
        this.attrAccessToken = rosService.attrAccessToken;
        this.attrCallerUid = rosService.attrCallerUid;
        this.attrCpu = rosService.attrCpu;
        this.attrCreateTime = rosService.attrCreateTime;
        this.attrCurrentVersion = rosService.attrCurrentVersion;
        this.attrExtraData = rosService.attrExtraData;
        this.attrGpu = rosService.attrGpu;
        this.attrImage = rosService.attrImage;
        this.attrInternetEndpoint = rosService.attrInternetEndpoint;
        this.attrIntranetEndpoint = rosService.attrIntranetEndpoint;
        this.attrLabels = rosService.attrLabels;
        this.attrLatestVersion = rosService.attrLatestVersion;
        this.attrMemory = rosService.attrMemory;
        this.attrMessage = rosService.attrMessage;
        this.attrNamespace = rosService.attrNamespace;
        this.attrParentUid = rosService.attrParentUid;
        this.attrPendingInstance = rosService.attrPendingInstance;
        this.attrReason = rosService.attrReason;
        this.attrResource = rosService.attrResource;
        this.attrResourceAlias = rosService.attrResourceAlias;
        this.attrRole = rosService.attrRole;
        this.attrRoleAttrs = rosService.attrRoleAttrs;
        this.attrRunningInstance = rosService.attrRunningInstance;
        this.attrSafetyLock = rosService.attrSafetyLock;
        this.attrServiceConfig = rosService.attrServiceConfig;
        this.attrServiceGroup = rosService.attrServiceGroup;
        this.attrServiceName = rosService.attrServiceName;
        this.attrServiceUid = rosService.attrServiceUid;
        this.attrTotalInstance = rosService.attrTotalInstance;
        this.attrUpdateTime = rosService.attrUpdateTime;
        this.attrWeight = rosService.attrWeight;
    }
}
exports.Service = Service;
//# sourceMappingURL=data:application/json;base64,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