"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workspace = exports.WorkspaceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "WorkspaceProperty", { enumerable: true, get: function () { return pai_generated_1.RosWorkspace; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::Workspace`, which is used to create a workspace.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosWorkspace`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-workspace
 */
class Workspace extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosWorkspace = new pai_generated_1.RosWorkspace(this, id, {
            description: props.description,
            displayName: props.displayName,
            workspaceName: props.workspaceName,
            envTypes: props.envTypes,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWorkspace;
        this.attrAdminNames = rosWorkspace.attrAdminNames;
        this.attrCreator = rosWorkspace.attrCreator;
        this.attrDescription = rosWorkspace.attrDescription;
        this.attrDisplayName = rosWorkspace.attrDisplayName;
        this.attrEnvTypes = rosWorkspace.attrEnvTypes;
        this.attrExtraInfos = rosWorkspace.attrExtraInfos;
        this.attrOwner = rosWorkspace.attrOwner;
        this.attrUsers = rosWorkspace.attrUsers;
        this.attrWorkspaceId = rosWorkspace.attrWorkspaceId;
        this.attrWorkspaceName = rosWorkspace.attrWorkspaceName;
    }
}
exports.Workspace = Workspace;
//# sourceMappingURL=data:application/json;base64,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