"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceResourceDlc = exports.WorkspaceResourceDlcProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "WorkspaceResourceDlcProperty", { enumerable: true, get: function () { return pai_generated_1.RosWorkspaceResourceDlc; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::WorkspaceResourceDlc`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosWorkspaceResourceDlc`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-workspaceresourcedlc
 */
class WorkspaceResourceDlc extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosWorkspaceResourceDlc = new pai_generated_1.RosWorkspaceResourceDlc(this, id, {
            isDefault: props.isDefault,
            groupName: props.groupName,
            workspaceId: props.workspaceId,
            option: props.option,
            resources: props.resources,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWorkspaceResourceDlc;
        this.attrCreateTime = rosWorkspaceResourceDlc.attrCreateTime;
        this.attrGroupName = rosWorkspaceResourceDlc.attrGroupName;
        this.attrIsDefault = rosWorkspaceResourceDlc.attrIsDefault;
        this.attrResources = rosWorkspaceResourceDlc.attrResources;
    }
}
exports.WorkspaceResourceDlc = WorkspaceResourceDlc;
//# sourceMappingURL=data:application/json;base64,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