"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceResourceMaxCompute = exports.WorkspaceResourceMaxComputeProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const pai_generated_1 = require("./pai.generated");
Object.defineProperty(exports, "WorkspaceResourceMaxComputeProperty", { enumerable: true, get: function () { return pai_generated_1.RosWorkspaceResourceMaxCompute; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::PAI::WorkspaceResourceMaxCompute`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosWorkspaceResourceMaxCompute`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-pai-workspaceresourcemaxcompute
 */
class WorkspaceResourceMaxCompute extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosWorkspaceResourceMaxCompute = new pai_generated_1.RosWorkspaceResourceMaxCompute(this, id, {
            isDefault: props.isDefault,
            groupName: props.groupName,
            workspaceId: props.workspaceId,
            option: props.option,
            resources: props.resources,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWorkspaceResourceMaxCompute;
        this.attrCreateTime = rosWorkspaceResourceMaxCompute.attrCreateTime;
        this.attrGroupName = rosWorkspaceResourceMaxCompute.attrGroupName;
        this.attrIsDefault = rosWorkspaceResourceMaxCompute.attrIsDefault;
        this.attrResources = rosWorkspaceResourceMaxCompute.attrResources;
    }
}
exports.WorkspaceResourceMaxCompute = WorkspaceResourceMaxCompute;
//# sourceMappingURL=data:application/json;base64,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