# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ModelComponentModel',
    'ModelMetric',
    'ModelMetricDatasetSummary',
    'ModelMetricLabelMetricsReport',
    'ModelMetricLabelMetricsReportConfidenceEntry',
    'ModelMetricOverallMetricsReport',
    'ModelMetricOverallMetricsReportConfidenceEntry',
    'ModelTestingDataset',
    'ModelTrainingDataset',
    'ModelValidationDataset',
    'ProcessorJobInputLocation',
    'ProcessorJobInputLocationObjectLocation',
    'ProcessorJobOutputLocation',
    'ProcessorJobProcessorConfig',
    'ProcessorJobProcessorConfigFeature',
    'GetModelComponentModelResult',
    'GetModelMetricResult',
    'GetModelMetricDatasetSummaryResult',
    'GetModelMetricLabelMetricsReportResult',
    'GetModelMetricLabelMetricsReportConfidenceEntryResult',
    'GetModelMetricOverallMetricsReportResult',
    'GetModelMetricOverallMetricsReportConfidenceEntryResult',
    'GetModelTestingDatasetResult',
    'GetModelTrainingDatasetResult',
    'GetModelValidationDatasetResult',
    'GetModelsFilterResult',
    'GetModelsModelCollectionResult',
    'GetModelsModelCollectionItemResult',
    'GetModelsModelCollectionItemComponentModelResult',
    'GetModelsModelCollectionItemMetricResult',
    'GetModelsModelCollectionItemMetricDatasetSummaryResult',
    'GetModelsModelCollectionItemMetricLabelMetricsReportResult',
    'GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult',
    'GetModelsModelCollectionItemMetricOverallMetricsReportResult',
    'GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult',
    'GetModelsModelCollectionItemTestingDatasetResult',
    'GetModelsModelCollectionItemTrainingDatasetResult',
    'GetModelsModelCollectionItemValidationDatasetResult',
    'GetProcessorJobInputLocationResult',
    'GetProcessorJobInputLocationObjectLocationResult',
    'GetProcessorJobOutputLocationResult',
    'GetProcessorJobProcessorConfigResult',
    'GetProcessorJobProcessorConfigFeatureResult',
    'GetProjectsFilterResult',
    'GetProjectsProjectCollectionResult',
    'GetProjectsProjectCollectionItemResult',
]

@pulumi.output_type
class ModelComponentModel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelId":
            suggest = "model_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelComponentModel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelComponentModel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelComponentModel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_id: Optional[builtins.str] = None):
        """
        :param builtins.str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class ModelMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetSummaries":
            suggest = "dataset_summaries"
        elif key == "labelMetricsReports":
            suggest = "label_metrics_reports"
        elif key == "modelType":
            suggest = "model_type"
        elif key == "overallMetricsReports":
            suggest = "overall_metrics_reports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_summaries: Optional[Sequence['outputs.ModelMetricDatasetSummary']] = None,
                 label_metrics_reports: Optional[Sequence['outputs.ModelMetricLabelMetricsReport']] = None,
                 model_type: Optional[builtins.str] = None,
                 overall_metrics_reports: Optional[Sequence['outputs.ModelMetricOverallMetricsReport']] = None):
        """
        :param Sequence['ModelMetricDatasetSummaryArgs'] dataset_summaries: Summary of count of samples used during model training.
        :param Sequence['ModelMetricLabelMetricsReportArgs'] label_metrics_reports: List of metrics entries per label.
        :param builtins.str model_type: The type of the Document model.
        :param Sequence['ModelMetricOverallMetricsReportArgs'] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        if dataset_summaries is not None:
            pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        if label_metrics_reports is not None:
            pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if overall_metrics_reports is not None:
            pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Optional[Sequence['outputs.ModelMetricDatasetSummary']]:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Optional[Sequence['outputs.ModelMetricLabelMetricsReport']]:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[builtins.str]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Optional[Sequence['outputs.ModelMetricOverallMetricsReport']]:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")


@pulumi.output_type
class ModelMetricDatasetSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testSampleCount":
            suggest = "test_sample_count"
        elif key == "trainingSampleCount":
            suggest = "training_sample_count"
        elif key == "validationSampleCount":
            suggest = "validation_sample_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetricDatasetSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetricDatasetSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetricDatasetSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 test_sample_count: Optional[builtins.int] = None,
                 training_sample_count: Optional[builtins.int] = None,
                 validation_sample_count: Optional[builtins.int] = None):
        """
        :param builtins.int test_sample_count: Number of samples used for testing the model.
        :param builtins.int training_sample_count: Number of samples used for training the model.
        :param builtins.int validation_sample_count: Number of samples used for validating the model.
        """
        if test_sample_count is not None:
            pulumi.set(__self__, "test_sample_count", test_sample_count)
        if training_sample_count is not None:
            pulumi.set(__self__, "training_sample_count", training_sample_count)
        if validation_sample_count is not None:
            pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> Optional[builtins.int]:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> Optional[builtins.int]:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> Optional[builtins.int]:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")


@pulumi.output_type
class ModelMetricLabelMetricsReport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceEntries":
            suggest = "confidence_entries"
        elif key == "documentCount":
            suggest = "document_count"
        elif key == "meanAveragePrecision":
            suggest = "mean_average_precision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetricLabelMetricsReport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetricLabelMetricsReport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetricLabelMetricsReport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_entries: Optional[Sequence['outputs.ModelMetricLabelMetricsReportConfidenceEntry']] = None,
                 document_count: Optional[builtins.int] = None,
                 label: Optional[builtins.str] = None,
                 mean_average_precision: Optional[builtins.float] = None):
        """
        :param Sequence['ModelMetricLabelMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param builtins.int document_count: Total test documents in the label.
        :param builtins.str label: Label name
        :param builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[Sequence['outputs.ModelMetricLabelMetricsReportConfidenceEntry']]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[builtins.int]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter
    def label(self) -> Optional[builtins.str]:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[builtins.float]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class ModelMetricLabelMetricsReportConfidenceEntry(dict):
    def __init__(__self__, *,
                 accuracy: Optional[builtins.float] = None,
                 f1score: Optional[builtins.float] = None,
                 precision: Optional[builtins.float] = None,
                 recall: Optional[builtins.float] = None,
                 threshold: Optional[builtins.float] = None):
        """
        :param builtins.float accuracy: accuracy under the threshold
        :param builtins.float f1score: f1Score under the threshold
        :param builtins.float precision: Precision under the threshold
        :param builtins.float recall: Recall under the threshold
        :param builtins.float threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[builtins.float]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> Optional[builtins.float]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> Optional[builtins.float]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> Optional[builtins.float]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[builtins.float]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ModelMetricOverallMetricsReport(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceEntries":
            suggest = "confidence_entries"
        elif key == "documentCount":
            suggest = "document_count"
        elif key == "meanAveragePrecision":
            suggest = "mean_average_precision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelMetricOverallMetricsReport. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelMetricOverallMetricsReport.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelMetricOverallMetricsReport.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_entries: Optional[Sequence['outputs.ModelMetricOverallMetricsReportConfidenceEntry']] = None,
                 document_count: Optional[builtins.int] = None,
                 mean_average_precision: Optional[builtins.float] = None):
        """
        :param Sequence['ModelMetricOverallMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param builtins.int document_count: Total test documents in the label.
        :param builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        if confidence_entries is not None:
            pulumi.set(__self__, "confidence_entries", confidence_entries)
        if document_count is not None:
            pulumi.set(__self__, "document_count", document_count)
        if mean_average_precision is not None:
            pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Optional[Sequence['outputs.ModelMetricOverallMetricsReportConfidenceEntry']]:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> Optional[builtins.int]:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> Optional[builtins.float]:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class ModelMetricOverallMetricsReportConfidenceEntry(dict):
    def __init__(__self__, *,
                 accuracy: Optional[builtins.float] = None,
                 f1score: Optional[builtins.float] = None,
                 precision: Optional[builtins.float] = None,
                 recall: Optional[builtins.float] = None,
                 threshold: Optional[builtins.float] = None):
        """
        :param builtins.float accuracy: accuracy under the threshold
        :param builtins.float f1score: f1Score under the threshold
        :param builtins.float precision: Precision under the threshold
        :param builtins.float recall: Recall under the threshold
        :param builtins.float threshold: Threshold used to calculate precision and recall.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if f1score is not None:
            pulumi.set(__self__, "f1score", f1score)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[builtins.float]:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> Optional[builtins.float]:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> Optional[builtins.float]:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> Optional[builtins.float]:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[builtins.float]:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class ModelTestingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: builtins.str,
                 bucket: Optional[builtins.str] = None,
                 dataset_id: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 object: Optional[builtins.str] = None):
        """
        :param builtins.str dataset_type: The dataset type, based on where it is stored.
        :param builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[builtins.str]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[builtins.str]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ModelTrainingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTrainingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: builtins.str,
                 bucket: Optional[builtins.str] = None,
                 dataset_id: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 object: Optional[builtins.str] = None):
        """
        :param builtins.str dataset_type: The dataset type, based on where it is stored.
        :param builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[builtins.str]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[builtins.str]:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ModelValidationDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelValidationDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelValidationDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelValidationDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: builtins.str,
                 bucket: Optional[builtins.str] = None,
                 dataset_id: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 object: Optional[builtins.str] = None):
        """
        :param builtins.str dataset_type: The dataset type, based on where it is stored.
        :param builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param builtins.str object: The object name of the input data file.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[builtins.str]:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[builtins.str]:
        """
        The object name of the input data file.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ProcessorJobInputLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceType":
            suggest = "source_type"
        elif key == "objectLocations":
            suggest = "object_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobInputLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobInputLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobInputLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_type: builtins.str,
                 data: Optional[builtins.str] = None,
                 object_locations: Optional[Sequence['outputs.ProcessorJobInputLocationObjectLocation']] = None):
        """
        :param builtins.str source_type: The type of input location. The allowed values are:
               * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
               * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        :param builtins.str data: Raw document data with Base64 encoding.
        :param Sequence['ProcessorJobInputLocationObjectLocationArgs'] object_locations: The list of ObjectLocations.
        """
        pulumi.set(__self__, "source_type", source_type)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if object_locations is not None:
            pulumi.set(__self__, "object_locations", object_locations)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def data(self) -> Optional[builtins.str]:
        """
        Raw document data with Base64 encoding.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Optional[Sequence['outputs.ProcessorJobInputLocationObjectLocation']]:
        """
        The list of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")


@pulumi.output_type
class ProcessorJobInputLocationObjectLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 namespace: Optional[builtins.str] = None,
                 object: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: The Object Storage bucket name.
        :param builtins.str namespace: The Object Storage namespace name.
        :param builtins.str object: The Object Storage object name.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The Object Storage namespace name.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[builtins.str]:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ProcessorJobOutputLocation(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 namespace: builtins.str,
                 prefix: builtins.str):
        """
        :param builtins.str bucket: The Object Storage bucket name.
        :param builtins.str namespace: The Object Storage namespace.
        :param builtins.str prefix: The Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        """
        The Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class ProcessorJobProcessorConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processorType":
            suggest = "processor_type"
        elif key == "documentType":
            suggest = "document_type"
        elif key == "isZipOutputEnabled":
            suggest = "is_zip_output_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobProcessorConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobProcessorConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobProcessorConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 features: Sequence['outputs.ProcessorJobProcessorConfigFeature'],
                 processor_type: builtins.str,
                 document_type: Optional[builtins.str] = None,
                 is_zip_output_enabled: Optional[builtins.bool] = None,
                 language: Optional[builtins.str] = None):
        """
        :param Sequence['ProcessorJobProcessorConfigFeatureArgs'] features: The types of document analysis requested.
        :param builtins.str processor_type: The type of the processor.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param builtins.str document_type: The document type.
        :param builtins.bool is_zip_output_enabled: Whether or not to generate a ZIP file containing the results.
        :param builtins.str language: The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "processor_type", processor_type)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if is_zip_output_enabled is not None:
            pulumi.set(__self__, "is_zip_output_enabled", is_zip_output_enabled)
        if language is not None:
            pulumi.set(__self__, "language", language)

    @property
    @pulumi.getter
    def features(self) -> Sequence['outputs.ProcessorJobProcessorConfigFeature']:
        """
        The types of document analysis requested.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> builtins.str:
        """
        The type of the processor.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "processor_type")

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional[builtins.str]:
        """
        The document type.
        """
        return pulumi.get(self, "document_type")

    @property
    @pulumi.getter(name="isZipOutputEnabled")
    def is_zip_output_enabled(self) -> Optional[builtins.bool]:
        """
        Whether or not to generate a ZIP file containing the results.
        """
        return pulumi.get(self, "is_zip_output_enabled")

    @property
    @pulumi.getter
    def language(self) -> Optional[builtins.str]:
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        return pulumi.get(self, "language")


@pulumi.output_type
class ProcessorJobProcessorConfigFeature(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "featureType":
            suggest = "feature_type"
        elif key == "generateSearchablePdf":
            suggest = "generate_searchable_pdf"
        elif key == "maxResults":
            suggest = "max_results"
        elif key == "modelId":
            suggest = "model_id"
        elif key == "tenancyId":
            suggest = "tenancy_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProcessorJobProcessorConfigFeature. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProcessorJobProcessorConfigFeature.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProcessorJobProcessorConfigFeature.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature_type: builtins.str,
                 generate_searchable_pdf: Optional[builtins.bool] = None,
                 max_results: Optional[builtins.int] = None,
                 model_id: Optional[builtins.str] = None,
                 tenancy_id: Optional[builtins.str] = None):
        """
        :param builtins.str feature_type: The type of document analysis requested. The allowed values are:
               * `LANGUAGE_CLASSIFICATION`: Detect the language.
               * `TEXT_EXTRACTION`: Recognize text.
               * `TABLE_EXTRACTION`: Detect and extract data in tables.
               * `KEY_VALUE_EXTRACTION`: Extract form fields.
               * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        :param builtins.bool generate_searchable_pdf: Whether or not to generate a searchable PDF file.
        :param builtins.int max_results: The maximum number of results to return.
        :param builtins.str model_id: The custom model ID.
        :param builtins.str tenancy_id: The custom model tenancy ID when modelId represents aliasName.
        """
        pulumi.set(__self__, "feature_type", feature_type)
        if generate_searchable_pdf is not None:
            pulumi.set(__self__, "generate_searchable_pdf", generate_searchable_pdf)
        if max_results is not None:
            pulumi.set(__self__, "max_results", max_results)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> builtins.str:
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        """
        return pulumi.get(self, "feature_type")

    @property
    @pulumi.getter(name="generateSearchablePdf")
    def generate_searchable_pdf(self) -> Optional[builtins.bool]:
        """
        Whether or not to generate a searchable PDF file.
        """
        return pulumi.get(self, "generate_searchable_pdf")

    @property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> Optional[builtins.int]:
        """
        The maximum number of results to return.
        """
        return pulumi.get(self, "max_results")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[builtins.str]:
        """
        The custom model ID.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[builtins.str]:
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
        return pulumi.get(self, "tenancy_id")


@pulumi.output_type
class GetModelComponentModelResult(dict):
    def __init__(__self__, *,
                 model_id: builtins.str):
        """
        :param builtins.str model_id: A unique model identifier.
        """
        pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> builtins.str:
        """
        A unique model identifier.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class GetModelMetricResult(dict):
    def __init__(__self__, *,
                 dataset_summaries: Sequence['outputs.GetModelMetricDatasetSummaryResult'],
                 label_metrics_reports: Sequence['outputs.GetModelMetricLabelMetricsReportResult'],
                 model_type: builtins.str,
                 overall_metrics_reports: Sequence['outputs.GetModelMetricOverallMetricsReportResult']):
        """
        :param Sequence['GetModelMetricDatasetSummaryArgs'] dataset_summaries: Summary of count of samples used during model training.
        :param Sequence['GetModelMetricLabelMetricsReportArgs'] label_metrics_reports: List of metrics entries per label.
        :param builtins.str model_type: The type of the Document model.
        :param Sequence['GetModelMetricOverallMetricsReportArgs'] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Sequence['outputs.GetModelMetricDatasetSummaryResult']:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Sequence['outputs.GetModelMetricLabelMetricsReportResult']:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> builtins.str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Sequence['outputs.GetModelMetricOverallMetricsReportResult']:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")


@pulumi.output_type
class GetModelMetricDatasetSummaryResult(dict):
    def __init__(__self__, *,
                 test_sample_count: builtins.int,
                 training_sample_count: builtins.int,
                 validation_sample_count: builtins.int):
        """
        :param builtins.int test_sample_count: Number of samples used for testing the model.
        :param builtins.int training_sample_count: Number of samples used for training the model.
        :param builtins.int validation_sample_count: Number of samples used for validating the model.
        """
        pulumi.set(__self__, "test_sample_count", test_sample_count)
        pulumi.set(__self__, "training_sample_count", training_sample_count)
        pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> builtins.int:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> builtins.int:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> builtins.int:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")


@pulumi.output_type
class GetModelMetricLabelMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelMetricLabelMetricsReportConfidenceEntryResult'],
                 document_count: builtins.int,
                 label: builtins.str,
                 mean_average_precision: builtins.float):
        """
        :param Sequence['GetModelMetricLabelMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param builtins.int document_count: Total test documents in the label.
        :param builtins.str label: Label name
        :param builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelMetricLabelMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> builtins.int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> builtins.float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelMetricLabelMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: builtins.float,
                 f1score: builtins.float,
                 precision: builtins.float,
                 recall: builtins.float,
                 threshold: builtins.float):
        """
        :param builtins.float accuracy: accuracy under the threshold
        :param builtins.float f1score: f1Score under the threshold
        :param builtins.float precision: Precision under the threshold
        :param builtins.float recall: Recall under the threshold
        :param builtins.float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> builtins.float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> builtins.float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> builtins.float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> builtins.float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelMetricOverallMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelMetricOverallMetricsReportConfidenceEntryResult'],
                 document_count: builtins.int,
                 mean_average_precision: builtins.float):
        """
        :param Sequence['GetModelMetricOverallMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param builtins.int document_count: Total test documents in the label.
        :param builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelMetricOverallMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> builtins.int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> builtins.float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelMetricOverallMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: builtins.float,
                 f1score: builtins.float,
                 precision: builtins.float,
                 recall: builtins.float,
                 threshold: builtins.float):
        """
        :param builtins.float accuracy: accuracy under the threshold
        :param builtins.float f1score: f1Score under the threshold
        :param builtins.float precision: Precision under the threshold
        :param builtins.float recall: Recall under the threshold
        :param builtins.float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> builtins.float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> builtins.float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> builtins.float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> builtins.float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelTestingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str):
        """
        :param builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param builtins.str dataset_type: The dataset type, based on where it is stored.
        :param builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str):
        """
        :param builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param builtins.str dataset_type: The dataset type, based on where it is stored.
        :param builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelValidationDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str):
        """
        :param builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param builtins.str dataset_type: The dataset type, based on where it is stored.
        :param builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelsModelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetModelsModelCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetModelsModelCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetModelsModelCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 component_models: Sequence['outputs.GetModelsModelCollectionItemComponentModelResult'],
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_composed_model: builtins.bool,
                 is_quick_mode: builtins.bool,
                 labels: Sequence[builtins.str],
                 lifecycle_details: builtins.str,
                 max_training_time_in_hours: builtins.float,
                 metrics: Sequence['outputs.GetModelsModelCollectionItemMetricResult'],
                 model_id: builtins.str,
                 model_type: builtins.str,
                 model_version: builtins.str,
                 project_id: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 tenancy_id: builtins.str,
                 testing_datasets: Sequence['outputs.GetModelsModelCollectionItemTestingDatasetResult'],
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 trained_time_in_hours: builtins.float,
                 training_datasets: Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult'],
                 validation_datasets: Sequence['outputs.GetModelsModelCollectionItemValidationDatasetResult']):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Sequence['GetModelsModelCollectionItemComponentModelArgs'] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) collection of active custom Key Value models that need to be composed.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param builtins.str description: An optional description of the model.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param builtins.str id: The filter to find the model with the given identifier.
        :param builtins.bool is_composed_model: Set to true when the model is created by using multiple key value extraction models.
        :param builtins.bool is_quick_mode: Set to true when experimenting with a new model type or dataset, so model training is quick, with a predefined low number of passes through the training data.
        :param Sequence[builtins.str] labels: The collection of labels used to train the custom model.
        :param builtins.str lifecycle_details: A message describing the current state in more detail, that can provide actionable information if training failed.
        :param builtins.float max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param Sequence['GetModelsModelCollectionItemMetricArgs'] metrics: Trained Model Metrics.
        :param builtins.str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        :param builtins.str model_type: The type of the Document model.
        :param builtins.str model_version: The version of the model.
        :param builtins.str project_id: The ID of the project for which to list the objects.
        :param builtins.str state: The filter to match models with the given lifecycleState.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param builtins.str tenancy_id: The tenancy id of the model.
        :param Sequence['GetModelsModelCollectionItemTestingDatasetArgs'] testing_datasets: The base entity which is the input for creating and training a model.
        :param builtins.str time_created: When the model was created, as an RFC3339 datetime string.
        :param builtins.str time_updated: When the model was updated, as an RFC3339 datetime string.
        :param builtins.float trained_time_in_hours: The total hours actually used for model training.
        :param Sequence['GetModelsModelCollectionItemTrainingDatasetArgs'] training_datasets: The base entity which is the input for creating and training a model.
        :param Sequence['GetModelsModelCollectionItemValidationDatasetArgs'] validation_datasets: The base entity which is the input for creating and training a model.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "component_models", component_models)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_composed_model", is_composed_model)
        pulumi.set(__self__, "is_quick_mode", is_quick_mode)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "max_training_time_in_hours", max_training_time_in_hours)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "model_version", model_version)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "testing_datasets", testing_datasets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "trained_time_in_hours", trained_time_in_hours)
        pulumi.set(__self__, "training_datasets", training_datasets)
        pulumi.set(__self__, "validation_datasets", validation_datasets)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentModels")
    def component_models(self) -> Sequence['outputs.GetModelsModelCollectionItemComponentModelResult']:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) collection of active custom Key Value models that need to be composed.
        """
        return pulumi.get(self, "component_models")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        An optional description of the model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The filter to find the model with the given identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isComposedModel")
    def is_composed_model(self) -> builtins.bool:
        """
        Set to true when the model is created by using multiple key value extraction models.
        """
        return pulumi.get(self, "is_composed_model")

    @property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> builtins.bool:
        """
        Set to true when experimenting with a new model type or dataset, so model training is quick, with a predefined low number of passes through the training data.
        """
        return pulumi.get(self, "is_quick_mode")

    @property
    @pulumi.getter
    def labels(self) -> Sequence[builtins.str]:
        """
        The collection of labels used to train the custom model.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail, that can provide actionable information if training failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxTrainingTimeInHours")
    def max_training_time_in_hours(self) -> builtins.float:
        """
        The maximum model training time in hours, expressed as a decimal fraction.
        """
        return pulumi.get(self, "max_training_time_in_hours")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricResult']:
        """
        Trained Model Metrics.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> builtins.str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> builtins.str:
        """
        The version of the model.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The filter to match models with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> builtins.str:
        """
        The tenancy id of the model.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="testingDatasets")
    def testing_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTestingDatasetResult']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "testing_datasets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        When the model was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trainedTimeInHours")
    def trained_time_in_hours(self) -> builtins.float:
        """
        The total hours actually used for model training.
        """
        return pulumi.get(self, "trained_time_in_hours")

    @property
    @pulumi.getter(name="trainingDatasets")
    def training_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "training_datasets")

    @property
    @pulumi.getter(name="validationDatasets")
    def validation_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemValidationDatasetResult']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "validation_datasets")


@pulumi.output_type
class GetModelsModelCollectionItemComponentModelResult(dict):
    def __init__(__self__, *,
                 model_id: builtins.str):
        """
        :param builtins.str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        pulumi.set(__self__, "model_id", model_id)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of active custom Key Value model that need to be composed.
        """
        return pulumi.get(self, "model_id")


@pulumi.output_type
class GetModelsModelCollectionItemMetricResult(dict):
    def __init__(__self__, *,
                 dataset_summaries: Sequence['outputs.GetModelsModelCollectionItemMetricDatasetSummaryResult'],
                 label_metrics_reports: Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportResult'],
                 model_type: builtins.str,
                 overall_metrics_reports: Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportResult']):
        """
        :param Sequence['GetModelsModelCollectionItemMetricDatasetSummaryArgs'] dataset_summaries: Summary of count of samples used during model training.
        :param Sequence['GetModelsModelCollectionItemMetricLabelMetricsReportArgs'] label_metrics_reports: List of metrics entries per label.
        :param builtins.str model_type: The type of the Document model.
        :param Sequence['GetModelsModelCollectionItemMetricOverallMetricsReportArgs'] overall_metrics_reports: Overall Metrics report for Document Classification Model.
        """
        pulumi.set(__self__, "dataset_summaries", dataset_summaries)
        pulumi.set(__self__, "label_metrics_reports", label_metrics_reports)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "overall_metrics_reports", overall_metrics_reports)

    @property
    @pulumi.getter(name="datasetSummaries")
    def dataset_summaries(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricDatasetSummaryResult']:
        """
        Summary of count of samples used during model training.
        """
        return pulumi.get(self, "dataset_summaries")

    @property
    @pulumi.getter(name="labelMetricsReports")
    def label_metrics_reports(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportResult']:
        """
        List of metrics entries per label.
        """
        return pulumi.get(self, "label_metrics_reports")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> builtins.str:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="overallMetricsReports")
    def overall_metrics_reports(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportResult']:
        """
        Overall Metrics report for Document Classification Model.
        """
        return pulumi.get(self, "overall_metrics_reports")


@pulumi.output_type
class GetModelsModelCollectionItemMetricDatasetSummaryResult(dict):
    def __init__(__self__, *,
                 test_sample_count: builtins.int,
                 training_sample_count: builtins.int,
                 validation_sample_count: builtins.int):
        """
        :param builtins.int test_sample_count: Number of samples used for testing the model.
        :param builtins.int training_sample_count: Number of samples used for training the model.
        :param builtins.int validation_sample_count: Number of samples used for validating the model.
        """
        pulumi.set(__self__, "test_sample_count", test_sample_count)
        pulumi.set(__self__, "training_sample_count", training_sample_count)
        pulumi.set(__self__, "validation_sample_count", validation_sample_count)

    @property
    @pulumi.getter(name="testSampleCount")
    def test_sample_count(self) -> builtins.int:
        """
        Number of samples used for testing the model.
        """
        return pulumi.get(self, "test_sample_count")

    @property
    @pulumi.getter(name="trainingSampleCount")
    def training_sample_count(self) -> builtins.int:
        """
        Number of samples used for training the model.
        """
        return pulumi.get(self, "training_sample_count")

    @property
    @pulumi.getter(name="validationSampleCount")
    def validation_sample_count(self) -> builtins.int:
        """
        Number of samples used for validating the model.
        """
        return pulumi.get(self, "validation_sample_count")


@pulumi.output_type
class GetModelsModelCollectionItemMetricLabelMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult'],
                 document_count: builtins.int,
                 label: builtins.str,
                 mean_average_precision: builtins.float):
        """
        :param Sequence['GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param builtins.int document_count: Total test documents in the label.
        :param builtins.str label: Label name
        :param builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> builtins.int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Label name
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> builtins.float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelsModelCollectionItemMetricLabelMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: builtins.float,
                 f1score: builtins.float,
                 precision: builtins.float,
                 recall: builtins.float,
                 threshold: builtins.float):
        """
        :param builtins.float accuracy: accuracy under the threshold
        :param builtins.float f1score: f1Score under the threshold
        :param builtins.float precision: Precision under the threshold
        :param builtins.float recall: Recall under the threshold
        :param builtins.float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> builtins.float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> builtins.float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> builtins.float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> builtins.float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelsModelCollectionItemMetricOverallMetricsReportResult(dict):
    def __init__(__self__, *,
                 confidence_entries: Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult'],
                 document_count: builtins.int,
                 mean_average_precision: builtins.float):
        """
        :param Sequence['GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryArgs'] confidence_entries: List of document classification confidence report.
        :param builtins.int document_count: Total test documents in the label.
        :param builtins.float mean_average_precision: Mean average precision under different thresholds
        """
        pulumi.set(__self__, "confidence_entries", confidence_entries)
        pulumi.set(__self__, "document_count", document_count)
        pulumi.set(__self__, "mean_average_precision", mean_average_precision)

    @property
    @pulumi.getter(name="confidenceEntries")
    def confidence_entries(self) -> Sequence['outputs.GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult']:
        """
        List of document classification confidence report.
        """
        return pulumi.get(self, "confidence_entries")

    @property
    @pulumi.getter(name="documentCount")
    def document_count(self) -> builtins.int:
        """
        Total test documents in the label.
        """
        return pulumi.get(self, "document_count")

    @property
    @pulumi.getter(name="meanAveragePrecision")
    def mean_average_precision(self) -> builtins.float:
        """
        Mean average precision under different thresholds
        """
        return pulumi.get(self, "mean_average_precision")


@pulumi.output_type
class GetModelsModelCollectionItemMetricOverallMetricsReportConfidenceEntryResult(dict):
    def __init__(__self__, *,
                 accuracy: builtins.float,
                 f1score: builtins.float,
                 precision: builtins.float,
                 recall: builtins.float,
                 threshold: builtins.float):
        """
        :param builtins.float accuracy: accuracy under the threshold
        :param builtins.float f1score: f1Score under the threshold
        :param builtins.float precision: Precision under the threshold
        :param builtins.float recall: Recall under the threshold
        :param builtins.float threshold: Threshold used to calculate precision and recall.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "f1score", f1score)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def accuracy(self) -> builtins.float:
        """
        accuracy under the threshold
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter
    def f1score(self) -> builtins.float:
        """
        f1Score under the threshold
        """
        return pulumi.get(self, "f1score")

    @property
    @pulumi.getter
    def precision(self) -> builtins.float:
        """
        Precision under the threshold
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> builtins.float:
        """
        Recall under the threshold
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.float:
        """
        Threshold used to calculate precision and recall.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetModelsModelCollectionItemTestingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str):
        """
        :param builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param builtins.str dataset_type: The dataset type, based on where it is stored.
        :param builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsModelCollectionItemTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str):
        """
        :param builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param builtins.str dataset_type: The dataset type, based on where it is stored.
        :param builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsModelCollectionItemValidationDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str):
        """
        :param builtins.str bucket: The name of the Object Storage bucket that contains the input data file.
        :param builtins.str dataset_id: OCID of the Data Labeling dataset.
        :param builtins.str dataset_type: The dataset type, based on where it is stored.
        :param builtins.str namespace: The namespace name of the Object Storage bucket that contains the input data file.
        :param builtins.str object: The object name of the input data file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        OCID of the Data Labeling dataset.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        The dataset type, based on where it is stored.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace name of the Object Storage bucket that contains the input data file.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The object name of the input data file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetProcessorJobInputLocationResult(dict):
    def __init__(__self__, *,
                 data: builtins.str,
                 object_locations: Sequence['outputs.GetProcessorJobInputLocationObjectLocationResult'],
                 source_type: builtins.str):
        """
        :param builtins.str data: Raw document data with Base64 encoding.
        :param Sequence['GetProcessorJobInputLocationObjectLocationArgs'] object_locations: The list of ObjectLocations.
        :param builtins.str source_type: The type of input location. The allowed values are:
               * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
               * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "object_locations", object_locations)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter
    def data(self) -> builtins.str:
        """
        Raw document data with Base64 encoding.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="objectLocations")
    def object_locations(self) -> Sequence['outputs.GetProcessorJobInputLocationObjectLocationResult']:
        """
        The list of ObjectLocations.
        """
        return pulumi.get(self, "object_locations")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The type of input location. The allowed values are:
        * `OBJECT_STORAGE_LOCATIONS`: A list of object locations in Object Storage.
        * `INLINE_DOCUMENT_CONTENT`: The content of an inline document.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetProcessorJobInputLocationObjectLocationResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 namespace: builtins.str,
                 object: builtins.str):
        """
        :param builtins.str bucket: The Object Storage bucket name.
        :param builtins.str namespace: The Object Storage namespace.
        :param builtins.str object: The Object Storage object name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetProcessorJobOutputLocationResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 namespace: builtins.str,
                 prefix: builtins.str):
        """
        :param builtins.str bucket: The Object Storage bucket name.
        :param builtins.str namespace: The Object Storage namespace.
        :param builtins.str prefix: The Object Storage folder name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        """
        The Object Storage folder name.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetProcessorJobProcessorConfigResult(dict):
    def __init__(__self__, *,
                 document_type: builtins.str,
                 features: Sequence['outputs.GetProcessorJobProcessorConfigFeatureResult'],
                 is_zip_output_enabled: builtins.bool,
                 language: builtins.str,
                 processor_type: builtins.str):
        """
        :param builtins.str document_type: The document type.
        :param Sequence['GetProcessorJobProcessorConfigFeatureArgs'] features: The types of document analysis requested.
        :param builtins.bool is_zip_output_enabled: Whether or not to generate a ZIP file containing the results.
        :param builtins.str language: The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        :param builtins.str processor_type: The type of the processor.
        """
        pulumi.set(__self__, "document_type", document_type)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "is_zip_output_enabled", is_zip_output_enabled)
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "processor_type", processor_type)

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> builtins.str:
        """
        The document type.
        """
        return pulumi.get(self, "document_type")

    @property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GetProcessorJobProcessorConfigFeatureResult']:
        """
        The types of document analysis requested.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="isZipOutputEnabled")
    def is_zip_output_enabled(self) -> builtins.bool:
        """
        Whether or not to generate a ZIP file containing the results.
        """
        return pulumi.get(self, "is_zip_output_enabled")

    @property
    @pulumi.getter
    def language(self) -> builtins.str:
        """
        The document language, abbreviated according to the BCP 47 Language-Tag syntax.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> builtins.str:
        """
        The type of the processor.
        """
        return pulumi.get(self, "processor_type")


@pulumi.output_type
class GetProcessorJobProcessorConfigFeatureResult(dict):
    def __init__(__self__, *,
                 feature_type: builtins.str,
                 generate_searchable_pdf: builtins.bool,
                 max_results: builtins.int,
                 model_id: builtins.str,
                 tenancy_id: builtins.str):
        """
        :param builtins.str feature_type: The type of document analysis requested. The allowed values are:
               * `LANGUAGE_CLASSIFICATION`: Detect the language.
               * `TEXT_EXTRACTION`: Recognize text.
               * `TABLE_EXTRACTION`: Detect and extract data in tables.
               * `KEY_VALUE_EXTRACTION`: Extract form fields.
               * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        :param builtins.bool generate_searchable_pdf: Whether or not to generate a searchable PDF file.
        :param builtins.int max_results: The maximum number of results to return.
        :param builtins.str model_id: The custom model ID.
        :param builtins.str tenancy_id: The custom model tenancy ID when modelId represents aliasName.
        """
        pulumi.set(__self__, "feature_type", feature_type)
        pulumi.set(__self__, "generate_searchable_pdf", generate_searchable_pdf)
        pulumi.set(__self__, "max_results", max_results)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter(name="featureType")
    def feature_type(self) -> builtins.str:
        """
        The type of document analysis requested. The allowed values are:
        * `LANGUAGE_CLASSIFICATION`: Detect the language.
        * `TEXT_EXTRACTION`: Recognize text.
        * `TABLE_EXTRACTION`: Detect and extract data in tables.
        * `KEY_VALUE_EXTRACTION`: Extract form fields.
        * `DOCUMENT_CLASSIFICATION`: Identify the type of document.
        """
        return pulumi.get(self, "feature_type")

    @property
    @pulumi.getter(name="generateSearchablePdf")
    def generate_searchable_pdf(self) -> builtins.bool:
        """
        Whether or not to generate a searchable PDF file.
        """
        return pulumi.get(self, "generate_searchable_pdf")

    @property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> builtins.int:
        """
        The maximum number of results to return.
        """
        return pulumi.get(self, "max_results")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> builtins.str:
        """
        The custom model ID.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> builtins.str:
        """
        The custom model tenancy ID when modelId represents aliasName.
        """
        return pulumi.get(self, "tenancy_id")


@pulumi.output_type
class GetProjectsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProjectsProjectCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProjectsProjectCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProjectsProjectCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProjectsProjectCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 lifecycle_details: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param builtins.str description: An optional description of the project.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param builtins.str id: The filter to find the project with the given identifier.
        :param builtins.str lifecycle_details: A message describing the current state in more detail, that can provide actionable information if creation failed.
        :param builtins.str state: The filter to match projects with the given lifecycleState.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param builtins.str time_created: When the project was created, as an RFC3339 datetime string.
        :param builtins.str time_updated: When the project was updated, as an RFC3339 datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        An optional description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The filter to find the project with the given identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail, that can provide actionable information if creation failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The filter to match projects with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        When the project was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        When the project was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")


