# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ModelEvaluationResult',
    'ModelEvaluationResultClassMetric',
    'ModelEvaluationResultEntityMetric',
    'ModelEvaluationResultMetric',
    'ModelModelDetails',
    'ModelModelDetailsClassificationMode',
    'ModelTestStrategy',
    'ModelTestStrategyTestingDataset',
    'ModelTestStrategyTestingDatasetLocationDetails',
    'ModelTestStrategyValidationDataset',
    'ModelTestStrategyValidationDatasetLocationDetails',
    'ModelTrainingDataset',
    'ModelTrainingDatasetLocationDetails',
    'GetEndpointsEndpointCollectionResult',
    'GetEndpointsEndpointCollectionItemResult',
    'GetEndpointsFilterResult',
    'GetModelEvaluationResultResult',
    'GetModelEvaluationResultClassMetricResult',
    'GetModelEvaluationResultEntityMetricResult',
    'GetModelEvaluationResultMetricResult',
    'GetModelEvaluationResultsEvaluationResultCollectionResult',
    'GetModelEvaluationResultsEvaluationResultCollectionItemResult',
    'GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult',
    'GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult',
    'GetModelEvaluationResultsFilterResult',
    'GetModelModelDetailResult',
    'GetModelModelDetailClassificationModeResult',
    'GetModelTestStrategyResult',
    'GetModelTestStrategyTestingDatasetResult',
    'GetModelTestStrategyTestingDatasetLocationDetailResult',
    'GetModelTestStrategyValidationDatasetResult',
    'GetModelTestStrategyValidationDatasetLocationDetailResult',
    'GetModelTrainingDatasetResult',
    'GetModelTrainingDatasetLocationDetailResult',
    'GetModelsFilterResult',
    'GetModelsModelCollectionResult',
    'GetModelsModelCollectionItemResult',
    'GetModelsModelCollectionItemEvaluationResultResult',
    'GetModelsModelCollectionItemEvaluationResultClassMetricResult',
    'GetModelsModelCollectionItemEvaluationResultEntityMetricResult',
    'GetModelsModelCollectionItemEvaluationResultMetricResult',
    'GetModelsModelCollectionItemModelDetailResult',
    'GetModelsModelCollectionItemModelDetailClassificationModeResult',
    'GetModelsModelCollectionItemTestStrategyResult',
    'GetModelsModelCollectionItemTestStrategyTestingDatasetResult',
    'GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult',
    'GetModelsModelCollectionItemTestStrategyValidationDatasetResult',
    'GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult',
    'GetModelsModelCollectionItemTrainingDatasetResult',
    'GetModelsModelCollectionItemTrainingDatasetLocationDetailResult',
    'GetProjectsFilterResult',
    'GetProjectsProjectCollectionResult',
    'GetProjectsProjectCollectionItemResult',
]

@pulumi.output_type
class ModelEvaluationResult(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classMetrics":
            suggest = "class_metrics"
        elif key == "confusionMatrix":
            suggest = "confusion_matrix"
        elif key == "entityMetrics":
            suggest = "entity_metrics"
        elif key == "modelType":
            suggest = "model_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelEvaluationResult. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelEvaluationResult.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelEvaluationResult.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 class_metrics: Optional[Sequence['outputs.ModelEvaluationResultClassMetric']] = None,
                 confusion_matrix: Optional[builtins.str] = None,
                 entity_metrics: Optional[Sequence['outputs.ModelEvaluationResultEntityMetric']] = None,
                 labels: Optional[Sequence[builtins.str]] = None,
                 metrics: Optional[Sequence['outputs.ModelEvaluationResultMetric']] = None,
                 model_type: Optional[builtins.str] = None):
        """
        :param Sequence['ModelEvaluationResultClassMetricArgs'] class_metrics: List of text classification metrics
        :param builtins.str confusion_matrix: class level confusion matrix
        :param Sequence['ModelEvaluationResultEntityMetricArgs'] entity_metrics: List of entity metrics
        :param Sequence[builtins.str] labels: labels
        :param Sequence['ModelEvaluationResultMetricArgs'] metrics: Model level named entity recognition metrics
        :param builtins.str model_type: Model type
        """
        if class_metrics is not None:
            pulumi.set(__self__, "class_metrics", class_metrics)
        if confusion_matrix is not None:
            pulumi.set(__self__, "confusion_matrix", confusion_matrix)
        if entity_metrics is not None:
            pulumi.set(__self__, "entity_metrics", entity_metrics)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)

    @property
    @pulumi.getter(name="classMetrics")
    def class_metrics(self) -> Optional[Sequence['outputs.ModelEvaluationResultClassMetric']]:
        """
        List of text classification metrics
        """
        return pulumi.get(self, "class_metrics")

    @property
    @pulumi.getter(name="confusionMatrix")
    def confusion_matrix(self) -> Optional[builtins.str]:
        """
        class level confusion matrix
        """
        return pulumi.get(self, "confusion_matrix")

    @property
    @pulumi.getter(name="entityMetrics")
    def entity_metrics(self) -> Optional[Sequence['outputs.ModelEvaluationResultEntityMetric']]:
        """
        List of entity metrics
        """
        return pulumi.get(self, "entity_metrics")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence[builtins.str]]:
        """
        labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.ModelEvaluationResultMetric']]:
        """
        Model level named entity recognition metrics
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[builtins.str]:
        """
        Model type
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class ModelEvaluationResultClassMetric(dict):
    def __init__(__self__, *,
                 f1: Optional[builtins.float] = None,
                 label: Optional[builtins.str] = None,
                 precision: Optional[builtins.float] = None,
                 recall: Optional[builtins.float] = None,
                 support: Optional[builtins.float] = None):
        """
        :param builtins.float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.str label: Entity label
        :param builtins.float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param builtins.float support: number of samples in the test set
        """
        if f1 is not None:
            pulumi.set(__self__, "f1", f1)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)
        if support is not None:
            pulumi.set(__self__, "support", support)

    @property
    @pulumi.getter
    def f1(self) -> Optional[builtins.float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> Optional[builtins.str]:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> Optional[builtins.float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> Optional[builtins.float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def support(self) -> Optional[builtins.float]:
        """
        number of samples in the test set
        """
        return pulumi.get(self, "support")


@pulumi.output_type
class ModelEvaluationResultEntityMetric(dict):
    def __init__(__self__, *,
                 f1: Optional[builtins.float] = None,
                 label: Optional[builtins.str] = None,
                 precision: Optional[builtins.float] = None,
                 recall: Optional[builtins.float] = None):
        """
        :param builtins.float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.str label: Entity label
        :param builtins.float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        if f1 is not None:
            pulumi.set(__self__, "f1", f1)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if precision is not None:
            pulumi.set(__self__, "precision", precision)
        if recall is not None:
            pulumi.set(__self__, "recall", recall)

    @property
    @pulumi.getter
    def f1(self) -> Optional[builtins.float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> Optional[builtins.str]:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> Optional[builtins.float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> Optional[builtins.float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")


@pulumi.output_type
class ModelEvaluationResultMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "macroF1":
            suggest = "macro_f1"
        elif key == "macroPrecision":
            suggest = "macro_precision"
        elif key == "macroRecall":
            suggest = "macro_recall"
        elif key == "microF1":
            suggest = "micro_f1"
        elif key == "microPrecision":
            suggest = "micro_precision"
        elif key == "microRecall":
            suggest = "micro_recall"
        elif key == "weightedF1":
            suggest = "weighted_f1"
        elif key == "weightedPrecision":
            suggest = "weighted_precision"
        elif key == "weightedRecall":
            suggest = "weighted_recall"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelEvaluationResultMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelEvaluationResultMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelEvaluationResultMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accuracy: Optional[builtins.float] = None,
                 macro_f1: Optional[builtins.float] = None,
                 macro_precision: Optional[builtins.float] = None,
                 macro_recall: Optional[builtins.float] = None,
                 micro_f1: Optional[builtins.float] = None,
                 micro_precision: Optional[builtins.float] = None,
                 micro_recall: Optional[builtins.float] = None,
                 weighted_f1: Optional[builtins.float] = None,
                 weighted_precision: Optional[builtins.float] = None,
                 weighted_recall: Optional[builtins.float] = None):
        """
        :param builtins.float accuracy: The fraction of the labels that were correctly recognised .
        :param builtins.float macro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.float macro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float macro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param builtins.float micro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.float micro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float micro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param builtins.float weighted_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.float weighted_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float weighted_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        if accuracy is not None:
            pulumi.set(__self__, "accuracy", accuracy)
        if macro_f1 is not None:
            pulumi.set(__self__, "macro_f1", macro_f1)
        if macro_precision is not None:
            pulumi.set(__self__, "macro_precision", macro_precision)
        if macro_recall is not None:
            pulumi.set(__self__, "macro_recall", macro_recall)
        if micro_f1 is not None:
            pulumi.set(__self__, "micro_f1", micro_f1)
        if micro_precision is not None:
            pulumi.set(__self__, "micro_precision", micro_precision)
        if micro_recall is not None:
            pulumi.set(__self__, "micro_recall", micro_recall)
        if weighted_f1 is not None:
            pulumi.set(__self__, "weighted_f1", weighted_f1)
        if weighted_precision is not None:
            pulumi.set(__self__, "weighted_precision", weighted_precision)
        if weighted_recall is not None:
            pulumi.set(__self__, "weighted_recall", weighted_recall)

    @property
    @pulumi.getter
    def accuracy(self) -> Optional[builtins.float]:
        """
        The fraction of the labels that were correctly recognised .
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter(name="macroF1")
    def macro_f1(self) -> Optional[builtins.float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "macro_f1")

    @property
    @pulumi.getter(name="macroPrecision")
    def macro_precision(self) -> Optional[builtins.float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "macro_precision")

    @property
    @pulumi.getter(name="macroRecall")
    def macro_recall(self) -> Optional[builtins.float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "macro_recall")

    @property
    @pulumi.getter(name="microF1")
    def micro_f1(self) -> Optional[builtins.float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "micro_f1")

    @property
    @pulumi.getter(name="microPrecision")
    def micro_precision(self) -> Optional[builtins.float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "micro_precision")

    @property
    @pulumi.getter(name="microRecall")
    def micro_recall(self) -> Optional[builtins.float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "micro_recall")

    @property
    @pulumi.getter(name="weightedF1")
    def weighted_f1(self) -> Optional[builtins.float]:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "weighted_f1")

    @property
    @pulumi.getter(name="weightedPrecision")
    def weighted_precision(self) -> Optional[builtins.float]:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "weighted_precision")

    @property
    @pulumi.getter(name="weightedRecall")
    def weighted_recall(self) -> Optional[builtins.float]:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "weighted_recall")


@pulumi.output_type
class ModelModelDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "modelType":
            suggest = "model_type"
        elif key == "classificationMode":
            suggest = "classification_mode"
        elif key == "languageCode":
            suggest = "language_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 model_type: builtins.str,
                 classification_mode: Optional['outputs.ModelModelDetailsClassificationMode'] = None,
                 language_code: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str model_type: Model type
        :param 'ModelModelDetailsClassificationModeArgs' classification_mode: possible text classification modes
        :param builtins.str language_code: supported language default value is en
        :param builtins.str version: Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        pulumi.set(__self__, "model_type", model_type)
        if classification_mode is not None:
            pulumi.set(__self__, "classification_mode", classification_mode)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> builtins.str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> Optional['outputs.ModelModelDetailsClassificationMode']:
        """
        possible text classification modes
        """
        return pulumi.get(self, "classification_mode")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[builtins.str]:
        """
        supported language default value is en
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Optional pre trained model version. if nothing specified latest pre trained model will be used.  Supported versions can be found at /modelTypes/{modelType}
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ModelModelDetailsClassificationMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationMode":
            suggest = "classification_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelDetailsClassificationMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelDetailsClassificationMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelDetailsClassificationMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification_mode: builtins.str,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str classification_mode: classification Modes
        :param builtins.str version: Optional if nothing specified latest base model will be used for training. Supported versions can be found at /modelTypes/{modelType}
        """
        pulumi.set(__self__, "classification_mode", classification_mode)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> builtins.str:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_mode")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Optional if nothing specified latest base model will be used for training. Supported versions can be found at /modelTypes/{modelType}
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ModelTestStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "strategyType":
            suggest = "strategy_type"
        elif key == "testingDataset":
            suggest = "testing_dataset"
        elif key == "validationDataset":
            suggest = "validation_dataset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 strategy_type: builtins.str,
                 testing_dataset: 'outputs.ModelTestStrategyTestingDataset',
                 validation_dataset: Optional['outputs.ModelTestStrategyValidationDataset'] = None):
        """
        :param builtins.str strategy_type: This information will define the test strategy different datasets for test and validation(optional) dataset.
        :param 'ModelTestStrategyTestingDatasetArgs' testing_dataset: Possible data set type
        :param 'ModelTestStrategyValidationDatasetArgs' validation_dataset: Possible data set type
        """
        pulumi.set(__self__, "strategy_type", strategy_type)
        pulumi.set(__self__, "testing_dataset", testing_dataset)
        if validation_dataset is not None:
            pulumi.set(__self__, "validation_dataset", validation_dataset)

    @property
    @pulumi.getter(name="strategyType")
    def strategy_type(self) -> builtins.str:
        """
        This information will define the test strategy different datasets for test and validation(optional) dataset.
        """
        return pulumi.get(self, "strategy_type")

    @property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> 'outputs.ModelTestStrategyTestingDataset':
        """
        Possible data set type
        """
        return pulumi.get(self, "testing_dataset")

    @property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> Optional['outputs.ModelTestStrategyValidationDataset']:
        """
        Possible data set type
        """
        return pulumi.get(self, "validation_dataset")


@pulumi.output_type
class ModelTestStrategyTestingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "locationDetails":
            suggest = "location_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategyTestingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategyTestingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategyTestingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: builtins.str,
                 dataset_id: Optional[builtins.str] = None,
                 location_details: Optional['outputs.ModelTestStrategyTestingDatasetLocationDetails'] = None):
        """
        :param builtins.str dataset_type: Possible data sets
        :param builtins.str dataset_id: Data Science Labelling Service OCID
        :param 'ModelTestStrategyTestingDatasetLocationDetailsArgs' location_details: Possible object storage location types
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if location_details is not None:
            pulumi.set(__self__, "location_details", location_details)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[builtins.str]:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Optional['outputs.ModelTestStrategyTestingDatasetLocationDetails']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class ModelTestStrategyTestingDatasetLocationDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationType":
            suggest = "location_type"
        elif key == "objectNames":
            suggest = "object_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategyTestingDatasetLocationDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategyTestingDatasetLocationDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategyTestingDatasetLocationDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 location_type: builtins.str,
                 namespace: builtins.str,
                 object_names: Sequence[builtins.str]):
        """
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str location_type: Possible object storage location types
        :param builtins.str namespace: Object storage namespace
        :param Sequence[builtins.str] object_names: Array of files which need to be processed in the bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location_type", location_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> builtins.str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[builtins.str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class ModelTestStrategyValidationDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "locationDetails":
            suggest = "location_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategyValidationDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategyValidationDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategyValidationDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: builtins.str,
                 dataset_id: Optional[builtins.str] = None,
                 location_details: Optional['outputs.ModelTestStrategyValidationDatasetLocationDetails'] = None):
        """
        :param builtins.str dataset_type: Possible data sets
        :param builtins.str dataset_id: Data Science Labelling Service OCID
        :param 'ModelTestStrategyValidationDatasetLocationDetailsArgs' location_details: Possible object storage location types
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if location_details is not None:
            pulumi.set(__self__, "location_details", location_details)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[builtins.str]:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Optional['outputs.ModelTestStrategyValidationDatasetLocationDetails']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class ModelTestStrategyValidationDatasetLocationDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationType":
            suggest = "location_type"
        elif key == "objectNames":
            suggest = "object_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTestStrategyValidationDatasetLocationDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTestStrategyValidationDatasetLocationDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTestStrategyValidationDatasetLocationDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 location_type: builtins.str,
                 namespace: builtins.str,
                 object_names: Sequence[builtins.str]):
        """
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str location_type: Possible object storage location types
        :param builtins.str namespace: Object storage namespace
        :param Sequence[builtins.str] object_names: Array of files which need to be processed in the bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location_type", location_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> builtins.str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[builtins.str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class ModelTrainingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"
        elif key == "datasetId":
            suggest = "dataset_id"
        elif key == "locationDetails":
            suggest = "location_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTrainingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTrainingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_type: builtins.str,
                 dataset_id: Optional[builtins.str] = None,
                 location_details: Optional['outputs.ModelTrainingDatasetLocationDetails'] = None):
        """
        :param builtins.str dataset_type: Possible data sets
        :param builtins.str dataset_id: Data Science Labelling Service OCID
        :param 'ModelTrainingDatasetLocationDetailsArgs' location_details: Possible object storage location types
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if location_details is not None:
            pulumi.set(__self__, "location_details", location_details)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[builtins.str]:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Optional['outputs.ModelTrainingDatasetLocationDetails']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class ModelTrainingDatasetLocationDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationType":
            suggest = "location_type"
        elif key == "objectNames":
            suggest = "object_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelTrainingDatasetLocationDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelTrainingDatasetLocationDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelTrainingDatasetLocationDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 location_type: builtins.str,
                 namespace: builtins.str,
                 object_names: Sequence[builtins.str]):
        """
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str location_type: Possible object storage location types
        :param builtins.str namespace: Object storage namespace
        :param Sequence[builtins.str] object_names: Array of files which need to be processed in the bucket
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location_type", location_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> builtins.str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[builtins.str]:
        """
        Array of files which need to be processed in the bucket


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetEndpointsEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetEndpointsEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetEndpointsEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetEndpointsEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 inference_units: builtins.int,
                 lifecycle_details: builtins.str,
                 model_id: builtins.str,
                 project_id: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: A short description of the endpoint.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: Unique identifier endpoint OCID of an endpoint that is immutable on creation.
        :param builtins.int inference_units: Number of replicas required for this endpoint.
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        :param builtins.str model_id: The ID of the trained model for which to list the endpoints.
        :param builtins.str project_id: The ID of the project for which to list the objects.
        :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The time the the endpoint was created. An RFC3339 formatted datetime string.
        :param builtins.str time_updated: The time the endpoint was updated. An RFC3339 formatted datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inference_units", inference_units)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A short description of the endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier endpoint OCID of an endpoint that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inferenceUnits")
    def inference_units(self) -> builtins.int:
        """
        Number of replicas required for this endpoint.
        """
        return pulumi.get(self, "inference_units")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> builtins.str:
        """
        The ID of the trained model for which to list the endpoints.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the endpoint was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the endpoint was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelEvaluationResultResult(dict):
    def __init__(__self__, *,
                 class_metrics: Sequence['outputs.GetModelEvaluationResultClassMetricResult'],
                 confusion_matrix: builtins.str,
                 entity_metrics: Sequence['outputs.GetModelEvaluationResultEntityMetricResult'],
                 labels: Sequence[builtins.str],
                 metrics: Sequence['outputs.GetModelEvaluationResultMetricResult'],
                 model_type: builtins.str):
        """
        :param Sequence['GetModelEvaluationResultClassMetricArgs'] class_metrics: List of text classification metrics
        :param builtins.str confusion_matrix: class level confusion matrix
        :param Sequence['GetModelEvaluationResultEntityMetricArgs'] entity_metrics: List of entity metrics
        :param Sequence[builtins.str] labels: labels
        :param Sequence['GetModelEvaluationResultMetricArgs'] metrics: Model level named entity recognition metrics
        :param builtins.str model_type: Model type
        """
        pulumi.set(__self__, "class_metrics", class_metrics)
        pulumi.set(__self__, "confusion_matrix", confusion_matrix)
        pulumi.set(__self__, "entity_metrics", entity_metrics)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "model_type", model_type)

    @property
    @pulumi.getter(name="classMetrics")
    def class_metrics(self) -> Sequence['outputs.GetModelEvaluationResultClassMetricResult']:
        """
        List of text classification metrics
        """
        return pulumi.get(self, "class_metrics")

    @property
    @pulumi.getter(name="confusionMatrix")
    def confusion_matrix(self) -> builtins.str:
        """
        class level confusion matrix
        """
        return pulumi.get(self, "confusion_matrix")

    @property
    @pulumi.getter(name="entityMetrics")
    def entity_metrics(self) -> Sequence['outputs.GetModelEvaluationResultEntityMetricResult']:
        """
        List of entity metrics
        """
        return pulumi.get(self, "entity_metrics")

    @property
    @pulumi.getter
    def labels(self) -> Sequence[builtins.str]:
        """
        labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetModelEvaluationResultMetricResult']:
        """
        Model level named entity recognition metrics
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> builtins.str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class GetModelEvaluationResultClassMetricResult(dict):
    def __init__(__self__, *,
                 f1: builtins.float,
                 label: builtins.str,
                 precision: builtins.float,
                 recall: builtins.float,
                 support: builtins.float):
        """
        :param builtins.float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.str label: Entity label
        :param builtins.float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param builtins.float support: number of samples in the test set
        """
        pulumi.set(__self__, "f1", f1)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "support", support)

    @property
    @pulumi.getter
    def f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def support(self) -> builtins.float:
        """
        number of samples in the test set
        """
        return pulumi.get(self, "support")


@pulumi.output_type
class GetModelEvaluationResultEntityMetricResult(dict):
    def __init__(__self__, *,
                 f1: builtins.float,
                 label: builtins.str,
                 precision: builtins.float,
                 recall: builtins.float):
        """
        :param builtins.float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.str label: Entity label
        :param builtins.float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        pulumi.set(__self__, "f1", f1)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)

    @property
    @pulumi.getter
    def f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")


@pulumi.output_type
class GetModelEvaluationResultMetricResult(dict):
    def __init__(__self__, *,
                 accuracy: builtins.float,
                 macro_f1: builtins.float,
                 macro_precision: builtins.float,
                 macro_recall: builtins.float,
                 micro_f1: builtins.float,
                 micro_precision: builtins.float,
                 micro_recall: builtins.float,
                 weighted_f1: builtins.float,
                 weighted_precision: builtins.float,
                 weighted_recall: builtins.float):
        """
        :param builtins.float accuracy: The fraction of the labels that were correctly recognised .
        :param builtins.float macro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.float macro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float macro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param builtins.float micro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.float micro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float micro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param builtins.float weighted_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.float weighted_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float weighted_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "macro_f1", macro_f1)
        pulumi.set(__self__, "macro_precision", macro_precision)
        pulumi.set(__self__, "macro_recall", macro_recall)
        pulumi.set(__self__, "micro_f1", micro_f1)
        pulumi.set(__self__, "micro_precision", micro_precision)
        pulumi.set(__self__, "micro_recall", micro_recall)
        pulumi.set(__self__, "weighted_f1", weighted_f1)
        pulumi.set(__self__, "weighted_precision", weighted_precision)
        pulumi.set(__self__, "weighted_recall", weighted_recall)

    @property
    @pulumi.getter
    def accuracy(self) -> builtins.float:
        """
        The fraction of the labels that were correctly recognised .
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter(name="macroF1")
    def macro_f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "macro_f1")

    @property
    @pulumi.getter(name="macroPrecision")
    def macro_precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "macro_precision")

    @property
    @pulumi.getter(name="macroRecall")
    def macro_recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "macro_recall")

    @property
    @pulumi.getter(name="microF1")
    def micro_f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "micro_f1")

    @property
    @pulumi.getter(name="microPrecision")
    def micro_precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "micro_precision")

    @property
    @pulumi.getter(name="microRecall")
    def micro_recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "micro_recall")

    @property
    @pulumi.getter(name="weightedF1")
    def weighted_f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "weighted_f1")

    @property
    @pulumi.getter(name="weightedPrecision")
    def weighted_precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "weighted_precision")

    @property
    @pulumi.getter(name="weightedRecall")
    def weighted_recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "weighted_recall")


@pulumi.output_type
class GetModelEvaluationResultsEvaluationResultCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemResult']):
        """
        :param Sequence['GetModelEvaluationResultsEvaluationResultCollectionItemArgs'] items: List of model evaluation analysis
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemResult']:
        """
        List of model evaluation analysis
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetModelEvaluationResultsEvaluationResultCollectionItemResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 freeform_tags: Mapping[str, builtins.str],
                 location: builtins.str,
                 model_type: builtins.str,
                 predicted_entities: Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult'],
                 predicted_labels: Sequence[builtins.str],
                 record: builtins.str,
                 true_entities: Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult'],
                 true_labels: Sequence[builtins.str]):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str location: For CSV format location is rowId(1 is header) and for JSONL location is jsonL line sequence(1 is metadata)
        :param builtins.str model_type: Model type
        :param Sequence['GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityArgs'] predicted_entities: List of true(actual) entities in test data for NER model
        :param Sequence[builtins.str] predicted_labels: List of predicted labels by custom multi class or multi label TextClassification model
        :param builtins.str record: For CSV format location is rowId(1 is header) and for JSONL location is jsonL line sequence(1 is metadata)
        :param Sequence['GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityArgs'] true_entities: List of true(actual) entities in test data for NER model
        :param Sequence[builtins.str] true_labels: List of true(actual) labels in test data for multi class or multi label TextClassification
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "predicted_entities", predicted_entities)
        pulumi.set(__self__, "predicted_labels", predicted_labels)
        pulumi.set(__self__, "record", record)
        pulumi.set(__self__, "true_entities", true_entities)
        pulumi.set(__self__, "true_labels", true_labels)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        For CSV format location is rowId(1 is header) and for JSONL location is jsonL line sequence(1 is metadata)
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> builtins.str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="predictedEntities")
    def predicted_entities(self) -> Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult']:
        """
        List of true(actual) entities in test data for NER model
        """
        return pulumi.get(self, "predicted_entities")

    @property
    @pulumi.getter(name="predictedLabels")
    def predicted_labels(self) -> Sequence[builtins.str]:
        """
        List of predicted labels by custom multi class or multi label TextClassification model
        """
        return pulumi.get(self, "predicted_labels")

    @property
    @pulumi.getter
    def record(self) -> builtins.str:
        """
        For CSV format location is rowId(1 is header) and for JSONL location is jsonL line sequence(1 is metadata)
        """
        return pulumi.get(self, "record")

    @property
    @pulumi.getter(name="trueEntities")
    def true_entities(self) -> Sequence['outputs.GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult']:
        """
        List of true(actual) entities in test data for NER model
        """
        return pulumi.get(self, "true_entities")

    @property
    @pulumi.getter(name="trueLabels")
    def true_labels(self) -> Sequence[builtins.str]:
        """
        List of true(actual) labels in test data for multi class or multi label TextClassification
        """
        return pulumi.get(self, "true_labels")


@pulumi.output_type
class GetModelEvaluationResultsEvaluationResultCollectionItemPredictedEntityResult(dict):
    def __init__(__self__, *,
                 length: builtins.int,
                 offset: builtins.int,
                 type: builtins.str):
        """
        :param builtins.int length: Length of text
        :param builtins.int offset: Starting index on text.
        :param builtins.str type: Type of entity text like PER, LOC, GPE, NOPE etc.
        """
        pulumi.set(__self__, "length", length)
        pulumi.set(__self__, "offset", offset)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def length(self) -> builtins.int:
        """
        Length of text
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def offset(self) -> builtins.int:
        """
        Starting index on text.
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of entity text like PER, LOC, GPE, NOPE etc.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetModelEvaluationResultsEvaluationResultCollectionItemTrueEntityResult(dict):
    def __init__(__self__, *,
                 length: builtins.int,
                 offset: builtins.int,
                 type: builtins.str):
        """
        :param builtins.int length: Length of text
        :param builtins.int offset: Starting index on text.
        :param builtins.str type: Type of entity text like PER, LOC, GPE, NOPE etc.
        """
        pulumi.set(__self__, "length", length)
        pulumi.set(__self__, "offset", offset)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def length(self) -> builtins.int:
        """
        Length of text
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def offset(self) -> builtins.int:
        """
        Starting index on text.
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of entity text like PER, LOC, GPE, NOPE etc.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetModelEvaluationResultsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelModelDetailResult(dict):
    def __init__(__self__, *,
                 classification_modes: Sequence['outputs.GetModelModelDetailClassificationModeResult'],
                 language_code: builtins.str,
                 model_type: builtins.str,
                 version: builtins.str):
        """
        :param Sequence['GetModelModelDetailClassificationModeArgs'] classification_modes: classification Modes
        :param builtins.str language_code: supported language default value is en
        :param builtins.str model_type: Model type
        :param builtins.str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        pulumi.set(__self__, "classification_modes", classification_modes)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="classificationModes")
    def classification_modes(self) -> Sequence['outputs.GetModelModelDetailClassificationModeResult']:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_modes")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> builtins.str:
        """
        supported language default value is en
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> builtins.str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelModelDetailClassificationModeResult(dict):
    def __init__(__self__, *,
                 classification_mode: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str classification_mode: classification Modes
        :param builtins.str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        pulumi.set(__self__, "classification_mode", classification_mode)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> builtins.str:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_mode")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelTestStrategyResult(dict):
    def __init__(__self__, *,
                 strategy_type: builtins.str,
                 testing_datasets: Sequence['outputs.GetModelTestStrategyTestingDatasetResult'],
                 validation_datasets: Sequence['outputs.GetModelTestStrategyValidationDatasetResult']):
        """
        :param builtins.str strategy_type: This information will define the test strategy different datasets for test and validation(optional) dataset.
        :param Sequence['GetModelTestStrategyTestingDatasetArgs'] testing_datasets: Possible data set type
        :param Sequence['GetModelTestStrategyValidationDatasetArgs'] validation_datasets: Possible data set type
        """
        pulumi.set(__self__, "strategy_type", strategy_type)
        pulumi.set(__self__, "testing_datasets", testing_datasets)
        pulumi.set(__self__, "validation_datasets", validation_datasets)

    @property
    @pulumi.getter(name="strategyType")
    def strategy_type(self) -> builtins.str:
        """
        This information will define the test strategy different datasets for test and validation(optional) dataset.
        """
        return pulumi.get(self, "strategy_type")

    @property
    @pulumi.getter(name="testingDatasets")
    def testing_datasets(self) -> Sequence['outputs.GetModelTestStrategyTestingDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "testing_datasets")

    @property
    @pulumi.getter(name="validationDatasets")
    def validation_datasets(self) -> Sequence['outputs.GetModelTestStrategyValidationDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "validation_datasets")


@pulumi.output_type
class GetModelTestStrategyTestingDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 location_details: Sequence['outputs.GetModelTestStrategyTestingDatasetLocationDetailResult']):
        """
        :param builtins.str dataset_id: Data Science Labelling Service OCID
        :param builtins.str dataset_type: Possible data sets
        :param Sequence['GetModelTestStrategyTestingDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelTestStrategyTestingDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelTestStrategyTestingDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 location_type: builtins.str,
                 namespace: builtins.str,
                 object_names: Sequence[builtins.str]):
        """
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str location_type: Possible object storage location types
        :param builtins.str namespace: Object storage namespace
        :param Sequence[builtins.str] object_names: Array of files which need to be processed in the bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location_type", location_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> builtins.str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[builtins.str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelTestStrategyValidationDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 location_details: Sequence['outputs.GetModelTestStrategyValidationDatasetLocationDetailResult']):
        """
        :param builtins.str dataset_id: Data Science Labelling Service OCID
        :param builtins.str dataset_type: Possible data sets
        :param Sequence['GetModelTestStrategyValidationDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelTestStrategyValidationDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelTestStrategyValidationDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 location_type: builtins.str,
                 namespace: builtins.str,
                 object_names: Sequence[builtins.str]):
        """
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str location_type: Possible object storage location types
        :param builtins.str namespace: Object storage namespace
        :param Sequence[builtins.str] object_names: Array of files which need to be processed in the bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location_type", location_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> builtins.str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[builtins.str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 location_details: Sequence['outputs.GetModelTrainingDatasetLocationDetailResult']):
        """
        :param builtins.str dataset_id: Data Science Labelling Service OCID
        :param builtins.str dataset_type: Possible data sets
        :param Sequence['GetModelTrainingDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelTrainingDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelTrainingDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 location_type: builtins.str,
                 namespace: builtins.str,
                 object_names: Sequence[builtins.str]):
        """
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str location_type: Possible object storage location types
        :param builtins.str namespace: Object storage namespace
        :param Sequence[builtins.str] object_names: Array of files which need to be processed in the bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location_type", location_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> builtins.str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[builtins.str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelsModelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetModelsModelCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetModelsModelCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetModelsModelCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 evaluation_results: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultResult'],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 lifecycle_details: builtins.str,
                 model_details: Sequence['outputs.GetModelsModelCollectionItemModelDetailResult'],
                 project_id: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 test_strategies: Sequence['outputs.GetModelsModelCollectionItemTestStrategyResult'],
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 training_datasets: Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult'],
                 version: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: A short description of the Model.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Sequence['GetModelsModelCollectionItemEvaluationResultArgs'] evaluation_results: model training results of different models
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: Unique identifier model OCID of a model that is immutable on creation
        :param builtins.str lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        :param Sequence['GetModelsModelCollectionItemModelDetailArgs'] model_details: Possible model types
        :param builtins.str project_id: The ID of the project for which to list the objects.
        :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence['GetModelsModelCollectionItemTestStrategyArgs'] test_strategies: Possible strategy as testing and validation(optional) dataset.
        :param builtins.str time_created: The time the the model was created. An RFC3339 formatted datetime string.
        :param builtins.str time_updated: The time the model was updated. An RFC3339 formatted datetime string.
        :param Sequence['GetModelsModelCollectionItemTrainingDatasetArgs'] training_datasets: Possible data set type
        :param builtins.str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "evaluation_results", evaluation_results)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "model_details", model_details)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "test_strategies", test_strategies)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "training_datasets", training_datasets)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A short description of the Model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="evaluationResults")
    def evaluation_results(self) -> Sequence['outputs.GetModelsModelCollectionItemEvaluationResultResult']:
        """
        model training results of different models
        """
        return pulumi.get(self, "evaluation_results")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier model OCID of a model that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelDetails")
    def model_details(self) -> Sequence['outputs.GetModelsModelCollectionItemModelDetailResult']:
        """
        Possible model types
        """
        return pulumi.get(self, "model_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The ID of the project for which to list the objects.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="testStrategies")
    def test_strategies(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyResult']:
        """
        Possible strategy as testing and validation(optional) dataset.
        """
        return pulumi.get(self, "test_strategies")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time the the model was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time the model was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trainingDatasets")
    def training_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "training_datasets")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelsModelCollectionItemEvaluationResultResult(dict):
    def __init__(__self__, *,
                 class_metrics: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultClassMetricResult'],
                 confusion_matrix: builtins.str,
                 entity_metrics: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultEntityMetricResult'],
                 labels: Sequence[builtins.str],
                 metrics: Sequence['outputs.GetModelsModelCollectionItemEvaluationResultMetricResult'],
                 model_type: builtins.str):
        """
        :param Sequence['GetModelsModelCollectionItemEvaluationResultClassMetricArgs'] class_metrics: List of text classification metrics
        :param builtins.str confusion_matrix: class level confusion matrix
        :param Sequence['GetModelsModelCollectionItemEvaluationResultEntityMetricArgs'] entity_metrics: List of entity metrics
        :param Sequence[builtins.str] labels: labels
        :param Sequence['GetModelsModelCollectionItemEvaluationResultMetricArgs'] metrics: Model level named entity recognition metrics
        :param builtins.str model_type: Model type
        """
        pulumi.set(__self__, "class_metrics", class_metrics)
        pulumi.set(__self__, "confusion_matrix", confusion_matrix)
        pulumi.set(__self__, "entity_metrics", entity_metrics)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "model_type", model_type)

    @property
    @pulumi.getter(name="classMetrics")
    def class_metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemEvaluationResultClassMetricResult']:
        """
        List of text classification metrics
        """
        return pulumi.get(self, "class_metrics")

    @property
    @pulumi.getter(name="confusionMatrix")
    def confusion_matrix(self) -> builtins.str:
        """
        class level confusion matrix
        """
        return pulumi.get(self, "confusion_matrix")

    @property
    @pulumi.getter(name="entityMetrics")
    def entity_metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemEvaluationResultEntityMetricResult']:
        """
        List of entity metrics
        """
        return pulumi.get(self, "entity_metrics")

    @property
    @pulumi.getter
    def labels(self) -> Sequence[builtins.str]:
        """
        labels
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemEvaluationResultMetricResult']:
        """
        Model level named entity recognition metrics
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> builtins.str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class GetModelsModelCollectionItemEvaluationResultClassMetricResult(dict):
    def __init__(__self__, *,
                 f1: builtins.float,
                 label: builtins.str,
                 precision: builtins.float,
                 recall: builtins.float,
                 support: builtins.float):
        """
        :param builtins.float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.str label: Entity label
        :param builtins.float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param builtins.float support: number of samples in the test set
        """
        pulumi.set(__self__, "f1", f1)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)
        pulumi.set(__self__, "support", support)

    @property
    @pulumi.getter
    def f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")

    @property
    @pulumi.getter
    def support(self) -> builtins.float:
        """
        number of samples in the test set
        """
        return pulumi.get(self, "support")


@pulumi.output_type
class GetModelsModelCollectionItemEvaluationResultEntityMetricResult(dict):
    def __init__(__self__, *,
                 f1: builtins.float,
                 label: builtins.str,
                 precision: builtins.float,
                 recall: builtins.float):
        """
        :param builtins.float f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.str label: Entity label
        :param builtins.float precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        pulumi.set(__self__, "f1", f1)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "precision", precision)
        pulumi.set(__self__, "recall", recall)

    @property
    @pulumi.getter
    def f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "f1")

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Entity label
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "precision")

    @property
    @pulumi.getter
    def recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "recall")


@pulumi.output_type
class GetModelsModelCollectionItemEvaluationResultMetricResult(dict):
    def __init__(__self__, *,
                 accuracy: builtins.float,
                 macro_f1: builtins.float,
                 macro_precision: builtins.float,
                 macro_recall: builtins.float,
                 micro_f1: builtins.float,
                 micro_precision: builtins.float,
                 micro_recall: builtins.float,
                 weighted_f1: builtins.float,
                 weighted_precision: builtins.float,
                 weighted_recall: builtins.float):
        """
        :param builtins.float accuracy: The fraction of the labels that were correctly recognised .
        :param builtins.float macro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.float macro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float macro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param builtins.float micro_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.float micro_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float micro_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        :param builtins.float weighted_f1: F1-score, is a measure of a model’s accuracy on a dataset
        :param builtins.float weighted_precision: Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        :param builtins.float weighted_recall: Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        pulumi.set(__self__, "accuracy", accuracy)
        pulumi.set(__self__, "macro_f1", macro_f1)
        pulumi.set(__self__, "macro_precision", macro_precision)
        pulumi.set(__self__, "macro_recall", macro_recall)
        pulumi.set(__self__, "micro_f1", micro_f1)
        pulumi.set(__self__, "micro_precision", micro_precision)
        pulumi.set(__self__, "micro_recall", micro_recall)
        pulumi.set(__self__, "weighted_f1", weighted_f1)
        pulumi.set(__self__, "weighted_precision", weighted_precision)
        pulumi.set(__self__, "weighted_recall", weighted_recall)

    @property
    @pulumi.getter
    def accuracy(self) -> builtins.float:
        """
        The fraction of the labels that were correctly recognised .
        """
        return pulumi.get(self, "accuracy")

    @property
    @pulumi.getter(name="macroF1")
    def macro_f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "macro_f1")

    @property
    @pulumi.getter(name="macroPrecision")
    def macro_precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "macro_precision")

    @property
    @pulumi.getter(name="macroRecall")
    def macro_recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "macro_recall")

    @property
    @pulumi.getter(name="microF1")
    def micro_f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "micro_f1")

    @property
    @pulumi.getter(name="microPrecision")
    def micro_precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "micro_precision")

    @property
    @pulumi.getter(name="microRecall")
    def micro_recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "micro_recall")

    @property
    @pulumi.getter(name="weightedF1")
    def weighted_f1(self) -> builtins.float:
        """
        F1-score, is a measure of a model’s accuracy on a dataset
        """
        return pulumi.get(self, "weighted_f1")

    @property
    @pulumi.getter(name="weightedPrecision")
    def weighted_precision(self) -> builtins.float:
        """
        Precision refers to the number of true positives divided by the total number of positive predictions (i.e., the number of true positives plus the number of false positives)
        """
        return pulumi.get(self, "weighted_precision")

    @property
    @pulumi.getter(name="weightedRecall")
    def weighted_recall(self) -> builtins.float:
        """
        Measures the model's ability to predict actual positive classes. It is the ratio between the predicted true positives and what was actually tagged. The recall metric reveals how many of the predicted classes are correct.
        """
        return pulumi.get(self, "weighted_recall")


@pulumi.output_type
class GetModelsModelCollectionItemModelDetailResult(dict):
    def __init__(__self__, *,
                 classification_modes: Sequence['outputs.GetModelsModelCollectionItemModelDetailClassificationModeResult'],
                 language_code: builtins.str,
                 model_type: builtins.str,
                 version: builtins.str):
        """
        :param Sequence['GetModelsModelCollectionItemModelDetailClassificationModeArgs'] classification_modes: classification Modes
        :param builtins.str language_code: supported language default value is en
        :param builtins.str model_type: Model type
        :param builtins.str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        pulumi.set(__self__, "classification_modes", classification_modes)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="classificationModes")
    def classification_modes(self) -> Sequence['outputs.GetModelsModelCollectionItemModelDetailClassificationModeResult']:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_modes")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> builtins.str:
        """
        supported language default value is en
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> builtins.str:
        """
        Model type
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelsModelCollectionItemModelDetailClassificationModeResult(dict):
    def __init__(__self__, *,
                 classification_mode: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str classification_mode: classification Modes
        :param builtins.str version: For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        pulumi.set(__self__, "classification_mode", classification_mode)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="classificationMode")
    def classification_mode(self) -> builtins.str:
        """
        classification Modes
        """
        return pulumi.get(self, "classification_mode")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        For pre trained models this will identify model type version used for model creation For custom identifying the model by model id is difficult. This param provides ease of use for end customer. <<service>>::<<service-name>>_<<model-type-version>>::<<custom model on which this training has to be done>> ex: ai-lang::NER_V1::CUSTOM-V0
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyResult(dict):
    def __init__(__self__, *,
                 strategy_type: builtins.str,
                 testing_datasets: Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetResult'],
                 validation_datasets: Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetResult']):
        """
        :param builtins.str strategy_type: This information will define the test strategy different datasets for test and validation(optional) dataset.
        :param Sequence['GetModelsModelCollectionItemTestStrategyTestingDatasetArgs'] testing_datasets: Possible data set type
        :param Sequence['GetModelsModelCollectionItemTestStrategyValidationDatasetArgs'] validation_datasets: Possible data set type
        """
        pulumi.set(__self__, "strategy_type", strategy_type)
        pulumi.set(__self__, "testing_datasets", testing_datasets)
        pulumi.set(__self__, "validation_datasets", validation_datasets)

    @property
    @pulumi.getter(name="strategyType")
    def strategy_type(self) -> builtins.str:
        """
        This information will define the test strategy different datasets for test and validation(optional) dataset.
        """
        return pulumi.get(self, "strategy_type")

    @property
    @pulumi.getter(name="testingDatasets")
    def testing_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "testing_datasets")

    @property
    @pulumi.getter(name="validationDatasets")
    def validation_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetResult']:
        """
        Possible data set type
        """
        return pulumi.get(self, "validation_datasets")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyTestingDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 location_details: Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult']):
        """
        :param builtins.str dataset_id: Data Science Labelling Service OCID
        :param builtins.str dataset_type: Possible data sets
        :param Sequence['GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyTestingDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 location_type: builtins.str,
                 namespace: builtins.str,
                 object_names: Sequence[builtins.str]):
        """
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str location_type: Possible object storage location types
        :param builtins.str namespace: Object storage namespace
        :param Sequence[builtins.str] object_names: Array of files which need to be processed in the bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location_type", location_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> builtins.str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[builtins.str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyValidationDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 location_details: Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult']):
        """
        :param builtins.str dataset_id: Data Science Labelling Service OCID
        :param builtins.str dataset_type: Possible data sets
        :param Sequence['GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelsModelCollectionItemTestStrategyValidationDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 location_type: builtins.str,
                 namespace: builtins.str,
                 object_names: Sequence[builtins.str]):
        """
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str location_type: Possible object storage location types
        :param builtins.str namespace: Object storage namespace
        :param Sequence[builtins.str] object_names: Array of files which need to be processed in the bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location_type", location_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> builtins.str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[builtins.str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetModelsModelCollectionItemTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 dataset_id: builtins.str,
                 dataset_type: builtins.str,
                 location_details: Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetLocationDetailResult']):
        """
        :param builtins.str dataset_id: Data Science Labelling Service OCID
        :param builtins.str dataset_type: Possible data sets
        :param Sequence['GetModelsModelCollectionItemTrainingDatasetLocationDetailArgs'] location_details: Possible object storage location types
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "location_details", location_details)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> builtins.str:
        """
        Data Science Labelling Service OCID
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> builtins.str:
        """
        Possible data sets
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter(name="locationDetails")
    def location_details(self) -> Sequence['outputs.GetModelsModelCollectionItemTrainingDatasetLocationDetailResult']:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_details")


@pulumi.output_type
class GetModelsModelCollectionItemTrainingDatasetLocationDetailResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 location_type: builtins.str,
                 namespace: builtins.str,
                 object_names: Sequence[builtins.str]):
        """
        :param builtins.str bucket: Object storage bucket name
        :param builtins.str location_type: Possible object storage location types
        :param builtins.str namespace: Object storage namespace
        :param Sequence[builtins.str] object_names: Array of files which need to be processed in the bucket
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "location_type", location_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object_names", object_names)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Object storage bucket name
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="locationType")
    def location_type(self) -> builtins.str:
        """
        Possible object storage location types
        """
        return pulumi.get(self, "location_type")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        Object storage namespace
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="objectNames")
    def object_names(self) -> Sequence[builtins.str]:
        """
        Array of files which need to be processed in the bucket
        """
        return pulumi.get(self, "object_names")


@pulumi.output_type
class GetProjectsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetProjectsProjectCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetProjectsProjectCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProjectsProjectCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetProjectsProjectCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 lifecycle_details: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param builtins.str description: A short description of a project.
        :param builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param builtins.str id: Unique identifier OCID of the project
        :param builtins.str lifecycle_details: A message describing the current state in more detail.
        :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param builtins.str time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param builtins.str time_updated: The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A short description of a project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier OCID of the project
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


