# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceTaskArgs', 'WorkspaceTask']

@pulumi.input_type
class WorkspaceTaskArgs:
    def __init__(__self__, *,
                 identifier: pulumi.Input[builtins.str],
                 model_type: pulumi.Input[builtins.str],
                 registry_metadata: pulumi.Input['WorkspaceTaskRegistryMetadataArgs'],
                 workspace_id: pulumi.Input[builtins.str],
                 api_call_mode: Optional[pulumi.Input[builtins.str]] = None,
                 auth_config: Optional[pulumi.Input['WorkspaceTaskAuthConfigArgs']] = None,
                 cancel_rest_call_config: Optional[pulumi.Input['WorkspaceTaskCancelRestCallConfigArgs']] = None,
                 config_provider_delegate: Optional[pulumi.Input['WorkspaceTaskConfigProviderDelegateArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execute_rest_call_config: Optional[pulumi.Input['WorkspaceTaskExecuteRestCallConfigArgs']] = None,
                 input_ports: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskInputPortArgs']]]] = None,
                 is_single_load: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 model_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_status: Optional[pulumi.Input[builtins.int]] = None,
                 op_config_values: Optional[pulumi.Input['WorkspaceTaskOpConfigValuesArgs']] = None,
                 operation: Optional[pulumi.Input[builtins.str]] = None,
                 output_ports: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskOutputPortArgs']]]] = None,
                 parallel_load_limit: Optional[pulumi.Input[builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskParameterArgs']]]] = None,
                 parent_ref: Optional[pulumi.Input['WorkspaceTaskParentRefArgs']] = None,
                 poll_rest_call_config: Optional[pulumi.Input['WorkspaceTaskPollRestCallConfigArgs']] = None,
                 typed_expressions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskTypedExpressionArgs']]]] = None):
        """
        The set of arguments for constructing a WorkspaceTask resource.
        :param pulumi.Input[builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[builtins.str] model_type: (Updatable) The type of the task.
        :param pulumi.Input['WorkspaceTaskRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] api_call_mode: (Updatable) The REST invocation pattern to use. ASYNC_OCI_WORKREQUEST is being deprecated as well as cancelEndpoint/MethodType.
        :param pulumi.Input['WorkspaceTaskAuthConfigArgs'] auth_config: (Updatable) Authentication configuration for Generic REST invocation.
        :param pulumi.Input['WorkspaceTaskCancelRestCallConfigArgs'] cancel_rest_call_config: (Updatable) The REST API configuration for cancelling the task.
        :param pulumi.Input['WorkspaceTaskConfigProviderDelegateArgs'] config_provider_delegate: (Updatable) The type to create a config provider.
        :param pulumi.Input[builtins.str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input['WorkspaceTaskExecuteRestCallConfigArgs'] execute_rest_call_config: (Updatable) The REST API configuration for execution.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskInputPortArgs']]] input_ports: (Updatable) An array of input ports.
        :param pulumi.Input[builtins.bool] is_single_load: (Updatable) Defines whether Data Loader task is used for single load or multiple
        :param pulumi.Input[builtins.str] key: (Updatable) Generated key that can be used in API calls to identify task. On scenarios where reference to the task is needed, a value can be passed in create.
        :param pulumi.Input[builtins.str] model_version: (Updatable) The object's model version.
        :param pulumi.Input[builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input['WorkspaceTaskOpConfigValuesArgs'] op_config_values: (Updatable) Configuration values can be string, objects, or parameters.
        :param pulumi.Input[builtins.str] operation: (Updatable) Describes the shape of the execution result
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskOutputPortArgs']]] output_ports: (Updatable) An array of output ports.
        :param pulumi.Input[builtins.int] parallel_load_limit: (Updatable) Defines the number of entities being loaded in parallel at a time for a Data Loader task
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskParameterArgs']]] parameters: (Updatable) An array of parameters.
        :param pulumi.Input['WorkspaceTaskParentRefArgs'] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input['WorkspaceTaskPollRestCallConfigArgs'] poll_rest_call_config: (Updatable) The REST API configuration for polling.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskTypedExpressionArgs']]] typed_expressions: (Updatable) List of typed expressions.
        """
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "registry_metadata", registry_metadata)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if api_call_mode is not None:
            pulumi.set(__self__, "api_call_mode", api_call_mode)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if cancel_rest_call_config is not None:
            pulumi.set(__self__, "cancel_rest_call_config", cancel_rest_call_config)
        if config_provider_delegate is not None:
            pulumi.set(__self__, "config_provider_delegate", config_provider_delegate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_rest_call_config is not None:
            pulumi.set(__self__, "execute_rest_call_config", execute_rest_call_config)
        if input_ports is not None:
            pulumi.set(__self__, "input_ports", input_ports)
        if is_single_load is not None:
            pulumi.set(__self__, "is_single_load", is_single_load)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if op_config_values is not None:
            pulumi.set(__self__, "op_config_values", op_config_values)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if output_ports is not None:
            pulumi.set(__self__, "output_ports", output_ports)
        if parallel_load_limit is not None:
            pulumi.set(__self__, "parallel_load_limit", parallel_load_limit)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if parent_ref is not None:
            pulumi.set(__self__, "parent_ref", parent_ref)
        if poll_rest_call_config is not None:
            pulumi.set(__self__, "poll_rest_call_config", poll_rest_call_config)
        if typed_expressions is not None:
            pulumi.set(__self__, "typed_expressions", typed_expressions)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The type of the task.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> pulumi.Input['WorkspaceTaskRegistryMetadataArgs']:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: pulumi.Input['WorkspaceTaskRegistryMetadataArgs']):
        pulumi.set(self, "registry_metadata", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[builtins.str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter(name="apiCallMode")
    def api_call_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The REST invocation pattern to use. ASYNC_OCI_WORKREQUEST is being deprecated as well as cancelEndpoint/MethodType.
        """
        return pulumi.get(self, "api_call_mode")

    @api_call_mode.setter
    def api_call_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_call_mode", value)

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['WorkspaceTaskAuthConfigArgs']]:
        """
        (Updatable) Authentication configuration for Generic REST invocation.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['WorkspaceTaskAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @property
    @pulumi.getter(name="cancelRestCallConfig")
    def cancel_rest_call_config(self) -> Optional[pulumi.Input['WorkspaceTaskCancelRestCallConfigArgs']]:
        """
        (Updatable) The REST API configuration for cancelling the task.
        """
        return pulumi.get(self, "cancel_rest_call_config")

    @cancel_rest_call_config.setter
    def cancel_rest_call_config(self, value: Optional[pulumi.Input['WorkspaceTaskCancelRestCallConfigArgs']]):
        pulumi.set(self, "cancel_rest_call_config", value)

    @property
    @pulumi.getter(name="configProviderDelegate")
    def config_provider_delegate(self) -> Optional[pulumi.Input['WorkspaceTaskConfigProviderDelegateArgs']]:
        """
        (Updatable) The type to create a config provider.
        """
        return pulumi.get(self, "config_provider_delegate")

    @config_provider_delegate.setter
    def config_provider_delegate(self, value: Optional[pulumi.Input['WorkspaceTaskConfigProviderDelegateArgs']]):
        pulumi.set(self, "config_provider_delegate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executeRestCallConfig")
    def execute_rest_call_config(self) -> Optional[pulumi.Input['WorkspaceTaskExecuteRestCallConfigArgs']]:
        """
        (Updatable) The REST API configuration for execution.
        """
        return pulumi.get(self, "execute_rest_call_config")

    @execute_rest_call_config.setter
    def execute_rest_call_config(self, value: Optional[pulumi.Input['WorkspaceTaskExecuteRestCallConfigArgs']]):
        pulumi.set(self, "execute_rest_call_config", value)

    @property
    @pulumi.getter(name="inputPorts")
    def input_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskInputPortArgs']]]]:
        """
        (Updatable) An array of input ports.
        """
        return pulumi.get(self, "input_ports")

    @input_ports.setter
    def input_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskInputPortArgs']]]]):
        pulumi.set(self, "input_ports", value)

    @property
    @pulumi.getter(name="isSingleLoad")
    def is_single_load(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Defines whether Data Loader task is used for single load or multiple
        """
        return pulumi.get(self, "is_single_load")

    @is_single_load.setter
    def is_single_load(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_single_load", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Generated key that can be used in API calls to identify task. On scenarios where reference to the task is needed, a value can be passed in create.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The object's model version.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="opConfigValues")
    def op_config_values(self) -> Optional[pulumi.Input['WorkspaceTaskOpConfigValuesArgs']]:
        """
        (Updatable) Configuration values can be string, objects, or parameters.
        """
        return pulumi.get(self, "op_config_values")

    @op_config_values.setter
    def op_config_values(self, value: Optional[pulumi.Input['WorkspaceTaskOpConfigValuesArgs']]):
        pulumi.set(self, "op_config_values", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Describes the shape of the execution result
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="outputPorts")
    def output_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskOutputPortArgs']]]]:
        """
        (Updatable) An array of output ports.
        """
        return pulumi.get(self, "output_ports")

    @output_ports.setter
    def output_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskOutputPortArgs']]]]):
        pulumi.set(self, "output_ports", value)

    @property
    @pulumi.getter(name="parallelLoadLimit")
    def parallel_load_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Defines the number of entities being loaded in parallel at a time for a Data Loader task
        """
        return pulumi.get(self, "parallel_load_limit")

    @parallel_load_limit.setter
    def parallel_load_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "parallel_load_limit", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskParameterArgs']]]]:
        """
        (Updatable) An array of parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional[pulumi.Input['WorkspaceTaskParentRefArgs']]:
        """
        (Updatable) A reference to the object's parent.
        """
        return pulumi.get(self, "parent_ref")

    @parent_ref.setter
    def parent_ref(self, value: Optional[pulumi.Input['WorkspaceTaskParentRefArgs']]):
        pulumi.set(self, "parent_ref", value)

    @property
    @pulumi.getter(name="pollRestCallConfig")
    def poll_rest_call_config(self) -> Optional[pulumi.Input['WorkspaceTaskPollRestCallConfigArgs']]:
        """
        (Updatable) The REST API configuration for polling.
        """
        return pulumi.get(self, "poll_rest_call_config")

    @poll_rest_call_config.setter
    def poll_rest_call_config(self, value: Optional[pulumi.Input['WorkspaceTaskPollRestCallConfigArgs']]):
        pulumi.set(self, "poll_rest_call_config", value)

    @property
    @pulumi.getter(name="typedExpressions")
    def typed_expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskTypedExpressionArgs']]]]:
        """
        (Updatable) List of typed expressions.
        """
        return pulumi.get(self, "typed_expressions")

    @typed_expressions.setter
    def typed_expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskTypedExpressionArgs']]]]):
        pulumi.set(self, "typed_expressions", value)


@pulumi.input_type
class _WorkspaceTaskState:
    def __init__(__self__, *,
                 api_call_mode: Optional[pulumi.Input[builtins.str]] = None,
                 auth_config: Optional[pulumi.Input['WorkspaceTaskAuthConfigArgs']] = None,
                 cancel_rest_call_config: Optional[pulumi.Input['WorkspaceTaskCancelRestCallConfigArgs']] = None,
                 config_provider_delegate: Optional[pulumi.Input['WorkspaceTaskConfigProviderDelegateArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execute_rest_call_config: Optional[pulumi.Input['WorkspaceTaskExecuteRestCallConfigArgs']] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 input_ports: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskInputPortArgs']]]] = None,
                 is_single_load: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 key_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskMetadataArgs']]]] = None,
                 model_type: Optional[pulumi.Input[builtins.str]] = None,
                 model_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_status: Optional[pulumi.Input[builtins.int]] = None,
                 object_version: Optional[pulumi.Input[builtins.int]] = None,
                 op_config_values: Optional[pulumi.Input['WorkspaceTaskOpConfigValuesArgs']] = None,
                 operation: Optional[pulumi.Input[builtins.str]] = None,
                 output_ports: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskOutputPortArgs']]]] = None,
                 parallel_load_limit: Optional[pulumi.Input[builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskParameterArgs']]]] = None,
                 parent_ref: Optional[pulumi.Input['WorkspaceTaskParentRefArgs']] = None,
                 poll_rest_call_config: Optional[pulumi.Input['WorkspaceTaskPollRestCallConfigArgs']] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceTaskRegistryMetadataArgs']] = None,
                 typed_expressions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskTypedExpressionArgs']]]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceTask resources.
        :param pulumi.Input[builtins.str] api_call_mode: (Updatable) The REST invocation pattern to use. ASYNC_OCI_WORKREQUEST is being deprecated as well as cancelEndpoint/MethodType.
        :param pulumi.Input['WorkspaceTaskAuthConfigArgs'] auth_config: (Updatable) Authentication configuration for Generic REST invocation.
        :param pulumi.Input['WorkspaceTaskCancelRestCallConfigArgs'] cancel_rest_call_config: (Updatable) The REST API configuration for cancelling the task.
        :param pulumi.Input['WorkspaceTaskConfigProviderDelegateArgs'] config_provider_delegate: (Updatable) The type to create a config provider.
        :param pulumi.Input[builtins.str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input['WorkspaceTaskExecuteRestCallConfigArgs'] execute_rest_call_config: (Updatable) The REST API configuration for execution.
        :param pulumi.Input[builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskInputPortArgs']]] input_ports: (Updatable) An array of input ports.
        :param pulumi.Input[builtins.bool] is_single_load: (Updatable) Defines whether Data Loader task is used for single load or multiple
        :param pulumi.Input[builtins.str] key: (Updatable) Generated key that can be used in API calls to identify task. On scenarios where reference to the task is needed, a value can be passed in create.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] key_map: A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskMetadataArgs']]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[builtins.str] model_type: (Updatable) The type of the task.
        :param pulumi.Input[builtins.str] model_version: (Updatable) The object's model version.
        :param pulumi.Input[builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[builtins.int] object_version: This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input['WorkspaceTaskOpConfigValuesArgs'] op_config_values: (Updatable) Configuration values can be string, objects, or parameters.
        :param pulumi.Input[builtins.str] operation: (Updatable) Describes the shape of the execution result
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskOutputPortArgs']]] output_ports: (Updatable) An array of output ports.
        :param pulumi.Input[builtins.int] parallel_load_limit: (Updatable) Defines the number of entities being loaded in parallel at a time for a Data Loader task
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskParameterArgs']]] parameters: (Updatable) An array of parameters.
        :param pulumi.Input['WorkspaceTaskParentRefArgs'] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input['WorkspaceTaskPollRestCallConfigArgs'] poll_rest_call_config: (Updatable) The REST API configuration for polling.
        :param pulumi.Input['WorkspaceTaskRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskTypedExpressionArgs']]] typed_expressions: (Updatable) List of typed expressions.
        :param pulumi.Input[builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if api_call_mode is not None:
            pulumi.set(__self__, "api_call_mode", api_call_mode)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if cancel_rest_call_config is not None:
            pulumi.set(__self__, "cancel_rest_call_config", cancel_rest_call_config)
        if config_provider_delegate is not None:
            pulumi.set(__self__, "config_provider_delegate", config_provider_delegate)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execute_rest_call_config is not None:
            pulumi.set(__self__, "execute_rest_call_config", execute_rest_call_config)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if input_ports is not None:
            pulumi.set(__self__, "input_ports", input_ports)
        if is_single_load is not None:
            pulumi.set(__self__, "is_single_load", is_single_load)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if key_map is not None:
            pulumi.set(__self__, "key_map", key_map)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if op_config_values is not None:
            pulumi.set(__self__, "op_config_values", op_config_values)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if output_ports is not None:
            pulumi.set(__self__, "output_ports", output_ports)
        if parallel_load_limit is not None:
            pulumi.set(__self__, "parallel_load_limit", parallel_load_limit)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if parent_ref is not None:
            pulumi.set(__self__, "parent_ref", parent_ref)
        if poll_rest_call_config is not None:
            pulumi.set(__self__, "poll_rest_call_config", poll_rest_call_config)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if typed_expressions is not None:
            pulumi.set(__self__, "typed_expressions", typed_expressions)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="apiCallMode")
    def api_call_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The REST invocation pattern to use. ASYNC_OCI_WORKREQUEST is being deprecated as well as cancelEndpoint/MethodType.
        """
        return pulumi.get(self, "api_call_mode")

    @api_call_mode.setter
    def api_call_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_call_mode", value)

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['WorkspaceTaskAuthConfigArgs']]:
        """
        (Updatable) Authentication configuration for Generic REST invocation.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['WorkspaceTaskAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @property
    @pulumi.getter(name="cancelRestCallConfig")
    def cancel_rest_call_config(self) -> Optional[pulumi.Input['WorkspaceTaskCancelRestCallConfigArgs']]:
        """
        (Updatable) The REST API configuration for cancelling the task.
        """
        return pulumi.get(self, "cancel_rest_call_config")

    @cancel_rest_call_config.setter
    def cancel_rest_call_config(self, value: Optional[pulumi.Input['WorkspaceTaskCancelRestCallConfigArgs']]):
        pulumi.set(self, "cancel_rest_call_config", value)

    @property
    @pulumi.getter(name="configProviderDelegate")
    def config_provider_delegate(self) -> Optional[pulumi.Input['WorkspaceTaskConfigProviderDelegateArgs']]:
        """
        (Updatable) The type to create a config provider.
        """
        return pulumi.get(self, "config_provider_delegate")

    @config_provider_delegate.setter
    def config_provider_delegate(self, value: Optional[pulumi.Input['WorkspaceTaskConfigProviderDelegateArgs']]):
        pulumi.set(self, "config_provider_delegate", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executeRestCallConfig")
    def execute_rest_call_config(self) -> Optional[pulumi.Input['WorkspaceTaskExecuteRestCallConfigArgs']]:
        """
        (Updatable) The REST API configuration for execution.
        """
        return pulumi.get(self, "execute_rest_call_config")

    @execute_rest_call_config.setter
    def execute_rest_call_config(self, value: Optional[pulumi.Input['WorkspaceTaskExecuteRestCallConfigArgs']]):
        pulumi.set(self, "execute_rest_call_config", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="inputPorts")
    def input_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskInputPortArgs']]]]:
        """
        (Updatable) An array of input ports.
        """
        return pulumi.get(self, "input_ports")

    @input_ports.setter
    def input_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskInputPortArgs']]]]):
        pulumi.set(self, "input_ports", value)

    @property
    @pulumi.getter(name="isSingleLoad")
    def is_single_load(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Defines whether Data Loader task is used for single load or multiple
        """
        return pulumi.get(self, "is_single_load")

    @is_single_load.setter
    def is_single_load(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_single_load", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Generated key that can be used in API calls to identify task. On scenarios where reference to the task is needed, a value can be passed in create.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @key_map.setter
    def key_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "key_map", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskMetadataArgs']]]]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type of the task.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The object's model version.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "object_version", value)

    @property
    @pulumi.getter(name="opConfigValues")
    def op_config_values(self) -> Optional[pulumi.Input['WorkspaceTaskOpConfigValuesArgs']]:
        """
        (Updatable) Configuration values can be string, objects, or parameters.
        """
        return pulumi.get(self, "op_config_values")

    @op_config_values.setter
    def op_config_values(self, value: Optional[pulumi.Input['WorkspaceTaskOpConfigValuesArgs']]):
        pulumi.set(self, "op_config_values", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Describes the shape of the execution result
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="outputPorts")
    def output_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskOutputPortArgs']]]]:
        """
        (Updatable) An array of output ports.
        """
        return pulumi.get(self, "output_ports")

    @output_ports.setter
    def output_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskOutputPortArgs']]]]):
        pulumi.set(self, "output_ports", value)

    @property
    @pulumi.getter(name="parallelLoadLimit")
    def parallel_load_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Defines the number of entities being loaded in parallel at a time for a Data Loader task
        """
        return pulumi.get(self, "parallel_load_limit")

    @parallel_load_limit.setter
    def parallel_load_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "parallel_load_limit", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskParameterArgs']]]]:
        """
        (Updatable) An array of parameters.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> Optional[pulumi.Input['WorkspaceTaskParentRefArgs']]:
        """
        (Updatable) A reference to the object's parent.
        """
        return pulumi.get(self, "parent_ref")

    @parent_ref.setter
    def parent_ref(self, value: Optional[pulumi.Input['WorkspaceTaskParentRefArgs']]):
        pulumi.set(self, "parent_ref", value)

    @property
    @pulumi.getter(name="pollRestCallConfig")
    def poll_rest_call_config(self) -> Optional[pulumi.Input['WorkspaceTaskPollRestCallConfigArgs']]:
        """
        (Updatable) The REST API configuration for polling.
        """
        return pulumi.get(self, "poll_rest_call_config")

    @poll_rest_call_config.setter
    def poll_rest_call_config(self, value: Optional[pulumi.Input['WorkspaceTaskPollRestCallConfigArgs']]):
        pulumi.set(self, "poll_rest_call_config", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceTaskRegistryMetadataArgs']]:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceTaskRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @property
    @pulumi.getter(name="typedExpressions")
    def typed_expressions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskTypedExpressionArgs']]]]:
        """
        (Updatable) List of typed expressions.
        """
        return pulumi.get(self, "typed_expressions")

    @typed_expressions.setter
    def typed_expressions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceTaskTypedExpressionArgs']]]]):
        pulumi.set(self, "typed_expressions", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workspace_id", value)


class WorkspaceTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_call_mode: Optional[pulumi.Input[builtins.str]] = None,
                 auth_config: Optional[pulumi.Input[Union['WorkspaceTaskAuthConfigArgs', 'WorkspaceTaskAuthConfigArgsDict']]] = None,
                 cancel_rest_call_config: Optional[pulumi.Input[Union['WorkspaceTaskCancelRestCallConfigArgs', 'WorkspaceTaskCancelRestCallConfigArgsDict']]] = None,
                 config_provider_delegate: Optional[pulumi.Input[Union['WorkspaceTaskConfigProviderDelegateArgs', 'WorkspaceTaskConfigProviderDelegateArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execute_rest_call_config: Optional[pulumi.Input[Union['WorkspaceTaskExecuteRestCallConfigArgs', 'WorkspaceTaskExecuteRestCallConfigArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 input_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskInputPortArgs', 'WorkspaceTaskInputPortArgsDict']]]]] = None,
                 is_single_load: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 model_type: Optional[pulumi.Input[builtins.str]] = None,
                 model_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_status: Optional[pulumi.Input[builtins.int]] = None,
                 op_config_values: Optional[pulumi.Input[Union['WorkspaceTaskOpConfigValuesArgs', 'WorkspaceTaskOpConfigValuesArgsDict']]] = None,
                 operation: Optional[pulumi.Input[builtins.str]] = None,
                 output_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskOutputPortArgs', 'WorkspaceTaskOutputPortArgsDict']]]]] = None,
                 parallel_load_limit: Optional[pulumi.Input[builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskParameterArgs', 'WorkspaceTaskParameterArgsDict']]]]] = None,
                 parent_ref: Optional[pulumi.Input[Union['WorkspaceTaskParentRefArgs', 'WorkspaceTaskParentRefArgsDict']]] = None,
                 poll_rest_call_config: Optional[pulumi.Input[Union['WorkspaceTaskPollRestCallConfigArgs', 'WorkspaceTaskPollRestCallConfigArgsDict']]] = None,
                 registry_metadata: Optional[pulumi.Input[Union['WorkspaceTaskRegistryMetadataArgs', 'WorkspaceTaskRegistryMetadataArgsDict']]] = None,
                 typed_expressions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskTypedExpressionArgs', 'WorkspaceTaskTypedExpressionArgsDict']]]]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace Task resource in Oracle Cloud Infrastructure Data Integration service.

        Creates a new task ready for performing data integrations. There are specialized types of tasks that include data loader and integration tasks.

        ## Import

        WorkspaceTasks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceTask:WorkspaceTask test_workspace_task "workspaces/{workspaceId}/tasks/{taskKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_call_mode: (Updatable) The REST invocation pattern to use. ASYNC_OCI_WORKREQUEST is being deprecated as well as cancelEndpoint/MethodType.
        :param pulumi.Input[Union['WorkspaceTaskAuthConfigArgs', 'WorkspaceTaskAuthConfigArgsDict']] auth_config: (Updatable) Authentication configuration for Generic REST invocation.
        :param pulumi.Input[Union['WorkspaceTaskCancelRestCallConfigArgs', 'WorkspaceTaskCancelRestCallConfigArgsDict']] cancel_rest_call_config: (Updatable) The REST API configuration for cancelling the task.
        :param pulumi.Input[Union['WorkspaceTaskConfigProviderDelegateArgs', 'WorkspaceTaskConfigProviderDelegateArgsDict']] config_provider_delegate: (Updatable) The type to create a config provider.
        :param pulumi.Input[builtins.str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[Union['WorkspaceTaskExecuteRestCallConfigArgs', 'WorkspaceTaskExecuteRestCallConfigArgsDict']] execute_rest_call_config: (Updatable) The REST API configuration for execution.
        :param pulumi.Input[builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskInputPortArgs', 'WorkspaceTaskInputPortArgsDict']]]] input_ports: (Updatable) An array of input ports.
        :param pulumi.Input[builtins.bool] is_single_load: (Updatable) Defines whether Data Loader task is used for single load or multiple
        :param pulumi.Input[builtins.str] key: (Updatable) Generated key that can be used in API calls to identify task. On scenarios where reference to the task is needed, a value can be passed in create.
        :param pulumi.Input[builtins.str] model_type: (Updatable) The type of the task.
        :param pulumi.Input[builtins.str] model_version: (Updatable) The object's model version.
        :param pulumi.Input[builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[Union['WorkspaceTaskOpConfigValuesArgs', 'WorkspaceTaskOpConfigValuesArgsDict']] op_config_values: (Updatable) Configuration values can be string, objects, or parameters.
        :param pulumi.Input[builtins.str] operation: (Updatable) Describes the shape of the execution result
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskOutputPortArgs', 'WorkspaceTaskOutputPortArgsDict']]]] output_ports: (Updatable) An array of output ports.
        :param pulumi.Input[builtins.int] parallel_load_limit: (Updatable) Defines the number of entities being loaded in parallel at a time for a Data Loader task
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskParameterArgs', 'WorkspaceTaskParameterArgsDict']]]] parameters: (Updatable) An array of parameters.
        :param pulumi.Input[Union['WorkspaceTaskParentRefArgs', 'WorkspaceTaskParentRefArgsDict']] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input[Union['WorkspaceTaskPollRestCallConfigArgs', 'WorkspaceTaskPollRestCallConfigArgsDict']] poll_rest_call_config: (Updatable) The REST API configuration for polling.
        :param pulumi.Input[Union['WorkspaceTaskRegistryMetadataArgs', 'WorkspaceTaskRegistryMetadataArgsDict']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskTypedExpressionArgs', 'WorkspaceTaskTypedExpressionArgsDict']]]] typed_expressions: (Updatable) List of typed expressions.
        :param pulumi.Input[builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace Task resource in Oracle Cloud Infrastructure Data Integration service.

        Creates a new task ready for performing data integrations. There are specialized types of tasks that include data loader and integration tasks.

        ## Import

        WorkspaceTasks can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceTask:WorkspaceTask test_workspace_task "workspaces/{workspaceId}/tasks/{taskKey}"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_call_mode: Optional[pulumi.Input[builtins.str]] = None,
                 auth_config: Optional[pulumi.Input[Union['WorkspaceTaskAuthConfigArgs', 'WorkspaceTaskAuthConfigArgsDict']]] = None,
                 cancel_rest_call_config: Optional[pulumi.Input[Union['WorkspaceTaskCancelRestCallConfigArgs', 'WorkspaceTaskCancelRestCallConfigArgsDict']]] = None,
                 config_provider_delegate: Optional[pulumi.Input[Union['WorkspaceTaskConfigProviderDelegateArgs', 'WorkspaceTaskConfigProviderDelegateArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 execute_rest_call_config: Optional[pulumi.Input[Union['WorkspaceTaskExecuteRestCallConfigArgs', 'WorkspaceTaskExecuteRestCallConfigArgsDict']]] = None,
                 identifier: Optional[pulumi.Input[builtins.str]] = None,
                 input_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskInputPortArgs', 'WorkspaceTaskInputPortArgsDict']]]]] = None,
                 is_single_load: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 model_type: Optional[pulumi.Input[builtins.str]] = None,
                 model_version: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 object_status: Optional[pulumi.Input[builtins.int]] = None,
                 op_config_values: Optional[pulumi.Input[Union['WorkspaceTaskOpConfigValuesArgs', 'WorkspaceTaskOpConfigValuesArgsDict']]] = None,
                 operation: Optional[pulumi.Input[builtins.str]] = None,
                 output_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskOutputPortArgs', 'WorkspaceTaskOutputPortArgsDict']]]]] = None,
                 parallel_load_limit: Optional[pulumi.Input[builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskParameterArgs', 'WorkspaceTaskParameterArgsDict']]]]] = None,
                 parent_ref: Optional[pulumi.Input[Union['WorkspaceTaskParentRefArgs', 'WorkspaceTaskParentRefArgsDict']]] = None,
                 poll_rest_call_config: Optional[pulumi.Input[Union['WorkspaceTaskPollRestCallConfigArgs', 'WorkspaceTaskPollRestCallConfigArgsDict']]] = None,
                 registry_metadata: Optional[pulumi.Input[Union['WorkspaceTaskRegistryMetadataArgs', 'WorkspaceTaskRegistryMetadataArgsDict']]] = None,
                 typed_expressions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskTypedExpressionArgs', 'WorkspaceTaskTypedExpressionArgsDict']]]]] = None,
                 workspace_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceTaskArgs.__new__(WorkspaceTaskArgs)

            __props__.__dict__["api_call_mode"] = api_call_mode
            __props__.__dict__["auth_config"] = auth_config
            __props__.__dict__["cancel_rest_call_config"] = cancel_rest_call_config
            __props__.__dict__["config_provider_delegate"] = config_provider_delegate
            __props__.__dict__["description"] = description
            __props__.__dict__["execute_rest_call_config"] = execute_rest_call_config
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["input_ports"] = input_ports
            __props__.__dict__["is_single_load"] = is_single_load
            __props__.__dict__["key"] = key
            if model_type is None and not opts.urn:
                raise TypeError("Missing required property 'model_type'")
            __props__.__dict__["model_type"] = model_type
            __props__.__dict__["model_version"] = model_version
            __props__.__dict__["name"] = name
            __props__.__dict__["object_status"] = object_status
            __props__.__dict__["op_config_values"] = op_config_values
            __props__.__dict__["operation"] = operation
            __props__.__dict__["output_ports"] = output_ports
            __props__.__dict__["parallel_load_limit"] = parallel_load_limit
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["parent_ref"] = parent_ref
            __props__.__dict__["poll_rest_call_config"] = poll_rest_call_config
            if registry_metadata is None and not opts.urn:
                raise TypeError("Missing required property 'registry_metadata'")
            __props__.__dict__["registry_metadata"] = registry_metadata
            __props__.__dict__["typed_expressions"] = typed_expressions
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["key_map"] = None
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["object_version"] = None
        super(WorkspaceTask, __self__).__init__(
            'oci:DataIntegration/workspaceTask:WorkspaceTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_call_mode: Optional[pulumi.Input[builtins.str]] = None,
            auth_config: Optional[pulumi.Input[Union['WorkspaceTaskAuthConfigArgs', 'WorkspaceTaskAuthConfigArgsDict']]] = None,
            cancel_rest_call_config: Optional[pulumi.Input[Union['WorkspaceTaskCancelRestCallConfigArgs', 'WorkspaceTaskCancelRestCallConfigArgsDict']]] = None,
            config_provider_delegate: Optional[pulumi.Input[Union['WorkspaceTaskConfigProviderDelegateArgs', 'WorkspaceTaskConfigProviderDelegateArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            execute_rest_call_config: Optional[pulumi.Input[Union['WorkspaceTaskExecuteRestCallConfigArgs', 'WorkspaceTaskExecuteRestCallConfigArgsDict']]] = None,
            identifier: Optional[pulumi.Input[builtins.str]] = None,
            input_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskInputPortArgs', 'WorkspaceTaskInputPortArgsDict']]]]] = None,
            is_single_load: Optional[pulumi.Input[builtins.bool]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            key_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskMetadataArgs', 'WorkspaceTaskMetadataArgsDict']]]]] = None,
            model_type: Optional[pulumi.Input[builtins.str]] = None,
            model_version: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            object_status: Optional[pulumi.Input[builtins.int]] = None,
            object_version: Optional[pulumi.Input[builtins.int]] = None,
            op_config_values: Optional[pulumi.Input[Union['WorkspaceTaskOpConfigValuesArgs', 'WorkspaceTaskOpConfigValuesArgsDict']]] = None,
            operation: Optional[pulumi.Input[builtins.str]] = None,
            output_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskOutputPortArgs', 'WorkspaceTaskOutputPortArgsDict']]]]] = None,
            parallel_load_limit: Optional[pulumi.Input[builtins.int]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskParameterArgs', 'WorkspaceTaskParameterArgsDict']]]]] = None,
            parent_ref: Optional[pulumi.Input[Union['WorkspaceTaskParentRefArgs', 'WorkspaceTaskParentRefArgsDict']]] = None,
            poll_rest_call_config: Optional[pulumi.Input[Union['WorkspaceTaskPollRestCallConfigArgs', 'WorkspaceTaskPollRestCallConfigArgsDict']]] = None,
            registry_metadata: Optional[pulumi.Input[Union['WorkspaceTaskRegistryMetadataArgs', 'WorkspaceTaskRegistryMetadataArgsDict']]] = None,
            typed_expressions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskTypedExpressionArgs', 'WorkspaceTaskTypedExpressionArgsDict']]]]] = None,
            workspace_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkspaceTask':
        """
        Get an existing WorkspaceTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_call_mode: (Updatable) The REST invocation pattern to use. ASYNC_OCI_WORKREQUEST is being deprecated as well as cancelEndpoint/MethodType.
        :param pulumi.Input[Union['WorkspaceTaskAuthConfigArgs', 'WorkspaceTaskAuthConfigArgsDict']] auth_config: (Updatable) Authentication configuration for Generic REST invocation.
        :param pulumi.Input[Union['WorkspaceTaskCancelRestCallConfigArgs', 'WorkspaceTaskCancelRestCallConfigArgsDict']] cancel_rest_call_config: (Updatable) The REST API configuration for cancelling the task.
        :param pulumi.Input[Union['WorkspaceTaskConfigProviderDelegateArgs', 'WorkspaceTaskConfigProviderDelegateArgsDict']] config_provider_delegate: (Updatable) The type to create a config provider.
        :param pulumi.Input[builtins.str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[Union['WorkspaceTaskExecuteRestCallConfigArgs', 'WorkspaceTaskExecuteRestCallConfigArgsDict']] execute_rest_call_config: (Updatable) The REST API configuration for execution.
        :param pulumi.Input[builtins.str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskInputPortArgs', 'WorkspaceTaskInputPortArgsDict']]]] input_ports: (Updatable) An array of input ports.
        :param pulumi.Input[builtins.bool] is_single_load: (Updatable) Defines whether Data Loader task is used for single load or multiple
        :param pulumi.Input[builtins.str] key: (Updatable) Generated key that can be used in API calls to identify task. On scenarios where reference to the task is needed, a value can be passed in create.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] key_map: A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskMetadataArgs', 'WorkspaceTaskMetadataArgsDict']]]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[builtins.str] model_type: (Updatable) The type of the task.
        :param pulumi.Input[builtins.str] model_version: (Updatable) The object's model version.
        :param pulumi.Input[builtins.str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[builtins.int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[builtins.int] object_version: This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input[Union['WorkspaceTaskOpConfigValuesArgs', 'WorkspaceTaskOpConfigValuesArgsDict']] op_config_values: (Updatable) Configuration values can be string, objects, or parameters.
        :param pulumi.Input[builtins.str] operation: (Updatable) Describes the shape of the execution result
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskOutputPortArgs', 'WorkspaceTaskOutputPortArgsDict']]]] output_ports: (Updatable) An array of output ports.
        :param pulumi.Input[builtins.int] parallel_load_limit: (Updatable) Defines the number of entities being loaded in parallel at a time for a Data Loader task
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskParameterArgs', 'WorkspaceTaskParameterArgsDict']]]] parameters: (Updatable) An array of parameters.
        :param pulumi.Input[Union['WorkspaceTaskParentRefArgs', 'WorkspaceTaskParentRefArgsDict']] parent_ref: (Updatable) A reference to the object's parent.
        :param pulumi.Input[Union['WorkspaceTaskPollRestCallConfigArgs', 'WorkspaceTaskPollRestCallConfigArgsDict']] poll_rest_call_config: (Updatable) The REST API configuration for polling.
        :param pulumi.Input[Union['WorkspaceTaskRegistryMetadataArgs', 'WorkspaceTaskRegistryMetadataArgsDict']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkspaceTaskTypedExpressionArgs', 'WorkspaceTaskTypedExpressionArgsDict']]]] typed_expressions: (Updatable) List of typed expressions.
        :param pulumi.Input[builtins.str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceTaskState.__new__(_WorkspaceTaskState)

        __props__.__dict__["api_call_mode"] = api_call_mode
        __props__.__dict__["auth_config"] = auth_config
        __props__.__dict__["cancel_rest_call_config"] = cancel_rest_call_config
        __props__.__dict__["config_provider_delegate"] = config_provider_delegate
        __props__.__dict__["description"] = description
        __props__.__dict__["execute_rest_call_config"] = execute_rest_call_config
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["input_ports"] = input_ports
        __props__.__dict__["is_single_load"] = is_single_load
        __props__.__dict__["key"] = key
        __props__.__dict__["key_map"] = key_map
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["name"] = name
        __props__.__dict__["object_status"] = object_status
        __props__.__dict__["object_version"] = object_version
        __props__.__dict__["op_config_values"] = op_config_values
        __props__.__dict__["operation"] = operation
        __props__.__dict__["output_ports"] = output_ports
        __props__.__dict__["parallel_load_limit"] = parallel_load_limit
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["parent_ref"] = parent_ref
        __props__.__dict__["poll_rest_call_config"] = poll_rest_call_config
        __props__.__dict__["registry_metadata"] = registry_metadata
        __props__.__dict__["typed_expressions"] = typed_expressions
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceTask(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiCallMode")
    def api_call_mode(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The REST invocation pattern to use. ASYNC_OCI_WORKREQUEST is being deprecated as well as cancelEndpoint/MethodType.
        """
        return pulumi.get(self, "api_call_mode")

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> pulumi.Output['outputs.WorkspaceTaskAuthConfig']:
        """
        (Updatable) Authentication configuration for Generic REST invocation.
        """
        return pulumi.get(self, "auth_config")

    @property
    @pulumi.getter(name="cancelRestCallConfig")
    def cancel_rest_call_config(self) -> pulumi.Output['outputs.WorkspaceTaskCancelRestCallConfig']:
        """
        (Updatable) The REST API configuration for cancelling the task.
        """
        return pulumi.get(self, "cancel_rest_call_config")

    @property
    @pulumi.getter(name="configProviderDelegate")
    def config_provider_delegate(self) -> pulumi.Output['outputs.WorkspaceTaskConfigProviderDelegate']:
        """
        (Updatable) The type to create a config provider.
        """
        return pulumi.get(self, "config_provider_delegate")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executeRestCallConfig")
    def execute_rest_call_config(self) -> pulumi.Output['outputs.WorkspaceTaskExecuteRestCallConfig']:
        """
        (Updatable) The REST API configuration for execution.
        """
        return pulumi.get(self, "execute_rest_call_config")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="inputPorts")
    def input_ports(self) -> pulumi.Output[Sequence['outputs.WorkspaceTaskInputPort']]:
        """
        (Updatable) An array of input ports.
        """
        return pulumi.get(self, "input_ports")

    @property
    @pulumi.getter(name="isSingleLoad")
    def is_single_load(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Defines whether Data Loader task is used for single load or multiple
        """
        return pulumi.get(self, "is_single_load")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Generated key that can be used in API calls to identify task. On scenarios where reference to the task is needed, a value can be passed in create.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="keyMap")
    def key_map(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A key map. If provided, key is replaced with generated key. This structure provides mapping between user provided key and generated key.
        """
        return pulumi.get(self, "key_map")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceTaskMetadata']]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The type of the task.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The object's model version.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> pulumi.Output[builtins.int]:
        """
        This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @property
    @pulumi.getter(name="opConfigValues")
    def op_config_values(self) -> pulumi.Output['outputs.WorkspaceTaskOpConfigValues']:
        """
        (Updatable) Configuration values can be string, objects, or parameters.
        """
        return pulumi.get(self, "op_config_values")

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Describes the shape of the execution result
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="outputPorts")
    def output_ports(self) -> pulumi.Output[Sequence['outputs.WorkspaceTaskOutputPort']]:
        """
        (Updatable) An array of output ports.
        """
        return pulumi.get(self, "output_ports")

    @property
    @pulumi.getter(name="parallelLoadLimit")
    def parallel_load_limit(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) Defines the number of entities being loaded in parallel at a time for a Data Loader task
        """
        return pulumi.get(self, "parallel_load_limit")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.WorkspaceTaskParameter']]:
        """
        (Updatable) An array of parameters.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="parentRef")
    def parent_ref(self) -> pulumi.Output['outputs.WorkspaceTaskParentRef']:
        """
        (Updatable) A reference to the object's parent.
        """
        return pulumi.get(self, "parent_ref")

    @property
    @pulumi.getter(name="pollRestCallConfig")
    def poll_rest_call_config(self) -> pulumi.Output['outputs.WorkspaceTaskPollRestCallConfig']:
        """
        (Updatable) The REST API configuration for polling.
        """
        return pulumi.get(self, "poll_rest_call_config")

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> pulumi.Output['outputs.WorkspaceTaskRegistryMetadata']:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @property
    @pulumi.getter(name="typedExpressions")
    def typed_expressions(self) -> pulumi.Output[Sequence['outputs.WorkspaceTaskTypedExpression']]:
        """
        (Updatable) List of typed expressions.
        """
        return pulumi.get(self, "typed_expressions")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[builtins.str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

