# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSqlFirewallPolicyResult',
    'AwaitableGetSqlFirewallPolicyResult',
    'get_sql_firewall_policy',
    'get_sql_firewall_policy_output',
]

@pulumi.output_type
class GetSqlFirewallPolicyResult:
    """
    A collection of values returned by getSqlFirewallPolicy.
    """
    def __init__(__self__, allowed_client_ips=None, allowed_client_os_usernames=None, allowed_client_programs=None, compartment_id=None, db_user_name=None, defined_tags=None, description=None, display_name=None, enforcement_scope=None, freeform_tags=None, id=None, lifecycle_details=None, security_policy_id=None, sql_firewall_policy_id=None, sql_level=None, state=None, status=None, system_tags=None, time_created=None, time_updated=None, violation_action=None, violation_audit=None):
        if allowed_client_ips and not isinstance(allowed_client_ips, list):
            raise TypeError("Expected argument 'allowed_client_ips' to be a list")
        pulumi.set(__self__, "allowed_client_ips", allowed_client_ips)
        if allowed_client_os_usernames and not isinstance(allowed_client_os_usernames, list):
            raise TypeError("Expected argument 'allowed_client_os_usernames' to be a list")
        pulumi.set(__self__, "allowed_client_os_usernames", allowed_client_os_usernames)
        if allowed_client_programs and not isinstance(allowed_client_programs, list):
            raise TypeError("Expected argument 'allowed_client_programs' to be a list")
        pulumi.set(__self__, "allowed_client_programs", allowed_client_programs)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if db_user_name and not isinstance(db_user_name, str):
            raise TypeError("Expected argument 'db_user_name' to be a str")
        pulumi.set(__self__, "db_user_name", db_user_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enforcement_scope and not isinstance(enforcement_scope, str):
            raise TypeError("Expected argument 'enforcement_scope' to be a str")
        pulumi.set(__self__, "enforcement_scope", enforcement_scope)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if security_policy_id and not isinstance(security_policy_id, str):
            raise TypeError("Expected argument 'security_policy_id' to be a str")
        pulumi.set(__self__, "security_policy_id", security_policy_id)
        if sql_firewall_policy_id and not isinstance(sql_firewall_policy_id, str):
            raise TypeError("Expected argument 'sql_firewall_policy_id' to be a str")
        pulumi.set(__self__, "sql_firewall_policy_id", sql_firewall_policy_id)
        if sql_level and not isinstance(sql_level, str):
            raise TypeError("Expected argument 'sql_level' to be a str")
        pulumi.set(__self__, "sql_level", sql_level)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if violation_action and not isinstance(violation_action, str):
            raise TypeError("Expected argument 'violation_action' to be a str")
        pulumi.set(__self__, "violation_action", violation_action)
        if violation_audit and not isinstance(violation_audit, str):
            raise TypeError("Expected argument 'violation_audit' to be a str")
        pulumi.set(__self__, "violation_audit", violation_audit)

    @property
    @pulumi.getter(name="allowedClientIps")
    def allowed_client_ips(self) -> Sequence[builtins.str]:
        """
        The list of allowed ip addresses for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_ips")

    @property
    @pulumi.getter(name="allowedClientOsUsernames")
    def allowed_client_os_usernames(self) -> Sequence[builtins.str]:
        """
        The list of allowed operating system user names for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_os_usernames")

    @property
    @pulumi.getter(name="allowedClientPrograms")
    def allowed_client_programs(self) -> Sequence[builtins.str]:
        """
        The list of allowed client programs for the SQL Firewall policy.
        """
        return pulumi.get(self, "allowed_client_programs")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment containing the SQL Firewall policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> builtins.str:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the SQL Firewall policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the SQL Firewall policy.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enforcementScope")
    def enforcement_scope(self) -> builtins.str:
        """
        Specifies the SQL Firewall policy enforcement option.
        """
        return pulumi.get(self, "enforcement_scope")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the SQL Firewall policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Details about the current state of the SQL Firewall policy in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> builtins.str:
        """
        The OCID of the security policy corresponding to the SQL Firewall policy.
        """
        return pulumi.get(self, "security_policy_id")

    @property
    @pulumi.getter(name="sqlFirewallPolicyId")
    def sql_firewall_policy_id(self) -> builtins.str:
        return pulumi.get(self, "sql_firewall_policy_id")

    @property
    @pulumi.getter(name="sqlLevel")
    def sql_level(self) -> builtins.str:
        """
        Specifies the level of SQL included for this SQL Firewall policy. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        """
        return pulumi.get(self, "sql_level")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the SQL Firewall policy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Specifies whether the SQL Firewall policy is enabled or disabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time that the SQL Firewall policy was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the SQL Firewall policy was last updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="violationAction")
    def violation_action(self) -> builtins.str:
        """
        Specifies the mode in which the SQL Firewall policy is enabled.
        """
        return pulumi.get(self, "violation_action")

    @property
    @pulumi.getter(name="violationAudit")
    def violation_audit(self) -> builtins.str:
        """
        Specifies whether a unified audit policy should be enabled for auditing the SQL Firewall policy violations.
        """
        return pulumi.get(self, "violation_audit")


class AwaitableGetSqlFirewallPolicyResult(GetSqlFirewallPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlFirewallPolicyResult(
            allowed_client_ips=self.allowed_client_ips,
            allowed_client_os_usernames=self.allowed_client_os_usernames,
            allowed_client_programs=self.allowed_client_programs,
            compartment_id=self.compartment_id,
            db_user_name=self.db_user_name,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            enforcement_scope=self.enforcement_scope,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            security_policy_id=self.security_policy_id,
            sql_firewall_policy_id=self.sql_firewall_policy_id,
            sql_level=self.sql_level,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            violation_action=self.violation_action,
            violation_audit=self.violation_audit)


def get_sql_firewall_policy(sql_firewall_policy_id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlFirewallPolicyResult:
    """
    This data source provides details about a specific Sql Firewall Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a SQL Firewall policy by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_policy = oci.DataSafe.get_sql_firewall_policy(sql_firewall_policy_id=test_sql_firewall_policy_oci_data_safe_sql_firewall_policy["id"])
    ```


    :param builtins.str sql_firewall_policy_id: The OCID of the SQL Firewall policy resource.
    """
    __args__ = dict()
    __args__['sqlFirewallPolicyId'] = sql_firewall_policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSqlFirewallPolicy:getSqlFirewallPolicy', __args__, opts=opts, typ=GetSqlFirewallPolicyResult).value

    return AwaitableGetSqlFirewallPolicyResult(
        allowed_client_ips=pulumi.get(__ret__, 'allowed_client_ips'),
        allowed_client_os_usernames=pulumi.get(__ret__, 'allowed_client_os_usernames'),
        allowed_client_programs=pulumi.get(__ret__, 'allowed_client_programs'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        db_user_name=pulumi.get(__ret__, 'db_user_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        enforcement_scope=pulumi.get(__ret__, 'enforcement_scope'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        security_policy_id=pulumi.get(__ret__, 'security_policy_id'),
        sql_firewall_policy_id=pulumi.get(__ret__, 'sql_firewall_policy_id'),
        sql_level=pulumi.get(__ret__, 'sql_level'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        violation_action=pulumi.get(__ret__, 'violation_action'),
        violation_audit=pulumi.get(__ret__, 'violation_audit'))
def get_sql_firewall_policy_output(sql_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSqlFirewallPolicyResult]:
    """
    This data source provides details about a specific Sql Firewall Policy resource in Oracle Cloud Infrastructure Data Safe service.

    Gets a SQL Firewall policy by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_firewall_policy = oci.DataSafe.get_sql_firewall_policy(sql_firewall_policy_id=test_sql_firewall_policy_oci_data_safe_sql_firewall_policy["id"])
    ```


    :param builtins.str sql_firewall_policy_id: The OCID of the SQL Firewall policy resource.
    """
    __args__ = dict()
    __args__['sqlFirewallPolicyId'] = sql_firewall_policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSqlFirewallPolicy:getSqlFirewallPolicy', __args__, opts=opts, typ=GetSqlFirewallPolicyResult)
    return __ret__.apply(lambda __response__: GetSqlFirewallPolicyResult(
        allowed_client_ips=pulumi.get(__response__, 'allowed_client_ips'),
        allowed_client_os_usernames=pulumi.get(__response__, 'allowed_client_os_usernames'),
        allowed_client_programs=pulumi.get(__response__, 'allowed_client_programs'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        db_user_name=pulumi.get(__response__, 'db_user_name'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        enforcement_scope=pulumi.get(__response__, 'enforcement_scope'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        security_policy_id=pulumi.get(__response__, 'security_policy_id'),
        sql_firewall_policy_id=pulumi.get(__response__, 'sql_firewall_policy_id'),
        sql_level=pulumi.get(__response__, 'sql_level'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        violation_action=pulumi.get(__response__, 'violation_action'),
        violation_audit=pulumi.get(__response__, 'violation_audit')))
