# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MaskingPoliciesMaskingColumnArgs', 'MaskingPoliciesMaskingColumn']

@pulumi.input_type
class MaskingPoliciesMaskingColumnArgs:
    def __init__(__self__, *,
                 column_name: pulumi.Input[builtins.str],
                 masking_policy_id: pulumi.Input[builtins.str],
                 object: pulumi.Input[builtins.str],
                 schema_name: pulumi.Input[builtins.str],
                 is_masking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 masking_column_group: Optional[pulumi.Input[builtins.str]] = None,
                 masking_formats: Optional[pulumi.Input[Sequence[pulumi.Input['MaskingPoliciesMaskingColumnMaskingFormatArgs']]]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_type_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MaskingPoliciesMaskingColumn resource.
        :param pulumi.Input[builtins.str] column_name: The name of the database column. This attribute cannot be updated for an existing  masking column. Note that the same name is used for the masking column. There  is no separate displayName attribute for the masking column.
        :param pulumi.Input[builtins.str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[builtins.str] object: The name of the object (table or editioning view) that contains the database column. This attribute cannot be updated for an existing masking column.
        :param pulumi.Input[builtins.str] schema_name: The name of the schema that contains the database column. This attribute cannot be updated for an existing masking column.
        :param pulumi.Input[builtins.bool] is_masking_enabled: (Updatable) Indicates whether data masking is enabled for the masking column. Set it to false if  you don't want to mask the column.
        :param pulumi.Input[builtins.str] masking_column_group: (Updatable) The group of the masking column. It's a masking group identifier and can be any string  of acceptable length. All the columns in a group are masked together to ensure that  the masked data across these columns continue to retain the same logical relationship.  For more details, check  <a href=https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037>Group Masking in the Data Safe documentation.</a>
        :param pulumi.Input[Sequence[pulumi.Input['MaskingPoliciesMaskingColumnMaskingFormatArgs']]] masking_formats: (Updatable) The masking formats to be assigned to the masking column. You can specify a condition  as part of each masking format. It enables you to do  <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/conditional-masking.html">conditional masking</a>  so that you can mask the column data values differently using different masking  formats and the associated conditions. A masking format can have one or more format  entries. The combined output of all the format entries is used for masking. It  provides the flexibility to define a masking format that can generate different parts  of a data value separately and then combine them to get the final data value for masking.
        :param pulumi.Input[builtins.str] object_type: (Updatable) The type of the object that contains the database column.
        :param pulumi.Input[builtins.str] sensitive_type_id: (Updatable) The OCID of the sensitive type to be associated with the masking column. Note that  if the maskingFormats attribute isn't provided while creating a masking column,   the default masking format associated with the specified sensitive type is assigned  to the masking column.  
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "schema_name", schema_name)
        if is_masking_enabled is not None:
            pulumi.set(__self__, "is_masking_enabled", is_masking_enabled)
        if masking_column_group is not None:
            pulumi.set(__self__, "masking_column_group", masking_column_group)
        if masking_formats is not None:
            pulumi.set(__self__, "masking_formats", masking_formats)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if sensitive_type_id is not None:
            pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the database column. This attribute cannot be updated for an existing  masking column. Note that the same name is used for the masking column. There  is no separate displayName attribute for the masking column.
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "column_name", value)

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @masking_policy_id.setter
    def masking_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "masking_policy_id", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[builtins.str]:
        """
        The name of the object (table or editioning view) that contains the database column. This attribute cannot be updated for an existing masking column.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the schema that contains the database column. This attribute cannot be updated for an existing masking column.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="isMaskingEnabled")
    def is_masking_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates whether data masking is enabled for the masking column. Set it to false if  you don't want to mask the column.
        """
        return pulumi.get(self, "is_masking_enabled")

    @is_masking_enabled.setter
    def is_masking_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_masking_enabled", value)

    @property
    @pulumi.getter(name="maskingColumnGroup")
    def masking_column_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The group of the masking column. It's a masking group identifier and can be any string  of acceptable length. All the columns in a group are masked together to ensure that  the masked data across these columns continue to retain the same logical relationship.  For more details, check  <a href=https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037>Group Masking in the Data Safe documentation.</a>
        """
        return pulumi.get(self, "masking_column_group")

    @masking_column_group.setter
    def masking_column_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "masking_column_group", value)

    @property
    @pulumi.getter(name="maskingFormats")
    def masking_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MaskingPoliciesMaskingColumnMaskingFormatArgs']]]]:
        """
        (Updatable) The masking formats to be assigned to the masking column. You can specify a condition  as part of each masking format. It enables you to do  <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/conditional-masking.html">conditional masking</a>  so that you can mask the column data values differently using different masking  formats and the associated conditions. A masking format can have one or more format  entries. The combined output of all the format entries is used for masking. It  provides the flexibility to define a masking format that can generate different parts  of a data value separately and then combine them to get the final data value for masking.
        """
        return pulumi.get(self, "masking_formats")

    @masking_formats.setter
    def masking_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MaskingPoliciesMaskingColumnMaskingFormatArgs']]]]):
        pulumi.set(self, "masking_formats", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type of the object that contains the database column.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_type", value)

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the sensitive type to be associated with the masking column. Note that  if the maskingFormats attribute isn't provided while creating a masking column,   the default masking format associated with the specified sensitive type is assigned  to the masking column.  


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_type_id")

    @sensitive_type_id.setter
    def sensitive_type_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sensitive_type_id", value)


@pulumi.input_type
class _MaskingPoliciesMaskingColumnState:
    def __init__(__self__, *,
                 child_columns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 column_name: Optional[pulumi.Input[builtins.str]] = None,
                 data_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_masking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 masking_column_group: Optional[pulumi.Input[builtins.str]] = None,
                 masking_formats: Optional[pulumi.Input[Sequence[pulumi.Input['MaskingPoliciesMaskingColumnMaskingFormatArgs']]]] = None,
                 masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MaskingPoliciesMaskingColumn resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] child_columns: An array of child columns that are in referential relationship with the masking column.
        :param pulumi.Input[builtins.str] column_name: The name of the database column. This attribute cannot be updated for an existing  masking column. Note that the same name is used for the masking column. There  is no separate displayName attribute for the masking column.
        :param pulumi.Input[builtins.str] data_type: The data type of the masking column.
        :param pulumi.Input[builtins.bool] is_masking_enabled: (Updatable) Indicates whether data masking is enabled for the masking column. Set it to false if  you don't want to mask the column.
        :param pulumi.Input[builtins.str] key: The unique key that identifies the masking column. It's numeric and unique within a masking policy.
        :param pulumi.Input[builtins.str] lifecycle_details: Details about the current state of the masking column.
        :param pulumi.Input[builtins.str] masking_column_group: (Updatable) The group of the masking column. It's a masking group identifier and can be any string  of acceptable length. All the columns in a group are masked together to ensure that  the masked data across these columns continue to retain the same logical relationship.  For more details, check  <a href=https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037>Group Masking in the Data Safe documentation.</a>
        :param pulumi.Input[Sequence[pulumi.Input['MaskingPoliciesMaskingColumnMaskingFormatArgs']]] masking_formats: (Updatable) The masking formats to be assigned to the masking column. You can specify a condition  as part of each masking format. It enables you to do  <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/conditional-masking.html">conditional masking</a>  so that you can mask the column data values differently using different masking  formats and the associated conditions. A masking format can have one or more format  entries. The combined output of all the format entries is used for masking. It  provides the flexibility to define a masking format that can generate different parts  of a data value separately and then combine them to get the final data value for masking.
        :param pulumi.Input[builtins.str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[builtins.str] object: The name of the object (table or editioning view) that contains the database column. This attribute cannot be updated for an existing masking column.
        :param pulumi.Input[builtins.str] object_type: (Updatable) The type of the object that contains the database column.
        :param pulumi.Input[builtins.str] schema_name: The name of the schema that contains the database column. This attribute cannot be updated for an existing masking column.
        :param pulumi.Input[builtins.str] sensitive_type_id: (Updatable) The OCID of the sensitive type to be associated with the masking column. Note that  if the maskingFormats attribute isn't provided while creating a masking column,   the default masking format associated with the specified sensitive type is assigned  to the masking column.  
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the masking column.
        :param pulumi.Input[builtins.str] time_created: The date and time the masking column was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: The date and time the masking column was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        if child_columns is not None:
            pulumi.set(__self__, "child_columns", child_columns)
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if is_masking_enabled is not None:
            pulumi.set(__self__, "is_masking_enabled", is_masking_enabled)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if masking_column_group is not None:
            pulumi.set(__self__, "masking_column_group", masking_column_group)
        if masking_formats is not None:
            pulumi.set(__self__, "masking_formats", masking_formats)
        if masking_policy_id is not None:
            pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if sensitive_type_id is not None:
            pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="childColumns")
    def child_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of child columns that are in referential relationship with the masking column.
        """
        return pulumi.get(self, "child_columns")

    @child_columns.setter
    def child_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "child_columns", value)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the database column. This attribute cannot be updated for an existing  masking column. Note that the same name is used for the masking column. There  is no separate displayName attribute for the masking column.
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "column_name", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The data type of the masking column.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="isMaskingEnabled")
    def is_masking_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Indicates whether data masking is enabled for the masking column. Set it to false if  you don't want to mask the column.
        """
        return pulumi.get(self, "is_masking_enabled")

    @is_masking_enabled.setter
    def is_masking_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_masking_enabled", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique key that identifies the masking column. It's numeric and unique within a masking policy.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Details about the current state of the masking column.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maskingColumnGroup")
    def masking_column_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The group of the masking column. It's a masking group identifier and can be any string  of acceptable length. All the columns in a group are masked together to ensure that  the masked data across these columns continue to retain the same logical relationship.  For more details, check  <a href=https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037>Group Masking in the Data Safe documentation.</a>
        """
        return pulumi.get(self, "masking_column_group")

    @masking_column_group.setter
    def masking_column_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "masking_column_group", value)

    @property
    @pulumi.getter(name="maskingFormats")
    def masking_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MaskingPoliciesMaskingColumnMaskingFormatArgs']]]]:
        """
        (Updatable) The masking formats to be assigned to the masking column. You can specify a condition  as part of each masking format. It enables you to do  <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/conditional-masking.html">conditional masking</a>  so that you can mask the column data values differently using different masking  formats and the associated conditions. A masking format can have one or more format  entries. The combined output of all the format entries is used for masking. It  provides the flexibility to define a masking format that can generate different parts  of a data value separately and then combine them to get the final data value for masking.
        """
        return pulumi.get(self, "masking_formats")

    @masking_formats.setter
    def masking_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MaskingPoliciesMaskingColumnMaskingFormatArgs']]]]):
        pulumi.set(self, "masking_formats", value)

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @masking_policy_id.setter
    def masking_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "masking_policy_id", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the object (table or editioning view) that contains the database column. This attribute cannot be updated for an existing masking column.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type of the object that contains the database column.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_type", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the schema that contains the database column. This attribute cannot be updated for an existing masking column.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the sensitive type to be associated with the masking column. Note that  if the maskingFormats attribute isn't provided while creating a masking column,   the default masking format associated with the specified sensitive type is assigned  to the masking column.  


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_type_id")

    @sensitive_type_id.setter
    def sensitive_type_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sensitive_type_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the masking column.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the masking column was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the masking column was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class MaskingPoliciesMaskingColumn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_masking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 masking_column_group: Optional[pulumi.Input[builtins.str]] = None,
                 masking_formats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MaskingPoliciesMaskingColumnMaskingFormatArgs', 'MaskingPoliciesMaskingColumnMaskingFormatArgsDict']]]]] = None,
                 masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Masking Policies Masking Column resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new masking column in the specified masking policy. Use this operation
        to add parent columns only. It automatically adds the child columns from the
        associated sensitive data model or target database. If you provide the
        sensitiveTypeId attribute but not the maskingFormats attribute, it automatically
        assigns the default masking format associated with the specified sensitive type.
        Alternatively, if you provide the maskingFormats attribute, the specified masking
        formats are assigned to the column.

        Using the maskingFormats attribute, you can assign one or more masking formats
        to a column. You need to specify a condition as part of each masking format. It
        enables you to do <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/conditional-masking.html">conditional masking</a>
        so that you can mask the column data values differently using different
        masking conditions. A masking format can have one or more format entries. The
        combined output of all the format entries is used for masking. It provides the
        flexibility to define a masking format that can generate different parts of a data
        value separately and then combine them to get the final data value for masking.

        You can use the maskingColumnGroup attribute to group the columns that you would
        like to mask together. It enables you to do <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037">group or compound masking</a> that ensures that the
        masked data across the columns in a group continue to retain the same logical relationship.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_masking_policies_masking_column = oci.data_safe.MaskingPoliciesMaskingColumn("test_masking_policies_masking_column",
            column_name=masking_policies_masking_column_column_name,
            masking_policy_id=test_masking_policy["id"],
            object=masking_policies_masking_column_object,
            schema_name=masking_policies_masking_column_schema_name,
            is_masking_enabled=masking_policies_masking_column_is_masking_enabled,
            masking_column_group=masking_policies_masking_column_masking_column_group,
            masking_formats=[{
                "format_entries": [{
                    "type": masking_policies_masking_column_masking_formats_format_entries_type,
                    "column_name": masking_policies_masking_column_masking_formats_format_entries_column_name,
                    "description": masking_policies_masking_column_masking_formats_format_entries_description,
                    "end_date": masking_policies_masking_column_masking_formats_format_entries_end_date,
                    "end_length": masking_policies_masking_column_masking_formats_format_entries_end_length,
                    "end_value": masking_policies_masking_column_masking_formats_format_entries_end_value,
                    "fixed_number": masking_policies_masking_column_masking_formats_format_entries_fixed_number,
                    "fixed_string": masking_policies_masking_column_masking_formats_format_entries_fixed_string,
                    "grouping_columns": masking_policies_masking_column_masking_formats_format_entries_grouping_columns,
                    "length": masking_policies_masking_column_masking_formats_format_entries_length,
                    "library_masking_format_id": test_library_masking_format["id"],
                    "pattern": masking_policies_masking_column_masking_formats_format_entries_pattern,
                    "post_processing_function": masking_policies_masking_column_masking_formats_format_entries_post_processing_function,
                    "random_lists": masking_policies_masking_column_masking_formats_format_entries_random_list,
                    "regular_expression": masking_policies_masking_column_masking_formats_format_entries_regular_expression,
                    "replace_with": masking_policies_masking_column_masking_formats_format_entries_replace_with,
                    "schema_name": masking_policies_masking_column_masking_formats_format_entries_schema_name,
                    "sql_expression": masking_policies_masking_column_masking_formats_format_entries_sql_expression,
                    "start_date": masking_policies_masking_column_masking_formats_format_entries_start_date,
                    "start_length": masking_policies_masking_column_masking_formats_format_entries_start_length,
                    "start_position": masking_policies_masking_column_masking_formats_format_entries_start_position,
                    "start_value": masking_policies_masking_column_masking_formats_format_entries_start_value,
                    "table_name": test_table["name"],
                    "user_defined_function": masking_policies_masking_column_masking_formats_format_entries_user_defined_function,
                }],
                "condition": masking_policies_masking_column_masking_formats_condition,
                "description": masking_policies_masking_column_masking_formats_description,
            }],
            object_type=masking_policies_masking_column_object_type,
            sensitive_type_id=test_sensitive_type["id"])
        ```

        ## Import

        MaskingPoliciesMaskingColumns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/maskingPoliciesMaskingColumn:MaskingPoliciesMaskingColumn test_masking_policies_masking_column "maskingPolicies/{maskingPolicyId}/maskingColumns/{maskingColumnKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] column_name: The name of the database column. This attribute cannot be updated for an existing  masking column. Note that the same name is used for the masking column. There  is no separate displayName attribute for the masking column.
        :param pulumi.Input[builtins.bool] is_masking_enabled: (Updatable) Indicates whether data masking is enabled for the masking column. Set it to false if  you don't want to mask the column.
        :param pulumi.Input[builtins.str] masking_column_group: (Updatable) The group of the masking column. It's a masking group identifier and can be any string  of acceptable length. All the columns in a group are masked together to ensure that  the masked data across these columns continue to retain the same logical relationship.  For more details, check  <a href=https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037>Group Masking in the Data Safe documentation.</a>
        :param pulumi.Input[Sequence[pulumi.Input[Union['MaskingPoliciesMaskingColumnMaskingFormatArgs', 'MaskingPoliciesMaskingColumnMaskingFormatArgsDict']]]] masking_formats: (Updatable) The masking formats to be assigned to the masking column. You can specify a condition  as part of each masking format. It enables you to do  <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/conditional-masking.html">conditional masking</a>  so that you can mask the column data values differently using different masking  formats and the associated conditions. A masking format can have one or more format  entries. The combined output of all the format entries is used for masking. It  provides the flexibility to define a masking format that can generate different parts  of a data value separately and then combine them to get the final data value for masking.
        :param pulumi.Input[builtins.str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[builtins.str] object: The name of the object (table or editioning view) that contains the database column. This attribute cannot be updated for an existing masking column.
        :param pulumi.Input[builtins.str] object_type: (Updatable) The type of the object that contains the database column.
        :param pulumi.Input[builtins.str] schema_name: The name of the schema that contains the database column. This attribute cannot be updated for an existing masking column.
        :param pulumi.Input[builtins.str] sensitive_type_id: (Updatable) The OCID of the sensitive type to be associated with the masking column. Note that  if the maskingFormats attribute isn't provided while creating a masking column,   the default masking format associated with the specified sensitive type is assigned  to the masking column.  
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaskingPoliciesMaskingColumnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Masking Policies Masking Column resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new masking column in the specified masking policy. Use this operation
        to add parent columns only. It automatically adds the child columns from the
        associated sensitive data model or target database. If you provide the
        sensitiveTypeId attribute but not the maskingFormats attribute, it automatically
        assigns the default masking format associated with the specified sensitive type.
        Alternatively, if you provide the maskingFormats attribute, the specified masking
        formats are assigned to the column.

        Using the maskingFormats attribute, you can assign one or more masking formats
        to a column. You need to specify a condition as part of each masking format. It
        enables you to do <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/conditional-masking.html">conditional masking</a>
        so that you can mask the column data values differently using different
        masking conditions. A masking format can have one or more format entries. The
        combined output of all the format entries is used for masking. It provides the
        flexibility to define a masking format that can generate different parts of a data
        value separately and then combine them to get the final data value for masking.

        You can use the maskingColumnGroup attribute to group the columns that you would
        like to mask together. It enables you to do <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037">group or compound masking</a> that ensures that the
        masked data across the columns in a group continue to retain the same logical relationship.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_masking_policies_masking_column = oci.data_safe.MaskingPoliciesMaskingColumn("test_masking_policies_masking_column",
            column_name=masking_policies_masking_column_column_name,
            masking_policy_id=test_masking_policy["id"],
            object=masking_policies_masking_column_object,
            schema_name=masking_policies_masking_column_schema_name,
            is_masking_enabled=masking_policies_masking_column_is_masking_enabled,
            masking_column_group=masking_policies_masking_column_masking_column_group,
            masking_formats=[{
                "format_entries": [{
                    "type": masking_policies_masking_column_masking_formats_format_entries_type,
                    "column_name": masking_policies_masking_column_masking_formats_format_entries_column_name,
                    "description": masking_policies_masking_column_masking_formats_format_entries_description,
                    "end_date": masking_policies_masking_column_masking_formats_format_entries_end_date,
                    "end_length": masking_policies_masking_column_masking_formats_format_entries_end_length,
                    "end_value": masking_policies_masking_column_masking_formats_format_entries_end_value,
                    "fixed_number": masking_policies_masking_column_masking_formats_format_entries_fixed_number,
                    "fixed_string": masking_policies_masking_column_masking_formats_format_entries_fixed_string,
                    "grouping_columns": masking_policies_masking_column_masking_formats_format_entries_grouping_columns,
                    "length": masking_policies_masking_column_masking_formats_format_entries_length,
                    "library_masking_format_id": test_library_masking_format["id"],
                    "pattern": masking_policies_masking_column_masking_formats_format_entries_pattern,
                    "post_processing_function": masking_policies_masking_column_masking_formats_format_entries_post_processing_function,
                    "random_lists": masking_policies_masking_column_masking_formats_format_entries_random_list,
                    "regular_expression": masking_policies_masking_column_masking_formats_format_entries_regular_expression,
                    "replace_with": masking_policies_masking_column_masking_formats_format_entries_replace_with,
                    "schema_name": masking_policies_masking_column_masking_formats_format_entries_schema_name,
                    "sql_expression": masking_policies_masking_column_masking_formats_format_entries_sql_expression,
                    "start_date": masking_policies_masking_column_masking_formats_format_entries_start_date,
                    "start_length": masking_policies_masking_column_masking_formats_format_entries_start_length,
                    "start_position": masking_policies_masking_column_masking_formats_format_entries_start_position,
                    "start_value": masking_policies_masking_column_masking_formats_format_entries_start_value,
                    "table_name": test_table["name"],
                    "user_defined_function": masking_policies_masking_column_masking_formats_format_entries_user_defined_function,
                }],
                "condition": masking_policies_masking_column_masking_formats_condition,
                "description": masking_policies_masking_column_masking_formats_description,
            }],
            object_type=masking_policies_masking_column_object_type,
            sensitive_type_id=test_sensitive_type["id"])
        ```

        ## Import

        MaskingPoliciesMaskingColumns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/maskingPoliciesMaskingColumn:MaskingPoliciesMaskingColumn test_masking_policies_masking_column "maskingPolicies/{maskingPolicyId}/maskingColumns/{maskingColumnKey}"
        ```

        :param str resource_name: The name of the resource.
        :param MaskingPoliciesMaskingColumnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaskingPoliciesMaskingColumnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column_name: Optional[pulumi.Input[builtins.str]] = None,
                 is_masking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 masking_column_group: Optional[pulumi.Input[builtins.str]] = None,
                 masking_formats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MaskingPoliciesMaskingColumnMaskingFormatArgs', 'MaskingPoliciesMaskingColumnMaskingFormatArgsDict']]]]] = None,
                 masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 object: Optional[pulumi.Input[builtins.str]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None,
                 schema_name: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaskingPoliciesMaskingColumnArgs.__new__(MaskingPoliciesMaskingColumnArgs)

            if column_name is None and not opts.urn:
                raise TypeError("Missing required property 'column_name'")
            __props__.__dict__["column_name"] = column_name
            __props__.__dict__["is_masking_enabled"] = is_masking_enabled
            __props__.__dict__["masking_column_group"] = masking_column_group
            __props__.__dict__["masking_formats"] = masking_formats
            if masking_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'masking_policy_id'")
            __props__.__dict__["masking_policy_id"] = masking_policy_id
            if object is None and not opts.urn:
                raise TypeError("Missing required property 'object'")
            __props__.__dict__["object"] = object
            __props__.__dict__["object_type"] = object_type
            if schema_name is None and not opts.urn:
                raise TypeError("Missing required property 'schema_name'")
            __props__.__dict__["schema_name"] = schema_name
            __props__.__dict__["sensitive_type_id"] = sensitive_type_id
            __props__.__dict__["child_columns"] = None
            __props__.__dict__["data_type"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MaskingPoliciesMaskingColumn, __self__).__init__(
            'oci:DataSafe/maskingPoliciesMaskingColumn:MaskingPoliciesMaskingColumn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            child_columns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            column_name: Optional[pulumi.Input[builtins.str]] = None,
            data_type: Optional[pulumi.Input[builtins.str]] = None,
            is_masking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            masking_column_group: Optional[pulumi.Input[builtins.str]] = None,
            masking_formats: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MaskingPoliciesMaskingColumnMaskingFormatArgs', 'MaskingPoliciesMaskingColumnMaskingFormatArgsDict']]]]] = None,
            masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            object: Optional[pulumi.Input[builtins.str]] = None,
            object_type: Optional[pulumi.Input[builtins.str]] = None,
            schema_name: Optional[pulumi.Input[builtins.str]] = None,
            sensitive_type_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'MaskingPoliciesMaskingColumn':
        """
        Get an existing MaskingPoliciesMaskingColumn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] child_columns: An array of child columns that are in referential relationship with the masking column.
        :param pulumi.Input[builtins.str] column_name: The name of the database column. This attribute cannot be updated for an existing  masking column. Note that the same name is used for the masking column. There  is no separate displayName attribute for the masking column.
        :param pulumi.Input[builtins.str] data_type: The data type of the masking column.
        :param pulumi.Input[builtins.bool] is_masking_enabled: (Updatable) Indicates whether data masking is enabled for the masking column. Set it to false if  you don't want to mask the column.
        :param pulumi.Input[builtins.str] key: The unique key that identifies the masking column. It's numeric and unique within a masking policy.
        :param pulumi.Input[builtins.str] lifecycle_details: Details about the current state of the masking column.
        :param pulumi.Input[builtins.str] masking_column_group: (Updatable) The group of the masking column. It's a masking group identifier and can be any string  of acceptable length. All the columns in a group are masked together to ensure that  the masked data across these columns continue to retain the same logical relationship.  For more details, check  <a href=https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037>Group Masking in the Data Safe documentation.</a>
        :param pulumi.Input[Sequence[pulumi.Input[Union['MaskingPoliciesMaskingColumnMaskingFormatArgs', 'MaskingPoliciesMaskingColumnMaskingFormatArgsDict']]]] masking_formats: (Updatable) The masking formats to be assigned to the masking column. You can specify a condition  as part of each masking format. It enables you to do  <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/conditional-masking.html">conditional masking</a>  so that you can mask the column data values differently using different masking  formats and the associated conditions. A masking format can have one or more format  entries. The combined output of all the format entries is used for masking. It  provides the flexibility to define a masking format that can generate different parts  of a data value separately and then combine them to get the final data value for masking.
        :param pulumi.Input[builtins.str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[builtins.str] object: The name of the object (table or editioning view) that contains the database column. This attribute cannot be updated for an existing masking column.
        :param pulumi.Input[builtins.str] object_type: (Updatable) The type of the object that contains the database column.
        :param pulumi.Input[builtins.str] schema_name: The name of the schema that contains the database column. This attribute cannot be updated for an existing masking column.
        :param pulumi.Input[builtins.str] sensitive_type_id: (Updatable) The OCID of the sensitive type to be associated with the masking column. Note that  if the maskingFormats attribute isn't provided while creating a masking column,   the default masking format associated with the specified sensitive type is assigned  to the masking column.  
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current state of the masking column.
        :param pulumi.Input[builtins.str] time_created: The date and time the masking column was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: The date and time the masking column was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaskingPoliciesMaskingColumnState.__new__(_MaskingPoliciesMaskingColumnState)

        __props__.__dict__["child_columns"] = child_columns
        __props__.__dict__["column_name"] = column_name
        __props__.__dict__["data_type"] = data_type
        __props__.__dict__["is_masking_enabled"] = is_masking_enabled
        __props__.__dict__["key"] = key
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["masking_column_group"] = masking_column_group
        __props__.__dict__["masking_formats"] = masking_formats
        __props__.__dict__["masking_policy_id"] = masking_policy_id
        __props__.__dict__["object"] = object
        __props__.__dict__["object_type"] = object_type
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["sensitive_type_id"] = sensitive_type_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MaskingPoliciesMaskingColumn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="childColumns")
    def child_columns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        An array of child columns that are in referential relationship with the masking column.
        """
        return pulumi.get(self, "child_columns")

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the database column. This attribute cannot be updated for an existing  masking column. Note that the same name is used for the masking column. There  is no separate displayName attribute for the masking column.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Output[builtins.str]:
        """
        The data type of the masking column.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="isMaskingEnabled")
    def is_masking_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Indicates whether data masking is enabled for the masking column. Set it to false if  you don't want to mask the column.
        """
        return pulumi.get(self, "is_masking_enabled")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The unique key that identifies the masking column. It's numeric and unique within a masking policy.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Details about the current state of the masking column.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maskingColumnGroup")
    def masking_column_group(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The group of the masking column. It's a masking group identifier and can be any string  of acceptable length. All the columns in a group are masked together to ensure that  the masked data across these columns continue to retain the same logical relationship.  For more details, check  <a href=https://docs.oracle.com/en/cloud/paas/data-safe/udscs/group-masking1.html#GUID-755056B9-9540-48C0-9491-262A44A85037>Group Masking in the Data Safe documentation.</a>
        """
        return pulumi.get(self, "masking_column_group")

    @property
    @pulumi.getter(name="maskingFormats")
    def masking_formats(self) -> pulumi.Output[Sequence['outputs.MaskingPoliciesMaskingColumnMaskingFormat']]:
        """
        (Updatable) The masking formats to be assigned to the masking column. You can specify a condition  as part of each masking format. It enables you to do  <a href="https://docs.oracle.com/en/cloud/paas/data-safe/udscs/conditional-masking.html">conditional masking</a>  so that you can mask the column data values differently using different masking  formats and the associated conditions. A masking format can have one or more format  entries. The combined output of all the format entries is used for masking. It  provides the flexibility to define a masking format that can generate different parts  of a data value separately and then combine them to get the final data value for masking.
        """
        return pulumi.get(self, "masking_formats")

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @property
    @pulumi.getter
    def object(self) -> pulumi.Output[builtins.str]:
        """
        The name of the object (table or editioning view) that contains the database column. This attribute cannot be updated for an existing masking column.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The type of the object that contains the database column.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the schema that contains the database column. This attribute cannot be updated for an existing masking column.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the sensitive type to be associated with the masking column. Note that  if the maskingFormats attribute isn't provided while creating a masking column,   the default masking format associated with the specified sensitive type is assigned  to the masking column.  


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_type_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the masking column.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the masking column was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the masking column was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

