# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ExportExportOption',
    'ExportLock',
    'FileSystemLock',
    'FileSystemSourceDetail',
    'FilesystemSnapshotPolicyLock',
    'FilesystemSnapshotPolicySchedule',
    'MountTargetKerberos',
    'MountTargetLdapIdmap',
    'MountTargetLock',
    'OutboundConnectorEndpoint',
    'OutboundConnectorLock',
    'ReplicationLock',
    'SnapshotLock',
    'GetExportSetsExportSetResult',
    'GetExportSetsFilterResult',
    'GetExportsExportResult',
    'GetExportsExportExportOptionResult',
    'GetExportsExportLockResult',
    'GetExportsFilterResult',
    'GetFileSystemQuotaRulesFilterResult',
    'GetFileSystemQuotaRulesQuotaRuleResult',
    'GetFileSystemsFileSystemResult',
    'GetFileSystemsFileSystemLockResult',
    'GetFileSystemsFileSystemSourceDetailResult',
    'GetFileSystemsFilterResult',
    'GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyResult',
    'GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyLockResult',
    'GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyScheduleResult',
    'GetFilesystemSnapshotPoliciesFilterResult',
    'GetFilesystemSnapshotPolicyLockResult',
    'GetFilesystemSnapshotPolicyScheduleResult',
    'GetMountTargetsFilterResult',
    'GetMountTargetsMountTargetResult',
    'GetMountTargetsMountTargetKerberoResult',
    'GetMountTargetsMountTargetLdapIdmapResult',
    'GetMountTargetsMountTargetLockResult',
    'GetOutboundConnectorEndpointResult',
    'GetOutboundConnectorLockResult',
    'GetOutboundConnectorsFilterResult',
    'GetOutboundConnectorsOutboundConnectorResult',
    'GetOutboundConnectorsOutboundConnectorEndpointResult',
    'GetOutboundConnectorsOutboundConnectorLockResult',
    'GetReplicationLockResult',
    'GetReplicationTargetsFilterResult',
    'GetReplicationTargetsReplicationTargetResult',
    'GetReplicationsFilterResult',
    'GetReplicationsReplicationResult',
    'GetReplicationsReplicationLockResult',
    'GetSnapshotLockResult',
    'GetSnapshotsFilterResult',
    'GetSnapshotsSnapshotResult',
    'GetSnapshotsSnapshotLockResult',
]

@pulumi.output_type
class ExportExportOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedAuths":
            suggest = "allowed_auths"
        elif key == "anonymousGid":
            suggest = "anonymous_gid"
        elif key == "anonymousUid":
            suggest = "anonymous_uid"
        elif key == "identitySquash":
            suggest = "identity_squash"
        elif key == "isAnonymousAccessAllowed":
            suggest = "is_anonymous_access_allowed"
        elif key == "requirePrivilegedSourcePort":
            suggest = "require_privileged_source_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportExportOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportExportOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportExportOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source: builtins.str,
                 access: Optional[builtins.str] = None,
                 allowed_auths: Optional[Sequence[builtins.str]] = None,
                 anonymous_gid: Optional[builtins.str] = None,
                 anonymous_uid: Optional[builtins.str] = None,
                 identity_squash: Optional[builtins.str] = None,
                 is_anonymous_access_allowed: Optional[builtins.bool] = None,
                 require_privileged_source_port: Optional[builtins.bool] = None):
        """
        :param builtins.str source: (Updatable) Clients these options should apply to. Must be a either single IPv4 address or single IPv4 CIDR block.
               
               **Note:** Access will also be limited by any applicable VCN security rules and the ability to route IP packets to the mount target. Mount targets do not have Internet-routable IP addresses.
        :param builtins.str access: (Updatable) Type of access to grant clients using the file system through this export. If unspecified defaults to `READ_WRITE`.
        :param Sequence[builtins.str] allowed_auths: (Updatable) Array of allowed NFS authentication types.
        :param builtins.str anonymous_gid: (Updatable) GID value to remap to when squashing a client GID (see identitySquash for more details.) If unspecified defaults to `65534`.
        :param builtins.str anonymous_uid: (Updatable) UID value to remap to when squashing a client UID (see identitySquash for more details.) If unspecified, defaults to `65534`.
        :param builtins.str identity_squash: (Updatable) Used when clients accessing the file system through this export have their UID and GID remapped to 'anonymousUid' and 'anonymousGid'. If `ALL`, all users and groups are remapped; if `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `ROOT`.
        :param builtins.bool is_anonymous_access_allowed: (Updatable) Whether or not to enable anonymous access to the file system through this export in cases where a user isn't found in the LDAP server used for ID mapping. If true, and the user is not found in the LDAP directory, the operation uses the Squash UID and Squash GID.
        :param builtins.bool require_privileged_source_port: (Updatable) If `true`, clients accessing the file system through this export must connect from a privileged source port. If unspecified, defaults to `true`.
        """
        pulumi.set(__self__, "source", source)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if allowed_auths is not None:
            pulumi.set(__self__, "allowed_auths", allowed_auths)
        if anonymous_gid is not None:
            pulumi.set(__self__, "anonymous_gid", anonymous_gid)
        if anonymous_uid is not None:
            pulumi.set(__self__, "anonymous_uid", anonymous_uid)
        if identity_squash is not None:
            pulumi.set(__self__, "identity_squash", identity_squash)
        if is_anonymous_access_allowed is not None:
            pulumi.set(__self__, "is_anonymous_access_allowed", is_anonymous_access_allowed)
        if require_privileged_source_port is not None:
            pulumi.set(__self__, "require_privileged_source_port", require_privileged_source_port)

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        (Updatable) Clients these options should apply to. Must be a either single IPv4 address or single IPv4 CIDR block.

        **Note:** Access will also be limited by any applicable VCN security rules and the ability to route IP packets to the mount target. Mount targets do not have Internet-routable IP addresses.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def access(self) -> Optional[builtins.str]:
        """
        (Updatable) Type of access to grant clients using the file system through this export. If unspecified defaults to `READ_WRITE`.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="allowedAuths")
    def allowed_auths(self) -> Optional[Sequence[builtins.str]]:
        """
        (Updatable) Array of allowed NFS authentication types.
        """
        return pulumi.get(self, "allowed_auths")

    @property
    @pulumi.getter(name="anonymousGid")
    def anonymous_gid(self) -> Optional[builtins.str]:
        """
        (Updatable) GID value to remap to when squashing a client GID (see identitySquash for more details.) If unspecified defaults to `65534`.
        """
        return pulumi.get(self, "anonymous_gid")

    @property
    @pulumi.getter(name="anonymousUid")
    def anonymous_uid(self) -> Optional[builtins.str]:
        """
        (Updatable) UID value to remap to when squashing a client UID (see identitySquash for more details.) If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "anonymous_uid")

    @property
    @pulumi.getter(name="identitySquash")
    def identity_squash(self) -> Optional[builtins.str]:
        """
        (Updatable) Used when clients accessing the file system through this export have their UID and GID remapped to 'anonymousUid' and 'anonymousGid'. If `ALL`, all users and groups are remapped; if `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `ROOT`.
        """
        return pulumi.get(self, "identity_squash")

    @property
    @pulumi.getter(name="isAnonymousAccessAllowed")
    def is_anonymous_access_allowed(self) -> Optional[builtins.bool]:
        """
        (Updatable) Whether or not to enable anonymous access to the file system through this export in cases where a user isn't found in the LDAP server used for ID mapping. If true, and the user is not found in the LDAP directory, the operation uses the Squash UID and Squash GID.
        """
        return pulumi.get(self, "is_anonymous_access_allowed")

    @property
    @pulumi.getter(name="requirePrivilegedSourcePort")
    def require_privileged_source_port(self) -> Optional[builtins.bool]:
        """
        (Updatable) If `true`, clients accessing the file system through this export must connect from a privileged source port. If unspecified, defaults to `true`.
        """
        return pulumi.get(self, "require_privileged_source_port")


@pulumi.output_type
class ExportLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExportLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExportLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExportLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 message: Optional[builtins.str] = None,
                 related_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of the lock.
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class FileSystemLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 message: Optional[builtins.str] = None,
                 related_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of the lock.
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class FileSystemSourceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parentFileSystemId":
            suggest = "parent_file_system_id"
        elif key == "sourceSnapshotId":
            suggest = "source_snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileSystemSourceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileSystemSourceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileSystemSourceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parent_file_system_id: Optional[builtins.str] = None,
                 source_snapshot_id: Optional[builtins.str] = None):
        """
        :param builtins.str parent_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system that contains the source snapshot of a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param builtins.str source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        if parent_file_system_id is not None:
            pulumi.set(__self__, "parent_file_system_id", parent_file_system_id)
        if source_snapshot_id is not None:
            pulumi.set(__self__, "source_snapshot_id", source_snapshot_id)

    @property
    @pulumi.getter(name="parentFileSystemId")
    def parent_file_system_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system that contains the source snapshot of a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "parent_file_system_id")

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "source_snapshot_id")


@pulumi.output_type
class FilesystemSnapshotPolicyLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilesystemSnapshotPolicyLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilesystemSnapshotPolicyLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilesystemSnapshotPolicyLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 message: Optional[builtins.str] = None,
                 related_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of the lock.
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class FilesystemSnapshotPolicySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"
        elif key == "dayOfMonth":
            suggest = "day_of_month"
        elif key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "hourOfDay":
            suggest = "hour_of_day"
        elif key == "retentionDurationInSeconds":
            suggest = "retention_duration_in_seconds"
        elif key == "schedulePrefix":
            suggest = "schedule_prefix"
        elif key == "timeScheduleStart":
            suggest = "time_schedule_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilesystemSnapshotPolicySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilesystemSnapshotPolicySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilesystemSnapshotPolicySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 period: builtins.str,
                 time_zone: builtins.str,
                 day_of_month: Optional[builtins.int] = None,
                 day_of_week: Optional[builtins.str] = None,
                 hour_of_day: Optional[builtins.int] = None,
                 month: Optional[builtins.str] = None,
                 retention_duration_in_seconds: Optional[builtins.str] = None,
                 schedule_prefix: Optional[builtins.str] = None,
                 time_schedule_start: Optional[builtins.str] = None):
        """
        :param builtins.str period: (Updatable) The frequency of scheduled snapshots.
        :param builtins.str time_zone: (Updatable) Time zone used for scheduling the snapshot.
        :param builtins.int day_of_month: (Updatable) The day of the month to create a scheduled snapshot. If the day does not exist for the month, snapshot creation will be skipped. Used for MONTHLY and YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        :param builtins.str day_of_week: (Updatable) The day of the week to create a scheduled snapshot. Used for WEEKLY snapshot schedules. If not set, the system chooses a value at creation time.
        :param builtins.int hour_of_day: (Updatable) The hour of the day to create a DAILY, WEEKLY, MONTHLY, or YEARLY snapshot. If not set, the system chooses a value at creation time.
        :param builtins.str month: (Updatable) The month to create a scheduled snapshot. Used only for YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        :param builtins.str retention_duration_in_seconds: (Updatable) The number of seconds to retain snapshots created with this schedule. Snapshot expiration time will not be set if this value is empty.
        :param builtins.str schedule_prefix: (Updatable) A name prefix to be applied to snapshots created by this schedule.  Example: `compliance1`
        :param builtins.str time_schedule_start: (Updatable) The starting point used to begin the scheduling of the snapshots based upon recurrence string in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. If no `timeScheduleStart` is provided, the value will be set to the time when the schedule was created.
        """
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "time_zone", time_zone)
        if day_of_month is not None:
            pulumi.set(__self__, "day_of_month", day_of_month)
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if hour_of_day is not None:
            pulumi.set(__self__, "hour_of_day", hour_of_day)
        if month is not None:
            pulumi.set(__self__, "month", month)
        if retention_duration_in_seconds is not None:
            pulumi.set(__self__, "retention_duration_in_seconds", retention_duration_in_seconds)
        if schedule_prefix is not None:
            pulumi.set(__self__, "schedule_prefix", schedule_prefix)
        if time_schedule_start is not None:
            pulumi.set(__self__, "time_schedule_start", time_schedule_start)

    @property
    @pulumi.getter
    def period(self) -> builtins.str:
        """
        (Updatable) The frequency of scheduled snapshots.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        (Updatable) Time zone used for scheduling the snapshot.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> Optional[builtins.int]:
        """
        (Updatable) The day of the month to create a scheduled snapshot. If the day does not exist for the month, snapshot creation will be skipped. Used for MONTHLY and YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "day_of_month")

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[builtins.str]:
        """
        (Updatable) The day of the week to create a scheduled snapshot. Used for WEEKLY snapshot schedules. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> Optional[builtins.int]:
        """
        (Updatable) The hour of the day to create a DAILY, WEEKLY, MONTHLY, or YEARLY snapshot. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter
    def month(self) -> Optional[builtins.str]:
        """
        (Updatable) The month to create a scheduled snapshot. Used only for YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter(name="retentionDurationInSeconds")
    def retention_duration_in_seconds(self) -> Optional[builtins.str]:
        """
        (Updatable) The number of seconds to retain snapshots created with this schedule. Snapshot expiration time will not be set if this value is empty.
        """
        return pulumi.get(self, "retention_duration_in_seconds")

    @property
    @pulumi.getter(name="schedulePrefix")
    def schedule_prefix(self) -> Optional[builtins.str]:
        """
        (Updatable) A name prefix to be applied to snapshots created by this schedule.  Example: `compliance1`
        """
        return pulumi.get(self, "schedule_prefix")

    @property
    @pulumi.getter(name="timeScheduleStart")
    def time_schedule_start(self) -> Optional[builtins.str]:
        """
        (Updatable) The starting point used to begin the scheduling of the snapshots based upon recurrence string in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. If no `timeScheduleStart` is provided, the value will be set to the time when the schedule was created.
        """
        return pulumi.get(self, "time_schedule_start")


@pulumi.output_type
class MountTargetKerberos(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kerberosRealm":
            suggest = "kerberos_realm"
        elif key == "backupKeyTabSecretVersion":
            suggest = "backup_key_tab_secret_version"
        elif key == "currentKeyTabSecretVersion":
            suggest = "current_key_tab_secret_version"
        elif key == "isKerberosEnabled":
            suggest = "is_kerberos_enabled"
        elif key == "keyTabSecretId":
            suggest = "key_tab_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MountTargetKerberos. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MountTargetKerberos.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MountTargetKerberos.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kerberos_realm: builtins.str,
                 backup_key_tab_secret_version: Optional[builtins.int] = None,
                 current_key_tab_secret_version: Optional[builtins.int] = None,
                 is_kerberos_enabled: Optional[builtins.bool] = None,
                 key_tab_secret_id: Optional[builtins.str] = None):
        """
        :param builtins.str kerberos_realm: (Updatable) The Kerberos realm that the mount target will join.
        :param builtins.int backup_key_tab_secret_version: (Updatable) Version of the keytab Secret in the Vault to use as a backup.
        :param builtins.int current_key_tab_secret_version: (Updatable) Version of the keytab Secret in the Vault to use.
        :param builtins.bool is_kerberos_enabled: (Updatable) Specifies whether to enable or disable Kerberos.
        :param builtins.str key_tab_secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the keytab Secret in the Vault.
        """
        pulumi.set(__self__, "kerberos_realm", kerberos_realm)
        if backup_key_tab_secret_version is not None:
            pulumi.set(__self__, "backup_key_tab_secret_version", backup_key_tab_secret_version)
        if current_key_tab_secret_version is not None:
            pulumi.set(__self__, "current_key_tab_secret_version", current_key_tab_secret_version)
        if is_kerberos_enabled is not None:
            pulumi.set(__self__, "is_kerberos_enabled", is_kerberos_enabled)
        if key_tab_secret_id is not None:
            pulumi.set(__self__, "key_tab_secret_id", key_tab_secret_id)

    @property
    @pulumi.getter(name="kerberosRealm")
    def kerberos_realm(self) -> builtins.str:
        """
        (Updatable) The Kerberos realm that the mount target will join.
        """
        return pulumi.get(self, "kerberos_realm")

    @property
    @pulumi.getter(name="backupKeyTabSecretVersion")
    def backup_key_tab_secret_version(self) -> Optional[builtins.int]:
        """
        (Updatable) Version of the keytab Secret in the Vault to use as a backup.
        """
        return pulumi.get(self, "backup_key_tab_secret_version")

    @property
    @pulumi.getter(name="currentKeyTabSecretVersion")
    def current_key_tab_secret_version(self) -> Optional[builtins.int]:
        """
        (Updatable) Version of the keytab Secret in the Vault to use.
        """
        return pulumi.get(self, "current_key_tab_secret_version")

    @property
    @pulumi.getter(name="isKerberosEnabled")
    def is_kerberos_enabled(self) -> Optional[builtins.bool]:
        """
        (Updatable) Specifies whether to enable or disable Kerberos.
        """
        return pulumi.get(self, "is_kerberos_enabled")

    @property
    @pulumi.getter(name="keyTabSecretId")
    def key_tab_secret_id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the keytab Secret in the Vault.
        """
        return pulumi.get(self, "key_tab_secret_id")


@pulumi.output_type
class MountTargetLdapIdmap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheLifetimeSeconds":
            suggest = "cache_lifetime_seconds"
        elif key == "cacheRefreshIntervalSeconds":
            suggest = "cache_refresh_interval_seconds"
        elif key == "groupSearchBase":
            suggest = "group_search_base"
        elif key == "negativeCacheLifetimeSeconds":
            suggest = "negative_cache_lifetime_seconds"
        elif key == "outboundConnector1id":
            suggest = "outbound_connector1id"
        elif key == "outboundConnector2id":
            suggest = "outbound_connector2id"
        elif key == "schemaType":
            suggest = "schema_type"
        elif key == "userSearchBase":
            suggest = "user_search_base"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MountTargetLdapIdmap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MountTargetLdapIdmap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MountTargetLdapIdmap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_lifetime_seconds: Optional[builtins.int] = None,
                 cache_refresh_interval_seconds: Optional[builtins.int] = None,
                 group_search_base: Optional[builtins.str] = None,
                 negative_cache_lifetime_seconds: Optional[builtins.int] = None,
                 outbound_connector1id: Optional[builtins.str] = None,
                 outbound_connector2id: Optional[builtins.str] = None,
                 schema_type: Optional[builtins.str] = None,
                 user_search_base: Optional[builtins.str] = None):
        """
        :param builtins.int cache_lifetime_seconds: (Updatable) The maximum amount of time the mount target is allowed to use a cached entry.
        :param builtins.int cache_refresh_interval_seconds: (Updatable) The amount of time that the mount target should allow an entry to persist in its cache before attempting to refresh the entry.
        :param builtins.str group_search_base: (Updatable) All LDAP searches are recursive starting at this group.  Example: `CN=Group,DC=domain,DC=com`
        :param builtins.int negative_cache_lifetime_seconds: (Updatable) The amount of time that a mount target will maintain information that a user is not found in the ID mapping configuration.
        :param builtins.str outbound_connector1id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the first connector to use to communicate with the LDAP server.
        :param builtins.str outbound_connector2id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second connector to use to communicate with the LDAP server.
        :param builtins.str schema_type: (Updatable) Schema type of the LDAP account.
        :param builtins.str user_search_base: (Updatable) All LDAP searches are recursive starting at this user.  Example: `CN=User,DC=domain,DC=com`
        """
        if cache_lifetime_seconds is not None:
            pulumi.set(__self__, "cache_lifetime_seconds", cache_lifetime_seconds)
        if cache_refresh_interval_seconds is not None:
            pulumi.set(__self__, "cache_refresh_interval_seconds", cache_refresh_interval_seconds)
        if group_search_base is not None:
            pulumi.set(__self__, "group_search_base", group_search_base)
        if negative_cache_lifetime_seconds is not None:
            pulumi.set(__self__, "negative_cache_lifetime_seconds", negative_cache_lifetime_seconds)
        if outbound_connector1id is not None:
            pulumi.set(__self__, "outbound_connector1id", outbound_connector1id)
        if outbound_connector2id is not None:
            pulumi.set(__self__, "outbound_connector2id", outbound_connector2id)
        if schema_type is not None:
            pulumi.set(__self__, "schema_type", schema_type)
        if user_search_base is not None:
            pulumi.set(__self__, "user_search_base", user_search_base)

    @property
    @pulumi.getter(name="cacheLifetimeSeconds")
    def cache_lifetime_seconds(self) -> Optional[builtins.int]:
        """
        (Updatable) The maximum amount of time the mount target is allowed to use a cached entry.
        """
        return pulumi.get(self, "cache_lifetime_seconds")

    @property
    @pulumi.getter(name="cacheRefreshIntervalSeconds")
    def cache_refresh_interval_seconds(self) -> Optional[builtins.int]:
        """
        (Updatable) The amount of time that the mount target should allow an entry to persist in its cache before attempting to refresh the entry.
        """
        return pulumi.get(self, "cache_refresh_interval_seconds")

    @property
    @pulumi.getter(name="groupSearchBase")
    def group_search_base(self) -> Optional[builtins.str]:
        """
        (Updatable) All LDAP searches are recursive starting at this group.  Example: `CN=Group,DC=domain,DC=com`
        """
        return pulumi.get(self, "group_search_base")

    @property
    @pulumi.getter(name="negativeCacheLifetimeSeconds")
    def negative_cache_lifetime_seconds(self) -> Optional[builtins.int]:
        """
        (Updatable) The amount of time that a mount target will maintain information that a user is not found in the ID mapping configuration.
        """
        return pulumi.get(self, "negative_cache_lifetime_seconds")

    @property
    @pulumi.getter(name="outboundConnector1id")
    def outbound_connector1id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the first connector to use to communicate with the LDAP server.
        """
        return pulumi.get(self, "outbound_connector1id")

    @property
    @pulumi.getter(name="outboundConnector2id")
    def outbound_connector2id(self) -> Optional[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second connector to use to communicate with the LDAP server.
        """
        return pulumi.get(self, "outbound_connector2id")

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> Optional[builtins.str]:
        """
        (Updatable) Schema type of the LDAP account.
        """
        return pulumi.get(self, "schema_type")

    @property
    @pulumi.getter(name="userSearchBase")
    def user_search_base(self) -> Optional[builtins.str]:
        """
        (Updatable) All LDAP searches are recursive starting at this user.  Example: `CN=User,DC=domain,DC=com`
        """
        return pulumi.get(self, "user_search_base")


@pulumi.output_type
class MountTargetLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MountTargetLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MountTargetLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MountTargetLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 message: Optional[builtins.str] = None,
                 related_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of the lock.
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class OutboundConnectorEndpoint(dict):
    def __init__(__self__, *,
                 hostname: builtins.str,
                 port: builtins.str):
        """
        :param builtins.str hostname: Name of the DNS server.
        :param builtins.str port: Port of the DNS server.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        Name of the DNS server.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        Port of the DNS server.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class OutboundConnectorLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutboundConnectorLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutboundConnectorLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutboundConnectorLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 message: Optional[builtins.str] = None,
                 related_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of the lock.
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class ReplicationLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 message: Optional[builtins.str] = None,
                 related_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of the lock.
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class SnapshotLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relatedResourceId":
            suggest = "related_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 message: Optional[builtins.str] = None,
                 related_resource_id: Optional[builtins.str] = None,
                 time_created: Optional[builtins.str] = None):
        """
        :param builtins.str type: Type of the lock.
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: When the lock was created.
        """
        pulumi.set(__self__, "type", type)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if related_resource_id is not None:
            pulumi.set(__self__, "related_resource_id", related_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> Optional[builtins.str]:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[builtins.str]:
        """
        When the lock was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetExportSetsExportSetResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 compartment_id: builtins.str,
                 display_name: builtins.str,
                 id: builtins.str,
                 max_fs_stat_bytes: builtins.str,
                 max_fs_stat_files: builtins.str,
                 mount_target_id: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str,
                 vcn_id: builtins.str):
        """
        :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        :param builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        :param builtins.str max_fs_stat_bytes: Controls the maximum `tbytes`, `fbytes`, and `abytes`, values reported by `NFS FSSTAT` calls through any associated mount targets. This is an advanced feature. For most applications, use the default value. The `tbytes` value reported by `FSSTAT` will be `maxFsStatBytes`. The value of `fbytes` and `abytes` will be `maxFsStatBytes` minus the metered size of the file system. If the metered size is larger than `maxFsStatBytes`, then `fbytes` and `abytes` will both be '0'.
        :param builtins.str max_fs_stat_files: Controls the maximum `tfiles`, `ffiles`, and `afiles` values reported by `NFS FSSTAT` calls through any associated mount targets. This is an advanced feature. For most applications, use the default value. The `tfiles` value reported by `FSSTAT` will be `maxFsStatFiles`. The value of `ffiles` and `afiles` will be `maxFsStatFiles` minus the metered size of the file system. If the metered size is larger than `maxFsStatFiles`, then `ffiles` and `afiles` will both be '0'.
        :param builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        :param builtins.str time_created: The date and time the export set was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str vcn_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual cloud network (VCN) the export set is in.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_fs_stat_bytes", max_fs_stat_bytes)
        pulumi.set(__self__, "max_fs_stat_files", max_fs_stat_files)
        pulumi.set(__self__, "mount_target_id", mount_target_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxFsStatBytes")
    def max_fs_stat_bytes(self) -> builtins.str:
        """
        Controls the maximum `tbytes`, `fbytes`, and `abytes`, values reported by `NFS FSSTAT` calls through any associated mount targets. This is an advanced feature. For most applications, use the default value. The `tbytes` value reported by `FSSTAT` will be `maxFsStatBytes`. The value of `fbytes` and `abytes` will be `maxFsStatBytes` minus the metered size of the file system. If the metered size is larger than `maxFsStatBytes`, then `fbytes` and `abytes` will both be '0'.
        """
        return pulumi.get(self, "max_fs_stat_bytes")

    @property
    @pulumi.getter(name="maxFsStatFiles")
    def max_fs_stat_files(self) -> builtins.str:
        """
        Controls the maximum `tfiles`, `ffiles`, and `afiles` values reported by `NFS FSSTAT` calls through any associated mount targets. This is an advanced feature. For most applications, use the default value. The `tfiles` value reported by `FSSTAT` will be `maxFsStatFiles`. The value of `ffiles` and `afiles` will be `maxFsStatFiles` minus the metered size of the file system. If the metered size is larger than `maxFsStatFiles`, then `ffiles` and `afiles` will both be '0'.
        """
        return pulumi.get(self, "max_fs_stat_files")

    @property
    @pulumi.getter(name="mountTargetId")
    def mount_target_id(self) -> builtins.str:
        return pulumi.get(self, "mount_target_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the export set was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual cloud network (VCN) the export set is in.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetExportSetsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetExportsExportResult(dict):
    def __init__(__self__, *,
                 export_options: Sequence['outputs.GetExportsExportExportOptionResult'],
                 export_set_id: builtins.str,
                 file_system_id: builtins.str,
                 id: builtins.str,
                 is_idmap_groups_for_sys_auth: builtins.bool,
                 is_lock_override: builtins.bool,
                 locks: Sequence['outputs.GetExportsExportLockResult'],
                 path: builtins.str,
                 state: builtins.str,
                 time_created: builtins.str):
        """
        :param Sequence['GetExportsExportExportOptionArgs'] export_options: Policies that apply to NFS requests made through this export. `exportOptions` contains a sequential list of `ClientOptions`. Each `ClientOptions` item defines the export options that are applied to a specified set of clients.
        :param builtins.str export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export set.
        :param builtins.str file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        :param builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        :param builtins.bool is_idmap_groups_for_sys_auth: Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.
        :param Sequence['GetExportsExportLockArgs'] locks: Locks associated with this resource.
        :param builtins.str path: Path used to access the associated file system.
        :param builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        :param builtins.str time_created: The date and time the export was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "export_options", export_options)
        pulumi.set(__self__, "export_set_id", export_set_id)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_idmap_groups_for_sys_auth", is_idmap_groups_for_sys_auth)
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="exportOptions")
    def export_options(self) -> Sequence['outputs.GetExportsExportExportOptionResult']:
        """
        Policies that apply to NFS requests made through this export. `exportOptions` contains a sequential list of `ClientOptions`. Each `ClientOptions` item defines the export options that are applied to a specified set of clients.
        """
        return pulumi.get(self, "export_options")

    @property
    @pulumi.getter(name="exportSetId")
    def export_set_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export set.
        """
        return pulumi.get(self, "export_set_id")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIdmapGroupsForSysAuth")
    def is_idmap_groups_for_sys_auth(self) -> builtins.bool:
        """
        Whether or not the export should use ID mapping for Unix groups rather than the group list provided within an NFS request's RPC header. When this flag is true the Unix UID from the RPC header is used to retrieve the list of secondary groups from a the ID mapping subsystem. The primary GID is always taken from the RPC header. If ID mapping is not configured, incorrectly configured, unavailable, or cannot be used to determine a list of secondary groups then an empty secondary group list is used for authorization. If the number of groups exceeds the limit of 256 groups, the list retrieved from LDAP is truncated to the first 256 groups read.
        """
        return pulumi.get(self, "is_idmap_groups_for_sys_auth")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetExportsExportLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path used to access the associated file system.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the export was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetExportsExportExportOptionResult(dict):
    def __init__(__self__, *,
                 access: builtins.str,
                 allowed_auths: Sequence[builtins.str],
                 anonymous_gid: builtins.str,
                 anonymous_uid: builtins.str,
                 identity_squash: builtins.str,
                 is_anonymous_access_allowed: builtins.bool,
                 require_privileged_source_port: builtins.bool,
                 source: builtins.str):
        """
        :param builtins.str access: Type of access to grant clients using the file system through this export. If unspecified defaults to `READ_WRITE`.
        :param Sequence[builtins.str] allowed_auths: Array of allowed NFS authentication types.
        :param builtins.str anonymous_gid: GID value to remap to when squashing a client GID (see identitySquash for more details.) If unspecified defaults to `65534`.
        :param builtins.str anonymous_uid: UID value to remap to when squashing a client UID (see identitySquash for more details.) If unspecified, defaults to `65534`.
        :param builtins.str identity_squash: Used when clients accessing the file system through this export have their UID and GID remapped to 'anonymousUid' and 'anonymousGid'. If `ALL`, all users and groups are remapped; if `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `ROOT`.
        :param builtins.bool is_anonymous_access_allowed: Whether or not to enable anonymous access to the file system through this export in cases where a user isn't found in the LDAP server used for ID mapping. If true, and the user is not found in the LDAP directory, the operation uses the Squash UID and Squash GID.
        :param builtins.bool require_privileged_source_port: If `true`, clients accessing the file system through this export must connect from a privileged source port. If unspecified, defaults to `true`.
        :param builtins.str source: Clients these options should apply to. Must be a either single IPv4 address or single IPv4 CIDR block.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "allowed_auths", allowed_auths)
        pulumi.set(__self__, "anonymous_gid", anonymous_gid)
        pulumi.set(__self__, "anonymous_uid", anonymous_uid)
        pulumi.set(__self__, "identity_squash", identity_squash)
        pulumi.set(__self__, "is_anonymous_access_allowed", is_anonymous_access_allowed)
        pulumi.set(__self__, "require_privileged_source_port", require_privileged_source_port)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def access(self) -> builtins.str:
        """
        Type of access to grant clients using the file system through this export. If unspecified defaults to `READ_WRITE`.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="allowedAuths")
    def allowed_auths(self) -> Sequence[builtins.str]:
        """
        Array of allowed NFS authentication types.
        """
        return pulumi.get(self, "allowed_auths")

    @property
    @pulumi.getter(name="anonymousGid")
    def anonymous_gid(self) -> builtins.str:
        """
        GID value to remap to when squashing a client GID (see identitySquash for more details.) If unspecified defaults to `65534`.
        """
        return pulumi.get(self, "anonymous_gid")

    @property
    @pulumi.getter(name="anonymousUid")
    def anonymous_uid(self) -> builtins.str:
        """
        UID value to remap to when squashing a client UID (see identitySquash for more details.) If unspecified, defaults to `65534`.
        """
        return pulumi.get(self, "anonymous_uid")

    @property
    @pulumi.getter(name="identitySquash")
    def identity_squash(self) -> builtins.str:
        """
        Used when clients accessing the file system through this export have their UID and GID remapped to 'anonymousUid' and 'anonymousGid'. If `ALL`, all users and groups are remapped; if `ROOT`, only the root user and group (UID/GID 0) are remapped; if `NONE`, no remapping is done. If unspecified, defaults to `ROOT`.
        """
        return pulumi.get(self, "identity_squash")

    @property
    @pulumi.getter(name="isAnonymousAccessAllowed")
    def is_anonymous_access_allowed(self) -> builtins.bool:
        """
        Whether or not to enable anonymous access to the file system through this export in cases where a user isn't found in the LDAP server used for ID mapping. If true, and the user is not found in the LDAP directory, the operation uses the Squash UID and Squash GID.
        """
        return pulumi.get(self, "is_anonymous_access_allowed")

    @property
    @pulumi.getter(name="requirePrivilegedSourcePort")
    def require_privileged_source_port(self) -> builtins.bool:
        """
        If `true`, clients accessing the file system through this export must connect from a privileged source port. If unspecified, defaults to `true`.
        """
        return pulumi.get(self, "require_privileged_source_port")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        Clients these options should apply to. Must be a either single IPv4 address or single IPv4 CIDR block.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetExportsExportLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the export was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the export was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetExportsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFileSystemQuotaRulesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFileSystemQuotaRulesQuotaRuleResult(dict):
    def __init__(__self__, *,
                 are_violators_only: builtins.bool,
                 display_name: builtins.str,
                 file_system_id: builtins.str,
                 id: builtins.str,
                 is_hard_quota: builtins.bool,
                 principal_id: builtins.int,
                 principal_type: builtins.str,
                 quota_limit_in_gigabytes: builtins.int,
                 quota_rule_id: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str):
        """
        :param builtins.bool are_violators_only: An option to only display the users or groups that violate their quota rules. If `areViolatorsOnly` is false, the list result will display all the quota and usage report. If `areViolatorsOnly` is true, the list result will only display the quota and usage report for the users or groups that violate their quota rules.
        :param builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        :param builtins.str file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        :param builtins.str id: The identifier of the quota rule. It is the base64 encoded string of the tuple <principalId, principalType, isHardQuota>.
        :param builtins.bool is_hard_quota: The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is false, the quota rule will be enforced so the usage cannot exceed the hard quota limit. If `isHardQuota` is true, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        :param builtins.int principal_id: An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        :param builtins.str principal_type: The type of the owner of this quota rule and usage.
        :param builtins.int quota_limit_in_gigabytes: The value of the quota rule. The unit is Gigabyte.
        :param builtins.str time_created: The date and time the quota rule was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_updated: The date and time the quota rule was last updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "are_violators_only", are_violators_only)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_hard_quota", is_hard_quota)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "quota_limit_in_gigabytes", quota_limit_in_gigabytes)
        pulumi.set(__self__, "quota_rule_id", quota_rule_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="areViolatorsOnly")
    def are_violators_only(self) -> builtins.bool:
        """
        An option to only display the users or groups that violate their quota rules. If `areViolatorsOnly` is false, the list result will display all the quota and usage report. If `areViolatorsOnly` is true, the list result will only display the quota and usage report for the users or groups that violate their quota rules.
        """
        return pulumi.get(self, "are_violators_only")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. Example: `UserXYZ's quota`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The identifier of the quota rule. It is the base64 encoded string of the tuple <principalId, principalType, isHardQuota>.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isHardQuota")
    def is_hard_quota(self) -> builtins.bool:
        """
        The flag is an identifier to tell whether the quota rule will be enforced. If `isHardQuota` is false, the quota rule will be enforced so the usage cannot exceed the hard quota limit. If `isHardQuota` is true, usage can exceed the soft quota limit. An alarm or notification will be sent to the customer, if the specific usage exceeds.
        """
        return pulumi.get(self, "is_hard_quota")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.int:
        """
        An identifier for the owner of this usage and quota rule. Unix-like operating systems use this integer value to identify a user or group to manage access control.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> builtins.str:
        """
        The type of the owner of this quota rule and usage.
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="quotaLimitInGigabytes")
    def quota_limit_in_gigabytes(self) -> builtins.int:
        """
        The value of the quota rule. The unit is Gigabyte.
        """
        return pulumi.get(self, "quota_limit_in_gigabytes")

    @property
    @pulumi.getter(name="quotaRuleId")
    def quota_rule_id(self) -> builtins.str:
        return pulumi.get(self, "quota_rule_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the quota rule was started, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the quota rule was last updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetFileSystemsFileSystemResult(dict):
    def __init__(__self__, *,
                 are_quota_rules_enabled: builtins.bool,
                 availability_domain: builtins.str,
                 clone_attach_status: builtins.str,
                 clone_count: builtins.int,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 detach_clone_trigger: builtins.int,
                 display_name: builtins.str,
                 filesystem_snapshot_policy_id: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_clone_parent: builtins.bool,
                 is_hydrated: builtins.bool,
                 is_lock_override: builtins.bool,
                 is_targetable: builtins.bool,
                 kms_key_id: builtins.str,
                 lifecycle_details: builtins.str,
                 locks: Sequence['outputs.GetFileSystemsFileSystemLockResult'],
                 metered_bytes: builtins.str,
                 quota_enforcement_state: builtins.str,
                 replication_source_count: builtins.int,
                 replication_target_id: builtins.str,
                 source_details: Sequence['outputs.GetFileSystemsFileSystemSourceDetailResult'],
                 source_snapshot_id: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str):
        """
        :param builtins.bool are_quota_rules_enabled: Specifies the enforcement of quota rules on the file system.
        :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param builtins.str clone_attach_status: Specifies whether the file system is attached to its parent file system.
        :param builtins.int clone_count: Specifies the total number of children of a file system.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        :param builtins.str filesystem_snapshot_policy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system snapshot policy that is associated with the file systems.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        :param builtins.bool is_clone_parent: Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param builtins.bool is_hydrated: Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        :param builtins.bool is_targetable: Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        :param builtins.str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        :param builtins.str lifecycle_details: Additional information about the current 'lifecycleState'.
        :param Sequence['GetFileSystemsFileSystemLockArgs'] locks: Locks associated with this resource.
        :param builtins.str metered_bytes: The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        :param builtins.str quota_enforcement_state: Displays the state of enforcement of quota rules on the file system.
        :param builtins.int replication_source_count: Specifies the total number of replications for which this file system is a source.
        :param builtins.str replication_target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        :param Sequence['GetFileSystemsFileSystemSourceDetailArgs'] source_details: Source information for the file system.
        :param builtins.str source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param builtins.str time_created: The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "are_quota_rules_enabled", are_quota_rules_enabled)
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "clone_attach_status", clone_attach_status)
        pulumi.set(__self__, "clone_count", clone_count)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "detach_clone_trigger", detach_clone_trigger)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "filesystem_snapshot_policy_id", filesystem_snapshot_policy_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_clone_parent", is_clone_parent)
        pulumi.set(__self__, "is_hydrated", is_hydrated)
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        pulumi.set(__self__, "is_targetable", is_targetable)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "metered_bytes", metered_bytes)
        pulumi.set(__self__, "quota_enforcement_state", quota_enforcement_state)
        pulumi.set(__self__, "replication_source_count", replication_source_count)
        pulumi.set(__self__, "replication_target_id", replication_target_id)
        pulumi.set(__self__, "source_details", source_details)
        pulumi.set(__self__, "source_snapshot_id", source_snapshot_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="areQuotaRulesEnabled")
    def are_quota_rules_enabled(self) -> builtins.bool:
        """
        Specifies the enforcement of quota rules on the file system.
        """
        return pulumi.get(self, "are_quota_rules_enabled")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="cloneAttachStatus")
    def clone_attach_status(self) -> builtins.str:
        """
        Specifies whether the file system is attached to its parent file system.
        """
        return pulumi.get(self, "clone_attach_status")

    @property
    @pulumi.getter(name="cloneCount")
    def clone_count(self) -> builtins.int:
        """
        Specifies the total number of children of a file system.
        """
        return pulumi.get(self, "clone_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="detachCloneTrigger")
    def detach_clone_trigger(self) -> builtins.int:
        return pulumi.get(self, "detach_clone_trigger")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filesystemSnapshotPolicyId")
    def filesystem_snapshot_policy_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system snapshot policy that is associated with the file systems.
        """
        return pulumi.get(self, "filesystem_snapshot_policy_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCloneParent")
    def is_clone_parent(self) -> builtins.bool:
        """
        Specifies whether the file system has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "is_clone_parent")

    @property
    @pulumi.getter(name="isHydrated")
    def is_hydrated(self) -> builtins.bool:
        """
        Specifies whether the data has finished copying from the source to the clone. Hydration can take up to several hours to complete depending on the size of the source. The source and clone remain available during hydration, but there may be some performance impact. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm#hydration).
        """
        return pulumi.get(self, "is_hydrated")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter(name="isTargetable")
    def is_targetable(self) -> builtins.bool:
        """
        Specifies whether the file system can be used as a target file system for replication. The system sets this value to `true` if the file system is unexported, hasn't yet been specified as a target file system in any replication resource, and has no user snapshots. After the file system has been specified as a target in a replication, or if the file system contains user snapshots, the system sets this value to `false`. For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/using-replication.htm).
        """
        return pulumi.get(self, "is_targetable")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KMS key used to encrypt the encryption keys associated with this file system.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetFileSystemsFileSystemLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="meteredBytes")
    def metered_bytes(self) -> builtins.str:
        """
        The number of bytes consumed by the file system, including any snapshots. This number reflects the metered size of the file system and is updated asynchronously with respect to updates to the file system. For more information, see [File System Usage and Metering](https://docs.cloud.oracle.com/iaas/Content/File/Concepts/FSutilization.htm).
        """
        return pulumi.get(self, "metered_bytes")

    @property
    @pulumi.getter(name="quotaEnforcementState")
    def quota_enforcement_state(self) -> builtins.str:
        """
        Displays the state of enforcement of quota rules on the file system.
        """
        return pulumi.get(self, "quota_enforcement_state")

    @property
    @pulumi.getter(name="replicationSourceCount")
    def replication_source_count(self) -> builtins.int:
        """
        Specifies the total number of replications for which this file system is a source.
        """
        return pulumi.get(self, "replication_source_count")

    @property
    @pulumi.getter(name="replicationTargetId")
    def replication_target_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the replication target associated with the file system. Empty if the file system is not being used as target in a replication.
        """
        return pulumi.get(self, "replication_target_id")

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Sequence['outputs.GetFileSystemsFileSystemSourceDetailResult']:
        """
        Source information for the file system.
        """
        return pulumi.get(self, "source_details")

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "source_snapshot_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetFileSystemsFileSystemLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the file system was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFileSystemsFileSystemSourceDetailResult(dict):
    def __init__(__self__, *,
                 parent_file_system_id: builtins.str,
                 source_snapshot_id: builtins.str):
        """
        :param builtins.str parent_file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system that contains the source snapshot of a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param builtins.str source_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        pulumi.set(__self__, "parent_file_system_id", parent_file_system_id)
        pulumi.set(__self__, "source_snapshot_id", source_snapshot_id)

    @property
    @pulumi.getter(name="parentFileSystemId")
    def parent_file_system_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system that contains the source snapshot of a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "parent_file_system_id")

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the snapshot used to create a cloned file system. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "source_snapshot_id")


@pulumi.output_type
class GetFileSystemsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_lock_override: builtins.bool,
                 locks: Sequence['outputs.GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyLockResult'],
                 policy_prefix: builtins.str,
                 schedules: Sequence['outputs.GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyScheduleResult'],
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str):
        """
        :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        :param Sequence['GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyLockArgs'] locks: Locks associated with this resource.
        :param builtins.str policy_prefix: The prefix to apply to all snapshots created by this policy.  Example: `acme`
        :param Sequence['GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyScheduleArgs'] schedules: The list of associated snapshot schedules. A maximum of 10 schedules can be associated with a policy.
        :param builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param builtins.str time_created: The date and time the file system snapshot policy was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "policy_prefix", policy_prefix)
        pulumi.set(__self__, "schedules", schedules)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="policyPrefix")
    def policy_prefix(self) -> builtins.str:
        """
        The prefix to apply to all snapshots created by this policy.  Example: `acme`
        """
        return pulumi.get(self, "policy_prefix")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyScheduleResult']:
        """
        The list of associated snapshot schedules. A maximum of 10 schedules can be associated with a policy.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the file system snapshot policy was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the file system snapshot policy was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the file system snapshot policy was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFilesystemSnapshotPoliciesFilesystemSnapshotPolicyScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_month: builtins.int,
                 day_of_week: builtins.str,
                 hour_of_day: builtins.int,
                 month: builtins.str,
                 period: builtins.str,
                 retention_duration_in_seconds: builtins.str,
                 schedule_prefix: builtins.str,
                 time_schedule_start: builtins.str,
                 time_zone: builtins.str):
        """
        :param builtins.int day_of_month: The day of the month to create a scheduled snapshot. If the day does not exist for the month, snapshot creation will be skipped. Used for MONTHLY and YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        :param builtins.str day_of_week: The day of the week to create a scheduled snapshot. Used for WEEKLY snapshot schedules. If not set, the system chooses a value at creation time.
        :param builtins.int hour_of_day: The hour of the day to create a DAILY, WEEKLY, MONTHLY, or YEARLY snapshot. If not set, the system chooses a value at creation time.
        :param builtins.str month: The month to create a scheduled snapshot. Used only for YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        :param builtins.str period: The frequency of scheduled snapshots.
        :param builtins.str retention_duration_in_seconds: The number of seconds to retain snapshots created with this schedule. Snapshot expiration time will not be set if this value is empty.
        :param builtins.str schedule_prefix: A name prefix to be applied to snapshots created by this schedule.  Example: `compliance1`
        :param builtins.str time_schedule_start: The starting point used to begin the scheduling of the snapshots based upon recurrence string in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. If no `timeScheduleStart` is provided, the value will be set to the time when the schedule was created.
        :param builtins.str time_zone: Time zone used for scheduling the snapshot.
        """
        pulumi.set(__self__, "day_of_month", day_of_month)
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "retention_duration_in_seconds", retention_duration_in_seconds)
        pulumi.set(__self__, "schedule_prefix", schedule_prefix)
        pulumi.set(__self__, "time_schedule_start", time_schedule_start)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> builtins.int:
        """
        The day of the month to create a scheduled snapshot. If the day does not exist for the month, snapshot creation will be skipped. Used for MONTHLY and YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "day_of_month")

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        The day of the week to create a scheduled snapshot. Used for WEEKLY snapshot schedules. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        """
        The hour of the day to create a DAILY, WEEKLY, MONTHLY, or YEARLY snapshot. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter
    def month(self) -> builtins.str:
        """
        The month to create a scheduled snapshot. Used only for YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def period(self) -> builtins.str:
        """
        The frequency of scheduled snapshots.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="retentionDurationInSeconds")
    def retention_duration_in_seconds(self) -> builtins.str:
        """
        The number of seconds to retain snapshots created with this schedule. Snapshot expiration time will not be set if this value is empty.
        """
        return pulumi.get(self, "retention_duration_in_seconds")

    @property
    @pulumi.getter(name="schedulePrefix")
    def schedule_prefix(self) -> builtins.str:
        """
        A name prefix to be applied to snapshots created by this schedule.  Example: `compliance1`
        """
        return pulumi.get(self, "schedule_prefix")

    @property
    @pulumi.getter(name="timeScheduleStart")
    def time_schedule_start(self) -> builtins.str:
        """
        The starting point used to begin the scheduling of the snapshots based upon recurrence string in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. If no `timeScheduleStart` is provided, the value will be set to the time when the schedule was created.
        """
        return pulumi.get(self, "time_schedule_start")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        Time zone used for scheduling the snapshot.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetFilesystemSnapshotPoliciesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetFilesystemSnapshotPolicyLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the file system snapshot policy was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the file system snapshot policy was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFilesystemSnapshotPolicyScheduleResult(dict):
    def __init__(__self__, *,
                 day_of_month: builtins.int,
                 day_of_week: builtins.str,
                 hour_of_day: builtins.int,
                 month: builtins.str,
                 period: builtins.str,
                 retention_duration_in_seconds: builtins.str,
                 schedule_prefix: builtins.str,
                 time_schedule_start: builtins.str,
                 time_zone: builtins.str):
        """
        :param builtins.int day_of_month: The day of the month to create a scheduled snapshot. If the day does not exist for the month, snapshot creation will be skipped. Used for MONTHLY and YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        :param builtins.str day_of_week: The day of the week to create a scheduled snapshot. Used for WEEKLY snapshot schedules. If not set, the system chooses a value at creation time.
        :param builtins.int hour_of_day: The hour of the day to create a DAILY, WEEKLY, MONTHLY, or YEARLY snapshot. If not set, the system chooses a value at creation time.
        :param builtins.str month: The month to create a scheduled snapshot. Used only for YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        :param builtins.str period: The frequency of scheduled snapshots.
        :param builtins.str retention_duration_in_seconds: The number of seconds to retain snapshots created with this schedule. Snapshot expiration time will not be set if this value is empty.
        :param builtins.str schedule_prefix: A name prefix to be applied to snapshots created by this schedule.  Example: `compliance1`
        :param builtins.str time_schedule_start: The starting point used to begin the scheduling of the snapshots based upon recurrence string in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. If no `timeScheduleStart` is provided, the value will be set to the time when the schedule was created.
        :param builtins.str time_zone: Time zone used for scheduling the snapshot.
        """
        pulumi.set(__self__, "day_of_month", day_of_month)
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "hour_of_day", hour_of_day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "retention_duration_in_seconds", retention_duration_in_seconds)
        pulumi.set(__self__, "schedule_prefix", schedule_prefix)
        pulumi.set(__self__, "time_schedule_start", time_schedule_start)
        pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="dayOfMonth")
    def day_of_month(self) -> builtins.int:
        """
        The day of the month to create a scheduled snapshot. If the day does not exist for the month, snapshot creation will be skipped. Used for MONTHLY and YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "day_of_month")

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> builtins.str:
        """
        The day of the week to create a scheduled snapshot. Used for WEEKLY snapshot schedules. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="hourOfDay")
    def hour_of_day(self) -> builtins.int:
        """
        The hour of the day to create a DAILY, WEEKLY, MONTHLY, or YEARLY snapshot. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "hour_of_day")

    @property
    @pulumi.getter
    def month(self) -> builtins.str:
        """
        The month to create a scheduled snapshot. Used only for YEARLY snapshot schedules. If not set, the system chooses a value at creation time.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def period(self) -> builtins.str:
        """
        The frequency of scheduled snapshots.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="retentionDurationInSeconds")
    def retention_duration_in_seconds(self) -> builtins.str:
        """
        The number of seconds to retain snapshots created with this schedule. Snapshot expiration time will not be set if this value is empty.
        """
        return pulumi.get(self, "retention_duration_in_seconds")

    @property
    @pulumi.getter(name="schedulePrefix")
    def schedule_prefix(self) -> builtins.str:
        """
        A name prefix to be applied to snapshots created by this schedule.  Example: `compliance1`
        """
        return pulumi.get(self, "schedule_prefix")

    @property
    @pulumi.getter(name="timeScheduleStart")
    def time_schedule_start(self) -> builtins.str:
        """
        The starting point used to begin the scheduling of the snapshots based upon recurrence string in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. If no `timeScheduleStart` is provided, the value will be set to the time when the schedule was created.
        """
        return pulumi.get(self, "time_schedule_start")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        Time zone used for scheduling the snapshot.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class GetMountTargetsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMountTargetsMountTargetResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 export_set_id: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 hostname_label: builtins.str,
                 id: builtins.str,
                 idmap_type: builtins.str,
                 ip_address: builtins.str,
                 is_lock_override: builtins.bool,
                 kerberos: Sequence['outputs.GetMountTargetsMountTargetKerberoResult'],
                 ldap_idmaps: Sequence['outputs.GetMountTargetsMountTargetLdapIdmapResult'],
                 lifecycle_details: builtins.str,
                 locks: Sequence['outputs.GetMountTargetsMountTargetLockResult'],
                 nsg_ids: Sequence[builtins.str],
                 observed_throughput: builtins.str,
                 private_ip_ids: Sequence[builtins.str],
                 requested_throughput: builtins.str,
                 reserved_storage_capacity: builtins.str,
                 state: builtins.str,
                 subnet_id: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_billing_cycle_end: builtins.str,
                 time_created: builtins.str):
        """
        :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        :param builtins.str export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export set.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        :param builtins.str idmap_type: The method used to map a Unix UID to secondary groups. If NONE, the mount target will not use the Unix UID for ID mapping.
        :param Sequence['GetMountTargetsMountTargetKerberoArgs'] kerberos: Allows administrator to configure a mount target to interact with the administrator's Kerberos infrastructure.
        :param Sequence['GetMountTargetsMountTargetLdapIdmapArgs'] ldap_idmaps: Mount target details about the LDAP ID mapping configuration.
        :param builtins.str lifecycle_details: Additional information about the current 'lifecycleState'.
        :param Sequence['GetMountTargetsMountTargetLockArgs'] locks: Locks associated with this resource.
        :param Sequence[builtins.str] nsg_ids: A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this mount target. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the mount target from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param builtins.str observed_throughput: Current billed throughput for mount target in Gbps. This corresponds to shape of mount target. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        :param Sequence[builtins.str] private_ip_ids: The OCIDs of the private IP addresses associated with this mount target.
        :param builtins.str requested_throughput: * New throughput for mount target at the end of billing cycle in Gbps.
        :param builtins.str reserved_storage_capacity: * Reserved capacity (GB) associated with this mount target. Reserved capacity depends on observedThroughput value of mount target. Value is listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        :param builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        :param builtins.str subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the mount target is in.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param builtins.str time_billing_cycle_end: The date and time the mount target current billing cycle will end, expressed in  [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Once a cycle ends, it is updated  automatically to next timestamp which is after 30 days.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str time_created: The date and time the mount target was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "export_set_id", export_set_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "hostname_label", hostname_label)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idmap_type", idmap_type)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        pulumi.set(__self__, "kerberos", kerberos)
        pulumi.set(__self__, "ldap_idmaps", ldap_idmaps)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "observed_throughput", observed_throughput)
        pulumi.set(__self__, "private_ip_ids", private_ip_ids)
        pulumi.set(__self__, "requested_throughput", requested_throughput)
        pulumi.set(__self__, "reserved_storage_capacity", reserved_storage_capacity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_billing_cycle_end", time_billing_cycle_end)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exportSetId")
    def export_set_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the export set.
        """
        return pulumi.get(self, "export_set_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> builtins.str:
        return pulumi.get(self, "hostname_label")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idmapType")
    def idmap_type(self) -> builtins.str:
        """
        The method used to map a Unix UID to secondary groups. If NONE, the mount target will not use the Unix UID for ID mapping.
        """
        return pulumi.get(self, "idmap_type")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> builtins.str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def kerberos(self) -> Sequence['outputs.GetMountTargetsMountTargetKerberoResult']:
        """
        Allows administrator to configure a mount target to interact with the administrator's Kerberos infrastructure.
        """
        return pulumi.get(self, "kerberos")

    @property
    @pulumi.getter(name="ldapIdmaps")
    def ldap_idmaps(self) -> Sequence['outputs.GetMountTargetsMountTargetLdapIdmapResult']:
        """
        Mount target details about the LDAP ID mapping configuration.
        """
        return pulumi.get(self, "ldap_idmaps")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetMountTargetsMountTargetLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[builtins.str]:
        """
        A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this mount target. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the mount target from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="observedThroughput")
    def observed_throughput(self) -> builtins.str:
        """
        Current billed throughput for mount target in Gbps. This corresponds to shape of mount target. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        return pulumi.get(self, "observed_throughput")

    @property
    @pulumi.getter(name="privateIpIds")
    def private_ip_ids(self) -> Sequence[builtins.str]:
        """
        The OCIDs of the private IP addresses associated with this mount target.
        """
        return pulumi.get(self, "private_ip_ids")

    @property
    @pulumi.getter(name="requestedThroughput")
    def requested_throughput(self) -> builtins.str:
        """
        * New throughput for mount target at the end of billing cycle in Gbps.
        """
        return pulumi.get(self, "requested_throughput")

    @property
    @pulumi.getter(name="reservedStorageCapacity")
    def reserved_storage_capacity(self) -> builtins.str:
        """
        * Reserved capacity (GB) associated with this mount target. Reserved capacity depends on observedThroughput value of mount target. Value is listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        return pulumi.get(self, "reserved_storage_capacity")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the mount target is in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeBillingCycleEnd")
    def time_billing_cycle_end(self) -> builtins.str:
        """
        The date and time the mount target current billing cycle will end, expressed in  [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Once a cycle ends, it is updated  automatically to next timestamp which is after 30 days.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_billing_cycle_end")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the mount target was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetMountTargetsMountTargetKerberoResult(dict):
    def __init__(__self__, *,
                 backup_key_tab_secret_version: builtins.int,
                 current_key_tab_secret_version: builtins.int,
                 is_kerberos_enabled: builtins.bool,
                 kerberos_realm: builtins.str,
                 key_tab_secret_id: builtins.str):
        """
        :param builtins.int backup_key_tab_secret_version: Version of the keytab secert in the Vault to use as a backup.
        :param builtins.int current_key_tab_secret_version: Version of the keytab secret in the Vault to use.
        :param builtins.bool is_kerberos_enabled: Specifies whether to enable or disable Kerberos.
        :param builtins.str kerberos_realm: The Kerberos realm that the mount target will join.
        :param builtins.str key_tab_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the keytab secret in the Vault.
        """
        pulumi.set(__self__, "backup_key_tab_secret_version", backup_key_tab_secret_version)
        pulumi.set(__self__, "current_key_tab_secret_version", current_key_tab_secret_version)
        pulumi.set(__self__, "is_kerberos_enabled", is_kerberos_enabled)
        pulumi.set(__self__, "kerberos_realm", kerberos_realm)
        pulumi.set(__self__, "key_tab_secret_id", key_tab_secret_id)

    @property
    @pulumi.getter(name="backupKeyTabSecretVersion")
    def backup_key_tab_secret_version(self) -> builtins.int:
        """
        Version of the keytab secert in the Vault to use as a backup.
        """
        return pulumi.get(self, "backup_key_tab_secret_version")

    @property
    @pulumi.getter(name="currentKeyTabSecretVersion")
    def current_key_tab_secret_version(self) -> builtins.int:
        """
        Version of the keytab secret in the Vault to use.
        """
        return pulumi.get(self, "current_key_tab_secret_version")

    @property
    @pulumi.getter(name="isKerberosEnabled")
    def is_kerberos_enabled(self) -> builtins.bool:
        """
        Specifies whether to enable or disable Kerberos.
        """
        return pulumi.get(self, "is_kerberos_enabled")

    @property
    @pulumi.getter(name="kerberosRealm")
    def kerberos_realm(self) -> builtins.str:
        """
        The Kerberos realm that the mount target will join.
        """
        return pulumi.get(self, "kerberos_realm")

    @property
    @pulumi.getter(name="keyTabSecretId")
    def key_tab_secret_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the keytab secret in the Vault.
        """
        return pulumi.get(self, "key_tab_secret_id")


@pulumi.output_type
class GetMountTargetsMountTargetLdapIdmapResult(dict):
    def __init__(__self__, *,
                 cache_lifetime_seconds: builtins.int,
                 cache_refresh_interval_seconds: builtins.int,
                 group_search_base: builtins.str,
                 negative_cache_lifetime_seconds: builtins.int,
                 outbound_connector1id: builtins.str,
                 outbound_connector2id: builtins.str,
                 schema_type: builtins.str,
                 user_search_base: builtins.str):
        """
        :param builtins.int cache_lifetime_seconds: The maximum amount of time the mount target is allowed to use a cached entry.
        :param builtins.int cache_refresh_interval_seconds: The amount of time that the mount target should allow an entry to persist in its cache before attempting to refresh the entry.
        :param builtins.str group_search_base: All LDAP searches are recursive starting at this group.  Example: `CN=Group,DC=domain,DC=com`
        :param builtins.int negative_cache_lifetime_seconds: The amount of time that a mount target will maintain information that a user is not found in the ID mapping configuration.
        :param builtins.str outbound_connector1id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the first connector to use to communicate with the LDAP server.
        :param builtins.str outbound_connector2id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second connector to use to communicate with the LDAP server.
        :param builtins.str schema_type: Schema type of the LDAP account.
        :param builtins.str user_search_base: All LDAP searches are recursive starting at this user.  Example: `CN=User,DC=domain,DC=com`
        """
        pulumi.set(__self__, "cache_lifetime_seconds", cache_lifetime_seconds)
        pulumi.set(__self__, "cache_refresh_interval_seconds", cache_refresh_interval_seconds)
        pulumi.set(__self__, "group_search_base", group_search_base)
        pulumi.set(__self__, "negative_cache_lifetime_seconds", negative_cache_lifetime_seconds)
        pulumi.set(__self__, "outbound_connector1id", outbound_connector1id)
        pulumi.set(__self__, "outbound_connector2id", outbound_connector2id)
        pulumi.set(__self__, "schema_type", schema_type)
        pulumi.set(__self__, "user_search_base", user_search_base)

    @property
    @pulumi.getter(name="cacheLifetimeSeconds")
    def cache_lifetime_seconds(self) -> builtins.int:
        """
        The maximum amount of time the mount target is allowed to use a cached entry.
        """
        return pulumi.get(self, "cache_lifetime_seconds")

    @property
    @pulumi.getter(name="cacheRefreshIntervalSeconds")
    def cache_refresh_interval_seconds(self) -> builtins.int:
        """
        The amount of time that the mount target should allow an entry to persist in its cache before attempting to refresh the entry.
        """
        return pulumi.get(self, "cache_refresh_interval_seconds")

    @property
    @pulumi.getter(name="groupSearchBase")
    def group_search_base(self) -> builtins.str:
        """
        All LDAP searches are recursive starting at this group.  Example: `CN=Group,DC=domain,DC=com`
        """
        return pulumi.get(self, "group_search_base")

    @property
    @pulumi.getter(name="negativeCacheLifetimeSeconds")
    def negative_cache_lifetime_seconds(self) -> builtins.int:
        """
        The amount of time that a mount target will maintain information that a user is not found in the ID mapping configuration.
        """
        return pulumi.get(self, "negative_cache_lifetime_seconds")

    @property
    @pulumi.getter(name="outboundConnector1id")
    def outbound_connector1id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the first connector to use to communicate with the LDAP server.
        """
        return pulumi.get(self, "outbound_connector1id")

    @property
    @pulumi.getter(name="outboundConnector2id")
    def outbound_connector2id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the second connector to use to communicate with the LDAP server.
        """
        return pulumi.get(self, "outbound_connector2id")

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> builtins.str:
        """
        Schema type of the LDAP account.
        """
        return pulumi.get(self, "schema_type")

    @property
    @pulumi.getter(name="userSearchBase")
    def user_search_base(self) -> builtins.str:
        """
        All LDAP searches are recursive starting at this user.  Example: `CN=User,DC=domain,DC=com`
        """
        return pulumi.get(self, "user_search_base")


@pulumi.output_type
class GetMountTargetsMountTargetLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the mount target was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the mount target was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetOutboundConnectorEndpointResult(dict):
    def __init__(__self__, *,
                 hostname: builtins.str,
                 port: builtins.str):
        """
        :param builtins.str hostname: Name of the DNS server.
        :param builtins.str port: Port of the DNS server.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        Name of the DNS server.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        Port of the DNS server.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetOutboundConnectorLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetOutboundConnectorsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOutboundConnectorsOutboundConnectorResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 bind_distinguished_name: builtins.str,
                 compartment_id: builtins.str,
                 connector_type: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 display_name: builtins.str,
                 endpoints: Sequence['outputs.GetOutboundConnectorsOutboundConnectorEndpointResult'],
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_lock_override: builtins.bool,
                 locks: Sequence['outputs.GetOutboundConnectorsOutboundConnectorLockResult'],
                 password_secret_id: builtins.str,
                 password_secret_version: builtins.int,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str):
        """
        :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param builtins.str bind_distinguished_name: The LDAP Distinguished Name of the account.
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param builtins.str connector_type: The account type of this outbound connector.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        :param Sequence['GetOutboundConnectorsOutboundConnectorEndpointArgs'] endpoints: Array of server endpoints to use when connecting with the LDAP bind account.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        :param Sequence['GetOutboundConnectorsOutboundConnectorLockArgs'] locks: Locks associated with this resource.
        :param builtins.str password_secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        :param builtins.int password_secret_version: Version of the password secret in the Vault to use.
        :param builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param builtins.str time_created: The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "bind_distinguished_name", bind_distinguished_name)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connector_type", connector_type)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "password_secret_id", password_secret_id)
        pulumi.set(__self__, "password_secret_version", password_secret_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="bindDistinguishedName")
    def bind_distinguished_name(self) -> builtins.str:
        """
        The LDAP Distinguished Name of the account.
        """
        return pulumi.get(self, "bind_distinguished_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> builtins.str:
        """
        The account type of this outbound connector.
        """
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetOutboundConnectorsOutboundConnectorEndpointResult']:
        """
        Array of server endpoints to use when connecting with the LDAP bind account.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetOutboundConnectorsOutboundConnectorLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the password for the LDAP bind account in the Vault.
        """
        return pulumi.get(self, "password_secret_id")

    @property
    @pulumi.getter(name="passwordSecretVersion")
    def password_secret_version(self) -> builtins.int:
        """
        Version of the password secret in the Vault to use.
        """
        return pulumi.get(self, "password_secret_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetOutboundConnectorsOutboundConnectorEndpointResult(dict):
    def __init__(__self__, *,
                 hostname: builtins.str,
                 port: builtins.str):
        """
        :param builtins.str hostname: Name of the DNS server.
        :param builtins.str port: Port of the DNS server.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        Name of the DNS server.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def port(self) -> builtins.str:
        """
        Port of the DNS server.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetOutboundConnectorsOutboundConnectorLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the outbound connector was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetReplicationLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetReplicationTargetsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetReplicationTargetsReplicationTargetResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 delta_progress: builtins.str,
                 delta_status: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 last_snapshot_id: builtins.str,
                 lifecycle_details: builtins.str,
                 recovery_point_time: builtins.str,
                 replication_id: builtins.str,
                 source_id: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 target_id: builtins.str,
                 time_created: builtins.str):
        """
        :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str delta_progress: Percentage progress of the current replication cycle.
        :param builtins.str delta_status: The current state of the snapshot during replication operations.
        :param builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        :param builtins.str last_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last snapshot snapshot which was completely applied to the target file system. Empty while the initial snapshot is being applied.
        :param builtins.str lifecycle_details: Additional information about the current `lifecycleState`.
        :param builtins.str recovery_point_time: The snapshotTime of the most recent recoverable replication snapshot in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-04-04T20:01:29.100Z`
        :param builtins.str replication_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of replication.
        :param builtins.str source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of source filesystem.
        :param builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param builtins.str target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of target filesystem.
        :param builtins.str time_created: The date and time the replication target was created in target region. in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-01-04T20:01:29.100Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "delta_progress", delta_progress)
        pulumi.set(__self__, "delta_status", delta_status)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_snapshot_id", last_snapshot_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "recovery_point_time", recovery_point_time)
        pulumi.set(__self__, "replication_id", replication_id)
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deltaProgress")
    def delta_progress(self) -> builtins.str:
        """
        Percentage progress of the current replication cycle.
        """
        return pulumi.get(self, "delta_progress")

    @property
    @pulumi.getter(name="deltaStatus")
    def delta_status(self) -> builtins.str:
        """
        The current state of the snapshot during replication operations.
        """
        return pulumi.get(self, "delta_status")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastSnapshotId")
    def last_snapshot_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last snapshot snapshot which was completely applied to the target file system. Empty while the initial snapshot is being applied.
        """
        return pulumi.get(self, "last_snapshot_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current `lifecycleState`.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="recoveryPointTime")
    def recovery_point_time(self) -> builtins.str:
        """
        The snapshotTime of the most recent recoverable replication snapshot in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-04-04T20:01:29.100Z`
        """
        return pulumi.get(self, "recovery_point_time")

    @property
    @pulumi.getter(name="replicationId")
    def replication_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of replication.
        """
        return pulumi.get(self, "replication_id")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of source filesystem.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of target filesystem.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the replication target was created in target region. in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-01-04T20:01:29.100Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetReplicationsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetReplicationsReplicationResult(dict):
    def __init__(__self__, *,
                 availability_domain: builtins.str,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 delta_progress: builtins.str,
                 delta_status: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_lock_override: builtins.bool,
                 last_snapshot_id: builtins.str,
                 lifecycle_details: builtins.str,
                 locks: Sequence['outputs.GetReplicationsReplicationLockResult'],
                 recovery_point_time: builtins.str,
                 replication_interval: builtins.str,
                 replication_target_id: builtins.str,
                 source_id: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 target_id: builtins.str,
                 time_created: builtins.str):
        """
        :param builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str delta_progress: Percentage progress of the current replication cycle.
        :param builtins.str delta_status: The current state of the snapshot during replication operations.
        :param builtins.str display_name: A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        :param builtins.str last_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last snapshot that has been replicated completely. Empty if the copy of the initial snapshot is not complete.
        :param builtins.str lifecycle_details: Additional information about the current 'lifecycleState'.
        :param Sequence['GetReplicationsReplicationLockArgs'] locks: Locks associated with this resource.
        :param builtins.str recovery_point_time: The [`snapshotTime`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Snapshot/snapshotTime) of the most recent recoverable replication snapshot in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-04-04T20:01:29.100Z`
        :param builtins.str replication_interval: Duration in minutes between replication snapshots.
        :param builtins.str replication_target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [`ReplicationTarget`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ReplicationTarget).
        :param builtins.str source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source file system.
        :param builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param builtins.str target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target file system.
        :param builtins.str time_created: The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "delta_progress", delta_progress)
        pulumi.set(__self__, "delta_status", delta_status)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        pulumi.set(__self__, "last_snapshot_id", last_snapshot_id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "recovery_point_time", recovery_point_time)
        pulumi.set(__self__, "replication_interval", replication_interval)
        pulumi.set(__self__, "replication_target_id", replication_target_id)
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deltaProgress")
    def delta_progress(self) -> builtins.str:
        """
        Percentage progress of the current replication cycle.
        """
        return pulumi.get(self, "delta_progress")

    @property
    @pulumi.getter(name="deltaStatus")
    def delta_status(self) -> builtins.str:
        """
        The current state of the snapshot during replication operations.
        """
        return pulumi.get(self, "delta_status")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable.  Example: `My resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter(name="lastSnapshotId")
    def last_snapshot_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last snapshot that has been replicated completely. Empty if the copy of the initial snapshot is not complete.
        """
        return pulumi.get(self, "last_snapshot_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetReplicationsReplicationLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="recoveryPointTime")
    def recovery_point_time(self) -> builtins.str:
        """
        The [`snapshotTime`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Snapshot/snapshotTime) of the most recent recoverable replication snapshot in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-04-04T20:01:29.100Z`
        """
        return pulumi.get(self, "recovery_point_time")

    @property
    @pulumi.getter(name="replicationInterval")
    def replication_interval(self) -> builtins.str:
        """
        Duration in minutes between replication snapshots.
        """
        return pulumi.get(self, "replication_interval")

    @property
    @pulumi.getter(name="replicationTargetId")
    def replication_target_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [`ReplicationTarget`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ReplicationTarget).
        """
        return pulumi.get(self, "replication_target_id")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source file system.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target file system.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetReplicationsReplicationLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSnapshotLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the snapshot was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the snapshot was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSnapshotsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        """
        :param builtins.str name: Name of the snapshot. This value is immutable.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the snapshot. This value is immutable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, builtins.str],
                 expiration_time: builtins.str,
                 file_system_id: builtins.str,
                 filesystem_snapshot_policy_id: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 is_clone_source: builtins.bool,
                 is_lock_override: builtins.bool,
                 lifecycle_details: builtins.str,
                 locks: Sequence['outputs.GetSnapshotsSnapshotLockResult'],
                 name: builtins.str,
                 provenance_id: builtins.str,
                 snapshot_time: builtins.str,
                 snapshot_type: builtins.str,
                 state: builtins.str,
                 system_tags: Mapping[str, builtins.str],
                 time_created: builtins.str):
        """
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str expiration_time: The time when this snapshot will be deleted.
        :param builtins.str file_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        :param builtins.str filesystem_snapshot_policy_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system snapshot policy that is used to create the snapshots.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param builtins.str id: Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        :param builtins.bool is_clone_source: Specifies whether the snapshot has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param builtins.str lifecycle_details: Additional information about the current `lifecycleState`.
        :param Sequence['GetSnapshotsSnapshotLockArgs'] locks: Locks associated with this resource.
        :param builtins.str name: Name of the snapshot. This value is immutable.
        :param builtins.str provenance_id: An [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) identifying the parent from which this snapshot was cloned. If this snapshot was not cloned, then the `provenanceId` is the same as the snapshot `id` value. If this snapshot was cloned, then the `provenanceId` value is the parent's `provenanceId`. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        :param builtins.str snapshot_time: The date and time the snapshot was taken, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. This value might be the same or different from `timeCreated` depending on the following factors:
               * If the snapshot is created in the original file system directory.
               * If the snapshot is cloned from a file system.
               * If the snapshot is replicated from a file system.
        :param builtins.str snapshot_type: Specifies the generation type of the snapshot.
        :param builtins.str state: Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        :param Mapping[str, builtins.str] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param builtins.str time_created: The date and time the snapshot was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "filesystem_snapshot_policy_id", filesystem_snapshot_policy_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_clone_source", is_clone_source)
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "locks", locks)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "provenance_id", provenance_id)
        pulumi.set(__self__, "snapshot_time", snapshot_time)
        pulumi.set(__self__, "snapshot_type", snapshot_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> builtins.str:
        """
        The time when this snapshot will be deleted.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="filesystemSnapshotPolicyId")
    def filesystem_snapshot_policy_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the file system snapshot policy that is used to create the snapshots.
        """
        return pulumi.get(self, "filesystem_snapshot_policy_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Filter results by [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Must be an OCID of the correct type for the resouce type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCloneSource")
    def is_clone_source(self) -> builtins.bool:
        """
        Specifies whether the snapshot has been cloned. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "is_clone_source")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> builtins.bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Additional information about the current `lifecycleState`.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetSnapshotsSnapshotLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the snapshot. This value is immutable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="provenanceId")
    def provenance_id(self) -> builtins.str:
        """
        An [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) identifying the parent from which this snapshot was cloned. If this snapshot was not cloned, then the `provenanceId` is the same as the snapshot `id` value. If this snapshot was cloned, then the `provenanceId` value is the parent's `provenanceId`. See [Cloning a File System](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/cloningFS.htm).
        """
        return pulumi.get(self, "provenance_id")

    @property
    @pulumi.getter(name="snapshotTime")
    def snapshot_time(self) -> builtins.str:
        """
        The date and time the snapshot was taken, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. This value might be the same or different from `timeCreated` depending on the following factors:
        * If the snapshot is created in the original file system directory.
        * If the snapshot is cloned from a file system.
        * If the snapshot is replicated from a file system.
        """
        return pulumi.get(self, "snapshot_time")

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> builtins.str:
        """
        Specifies the generation type of the snapshot.
        """
        return pulumi.get(self, "snapshot_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Filter results by the specified lifecycle state. Must be a valid state for the resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the snapshot was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetSnapshotsSnapshotLockResult(dict):
    def __init__(__self__, *,
                 message: builtins.str,
                 related_resource_id: builtins.str,
                 time_created: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str message: A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        :param builtins.str related_resource_id: The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        :param builtins.str time_created: The date and time the snapshot was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        :param builtins.str type: Type of the lock.
        """
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "related_resource_id", related_resource_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        A message added by the creator of the lock. This is typically used to give an indication of why the resource is locked.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="relatedResourceId")
    def related_resource_id(self) -> builtins.str:
        """
        The ID of the resource that is locking this resource. Indicates that deleting this resource will remove the lock.
        """
        return pulumi.get(self, "related_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the snapshot was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Type of the lock.
        """
        return pulumi.get(self, "type")


