# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCompliancePoliciesResult',
    'AwaitableGetCompliancePoliciesResult',
    'get_compliance_policies',
    'get_compliance_policies_output',
]

@pulumi.output_type
class GetCompliancePoliciesResult:
    """
    A collection of values returned by getCompliancePolicies.
    """
    def __init__(__self__, compartment_id=None, compliance_policy_collections=None, display_name=None, filters=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compliance_policy_collections and not isinstance(compliance_policy_collections, list):
            raise TypeError("Expected argument 'compliance_policy_collections' to be a list")
        pulumi.set(__self__, "compliance_policy_collections", compliance_policy_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[builtins.str]:
        """
        The OCID of the compartment the CompliancePolicy belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compliancePolicyCollections")
    def compliance_policy_collections(self) -> Sequence['outputs.GetCompliancePoliciesCompliancePolicyCollectionResult']:
        """
        The list of compliance_policy_collection.
        """
        return pulumi.get(self, "compliance_policy_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Display name for the CompliancePolicy.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCompliancePoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The OCID of the CompliancePolicy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the CompliancePolicy.
        """
        return pulumi.get(self, "state")


class AwaitableGetCompliancePoliciesResult(GetCompliancePoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCompliancePoliciesResult(
            compartment_id=self.compartment_id,
            compliance_policy_collections=self.compliance_policy_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_compliance_policies(compartment_id: Optional[builtins.str] = None,
                            display_name: Optional[builtins.str] = None,
                            filters: Optional[Sequence[Union['GetCompliancePoliciesFilterArgs', 'GetCompliancePoliciesFilterArgsDict']]] = None,
                            id: Optional[builtins.str] = None,
                            state: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCompliancePoliciesResult:
    """
    This data source provides the list of Compliance Policies in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of compliancePolicies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compliance_policies = oci.FleetAppsManagement.get_compliance_policies(compartment_id=compartment_id,
        display_name=compliance_policy_display_name,
        id=compliance_policy_id,
        state=compliance_policy_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: unique CompliancePolicy identifier.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getCompliancePolicies:getCompliancePolicies', __args__, opts=opts, typ=GetCompliancePoliciesResult).value

    return AwaitableGetCompliancePoliciesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compliance_policy_collections=pulumi.get(__ret__, 'compliance_policy_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_compliance_policies_output(compartment_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCompliancePoliciesFilterArgs', 'GetCompliancePoliciesFilterArgsDict']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCompliancePoliciesResult]:
    """
    This data source provides the list of Compliance Policies in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a list of compliancePolicies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compliance_policies = oci.FleetAppsManagement.get_compliance_policies(compartment_id=compartment_id,
        display_name=compliance_policy_display_name,
        id=compliance_policy_id,
        state=compliance_policy_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: unique CompliancePolicy identifier.
    :param builtins.str state: A filter to return only resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getCompliancePolicies:getCompliancePolicies', __args__, opts=opts, typ=GetCompliancePoliciesResult)
    return __ret__.apply(lambda __response__: GetCompliancePoliciesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compliance_policy_collections=pulumi.get(__response__, 'compliance_policy_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
