# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPbfListingVersionsResult',
    'AwaitableGetPbfListingVersionsResult',
    'get_pbf_listing_versions',
    'get_pbf_listing_versions_output',
]

@pulumi.output_type
class GetPbfListingVersionsResult:
    """
    A collection of values returned by getPbfListingVersions.
    """
    def __init__(__self__, filters=None, id=None, is_current_version=None, name=None, pbf_listing_id=None, pbf_listing_version_id=None, pbf_listing_versions_collections=None, state=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_current_version and not isinstance(is_current_version, bool):
            raise TypeError("Expected argument 'is_current_version' to be a bool")
        pulumi.set(__self__, "is_current_version", is_current_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pbf_listing_id and not isinstance(pbf_listing_id, str):
            raise TypeError("Expected argument 'pbf_listing_id' to be a str")
        pulumi.set(__self__, "pbf_listing_id", pbf_listing_id)
        if pbf_listing_version_id and not isinstance(pbf_listing_version_id, str):
            raise TypeError("Expected argument 'pbf_listing_version_id' to be a str")
        pulumi.set(__self__, "pbf_listing_version_id", pbf_listing_version_id)
        if pbf_listing_versions_collections and not isinstance(pbf_listing_versions_collections, list):
            raise TypeError("Expected argument 'pbf_listing_versions_collections' to be a list")
        pulumi.set(__self__, "pbf_listing_versions_collections", pbf_listing_versions_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPbfListingVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCurrentVersion")
    def is_current_version(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "is_current_version")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        A brief descriptive name for the PBF trigger.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pbfListingId")
    def pbf_listing_id(self) -> builtins.str:
        """
        The OCID of the PbfListing this resource version belongs to.
        """
        return pulumi.get(self, "pbf_listing_id")

    @property
    @pulumi.getter(name="pbfListingVersionId")
    def pbf_listing_version_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "pbf_listing_version_id")

    @property
    @pulumi.getter(name="pbfListingVersionsCollections")
    def pbf_listing_versions_collections(self) -> Sequence['outputs.GetPbfListingVersionsPbfListingVersionsCollectionResult']:
        """
        The list of pbf_listing_versions_collection.
        """
        return pulumi.get(self, "pbf_listing_versions_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the PBF resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetPbfListingVersionsResult(GetPbfListingVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPbfListingVersionsResult(
            filters=self.filters,
            id=self.id,
            is_current_version=self.is_current_version,
            name=self.name,
            pbf_listing_id=self.pbf_listing_id,
            pbf_listing_version_id=self.pbf_listing_version_id,
            pbf_listing_versions_collections=self.pbf_listing_versions_collections,
            state=self.state)


def get_pbf_listing_versions(filters: Optional[Sequence[Union['GetPbfListingVersionsFilterArgs', 'GetPbfListingVersionsFilterArgsDict']]] = None,
                             is_current_version: Optional[builtins.bool] = None,
                             name: Optional[builtins.str] = None,
                             pbf_listing_id: Optional[builtins.str] = None,
                             pbf_listing_version_id: Optional[builtins.str] = None,
                             state: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPbfListingVersionsResult:
    """
    This data source provides the list of Pbf Listing Versions in Oracle Cloud Infrastructure Functions service.

    Fetches a wrapped list of all Pre-built Function(PBF) Listing versions. Returns a PbfListingVersionCollection
    containing an array of PbfListingVersionSummary response models.

    Note that the PbfListingIdentifier must be provided as a query parameter, otherwise an exception shall
    be thrown.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pbf_listing_versions = oci.Functions.get_pbf_listing_versions(pbf_listing_id=test_pbf_listing["id"],
        is_current_version=pbf_listing_version_is_current_version,
        name=pbf_listing_version_name,
        pbf_listing_version_id=test_pbf_listing_version["id"],
        state=pbf_listing_version_state)
    ```


    :param builtins.bool is_current_version: Matches the current version (the most recently added version with an Active  lifecycleState) associated with a PbfListing.
    :param builtins.str name: Matches a PbfListingVersion based on a provided semantic version name for a PbfListingVersion.  Each PbfListingVersion name is unique with respect to its associated PbfListing.
    :param builtins.str pbf_listing_id: unique PbfListing identifier
    :param builtins.str pbf_listing_version_id: unique PbfListingVersion identifier
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['isCurrentVersion'] = is_current_version
    __args__['name'] = name
    __args__['pbfListingId'] = pbf_listing_id
    __args__['pbfListingVersionId'] = pbf_listing_version_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Functions/getPbfListingVersions:getPbfListingVersions', __args__, opts=opts, typ=GetPbfListingVersionsResult).value

    return AwaitableGetPbfListingVersionsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_current_version=pulumi.get(__ret__, 'is_current_version'),
        name=pulumi.get(__ret__, 'name'),
        pbf_listing_id=pulumi.get(__ret__, 'pbf_listing_id'),
        pbf_listing_version_id=pulumi.get(__ret__, 'pbf_listing_version_id'),
        pbf_listing_versions_collections=pulumi.get(__ret__, 'pbf_listing_versions_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_pbf_listing_versions_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPbfListingVersionsFilterArgs', 'GetPbfListingVersionsFilterArgsDict']]]]] = None,
                                    is_current_version: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                    name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    pbf_listing_id: Optional[pulumi.Input[builtins.str]] = None,
                                    pbf_listing_version_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPbfListingVersionsResult]:
    """
    This data source provides the list of Pbf Listing Versions in Oracle Cloud Infrastructure Functions service.

    Fetches a wrapped list of all Pre-built Function(PBF) Listing versions. Returns a PbfListingVersionCollection
    containing an array of PbfListingVersionSummary response models.

    Note that the PbfListingIdentifier must be provided as a query parameter, otherwise an exception shall
    be thrown.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_pbf_listing_versions = oci.Functions.get_pbf_listing_versions(pbf_listing_id=test_pbf_listing["id"],
        is_current_version=pbf_listing_version_is_current_version,
        name=pbf_listing_version_name,
        pbf_listing_version_id=test_pbf_listing_version["id"],
        state=pbf_listing_version_state)
    ```


    :param builtins.bool is_current_version: Matches the current version (the most recently added version with an Active  lifecycleState) associated with a PbfListing.
    :param builtins.str name: Matches a PbfListingVersion based on a provided semantic version name for a PbfListingVersion.  Each PbfListingVersion name is unique with respect to its associated PbfListing.
    :param builtins.str pbf_listing_id: unique PbfListing identifier
    :param builtins.str pbf_listing_version_id: unique PbfListingVersion identifier
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['isCurrentVersion'] = is_current_version
    __args__['name'] = name
    __args__['pbfListingId'] = pbf_listing_id
    __args__['pbfListingVersionId'] = pbf_listing_version_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Functions/getPbfListingVersions:getPbfListingVersions', __args__, opts=opts, typ=GetPbfListingVersionsResult)
    return __ret__.apply(lambda __response__: GetPbfListingVersionsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_current_version=pulumi.get(__response__, 'is_current_version'),
        name=pulumi.get(__response__, 'name'),
        pbf_listing_id=pulumi.get(__response__, 'pbf_listing_id'),
        pbf_listing_version_id=pulumi.get(__response__, 'pbf_listing_version_id'),
        pbf_listing_versions_collections=pulumi.get(__response__, 'pbf_listing_versions_collections'),
        state=pulumi.get(__response__, 'state')))
