# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HostInsightArgs', 'HostInsight']

@pulumi.input_type
class HostInsightArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 entity_source: pulumi.Input[builtins.str],
                 compute_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_insight_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a HostInsight resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier of host
        :param pulumi.Input[builtins.str] entity_source: (Updatable) Source of the host entity.
        :param pulumi.Input[builtins.str] compute_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute Instance
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[builtins.str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[builtins.str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[builtins.str] exadata_insight_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] management_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same Management agent OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        :param pulumi.Input[builtins.str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "entity_source", entity_source)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if enterprise_manager_bridge_id is not None:
            pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if enterprise_manager_entity_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_entity_identifier", enterprise_manager_entity_identifier)
        if enterprise_manager_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_identifier", enterprise_manager_identifier)
        if exadata_insight_id is not None:
            pulumi.set(__self__, "exadata_insight_id", exadata_insight_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Compartment Identifier of host
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Source of the host entity.
        """
        return pulumi.get(self, "entity_source")

    @entity_source.setter
    def entity_source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "entity_source", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute Instance
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @enterprise_manager_bridge_id.setter
    def enterprise_manager_bridge_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_manager_bridge_id", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @enterprise_manager_entity_identifier.setter
    def enterprise_manager_entity_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_manager_entity_identifier", value)

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @enterprise_manager_identifier.setter
    def enterprise_manager_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_manager_identifier", value)

    @property
    @pulumi.getter(name="exadataInsightId")
    def exadata_insight_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        """
        return pulumi.get(self, "exadata_insight_id")

    @exadata_insight_id.setter
    def exadata_insight_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exadata_insight_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same Management agent OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _HostInsightState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_entity_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_entity_name: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_entity_type: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 entity_source: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_insight_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 host_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 host_name: Optional[pulumi.Input[builtins.str]] = None,
                 host_type: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 management_agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 platform_name: Optional[pulumi.Input[builtins.str]] = None,
                 platform_type: Optional[pulumi.Input[builtins.str]] = None,
                 platform_version: Optional[pulumi.Input[builtins.str]] = None,
                 processor_count: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering HostInsight resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier of host
        :param pulumi.Input[builtins.str] compute_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute Instance
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[builtins.str] enterprise_manager_entity_display_name: Enterprise Manager Entity Display Name
        :param pulumi.Input[builtins.str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[builtins.str] enterprise_manager_entity_name: Enterprise Manager Entity Name
        :param pulumi.Input[builtins.str] enterprise_manager_entity_type: Enterprise Manager Entity Type
        :param pulumi.Input[builtins.str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[builtins.str] entity_source: (Updatable) Source of the host entity.
        :param pulumi.Input[builtins.str] exadata_insight_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] host_display_name: The user-friendly name for the host. The name does not have to be unique.
        :param pulumi.Input[builtins.str] host_name: The host name. The host name is unique amongst the hosts managed by the same management agent.
        :param pulumi.Input[builtins.str] host_type: Ops Insights internal representation of the host type. Possible value is EXTERNAL-HOST.
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[builtins.str] management_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same Management agent OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        :param pulumi.Input[builtins.str] platform_name: Platform name.
        :param pulumi.Input[builtins.str] platform_type: Platform type. Supported platformType(s) for MACS-managed external host insight: [LINUX, SOLARIS, WINDOWS]. Supported platformType(s) for MACS-managed cloud host insight: [LINUX]. Supported platformType(s) for EM-managed external host insight: [LINUX, SOLARIS, SUNOS, ZLINUX, WINDOWS, AIX].
        :param pulumi.Input[builtins.str] platform_version: Platform version.
        :param pulumi.Input[builtins.str] state: The current state of the host.
        :param pulumi.Input[builtins.str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the the host insight was first enabled. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time the host insight was updated. An RFC3339 formatted datetime string
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_id is not None:
            pulumi.set(__self__, "compute_id", compute_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if enterprise_manager_bridge_id is not None:
            pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if enterprise_manager_entity_display_name is not None:
            pulumi.set(__self__, "enterprise_manager_entity_display_name", enterprise_manager_entity_display_name)
        if enterprise_manager_entity_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_entity_identifier", enterprise_manager_entity_identifier)
        if enterprise_manager_entity_name is not None:
            pulumi.set(__self__, "enterprise_manager_entity_name", enterprise_manager_entity_name)
        if enterprise_manager_entity_type is not None:
            pulumi.set(__self__, "enterprise_manager_entity_type", enterprise_manager_entity_type)
        if enterprise_manager_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_identifier", enterprise_manager_identifier)
        if entity_source is not None:
            pulumi.set(__self__, "entity_source", entity_source)
        if exadata_insight_id is not None:
            pulumi.set(__self__, "exadata_insight_id", exadata_insight_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_display_name is not None:
            pulumi.set(__self__, "host_display_name", host_display_name)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if host_type is not None:
            pulumi.set(__self__, "host_type", host_type)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if platform_name is not None:
            pulumi.set(__self__, "platform_name", platform_name)
        if platform_type is not None:
            pulumi.set(__self__, "platform_type", platform_type)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if processor_count is not None:
            pulumi.set(__self__, "processor_count", processor_count)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Compartment Identifier of host
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute Instance
        """
        return pulumi.get(self, "compute_id")

    @compute_id.setter
    def compute_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @enterprise_manager_bridge_id.setter
    def enterprise_manager_bridge_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_manager_bridge_id", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityDisplayName")
    def enterprise_manager_entity_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enterprise Manager Entity Display Name
        """
        return pulumi.get(self, "enterprise_manager_entity_display_name")

    @enterprise_manager_entity_display_name.setter
    def enterprise_manager_entity_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_manager_entity_display_name", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @enterprise_manager_entity_identifier.setter
    def enterprise_manager_entity_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_manager_entity_identifier", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityName")
    def enterprise_manager_entity_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enterprise Manager Entity Name
        """
        return pulumi.get(self, "enterprise_manager_entity_name")

    @enterprise_manager_entity_name.setter
    def enterprise_manager_entity_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_manager_entity_name", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityType")
    def enterprise_manager_entity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enterprise Manager Entity Type
        """
        return pulumi.get(self, "enterprise_manager_entity_type")

    @enterprise_manager_entity_type.setter
    def enterprise_manager_entity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_manager_entity_type", value)

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @enterprise_manager_identifier.setter
    def enterprise_manager_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_manager_identifier", value)

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Source of the host entity.
        """
        return pulumi.get(self, "entity_source")

    @entity_source.setter
    def entity_source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entity_source", value)

    @property
    @pulumi.getter(name="exadataInsightId")
    def exadata_insight_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        """
        return pulumi.get(self, "exadata_insight_id")

    @exadata_insight_id.setter
    def exadata_insight_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exadata_insight_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostDisplayName")
    def host_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-friendly name for the host. The name does not have to be unique.
        """
        return pulumi.get(self, "host_display_name")

    @host_display_name.setter
    def host_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_display_name", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The host name. The host name is unique amongst the hosts managed by the same management agent.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Ops Insights internal representation of the host type. Possible value is EXTERNAL-HOST.
        """
        return pulumi.get(self, "host_type")

    @host_type.setter
    def host_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_type", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same Management agent OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @property
    @pulumi.getter(name="platformName")
    def platform_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Platform name.
        """
        return pulumi.get(self, "platform_name")

    @platform_name.setter
    def platform_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_name", value)

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Platform type. Supported platformType(s) for MACS-managed external host insight: [LINUX, SOLARIS, WINDOWS]. Supported platformType(s) for MACS-managed cloud host insight: [LINUX]. Supported platformType(s) for EM-managed external host insight: [LINUX, SOLARIS, SUNOS, ZLINUX, WINDOWS, AIX].
        """
        return pulumi.get(self, "platform_type")

    @platform_type.setter
    def platform_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_type", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Platform version.
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter(name="processorCount")
    def processor_count(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "processor_count")

    @processor_count.setter
    def processor_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "processor_count", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the host.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the the host insight was first enabled. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the host insight was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class HostInsight(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 entity_source: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_insight_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Host Insight resource in Oracle Cloud Infrastructure Opsi service.

        Create a Host Insight resource for a host in Ops Insights. The host will be enabled in Ops Insights. Host metric collection and analysis will be started.

        ## Import

        HostInsights can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/hostInsight:HostInsight test_host_insight "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier of host
        :param pulumi.Input[builtins.str] compute_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute Instance
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[builtins.str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[builtins.str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[builtins.str] entity_source: (Updatable) Source of the host entity.
        :param pulumi.Input[builtins.str] exadata_insight_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] management_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same Management agent OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        :param pulumi.Input[builtins.str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostInsightArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Host Insight resource in Oracle Cloud Infrastructure Opsi service.

        Create a Host Insight resource for a host in Ops Insights. The host will be enabled in Ops Insights. Host metric collection and analysis will be started.

        ## Import

        HostInsights can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/hostInsight:HostInsight test_host_insight "id"
        ```

        :param str resource_name: The name of the resource.
        :param HostInsightArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostInsightArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 entity_source: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_insight_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 management_agent_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostInsightArgs.__new__(HostInsightArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_id"] = compute_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["enterprise_manager_bridge_id"] = enterprise_manager_bridge_id
            __props__.__dict__["enterprise_manager_entity_identifier"] = enterprise_manager_entity_identifier
            __props__.__dict__["enterprise_manager_identifier"] = enterprise_manager_identifier
            if entity_source is None and not opts.urn:
                raise TypeError("Missing required property 'entity_source'")
            __props__.__dict__["entity_source"] = entity_source
            __props__.__dict__["exadata_insight_id"] = exadata_insight_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["management_agent_id"] = management_agent_id
            __props__.__dict__["status"] = status
            __props__.__dict__["enterprise_manager_entity_display_name"] = None
            __props__.__dict__["enterprise_manager_entity_name"] = None
            __props__.__dict__["enterprise_manager_entity_type"] = None
            __props__.__dict__["host_display_name"] = None
            __props__.__dict__["host_name"] = None
            __props__.__dict__["host_type"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["platform_name"] = None
            __props__.__dict__["platform_type"] = None
            __props__.__dict__["platform_version"] = None
            __props__.__dict__["processor_count"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(HostInsight, __self__).__init__(
            'oci:Opsi/hostInsight:HostInsight',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            compute_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            enterprise_manager_bridge_id: Optional[pulumi.Input[builtins.str]] = None,
            enterprise_manager_entity_display_name: Optional[pulumi.Input[builtins.str]] = None,
            enterprise_manager_entity_identifier: Optional[pulumi.Input[builtins.str]] = None,
            enterprise_manager_entity_name: Optional[pulumi.Input[builtins.str]] = None,
            enterprise_manager_entity_type: Optional[pulumi.Input[builtins.str]] = None,
            enterprise_manager_identifier: Optional[pulumi.Input[builtins.str]] = None,
            entity_source: Optional[pulumi.Input[builtins.str]] = None,
            exadata_insight_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            host_display_name: Optional[pulumi.Input[builtins.str]] = None,
            host_name: Optional[pulumi.Input[builtins.str]] = None,
            host_type: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            management_agent_id: Optional[pulumi.Input[builtins.str]] = None,
            platform_name: Optional[pulumi.Input[builtins.str]] = None,
            platform_type: Optional[pulumi.Input[builtins.str]] = None,
            platform_version: Optional[pulumi.Input[builtins.str]] = None,
            processor_count: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'HostInsight':
        """
        Get an existing HostInsight resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier of host
        :param pulumi.Input[builtins.str] compute_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute Instance
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[builtins.str] enterprise_manager_entity_display_name: Enterprise Manager Entity Display Name
        :param pulumi.Input[builtins.str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[builtins.str] enterprise_manager_entity_name: Enterprise Manager Entity Name
        :param pulumi.Input[builtins.str] enterprise_manager_entity_type: Enterprise Manager Entity Type
        :param pulumi.Input[builtins.str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[builtins.str] entity_source: (Updatable) Source of the host entity.
        :param pulumi.Input[builtins.str] exadata_insight_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] host_display_name: The user-friendly name for the host. The name does not have to be unique.
        :param pulumi.Input[builtins.str] host_name: The host name. The host name is unique amongst the hosts managed by the same management agent.
        :param pulumi.Input[builtins.str] host_type: Ops Insights internal representation of the host type. Possible value is EXTERNAL-HOST.
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[builtins.str] management_agent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same Management agent OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        :param pulumi.Input[builtins.str] platform_name: Platform name.
        :param pulumi.Input[builtins.str] platform_type: Platform type. Supported platformType(s) for MACS-managed external host insight: [LINUX, SOLARIS, WINDOWS]. Supported platformType(s) for MACS-managed cloud host insight: [LINUX]. Supported platformType(s) for EM-managed external host insight: [LINUX, SOLARIS, SUNOS, ZLINUX, WINDOWS, AIX].
        :param pulumi.Input[builtins.str] platform_version: Platform version.
        :param pulumi.Input[builtins.str] state: The current state of the host.
        :param pulumi.Input[builtins.str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the the host insight was first enabled. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time the host insight was updated. An RFC3339 formatted datetime string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostInsightState.__new__(_HostInsightState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_id"] = compute_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["enterprise_manager_bridge_id"] = enterprise_manager_bridge_id
        __props__.__dict__["enterprise_manager_entity_display_name"] = enterprise_manager_entity_display_name
        __props__.__dict__["enterprise_manager_entity_identifier"] = enterprise_manager_entity_identifier
        __props__.__dict__["enterprise_manager_entity_name"] = enterprise_manager_entity_name
        __props__.__dict__["enterprise_manager_entity_type"] = enterprise_manager_entity_type
        __props__.__dict__["enterprise_manager_identifier"] = enterprise_manager_identifier
        __props__.__dict__["entity_source"] = entity_source
        __props__.__dict__["exadata_insight_id"] = exadata_insight_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host_display_name"] = host_display_name
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["host_type"] = host_type
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["management_agent_id"] = management_agent_id
        __props__.__dict__["platform_name"] = platform_name
        __props__.__dict__["platform_type"] = platform_type
        __props__.__dict__["platform_version"] = platform_version
        __props__.__dict__["processor_count"] = processor_count
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return HostInsight(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Compartment Identifier of host
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeId")
    def compute_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Compute Instance
        """
        return pulumi.get(self, "compute_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> pulumi.Output[builtins.str]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @property
    @pulumi.getter(name="enterpriseManagerEntityDisplayName")
    def enterprise_manager_entity_display_name(self) -> pulumi.Output[builtins.str]:
        """
        Enterprise Manager Entity Display Name
        """
        return pulumi.get(self, "enterprise_manager_entity_display_name")

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @property
    @pulumi.getter(name="enterpriseManagerEntityName")
    def enterprise_manager_entity_name(self) -> pulumi.Output[builtins.str]:
        """
        Enterprise Manager Entity Name
        """
        return pulumi.get(self, "enterprise_manager_entity_name")

    @property
    @pulumi.getter(name="enterpriseManagerEntityType")
    def enterprise_manager_entity_type(self) -> pulumi.Output[builtins.str]:
        """
        Enterprise Manager Entity Type
        """
        return pulumi.get(self, "enterprise_manager_entity_type")

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> pulumi.Output[builtins.str]:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Source of the host entity.
        """
        return pulumi.get(self, "entity_source")

    @property
    @pulumi.getter(name="exadataInsightId")
    def exadata_insight_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        """
        return pulumi.get(self, "exadata_insight_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostDisplayName")
    def host_display_name(self) -> pulumi.Output[builtins.str]:
        """
        The user-friendly name for the host. The name does not have to be unique.
        """
        return pulumi.get(self, "host_display_name")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[builtins.str]:
        """
        The host name. The host name is unique amongst the hosts managed by the same management agent.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="hostType")
    def host_type(self) -> pulumi.Output[builtins.str]:
        """
        Ops Insights internal representation of the host type. Possible value is EXTERNAL-HOST.
        """
        return pulumi.get(self, "host_type")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same Management agent OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        """
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter(name="platformName")
    def platform_name(self) -> pulumi.Output[builtins.str]:
        """
        Platform name.
        """
        return pulumi.get(self, "platform_name")

    @property
    @pulumi.getter(name="platformType")
    def platform_type(self) -> pulumi.Output[builtins.str]:
        """
        Platform type. Supported platformType(s) for MACS-managed external host insight: [LINUX, SOLARIS, WINDOWS]. Supported platformType(s) for MACS-managed cloud host insight: [LINUX]. Supported platformType(s) for EM-managed external host insight: [LINUX, SOLARIS, SUNOS, ZLINUX, WINDOWS, AIX].
        """
        return pulumi.get(self, "platform_type")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> pulumi.Output[builtins.str]:
        """
        Platform version.
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="processorCount")
    def processor_count(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "processor_count")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the host.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the the host insight was first enabled. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the host insight was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

