# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OperationsInsightsWarehouseArgs', 'OperationsInsightsWarehouse']

@pulumi.input_type
class OperationsInsightsWarehouseArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 cpu_allocated: pulumi.Input[builtins.float],
                 display_name: pulumi.Input[builtins.str],
                 compute_model: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 storage_allocated_in_gbs: Optional[pulumi.Input[builtins.float]] = None):
        """
        The set of arguments for constructing a OperationsInsightsWarehouse resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.float] cpu_allocated: (Updatable) Number of CPUs allocated to OPSI Warehouse ADW.
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friedly name of Ops Insights Warehouse that does not have to be unique.
        :param pulumi.Input[builtins.str] compute_model: (Updatable) The compute model for the OPSI warehouse ADW (OCPU or ECPU)
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.float] storage_allocated_in_gbs: (Updatable) Storage allocated to OPSI Warehouse ADW. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "cpu_allocated", cpu_allocated)
        pulumi.set(__self__, "display_name", display_name)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if storage_allocated_in_gbs is not None:
            pulumi.set(__self__, "storage_allocated_in_gbs", storage_allocated_in_gbs)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpuAllocated")
    def cpu_allocated(self) -> pulumi.Input[builtins.float]:
        """
        (Updatable) Number of CPUs allocated to OPSI Warehouse ADW.
        """
        return pulumi.get(self, "cpu_allocated")

    @cpu_allocated.setter
    def cpu_allocated(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "cpu_allocated", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) User-friedly name of Ops Insights Warehouse that does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The compute model for the OPSI warehouse ADW (OCPU or ECPU)
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="storageAllocatedInGbs")
    def storage_allocated_in_gbs(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        (Updatable) Storage allocated to OPSI Warehouse ADW. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "storage_allocated_in_gbs")

    @storage_allocated_in_gbs.setter
    def storage_allocated_in_gbs(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "storage_allocated_in_gbs", value)


@pulumi.input_type
class _OperationsInsightsWarehouseState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_model: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_allocated: Optional[pulumi.Input[builtins.float]] = None,
                 cpu_used: Optional[pulumi.Input[builtins.float]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dynamic_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 operations_insights_tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 storage_allocated_in_gbs: Optional[pulumi.Input[builtins.float]] = None,
                 storage_used_in_gbs: Optional[pulumi.Input[builtins.float]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_last_wallet_rotated: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OperationsInsightsWarehouse resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] compute_model: (Updatable) The compute model for the OPSI warehouse ADW (OCPU or ECPU)
        :param pulumi.Input[builtins.float] cpu_allocated: (Updatable) Number of CPUs allocated to OPSI Warehouse ADW.
        :param pulumi.Input[builtins.float] cpu_used: Number of OCPUs used by OPSI Warehouse ADW. Can be fractional.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friedly name of Ops Insights Warehouse that does not have to be unique.
        :param pulumi.Input[builtins.str] dynamic_group_id: OCID of the dynamic group created for the warehouse
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[builtins.str] operations_insights_tenancy_id: Tenancy Identifier of Ops Insights service
        :param pulumi.Input[builtins.str] state: Possible lifecycle states
        :param pulumi.Input[builtins.float] storage_allocated_in_gbs: (Updatable) Storage allocated to OPSI Warehouse ADW. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.float] storage_used_in_gbs: Storage by OPSI Warehouse ADW in GB.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time at which the resource was first created. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_last_wallet_rotated: The time at which the ADW wallet was last rotated for the Ops Insights Warehouse. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if cpu_allocated is not None:
            pulumi.set(__self__, "cpu_allocated", cpu_allocated)
        if cpu_used is not None:
            pulumi.set(__self__, "cpu_used", cpu_used)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dynamic_group_id is not None:
            pulumi.set(__self__, "dynamic_group_id", dynamic_group_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if operations_insights_tenancy_id is not None:
            pulumi.set(__self__, "operations_insights_tenancy_id", operations_insights_tenancy_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_allocated_in_gbs is not None:
            pulumi.set(__self__, "storage_allocated_in_gbs", storage_allocated_in_gbs)
        if storage_used_in_gbs is not None:
            pulumi.set(__self__, "storage_used_in_gbs", storage_used_in_gbs)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_wallet_rotated is not None:
            pulumi.set(__self__, "time_last_wallet_rotated", time_last_wallet_rotated)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The compute model for the OPSI warehouse ADW (OCPU or ECPU)
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_model", value)

    @property
    @pulumi.getter(name="cpuAllocated")
    def cpu_allocated(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        (Updatable) Number of CPUs allocated to OPSI Warehouse ADW.
        """
        return pulumi.get(self, "cpu_allocated")

    @cpu_allocated.setter
    def cpu_allocated(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "cpu_allocated", value)

    @property
    @pulumi.getter(name="cpuUsed")
    def cpu_used(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Number of OCPUs used by OPSI Warehouse ADW. Can be fractional.
        """
        return pulumi.get(self, "cpu_used")

    @cpu_used.setter
    def cpu_used(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "cpu_used", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-friedly name of Ops Insights Warehouse that does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dynamicGroupId")
    def dynamic_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the dynamic group created for the warehouse
        """
        return pulumi.get(self, "dynamic_group_id")

    @dynamic_group_id.setter
    def dynamic_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dynamic_group_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="operationsInsightsTenancyId")
    def operations_insights_tenancy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tenancy Identifier of Ops Insights service
        """
        return pulumi.get(self, "operations_insights_tenancy_id")

    @operations_insights_tenancy_id.setter
    def operations_insights_tenancy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operations_insights_tenancy_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible lifecycle states
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageAllocatedInGbs")
    def storage_allocated_in_gbs(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        (Updatable) Storage allocated to OPSI Warehouse ADW. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "storage_allocated_in_gbs")

    @storage_allocated_in_gbs.setter
    def storage_allocated_in_gbs(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "storage_allocated_in_gbs", value)

    @property
    @pulumi.getter(name="storageUsedInGbs")
    def storage_used_in_gbs(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Storage by OPSI Warehouse ADW in GB.
        """
        return pulumi.get(self, "storage_used_in_gbs")

    @storage_used_in_gbs.setter
    def storage_used_in_gbs(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "storage_used_in_gbs", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastWalletRotated")
    def time_last_wallet_rotated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the ADW wallet was last rotated for the Ops Insights Warehouse. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_wallet_rotated")

    @time_last_wallet_rotated.setter
    def time_last_wallet_rotated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_last_wallet_rotated", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class OperationsInsightsWarehouse(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_model: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_allocated: Optional[pulumi.Input[builtins.float]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 storage_allocated_in_gbs: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        """
        This resource provides the Operations Insights Warehouse resource in Oracle Cloud Infrastructure Opsi service.

        Create a Ops Insights Warehouse resource for the tenant in Ops Insights. New ADW will be provisioned for this tenant.
        There is only expected to be 1 warehouse per tenant. The warehouse is expected to be in the root compartment. If the 'opsi-warehouse-type'
        header is passed to the API, a warehouse resource without ADW or Schema provisioning is created.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_operations_insights_warehouse = oci.opsi.OperationsInsightsWarehouse("test_operations_insights_warehouse",
            compartment_id=compartment_id,
            cpu_allocated=operations_insights_warehouse_cpu_allocated,
            display_name=operations_insights_warehouse_display_name,
            compute_model=operations_insights_warehouse_compute_model,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            storage_allocated_in_gbs=operations_insights_warehouse_storage_allocated_in_gbs)
        ```

        ## Import

        OperationsInsightsWarehouses can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/operationsInsightsWarehouse:OperationsInsightsWarehouse test_operations_insights_warehouse "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] compute_model: (Updatable) The compute model for the OPSI warehouse ADW (OCPU or ECPU)
        :param pulumi.Input[builtins.float] cpu_allocated: (Updatable) Number of CPUs allocated to OPSI Warehouse ADW.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friedly name of Ops Insights Warehouse that does not have to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.float] storage_allocated_in_gbs: (Updatable) Storage allocated to OPSI Warehouse ADW. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OperationsInsightsWarehouseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Operations Insights Warehouse resource in Oracle Cloud Infrastructure Opsi service.

        Create a Ops Insights Warehouse resource for the tenant in Ops Insights. New ADW will be provisioned for this tenant.
        There is only expected to be 1 warehouse per tenant. The warehouse is expected to be in the root compartment. If the 'opsi-warehouse-type'
        header is passed to the API, a warehouse resource without ADW or Schema provisioning is created.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_operations_insights_warehouse = oci.opsi.OperationsInsightsWarehouse("test_operations_insights_warehouse",
            compartment_id=compartment_id,
            cpu_allocated=operations_insights_warehouse_cpu_allocated,
            display_name=operations_insights_warehouse_display_name,
            compute_model=operations_insights_warehouse_compute_model,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            storage_allocated_in_gbs=operations_insights_warehouse_storage_allocated_in_gbs)
        ```

        ## Import

        OperationsInsightsWarehouses can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Opsi/operationsInsightsWarehouse:OperationsInsightsWarehouse test_operations_insights_warehouse "id"
        ```

        :param str resource_name: The name of the resource.
        :param OperationsInsightsWarehouseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OperationsInsightsWarehouseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_model: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_allocated: Optional[pulumi.Input[builtins.float]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 storage_allocated_in_gbs: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OperationsInsightsWarehouseArgs.__new__(OperationsInsightsWarehouseArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_model"] = compute_model
            if cpu_allocated is None and not opts.urn:
                raise TypeError("Missing required property 'cpu_allocated'")
            __props__.__dict__["cpu_allocated"] = cpu_allocated
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["storage_allocated_in_gbs"] = storage_allocated_in_gbs
            __props__.__dict__["cpu_used"] = None
            __props__.__dict__["dynamic_group_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["operations_insights_tenancy_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["storage_used_in_gbs"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_wallet_rotated"] = None
            __props__.__dict__["time_updated"] = None
        super(OperationsInsightsWarehouse, __self__).__init__(
            'oci:Opsi/operationsInsightsWarehouse:OperationsInsightsWarehouse',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            compute_model: Optional[pulumi.Input[builtins.str]] = None,
            cpu_allocated: Optional[pulumi.Input[builtins.float]] = None,
            cpu_used: Optional[pulumi.Input[builtins.float]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            dynamic_group_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            operations_insights_tenancy_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            storage_allocated_in_gbs: Optional[pulumi.Input[builtins.float]] = None,
            storage_used_in_gbs: Optional[pulumi.Input[builtins.float]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_last_wallet_rotated: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'OperationsInsightsWarehouse':
        """
        Get an existing OperationsInsightsWarehouse resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] compute_model: (Updatable) The compute model for the OPSI warehouse ADW (OCPU or ECPU)
        :param pulumi.Input[builtins.float] cpu_allocated: (Updatable) Number of CPUs allocated to OPSI Warehouse ADW.
        :param pulumi.Input[builtins.float] cpu_used: Number of OCPUs used by OPSI Warehouse ADW. Can be fractional.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) User-friedly name of Ops Insights Warehouse that does not have to be unique.
        :param pulumi.Input[builtins.str] dynamic_group_id: OCID of the dynamic group created for the warehouse
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[builtins.str] operations_insights_tenancy_id: Tenancy Identifier of Ops Insights service
        :param pulumi.Input[builtins.str] state: Possible lifecycle states
        :param pulumi.Input[builtins.float] storage_allocated_in_gbs: (Updatable) Storage allocated to OPSI Warehouse ADW. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.float] storage_used_in_gbs: Storage by OPSI Warehouse ADW in GB.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time at which the resource was first created. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_last_wallet_rotated: The time at which the ADW wallet was last rotated for the Ops Insights Warehouse. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OperationsInsightsWarehouseState.__new__(_OperationsInsightsWarehouseState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["cpu_allocated"] = cpu_allocated
        __props__.__dict__["cpu_used"] = cpu_used
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dynamic_group_id"] = dynamic_group_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["operations_insights_tenancy_id"] = operations_insights_tenancy_id
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_allocated_in_gbs"] = storage_allocated_in_gbs
        __props__.__dict__["storage_used_in_gbs"] = storage_used_in_gbs
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_wallet_rotated"] = time_last_wallet_rotated
        __props__.__dict__["time_updated"] = time_updated
        return OperationsInsightsWarehouse(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The compute model for the OPSI warehouse ADW (OCPU or ECPU)
        """
        return pulumi.get(self, "compute_model")

    @property
    @pulumi.getter(name="cpuAllocated")
    def cpu_allocated(self) -> pulumi.Output[builtins.float]:
        """
        (Updatable) Number of CPUs allocated to OPSI Warehouse ADW.
        """
        return pulumi.get(self, "cpu_allocated")

    @property
    @pulumi.getter(name="cpuUsed")
    def cpu_used(self) -> pulumi.Output[builtins.float]:
        """
        Number of OCPUs used by OPSI Warehouse ADW. Can be fractional.
        """
        return pulumi.get(self, "cpu_used")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) User-friedly name of Ops Insights Warehouse that does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dynamicGroupId")
    def dynamic_group_id(self) -> pulumi.Output[builtins.str]:
        """
        OCID of the dynamic group created for the warehouse
        """
        return pulumi.get(self, "dynamic_group_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="operationsInsightsTenancyId")
    def operations_insights_tenancy_id(self) -> pulumi.Output[builtins.str]:
        """
        Tenancy Identifier of Ops Insights service
        """
        return pulumi.get(self, "operations_insights_tenancy_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Possible lifecycle states
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageAllocatedInGbs")
    def storage_allocated_in_gbs(self) -> pulumi.Output[builtins.float]:
        """
        (Updatable) Storage allocated to OPSI Warehouse ADW. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "storage_allocated_in_gbs")

    @property
    @pulumi.getter(name="storageUsedInGbs")
    def storage_used_in_gbs(self) -> pulumi.Output[builtins.float]:
        """
        Storage by OPSI Warehouse ADW in GB.
        """
        return pulumi.get(self, "storage_used_in_gbs")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the resource was first created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastWalletRotated")
    def time_last_wallet_rotated(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the ADW wallet was last rotated for the Ops Insights Warehouse. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_last_wallet_rotated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time at which the resource was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

