# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceGroupInstallPackagesManagementArgs', 'ManagedInstanceGroupInstallPackagesManagement']

@pulumi.input_type
class ManagedInstanceGroupInstallPackagesManagementArgs:
    def __init__(__self__, *,
                 managed_instance_group_id: pulumi.Input[builtins.str],
                 package_names: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 is_latest: Optional[pulumi.Input[builtins.bool]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a ManagedInstanceGroupInstallPackagesManagement resource.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] package_names: The list of package names.
        :param pulumi.Input[builtins.bool] is_latest: Indicates whether this is the latest package version.
        :param pulumi.Input['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        pulumi.set(__self__, "package_names", package_names)
        if is_latest is not None:
            pulumi.set(__self__, "is_latest", is_latest)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="packageNames")
    def package_names(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The list of package names.
        """
        return pulumi.get(self, "package_names")

    @package_names.setter
    def package_names(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "package_names", value)

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether this is the latest package version.
        """
        return pulumi.get(self, "is_latest")

    @is_latest.setter
    def is_latest(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_latest", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _ManagedInstanceGroupInstallPackagesManagementState:
    def __init__(__self__, *,
                 is_latest: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 package_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs']] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceGroupInstallPackagesManagement resources.
        :param pulumi.Input[builtins.bool] is_latest: Indicates whether this is the latest package version.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] package_names: The list of package names.
        :param pulumi.Input['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        if is_latest is not None:
            pulumi.set(__self__, "is_latest", is_latest)
        if managed_instance_group_id is not None:
            pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if package_names is not None:
            pulumi.set(__self__, "package_names", package_names)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether this is the latest package version.
        """
        return pulumi.get(self, "is_latest")

    @is_latest.setter
    def is_latest(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_latest", value)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="packageNames")
    def package_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of package names.
        """
        return pulumi.get(self, "package_names")

    @package_names.setter
    def package_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "package_names", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


class ManagedInstanceGroupInstallPackagesManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_latest: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 package_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Group Install Packages Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Installs the specified packages on each managed instance in a managed instance group. The package must be compatible with the instances in the group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_install_packages_management = oci.os_management_hub.ManagedInstanceGroupInstallPackagesManagement("test_managed_instance_group_install_packages_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            package_names=managed_instance_group_install_packages_management_package_names,
            is_latest=managed_instance_group_install_packages_management_is_latest,
            work_request_details={
                "description": managed_instance_group_install_packages_management_work_request_details_description,
                "display_name": managed_instance_group_install_packages_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupInstallPackagesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupInstallPackagesManagement:ManagedInstanceGroupInstallPackagesManagement test_managed_instance_group_install_packages_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_latest: Indicates whether this is the latest package version.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] package_names: The list of package names.
        :param pulumi.Input[Union['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceGroupInstallPackagesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Group Install Packages Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Installs the specified packages on each managed instance in a managed instance group. The package must be compatible with the instances in the group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_install_packages_management = oci.os_management_hub.ManagedInstanceGroupInstallPackagesManagement("test_managed_instance_group_install_packages_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            package_names=managed_instance_group_install_packages_management_package_names,
            is_latest=managed_instance_group_install_packages_management_is_latest,
            work_request_details={
                "description": managed_instance_group_install_packages_management_work_request_details_description,
                "display_name": managed_instance_group_install_packages_management_work_request_details_display_name,
            })
        ```

        ## Import

        ManagedInstanceGroupInstallPackagesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupInstallPackagesManagement:ManagedInstanceGroupInstallPackagesManagement test_managed_instance_group_install_packages_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceGroupInstallPackagesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceGroupInstallPackagesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_latest: Optional[pulumi.Input[builtins.bool]] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 package_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceGroupInstallPackagesManagementArgs.__new__(ManagedInstanceGroupInstallPackagesManagementArgs)

            __props__.__dict__["is_latest"] = is_latest
            if managed_instance_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_group_id'")
            __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
            if package_names is None and not opts.urn:
                raise TypeError("Missing required property 'package_names'")
            __props__.__dict__["package_names"] = package_names
            __props__.__dict__["work_request_details"] = work_request_details
        super(ManagedInstanceGroupInstallPackagesManagement, __self__).__init__(
            'oci:OsManagementHub/managedInstanceGroupInstallPackagesManagement:ManagedInstanceGroupInstallPackagesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_latest: Optional[pulumi.Input[builtins.bool]] = None,
            managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
            package_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            work_request_details: Optional[pulumi.Input[Union['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgsDict']]] = None) -> 'ManagedInstanceGroupInstallPackagesManagement':
        """
        Get an existing ManagedInstanceGroupInstallPackagesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_latest: Indicates whether this is the latest package version.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] package_names: The list of package names.
        :param pulumi.Input[Union['ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgs', 'ManagedInstanceGroupInstallPackagesManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceGroupInstallPackagesManagementState.__new__(_ManagedInstanceGroupInstallPackagesManagementState)

        __props__.__dict__["is_latest"] = is_latest
        __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
        __props__.__dict__["package_names"] = package_names
        __props__.__dict__["work_request_details"] = work_request_details
        return ManagedInstanceGroupInstallPackagesManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether this is the latest package version.
        """
        return pulumi.get(self, "is_latest")

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="packageNames")
    def package_names(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of package names.
        """
        return pulumi.get(self, "package_names")

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.ManagedInstanceGroupInstallPackagesManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

