# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMonitoredResourceTypeResult',
    'AwaitableGetMonitoredResourceTypeResult',
    'get_monitored_resource_type',
    'get_monitored_resource_type_output',
]

@pulumi.output_type
class GetMonitoredResourceTypeResult:
    """
    A collection of values returned by getMonitoredResourceType.
    """
    def __init__(__self__, additional_namespace_map=None, availability_metrics_configs=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, handler_configs=None, id=None, is_system_defined=None, metadatas=None, metric_namespace=None, monitored_resource_type_id=None, name=None, resource_category=None, source_type=None, state=None, system_tags=None, tenancy_id=None, time_created=None, time_updated=None):
        if additional_namespace_map and not isinstance(additional_namespace_map, dict):
            raise TypeError("Expected argument 'additional_namespace_map' to be a dict")
        pulumi.set(__self__, "additional_namespace_map", additional_namespace_map)
        if availability_metrics_configs and not isinstance(availability_metrics_configs, list):
            raise TypeError("Expected argument 'availability_metrics_configs' to be a list")
        pulumi.set(__self__, "availability_metrics_configs", availability_metrics_configs)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if handler_configs and not isinstance(handler_configs, list):
            raise TypeError("Expected argument 'handler_configs' to be a list")
        pulumi.set(__self__, "handler_configs", handler_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_system_defined and not isinstance(is_system_defined, bool):
            raise TypeError("Expected argument 'is_system_defined' to be a bool")
        pulumi.set(__self__, "is_system_defined", is_system_defined)
        if metadatas and not isinstance(metadatas, list):
            raise TypeError("Expected argument 'metadatas' to be a list")
        pulumi.set(__self__, "metadatas", metadatas)
        if metric_namespace and not isinstance(metric_namespace, str):
            raise TypeError("Expected argument 'metric_namespace' to be a str")
        pulumi.set(__self__, "metric_namespace", metric_namespace)
        if monitored_resource_type_id and not isinstance(monitored_resource_type_id, str):
            raise TypeError("Expected argument 'monitored_resource_type_id' to be a str")
        pulumi.set(__self__, "monitored_resource_type_id", monitored_resource_type_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_category and not isinstance(resource_category, str):
            raise TypeError("Expected argument 'resource_category' to be a str")
        pulumi.set(__self__, "resource_category", resource_category)
        if source_type and not isinstance(source_type, str):
            raise TypeError("Expected argument 'source_type' to be a str")
        pulumi.set(__self__, "source_type", source_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="additionalNamespaceMap")
    def additional_namespace_map(self) -> Mapping[str, builtins.str]:
        """
        Key/Value pair for additional namespaces used by stack monitoring services for SYSTEM (SMB) resource types.
        """
        return pulumi.get(self, "additional_namespace_map")

    @property
    @pulumi.getter(name="availabilityMetricsConfigs")
    def availability_metrics_configs(self) -> Sequence['outputs.GetMonitoredResourceTypeAvailabilityMetricsConfigResult']:
        """
        Availability metrics details.
        """
        return pulumi.get(self, "availability_metrics_configs")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        A friendly description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Monitored resource type display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="handlerConfigs")
    def handler_configs(self) -> Sequence['outputs.GetMonitoredResourceTypeHandlerConfigResult']:
        """
        Specific resource mapping configurations for Agent Extension Handlers.
        """
        return pulumi.get(self, "handler_configs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Monitored resource type identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSystemDefined")
    def is_system_defined(self) -> builtins.bool:
        """
        If boolean flag is true, then the resource type cannot be modified or deleted.
        """
        return pulumi.get(self, "is_system_defined")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetMonitoredResourceTypeMetadataResult']:
        """
        The metadata details for resource type.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="metricNamespace")
    def metric_namespace(self) -> builtins.str:
        """
        Metric namespace for resource type.
        """
        return pulumi.get(self, "metric_namespace")

    @property
    @pulumi.getter(name="monitoredResourceTypeId")
    def monitored_resource_type_id(self) -> builtins.str:
        return pulumi.get(self, "monitored_resource_type_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        A unique monitored resource type name. The name must be unique across tenancy.  Name can not be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> builtins.str:
        """
        Resource Category to indicate the kind of resource type.
        """
        return pulumi.get(self, "resource_category")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Lifecycle state of the monitored resource type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> builtins.str:
        """
        Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time when the monitored resource type was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time when the monitored resource was updated, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMonitoredResourceTypeResult(GetMonitoredResourceTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMonitoredResourceTypeResult(
            additional_namespace_map=self.additional_namespace_map,
            availability_metrics_configs=self.availability_metrics_configs,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            handler_configs=self.handler_configs,
            id=self.id,
            is_system_defined=self.is_system_defined,
            metadatas=self.metadatas,
            metric_namespace=self.metric_namespace,
            monitored_resource_type_id=self.monitored_resource_type_id,
            name=self.name,
            resource_category=self.resource_category,
            source_type=self.source_type,
            state=self.state,
            system_tags=self.system_tags,
            tenancy_id=self.tenancy_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_monitored_resource_type(monitored_resource_type_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMonitoredResourceTypeResult:
    """
    This data source provides details about a specific Monitored Resource Type resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets a monitored resource type by identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_resource_type = oci.StackMonitoring.get_monitored_resource_type(monitored_resource_type_id=test_monitored_resource_type_oci_stack_monitoring_monitored_resource_type["id"])
    ```


    :param builtins.str monitored_resource_type_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored resource type.
    """
    __args__ = dict()
    __args__['monitoredResourceTypeId'] = monitored_resource_type_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:StackMonitoring/getMonitoredResourceType:getMonitoredResourceType', __args__, opts=opts, typ=GetMonitoredResourceTypeResult).value

    return AwaitableGetMonitoredResourceTypeResult(
        additional_namespace_map=pulumi.get(__ret__, 'additional_namespace_map'),
        availability_metrics_configs=pulumi.get(__ret__, 'availability_metrics_configs'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        handler_configs=pulumi.get(__ret__, 'handler_configs'),
        id=pulumi.get(__ret__, 'id'),
        is_system_defined=pulumi.get(__ret__, 'is_system_defined'),
        metadatas=pulumi.get(__ret__, 'metadatas'),
        metric_namespace=pulumi.get(__ret__, 'metric_namespace'),
        monitored_resource_type_id=pulumi.get(__ret__, 'monitored_resource_type_id'),
        name=pulumi.get(__ret__, 'name'),
        resource_category=pulumi.get(__ret__, 'resource_category'),
        source_type=pulumi.get(__ret__, 'source_type'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_monitored_resource_type_output(monitored_resource_type_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMonitoredResourceTypeResult]:
    """
    This data source provides details about a specific Monitored Resource Type resource in Oracle Cloud Infrastructure Stack Monitoring service.

    Gets a monitored resource type by identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_monitored_resource_type = oci.StackMonitoring.get_monitored_resource_type(monitored_resource_type_id=test_monitored_resource_type_oci_stack_monitoring_monitored_resource_type["id"])
    ```


    :param builtins.str monitored_resource_type_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of monitored resource type.
    """
    __args__ = dict()
    __args__['monitoredResourceTypeId'] = monitored_resource_type_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:StackMonitoring/getMonitoredResourceType:getMonitoredResourceType', __args__, opts=opts, typ=GetMonitoredResourceTypeResult)
    return __ret__.apply(lambda __response__: GetMonitoredResourceTypeResult(
        additional_namespace_map=pulumi.get(__response__, 'additional_namespace_map'),
        availability_metrics_configs=pulumi.get(__response__, 'availability_metrics_configs'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        handler_configs=pulumi.get(__response__, 'handler_configs'),
        id=pulumi.get(__response__, 'id'),
        is_system_defined=pulumi.get(__response__, 'is_system_defined'),
        metadatas=pulumi.get(__response__, 'metadatas'),
        metric_namespace=pulumi.get(__response__, 'metric_namespace'),
        monitored_resource_type_id=pulumi.get(__response__, 'monitored_resource_type_id'),
        name=pulumi.get(__response__, 'name'),
        resource_category=pulumi.get(__response__, 'resource_category'),
        source_type=pulumi.get(__response__, 'source_type'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
