# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSenderInvitationsResult',
    'AwaitableGetSenderInvitationsResult',
    'get_sender_invitations',
    'get_sender_invitations_output',
]

@pulumi.output_type
class GetSenderInvitationsResult:
    """
    A collection of values returned by getSenderInvitations.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, recipient_tenancy_id=None, sender_invitation_collections=None, state=None, status=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if recipient_tenancy_id and not isinstance(recipient_tenancy_id, str):
            raise TypeError("Expected argument 'recipient_tenancy_id' to be a str")
        pulumi.set(__self__, "recipient_tenancy_id", recipient_tenancy_id)
        if sender_invitation_collections and not isinstance(sender_invitation_collections, list):
            raise TypeError("Expected argument 'sender_invitation_collections' to be a list")
        pulumi.set(__self__, "sender_invitation_collections", sender_invitation_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        OCID of the sender tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-created name to describe the invitation. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSenderInvitationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="recipientTenancyId")
    def recipient_tenancy_id(self) -> Optional[builtins.str]:
        """
        OCID of the recipient tenancy.
        """
        return pulumi.get(self, "recipient_tenancy_id")

    @property
    @pulumi.getter(name="senderInvitationCollections")
    def sender_invitation_collections(self) -> Sequence['outputs.GetSenderInvitationsSenderInvitationCollectionResult']:
        """
        The list of sender_invitation_collection.
        """
        return pulumi.get(self, "sender_invitation_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Lifecycle state of the sender invitation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of the sender invitation.
        """
        return pulumi.get(self, "status")


class AwaitableGetSenderInvitationsResult(GetSenderInvitationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSenderInvitationsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            recipient_tenancy_id=self.recipient_tenancy_id,
            sender_invitation_collections=self.sender_invitation_collections,
            state=self.state,
            status=self.status)


def get_sender_invitations(compartment_id: Optional[builtins.str] = None,
                           display_name: Optional[builtins.str] = None,
                           filters: Optional[Sequence[Union['GetSenderInvitationsFilterArgs', 'GetSenderInvitationsFilterArgsDict']]] = None,
                           recipient_tenancy_id: Optional[builtins.str] = None,
                           state: Optional[builtins.str] = None,
                           status: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSenderInvitationsResult:
    """
    This data source provides the list of Sender Invitations in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Return a (paginated) list of sender invitations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sender_invitations = oci.Tenantmanagercontrolplane.get_sender_invitations(compartment_id=compartment_id,
        display_name=sender_invitation_display_name,
        recipient_tenancy_id=test_tenancy["id"],
        state=sender_invitation_state,
        status=sender_invitation_status)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str recipient_tenancy_id: The tenancy that the invitation is addressed to.
    :param builtins.str state: The lifecycle state of the resource.
    :param builtins.str status: The status of the sender invitation.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['recipientTenancyId'] = recipient_tenancy_id
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getSenderInvitations:getSenderInvitations', __args__, opts=opts, typ=GetSenderInvitationsResult).value

    return AwaitableGetSenderInvitationsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        recipient_tenancy_id=pulumi.get(__ret__, 'recipient_tenancy_id'),
        sender_invitation_collections=pulumi.get(__ret__, 'sender_invitation_collections'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'))
def get_sender_invitations_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                  display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSenderInvitationsFilterArgs', 'GetSenderInvitationsFilterArgsDict']]]]] = None,
                                  recipient_tenancy_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  status: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSenderInvitationsResult]:
    """
    This data source provides the list of Sender Invitations in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Return a (paginated) list of sender invitations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sender_invitations = oci.Tenantmanagercontrolplane.get_sender_invitations(compartment_id=compartment_id,
        display_name=sender_invitation_display_name,
        recipient_tenancy_id=test_tenancy["id"],
        state=sender_invitation_state,
        status=sender_invitation_status)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str recipient_tenancy_id: The tenancy that the invitation is addressed to.
    :param builtins.str state: The lifecycle state of the resource.
    :param builtins.str status: The status of the sender invitation.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['recipientTenancyId'] = recipient_tenancy_id
    __args__['state'] = state
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getSenderInvitations:getSenderInvitations', __args__, opts=opts, typ=GetSenderInvitationsResult)
    return __ret__.apply(lambda __response__: GetSenderInvitationsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        recipient_tenancy_id=pulumi.get(__response__, 'recipient_tenancy_id'),
        sender_invitation_collections=pulumi.get(__response__, 'sender_invitation_collections'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status')))
