# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VbInstanceArgs', 'VbInstance']

@pulumi.input_type
class VbInstanceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 node_count: pulumi.Input[builtins.int],
                 alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['VbInstanceAlternateCustomEndpointArgs']]]] = None,
                 consumption_model: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input['VbInstanceCustomEndpointArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_open_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_endpoint_details: Optional[pulumi.Input['VbInstanceNetworkEndpointDetailsArgs']] = None):
        """
        The set of arguments for constructing a VbInstance resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Vb Instance Identifier.
        :param pulumi.Input[builtins.int] node_count: (Updatable) The number of Nodes
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['VbInstanceAlternateCustomEndpointArgs']]] alternate_custom_endpoints: (Updatable) A list of alternate custom endpoints to be used for the vb instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        :param pulumi.Input[builtins.str] consumption_model: Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        :param pulumi.Input['VbInstanceCustomEndpointArgs'] custom_endpoint: (Updatable) Details for a custom endpoint for the vb instance (update).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] idcs_open_id: (Updatable) Encrypted IDCS Open ID token. This is required for pre-UCPIS cloud accounts, but not UCPIS, hence not a required parameter
        :param pulumi.Input[builtins.bool] is_visual_builder_enabled: (Updatable) Visual Builder is enabled or not.
        :param pulumi.Input['VbInstanceNetworkEndpointDetailsArgs'] network_endpoint_details: (Updatable) Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "node_count", node_count)
        if alternate_custom_endpoints is not None:
            pulumi.set(__self__, "alternate_custom_endpoints", alternate_custom_endpoints)
        if consumption_model is not None:
            pulumi.set(__self__, "consumption_model", consumption_model)
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idcs_open_id is not None:
            pulumi.set(__self__, "idcs_open_id", idcs_open_id)
        if is_visual_builder_enabled is not None:
            pulumi.set(__self__, "is_visual_builder_enabled", is_visual_builder_enabled)
        if network_endpoint_details is not None:
            pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Vb Instance Identifier.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) The number of Nodes


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VbInstanceAlternateCustomEndpointArgs']]]]:
        """
        (Updatable) A list of alternate custom endpoints to be used for the vb instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @alternate_custom_endpoints.setter
    def alternate_custom_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VbInstanceAlternateCustomEndpointArgs']]]]):
        pulumi.set(self, "alternate_custom_endpoints", value)

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        """
        return pulumi.get(self, "consumption_model")

    @consumption_model.setter
    def consumption_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumption_model", value)

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input['VbInstanceCustomEndpointArgs']]:
        """
        (Updatable) Details for a custom endpoint for the vb instance (update).
        """
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input['VbInstanceCustomEndpointArgs']]):
        pulumi.set(self, "custom_endpoint", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="idcsOpenId")
    def idcs_open_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Encrypted IDCS Open ID token. This is required for pre-UCPIS cloud accounts, but not UCPIS, hence not a required parameter
        """
        return pulumi.get(self, "idcs_open_id")

    @idcs_open_id.setter
    def idcs_open_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_open_id", value)

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @is_visual_builder_enabled.setter
    def is_visual_builder_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_visual_builder_enabled", value)

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Optional[pulumi.Input['VbInstanceNetworkEndpointDetailsArgs']]:
        """
        (Updatable) Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        """
        return pulumi.get(self, "network_endpoint_details")

    @network_endpoint_details.setter
    def network_endpoint_details(self, value: Optional[pulumi.Input['VbInstanceNetworkEndpointDetailsArgs']]):
        pulumi.set(self, "network_endpoint_details", value)


@pulumi.input_type
class _VbInstanceState:
    def __init__(__self__, *,
                 alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['VbInstanceAlternateCustomEndpointArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 consumption_model: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input['VbInstanceCustomEndpointArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_open_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_url: Optional[pulumi.Input[builtins.str]] = None,
                 is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 management_nat_gateway_ip: Optional[pulumi.Input[builtins.str]] = None,
                 management_vcn_id: Optional[pulumi.Input[builtins.str]] = None,
                 network_endpoint_details: Optional[pulumi.Input['VbInstanceNetworkEndpointDetailsArgs']] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 service_nat_gateway_ip: Optional[pulumi.Input[builtins.str]] = None,
                 service_vcn_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_message: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VbInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input['VbInstanceAlternateCustomEndpointArgs']]] alternate_custom_endpoints: (Updatable) A list of alternate custom endpoints to be used for the vb instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[builtins.str] consumption_model: Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        :param pulumi.Input['VbInstanceCustomEndpointArgs'] custom_endpoint: (Updatable) Details for a custom endpoint for the vb instance (update).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Vb Instance Identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] idcs_open_id: (Updatable) Encrypted IDCS Open ID token. This is required for pre-UCPIS cloud accounts, but not UCPIS, hence not a required parameter
        :param pulumi.Input[builtins.str] instance_url: The Vb Instance URL.
        :param pulumi.Input[builtins.bool] is_visual_builder_enabled: (Updatable) Visual Builder is enabled or not.
        :param pulumi.Input[builtins.str] management_nat_gateway_ip: The NAT gateway IP address for the VB management VCN
        :param pulumi.Input[builtins.str] management_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        :param pulumi.Input['VbInstanceNetworkEndpointDetailsArgs'] network_endpoint_details: (Updatable) Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        :param pulumi.Input[builtins.int] node_count: (Updatable) The number of Nodes
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] service_nat_gateway_ip: The NAT gateway IP address for the VB service VCN
        :param pulumi.Input[builtins.str] service_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        :param pulumi.Input[builtins.str] state: The current state of the vb instance.
        :param pulumi.Input[builtins.str] state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the the VbInstance was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        if alternate_custom_endpoints is not None:
            pulumi.set(__self__, "alternate_custom_endpoints", alternate_custom_endpoints)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if consumption_model is not None:
            pulumi.set(__self__, "consumption_model", consumption_model)
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if idcs_open_id is not None:
            pulumi.set(__self__, "idcs_open_id", idcs_open_id)
        if instance_url is not None:
            pulumi.set(__self__, "instance_url", instance_url)
        if is_visual_builder_enabled is not None:
            pulumi.set(__self__, "is_visual_builder_enabled", is_visual_builder_enabled)
        if management_nat_gateway_ip is not None:
            pulumi.set(__self__, "management_nat_gateway_ip", management_nat_gateway_ip)
        if management_vcn_id is not None:
            pulumi.set(__self__, "management_vcn_id", management_vcn_id)
        if network_endpoint_details is not None:
            pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if service_nat_gateway_ip is not None:
            pulumi.set(__self__, "service_nat_gateway_ip", service_nat_gateway_ip)
        if service_vcn_id is not None:
            pulumi.set(__self__, "service_vcn_id", service_vcn_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VbInstanceAlternateCustomEndpointArgs']]]]:
        """
        (Updatable) A list of alternate custom endpoints to be used for the vb instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @alternate_custom_endpoints.setter
    def alternate_custom_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VbInstanceAlternateCustomEndpointArgs']]]]):
        pulumi.set(self, "alternate_custom_endpoints", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        """
        return pulumi.get(self, "consumption_model")

    @consumption_model.setter
    def consumption_model(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "consumption_model", value)

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional[pulumi.Input['VbInstanceCustomEndpointArgs']]:
        """
        (Updatable) Details for a custom endpoint for the vb instance (update).
        """
        return pulumi.get(self, "custom_endpoint")

    @custom_endpoint.setter
    def custom_endpoint(self, value: Optional[pulumi.Input['VbInstanceCustomEndpointArgs']]):
        pulumi.set(self, "custom_endpoint", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Vb Instance Identifier.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="idcsOpenId")
    def idcs_open_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Encrypted IDCS Open ID token. This is required for pre-UCPIS cloud accounts, but not UCPIS, hence not a required parameter
        """
        return pulumi.get(self, "idcs_open_id")

    @idcs_open_id.setter
    def idcs_open_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_open_id", value)

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Vb Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @instance_url.setter
    def instance_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_url", value)

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @is_visual_builder_enabled.setter
    def is_visual_builder_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_visual_builder_enabled", value)

    @property
    @pulumi.getter(name="managementNatGatewayIp")
    def management_nat_gateway_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The NAT gateway IP address for the VB management VCN
        """
        return pulumi.get(self, "management_nat_gateway_ip")

    @management_nat_gateway_ip.setter
    def management_nat_gateway_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "management_nat_gateway_ip", value)

    @property
    @pulumi.getter(name="managementVcnId")
    def management_vcn_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        """
        return pulumi.get(self, "management_vcn_id")

    @management_vcn_id.setter
    def management_vcn_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "management_vcn_id", value)

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Optional[pulumi.Input['VbInstanceNetworkEndpointDetailsArgs']]:
        """
        (Updatable) Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        """
        return pulumi.get(self, "network_endpoint_details")

    @network_endpoint_details.setter
    def network_endpoint_details(self, value: Optional[pulumi.Input['VbInstanceNetworkEndpointDetailsArgs']]):
        pulumi.set(self, "network_endpoint_details", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The number of Nodes


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="serviceNatGatewayIp")
    def service_nat_gateway_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The NAT gateway IP address for the VB service VCN
        """
        return pulumi.get(self, "service_nat_gateway_ip")

    @service_nat_gateway_ip.setter
    def service_nat_gateway_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_nat_gateway_ip", value)

    @property
    @pulumi.getter(name="serviceVcnId")
    def service_vcn_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        """
        return pulumi.get(self, "service_vcn_id")

    @service_vcn_id.setter
    def service_vcn_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_vcn_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the vb instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the the VbInstance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class VbInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VbInstanceAlternateCustomEndpointArgs', 'VbInstanceAlternateCustomEndpointArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 consumption_model: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input[Union['VbInstanceCustomEndpointArgs', 'VbInstanceCustomEndpointArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_open_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_endpoint_details: Optional[pulumi.Input[Union['VbInstanceNetworkEndpointDetailsArgs', 'VbInstanceNetworkEndpointDetailsArgsDict']]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Vb Instance resource in Oracle Cloud Infrastructure Visual Builder service.

        Creates a new Vb Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vb_instance = oci.visual_builder.VbInstance("test_vb_instance",
            compartment_id=compartment_id,
            display_name=vb_instance_display_name,
            node_count=vb_instance_node_count,
            alternate_custom_endpoints=[{
                "hostname": vb_instance_alternate_custom_endpoints_hostname,
                "certificate_secret_id": test_secret["id"],
            }],
            consumption_model=vb_instance_consumption_model,
            custom_endpoint={
                "hostname": vb_instance_custom_endpoint_hostname,
                "certificate_secret_id": test_secret["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            idcs_open_id=test_idcs_open["id"],
            is_visual_builder_enabled=vb_instance_is_visual_builder_enabled,
            network_endpoint_details={
                "network_endpoint_type": vb_instance_network_endpoint_details_network_endpoint_type,
                "subnet_id": test_subnet["id"],
                "network_security_group_ids": vb_instance_network_endpoint_details_network_security_group_ids,
                "private_endpoint_ip": vb_instance_network_endpoint_details_private_endpoint_ip,
            })
        ```

        ## Import

        VbInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:VisualBuilder/vbInstance:VbInstance test_vb_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VbInstanceAlternateCustomEndpointArgs', 'VbInstanceAlternateCustomEndpointArgsDict']]]] alternate_custom_endpoints: (Updatable) A list of alternate custom endpoints to be used for the vb instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[builtins.str] consumption_model: Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        :param pulumi.Input[Union['VbInstanceCustomEndpointArgs', 'VbInstanceCustomEndpointArgsDict']] custom_endpoint: (Updatable) Details for a custom endpoint for the vb instance (update).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Vb Instance Identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] idcs_open_id: (Updatable) Encrypted IDCS Open ID token. This is required for pre-UCPIS cloud accounts, but not UCPIS, hence not a required parameter
        :param pulumi.Input[builtins.bool] is_visual_builder_enabled: (Updatable) Visual Builder is enabled or not.
        :param pulumi.Input[Union['VbInstanceNetworkEndpointDetailsArgs', 'VbInstanceNetworkEndpointDetailsArgsDict']] network_endpoint_details: (Updatable) Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        :param pulumi.Input[builtins.int] node_count: (Updatable) The number of Nodes
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VbInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Vb Instance resource in Oracle Cloud Infrastructure Visual Builder service.

        Creates a new Vb Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_vb_instance = oci.visual_builder.VbInstance("test_vb_instance",
            compartment_id=compartment_id,
            display_name=vb_instance_display_name,
            node_count=vb_instance_node_count,
            alternate_custom_endpoints=[{
                "hostname": vb_instance_alternate_custom_endpoints_hostname,
                "certificate_secret_id": test_secret["id"],
            }],
            consumption_model=vb_instance_consumption_model,
            custom_endpoint={
                "hostname": vb_instance_custom_endpoint_hostname,
                "certificate_secret_id": test_secret["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            idcs_open_id=test_idcs_open["id"],
            is_visual_builder_enabled=vb_instance_is_visual_builder_enabled,
            network_endpoint_details={
                "network_endpoint_type": vb_instance_network_endpoint_details_network_endpoint_type,
                "subnet_id": test_subnet["id"],
                "network_security_group_ids": vb_instance_network_endpoint_details_network_security_group_ids,
                "private_endpoint_ip": vb_instance_network_endpoint_details_private_endpoint_ip,
            })
        ```

        ## Import

        VbInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:VisualBuilder/vbInstance:VbInstance test_vb_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param VbInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VbInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VbInstanceAlternateCustomEndpointArgs', 'VbInstanceAlternateCustomEndpointArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 consumption_model: Optional[pulumi.Input[builtins.str]] = None,
                 custom_endpoint: Optional[pulumi.Input[Union['VbInstanceCustomEndpointArgs', 'VbInstanceCustomEndpointArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 idcs_open_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_endpoint_details: Optional[pulumi.Input[Union['VbInstanceNetworkEndpointDetailsArgs', 'VbInstanceNetworkEndpointDetailsArgsDict']]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VbInstanceArgs.__new__(VbInstanceArgs)

            __props__.__dict__["alternate_custom_endpoints"] = alternate_custom_endpoints
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["consumption_model"] = consumption_model
            __props__.__dict__["custom_endpoint"] = custom_endpoint
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["idcs_open_id"] = None if idcs_open_id is None else pulumi.Output.secret(idcs_open_id)
            __props__.__dict__["is_visual_builder_enabled"] = is_visual_builder_enabled
            __props__.__dict__["network_endpoint_details"] = network_endpoint_details
            if node_count is None and not opts.urn:
                raise TypeError("Missing required property 'node_count'")
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["instance_url"] = None
            __props__.__dict__["management_nat_gateway_ip"] = None
            __props__.__dict__["management_vcn_id"] = None
            __props__.__dict__["service_nat_gateway_ip"] = None
            __props__.__dict__["service_vcn_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["idcsOpenId"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(VbInstance, __self__).__init__(
            'oci:VisualBuilder/vbInstance:VbInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternate_custom_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VbInstanceAlternateCustomEndpointArgs', 'VbInstanceAlternateCustomEndpointArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            consumption_model: Optional[pulumi.Input[builtins.str]] = None,
            custom_endpoint: Optional[pulumi.Input[Union['VbInstanceCustomEndpointArgs', 'VbInstanceCustomEndpointArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            idcs_open_id: Optional[pulumi.Input[builtins.str]] = None,
            instance_url: Optional[pulumi.Input[builtins.str]] = None,
            is_visual_builder_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            management_nat_gateway_ip: Optional[pulumi.Input[builtins.str]] = None,
            management_vcn_id: Optional[pulumi.Input[builtins.str]] = None,
            network_endpoint_details: Optional[pulumi.Input[Union['VbInstanceNetworkEndpointDetailsArgs', 'VbInstanceNetworkEndpointDetailsArgsDict']]] = None,
            node_count: Optional[pulumi.Input[builtins.int]] = None,
            service_nat_gateway_ip: Optional[pulumi.Input[builtins.str]] = None,
            service_vcn_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_message: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'VbInstance':
        """
        Get an existing VbInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VbInstanceAlternateCustomEndpointArgs', 'VbInstanceAlternateCustomEndpointArgsDict']]]] alternate_custom_endpoints: (Updatable) A list of alternate custom endpoints to be used for the vb instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Compartment Identifier.
        :param pulumi.Input[builtins.str] consumption_model: Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        :param pulumi.Input[Union['VbInstanceCustomEndpointArgs', 'VbInstanceCustomEndpointArgsDict']] custom_endpoint: (Updatable) Details for a custom endpoint for the vb instance (update).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Vb Instance Identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] idcs_open_id: (Updatable) Encrypted IDCS Open ID token. This is required for pre-UCPIS cloud accounts, but not UCPIS, hence not a required parameter
        :param pulumi.Input[builtins.str] instance_url: The Vb Instance URL.
        :param pulumi.Input[builtins.bool] is_visual_builder_enabled: (Updatable) Visual Builder is enabled or not.
        :param pulumi.Input[builtins.str] management_nat_gateway_ip: The NAT gateway IP address for the VB management VCN
        :param pulumi.Input[builtins.str] management_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        :param pulumi.Input[Union['VbInstanceNetworkEndpointDetailsArgs', 'VbInstanceNetworkEndpointDetailsArgsDict']] network_endpoint_details: (Updatable) Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        :param pulumi.Input[builtins.int] node_count: (Updatable) The number of Nodes
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] service_nat_gateway_ip: The NAT gateway IP address for the VB service VCN
        :param pulumi.Input[builtins.str] service_vcn_id: The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        :param pulumi.Input[builtins.str] state: The current state of the vb instance.
        :param pulumi.Input[builtins.str] state_message: An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the the VbInstance was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VbInstanceState.__new__(_VbInstanceState)

        __props__.__dict__["alternate_custom_endpoints"] = alternate_custom_endpoints
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["consumption_model"] = consumption_model
        __props__.__dict__["custom_endpoint"] = custom_endpoint
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["idcs_open_id"] = idcs_open_id
        __props__.__dict__["instance_url"] = instance_url
        __props__.__dict__["is_visual_builder_enabled"] = is_visual_builder_enabled
        __props__.__dict__["management_nat_gateway_ip"] = management_nat_gateway_ip
        __props__.__dict__["management_vcn_id"] = management_vcn_id
        __props__.__dict__["network_endpoint_details"] = network_endpoint_details
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["service_nat_gateway_ip"] = service_nat_gateway_ip
        __props__.__dict__["service_vcn_id"] = service_vcn_id
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return VbInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alternateCustomEndpoints")
    def alternate_custom_endpoints(self) -> pulumi.Output[Sequence['outputs.VbInstanceAlternateCustomEndpoint']]:
        """
        (Updatable) A list of alternate custom endpoints to be used for the vb instance URL (contact Oracle for alternateCustomEndpoints availability for a specific instance).
        """
        return pulumi.get(self, "alternate_custom_endpoints")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Compartment Identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consumptionModel")
    def consumption_model(self) -> pulumi.Output[builtins.str]:
        """
        Optional parameter specifying which entitlement to use for billing purposes. Only required if the account possesses more than one entitlement.
        """
        return pulumi.get(self, "consumption_model")

    @property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> pulumi.Output['outputs.VbInstanceCustomEndpoint']:
        """
        (Updatable) Details for a custom endpoint for the vb instance (update).
        """
        return pulumi.get(self, "custom_endpoint")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Vb Instance Identifier.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="idcsOpenId")
    def idcs_open_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        (Updatable) Encrypted IDCS Open ID token. This is required for pre-UCPIS cloud accounts, but not UCPIS, hence not a required parameter
        """
        return pulumi.get(self, "idcs_open_id")

    @property
    @pulumi.getter(name="instanceUrl")
    def instance_url(self) -> pulumi.Output[builtins.str]:
        """
        The Vb Instance URL.
        """
        return pulumi.get(self, "instance_url")

    @property
    @pulumi.getter(name="isVisualBuilderEnabled")
    def is_visual_builder_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Visual Builder is enabled or not.
        """
        return pulumi.get(self, "is_visual_builder_enabled")

    @property
    @pulumi.getter(name="managementNatGatewayIp")
    def management_nat_gateway_ip(self) -> pulumi.Output[builtins.str]:
        """
        The NAT gateway IP address for the VB management VCN
        """
        return pulumi.get(self, "management_nat_gateway_ip")

    @property
    @pulumi.getter(name="managementVcnId")
    def management_vcn_id(self) -> pulumi.Output[builtins.str]:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder management VCN
        """
        return pulumi.get(self, "management_vcn_id")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> pulumi.Output['outputs.VbInstanceNetworkEndpointDetails']:
        """
        (Updatable) Base representation of a network endpoint. In input payload to update an Visual Builder instance endpoint details, an empty payload will clear out any existing configuration for Public Visual Builder instance.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The number of Nodes


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="serviceNatGatewayIp")
    def service_nat_gateway_ip(self) -> pulumi.Output[builtins.str]:
        """
        The NAT gateway IP address for the VB service VCN
        """
        return pulumi.get(self, "service_nat_gateway_ip")

    @property
    @pulumi.getter(name="serviceVcnId")
    def service_vcn_id(self) -> pulumi.Output[builtins.str]:
        """
        The Oracle Cloud ID (OCID) of the Visual Builder service VCN
        """
        return pulumi.get(self, "service_vcn_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the vb instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[builtins.str]:
        """
        An message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the the VbInstance was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the VbInstance was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

