from .geom import geom

class geom_line(geom):
    is_path = False
    DEFAULT_AES = {'color': 'black', 'alpha': 1.0, 'linetype': 'solid', 'size': 1.0}
    REQUIRED_AES = {'x', 'y'}
    DEFAULT_PARAMS = {'stat': 'identity', 'position': 'identity'}

    _aes_renames = {'size': 'linewidth', 'linetype': 'linestyle'}

    def plot(self, ax, data, _aes):
        params = self._get_plot_args(data, _aes)
        variables = _aes.data
        x = data[variables['x']]
        y = data[variables['y']]

        nulls = (x.isnull() | y.isnull())
        x = x[nulls==False]
        y = y[nulls==False]

        if self.is_path:
            pass
        else:
            order = x.argsort()
            x, y = x[order], y[order]
        ax.plot(x, y, **params)
