aws_arn = {
    "acm": {
        "certificate": {
            "arn_format": "arn:{partition}:acm:{region}:{account}:certificate/{resource_id}",
            "id_name": "CertificateId",
            "id_regexp": "([a-z0-9-]+)",
            "asff_name": "AwsCertificateManagerCertificate",
            "cloudformation": "AWS::CertificateManager::Certificate",
        }
    },
    "acm-pca": {
        "certificate_authority": {
            "arn_format": "arn:{partition}:acm-pca:{region}:{account}:certificate-authority/{resource_id}",
            "id_name": "CertificateAuthorityId",
            "id_regexp": "([a-z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ACMPCA::CertificateAuthority",
        }
    },
    "alexaforbusiness": {
        "skill": {
            "arn_format": "arn:{partition}:aplb:{region}:{account}:skill/{resource_id}",
            "id_name": "SkillId",
            "id_regexp": "([a-zA-Z0-9_\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::AlexaForBusiness::Skill",
        }
    },
    "apigateway": {
        "api": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{resource_id}",
            "id_name": "ApiId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "AwsApiGatewayV2Api",
            "cloudformation": "AWS::ApiGateway::RestApi",
        },
        "api_key": {
            "arn_format": "arn:{partition}:apigateway:{region}::/apikeys/{resource_id}",
            "id_name": "ApiKeyId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::ApiKey",
        },
        "authorizer": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/authorizers/{resource_id}",
            "id_name": "AuthorizerId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Authorizer",
        },
        "base_path_mapping": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/basepathmappings/{resource_id}",
            "id_name": "BasePathMappingId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::BasePathMapping",
        },
        "client_certificate": {
            "arn_format": "arn:{partition}:apigateway:{region}::/clientcertificates/{resource_id}",
            "id_name": "ClientCertificateId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::ClientCertificate",
        },
        "deployment": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/deployments/{resource_id}",
            "id_name": "DeploymentId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Deployment",
        },
        "documentation_part": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/documentation/parts/{resource_id}",
            "id_name": "DocumentationPartId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::DocumentationPart",
        },
        "documentation_version": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/documentation/versions/{resource_id}",
            "id_name": "DocumentationVersion",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::DocumentationVersion",
        },
        "domain_name": {
            "arn_format": "arn:{partition}:apigateway:{region}::/domainnames/{resource_id}",
            "id_name": "DomainName",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::DomainName",
        },
        "gateway_response": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/gatewayresponses/{resource_id}",
            "id_name": "GatewayResponseId",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::GatewayResponse",
        },
        "integration": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/resources/{ResourceId}/methods/{HttpMethod}/integrations/{resource_id}",
            "id_name": "IntegrationId",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Integration",
        },
        "method": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/resources/{ResourceId}/methods/{resource_id}",
            "id_name": "HttpMethod",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Method",
        },
        "model": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/models/{resource_id}",
            "id_name": "ModelName",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Model",
        },
        "request_validator": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/requestvalidators/{resource_id}",
            "id_name": "RequestValidatorId",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::RequestValidator",
        },
        "resource": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/resources/{resource_id}",
            "id_name": "ResourceId",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Resource",
        },
        "rest_api": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{resource_id}",
            "id_name": "ApiId",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::RestApi",
        },
        "rest_api": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{resource_id}",
            "id_name": "ApiId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::RestApi",
        },
        "stage": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{rest_api_id}/stages/{resource_id}",
            "id_name": "StageName",
            "id_regexp": "[a-zA-Z0-9\\-_]+",
            "asff_name": "AwsApiGatewayV2Stage",
            "cloudformation": "AWS::ApiGateway::Stage",
        },
        "usage_plan": {
            "arn_format": "arn:{partition}:apigateway:{region}::/usageplans/{resource_id}",
            "id_name": "UsagePlanId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::UsagePlan",
        },
        "usage_plan_key": {
            "arn_format": "arn:{partition}:apigateway:{region}::/usageplans/{usage_plan_id}/keys/{resource_id}",
            "id_name": "KeyId",
            "id_regexp": "[a-zA-Z0-9-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::UsagePlanKey",
        },
        "vpc_link": {
            "arn_format": "arn:{partition}:apigateway:{region}::/vpclinks/{resource_id}",
            "id_name": "VpcLinkId",
            "id_regexp": "[a-zA-Z0-9\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::VpcLink",
        },
    },
    "appflow": {
        "connector_profile": {
            "arn_format": "arn:{partition}:appflow:{region}:{account}:connectorprofile/{resource_id}",
            "id_name": "ConnectorProfileName",
            "id_regexp": "([a-zA-Z0-9-_]{1,256})",
            "asff_name": "",
            "cloudformation": "AWS::AppFlow::ConnectorProfile",
        },
        "flow": {
            "arn_format": "arn:{partition}:appflow:{region}:{account}:flow/{resource_id}",
            "id_name": "FlowName",
            "id_regexp": "([a-zA-Z0-9-_]{1,256})",
            "asff_name": "",
            "cloudformation": "AWS::AppFlow::Flow",
        },
    },
    "appstream": {
        "directory_config": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:directoryconfig/{resource_id}",
            "id_name": "DirectoryConfigName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::DirectoryConfig",
        },
        "fleet": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:fleet/{resource_id}",
            "id_name": "FleetName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::Fleet",
        },
        "image": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:image/{resource_id}",
            "id_name": "ImageName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::Image",
        },
        "image_builder": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:imagebuilder/{resource_id}",
            "id_name": "ImageBuilderName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::ImageBuilder",
        },
        "stack": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:stack/{resource_id}",
            "id_name": "StackName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::Stack",
        },
    },
    "athena": {
        "workgroup": {
            "arn_format": "arn:{partition}:athena:{region}:{account}:workgroup/{resource_id}",
            "id_name": "WorkGroupName",
            "id_regexp": "([a-zA-Z0-9._-]+)",
            "asff_name": "",
            "cloudformation": "AWS::Athena::WorkGroup",
        }
    },
    "augmentedairuntime": {
        "human_loop": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:human-loop/{resource_id}",
            "id_name": "HumanLoopName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::HumanTaskUi",
        }
    },
    "autoscaling": {
        "auto_scaling_group": {
            "arn_format": "arn:{partition}:autoscaling:{region}:{account}:autoScalingGroup:{resource_id}",
            "id_name": "AutoScalingGroupName",
            "id_regexp": "[a-zA-Z0-9-]{1,255}",
            "asff_name": "AwsAutoScalingAutoScalingGroup",
            "cloudformation": "AWS::AutoScaling::AutoScalingGroup",
        },
        "launch_configuration": {
            "arn_format": "arn:{partition}:autoscaling:{region}:{account}:launchConfiguration:{resource_id}",
            "id_name": "LaunchConfigurationName",
            "id_regexp": "[a-zA-Z0-9-]{1,255}",
            "asff_name": "AwsAutoScalingLaunchConfiguration",
            "cloudformation": "AWS::AutoScaling::LaunchConfiguration",
        },
    },
    "backup": {
        "backup_plan": {
            "arn_format": "arn:{partition}:backup:{region}:{account}:backup-plan/{resource_id}",
            "id_name": "BackupPlanId",
            "id_regexp": "^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$",
            "asff_name": "AwsBackupBackupPlan",
            "cloudformation": "AWS::Backup::BackupPlan",
        },
        "backup_vault": {
            "arn_format": "arn:{partition}:backup:{region}:{account}:backup-vault/{resource_id}",
            "id_name": "BackupVaultName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,50}$",
            "asff_name": "AwsBackupBackupVault",
            "cloudformation": "AWS::Backup::BackupVault",
        },
        "recovery_plan": {
            "arn_format": "arn:{partition}:backup:{region}:{account}:recoveryplan/{resource_id}",
            "id_name": "RecoveryPlanName",
            "id_regexp": "^[a-zA-Z0-9\\-\\_\\.]+$",
            "asff_name": "AwsBackupRecoveryPoint",
            "cloudformation": "AWS::Backup::RecoveryPlan",
        },
    },
    "batch": {
        "compute_environment": {
            "arn_format": "arn:{partition}:batch:{region}:{account}:compute-environment/{resource_id}",
            "id_name": "ComputeEnvironmentName",
            "id_regexp": "[a-zA-Z0-9_-]+",
            "asff_name": "",
            "cloudformation": "AWS::Batch::ComputeEnvironment",
        },
        "job_definition": {
            "arn_format": "arn:{partition}:batch:{region}:{account}:job-definition/{resource_id}:{version}",
            "id_name": "JobDefinitionName",
            "version_name": "JobDefinitionVersion",
            "id_regexp": "[a-zA-Z0-9_-]+",
            "version_regexp": "[a-zA-Z0-9_-]+",
            "asff_name": "",
            "cloudformation": "AWS::Batch::JobDefinition",
        },
        "job_queue": {
            "arn_format": "arn:{partition}:batch:{region}:{account}:job-queue/{resource_id}",
            "id_name": "JobQueueName",
            "id_regexp": "[a-zA-Z0-9_-]+",
            "asff_name": "",
            "cloudformation": "AWS::Batch::JobQueue",
        },
    },
    "budgets": {
        "budget": {
            "arn_format": "arn:{partition}:budgets:{region}:{account}:budget/{resource_id}",
            "id_name": "BudgetName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::Budgets::Budget",
        }
    },
    "cloud9": {
        "environment": {
            "arn_format": "arn:{partition}:cloud9:{region}:{account}:environment:{resource_id}",
            "id_name": "EnvironmentId",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::Cloud9::EnvironmentEC2",
        }
    },
    "cloudformation": {
        "change_set": {
            "arn_format": "arn:{partition}:cloudformation:{region}:{account}:changeSet/{resource_id}",
            "id_name": "ChangeSetId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CloudFormation::ChangeSet",
        },
        "stack": {
            "arn_format": "arn:{partition}:cloudformation:{region}:{account}:stack/{stack_name}/{stack_id}",
            "id_name": "StackName",
            "id_regexp": "([a-zA-Z][-a-zA-Z0-9]*)",
            "asff_name": "AwsCloudFormationStack",
            "cloudformation": "AWS::CloudFormation::Stack",
        },
    },
    "cloudfront": {
        "distribution": {
            "arn_format": "arn:{partition}:cloudfront::{account}:distribution/{resource_id}",
            "id_name": "DistributionId",
            "id_regexp": "[A-Z0-9]+",
            "asff_name": "AwsCloudFrontDistribution",
            "cloudformation": "AWS::CloudFront::Distribution",
        },
        "field_level_encryption_config": {
            "arn_format": "arn:{partition}:cloudfront::{account}:field-level-encryption-config/{resource_id}",
            "id_name": "FieldLevelEncryptionConfigId",
            "id_regexp": "[A-Z0-9]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudFront::FieldLevelEncryptionConfig",
        },
        "field_level_encryption_profile": {
            "arn_format": "arn:{partition}:cloudfront::{account}:field-level-encryption-profile/{resource_id}",
            "id_name": "FieldLevelEncryptionProfileId",
            "id_regexp": "[A-Z0-9]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudFront::FieldLevelEncryptionProfile",
        },
        "realtime_log_config": {
            "arn_format": "arn:{partition}:cloudfront::{account}:realtime-log-config/{resource_id}",
            "id_name": "RealtimeLogConfigId",
            "id_regexp": "[A-Z0-9]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudFront::RealtimeLogConfig",
        },
    },
    "cloudhsmv2": {
        "cluster": {
            "arn_format": "arn:{partition}:cloudhsmv2:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterId",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudHSMV2::Cluster",
        },
        "backup": {
            "arn_format": "arn:{partition}:cloudhsmv2:{region}:{account}:backup/{resource_id}",
            "id_name": "BackupId",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudHSMV2::Backup",
        },
        "hsm": {
            "arn_format": "arn:{partition}:cloudhsmv2:{region}:{account}:cluster/{resource_id}/hsm/{hsm_id}",
            "id_name": "HsmId",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudHSMV2::Hsm",
        },
    },
    "cloudtrail": {
        "trail": {
            "arn_format": "arn:{partition}:cloudtrail:{region}:{account}:trail/{resource_id}",
            "id_name": "TrailName",
            "id_regexp": "[a-zA-Z0-9-_\\.]+",
            "asff_name": "AwsCloudTrailTrail",
            "cloudformation": "AWS::CloudTrail::Trail",
        }
    },
    "cloudwatch": {
        "alarm": {
            "arn_format": "arn:{partition}:cloudwatch:{region}:{account}:alarm:{resource_id}",
            "id_name": "AlarmName",
            "id_regexp": "^[a-zA-Z0-9\\-_]{1,255}$",
            "asff_name": "AwsCloudWatchAlarm",
            "cloudformation": "AWS::CloudWatch::Alarm",
        },
        "dashboard": {
            "arn_format": "arn:{partition}:cloudwatch::{account}:dashboard/{resource_id}",
            "id_name": "DashboardName",
            "id_regexp": "^[a-zA-Z0-9-_ ]{3,255}$",
            "asff_name": "",
            "cloudformation": "AWS::CloudWatch::Dashboard",
        },
    },
    "codeartifact": {
        "domain": {
            "arn_format": "arn:{partition}:codeartifact:{region}:{account}:domain/{resource_id}",
            "id_name": "DomainName",
            "id_regexp": "([a-zA-Z0-9._-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeArtifact::Domain",
        },
        "repository": {
            "arn_format": "arn:{partition}:codeartifact:{region}:{account}:repository/{domain_name}/{resource_id}",
            "id_name": "RepositoryName",
            "id_regexp": "([a-zA-Z0-9._-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeArtifact::Repository",
        },
        "package": {
            "arn_format": "arn:{partition}:codeartifact:{region}:{account}:repository/{domain_name}/{repository_name}/package/{package_format}/{package_name}@{package_version}",
            "id_name": "PackageName",
            "id_regexp": "([a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeArtifact::Package",
        },
    },
    "codebuild": {
        "project": {
            "arn_format": "arn:{partition}:codebuild:{region}:{account}:project/{resource_id}",
            "id_name": "ProjectName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "AwsCodeBuildProject",
            "cloudformation": "AWS::CodeBuild::Project",
        }
    },
    "codecommit": {
        "repository": {
            "arn_format": "arn:{partition}:codecommit:{region}:{account}:{resource_id}",
            "id_name": "RepositoryName",
            "id_regexp": "([a-zA-Z0-9_.-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeCommit::Repository",
        }
    },
    "codedeploy": {
        "application": {
            "arn_format": "arn:{partition}:codedeploy:{region}:{account}:application:{resource_id}",
            "id_name": "ApplicationName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeDeploy::Application",
        },
        "deployment_config": {
            "arn_format": "arn:{partition}:codedeploy:{region}:{account}:deploymentconfig:{resource_id}",
            "id_name": "DeploymentConfigName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeDeploy::DeploymentConfig",
        },
        "deployment_group": {
            "arn_format": "arn:{partition}:codedeploy:{region}:{account}:deploymentgroup:{resource_id}",
            "id_name": "ApplicationName/DeploymentGroupName",
            "id_regexp": "([a-zA-Z0-9-_]+/[a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeDeploy::DeploymentGroup",
        },
    },
    "codepipeline": {
        "pipeline": {
            "arn_format": "arn:{partition}:codepipeline:{region}:{account}:{resource_type}/{resource_id}",
            "id_name": "PipelineName",
            "id_regexp": "([a-zA-Z0-9_\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodePipeline::Pipeline",
        }
    },
    "codestar-connections": {
        "connection": {
            "arn_format": "arn:{partition}:codestar-connections:{region}:{account}:connection/{resource_id}",
            "id_name": "ConnectionName",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeStarConnections::Connection",
        }
    },
    "codestar-notifications": {
        "rule": {
            "arn_format": "arn:{partition}:codestar-notifications:{region}:{account}:notificationrule/{resource_id}",
            "id_name": "NotificationRuleId",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeStarNotifications::NotificationRule",
        }
    },
    "cognito-idp": {
        "identity_provider": {
            "arn_format": "arn:{partition}:cognito-idp:{region}:{account}:userpool/{user_pool_id}:identityprovider/{identity_provider_name}",
            "id_name": "identity_provider_name",
            "id_regexp": "([a-zA-Z0-9_\\.\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::Cognito::UserPoolIdentityProvider",
        },
        "resource_server": {
            "arn_format": "arn:{partition}:cognito-idp:{region}:{account}:userpool/{user_pool_id}/resource-server/{resource_server_id}",
            "id_name": "resource_server_id",
            "id_regexp": "([a-zA-Z0-9_\\.\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::Cognito::UserPoolResourceServer",
        },
        "user_pool": {
            "arn_format": "arn:{partition}:cognito-idp:{region}:{account}:userpool/{user_pool_id}",
            "id_name": "user_pool_id",
            "id_regexp": "([a-zA-Z0-9_\\.\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::Cognito::UserPool",
        },
    },
    "comprehend": {
        "document_classifier": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:document-classifier/{resource_id}",
            "id_name": "DocumentClassifierName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::DocumentClassifier",
        },
        "entity_recognizer": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:entity-recognizer/{resource_id}",
            "id_name": "EntityRecognizerName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::EntityRecognizer",
        },
        "key_phrases_detection_job": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:key-phrases-detection-job/{resource_id}",
            "id_name": "KeyPhrasesDetectionJobName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::KeyPhrasesDetectionJob",
        },
        "sentiment_detection_job": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:sentiment-detection-job/{resource_id}",
            "id_name": "SentimentDetectionJobName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::SentimentDetectionJob",
        },
        "topic_detection_job": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:topic-detection-job/{resource_id}",
            "id_name": "TopicDetectionJobName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::TopicDetectionJob",
        },
    },
    "compute-optimizer": {
        "recommendation_export_job": {
            "arn_format": "arn:{partition}:compute-optimizer:{region}:{account}:recommendation-export-job/{resource_id}",
            "id_name": "ExportJobId",
            "id_regexp": "([a-z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ComputeOptimizer::RecommendationExportJob",
        }
    },
    "config": {
        "aggregator": {
            "arn_format": "arn:{partition}:config:{region}:{account}:config-aggregator/{resource_id}",
            "id_name": "ConfigAggregatorName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::Aggregator",
        },
        "conformance_pack": {
            "arn_format": "arn:{partition}:config:{region}:{account}:conformance-pack/{resource_id}",
            "id_name": "ConformancePackName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::ConformancePack",
        },
        "config_rule": {
            "arn_format": "arn:{partition}:config:{region}:{account}:config-rule/{resource_id}",
            "id_name": "ConfigRuleName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::ConfigRule",
        },
        "organization_config_rule": {
            "arn_format": "arn:{partition}:config:{region}:{account}:organization-config-rule/{resource_id}",
            "id_name": "OrganizationConfigRuleName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::OrganizationConfigRule",
        },
        "remediation_configuration": {
            "arn_format": "arn:{partition}:config:{region}:{account}:remediation-configuration/{resource_id}",
            "id_name": "RemediationConfigurationName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::RemediationConfiguration",
        },
    },
    "cur": {
        "report_definition": {
            "arn_format": "arn:{partition}:cur:${ReportName}-${YYYYMM}-${AdditionalArtifact}-{region}-{account}",
            "id_name": "ReportName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::CUR::ReportDefinition",
        }
    },
    "dataexchange": {
        "asset": {
            "arn_format": "arn:{partition}:dataexchange:{region}:{account}:asset/{resource_id}",
            "id_name": "AssetId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataExchange::Asset",
        },
        "data_set": {
            "arn_format": "arn:{partition}:dataexchange:{region}:{account}:data-sets/{resource_id}",
            "id_name": "DataSetId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataExchange::DataSet",
        },
        "job": {
            "arn_format": "arn:{partition}:dataexchange:{region}:{account}:job/{resource_id}",
            "id_name": "JobId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataExchange::Job",
        },
        "revision": {
            "arn_format": "arn:{partition}:dataexchange:{region}:{account}:revision/{resource_id}",
            "id_name": "RevisionId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataExchange::Revision",
        },
    },
    "datapipeline": {
        "pipeline": {
            "arn_format": "arn:{partition}:datapipeline:{region}:{account}:{resource_type}/{resource_id}",
            "id_name": "PipelineId",
            "id_regexp": "([a-zA-Z0-9_-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataPipeline::Pipeline",
        }
    },
    "dax": {
        "cluster": {
            "arn_format": "arn:{partition}:dax:{region}:{account}:cluster:{resource_id}",
            "id_name": "ClusterName",
            "id_regexp": "([a-zA-Z0-9_.-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DAX::Cluster",
        }
    },
    "devicefarm": {
        "project": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:project:${resource_id}",
            "id_name": "ProjectArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Project",
        },
        "device_instance": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:device-instance:${resource_id}",
            "id_name": "DeviceInstanceArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::DeviceInstance",
        },
        "device_pool": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:devicepool:${resource_id}",
            "id_name": "DevicePoolArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::DevicePool",
        },
        "run": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:run:${resource_id}",
            "id_name": "RunArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Run",
        },
        "job": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:job:${resource_id}",
            "id_name": "JobArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Job",
        },
        "suite": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:suite:${resource_id}",
            "id_name": "SuiteArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Suite",
        },
        "test": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:test:${resource_id}",
            "id_name": "TestArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Test",
        },
    },
    "directconnect": {
        "connection": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:dxcon:{resource_id}",
            "id_name": "ConnectionId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::Connection",
        },
        "link_aggregation_group": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:linkaggregations:{resource_id}",
            "id_name": "LagId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::LinkAggregationGroup",
        },
        "private_virtual_interface": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:dxvif:{resource_id}",
            "id_name": "VirtualInterfaceId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::PrivateVirtualInterface",
        },
        "public_virtual_interface": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:dxvif:{resource_id}",
            "id_name": "VirtualInterfaceId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::PublicVirtualInterface",
        },
        "transit_virtual_interface": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:dxvif:{resource_id}",
            "id_name": "VirtualInterfaceId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::TransitVirtualInterface",
        },
    },
    "dynamodb": {
        "table": {
            "arn_format": "arn:{partition}:dynamodb:{region}:{account}:table/{resource_id}",
            "id_name": "TableName",
            "id_regexp": "([a-zA-Z0-9_.-]+)",
            "asff_name": "AwsDynamoDbTable",
            "cloudformation": "AWS::DynamoDB::Table",
        }
    },
    "ec2": {
        "customer_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:customer-gateway/{resource_id}",
            "id_name": "CustomerGatewayId",
            "id_regexp": "^cgw-[a-f0-9]{8}$",
            "asff_name": "AwsEc2CustomerGateway",
            "cloudformation": "AWS::EC2::CustomerGateway",
        },
        "dedicated_host": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:host/{resource_id}",
            "id_name": "DedicatedHostId",
            "id_regexp": "^h-[0-9a-f]{17}$",
            "asff_name": "AwsEc2DedicatedHost",
            "cloudformation": "AWS::EC2::Host",
        },
        "dhcp_options": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:dhcp-options/{resource_id}",
            "id_name": "DhcpOptionsId",
            "id_regexp": "^dopt-[0-9a-fA-F]{8,17}$",
            "asff_name": "AwsEc2DhcpOptions",
            "cloudformation": "AWS::EC2::DHCPOptions",
        },
        "egress_only_internet_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:egress-only-internet-gateway/{resource_id}",
            "id_name": "EgressOnlyInternetGatewayId",
            "id_regexp": "^egress-only-igw-[a-f0-9]{8,17}$",
            "asff_name": "AwsEc2EgressOnlyInternetGateway",
            "cloudformation": "AWS::EC2::EgressOnlyInternetGateway",
        },
        "elastic_gpu": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:elastic-gpu/{resource_id}",
            "id_name": "ElasticGpuId",
            "id_regexp": "^egp-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2ElasticGpu",
            "cloudformation": "AWS::EC2::ElasticGpu",
        },
        "elastic_inference_accelerator": {
            "arn_format": "arn:{partition}:elastic-inference:{region}:{account}:accelerator/{resource_id}",
            "id_name": "AcceleratorId",
            "id_regexp": "^eia-[0-9a-f]{17}$",
            "asff_name": "AwsElasticInferenceAccelerator",
            "cloudformation": "AWS::ElasticInference::Accelerator",
        },
        "elastic_ip": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:elastic-ip/{resource_id}",
            "id_name": "AllocationId",
            "id_regexp": "^eipalloc-[0-9a-fA-F]{8,17}$",
            "asff_name": "AwsEc2Eip",
            "cloudformation": "AWS::EC2::EIP",
        },
        "flow_log": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:flow-log/{resource_id}",
            "id_name": "FlowLogId",
            "id_regexp": "^fl-[0-9a-f]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::FlowLog",
        },
        "image": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:image/{resource_id}",
            "id_name": "ImageId",
            "id_regexp": "^ami-[a-f0-9]{8}$|^ami-[a-f0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::Image",
        },
        "instance": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:instance/{resource_id}",
            "id_name": "InstanceId",
            "id_regexp": "^i-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2Instance",
            "cloudformation": "AWS::EC2::Instance",
        },
        "internet_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:internet-gateway/{resource_id}",
            "id_name": "InternetGatewayId",
            "id_regexp": "^igw-[a-f0-9]{8,17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::InternetGateway",
        },
        "key_pair": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:key-pair/{resource_id}",
            "id_name": "KeyName",
            "id_regexp": "^[a-zA-Z0-9-_=,.@()]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::KeyPair",
        },
        "launch_template": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:launch-template/{resource_id}",
            "id_name": "LaunchTemplateId",
            "id_regexp": "^lt-[a-zA-Z0-9]{17}$",
            "asff_name": "AwsEc2LaunchTemplate",
            "cloudformation": "AWS::EC2::LaunchTemplate",
        },
        "natgateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:natgateway/{resource_id}",
            "id_name": "NatGatewayId",
            "id_regexp": "^nat-[a-f0-9]{8,}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::NatGateway",
        },
        "network_acl": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:network-acl/{resource_id}",
            "id_name": "NetworkAclId",
            "id_regexp": "^acl-[0-9a-fA-F]{8,17}$",
            "asff_name": "AwsEc2NetworkAcl",
            "cloudformation": "AWS::EC2::NetworkAcl",
        },
        "network_interface": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:network-interface/{resource_id}",
            "id_name": "NetworkInterfaceId",
            "id_regexp": "^eni-[0-9a-f]{8}|eni-[0-9a-f]{17}$",
            "asff_name": "AwsEc2NetworkInterface",
            "cloudformation": "AWS::EC2::NetworkInterface",
        },
        "placement_group": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:placement-group/{resource_id}",
            "id_name": "PlacementGroupName",
            "id_regexp": "^pg-[a-z0-9]{8}$",
            "asff_name": "AwsEc2PlacementGroup",
            "cloudformation": "AWS::EC2::PlacementGroup",
        },
        "reserved_instances": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:reserved-instances/{resource_id}",
            "id_name": "ReservedInstancesId",
            "id_regexp": "^i-[a-zA-Z0-9]{12}$",
            "asff_name": "AwsEc2ReservedInstances",
            "cloudformation": "AWS::EC2::ReservedInstances",
        },
        "route_table": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:route-table/{resource_id}",
            "id_name": "RouteTableId",
            "id_regexp": "^rtb-[a-f0-9]{8,17}$",
            "asff_name": "AwsEc2RouteTable",
            "cloudformation": "AWS::EC2::RouteTable",
        },
        "security_group": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:security-group/{resource_id}",
            "id_name": "SecurityGroupId",
            "id_regexp": "^sg-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2SecurityGroup",
            "cloudformation": "AWS::EC2::SecurityGroup",
        },
        "snapshot": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:snapshot/{resource_id}",
            "id_name": "SnapshotId",
            "id_regexp": "^snap-[a-f0-9]{8,17}$",
            "asff_name": "AwsEc2Snapshot",
            "cloudformation": "AWS::EC2::Snapshot",
        },
        "spot_fleet_request": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:spot-fleet-request/{resource_id}",
            "id_name": "SpotFleetRequestId",
            "id_regexp": "^sfr-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2SpotFleetRequest",
            "cloudformation": "AWS::EC2::SpotFleet",
        },
        "spot_instance_request": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:spot-instances-request/{resource_id}",
            "id_name": "SpotInstanceRequestId",
            "id_regexp": "^sir-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2SpotInstanceRequest",
            "cloudformation": "AWS::EC2::SpotInstance",
        },
        "subnet": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:subnet/{resource_id}",
            "id_name": "SubnetId",
            "id_regexp": "^subnet-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2Subnet",
            "cloudformation": "AWS::EC2::Subnet",
        },
        "traffic_mirror_filter": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:traffic-mirror-filter/{resource_id}",
            "id_name": "TrafficMirrorFilterId",
            "id_regexp": "^tmf-[a-f0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TrafficMirrorFilter",
        },
        "traffic_mirror_session": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:traffic-mirror-session/{resource_id}",
            "id_name": "TrafficMirrorSessionId",
            "id_regexp": "^tmse-[a-f0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TrafficMirrorSession",
        },
        "traffic_mirror_target": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:traffic-mirror-target/{resource_id}",
            "id_name": "TrafficMirrorTargetId",
            "id_regexp": "^tmt-[a-f0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TrafficMirrorTarget",
        },
        "transit_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:transit-gateway/{resource_id}",
            "id_name": "TransitGatewayId",
            "id_regexp": "^tgw-\w{8,17}$",
            "asff_name": "AwsEc2TransitGateway",
            "cloudformation": "AWS::EC2::TransitGateway",
        },
        "transit_gateway_attachment": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:transit-gateway-attachment/{resource_id}",
            "id_name": "TransitGatewayAttachmentId",
            "id_regexp": "^tgw-attach-[0-9a-f]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TransitGatewayAttachment",
        },
        "transit_gateway_multicast_domain": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:transit-gateway-multicast-domain/{resource_id}",
            "id_name": "TransitGatewayMulticastDomainId",
            "id_regexp": "^tgmd-[a-f0-9]{8,17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TransitGatewayMulticastDomain",
        },
        "transit_gateway_route_table": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:transit-gateway-route-table/{resource_id}",
            "id_name": "TransitGatewayRouteTableId",
            "id_regexp": "^tgw-rtb-[0-9a-f]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TransitGatewayRouteTable",
        },
        "volume": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:volume/{resource_id}",
            "id_name": "VolumeId",
            "id_regexp": "^vol-[a-f0-9]{8}|vol-[a-f0-9]{17}$",
            "asff_name": "AwsEc2Volume",
            "cloudformation": "AWS::EC2::Volume",
        },
        "vpc": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpc/{resource_id}",
            "id_name": "VpcId",
            "id_regexp": "^vpc-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2Vpc",
            "cloudformation": "AWS::EC2::VPC",
        },
        "vpc_endpoint": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpc-endpoint/{resource_id}",
            "id_name": "VpcEndpointId",
            "id_regexp": "^vpce-[a-z0-9]{8,}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::VPCEndpoint",
        },
        "vpc_endpoint_service": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpc-endpoint-service/{resource_id}",
            "id_name": "VpcEndpointServiceId",
            "id_regexp": "^vpce-svc-[0-9a-f]{8,}$",
            "asff_name": "AwsEc2VpcEndpointService",
            "cloudformation": "AWS::EC2::VPCEndpointService",
        },
        "vpc_peering_connection": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpc-peering-connection/{resource_id}",
            "id_name": "VpcPeeringConnectionId",
            "id_regexp": "^pcx-[a-z0-9]{8,17}$",
            "asff_name": "AwsEc2VpcPeeringConnection",
            "cloudformation": "AWS::EC2::VPCPeeringConnection",
        },
        "vpn_connection": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpn-connection/{resource_id}",
            "id_name": "VpnConnectionId",
            "id_regexp": "^vpn-[a-f0-9]{8}$",
            "asff_name": "AwsEc2VpnConnection",
            "cloudformation": "AWS::EC2::VPNConnection",
        },
        "vpn_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpn-gateway/{resource_id}",
            "id_name": "VpnGatewayId",
            "id_regexp": "^vgw-[0-9a-f]{8}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::VPNGateway",
        },
    },
    "ec2-instance-connect": {
        "connect": {
            "arn_format": "arn:{partition}:ec2-instance-connect:{region}:{account}:connect/${InstanceId}",
            "id_name": "InstanceId",
            "id_regexp": "([a-zA-Z0-9\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::EC2::Instance",
        }
    },
    "ecr": {
        "repository": {
            "arn_format": "arn:{partition}:ecr:{region}:{account}:repository/{resource_id}",
            "id_name": "RepositoryName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AwsEcrRepository",
        },
        "image": {
            "arn_format": "arn:{partition}:ecr:{region}:{account}:image/{resource_id}",
            "id_name": "ImageDigest",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "AwsEcrContainerImage",
            "cloudformation": "AWS::ECR::Image",
        },
    },
    "ecs": {
        "cluster": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsCluster",
            "cloudformation": "AWS::ECS::Cluster",
        },
        "task_definition": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:task-definition/{resource_id}",
            "id_name": "TaskDefinitionFamily",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsTaskDefinition",
            "cloudformation": "AWS::ECS::TaskDefinition",
        },
        "task": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:task/{resource_id}",
            "id_name": "TaskId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsTask",
            "cloudformation": "AWS::ECS::Task",
        },
        "service": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:service/{cluster_name}/{service_name}",
            "id_name": "ServiceName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "parent_id_name": "ClusterName",
            "parent_id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsService",
            "cloudformation": "AWS::ECS::Service",
        },
        "container_instance": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:container-instance/{resource_id}",
            "id_name": "ContainerInstanceId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsContainer",
            "cloudformation": "AWS::ECS::ContainerInstance",
        },
    },
    "efs": {
        "file_system": {
            "arn_format": "arn:{partition}:elasticfilesystem:{region}:{account}:file-system/{resource_id}",
            "id_name": "FileSystemId",
            "id_regexp": "fs-[a-zA-Z0-9]{8}",
            "asff_name": "",
            "cloudformation": "AWS::EFS::FileSystem",
        },
        "access_point": {
            "arn_format": "arn:{partition}:elasticfilesystem:{region}:{account}:access-point/{resource_id}",
            "id_name": "AccessPointId",
            "id_regexp": "fsap-[a-zA-Z0-9]{8}",
            "asff_name": "AwsEfsAccessPoint",
            "cloudformation": "AWS::EFS::AccessPoint",
        },
    },
    "eks": {
        "cluster": {
            "arn_format": "arn:{partition}:eks:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterName",
            "id_regexp": "([a-zA-Z0-9._-]+)",
            "asff_name": "AwsEksCluster",
            "cloudformation": "AWS::EKS::Cluster",
        }
    },
    "elastic-inference": {
        "accelerator_type": {
            "arn_format": "arn:{partition}:elastic-inference:{region}:{account}:accelerator-type/{resource_id}",
            "id_name": "AcceleratorTypeName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElasticInference::AcceleratorType",
        }
    },
    "elasticache": {
        "cache_cluster": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:cluster:{resource_id}",
            "id_name": "CacheClusterId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::CacheCluster",
        },
        "cache_parameter_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:parameter-group:{resource_id}",
            "id_name": "CacheParameterGroupName",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::CacheParameterGroup",
        },
        "cache_security_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:security-group:{resource_id}",
            "id_name": "CacheSecurityGroupName",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::SecurityGroup",
        },
        "cache_subnet_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:subnet-group:{resource_id}",
            "id_name": "CacheSubnetGroupName",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::SubnetGroup",
        },
        "global_replication_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:global-replication-group:{resource_id}",
            "id_name": "GlobalReplicationGroupId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::GlobalReplicationGroup",
        },
        "replication_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:cluster:{resource_id}",
            "id_name": "ReplicationGroupId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::ReplicationGroup",
        },
        "user_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:user-group:{resource_id}",
            "id_name": "UserGroupId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::UserGroup",
        },
    },
    "elasticbeanstalk": {
        "application": {
            "arn_format": "arn:{partition}:elasticbeanstalk:{region}:{account}:application/{resource_id}",
            "id_name": "ApplicationName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElasticBeanstalk::Application",
        },
        "application_version": {
            "arn_format": "arn:{partition}:elasticbeanstalk:{region}:{account}:applicationversion/{resource_id}",
            "id_name": "ApplicationVersionName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElasticBeanstalk::ApplicationVersion",
        },
        "environment": {
            "arn_format": "arn:{partition}:elasticbeanstalk:{region}:{account}:environment/{resource_id}",
            "id_name": "EnvironmentId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsElasticBeanstalkEnvironment",
            "cloudformation": "AWS::ElasticBeanstalk::Environment",
        },
    },
    "elb": {
        "loadbalancer": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:loadbalancer/{resource_id}",
            "id_name": "LoadBalancerName",
            "id_regexp": "[\\w.-]{1,32}",
            "asff_name": "AwsElbLoadBalancer",
            "cloudformation": "AWS::ElasticLoadBalancing::LoadBalancer",
        },
    },
    "elbv2": {
        "loadbalancer": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:loadbalancer/{resource_id}",
            "id_name": "LoadBalancerName",
            "id_regexp": "[\\w.-]{1,32}",
            "asff_name": "AwsElbv2LoadBalancer",
            "cloudformation": "AWS::ElasticLoadBalancingV2::LoadBalancer",
        },
        "targetgroup": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:targetgroup/{resource_id}/{tagergroup_id}}",
            "id_name": "TargetGroupID",
            "id_regexp": "[\\w.-]{1,32}",
            "asff_name": "",
            "cloudformation": "AWS::ElasticLoadBalancingV2::TargetGroup",
        },
        "listener": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:listener/{resource_id}/{load_balancer_id}/{listener_id}",
            "id_name": "ListenerId",
            "id_regexp": "(?<=listener\/app\/)[^\/]+",
            "asff_name": "",
            "cloudformation": "AWS::ElasticLoadBalancingV2::Listener",
        },
        "listener_rule": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:listener-rule/{resource_id}",
            "id_name": "ListenerRuleId",
            "id_regexp": "[\\w.-]{1,32}",
            "asff_name": "",
            "cloudformation": "AWS::ElasticLoadBalancingV2::ListenerRule",
        },
    },
    "elasticmapreduce": {
        "cluster": {
            "arn_format": "arn:{partition}:elasticmapreduce:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterId",
            "id_regexp": "j-[0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::EMR::Cluster",
        },
        "security_configuration": {
            "arn_format": "arn:{partition}:elasticmapreduce:{region}:{account}:security-configuration/{resource_id}",
            "id_name": "SecurityConfigurationName",
            "id_regexp": "[a-zA-Z0-9_.\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::EMR::SecurityConfiguration",
        },
        "step": {
            "arn_format": "arn:{partition}:elasticmapreduce:{region}:{account}:cluster/{resource_id}/step/{step_id}",
            "id_name": "StepId",
            "id_regexp": "s-[0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::EMR::Step",
        },
    },
    "elastictranscoder": {
        "pipeline": {
            "arn_format": "arn:{partition}:elastictranscoder:{region}:{account}:pipeline/{resource_id}",
            "id_name": "PipelineId",
            "id_regexp": "[0-9a-zA-Z-_]{1,255}",
            "asff_name": "",
            "cloudformation": "AWS::ElasticTranscoder::Pipeline",
        },
        "preset": {
            "arn_format": "arn:{partition}:elastictranscoder:{region}:{account}:preset/{resource_id}",
            "id_name": "PresetId",
            "id_regexp": "[0-9a-zA-Z-_]{1,255}",
            "asff_name": "",
            "cloudformation": "AWS::ElasticTranscoder::Preset",
        },
    },
    "es": {
        "domain": {
            "arn_format": "arn:{partition}:es:{region}:{account}:domain/{resource_id}",
            "id_name": "DomainName",
            "id_regexp": "[a-z0-9][a-z0-9-]{2,28}[a-z0-9]",
            "asff_name": "AwsElasticSearchDomain",
            "cloudformation": "AWS::Elasticsearch::Domain",
        }
    },
    "events": {
        "archive": {
            "arn_format": "arn:{partition}:events:{region}:{account}:archive/{resource_id}",
            "id_name": "ArchiveName",
            "id_regexp": "[0-9a-zA-Z_.:-]+",
            "asff_name": "",
            "cloudformation": "AWS::Events::Archive",
        },
        "bus": {
            "arn_format": "arn:{partition}:events:{region}:{account}:event-bus/{resource_id}",
            "id_name": "EventBusName",
            "id_regexp": "[0-9a-zA-Z_]+",
            "asff_name": "",
            "cloudformation": "AWS::Events::EventBus",
        },
        "rule": {
            "arn_format": "arn:{partition}:events:{region}:{account}:rule/{resource_id}",
            "id_name": "RuleName",
            "id_regexp": "[0-9a-zA-Z_]+",
            "asff_name": "",
            "cloudformation": "AWS::Events::Rule",
        },
    },
    "firehose": {
        "delivery_stream": {
            "arn_format": "arn:{partition}:firehose:{region}:{account}:deliverystream/{resource_id}",
            "id_name": "DeliveryStreamName",
            "id_regexp": "[a-zA-Z0-9_-]+",
            "asff_name": "",
            "cloudformation": "AWS::KinesisFirehose::DeliveryStream",
        }
    },
    "fms": {
        "policy": {
            "arn_format": "arn:{partition}:fms:{region}:{account}:policy/{resource_id}",
            "id_name": "PolicyName",
            "id_regexp": "[\\w-]+",
            "asff_name": "",
            "cloudformation": "AWS::FMS::Policy",
        }
    },
    "fsx": {
        "backup": {
            "arn_format": "arn:{partition}:fsx:{region}:{account}:backup/{resource_id}",
            "id_name": "BackupId",
            "id_regexp": "backup-[0-9a-f]+",
            "asff_name": "",
            "cloudformation": "AWS::FSx::Backup",
        },
        "file_system": {
            "arn_format": "arn:{partition}:fsx:{region}:{account}:file-system/{resource_id}",
            "id_name": "FileSystemId",
            "id_regexp": "fs-[0-9a-f]+",
            "asff_name": "",
            "cloudformation": "AWS::FSx::FileSystem",
        },
    },
    "gamelift": {
        "alias": {
            "arn_format": "arn:{partition}:gamelift:{region}:{account}:alias/{resource_id}",
            "id_name": "AliasId",
            "id_regexp": "^[a-zA-Z0-9-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::GameLift::Alias",
        },
        "build": {
            "arn_format": "arn:{partition}:gamelift:{region}:{account}:build/{resource_id}",
            "id_name": "BuildId",
            "id_regexp": "^build-[a-z0-9]{14}$",
            "asff_name": "",
            "cloudformation": "AWS::GameLift::Build",
        },
        "fleet": {
            "arn_format": "arn:{partition}:gamelift:{region}:{account}:fleet/{resource_id}",
            "id_name": "FleetId",
            "id_regexp": "^fleet-[a-z0-9]{14}$",
            "asff_name": "",
            "cloudformation": "AWS::GameLift::Fleet",
        },
    },
    "glacier": {
        "vault": {
            "arn_format": "arn:{partition}:glacier:{region}:{account}:vaults/{resource_id}",
            "id_name": "VaultName",
            "id_regexp": "^[a-zA-Z0-9][a-zA-Z0-9-]{0,254}$",
            "asff_name": "",
            "cloudformation": "AWS::Glacier::Vault",
        }
    },
    "globalaccelerator": {
        "accelerator": {
            "arn_format": "arn:{partition}:globalaccelerator::{account}:accelerator/{resource_id}",
            "id_name": "AcceleratorId",
            "id_regexp": "[a-z0-9]{16}",
            "asff_name": "",
            "cloudformation": "AWS::GlobalAccelerator::Accelerator",
        },
        "listener": {
            "arn_format": "arn:{partition}:globalaccelerator::{account}:listener/{resource_id}",
            "id_name": "ListenerId",
            "id_regexp": "[a-z0-9]{16}",
            "asff_name": "",
            "cloudformation": "AWS::GlobalAccelerator::Listener",
        },
        "endpoint_group": {
            "arn_format": "arn:{partition}:globalaccelerator::{account}:endpoint-group/{resource_id}",
            "id_name": "EndpointGroupId",
            "id_regexp": "[a-z0-9]{16}",
            "asff_name": "",
            "cloudformation": "AWS::GlobalAccelerator::EndpointGroup",
        },
    },
    "glue": {
        "catalog": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:catalog",
            "id_name": "None",
            "id_regexp": "None",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Catalog",
        },
        "crawler": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:crawler:{resource_name}",
            "id_name": "CrawlerName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Crawler",
        },
        "database": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:database/{resource_id}",
            "id_name": "DatabaseName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Database",
        },
        "dev_endpoint": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:devEndpoint/{resource_name}",
            "id_name": "DevEndpointName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::DevEndpoint",
        },
        "job": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:job/{resource_name}",
            "id_name": "JobName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Job",
        },
        "partition": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:table/{DatabaseName}/{TableName}/partition/{PartitionValues}",
            "id_name": "None",
            "id_regexp": "None",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Partition",
        },
        "trigger": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:trigger/{resource_name}",
            "id_name": "TriggerName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Trigger",
        },
        "workflow": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:workflow/{resource_name}",
            "id_name": "WorkflowName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Workflow",
        },
    },
    "greengrass": {
        "group": {
            "arn_format": "arn:{partition}:greengrass:{region}:{account}:/greengrass/groups/{resource_id}",
            "id_name": "GroupId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::Greengrass::Group",
        }
    },
    "guardduty": {
        "detector": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}",
            "id_name": "DetectorId",
            "id_regexp": "^[0-9a-f]{8,}-[0-9a-f]{4,}-[0-9a-f]{4,}-[0-9a-f]{4,}-[0-9a-f]{12,}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::Detector",
        },
        "filter": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}/filter/{subresource_id}",
            "id_name": "FilterName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::Filter",
        },
        "ipset": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}/ipset/{subresource_id}",
            "id_name": "IpSetId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::IPSet",
        },
        "member": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}/member/{subresource_id}",
            "id_name": "MemberId",
            "id_regexp": "^[0-9a-zA-Z-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::Member",
        },
        "threatintelset": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}/threatintelset/{subresource_id}",
            "id_name": "ThreatIntelSetId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::ThreatIntelSet",
        },
    },
    "health": {
        "event": {
            "arn_format": "arn:{partition}:health:{region}:{account}:event/{resource_id}",
            "id_name": "EventArn",
            "id_regexp": "arn:[^:]+:health:[^:]+:[^:]+:event\/[0-9a-f-]+",
            "asff_name": "",
            "cloudformation": "AWS::Health::Event",
        },
        "health_check": {
            "arn_format": "arn:{partition}:health:{region}:{account}:healthcheck/{resource_id}",
            "id_name": "HealthCheckId",
            "id_regexp": "[0-9a-f-]{8}",
            "asff_name": "",
            "cloudformation": "AWS::Health::HealthCheck",
        },
        "organization_event_detail": {
            "arn_format": "arn:{partition}:health:{region}:{account}:event-organization/{event_type_code}/{service}/{event_type_version}/{event_id}",
            "id_name": "EventArn",
            "id_regexp": "arn:[^:]+:health:[^:]+:[^:]+:event\/[0-9a-f-]+",
            "asff_name": "",
            "cloudformation": "AWS::Health::OrganizationEventDetail",
        },
        "service": {
            "arn_format": "arn:{partition}:health:{region}:{account}:service/{resource_id}",
            "id_name": "Service",
            "id_regexp": "[a-zA-Z0-9_-]{1,64}",
            "asff_name": "",
            "cloudformation": "AWS::Health::Service",
        },
    },
    "iam": {
        "access_key": {
            "arn_format": "arn:{partition}:iam::{account}:accesskey/{resource_id}",
            "id_name": "AccessKeyId",
            "id_regexp": "^[A-Z0-9]{16}$",
            "asff_name": "AwsIamAccessKey",
            "cloudformation": "AWS::IAM::AccessKey",
        },
        "account_alias": {
            "arn_format": "arn:{partition}:iam::{account}:alias/{resource_id}",
            "id_name": "AccountAlias",
            "id_regexp": "^[a-z0-9][a-z0-9.-]{0,62}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::AccountAlias",
        },
        "group": {
            "arn_format": "arn:{partition}:iam::{account}:group/{resource_id}",
            "id_name": "GroupName",
            "id_regexp": "^[a-zA-Z0-9+=,.@_-]{1,128}$",
            "asff_name": "AwsIamGroup",
            "cloudformation": "AWS::IAM::Group",
        },
        "instance_profile": {
            "arn_format": "arn:{partition}:iam::{account}:instance-profile/{resource_id}",
            "id_name": "InstanceProfileName",
            "id_regexp": "^[a-zA-Z0-9_/+=.@-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::InstanceProfile",
        },
        "policy": {
            "arn_format": "arn:{partition}:iam::{account}:policy/{resource_id}",
            "id_name": "PolicyName",
            "id_regexp": "^[a-zA-Z0-9+=,.@-_]{1,128}$",
            "asff_name": "AwsIamPolicy",
            "cloudformation": "AWS::IAM::Policy",
        },
        "role": {
            "arn_format": "arn:{partition}:iam::{account}:role/{resource_id}",
            "id_name": "RoleName",
            "id_regexp": "^[a-zA-Z_][a-zA-Z0-9_=@,.+-]{1,63}$",
            "asff_name": "AwsIamRole",
            "cloudformation": "AWS::IAM::Role",
        },
        "server_certificate": {
            "arn_format": "arn:{partition}:iam::{account}:server-certificate/{resource_id}",
            "id_name": "ServerCertificateName",
            "id_regexp": "^[a-zA-Z0-9_/+=.@-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::ServerCertificate",
        },
        "user": {
            "arn_format": "arn:{partition}:iam::{account}:user/{resource_id}",
            "id_name": "UserName",
            "id_regexp": "^[a-zA-Z0-9_+=,.@-]{1,128}$",
            "asff_name": "AwsIamUser",
            "cloudformation": "AWS::IAM::User",
        },
        "virtual_mfa_device": {
            "arn_format": "arn:{partition}:iam::{account}:mfa/{resource_id}",
            "id_name": "VirtualMFADeviceName",
            "id_regexp": "^[\\w+=,.@-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::VirtualMFADevice",
        },
        "group_policy": {
            "arn_format": "arn:{partition}:iam::{account}:group/{group_id}/policy/{policy_id}",
            "id_name": ["GroupName", "PolicyName"],
            "id_regexp": ["^[\\w+=,.@-]{1,128}$", "^[\\w+=,.@-]{1,128}$"],
            "asff_name": "",
            "cloudformation": "AWS::IAM::Policy",
        },
        "role_policy": {
            "arn_format": "arn:{partition}:iam::{account}:role/{role_id}/policy/{policy_id}",
            "id_name": ["RoleName", "PolicyName"],
            "id_regexp": ["^[\\w+=,.@-]{1,64}$", "^[\\w+=,.@-]{1,128}$"],
            "asff_name": "",
            "cloudformation": "AWS::IAM::Policy",
        },
        "user_policy": {
            "arn_format": "arn:{partition}:iam::{account}:user/{user_id}/policy/{policy_id}",
            "id_name": ["UserName", "PolicyName"],
            "id_regexp": ["^[\\w+=,.@-]{1,64}$", "^[\\w+=,.@-]{1,128}$"],
            "asff_name": "",
            "cloudformation": "AWS::IAM::Policy",
        },
    },
    "imagebuilder": {
        "component": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:component/{resource_id}",
            "id_name": "ComponentBuildVersionArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:component/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::Component",
        },
        "distribution_configuration": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:distribution-configuration/{resource_id}",
            "id_name": "DistributionConfigurationArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:distribution-configuration/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::DistributionConfiguration",
        },
        "image": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:image/{resource_id}",
            "id_name": "ImageBuildVersionArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:image/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::Image",
        },
        "image_pipeline": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:image-pipeline/{resource_id}",
            "id_name": "ImagePipelineArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:image-pipeline/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::ImagePipeline",
        },
        "infrastructure_configuration": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:infrastructure-configuration/{resource_id}",
            "id_name": "InfrastructureConfigurationArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:infrastructure-configuration/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::InfrastructureConfiguration",
        },
    },
    "inspector": {
        "assessment_target": {
            "arn_format": "arn:{partition}:inspector:{region}:{account}:target/{resource_id}",
            "id_name": "AssessmentTargetArn",
            "id_regexp": "^arn:aws:inspector:[a-z]{2}-[a-z]+-[0-9]:[0-9]{12}:target/[a-zA-Z0-9_-]{36}$",
            "asff_name": "",
            "cloudformation": "AWS::Inspector::AssessmentTarget",
        },
        "assessment_template": {
            "arn_format": "arn:{partition}:inspector:{region}:{account}:template/{resource_id}",
            "id_name": "AssessmentTemplateArn",
            "id_regexp": "^arn:aws:inspector:[a-z]{2}-[a-z]+-[0-9]:[0-9]{12}:template/[a-zA-Z0-9_-]{36}$",
            "asff_name": "",
            "cloudformation": "AWS::Inspector::AssessmentTemplate",
        },
        "assessment_run": {
            "arn_format": "arn:{partition}:inspector:{region}:{account}:run/{resource_id}",
            "id_name": "AssessmentRunArn",
            "id_regexp": "^arn:aws:inspector:[a-z]{2}-[a-z]+-[0-9]:[0-9]{12}:run/[a-zA-Z0-9_-]{36}$",
            "asff_name": "",
            "cloudformation": "AWS::Inspector::AssessmentRun",
        },
    },
    "iot": {
        "authorizer": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:authorizer/${AuthorizerName}",
            "id_name": "AuthorizerName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Authorizer",
        },
        "billing_group": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:billinggroup/${BillingGroupName}",
            "id_name": "BillingGroupName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::BillingGroup",
        },
        "certificate": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:cert/${CertificateId}",
            "id_name": "CertificateId",
            "id_regexp": "^([a-f0-9]){64}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Certificate",
        },
        "dimension": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:dimension/${DimensionName}",
            "id_name": "DimensionName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Dimension",
        },
        "policy": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:policy/${PolicyName}",
            "id_name": "PolicyName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Policy",
        },
        "provisioning_template": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:provisioningtemplate/${TemplateName}",
            "id_name": "TemplateName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::ProvisioningTemplate",
        },
        "rule": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:rule/${RuleName}",
            "id_name": "RuleName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::TopicRule",
        },
        "scheduled_audit": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:scheduledaudit/${ScheduledAuditName}",
            "id_name": "ScheduledAuditName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::ScheduledAudit",
        },
        "thing": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:thing/{resource_id}",
            "id_name": "ThingName",
            "id_regexp": "^[a-zA-Z0-9_-]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Thing",
        },
        "thing_group": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:thinggroup/{resource_id}",
            "id_name": "ThingGroupName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::ThingGroup",
        },
        "thing_type": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:thingtype/{resource_id}",
            "id_name": "ThingTypeName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::ThingType",
        },
        "topic_rule_destination": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:topic-rule-destination/{resource_id}",
            "id_name": "TopicRuleDestinationName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::TopicRuleDestination",
        },
        "topic_rule": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:rule/{resource_id}",
            "id_name": "RuleName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::TopicRule",
        },
        "domain_configuration": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:domainconfiguration/{resource_id}",
            "id_name": "DomainConfigurationName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::DomainConfiguration",
        },
        "fleet_indexing_configuration": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:fleet-indexing-configuration/{resource_id}",
            "id_name": "IndexingConfigurationName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::FleetIndexingConfiguration",
        },
        "job": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:job/{resource_id}",
            "id_name": "JobId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Job",
        },
    },
    "iot-device-tester": {
        "test_suite_run": {
            "arn_format": "arn:{partition}:iot-device-tester:{region}:{account}:test-suite-run:${SuiteDefinitionId}/{resource_id}",
            "id_name": "SuiteRunId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTDeviceTester::TestSuiteRun",
        }
    },
    "iot1click-projects": {
            "device": {
        "arn_format": "arn:{partition}:iot1click:{region}:{account}:device/{resource_id}",
        "id_name": "DeviceId",
        "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
        "asff_name": "",
        "cloudformation": "AWS::IoT1Click::Device",
    },
    "placement": {
        "arn_format": "arn:{partition}:iot1click:{region}:{account}:placement/{resource_id}",
        "id_name": "PlacementName",
        "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
        "asff_name": "",
        "cloudformation": "AWS::IoT1Click::Placement",
    },
    "project": {
        "arn_format": "arn:{partition}:iot1click:{region}:{account}:project/{resource_id}",
        "id_name": "ProjectName",
        "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
        "asff_name": "",
        "cloudformation": "AWS::IoT1Click::Project",
    },
    },
    "iotanalytics": {
        "channel": {
            "arn_format": "arn:{partition}:iotanalytics:{region}:{account}:channel/{resource_id}",
            "id_name": "ChannelName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoTAnalytics::Channel",
        },
        "dataset": {
            "arn_format": "arn:{partition}:iotanalytics:{region}:{account}:dataset/{resource_id}",
            "id_name": "DatasetName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoTAnalytics::Dataset",
        },
        "datastore": {
            "arn_format": "arn:{partition}:iotanalytics:{region}:{account}:datastore/{resource_id}",
            "id_name": "DatastoreName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoTAnalytics::Datastore",
        },
        "pipeline": {
            "arn_format": "arn:{partition}:iotanalytics:{region}:{account}:pipeline/{resource_id}",
            "id_name": "PipelineName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoTAnalytics::Pipeline",
        },
    },
    "iotevents": {
        "input": {
            "arn_format": "arn:{partition}:iotevents:{region}:{account}:input/{resource_id}",
            "id_name": "InputName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTEvents::Input",
        },
        "detector_model": {
            "arn_format": "arn:{partition}:iotevents:{region}:{account}:detector-model/{resource_id}",
            "id_name": "DetectorModelName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTEvents::DetectorModel",
        },
    },
    "iotsitewise": {
        "asset_model": {
            "arn_format": "arn:{partition}:iotsitewise:{region}:{account}:asset-model/{resource_id}",
            "id_name": "AssetModelId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTSiteWise::AssetModel",
        },
        "gateway": {
            "arn_format": "arn:{partition}:iotsitewise:{region}:{account}:gateway/{resource_id}",
            "id_name": "GatewayId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTSiteWise::Gateway",
        },
    },
    "kafka": {
        "cluster": {
            "arn_format": "arn:{partition}:kafka:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MSK::Cluster",
        }
    },
    "kinesis": {
        "stream": {
            "arn_format": "arn:{partition}:kinesis:{region}:{account}:stream/{resource_id}",
            "id_name": "StreamName",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,128}$",
            "asff_name": "AwsKinesisStream",
            "cloudformation": "AWS::Kinesis::Stream",
        },
        "firehose_delivery_stream": {
            "arn_format": "arn:{partition}:firehose:{region}:{account}:deliverystream/{resource_id}",
            "id_name": "DeliveryStreamName",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Firehose::DeliveryStream",
        },
    },
    "kinesis-video-archived-media": {
        "archive": {
            "arn_format": "arn:{partition}:kinesisvideo:{region}:{account}:archive/{stream_id}/{archive_id}",
            "id_name": "ArchiveId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::KinesisVideo::Stream/Archive",
        },
        "stream": {
            "arn_format": "arn:{partition}:kinesisvideo:{region}:{account}:stream/{stream_id}/{stream_arn}",
            "id_name": "StreamARN",
            "id_regexp": "^arn:aws:kinesisvideo:[a-z0-9-]+:[0-9]+:stream/[a-zA-Z0-9_.-]{1,256}/[0-9]+/[0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::KinesisVideo::Stream",
        },
    },
    "kinesis-video-media": {
        "stream": {
            "arn_format": "arn:{partition}:kinesisvideo:{region}:{account}:stream/{stream_id}/{stream_arn}",
            "id_name": "StreamARN",
            "id_regexp": "^arn:aws:kinesisvideo:[a-z0-9-]+:[0-9]+:stream/[a-zA-Z0-9_.-]{1,256}/[0-9]+/[0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::KinesisVideo::Stream",
        }
    },
    "kinesis-video-signaling": {
        "channel": {
            "arn_format": "arn:{partition}:kinesisvideo:{region}:{account}:channel/{channel_name}/{channel_arn}",
            "id_name": "ChannelARN",
            "id_regexp": "^arn:aws:kinesisvideo:[a-z0-9-]+:[0-9]+:channel/[a-zA-Z0-9_.-]{1,256}/[0-9]+/[0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::KinesisVideo::Channel",
        }
    },
    "kms": {
        "key": {
            "arn_format": "arn:{partition}:kms:{region}:{account}:key/{resource_id}",
            "id_name": "KeyId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "AwsKmsKey",
            "cloudformation": "AWS::KMS::Key",
        },
        "alias": {
            "arn_format": "arn:{partition}:kms:{region}:{account}:alias/{resource_id}",
            "id_name": "AliasName",
            "id_regexp": "^alias/[a-zA-Z0-9:/_-]{1,256}$",
            "asff_name": "",
            "cloudformation": "AWS::KMS::Alias",
        },
    },
    "lakeformation": {
        "data_lake_settings": {
            "arn_format": "arn:{partition}:lakeformation:{region}:{account}:datalake/{resource_id}/settings",
            "id_name": "DataLakeId",
            "id_regexp": "^[a-zA-Z0-9-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::LakeFormation::DataLakeSettings",
        },
        "permissions": {
            "arn_format": "arn:{partition}:lakeformation:{region}:{account}:permissions/{resource_id}",
            "id_name": "ResourceId",
            "id_regexp": "^[a-zA-Z0-9-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::LakeFormation::Permissions",
        },
    },
    "lambda": {
        "function": {
            "arn_format": "arn:{partition}:lambda:{region}:{account}:function:{resource_id}",
            "id_name": "FunctionName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,140}$",
            "asff_name": "AwsLambdaFunction",
            "cloudformation": "AWS::Lambda::Function",
        },
        "layer": {
            "arn_format": "arn:{partition}:lambda:{region}:{account}:layer:{resource_id}",
            "id_name": "LayerName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,140}$",
            "asff_name": "AwsLambdaLayerVersion",
            "cloudformation": "AWS::Lambda::LayerVersion",
        },
        "event_source_mapping": {
            "arn_format": "arn:{partition}:lambda:{region}:{account}:event-source-mapping:{resource_id}",
            "id_name": "UUID",
            "id_regexp": "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Lambda::EventSourceMapping",
        },
        "event_invoke_config": {
            "arn_format": "arn:{partition}:lambda:{region}:{account}:event-invoke-config:{resource_id}",
            "id_name": "UUID",
            "id_regexp": "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Lambda::EventInvokeConfig",
        },
    },
    "lex": {
        "bot": {
            "arn_format": "arn:{partition}:lex:{region}:{account}:bot:{resource_id}",
            "id_name": "BotName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,50}$",
            "asff_name": "",
            "cloudformation": "AWS::Lex::Bot",
        },
        "bot_alias": {
            "arn_format": "arn:{partition}:lex:{region}:{account}:bot:{BotName}:alias:{resource_id}",
            "id_name": "BotAlias",
            "id_regexp": "^[a-zA-Z0-9_-]{1,50}$",
            "asff_name": "",
            "cloudformation": "AWS::Lex::BotAlias",
        },
        "bot_channel": {
            "arn_format": "arn:{partition}:lex:{region}:{account}:bot-channel:{BotName}:{BotAlias}:{ChannelName}",
            "id_name": "ChannelName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,50}$",
            "asff_name": "",
            "cloudformation": "AWS::Lex::BotChannel",
        },
    },
    "license-manager": {
        "license_configuration": {
            "arn_format": "arn:{partition}:license-manager:{region}:{account}:license-configuration/{resource_id}",
            "id_name": "LicenseConfigurationId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,100}$",
            "asff_name": "",
            "cloudformation": "AWS::LicenseManager::LicenseConfiguration",
        }
    },
    "lightsail": {
        "instance": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:instance/{resource_id}",
            "id_name": "InstanceName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::Instance",
        },
        "key_pair": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:key-pair/{resource_id}",
            "id_name": "KeyName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::KeyPair",
        },
        "static_ip": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:static-ip/{resource_id}",
            "id_name": "StaticIpName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::StaticIp",
        },
        "load_balancer": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:loadbalancer/{resource_id}",
            "id_name": "LoadBalancerName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::LoadBalancer",
        },
        "bucket": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:bucket/{resource_id}",
            "id_name": "BucketName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::Bucket",
        },
    },
    "logs": {
        "log_group": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:log-group:{resource_id}",
            "id_name": "LogGroupName",
            "id_regexp": "^[a-zA-Z0-9._/-]{1,512}$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::LogGroup",
        },
        "log_stream": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:log-group:{LogGroupName}:log-stream:{resource_id}",
            "id_name": "LogStreamName",
            "id_regexp": "^[^:*]*$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::LogStream",
        },
        "metric_filter": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:metric-filter:{resource_id}",
            "id_name": "MetricFilterName",
            "id_regexp": "^[a-zA-Z0-9._/-]{1,512}$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::MetricFilter",
        },
        "destination": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:destination:{resource_id}",
            "id_name": "DestinationName",
            "id_regexp": "^[a-zA-Z0-9._/-]{1,512}$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::Destination",
        },
        "query_definition": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:query-definition:{resource_id}",
            "id_name": "QueryDefinitionName",
            "id_regexp": "^[a-zA-Z0-9._/-]{1,512}$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::QueryDefinition",
        },
    },
    "machinelearning": {
        "batch_prediction": {
            "arn_format": "arn:{partition}:machinelearning:{region}:{account}:batchprediction/{resource_id}",
            "id_name": "BatchPredictionId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MachineLearning::BatchPrediction",
        },
        "data_source": {
            "arn_format": "arn:{partition}:machinelearning:{region}:{account}:datasource/{resource_id}",
            "id_name": "DataSourceId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MachineLearning::DataSource",
        },
        "evaluation": {
            "arn_format": "arn:{partition}:machinelearning:{region}:{account}:evaluation/{resource_id}",
            "id_name": "EvaluationId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MachineLearning::Evaluation",
        },
        "ml_model": {
            "arn_format": "arn:{partition}:machinelearning:{region}:{account}:mlmodel/{resource_id}",
            "id_name": "MLModelId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MachineLearning::MLModel",
        },
    },
    "macie": {
        "classification_job": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:classification-job/{resource_id}",
            "id_name": "ClassificationJobId",
            "id_regexp": "^[a-f0-9]{32}$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::ClassificationJob",
        },
        "custom_data_identifier": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:custom-data-identifier/{resource_id}",
            "id_name": "CustomDataIdentifierId",
            "id_regexp": "^[a-f0-9]{32}$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::CustomDataIdentifier",
        },
        "findings_filter": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:findings-filter/{resource_id}",
            "id_name": "FindingsFilterId",
            "id_regexp": "^[a-f0-9]{32}$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::FindingsFilter",
        },
        "member_account": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:member-account/{resource_id}",
            "id_name": "MemberAccountId",
            "id_regexp": "^\\d{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::MemberAccount",
        },
        "s3_object": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:s3-object/{resource_id}",
            "id_name": "S3BucketName/S3ObjectKey",
            "id_regexp": "^[^/]{1,255}/.*$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::S3Object",
        },
    },
    "managedblockchain": {
        "network": {
            "arn_format": "arn:{partition}:managedblockchain:{region}:{account}:network/${NetworkId}",
            "id_name": "NetworkId",
            "id_regexp": "^[a-zA-Z0-9]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::ManagedBlockchain::Network",
        },
        "node": {
            "arn_format": "arn:{partition}:managedblockchain:{region}:{account}:node/${NetworkId}/${MemberId}/${NodeId}",
            "id_name": "NodeId",
            "id_regexp": "^[a-zA-Z0-9]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::ManagedBlockchain::Node",
        },
        "proposal": {
            "arn_format": "arn:{partition}:managedblockchain:{region}:{account}:proposal/${NetworkId}/${ProposalId}",
            "id_name": "ProposalId",
            "id_regexp": "^[a-zA-Z0-9]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::ManagedBlockchain::Proposal",
        },
    },
    "mediaconnect": {
        "flow": {
            "arn_format": "arn:{partition}:mediaconnect:{region}:{account}:flow/{resource_id}",
            "id_name": "FlowArn",
            "id_regexp": "^arn:aws:mediaconnect:[^:]+:[^:]+:[0-9]+:[^/]+/[^/]+$",
            "asff_name": "",
            "cloudformation": "AWS::MediaConnect::Flow",
        }
    },
    "mediaconvert": {
        "queue": {
            "arn_format": "arn:{partition}:mediaconvert:{region}:{account}:queue/{resource_id}",
            "id_name": "QueueName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaConvert::Queue",
        },
        "preset": {
            "arn_format": "arn:{partition}:mediaconvert:{region}:{account}:preset/{resource_id}",
            "id_name": "PresetName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaConvert::Preset",
        },
        "job_template": {
            "arn_format": "arn:{partition}:mediaconvert:{region}:{account}:jobTemplate/{resource_id}",
            "id_name": "JobTemplateName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaConvert::JobTemplate",
        },
    },
    "medialive": {
        "channel": {
            "arn_format": "arn:{partition}:medialive:{region}:{account}:channel:{resource_id}",
            "id_name": "ChannelId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaLive::Channel",
        }
    },
    "mediapackage": {
        "channel": {
            "arn_format": "arn:{partition}:mediapackage:{region}:{account}:channel/{resource_id}",
            "id_name": "ChannelId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaPackage::Channel",
        },
        "origin_endpoint": {
            "arn_format": "arn:{partition}:mediapackage:{region}:{account}:origin_endpoint/{resource_id}",
            "id_name": "OriginEndpointId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaPackage::OriginEndpoint",
        },
    },
    "mediastore": {
        "container": {
            "arn_format": "arn:{partition}:mediastore:{region}:{account}:container/{resource_id}",
            "id_name": "ContainerName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaStore::Container",
        }
    },
    "mediastore-data": {
        "object": {
            "arn_format": "arn:{partition}:mediastore-data:{region}:{account}:object/{resource_id}",
            "id_name": "Path",
            "id_regexp": "^.{1,1024}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaStore::Object",
        }
    },
    "meteringmarketplace": {
        "product": {
            "arn_format": "arn:{partition}:meteringmarketplace:{region}:{account}:product/{resource_id}",
            "id_name": "ProductCode",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::Marketplace::Product",
        },
        "usage_record": {
            "arn_format": "arn:{partition}:meteringmarketplace:{region}:{account}:usage-record:{resource_id}",
            "id_name": "ProductCode",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::Marketplace::UsageRecord",
        },
    },
    "mgh": {
        "home_region_control": {
            "arn_format": "arn:{partition}:mgh:{region}:{account}:homeRegionControl/{resource_id}",
            "id_name": "HomeRegionControlId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MGH::HomeRegionControl",
        },
        "migration_task": {
            "arn_format": "arn:{partition}:mgh:{region}:{account}:migrationTask/{resource_id}",
            "id_name": "MigrationTaskName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,256}$",
            "asff_name": "",
            "cloudformation": "AWS::MGH::MigrationTask",
        },
        "progress_update_stream": {
            "arn_format": "arn:{partition}:mgh:{region}:{account}:progressUpdateStream/{resource_id}",
            "id_name": "ProgressUpdateStreamName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,256}$",
            "asff_name": "",
            "cloudformation": "AWS::MGH::ProgressUpdateStream",
        },
    },
    "mobilehub": {
        "project": {
            "arn_format": "arn:{partition}:mobilehub:{region}:{account}:project/{resource_id}",
            "id_name": "ProjectId",
            "id_regexp": "^[a-zA-Z0-9_.:-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::MobileHub::Project",
        }
    },
    "mq": {
        "broker": {
            "arn_format": "arn:{partition}:mq:{region}:{account}:broker:{resource_id}",
            "id_name": "BrokerId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,36}$",
            "asff_name": "",
            "cloudformation": "AWS::AmazonMQ::Broker",
        },
        "configuration": {
            "arn_format": "arn:{partition}:mq:{region}:{account}:configuration:{resource_id}",
            "id_name": "ConfigurationId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,36}$",
            "asff_name": "",
            "cloudformation": "AWS::AmazonMQ::Configuration",
        },
    },
    "mturk": {
        "hit_type": {
            "arn_format": "arn:{partition}:mturk:{region}:{account}:hittype/{resource_id}",
            "id_name": "HITTypeId",
            "id_regexp": "^[A-Z0-9A-Z]{10,}$",
            "asff_name": "",
            "cloudformation": "AWS::MTurk::HITType",
        },
        "hit": {
            "arn_format": "arn:{partition}:mturk:{region}:{account}:hit/{resource_id}",
            "id_name": "HITId",
            "id_regexp": "^[A-Z0-9A-Z]{30,}$",
            "asff_name": "",
            "cloudformation": "AWS::MTurk::HIT",
        },
        "qualification_type": {
            "arn_format": "arn:{partition}:mturk:{region}:{account}:qualificationtype/{resource_id}",
            "id_name": "QualificationTypeId",
            "id_regexp": "^[A-Z0-9A-Z]{10,}$",
            "asff_name": "",
            "cloudformation": "AWS::MTurk::QualificationType",
        },
    },
    "neptune-db": {
        "cluster": {
            "arn_format": "arn:{partition}:neptune-db:{region}:{account}:cluster:{resource_id}",
            "id_name": "ClusterResourceId",
            "id_regexp": "^neptune-[^:]*:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Neptune::DBCluster",
        }
    },
    "network-firewall": {
        "firewall_policy": {
            "arn_format": "arn:{partition}:network-firewall:{region}:{account}:policy/{resource_id}",
            "id_name": "FirewallPolicyName",
            "id_regexp": "^[a-zA-Z0-9-]{1,128}$",
            "asff_name": "AwsNetworkFirewallFirewallPolicy",
            "cloudformation": "AWS::NetworkFirewall::FirewallPolicy",
        },
        "firewall": {
            "arn_format": "arn:{partition}:network-firewall:{region}:{account}:firewall/{resource_id}",
            "id_name": "FirewallName",
            "id_regexp": "^[a-zA-Z0-9-]{1,128}$",
            "asff_name": "AwsNetworkFirewallFirewall",
            "cloudformation": "AWS::NetworkFirewall::Firewall",
        },
        "rule_group": {
            "arn_format": "arn:{partition}:network-firewall:{region}:{account}:rulegroup/{resource_id}",
            "id_name": "RuleGroupName",
            "id_regexp": "^[a-zA-Z0-9-]{1,128}$",
            "asff_name": "AwsNetworkFirewallRuleGroup",
            "cloudformation": "AWS::NetworkFirewall::RuleGroup",
        },
    },
    "networkmanager": {
        "global_network": {
            "arn_format": "arn:{partition}:networkmanager:{region}:{account}:global-network/{resource_id}",
            "id_name": "GlobalNetworkId",
            "id_regexp": "^[a-zA-Z0-9\\-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::NetworkManager::GlobalNetwork",
        },
        "device": {
            "arn_format": "arn:{partition}:networkmanager:{region}:{account}:device/{resource_id}",
            "id_name": "DeviceId",
            "id_regexp": "^[a-zA-Z0-9\\-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::NetworkManager::Device",
        },
        "link": {
            "arn_format": "arn:{partition}:networkmanager:{region}:{account}:link/{resource_id}",
            "id_name": "LinkId",
            "id_regexp": "^[a-zA-Z0-9\\-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::NetworkManager::Link",
        },
        "site": {
            "arn_format": "arn:{partition}:networkmanager:{region}:{account}:site/{resource_id}",
            "id_name": "SiteId",
            "id_regexp": "^[a-zA-Z0-9\\-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::NetworkManager::Site",
        },
    },
    "opensearch": {
        "domain": {
            "arn_format": "arn:{partition}:opensearch:{region}:{account}:domain/{resource_id}",
            "id_name": "DomainId",
            "id_regexp": "^[a-zA-Z0-9][a-zA-Z0-9\\-]{2,28}[a-zA-Z0-9]$",
            "asff_name": "AwsOpenSearchServiceDomain",
            "cloudformation": "AWS::OpenSearchService::Domain",
        },
    },
    "opsworks": {
        "stack": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:stack/{resource_id}",
            "id_name": "StackId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Stack",
        },
        "layer": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:layer/{resource_id}",
            "id_name": "LayerId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Layer",
        },
        "app": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:app/{resource_id}",
            "id_name": "AppId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::App",
        },
        "instance": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:instance/{resource_id}",
            "id_name": "InstanceId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Instance",
        },
        "user_profile": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:user-profile/{resource_id}",
            "id_name": "UserProfileId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::UserProfile",
        },
        "permission": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:permission/{resource_id}",
            "id_name": "PermissionId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Permission",
        },
        "deployment": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:deployment/{resource_id}",
            "id_name": "DeploymentId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Deployment",
        },
    },
    "organizations": {
        "organization": {
            "arn_format": "arn:{partition}:organizations::{account}:organization/{resource_id}",
            "id_name": "OrganizationId",
            "id_regexp": "^o-[a-z0-9]{10,32}$",
            "asff_name": "",
            "cloudformation": "AWS::Organizations::Organization",
        },
        "account": {
            "arn_format": "arn:{partition}:organizations::{account}:account/{resource_id}",
            "id_name": "AccountId",
            "id_regexp": "^[0-9]{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Organizations::Account",
        },
        "organizational_unit": {
            "arn_format": "arn:{partition}:organizations::{account}:ou/{resource_id}",
            "id_name": "OrganizationalUnitId",
            "id_regexp": "^ou-[a-z0-9]{4,32}-[a-z0-9]{8,32}$",
            "asff_name": "",
            "cloudformation": "AWS::Organizations::OrganizationalUnit",
        },
    },
    "outposts": {
        "outpost": {
            "arn_format": "arn:{partition}:outposts:{region}:{account}:outpost/{resource_id}",
            "id_name": "OutpostId",
            "id_regexp": "^[a-zA-Z0-9_\\-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Outposts::Outpost",
        }
    },
    "personalize": {
        "dataset_group": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:dataset-group/{resource_id}",
            "id_name": "DatasetGroupId",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::DatasetGroup",
        },
        "dataset": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:dataset/{dataset_group_arn}/dataset/{resource_id}",
            "id_name": "DatasetArn",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::Dataset",
        },
        "solution": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:solution/{resource_id}",
            "id_name": "SolutionArn",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::Solution",
        },
        "campaign": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:campaign/{resource_id}",
            "id_name": "CampaignArn",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::Campaign",
        },
        "event_tracker": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:event-tracker/{resource_id}",
            "id_name": "EventTrackerArn",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::EventTracker",
        },
    },
    "pi": {
        "dimension": {
            "arn_format": "arn:{partition}:pi:{region}:{account}:dimension:${resource_id}",
            "id_name": "DimensionName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::PI::Dimension",
        }
    },
    "pinpoint": {
        "app": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/${resource_id}",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::App",
        },
        "adm_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/${ApplicationId}/channels/adm",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::ADMChannel",
        },
        "apns_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/${ApplicationId}/channels/apns",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::APNSChannel",
        },
        "apns_sandbox_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/${ApplicationId}/channels/apns_sandbox",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::APNSSandboxChannel",
        },
        "baidu_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/${ApplicationId}/channels/baidu",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::BaiduChannel",
        },
        "email_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/${ApplicationId}/channels/email",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::EmailChannel",
        },
        "gcm_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/${ApplicationId}/channels/gcm",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::GCMChannel",
        },
        "sms_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/${ApplicationId}/channels/sms}",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::SMSChannel",
        },
    },
    "polly": {
        "lexicon": {
            "arn_format": "arn:{partition}:polly:{region}:{account}:lexicon/{resource_id}",
            "id_name": "LexiconName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::Polly::Lexicon",
        }
    },
    "qldb": {
        "ledger": {
            "arn_format": "arn:{partition}:qldb:{region}:{account}:ledger/${resource_id}",
            "id_name": "LedgerName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::QLDB::Ledger",
        }
    },
    "quickSight": {
        "group": {
            "arn_format": "arn:{partition}:quicksight:{region}:{account}:group/{resource_id}",
            "id_name": "GroupName",
            "id_regexp": "^[a-zA-Z0-9._-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::QuickSight::Group",
        },
        "user": {
            "arn_format": "arn:{partition}:quicksight:{region}:{account}:user/{resource_id}",
            "id_name": "UserName",
            "id_regexp": "^[a-zA-Z0-9._-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::QuickSight::User",
        },
    },
    "ram": {
        "resource_share": {
            "arn_format": "arn:{partition}:ram:{region}:{account}:resource-share/${resource_id}",
            "id_name": "ResourceShareName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::RAM::ResourceShare",
        },
        "resource_share_invitation": {
            "arn_format": "arn:{partition}:ram:{region}:{account}:resource-share-invitation/${resource_id}",
            "id_name": "ResourceShareInvitationId",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::RAM::ResourceShareInvitation",
        },
    },
    "rds": {
        "db_instance": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:db:{resource_id}",
            "id_name": "DBInstanceIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbInstance",
            "cloudformation": "AWS::RDS::DBInstance",
        },
        "db_snapshot": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:snapshot:{resource_id}",
            "id_name": "DBSnapshotIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbSnapshot",
            "cloudformation": "AWS::RDS::DBSnapshot",
        },
        "db_cluster": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:cluster:{resource_id}",
            "id_name": "DBClusterIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbCluster",
            "cloudformation": "AWS::RDS::DBCluster",
        },
        "db_cluster_snapshot": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:cluster-snapshot:{resource_id}",
            "id_name": "DBClusterSnapshotIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbClusterSnapshot",
            "cloudformation": "AWS::RDS::DBClusterSnapshot",
        },
        "option_group": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:og:{resource_id}",
            "id_name": "OptionGroupName",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::RDS::OptionGroup",
        },
        "parameter_group": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:pg:{resource_id}",
            "id_name": "DBParameterGroupName",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::RDS::DBParameterGroup",
        },
        "security_group": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:secgrp:{resource_id}",
            "id_name": "DBSecurityGroupName",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbSecurityGroup",
            "cloudformation": "AWS::RDS::DBSecurityGroup",
        },
        "subgroup": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:sub-group:{resource_id}",
            "id_name": "DBSubnetGroupName",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::RDS::DBSubnetGroup",
        },
        "event_subscription": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:es:{resource_id}",
            "id_name": "EventSubscriptionName",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "AwsRdsEventSubscription",
            "cloudformation": "AWS::RDS::EventSubscription",
        },
        "global_cluster": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:global-cluster:${resource_id}",
            "id_name": "GlobalClusterIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::RDS::GlobalCluster",
        },
    },
    "rds-data": {
        "secret": {
            "arn_format": "arn:{partition}:secretsmanager:{region}:{account}:secret:{resource_id}",
            "id_name": "SecretId",
            "id_regexp": "^[-0-9a-zA-Z:_/]+$",
            "asff_name": "",
            "cloudformation": "AWS::SecretsManager::Secret",
        }
    },
        "redshift": {
            "cluster": {
                "arn_format": "arn:{partition}:redshift:{region}:{account}:cluster:${resource_id}",
                "id_name": "ClusterName",
                "id_regexp": "^([a-z0-9][a-z0-9-]*[a-z0-9]|[a-z0-9])$",
                "asff_name": "AwsRedshiftCluster",
                "cloudformation": "AWS::Redshift::Cluster",
            },
            "snapshot": {
                "arn_format": "arn:{partition}:redshift:{region}:{account}:snapshot:${resource_id}",
                "id_name": "SnapshotName",
                "id_regexp": "^([a-z0-9][a-z0-9-]*[a-z0-9]|[a-z0-9])$",
                "asff_name": "",
                "cloudformation": "AWS::Redshift::Snapshot",
            },
        },
        "rekognition": {
            "collection": {
                "arn_format": "arn:{partition}:rekognition:{region}:{account}:collection/${resource_id}",
                "id_name": "CollectionId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::Rekognition::Collection",
            },
            "stream_processor": {
                "arn_format": "arn:{partition}:rekognition:{region}:{account}:stream-processor/${resource_id}",
                "id_name": "StreamProcessorName",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::Rekognition::StreamProcessor",
            },
        },
        "resource-groups": {
            "group": {
                "arn_format": "arn:{partition}:resource-groups:{region}:{account}:group/${resource_id}",
                "id_name": "GroupName",
                "id_regexp": "^[a-zA-Z0-9._\\-]+$",
                "asff_name": "",
                "cloudformation": "AWS::ResourceGroups::Group",
            }
        },
        "robomaker": {
            "robot_application": {
                "arn_format": "arn:{partition}:robomaker:{region}:{account}:robot-application/${ApplicationName}/${ApplicationVersion}",
                "id_name": "ApplicationName",
                "id_regexp": "^[a-zA-Z0-9-_]{1,127}$",
                "asff_name": "",
                "cloudformation": "AWS::RoboMaker::RobotApplication",
            },
            "simulation_application": {
                "arn_format": "arn:{partition}:robomaker:{region}:{account}:simulation-application/${ApplicationName}/${ApplicationVersion}",
                "id_name": "ApplicationName",
                "id_regexp": "^[a-zA-Z0-9-_]{1,127}$",
                "asff_name": "",
                "cloudformation": "AWS::RoboMaker::SimulationApplication",
            },
            "robot": {
                "arn_format": "arn:{partition}:robomaker:{region}:{account}:robot/${RobotName}",
                "id_name": "RobotName",
                "id_regexp": "^[a-zA-Z0-9-_]{1,127}$",
                "asff_name": "",
                "cloudformation": "AWS::RoboMaker::Robot",
            },
            "simulation_job": {
                "arn_format": "arn:{partition}:robomaker:{region}:{account}:simulation-job/${SimulationJobArn}",
                "id_name": "SimulationJobArn",
                "id_regexp": "^arn:[a-zA-Z0-9-]+:robomaker:[a-z]{2}(-gov)?-[a-z]+-\\d+:[a-z0-9]{12}:simulation-job:[a-zA-Z0-9-_]{1,128}(/\\d+)?$",
                "asff_name": "",
                "cloudformation": "AWS::RoboMaker::SimulationJob",
            },
            "fleet": {
                "arn_format": "arn:{partition}:robomaker:{region}:{account}:fleet/${FleetName}",
                "id_name": "FleetName",
                "id_regexp": "^[a-zA-Z0-9-_]{1,127}$",
                "asff_name": "",
                "cloudformation": "AWS::RoboMaker::Fleet",
            },
        },
        "route53": {
            "health_check": {
                "arn_format": "arn:{partition}:route53:::healthcheck/{resource_id}",
                "id_name": "HealthCheckId",
                "id_regexp": "^[a-zA-Z0-9]+$",
                "asff_name": "",
                "cloudformation": "AWS::Route53::HealthCheck",
            },
            "hosted_zone": {
                "arn_format": "arn:{partition}:route53:::hostedzone/{resource_id}",
                "id_name": "HostedZoneId",
                "id_regexp": "^Z[a-zA-Z0-9]+$",
                "asff_name": "",
                "cloudformation": "AWS::Route53::HostedZone",
            },
            "vpc_association_authorization": {
                "arn_format": "arn:{partition}:route53:::vpc/{region}:{account}:authorizevpcassociation/{resource_id}/{vpc_id}",
                "id_name": ["HostedZoneId"],
                "id_regexp": "^vpc-[a-z0-9]+$",
                "asff_name": "",
                "cloudformation": "AWS::Route53::VPCAssociationAuthorization",
            },
            "resolver_endpoint": {
                "arn_format": "arn:{partition}:route53resolver:{region}:{account}:resolver-endpoint/{resource_id}",
                "id_name": "ResolverEndpointId",
                "id_regexp": "^rslv-[a-z0-9]{17}$",
                "asff_name": "",
                "cloudformation": "AWS::Route53Resolver::ResolverEndpoint",
            },
            "resolver_rule": {
                "arn_format": "arn:{partition}:route53resolver:{region}:{account}:resolver-rule/{resource_id}",
                "id_name": "ResolverRuleId",
                "id_regexp": "^rslvrule-[a-z0-9]{17}$",
                "asff_name": "",
                "cloudformation": "AWS::Route53Resolver::ResolverRule",
            },
            "resolver_rule_association": {
                "arn_format": "arn:{partition}:route53resolver:{region}:{account}:resolver-rule-association/{resource_id}",
                "id_name": "ResolverRuleAssociationId",
                "id_regexp": "^rslvrassoc-[a-z0-9]{17}$",
                "asff_name": "",
                "cloudformation": "AWS::Route53Resolver::ResolverRuleAssociation",
            },
        },
        "s3": {
            "bucket": {
                "arn_format": "arn:{partition}:s3:::{resource_id}",
                "id_name": "BucketName",
                "id_regexp": "^[a-z0-9.-]{3,63}$",
                "asff_name": "AwsS3Bucket",
                "cloudformation": "AWS::S3::Bucket",
            },
            "object": {
                "arn_format": "arn:{partition}:s3:::{bucket}/{resource_id}",
                "id_name": "ObjectName",
                "id_regexp": ".+",
                "asff_name": "AwsS3Object",
                "cloudformation": "AWS::S3::Object",
            },
        },
        "s3-object-lambda": {
            "access_point": {
                "arn_format": "arn:{partition}:s3-object-lambda:{region}:{account}:accesspoint/${resource_id}",
                "id_name": "AccessPointName",
                "id_regexp": "^[a-zA-Z0-9\\.\\-_]{1,64}$",
                "asff_name": "",
                "cloudformation": "AWS::S3ObjectLambda::AccessPoint",
            },
            "access_point_policy": {
                "arn_format": "arn:{partition}:s3-object-lambda:{region}:{account}:accesspoint-policy/${resource_id}",
                "id_name": "AccessPointName",
                "id_regexp": "^[a-zA-Z0-9\\.\\-_]{1,64}$",
                "asff_name": "",
                "cloudformation": "AWS::S3ObjectLambda::AccessPointPolicy",
            },
            "access_point_configuration": {
                "arn_format": "arn:{partition}:s3-object-lambda:{region}:{account}:accesspoint/${resource_id}/configuration",
                "id_name": "AccessPointName",
                "id_regexp": "^[a-zA-Z0-9\\.\\-_]{1,64}$",
                "asff_name": "",
                "cloudformation": "AWS::S3ObjectLambda::AccessPointConfiguration",
            },
        },
        "sagemaker": {
            "notebook_instance": {
                "arn_format": "arn:{partition}:sagemaker:{region}:{account}:notebook-instance/${resource_id}",
                "id_name": "NotebookInstanceName",
                "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
                "asff_name": "AwsSageMakerNotebookInstance",
                "cloudformation": "AWS::SageMaker::NotebookInstance",
            },
            "notebook_instance_lifecycle_configuration": {
                "arn_format": "arn:{partition}:sagemaker:{region}:{account}:notebook-instance-lifecycle-config/${resource_id}",
                "id_name": "NotebookInstanceLifecycleConfigName",
                "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
                "asff_name": "",
                "cloudformation": "AWS::SageMaker::NotebookInstanceLifecycleConfig",
            },
            "training_job": {
                "arn_format": "arn:{partition}:sagemaker:{region}:{account}:training-job/${resource_id}",
                "id_name": "TrainingJobName",
                "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
                "asff_name": "",
                "cloudformation": "AWS::SageMaker::TrainingJob",
            },
            "processing_job": {
                "arn_format": "arn:{partition}:sagemaker:{region}:{account}:processing-job/${resource_id}",
                "id_name": "ProcessingJobName",
                "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
                "asff_name": "",
                "cloudformation": "AWS::SageMaker::ProcessingJob",
            },
            "transform_job": {
                "arn_format": "arn:{partition}:sagemaker:{region}:{account}:transform-job/${resource_id}",
                "id_name": "TransformJobName",
                "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
                "asff_name": "",
                "cloudformation": "AWS::SageMaker::TransformJob",
            },
            "model": {
                "arn_format": "arn:{partition}:sagemaker:{region}:{account}:model/${resource_id}",
                "id_name": "ModelName",
                "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
                "asff_name": "",
                "cloudformation": "AWS::SageMaker::Model",
            },
            "endpoint_config": {
                "arn_format": "arn:{partition}:sagemaker:{region}:{account}:endpoint-config/${resource_id}",
                "id_name": "EndpointConfigName",
                "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
                "asff_name": "",
                "cloudformation": "AWS::SageMaker::EndpointConfig",
            },
            "endpoint": {
                "arn_format": "arn:{partition}:sagemaker:{region}:{account}:endpoint/${resource_id}",
                "id_name": "EndpointName",
                "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
                "asff_name": "",
                "cloudformation": "AWS::SageMaker::Endpoint",
            },
            "feature_group": {
                "arn_format": "arn:{partition}:sagemaker:{region}:{account}:feature-group/${resource_id}",
                "id_name": "FeatureGroupName",
                "id_regexp": "^[a-zA-Z0-9]([a-zA-Z0-9_-]{0,62}[a-zA-Z0-9])?$",
                "asff_name": "",
                "cloudformation": "AWS::SageMaker::FeatureGroup",
            },
        },
        "sdb": {
            "domain": {
                "arn_format": "arn:{partition}:sdb:{region}:{account}:domain/${resource_id}",
                "id_name": "DomainName",
                "id_regexp": "^[a-zA-Z0-9_.-]{3,255}$",
                "asff_name": "",
                "cloudformation": "AWS::SDB::Domain",
            }
        },
        "secretsmanager": {
            "secret": {
                "arn_format": "arn:{partition}:secretsmanager:{region}:{account}:secret:${resource_id}",
                "id_name": "SecretId",
                "id_regexp": "^[a-zA-Z0-9/_+=.@-]{1,64}$",
                "asff_name": "AwsSecretsManagerSecret",
                "cloudformation": "AWS::SecretsManager::Secret",
            }
        },
        "securityhub": {
            "hub": {
                "arn_format": "arn:{partition}:securityhub:{region}:{account}:hub/default",
                "id_name": "none",
                "id_regexp": "",
                "asff_name": "",
                "cloudformation": "AWS::SecurityHub::Hub",
            },
            "product_subscription": {
                "arn_format": "arn:{partition}:securityhub:{region}:{account}:subscription/${resource_id}",
                "id_name": "SubscriptionId",
                "id_regexp": "^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$",
                "asff_name": "",
                "cloudformation": "AWS::SecurityHub::ProductSubscription",
            },
        },
        "serverlessrepo": {
            "application": {
                "arn_format": "arn:{partition}:serverlessrepo:{region}:{account}:applications/${resource_id}",
                "id_name": "ApplicationId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::ServerlessRepo::Application",
            }
        },
        "servicecatalog": {
            "product": {
                "arn_format": "arn:{partition}:catalog:{region}:{account}:product/${resource_id}",
                "id_name": "ProductId",
                "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
                "asff_name": "",
                "cloudformation": "AWS::ServiceCatalog::CloudFormationProduct",
            },
            "portfolio": {
                "arn_format": "arn:{partition}:catalog:{region}:{account}:portfolio/${resource_id}",
                "id_name": "PortfolioId",
                "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
                "asff_name": "",
                "cloudformation": "AWS::ServiceCatalog::CloudFormationProduct",
            },
            "portfolio_share": {
                "arn_format": "arn:{partition}:catalog:{region}:{account}:share/${resource_id}",
                "id_name": "ShareId",
                "id_regexp": "^[a-f0-9]{64}$",
                "asff_name": "",
                "cloudformation": "AWS::ServiceCatalog::CloudFormationProduct",
            },
            "cloudformation_stack_set_constraint": {
                "arn_format": "arn:{partition}:cloudformation:{region}:{account}:stack-set/${StackSetName}:constraint/${resource_id}",
                "id_name": "ConstraintId",
                "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
                "asff_name": "",
                "cloudformation": "AWS::ServiceCatalog::CloudFormationStackSetConstraint",
            },
        },
        "servicediscovery": {
            "namespace": {
                "arn_format": "arn:{partition}:servicediscovery:{region}:{account}:namespace/${resource_id}",
                "id_name": "NamespaceId",
                "id_regexp": "^[a-zA-Z0-9_]+$",
                "asff_name": "",
                "cloudformation": "AWS::ServiceDiscovery::Namespace",
            },
            "service": {
                "arn_format": "arn:{partition}:servicediscovery:{region}:{account}:service/${resource_id}",
                "id_name": "ServiceId",
                "id_regexp": "^[a-zA-Z0-9_]+$",
                "asff_name": "",
                "cloudformation": "AWS::ServiceDiscovery::Service",
            },
        },
        "ses": {
            "configuration_set": {
                "arn_format": "arn:{partition}:ses:{region}:{account}:configuration-set/${resource_id}",
                "id_name": "ConfigurationSetName",
                "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
                "asff_name": "",
                "cloudformation": "AWS::SES::ConfigurationSet",
            }
        },
        "shield": {
            "protection": {
                "arn_format": "arn:{partition}:shield::{account}:protection/${resource_id}",
                "id_name": "ProtectionId",
                "id_regexp": "^[a-zA-Z0-9_/-]{1,36}$",
                "asff_name": "",
                "cloudformation": "AWS::Shield::Protection",
            }
        },
        "signer": {
            "signing_profile": {
                "arn_format": "arn:{partition}:signer:{region}:{account}:signing-profiles/${resource_id}",
                "id_name": "SigningProfileName",
                "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
                "asff_name": "",
                "cloudformation": "AWS::Signer::SigningProfile",
            }
        },
        "sms": {
            "app": {
                "arn_format": "arn:{partition}:sms:{region}:{account}:app/${resource_id}",
                "id_name": "AppId",
                "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
                "asff_name": "",
                "cloudformation": "AWS::SMS::App",
            },
            "server": {
                "arn_format": "arn:{partition}:sms:{region}:{account}:server/${resource_id}",
                "id_name": "ServerId",
                "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
                "asff_name": "",
                "cloudformation": "AWS::SMS::Server",
            },
            "replication_job": {
                "arn_format": "arn:{partition}:sms:{region}:{account}:replication-job/${resource_id}",
                "id_name": "ReplicationJobId",
                "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
                "asff_name": "",
                "cloudformation": "AWS::SMS::ReplicationJob",
            },
        },
        "snowball": {
            "job": {
                "arn_format": "arn:{partition}:snowball:{region}:{account}:job/${JobId}",
                "id_name": "JobId",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "",
                "cloudformation": "AWS::Snowball::Job",
            }
        },
        "sns": {
            "topic": {
                "arn_format": "arn:{partition}:sns:{region}:{account}:${TopicName}",
                "id_name": "TopicName",
                "id_regexp": "^[a-zA-Z0-9-_]{1,256}$",
                "asff_name": "AwsSnsTopic",
                "cloudformation": "AWS::SNS::Topic",
            },
            "subscription": {
                "arn_format": "arn:{partition}:sns:{region}:{account}:${TopicName}:${SubscriptionId}",
                "id_name": "SubscriptionId",
                "id_regexp": "^[a-zA-Z0-9-_]{1,256}$",
                "asff_name": "",
                "cloudformation": "AWS::SNS::Subscription",
            },
            "platform_application_endpoint": {
                "arn_format": "arn:{partition}:sns:{region}:{account}:app/${PlatformApplicationArn}/${EndpointId}",
                "id_name": "EndpointId",
                "id_regexp": "^[a-zA-Z0-9-_]{1,256}$",
                "asff_name": "",
                "cloudformation": "AWS::SNS::Endpoint",
            },
        },
        "sqs": {
            "queue": {
                "arn_format": "arn:{partition}:sqs:{region}:{account}:${QueueName}",
                "id_name": "QueueName",
                "id_regexp": "^[a-zA-Z0-9_-]{1,80}$",
                "asff_name": "AwsSqsQueue",
                "cloudformation": "AWS::SQS::Queue",
            }
        },
        "ssm": {
            "document": {
                "arn_format": "arn:{partition}:ssm:{region}:{account}:document/${DocumentName}",
                "id_name": "DocumentName",
                "id_regexp": "^[a-zA-Z0-9_/+.-]{3,128}$",
                "asff_name": "",
                "cloudformation": "AWS::SSM::Document",
            },
            "parameter": {
                "arn_format": "arn:{partition}:ssm:{region}:{account}:parameter/${ParameterName}",
                "id_name": "ParameterName",
                "id_regexp": "^[a-zA-Z0-9_/+.-]{1,2048}$",
                "asff_name": "",
                "cloudformation": "AWS::SSM::Parameter",
            },
            "maintenance_window": {
                "arn_format": "arn:{partition}:ssm:{region}:{account}:maintenancewindow/${WindowId}",
                "id_name": "WindowId",
                "id_regexp": "^[a-zA-Z0-9_-]{20,40}$",
                "asff_name": "",
                "cloudformation": "AWS::SSM::MaintenanceWindow",
            },
            "maintenance_window_task": {
                "arn_format": "arn:{partition}:ssm:{region}:{account}:maintenancewindow/${WindowId}/task/${WindowTaskId}",
                "id_name": "WindowTaskId",
                "id_regexp": "^[a-zA-Z0-9_-]{20,40}$",
                "asff_name": "",
                "cloudformation": "AWS::SSM::MaintenanceWindowTask",
            },
            "patch_baseline": {
                "arn_format": "arn:{partition}:ssm:{region}:{account}:patchbaseline/${BaselineId}",
                "id_name": "BaselineId",
                "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
                "asff_name": "AwsSsmPatchCompliance",
                "cloudformation": "AWS::SSM::PatchBaseline",
            },
        },
        "sso": {
            "instance": {
                "arn_format": "arn:{partition}:sso:{region}:{account}:instance/${resource_id}",
                "id_name": "InstanceId",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "",
                "cloudformation": "AWS::SSO::Instance",
            },
            "permission_set": {
                "arn_format": "arn:{partition}:sso:{region}:{account}:permissionSet/${resource_id}",
                "id_name": "PermissionSetId",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "",
                "cloudformation": "AWS::SSO::PermissionSet",
            },
        },
        "sso-directory": {
            "directory": {
                "arn_format": "arn:{partition}:sso-directory:{region}:{account}:directory/${resource_id}",
                "id_name": "DirectoryId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::SSO::Directory",
            }
        },
        "stepfunctions": {
            "state_machine": {
                "arn_format": "arn:{partition}:states:{region}:{account}:stateMachine:${resource_id}",
                "id_name": "StateMachineName",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::StepFunctions::StateMachine",
            }
        },
        "storagegateway": {
            "gateway": {
                "arn_format": "arn:{partition}:storagegateway:{region}:{account}:gateway/${resource_id}",
                "id_name": "GatewayId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::StorageGateway::Gateway",
            },
            "share": {
                "arn_format": "arn:{partition}:storagegateway:{region}:{account}:share/${resource_id}",
                "id_name": "ShareId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::StorageGateway::NFSFileShare",
            },
            "tape": {
                "arn_format": "arn:{partition}:storagegateway:{region}:{account}:tape/${resource_id}",
                "id_name": "TapeARN",
                "id_regexp": "^[a-zA-Z0-9-:/_\\.\\(\\)]+$",
                "asff_name": "",
                "cloudformation": "AWS::StorageGateway::Tape",
            },
            "volume": {
                "arn_format": "arn:{partition}:storagegateway:{region}:{account}:gateway/${gateway_id}/volume/${volume_id}",
                "id_name": "VolumeId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::StorageGateway::StorediSCSIVolume",
            },
        },
        "sts": {
            "assumed_role": {
                "arn_format": "arn:{partition}:sts::{account}:assumed-role/${resource_name}/${resource_id}",
                "id_name": "RoleSessionName",
                "id_regexp": "^[\\w+=,.@-]+$",
                "asff_name": "",
                "cloudformation": "AWS::STS::AssumedRole",
            },
            "federated_user": {
                "arn_format": "arn:{partition}:sts::{account}:federated-user/${resource_id}",
                "id_name": "UserName",
                "id_regexp": "^[\\w+=,.@-]+$",
                "asff_name": "",
                "cloudformation": "AWS::STS::FederatedUser",
            },
            "oidc_provider": {
                "arn_format": "arn:{partition}:iam::{account}:oidc-provider/${resource_id}",
                "id_name": "Url",
                "id_regexp": "^(https|http)://.*$",
                "asff_name": "",
                "cloudformation": "AWS::IAM::OpenIDConnectProvider",
            },
            "saml_provider": {
                "arn_format": "arn:{partition}:iam::{account}:saml-provider/${resource_id}",
                "id_name": "Name",
                "id_regexp": "^[\\w+=,.@-]+$",
                "asff_name": "",
                "cloudformation": "AWS::IAM::SAMLProvider",
            },
        },
        "swf": {
            "domain": {
                "arn_format": "arn:{partition}:swf:{region}:{account}:domain/${resource_id}",
                "id_name": "DomainName",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::SWF::Domain",
            },
            "workflow_type": {
                "arn_format": "arn:{partition}:swf:{region}:{account}:workflowType/${DomainName}/${resource_id}",
                "id_name": "WorkflowTypeName",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::SWF::WorkflowType",
            },
            "activity_type": {
                "arn_format": "arn:{partition}:swf:{region}:{account}:activityType/${DomainName}/${resource_id}",
                "id_name": "ActivityTypeName",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::SWF::ActivityType",
            },
            "workflow_execution": {
                "arn_format": "arn:{partition}:swf:{region}:{account}:workflow/${DomainName}/${WorkflowType}:${resource_id}",
                "id_name": "WorkflowExecutionId",
                "id_regexp": "^[-a-zA-Z0-9_]+(?:\\.[-a-zA-Z0-9_]+)*$",
                "asff_name": "",
                "cloudformation": "AWS::SWF::WorkflowExecution",
            },
            "activity_execution": {
                "arn_format": "arn:{partition}:swf:{region}:{account}:activity/${DomainName}/${ActivityType}:${resource_id}",
                "id_name": "ActivityId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::SWF::ActivityTask",
            },
        },
        "synthetics": {
            "canary": {
                "arn_format": "arn:{partition}:synthetics:{region}:{account}:canary:${resource_id}",
                "id_name": "CanaryName",
                "id_regexp": "^[a-zA-Z0-9_-]{1,63}$",
                "asff_name": "",
                "cloudformation": "AWS::Synthetics::Canary",
            },
            "canary_run": {
                "arn_format": "arn:{partition}:synthetics:{region}:{account}:canary:${CanaryName}:run:${resource_id}",
                "id_name": "CanaryRunId",
                "id_regexp": "^[a-zA-Z0-9_-]{1,63}$",
                "asff_name": "",
                "cloudformation": "AWS::Synthetics::CanaryRun",
            },
        },
        "textract": {
            "document": {
                "arn_format": "arn:{partition}:textract:{region}:{account}:document/${resource_id}",
                "id_name": "DocumentId",
                "id_regexp": "^[a-f0-9]{32}$",
                "asff_name": "",
                "cloudformation": "AWS::Textract::Document",
            }
        },
        "transcribe": {
            "vocabulary": {
                "arn_format": "arn:{partition}:transcribe:{region}:{account}:vocabulary/${resource_id}",
                "id_name": "VocabularyName",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::Transcribe::Vocabulary",
            }
        },
        "transfer": {
            "server": {
                "arn_format": "arn:{partition}:transfer:{region}:{account}:server/${resource_id}",
                "id_name": "ServerId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::Transfer::Server",
            },
            "user": {
                "arn_format": "arn:{partition}:transfer:{region}:{account}:user/${ServerId}/${resource_id}",
                "id_name": "UserName",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::Transfer::User",
            },
        },
        "translate": {
            "terminology": {
                "arn_format": "arn:{partition}:translate:{region}:{account}:terminology/${resource_id}",
                "id_name": "TerminologyName",
                "id_regexp": "^[a-zA-Z0-9\\-\\_]+$",
                "asff_name": "",
                "cloudformation": "AWS::Translate::Terminology",
            }
        },
        "waf": {
            "ipset": {
                "arn_format": "arn:{partition}:waf:{region}:{account}:ipset/${resource_id}",
                "id_name": "IpSetId",
                "id_regexp": "^[a-zA-Z0-9]+$",
                "asff_name": "",
                "cloudformation": "AWS::WAF::IPSet",
            },
            "rule": {
                "arn_format": "arn:{partition}:waf:{region}:{account}:rule/${resource_id}",
                "id_name": "RuleId",
                "id_regexp": "^[a-zA-Z0-9]+$",
                "asff_name": "AwsWafRule",
                "cloudformation": "AWS::WAF::Rule",
            },
            "rule_group": {
                "arn_format": "arn:{partition}:waf::{account}:rulegroup/${resource_name}/${resource_id}",
                "id_name": "RuleGroupId",
                "id_regexp": "^[a-zA-Z0-9]+$",
                "asff_name": "AwsWafRuleGroup",
                "cloudformation": "AWS::WAF::RuleGroup",
            },
            "web_acl": {
                "arn_format": "arn:{partition}:waf:{region}:{account}:webacl/${resource_id}",
                "id_name": "WebACLId",
                "id_regexp": "^[a-zA-Z0-9]+$",
                "asff_name": "AwsWafWebAcl",
                "cloudformation": "AWS::WAF::WebACL",
            },
            "global_web_acl": {
                "arn_format": "arn:{partition}:waf::{account}:global-webacl/${resource_name}/${resource_id}",
                "id_name": "WebACLId",
                "id_regexp": "^[a-zA-Z0-9]+$",
                "asff_name": "",
                "cloudformation": "AWS::WAFv2::WebACL",
            },
            "rate_based_rule": {
                "arn_format": "arn:{partition}:waf::{account}:ratebasedrule/${resource_name}/${resource_id}",
                "id_name": "RuleId",
                "id_regexp": "^[a-zA-Z0-9]+$",
                "asff_name": "AwsWafRateBasedRule",
                "cloudformation": "AWS::WAF::RateBasedRule",
            },
        },
        "waf-regional": {
            "ipset": {
                "arn_format": "arn:{partition}:waf-regional:{region}:{account}:ipset/${resource_id}",
                "id_name": "IpSetId",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "",
                "cloudformation": "AWS::WAF::IPSet",
            },
            "regional_rule": {
                "arn_format": "arn:{partition}:waf-regional:{region}:{account}:rule/${resource_id}",
                "id_name": "RuleId",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "AwsWafRegionalRule",
                "cloudformation": "AWS::WAF::Rule",
            },
            "regional_web_acl": {
                "arn_format": "arn:{partition}:waf-regional:{region}:{account}:webacl/${resource_id}",
                "id_name": "WebACLId",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "AwsWafRegionalWebAcl",
                "cloudformation": "AWS::WAF::WebACL",
            },
            "regional_rule_group": {
                "arn_format": "arn:{partition}:waf-regional:{region}:{account}:rulegroup/${RuleGroupName}/${resource_id}",
                "id_name": "RuleGroupId",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "AwsWafRegionalRuleGroup",
                "cloudformation": "AWS::WAF::RuleGroup",
            },
            "regional_rate_based_rule": {
                "arn_format": "arn:{partition}:waf-regional:{region}:{account}:rule/${resource_id}",
                "id_name": "RuleId",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "AwsWafRegionalRateBasedRule",
                "cloudformation": "AWS::WAF::RateBasedRule",
            },
        },
        "wafv2": {
            "ip_set": {
                "arn_format": "arn:{partition}:wafv2:{region}:{account}:/ipset/${resource_scope}/${resource_id}",
                "id_name": "Id",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "",
                "cloudformation": "AWS::WAFv2::IPSet",
            },
            "rule_group": {
                "arn_format": "arn:{partition}:wafv2:{region}:{account}:/rulegroup/${resource_scope}/${resource_id}",
                "id_name": "Id",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "AwsWafv2RuleGroup",
                "cloudformation": "AWS::WAFv2::RuleGroup",
            },
            "web_acl": {
                "arn_format": "arn:{partition}:wafv2:{region}:{account}:/webacl/${resource_scope}/${resource_id}",
                "id_name": "Id",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "AwsWafv2WebAcl",
                "cloudformation": "AWS::WAFv2::WebACL",
            },
        },
        "wellarchitected": {
            "workload": {
                "arn_format": "arn:{partition}:wellarchitected:{region}:{account}:workload/${resource_id}",
                "id_name": "WorkloadId",
                "id_regexp": "^[a-zA-Z0-9-]+$",
                "asff_name": "",
                "cloudformation": "AWS::WellArchitected::Workload",
            }
        },
        "workdocs": {
            "document": {
                "arn_format": "arn:{partition}:workdocs:{region}:{account}:${FolderHierarchy}/${resource_id}",
                "id_name": "DocumentName",
                "id_regexp": "^[a-zA-Z0-9-_.()]+$",
                "asff_name": "",
                "cloudformation": "AWS::WorkDocs::Document",
            },
            "folder": {
                "arn_format": "arn:{partition}:workdocs:{region}:{account}:${FolderHierarchy}/${resource_id}",
                "id_name": "FolderName",
                "id_regexp": "^[a-zA-Z0-9-_.()]+$",
                "asff_name": "",
                "cloudformation": "AWS::WorkDocs::Folder",
            },
            "user": {
                "arn_format": "arn:{partition}:workdocs:{region}:{account}:user/${resource_id}",
                "id_name": "UserId",
                "id_regexp": "^[a-zA-Z0-9_-]+$",
                "asff_name": "",
                "cloudformation": "AWS::WorkDocs::User",
            },
        },
        "worklink": {
            "fleet": {
                "arn_format": "arn:{partition}:worklink:{region}:{account}:fleet/${resource_id}",
                "id_name": "FleetArnName",
                "id_regexp": "^.+$",
                "asff_name": "",
                "cloudformation": "AWS::WorkLink::Fleet",
            },
            "website_certificate_authority_association": {
                "arn_format": "arn:{partition}:worklink:{region}:{account}:website-certificate-authority-association/${resource_id}",
                "id_name": "WebsiteCertificateAuthorityAssociationId",
                "id_regexp": "^[a-zA-Z0-9]+$",
                "asff_name": "",
                "cloudformation": "AWS::WorkLink::WebsiteCertificateAuthorityAssociation",
            },
        },
        "workmail": {
            "organization": {
                "arn_format": "arn:{partition}:workmail:{region}:{account}:organization/${resource_id}",
                "id_name": "OrganizationId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::WorkMail::Organization",
            },
            "resource": {
                "arn_format": "arn:{partition}:workmail:{region}:{account}:resource/${resource_id}",
                "id_name": "ResourceId",
                "id_regexp": "^[a-zA-Z0-9-_]+$",
                "asff_name": "",
                "cloudformation": "AWS::WorkMail::Resource",
            },
            "user": {
                "arn_format": "arn:{partition}:workmail:{region}:{account}:user/${resource_id}",
                "id_name": "UserId",
                "id_regexp": "^[a-zA-Z0-9-_@.]+$",
                "asff_name": "",
                "cloudformation": "AWS::WorkMail::User",
            },
        },
        "workspaces": {
            "directory": {
                "arn_format": "arn:{partition}:workspaces:{region}:{account}:directory/${resource_id}",
                "id_name": "DirectoryId",
                "id_regexp": "^[a-zA-Z0-9_-]{10,64}$",
                "asff_name": "",
                "cloudformation": "AWS::WorkSpaces::Directory",
            },
            "workspace": {
                "arn_format": "arn:{partition}:workspaces:{region}:{account}:workspace/${resource_id}",
                "id_name": "WorkspaceId",
                "id_regexp": "^[a-zA-Z0-9_-]{13,68}$",
                "asff_name": "",
                "cloudformation": "AWS::WorkSpaces::Workspace",
            },
        },
    }
