aws_arn_data = {
    "acm": {
        "certificate": {
            "arn_format": "arn:{partition}:acm:{region}:{account}:certificate/{resource_id}",
            "id_name": "CertificateId",
            "id_regexp": "([a-z0-9-]+)",
            "asff_name": "AwsCertificateManagerCertificate",
            "cloudformation": "AWS::CertificateManager::Certificate",
            "terraform": "aws_acm_certificate",
        }
    },
    "acm-pca": {
        "certificate_authority": {
            "arn_format": "arn:{partition}:acm-pca:{region}:{account}:certificate-authority/{resource_id}",
            "id_name": "CertificateAuthorityId",
            "id_regexp": "([a-z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ACMPCA::CertificateAuthority",
            "terraform": "aws_acm_certificate_authority",
        }
    },
    "alexaforbusiness": {
        "skill": {
            "arn_format": "arn:{partition}:aplb:{region}:{account}:skill/{resource_id}",
            "id_name": "SkillId",
            "id_regexp": "([a-zA-Z0-9_\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::AlexaForBusiness::Skill",
            "terraform": "aws_alexa_skill",
        }
    },
    "apigateway": {
        "api": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{resource_id}",
            "id_name": "ApiId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "AwsApiGatewayV2Api",
            "cloudformation": "AWS::ApiGateway::RestApi",
            "terraform": "aws_api_gateway_rest_api",
        },
        "api_key": {
            "arn_format": "arn:{partition}:apigateway:{region}::/apikeys/{resource_id}",
            "id_name": "ApiKeyId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::ApiKey",
            "terraform": "aws_api_gateway_api_key",
        },
        "authorizer": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/authorizers/{resource_id}",
            "id_name": "AuthorizerId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Authorizer",
            "terraform": "aws_api_gateway_authorizer",
        },
        "base_path_mapping": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/basepathmappings/{resource_id}",
            "id_name": "BasePathMappingId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::BasePathMapping",
            "terraform": "aws_api_gateway_base_path_mapping",
        },
        "client_certificate": {
            "arn_format": "arn:{partition}:apigateway:{region}::/clientcertificates/{resource_id}",
            "id_name": "ClientCertificateId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::ClientCertificate",
            "terraform": "aws_api_gateway_client_certificate",
        },
        "deployment": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/deployments/{resource_id}",
            "id_name": "DeploymentId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Deployment",
            "terraform": "aws_api_gateway_deployment",
        },
        "documentation_part": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/documentation/parts/{resource_id}",
            "id_name": "DocumentationPartId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::DocumentationPart",
            "terraform": "aws_api_gateway_documentation_part",
        },
        "documentation_version": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{api_id}/documentation/versions/{resource_id}",
            "id_name": "DocumentationVersion",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::DocumentationVersion",
            "terraform": "aws_api_gateway_documentation_version",
        },
        "domain_name": {
            "arn_format": "arn:{partition}:apigateway:{region}::/domainnames/{resource_id}",
            "id_name": "DomainName",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::DomainName",
            "terraform": "aws_api_gateway_domain_name",
        },
        "gateway_response": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/gatewayresponses/{resource_id}",
            "id_name": "GatewayResponseId",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::GatewayResponse",
            "terraform": "aws_api_gateway_gateway_response",
        },
        "integration": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/resources/{ResourceId}/methods/{HttpMethod}/integrations/{resource_id}",
            "id_name": "IntegrationId",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Integration",
            "terraform": "aws_api_gateway_integration",
        },
        "method": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/resources/{ResourceId}/methods/{resource_id}",
            "id_name": "HttpMethod",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Method",
            "terraform": "aws_api_gateway_method",
        },
        "model": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/models/{resource_id}",
            "id_name": "ModelName",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Model",
            "terraform": "aws_api_gateway_model",
        },
        "request_validator": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/requestvalidators/{resource_id}",
            "id_name": "RequestValidatorId",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::RequestValidator",
            "terraform": "aws_api_gateway_request_validator",
        },
        "resource": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{ApiId}/resources/{resource_id}",
            "id_name": "ResourceId",
            "id_regexp": "[a-zA-Z0-9\\.\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::Resource",
            "terraform": "aws_api_gateway_resource",
        },
        "rest_api": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{resource_id}",
            "id_name": "ApiId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::RestApi",
            "terraform": "aws_api_gateway_rest_api",
        },
        "stage": {
            "arn_format": "arn:{partition}:apigateway:{region}::/restapis/{rest_api_id}/stages/{resource_id}",
            "id_name": "StageName",
            "id_regexp": "[a-zA-Z0-9\\-_]+",
            "asff_name": "AwsApiGatewayV2Stage",
            "cloudformation": "AWS::ApiGateway::Stage",
            "terraform": "aws_api_gateway_stage",
        },
        "usage_plan": {
            "arn_format": "arn:{partition}:apigateway:{region}::/usageplans/{resource_id}",
            "id_name": "UsagePlanId",
            "id_regexp": "[a-zA-Z0-9\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::UsagePlan",
            "terraform": "aws_api_gateway_usage_plan",
        },
        "usage_plan_key": {
            "arn_format": "arn:{partition}:apigateway:{region}::/usageplans/{usage_plan_id}/keys/{resource_id}",
            "id_name": "KeyId",
            "id_regexp": "[a-zA-Z0-9-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::UsagePlanKey",
            "terraform": "aws_api_gateway_usage_plan_key",
        },
        "vpc_link": {
            "arn_format": "arn:{partition}:apigateway:{region}::/vpclinks/{resource_id}",
            "id_name": "VpcLinkId",
            "id_regexp": "[a-zA-Z0-9\\-_]+",
            "asff_name": "",
            "cloudformation": "AWS::ApiGateway::VpcLink",
            "terraform": "aws_api_gateway_vpc_link",
        },
    },
    "appflow": {
        "connector_profile": {
            "arn_format": "arn:{partition}:appflow:{region}:{account}:connectorprofile/{resource_id}",
            "id_name": "ConnectorProfileName",
            "id_regexp": "([a-zA-Z0-9-_]{1,256})",
            "asff_name": "",
            "cloudformation": "AWS::AppFlow::ConnectorProfile",
            "terraform": "aws_appflow_connector_profile",
        },
        "flow": {
            "arn_format": "arn:{partition}:appflow:{region}:{account}:flow/{resource_id}",
            "id_name": "FlowName",
            "id_regexp": "([a-zA-Z0-9-_]{1,256})",
            "asff_name": "",
            "cloudformation": "AWS::AppFlow::Flow",
            "terraform": "aws_appflow_flow",
        },
    },
    "appstream": {
        "directory_config": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:directoryconfig/{resource_id}",
            "id_name": "DirectoryConfigName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::DirectoryConfig",
            "terraform": "aws_appstream_directory_config",
        },
        "fleet": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:fleet/{resource_id}",
            "id_name": "FleetName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::Fleet",
            "terraform": "aws_appstream_fleet",
        },
        "image": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:image/{resource_id}",
            "id_name": "ImageName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::Image",
            "terraform": "aws_appstream_image",
        },
        "image_builder": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:imagebuilder/{resource_id}",
            "id_name": "ImageBuilderName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::ImageBuilder",
            "terraform": "aws_appstream_image_builder",
        },
        "stack": {
            "arn_format": "arn:{partition}:appstream:{region}:{account}:stack/{resource_id}",
            "id_name": "StackName",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::AppStream::Stack",
            "terraform": "aws_appstream_stack",
        },
    },
    "athena": {
        "workgroup": {
            "arn_format": "arn:{partition}:athena:{region}:{account}:workgroup/{resource_id}",
            "id_name": "WorkGroupName",
            "id_regexp": "([a-zA-Z0-9._-]+)",
            "asff_name": "",
            "cloudformation": "AWS::Athena::WorkGroup",
            "terraform": "aws_athena_workgroup",
        }
    },
    "augmentedairuntime": {
        "human_loop": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:human-loop/{resource_id}",
            "id_name": "HumanLoopName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::HumanTaskUi",
            "terraform": "aws_sagemaker_human_task_ui",
        }
    },
    "autoscaling": {
        "auto_scaling_group": {
            "arn_format": "arn:{partition}:autoscaling:{region}:{account}:autoScalingGroup/{resource_id}",
            "id_name": "AutoScalingGroupName",
            "id_regexp": "[a-zA-Z0-9-]{1,255}",
            "asff_name": "AwsAutoScalingAutoScalingGroup",
            "cloudformation": "AWS::AutoScaling::AutoScalingGroup",
            "terraform": "aws_autoscaling_group",
        },
        "launch_configuration": {
            "arn_format": "arn:{partition}:autoscaling:{region}:{account}:launchConfiguration/{resource_id}",
            "id_name": "LaunchConfigurationName",
            "id_regexp": "[a-zA-Z0-9-]{1,255}",
            "asff_name": "AwsAutoScalingLaunchConfiguration",
            "cloudformation": "AWS::AutoScaling::LaunchConfiguration",
            "terraform": "aws_launch_configuration",
        },
    },
    "backup": {
        "backup_plan": {
            "arn_format": "arn:{partition}:backup:{region}:{account}:backup-plan/{resource_id}",
            "id_name": "BackupPlanId",
            "id_regexp": "^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$",
            "asff_name": "AwsBackupBackupPlan",
            "cloudformation": "AWS::Backup::BackupPlan",
            "terraform": "aws_backup_plan",
        },
        "backup_vault": {
            "arn_format": "arn:{partition}:backup:{region}:{account}:backup-vault/{resource_id}",
            "id_name": "BackupVaultName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,50}$",
            "asff_name": "AwsBackupBackupVault",
            "cloudformation": "AWS::Backup::BackupVault",
            "terraform": "aws_backup_vault",
        },
        "recovery_plan": {
            "arn_format": "arn:{partition}:backup:{region}:{account}:recoveryplan/{resource_id}",
            "id_name": "RecoveryPlanName",
            "id_regexp": "^[a-zA-Z0-9\\-\\_\\.]+$",
            "asff_name": "AwsBackupRecoveryPoint",
            "cloudformation": "AWS::Backup::RecoveryPlan",
            "terraform": "aws_backup_recovery_point",
        },
    },
    "batch": {
        "compute_environment": {
            "arn_format": "arn:{partition}:batch:{region}:{account}:compute-environment/{resource_id}",
            "id_name": "ComputeEnvironmentName",
            "id_regexp": "[a-zA-Z0-9_-]+",
            "asff_name": "",
            "cloudformation": "AWS::Batch::ComputeEnvironment",
            "terraform": "aws_batch_compute_environment",
        },
        "job_definition": {
            "arn_format": "arn:{partition}:batch:{region}:{account}:job-definition/{resource_id}:{version}",
            "id_name": "JobDefinitionName",
            "version_name": "JobDefinitionVersion",
            "id_regexp": "[a-zA-Z0-9_-]+",
            "version_regexp": "[a-zA-Z0-9_-]+",
            "asff_name": "",
            "cloudformation": "AWS::Batch::JobDefinition",
            "terraform": "aws_batch_job_definition",
        },
        "job_queue": {
            "arn_format": "arn:{partition}:batch:{region}:{account}:job-queue/{resource_id}",
            "id_name": "JobQueueName",
            "id_regexp": "[a-zA-Z0-9_-]+",
            "asff_name": "",
            "cloudformation": "AWS::Batch::JobQueue",
            "terraform": "aws_batch_job_queue",
        },
    },
    "budgets": {
        "budget": {
            "arn_format": "arn:{partition}:budgets:{region}:{account}:budget/{resource_id}",
            "id_name": "BudgetName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::Budgets::Budget",
            "terraform": "aws_budgets_budget",
        }
    },
    "cloud9": {
        "environment": {
            "arn_format": "arn:{partition}:cloud9:{region}:{account}:environment:{resource_id}",
            "id_name": "EnvironmentId",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::Cloud9::EnvironmentEC2",
            "terraform": "aws_cloud9_environment_ec2",
        }
    },
    "cloudformation": {
        "change_set": {
            "arn_format": "arn:{partition}:cloudformation:{region}:{account}:changeSet/{resource_id}",
            "id_name": "ChangeSetId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CloudFormation::ChangeSet",
            "terraform": "aws_cloudformation_change_set",
        },
        "stack": {
            "arn_format": "arn:{partition}:cloudformation:{region}:{account}:stack/{resource_id}/{stack_id}",
            "id_name": "StackName",
            "id_regexp": "([a-zA-Z][-a-zA-Z0-9]*)",
            "asff_name": "AwsCloudFormationStack",
            "cloudformation": "AWS::CloudFormation::Stack",
            "terraform": "aws_cloudformation_stack",
        },
    },
    "cloudfront": {
        "distribution": {
            "arn_format": "arn:{partition}:cloudfront::{account}:distribution/{resource_id}",
            "id_name": "DistributionId",
            "id_regexp": "[A-Z0-9]+",
            "asff_name": "AwsCloudFrontDistribution",
            "cloudformation": "AWS::CloudFront::Distribution",
            "terraform": "aws_cloudfront_distribution",
        },
        "field_level_encryption_config": {
            "arn_format": "arn:{partition}:cloudfront::{account}:field-level-encryption-config/{resource_id}",
            "id_name": "FieldLevelEncryptionConfigId",
            "id_regexp": "[A-Z0-9]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudFront::FieldLevelEncryptionConfig",
            "terraform": "aws_cloudfront_field_level_encryption_config",
        },
        "field_level_encryption_profile": {
            "arn_format": "arn:{partition}:cloudfront::{account}:field-level-encryption-profile/{resource_id}",
            "id_name": "FieldLevelEncryptionProfileId",
            "id_regexp": "[A-Z0-9]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudFront::FieldLevelEncryptionProfile",
            "terraform": "aws_cloudfront_field_level_encryption_profile",
        },
        "realtime_log_config": {
            "arn_format": "arn:{partition}:cloudfront::{account}:realtime-log-config/{resource_id}",
            "id_name": "RealtimeLogConfigId",
            "id_regexp": "[A-Z0-9]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudFront::RealtimeLogConfig",
            "terraform": "aws_cloudfront_realtime_log_config",
        },
    },
    "cloudhsmv2": {
        "cluster": {
            "arn_format": "arn:{partition}:cloudhsmv2:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterId",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudHSMV2::Cluster",
            "terraform": "aws_cloudhsmv2_cluster",
        },
        "backup": {
            "arn_format": "arn:{partition}:cloudhsmv2:{region}:{account}:backup/{resource_id}",
            "id_name": "BackupId",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudHSMV2::Backup",
            "terraform": "aws_cloudhsmv2_backup",
        },
        "hsm": {
            "arn_format": "arn:{partition}:cloudhsmv2:{region}:{account}:cluster/{resource_id}/hsm/{hsm_id}",
            "id_name": "HsmId",
            "id_regexp": "[a-zA-Z0-9-]+",
            "asff_name": "",
            "cloudformation": "AWS::CloudHSMV2::Hsm",
            "terraform": "aws_cloudhsmv2_hsm",
        },
    },
    "cloudtrail": {
        "trail": {
            "arn_format": "arn:{partition}:cloudtrail:{region}:{account}:trail/{resource_id}",
            "id_name": "TrailName",
            "id_regexp": "[a-zA-Z0-9-_\\.]+",
            "asff_name": "AwsCloudTrailTrail",
            "cloudformation": "AWS::CloudTrail::Trail",
            "terraform": "aws_cloudtrail",
        }
    },
    "cloudwatch": {
        "alarm": {
            "arn_format": "arn:{partition}:cloudwatch:{region}:{account}:alarm:{resource_id}",
            "id_name": "AlarmName",
            "id_regexp": "^[a-zA-Z0-9\\-_]{1,255}$",
            "asff_name": "AwsCloudWatchAlarm",
            "cloudformation": "AWS::CloudWatch::Alarm",
            "terraform": "aws_cloudwatch_metric_alarm",
        },
        "dashboard": {
            "arn_format": "arn:{partition}:cloudwatch::{account}:dashboard/{resource_id}",
            "id_name": "DashboardName",
            "id_regexp": "^[a-zA-Z0-9-_ ]{3,255}$",
            "asff_name": "",
            "cloudformation": "AWS::CloudWatch::Dashboard",
            "terraform": "aws_cloudwatch_dashboard",
        },
    },
    "codeartifact": {
        "domain": {
            "arn_format": "arn:{partition}:codeartifact:{region}:{account}:domain/{resource_id}",
            "id_name": "DomainName",
            "id_regexp": "([a-zA-Z0-9._-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeArtifact::Domain",
            "terraform": "aws_codeartifact_domain",
        },
        "repository": {
            "arn_format": "arn:{partition}:codeartifact:{region}:{account}:repository/{domain_name}/{resource_id}",
            "id_name": "RepositoryName",
            "id_regexp": "([a-zA-Z0-9._-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeArtifact::Repository",
            "terraform": "aws_codeartifact_repository",
        },
        "package": {
            "arn_format": "arn:{partition}:codeartifact:{region}:{account}:repository/{domain_name}/{repository_name}/package/{package_format}/{resource_id}@{package_version}",
            "id_name": "PackageName",
            "id_regexp": "([a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeArtifact::Package",
            "terraform": "aws_codeartifact_package",
        },
    },
    "codebuild": {
        "project": {
            "arn_format": "arn:{partition}:codebuild:{region}:{account}:project/{resource_id}",
            "id_name": "ProjectName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "AwsCodeBuildProject",
            "cloudformation": "AWS::CodeBuild::Project",
            "terraform": "aws_codebuild_project",
        }
    },
    "codecommit": {
        "repository": {
            "arn_format": "arn:{partition}:codecommit:{region}:{account}:{resource_id}",
            "id_name": "RepositoryName",
            "id_regexp": "([a-zA-Z0-9_.-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeCommit::Repository",
            "terraform": "aws_codecommit_repository",
        }
    },
    "codedeploy": {
        "application": {
            "arn_format": "arn:{partition}:codedeploy:{region}:{account}:application:{resource_id}",
            "id_name": "ApplicationName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeDeploy::Application",
            "terraform": "aws_codedeploy_app",
        },
        "deployment_config": {
            "arn_format": "arn:{partition}:codedeploy:{region}:{account}:deploymentconfig:{resource_id}",
            "id_name": "DeploymentConfigName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeDeploy::DeploymentConfig",
            "terraform": "aws_codedeploy_deployment_config",
        },
        "deployment_group": {
            "arn_format": "arn:{partition}:codedeploy:{region}:{account}:deploymentgroup:{resource_id}",
            "id_name": "ApplicationName/DeploymentGroupName",
            "id_regexp": "([a-zA-Z0-9-_]+/[a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeDeploy::DeploymentGroup",
            "terraform": "aws_codedeploy_deployment_group",
        },
    },
    "codepipeline": {
        "pipeline": {
            "arn_format": "arn:{partition}:codepipeline:{region}:{account}:{resource_type}/{resource_id}",
            "id_name": "PipelineName",
            "id_regexp": "([a-zA-Z0-9_\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodePipeline::Pipeline",
            "terraform": "aws_codepipeline",
        }
    },
    "codestar-connections": {
        "connection": {
            "arn_format": "arn:{partition}:codestar-connections:{region}:{account}:connection/{resource_id}",
            "id_name": "ConnectionName",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeStarConnections::Connection",
            "terraform": "aws_codestarconnections_connection",
        }
    },
    "codestar-notifications": {
        "rule": {
            "arn_format": "arn:{partition}:codestar-notifications:{region}:{account}:notificationrule/{resource_id}",
            "id_name": "NotificationRuleId",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::CodeStarNotifications::NotificationRule",
            "terraform": "aws_codestarnotifications_notification_rule",
        }
    },
    "cognito-idp": {
        "identity_provider": {
            "arn_format": "arn:{partition}:cognito-idp:{region}:{account}:userpool/{user_pool_id}:identityprovider/{resource_id}",
            "id_name": "IdentityProviderName",
            "id_regexp": "([a-zA-Z0-9_\\.\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::Cognito::UserPoolIdentityProvider",
            "terraform": "aws_cognito_identity_provider",
        },
        "resource_server": {
            "arn_format": "arn:{partition}:cognito-idp:{region}:{account}:userpool/{user_pool_id}/resource-server/{resource_id}",
            "id_name": "ResourceServerIdentifier",
            "id_regexp": "([a-zA-Z0-9_\\.\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::Cognito::UserPoolResourceServer",
            "terraform": "aws_cognito_user_pool_resource_server",
        },
        "user_pool": {
            "arn_format": "arn:{partition}:cognito-idp:{region}:{account}:userpool/{resource_id}",
            "id_name": "UserPoolId",
            "id_regexp": "([a-zA-Z0-9_\\.\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::Cognito::UserPool",
            "terraform": "aws_cognito_user_pool",
        },
    },
    "comprehend": {
        "document_classifier": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:document-classifier/{resource_id}",
            "id_name": "DocumentClassifierName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::DocumentClassifier",
            "terraform": "aws_comprehend_document_classifier",
        },
        "entity_recognizer": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:entity-recognizer/{resource_id}",
            "id_name": "EntityRecognizerName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::EntityRecognizer",
            "terraform": "aws_comprehend_entity_recognizer",
        },
        "key_phrases_detection_job": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:key-phrases-detection-job/{resource_id}",
            "id_name": "KeyPhrasesDetectionJobName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::KeyPhrasesDetectionJob",
            "terraform": "aws_comprehend_key_phrases_detection_job",
        },
        "sentiment_detection_job": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:sentiment-detection-job/{resource_id}",
            "id_name": "SentimentDetectionJobName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::SentimentDetectionJob",
            "terraform": "aws_comprehend_sentiment_detection_job",
        },
        "topic_detection_job": {
            "arn_format": "arn:{partition}:comprehend:{region}:{account}:topic-detection-job/{resource_id}",
            "id_name": "TopicDetectionJobName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Comprehend::TopicDetectionJob",
            "terraform": "aws_comprehend_topic_detection_job",
        },
    },
    "compute-optimizer": {
        "recommendation_export_job": {
            "arn_format": "arn:{partition}:compute-optimizer:{region}:{account}:recommendation-export-job/{resource_id}",
            "id_name": "ExportJobId",
            "id_regexp": "([a-z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ComputeOptimizer::RecommendationExportJob",
            "terraform": "aws_compute_optimizer_export_destination",
        }
    },
    "config": {
        "aggregator": {
            "arn_format": "arn:{partition}:config:{region}:{account}:config-aggregator/{resource_id}",
            "id_name": "ConfigAggregatorName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::Aggregator",
            "terraform": "aws_config_configuration_aggregator",
        },
        "conformance_pack": {
            "arn_format": "arn:{partition}:config:{region}:{account}:conformance-pack/{resource_id}",
            "id_name": "ConformancePackName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::ConformancePack",
            "terraform": "aws_config_conformance_pack",
        },
        "config_rule": {
            "arn_format": "arn:{partition}:config:{region}:{account}:config-rule/{resource_id}",
            "id_name": "ConfigRuleName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::ConfigRule",
            "terraform": "aws_config_config_rule",
        },
        "organization_config_rule": {
            "arn_format": "arn:{partition}:config:{region}:{account}:organization-config-rule/{resource_id}",
            "id_name": "OrganizationConfigRuleName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::OrganizationConfigRule",
            "terraform": "aws_config_organization_custom_rule",
        },
        "remediation_configuration": {
            "arn_format": "arn:{partition}:config:{region}:{account}:remediation-configuration/{resource_id}",
            "id_name": "RemediationConfigurationName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "",
            "cloudformation": "AWS::Config::RemediationConfiguration",
            "terraform": "aws_config_remediation_configuration",
        },
    },
    "cur": {
        "report_definition": {
            "arn_format": "arn:{partition}:cur:{region}:{account}:{ReportName}-{YYYYMM}-{AdditionalArtifact}-{region}-{account}",
            "id_name": "ReportName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::CUR::ReportDefinition",
            "terraform": "aws_cur_report_definition",
        }
    },
    "dataexchange": {
        "asset": {
            "arn_format": "arn:{partition}:dataexchange:{region}:{account}:asset/{resource_id}",
            "id_name": "AssetId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataExchange::Asset",
            "terraform": "aws_dataexchange_asset",
        },
        "data_set": {
            "arn_format": "arn:{partition}:dataexchange:{region}:{account}:data-sets/{resource_id}",
            "id_name": "DataSetId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataExchange::DataSet",
            "terraform": "aws_dataexchange_data_set",
        },
        "job": {
            "arn_format": "arn:{partition}:dataexchange:{region}:{account}:job/{resource_id}",
            "id_name": "JobId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataExchange::Job",
            "terraform": "aws_dataexchange_job",
        },
        "revision": {
            "arn_format": "arn:{partition}:dataexchange:{region}:{account}:revision/{resource_id}",
            "id_name": "RevisionId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataExchange::Revision",
            "terraform": "aws_dataexchange_revision",
        },
    },
    "datapipeline": {
        "pipeline": {
            "arn_format": "arn:{partition}:datapipeline:{region}:{account}:{resource_type}/{resource_id}",
            "id_name": "PipelineId",
            "id_regexp": "([a-zA-Z0-9_-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DataPipeline::Pipeline",
            "terraform": "aws_datapipeline_pipeline",
        }
    },
    "dax": {
        "cluster": {
            "arn_format": "arn:{partition}:dax:{region}:{account}:cluster:{resource_id}",
            "id_name": "ClusterName",
            "id_regexp": "([a-zA-Z0-9_.-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DAX::Cluster",
            "terraform": "aws_dax_cluster",
        }
    },
    "devicefarm": {
        "project": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:project:{resource_id}",
            "id_name": "ProjectArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Project",
            "terraform": "aws_devicefarm_project",
        },
        "device_instance": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:device-instance:{resource_id}",
            "id_name": "DeviceInstanceArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::DeviceInstance",
            "terraform": "aws_devicefarm_device_instance",
        },
        "device_pool": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:devicepool:{resource_id}",
            "id_name": "DevicePoolArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::DevicePool",
            "terraform": "aws_devicefarm_device_pool",
        },
        "run": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:run:{resource_id}",
            "id_name": "RunArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Run",
            "terraform": "aws_devicefarm_run",
        },
        "job": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:job:{resource_id}",
            "id_name": "JobArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Job",
            "terraform": "aws_devicefarm_job",
        },
        "suite": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:suite:{resource_id}",
            "id_name": "SuiteArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Suite",
            "terraform": "aws_devicefarm_suite",
        },
        "test": {
            "arn_format": "arn:{partition}:devicefarm:{region}:{account}:test:{resource_id}",
            "id_name": "TestArnSuffix",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::DeviceFarm::Test",
            "terraform": "aws_devicefarm_test",
        },
    },
    "directconnect": {
        "connection": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:dxcon:{resource_id}",
            "id_name": "ConnectionId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::Connection",
            "terraform": "aws_dx_connection",
        },
        "link_aggregation_group": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:linkaggregations:{resource_id}",
            "id_name": "LagId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::LinkAggregationGroup",
            "terraform": "aws_dx_lag",
        },
        "private_virtual_interface": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:dxvif:{resource_id}",
            "id_name": "VirtualInterfaceId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::PrivateVirtualInterface",
            "terraform": "aws_dx_private_virtual_interface",
        },
        "public_virtual_interface": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:dxvif:{resource_id}",
            "id_name": "VirtualInterfaceId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::PublicVirtualInterface",
            "terraform": "aws_dx_public_virtual_interface",
        },
        "transit_virtual_interface": {
            "arn_format": "arn:{partition}:directconnect:{region}:{account}:dxvif:{resource_id}",
            "id_name": "VirtualInterfaceId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::DirectConnect::TransitVirtualInterface",
            "terraform": "aws_dx_transit_virtual_interface",
        },
    },
    "dynamodb": {
        "table": {
            "arn_format": "arn:{partition}:dynamodb:{region}:{account}:table/{resource_id}",
            "id_name": "TableName",
            "id_regexp": "([a-zA-Z0-9_.-]+)",
            "asff_name": "AwsDynamoDbTable",
            "cloudformation": "AWS::DynamoDB::Table",
            "terraform": "aws_dynamodb_table",
        }
    },
    "ec2": {
        "customer_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:customer-gateway/{resource_id}",
            "id_name": "CustomerGatewayId",
            "id_regexp": "^cgw-[a-f0-9]{8}$",
            "asff_name": "AwsEc2CustomerGateway",
            "cloudformation": "AWS::EC2::CustomerGateway",
            "terraform": "aws_customer_gateway",
        },
        "dedicated_host": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:host/{resource_id}",
            "id_name": "DedicatedHostId",
            "id_regexp": "^h-[0-9a-f]{17}$",
            "asff_name": "AwsEc2DedicatedHost",
            "cloudformation": "AWS::EC2::Host",
            "terraform": "aws_ec2_host",
        },
        "dhcp_options": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:dhcp-options/{resource_id}",
            "id_name": "DhcpOptionsId",
            "id_regexp": "^dopt-[0-9a-fA-F]{8,17}$",
            "asff_name": "AwsEc2DhcpOptions",
            "cloudformation": "AWS::EC2::DHCPOptions",
            "terraform": "aws_dhcp_options",
        },
        "egress_only_internet_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:egress-only-internet-gateway/{resource_id}",
            "id_name": "EgressOnlyInternetGatewayId",
            "id_regexp": "^egress-only-igw-[a-f0-9]{8,17}$",
            "asff_name": "AwsEc2EgressOnlyInternetGateway",
            "cloudformation": "AWS::EC2::EgressOnlyInternetGateway",
            "terraform": "aws_egress_only_internet_gateway",
        },
        "elastic_gpu": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:elastic-gpu/{resource_id}",
            "id_name": "ElasticGpuId",
            "id_regexp": "^egp-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2ElasticGpu",
            "cloudformation": "AWS::EC2::ElasticGpu",
            "terraform": "",
        },
        "elastic_inference_accelerator": {
            "arn_format": "arn:{partition}:elastic-inference:{region}:{account}:accelerator/{resource_id}",
            "id_name": "AcceleratorId",
            "id_regexp": "^eia-[0-9a-f]{17}$",
            "asff_name": "AwsElasticInferenceAccelerator",
            "cloudformation": "AWS::ElasticInference::Accelerator",
            "terraform": "aws_eia_accelerator",
        },
        "elastic_ip": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:elastic-ip/{resource_id}",
            "id_name": "AllocationId",
            "id_regexp": "^eipalloc-[0-9a-fA-F]{8,17}$",
            "asff_name": "AwsEc2Eip",
            "cloudformation": "AWS::EC2::EIP",
            "terraform": "aws_eip",
        },
        "flow_log": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:flow-log/{resource_id}",
            "id_name": "FlowLogId",
            "id_regexp": "^fl-[0-9a-f]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::FlowLog",
            "terraform": "aws_flow_log",
        },
        "image": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:image/{resource_id}",
            "id_name": "ImageId",
            "id_regexp": "^ami-[a-f0-9]{8}$|^ami-[a-f0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::Image",
            "terraform": "aws_ami",
        },
        "instance": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:instance/{resource_id}",
            "id_name": "InstanceId",
            "id_regexp": "^i-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2Instance",
            "cloudformation": "AWS::EC2::Instance",
            "terraform": "aws_instance",
        },
        "internet_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:internet-gateway/{resource_id}",
            "id_name": "InternetGatewayId",
            "id_regexp": "^igw-[a-f0-9]{8,17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::InternetGateway",
            "terraform": "aws_internet_gateway",
        },
        "key_pair": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:key-pair/{resource_id}",
            "id_name": "KeyName",
            "id_regexp": "^[a-zA-Z0-9-_=,.@()]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::KeyPair",
            "terraform": "aws_key_pair",
        },
        "launch_template": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:launch-template/{resource_id}",
            "id_name": "LaunchTemplateId",
            "id_regexp": "^lt-[a-zA-Z0-9]{17}$",
            "asff_name": "AwsEc2LaunchTemplate",
            "cloudformation": "AWS::EC2::LaunchTemplate",
            "terraform": "aws_launch_template",
        },
        "natgateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:natgateway/{resource_id}",
            "id_name": "NatGatewayId",
            "id_regexp": "^nat-[a-f0-9]{8,}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::NatGateway",
            "terraform": "aws_nat_gateway",
        },
        "network_acl": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:network-acl/{resource_id}",
            "id_name": "NetworkAclId",
            "id_regexp": "^acl-[0-9a-fA-F]{8,17}$",
            "asff_name": "AwsEc2NetworkAcl",
            "cloudformation": "AWS::EC2::NetworkAcl",
            "terraform": "aws_network_acl",
        },
        "network_interface": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:network-interface/{resource_id}",
            "id_name": "NetworkInterfaceId",
            "id_regexp": "^eni-[0-9a-f]{8}|eni-[0-9a-f]{17}$",
            "asff_name": "AwsEc2NetworkInterface",
            "cloudformation": "AWS::EC2::NetworkInterface",
            "terraform": "aws_network_interface",
        },
        "placement_group": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:placement-group/{resource_id}",
            "id_name": "PlacementGroupName",
            "id_regexp": "^pg-[a-z0-9]{8}$",
            "asff_name": "AwsEc2PlacementGroup",
            "cloudformation": "AWS::EC2::PlacementGroup",
            "terraform": "aws_placement_group",
        },
        "reserved_instances": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:reserved-instances/{resource_id}",
            "id_name": "ReservedInstancesId",
            "id_regexp": "^i-[a-zA-Z0-9]{12}$",
            "asff_name": "AwsEc2ReservedInstances",
            "cloudformation": "AWS::EC2::ReservedInstances",
            "terraform": "aws_instance",
        },
        "route_table": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:route-table/{resource_id}",
            "id_name": "RouteTableId",
            "id_regexp": "^rtb-[a-f0-9]{8,17}$",
            "asff_name": "AwsEc2RouteTable",
            "cloudformation": "AWS::EC2::RouteTable",
            "terraform": "aws_route_table",
        },
        "security_group": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:security-group/{resource_id}",
            "id_name": "SecurityGroupId",
            "id_regexp": "^sg-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2SecurityGroup",
            "cloudformation": "AWS::EC2::SecurityGroup",
            "terraform": "aws_security_group",
        },
        "snapshot": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:snapshot/{resource_id}",
            "id_name": "SnapshotId",
            "id_regexp": "^snap-[a-f0-9]{8,17}$",
            "asff_name": "AwsEc2Snapshot",
            "cloudformation": "AWS::EC2::Snapshot",
            "terraform": "aws_ebs_snapshot",
        },
        "spot_fleet_request": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:spot-fleet-request/{resource_id}",
            "id_name": "SpotFleetRequestId",
            "id_regexp": "^sfr-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2SpotFleetRequest",
            "cloudformation": "AWS::EC2::SpotFleet",
            "terraform": "aws_spot_fleet_request",
        },
        "spot_instance_request": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:spot-instances-request/{resource_id}",
            "id_name": "SpotInstanceRequestId",
            "id_regexp": "^sir-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2SpotInstanceRequest",
            "cloudformation": "AWS::EC2::SpotInstance",
            "terraform": "aws_spot_instance_request",
        },
        "subnet": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:subnet/{resource_id}",
            "id_name": "SubnetId",
            "id_regexp": "^subnet-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2Subnet",
            "cloudformation": "AWS::EC2::Subnet",
            "terraform": "aws_subnet",
        },
        "traffic_mirror_filter": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:traffic-mirror-filter/{resource_id}",
            "id_name": "TrafficMirrorFilterId",
            "id_regexp": "^tmf-[a-f0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TrafficMirrorFilter",
            "terraform": "aws_ec2_traffic_mirror_filter",
        },
        "traffic_mirror_session": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:traffic-mirror-session/{resource_id}",
            "id_name": "TrafficMirrorSessionId",
            "id_regexp": "^tmse-[a-f0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TrafficMirrorSession",
            "terraform": "aws_ec2_traffic_mirror_session",
        },
        "traffic_mirror_target": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:traffic-mirror-target/{resource_id}",
            "id_name": "TrafficMirrorTargetId",
            "id_regexp": "^tmt-[a-f0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TrafficMirrorTarget",
            "terraform": "aws_ec2_traffic_mirror_target",
        },
        "transit_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:transit-gateway/{resource_id}",
            "id_name": "TransitGatewayId",
            "id_regexp": "^tgw-\w{8,17}$",
            "asff_name": "AwsEc2TransitGateway",
            "cloudformation": "AWS::EC2::TransitGateway",
            "terraform": "aws_ec2_transit_gateway",
        },
        "transit_gateway_attachment": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:transit-gateway-attachment/{resource_id}",
            "id_name": "TransitGatewayAttachmentId",
            "id_regexp": "^tgw-attach-[0-9a-f]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TransitGatewayAttachment",
            "terraform": "aws_ec2_transit_gateway_attachment",
        },
        "transit_gateway_multicast_domain": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:transit-gateway-multicast-domain/{resource_id}",
            "id_name": "TransitGatewayMulticastDomainId",
            "id_regexp": "^tgmd-[a-f0-9]{8,17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TransitGatewayMulticastDomain",
            "terraform": "aws_ec2_transit_gateway_multicast_domain",
        },
        "transit_gateway_route_table": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:transit-gateway-route-table/{resource_id}",
            "id_name": "TransitGatewayRouteTableId",
            "id_regexp": "^tgw-rtb-[0-9a-f]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::TransitGatewayRouteTable",
            "terraform": "aws_ec2_transit_gateway_route_table",
        },
        "volume": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:volume/{resource_id}",
            "id_name": "VolumeId",
            "id_regexp": "^vol-[a-f0-9]{8}|vol-[a-f0-9]{17}$",
            "asff_name": "AwsEc2Volume",
            "cloudformation": "AWS::EC2::Volume",
            "terraform": "aws_ebs_volume",
        },
        "vpc": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpc/{resource_id}",
            "id_name": "VpcId",
            "id_regexp": "^vpc-[0-9a-f]{8,17}$",
            "asff_name": "AwsEc2Vpc",
            "cloudformation": "AWS::EC2::VPC",
            "terraform": "aws_vpc",
        },
        "vpc_endpoint": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpc-endpoint/{resource_id}",
            "id_name": "VpcEndpointId",
            "id_regexp": "^vpce-[a-z0-9]{8,}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::VPCEndpoint",
            "terraform": "aws_vpc_endpoint",
        },
        "vpc_endpoint_service": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpc-endpoint-service/{resource_id}",
            "id_name": "VpcEndpointServiceId",
            "id_regexp": "^vpce-svc-[0-9a-f]{8,}$",
            "asff_name": "AwsEc2VpcEndpointService",
            "cloudformation": "AWS::EC2::VPCEndpointService",
            "terraform": "aws_vpc_endpoint_service",
        },
        "vpc_peering_connection": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpc-peering-connection/{resource_id}",
            "id_name": "VpcPeeringConnectionId",
            "id_regexp": "^pcx-[a-z0-9]{8,17}$",
            "asff_name": "AwsEc2VpcPeeringConnection",
            "cloudformation": "AWS::EC2::VPCPeeringConnection",
            "terraform": "aws_vpc_peering_connection",
        },
        "vpn_connection": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpn-connection/{resource_id}",
            "id_name": "VpnConnectionId",
            "id_regexp": "^vpn-[a-f0-9]{8}$",
            "asff_name": "AwsEc2VpnConnection",
            "cloudformation": "AWS::EC2::VPNConnection",
            "terraform": "aws_vpn_connection",
        },
        "vpn_gateway": {
            "arn_format": "arn:{partition}:ec2:{region}:{account}:vpn-gateway/{resource_id}",
            "id_name": "VpnGatewayId",
            "id_regexp": "^vgw-[0-9a-f]{8}$",
            "asff_name": "",
            "cloudformation": "AWS::EC2::VPNGateway",
            "terraform": "aws_vpn_gateway",
        },
    },
    "ec2-instance-connect": {
        "connect": {
            "arn_format": "arn:{partition}:ec2-instance-connect:{region}:{account}:connect/{resource_id}",
            "id_name": "InstanceId",
            "id_regexp": "([a-zA-Z0-9\\-]+)",
            "asff_name": "",
            "cloudformation": "AWS::EC2::Instance",
            "terraform": "aws_instance",
        }
    },
    "ecr": {
        "repository": {
            "arn_format": "arn:{partition}:ecr:{region}:{account}:repository/{resource_id}",
            "id_name": "RepositoryName",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "AwsEcrRepository",
            "cloudformation": "AWS::ECR::Repository",
            "terraform": "aws_ecr_repository",
        },
        "image": {
            "arn_format": "arn:{partition}:ecr:{region}:{account}:image/{resource_id}",
            "id_name": "ImageDigest",
            "id_regexp": "([a-zA-Z0-9-_]+)",
            "asff_name": "AwsEcrContainerImage",
            "cloudformation": "AWS::ECR::Image",
            "terraform": "aws_ecr_lifecycle_policy",
        },
    },
    "ecs": {
        "cluster": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsCluster",
            "cloudformation": "AWS::ECS::Cluster",
            "terraform": "aws_ecs_cluster",
        },
        "task_definition": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:task-definition/{resource_id}",
            "id_name": "TaskDefinitionFamily",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsTaskDefinition",
            "cloudformation": "AWS::ECS::TaskDefinition",
            "terraform": "aws_ecs_task_definition",
        },
        "task": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:task/{resource_id}",
            "id_name": "TaskId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsTask",
            "cloudformation": "AWS::ECS::Task",
            "terraform": "aws_ecs_task",
        },
        "service": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:service/{cluster_name}/{resource_id}",
            "id_name": "ServiceName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "parent_id_name": "ClusterName",
            "parent_id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsService",
            "cloudformation": "AWS::ECS::Service",
            "terraform": "aws_ecs_service",
        },
        "container_instance": {
            "arn_format": "arn:{partition}:ecs:{region}:{account}:container-instance/{resource_id}",
            "id_name": "ContainerInstanceId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsEcsContainer",
            "cloudformation": "AWS::ECS::ContainerInstance",
            "terraform": "aws_ecs_container_instance",
        },
    },
    "efs": {
        "file_system": {
            "arn_format": "arn:{partition}:elasticfilesystem:{region}:{account}:file-system/{resource_id}",
            "id_name": "FileSystemId",
            "id_regexp": "fs-[a-zA-Z0-9]{8}",
            "asff_name": "",
            "cloudformation": "AWS::EFS::FileSystem",
            "terraform": "aws_efs_file_system",
        },
        "access_point": {
            "arn_format": "arn:{partition}:elasticfilesystem:{region}:{account}:access-point/{resource_id}",
            "id_name": "AccessPointId",
            "id_regexp": "fsap-[a-zA-Z0-9]{8}",
            "asff_name": "AwsEfsAccessPoint",
            "cloudformation": "AWS::EFS::AccessPoint",
            "terraform": "aws_efs_access_point",
        },
    },
    "eks": {
        "cluster": {
            "arn_format": "arn:{partition}:eks:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterName",
            "id_regexp": "([a-zA-Z0-9._-]+)",
            "asff_name": "AwsEksCluster",
            "cloudformation": "AWS::EKS::Cluster",
            "terraform": "aws_eks_cluster",
        }
    },
    "elastic-inference": {
        "accelerator_type": {
            "arn_format": "arn:{partition}:elastic-inference:{region}:{account}:accelerator-type/{resource_id}",
            "id_name": "AcceleratorTypeName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElasticInference::AcceleratorType",
            "terraform": "aws_ei_accelerator_type",
        }
    },
    "elasticache": {
        "cache_cluster": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:cluster:{resource_id}",
            "id_name": "CacheClusterId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::CacheCluster",
            "terraform": "aws_elasticache_cluster",
        },
        "cache_parameter_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:parameter-group:{resource_id}",
            "id_name": "CacheParameterGroupName",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::CacheParameterGroup",
            "terraform": "aws_elasticache_parameter_group",
        },
        "cache_security_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:security-group:{resource_id}",
            "id_name": "CacheSecurityGroupName",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::SecurityGroup",
            "terraform": "aws_elasticache_security_group",
        },
        "cache_subnet_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:subnet-group:{resource_id}",
            "id_name": "CacheSubnetGroupName",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::SubnetGroup",
            "terraform": "aws_elasticache_subnet_group",
        },
        "global_replication_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:global-replication-group:{resource_id}",
            "id_name": "GlobalReplicationGroupId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::GlobalReplicationGroup",
            "terraform": "aws_elasticache_global_replication_group",
        },
        "replication_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:cluster:{resource_id}",
            "id_name": "ReplicationGroupId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::ReplicationGroup",
            "terraform": "aws_elasticache_replication_group",
        },
        "user_group": {
            "arn_format": "arn:{partition}:elasticache:{region}:{account}:user-group:{resource_id}",
            "id_name": "UserGroupId",
            "id_regexp": "([a-zA-Z0-9-]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElastiCache::UserGroup",
            "terraform": "aws_elasticache_user_group",
        },
    },
    "elasticbeanstalk": {
        "application": {
            "arn_format": "arn:{partition}:elasticbeanstalk:{region}:{account}:application/{resource_id}",
            "id_name": "ApplicationName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElasticBeanstalk::Application",
            "terraform": "aws_elastic_beanstalk_application",
        },
        "application_version": {
            "arn_format": "arn:{partition}:elasticbeanstalk:{region}:{account}:applicationversion/{resource_id}",
            "id_name": "ApplicationVersionName",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "",
            "cloudformation": "AWS::ElasticBeanstalk::ApplicationVersion",
            "terraform": "aws_elastic_beanstalk_application_version",
        },
        "environment": {
            "arn_format": "arn:{partition}:elasticbeanstalk:{region}:{account}:environment/{resource_id}",
            "id_name": "EnvironmentId",
            "id_regexp": "([a-zA-Z0-9-_.]+)",
            "asff_name": "AwsElasticBeanstalkEnvironment",
            "cloudformation": "AWS::ElasticBeanstalk::Environment",
            "terraform": "aws_elastic_beanstalk_environment",
        },
    },
    "elb": {
        "loadbalancer": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:loadbalancer/{resource_id}",
            "id_name": "LoadBalancerName",
            "id_regexp": "[\\w.-]{1,32}",
            "asff_name": "AwsElbLoadBalancer",
            "cloudformation": "AWS::ElasticLoadBalancing::LoadBalancer",
            "terraform": "aws_elb",
        },
    },
    "elbv2": {
        "loadbalancer": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:loadbalancer/{resource_id}",
            "id_name": "LoadBalancerName",
            "id_regexp": "[\\w.-]{1,32}",
            "asff_name": "AwsElbv2LoadBalancer",
            "cloudformation": "AWS::ElasticLoadBalancingV2::LoadBalancer",
            "terraform": "aws_alb",
        },
        "targetgroup": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:targetgroup/{resource_id}/{targetgroup_id}",
            "id_name": "TargetGroupID",
            "id_regexp": "[\\w.-]{1,32}",
            "asff_name": "",
            "cloudformation": "AWS::ElasticLoadBalancingV2::TargetGroup",
            "terraform": "aws_alb_target_group",
        },
        "listener": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:listener/{resource_id}/{load_balancer_id}/{listener_id}",
            "id_name": "ListenerId",
            "id_regexp": "(?<=listener\/app\/)[^\/]+",
            "asff_name": "",
            "cloudformation": "AWS::ElasticLoadBalancingV2::Listener",
            "terraform": "aws_alb_listener",
        },
        "listener_rule": {
            "arn_format": "arn:{partition}:elasticloadbalancing:{region}:{account}:listener-rule/{resource_id}",
            "id_name": "ListenerRuleId",
            "id_regexp": "[\\w.-]{1,32}",
            "asff_name": "",
            "cloudformation": "AWS::ElasticLoadBalancingV2::ListenerRule",
            "terraform": "aws_alb_listener_rule",
        },
    },
    "elasticmapreduce": {
        "cluster": {
            "arn_format": "arn:{partition}:elasticmapreduce:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterId",
            "id_regexp": "j-[0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::EMR::Cluster",
            "terraform": "aws_emr_cluster",
        },
        "security_configuration": {
            "arn_format": "arn:{partition}:elasticmapreduce:{region}:{account}:security-configuration/{resource_id}",
            "id_name": "SecurityConfigurationName",
            "id_regexp": "[a-zA-Z0-9_.\\-]+",
            "asff_name": "",
            "cloudformation": "AWS::EMR::SecurityConfiguration",
            "terraform": "aws_emr_security_configuration",
        },
        "step": {
            "arn_format": "arn:{partition}:elasticmapreduce:{region}:{account}:cluster/{resource_id}/step/{step_id}",
            "id_name": "StepId",
            "id_regexp": "s-[0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::EMR::Step",
            "terraform": "aws_emr_step",
        },
    },
    "elastictranscoder": {
        "pipeline": {
            "arn_format": "arn:{partition}:elastictranscoder:{region}:{account}:pipeline/{resource_id}",
            "id_name": "PipelineId",
            "id_regexp": "[0-9a-zA-Z-_]{1,255}",
            "asff_name": "",
            "cloudformation": "AWS::ElasticTranscoder::Pipeline",
            "terraform": "aws_elastictranscoder_pipeline",
        },
        "preset": {
            "arn_format": "arn:{partition}:elastictranscoder:{region}:{account}:preset/{resource_id}",
            "id_name": "PresetId",
            "id_regexp": "[0-9a-zA-Z-_]{1,255}",
            "asff_name": "",
            "cloudformation": "AWS::ElasticTranscoder::Preset",
            "terraform": "aws_elastictranscoder_preset",
        },
    },
    "es": {
        "domain": {
            "arn_format": "arn:{partition}:es:{region}:{account}:domain/{resource_id}",
            "id_name": "DomainName",
            "id_regexp": "[a-z0-9][a-z0-9-]{2,28}[a-z0-9]",
            "asff_name": "AwsElasticSearchDomain",
            "cloudformation": "AWS::Elasticsearch::Domain",
            "terraform": "aws_elasticsearch_domain",
        }
    },
    "events": {
        "archive": {
            "arn_format": "arn:{partition}:events:{region}:{account}:archive/{resource_id}",
            "id_name": "ArchiveName",
            "id_regexp": "[0-9a-zA-Z_.:-]+",
            "asff_name": "",
            "cloudformation": "AWS::Events::Archive",
            "terraform": "aws_cloudwatch_event_archive",
        },
        "bus": {
            "arn_format": "arn:{partition}:events:{region}:{account}:event-bus/{resource_id}",
            "id_name": "EventBusName",
            "id_regexp": "[0-9a-zA-Z_]+",
            "asff_name": "",
            "cloudformation": "AWS::Events::EventBus",
            "terraform": "aws_cloudwatch_event_bus",
        },
        "rule": {
            "arn_format": "arn:{partition}:events:{region}:{account}:rule/{resource_id}",
            "id_name": "RuleName",
            "id_regexp": "[0-9a-zA-Z_]+",
            "asff_name": "",
            "cloudformation": "AWS::Events::Rule",
            "terraform": "aws_cloudwatch_event_rule",
        },
    },
    "firehose": {
        "delivery_stream": {
            "arn_format": "arn:{partition}:firehose:{region}:{account}:deliverystream/{resource_id}",
            "id_name": "DeliveryStreamName",
            "id_regexp": "[a-zA-Z0-9_-]+",
            "asff_name": "",
            "cloudformation": "AWS::KinesisFirehose::DeliveryStream",
            "terraform": "aws_kinesis_firehose_delivery_stream",
        }
    },
    "fms": {
        "policy": {
            "arn_format": "arn:{partition}:fms:{region}:{account}:policy/{resource_id}",
            "id_name": "PolicyName",
            "id_regexp": "[\\w-]+",
            "asff_name": "",
            "cloudformation": "AWS::FMS::Policy",
            "terraform": "aws_fms_policy",
        }
    },
    "fsx": {
        "backup": {
            "arn_format": "arn:{partition}:fsx:{region}:{account}:backup/{resource_id}",
            "id_name": "BackupId",
            "id_regexp": "backup-[0-9a-f]+",
            "asff_name": "",
            "cloudformation": "AWS::FSx::Backup",
            "terraform": "aws_fsx_backup",
        },
        "file_system": {
            "arn_format": "arn:{partition}:fsx:{region}:{account}:file-system/{resource_id}",
            "id_name": "FileSystemId",
            "id_regexp": "fs-[0-9a-f]+",
            "asff_name": "",
            "cloudformation": "AWS::FSx::FileSystem",
            "terraform": "aws_fsx_lustre_file_system",
        },
    },
    "gamelift": {
        "alias": {
            "arn_format": "arn:{partition}:gamelift:{region}:{account}:alias/{resource_id}",
            "id_name": "AliasId",
            "id_regexp": "^[a-zA-Z0-9-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::GameLift::Alias",
            "terraform": "aws_gamelift_alias",
        },
        "build": {
            "arn_format": "arn:{partition}:gamelift:{region}:{account}:build/{resource_id}",
            "id_name": "BuildId",
            "id_regexp": "^build-[a-z0-9]{14}$",
            "asff_name": "",
            "cloudformation": "AWS::GameLift::Build",
            "terraform": "aws_gamelift_build",
        },
        "fleet": {
            "arn_format": "arn:{partition}:gamelift:{region}:{account}:fleet/{resource_id}",
            "id_name": "FleetId",
            "id_regexp": "^fleet-[a-z0-9]{14}$",
            "asff_name": "",
            "cloudformation": "AWS::GameLift::Fleet",
            "terraform": "aws_gamelift_fleet",
        },
    },
    "glacier": {
        "vault": {
            "arn_format": "arn:{partition}:glacier:{region}:{account}:vaults/{resource_id}",
            "id_name": "VaultName",
            "id_regexp": "^[a-zA-Z0-9][a-zA-Z0-9-]{0,254}$",
            "asff_name": "",
            "cloudformation": "AWS::Glacier::Vault",
            "terraform": "aws_glacier_vault",
        }
    },
    "globalaccelerator": {
        "accelerator": {
            "arn_format": "arn:{partition}:globalaccelerator::{account}:accelerator/{resource_id}",
            "id_name": "AcceleratorId",
            "id_regexp": "[a-z0-9]{16}",
            "asff_name": "",
            "cloudformation": "AWS::GlobalAccelerator::Accelerator",
            "terraform": "aws_globalaccelerator_accelerator",
        },
        "listener": {
            "arn_format": "arn:{partition}:globalaccelerator::{account}:listener/{resource_id}",
            "id_name": "ListenerId",
            "id_regexp": "[a-z0-9]{16}",
            "asff_name": "",
            "cloudformation": "AWS::GlobalAccelerator::Listener",
            "terraform": "aws_globalaccelerator_listener",
        },
        "endpoint_group": {
            "arn_format": "arn:{partition}:globalaccelerator::{account}:endpoint-group/{resource_id}",
            "id_name": "EndpointGroupId",
            "id_regexp": "[a-z0-9]{16}",
            "asff_name": "",
            "cloudformation": "AWS::GlobalAccelerator::EndpointGroup",
            "terraform": "aws_globalaccelerator_endpoint_group",
        },
    },
    "glue": {
        "catalog": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:catalog",
            "id_name": "None",
            "id_regexp": "None",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Catalog",
            "terraform": "aws_glue_catalog_database",
        },
        "crawler": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:crawler:{resource_name}",
            "id_name": "CrawlerName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Crawler",
            "terraform": "aws_glue_crawler",
        },
        "database": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:database/{resource_id}",
            "id_name": "DatabaseName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Database",
            "terraform": "aws_glue_catalog_database",
        },
        "dev_endpoint": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:devEndpoint/{resource_id}",
            "id_name": "DevEndpointName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::DevEndpoint",
            "terraform": "aws_glue_dev_endpoint",
        },
        "job": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:job/{resource_id}",
            "id_name": "JobName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Job",
            "terraform": "aws_glue_job",
        },
        "partition": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:table/{DatabaseName}/{TableName}/partition/{PartitionValues}",
            "id_name": "None",
            "id_regexp": "None",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Partition",
            "terraform": "aws_glue_catalog_partition",
        },
        "trigger": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:trigger/{resource_id}",
            "id_name": "TriggerName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Trigger",
            "terraform": "aws_glue_trigger",
        },
        "workflow": {
            "arn_format": "arn:{partition}:glue:{region}:{account}:workflow/{resource_id}",
            "id_name": "WorkflowName",
            "id_regexp": "[-0-9a-zA-Z]+",
            "asff_name": "",
            "cloudformation": "AWS::Glue::Workflow",
            "terraform": "aws_glue_workflow",
        },
    },
    "greengrass": {
        "group": {
            "arn_format": "arn:{partition}:greengrass:{region}:{account}:/greengrass/groups/{resource_id}",
            "id_name": "GroupId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::Greengrass::Group",
            "terraform": "aws_greengrass_group",
        }
    },
    "guardduty": {
        "detector": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}",
            "id_name": "DetectorId",
            "id_regexp": "^[0-9a-f]{8,}-[0-9a-f]{4,}-[0-9a-f]{4,}-[0-9a-f]{4,}-[0-9a-f]{12,}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::Detector",
            "terraform": "aws_guardduty_detector",
        },
        "filter": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}/filter/{subresource_id}",
            "id_name": "FilterName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::Filter",
            "terraform": "aws_guardduty_filter",
        },
        "ipset": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}/ipset/{subresource_id}",
            "id_name": "IpSetId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::IPSet",
            "terraform": "aws_guardduty_ipset",
        },
        "member": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}/member/{subresource_id}",
            "id_name": "MemberId",
            "id_regexp": "^[0-9a-zA-Z-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::Member",
            "terraform": "aws_guardduty_member",
        },
        "threatintelset": {
            "arn_format": "arn:{partition}:guardduty:{region}:{account}:detector/{resource_id}/threatintelset/{subresource_id}",
            "id_name": "ThreatIntelSetId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::GuardDuty::ThreatIntelSet",
            "terraform": "aws_guardduty_threatintelset",
        },
    },
    "health": {
        "event": {
            "arn_format": "arn:{partition}:health:{region}:{account}:event/{resource_id}",
            "id_name": "EventArn",
            "id_regexp": "arn:[^:]+:health:[^:]+:[^:]+:event\/[0-9a-f-]+",
            "asff_name": "",
            "cloudformation": "AWS::Health::Event",
            "terraform": "aws_health_event",
        },
        "health_check": {
            "arn_format": "arn:{partition}:health:{region}:{account}:healthcheck/{resource_id}",
            "id_name": "HealthCheckId",
            "id_regexp": "[0-9a-f-]{8}",
            "asff_name": "",
            "cloudformation": "AWS::Health::HealthCheck",
            "terraform": "aws_health_check",
        },
        "organization_event_detail": {
            "arn_format": "arn:{partition}:health:{region}:{account}:event-organization/{event_type_code}/{service}/{event_type_version}/{event_id}",
            "id_name": "EventArn",
            "id_regexp": "arn:[^:]+:health:[^:]+:[^:]+:event\/[0-9a-f-]+",
            "asff_name": "",
            "cloudformation": "AWS::Health::OrganizationEventDetail",
            "terraform": "aws_health_organization_event_detail",
        },
        "service": {
            "arn_format": "arn:{partition}:health:{region}:{account}:service/{resource_id}",
            "id_name": "Service",
            "id_regexp": "[a-zA-Z0-9_-]{1,64}",
            "asff_name": "",
            "cloudformation": "AWS::Health::Service",
            "terraform": "aws_health_service",
        },
    },
    "iam": {
        "access_key": {
            "arn_format": "arn:{partition}:iam::{account}:accesskey/{resource_id}",
            "id_name": "AccessKeyId",
            "id_regexp": "^[A-Z0-9]{16}$",
            "asff_name": "AwsIamAccessKey",
            "cloudformation": "AWS::IAM::AccessKey",
            "terraform": "aws_iam_access_key",
        },
        "account_alias": {
            "arn_format": "arn:{partition}:iam::{account}:alias/{resource_id}",
            "id_name": "AccountAlias",
            "id_regexp": "^[a-z0-9][a-z0-9.-]{0,62}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::AccountAlias",
            "terraform": "aws_iam_account_alias",
        },
        "group": {
            "arn_format": "arn:{partition}:iam::{account}:group/{resource_id}",
            "id_name": "GroupName",
            "id_regexp": "^[a-zA-Z0-9+=,.@_-]{1,128}$",
            "asff_name": "AwsIamGroup",
            "cloudformation": "AWS::IAM::Group",
            "terraform": "aws_iam_group",
        },
        "instance_profile": {
            "arn_format": "arn:{partition}:iam::{account}:instance-profile/{resource_id}",
            "id_name": "InstanceProfileName",
            "id_regexp": "^[a-zA-Z0-9_/+=.@-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::InstanceProfile",
            "terraform": "aws_iam_instance_profile",
        },
        "policy": {
            "arn_format": "arn:{partition}:iam::{account}:policy/{resource_id}",
            "id_name": "PolicyName",
            "id_regexp": "^[a-zA-Z0-9+=,.@-_]{1,128}$",
            "asff_name": "AwsIamPolicy",
            "cloudformation": "AWS::IAM::Policy",
            "terraform": "aws_iam_policy",
        },
        "role": {
            "arn_format": "arn:{partition}:iam::{account}:role/{resource_id}",
            "id_name": "RoleName",
            "id_regexp": "^[a-zA-Z_][a-zA-Z0-9_=@,.+-]{1,63}$",
            "asff_name": "AwsIamRole",
            "cloudformation": "AWS::IAM::Role",
            "terraform": "aws_iam_role",
        },
        "server_certificate": {
            "arn_format": "arn:{partition}:iam::{account}:server-certificate/{resource_id}",
            "id_name": "ServerCertificateName",
            "id_regexp": "^[a-zA-Z0-9_/+=.@-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::ServerCertificate",
            "terraform": "aws_iam_server_certificate",
        },
        "user": {
            "arn_format": "arn:{partition}:iam::{account}:user/{resource_id}",
            "id_name": "UserName",
            "id_regexp": "^[a-zA-Z0-9_+=,.@-]{1,128}$",
            "asff_name": "AwsIamUser",
            "cloudformation": "AWS::IAM::User",
            "terraform": "aws_iam_user",
        },
        "virtual_mfa_device": {
            "arn_format": "arn:{partition}:iam::{account}:mfa/{resource_id}",
            "id_name": "VirtualMFADeviceName",
            "id_regexp": "^[\\w+=,.@-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::VirtualMFADevice",
            "terraform": "aws_iam_virtual_mfa_device",
        },
        "group_policy": {
            "arn_format": "arn:{partition}:iam::{account}:group/{group_id}/policy/{resource_id}",
            "id_name": "PolicyName",
            "id_regexp": "^[\\w+=,.@-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::Policy",
            "terraform": "aws_iam_group_policy_attachment",
        },
        "role_policy": {
            "arn_format": "arn:{partition}:iam::{account}:role/{role_id}/policy/{resource_id}",
            "id_name": "PolicyName",
            "id_regexp": "^[\\w+=,.@-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::Policy",
            "terraform": "aws_iam_role_policy_attachment",
        },
        "user_policy": {
            "arn_format": "arn:{partition}:iam::{account}:user/{user_id}/policy/{resource_id}",
            "id_name": "PolicyName",
            "id_regexp": "^[\\w+=,.@-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::Policy",
            "terraform": "aws_iam_user_policy_attachment",
        },
    },
    "imagebuilder": {
        "component": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:component/{resource_id}",
            "id_name": "ComponentBuildVersionArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:component/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::Component",
            "terraform": "aws_imagebuilder_component",
        },
        "distribution_configuration": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:distribution-configuration/{resource_id}",
            "id_name": "DistributionConfigurationArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:distribution-configuration/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::DistributionConfiguration",
            "terraform": "aws_imagebuilder_distribution_configuration",
        },
        "image": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:image/{resource_id}",
            "id_name": "ImageBuildVersionArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:image/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::Image",
            "terraform": "aws_imagebuilder_image",
        },
        "image_pipeline": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:image-pipeline/{resource_id}",
            "id_name": "ImagePipelineArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:image-pipeline/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::ImagePipeline",
            "terraform": "aws_imagebuilder_image_pipeline",
        },
        "infrastructure_configuration": {
            "arn_format": "arn:{partition}:imagebuilder:{region}:{account}:infrastructure-configuration/{resource_id}",
            "id_name": "InfrastructureConfigurationArn",
            "id_regexp": "^arn:(aws[a-zA-Z-])?:imagebuilder:[^:]:[^:]:infrastructure-configuration/.$",
            "asff_name": "",
            "cloudformation": "AWS::ImageBuilder::InfrastructureConfiguration",
            "terraform": "aws_imagebuilder_infrastructure_configuration",
        },
    },
    "inspector": {
        "assessment_target": {
            "arn_format": "arn:{partition}:inspector:{region}:{account}:target/{resource_id}",
            "id_name": "AssessmentTargetArn",
            "id_regexp": "^arn:aws:inspector:[a-z]{2}-[a-z]+-[0-9]:[0-9]{12}:target/[a-zA-Z0-9_-]{36}$",
            "asff_name": "",
            "cloudformation": "AWS::Inspector::AssessmentTarget",
            "terraform": "aws_inspector_assessment_target",
        },
        "assessment_template": {
            "arn_format": "arn:{partition}:inspector:{region}:{account}:template/{resource_id}",
            "id_name": "AssessmentTemplateArn",
            "id_regexp": "^arn:aws:inspector:[a-z]{2}-[a-z]+-[0-9]:[0-9]{12}:template/[a-zA-Z0-9_-]{36}$",
            "asff_name": "",
            "cloudformation": "AWS::Inspector::AssessmentTemplate",
            "terraform": "aws_inspector_assessment_template",
        },
        "assessment_run": {
            "arn_format": "arn:{partition}:inspector:{region}:{account}:run/{resource_id}",
            "id_name": "AssessmentRunArn",
            "id_regexp": "^arn:aws:inspector:[a-z]{2}-[a-z]+-[0-9]:[0-9]{12}:run/[a-zA-Z0-9_-]{36}$",
            "asff_name": "",
            "cloudformation": "AWS::Inspector::AssessmentRun",
            "terraform": "aws_inspector_assessment_run",
        },
    },
    "iot": {
        "authorizer": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:authorizer/{resource_id}",
            "id_name": "AuthorizerName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Authorizer",
            "terraform": "aws_iot_authorizer",
        },
        "billing_group": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:billinggroup/{resource_id}",
            "id_name": "BillingGroupName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::BillingGroup",
            "terraform": "aws_iot_billing_group",
        },
        "certificate": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:cert/{resource_id}",
            "id_name": "CertificateId",
            "id_regexp": "^([a-f0-9]){64}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Certificate",
            "terraform": "aws_iot_certificate",
        },
        "dimension": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:dimension/{resource_id}",
            "id_name": "DimensionName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Dimension",
            "terraform": "aws_iot_dimension",
        },
        "policy": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:policy/{resource_id}",
            "id_name": "PolicyName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Policy",
            "terraform": "aws_iot_policy",
        },
        "provisioning_template": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:provisioningtemplate/{resource_id}",
            "id_name": "TemplateName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::ProvisioningTemplate",
            "terraform": "aws_iot_provisioning_template",
        },
        "rule": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:rule/{resource_id}",
            "id_name": "RuleName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::TopicRule",
            "terraform": "aws_iot_topic_rule",
        },
        "scheduled_audit": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:scheduledaudit/{resource_id}",
            "id_name": "ScheduledAuditName",
            "id_regexp": "^([a-zA-Z0-9:_-]){1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::ScheduledAudit",
            "terraform": "aws_iot_scheduled_audit",
        },
        "thing": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:thing/{resource_id}",
            "id_name": "ThingName",
            "id_regexp": "^[a-zA-Z0-9_-]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Thing",
            "terraform": "aws_iot_thing",
        },
        "thing_group": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:thinggroup/{resource_id}",
            "id_name": "ThingGroupName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::ThingGroup",
            "terraform": "aws_iot_thing_group",
        },
        "thing_type": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:thingtype/{resource_id}",
            "id_name": "ThingTypeName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::ThingType",
            "terraform": "aws_iot_thing_type",
        },
        "topic_rule_destination": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:topic-rule-destination/{resource_id}",
            "id_name": "TopicRuleDestinationName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::TopicRuleDestination",
            "terraform": "aws_iot_topic_rule_destination",
        },
        "topic_rule": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:rule/{resource_id}",
            "id_name": "RuleName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::TopicRule",
            "terraform": "aws_iot_topic_rule",
        },
        "domain_configuration": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:domainconfiguration/{resource_id}",
            "id_name": "DomainConfigurationName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::DomainConfiguration",
            "terraform": "aws_iot_domain_configuration",
        },
        "fleet_indexing_configuration": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:fleet-indexing-configuration/{resource_id}",
            "id_name": "IndexingConfigurationName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::FleetIndexingConfiguration",
            "terraform": "aws_iot_fleet_indexing_configuration",
        },
        "job": {
            "arn_format": "arn:{partition}:iot:{region}:{account}:job/{resource_id}",
            "id_name": "JobId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT::Job",
            "terraform": "aws_iot_job",
        },
    },
    "iot-device-tester": {
        "test_suite_run": {
            "arn_format": "arn:{partition}:iot-device-tester:{region}:{account}:test-suite-run:{SuiteDefinitionId}/{resource_id}",
            "id_name": "SuiteRunId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTDeviceTester::TestSuiteRun",
            "terraform": "aws_iot_device_tester_test_suite_run",
        }
    },
    "iot1click-projects": {
        "device": {
            "arn_format": "arn:{partition}:iot1click:{region}:{account}:device/{resource_id}",
            "id_name": "DeviceId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT1Click::Device",
            "terraform": "aws_iot1click_device",
        },
        "placement": {
            "arn_format": "arn:{partition}:iot1click:{region}:{account}:placement/{resource_id}",
            "id_name": "PlacementName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT1Click::Placement",
            "terraform": "aws_iot1click_placement",
        },
        "project": {
            "arn_format": "arn:{partition}:iot1click:{region}:{account}:project/{resource_id}",
            "id_name": "ProjectName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoT1Click::Project",
            "terraform": "aws_iot1click_project",
        },
    },
    "iotanalytics": {
        "channel": {
            "arn_format": "arn:{partition}:iotanalytics:{region}:{account}:channel/{resource_id}",
            "id_name": "ChannelName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoTAnalytics::Channel",
            "terraform": "aws_iot_analytics_channel",
        },
        "dataset": {
            "arn_format": "arn:{partition}:iotanalytics:{region}:{account}:dataset/{resource_id}",
            "id_name": "DatasetName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoTAnalytics::Dataset",
            "terraform": "aws_iot_analytics_dataset",
        },
        "datastore": {
            "arn_format": "arn:{partition}:iotanalytics:{region}:{account}:datastore/{resource_id}",
            "id_name": "DatastoreName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoTAnalytics::Datastore",
            "terraform": "aws_iot_analytics_datastore",
        },
        "pipeline": {
            "arn_format": "arn:{partition}:iotanalytics:{region}:{account}:pipeline/{resource_id}",
            "id_name": "PipelineName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::IoTAnalytics::Pipeline",
            "terraform": "aws_iot_analytics_pipeline",
        },
    },
    "iotevents": {
        "input": {
            "arn_format": "arn:{partition}:iotevents:{region}:{account}:input/{resource_id}",
            "id_name": "InputName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTEvents::Input",
            "terraform": "aws_iot_events_input",
        },
        "detector_model": {
            "arn_format": "arn:{partition}:iotevents:{region}:{account}:detector-model/{resource_id}",
            "id_name": "DetectorModelName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTEvents::DetectorModel",
            "terraform": "aws_iot_events_detector_model",
        },
    },
    "iotsitewise": {
        "asset_model": {
            "arn_format": "arn:{partition}:iotsitewise:{region}:{account}:asset-model/{resource_id}",
            "id_name": "AssetModelId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTSiteWise::AssetModel",
            "terraform": "aws_iotsitewise_asset_model",
        },
        "gateway": {
            "arn_format": "arn:{partition}:iotsitewise:{region}:{account}:gateway/{resource_id}",
            "id_name": "GatewayId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::IoTSiteWise::Gateway",
            "terraform": "aws_iotsitewise_gateway",
        },
    },
    "kafka": {
        "cluster": {
            "arn_format": "arn:{partition}:kafka:{region}:{account}:cluster/{resource_id}",
            "id_name": "ClusterName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MSK::Cluster",
            "terraform": "aws_msk_cluster",
        }
    },
    "kinesis": {
        "stream": {
            "arn_format": "arn:{partition}:kinesis:{region}:{account}:stream/{resource_id}",
            "id_name": "StreamName",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,128}$",
            "asff_name": "AwsKinesisStream",
            "cloudformation": "AWS::Kinesis::Stream",
            "terraform": "aws_kinesis_stream",
        },
        "firehose_delivery_stream": {
            "arn_format": "arn:{partition}:firehose:{region}:{account}:deliverystream/{resource_id}",
            "id_name": "DeliveryStreamName",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Firehose::DeliveryStream",
            "terraform": "aws_kinesis_firehose_delivery_stream",
        },
    },
    "kinesis-video-archived-media": {
        "archive": {
            "arn_format": "arn:{partition}:kinesisvideo:{region}:{account}:archive/{stream_id}/{resource_id}",
            "id_name": "ArchiveId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::KinesisVideo::Stream/Archive",
            "terraform": "aws_kinesis_video_archive",
        },
        "stream": {
            "arn_format": "arn:{partition}:kinesisvideo:{region}:{account}:stream/{stream_id}/{resource_id}",
            "id_name": "StreamARN",
            "id_regexp": "^arn:aws:kinesisvideo:[a-z0-9-]+:[0-9]+:stream/[a-zA-Z0-9_.-]{1,256}/[0-9]+/[0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::KinesisVideo::Stream",
            "terraform": "aws_kinesis_video_stream",
        },
    },
    "kinesis-video-media": {
        "stream": {
            "arn_format": "arn:{partition}:kinesisvideo:{region}:{account}:stream/{stream_id}/{resource_id}",
            "id_name": "StreamARN",
            "id_regexp": "^arn:aws:kinesisvideo:[a-z0-9-]+:[0-9]+:stream/[a-zA-Z0-9_.-]{1,256}/[0-9]+/[0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::KinesisVideo::Stream",
            "terraform": "aws_kinesis_video_stream",
        }
    },
    "kinesis-video-signaling": {
        "channel": {
            "arn_format": "arn:{partition}:kinesisvideo:{region}:{account}:channel/{channel_name}/{resource_id}",
            "id_name": "ChannelARN",
            "id_regexp": "^arn:aws:kinesisvideo:[a-z0-9-]+:[0-9]+:channel/[a-zA-Z0-9_.-]{1,256}/[0-9]+/[0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::KinesisVideo::Channel",
            "terraform": "aws_kinesis_video_channel",
        }
    },
    "kms": {
        "key": {
            "arn_format": "arn:{partition}:kms:{region}:{account}:key/{resource_id}",
            "id_name": "KeyId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "AwsKmsKey",
            "cloudformation": "AWS::KMS::Key",
            "terraform": "aws_kms_key",
        },
        "alias": {
            "arn_format": "arn:{partition}:kms:{region}:{account}:alias/{resource_id}",
            "id_name": "AliasName",
            "id_regexp": "^alias/[a-zA-Z0-9:/_-]{1,256}$",
            "asff_name": "",
            "cloudformation": "AWS::KMS::Alias",
            "terraform": "aws_kms_alias",
        },
    },
    "lakeformation": {
        "data_lake_settings": {
            "arn_format": "arn:{partition}:lakeformation:{region}:{account}:datalake/{resource_id}/settings",
            "id_name": "DataLakeId",
            "id_regexp": "^[a-zA-Z0-9-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::LakeFormation::DataLakeSettings",
            "terraform": "aws_lakeformation_data_lake_settings",
        },
        "permissions": {
            "arn_format": "arn:{partition}:lakeformation:{region}:{account}:permissions/{resource_id}",
            "id_name": "ResourceId",
            "id_regexp": "^[a-zA-Z0-9-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::LakeFormation::Permissions",
            "terraform": "aws_lakeformation_permissions",
        },
    },
    "lambda": {
        "function": {
            "arn_format": "arn:{partition}:lambda:{region}:{account}:function:{resource_id}",
            "id_name": "FunctionName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,140}$",
            "asff_name": "AwsLambdaFunction",
            "cloudformation": "AWS::Lambda::Function",
            "terraform": "aws_lambda_function",
        },
        "layer": {
            "arn_format": "arn:{partition}:lambda:{region}:{account}:layer:{resource_id}",
            "id_name": "LayerName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,140}$",
            "asff_name": "AwsLambdaLayerVersion",
            "cloudformation": "AWS::Lambda::LayerVersion",
            "terraform": "aws_lambda_layer_version",
        },
        "event_source_mapping": {
            "arn_format": "arn:{partition}:lambda:{region}:{account}:event-source-mapping:{resource_id}",
            "id_name": "UUID",
            "id_regexp": "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Lambda::EventSourceMapping",
            "terraform": "aws_lambda_event_source_mapping",
        },
        "event_invoke_config": {
            "arn_format": "arn:{partition}:lambda:{region}:{account}:event-invoke-config:{resource_id}",
            "id_name": "UUID",
            "id_regexp": "^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Lambda::EventInvokeConfig",
            "terraform": "aws_lambda_event_invoke_config",
        },
    },
    "lex": {
        "bot": {
            "arn_format": "arn:{partition}:lex:{region}:{account}:bot:{resource_id}",
            "id_name": "BotName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,50}$",
            "asff_name": "",
            "cloudformation": "AWS::Lex::Bot",
            "terraform": "aws_lex_bot",
        },
        "bot_alias": {
            "arn_format": "arn:{partition}:lex:{region}:{account}:bot:{BotName}:alias:{resource_id}",
            "id_name": "BotAlias",
            "id_regexp": "^[a-zA-Z0-9_-]{1,50}$",
            "asff_name": "",
            "cloudformation": "AWS::Lex::BotAlias",
            "terraform": "aws_lex_bot_alias",
        },
        "bot_channel": {
            "arn_format": "arn:{partition}:lex:{region}:{account}:bot-channel:{BotName}:{BotAlias}:{ChannelName}",
            "id_name": "ChannelName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,50}$",
            "asff_name": "",
            "cloudformation": "AWS::Lex::BotChannel",
            "terraform": "aws_lex_bot_channel",
        },
    },
    "license-manager": {
        "license_configuration": {
            "arn_format": "arn:{partition}:license-manager:{region}:{account}:license-configuration/{resource_id}",
            "id_name": "LicenseConfigurationId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,100}$",
            "asff_name": "",
            "cloudformation": "AWS::LicenseManager::LicenseConfiguration",
            "terraform": "aws_licensemanager_license_configuration",
        }
    },
    "lightsail": {
        "instance": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:instance/{resource_id}",
            "id_name": "InstanceName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::Instance",
            "terraform": "aws_lightsail_instance",
        },
        "key_pair": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:key-pair/{resource_id}",
            "id_name": "KeyName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::KeyPair",
            "terraform": "aws_lightsail_key_pair",
        },
        "static_ip": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:static-ip/{resource_id}",
            "id_name": "StaticIpName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::StaticIp",
            "terraform": "aws_lightsail_static_ip",
        },
        "load_balancer": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:loadbalancer/{resource_id}",
            "id_name": "LoadBalancerName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::LoadBalancer",
            "terraform": "aws_lightsail_load_balancer",
        },
        "bucket": {
            "arn_format": "arn:{partition}:lightsail:{region}:{account}:bucket/{resource_id}",
            "id_name": "BucketName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Lightsail::Bucket",
            "terraform": "aws_lightsail_bucket",
        },
    },
    "logs": {
        "log_group": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:log-group:{resource_id}",
            "id_name": "LogGroupName",
            "id_regexp": "^[a-zA-Z0-9._/-]{1,512}$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::LogGroup",
            "terraform": "aws_cloudwatch_log_group",
        },
        "log_stream": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:log-group:{LogGroupName}:log-stream:{resource_id}",
            "id_name": "LogStreamName",
            "id_regexp": "^[^:*]*$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::LogStream",
            "terraform": "aws_cloudwatch_log_stream",
        },
        "metric_filter": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:metric-filter:{resource_id}",
            "id_name": "MetricFilterName",
            "id_regexp": "^[a-zA-Z0-9._/-]{1,512}$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::MetricFilter",
            "terraform": "aws_cloudwatch_log_metric_filter",
        },
        "destination": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:destination:{resource_id}",
            "id_name": "DestinationName",
            "id_regexp": "^[a-zA-Z0-9._/-]{1,512}$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::Destination",
            "terraform": "aws_cloudwatch_log_destination",
        },
        "query_definition": {
            "arn_format": "arn:{partition}:logs:{region}:{account}:query-definition:{resource_id}",
            "id_name": "QueryDefinitionName",
            "id_regexp": "^[a-zA-Z0-9._/-]{1,512}$",
            "asff_name": "",
            "cloudformation": "AWS::Logs::QueryDefinition",
            "terraform": "aws_cloudwatch_log_query_definition",
        },
    },
    "machinelearning": {
        "batch_prediction": {
            "arn_format": "arn:{partition}:machinelearning:{region}:{account}:batchprediction/{resource_id}",
            "id_name": "BatchPredictionId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MachineLearning::BatchPrediction",
            "terraform": "aws_machine_learning_batch_prediction",
        },
        "data_source": {
            "arn_format": "arn:{partition}:machinelearning:{region}:{account}:datasource/{resource_id}",
            "id_name": "DataSourceId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MachineLearning::DataSource",
            "terraform": "aws_machine_learning_data_source",
        },
        "evaluation": {
            "arn_format": "arn:{partition}:machinelearning:{region}:{account}:evaluation/{resource_id}",
            "id_name": "EvaluationId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MachineLearning::Evaluation",
            "terraform": "aws_machine_learning_evaluation",
        },
        "ml_model": {
            "arn_format": "arn:{partition}:machinelearning:{region}:{account}:mlmodel/{resource_id}",
            "id_name": "MLModelId",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MachineLearning::MLModel",
            "terraform": "aws_machine_learning_model",
        },
    },
    "macie": {
        "classification_job": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:classification-job/{resource_id}",
            "id_name": "ClassificationJobId",
            "id_regexp": "^[a-f0-9]{32}$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::ClassificationJob",
            "terraform": "aws_macie_classification_job",
        },
        "custom_data_identifier": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:custom-data-identifier/{resource_id}",
            "id_name": "CustomDataIdentifierId",
            "id_regexp": "^[a-f0-9]{32}$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::CustomDataIdentifier",
            "terraform": "aws_macie_custom_data_identifier",
        },
        "findings_filter": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:findings-filter/{resource_id}",
            "id_name": "FindingsFilterId",
            "id_regexp": "^[a-f0-9]{32}$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::FindingsFilter",
            "terraform": "aws_macie_findings_filter",
        },
        "member_account": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:member-account/{resource_id}",
            "id_name": "MemberAccountId",
            "id_regexp": "^\\d{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::MemberAccount",
            "terraform": "aws_macie_member_account_association",
        },
        "s3_object": {
            "arn_format": "arn:{partition}:macie:{region}:{account}:s3-object/{resource_id}",
            "id_name": "S3BucketName/S3ObjectKey",
            "id_regexp": "^[^/]{1,255}/.*$",
            "asff_name": "",
            "cloudformation": "AWS::Macie::S3Object",
            "terraform": "aws_macie_s3_bucket_association",
        },
    },
    "managedblockchain": {
        "network": {
            "arn_format": "arn:{partition}:managedblockchain:{region}:{account}:network/{resource_id}",
            "id_name": "NetworkId",
            "id_regexp": "^[a-zA-Z0-9]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::ManagedBlockchain::Network",
            "terraform": "aws_managed_blockchain_network",
        },
        "node": {
            "arn_format": "arn:{partition}:managedblockchain:{region}:{account}:node/{NetworkId}/{MemberId}/{resource_id}",
            "id_name": "NodeId",
            "id_regexp": "^[a-zA-Z0-9]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::ManagedBlockchain::Node",
            "terraform": "aws_managed_blockchain_node",
        },
        "proposal": {
            "arn_format": "arn:{partition}:managedblockchain:{region}:{account}:proposal/{NetworkId}/{resource_id}",
            "id_name": "ProposalId",
            "id_regexp": "^[a-zA-Z0-9]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::ManagedBlockchain::Proposal",
            "terraform": "aws_managed_blockchain_proposal",
        },
    },
    "mediaconnect": {
        "flow": {
            "arn_format": "arn:{partition}:mediaconnect:{region}:{account}:flow/{resource_id}",
            "id_name": "FlowArn",
            "id_regexp": "^arn:aws:mediaconnect:[^:]+:[^:]+:[0-9]+:[^/]+/[^/]+$",
            "asff_name": "",
            "cloudformation": "AWS::MediaConnect::Flow",
            "terraform": "aws_media_connect_flow",
        }
    },
    "mediaconvert": {
        "queue": {
            "arn_format": "arn:{partition}:mediaconvert:{region}:{account}:queue/{resource_id}",
            "id_name": "QueueName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaConvert::Queue",
            "terraform": "aws_media_convert_queue",
        },
        "preset": {
            "arn_format": "arn:{partition}:mediaconvert:{region}:{account}:preset/{resource_id}",
            "id_name": "PresetName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaConvert::Preset",
            "terraform": "aws_media_convert_preset",
        },
        "job_template": {
            "arn_format": "arn:{partition}:mediaconvert:{region}:{account}:jobTemplate/{resource_id}",
            "id_name": "JobTemplateName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaConvert::JobTemplate",
            "terraform": "aws_media_convert_job_template",
        },
    },
    "medialive": {
        "channel": {
            "arn_format": "arn:{partition}:medialive:{region}:{account}:channel:{resource_id}",
            "id_name": "ChannelId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaLive::Channel",
            "terraform": "aws_media_live_channel",
        }
    },
    "mediapackage": {
        "channel": {
            "arn_format": "arn:{partition}:mediapackage:{region}:{account}:channel/{resource_id}",
            "id_name": "ChannelId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaPackage::Channel",
            "terraform": "aws_media_package_channel",
        },
        "origin_endpoint": {
            "arn_format": "arn:{partition}:mediapackage:{region}:{account}:origin_endpoint/{resource_id}",
            "id_name": "OriginEndpointId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaPackage::OriginEndpoint",
            "terraform": "aws_media_package_origin_endpoint",
        },
    },
    "mediastore": {
        "container": {
            "arn_format": "arn:{partition}:mediastore:{region}:{account}:container/{resource_id}",
            "id_name": "ContainerName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaStore::Container",
            "terraform": "aws_media_store_container",
        }
    },
    "mediastore-data": {
        "object": {
            "arn_format": "arn:{partition}:mediastore-data:{region}:{account}:object/{resource_id}",
            "id_name": "Path",
            "id_regexp": "^.{1,1024}$",
            "asff_name": "",
            "cloudformation": "AWS::MediaStore::Object",
            "terraform": "aws_media_store_data_object",
        }
    },
    "meteringmarketplace": {
        "product": {
            "arn_format": "arn:{partition}:meteringmarketplace:{region}:{account}:product/{resource_id}",
            "id_name": "ProductCode",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::Marketplace::Product",
            "terraform": "aws_marketplace_catalog_product",
        },
        "usage_record": {
            "arn_format": "arn:{partition}:meteringmarketplace:{region}:{account}:usage-record:{resource_id}",
            "id_name": "ProductCode",
            "id_regexp": "^[a-zA-Z0-9_.-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::Marketplace::UsageRecord",
            "terraform": "aws_marketplace_entitlement",
        },
    },
    "mgh": {
        "home_region_control": {
            "arn_format": "arn:{partition}:mgh:{region}:{account}:homeRegionControl/{resource_id}",
            "id_name": "HomeRegionControlId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::MGH::HomeRegionControl",
            "terraform": "aws_migration_hub_home_region_control",
        },
        "migration_task": {
            "arn_format": "arn:{partition}:mgh:{region}:{account}:migrationTask/{resource_id}",
            "id_name": "MigrationTaskName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,256}$",
            "asff_name": "",
            "cloudformation": "AWS::MGH::MigrationTask",
            "terraform": "aws_migration_hub_migration_task",
        },
        "progress_update_stream": {
            "arn_format": "arn:{partition}:mgh:{region}:{account}:progressUpdateStream/{resource_id}",
            "id_name": "ProgressUpdateStreamName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,256}$",
            "asff_name": "",
            "cloudformation": "AWS::MGH::ProgressUpdateStream",
            "terraform": "aws_migration_hub_progress_update_stream",
        },
    },
    "mobilehub": {
        "project": {
            "arn_format": "arn:{partition}:mobilehub:{region}:{account}:project/{resource_id}",
            "id_name": "ProjectId",
            "id_regexp": "^[a-zA-Z0-9_.:-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::MobileHub::Project",
            "terraform": "aws_mobilehub_project",
        }
    },
    "mq": {
        "broker": {
            "arn_format": "arn:{partition}:mq:{region}:{account}:broker:{resource_id}",
            "id_name": "BrokerId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,36}$",
            "asff_name": "",
            "cloudformation": "AWS::AmazonMQ::Broker",
            "terraform": "aws_mq_broker",
        },
        "configuration": {
            "arn_format": "arn:{partition}:mq:{region}:{account}:configuration:{resource_id}",
            "id_name": "ConfigurationId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,36}$",
            "asff_name": "",
            "cloudformation": "AWS::AmazonMQ::Configuration",
            "terraform": "aws_mq_configuration",
        },
    },
    "mturk": {
        "hit_type": {
            "arn_format": "arn:{partition}:mturk:{region}:{account}:hittype/{resource_id}",
            "id_name": "HITTypeId",
            "id_regexp": "^[A-Z0-9A-Z]{10,}$",
            "asff_name": "",
            "cloudformation": "AWS::MTurk::HITType",
            "terraform": "aws_mturk_hit_type",
        },
        "hit": {
            "arn_format": "arn:{partition}:mturk:{region}:{account}:hit/{resource_id}",
            "id_name": "HITId",
            "id_regexp": "^[A-Z0-9A-Z]{30,}$",
            "asff_name": "",
            "cloudformation": "AWS::MTurk::HIT",
            "terraform": "aws_mturk_hit",
        },
        "qualification_type": {
            "arn_format": "arn:{partition}:mturk:{region}:{account}:qualificationtype/{resource_id}",
            "id_name": "QualificationTypeId",
            "id_regexp": "^[A-Z0-9A-Z]{10,}$",
            "asff_name": "",
            "cloudformation": "AWS::MTurk::QualificationType",
            "terraform": "aws_mturk_qualification_type",
        },
    },
    "neptune-db": {
        "cluster": {
            "arn_format": "arn:{partition}:neptune-db:{region}:{account}:cluster:{resource_id}",
            "id_name": "ClusterResourceId",
            "id_regexp": "^neptune-[^:]*:[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Neptune::DBCluster",
            "terraform": "aws_neptune_cluster",
        }
    },
    "network-firewall": {
        "firewall_policy": {
            "arn_format": "arn:{partition}:network-firewall:{region}:{account}:policy/{resource_id}",
            "id_name": "FirewallPolicyName",
            "id_regexp": "^[a-zA-Z0-9-]{1,128}$",
            "asff_name": "AwsNetworkFirewallFirewallPolicy",
            "cloudformation": "AWS::NetworkFirewall::FirewallPolicy",
            "terraform": "aws_networkfirewall_firewall_policy",
        },
        "firewall": {
            "arn_format": "arn:{partition}:network-firewall:{region}:{account}:firewall/{resource_id}",
            "id_name": "FirewallName",
            "id_regexp": "^[a-zA-Z0-9-]{1,128}$",
            "asff_name": "AwsNetworkFirewallFirewall",
            "cloudformation": "AWS::NetworkFirewall::Firewall",
            "terraform": "aws_networkfirewall_firewall",
        },
        "rule_group": {
            "arn_format": "arn:{partition}:network-firewall:{region}:{account}:rulegroup/{resource_id}",
            "id_name": "RuleGroupName",
            "id_regexp": "^[a-zA-Z0-9-]{1,128}$",
            "asff_name": "AwsNetworkFirewallRuleGroup",
            "cloudformation": "AWS::NetworkFirewall::RuleGroup",
            "terraform": "aws_networkfirewall_rule_group",
        },
    },
    "networkmanager": {
        "global_network": {
            "arn_format": "arn:{partition}:networkmanager:{region}:{account}:global-network/{resource_id}",
            "id_name": "GlobalNetworkId",
            "id_regexp": "^[a-zA-Z0-9\\-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::NetworkManager::GlobalNetwork",
            "terraform": "aws_networkmanager_global_network",
        },
        "device": {
            "arn_format": "arn:{partition}:networkmanager:{region}:{account}:device/{resource_id}",
            "id_name": "DeviceId",
            "id_regexp": "^[a-zA-Z0-9\\-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::NetworkManager::Device",
            "terraform": "aws_networkmanager_device",
        },
        "link": {
            "arn_format": "arn:{partition}:networkmanager:{region}:{account}:link/{resource_id}",
            "id_name": "LinkId",
            "id_regexp": "^[a-zA-Z0-9\\-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::NetworkManager::Link",
            "terraform": "aws_networkmanager_link",
        },
        "site": {
            "arn_format": "arn:{partition}:networkmanager:{region}:{account}:site/{resource_id}",
            "id_name": "SiteId",
            "id_regexp": "^[a-zA-Z0-9\\-]{1,255}$",
            "asff_name": "",
            "cloudformation": "AWS::NetworkManager::Site",
            "terraform": "aws_networkmanager_site",
        },
    },
    "opensearch": {
        "domain": {
            "arn_format": "arn:{partition}:opensearch:{region}:{account}:domain/{resource_id}",
            "id_name": "DomainId",
            "id_regexp": "^[a-zA-Z0-9][a-zA-Z0-9\\-]{2,28}[a-zA-Z0-9]$",
            "asff_name": "AwsOpenSearchServiceDomain",
            "cloudformation": "AWS::OpenSearchService::Domain",
            "terraform": "aws_opensearch_service_domain",
        },
    },
    "opsworks": {
        "stack": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:stack/{resource_id}",
            "id_name": "StackId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Stack",
            "terraform": "aws_opsworks_stack",
        },
        "layer": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:layer/{resource_id}",
            "id_name": "LayerId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Layer",
            "terraform": "aws_opsworks_layer",
        },
        "app": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:app/{resource_id}",
            "id_name": "AppId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::App",
            "terraform": "aws_opsworks_app",
        },
        "instance": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:instance/{resource_id}",
            "id_name": "InstanceId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Instance",
            "terraform": "aws_opsworks_instance",
        },
        "user_profile": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:user-profile/{resource_id}",
            "id_name": "UserProfileId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::UserProfile",
            "terraform": "aws_opsworks_user_profile",
        },
        "permission": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:permission/{resource_id}",
            "id_name": "PermissionId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Permission",
            "terraform": "aws_opsworks_permission",
        },
        "deployment": {
            "arn_format": "arn:{partition}:opsworks:{region}:{account}:deployment/{resource_id}",
            "id_name": "DeploymentId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::OpsWorks::Deployment",
            "terraform": "aws_opsworks_deployment",
        },
    },
    "organizations": {
        "organization": {
            "arn_format": "arn:{partition}:organizations::{account}:organization/{resource_id}",
            "id_name": "OrganizationId",
            "id_regexp": "^o-[a-z0-9]{10,32}$",
            "asff_name": "",
            "cloudformation": "AWS::Organizations::Organization",
            "terraform": "aws_organizations_organization",
        },
        "account": {
            "arn_format": "arn:{partition}:organizations::{account}:account/{resource_id}",
            "id_name": "AccountId",
            "id_regexp": "^[0-9]{12}$",
            "asff_name": "",
            "cloudformation": "AWS::Organizations::Account",
            "terraform": "aws_organizations_account",
        },
        "organizational_unit": {
            "arn_format": "arn:{partition}:organizations::{account}:ou/{resource_id}",
            "id_name": "OrganizationalUnitId",
            "id_regexp": "^ou-[a-z0-9]{4,32}-[a-z0-9]{8,32}$",
            "asff_name": "",
            "cloudformation": "AWS::Organizations::OrganizationalUnit",
            "terraform": "aws_organizations_organizational_unit",
        },
    },
    "outposts": {
        "outpost": {
            "arn_format": "arn:{partition}:outposts:{region}:{account}:outpost/{resource_id}",
            "id_name": "OutpostId",
            "id_regexp": "^[a-zA-Z0-9_\\-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Outposts::Outpost",
            "terraform": "aws_outposts_outpost",
        }
    },
    "personalize": {
        "dataset_group": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:dataset-group/{resource_id}",
            "id_name": "DatasetGroupId",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::DatasetGroup",
            "terraform": "aws_personalize_dataset_group",
        },
        "dataset": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:dataset/{dataset_group_arn}/dataset/{resource_id}",
            "id_name": "DatasetArn",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::Dataset",
            "terraform": "aws_personalize_dataset",
        },
        "solution": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:solution/{resource_id}",
            "id_name": "SolutionArn",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::Solution",
            "terraform": "aws_personalize_solution",
        },
        "campaign": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:campaign/{resource_id}",
            "id_name": "CampaignArn",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::Campaign",
            "terraform": "aws_personalize_campaign",
        },
        "event_tracker": {
            "arn_format": "arn:{partition}:personalize:{region}:{account}:event-tracker/{resource_id}",
            "id_name": "EventTrackerArn",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Personalize::EventTracker",
            "terraform": "aws_personalize_event_tracker",
        },
    },
    "pi": {
        "dimension": {
            "arn_format": "arn:{partition}:pi:{region}:{account}:dimension:{resource_id}",
            "id_name": "DimensionName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::PI::Dimension",
            "terraform": "aws_pi_dimension",
        }
    },
    "pinpoint": {
        "app": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/{resource_id}",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::App",
            "terraform": "aws_pinpoint_app",
        },
        "adm_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/{resource_id}/channels/adm",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::ADMChannel",
            "terraform": "aws_pinpoint_adm_channel",
        },
        "apns_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/{resource_id}/channels/apns",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::APNSChannel",
            "terraform": "aws_pinpoint_apns_channel",
        },
        "apns_sandbox_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/{resource_id}/channels/apns_sandbox",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::APNSSandboxChannel",
            "terraform": "aws_pinpoint_apns_sandbox_channel",
        },
        "baidu_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/{resource_id}/channels/baidu",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::BaiduChannel",
            "terraform": "aws_pinpoint_baidu_channel",
        },
        "email_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/{resource_id}/channels/email",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::EmailChannel",
            "terraform": "aws_pinpoint_email_channel",
        },
        "gcm_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/{resource_id}/channels/gcm",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::GCMChannel",
            "terraform": "aws_pinpoint_gcm_channel",
        },
        "sms_channel": {
            "arn_format": "arn:{partition}:mobiletargeting:{region}:{account}:apps/{resource_id}/channels/sms}",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Pinpoint::SMSChannel",
            "terraform": "aws_pinpoint_sms_channel",
        },
    },
    "polly": {
        "lexicon": {
            "arn_format": "arn:{partition}:polly:{region}:{account}:lexicon/{resource_id}",
            "id_name": "LexiconName",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::Polly::Lexicon",
            "terraform": "aws_polly_lexicon",
        }
    },
    "qldb": {
        "ledger": {
            "arn_format": "arn:{partition}:qldb:{region}:{account}:ledger/{resource_id}",
            "id_name": "LedgerName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,32}$",
            "asff_name": "",
            "cloudformation": "AWS::QLDB::Ledger",
            "terraform": "aws_qldb_ledger",
        }
    },
    "quickSight": {
        "group": {
            "arn_format": "arn:{partition}:quicksight:{region}:{account}:group/{resource_id}",
            "id_name": "GroupName",
            "id_regexp": "^[a-zA-Z0-9._-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::QuickSight::Group",
            "terraform": "aws_quicksight_group",
        },
        "user": {
            "arn_format": "arn:{partition}:quicksight:{region}:{account}:user/{resource_id}",
            "id_name": "UserName",
            "id_regexp": "^[a-zA-Z0-9._-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::QuickSight::User",
            "terraform": "aws_quicksight_user",
        },
    },
    "ram": {
        "resource_share": {
            "arn_format": "arn:{partition}:ram:{region}:{account}:resource-share/{resource_id}",
            "id_name": "ResourceShareName",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::RAM::ResourceShare",
            "terraform": "aws_ram_resource_share",
        },
        "resource_share_invitation": {
            "arn_format": "arn:{partition}:ram:{region}:{account}:resource-share-invitation/{resource_id}",
            "id_name": "ResourceShareInvitationId",
            "id_regexp": "^[a-zA-Z0-9-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::RAM::ResourceShareInvitation",
            "terraform": "aws_ram_resource_share_invitation",
        },
    },
    "rds": {
        "db_instance": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:db:{resource_id}",
            "id_name": "DBInstanceIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbInstance",
            "cloudformation": "AWS::RDS::DBInstance",
            "terraform": "aws_db_instance",
        },
        "db_snapshot": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:snapshot:{resource_id}",
            "id_name": "DBSnapshotIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbSnapshot",
            "cloudformation": "AWS::RDS::DBSnapshot",
            "terraform": "aws_db_snapshot",
        },
        "db_cluster": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:cluster:{resource_id}",
            "id_name": "DBClusterIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbCluster",
            "cloudformation": "AWS::RDS::DBCluster",
            "terraform": "aws_rds_cluster",
        },
        "db_cluster_snapshot": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:cluster-snapshot:{resource_id}",
            "id_name": "DBClusterSnapshotIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbClusterSnapshot",
            "cloudformation": "AWS::RDS::DBClusterSnapshot",
            "terraform": "aws_rds_cluster_snapshot",
        },
        "option_group": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:og:{resource_id}",
            "id_name": "OptionGroupName",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::RDS::OptionGroup",
            "terraform": "aws_db_option_group",
        },
        "parameter_group": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:pg:{resource_id}",
            "id_name": "DBParameterGroupName",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::RDS::DBParameterGroup",
            "terraform": "aws_db_parameter_group",
        },
        "security_group": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:secgrp:{resource_id}",
            "id_name": "DBSecurityGroupName",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsRdsDbSecurityGroup",
            "cloudformation": "AWS::RDS::DBSecurityGroup",
            "terraform": "aws_db_security_group",
        },
        "subgroup": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:sub-group:{resource_id}",
            "id_name": "DBSubnetGroupName",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::RDS::DBSubnetGroup",
            "terraform": "aws_db_subnet_group",
        },
        "event_subscription": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:es:{resource_id}",
            "id_name": "EventSubscriptionName",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "AwsRdsEventSubscription",
            "cloudformation": "AWS::RDS::EventSubscription",
            "terraform": "aws_db_event_subscription",
        },
        "global_cluster": {
            "arn_format": "arn:{partition}:rds:{region}:{account}:global-cluster:{resource_id}",
            "id_name": "GlobalClusterIdentifier",
            "id_regexp": "^[a-zA-Z0-9-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::RDS::GlobalCluster",
            "terraform": "aws_rds_global_cluster",
        },
    },
    "rds-data": {
        "secret": {
            "arn_format": "arn:{partition}:secretsmanager:{region}:{account}:secret:{resource_id}",
            "id_name": "SecretId",
            "id_regexp": "^[-0-9a-zA-Z:_/]+$",
            "asff_name": "",
            "cloudformation": "AWS::SecretsManager::Secret",
            "terraform": "aws_secretsmanager_secret",
        }
    },
    "redshift": {
        "cluster": {
            "arn_format": "arn:{partition}:redshift:{region}:{account}:cluster:{resource_id}",
            "id_name": "ClusterName",
            "id_regexp": "^([a-z0-9][a-z0-9-]*[a-z0-9]|[a-z0-9])$",
            "asff_name": "AwsRedshiftCluster",
            "cloudformation": "AWS::Redshift::Cluster",
            "terraform": "aws_redshift_cluster",
        },
        "snapshot": {
            "arn_format": "arn:{partition}:redshift:{region}:{account}:snapshot:{resource_id}",
            "id_name": "SnapshotName",
            "id_regexp": "^([a-z0-9][a-z0-9-]*[a-z0-9]|[a-z0-9])$",
            "asff_name": "",
            "cloudformation": "AWS::Redshift::Snapshot",
            "terraform": "aws_redshift_snapshot",
        },
    },
    "rekognition": {
        "collection": {
            "arn_format": "arn:{partition}:rekognition:{region}:{account}:collection/{resource_id}",
            "id_name": "CollectionId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::Rekognition::Collection",
            "terraform": "aws_rekognition_collection",
        },
        "stream_processor": {
            "arn_format": "arn:{partition}:rekognition:{region}:{account}:stream-processor/{resource_id}",
            "id_name": "StreamProcessorName",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::Rekognition::StreamProcessor",
            "terraform": "aws_rekognition_stream_processor",
        },
    },
    "resource-groups": {
        "group": {
            "arn_format": "arn:{partition}:resource-groups:{region}:{account}:group/{resource_id}",
            "id_name": "GroupName",
            "id_regexp": "^[a-zA-Z0-9._\\-]+$",
            "asff_name": "",
            "cloudformation": "AWS::ResourceGroups::Group",
            "terraform": "aws_resourcegroups_group",
        }
    },
    "robomaker": {
        "robot_application": {
            "arn_format": "arn:{partition}:robomaker:{region}:{account}:robot-application/{resource_id}/{ApplicationVersion}",
            "id_name": "ApplicationName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,127}$",
            "asff_name": "",
            "cloudformation": "AWS::RoboMaker::RobotApplication",
            "terraform": "aws_robomaker_robot_application",
        },
        "simulation_application": {
            "arn_format": "arn:{partition}:robomaker:{region}:{account}:simulation-application/{resource_id}/{ApplicationVersion}",
            "id_name": "ApplicationName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,127}$",
            "asff_name": "",
            "cloudformation": "AWS::RoboMaker::SimulationApplication",
            "terraform": "aws_robomaker_simulation_application",
        },
        "robot": {
            "arn_format": "arn:{partition}:robomaker:{region}:{account}:robot/{resource_id}",
            "id_name": "RobotName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,127}$",
            "asff_name": "",
            "cloudformation": "AWS::RoboMaker::Robot",
            "terraform": "aws_robomaker_robot",
        },
        "simulation_job": {
            "arn_format": "arn:{partition}:robomaker:{region}:{account}:simulation-job/{resource_id}",
            "id_name": "SimulationJobArn",
            "id_regexp": "^arn:[a-zA-Z0-9-]+:robomaker:[a-z]{2}(-gov)?-[a-z]+-\\d+:[a-z0-9]{12}:simulation-job:[a-zA-Z0-9-_]{1,128}(/\\d+)?$",
            "asff_name": "",
            "cloudformation": "AWS::RoboMaker::SimulationJob",
            "terraform": "aws_robomaker_simulation_job",
        },
        "fleet": {
            "arn_format": "arn:{partition}:robomaker:{region}:{account}:fleet/{resource_id}",
            "id_name": "FleetName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,127}$",
            "asff_name": "",
            "cloudformation": "AWS::RoboMaker::Fleet",
            "terraform": "aws_robomaker_fleet",
        },
    },
    "route53": {
        "health_check": {
            "arn_format": "arn:{partition}:route53:::healthcheck/{resource_id}",
            "id_name": "HealthCheckId",
            "id_regexp": "^[a-zA-Z0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::Route53::HealthCheck",
            "terraform": "aws_route53_health_check",
        },
        "hosted_zone": {
            "arn_format": "arn:{partition}:route53:::hostedzone/{resource_id}",
            "id_name": "HostedZoneId",
            "id_regexp": "^Z[a-zA-Z0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::Route53::HostedZone",
            "terraform": "aws_route53_zone",
        },
        "vpc_association_authorization": {
            "arn_format": "arn:{partition}:route53:::vpc/{region}:{account}:authorizevpcassociation/{resource_id}/{vpc_id}",
            "id_name": "HostedZoneId",
            "id_regexp": "^vpc-[a-z0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::Route53::VPCAssociationAuthorization",
            "terraform": "aws_route53_zone_association_authorization",
        },
        "resolver_endpoint": {
            "arn_format": "arn:{partition}:route53resolver:{region}:{account}:resolver-endpoint/{resource_id}",
            "id_name": "ResolverEndpointId",
            "id_regexp": "^rslv-[a-z0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::Route53Resolver::ResolverEndpoint",
            "terraform": "aws_route53_resolver_endpoint",
        },
        "resolver_rule": {
            "arn_format": "arn:{partition}:route53resolver:{region}:{account}:resolver-rule/{resource_id}",
            "id_name": "ResolverRuleId",
            "id_regexp": "^rslvrule-[a-z0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::Route53Resolver::ResolverRule",
            "terraform": "aws_route53_resolver_rule",
        },
        "resolver_rule_association": {
            "arn_format": "arn:{partition}:route53resolver:{region}:{account}:resolver-rule-association/{resource_id}",
            "id_name": "ResolverRuleAssociationId",
            "id_regexp": "^rslvrassoc-[a-z0-9]{17}$",
            "asff_name": "",
            "cloudformation": "AWS::Route53Resolver::ResolverRuleAssociation",
            "terraform": "aws_route53_resolver_rule_association",
        },
    },
    "s3": {
        "bucket": {
            "arn_format": "arn:{partition}:s3:::{resource_id}",
            "id_name": "BucketName",
            "id_regexp": "^[a-z0-9.-]{3,63}$",
            "asff_name": "AwsS3Bucket",
            "cloudformation": "AWS::S3::Bucket",
            "terraform": "aws_s3_bucket",
        },
        "object": {
            "arn_format": "arn:{partition}:s3:::{bucket}/{resource_id}",
            "id_name": "ObjectName",
            "id_regexp": ".+",
            "asff_name": "AwsS3Object",
            "cloudformation": "AWS::S3::Object",
            "terraform": "aws_s3_bucket_object",
        },
    },
    "s3-object-lambda": {
        "access_point": {
            "arn_format": "arn:{partition}:s3-object-lambda:{region}:{account}:accesspoint/{resource_id}",
            "id_name": "AccessPointName",
            "id_regexp": "^[a-zA-Z0-9\\.\\-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::S3ObjectLambda::AccessPoint",
            "terraform": "aws_s3object_lambda_access_point",
        },
        "access_point_policy": {
            "arn_format": "arn:{partition}:s3-object-lambda:{region}:{account}:accesspoint-policy/{resource_id}",
            "id_name": "AccessPointName",
            "id_regexp": "^[a-zA-Z0-9\\.\\-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::S3ObjectLambda::AccessPointPolicy",
            "terraform": "aws_s3object_lambda_access_point_policy",
        },
        "access_point_configuration": {
            "arn_format": "arn:{partition}:s3-object-lambda:{region}:{account}:accesspoint/{resource_id}/configuration",
            "id_name": "AccessPointName",
            "id_regexp": "^[a-zA-Z0-9\\.\\-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::S3ObjectLambda::AccessPointConfiguration",
            "terraform": "aws_s3object_lambda_access_point_configuration",
        },
    },
    "sagemaker": {
        "notebook_instance": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:notebook-instance/{resource_id}",
            "id_name": "NotebookInstanceName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
            "asff_name": "AwsSageMakerNotebookInstance",
            "cloudformation": "AWS::SageMaker::NotebookInstance",
            "terraform": "aws_sagemaker_notebook_instance",
        },
        "notebook_instance_lifecycle_configuration": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:notebook-instance-lifecycle-config/{resource_id}",
            "id_name": "NotebookInstanceLifecycleConfigName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::NotebookInstanceLifecycleConfig",
            "terraform": "aws_sagemaker_notebook_instance_lifecycle_configuration",
        },
        "training_job": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:training-job/{resource_id}",
            "id_name": "TrainingJobName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::TrainingJob",
            "terraform": "aws_sagemaker_training_job",
        },
        "processing_job": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:processing-job/{resource_id}",
            "id_name": "ProcessingJobName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::ProcessingJob",
            "terraform": "aws_sagemaker_processing_job",
        },
        "transform_job": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:transform-job/{resource_id}",
            "id_name": "TransformJobName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::TransformJob",
            "terraform": "aws_sagemaker_transform_job",
        },
        "model": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:model/{resource_id}",
            "id_name": "ModelName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::Model",
            "terraform": "aws_sagemaker_model",
        },
        "endpoint_config": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:endpoint-config/{resource_id}",
            "id_name": "EndpointConfigName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::EndpointConfig",
            "terraform": "aws_sagemaker_endpoint_configuration",
        },
        "endpoint": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:endpoint/{resource_id}",
            "id_name": "EndpointName",
            "id_regexp": "^[a-zA-Z0-9](-*[a-zA-Z0-9])*$",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::Endpoint",
            "terraform": "aws_sagemaker_endpoint",
        },
        "feature_group": {
            "arn_format": "arn:{partition}:sagemaker:{region}:{account}:feature-group/{resource_id}",
            "id_name": "FeatureGroupName",
            "id_regexp": "^[a-zA-Z0-9]([a-zA-Z0-9_-]{0,62}[a-zA-Z0-9])?$",
            "asff_name": "",
            "cloudformation": "AWS::SageMaker::FeatureGroup",
            "terraform": "aws_sagemaker_feature_group",
        },
    },
    "sdb": {
        "domain": {
            "arn_format": "arn:{partition}:sdb:{region}:{account}:domain/{resource_id}",
            "id_name": "DomainName",
            "id_regexp": "^[a-zA-Z0-9_.-]{3,255}$",
            "asff_name": "",
            "cloudformation": "AWS::SDB::Domain",
            "terraform": "aws_sdb_domain",
        }
    },
    "secretsmanager": {
        "secret": {
            "arn_format": "arn:{partition}:secretsmanager:{region}:{account}:secret:{resource_id}",
            "id_name": "SecretId",
            "id_regexp": "^[a-zA-Z0-9/_+=.@-]{1,64}$",
            "asff_name": "AwsSecretsManagerSecret",
            "cloudformation": "AWS::SecretsManager::Secret",
            "terraform": "aws_secretsmanager_secret",
        }
    },
    "securityhub": {
        "hub": {
            "arn_format": "arn:{partition}:securityhub:{region}:{account}:hub/default",
            "id_name": "none",
            "id_regexp": "",
            "asff_name": "",
            "cloudformation": "AWS::SecurityHub::Hub",
            "terraform": "aws_securityhub_account",
        },
        "product_subscription": {
            "arn_format": "arn:{partition}:securityhub:{region}:{account}:subscription/{resource_id}",
            "id_name": "SubscriptionId",
            "id_regexp": "^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$",
            "asff_name": "",
            "cloudformation": "AWS::SecurityHub::ProductSubscription",
            "terraform": "aws_securityhub_product_subscription",
        },
    },
    "serverlessrepo": {
        "application": {
            "arn_format": "arn:{partition}:serverlessrepo:{region}:{account}:applications/{resource_id}",
            "id_name": "ApplicationId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::ServerlessRepo::Application",
            "terraform": "aws_serverlessapplicationrepository_application",
        }
    },
    "servicecatalog": {
        "product": {
            "arn_format": "arn:{partition}:catalog:{region}:{account}:product/{resource_id}",
            "id_name": "ProductId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::ServiceCatalog::CloudFormationProduct",
            "terraform": "aws_servicecatalog_cloudformation_product",
        },
        "portfolio": {
            "arn_format": "arn:{partition}:catalog:{region}:{account}:portfolio/{resource_id}",
            "id_name": "PortfolioId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::ServiceCatalog::CloudFormationProduct",
            "terraform": "aws_servicecatalog_portfolio",
        },
        "portfolio_share": {
            "arn_format": "arn:{partition}:catalog:{region}:{account}:share/{resource_id}",
            "id_name": "ShareId",
            "id_regexp": "^[a-f0-9]{64}$",
            "asff_name": "",
            "cloudformation": "AWS::ServiceCatalog::CloudFormationProduct",
            "terraform": "aws_servicecatalog_portfolio_share",
        },
        "cloudformation_stack_set_constraint": {
            "arn_format": "arn:{partition}:cloudformation:{region}:{account}:stack-set/{StackSetName}:constraint/{resource_id}",
            "id_name": "ConstraintId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::ServiceCatalog::CloudFormationStackSetConstraint",
            "terraform": "aws_servicecatalog_stack_set_constraint",
        },
    },
    "servicediscovery": {
        "namespace": {
            "arn_format": "arn:{partition}:servicediscovery:{region}:{account}:namespace/{resource_id}",
            "id_name": "NamespaceId",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::ServiceDiscovery::Namespace",
            "terraform": "aws_service_discovery_private_dns_namespace",
        },
        "service": {
            "arn_format": "arn:{partition}:servicediscovery:{region}:{account}:service/{resource_id}",
            "id_name": "ServiceId",
            "id_regexp": "^[a-zA-Z0-9_]+$",
            "asff_name": "",
            "cloudformation": "AWS::ServiceDiscovery::Service",
            "terraform": "aws_service_discovery_service",
        },
    },
    "ses": {
        "configuration_set": {
            "arn_format": "arn:{partition}:ses:{region}:{account}:configuration-set/{resource_id}",
            "id_name": "ConfigurationSetName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::SES::ConfigurationSet",
            "terraform": "aws_ses_configuration_set",
        }
    },
    "shield": {
        "protection": {
            "arn_format": "arn:{partition}:shield::{account}:protection/{resource_id}",
            "id_name": "ProtectionId",
            "id_regexp": "^[a-zA-Z0-9_/-]{1,36}$",
            "asff_name": "",
            "cloudformation": "AWS::Shield::Protection",
            "terraform": "aws_shield_protection",
        }
    },
    "signer": {
        "signing_profile": {
            "arn_format": "arn:{partition}:signer:{region}:{account}:signing-profiles/{resource_id}",
            "id_name": "SigningProfileName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,64}$",
            "asff_name": "",
            "cloudformation": "AWS::Signer::SigningProfile",
            "terraform": "aws_signer_signing_profile",
        }
    },
    "sms": {
        "app": {
            "arn_format": "arn:{partition}:sms:{region}:{account}:app/{resource_id}",
            "id_name": "AppId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::SMS::App",
            "terraform": "aws_sms_app",
        },
        "server": {
            "arn_format": "arn:{partition}:sms:{region}:{account}:server/{resource_id}",
            "id_name": "ServerId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::SMS::Server",
            "terraform": "aws_sms_server",
        },
        "replication_job": {
            "arn_format": "arn:{partition}:sms:{region}:{account}:replication-job/{resource_id}",
            "id_name": "ReplicationJobId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "",
            "cloudformation": "AWS::SMS::ReplicationJob",
            "terraform": "aws_sms_replication_job",
        },
    },
    "snowball": {
        "job": {
            "arn_format": "arn:{partition}:snowball:{region}:{account}:job/{resource_id}",
            "id_name": "JobId",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::Snowball::Job",
            "terraform": "aws_snowball_job",
        }
    },
    "sns": {
        "topic": {
            "arn_format": "arn:{partition}:sns:{region}:{account}:{resource_id}",
            "id_name": "TopicName",
            "id_regexp": "^[a-zA-Z0-9-_]{1,256}$",
            "asff_name": "AwsSnsTopic",
            "cloudformation": "AWS::SNS::Topic",
            "terraform": "aws_sns_topic",
        },
        "subscription": {
            "arn_format": "arn:{partition}:sns:{region}:{account}:{TopicName}:{resource_id}",
            "id_name": "SubscriptionId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,256}$",
            "asff_name": "",
            "cloudformation": "AWS::SNS::Subscription",
            "terraform": "aws_sns_topic_subscription",
        },
        "platform_application_endpoint": {
            "arn_format": "arn:{partition}:sns:{region}:{account}:app/{PlatformApplicationArn}/{resource_id}",
            "id_name": "EndpointId",
            "id_regexp": "^[a-zA-Z0-9-_]{1,256}$",
            "asff_name": "",
            "cloudformation": "AWS::SNS::Endpoint",
            "terraform": "aws_sns_platform_application_endpoint",
        },
    },
    "sqs": {
        "queue": {
            "arn_format": "arn:{partition}:sqs:{region}:{account}:{resource_id}",
            "id_name": "QueueName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,80}$",
            "asff_name": "AwsSqsQueue",
            "cloudformation": "AWS::SQS::Queue",
            "terraform": "aws_sqs_queue",
        }
    },
    "ssm": {
        "document": {
            "arn_format": "arn:{partition}:ssm:{region}:{account}:document/{resource_id}",
            "id_name": "DocumentName",
            "id_regexp": "^[a-zA-Z0-9_/+.-]{3,128}$",
            "asff_name": "",
            "cloudformation": "AWS::SSM::Document",
            "terraform": "aws_ssm_document",
        },
        "parameter": {
            "arn_format": "arn:{partition}:ssm:{region}:{account}:parameter/{resource_id}",
            "id_name": "ParameterName",
            "id_regexp": "^[a-zA-Z0-9_/+.-]{1,2048}$",
            "asff_name": "",
            "cloudformation": "AWS::SSM::Parameter",
            "terraform": "aws_ssm_parameter",
        },
        "maintenance_window": {
            "arn_format": "arn:{partition}:ssm:{region}:{account}:maintenancewindow/{resource_id}",
            "id_name": "WindowId",
            "id_regexp": "^[a-zA-Z0-9_-]{20,40}$",
            "asff_name": "",
            "cloudformation": "AWS::SSM::MaintenanceWindow",
            "terraform": "aws_ssm_maintenance_window",
        },
        "maintenance_window_task": {
            "arn_format": "arn:{partition}:ssm:{region}:{account}:maintenancewindow/{WindowId}/task/{resource_id}",
            "id_name": "WindowTaskId",
            "id_regexp": "^[a-zA-Z0-9_-]{20,40}$",
            "asff_name": "",
            "cloudformation": "AWS::SSM::MaintenanceWindowTask",
            "terraform": "aws_ssm_maintenance_window_task",
        },
        "patch_baseline": {
            "arn_format": "arn:{partition}:ssm:{region}:{account}:patchbaseline/{resource_id}",
            "id_name": "BaselineId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,128}$",
            "asff_name": "AwsSsmPatchCompliance",
            "cloudformation": "AWS::SSM::PatchBaseline",
            "terraform": "aws_ssm_patch_baseline",
        },
    },
    "sso": {
        "instance": {
            "arn_format": "arn:{partition}:sso:{region}:{account}:instance/{resource_id}",
            "id_name": "InstanceId",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::SSO::Instance",
            "terraform": "aws_sso_instance",
        },
        "permission_set": {
            "arn_format": "arn:{partition}:sso:{region}:{account}:permissionSet/{resource_id}",
            "id_name": "PermissionSetId",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::SSO::PermissionSet",
            "terraform": "aws_sso_permission_set",
        },
    },
    "sso-directory": {
        "directory": {
            "arn_format": "arn:{partition}:sso-directory:{region}:{account}:directory/{resource_id}",
            "id_name": "DirectoryId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::SSO::Directory",
            "terraform": "aws_sso_directory",
        }
    },
    "stepfunctions": {
        "state_machine": {
            "arn_format": "arn:{partition}:states:{region}:{account}:stateMachine:{resource_id}",
            "id_name": "StateMachineName",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::StepFunctions::StateMachine",
            "terraform": "aws_sfn_state_machine",
        }
    },
    "storagegateway": {
        "gateway": {
            "arn_format": "arn:{partition}:storagegateway:{region}:{account}:gateway/{resource_id}",
            "id_name": "GatewayId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::StorageGateway::Gateway",
            "terraform": "aws_storagegateway_gateway",
        },
        "share": {
            "arn_format": "arn:{partition}:storagegateway:{region}:{account}:share/{resource_id}",
            "id_name": "ShareId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::StorageGateway::NFSFileShare",
            "terraform": "aws_storagegateway_nfs_file_share",
        },
        "tape": {
            "arn_format": "arn:{partition}:storagegateway:{region}:{account}:tape/{resource_id}",
            "id_name": "TapeARN",
            "id_regexp": "^[a-zA-Z0-9-:/_\\.\\(\\)]+$",
            "asff_name": "",
            "cloudformation": "AWS::StorageGateway::Tape",
            "terraform": "aws_storagegateway_tape",
        },
        "volume": {
            "arn_format": "arn:{partition}:storagegateway:{region}:{account}:gateway/{gateway_id}/volume/{resource_id}",
            "id_name": "VolumeId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::StorageGateway::StorediSCSIVolume",
            "terraform": "aws_storagegateway_cached_iscsi_volume",
        },
    },
    "sts": {
        "assumed_role": {
            "arn_format": "arn:{partition}:sts::{account}:assumed-role/{resource_name}/{resource_id}",
            "id_name": "RoleSessionName",
            "id_regexp": "^[\\w+=,.@-]+$",
            "asff_name": "",
            "cloudformation": "AWS::STS::AssumedRole",
            "terraform": "aws_iam_role",
        },
        "federated_user": {
            "arn_format": "arn:{partition}:sts::{account}:federated-user/{resource_id}",
            "id_name": "UserName",
            "id_regexp": "^[\\w+=,.@-]+$",
            "asff_name": "",
            "cloudformation": "AWS::STS::FederatedUser",
            "terraform": "aws_iam_user",
        },
        "oidc_provider": {
            "arn_format": "arn:{partition}:iam::{account}:oidc-provider/{resource_id}",
            "id_name": "Url",
            "id_regexp": "^(https|http)://.*$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::OpenIDConnectProvider",
            "terraform": "aws_iam_openid_connect_provider",
        },
        "saml_provider": {
            "arn_format": "arn:{partition}:iam::{account}:saml-provider/{resource_id}",
            "id_name": "Name",
            "id_regexp": "^[\\w+=,.@-]+$",
            "asff_name": "",
            "cloudformation": "AWS::IAM::SAMLProvider",
            "terraform": "aws_iam_saml_provider",
        },
    },
    "swf": {
        "domain": {
            "arn_format": "arn:{partition}:swf:{region}:{account}:domain/{resource_id}",
            "id_name": "DomainName",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::SWF::Domain",
            "terraform": "aws_swf_domain",
        },
        "workflow_type": {
            "arn_format": "arn:{partition}:swf:{region}:{account}:workflowType/{DomainName}/{resource_id}",
            "id_name": "WorkflowTypeName",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::SWF::WorkflowType",
            "terraform": "aws_swf_workflow_type",
        },
        "activity_type": {
            "arn_format": "arn:{partition}:swf:{region}:{account}:activityType/{DomainName}/{resource_id}",
            "id_name": "ActivityTypeName",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::SWF::ActivityType",
            "terraform": "aws_swf_activity_type",
        },
        "workflow_execution": {
            "arn_format": "arn:{partition}:swf:{region}:{account}:workflow/{DomainName}/{WorkflowType}:{resource_id}",
            "id_name": "WorkflowExecutionId",
            "id_regexp": "^[-a-zA-Z0-9_]+(?:\\.[-a-zA-Z0-9_]+)*$",
            "asff_name": "",
            "cloudformation": "AWS::SWF::WorkflowExecution",
            "terraform": "aws_swf_workflow_execution",
        },
        "activity_execution": {
            "arn_format": "arn:{partition}:swf:{region}:{account}:activity/{DomainName}/{ActivityType}:{resource_id}",
            "id_name": "ActivityId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::SWF::ActivityTask",
            "terraform": "aws_swf_activity_task",
        },
    },
    "synthetics": {
        "canary": {
            "arn_format": "arn:{partition}:synthetics:{region}:{account}:canary:{resource_id}",
            "id_name": "CanaryName",
            "id_regexp": "^[a-zA-Z0-9_-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Synthetics::Canary",
            "terraform": "aws_synthetics_canary",
        },
        "canary_run": {
            "arn_format": "arn:{partition}:synthetics:{region}:{account}:canary:{CanaryName}:run:{resource_id}",
            "id_name": "CanaryRunId",
            "id_regexp": "^[a-zA-Z0-9_-]{1,63}$",
            "asff_name": "",
            "cloudformation": "AWS::Synthetics::CanaryRun",
            "terraform": "aws_synthetics_canary_run",
        },
    },
    "textract": {
        "document": {
            "arn_format": "arn:{partition}:textract:{region}:{account}:document/{resource_id}",
            "id_name": "DocumentId",
            "id_regexp": "^[a-f0-9]{32}$",
            "asff_name": "",
            "cloudformation": "AWS::Textract::Document",
            "terraform": "aws_textract_document",
        }
    },
    "transcribe": {
        "vocabulary": {
            "arn_format": "arn:{partition}:transcribe:{region}:{account}:vocabulary/{resource_id}",
            "id_name": "VocabularyName",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::Transcribe::Vocabulary",
            "terraform": "aws_transcribe_vocabulary",
        }
    },
    "transfer": {
        "server": {
            "arn_format": "arn:{partition}:transfer:{region}:{account}:server/{resource_id}",
            "id_name": "ServerId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::Transfer::Server",
            "terraform": "aws_transfer_server",
        },
        "user": {
            "arn_format": "arn:{partition}:transfer:{region}:{account}:user/{ServerId}/{resource_id}",
            "id_name": "UserName",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::Transfer::User",
            "terraform": "aws_transfer_user",
        },
    },
    "translate": {
        "terminology": {
            "arn_format": "arn:{partition}:translate:{region}:{account}:terminology/{resource_id}",
            "id_name": "TerminologyName",
            "id_regexp": "^[a-zA-Z0-9\\-\\_]+$",
            "asff_name": "",
            "cloudformation": "AWS::Translate::Terminology",
            "terraform": "aws_translate_terminology",
        }
    },
    "waf": {
        "ipset": {
            "arn_format": "arn:{partition}:waf:{region}:{account}:ipset/{resource_id}",
            "id_name": "IpSetId",
            "id_regexp": "^[a-zA-Z0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::WAF::IPSet",
            "terraform": "aws_waf_ipset",
        },
        "rule": {
            "arn_format": "arn:{partition}:waf:{region}:{account}:rule/{resource_id}",
            "id_name": "RuleId",
            "id_regexp": "^[a-zA-Z0-9]+$",
            "asff_name": "AwsWafRule",
            "cloudformation": "AWS::WAF::Rule",
            "terraform": "aws_waf_rule",
        },
        "rule_group": {
            "arn_format": "arn:{partition}:waf::{account}:rulegroup/{resource_name}/{resource_id}",
            "id_name": "RuleGroupId",
            "id_regexp": "^[a-zA-Z0-9]+$",
            "asff_name": "AwsWafRuleGroup",
            "cloudformation": "AWS::WAF::RuleGroup",
            "terraform": "aws_waf_rule_group",
        },
        "web_acl": {
            "arn_format": "arn:{partition}:waf:{region}:{account}:webacl/{resource_id}",
            "id_name": "WebACLId",
            "id_regexp": "^[a-zA-Z0-9]+$",
            "asff_name": "AwsWafWebAcl",
            "cloudformation": "AWS::WAF::WebACL",
            "terraform": "aws_waf_web_acl",
        },
        "global_web_acl": {
            "arn_format": "arn:{partition}:waf::{account}:global-webacl/{resource_name}/{resource_id}",
            "id_name": "WebACLId",
            "id_regexp": "^[a-zA-Z0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::WAFv2::WebACL",
            "terraform": "aws_wafv2_web_acl",
        },
        "rate_based_rule": {
            "arn_format": "arn:{partition}:waf::{account}:ratebasedrule/{resource_name}/{resource_id}",
            "id_name": "RuleId",
            "id_regexp": "^[a-zA-Z0-9]+$",
            "asff_name": "AwsWafRateBasedRule",
            "cloudformation": "AWS::WAF::RateBasedRule",
            "terraform": "aws_waf_rate_based_rule",
        },
    },
    "waf-regional": {
        "ipset": {
            "arn_format": "arn:{partition}:waf-regional:{region}:{account}:ipset/{resource_id}",
            "id_name": "IpSetId",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::WAF::IPSet",
            "terraform": "aws_waf_ipset",
        },
        "regional_rule": {
            "arn_format": "arn:{partition}:waf-regional:{region}:{account}:rule/{resource_id}",
            "id_name": "RuleId",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsWafRegionalRule",
            "cloudformation": "AWS::WAF::Rule",
            "terraform": "aws_waf_rule",
        },
        "regional_web_acl": {
            "arn_format": "arn:{partition}:waf-regional:{region}:{account}:webacl/{resource_id}",
            "id_name": "WebACLId",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsWafRegionalWebAcl",
            "cloudformation": "AWS::WAF::WebACL",
            "terraform": "aws_waf_web_acl",
        },
        "regional_rule_group": {
            "arn_format": "arn:{partition}:waf-regional:{region}:{account}:rulegroup/{RuleGroupName}/{resource_id}",
            "id_name": "RuleGroupId",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsWafRegionalRuleGroup",
            "cloudformation": "AWS::WAF::RuleGroup",
            "terraform": "aws_waf_rule_group",
        },
        "regional_rate_based_rule": {
            "arn_format": "arn:{partition}:waf-regional:{region}:{account}:rule/{resource_id}",
            "id_name": "RuleId",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsWafRegionalRateBasedRule",
            "cloudformation": "AWS::WAF::RateBasedRule",
            "terraform": "aws_waf_rate_based_rule",
        },
    },
    "wafv2": {
        "ip_set": {
            "arn_format": "arn:{partition}:wafv2:{region}:{account}:/ipset/{resource_scope}/{resource_id}",
            "id_name": "Id",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::WAFv2::IPSet",
            "terraform": "aws_wafv2_ip_set",
        },
        "rule_group": {
            "arn_format": "arn:{partition}:wafv2:{region}:{account}:/rulegroup/{resource_scope}/{resource_id}",
            "id_name": "Id",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsWafv2RuleGroup",
            "cloudformation": "AWS::WAFv2::RuleGroup",
            "terraform": "aws_wafv2_rule_group",
        },
        "web_acl": {
            "arn_format": "arn:{partition}:wafv2:{region}:{account}:/webacl/{resource_scope}/{resource_id}",
            "id_name": "Id",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "AwsWafv2WebAcl",
            "cloudformation": "AWS::WAFv2::WebACL",
            "terraform": "aws_wafv2_web_acl",
        },
    },
    "wellarchitected": {
        "workload": {
            "arn_format": "arn:{partition}:wellarchitected:{region}:{account}:workload/{resource_id}",
            "id_name": "WorkloadId",
            "id_regexp": "^[a-zA-Z0-9-]+$",
            "asff_name": "",
            "cloudformation": "AWS::WellArchitected::Workload",
            "terraform": "aws_wellarchitected_workload",
        }
    },
    "workdocs": {
        "document": {
            "arn_format": "arn:{partition}:workdocs:{region}:{account}:{FolderHierarchy}/{resource_id}",
            "id_name": "DocumentName",
            "id_regexp": "^[a-zA-Z0-9-_.()]+$",
            "asff_name": "",
            "cloudformation": "AWS::WorkDocs::Document",
            "terraform": "aws_workdocs_document",
        },
        "folder": {
            "arn_format": "arn:{partition}:workdocs:{region}:{account}:{FolderHierarchy}/{resource_id}",
            "id_name": "FolderName",
            "id_regexp": "^[a-zA-Z0-9-_.()]+$",
            "asff_name": "",
            "cloudformation": "AWS::WorkDocs::Folder",
            "terraform": "aws_workdocs_folder",
        },
        "user": {
            "arn_format": "arn:{partition}:workdocs:{region}:{account}:user/{resource_id}",
            "id_name": "UserId",
            "id_regexp": "^[a-zA-Z0-9_-]+$",
            "asff_name": "",
            "cloudformation": "AWS::WorkDocs::User",
            "terraform": "aws_workdocs_user",
        },
    },
    "worklink": {
        "fleet": {
            "arn_format": "arn:{partition}:worklink:{region}:{account}:fleet/{resource_id}",
            "id_name": "FleetArnName",
            "id_regexp": "^.+$",
            "asff_name": "",
            "cloudformation": "AWS::WorkLink::Fleet",
            "terraform": "aws_worklink_fleet",
        },
        "website_certificate_authority_association": {
            "arn_format": "arn:{partition}:worklink:{region}:{account}:website-certificate-authority-association/{resource_id}",
            "id_name": "WebsiteCertificateAuthorityAssociationId",
            "id_regexp": "^[a-zA-Z0-9]+$",
            "asff_name": "",
            "cloudformation": "AWS::WorkLink::WebsiteCertificateAuthorityAssociation",
            "terraform": "aws_worklink_website_certificate_authority_association",
        },
    },
    "workmail": {
        "organization": {
            "arn_format": "arn:{partition}:workmail:{region}:{account}:organization/{resource_id}",
            "id_name": "OrganizationId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::WorkMail::Organization",
            "terraform": "aws_workmail_organization",
        },
        "resource": {
            "arn_format": "arn:{partition}:workmail:{region}:{account}:resource/{resource_id}",
            "id_name": "ResourceId",
            "id_regexp": "^[a-zA-Z0-9-_]+$",
            "asff_name": "",
            "cloudformation": "AWS::WorkMail::Resource",
            "terraform": "aws_workmail_resource",
        },
        "user": {
            "arn_format": "arn:{partition}:workmail:{region}:{account}:user/{resource_id}",
            "id_name": "UserId",
            "id_regexp": "^[a-zA-Z0-9-_@.]+$",
            "asff_name": "",
            "cloudformation": "AWS::WorkMail::User",
            "terraform": "aws_workmail_user",
        },
    },
    "workspaces": {
        "directory": {
            "arn_format": "arn:{partition}:workspaces:{region}:{account}:directory/{resource_id}",
            "id_name": "DirectoryId",
            "id_regexp": "^[a-zA-Z0-9_-]{10,64}$",
            "asff_name": "",
            "cloudformation": "AWS::WorkSpaces::Directory",
            "terraform": "aws_workspaces_directory",
        },
        "workspace": {
            "arn_format": "arn:{partition}:workspaces:{region}:{account}:workspace/{resource_id}",
            "id_name": "WorkspaceId",
            "id_regexp": "^[a-zA-Z0-9_-]{13,68}$",
            "asff_name": "",
            "cloudformation": "AWS::WorkSpaces::Workspace",
            "terraform": "aws_workspaces_workspace",
        },
    },
}
