(function(){RB.UploadDiffModel=Backbone.Model.extend({defaults:{basedir:null,changeNumber:null,diffFile:null,diffValid:false,error:null,parentDiffFile:null,repository:null,reviewRequest:null,state:0},State:{PROMPT_FOR_DIFF:0,PROMPT_FOR_BASEDIR:1,PROPMT_FOR_CHANGE_NUMBER:2,PROCESSING_DIFF:3,UPLOADING:4,PROMPT_FOR_PARENT_DIFF:5,ERROR:6},initialize:function(){_super(this).initialize.apply(this,arguments);this.on("change:diffFile change:parentDiffFile change:basedir "+"change:changeNumber change:diffValid",this._updateState,this)},startOver:function(){this.set({basedir:null,changeNumber:null,diffFile:null,diffValid:false,error:null,parentDiffFile:null,state:this.State.PROMPT_FOR_DIFF})},handleFiles:function(files){switch(this.get("state")){case this.State.PROMPT_FOR_DIFF:this.set("diffFile",files[0]);break;case this.State.PROMPT_FOR_PARENT_DIFF:this.set("parentDiffFile",files[0]);break;default:console.assert("File received in wrong state");break}},_updateState:function(){var basedir=this.get("basedir"),changeNumber=this.get("changeNumber"),diff=this.get("diffFile"),diffValid=this.get("diffValid"),parentDiff=this.get("parentDiffFile"),repository=this.get("repository"),requiresBasedir=repository.get("requiresBasedir"),requiresChangeNumber=repository.get("requiresChangeNumber"),state=this.get("state");switch(state){case this.State.PROMPT_FOR_DIFF:if(diff){if(requiresBasedir&&!basedir){this.set("state",this.State.PROMPT_FOR_BASEDIR)}else if(requiresChangeNumber&&!changeNumber){this.set("state",this.State.PROMPT_FOR_CHANGE_NUMBER)}else{this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}}break;case this.State.PROMPT_FOR_PARENT_DIFF:if(diff&&parentDiff){this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}break;case this.State.PROMPT_FOR_BASEDIR:console.assert(diff,"cannot be in basedir prompt state without a diff");if(basedir){if(requiresChangeNumber&&!changeNumber){this.set("state",this.State.PROMPT_FOR_CHANGE_NUMBER)}else{this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}}break;case this.State.PROMPT_FOR_CHANGE_NUMBER:console.assert(diff,"cannot be in changenum prompt state without a diff");if(changeNumber){this.set("state",this.State.PROCESSING_DIFF);this._tryValidate()}break;case this.State.PROCESSING_DIFF:if(diffValid){this.set("state",this.State.UPLOADING);if(this.get("reviewRequest")===null){this._createReviewRequest()}else{this._createDiff()}}break;case this.State.UPLOADING:break;case this.State.ERROR:break}},_tryValidate:function(){var diff=this.get("diffFile"),parentDiff=this.get("parentDiffFile"),repository=this.get("repository"),uploader=new RB.ValidateDiffModel;this.set("diffValid",false);console.assert(diff);uploader.set({repository:repository.get("id"),localSitePrefix:repository.get("localSitePrefix"),basedir:this.get("basedir"),diff:diff,parentDiff:parentDiff});uploader.save({success:_.bind(this._onValidateSuccess,this),error:_.bind(this._onValidateError,this)})},_onValidateSuccess:function(){this.set("diffValid",true)},_onValidateError:function(model,xhr){var rsp=$.parseJSON(xhr.responseText),newState=this.State.ERROR,error;if(rsp!==null){switch(rsp.err.code){case RB.APIErrors.REPO_FILE_NOT_FOUND:if(this.get("repository").get("scmtoolName")==="Git"&&rsp.revision.length!==40){error=gettext("The uploaded diff uses short revisions, but Review Board requires full revisions.<br />Please generate a new diff using the <code>--full-index</code> parameter.")}else{error=interpolate(gettext('The file "%(file)s" (revision %(revision)s) was not found in the repository.'),{file:rsp.file,revision:rsp.revision},true);if(this.get("parentDiffFile")===null){newState=this.State.PROMPT_FOR_PARENT_DIFF}}break;case RB.APIErrors.DIFF_PARSE_ERROR:error=interpolate(gettext("%(error)s<br />Line %(line)s: %(reason)s"),{error:rsp.err.msg,line:rsp.linenum,reason:rsp.reason},true);break;default:error=rsp.err.msg;break}}else{error=gettext("Unknown error")}if(error){this.set({state:newState,error:error})}},_createReviewRequest:function(){var repository=this.get("repository"),reviewRequest=new RB.ReviewRequest({commitID:this.get("changeNumber"),localSitePrefix:repository.get("localSitePrefix"),repository:repository.get("id")});reviewRequest.save({success:function(){this.set("reviewRequest",reviewRequest);this._createDiff()},error:this._onValidateError},this)},_createDiff:function(){var reviewRequest=this.get("reviewRequest"),diff=reviewRequest.createDiff();diff.set({basedir:this.get("basedir"),diff:this.get("diffFile"),parentDiff:this.get("parentDiffFile")});diff.url=reviewRequest.get("links").diffs.href;diff.save({success:function(){window.location=reviewRequest.get("reviewURL")},error:this._onValidateError},this)}});RB.PostCommitModel=Backbone.Model.extend({defaults:{repository:null,branch:null}});RB.NewReviewRequest=Backbone.Model.extend({defaults:{repositories:[]}});RB.UploadDiffView=Backbone.View.extend({events:{"dragenter .dnd":"_onDragEnter","dragover .dnd":"_onDragOver","dragleave .dnd":"_onDragLeave","drop .dnd":"_onDrop","submit #basedir-form":"_onBasedirSubmit","submit #changenum-form":"_onChangenumSubmit","click .startover":"_onStartOverClicked","click #select-diff-file":"_onSelectFileClicked","click #select-parent-diff-file":"_onSelectFileClicked"},initialize:function(){this.listenTo(this.model,"change:state",this._onStateChanged);this.listenTo(this.model,"change:error",this._onErrorChanged)},render:function(){var self=this,selectDiffText,selectParentDiffText;if(this._canDragDrop()){selectDiffText=gettext('<input type="button" id="select-diff-file" value="Select"> or drag and drop a diff file to begin');selectParentDiffText=gettext('<input type="button" id="select-parent-diff-file" value="Select"> or drag and drop a parent diff file if you have one')}else{selectDiffText=gettext('<input type="button" id="select-diff-file" value="Select"> a file to begin');selectParentDiffText=gettext('<input type="button" id="select-parent-diff-file" value="Select"> a parent diff file if you have one')}this.$el.html(this.template({pendingChangeHeader:gettext("Create from a local change"),tipHeader:gettext("Tip:"),tip:gettext('Use <tt>rbt post</tt> from <a href="https://www.reviewboard.org/downloads/rbtools/">RBTools</a> to more easily create and update review requests.'),selectDiff:selectDiffText,selectParentDiff:selectParentDiffText,baseDir:gettext("What is the base directory for this diff?"),changeNum:gettext("What is the change number for this diff?"),startOver:gettext("Start Over"),ok:gettext("OK")}));this._$fileInput=$('<input type="file" />').hide().appendTo(this.$el).change(function(){self.model.handleFiles(self._$fileInput.get(0).files)});this._$diffRevisionError=this.$("#parent-diff-error-contents");this._$error=this.$("#error-indicator");this._$errorContents=this.$("#error-contents");this._$processingDiff=this.$("#processing-diff");this._$promptForBasedir=this.$("#prompt-for-basedir");this._$promptForChangeNumber=this.$("#prompt-for-change-number");this._$promptForDiff=this.$("#prompt-for-diff");this._$promptForParentDiff=this.$("#prompt-for-parent-diff");this._$uploading=this.$("#uploading-diffs");this._onStateChanged(this.model,this.model.get("state"));return this},_canDragDrop:function(){return("draggable"in this.el||"ondragstart"in this.el&&"ondrop"in this.el)&&!navigator.userAgent.match("iPhone OS")&&!navigator.userAgent.match("iPad")},_onErrorChanged:function(model,error){var errorHTML='<div class="rb-icon rb-icon-warning"></div>'+error,innerHeight,outerHeight;this._$errorContents.html(errorHTML);this._$diffRevisionError.html(errorHTML);innerHeight=this._$errorContents.height();outerHeight=this._$error.height();this._$errorContents.css({top:Math.floor((outerHeight-innerHeight)/2)+"px"})},_onStateChanged:function(model,state){this._$promptForDiff.setVisible(state===this.model.State.PROMPT_FOR_DIFF);this._$promptForParentDiff.setVisible(state===this.model.State.PROMPT_FOR_PARENT_DIFF);this._$promptForBasedir.setVisible(state===this.model.State.PROMPT_FOR_BASEDIR);this._$processingDiff.setVisible(state===this.model.State.PROCESSING_DIFF);this._$promptForChangeNumber.setVisible(state===this.model.State.PROMPT_FOR_CHANGE_NUMBER);this._$uploading.setVisible(state===this.model.State.UPLOADING);this._$error.setVisible(state===this.model.State.ERROR)},_onDragEnter:function(event){event.stopPropagation();event.preventDefault();this.$(".dnd").addClass("drag-hover");return false},_onDragOver:function(event){var dt=event.originalEvent.dataTransfer;event.stopPropagation();event.preventDefault();if(dt){dt.dropEffect="copy"}return false},_onDragLeave:function(event){var dt=event.originalEvent.dataTransfer;event.stopPropagation();event.preventDefault();this.$(".dnd").removeClass("drag-hover");if(dt){dt.dropEffect="none"}return false},_onDrop:function(event){var dt=event.originalEvent.dataTransfer,files=dt&&dt.files;event.stopPropagation();event.preventDefault();if(files){this.model.handleFiles(files)}},_onBasedirSubmit:function(){var basedir=this.$("#basedir-input").val();if(basedir){this.model.set("basedir",basedir)}return false},_onChangenumSubmit:function(){var changenum=this.$("#changenum-input").val();if(changenum){this.model.set("changeNumber",changenum)}return false},_onStartOverClicked:function(){var input=this._$fileInput.clone(true);this._$fileInput.replaceWith(input);this._$fileInput=input;this.model.startOver();return false},_onSelectFileClicked:function(){this._$fileInput.click()}});RB.BranchView=Backbone.View.extend({tagName:"option",render:function(){this.$el.text(this.model.get("name")).attr("selected",this.model.get("isDefault"));return this}});RB.BranchesView=RB.CollectionView.extend({tagName:"select",itemViewType:RB.BranchView,events:{change:"_onChange"},render:function(){_super(this).render.apply(this,arguments);this.collection.each(function(branch){if(branch.get("isDefault")){this.trigger("selected",branch)}},this);return this},_onAdded:function(branch){_super(this)._onAdded.apply(this,arguments);if(this._rendered&&branch.get("isDefault")){this.trigger("selected",branch)}},_onChange:function(){var selectedIx=this.$el.prop("selectedIndex");this.trigger("selected",this.collection.models[selectedIx])}});RB.CommitView=Backbone.View.extend({className:"commit",template:_.template(['<div class="progress">',' <span class="fa fa-spinner fa-pulse"></span>',"</div>","<% if (accessible) { %>",' <div class="summary">',"  <% if (reviewRequestURL) { %>",'   <span class="fa fa-arrow-circle-right jump-to-commit"/>',"  <% } %>","  <%- summary %>"," </div>","<% } %>",'<div class="commit-info">',' <span class="revision">','  <span class="fa fa-code-fork"></span>',"  <%- revision %>","  <% if (!accessible) { %>","   <%- RB.CommitView.strings.COMMIT_NOT_ACCESSIBLE %>","  <% } %>"," </span>"," <% if (accessible && author) { %>",'  <span class="author">','   <span class="fa fa-user"></span>',"   <%- author %>","  </span>"," <% } %>"," <% if (date) { %>",'  <span class="time">','   <span class="fa fa-clock-o"></span>','   <time class="timesince" datetime="<%- date %>"></time>',"  </span>"," <% } %>","</div>"].join("")),_dialogBodyTemplate:_.template(["<p><%- prefixText %></p>","<p><code><%- commitID %>: <%- summary %></code></p>","<p><%- suffixText %></p>"].join("")),events:{click:"_onClick"},render:function(){var commitID=this.model.get("id"),date=this.model.get("date");if(!this.model.get("accessible")){this.$el.addClass("disabled")}if(commitID.length===40){commitID=commitID.slice(0,7)}if(this.model.get("reviewRequestURL")){this.$el.addClass("has-review-request")}this.$el.html(this.template(_.defaults({revision:commitID,author:this.model.get("authorName")||gettext("<unknown>"),date:date?date.toISOString():null},this.model.attributes)));if(date){this.$(".timesince").timesince()}return this},_onClick:function(){var commitID=this.model.get("id"),dialogView;if(commitID.length>7){commitID=commitID.slice(0,7)}dialogView=new RB.DialogView({title:gettext("Create Review Request?"),body:this._dialogBodyTemplate({prefixText:gettext("You are creating a new review request from the following published commit:"),commitID:commitID,summary:this.model.get("summary"),suffixText:gettext("Are you sure you want to continue?")}),buttons:[{label:gettext("Cancel")},{label:gettext("Create Review Request"),primary:true,onClick:_.bind(this._createReviewRequest,this)}]});dialogView.show()},_createReviewRequest:function(){var url;if(this.model.get("accessible")){url=this.model.get("reviewRequestURL");if(url){window.location=url}else{this.model.trigger("create",this.model)}}},showProgress:function(){this.$(".progress").show()},cancelProgress:function(){this.$(".progress").hide()}},{strings:{COMMIT_NOT_ACCESSIBLE:gettext("(not accessible on this repository)")}});RB.CommitsView=RB.CollectionView.extend({className:"commits",itemViewType:RB.CommitView,render:function(){_super(this).render.call(this);$("#new-review-request .main").scroll(_.bind(this._onScroll,this));return this},setPending:function(commit){_.each(this.views,function(view){if(view.model===commit){view.showProgress()}else{view.cancelProgress()}})},cancelPending:function(){_.each(this.views,function(view){view.cancelProgress()})},_onScroll:function(ev){var scrollThresholdPx=50;if(ev.target.scrollTop+ev.target.offsetHeight>ev.target.scrollHeight-scrollThresholdPx){this.collection.fetchNext()}}});RB.RepositoryView=Backbone.View.extend({tagName:"li",className:"has-url item repository",template:_.template(['<div class="page-sidebar-row">','<span class="label"><%- name %></span>',"</div>"].join("")),events:{click:"_onClick"},render:function(){this.$el.html(this.template(this.model.attributes));this.lowerName=this.model.get("name").toLowerCase();return this},_onClick:function(){this.model.trigger("selected",this.model)}});RB.RepositorySelectionView=RB.CollectionView.extend({tagName:"ul",className:"repository-selector page-sidebar-items",itemViewType:RB.RepositoryView,template:_.template(['<li class="section">',' <div class="page-sidebar-row">','  <h3 class="label"><%- repositoriesLabel %></h3>'," </div>"," <ul>","  <li>",'   <div class="search-icon-wrapper">','    <span class="fa fa-search"></span>','    <input class="repository-search" ','           placeholder="<%- filterLabel %>" />',"   </div>","  </li>"," </ul>","</li>"].join("")),events:{"input .repository-search":"_onSearchChanged"},initialize:function(){_super(this).initialize.apply(this,arguments);this._selected=null;this._searchActive=false;this.listenTo(this.collection,"selected",this._onRepositorySelected)},render:function(){_super(this).render.apply(this,arguments);this.$el.prepend(this.template({repositoriesLabel:gettext("Repositories"),filterLabel:gettext("Filter")}));this._$searchIconWrapper=this.$(".search-icon-wrapper");this._$searchIcon=this._$searchIconWrapper.find(".repository-search-icon");this._$searchBox=this.$(".repository-search");this._iconOffset=this.$el.innerWidth()-this._$searchIcon.outerWidth(true);return this},unselect:function(){_.each(this.views,function(view){if(view.model===this._selected){view.$el.removeClass("active")}},this);this._selected=null;this.trigger("selected",null)},_onRepositorySelected:function(item){this._selected=item;_.each(this.views,function(view){if(view.model===item){view.$el.addClass("active")}else{view.$el.removeClass("active")}});this.trigger("selected",item)},_onSearchChanged:function(){var searchTerm=this._$searchBox.val().toLowerCase();_.each(this.views,function(view){view.$el.setVisible(view.lowerName.indexOf(searchTerm)!==-1)})}});RB.PostCommitView=Backbone.View.extend({className:"post-commit",loadErrorTemplate:_.template(['<div class="error">'," <p><%- errorLoadingText %></p>",' <p class="error-text">',"  <% _.each(errorLines, function(line) { %><%- line %><br /><% }); %>"," </p>"," <p>","  <%- temporaryFailureText %>",'  <a href="#" id="reload_<%- reloadID %>"><%- tryAgainText %></a>'," </p>","</div>"].join("")),events:{"click #reload_branches":"_loadBranches","click #reload_commits":"_loadCommits"},initialize:function(){var model=this.model,repository=model.get("repository"),branches=repository.branches;this._$error=null;this._branchesView=new RB.BranchesView({collection:branches});this._branchesView.on("selected",function(branch){model.set("branch",branch)},this);this.listenTo(model,"change:branch",this._onBranchChanged);if(!branches.loaded){this._loadBranches()}},render:function(){var $branch=$("<div/>").addClass("branches section-header");this._rendered=true;$branch.append($("<span/>").text(gettext("Create from an existing commit on:"))).append(this._branchesView.render().el).appendTo(this.$el);if(this._commitsView){this.$el.append(this._commitsView.render().el)}return this},_loadBranches:function(){var branches=this.model.get("repository").branches;this._clearLoadError();branches.fetch({success:function(){branches.loaded=true;this._branchesView.$el.show();if(this._commitsView){this._commitsView.$el.show()}},error:function(collection,xhr){this._branchesView.$el.hide();if(this._commitsView){this._commitsView.$el.hide()}this._showLoadError("branches",xhr)}},this)},_loadCommits:function(){this._clearLoadError();this._commitsCollection.fetch({success:function(){this._commitsView.$el.show()},error:function(collection,xhr){this._commitsView.$el.hide();this._showLoadError("commits",xhr)}},this)},_clearLoadError:function(){if(this._$error){this._$error.remove();this._$error=null}},_showLoadError:function(reloadID,xhr){this._clearLoadError();this._$error=$(this.loadErrorTemplate({errorLoadingText:gettext("There was an error loading information from this repository:"),temporaryFailureText:gettext("This may be a temporary failure."),tryAgainText:gettext("Try again"),errorLines:xhr.errorText.split("\n"),reloadID:reloadID})).appendTo(this.$el)},_onBranchChanged:function(model,branch){if(this._commitsView){this.stopListening(this._commitsCollection);this._commitsView.remove()}this._commitsCollection=this.model.get("repository").getCommits({branch:branch.id,start:branch.get("commit")});this.listenTo(this._commitsCollection,"create",this._onCreateReviewRequest);this._commitsView=new RB.CommitsView({collection:this._commitsCollection});if(this._rendered){this.$el.append(this._commitsView.render().el)}this._loadCommits()},_onCreateReviewRequest:function(commit){var repository=this.model.get("repository"),reviewRequest;if(this._createPending){return}this._createPending=true;this._commitsView.setPending(commit);reviewRequest=new RB.ReviewRequest({repository:repository.id,localSitePrefix:repository.get("localSitePrefix")});reviewRequest.createFromCommit({commitID:commit.id,success:function(){window.location=reviewRequest.get("reviewURL")},error:function(model,xhr){this._commitsView.setPending(null);this._createPending=false;alert(xhr.errorText)}},this)}});RB.PreCommitView=RB.UploadDiffView.extend({className:"pre-commit",template:_.template(['<div class="section-header"><%- pendingChangeHeader %></div>','<div class="tip">'," <strong><%- tipHeader %></strong>"," <%= tip %>","</div>",'<div class="input dnd" id="prompt-for-diff">'," <form>","  <%= selectDiff %>"," </form>","</div>",'<div class="input dnd" id="prompt-for-parent-diff">'," <form>",'  <div id="parent-diff-error-contents" />',"  <%= selectParentDiff %>"," </form>",' <a href="#" class="startover"><%- startOver %></a>',"</div>",'<div class="input" id="prompt-for-basedir">',' <form id="basedir-form">',"  <%- baseDir %>",'  <input id="basedir-input" />','  <input type="submit" value="<%- ok %>" />'," </form>",' <a href="#" class="startover"><%- startOver %></a>',"</div>",'<div class="input" id="prompt-for-change-number">',' <form id="changenum-form">',"  <%- changeNum %>",'  <input type="number" step="1" id="changenum-input" />','  <input type="submit" value="<%- ok %>" />'," </form>",' <a href="#" class="startover"><%- startOver %></a>',"</div>",'<div class="input" id="processing-diff">',' <div class="spinner"><span class="fa fa-spinner fa-pulse"></div>',"</div>",'<div class="input" id="uploading-diffs">',' <div><span class="fa fa-spinner fa-pulse"></div>',"</div>",'<div class="input" id="error-indicator">',' <div id="error-contents" />',' <a href="#" class="startover"><%- startOver %></a>',"</div>"].join(""))});(function(){var FilesOnlyPreCommitModel,FilesOnlyPreCommitView;FilesOnlyPreCommitModel=Backbone.Model.extend({defaults:_.defaults({repository:null})});FilesOnlyPreCommitView=Backbone.View.extend({className:"files-only",template:_.template(["<p><%- description %></p>",'<input type="submit" class="primary large" id="files-only-create"','       value="<%- buttonText %>" />'].join("")),events:{"click #files-only-create":"_onCreateClicked"},render:function(){this.$el.html(this.template({description:gettext("You won't be able to add any diffs to this review request. The review request will only be usable for reviewing graphics, screenshots and file attachments."),buttonText:gettext("Create Review Request")}));return this},_onCreateClicked:function(){var repository=this.model.get("repository"),reviewRequest=new RB.ReviewRequest({localSitePrefix:repository.get("localSitePrefix")});reviewRequest.save({success:function(){window.location=reviewRequest.get("reviewURL")},error:function(){}});return false}});RB.NewReviewRequestView=Backbone.View.extend({el:"#new-review-request",template:_.template(['<a href="#" class="show-repositories">',' <span class="fa fa-chevron-left"></span>'," <%- repositoriesLabel %>","</a>",'<div class="new-review-request-container">',' <div class="main">','  <div class="hint"><%- hint %></div>'," </div>","</div>"].join("")),events:{"click .show-repositories":"_onShowRepositoriesClicked"},initialize:function(){this._repositorySelectionView=new RB.RepositorySelectionView({collection:this.model.get("repositories")});this.listenTo(this._repositorySelectionView,"selected",this._onRepositorySelected);$(window).resize(_.bind(this._onResize,this))},render:function(){var repositories=this.model.get("repositories").models;this._rendered=true;this.$el.html(this.template({hint:gettext("Select a repository"),repositoriesLabel:gettext("Repositories")}));this._$sidebar=$("#page_sidebar");this._$content=this.$(".main");this._$hint=this.$(".hint");this._$sidebar.append(this._repositorySelectionView.el);this._repositorySelectionView.render();if(this._preCommitView){this._$hint.hide();this._$content.append(this._preCommitView.render().el)}if(this._postCommitView){this._$hint.hide();this._$content.append(this._postCommitView.render().el)}this.$el.show();this._onResize();if(repositories.length===2){repositories[1].trigger("selected",repositories[1])}return this},_onResize:function(){var $window,windowHeight,elTop,height;if(this._rendered){$window=$(window);windowHeight=$window.height();elTop=this.$el.offset().top;height=windowHeight-elTop-14;this.$el.height(height);height-=this._$content.position().top;this._$content.height(height)}},_onRepositorySelected:function(repository){if(this._preCommitView){this._preCommitView.remove();this._preCommitView=null}if(this._postCommitView){this._postCommitView.remove();this._postCommitView=null}this.model.set("repository",repository);if(repository===null){return}$(document.body).removeClass("mobile-show-page-sidebar");if(repository.get("filesOnly")){this._preCommitView=new FilesOnlyPreCommitView({model:new FilesOnlyPreCommitModel({repository:repository})})}else{this._preCommitView=new RB.PreCommitView({model:new RB.UploadDiffModel({repository:repository})});if(repository.get("supportsPostCommit")){this._postCommitView=new RB.PostCommitView({model:new RB.PostCommitModel({repository:repository})})}}if(this._rendered){this._$hint.hide();this._$content.append(this._preCommitView.render().el);if(this._postCommitView){this._$content.append(this._postCommitView.render().el)}}},_onShowRepositoriesClicked:function(){this._repositorySelectionView.unselect();$(document.body).addClass("mobile-show-page-sidebar")}})})()}).call(this);